/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.data.converter;

import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationException;
import com.vaadin.data.ValueContext;
import com.vaadin.data.converter.LocalDateTimeToDateConverter;
import com.vaadin.shared.ui.datefield.DateTimeResolution;
import com.vaadin.tests.data.converter.AbstractConverterTest;
import com.vaadin.ui.DateTimeField;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class LocalDateTimeToDateConverterTest
extends AbstractConverterTest {
    private static final LocalDateTime LOCAL_DATE = LocalDateTime.of(2017, 1, 1, 1, 1, 1);
    private static final Date DATE = LocalDateTimeToDateConverterTest.createDate();

    protected LocalDateTimeToDateConverter getConverter() {
        return new LocalDateTimeToDateConverter((ZoneId)ZoneOffset.UTC);
    }

    @Test
    public void testToModel() {
        this.assertValue(DATE, this.getConverter().convertToModel(LOCAL_DATE, new ValueContext()));
    }

    @Test
    public void testToModelFromSqlDate() {
        this.assertValue(new java.sql.Date(DATE.getTime()), this.getConverter().convertToModel(LOCAL_DATE, new ValueContext()));
    }

    @Test
    public void testToPresentation() {
        Assert.assertEquals((Object)LOCAL_DATE, (Object)this.getConverter().convertToPresentation(DATE, new ValueContext()));
    }

    @Test
    public void useWithBinder() throws ValidationException {
        Binder binder = new Binder();
        DateTimeField dateField = new DateTimeField();
        binder.forField((HasValue)dateField).withConverter((Converter)this.getConverter()).bind(BeanWithDate::getDate, BeanWithDate::setDate);
        dateField.setValue((Temporal)LOCAL_DATE);
        BeanWithDate bean = new BeanWithDate();
        binder.writeBean((Object)bean);
        Assert.assertEquals((Object)DateTimeResolution.MINUTE, (Object)dateField.getResolution());
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC));
        calendar.clear();
        calendar.set(2017, 0, 1, 1, 1, 0);
        Date date = calendar.getTime();
        Assert.assertEquals((Object)date, (Object)bean.getDate());
    }

    private static Date createDate() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC));
        calendar.clear();
        calendar.set(2017, 0, 1, 1, 1, 1);
        return calendar.getTime();
    }

    public static class BeanWithDate {
        private Date date;

        public void setDate(Date date) {
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }
    }
}

