/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.provider.hierarchical;

import com.vaadin.data.TreeData;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.HierarchicalDataProvider;
import com.vaadin.data.provider.HierarchicalQuery;
import com.vaadin.data.provider.HierarchyMapper;
import com.vaadin.data.provider.TreeDataProvider;
import com.vaadin.data.provider.hierarchical.Node;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.shared.Range;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class HierarchyMapperWithDataTest {
    private static final int ROOT_COUNT = 5;
    private static final int PARENT_COUNT = 4;
    private static final int LEAF_COUNT = 2;
    private static TreeData<Node> data = new TreeData();
    private TreeDataProvider<Node> provider;
    private HierarchyMapper<Node, SerializablePredicate<Node>> mapper;
    private static List<Node> testData;
    private static List<Node> roots;
    private int mapSize = 5;

    @BeforeClass
    public static void setupData() {
        testData = HierarchyMapperWithDataTest.generateTestData(5, 4, 2);
        roots = testData.stream().filter(item -> item.getParent() == null).collect(Collectors.toList());
        data.addItems(roots, (ValueProvider & Serializable)parent -> testData.stream().filter(item -> Objects.equals(item.getParent(), parent)).collect(Collectors.toList()));
    }

    @Before
    public void setup() {
        this.provider = new TreeDataProvider(data);
        this.mapper = new HierarchyMapper(this.provider);
        this.mapper.useActiveDataOptimization(false);
        this.mapper.setInitialized(true);
    }

    @Test
    public void expandRootNode() {
        Assert.assertEquals((String)"Map size should be equal to root node count", (long)5L, (long)this.mapper.getTreeSize());
        this.expand(testData.get(0));
        Assert.assertEquals((String)"Should be root count + once parent count", (long)9L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
    }

    @Test
    public void expandAndCollapseLastRootNode() {
        Assert.assertEquals((String)"Map size should be equal to root node count", (long)5L, (long)this.mapper.getTreeSize());
        this.expand(roots.get(roots.size() - 1));
        Assert.assertEquals((String)"Should be root count + once parent count", (long)9L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
        this.collapse(roots.get(roots.size() - 1));
        Assert.assertEquals((String)"Map size should be equal to root node count again", (long)5L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
    }

    @Test
    public void expandHiddenNode() {
        Assert.assertEquals((String)"Map size should be equal to root node count", (long)5L, (long)this.mapper.getTreeSize());
        this.expand(testData.get(1));
        Assert.assertEquals((String)"Map size should not change when expanding a hidden node", (long)5L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
        this.expand(roots.get(0));
        Assert.assertEquals((String)"Hidden node should now be expanded as well", (long)11L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
        this.collapse(roots.get(0));
        Assert.assertEquals((String)"Map size should be equal to root node count", (long)5L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
    }

    @Test
    public void expandLeafNode() {
        Assert.assertEquals((String)"Map size should be equal to root node count", (long)5L, (long)this.mapper.getTreeSize());
        this.expand(testData.get(0));
        this.expand(testData.get(1));
        Assert.assertEquals((String)"Root and parent node expanded", (long)11L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
        this.expand(testData.get(2));
        Assert.assertEquals((String)"Expanding a leaf node should have no effect", (long)11L, (long)this.mapper.getTreeSize());
        this.checkMapSize();
    }

    @Test
    public void findParentIndexOfLeaf() {
        this.expand(testData.get(0));
        Assert.assertEquals((String)"Could not find the root node of a parent", (Object)0, (Object)this.mapper.getParentIndex((Object)testData.get(1)));
        this.expand(testData.get(1));
        Assert.assertEquals((String)"Could not find the parent of a leaf", (Object)1, (Object)this.mapper.getParentIndex((Object)testData.get(2)));
    }

    @Test
    public void fetchRangeOfRows() {
        this.expand(testData.get(0));
        this.expand(testData.get(1));
        List<Node> expectedResult = testData.stream().filter(n -> roots.contains(n) || n.getParent().equals(testData.get(0)) || n.getParent().equals(testData.get(1))).collect(Collectors.toList());
        Range range = Range.between((int)3, (int)this.mapper.getTreeSize());
        this.verifyFetchIsCorrect(expectedResult, range);
        range = Range.between((int)0, (int)2);
        this.verifyFetchIsCorrect(expectedResult, range);
        range = Range.between((int)0, (int)this.mapper.getTreeSize());
        this.verifyFetchIsCorrect(expectedResult, range);
    }

    @Test
    public void fetchRangeOfRowsWithSorting() {
        this.expand(testData.get(0));
        this.expand(testData.get(1));
        ArrayList levels = new ArrayList();
        Comparator<Node> comparator = Comparator.comparing(Node::getNumber).reversed();
        levels.add(testData.stream().filter(n -> n.getParent() == null).sorted(comparator).collect(Collectors.toList()));
        levels.add(testData.stream().filter(n -> n.getParent() == testData.get(0)).sorted(comparator).collect(Collectors.toList()));
        levels.add(testData.stream().filter(n -> n.getParent() == testData.get(1)).sorted(comparator).collect(Collectors.toList()));
        List<Node> expectedResult = ((List)levels.get(0)).stream().flatMap(root -> {
            Stream nextLevel = ((List)levels.get(1)).stream().filter(n -> n.getParent() == root).flatMap(node -> Stream.concat(Stream.of(node), ((List)levels.get(2)).stream().filter(n -> n.getParent() == node)));
            return Stream.concat(Stream.of(root), nextLevel);
        }).collect(Collectors.toList());
        this.mapper.setInMemorySorting(comparator::compare);
        Range range = Range.between((int)8, (int)this.mapper.getTreeSize());
        this.verifyFetchIsCorrect(expectedResult, range);
        range = Range.between((int)0, (int)5);
        this.verifyFetchIsCorrect(expectedResult, range);
        range = Range.between((int)0, (int)this.mapper.getTreeSize());
        this.verifyFetchIsCorrect(expectedResult, range);
    }

    @Test
    public void fetchWithFilter() {
        this.expand(testData.get(0));
        Node expandedNode = testData.get(4);
        this.expand(expandedNode);
        SerializablePredicate & Serializable filter = (SerializablePredicate & Serializable)n -> n.getNumber() % 2 == 0;
        List<Node> expectedResult = IntStream.of(0, 1, 4, 6, 7, 10, 13, 26, 39, 52).mapToObj(testData::get).collect(Collectors.toList());
        this.mapper.setFilter((Object)filter);
        Range range = Range.between((int)0, (int)this.mapper.getTreeSize());
        this.verifyFetchIsCorrect(expectedResult, range);
    }

    @Test
    public void fetchItemsWithNodeAndRangeStreamsGetClosed() {
        final AtomicInteger callCount = new AtomicInteger();
        final AtomicInteger closeCount = new AtomicInteger();
        final AtomicInteger mapperStreamCallCount = new AtomicInteger();
        final AtomicInteger mapperStreamCloseCount = new AtomicInteger();
        this.mapper = new HierarchyMapper<Node, SerializablePredicate<Node>>((HierarchicalDataProvider)new TreeDataProvider<Node>(data){

            public Stream<Node> fetchChildren(HierarchicalQuery<Node, SerializablePredicate<Node>> query) {
                callCount.incrementAndGet();
                return (Stream)super.fetchChildren(query).onClose(() -> closeCount.incrementAndGet());
            }
        }){

            public Stream<Node> fetchItems(Node parent, Range range) {
                mapperStreamCallCount.incrementAndGet();
                return (Stream)super.fetchItems((Object)parent, range).onClose(() -> mapperStreamCloseCount.incrementAndGet());
            }
        };
        Node rootNode = testData.get(0);
        this.expand(rootNode);
        Assert.assertEquals((String)"TreeDataProvider.fetchChildren got called earlier than expected", (long)0L, (long)callCount.get());
        Assert.assertEquals((String)"HierarchyMapper.fetchItems got called earlier than expected", (long)0L, (long)mapperStreamCallCount.get());
        Stream stream = this.mapper.fetchItems((Object)rootNode, Range.between((int)0, (int)10));
        Assert.assertEquals((String)"Unexpected  TreeDataProvider.fetchChildren call count", (long)2L, (long)callCount.get());
        Assert.assertEquals((String)"All TreeDataProvider.fetchChildren streams didn't get closed", (long)callCount.get(), (long)closeCount.get());
        Assert.assertEquals((String)"Unexpected  HierarchyMapper.fetchItems call count", (long)1L, (long)mapperStreamCallCount.get());
        Assert.assertEquals((String)"HierarchyMapper.fetchItems stream got closed even without recommended handling", (long)0L, (long)mapperStreamCloseCount.get());
        stream.count();
        Assert.assertEquals((String)"HierarchyMapper.fetchItems stream got closed after terminal operation even without recommended handling", (long)0L, (long)mapperStreamCloseCount.get());
        stream.close();
        Assert.assertEquals((String)"All HierarchyMapper.fetchItems streams didn't get closed as expected even after separate call", (long)mapperStreamCallCount.get(), (long)mapperStreamCloseCount.get());
        try (Stream newStream = this.mapper.fetchItems((Object)rootNode, Range.between((int)0, (int)10));){
            newStream.count();
        }
        Assert.assertEquals((String)"All HierarchyMapper.fetchItems streams didn't get closed as expected despite the recommended handling", (long)mapperStreamCallCount.get(), (long)mapperStreamCloseCount.get());
    }

    @Test
    public void fetchItemsWithRangeStreamsGetClosed() {
        final AtomicInteger callCount = new AtomicInteger();
        final AtomicInteger closeCount = new AtomicInteger();
        final AtomicInteger mapperStreamCallCount = new AtomicInteger();
        final AtomicInteger mapperStreamCloseCount = new AtomicInteger();
        this.mapper = new HierarchyMapper<Node, SerializablePredicate<Node>>((HierarchicalDataProvider)new TreeDataProvider<Node>(data){

            public Stream<Node> fetchChildren(HierarchicalQuery<Node, SerializablePredicate<Node>> query) {
                callCount.incrementAndGet();
                return (Stream)super.fetchChildren(query).onClose(() -> closeCount.incrementAndGet());
            }
        }){

            public Stream<Node> fetchItems(Range range) {
                mapperStreamCallCount.incrementAndGet();
                return (Stream)super.fetchItems(range).onClose(() -> mapperStreamCloseCount.incrementAndGet());
            }
        };
        this.expand(testData.get(0));
        Assert.assertEquals((String)"TreeDataProvider.fetchChildren got called earlier than expected", (long)0L, (long)callCount.get());
        Assert.assertEquals((String)"HierarchyMapper.fetchItems got called earlier than expected", (long)0L, (long)mapperStreamCallCount.get());
        Stream stream = this.mapper.fetchItems(Range.between((int)0, (int)10));
        Assert.assertEquals((String)"Unexpected  TreeDataProvider.fetchChildren call count", (long)4L, (long)callCount.get());
        Assert.assertEquals((String)"All TreeDataProvider.fetchChildren streams didn't get closed", (long)callCount.get(), (long)closeCount.get());
        Assert.assertEquals((String)"Unexpected  HierarchyMapper.fetchItems call count", (long)1L, (long)mapperStreamCallCount.get());
        Assert.assertEquals((String)"HierarchyMapper.fetchItems stream got closed even without recommended handling", (long)0L, (long)mapperStreamCloseCount.get());
        stream.count();
        Assert.assertEquals((String)"HierarchyMapper.fetchItems stream got closed after terminal operation even without recommended handling", (long)0L, (long)mapperStreamCloseCount.get());
        stream.close();
        Assert.assertEquals((String)"All HierarchyMapper.fetchItems streams didn't get closed as expected even after separate call", (long)mapperStreamCallCount.get(), (long)mapperStreamCloseCount.get());
        try (Stream newStream = this.mapper.fetchItems(Range.between((int)0, (int)10));){
            newStream.count();
        }
        Assert.assertEquals((String)"All HierarchyMapper.fetchItems streams didn't get closed as expected despite the recommended handling", (long)mapperStreamCallCount.get(), (long)mapperStreamCloseCount.get());
    }

    private void expand(Node node) {
        this.insertRows(this.mapper.expand((Object)node, (Integer)this.mapper.getIndexOf((Object)node).orElse(null)));
    }

    private void collapse(Node node) {
        this.removeRows(this.mapper.collapse((Object)node, (Integer)this.mapper.getIndexOf((Object)node).orElse(null)));
    }

    private void verifyFetchIsCorrect(List<Node> expectedResult, Range range) {
        List collect;
        try (Stream stream = this.mapper.fetchItems(range);){
            collect = stream.collect(Collectors.toList());
        }
        for (int i = 0; i < range.length(); ++i) {
            Assert.assertEquals((String)"Unexpected fetch results.", (Object)expectedResult.get(i + range.getStart()), collect.get(i));
        }
    }

    static List<Node> generateTestData(int rootCount, int parentCount, int leafCount) {
        int nodeCounter = 0;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < rootCount; ++i) {
            Node root = new Node(nodeCounter++);
            nodes.add(root);
            for (int j = 0; j < parentCount; ++j) {
                Node parent = new Node(root, nodeCounter++);
                nodes.add(parent);
                for (int k = 0; k < leafCount; ++k) {
                    nodes.add(new Node(parent, nodeCounter++));
                }
            }
        }
        return nodes;
    }

    private void checkMapSize() {
        Assert.assertEquals((String)"Map size not properly updated", (long)this.mapper.getTreeSize(), (long)this.mapSize);
    }

    public void removeRows(Range range) {
        Assert.assertTrue((String)"Index not in range", (0 <= range.getStart() && range.getStart() < this.mapSize ? 1 : 0) != 0);
        Assert.assertTrue((String)"Removing more items than in map", (range.getEnd() <= this.mapSize ? 1 : 0) != 0);
        this.mapSize -= range.length();
    }

    public void insertRows(Range range) {
        Assert.assertTrue((String)"Index not in range", (0 <= range.getStart() && range.getStart() <= this.mapSize ? 1 : 0) != 0);
        this.mapSize += range.length();
    }
}

