/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.provider;

import com.vaadin.data.provider.AbstractDataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.data.provider.StrBean;
import java.util.List;
import java.util.stream.Stream;

public class ReplaceListDataProvider
extends AbstractDataProvider<StrBean, Void> {
    private final List<StrBean> backend;

    public ReplaceListDataProvider(List<StrBean> items) {
        this.backend = items;
    }

    public void refreshItem(StrBean item) {
        if (this.replaceItem(item)) {
            super.refreshItem((Object)item);
        }
    }

    private boolean replaceItem(StrBean item) {
        for (int i = 0; i < this.backend.size(); ++i) {
            if (!this.getId(this.backend.get(i)).equals(this.getId(item))) continue;
            if (this.backend.get(i).equals(item)) {
                return false;
            }
            this.backend.remove(i);
            this.backend.add(i, item);
            return true;
        }
        return false;
    }

    public boolean isInMemory() {
        return true;
    }

    public int size(Query<StrBean, Void> t) {
        return this.backend.size();
    }

    public Stream<StrBean> fetch(Query<StrBean, Void> query) {
        return this.backend.stream().skip(query.getOffset()).limit(query.getLimit());
    }

    public boolean isStale(StrBean item) {
        Object id = this.getId(item);
        boolean itemExistsInBackEnd = this.backend.contains(item);
        boolean backEndHasInstanceWithSameId = this.backend.stream().map(this::getId).filter(i -> id.equals(i)).count() == 1L;
        return !itemExistsInBackEnd && backEndHasInstanceWithSameId;
    }

    public Object getId(StrBean item) {
        return item.getId();
    }
}

