/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.HasValue;
import com.vaadin.data.ValueContext;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import java.util.Locale;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValueContextTest
extends UI {
    private static final Locale UI_LOCALE = Locale.GERMAN;
    private static final Locale COMPONENT_LOCALE = Locale.FRENCH;
    private TextField textField;

    @Test
    public void locale_from_component() {
        this.textField.setLocale(COMPONENT_LOCALE);
        ValueContext fromComponent = new ValueContext((Component)this.textField);
        Locale locale = fromComponent.getLocale().orElse(null);
        Objects.requireNonNull(locale);
        Assert.assertEquals((String)"Unexpected locale from component", (Object)COMPONENT_LOCALE, (Object)locale);
    }

    @Test
    public void locale_from_ui() {
        ValueContext fromComponent = new ValueContext((Component)this.textField);
        Locale locale = fromComponent.getLocale().orElse(null);
        Objects.requireNonNull(locale);
        Assert.assertEquals((String)"Unexpected locale from component", (Object)UI_LOCALE, (Object)locale);
    }

    @Test
    public void default_locale() {
        this.setLocale(null);
        ValueContext fromComponent = new ValueContext((Component)this.textField);
        Locale locale = fromComponent.getLocale().orElse(null);
        Objects.requireNonNull(locale);
        Assert.assertEquals((String)"Unexpected locale from component", (Object)Locale.getDefault(), (Object)locale);
    }

    @Test
    public void testHasValue1() {
        this.setLocale(null);
        ValueContext fromComponent = new ValueContext((Component)this.textField);
        Assert.assertEquals((Object)this.textField, fromComponent.getHasValue().get());
    }

    @Test
    public void testHasValue2() {
        this.setLocale(null);
        ValueContext fromComponent = new ValueContext((Component)new CheckBox(), (HasValue)this.textField);
        Assert.assertEquals((Object)this.textField, fromComponent.getHasValue().get());
    }

    @Test
    public void testHasValue3() {
        this.setLocale(null);
        ValueContext fromComponent = new ValueContext((Component)new CheckBox(), (HasValue)this.textField, Locale.CANADA);
        Assert.assertEquals((Object)this.textField, fromComponent.getHasValue().get());
        Assert.assertEquals((Object)Locale.CANADA, fromComponent.getLocale().get());
    }

    @Before
    public void setUp() {
        this.setLocale(UI_LOCALE);
        this.textField = new TextField();
        this.setContent((Component)this.textField);
    }

    public void init(VaadinRequest request) {
    }
}

