/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.HasValue;
import com.vaadin.ui.DateField;
import com.vaadin.ui.TextField;
import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class HasValueTest {
    @Test
    public void clear() {
        TestHasValue hasValue = (TestHasValue)Mockito.mock(TestHasValue.class);
        ((TestHasValue)Mockito.doCallRealMethod().when((Object)hasValue)).clear();
        String value = "foo";
        Mockito.when((Object)((String)hasValue.getEmptyValue())).thenReturn((Object)value);
        hasValue.clear();
        ((TestHasValue)Mockito.verify((Object)hasValue)).setValue(value);
    }

    @Test
    public void getOptionalValue_nullableHasValue() {
        DateField nullable = new DateField();
        assert (nullable.isEmpty());
        assert (nullable.getValue() == null);
        Assert.assertFalse((boolean)nullable.getOptionalValue().isPresent());
        nullable.setValue((Object)LocalDate.now());
        assert (!nullable.isEmpty());
        Assert.assertSame((Object)nullable.getValue(), nullable.getOptionalValue().get());
    }

    @Test
    public void getOptionalValue_nonNullableHasValue() {
        TextField nonNullable = new TextField();
        assert (nonNullable.isEmpty());
        assert (nonNullable.getValue() != null);
        Assert.assertFalse((boolean)nonNullable.getOptionalValue().isPresent());
        nonNullable.setValue((Object)"foo");
        assert (!nonNullable.isEmpty());
        Assert.assertSame((Object)nonNullable.getValue(), nonNullable.getOptionalValue().get());
    }

    public static abstract class TestHasValue
    implements HasValue<String> {
        public void clear() {
            super.clear();
        }
    }
}

