/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.Binder;
import com.vaadin.data.BinderTestBase;
import com.vaadin.data.Converter;
import com.vaadin.data.Result;
import com.vaadin.data.ValueContext;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.tests.data.bean.BeanWithEnums;
import com.vaadin.tests.data.bean.TestEnum;
import com.vaadin.ui.CheckBoxGroup;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinderMultiSelectTest
extends BinderTestBase<Binder<BeanWithEnums>, BeanWithEnums> {
    private final Binder<AtomicReference<String>> converterBinder = new Binder();
    private CheckBoxGroup<TestEnum> select;

    @Before
    public void setUp() {
        this.binder = new Binder();
        this.item = new BeanWithEnums();
        this.select = new CheckBoxGroup();
        this.select.setItems((Object[])TestEnum.values());
        this.converterBinder.forField(this.select).withConverter((Converter)new TestEnumSetToStringConverter()).bind(AtomicReference::get, AtomicReference::set);
    }

    @Test
    public void beanBound_bindSelectByShortcut_selectionUpdated() {
        ((BeanWithEnums)this.item).setEnums(Collections.singleton(TestEnum.ONE));
        this.binder.setBean((Object)((BeanWithEnums)this.item));
        this.binder.bind(this.select, BeanWithEnums::getEnums, BeanWithEnums::setEnums);
        Assert.assertEquals(Collections.singleton(TestEnum.ONE), (Object)this.select.getSelectedItems());
    }

    @Test
    public void beanBound_bindSelect_selectionUpdated() {
        ((BeanWithEnums)this.item).setEnums(Collections.singleton(TestEnum.TWO));
        this.binder.setBean((Object)((BeanWithEnums)this.item));
        this.binder.forField(this.select).bind(BeanWithEnums::getEnums, BeanWithEnums::setEnums);
        Assert.assertEquals(Collections.singleton(TestEnum.TWO), (Object)this.select.getSelectedItems());
    }

    @Test
    public void selectBound_bindBeanWithoutEnums_selectedItemNotPresent() {
        this.bindEnum();
        Assert.assertTrue((boolean)this.select.getSelectedItems().isEmpty());
    }

    @Test
    public void selectBound_bindBean_selectionUpdated() {
        ((BeanWithEnums)this.item).setEnums(Collections.singleton(TestEnum.ONE));
        this.bindEnum();
        Assert.assertEquals(Collections.singleton(TestEnum.ONE), (Object)this.select.getSelectedItems());
    }

    @Test
    public void bound_setSelection_beanValueUpdated() {
        this.bindEnum();
        this.select.select((Object[])new TestEnum[]{TestEnum.TWO});
        Assert.assertEquals(Collections.singleton(TestEnum.TWO), ((BeanWithEnums)this.item).getEnums());
    }

    @Test
    public void bound_setSelection_beanValueIsACopy() {
        this.bindEnum();
        this.select.select((Object[])new TestEnum[]{TestEnum.TWO});
        Set<TestEnum> enums = ((BeanWithEnums)this.item).getEnums();
        this.binder.setBean((Object)new BeanWithEnums());
        this.select.select((Object[])new TestEnum[]{TestEnum.ONE});
        Assert.assertEquals(Collections.singleton(TestEnum.TWO), enums);
    }

    @Test
    public void bound_deselect_beanValueUpdatedToNull() {
        ((BeanWithEnums)this.item).setEnums(Collections.singleton(TestEnum.ONE));
        this.bindEnum();
        this.select.deselect((Object[])new TestEnum[]{TestEnum.ONE});
        Assert.assertTrue((boolean)((BeanWithEnums)this.item).getEnums().isEmpty());
    }

    @Test
    public void unbound_changeSelection_beanValueNotUpdated() {
        ((BeanWithEnums)this.item).setEnums(Collections.singleton(TestEnum.ONE));
        this.bindEnum();
        this.binder.removeBean();
        this.select.select((Object[])new TestEnum[]{TestEnum.TWO});
        Assert.assertEquals(Collections.singleton(TestEnum.ONE), ((BeanWithEnums)this.item).getEnums());
    }

    @Test
    public void withConverter_load_selectUpdated() {
        this.converterBinder.readBean(new AtomicReference<String>("TWO"));
        Assert.assertEquals(Collections.singleton(TestEnum.TWO), (Object)this.select.getSelectedItems());
    }

    @Test
    public void withConverter_save_referenceUpdated() {
        this.select.select((Object[])new TestEnum[]{TestEnum.ONE});
        this.select.select((Object[])new TestEnum[]{TestEnum.TWO});
        AtomicReference<String> reference = new AtomicReference<String>("");
        this.converterBinder.writeBeanIfValid(reference);
        Assert.assertEquals((Object)"ONE,TWO", (Object)reference.get());
    }

    @Test
    public void withValidator_validate_validatorUsed() {
        this.binder.forField(this.select).withValidator((SerializablePredicate & Serializable)selection -> selection.size() % 2 == 1, "Must select odd number of items").bind(BeanWithEnums::getEnums, BeanWithEnums::setEnums);
        this.binder.setBean((Object)((BeanWithEnums)this.item));
        Assert.assertFalse((boolean)this.binder.validate().isOk());
        this.select.select((Object[])new TestEnum[]{TestEnum.TWO});
        Assert.assertTrue((boolean)this.binder.validate().isOk());
    }

    protected void bindEnum() {
        this.binder.forField(this.select).bind(BeanWithEnums::getEnums, BeanWithEnums::setEnums);
        this.binder.setBean((Object)((BeanWithEnums)this.item));
    }

    public static class TestEnumSetToStringConverter
    implements Converter<Set<TestEnum>, String> {
        public Result<String> convertToModel(Set<TestEnum> value, ValueContext context) {
            return Result.ok((Object)value.stream().map(Enum::name).collect(Collectors.joining(",")));
        }

        public Set<TestEnum> convertToPresentation(String value, ValueContext context) {
            return Stream.of(value.split(",")).filter(string -> !string.isEmpty()).map(TestEnum::valueOf).collect(Collectors.toSet());
        }
    }
}

