/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import com.vaadin.event.SerializableEventListener;
import com.vaadin.ui.Grid;

/**
 * An event listener for a {@link Grid} editor save events.
 *
 * @author Vaadin Ltd
 * @since 8.0
 *
 * @see EditorSaveEvent
 * @see Editor#addSaveListener(EditorSaveListener)
 */
@FunctionalInterface
public interface EditorSaveListener<T> extends SerializableEventListener {

    /**
     * Called when the editor is saved.
     *
     * @param event
     *            save event
     */
    public void onEditorSave(EditorSaveEvent<T> event);
}
