/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.dnd.event;

import java.lang.reflect.Method;

import com.vaadin.event.ConnectorEventListener;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.dnd.DragSourceExtension;
import com.vaadin.util.ReflectTools;

/**
 * Interface to be implemented when creating a dragstart listener on a drag
 * source for HTML5 drag and drop.
 *
 * @param <T>
 *            Type of draggable component.
 * @author Vaadin Ltd
 * @see DragSourceExtension#addDragStartListener(DragStartListener)
 * @since 8.1
 */
@FunctionalInterface
public interface DragStartListener<T extends AbstractComponent>
        extends ConnectorEventListener {
    static final Method DRAGSTART_METHOD = ReflectTools
            .getMethod(DragStartListener.class);

    /**
     * Called when dragstart event is fired.
     *
     * @param event
     *            Server side dragstart event.
     */
    void dragStart(DragStartEvent<T> event);
}
