/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import java.lang.reflect.Method;

import com.vaadin.event.ConnectorEventListener;
import com.vaadin.util.ReflectTools;

/**
 * Drag start listener for HTML5 drag start on a Grid row.
 *
 * @param <T>
 *            The Grid bean type.
 * @author Vaadin Ltd.
 * @see GridDragSource#addGridDragStartListener(GridDragStartListener)
 * @since 8.1
 */
@FunctionalInterface
public interface GridDragStartListener<T> extends ConnectorEventListener {

    static final Method DRAG_START_METHOD = ReflectTools
            .getMethod(GridDragStartListener.class);

    /**
     * Invoked when the user has started dragging grid's rows.
     *
     * @param event
     *            The drag start event.
     */
    void dragStart(GridDragStartEvent<T> event);
}
