/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui;

import com.vaadin.server.SerializableFunction;

/**
 * A callback interface for generating custom CSS class names for items.
 *
 * @param <T>
 *            the item type
 *
 * @since 8.0
 * @author Vaadin Ltd
 */
@FunctionalInterface
public interface StyleGenerator<T> extends SerializableFunction<T, String> {

    /**
     * Gets a class name for the {@code item}.
     *
     * @param item
     *            the item to get the class name for
     * @return the generated class name
     */
    @Override
    String apply(T item);
}
