/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui;

import com.vaadin.server.SerializableFunction;

/**
 * {@link ItemCaptionGenerator} can be used to customize the string shown to the
 * user for an item.
 *
 * @see ComboBox#setItemCaptionGenerator(ItemCaptionGenerator)
 * @param <T>
 *            item type
 * @since 8.0
 * @author Vaadin Ltd
 */
@FunctionalInterface
public interface ItemCaptionGenerator<T>
        extends SerializableFunction<T, String> {

    /**
     * Gets a caption for the {@code item}.
     *
     * @param item
     *            the item to get caption for
     * @return the caption of the item; {@code null} will be shown as an empty
     *         string
     */
    @Override
    String apply(T item);
}
