/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.event.selection;

import java.lang.reflect.Method;

import com.vaadin.event.SerializableEventListener;
import com.vaadin.util.ReflectTools;

/**
 * A listener for listening to selection changes on a single selection
 * component.
 *
 * @author Vaadin Ltd.
 *
 * @since 8.0
 *
 * @param <T>
 *            the type of the selected item
 *
 * @see com.vaadin.data.SelectionModel.Single SelectionModel.Single
 * @see SingleSelectionEvent
 */
@FunctionalInterface
public interface SingleSelectionListener<T> extends SerializableEventListener {

    /** For internal use only. Might be removed in the future. */
    @Deprecated
    static final Method SELECTION_CHANGE_METHOD = ReflectTools.findMethod(
            SingleSelectionListener.class, "selectionChange",
            SingleSelectionEvent.class);

    /**
     * Invoked when selection has been changed by the user or programmatically.
     *
     * @param event
     *            the selection event
     */
    public void selectionChange(SingleSelectionEvent<T> event);
}
