/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.dnd;

import java.io.Serializable;

import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.dnd.event.FileDropEvent;

/**
 * Handles the drop event on a file drop target.
 *
 * @param <T>
 *            Type of the file drop target component.
 * @author Vaadin Ltd
 * @see FileDropEvent
 * @see com.vaadin.ui.dnd.FileDropTarget
 * @since 8.1
 */
public interface FileDropHandler<T extends AbstractComponent>
        extends Serializable {

    /**
     * Handles the drop event. The method is called when files are dropped onto
     * the file drop target this handler is registered to.
     *
     * @param event
     *            The file drop event containing the list of files that were
     *            dropped onto the component.
     */
    public void drop(FileDropEvent<T> event);
}
