/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.event.dd;

import java.io.Serializable;

import com.vaadin.ui.dnd.event.DropEvent;

/**
 * TargetDetails wraps drop target related information about
 * {@link DragAndDropEvent}.
 * <p>
 * When a TargetDetails object is used in {@link DropHandler} it is often
 * preferable to cast the TargetDetails to an implementation provided by
 * DropTarget like {@code TreeTargetDetails}. They often provide a better typed,
 * drop target specific API.
 *
 * @since 6.3
 * @deprecated Replaced in 8.1 by {@link DropEvent#getDataTransferData(String)}
 */
@Deprecated
public interface TargetDetails extends Serializable {

    /**
     * Gets target data associated with the given string key.
     *
     * @param key
     * @return The data associated with the key
     */
    public Object getData(String key);

    /**
     * @return the drop target on which the {@link DragAndDropEvent} happened.
     */
    public DropTarget getTarget();

}
