/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation enabling using multiple {@link HtmlImport @HtmlImport}
 * annotations.
 * <p>
 * <b>NOT meant to be used</b>, for multiple HTML dependencies,
 * {@link HtmlImport @HtmlImport} should be used instead.
 *
 * @author Vaadin Ltd
 * @since 8.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface InternalContainerAnnotationForHtml {

    /**
     * Not to be used, instead multiple {@link HtmlImport @HtmlImport}
     * annotations should be used.
     *
     * @return an array of the HtmlImport annotations
     */
    HtmlImport[] value();
}
