/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import java.lang.reflect.Method;

import com.vaadin.event.ConnectorEventListener;
import com.vaadin.util.ReflectTools;

/**
 * Drop listener for HTML5 drop on a TreeGrid row.
 *
 * @param <T>
 *            The Grid bean type.
 * @author Vaadin Ltd.
 * @see TreeGridDropTarget#addTreeGridDropListener(TreeGridDropListener)
 * @since 8.1
 */
@FunctionalInterface
public interface TreeGridDropListener<T> extends ConnectorEventListener {

    static final Method DROP_METHOD = ReflectTools
            .getMethod(TreeGridDropListener.class);

    /**
     * Called when drop event is fired on a Grid row.
     *
     * @param event
     *            Server side drop event.
     */
    void drop(TreeGridDropEvent<T> event);
}
