/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import java.util.EventObject;

import com.vaadin.ui.Grid;

/**
 * An event that is fired when a Grid editor is opened.
 *
 * @author Vaadin Ltd
 * @since 8.1
 *
 * @see EditorOpenListener
 * @see Editor#addOpenListener(EditorOpenListener)
 *
 * @param <T>
 *            the bean type
 */
public class EditorOpenEvent<T> extends EventObject {

    private T bean;

    /**
     * Constructor for a editor open event.
     *
     * @param editor
     *            the source of the event
     * @param bean
     *            the bean being edited
     */
    public EditorOpenEvent(Editor<T> editor, T bean) {
        super(editor);
        this.bean = bean;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Editor<T> getSource() {
        return (Editor<T>) super.getSource();
    }

    /**
     * Gets the editors' grid.
     *
     * @return the editors' grid
     */
    public Grid<T> getGrid() {
        return getSource().getGrid();
    }

    /**
     * Gets the bean being edited.
     *
     * @return the bean being edited
     */
    public T getBean() {
        return bean;
    }
}
