/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.navigator;

import java.io.Serializable;

/**
 * An action to execute when navigating away from a view.
 *
 * @since 8.1
 */
@FunctionalInterface
public interface ViewLeaveAction extends Serializable {
    /**
     * Executes the action.
     */
    public void run();
}
