/*
 * Vaadin Framework 7
 *
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

package com.vaadin.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation enabling using multiple {@link JavaScript @JavaScript}
 * annotations.
 * <p>
 * <b>NOT meant to be used</b>, for multiple JavaScript dependencies,
 * {@link JavaScript @JavaScript} should be used instead.
 *
 * @author Vaadin Ltd
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface InternalContainerAnnotationForJS {

    /**
     * Not to be used, instead multiple {@link JavaScript @JavaScript}
     * annotations should be used.
     *
     * @return an array of the JavaScript annotations
     */
    JavaScript[] value();
}
