/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JacksonSerializer;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.internal.nodefeature.ReturnChannelMap;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;

@JsModule(value="./lit-renderer.ts")
public class LitRenderer<SOURCE>
extends Renderer<SOURCE> {
    private final String templateExpression;
    private final String propertyNamespace;
    private final Map<String, ValueProvider<SOURCE, ?>> valueProviders = new HashMap();
    private final Map<String, SerializableBiConsumer<SOURCE, ArrayNode>> clientCallables = new HashMap<String, SerializableBiConsumer<SOURCE, ArrayNode>>();
    private final String ALPHANUMERIC_REGEX = "^[a-zA-Z0-9]+$";

    private LitRenderer(String templateExpression) {
        this.templateExpression = templateExpression;
        this.propertyNamespace = String.format("lr_%s_", UUID.randomUUID().toString().replace("-", "").substring(0, 16));
    }

    LitRenderer() {
        this("");
    }

    public static <SOURCE> LitRenderer<SOURCE> of(String templateExpression) {
        Objects.requireNonNull(templateExpression);
        return new LitRenderer<SOURCE>(templateExpression);
    }

    @Override
    public Rendering<SOURCE> render(Element container, DataKeyMapper<SOURCE> keyMapper, String rendererName) {
        final DataGenerator<SOURCE> dataGenerator = this.createDataGenerator();
        final Registration registration = this.createJsRendererFunction(container, keyMapper, rendererName);
        return new Rendering<SOURCE>(){

            @Override
            public Optional<DataGenerator<SOURCE>> getDataGenerator() {
                return Optional.of(dataGenerator);
            }

            @Override
            public Registration getRegistration() {
                return registration;
            }
        };
    }

    private UI getElementUI(Element element) {
        return ((StateTree)element.getNode().getOwner()).getUI();
    }

    private void setElementRenderer(Element container, String rendererName, String templateExpression, ReturnChannelRegistration returnChannel, ArrayNode clientCallablesArray, String propertyNamespace) {
        assert (container.getNode().isAttached()) : "Container must be attached";
        String appId = this.getElementUI(container).getInternals().getAppId();
        container.executeJs("window.Vaadin.setLitRenderer(this, $0, $1, $2, $3, $4, $5)", new Serializable[]{rendererName, templateExpression, returnChannel, clientCallablesArray, propertyNamespace, appId});
    }

    protected String getTemplateExpression() {
        return this.templateExpression;
    }

    String getPropertyNamespace() {
        return this.propertyNamespace;
    }

    private Registration createJsRendererFunction(Element container, DataKeyMapper<SOURCE> keyMapper, String rendererName) {
        ReturnChannelRegistration returnChannel = ((ReturnChannelMap)container.getNode().getFeature(ReturnChannelMap.class)).registerChannel((SerializableConsumer & Serializable)arguments -> {
            String handlerName = arguments.get(0).asText();
            String itemKey = arguments.get(1).asText();
            ArrayNode args = (ArrayNode)arguments.get(2);
            SerializableBiConsumer<SOURCE, ArrayNode> handler = this.clientCallables.get(handlerName);
            Object item = keyMapper.get(itemKey);
            if (item != null) {
                handler.accept(item, (Object)args);
            }
        });
        ArrayNode clientCallablesArray = JacksonUtils.listToJson(new ArrayList<String>(this.clientCallables.keySet()));
        ArrayList<Registration> registrations = new ArrayList<Registration>();
        registrations.add(container.addAttachListener((ElementAttachListener & Serializable)e -> this.setElementRenderer(container, rendererName, this.getTemplateExpression(), returnChannel, clientCallablesArray, this.propertyNamespace)));
        if (container.getNode().isAttached()) {
            this.setElementRenderer(container, rendererName, this.getTemplateExpression(), returnChannel, clientCallablesArray, this.propertyNamespace);
        }
        registrations.add((Registration & Serializable)() -> container.executeJs("window.Vaadin.unsetLitRenderer(this, $0, $1)", new Serializable[]{rendererName, this.propertyNamespace}));
        return (Registration & Serializable)() -> registrations.forEach(Registration::remove);
    }

    private DataGenerator<SOURCE> createDataGenerator() {
        return new DataGenerator<SOURCE>(){

            public void generateData(SOURCE item, ObjectNode jsonObject) {
                LitRenderer.this.valueProviders.forEach((key, provider) -> jsonObject.set(LitRenderer.this.propertyNamespace + key, JacksonSerializer.toJson((Object)provider.apply(item))));
            }
        };
    }

    public LitRenderer<SOURCE> withProperty(String property, ValueProvider<SOURCE, ?> provider) {
        Objects.requireNonNull(property);
        Objects.requireNonNull(provider);
        this.valueProviders.put(property, provider);
        return this;
    }

    public LitRenderer<SOURCE> withFunction(String functionName, SerializableConsumer<SOURCE> handler) {
        return this.withFunction(functionName, (SerializableBiConsumer & Serializable)(item, ignore) -> handler.accept(item));
    }

    public LitRenderer<SOURCE> withFunction(String functionName, SerializableBiConsumer<SOURCE, ArrayNode> handler) {
        Objects.requireNonNull(functionName);
        Objects.requireNonNull(handler);
        if (!Pattern.matches("^[a-zA-Z0-9]+$", functionName)) {
            throw new IllegalArgumentException("Function name must be alphanumeric");
        }
        this.clientCallables.put(functionName, handler);
        return this;
    }

    public Map<String, ValueProvider<SOURCE, ?>> getValueProviders() {
        return Collections.unmodifiableMap(this.valueProviders);
    }

    static {
        UsageStatistics.markAsUsed((String)"flow-components/LitRenderer", null);
    }
}

