/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.data.provider.AbstractComponentDataGenerator;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.ValueProvider;
import org.slf4j.LoggerFactory;

public class ComponentDataGenerator<T>
extends AbstractComponentDataGenerator<T> {
    private final ComponentRenderer<? extends Component, T> componentRenderer;
    private final ValueProvider<T, String> keyMapper;
    private String nodeIdPropertyName;
    private Element container;

    public ComponentDataGenerator(ComponentRenderer<? extends Component, T> componentRenderer, ValueProvider<T, String> keyMapper) {
        this.componentRenderer = componentRenderer;
        this.keyMapper = keyMapper;
    }

    public void generateData(T item, ObjectNode jsonObject) {
        int nodeId;
        if (this.nodeIdPropertyName == null) {
            return;
        }
        String itemKey = this.getItemKey(item);
        Component oldRenderedComponent = this.getRenderedComponent(itemKey);
        if (oldRenderedComponent != null) {
            nodeId = oldRenderedComponent.getElement().getNode().getId();
        } else {
            Component renderedComponent = this.createComponent(item);
            if (renderedComponent.getParent().isPresent()) {
                LoggerFactory.getLogger(ComponentDataGenerator.class).warn("The 'createComponent' method returned a component '{}' which already has a parent. It means that most likely your component renderer '{}' class is implemented incorrectly", (Object)renderedComponent.getClass().getName(), (Object)this.componentRenderer.getClass().getName());
            }
            this.registerRenderedComponent(itemKey, renderedComponent);
            nodeId = renderedComponent.getElement().getNode().getId();
        }
        jsonObject.put(this.nodeIdPropertyName, nodeId);
    }

    protected Component createComponent(T item) {
        Component c = this.componentRenderer.createComponent(item);
        if (c == null) {
            c = new Text("");
        }
        return c;
    }

    protected Component updateComponent(Component currentComponent, T item) {
        return this.componentRenderer.updateComponent(currentComponent, item);
    }

    protected String getItemKey(T item) {
        if (this.keyMapper == null) {
            return null;
        }
        return (String)this.keyMapper.apply(item);
    }

    protected Element getContainer() {
        return this.container;
    }

    public void setContainer(Element container) {
        this.container = container;
    }

    public ComponentRenderer<? extends Component, T> getComponentRenderer() {
        return this.componentRenderer;
    }

    public String getNodeIdPropertyName() {
        return this.nodeIdPropertyName;
    }

    public void setNodeIdPropertyName(String nodeIdPropertyName) {
        this.nodeIdPropertyName = nodeIdPropertyName;
    }
}

