/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.radiobutton;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.data.binder.HasItemComponents;

@Tag(value="vaadin-radio-button")
@NpmPackage(value="@vaadin/radio-group", version="25.1.0-alpha6")
@JsModule(value="@vaadin/radio-group/src/vaadin-radio-button.js")
class RadioButton<T>
extends Component
implements ClickNotifier<RadioButton<T>>,
Focusable<RadioButton<T>>,
HasComponents,
HasItemComponents.ItemComponent<T>,
HasStyle {
    private T item;
    private final NativeLabel labelElement = this.appendLabelElement();

    RadioButton(String key, T item) {
        this.item = item;
        this.getElement().setProperty("value", key);
    }

    public T getItem() {
        return this.item;
    }

    public void setLabelComponent(Component component) {
        this.labelElement.removeAll();
        this.labelElement.add(new Component[]{component});
    }

    private NativeLabel appendLabelElement() {
        NativeLabel label = new NativeLabel();
        SlotUtils.addToSlot((HasElement)this, (String)"label", (Component[])new Component[]{label});
        return label;
    }

    @Synchronize(property="checked", value={"checked-changed"})
    boolean isCheckedBoolean() {
        return this.getElement().getProperty("checked", false);
    }

    void setChecked(boolean checked) {
        this.getElement().setProperty("checked", checked);
    }

    void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }
}

