/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.radiobutton;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.radiobutton.RadioButton;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import com.vaadin.flow.component.radiobutton.dataview.RadioButtonGroupDataView;
import com.vaadin.flow.component.radiobutton.dataview.RadioButtonGroupListDataView;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.component.shared.SelectionPreservationHandler;
import com.vaadin.flow.component.shared.SelectionPreservationMode;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.shared.internal.ValidationController;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;

@Tag(value="vaadin-radio-group")
@NpmPackage(value="@vaadin/radio-group", version="25.1.0-alpha5")
@JsModule(value="@vaadin/radio-group/src/vaadin-radio-group.js")
public class RadioButtonGroup<T>
extends AbstractSinglePropertyField<RadioButtonGroup<T>, T>
implements HasAriaLabel,
HasDataView<T, Void, RadioButtonGroupDataView<T>>,
HasListDataView<T, RadioButtonGroupListDataView<T>>,
InputField<AbstractField.ComponentValueChangeEvent<RadioButtonGroup<T>, T>, T>,
HasThemeVariant<RadioGroupVariant>,
HasValidationProperties,
HasValidator<T>,
SingleSelect<RadioButtonGroup<T>, T> {
    private final KeyMapper<T> keyMapper = new KeyMapper();
    private final AtomicReference<DataProvider<T, ?>> dataProvider = new AtomicReference<ListDataProvider>(DataProvider.ofItems((Object[])new Object[0]));
    private SerializablePredicate<T> itemEnabledProvider = (SerializablePredicate & Serializable)item -> this.isEnabled();
    private ItemLabelGenerator<T> itemLabelGenerator = String::valueOf;
    private ComponentRenderer<? extends Component, T> itemRenderer = new TextRenderer(this.itemLabelGenerator);
    private Registration dataProviderListenerRegistration;
    private int lastNotifiedDataSize = -1;
    private volatile int lastFetchedDataSize = -1;
    private SerializableConsumer<UI> sizeRequest;
    private RadioButtonGroupI18n i18n;
    private Validator<T> defaultValidator = (Validator & Serializable)(value, context) -> {
        boolean fromComponent = context == null;
        boolean isRequired = fromComponent && this.isRequiredIndicatorVisible();
        return ValidationUtil.validateRequiredConstraint((String)this.getI18nErrorMessage(RadioButtonGroupI18n::getRequiredErrorMessage), (boolean)isRequired, (Object)this.getValue(), (Object)this.getEmptyValue());
    };
    private ValidationController<RadioButtonGroup<T>, T> validationController = new ValidationController((Component)this);
    private SelectionPreservationHandler<T> selectionPreservationHandler;

    private static <T> T presentationToModel(RadioButtonGroup<T> radioButtonGroup, String presentation) {
        if (radioButtonGroup.keyMapper == null) {
            return null;
        }
        if (!radioButtonGroup.keyMapper.containsKey(presentation)) {
            return null;
        }
        return (T)radioButtonGroup.keyMapper.get(presentation);
    }

    private static <T> String modelToPresentation(RadioButtonGroup<T> radioButtonGroup, T model) {
        if (!radioButtonGroup.keyMapper.has(model)) {
            return null;
        }
        return radioButtonGroup.keyMapper.key(model);
    }

    public RadioButtonGroup() {
        super("value", null, String.class, RadioButtonGroup::presentationToModel, RadioButtonGroup::modelToPresentation);
        this.getElement().setProperty("manualValidation", true);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.initSelectionPreservationHandler();
    }

    public RadioButtonGroup(String label) {
        this();
        this.setLabel(label);
    }

    public RadioButtonGroup(String label, Collection<T> items) {
        this(label);
        this.setItems(items);
    }

    @SafeVarargs
    public RadioButtonGroup(String label, T ... items) {
        this(label);
        this.setItems(items);
    }

    public RadioButtonGroup(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<RadioButtonGroup<T>, T>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public RadioButtonGroup(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<RadioButtonGroup<T>, T>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    @SafeVarargs
    public RadioButtonGroup(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<RadioButtonGroup<T>, T>> listener, T ... items) {
        this(label, listener);
        this.setItems(items);
    }

    public RadioButtonGroupDataView<T> setItems(DataProvider<T, Void> dataProvider) {
        this.setDataProvider(dataProvider);
        return this.getGenericDataView();
    }

    public RadioButtonGroupDataView<T> setItems(InMemoryDataProvider<T> inMemoryDataProvider) {
        DataProviderWrapper convertedDataProvider = new DataProviderWrapper<T, Void, SerializablePredicate<T>>((DataProvider)inMemoryDataProvider, (InMemoryDataProvider)inMemoryDataProvider){
            final /* synthetic */ InMemoryDataProvider val$inMemoryDataProvider;
            {
                this.val$inMemoryDataProvider = inMemoryDataProvider;
                super(arg0);
            }

            protected SerializablePredicate<T> getFilter(Query<T, Void> query) {
                return Optional.ofNullable(this.val$inMemoryDataProvider.getFilter()).orElse((SerializablePredicate & Serializable)item -> true);
            }
        };
        return this.setItems((DataProvider<T, Void>)convertedDataProvider);
    }

    public RadioButtonGroupListDataView<T> setItems(ListDataProvider<T> dataProvider) {
        this.setDataProvider((DataProvider<T, ?>)dataProvider);
        return this.getListDataView();
    }

    public RadioButtonGroupListDataView<T> getListDataView() {
        return new RadioButtonGroupListDataView(this::getDataProvider, this, this::identifierProviderChanged, (SerializableBiConsumer & Serializable)(filter, sorting) -> this.rebuild());
    }

    public RadioButtonGroupDataView<T> getGenericDataView() {
        return new RadioButtonGroupDataView(this::getDataProvider, this, this::identifierProviderChanged);
    }

    protected boolean hasValidValue() {
        String selectedKey = this.getElement().getProperty("value");
        Object item = this.keyMapper.get(selectedKey);
        if (item == null) {
            return true;
        }
        return this.itemEnabledProvider.test(item);
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.dataProvider.set(dataProvider);
        DataViewUtils.removeComponentFilterAndSortComparator((Component)this);
        this.keyMapper.removeAll();
        this.clear();
        this.rebuild();
        this.setupDataProviderListener(dataProvider);
    }

    private void setupDataProviderListener(DataProvider<T, ?> dataProvider) {
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
        }
        this.dataProviderListenerRegistration = dataProvider.addDataProviderListener(this::handleDataChange);
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator, "The item label generator can not be null");
        this.itemLabelGenerator = itemLabelGenerator;
        this.setRenderer((ComponentRenderer<? extends Component, T>)new TextRenderer(itemLabelGenerator));
    }

    public ItemLabelGenerator<T> getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    public void setValue(T value) {
        super.setValue(value);
        if (value == null) {
            this.getRadioButtons().forEach(rb -> rb.setChecked(false));
        } else {
            this.getRadioButtons().forEach(rb -> rb.setChecked(this.valueEquals(rb.getItem(), value)));
        }
        this.refreshButtons();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.getDataProvider() != null) {
            this.setupDataProviderListener(this.getDataProvider());
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
            this.dataProviderListenerRegistration = null;
        }
        super.onDetach(detachEvent);
    }

    public DataProvider<T, ?> getDataProvider() {
        return Optional.ofNullable(this.dataProvider).map(AtomicReference::get).orElse(null);
    }

    public SerializablePredicate<T> getItemEnabledProvider() {
        return this.itemEnabledProvider;
    }

    public void setItemEnabledProvider(SerializablePredicate<T> itemEnabledProvider) {
        this.itemEnabledProvider = Objects.requireNonNull(itemEnabledProvider);
        this.refreshButtons();
    }

    public ComponentRenderer<? extends Component, T> getItemRenderer() {
        return this.itemRenderer;
    }

    public void setRenderer(ComponentRenderer<? extends Component, T> renderer) {
        this.itemRenderer = Objects.requireNonNull(renderer);
        this.refreshButtons();
    }

    public void onEnabledStateChanged(boolean enabled) {
        this.setDisabled(!enabled);
        this.refreshButtons();
    }

    public void setReadOnly(boolean readOnly) {
        this.getElement().setProperty("readonly", readOnly);
        this.refreshButtons();
    }

    public boolean isReadOnly() {
        return this.getElement().getProperty("readonly", false);
    }

    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public boolean isRequiredIndicatorVisible() {
        return super.isRequiredIndicatorVisible();
    }

    public boolean isRequired() {
        return this.isRequiredIndicatorVisible();
    }

    public void setRequired(boolean required) {
        this.setRequiredIndicatorVisible(required);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setSelectionPreservationMode(SelectionPreservationMode selectionPreservationMode) {
        this.selectionPreservationHandler.setSelectionPreservationMode(selectionPreservationMode);
    }

    public SelectionPreservationMode getSelectionPreservationMode() {
        return this.selectionPreservationHandler.getSelectionPreservationMode();
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("accessibleName", ariaLabel);
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public void setAriaLabelledBy(String labelledBy) {
        this.getElement().setProperty("accessibleNameRef", labelledBy);
    }

    public Optional<String> getAriaLabelledBy() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleNameRef"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        AtomicReference<DataProvider<T, ?>> atomicReference = this.dataProvider;
        synchronized (atomicReference) {
            Component helperComponent = this.getHelperComponent();
            this.getChildren().forEach(child -> child.getElement().removeFromParent());
            this.setHelperComponent(helperComponent);
            AtomicInteger itemCounter = new AtomicInteger(0);
            this.getDataProvider().fetch(DataViewUtils.getQuery((Component)this)).map(item -> this.createRadioButton(item)).forEach(component -> {
                this.getElement().appendChild(new Element[]{((Component)component).getElement()});
                itemCounter.incrementAndGet();
            });
            this.lastFetchedDataSize = itemCounter.get();
            if (this.sizeRequest == null) {
                this.sizeRequest = new SerializableConsumer<UI>(){

                    public void accept(UI ui) {
                        RadioButtonGroup.this.fireSizeEvent();
                        RadioButtonGroup.this.sizeRequest = null;
                    }
                };
                this.runBeforeClientResponse(this.sizeRequest);
            }
        }
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    private void fireSizeEvent() {
        int newSize = this.lastFetchedDataSize;
        if (this.lastNotifiedDataSize != newSize) {
            this.lastNotifiedDataSize = newSize;
            this.fireEvent((ComponentEvent)new ItemCountChangeEvent((Component)this, newSize, false));
        }
    }

    private void resetRadioButton(T item) {
        this.getRadioButtons().filter(radioButton -> this.getItemId(radioButton.getItem()).equals(this.getItemId(item))).findFirst().ifPresent(this::updateButton);
    }

    private Object getItemId(T item) {
        return this.getIdentifierProvider().apply(item);
    }

    private IdentifierProvider<T> getIdentifierProvider() {
        IdentifierProvider identifierProviderObject = (IdentifierProvider)ComponentUtil.getData((Component)this, IdentifierProvider.class);
        if (identifierProviderObject == null) {
            DataProvider<T, ?> dataProvider = this.getDataProvider();
            if (dataProvider != null) {
                return arg_0 -> dataProvider.getId(arg_0);
            }
            return IdentifierProvider.identity();
        }
        return identifierProviderObject;
    }

    private Component createRadioButton(T item) {
        RadioButton<T> button = new RadioButton<T>(this.keyMapper.key(item), item);
        this.updateButton(button);
        return button;
    }

    private void refreshButtons() {
        this.getRadioButtons().forEach(this::updateButton);
    }

    private Stream<RadioButton<T>> getRadioButtons() {
        return this.getChildren().filter(RadioButton.class::isInstance).map(child -> (RadioButton)((Object)child));
    }

    private void updateButton(RadioButton<T> button) {
        this.updateEnabled(button);
        Component labelComponent = this.getItemRenderer().createComponent(button.getItem());
        button.setLabelComponent(labelComponent);
    }

    protected boolean valueEquals(T value1, T value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return this.getItemId(value1).equals(this.getItemId(value2));
    }

    private void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    private boolean isDisabled() {
        return this.getElement().getProperty("disabled", false);
    }

    private void updateEnabled(RadioButton<T> button) {
        boolean disabled;
        boolean bl = disabled = this.isDisabled() || !this.getItemEnabledProvider().test(button.getItem());
        if (this.isReadOnly() && !button.isCheckedBoolean()) {
            disabled = true;
        }
        button.setEnabled(!disabled);
        button.setDisabled(disabled);
        button.getElement().executeJs("this.disabled = $0", new Object[]{disabled});
    }

    private void identifierProviderChanged(IdentifierProvider<T> identifierProvider) {
        this.keyMapper.setIdentifierGetter(identifierProvider);
    }

    private void initSelectionPreservationHandler() {
        this.selectionPreservationHandler = new SelectionPreservationHandler<T>(SelectionPreservationMode.DISCARD){

            public void onPreserveAll(DataChangeEvent<T> dataChangeEvent) {
            }

            public void onPreserveExisting(DataChangeEvent<T> dataChangeEvent) {
                Object initialValue = RadioButtonGroup.this.getValue();
                if (RadioButtonGroup.this.getDataProvider().fetch(DataViewUtils.getQuery((Component)RadioButtonGroup.this)).noneMatch(item -> RadioButtonGroup.this.valueEquals(item, initialValue))) {
                    RadioButtonGroup.this.clear();
                }
            }

            public void onDiscard(DataChangeEvent<T> dataChangeEvent) {
                RadioButtonGroup.this.clear();
            }
        };
    }

    private void handleDataChange(DataChangeEvent<T> dataChangeEvent) {
        if (dataChangeEvent instanceof DataChangeEvent.DataRefreshEvent) {
            DataChangeEvent.DataRefreshEvent refreshEvent = (DataChangeEvent.DataRefreshEvent)dataChangeEvent;
            this.keyMapper.refresh(refreshEvent.getItem());
            this.resetRadioButton(refreshEvent.getItem());
        } else {
            this.keyMapper.removeAll();
            this.selectionPreservationHandler.handleDataChange(dataChangeEvent);
            this.rebuild();
        }
    }

    public void setManualValidation(boolean enabled) {
        this.validationController.setManualValidation(enabled);
    }

    public Validator<T> getDefaultValidator() {
        return this.defaultValidator;
    }

    protected void validate() {
        this.validationController.validate(this.getValue());
    }

    public RadioButtonGroupI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(RadioButtonGroupI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
    }

    private String getI18nErrorMessage(Function<RadioButtonGroupI18n, String> getter) {
        return Optional.ofNullable(this.i18n).map(getter).orElse("");
    }

    public static class RadioButtonGroupI18n
    implements Serializable {
        private String requiredErrorMessage;

        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public RadioButtonGroupI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }
    }
}

