/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.radiobutton.dataview;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.data.provider.AbstractDataView;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableSupplier;

public class RadioButtonGroupDataView<T>
extends AbstractDataView<T> {
    private SerializableConsumer<IdentifierProvider<T>> identifierChangedCallback;

    public RadioButtonGroupDataView(SerializableSupplier<? extends DataProvider<T, ?>> dataProviderSupplier, RadioButtonGroup radioButtonGroup) {
        super(dataProviderSupplier, (Component)radioButtonGroup);
    }

    public RadioButtonGroupDataView(SerializableSupplier<? extends DataProvider<T, ?>> dataProviderSupplier, RadioButtonGroup radioButtonGroup, SerializableConsumer<IdentifierProvider<T>> identifierChangedCallback) {
        super(dataProviderSupplier, (Component)radioButtonGroup);
        this.identifierChangedCallback = identifierChangedCallback;
    }

    protected Class<?> getSupportedDataProviderType() {
        return DataProvider.class;
    }

    public T getItem(int index) {
        int dataSize = ((DataProvider)this.dataProviderSupplier.get()).size(new Query());
        if (dataSize == 0) {
            throw new IndexOutOfBoundsException(String.format("Requested index %d on empty data.", index));
        }
        if (index < 0 || index >= dataSize) {
            throw new IndexOutOfBoundsException(String.format("Given index %d is outside of the accepted range '0 - %d'", index, dataSize - 1));
        }
        return this.getItems().skip(index).findFirst().orElse(null);
    }

    public void setIdentifierProvider(IdentifierProvider<T> identifierProvider) {
        super.setIdentifierProvider(identifierProvider);
        if (this.identifierChangedCallback != null) {
            this.identifierChangedCallback.accept(identifierProvider);
        }
    }
}

