/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.radiobutton;

import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateNode;
import java.io.Serializable;

class FieldValidationUtil {
    private FieldValidationUtil() {
    }

    static <T> void disableClientValidation(RadioButtonGroup<T> component) {
        if (!component.isAttached()) {
            throw new IllegalStateException(String.format("Component %s is not attached. Client side validation should be disabled when the component is attached, thus this method needs to be called from the onAttach method of the component.", ((Object)component).toString()));
        }
        StateNode componentNode = component.getElement().getNode();
        componentNode.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(componentNode, (SerializableConsumer & Serializable)executionContext -> FieldValidationUtil.overrideClientValidation(component)));
    }

    private static <T> void overrideClientValidation(RadioButtonGroup<T> component) {
        StringBuilder expression = new StringBuilder("this.validate = function () {return this.checkValidity();};");
        if (component.isInvalid()) {
            expression.append("this.invalid = true;");
        }
        component.getElement().executeJs(expression.toString(), new Serializable[0]);
    }
}

