/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.graal;

import com.vaadin.quarkus.graal.DelayedInitBroadcaster;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.List;
import org.atmosphere.cpr.AtmosphereFramework;

public class AtmosphereDeferredInitializer {
    transient List<AtmosphereFramework> frameworks = new ArrayList<AtmosphereFramework>();

    static void completeInitialization(ServletContext servletContext) {
        AtmosphereDeferredInitializer initializer = AtmosphereDeferredInitializer.getOrCreateInitializer(servletContext);
        initializer.frameworks.forEach(DelayedInitBroadcaster::startExecutors);
    }

    public static void register(ServletConfig config, AtmosphereFramework framework) {
        ServletContext context = config.getServletContext();
        AtmosphereDeferredInitializer initializer = AtmosphereDeferredInitializer.getOrCreateInitializer(context);
        initializer.frameworks.add(framework);
    }

    private static AtmosphereDeferredInitializer getOrCreateInitializer(ServletContext context) {
        AtmosphereDeferredInitializer initializer = (AtmosphereDeferredInitializer)context.getAttribute(AtmosphereDeferredInitializer.class.getName());
        if (initializer == null) {
            initializer = new AtmosphereDeferredInitializer();
            context.setAttribute(AtmosphereDeferredInitializer.class.getName(), (Object)initializer);
        }
        return initializer;
    }
}

