/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus;

import com.vaadin.quarkus.AnyLiteral;
import com.vaadin.quarkus.annotation.VaadinServiceEnabled;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

class BeanLookup<T> {
    private final BeanManager beanManager;
    private final Class<T> type;
    private final Annotation[] qualifiers;
    private UnsatisfiedHandler unsatisfiedHandler = () -> {};
    private Consumer<AmbiguousResolutionException> ambiguousHandler = e -> {
        throw e;
    };
    private static final Annotation[] ANY = new Annotation[]{new AnyLiteral()};

    BeanLookup(BeanManager beanManager, Class<T> type, Annotation ... qualifiers) {
        this.beanManager = beanManager;
        this.type = type;
        this.qualifiers = qualifiers.length > 0 ? qualifiers : ANY;
    }

    BeanLookup<T> setUnsatisfiedHandler(UnsatisfiedHandler unsatisfiedHandler) {
        this.unsatisfiedHandler = unsatisfiedHandler;
        return this;
    }

    BeanLookup<T> setAmbiguousHandler(Consumer<AmbiguousResolutionException> ambiguousHandler) {
        this.ambiguousHandler = ambiguousHandler;
        return this;
    }

    T lookupOrElseGet(Supplier<T> fallback) {
        Bean bean;
        Set beans = this.beanManager.getBeans(this.type, this.qualifiers);
        if (beans == null || beans.isEmpty()) {
            this.unsatisfiedHandler.handle();
            return fallback.get();
        }
        try {
            bean = this.beanManager.resolve(beans);
        }
        catch (AmbiguousResolutionException e) {
            this.ambiguousHandler.accept(e);
            return fallback.get();
        }
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return (T)this.beanManager.getReference(bean, this.type, ctx);
    }

    T lookup() {
        return (T)this.lookupOrElseGet(() -> null);
    }

    Stream<T> lookupAll() {
        Set beans = this.beanManager.getBeans(this.type, new Annotation[]{VaadinServiceEnabled.Literal.INSTANCE});
        if (beans == null || beans.isEmpty()) {
            this.unsatisfiedHandler.handle();
            return Stream.empty();
        }
        return beans.stream().map(bean -> {
            CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
            return this.beanManager.getReference(bean, this.type, ctx);
        });
    }

    @FunctionalInterface
    public static interface UnsatisfiedHandler {
        public void handle();
    }
}

