/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.auth.MenuAccessControl;
import com.vaadin.quarkus.BeanLookup;
import com.vaadin.quarkus.annotation.VaadinServiceEnabled;
import jakarta.enterprise.inject.spi.BeanManager;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarkusInstantiator
implements Instantiator {
    private static final String CANNOT_USE_CDI_BEANS_FOR_I18N = "Cannot use CDI beans for I18N, falling back to the default behavior.";
    private static final String FALLING_BACK_TO_DEFAULT_INSTANTIATION = "Falling back to default instantiation.";
    private AtomicBoolean i18NLoggingEnabled = new AtomicBoolean(true);
    private DefaultInstantiator delegate;
    private BeanManager beanManager;

    public QuarkusInstantiator(DefaultInstantiator delegate, BeanManager beanManager) {
        this.delegate = delegate;
        this.beanManager = beanManager;
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public <T> T getOrCreate(Class<T> type) {
        return (T)new BeanLookup<T>(this.getBeanManager(), type, new Annotation[0]).setUnsatisfiedHandler(() -> QuarkusInstantiator.getLogger().debug("'{}' is not a CDI bean. Falling back to default instantiation.", (Object)type.getName())).setAmbiguousHandler(e -> QuarkusInstantiator.getLogger().debug("Multiple CDI beans found. Falling back to default instantiation.", (Throwable)e)).lookupOrElseGet(() -> {
            Object instance = this.delegate.getOrCreate(type);
            return instance;
        });
    }

    public I18NProvider getI18NProvider() {
        BeanLookup<I18NProvider> lookup = new BeanLookup<I18NProvider>(this.getBeanManager(), I18NProvider.class, VaadinServiceEnabled.Literal.INSTANCE);
        if (this.i18NLoggingEnabled.compareAndSet(true, false)) {
            lookup.setUnsatisfiedHandler(() -> QuarkusInstantiator.getLogger().info("Can't find any @VaadinServiceScoped bean implementing '{}'. Cannot use CDI beans for I18N, falling back to the default behavior.", (Object)I18NProvider.class.getSimpleName())).setAmbiguousHandler(e -> QuarkusInstantiator.getLogger().warn("Found more beans for I18N. Cannot use CDI beans for I18N, falling back to the default behavior.", (Throwable)e));
        } else {
            lookup.setAmbiguousHandler(e -> {});
        }
        return lookup.lookupOrElseGet(() -> ((DefaultInstantiator)this.delegate).getI18NProvider());
    }

    public MenuAccessControl getMenuAccessControl() {
        BeanLookup<MenuAccessControl> lookup = new BeanLookup<MenuAccessControl>(this.getBeanManager(), MenuAccessControl.class, VaadinServiceEnabled.Literal.INSTANCE);
        return lookup.lookupOrElseGet(() -> ((DefaultInstantiator)this.delegate).getMenuAccessControl());
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(QuarkusInstantiator.class);
    }

    public Stream<VaadinServiceInitListener> getServiceInitListeners() {
        return Stream.concat(this.delegate.getServiceInitListeners(), Stream.of((VaadinServiceInitListener & Serializable)event -> this.getBeanManager().getEvent().fire((Object)event)));
    }

    public <T extends Component> T createComponent(Class<T> componentClass) {
        return (T)((Component)this.getOrCreate(componentClass));
    }
}

