/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.graal;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.DefaultBroadcaster;

public class DelayedInitBroadcaster
extends DefaultBroadcaster {
    private final AtomicBoolean executorsInitialized = new AtomicBoolean(false);

    protected BroadcasterConfig createBroadcasterConfig(AtmosphereConfig config) {
        return new DelayedInitBroadcasterConfig(config.framework().broadcasterFilters(), config, this.getID()).init();
    }

    protected void spawnReactor() {
        if (this.executorsInitialized.get()) {
            super.spawnReactor();
        }
    }

    protected void start() {
        if (!this.started.getAndSet(true) && this.executorsInitialized.get()) {
            super.start();
        }
    }

    void delayedInit() {
        BroadcasterConfig broadcasterConfig = this.getBroadcasterConfig();
        if (broadcasterConfig instanceof DelayedInitBroadcasterConfig) {
            DelayedInitBroadcasterConfig cfg = (DelayedInitBroadcasterConfig)broadcasterConfig;
            if (this.executorsInitialized.compareAndSet(false, true)) {
                cfg.configExecutors();
                if (this.started.get()) {
                    super.start();
                }
            }
        }
    }

    static void startExecutors(AtmosphereFramework framework) {
        if (framework != null) {
            framework.getAtmosphereHandlers().values().stream().map(h -> h.broadcaster).filter(Objects::nonNull).filter(b -> b instanceof DelayedInitBroadcaster).map(DelayedInitBroadcaster.class::cast).forEach(DelayedInitBroadcaster::delayedInit);
        }
    }

    private static class DelayedInitBroadcasterConfig
    extends BroadcasterConfig {
        public DelayedInitBroadcasterConfig(List<String> broadcastFilters, AtmosphereConfig config, String broadcasterId) {
            super(broadcastFilters, config, false, broadcasterId);
        }

        protected synchronized void configExecutors() {
            super.configExecutors();
        }
    }
}

