/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus;

import com.vaadin.flow.server.HandlerHelper;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.quarkus.websockets.client.runtime.WebSocketPrincipal;
import io.undertow.httpcore.HttpExchange;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.vertx.VertxHttpExchange;
import io.undertow.websockets.ServerWebSocketContainer;
import io.undertow.websockets.WebSocketDeploymentInfo;
import io.undertow.websockets.vertx.VertxWebSocketHandler;
import io.undertow.websockets.vertx.VertxWebSocketHttpExchange;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.security.Principal;
import java.util.Optional;
import java.util.concurrent.Executor;

@Recorder
public class WebsocketHttpSessionAttachRecorder {
    public Handler<RoutingContext> createWebSocketHandler(RuntimeValue<WebSocketDeploymentInfo> info, RuntimeValue<ServerWebSocketContainer> container, DeploymentManager deploymentManager) {
        Deployment deployment = deploymentManager.getDeployment();
        final UpgradeRequestSessionAttachmentHandler handler = new UpgradeRequestSessionAttachmentHandler(deployment);
        return new VertxWebSocketHandler(this, (ServerWebSocketContainer)container.getValue(), (WebSocketDeploymentInfo)info.getValue()){

            public void handle(RoutingContext event) {
                if (HandlerHelper.RequestType.PUSH.getIdentifier().equals(event.request().getParam("v-r"))) {
                    super.handle(event);
                } else {
                    event.next();
                }
            }

            protected VertxWebSocketHttpExchange createHttpExchange(RoutingContext event) {
                VertxHttpExchange delegate = new VertxHttpExchange(event.request(), null, this.executor, null, null);
                return handler.extractSession(event, (HttpExchange)delegate).map(sess -> new QuarkusVertxWebSocketHttpExchange(this.executor, event, (HttpSession)sess)).orElseGet(() -> super.createHttpExchange(event));
            }
        };
    }

    private static class UpgradeRequestSessionAttachmentHandler {
        private final Deployment deployment;
        private final SessionAttachmentHandler sessionAttachmentHandler;

        private UpgradeRequestSessionAttachmentHandler(Deployment deployment) {
            this.deployment = deployment;
            this.sessionAttachmentHandler = new SessionAttachmentHandler(exchange -> {}, deployment.getSessionManager(), deployment.getServletContext().getSessionConfig());
        }

        private void handleRequest(HttpServerExchange exchange) throws Exception {
            ServletContextImpl servletContext = this.deployment.getServletContext();
            ServletPathMatch pathMatch = new ServletPathMatches(this.deployment).getServletHandlerByPath(exchange.getRelativePath());
            HttpServletResponseImpl response = new HttpServletResponseImpl(exchange, servletContext);
            HttpServletRequestImpl request = new HttpServletRequestImpl(exchange, servletContext);
            ServletRequestContext servletRequestContext = new ServletRequestContext(servletContext.getDeployment(), request, response, pathMatch);
            exchange.putAttachment(ServletRequestContext.ATTACHMENT_KEY, (Object)servletRequestContext);
            this.sessionAttachmentHandler.handleRequest(exchange);
        }

        private Optional<HttpSession> extractSession(RoutingContext event, HttpExchange httpExchange) {
            HttpServerExchange serverExchange = new HttpServerExchange(httpExchange, -1L);
            serverExchange.setRelativePath(event.request().path());
            serverExchange.setDispatchExecutor(Runnable::run);
            try {
                this.handleRequest(serverExchange);
            }
            catch (Exception e) {
                return Optional.empty();
            }
            SessionManager sessionManager = this.deployment.getSessionManager();
            SessionConfig sessionConfig = this.deployment.getServletContext().getSessionConfig();
            ServletContextImpl servletContext = this.deployment.getServletContext();
            return Optional.ofNullable(sessionManager.getSession(serverExchange, sessionConfig)).map(sess -> HttpSessionImpl.forSession((Session)sess, (ServletContext)servletContext, (boolean)false));
        }
    }

    private static class QuarkusVertxWebSocketHttpExchange
    extends VertxWebSocketHttpExchange {
        private final RoutingContext routingContext;
        private final HttpSession session;

        public QuarkusVertxWebSocketHttpExchange(Executor executor, RoutingContext routingContext, HttpSession session) {
            super(executor, routingContext);
            this.routingContext = routingContext;
            this.session = session;
        }

        public Object getSession() {
            return this.session;
        }

        public Principal getUserPrincipal() {
            QuarkusHttpUser user = (QuarkusHttpUser)this.routingContext.user();
            if (user != null) {
                return new WebSocketPrincipal(user.getSecurityIdentity());
            }
            return null;
        }
    }
}

