/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.graal;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.util.ExecutorsFactory;

public class DelayedSchedulerExecutorsFactory {
    public static ScheduledExecutorService getScheduler(AtmosphereConfig config) {
        return new DelayedSchedulerExecutor(config);
    }

    private static ScheduledExecutorService newScheduler(AtmosphereConfig config) {
        return ExecutorsFactory.getScheduler((AtmosphereConfig)config);
    }

    private static class DelayedSchedulerExecutor
    implements ScheduledExecutorService {
        private final AtmosphereConfig config;
        private final AtomicReference<ScheduledExecutorService> delegate = new AtomicReference();

        public DelayedSchedulerExecutor(AtmosphereConfig config) {
            this.config = config;
        }

        public ScheduledExecutorService getDelegate() {
            return this.delegate.updateAndGet(executor -> {
                if (executor == null) {
                    return DelayedSchedulerExecutorsFactory.newScheduler(this.config);
                }
                return executor;
            });
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.getDelegate().schedule(command, delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.getDelegate().schedule(callable, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.getDelegate().scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.getDelegate().scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }

        @Override
        public void shutdown() {
            this.getDelegate().shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.getDelegate().shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.getDelegate().isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.getDelegate().isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.getDelegate().awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.getDelegate().submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.getDelegate().submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.getDelegate().submit(task);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.getDelegate().invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.getDelegate().invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.getDelegate().invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.getDelegate().invokeAny(tasks, timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            this.getDelegate().execute(command);
        }
    }
}

