/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus;

import com.vaadin.flow.di.ResourceProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;

public class QuarkusResourceProvider
implements ResourceProvider {
    private Map<String, CachedStreamData> cache = new ConcurrentHashMap<String, CachedStreamData>();

    public URL getApplicationResource(String path) {
        return Thread.currentThread().getContextClassLoader().getResource(path);
    }

    public List<URL> getApplicationResources(String path) throws IOException {
        return Collections.list(Thread.currentThread().getContextClassLoader().getResources(path));
    }

    public URL getClientResource(String path) {
        return this.getApplicationResource(path);
    }

    public InputStream getClientResourceAsStream(String path) throws IOException {
        CachedStreamData cached = this.cache.computeIfAbsent(path, key -> {
            CachedStreamData cachedStreamData;
            block8: {
                URL url = this.getClientResource((String)key);
                InputStream stream = url.openStream();
                try {
                    ByteArrayOutputStream tempBuffer = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)stream, (OutputStream)tempBuffer);
                    cachedStreamData = new CachedStreamData(tempBuffer.toByteArray(), null);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return new CachedStreamData(null, e);
                    }
                }
                stream.close();
            }
            return cachedStreamData;
        });
        IOException exception = cached.exception;
        if (exception == null) {
            return new ByteArrayInputStream(cached.data);
        }
        throw exception;
    }

    private static class CachedStreamData {
        private final byte[] data;
        private final IOException exception;

        private CachedStreamData(byte[] data, IOException exception) {
            this.data = data;
            this.exception = exception;
        }
    }
}

