/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.context;

import com.vaadin.flow.server.SessionDestroyEvent;
import com.vaadin.flow.server.SessionDestroyListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.quarkus.annotation.VaadinSessionScoped;
import com.vaadin.quarkus.context.AbstractContext;
import com.vaadin.quarkus.context.ContextualStorage;
import jakarta.enterprise.context.spi.Contextual;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaadinSessionScopedContext
extends AbstractContext {
    private static final String ATTRIBUTE_NAME = VaadinSessionScopedContext.class.getName();

    @Override
    protected ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        VaadinSession session = VaadinSession.getCurrent();
        ContextualStorage storage = VaadinSessionScopedContext.findContextualStorage(session);
        if (storage == null && createIfNotExist) {
            storage = new SessionContextualStorage(session);
            session.setAttribute(ATTRIBUTE_NAME, (Object)storage);
        }
        return storage;
    }

    private static ContextualStorage findContextualStorage(VaadinSession session) {
        return (ContextualStorage)session.getAttribute(ATTRIBUTE_NAME);
    }

    public Class<? extends Annotation> getScope() {
        return VaadinSessionScoped.class;
    }

    public boolean isActive() {
        return VaadinSession.getCurrent() != null;
    }

    private static class SessionContextualStorage
    extends ContextualStorage
    implements SessionDestroyListener {
        private final Registration registration;
        private final VaadinSession session;

        private SessionContextualStorage(VaadinSession session) {
            super(false);
            this.session = session;
            this.registration = session.getService().addSessionDestroyListener((SessionDestroyListener)this);
        }

        public void sessionDestroy(SessionDestroyEvent event) {
            if (!this.session.equals(event.getSession())) {
                return;
            }
            this.getLogger().debug("VaadinSessionScopedContext destroy");
            ContextualStorage storage = VaadinSessionScopedContext.findContextualStorage(event.getSession());
            this.registration.remove();
            if (storage != null) {
                AbstractContext.destroyAllActive(storage);
            }
        }

        private Logger getLogger() {
            return LoggerFactory.getLogger(SessionContextualStorage.class);
        }
    }
}

