/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.PollEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.di.InstantiatorFactory;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveListener;
import com.vaadin.flow.router.ListenerPriority;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.ServiceDestroyEvent;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.SessionDestroyEvent;
import com.vaadin.flow.server.SessionInitEvent;
import com.vaadin.flow.server.SystemMessagesProvider;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.quarkus.BeanLookup;
import com.vaadin.quarkus.QuarkusVaadinServlet;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarkusVaadinServletService
extends VaadinServletService {
    private BeanManager beanManager;
    private final UIEventListener uiEventListener;

    public QuarkusVaadinServletService(QuarkusVaadinServlet servlet, DeploymentConfiguration configuration, BeanManager beanManager) {
        super((VaadinServlet)servlet, configuration);
        this.beanManager = beanManager;
        this.uiEventListener = new UIEventListener(beanManager);
        this.reportUsage();
    }

    private void reportUsage() {
        if (!this.getDeploymentConfiguration().isProductionMode()) {
            UsageStatistics.markAsUsed((String)"flow/quarkus", null);
        }
    }

    public void init() throws ServiceException {
        this.addEventListeners();
        this.lookup(SystemMessagesProvider.class).ifPresent(arg_0 -> ((QuarkusVaadinServletService)this).setSystemMessagesProvider(arg_0));
        super.init();
    }

    public void fireUIInitListeners(UI ui) {
        this.addUIListeners(ui);
        super.fireUIInitListeners(ui);
    }

    public Optional<Instantiator> loadInstantiators() throws ServiceException {
        Bean bean;
        Set beans = this.beanManager.getBeans(InstantiatorFactory.class, new Annotation[]{BeanLookup.SERVICE});
        if (beans == null || beans.isEmpty()) {
            throw new ServiceException("Cannot init VaadinService because no CDI instantiator factory bean found.");
        }
        try {
            bean = this.beanManager.resolve(beans);
        }
        catch (AmbiguousResolutionException e) {
            throw new ServiceException("There are multiple eligible CDI " + InstantiatorFactory.class.getSimpleName() + " beans.", (Throwable)e);
        }
        CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)bean);
        Context context = this.beanManager.getContext(ApplicationScoped.class);
        InstantiatorFactory instantiatorFactory = (InstantiatorFactory)context.get((Contextual)bean, creationalContext);
        Instantiator instantiator = instantiatorFactory.createInstantitor((VaadinService)this);
        if (instantiator == null) {
            throw new ServiceException("Cannot init VaadinService because " + Instantiator.class.getSimpleName() + " is null");
        }
        return Optional.of(instantiator);
    }

    public QuarkusVaadinServlet getServlet() {
        return (QuarkusVaadinServlet)super.getServlet();
    }

    private void addEventListeners() {
        this.addServiceDestroyListener(this::fireCdiDestroyEvent);
        this.addUIInitListener((UIInitListener & Serializable)event -> this.getBeanManager().getEvent().fire((Object)event));
        this.addSessionInitListener(this::sessionInit);
        this.addSessionDestroyListener(this::sessionDestroy);
    }

    private void sessionInit(SessionInitEvent sessionInitEvent) throws ServiceException {
        VaadinSession session = sessionInitEvent.getSession();
        this.lookup(ErrorHandler.class).ifPresent(arg_0 -> ((VaadinSession)session).setErrorHandler(arg_0));
        this.getBeanManager().getEvent().fire((Object)sessionInitEvent);
    }

    private void sessionDestroy(SessionDestroyEvent sessionDestroyEvent) {
        this.getBeanManager().getEvent().fire((Object)sessionDestroyEvent);
    }

    private void fireCdiDestroyEvent(ServiceDestroyEvent event) {
        try {
            this.beanManager.getEvent().fire((Object)event);
        }
        catch (Exception e) {
            QuarkusVaadinServletService.getLogger().warn("Error at destroy event distribution with CDI.", (Throwable)e);
        }
    }

    private void addUIListeners(UI ui) {
        ui.addAfterNavigationListener((AfterNavigationListener)this.uiEventListener);
        ui.addBeforeLeaveListener((BeforeLeaveListener)this.uiEventListener);
        ui.addBeforeEnterListener((BeforeEnterListener)this.uiEventListener);
        ui.addPollListener((ComponentEventListener)this.uiEventListener);
    }

    public <T> Optional<T> lookup(Class<T> type) throws ServiceException {
        try {
            T instance = new BeanLookup<T>(this.getBeanManager(), type, BeanLookup.SERVICE).lookup();
            return Optional.ofNullable(instance);
        }
        catch (AmbiguousResolutionException e) {
            throw new ServiceException("There are multiple eligible CDI " + type.getSimpleName() + " beans.", (Throwable)e);
        }
    }

    private BeanManager getBeanManager() {
        return this.beanManager;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(QuarkusVaadinServletService.class);
    }

    @ListenerPriority(value=-100)
    private static class UIEventListener
    implements AfterNavigationListener,
    BeforeEnterListener,
    BeforeLeaveListener,
    ComponentEventListener<PollEvent> {
        private BeanManager beanManager;

        UIEventListener(BeanManager beanManager) {
            this.beanManager = beanManager;
        }

        public void afterNavigation(AfterNavigationEvent event) {
            this.getBeanManager().getEvent().fire((Object)event);
        }

        public void beforeEnter(BeforeEnterEvent event) {
            this.getBeanManager().getEvent().fire((Object)event);
        }

        public void beforeLeave(BeforeLeaveEvent event) {
            this.getBeanManager().getEvent().fire((Object)event);
        }

        public void onComponentEvent(PollEvent event) {
            this.getBeanManager().getEvent().fire((Object)event);
        }

        private BeanManager getBeanManager() {
            return this.beanManager;
        }
    }
}

