/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus;

import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.di.InstantiatorFactory;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.quarkus.QuarkusInstantiator;
import com.vaadin.quarkus.QuarkusVaadinServletService;
import com.vaadin.quarkus.annotation.VaadinServiceEnabled;
import io.quarkus.arc.Unremovable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;

@VaadinServiceEnabled
@Unremovable
@ApplicationScoped
public class QuarkusInstantiatorFactory
implements InstantiatorFactory {
    @Inject
    BeanManager beanManager;

    public Instantiator createInstantitor(VaadinService vaadinService) {
        if (!this.getServiceClass().isAssignableFrom(vaadinService.getClass())) {
            return null;
        }
        DefaultInstantiator delegate = new DefaultInstantiator(vaadinService){

            protected ClassLoader getClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        return new QuarkusInstantiator(delegate, this.beanManager);
    }

    public Class<? extends VaadinService> getServiceClass() {
        return QuarkusVaadinServletService.class;
    }
}

