/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.context;

import com.vaadin.quarkus.context.ContextualInstanceInfo;
import com.vaadin.quarkus.context.ContextualStorage;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

public abstract class AbstractContext
implements InjectableContext {
    protected abstract ContextualStorage getContextualStorage(Contextual<?> var1, boolean var2);

    protected List<ContextualStorage> getActiveContextualStorages() {
        ArrayList<ContextualStorage> result = new ArrayList<ContextualStorage>();
        result.add(this.getContextualStorage(null, false));
        return result;
    }

    public <T> T get(Contextual<T> bean) {
        this.checkActive();
        ContextualStorage storage = this.getContextualStorage(bean, false);
        if (storage == null) {
            return null;
        }
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return null;
        }
        return (T)contextualInstanceInfo.getContextualInstance();
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object instance;
        if (creationalContext == null) {
            return this.get(bean);
        }
        this.checkActive();
        ContextualStorage storage = this.getContextualStorage(bean, true);
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo != null && (instance = contextualInstanceInfo.getContextualInstance()) != null) {
            return (T)instance;
        }
        return storage.createContextualInstance(bean, creationalContext);
    }

    public void destroy(Contextual<?> bean) {
        ContextualStorage storage = this.getContextualStorage(bean, false);
        if (storage == null) {
            return;
        }
        ContextualInstanceInfo<?> contextualInstanceInfo = storage.getStorage().remove(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return;
        }
        AbstractContext.destroyBean(bean, contextualInstanceInfo);
    }

    public void destroyAllActive() {
        List<ContextualStorage> storages = this.getActiveContextualStorages();
        if (storages == null) {
            return;
        }
        for (ContextualStorage storage : storages) {
            if (storage == null) continue;
            AbstractContext.destroyAllActive(storage);
        }
    }

    public static Map<Object, ContextualInstanceInfo<?>> destroyAllActive(ContextualStorage storage) {
        HashMap contextMap = new HashMap(storage.getStorage());
        storage.getStorage().clear();
        for (Map.Entry entry : contextMap.entrySet()) {
            Contextual<?> bean = storage.getBean(entry.getKey());
            ContextualInstanceInfo contextualInstanceInfo = (ContextualInstanceInfo)entry.getValue();
            AbstractContext.destroyBean(bean, contextualInstanceInfo);
        }
        return contextMap;
    }

    public void destroy() {
        this.destroyAllActive();
    }

    public InjectableContext.ContextState getState() {
        return this::getContextualInstances;
    }

    protected void checkActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }

    private Map<InjectableBean<?>, Object> getContextualInstances() {
        List<ContextualStorage> storages = this.getActiveContextualStorages();
        if (storages == null) {
            return Collections.emptyMap();
        }
        HashMap state = new HashMap();
        for (ContextualStorage storage : storages) {
            for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : storage.getStorage().entrySet()) {
                state.put((InjectableBean)storage.getBean(entry.getKey()), entry.getValue().getContextualInstance());
            }
        }
        return state;
    }

    public static void destroyBean(Contextual bean, ContextualInstanceInfo<?> contextualInstanceInfo) {
        bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
    }
}

