/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.quarkus.QuarkusVaadinServletService;
import java.io.IOException;
import java.util.Optional;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class QuarkusVaadinServlet
extends VaadinServlet {
    @Inject
    BeanManager beanManager;
    private static final ThreadLocal<Optional<String>> SERVLET_NAME = new ThreadLocal();

    protected VaadinServletService createServletService(DeploymentConfiguration configuration) throws ServiceException {
        QuarkusVaadinServletService service = new QuarkusVaadinServletService(this, configuration, this.beanManager);
        service.init();
        return service;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        SERVLET_NAME.set(Optional.of(servletConfig.getServletName()));
        try {
            super.init(servletConfig);
        }
        finally {
            SERVLET_NAME.set(Optional.empty());
        }
    }

    public void destroy() {
        super.destroy();
        SERVLET_NAME.remove();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SERVLET_NAME.set(Optional.of(this.getServletName()));
        try {
            super.service(request, response);
        }
        finally {
            SERVLET_NAME.set(Optional.empty());
        }
    }

    public static Optional<String> getCurrentServletName() {
        return SERVLET_NAME.get();
    }
}

