/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.context;

import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.quarkus.annotation.NormalUIScoped;
import com.vaadin.quarkus.annotation.VaadinSessionScoped;
import com.vaadin.quarkus.context.AbstractContext;
import com.vaadin.quarkus.context.AbstractContextualStorageManager;
import com.vaadin.quarkus.context.BeanProvider;
import com.vaadin.quarkus.context.ContextualStorage;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.Unremovable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.BeanManager;

public class UIScopedContext
extends AbstractContext {
    @Override
    protected ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        return BeanProvider.getContextualReference(this.getBeanManager(), ContextualStorageManager.class, false, new Annotation[0]).getContextualStorage(createIfNotExist);
    }

    public Class<? extends Annotation> getScope() {
        return NormalUIScoped.class;
    }

    public boolean isActive() {
        return VaadinSession.getCurrent() != null && UI.getCurrent() != null;
    }

    BeanManager getBeanManager() {
        return Arc.container().beanManager();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public InjectableContext.ContextState getState() {
        return super.getState();
    }

    @VaadinSessionScoped
    @Unremovable
    public static class ContextualStorageManager
    extends AbstractContextualStorageManager<Integer> {
        public ContextualStorageManager() {
            super(false);
        }

        public ContextualStorage getContextualStorage(boolean createIfNotExist) {
            Integer uiId = UI.getCurrent().getUIId();
            return super.getContextualStorage(uiId, createIfNotExist);
        }

        @Override
        protected ContextualStorage newContextualStorage(Integer uiId) {
            UI.getCurrent().addDetachListener(this::destroy);
            return super.newContextualStorage(uiId);
        }

        @Override
        private void destroy(DetachEvent event) {
            int uiId = event.getUI().getUIId();
            super.destroy(uiId);
        }
    }
}

