/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.context;

import com.vaadin.quarkus.context.ContextualInstanceInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

public class ContextualStorage
implements Serializable {
    private final Map<Object, ContextualInstanceInfo<?>> contextualInstances;
    private final boolean concurrent;

    public ContextualStorage(boolean concurrent) {
        this.concurrent = concurrent;
        this.contextualInstances = concurrent ? new ConcurrentHashMap() : new HashMap();
    }

    public Map<Object, ContextualInstanceInfo<?>> getStorage() {
        return this.contextualInstances;
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T createContextualInstance(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object beanKey = this.getBeanKey(bean);
        if (this.isConcurrent()) {
            ConcurrentHashMap concurrentMap = (ConcurrentHashMap)this.contextualInstances;
            ContextualInstanceInfo<T> instanceInfo = new ContextualInstanceInfo<T>();
            ContextualInstanceInfo oldInstanceInfo = concurrentMap.putIfAbsent(beanKey, instanceInfo);
            if (oldInstanceInfo != null) {
                instanceInfo = oldInstanceInfo;
            }
            ContextualInstanceInfo<T> contextualInstanceInfo = instanceInfo;
            synchronized (contextualInstanceInfo) {
                Object instance = instanceInfo.getContextualInstance();
                if (instance == null) {
                    instance = bean.create(creationalContext);
                    instanceInfo.setContextualInstance(instance);
                    instanceInfo.setCreationalContext(creationalContext);
                }
                return instance;
            }
        }
        ContextualInstanceInfo<Object> instanceInfo = new ContextualInstanceInfo<Object>();
        instanceInfo.setCreationalContext(creationalContext);
        instanceInfo.setContextualInstance(bean.create(creationalContext));
        this.contextualInstances.put(beanKey, instanceInfo);
        return instanceInfo.getContextualInstance();
    }

    public <T> Object getBeanKey(Contextual<T> bean) {
        return bean;
    }

    public Contextual<?> getBean(Object beanKey) {
        return (Contextual)beanKey;
    }
}

