/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.context;

import com.vaadin.flow.server.ServiceDestroyEvent;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.quarkus.QuarkusVaadinServlet;
import com.vaadin.quarkus.annotation.VaadinServiceScoped;
import com.vaadin.quarkus.context.AbstractContext;
import com.vaadin.quarkus.context.AbstractContextualStorageManager;
import com.vaadin.quarkus.context.BeanProvider;
import com.vaadin.quarkus.context.ContextualStorage;
import io.quarkus.arc.Arc;
import io.quarkus.arc.Unremovable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;

public class VaadinServiceScopedContext
extends AbstractContext {
    @Override
    protected ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        QuarkusVaadinServlet servlet = (QuarkusVaadinServlet)VaadinServlet.getCurrent();
        String servletName = servlet != null ? servlet.getServletName() : QuarkusVaadinServlet.getCurrentServletName().get();
        return BeanProvider.getContextualReference(Arc.container().beanManager(), ContextualStorageManager.class, false, new Annotation[0]).getContextualStorage(servletName, createIfNotExist);
    }

    public Class<? extends Annotation> getScope() {
        return VaadinServiceScoped.class;
    }

    public boolean isActive() {
        VaadinServlet servlet = VaadinServlet.getCurrent();
        return servlet instanceof QuarkusVaadinServlet || servlet == null && QuarkusVaadinServlet.getCurrentServletName() != null;
    }

    @ApplicationScoped
    @Unremovable
    public static class ContextualStorageManager
    extends AbstractContextualStorageManager<String> {
        public ContextualStorageManager() {
            super(true);
        }

        private void onServiceDestroy(@Observes(notifyObserver=Reception.IF_EXISTS) ServiceDestroyEvent event) {
            if (!(event.getSource() instanceof VaadinServletService)) {
                return;
            }
            VaadinServletService service = (VaadinServletService)event.getSource();
            String servletName = service.getServlet().getServletName();
            this.destroy(servletName);
        }
    }
}

