/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.context;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.quarkus.annotation.NormalRouteScoped;
import com.vaadin.quarkus.annotation.NormalUIScoped;
import com.vaadin.quarkus.annotation.RouteScopeOwner;
import com.vaadin.quarkus.annotation.VaadinSessionScoped;
import com.vaadin.quarkus.context.AbstractContext;
import com.vaadin.quarkus.context.AbstractContextualStorageManager;
import com.vaadin.quarkus.context.BeanProvider;
import com.vaadin.quarkus.context.ContextualStorage;
import io.quarkus.arc.Arc;
import io.quarkus.arc.Unremovable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;

public class RouteScopedContext
extends AbstractContext {
    public Class<? extends Annotation> getScope() {
        return NormalRouteScoped.class;
    }

    public boolean isActive() {
        return Arc.container().getActiveContext(NormalUIScoped.class).isActive();
    }

    @Override
    protected ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        RouteStorageKey key = this.convertToKey(contextual);
        return this.getStorageManager().getContextualStorage(key, createIfNotExist);
    }

    @Override
    protected List<ContextualStorage> getActiveContextualStorages() {
        return this.getStorageManager().getActiveContextualStorages();
    }

    BeanManager getBeanManager() {
        return Arc.container().beanManager();
    }

    Class<? extends ContextualStorageManager> getContextualStorageManagerClass() {
        return RouteContextualStorageManager.class;
    }

    private RouteStorageKey convertToKey(Contextual<?> contextual) {
        Class<?> owner;
        Bean<?> bean = this.getBean(contextual);
        UI ui = UI.getCurrent();
        if (!this.navigationChainHasOwner(ui, owner = this.getOwner(ui, bean))) {
            throw new IllegalStateException(String.format("Route owner '%s' instance is not available in the active navigation components chain: the scope defined by the bean '%s' doesn't exist.", owner, bean.getBeanClass().getName()));
        }
        return this.getStorageManager().getKey(ui, owner);
    }

    private boolean navigationChainHasOwner(UI ui, Class<?> owner) {
        NavigationData data = (NavigationData)ComponentUtil.getData((Component)ui, NavigationData.class);
        if (owner.equals(data.getNavigationTarget())) {
            return true;
        }
        return data.getLayouts().stream().anyMatch(clazz -> clazz.equals(owner));
    }

    private Class<?> getOwner(UI ui, Bean<?> bean) {
        return bean.getQualifiers().stream().filter(annotation -> annotation instanceof RouteScopeOwner).map(annotation -> ((RouteScopeOwner)annotation).value()).findFirst().orElseGet(() -> this.getCurrentNavigationTarget(ui, bean));
    }

    private Class getCurrentNavigationTarget(UI ui, Bean<?> bean) {
        NavigationData data = (NavigationData)ComponentUtil.getData((Component)ui, NavigationData.class);
        if (data == null) {
            throw new IllegalStateException(String.format("There is no yet any navigation chain available, so bean '%s' has no scope and may not be injected", bean.getBeanClass().getName()));
        }
        return data.getNavigationTarget();
    }

    private ContextualStorageManager getStorageManager() {
        return BeanProvider.getContextualReference(this.getBeanManager(), this.getContextualStorageManagerClass(), false, new Annotation[0]);
    }

    private Bean<?> getBean(Contextual<?> contextual) {
        if (contextual instanceof Bean) {
            return (Bean)contextual;
        }
        throw new IllegalArgumentException(contextual.getClass().getName() + " is not of type " + Bean.class.getName());
    }

    static class NavigationData {
        private final Class<?> navigationTarget;
        private final List<Class<? extends RouterLayout>> layouts;

        NavigationData(Class<?> navigationTarget, List<Class<? extends RouterLayout>> layouts) {
            this.navigationTarget = navigationTarget;
            this.layouts = layouts;
        }

        Class<?> getNavigationTarget() {
            return this.navigationTarget;
        }

        List<Class<? extends RouterLayout>> getLayouts() {
            return this.layouts;
        }
    }

    static class RouteStorageKey
    implements Serializable {
        private final Class<?> owner;
        private final String uiId;

        private RouteStorageKey(Class<?> owner, String uiId) {
            this.owner = owner;
            this.uiId = uiId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RouteStorageKey)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            RouteStorageKey key = (RouteStorageKey)obj;
            return this.owner.equals(key.owner) && this.uiId.equals(key.uiId);
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.uiId);
        }

        public String toString() {
            return "[ ui-key='" + this.getUIId() + "', owner='" + this.getOwner() + "' ]";
        }

        Class<?> getOwner() {
            return this.owner;
        }

        String getUIId() {
            return this.uiId;
        }
    }

    @VaadinSessionScoped
    @Unremovable
    private static class RouteContextualStorageManager
    extends ContextualStorageManager {
        private RouteContextualStorageManager() {
        }
    }

    public static abstract class ContextualStorageManager
    extends AbstractContextualStorageManager<RouteStorageKey> {
        public ContextualStorageManager() {
            super(false);
        }

        @Override
        protected ContextualStorage newContextualStorage(RouteStorageKey key) {
            UI.getCurrent().addDetachListener((ComponentEventListener & Serializable)event -> this.handleUIDetach(event.getUI(), key));
            return super.newContextualStorage(key);
        }

        private void onAfterNavigation(@Observes(notifyObserver=Reception.IF_EXISTS) AfterNavigationEvent event) {
            Set<Class<?>> activeChain = event.getActiveChain().stream().map(Object::getClass).collect(Collectors.toSet());
            this.destroyDescopedBeans(event.getLocationChangeEvent().getUI(), activeChain);
        }

        private void onBeforeEnter(@Observes BeforeEnterEvent event) {
            UI ui = event.getUI();
            ComponentUtil.setData((Component)ui, NavigationData.class, (Object)new NavigationData(event.getNavigationTarget(), event.getLayouts()));
            HashSet activeChain = new HashSet();
            activeChain.add(event.getNavigationTarget());
            activeChain.addAll(event.getLayouts());
            this.destroyDescopedBeans(ui, activeChain);
        }

        private void destroyDescopedBeans(UI ui, Set<Class<?>> navigationChain) {
            String uiStoreId = this.getUIStoreId(ui);
            Set<RouteStorageKey> missingKeys = this.getKeySet().stream().filter(key -> key.getUIId().equals(uiStoreId)).filter(key -> !navigationChain.contains(key.getOwner())).collect(Collectors.toSet());
            missingKeys.forEach(this::destroy);
        }

        private void handleUIDetach(UI ui, RouteStorageKey key) {
            UI uiAfterRefresh = this.findPreservingUI(ui);
            if (uiAfterRefresh == null) {
                this.destroy(key);
            } else {
                uiAfterRefresh.addDetachListener((ComponentEventListener & Serializable)event -> this.handleUIDetach(event.getUI(), key));
            }
        }

        private UI findPreservingUI(UI ui) {
            VaadinSession session = ui.getSession();
            String windowName = ContextualStorageManager.getWindowName(ui);
            for (UI sessionUi : session.getUIs()) {
                if (sessionUi == ui || windowName == null || !windowName.equals(ContextualStorageManager.getWindowName(sessionUi))) continue;
                return sessionUi;
            }
            return null;
        }

        private static String getWindowName(UI ui) {
            ExtendedClientDetails details = ui.getInternals().getExtendedClientDetails();
            if (details == null) {
                return null;
            }
            return details.getWindowName();
        }

        private RouteStorageKey getKey(UI ui, Class<?> owner) {
            ExtendedClientDetails details = ui.getInternals().getExtendedClientDetails();
            RouteStorageKey key = new RouteStorageKey(owner, this.getUIStoreId(ui));
            if (details == null) {
                ui.getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)det -> this.relocate(ui, key));
            }
            return key;
        }

        @Override
        private void relocate(UI ui, RouteStorageKey key) {
            this.relocate(key, new RouteStorageKey(key.getOwner(), this.getUIStoreId(ui)));
        }

        private String getUIStoreId(UI ui) {
            ExtendedClientDetails details = ui.getInternals().getExtendedClientDetails();
            if (details == null) {
                return "uid-" + ui.getUIId();
            }
            return "win-" + ContextualStorageManager.getWindowName(ui);
        }

        private List<ContextualStorage> getActiveContextualStorages() {
            return this.getKeySet().stream().filter(key -> key.getUIId().equals(this.getUIStoreId(UI.getCurrent()))).map(key -> this.getContextualStorage(key, false)).collect(Collectors.toList());
        }
    }
}

