/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.context;

import io.quarkus.arc.Arc;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;

@Typed
public abstract class ContextUtils {
    private ContextUtils() {
    }

    public static boolean isContextActive(Class<? extends Annotation> scopeAnnotationClass) {
        return ContextUtils.isContextActive(scopeAnnotationClass, Arc.container().beanManager());
    }

    public static boolean isContextActive(Class<? extends Annotation> scopeAnnotationClass, BeanManager beanManager) {
        try {
            if (beanManager.getContext(scopeAnnotationClass) == null || !beanManager.getContext(scopeAnnotationClass).isActive()) {
                return false;
            }
        }
        catch (ContextNotActiveException e) {
            return false;
        }
        return true;
    }
}

