/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.deployment.nativebuild;

import com.vaadin.flow.server.communication.PushRequestHandler;
import com.vaadin.quarkus.deployment.nativebuild.InjectableObjectFactoryFieldUsageRemovalMethodVisitor;
import com.vaadin.quarkus.graal.AtmosphereDeferredInitializer;
import com.vaadin.quarkus.graal.AtmosphereServletConfig;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.ClassTransformer;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletConnection;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.inject.InjectableObjectFactory;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class AtmospherePatches {
    static final DotName EXECUTORS_FACTORY = DotName.createSimple((String)"org.atmosphere.util.ExecutorsFactory");
    static final DotName DELAYED_EXECUTORS_FACTORY = DotName.createSimple((String)"com.vaadin.quarkus.graal.DelayedSchedulerExecutorsFactory");
    private final IndexView index;

    public AtmospherePatches(IndexView index) {
        this.index = index;
    }

    public void apply(BuildProducer<BytecodeTransformerBuildItem> producer) {
        producer.produce((BuildItem)new BytecodeTransformerBuildItem(EXECUTORS_FACTORY.toString(), this.patchAtmosphereExecutorsFactory()));
        producer.produce((BuildItem)new BytecodeTransformerBuildItem(DELAYED_EXECUTORS_FACTORY.toString(), this.patchDelayedSchedulerExecutorsFactory()));
        producer.produce((BuildItem)new BytecodeTransformerBuildItem(AtmosphereFramework.class.getName(), this.patchAtmosphereFramework()));
        producer.produce((BuildItem)new BytecodeTransformerBuildItem(InjectableObjectFactory.class.getName(), this.patchInjectableObjectFactory()));
        producer.produce((BuildItem)new BytecodeTransformerBuildItem("org.atmosphere.cpr.AtmosphereRequest", this.patchHttpServletRequest()));
        producer.produce((BuildItem)new BytecodeTransformerBuildItem("org.atmosphere.cpr.AtmosphereRequestImpl", this.patchHttpServletRequest()));
        producer.produce((BuildItem)new BytecodeTransformerBuildItem("org.atmosphere.cpr.AtmosphereRequestImpl$NoOpsRequest", this.patchHttpServletRequest()));
        producer.produce((BuildItem)new BytecodeTransformerBuildItem("org.atmosphere.cpr.AtmosphereResponse", this.patchHttpServletResponse()));
        producer.produce((BuildItem)new BytecodeTransformerBuildItem("org.atmosphere.cpr.AtmosphereResponseImpl", this.patchHttpServletResponse()));
        producer.produce((BuildItem)new BytecodeTransformerBuildItem("org.atmosphere.util.FakeHttpSession", this.patchHttpSession()));
        producer.produce((BuildItem)new BytecodeTransformerBuildItem(PushRequestHandler.class.getName(), this.patchPushRequestHandler()));
    }

    private BiFunction<String, ClassVisitor, ClassVisitor> patchAtmosphereExecutorsFactory() {
        return (className, classVisitor) -> {
            ClassInfo classInfo = this.index.getClassByName(EXECUTORS_FACTORY);
            ClassTransformer transformer = new ClassTransformer(EXECUTORS_FACTORY.toString());
            MethodInfo getSchedulerMethod = classInfo.method("getScheduler", new Type[]{Type.create((DotName)DotName.createSimple(AtmosphereConfig.class), (Type.Kind)Type.Kind.CLASS)});
            transformer.modifyMethod(MethodDescriptor.of((MethodInfo)getSchedulerMethod)).rename("getScheduler_original");
            try (MethodCreator creator = transformer.addMethod(MethodDescriptor.of((MethodInfo)getSchedulerMethod));){
                creator.setModifiers(9);
                creator.returnValue(creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)DELAYED_EXECUTORS_FACTORY.toString(), (String)"getScheduler", ScheduledExecutorService.class, (Object[])new Object[]{AtmosphereConfig.class}), new ResultHandle[]{creator.getMethodParam(0)}));
            }
            return transformer.applyTo(classVisitor);
        };
    }

    private BiFunction<String, ClassVisitor, ClassVisitor> patchDelayedSchedulerExecutorsFactory() {
        return (className, classVisitor) -> {
            ClassInfo classInfo = this.index.getClassByName(DELAYED_EXECUTORS_FACTORY);
            ClassTransformer transformer = new ClassTransformer(EXECUTORS_FACTORY.toString());
            MethodInfo newSchedulerMethod = classInfo.method("newScheduler", new Type[]{Type.create((DotName)DotName.createSimple(AtmosphereConfig.class), (Type.Kind)Type.Kind.CLASS)});
            transformer.removeMethod(MethodDescriptor.of((MethodInfo)newSchedulerMethod));
            try (MethodCreator creator = transformer.addMethod(MethodDescriptor.of((MethodInfo)newSchedulerMethod));){
                creator.setModifiers(10);
                creator.returnValue(creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)EXECUTORS_FACTORY.toString(), (String)"getScheduler_original", ScheduledExecutorService.class, (Object[])new Object[]{AtmosphereConfig.class}), new ResultHandle[]{creator.getMethodParam(0)}));
            }
            return transformer.applyTo(classVisitor);
        };
    }

    private BiFunction<String, ClassVisitor, ClassVisitor> patchAtmosphereFramework() {
        return (className, classVisitor) -> {
            ClassInfo classInfo = this.index.getClassByName(className);
            ClassTransformer transformer = new ClassTransformer(className);
            MethodInfo info = classInfo.method("info", new Type[0]);
            transformer.removeMethod(MethodDescriptor.of((MethodInfo)info));
            try (MethodCreator creator = transformer.addMethod(MethodDescriptor.of((MethodInfo)info));){
                creator.setModifiers(2);
                creator.returnValue(null);
            }
            return transformer.applyTo(classVisitor);
        };
    }

    private BiFunction<String, ClassVisitor, ClassVisitor> patchPushRequestHandler() {
        return (className, classVisitor) -> {
            ClassInfo classInfo = this.index.getClassByName(className);
            ClassTransformer transformer = new ClassTransformer(className);
            MethodInfo initAtmosphereMethod = classInfo.method("initAtmosphere", new Type[]{Type.create(ServletConfig.class)});
            transformer.modifyMethod(MethodDescriptor.of((MethodInfo)initAtmosphereMethod)).rename("initAtmosphere_original");
            try (MethodCreator creator = transformer.addMethod(MethodDescriptor.of((MethodInfo)initAtmosphereMethod));){
                creator.setModifiers(8);
                AssignableResultHandle configWrapper = creator.createVariable(AtmosphereServletConfig.class);
                creator.assign(configWrapper, creator.newInstance(MethodDescriptor.ofMethod(AtmosphereServletConfig.class, (String)"<init>", Void.TYPE, (Class[])new Class[]{ServletConfig.class}), new ResultHandle[]{creator.getMethodParam(0)}));
                AssignableResultHandle framework = creator.createVariable(AtmosphereFramework.class);
                creator.assign(framework, creator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)initAtmosphereMethod.declaringClass().name().toString(), (String)"initAtmosphere_original", AtmosphereFramework.class, (Object[])new Object[]{ServletConfig.class}), new ResultHandle[]{configWrapper}));
                creator.invokeStaticMethod(MethodDescriptor.ofMethod(AtmosphereDeferredInitializer.class, (String)"register", Void.TYPE, (Class[])new Class[]{ServletConfig.class, AtmosphereFramework.class}), new ResultHandle[]{creator.getMethodParam(0), framework});
                creator.returnValue((ResultHandle)framework);
            }
            return transformer.applyTo(classVisitor);
        };
    }

    private BiFunction<String, ClassVisitor, ClassVisitor> patchInjectableObjectFactory() {
        return (className, classVisitor) -> {
            ClassTransformer transformer = new ClassTransformer(className);
            transformer.removeField("injectableServiceLoader", ServiceLoader.class);
            return new ClassVisitor(this, 589824, transformer.applyTo(classVisitor)){

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                    if ("<init>".equals(name) || "configure".equals(name)) {
                        return new InjectableObjectFactoryFieldUsageRemovalMethodVisitor(mv, access, name, descriptor, signature, exceptions);
                    }
                    return mv;
                }
            };
        };
    }

    private BiFunction<String, ClassVisitor, ClassVisitor> patchHttpServletRequest() {
        return (className, classVisitor) -> {
            MethodCreator creator;
            ClassInfo classInfo = this.index.getClassByName(className);
            ClassTransformer transformer = new ClassTransformer(className);
            AtmospherePatches.removeMethod(transformer, classInfo, "getRealPath", String.class, String.class);
            AtmospherePatches.removeMethod(transformer, classInfo, "isRequestedSessionIdFromUrl", Boolean.TYPE, new Class[0]);
            if (classInfo.method("getRequestId", new Type[0]) == null) {
                creator = transformer.addMethod("getRequestId", String.class, new Object[0]);
                try {
                    creator.returnNull();
                }
                finally {
                    if (creator != null) {
                        creator.close();
                    }
                }
            }
            if (classInfo.method("getProtocolRequestId", new Type[0]) == null) {
                creator = transformer.addMethod("getProtocolRequestId", String.class, new Object[0]);
                try {
                    creator.returnNull();
                }
                finally {
                    if (creator != null) {
                        creator.close();
                    }
                }
            }
            if (classInfo.method("getServletConnection", new Type[0]) == null) {
                creator = transformer.addMethod("getServletConnection", ServletConnection.class, new Object[0]);
                try {
                    creator.returnNull();
                }
                finally {
                    if (creator != null) {
                        creator.close();
                    }
                }
            }
            return transformer.applyTo(classVisitor);
        };
    }

    private BiFunction<String, ClassVisitor, ClassVisitor> patchHttpServletResponse() {
        return (className, classVisitor) -> {
            ClassInfo classInfo = this.index.getClassByName(className);
            ClassTransformer transformer = new ClassTransformer(className);
            AtmospherePatches.removeMethod(transformer, classInfo, "encodeUrl", String.class, String.class);
            AtmospherePatches.removeMethod(transformer, classInfo, "encodeRedirectUrl", String.class, String.class);
            AtmospherePatches.removeMethod(transformer, classInfo, "setStatus", Void.TYPE, Integer.TYPE, String.class);
            if ("org.atmosphere.cpr.AtmosphereResponseImpl".equals(className)) {
                try (MethodCreator creator = transformer.addMethod("setStatus", Void.TYPE, new Object[]{Integer.TYPE, String.class});){
                    creator.invokeVirtualMethod(MethodDescriptor.ofMethod((String)className, (String)"setStatus", (String)"V", (String[])new String[]{"I"}), creator.getThis(), new ResultHandle[]{creator.getMethodParam(0)});
                    creator.returnValue(null);
                }
            }
            return transformer.applyTo(classVisitor);
        };
    }

    private static void removeMethod(ClassTransformer transformer, ClassInfo classInfo, String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        if (classInfo.method(methodName, Arrays.stream(parameterTypes).map(Type::create).toList()) != null) {
            transformer.removeMethod(methodName, returnType, (Object[])parameterTypes);
        }
    }

    private BiFunction<String, ClassVisitor, ClassVisitor> patchHttpSession() {
        return (className, classVisitor) -> {
            ClassInfo classInfo = this.index.getClassByName(className);
            ClassTransformer transformer = new ClassTransformer(className);
            if (classInfo.method("getSessionContext", new Type[0]) != null) {
                transformer.removeMethod("getSessionContext", (Object)"jakarta.servlet.http.HttpSessionContext", new Object[0]);
            }
            AtmospherePatches.removeMethod(transformer, classInfo, "getValue", Object.class, String.class);
            AtmospherePatches.removeMethod(transformer, classInfo, "getValueNames", String[].class, new Class[0]);
            AtmospherePatches.removeMethod(transformer, classInfo, "putValue", Void.TYPE, String.class, Object.class);
            AtmospherePatches.removeMethod(transformer, classInfo, "removeValue", Void.TYPE, String.class);
            return transformer.applyTo(classVisitor);
        };
    }
}

