/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.deployment;

import java.util.HashSet;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

class TypeInspector {
    TypeInspector() {
    }

    static Set<ClassInfo> collectTypes(Type type, IndexView index) {
        HashSet<ClassInfo> concreteTypes = new HashSet<ClassInfo>();
        HashSet<Type> visited = new HashSet<Type>();
        TypeInspector.collectConcreteTypes(type, index, concreteTypes, visited);
        return concreteTypes;
    }

    static Set<ClassInfo> collectTypes(MethodInfo methodInfo, IndexView index) {
        HashSet<ClassInfo> concreteTypes = new HashSet<ClassInfo>();
        HashSet<Type> visited = new HashSet<Type>();
        TypeInspector.collectConcreteTypesFromMethod(methodInfo, index, concreteTypes, visited);
        return concreteTypes;
    }

    private static void collectConcreteTypesFromMethod(MethodInfo methodInfo, IndexView index, Set<ClassInfo> concreteTypes, Set<Type> visited) {
        TypeInspector.collectConcreteTypes(methodInfo.returnType(), index, concreteTypes, visited);
        for (Type paramType : methodInfo.parameterTypes()) {
            TypeInspector.collectConcreteTypes(paramType, index, concreteTypes, visited);
        }
    }

    private static void collectConcreteTypes(Type type, IndexView index, Set<ClassInfo> collector, Set<Type> visited) {
        if (type == null) {
            return;
        }
        if (visited.contains(type)) {
            return;
        }
        switch (type.kind()) {
            case PRIMITIVE: 
            case VOID: {
                break;
            }
            case CLASS: {
                ClassInfo classInfo = index.getClassByName(type.name());
                if (classInfo == null) break;
                collector.add(classInfo);
                break;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType paramType = type.asParameterizedType();
                TypeInspector.collectConcreteTypes(paramType.owner(), index, collector, visited);
                for (Type arg : paramType.arguments()) {
                    TypeInspector.collectConcreteTypes(arg, index, collector, visited);
                }
                break;
            }
            case TYPE_VARIABLE: {
                TypeVariable typeVar = type.asTypeVariable();
                for (Type bound : typeVar.bounds()) {
                    TypeInspector.collectConcreteTypes(bound, index, collector, visited);
                }
                break;
            }
            case ARRAY: {
                TypeInspector.collectConcreteTypes(type.asArrayType().component(), index, collector, visited);
                break;
            }
            case WILDCARD_TYPE: {
                Type superBound;
                Type extendsBound = type.asWildcardType().extendsBound();
                if (extendsBound != null) {
                    TypeInspector.collectConcreteTypes(extendsBound, index, collector, visited);
                }
                if ((superBound = type.asWildcardType().superBound()) == null) break;
                TypeInspector.collectConcreteTypes(superBound, index, collector, visited);
                break;
            }
        }
    }
}

