/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.deployment.vaadinplugin;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.base.PluginAdapterBuild;
import com.vaadin.flow.server.frontend.BundleValidationUtil;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskCleanFrontendFiles;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.MissingLicenseKeyException;
import com.vaadin.quarkus.deployment.vaadinplugin.QuarkusPluginAdapter;
import com.vaadin.quarkus.deployment.vaadinplugin.VaadinBuildTimeConfig;
import com.vaadin.quarkus.deployment.vaadinplugin.WorkspaceInfo;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.builder.BuildException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public final class VaadinPlugin {
    private final QuarkusPluginAdapter pluginAdapter;
    private final TaskCleanFrontendFiles cleanTask;

    private VaadinPlugin(VaadinBuildTimeConfig vaadinConfig, ApplicationModel applicationModel, WorkspaceModule workspaceModule) {
        this.pluginAdapter = new QuarkusPluginAdapter(vaadinConfig, applicationModel, workspaceModule);
        this.cleanTask = this.createCleanFrontendFilesTask(this.pluginAdapter);
    }

    public static VaadinPlugin of(VaadinBuildTimeConfig vaadinConfig, ApplicationModel applicationModel, Path outputTarget) throws BuildException {
        WorkspaceModule module = applicationModel.getApplicationModule();
        if (module == null) {
            try {
                module = WorkspaceInfo.load(outputTarget);
            }
            catch (Exception e) {
                throw new BuildException("Cannot load workspace information for Vaadin plugin. quarkus.bootstrap.workspace-discovery=true might be required.", (Throwable)e, List.of());
            }
        }
        return new VaadinPlugin(vaadinConfig, applicationModel, module);
    }

    public void prepareFrontend() throws BuildException {
        BuildFrontendUtil.propagateBuildInfo((PluginAdapterBase)this.pluginAdapter);
        try {
            BuildFrontendUtil.prepareFrontend((PluginAdapterBase)this.pluginAdapter);
        }
        catch (Exception exception) {
            throw new BuildException("Could not execute prepare-frontend goal.", (Throwable)exception, List.of());
        }
    }

    public void buildFrontend(BiConsumer<String, byte[]> emitter) throws BuildException {
        boolean commercialBannerRequired;
        boolean licenseRequired;
        long start = System.nanoTime();
        FrontendDependenciesScanner frontendDependencies = this.createFrontendScanner();
        try {
            BuildFrontendUtil.runNodeUpdater((PluginAdapterBuild)this.pluginAdapter, (FrontendDependenciesScanner)frontendDependencies);
        }
        catch (ExecutionFailedException | URISyntaxException exception) {
            throw new BuildException("Could not execute build-frontend goal", exception, List.of());
        }
        if (this.pluginAdapter.generateBundle() && BundleValidationUtil.needsBundleBuild((File)this.pluginAdapter.servletResourceOutputDirectory())) {
            try {
                BuildFrontendUtil.runFrontendBuild((PluginAdapterBase)this.pluginAdapter);
            }
            catch (URISyntaxException | TimeoutException exception) {
                throw new BuildException(exception.getMessage(), (Throwable)exception, List.of());
            }
        }
        LicenseChecker.setStrictOffline((boolean)true);
        try {
            licenseRequired = BuildFrontendUtil.validateLicenses((PluginAdapterBase)this.pluginAdapter, (FrontendDependenciesScanner)frontendDependencies);
            commercialBannerRequired = false;
        }
        catch (MissingLicenseKeyException ex) {
            licenseRequired = true;
            commercialBannerRequired = true;
            this.pluginAdapter.logInfo(ex.getMessage());
        }
        BuildFrontendUtil.updateBuildFile((PluginAdapterBuild)this.pluginAdapter, (boolean)licenseRequired, (boolean)commercialBannerRequired);
        long ms = (System.nanoTime() - start) / 1000000L;
        this.pluginAdapter.logInfo("Build frontend completed in " + ms + " ms.");
        this.emitGeneratedFiles(emitter);
    }

    private void emitGeneratedFiles(BiConsumer<String, byte[]> emitter) throws BuildException {
        block9: {
            Path vaadinMetaInfDir = this.pluginAdapter.servletResourceOutputDirectory().toPath();
            Path buildFolder = this.pluginAdapter.buildDir();
            if (Files.exists(vaadinMetaInfDir, new LinkOption[0])) {
                try (Stream<Path> stream = Files.walk(vaadinMetaInfDir, new FileVisitOption[0]);){
                    stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(filePath -> {
                        try {
                            Path relativePath = buildFolder.relativize((Path)filePath);
                            byte[] content = Files.readAllBytes(filePath);
                            emitter.accept(relativePath.toString().replace('\\', '/'), content);
                            this.pluginAdapter.logDebug("Added Vaadin resource: " + String.valueOf(relativePath));
                        }
                        catch (IOException e) {
                            this.pluginAdapter.logWarn("Failed to read Vaadin resource file: " + String.valueOf(filePath), e);
                        }
                    });
                    this.pluginAdapter.logInfo("Added Vaadin frontend resources from META-INF/VAADIN to artifact");
                    break block9;
                }
                catch (IOException e) {
                    throw new BuildException("Failed to scan Vaadin resources directory", (Throwable)e, List.of());
                }
            }
            this.pluginAdapter.logInfo("No META-INF/VAADIN directory found, skipping resource addition");
        }
    }

    public void clean() {
        if (this.cleanTask != null) {
            try {
                this.cleanTask.execute();
            }
            catch (ExecutionFailedException exception) {
                this.pluginAdapter.logError("Error cleaning frontend files", exception);
            }
        }
    }

    private TaskCleanFrontendFiles createCleanFrontendFilesTask(QuarkusPluginAdapter pluginAdapter) {
        if (pluginAdapter.cleanFrontendFiles()) {
            Options options = new Options(null, pluginAdapter.getClassFinder(), pluginAdapter.npmFolder()).withFrontendDirectory(pluginAdapter.frontendDirectory()).withFrontendGeneratedFolder(pluginAdapter.generatedTsFolder());
            return new TaskCleanFrontendFiles(options);
        }
        return null;
    }

    private FrontendDependenciesScanner createFrontendScanner() {
        boolean reactEnabled = this.pluginAdapter.isReactEnabled() && FrontendUtils.isReactRouterRequired((File)BuildFrontendUtil.getFrontendDirectory((PluginAdapterBase)this.pluginAdapter));
        ClassFinder classFinder = this.pluginAdapter.getClassFinder();
        FeatureFlags featureFlags = new FeatureFlags(this.pluginAdapter.createLookup(classFinder));
        if (this.pluginAdapter.javaResourceFolder() != null) {
            featureFlags.setPropertiesLocation(this.pluginAdapter.javaResourceFolder());
        }
        return new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(!this.pluginAdapter.optimizeBundle(), classFinder, this.pluginAdapter.generateEmbeddableWebComponents(), featureFlags, reactEnabled);
    }
}

