/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.deployment.vaadinplugin;

import com.vaadin.flow.internal.JacksonUtils;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;

class WorkspaceInfo {
    WorkspaceInfo() {
    }

    static void save(WorkspaceModule module, Path workDir) throws Exception {
        Path projectInfoFile = WorkspaceInfo.resolveProjectInfoFile(workDir);
        ProjectInfo info = WorkspaceInfo.collectWorkspaceInfo(module);
        Files.writeString(projectInfoFile, (CharSequence)JacksonUtils.getMapper().writeValueAsString((Object)info), StandardOpenOption.CREATE);
    }

    static WorkspaceModule load(Path workDir) throws Exception {
        Path projectInfoFile = WorkspaceInfo.resolveProjectInfoFile(workDir);
        if (Files.exists(projectInfoFile, new LinkOption[0])) {
            ProjectInfo info = (ProjectInfo)JacksonUtils.getMapper().readValue(projectInfoFile.toFile(), ProjectInfo.class);
            return WorkspaceModule.builder().setModuleId(info.moduleId()).setModuleDir(Path.of(info.moduleDir(), new String[0])).setBuildDir(Path.of(info.buildDir(), new String[0])).addArtifactSources((ArtifactSources)new DefaultArtifactSources("", info.sourceDirs.stream().map(d -> SourceDir.of((Path)Path.of(d.dir(), new String[0]), (Path)Path.of(d.outputDir(), new String[0]))).toList(), info.resourceDirs.stream().map(d -> SourceDir.of((Path)Path.of(d.dir(), new String[0]), (Path)Path.of(d.outputDir(), new String[0]))).toList())).build();
        }
        return null;
    }

    private static Path resolveProjectInfoFile(Path workDir) {
        return workDir.resolve("vaadin-plugin-project-info.txt");
    }

    private static ProjectInfo collectWorkspaceInfo(WorkspaceModule module) {
        List<SourceDirInfo> sourceDirs = null;
        List<SourceDirInfo> resourceDirs = null;
        if (module.hasMainSources()) {
            sourceDirs = module.getMainSources().getSourceDirs().stream().map(SourceDirInfo::new).collect(Collectors.toList());
            resourceDirs = module.getMainSources().getResourceDirs().stream().map(SourceDirInfo::new).collect(Collectors.toList());
        }
        WorkspaceModuleId moduleId = module.getId();
        return new ProjectInfo(moduleId.getGroupId(), moduleId.getArtifactId(), moduleId.getVersion(), module.getModuleDir().getAbsolutePath(), module.getBuildDir().getAbsolutePath(), sourceDirs, resourceDirs);
    }

    private record ProjectInfo(String groupId, String artifactId, String version, String moduleDir, String buildDir, List<SourceDirInfo> sourceDirs, List<SourceDirInfo> resourceDirs) {
        WorkspaceModuleId moduleId() {
            return WorkspaceModuleId.of((String)this.groupId, (String)this.artifactId, (String)this.version);
        }
    }

    private record SourceDirInfo(String dir, String outputDir) {
        SourceDirInfo(SourceDir sourceDir) {
            this(sourceDir.getDir().toFile().getAbsolutePath(), sourceDir.getOutputDir().toFile().getAbsolutePath());
        }
    }
}

