/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.deployment.vaadinplugin;

import com.vaadin.quarkus.deployment.vaadinplugin.WorkspaceInfo;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.microprofile.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceInfoCollector
implements CodeGenProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkspaceInfoCollector.class);
    private WorkspaceModule module;

    public String providerId() {
        return "vaadin-plugin-workspace-info";
    }

    public String inputDirectory() {
        return "";
    }

    public void init(ApplicationModel model, Map<String, String> properties) {
        this.module = model.getApplicationModule();
    }

    public boolean shouldRun(Path sourceDir, Config config) {
        if (this.module == null) {
            LOGGER.debug("Workspace information for Vaadin embedded plugin not collected because module details are not available");
            return false;
        }
        if (!config.getOptionalValue("vaadin.build.enabled", Boolean.class).orElse(true).booleanValue()) {
            LOGGER.info("Workspace information for Vaadin embedded plugin not collected because Vaadin embedded plugin is disabled");
            return false;
        }
        if (config.getOptionalValue("quarkus.bootstrap.workspace-discovery", Boolean.class).orElse(false).booleanValue()) {
            LOGGER.debug("Workspace information for Vaadin embedded plugin not collected because workspace information already available at build time");
            return false;
        }
        return true;
    }

    public boolean trigger(CodeGenContext context) throws CodeGenException {
        if (this.module != null) {
            LOGGER.info("Collecting workspace information for Vaadin plugin");
            try {
                WorkspaceInfo.save(this.module, context.workDir());
            }
            catch (Exception e) {
                throw new CodeGenException("Failed to store workspace information for Vaadin plugin", (Throwable)e);
            }
        }
        return false;
    }
}

