/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.deployment.vaadinplugin;

import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.base.PluginAdapterBuild;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.installer.Platform;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.scanner.ReflectionsClassFinder;
import com.vaadin.flow.utils.FlowFileUtils;
import com.vaadin.quarkus.deployment.vaadinplugin.VaadinBuildTimeConfig;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QuarkusPluginAdapter
implements PluginAdapterBuild {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuarkusPluginAdapter.class);
    private final VaadinBuildTimeConfig config;
    private final ApplicationModel model;
    private final WorkspaceModule appModule;
    private final SourceDir sourcesDir;
    private final SourceDir resourcesDir;
    private ClassFinder classFinder;

    QuarkusPluginAdapter(VaadinBuildTimeConfig config, ApplicationModel applicationModel) {
        this(config, applicationModel, applicationModel.getApplicationModule());
    }

    QuarkusPluginAdapter(VaadinBuildTimeConfig config, ApplicationModel applicationModel, WorkspaceModule appModule) {
        this.config = config;
        this.model = applicationModel;
        this.appModule = appModule;
        SourceDir assumedSources = SourceDir.of((Path)appModule.getModuleDir().toPath().resolve(Paths.get("src", "main", "java")), (Path)appModule.getBuildDir().toPath().resolve("classes"));
        SourceDir assumedResources = SourceDir.of((Path)appModule.getModuleDir().toPath().resolve(Paths.get("src", "main", "resources")), (Path)appModule.getBuildDir().toPath().resolve("classes"));
        if (appModule.hasMainSources()) {
            this.sourcesDir = appModule.getMainSources().getSourceDirs().stream().findFirst().orElse(assumedSources);
            this.resourcesDir = appModule.getMainSources().getResourceDirs().stream().findFirst().orElse(assumedResources);
        } else {
            this.sourcesDir = assumedSources;
            this.resourcesDir = assumedResources;
        }
    }

    public File frontendResourcesDirectory() {
        return this.resolveProjectDirectory(this.config.frontendResourcesDirectory(), "vaadin.build.frontendResourcesDirectory");
    }

    public boolean generateBundle() {
        return this.config.generateBundle();
    }

    public boolean generateEmbeddableWebComponents() {
        return this.config.generateEmbeddableWebComponents();
    }

    public boolean optimizeBundle() {
        return this.config.optimizeBundle();
    }

    public boolean runNpmInstall() {
        return this.config.runNpmInstall();
    }

    public boolean ciBuild() {
        return this.config.ciBuild();
    }

    public boolean forceProductionBuild() {
        return this.config.forceProductionBuild();
    }

    public boolean compressBundle() {
        return true;
    }

    public boolean checkRuntimeDependency(String groupId, String artifactId, Consumer<String> missingDependencyMessageConsumer) {
        if (this.model.getRuntimeDependencies().stream().noneMatch(dependency -> dependency.getGroupId().equals(groupId))) {
            if (missingDependencyMessageConsumer != null) {
                missingDependencyMessageConsumer.accept(String.format("The dependency %1$s:%2$s has not been found in the project configuration.\nPlease add the following dependency to your POM file:\n\n<dependency>\n    <groupId>%1$s</groupId>\n    <artifactId>%2$s</artifactId>\n    <scope>runtime</scope>\n</dependency>\n", groupId, artifactId));
            }
            return true;
        }
        return true;
    }

    public File applicationProperties() {
        return this.config.applicationProperties();
    }

    public boolean eagerServerLoad() {
        return this.config.eagerServerLoad();
    }

    public File frontendDirectory() {
        return this.resolveProjectDirectory(this.config.frontendDirectory(), "vaadin.build.frontedDirectory");
    }

    private File resolveProjectDirectory(File directory, String name) {
        return this.resolveDirectory(this.projectBaseDirectory().toFile(), directory, name);
    }

    private File resolveBuildDirectory(File directory, String name) {
        return this.resolveDirectory(this.resourcesDir.getOutputDir().toFile(), directory, name);
    }

    private File resolveDirectory(File base, File directory, String key) {
        if (directory.isAbsolute() && directory.isDirectory()) {
            return directory;
        }
        directory = base.toPath().resolve(directory.toPath()).toFile();
        if (directory.exists() && !directory.isDirectory()) {
            throw new ConfigurationException(key + " must be a directory: " + String.valueOf(directory), Set.of(key));
        }
        return directory;
    }

    public File generatedTsFolder() {
        return this.config.generatedTsFolder().orElseGet(() -> this.frontendDirectory().toPath().resolve("generated/").toFile());
    }

    public ClassFinder getClassFinder() {
        if (this.classFinder == null) {
            URL[] urls = (URL[])this.buildClasspath().map(Path::toFile).map(FlowFileUtils::convertToUrl).toArray(URL[]::new);
            URLClassLoader classLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            this.classFinder = new ReflectionsClassFinder((ClassLoader)classLoader, urls);
        }
        return this.classFinder;
    }

    public Set<File> getJarFiles() {
        return this.model.getRuntimeDependencies().stream().flatMap(dep -> dep.getResolvedPaths().stream()).map(Path::toFile).filter(file -> !file.isDirectory()).collect(Collectors.toSet());
    }

    public boolean isJarProject() {
        return true;
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public File javaSourceFolder() {
        return this.sourcesDir.getDir().toFile();
    }

    public File javaResourceFolder() {
        return this.resourcesDir.getDir().toFile();
    }

    public boolean isFrontendIgnoreVersionChecks() {
        return this.config.frontendIgnoreVersionChecks();
    }

    public void logDebug(CharSequence charSequence) {
        LOGGER.debug(charSequence.toString());
    }

    public void logDebug(CharSequence charSequence, Throwable throwable) {
        LOGGER.debug(charSequence.toString(), throwable);
    }

    public void logInfo(CharSequence charSequence) {
        LOGGER.info(charSequence.toString());
    }

    public void logWarn(CharSequence charSequence) {
        LOGGER.warn(charSequence.toString());
    }

    public void logError(CharSequence charSequence) {
        LOGGER.error(charSequence.toString());
    }

    public void logWarn(CharSequence charSequence, Throwable throwable) {
        LOGGER.warn(charSequence.toString(), throwable);
    }

    public void logError(CharSequence charSequence, Throwable throwable) {
        LOGGER.error(charSequence.toString(), throwable);
    }

    public URI nodeDownloadRoot() throws URISyntaxException {
        String nodeDownloadRoot = this.config.nodeDownloadRoot().orElseGet(() -> Platform.guess().getNodeDownloadRoot());
        try {
            return new URI(nodeDownloadRoot);
        }
        catch (URISyntaxException e) {
            this.logError("Failed to parse nodeDownloadRoot uri", e);
            throw new URISyntaxException(nodeDownloadRoot, "Failed to parse nodeDownloadRoot uri");
        }
    }

    public boolean nodeAutoUpdate() {
        return this.config.nodeAutoUpdate();
    }

    public String nodeVersion() {
        return this.config.nodeVersion();
    }

    public File npmFolder() {
        return this.config.npmFolder().map(dir -> this.resolveProjectDirectory((File)dir, "npmFolder")).orElseGet(() -> this.projectBaseDirectory().toFile());
    }

    public File openApiJsonFile() {
        return this.config.openApiJsonFile();
    }

    public boolean pnpmEnable() {
        return this.config.pnpmEnable();
    }

    public boolean bunEnable() {
        return this.config.bunEnable();
    }

    public boolean useGlobalPnpm() {
        return this.config.useGlobalPnpm();
    }

    public Path projectBaseDirectory() {
        return this.appModule.getModuleDir().toPath();
    }

    public boolean requireHomeNodeExec() {
        return this.config.requireHomeNodeExec();
    }

    public File servletResourceOutputDirectory() {
        return this.resolveBuildDirectory(this.config.resourceOutputDirectory(), "resourceOutputDirectory");
    }

    public File webpackOutputDirectory() {
        return this.frontendOutputDirectory();
    }

    public File frontendOutputDirectory() {
        File outputDir = this.resolveBuildDirectory(this.config.frontendOutputDirectory(), "frontendOutputDirectory");
        this.config.webpackOutputDirectory().map(f -> this.resolveBuildDirectory((File)f, "webpackOutputDirectory")).filter(f -> !f.equals(outputDir)).ifPresent(deprecatedOutputDir -> this.logWarn("Both 'frontendOutputDirectory' and 'webpackOutputDirectory' are set. 'webpackOutputDirectory' property will be removed in future releases and will be ignored. Please use only 'frontendOutputDirectory'."));
        return outputDir;
    }

    public String buildFolder() {
        Path projectDir = this.appModule.getModuleDir().toPath();
        Path buildDir = this.appModule.getBuildDir().toPath();
        if (buildDir.startsWith(projectDir)) {
            return projectDir.relativize(buildDir).toString();
        }
        return buildDir.toString();
    }

    public List<String> postinstallPackages() {
        return this.config.postinstallPackages().orElseGet(List::of);
    }

    public boolean isFrontendHotdeploy() {
        return true;
    }

    public boolean skipDevBundleBuild() {
        return this.config.skipDevBundleBuild();
    }

    public boolean isPrepareFrontendCacheDisabled() {
        return false;
    }

    public boolean isReactEnabled() {
        return this.config.reactEnabled().orElseGet(() -> FrontendUtils.isReactRouterRequired((File)BuildFrontendUtil.getFrontendDirectory((PluginAdapterBase)this)));
    }

    public String applicationIdentifier() {
        return this.config.applicationIdentifier().filter(id -> !id.isBlank()).orElseGet(() -> "app-" + StringUtil.getHash((String)(this.model.getAppArtifact().getGroupId() + this.model.getAppArtifact().getArtifactId()), (Charset)StandardCharsets.UTF_8));
    }

    public List<String> frontendExtraFileExtensions() {
        return this.config.frontendExtraFileExtensions().orElseGet(List::of);
    }

    public boolean isNpmExcludeWebComponents() {
        return this.config.npmExcludeWebComponents();
    }

    public boolean isCommercialBannerEnabled() {
        return this.config.commercialWithBanner();
    }

    public boolean cleanFrontendFiles() {
        return this.config.cleanFrontendFiles();
    }

    Path buildDir() {
        return this.resourcesDir.getOutputDir();
    }

    private Stream<Path> buildClasspath() {
        return Stream.concat(this.appModule.getMainSources().getOutputTree().getRoots().stream(), this.model.getRuntimeDependencies().stream().flatMap(dep -> dep.getResolvedPaths().stream()));
    }
}

