import{i as td,a as ed,b as id}from"./indexhtml-DyFCVIfQ.js";import{F as nd,R as sd,T as rd,E as ad,P as od,L as hd,d as ld}from"./generated-flow-imports-DE_3A-Qj.js";import"./commonjsHelpers-CqkleIqs.js";/**
 * @license
 * Copyright (c) 2000 - 2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const cd=td`
  :host {
    display: block;
    height: 400px;
    flex: 1 1 auto;
    align-self: stretch;
    overflow: hidden;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([focus-ring]) {
    outline: var(--vaadin-focus-ring-width) solid var(--vaadin-focus-ring-color);
  }

  :host(:not([theme~='no-border'])) {
    border-radius: var(--vaadin-map-border-radius, var(--vaadin-radius-m));
    position: relative;
  }

  :host(:not([theme~='no-border']))::before {
    content: '';
    position: absolute;
    inset: 0;
    border: 1px solid var(--vaadin-map-border-color, var(--vaadin-border-color-secondary));
    border-radius: inherit;
    z-index: 1;
    pointer-events: none;
  }

  #map {
    width: 100%;
    height: 100%;
    outline: none;
  }

  #map,
  .ol-viewport,
  .ol-layers {
    border-radius: inherit;
    overflow: hidden;
  }

  #map:fullscreen {
    border-radius: 0;
  }

  #map:-webkit-full-screen {
    border-radius: 0;
  }

  /* Functional styles, copied from 'ol/ol.css' */

  .ol-box {
    box-sizing: border-box;
    border-radius: 2px;
    border: 1px solid rgba(0, 0, 0, 0.5);
    background-color: rgba(255, 255, 255, 0.2);
    box-shadow: 0 0 0 1px rgba(255, 255, 255, 0.5);
  }

  .ol-unsupported {
    display: none;
  }

  .ol-viewport,
  .ol-unselectable {
    -webkit-touch-callout: none;
    -webkit-user-select: none;
    user-select: none;
    -webkit-tap-highlight-color: transparent;
  }

  .ol-viewport canvas {
    all: unset;
  }

  .ol-selectable {
    -webkit-touch-callout: default;
    -webkit-user-select: text;
    user-select: text;
  }

  .ol-grabbing {
    cursor: grabbing;
  }

  .ol-grab {
    cursor: move;
    cursor: grab;
  }

  /* Control positioning and styling */

  .ol-overlaycontainer-stopevent {
    /* stylelint-disable declaration-block-no-redundant-longhand-properties */
    display: grid;
    grid-template-columns: min-content 1fr min-content;
    grid-template-rows: min-content 1fr min-content min-content min-content min-content;
    padding: var(--vaadin-map-controls-inset, 4px);
    box-sizing: border-box;
    grid-template-areas:
      'scale mouse-position fullscreen'
      'overview-map . zoom-extent'
      'overview-map . compass'
      'overview-map . zoom-slider'
      'overview-map . zoom'
      'overview-map attribution attribution';
  }

  .ol-mouse-position {
    grid-area: mouse-position;
    align-self: start;
    text-align: center;
    font-size: 0.625em;
    color: #000;
    filter: drop-shadow(0 0 1px #fff) drop-shadow(0 0 1px #fff);
  }

  .ol-scale-line,
  .ol-scale-bar {
    grid-area: scale;
    position: relative;
    pointer-events: none !important;
    color: #000;
  }

  .ol-scale-line-inner {
    border: 1px solid rgba(0, 0, 0, 0.5);
    border-top: none;
    font-size: 0.625em;
    text-align: center;
    will-change: contents, width, filter;
    transition: all 0.25s;
    filter: drop-shadow(0 0 1px #fff) drop-shadow(0 0 1px #fff);
  }

  .ol-scale-bar-inner {
    display: flex;
    border: 1px solid rgba(0, 0, 0, 0.5);
    box-shadow: 0 0 0 1px rgba(255, 255, 255, 0.5);
    overflow: hidden;
  }

  .ol-scale-singlebar-even {
    background: #000;
  }

  .ol-scale-singlebar-odd {
    background: #fff;
  }

  .ol-scale-step-marker {
    display: none;
  }

  .ol-scale-step-text {
    position: absolute;
    top: 12px;
    font-size: 0.625em;
    color: #000;
    filter: drop-shadow(0 0 1px #fff) drop-shadow(0 0 1px #fff);
    white-space: nowrap;
    overflow: hidden;
  }

  .ol-scale-text {
    position: absolute;
    font-size: 0.625em;
    top: 32px;
    color: #000;
    white-space: nowrap;
    filter: drop-shadow(0 0 1px #fff) drop-shadow(0 0 1px #fff);
  }

  .ol-scale-singlebar {
    height: 4px;
    opacity: 0.5;
  }

  .ol-control {
    margin: 4px;
    border-radius: var(--vaadin-button-border-radius, var(--vaadin-radius-m));
  }

  .ol-control button {
    appearance: none;
    display: block;
    border: 0;
    margin: 0;
    padding: 0;
    color: inherit;
    font: inherit;
    width: var(--vaadin-map-control-size, 24px);
    height: var(--vaadin-map-control-size, 24px);
    border-radius: inherit;
  }

  .ol-control button::-moz-focus-inner {
    border: none;
    padding: 0;
  }

  .ol-compass {
    grid-area: compass;
    display: block;
    will-change: transform;
  }

  .ol-zoom {
    grid-area: zoom;
    display: flex;
    flex-direction: column;
    gap: 2px;
  }

  .ol-attribution {
    grid-area: attribution;
    margin-inline-start: auto !important;
    display: flex;
    flex-flow: row-reverse;
  }

  .ol-attribution.ol-uncollapsible {
    margin-inline-end: calc(var(--vaadin-map-controls-inset, 4px) * -1);
    margin-block-end: calc(var(--vaadin-map-controls-inset, 4px) * -1);
    border-radius: var(--vaadin-radius) 0 0 0;
  }

  .ol-attribution button span:empty::before {
    content: var(--vaadin-map-icon-attribution-collapse, '\\25B8');
  }

  .ol-attribution.ol-collapsed button span:empty::before {
    content: var(--vaadin-map-icon-attribution-expand, '\\2139');
  }

  .ol-attribution ul {
    display: flex;
    align-items: center;
    gap: 1em;
    list-style: none;
    margin: 0;
    color: var(--vaadin-map-attribution-text-color, var(--vaadin-text-color-secondary));
    padding: var(--vaadin-padding-block-container) var(--vaadin-padding-inline-container);
    font-size: 0.8em;
  }

  .ol-attribution.ol-collapsed ul {
    display: none;
  }

  .ol-attribution.ol-uncollapsible button {
    display: none;
  }

  .ol-rotate {
    grid-area: compass;
  }

  .ol-compass:empty::before {
    mask: var(--vaadin-map-icon-compass, var(--_vaadin-icon-arrow-up)) 50% / var(--vaadin-icon-visual-size, 100%)
      no-repeat;
  }

  .ol-full-screen {
    grid-area: fullscreen;
  }

  .ol-full-screen button:empty::before {
    mask: var(--vaadin-map-icon-fullscreen, var(--_vaadin-icon-fullscreen)) 50% / var(--vaadin-icon-visual-size, 100%)
      no-repeat;
  }

  .ol-full-screen .ol-full-screen-true:empty::before {
    mask: var(--vaadin-map-icon-close, var(--_vaadin-icon-cross)) 50% / var(--vaadin-icon-visual-size, 100%) no-repeat;
  }

  .ol-overviewmap {
    grid-area: overview-map;
    align-self: end;
    width: max-content;
  }

  .ol-overviewmap-map {
    height: 160px;
    width: 160px;
    margin: 4px;
    border: 0;
    border-radius: var(--vaadin-button-border-radius, var(--vaadin-radius));
  }

  .ol-overviewmap:not(.ol-uncollapsible) .ol-overviewmap-map {
    margin-bottom: 0;
  }

  .ol-overviewmap.ol-collapsed .ol-overviewmap-map,
  .ol-overviewmap.ol-uncollapsible button {
    display: none;
  }

  .ol-overviewmap-box {
    border: 1px dashed rgba(0, 0, 0, 0.5);
    filter: drop-shadow(0 0 1px #fff) drop-shadow(0 0 1px #fff);
    will-change: filter;
    cursor: move;
  }

  .ol-zoomslider {
    grid-area: zoom-slider;
    height: 128px;
  }

  .ol-zoomslider button {
    position: relative;
    height: 8px;
    display: block;
    border-radius: inherit;
  }

  .ol-zoom-extent {
    grid-area: zoom-extent;
    align-self: end;
  }

  /* icons & controls styles */
  .ol-overviewmap button span:empty {
    display: contents;
  }

  .ol-overviewmap button span:empty::before {
    mask: var(--vaadin-map-icon-overview-map-collapse, var(--_vaadin-icon-chevron-down)) 50% /
      var(--vaadin-icon-visual-size, 100%) no-repeat;
  }

  .ol-overviewmap.ol-collapsed button {
    rotate: 180deg;
  }

  .ol-overviewmap button span:empty::before,
  .ol-zoom-in:empty::before,
  .ol-zoom-out:empty::before,
  .ol-compass:empty::before,
  .ol-full-screen button:empty::before,
  .ol-full-screen-true:empty::before {
    content: '';
    display: block;
    background: currentColor;
    width: var(--vaadin-icon-size, 1lh);
    height: var(--vaadin-icon-size, 1lh);
    flex: none;
  }

  .ol-zoom-in:empty::before {
    mask: var(--vaadin-map-icon-zoom-in, var(--_vaadin-icon-plus)) 50% / var(--vaadin-icon-visual-size, 100%) no-repeat;
  }

  .ol-zoom-out:empty::before {
    mask: var(--vaadin-map-icon-zoom-out, var(--_vaadin-icon-minus)) 50% / var(--vaadin-icon-visual-size, 100%)
      no-repeat;
  }

  .ol-zoom button.ol-zoom-in {
    border-bottom-left-radius: 0;
    border-bottom-right-radius: 0;
  }

  .ol-zoom button.ol-zoom-out {
    border-top-left-radius: 0;
    border-top-right-radius: 0;
  }

  .ol-control button,
  .ol-attribution:not(.ol-uncollapsible) ul {
    transition: 0.15s opacity;
    background: var(--vaadin-map-control-background, var(--vaadin-background-color));
    color: var(--vaadin-map-control-text-color, var(--vaadin-text-color-secondary));
    opacity: 0.65;
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .ol-control:not(.ol-uncollapsible):hover {
    box-shadow: var(--vaadin-map-control-shadow, 0 3px 8px -1px rgba(0, 0, 0, 0.2));
  }

  .ol-attribution a {
    color: inherit;
    cursor: pointer;
  }

  .ol-control:hover button,
  .ol-control button:focus,
  .ol-attribution:hover ul {
    opacity: 1;
  }

  .ol-control button:hover {
    color: var(--vaadin-map-control-text-color-hover, var(--vaadin-text-color));
  }

  .ol-control button:focus-visible {
    outline: var(--vaadin-focus-ring-width) solid var(--vaadin-focus-ring-color);
  }

  .ol-overviewmap:not(.ol-collapsed),
  .ol-overviewmap:not(.ol-collapsed):hover {
    background: var(--vaadin-map-control-background, var(--vaadin-background-color));
    box-shadow: var(--vaadin-map-control-shadow, 0 3px 8px -1px rgba(0, 0, 0, 0.2));
    transition: 0.15s box-shadow;
  }
`;function ud(i,t,e){let n,s;e=e||ri;let r=0,a=i.length,o=!1;for(;r<a;)n=r+(a-r>>1),s=+e(i[n],t),s<0?r=n+1:(a=n,o=!s);return o?r:~r}function ri(i,t){return i>t?1:i<t?-1:0}function dd(i,t){return i<t?1:i>t?-1:0}function qr(i,t,e){if(i[0]<=t)return 0;const n=i.length;if(t<=i[n-1])return n-1;if(typeof e=="function"){for(let s=1;s<n;++s){const r=i[s];if(r===t)return s;if(r<t)return e(t,i[s-1],r)>0?s-1:s}return n-1}if(e>0){for(let s=1;s<n;++s)if(i[s]<t)return s-1;return n-1}if(e<0){for(let s=1;s<n;++s)if(i[s]<=t)return s;return n-1}for(let s=1;s<n;++s){if(i[s]==t)return s;if(i[s]<t)return i[s-1]-t<t-i[s]?s-1:s}return n-1}function fd(i,t,e){for(;t<e;){const n=i[t];i[t]=i[e],i[e]=n,++t,--e}}function _o(i,t){const e=Array.isArray(t)?t:[t],n=e.length;for(let s=0;s<n;s++)i[i.length]=e[s]}function Li(i,t){const e=i.length;if(e!==t.length)return!1;for(let n=0;n<e;n++)if(i[n]!==t[n])return!1;return!0}function gd(i,t,e){const n=t||ri;return i.every(function(s,r){if(r===0)return!0;const a=n(i[r-1],s);return!(a>0||a===0)})}const rr="ol-hidden",jr="ol-unselectable",mo="ol-control",_h="ol-collapsed",_d=new RegExp(["^\\s*(?=(?:(?:[-a-z]+\\s*){0,2}(italic|oblique))?)","(?=(?:(?:[-a-z]+\\s*){0,2}(small-caps))?)","(?=(?:(?:[-a-z]+\\s*){0,2}(bold(?:er)?|lighter|[1-9]00 ))?)","(?:(?:normal|\\1|\\2|\\3)\\s*){0,3}((?:xx?-)?","(?:small|large)|medium|smaller|larger|[\\.\\d]+(?:\\%|in|[cem]m|ex|p[ctx]))","(?:\\s*\\/\\s*(normal|[\\.\\d]+(?:\\%|in|[cem]m|ex|p[ctx])?))",`?\\s*([-,\\"\\'\\sa-z0-9]+?)\\s*$`].join(""),"i"),mh=["style","variant","weight","size","lineHeight","family"],qa={normal:400,bold:700},ja=function(i){const t=i.match(_d);if(!t)return null;const e={lineHeight:"normal",size:"1.2em",style:"normal",weight:"400",variant:"normal"};for(let n=0,s=mh.length;n<s;++n){const r=t[n+1];r!==void 0&&(e[mh[n]]=typeof r=="string"?r.trim():r)}return isNaN(Number(e.weight))&&e.weight in qa&&(e.weight=qa[e.weight]),e.families=e.family.split(/,\s?/).map(n=>n.trim().replace(/^['"]|['"]$/g,"")),e},Ki=typeof navigator<"u"&&typeof navigator.userAgent<"u"?navigator.userAgent.toLowerCase():"",md=Ki.includes("safari")&&!Ki.includes("chrom");md&&(Ki.includes("version/15.4")||/cpu (os|iphone os) 15_4 like mac os x/.test(Ki));const yd=Ki.includes("webkit")&&!Ki.includes("edge"),Yl=Ki.includes("macintosh"),pd=typeof devicePixelRatio<"u"?devicePixelRatio:1,yo=typeof WorkerGlobalScope<"u"&&typeof OffscreenCanvas<"u"&&self instanceof WorkerGlobalScope,po=typeof Image<"u"&&Image.prototype.decode,Kl=typeof createImageBitmap=="function",Vl=(function(){let i=!1;try{const t=Object.defineProperty({},"passive",{get:function(){i=!0}});window.addEventListener("_",null,t),window.removeEventListener("_",null,t)}catch{}return i})();function Bt(i,t,e,n){let s;return e&&e.length?s=e.shift():yo?s=new OffscreenCanvas(i||300,t||300):s=document.createElement("canvas"),i&&(s.width=i),t&&(s.height=t),s.getContext("2d",n)}let da;function Mr(){return da||(da=Bt(1,1)),da}function Yr(i){const t=i.canvas;t.width=1,t.height=1,i.clearRect(0,0,1,1)}function yh(i,t){const e=t.parentNode;e&&e.replaceChild(i,t)}function Ed(i){for(;i.lastChild;)i.lastChild.remove()}function vd(i,t){const e=i.childNodes;for(let n=0;;++n){const s=e[n],r=t[n];if(!s&&!r)break;if(s!==r){if(!s){i.appendChild(r);continue}if(!r){i.removeChild(s),--n;continue}i.insertBefore(r,s)}}}const et={CHANGE:"change",ERROR:"error",CONTEXTMENU:"contextmenu",CLICK:"click",DBLCLICK:"dblclick",KEYDOWN:"keydown",KEYPRESS:"keypress",LOAD:"load",TOUCHMOVE:"touchmove",WHEEL:"wheel"};function Vi(){return!0}function Kr(){return!1}function Es(){}function Zl(i){let t,e,n;return function(){const s=Array.prototype.slice.call(arguments);return(!e||this!==n||!Li(s,e))&&(n=this,e=s,t=i.apply(this,arguments)),t}}function $l(i){function t(){let e;try{e=i()}catch(n){return Promise.reject(n)}return e instanceof Promise?e:Promise.resolve(e)}return t()}const pi={POSTRENDER:"postrender",MOVESTART:"movestart",MOVEEND:"moveend",LOADSTART:"loadstart",LOADEND:"loadend"},Ln={PROPERTYCHANGE:"propertychange"};class Vr{constructor(){this.disposed=!1}dispose(){this.disposed||(this.disposed=!0,this.disposeInternal())}disposeInternal(){}}function Ns(i){for(const t in i)delete i[t]}function Gn(i){let t;for(t in i)return!1;return!t}class We{constructor(t){this.propagationStopped,this.defaultPrevented,this.type=t,this.target=null}preventDefault(){this.defaultPrevented=!0}stopPropagation(){this.propagationStopped=!0}}class Fs extends Vr{constructor(t){super(),this.eventTarget_=t,this.pendingRemovals_=null,this.dispatching_=null,this.listeners_=null}addEventListener(t,e){if(!t||!e)return;const n=this.listeners_||(this.listeners_={}),s=n[t]||(n[t]=[]);s.includes(e)||s.push(e)}dispatchEvent(t){const e=typeof t=="string",n=e?t:t.type,s=this.listeners_&&this.listeners_[n];if(!s)return;const r=e?new We(t):t;r.target||(r.target=this.eventTarget_||this);const a=this.dispatching_||(this.dispatching_={}),o=this.pendingRemovals_||(this.pendingRemovals_={});n in a||(a[n]=0,o[n]=0),++a[n];let h;for(let l=0,c=s.length;l<c;++l)if("handleEvent"in s[l]?h=s[l].handleEvent(r):h=s[l].call(this,r),h===!1||r.propagationStopped){h=!1;break}if(--a[n]===0){let l=o[n];for(delete o[n];l--;)this.removeEventListener(n,Es);delete a[n]}return h}disposeInternal(){this.listeners_&&Ns(this.listeners_)}getListeners(t){return this.listeners_&&this.listeners_[t]||void 0}hasListener(t){return this.listeners_?t?t in this.listeners_:Object.keys(this.listeners_).length>0:!1}removeEventListener(t,e){if(!this.listeners_)return;const n=this.listeners_[t];if(!n)return;const s=n.indexOf(e);s!==-1&&(this.pendingRemovals_&&t in this.pendingRemovals_?(n[s]=Es,++this.pendingRemovals_[t]):(n.splice(s,1),n.length===0&&delete this.listeners_[t]))}}function mt(i,t,e,n,s){if(s){const a=e;e=function(o){return i.removeEventListener(t,e),a.call(n??this,o)}}else n&&n!==i&&(e=e.bind(n));const r={target:i,type:t,listener:e};return i.addEventListener(t,e),r}function wr(i,t,e,n){return mt(i,t,e,n,!0)}function bt(i){i&&i.target&&(i.target.removeEventListener(i.type,i.listener),Ns(i))}class ks extends Fs{constructor(){super(),this.on=this.onInternal,this.once=this.onceInternal,this.un=this.unInternal,this.revision_=0}changed(){++this.revision_,this.dispatchEvent(et.CHANGE)}getRevision(){return this.revision_}onInternal(t,e){if(Array.isArray(t)){const n=t.length,s=new Array(n);for(let r=0;r<n;++r)s[r]=mt(this,t[r],e);return s}return mt(this,t,e)}onceInternal(t,e){let n;if(Array.isArray(t)){const s=t.length;n=new Array(s);for(let r=0;r<s;++r)n[r]=wr(this,t[r],e)}else n=wr(this,t,e);return e.ol_key=n,n}unInternal(t,e){const n=e.ol_key;if(n)xd(n);else if(Array.isArray(t))for(let s=0,r=t.length;s<r;++s)this.removeEventListener(t[s],e);else this.removeEventListener(t,e)}}ks.prototype.on;ks.prototype.once;ks.prototype.un;function xd(i){if(Array.isArray(i))for(let t=0,e=i.length;t<e;++t)bt(i[t]);else bt(i)}function yt(){throw new Error("Unimplemented abstract method.")}let Md=0;function _t(i){return i.ol_uid||(i.ol_uid=String(++Md))}class ph extends We{constructor(t,e,n){super(t),this.key=e,this.oldValue=n}}class He extends ks{constructor(t){super(),this.on,this.once,this.un,_t(this),this.values_=null,t!==void 0&&this.setProperties(t)}get(t){let e;return this.values_&&this.values_.hasOwnProperty(t)&&(e=this.values_[t]),e}getKeys(){return this.values_&&Object.keys(this.values_)||[]}getProperties(){return this.values_&&Object.assign({},this.values_)||{}}getPropertiesInternal(){return this.values_}hasProperties(){return!!this.values_}notify(t,e){let n;n=`change:${t}`,this.hasListener(n)&&this.dispatchEvent(new ph(n,t,e)),n=Ln.PROPERTYCHANGE,this.hasListener(n)&&this.dispatchEvent(new ph(n,t,e))}addChangeListener(t,e){this.addEventListener(`change:${t}`,e)}removeChangeListener(t,e){this.removeEventListener(`change:${t}`,e)}set(t,e,n){const s=this.values_||(this.values_={});if(n)s[t]=e;else{const r=s[t];s[t]=e,r!==e&&this.notify(t,r)}}setProperties(t,e){for(const n in t)this.set(n,t[n],e)}applyProperties(t){t.values_&&Object.assign(this.values_||(this.values_={}),t.values_)}unset(t,e){if(this.values_&&t in this.values_){const n=this.values_[t];delete this.values_[t],Gn(this.values_)&&(this.values_=null),e||this.notify(t,n)}}}class Eo extends He{constructor(t){super();const e=t.element;e&&!t.target&&!e.style.pointerEvents&&(e.style.pointerEvents="auto"),this.element=e||null,this.target_=null,this.map_=null,this.listenerKeys=[],t.render&&(this.render=t.render),t.target&&this.setTarget(t.target)}disposeInternal(){this.element?.remove(),super.disposeInternal()}getMap(){return this.map_}setMap(t){this.map_&&this.element?.remove();for(let e=0,n=this.listenerKeys.length;e<n;++e)bt(this.listenerKeys[e]);if(this.listenerKeys.length=0,this.map_=t,t){const e=this.target_??t.getOverlayContainerStopEvent();this.element&&e.appendChild(this.element),this.render!==Es&&this.listenerKeys.push(mt(t,pi.POSTRENDER,this.render,this)),t.render()}}render(t){}setTarget(t){this.target_=typeof t=="string"?document.getElementById(t):t}}class wd extends Eo{constructor(t){t=t||{},super({element:document.createElement("div"),render:t.render,target:t.target}),this.ulElement_=document.createElement("ul"),this.collapsed_=t.collapsed!==void 0?t.collapsed:!0,this.userCollapsed_=this.collapsed_,this.overrideCollapsible_=t.collapsible!==void 0,this.collapsible_=t.collapsible!==void 0?t.collapsible:!0,this.collapsible_||(this.collapsed_=!1),this.attributions_=t.attributions;const e=t.className!==void 0?t.className:"ol-attribution",n=t.tipLabel!==void 0?t.tipLabel:"Attributions",s=t.expandClassName!==void 0?t.expandClassName:e+"-expand",r=t.collapseLabel!==void 0?t.collapseLabel:"›",a=t.collapseClassName!==void 0?t.collapseClassName:e+"-collapse";typeof r=="string"?(this.collapseLabel_=document.createElement("span"),this.collapseLabel_.textContent=r,this.collapseLabel_.className=a):this.collapseLabel_=r;const o=t.label!==void 0?t.label:"i";typeof o=="string"?(this.label_=document.createElement("span"),this.label_.textContent=o,this.label_.className=s):this.label_=o;const h=this.collapsible_&&!this.collapsed_?this.collapseLabel_:this.label_;this.toggleButton_=document.createElement("button"),this.toggleButton_.setAttribute("type","button"),this.toggleButton_.setAttribute("aria-expanded",String(!this.collapsed_)),this.toggleButton_.title=n,this.toggleButton_.appendChild(h),this.toggleButton_.addEventListener(et.CLICK,this.handleClick_.bind(this),!1);const l=e+" "+jr+" "+mo+(this.collapsed_&&this.collapsible_?" "+_h:"")+(this.collapsible_?"":" ol-uncollapsible"),c=this.element;c.className=l,c.appendChild(this.toggleButton_),c.appendChild(this.ulElement_),this.renderedAttributions_=[],this.renderedVisible_=!0}collectSourceAttributions_(t){const e=this.getMap().getAllLayers(),n=new Set(e.flatMap(s=>s.getAttributions(t)));if(this.attributions_!==void 0&&(Array.isArray(this.attributions_)?this.attributions_.forEach(s=>n.add(s)):n.add(this.attributions_)),!this.overrideCollapsible_){const s=!e.some(r=>r.getSource()?.getAttributionsCollapsible()===!1);this.setCollapsible(s)}return Array.from(n)}async updateElement_(t){if(!t){this.renderedVisible_&&(this.element.style.display="none",this.renderedVisible_=!1);return}const e=await Promise.all(this.collectSourceAttributions_(t).map(s=>$l(()=>s))),n=e.length>0;if(this.renderedVisible_!=n&&(this.element.style.display=n?"":"none",this.renderedVisible_=n),!Li(e,this.renderedAttributions_)){Ed(this.ulElement_);for(let s=0,r=e.length;s<r;++s){const a=document.createElement("li");a.innerHTML=e[s],this.ulElement_.appendChild(a)}this.renderedAttributions_=e}}handleClick_(t){t.preventDefault(),this.handleToggle_(),this.userCollapsed_=this.collapsed_}handleToggle_(){this.element.classList.toggle(_h),this.collapsed_?yh(this.collapseLabel_,this.label_):yh(this.label_,this.collapseLabel_),this.collapsed_=!this.collapsed_,this.toggleButton_.setAttribute("aria-expanded",String(!this.collapsed_))}getCollapsible(){return this.collapsible_}setCollapsible(t){this.collapsible_!==t&&(this.collapsible_=t,this.element.classList.toggle("ol-uncollapsible"),this.userCollapsed_&&this.handleToggle_())}setCollapsed(t){this.userCollapsed_=t,!(!this.collapsible_||this.collapsed_===t)&&this.handleToggle_()}getCollapsed(){return this.collapsed_}render(t){this.updateElement_(t.frameState)}}const Jt={LAYERGROUP:"layergroup",SIZE:"size",TARGET:"target",VIEW:"view"},jt={UNKNOWN:0,INTERSECTING:1,ABOVE:2,RIGHT:4,BELOW:8,LEFT:16};function Eh(i){const t=fe();for(let e=0,n=i.length;e<n;++e)us(t,i[e]);return t}function Sd(i,t,e){const n=Math.min.apply(null,i),s=Math.min.apply(null,t),r=Math.max.apply(null,i),a=Math.max.apply(null,t);return li(n,s,r,a,e)}function On(i,t,e){return e?(e[0]=i[0]-t,e[1]=i[1]-t,e[2]=i[2]+t,e[3]=i[3]+t,e):[i[0]-t,i[1]-t,i[2]+t,i[3]+t]}function Hl(i,t){return t?(t[0]=i[0],t[1]=i[1],t[2]=i[2],t[3]=i[3],t):i.slice()}function Jl(i,t,e){let n,s;return t<i[0]?n=i[0]-t:i[2]<t?n=t-i[2]:n=0,e<i[1]?s=i[1]-e:i[3]<e?s=e-i[3]:s=0,n*n+s*s}function Zi(i,t){return Ql(i,t[0],t[1])}function xi(i,t){return i[0]<=t[0]&&t[2]<=i[2]&&i[1]<=t[1]&&t[3]<=i[3]}function Ql(i,t,e){return i[0]<=t&&t<=i[2]&&i[1]<=e&&e<=i[3]}function Ya(i,t){const e=i[0],n=i[1],s=i[2],r=i[3],a=t[0],o=t[1];let h=jt.UNKNOWN;return a<e?h=h|jt.LEFT:a>s&&(h=h|jt.RIGHT),o<n?h=h|jt.BELOW:o>r&&(h=h|jt.ABOVE),h===jt.UNKNOWN&&(h=jt.INTERSECTING),h}function fe(){return[1/0,1/0,-1/0,-1/0]}function li(i,t,e,n,s){return s?(s[0]=i,s[1]=t,s[2]=e,s[3]=n,s):[i,t,e,n]}function zs(i){return li(1/0,1/0,-1/0,-1/0,i)}function vo(i,t){const e=i[0],n=i[1];return li(e,n,e,n,t)}function xo(i,t,e,n,s){const r=zs(s);return ec(r,i,t,e,n)}function Dn(i,t){return i[0]==t[0]&&i[2]==t[2]&&i[1]==t[1]&&i[3]==t[3]}function tc(i,t){return t[0]<i[0]&&(i[0]=t[0]),t[2]>i[2]&&(i[2]=t[2]),t[1]<i[1]&&(i[1]=t[1]),t[3]>i[3]&&(i[3]=t[3]),i}function us(i,t){t[0]<i[0]&&(i[0]=t[0]),t[0]>i[2]&&(i[2]=t[0]),t[1]<i[1]&&(i[1]=t[1]),t[1]>i[3]&&(i[3]=t[1])}function ec(i,t,e,n,s){for(;e<n;e+=s)Cd(i,t[e],t[e+1]);return i}function Cd(i,t,e){i[0]=Math.min(i[0],t),i[1]=Math.min(i[1],e),i[2]=Math.max(i[2],t),i[3]=Math.max(i[3],e)}function ic(i,t){let e;return e=t(Zr(i)),e||(e=t($r(i)),e)||(e=t(Hr(i)),e)||(e=t(tn(i)),e)?e:!1}function Ka(i){let t=0;return en(i)||(t=gt(i)*Wt(i)),t}function Zr(i){return[i[0],i[1]]}function $r(i){return[i[2],i[1]]}function Ve(i){return[(i[0]+i[2])/2,(i[1]+i[3])/2]}function Id(i,t){let e;if(t==="bottom-left")e=Zr(i);else if(t==="bottom-right")e=$r(i);else if(t==="top-left")e=tn(i);else if(t==="top-right")e=Hr(i);else throw new Error("Invalid corner");return e}function vs(i,t,e,n,s){const[r,a,o,h,l,c,u,d]=nc(i,t,e,n);return li(Math.min(r,o,l,u),Math.min(a,h,c,d),Math.max(r,o,l,u),Math.max(a,h,c,d),s)}function nc(i,t,e,n){const s=t*n[0]/2,r=t*n[1]/2,a=Math.cos(e),o=Math.sin(e),h=s*a,l=s*o,c=r*a,u=r*o,d=i[0],f=i[1];return[d-h+u,f-l-c,d-h-u,f-l+c,d+h-u,f+l+c,d+h+u,f+l-c,d-h+u,f-l-c]}function Wt(i){return i[3]-i[1]}function ai(i,t,e){const n=e||fe();return ie(i,t)?(i[0]>t[0]?n[0]=i[0]:n[0]=t[0],i[1]>t[1]?n[1]=i[1]:n[1]=t[1],i[2]<t[2]?n[2]=i[2]:n[2]=t[2],i[3]<t[3]?n[3]=i[3]:n[3]=t[3]):zs(n),n}function tn(i){return[i[0],i[3]]}function Hr(i){return[i[2],i[3]]}function gt(i){return i[2]-i[0]}function ie(i,t){return i[0]<=t[2]&&i[2]>=t[0]&&i[1]<=t[3]&&i[3]>=t[1]}function en(i){return i[2]<i[0]||i[3]<i[1]}function Rd(i,t){return t?(t[0]=i[0],t[1]=i[1],t[2]=i[2],t[3]=i[3],t):i}function Ad(i,t,e){let n=!1;const s=Ya(i,t),r=Ya(i,e);if(s===jt.INTERSECTING||r===jt.INTERSECTING)n=!0;else{const a=i[0],o=i[1],h=i[2],l=i[3],c=t[0],u=t[1],d=e[0],f=e[1],g=(f-u)/(d-c);let _,m;r&jt.ABOVE&&!(s&jt.ABOVE)&&(_=d-(f-l)/g,n=_>=a&&_<=h),!n&&r&jt.RIGHT&&!(s&jt.RIGHT)&&(m=f-(d-h)*g,n=m>=o&&m<=l),!n&&r&jt.BELOW&&!(s&jt.BELOW)&&(_=d-(f-o)/g,n=_>=a&&_<=h),!n&&r&jt.LEFT&&!(s&jt.LEFT)&&(m=f-(d-a)*g,n=m>=o&&m<=l)}return n}function Td(i,t,e,n){if(en(i))return zs(e);let s=[];s=[i[0],i[1],i[2],i[1],i[2],i[3],i[0],i[3]],t(s,s,2);const r=[],a=[];for(let o=0,h=s.length;o<h;o+=2)r.push(s[o]),a.push(s[o+1]);return Sd(r,a,e)}function sc(i,t){const e=t.getExtent(),n=Ve(i);if(t.canWrapX()&&(n[0]<e[0]||n[0]>=e[2])){const s=gt(e),a=Math.floor((n[0]-e[0])/s)*s;i[0]-=a,i[2]-=a}return i}function rc(i,t,e){if(t.canWrapX()){const n=t.getExtent();if(!isFinite(i[0])||!isFinite(i[2]))return[[n[0],i[1],n[2],i[3]]];sc(i,t);const s=gt(n);if(gt(i)>s&&!e)return[[n[0],i[1],n[2],i[3]]];if(i[0]<n[0])return[[i[0]+s,i[1],n[2],i[3]],[n[0],i[1],i[2],i[3]]];if(i[2]>n[2])return[[i[0],i[1],n[2],i[3]],[n[0],i[1],i[2]-s,i[3]]]}return[i]}function Pt(i,t,e){return Math.min(Math.max(i,t),e)}function bd(i,t,e,n,s,r){const a=s-e,o=r-n;if(a!==0||o!==0){const h=((i-e)*a+(t-n)*o)/(a*a+o*o);h>1?(e=s,n=r):h>0&&(e+=a*h,n+=o*h)}return In(i,t,e,n)}function In(i,t,e,n){const s=e-i,r=n-t;return s*s+r*r}function Pd(i){const t=i.length;for(let n=0;n<t;n++){let s=n,r=Math.abs(i[n][n]);for(let o=n+1;o<t;o++){const h=Math.abs(i[o][n]);h>r&&(r=h,s=o)}if(r===0)return null;const a=i[s];i[s]=i[n],i[n]=a;for(let o=n+1;o<t;o++){const h=-i[o][n]/i[n][n];for(let l=n;l<t+1;l++)n==l?i[o][l]=0:i[o][l]+=h*i[n][l]}}const e=new Array(t);for(let n=t-1;n>=0;n--){e[n]=i[n][t]/i[n][n];for(let s=n-1;s>=0;s--)i[s][t]-=i[s][n]*e[n]}return e}function vh(i){return i*180/Math.PI}function Ii(i){return i*Math.PI/180}function Yi(i,t){const e=i%t;return e*t<0?e+t:e}function Se(i,t,e){return i+e*(t-i)}function Us(i,t){const e=Math.pow(10,t);return Math.round(i*e)/e}function xh(i,t){return Math.round(Us(i,t))}function En(i,t){return Math.floor(Us(i,t))}function Mi(i,t){return Math.ceil(Us(i,t))}function Va(i,t,e){if(i>=t&&i<e)return i;const n=e-t;return((i-t)%n+n)%n+t}function Mo(i,t){const e=(""+i).split("."),n=(""+t).split(".");for(let s=0;s<Math.max(e.length,n.length);s++){const r=parseInt(e[s]||"0",10),a=parseInt(n[s]||"0",10);if(r>a)return 1;if(a>r)return-1}return 0}function ac(i,t){return i[0]+=+t[0],i[1]+=+t[1],i}function Sr(i,t){let e=!0;for(let n=i.length-1;n>=0;--n)if(i[n]!=t[n]){e=!1;break}return e}function wo(i,t){const e=Math.cos(t),n=Math.sin(t),s=i[0]*e-i[1]*n,r=i[1]*e+i[0]*n;return i[0]=s,i[1]=r,i}function oc(i,t){return i[0]*=t,i[1]*=t,i}function hc(i,t){if(t.canWrapX()){const e=gt(t.getExtent()),n=lc(i,t,e);n&&(i[0]-=n*e)}return i}function lc(i,t,e){const n=t.getExtent();let s=0;return t.canWrapX()&&(i[0]<n[0]||i[0]>n[2])&&(e=e||gt(n),s=Math.floor((i[0]-n[0])/e)),s}const Za={POINTERMOVE:"pointermove",POINTERDOWN:"pointerdown"};function cc(...i){console.warn(...i)}const So={radians:6370997/(2*Math.PI),degrees:2*Math.PI*6370997/360,ft:.3048,m:1,"us-ft":1200/3937};let Jr=class{constructor(t){this.code_=t.code,this.units_=t.units,this.extent_=t.extent!==void 0?t.extent:null,this.worldExtent_=t.worldExtent!==void 0?t.worldExtent:null,this.axisOrientation_=t.axisOrientation!==void 0?t.axisOrientation:"enu",this.global_=t.global!==void 0?t.global:!1,this.canWrapX_=!!(this.global_&&this.extent_),this.getPointResolutionFunc_=t.getPointResolution,this.defaultTileGrid_=null,this.metersPerUnit_=t.metersPerUnit}canWrapX(){return this.canWrapX_}getCode(){return this.code_}getExtent(){return this.extent_}getUnits(){return this.units_}getMetersPerUnit(){return this.metersPerUnit_||So[this.units_]}getWorldExtent(){return this.worldExtent_}getAxisOrientation(){return this.axisOrientation_}isGlobal(){return this.global_}setGlobal(t){this.global_=t,this.canWrapX_=!!(t&&this.extent_)}getDefaultTileGrid(){return this.defaultTileGrid_}setDefaultTileGrid(t){this.defaultTileGrid_=t}setExtent(t){this.extent_=t,this.canWrapX_=!!(this.global_&&t)}setWorldExtent(t){this.worldExtent_=t}setGetPointResolution(t){this.getPointResolutionFunc_=t}getPointResolutionFunc(){return this.getPointResolutionFunc_}};const Ws=6378137,vn=Math.PI*Ws,Ld=[-vn,-vn,vn,vn],Gd=[-180,-85,180,85],ar=Ws*Math.log(Math.tan(Math.PI/2));class on extends Jr{constructor(t){super({code:t,units:"m",extent:Ld,global:!0,worldExtent:Gd,getPointResolution:function(e,n){return e/Math.cosh(n[1]/Ws)}})}}const Mh=[new on("EPSG:3857"),new on("EPSG:102100"),new on("EPSG:102113"),new on("EPSG:900913"),new on("http://www.opengis.net/def/crs/EPSG/0/3857"),new on("http://www.opengis.net/gml/srs/epsg.xml#3857")];function Od(i,t,e,n){const s=i.length;e=e>1?e:2,n=n??e,t===void 0&&(e>2?t=i.slice():t=new Array(s));for(let r=0;r<s;r+=n){t[r]=vn*i[r]/180;let a=Ws*Math.log(Math.tan(Math.PI*(+i[r+1]+90)/360));a>ar?a=ar:a<-ar&&(a=-ar),t[r+1]=a}return t}function Dd(i,t,e,n){const s=i.length;e=e>1?e:2,n=n??e,t===void 0&&(e>2?t=i.slice():t=new Array(s));for(let r=0;r<s;r+=n)t[r]=180*i[r]/vn,t[r+1]=360*Math.atan(Math.exp(i[r+1]/Ws))/Math.PI-90;return t}const Nd=6378137,wh=[-180,-90,180,90],Fd=Math.PI*Nd/180;class Fi extends Jr{constructor(t,e){super({code:t,units:"degrees",extent:wh,axisOrientation:e,global:!0,metersPerUnit:Fd,worldExtent:wh})}}const Sh=[new Fi("CRS:84"),new Fi("EPSG:4326","neu"),new Fi("urn:ogc:def:crs:OGC:1.3:CRS84"),new Fi("urn:ogc:def:crs:OGC:2:84"),new Fi("http://www.opengis.net/def/crs/OGC/1.3/CRS84"),new Fi("http://www.opengis.net/gml/srs/epsg.xml#4326","neu"),new Fi("http://www.opengis.net/def/crs/EPSG/0/4326","neu")];let $a={};function yr(i){return $a[i]||$a[i.replace(/urn:(x-)?ogc:def:crs:EPSG:(.*:)?(\w+)$/,"EPSG:$3")]||null}function kd(i,t){$a[i]=t}let Rn={};function $i(i,t,e){const n=i.getCode(),s=t.getCode();n in Rn||(Rn[n]={}),Rn[n][s]=e}function pr(i,t){return i in Rn&&t in Rn[i]?Rn[i][t]:null}const Cr=.9996,Re=.00669438,Qr=Re*Re,ta=Qr*Re,Bi=Re/(1-Re),Ch=Math.sqrt(1-Re),Nn=(1-Ch)/(1+Ch),uc=Nn*Nn,Co=uc*Nn,Io=Co*Nn,dc=Io*Nn,fc=1-Re/4-3*Qr/64-5*ta/256,zd=3*Re/8+3*Qr/32+45*ta/1024,Ud=15*Qr/256+45*ta/1024,Wd=35*ta/3072,Bd=3/2*Nn-27/32*Co+269/512*dc,Xd=21/16*uc-55/32*Io,qd=151/96*Co-417/128*dc,jd=1097/512*Io,Ir=6378137;function Yd(i,t,e){const n=i-5e5,a=(e.north?t:t-1e7)/Cr/(Ir*fc),o=a+Bd*Math.sin(2*a)+Xd*Math.sin(4*a)+qd*Math.sin(6*a)+jd*Math.sin(8*a),h=Math.sin(o),l=h*h,c=Math.cos(o),u=h/c,d=u*u,f=d*d,g=1-Re*l,_=Math.sqrt(1-Re*l),m=Ir/_,y=(1-Re)/g,p=Bi*c**2,x=p*p,v=n/(m*Cr),M=v*v,C=M*v,P=C*v,b=P*v,L=b*v,N=o-u/y*(M/2-P/24*(5+3*d+10*p-4*x-9*Bi))+L/720*(61+90*d+298*p+45*f-252*Bi-3*x);let B=(v-C/6*(1+2*d+p)+b/120*(5-2*p+28*d-3*x+8*Bi+24*f))/c;return B=Va(B+Ii(gc(e.number)),-Math.PI,Math.PI),[vh(B),vh(N)]}const Ih=-80,Rh=84,Kd=-180,Vd=180;function Zd(i,t,e){i=Va(i,Kd,Vd),t<Ih?t=Ih:t>Rh&&(t=Rh);const n=Ii(t),s=Math.sin(n),r=Math.cos(n),a=s/r,o=a*a,h=o*o,l=Ii(i),c=gc(e.number),u=Ii(c),d=Ir/Math.sqrt(1-Re*s**2),f=Bi*r**2,g=r*Va(l-u,-Math.PI,Math.PI),_=g*g,m=_*g,y=m*g,p=y*g,x=p*g,v=Ir*(fc*n-zd*Math.sin(2*n)+Ud*Math.sin(4*n)-Wd*Math.sin(6*n)),M=Cr*d*(g+m/6*(1-o+f)+p/120*(5-18*o+h+72*f-58*Bi))+5e5;let C=Cr*(v+d*a*(_/2+y/24*(5-o+9*f+4*f**2)+x/720*(61-58*o+h+600*f-330*Bi)));return e.north||(C+=1e7),[M,C]}function gc(i){return(i-1)*6-180+3}const $d=[/^EPSG:(\d+)$/,/^urn:ogc:def:crs:EPSG::(\d+)$/,/^http:\/\/www\.opengis\.net\/def\/crs\/EPSG\/0\/(\d+)$/];function _c(i){let t=0;for(const s of $d){const r=i.match(s);if(r){t=parseInt(r[1]);break}}if(!t)return null;let e=0,n=!1;return t>32700&&t<32761?e=t-32700:t>32600&&t<32661&&(n=!0,e=t-32600),e?{number:e,north:n}:null}function Ah(i,t){return function(e,n,s,r){const a=e.length;s=s>1?s:2,r=r??s,n||(s>2?n=e.slice():n=new Array(a));for(let o=0;o<a;o+=r){const h=e[o],l=e[o+1],c=i(h,l,t);n[o]=c[0],n[o+1]=c[1]}return n}}function Hd(i){return _c(i)?new Jr({code:i,units:"m"}):null}function Jd(i){const t=_c(i.getCode());return t?{forward:Ah(Zd,t),inverse:Ah(Yd,t)}:null}const Qd=63710088e-1;function Th(i,t,e){e=e||Qd;const n=Ii(i[1]),s=Ii(t[1]),r=(s-n)/2,a=Ii(t[0]-i[0])/2,o=Math.sin(r)*Math.sin(r)+Math.sin(a)*Math.sin(a)*Math.cos(n)*Math.cos(s);return 2*e*Math.atan2(Math.sqrt(o),Math.sqrt(1-o))}const tf=[Jd],ef=[Hd];let Ha=!0;function nf(i){Ha=!1}function Ro(i,t){if(t!==void 0){for(let e=0,n=i.length;e<n;++e)t[e]=i[e];t=t}else t=i.slice();return t}function Rr(i){kd(i.getCode(),i),$i(i,i,Ro)}function sf(i){i.forEach(Rr)}function Gt(i){if(typeof i!="string")return i;const t=yr(i);if(t)return t;for(const e of ef){const n=e(i);if(n)return n}return null}function bh(i,t,e,n){i=Gt(i);let s;const r=i.getPointResolutionFunc();if(r)s=r(t,e);else{const a=i.getUnits();if(a=="degrees"&&!n||n=="degrees")s=t;else{const o=Bs(i,Gt("EPSG:4326"));if(!o&&a!=="degrees")s=t*i.getMetersPerUnit();else{let l=[e[0]-t/2,e[1],e[0]+t/2,e[1],e[0],e[1]-t/2,e[0],e[1]+t/2];l=o(l,l,2);const c=Th(l.slice(0,2),l.slice(2,4)),u=Th(l.slice(4,6),l.slice(6,8));s=(c+u)/2}const h=i.getMetersPerUnit();h!==void 0&&(s/=h)}}return s}function Ja(i){sf(i),i.forEach(function(t){i.forEach(function(e){t!==e&&$i(t,e,Ro)})})}function rf(i,t,e,n){i.forEach(function(s){t.forEach(function(r){$i(s,r,e),$i(r,s,n)})})}function Ao(i,t){return i?typeof i=="string"?Gt(i):i:Gt(t)}function Qa(i){return(function(t,e,n,s){const r=t.length;n=n!==void 0?n:2,s=s??n,e=e!==void 0?e:new Array(r);for(let a=0;a<r;a+=s){const o=i(t.slice(a,a+n)),h=o.length;for(let l=0,c=s;l<c;++l)e[a+l]=l>=h?t[a+l]:o[l]}return e})}function af(i,t,e,n){const s=Gt(i),r=Gt(t);$i(s,r,Qa(e)),$i(r,s,Qa(n))}function ds(i,t){if(i===t)return!0;const e=i.getUnits()===t.getUnits();return(i.getCode()===t.getCode()||Bs(i,t)===Ro)&&e}function Bs(i,t){const e=i.getCode(),n=t.getCode();let s=pr(e,n);if(s)return s;let r=null,a=null;for(const h of tf)r||(r=h(i)),a||(a=h(t));if(!r&&!a)return null;const o="EPSG:4326";if(a)if(r)s=fa(r.inverse,a.forward);else{const h=pr(e,o);h&&(s=fa(h,a.forward))}else{const h=pr(o,n);h&&(s=fa(r.inverse,h))}return s&&(Rr(i),Rr(t),$i(i,t,s)),s}function fa(i,t){return function(e,n,s,r){return n=i(e,n,s,r),t(n,n,s,r)}}function xs(i,t){const e=Gt(i),n=Gt(t);return Bs(e,n)}function Bn(i,t,e){const n=xs(t,e);if(!n){const s=Gt(t).getCode(),r=Gt(e).getCode();throw new Error(`No transform available between ${s} and ${r}`)}return n(i,void 0,i.length)}function mc(i,t,e,n){const s=xs(t,e);return Td(i,s,void 0)}let Ae=null;function yc(i){Ae=Gt(i)}function Ms(){return Ae}function to(i,t){return Ae?Bn(i,t,Ae):i}function De(i,t){return Ae?Bn(i,Ae,t):(Ha&&!Sr(i,[0,0])&&i[0]>=-180&&i[0]<=180&&i[1]>=-90&&i[1]<=90&&(Ha=!1,cc("Call useGeographic() from ol/proj once to work with [longitude, latitude] coordinates.")),i)}function Ar(i,t){return Ae?mc(i,t,Ae):i}function qe(i,t){return Ae?mc(i,Ae,t):i}function of(i,t){if(!Ae)return i;const e=Gt(t).getMetersPerUnit(),n=Ae.getMetersPerUnit();return e&&n?i*e/n:i}function Ph(i,t,e){return function(n){let s,r;if(i.canWrapX()){const a=i.getExtent(),o=gt(a);n=n.slice(0),r=lc(n,i,o),r&&(n[0]=n[0]-r*o),n[0]=Pt(n[0],a[0],a[2]),n[1]=Pt(n[1],a[1],a[3]),s=e(n)}else s=e(n);return r&&t.canWrapX()&&(s[0]+=r*gt(t.getExtent())),s}}function hf(){Ja(Mh),Ja(Sh),rf(Sh,Mh,Od,Dd)}hf();const oe={ADD:"add",REMOVE:"remove"},Lh={LENGTH:"length"};class or extends We{constructor(t,e,n){super(t),this.element=e,this.index=n}}class ne extends He{constructor(t,e){if(super(),this.on,this.once,this.un,e=e||{},this.unique_=!!e.unique,this.array_=t||[],this.unique_)for(let n=0,s=this.array_.length;n<s;++n)this.assertUnique_(this.array_[n],n);this.updateLength_()}clear(){for(;this.getLength()>0;)this.pop()}extend(t){for(let e=0,n=t.length;e<n;++e)this.push(t[e]);return this}forEach(t){const e=this.array_;for(let n=0,s=e.length;n<s;++n)t(e[n],n,e)}getArray(){return this.array_}item(t){return this.array_[t]}getLength(){return this.get(Lh.LENGTH)}insertAt(t,e){if(t<0||t>this.getLength())throw new Error("Index out of bounds: "+t);this.unique_&&this.assertUnique_(e),this.array_.splice(t,0,e),this.updateLength_(),this.dispatchEvent(new or(oe.ADD,e,t))}pop(){return this.removeAt(this.getLength()-1)}push(t){this.unique_&&this.assertUnique_(t);const e=this.getLength();return this.insertAt(e,t),this.getLength()}remove(t){const e=this.array_;for(let n=0,s=e.length;n<s;++n)if(e[n]===t)return this.removeAt(n)}removeAt(t){if(t<0||t>=this.getLength())return;const e=this.array_[t];return this.array_.splice(t,1),this.updateLength_(),this.dispatchEvent(new or(oe.REMOVE,e,t)),e}setAt(t,e){const n=this.getLength();if(t>=n){this.insertAt(t,e);return}if(t<0)throw new Error("Index out of bounds: "+t);this.unique_&&this.assertUnique_(e,t);const s=this.array_[t];this.array_[t]=e,this.dispatchEvent(new or(oe.REMOVE,s,t)),this.dispatchEvent(new or(oe.ADD,e,t))}updateLength_(){this.set(Lh.LENGTH,this.array_.length)}assertUnique_(t,e){for(let n=0,s=this.array_.length;n<s;++n)if(this.array_[n]===t&&n!==e)throw new Error("Duplicate item added to a unique collection")}}class gn extends We{constructor(t,e,n){super(t),this.map=e,this.frameState=n!==void 0?n:null}}class Ei extends gn{constructor(t,e,n,s,r,a){super(t,e,r),this.originalEvent=n,this.pixel_=null,this.coordinate_=null,this.dragging=s!==void 0?s:!1,this.activePointers=a}get pixel(){return this.pixel_||(this.pixel_=this.map.getEventPixel(this.originalEvent)),this.pixel_}set pixel(t){this.pixel_=t}get coordinate(){return this.coordinate_||(this.coordinate_=this.map.getCoordinateFromPixel(this.pixel)),this.coordinate_}set coordinate(t){this.coordinate_=t}preventDefault(){super.preventDefault(),"preventDefault"in this.originalEvent&&this.originalEvent.preventDefault()}stopPropagation(){super.stopPropagation(),"stopPropagation"in this.originalEvent&&this.originalEvent.stopPropagation()}}const Dt={SINGLECLICK:"singleclick",CLICK:et.CLICK,DBLCLICK:et.DBLCLICK,POINTERDRAG:"pointerdrag",POINTERMOVE:"pointermove",POINTERDOWN:"pointerdown",POINTERUP:"pointerup",POINTEROVER:"pointerover",POINTEROUT:"pointerout",POINTERENTER:"pointerenter",POINTERLEAVE:"pointerleave",POINTERCANCEL:"pointercancel"};class lf extends Fs{constructor(t,e){super(t),this.map_=t,this.clickTimeoutId_,this.emulateClicks_=!1,this.dragging_=!1,this.dragListenerKeys_=[],this.moveTolerance_=e===void 0?1:e,this.down_=null;const n=this.map_.getViewport();this.activePointers_=[],this.trackedTouches_={},this.element_=n,this.pointerdownListenerKey_=mt(n,Za.POINTERDOWN,this.handlePointerDown_,this),this.originalPointerMoveEvent_,this.relayedListenerKey_=mt(n,Za.POINTERMOVE,this.relayMoveEvent_,this),this.boundHandleTouchMove_=this.handleTouchMove_.bind(this),this.element_.addEventListener(et.TOUCHMOVE,this.boundHandleTouchMove_,Vl?{passive:!1}:!1)}emulateClick_(t){let e=new Ei(Dt.CLICK,this.map_,t);this.dispatchEvent(e),this.clickTimeoutId_!==void 0?(clearTimeout(this.clickTimeoutId_),this.clickTimeoutId_=void 0,e=new Ei(Dt.DBLCLICK,this.map_,t),this.dispatchEvent(e)):this.clickTimeoutId_=setTimeout(()=>{this.clickTimeoutId_=void 0;const n=new Ei(Dt.SINGLECLICK,this.map_,t);this.dispatchEvent(n)},250)}updateActivePointers_(t){const e=t,n=e.pointerId;if(e.type==Dt.POINTERUP||e.type==Dt.POINTERCANCEL){delete this.trackedTouches_[n];for(const s in this.trackedTouches_)if(this.trackedTouches_[s].target!==e.target){delete this.trackedTouches_[s];break}}else(e.type==Dt.POINTERDOWN||e.type==Dt.POINTERMOVE)&&(this.trackedTouches_[n]=e);this.activePointers_=Object.values(this.trackedTouches_)}handlePointerUp_(t){this.updateActivePointers_(t);const e=new Ei(Dt.POINTERUP,this.map_,t,void 0,void 0,this.activePointers_);this.dispatchEvent(e),this.emulateClicks_&&!e.defaultPrevented&&!this.dragging_&&this.isMouseActionButton_(t)&&this.emulateClick_(this.down_),this.activePointers_.length===0&&(this.dragListenerKeys_.forEach(bt),this.dragListenerKeys_.length=0,this.dragging_=!1,this.down_=null)}isMouseActionButton_(t){return t.button===0}handlePointerDown_(t){this.emulateClicks_=this.activePointers_.length===0,this.updateActivePointers_(t);const e=new Ei(Dt.POINTERDOWN,this.map_,t,void 0,void 0,this.activePointers_);if(this.dispatchEvent(e),this.down_=new PointerEvent(t.type,t),Object.defineProperty(this.down_,"target",{writable:!1,value:t.target}),this.dragListenerKeys_.length===0){const n=this.map_.getOwnerDocument();this.dragListenerKeys_.push(mt(n,Dt.POINTERMOVE,this.handlePointerMove_,this),mt(n,Dt.POINTERUP,this.handlePointerUp_,this),mt(this.element_,Dt.POINTERCANCEL,this.handlePointerUp_,this)),this.element_.getRootNode&&this.element_.getRootNode()!==n&&this.dragListenerKeys_.push(mt(this.element_.getRootNode(),Dt.POINTERUP,this.handlePointerUp_,this))}}handlePointerMove_(t){if(this.isMoving_(t)){this.updateActivePointers_(t),this.dragging_=!0;const e=new Ei(Dt.POINTERDRAG,this.map_,t,this.dragging_,void 0,this.activePointers_);this.dispatchEvent(e)}}relayMoveEvent_(t){this.originalPointerMoveEvent_=t;const e=!!(this.down_&&this.isMoving_(t));this.dispatchEvent(new Ei(Dt.POINTERMOVE,this.map_,t,e))}handleTouchMove_(t){const e=this.originalPointerMoveEvent_;(!e||e.defaultPrevented)&&(typeof t.cancelable!="boolean"||t.cancelable===!0)&&t.preventDefault()}isMoving_(t){return this.dragging_||Math.abs(t.clientX-this.down_.clientX)>this.moveTolerance_||Math.abs(t.clientY-this.down_.clientY)>this.moveTolerance_}disposeInternal(){this.relayedListenerKey_&&(bt(this.relayedListenerKey_),this.relayedListenerKey_=null),this.element_.removeEventListener(et.TOUCHMOVE,this.boundHandleTouchMove_),this.pointerdownListenerKey_&&(bt(this.pointerdownListenerKey_),this.pointerdownListenerKey_=null),this.dragListenerKeys_.forEach(bt),this.dragListenerKeys_.length=0,this.element_=null,super.disposeInternal()}}const $={IDLE:0,LOADING:1,LOADED:2,ERROR:3,EMPTY:4};function vt(i,t){if(!i)throw new Error(t)}const Tr=1/0;class cf{constructor(t,e){this.priorityFunction_=t,this.keyFunction_=e,this.elements_=[],this.priorities_=[],this.queuedElements_={}}clear(){this.elements_.length=0,this.priorities_.length=0,Ns(this.queuedElements_)}dequeue(){const t=this.elements_,e=this.priorities_,n=t[0];t.length==1?(t.length=0,e.length=0):(t[0]=t.pop(),e[0]=e.pop(),this.siftUp_(0));const s=this.keyFunction_(n);return delete this.queuedElements_[s],n}enqueue(t){vt(!(this.keyFunction_(t)in this.queuedElements_),"Tried to enqueue an `element` that was already added to the queue");const e=this.priorityFunction_(t);return e!=Tr?(this.elements_.push(t),this.priorities_.push(e),this.queuedElements_[this.keyFunction_(t)]=!0,this.siftDown_(0,this.elements_.length-1),!0):!1}getCount(){return this.elements_.length}getLeftChildIndex_(t){return t*2+1}getRightChildIndex_(t){return t*2+2}getParentIndex_(t){return t-1>>1}heapify_(){let t;for(t=(this.elements_.length>>1)-1;t>=0;t--)this.siftUp_(t)}isEmpty(){return this.elements_.length===0}isKeyQueued(t){return t in this.queuedElements_}isQueued(t){return this.isKeyQueued(this.keyFunction_(t))}siftUp_(t){const e=this.elements_,n=this.priorities_,s=e.length,r=e[t],a=n[t],o=t;for(;t<s>>1;){const h=this.getLeftChildIndex_(t),l=this.getRightChildIndex_(t),c=l<s&&n[l]<n[h]?l:h;e[t]=e[c],n[t]=n[c],t=c}e[t]=r,n[t]=a,this.siftDown_(o,t)}siftDown_(t,e){const n=this.elements_,s=this.priorities_,r=n[e],a=s[e];for(;e>t;){const o=this.getParentIndex_(e);if(s[o]>a)n[e]=n[o],s[e]=s[o],e=o;else break}n[e]=r,s[e]=a}reprioritize(){const t=this.priorityFunction_,e=this.elements_,n=this.priorities_;let s=0;const r=e.length;let a,o,h;for(o=0;o<r;++o)a=e[o],h=t(a),h==Tr?delete this.queuedElements_[this.keyFunction_(a)]:(n[s]=h,e[s++]=a);e.length=s,n.length=s,this.heapify_()}}class uf extends cf{constructor(t,e){super(n=>t.apply(null,n),n=>n[0].getKey()),this.boundHandleTileChange_=this.handleTileChange.bind(this),this.tileChangeCallback_=e,this.tilesLoading_=0,this.tilesLoadingKeys_={}}enqueue(t){const e=super.enqueue(t);return e&&t[0].addEventListener(et.CHANGE,this.boundHandleTileChange_),e}getTilesLoading(){return this.tilesLoading_}handleTileChange(t){const e=t.target,n=e.getState();if(n===$.LOADED||n===$.ERROR||n===$.EMPTY){n!==$.ERROR&&e.removeEventListener(et.CHANGE,this.boundHandleTileChange_);const s=e.getKey();s in this.tilesLoadingKeys_&&(delete this.tilesLoadingKeys_[s],--this.tilesLoading_),this.tileChangeCallback_()}}loadMoreTiles(t,e){let n=0;for(;this.tilesLoading_<t&&n<e&&this.getCount()>0;){const s=this.dequeue()[0],r=s.getKey();s.getState()===$.IDLE&&!(r in this.tilesLoadingKeys_)&&(this.tilesLoadingKeys_[r]=!0,++this.tilesLoading_,++n,s.load())}}}function df(i,t,e,n,s){if(!i||!(e in i.wantedTiles)||!i.wantedTiles[e][t.getKey()])return Tr;const r=i.viewState.center,a=n[0]-r[0],o=n[1]-r[1];return 65536*Math.log(s)+Math.sqrt(a*a+o*o)/s}const Yt={ANIMATING:0,INTERACTING:1},Ge={CENTER:"center",RESOLUTION:"resolution",ROTATION:"rotation"};function Gh(i,t,e){return(function(n,s,r,a,o){if(!n)return;if(!s&&!t)return n;const h=t?0:r[0]*s,l=t?0:r[1]*s,c=o?o[0]:0,u=o?o[1]:0;let d=i[0]+h/2+c,f=i[2]-h/2+c,g=i[1]+l/2+u,_=i[3]-l/2+u;d>f&&(d=(f+d)/2,f=d),g>_&&(g=(_+g)/2,_=g);let m=Pt(n[0],d,f),y=Pt(n[1],g,_);if(a&&e&&s){const p=30*s;m+=-p*Math.log(1+Math.max(0,d-n[0])/p)+p*Math.log(1+Math.max(0,n[0]-f)/p),y+=-p*Math.log(1+Math.max(0,g-n[1])/p)+p*Math.log(1+Math.max(0,n[1]-_)/p)}return[m,y]})}function ff(i){return i}function pc(i){return Math.pow(i,3)}function Xn(i){return 1-pc(1-i)}function gf(i){return 3*i*i-2*i*i*i}function _f(i){return i}new Array(6);function ke(){return[1,0,0,1,0,0]}function mf(i,t){return i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=t[3],i[4]=t[4],i[5]=t[5],i}function Ut(i,t){const e=t[0],n=t[1];return t[0]=i[0]*e+i[2]*n+i[4],t[1]=i[1]*e+i[3]*n+i[5],t}function Ze(i,t,e,n,s,r,a,o){const h=Math.sin(r),l=Math.cos(r);return i[0]=n*l,i[1]=s*h,i[2]=-n*h,i[3]=s*l,i[4]=a*n*l-o*n*h+t,i[5]=a*s*h+o*s*l+e,i}function Ec(i,t){const e=yf(t);vt(e!==0,"Transformation matrix cannot be inverted");const n=t[0],s=t[1],r=t[2],a=t[3],o=t[4],h=t[5];return i[0]=a/e,i[1]=-s/e,i[2]=-r/e,i[3]=n/e,i[4]=(r*h-a*o)/e,i[5]=-(n*h-s*o)/e,i}function yf(i){return i[0]*i[3]-i[1]*i[2]}const pf=[1e5,1e5,1e5,1e5,2,2];function Ef(i){return"matrix("+i.join(", ")+")"}function Oh(i){return i.substring(7,i.length-1).split(",").map(parseFloat)}function vf(i,t){const e=Oh(i),n=Oh(t);for(let s=0;s<6;++s)if(Math.round((e[s]-n[s])*pf[s])!==0)return!1;return!0}function Ri(i,t,e,n,s,r,a){r=r||[],a=a||2;let o=0;for(let h=t;h<e;h+=n){const l=i[h],c=i[h+1];r[o++]=s[0]*l+s[2]*c+s[4],r[o++]=s[1]*l+s[3]*c+s[5];for(let u=2;u<a;u++)r[o++]=i[h+u]}return r&&r.length!=o&&(r.length=o),r}function vc(i,t,e,n,s,r,a){a=a||[];const o=Math.cos(s),h=Math.sin(s),l=r[0],c=r[1];let u=0;for(let d=t;d<e;d+=n){const f=i[d]-l,g=i[d+1]-c;a[u++]=l+f*o-g*h,a[u++]=c+f*h+g*o;for(let _=d+2;_<d+n;++_)a[u++]=i[_]}return a&&a.length!=u&&(a.length=u),a}function xf(i,t,e,n,s,r,a,o){o=o||[];const h=a[0],l=a[1];let c=0;for(let u=t;u<e;u+=n){const d=i[u]-h,f=i[u+1]-l;o[c++]=h+s*d,o[c++]=l+r*f;for(let g=u+2;g<u+n;++g)o[c++]=i[g]}return o&&o.length!=c&&(o.length=c),o}function Mf(i,t,e,n,s,r,a){a=a||[];let o=0;for(let h=t;h<e;h+=n){a[o++]=i[h]+s,a[o++]=i[h+1]+r;for(let l=h+2;l<h+n;++l)a[o++]=i[l]}return a&&a.length!=o&&(a.length=o),a}const Dh=ke(),wf=[NaN,NaN];class Sf extends He{constructor(){super(),this.extent_=fe(),this.extentRevision_=-1,this.simplifiedGeometryMaxMinSquaredTolerance=0,this.simplifiedGeometryRevision=0,this.simplifyTransformedInternal=Zl((t,e,n)=>{if(!n)return this.getSimplifiedGeometry(e);const s=this.clone();return s.applyTransform(n),s.getSimplifiedGeometry(e)})}simplifyTransformed(t,e){return this.simplifyTransformedInternal(this.getRevision(),t,e)}clone(){return yt()}closestPointXY(t,e,n,s){return yt()}containsXY(t,e){return this.closestPointXY(t,e,wf,Number.MIN_VALUE)===0}getClosestPoint(t,e){return e=e||[NaN,NaN],this.closestPointXY(t[0],t[1],e,1/0),e}intersectsCoordinate(t){return this.containsXY(t[0],t[1])}computeExtent(t){return yt()}getExtent(t){if(this.extentRevision_!=this.getRevision()){const e=this.computeExtent(this.extent_);(isNaN(e[0])||isNaN(e[1]))&&zs(e),this.extentRevision_=this.getRevision()}return Rd(this.extent_,t)}rotate(t,e){yt()}scale(t,e,n){yt()}simplify(t){return this.getSimplifiedGeometry(t*t)}getSimplifiedGeometry(t){return yt()}getType(){return yt()}applyTransform(t){yt()}intersectsExtent(t){return yt()}translate(t,e){yt()}transform(t,e){const n=Gt(t),s=n.getUnits()=="tile-pixels"?function(r,a,o){const h=n.getExtent(),l=n.getWorldExtent(),c=Wt(l)/Wt(h);Ze(Dh,l[0],l[3],c,-c,0,0,0);const u=Ri(r,0,r.length,o,Dh,a),d=xs(n,e);return d?d(u,u,o):u}:xs(n,e);return this.applyTransform(s),this}}class To extends Sf{constructor(){super(),this.layout="XY",this.stride=2,this.flatCoordinates}computeExtent(t){return xo(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,t)}getCoordinates(){return yt()}getFirstCoordinate(){return this.flatCoordinates.slice(0,this.stride)}getFlatCoordinates(){return this.flatCoordinates}getLastCoordinate(){return this.flatCoordinates.slice(this.flatCoordinates.length-this.stride)}getLayout(){return this.layout}getSimplifiedGeometry(t){if(this.simplifiedGeometryRevision!==this.getRevision()&&(this.simplifiedGeometryMaxMinSquaredTolerance=0,this.simplifiedGeometryRevision=this.getRevision()),t<0||this.simplifiedGeometryMaxMinSquaredTolerance!==0&&t<=this.simplifiedGeometryMaxMinSquaredTolerance)return this;const e=this.getSimplifiedGeometryInternal(t);return e.getFlatCoordinates().length<this.flatCoordinates.length?e:(this.simplifiedGeometryMaxMinSquaredTolerance=t,this)}getSimplifiedGeometryInternal(t){return this}getStride(){return this.stride}setFlatCoordinates(t,e){this.stride=Nh(t),this.layout=t,this.flatCoordinates=e}setCoordinates(t,e){yt()}setLayout(t,e,n){let s;if(t)s=Nh(t);else{for(let r=0;r<n;++r){if(e.length===0){this.layout="XY",this.stride=2;return}e=e[0]}s=e.length,t=Cf(s)}this.layout=t,this.stride=s}applyTransform(t){this.flatCoordinates&&(t(this.flatCoordinates,this.flatCoordinates,this.layout.startsWith("XYZ")?3:2,this.stride),this.changed())}rotate(t,e){const n=this.getFlatCoordinates();if(n){const s=this.getStride();vc(n,0,n.length,s,t,e,n),this.changed()}}scale(t,e,n){e===void 0&&(e=t),n||(n=Ve(this.getExtent()));const s=this.getFlatCoordinates();if(s){const r=this.getStride();xf(s,0,s.length,r,t,e,n,s),this.changed()}}translate(t,e){const n=this.getFlatCoordinates();if(n){const s=this.getStride();Mf(n,0,n.length,s,t,e,n),this.changed()}}}function Cf(i){let t;return i==2?t="XY":i==3?t="XYZ":i==4&&(t="XYZM"),t}function Nh(i){let t;return i=="XY"?t=2:i=="XYZ"||i=="XYM"?t=3:i=="XYZM"&&(t=4),t}function If(i,t,e){const n=i.getFlatCoordinates();if(!n)return null;const s=i.getStride();return Ri(n,0,n.length,s,t,e)}function xc(i,t,e,n){let s=0;const r=i[e-n],a=i[e-n+1];let o=0,h=0;for(;t<e;t+=n){const l=i[t]-r,c=i[t+1]-a;s+=h*l-o*c,o=l,h=c}return s/2}function Rf(i,t,e,n){let s=0;for(let r=0,a=e.length;r<a;++r){const o=e[r];s+=xc(i,t,o,n),t=o}return s}function Fh(i,t,e,n,s,r,a){const o=i[t],h=i[t+1],l=i[e]-o,c=i[e+1]-h;let u;if(l===0&&c===0)u=t;else{const d=((s-o)*l+(r-h)*c)/(l*l+c*c);if(d>1)u=e;else if(d>0){for(let f=0;f<n;++f)a[f]=Se(i[t+f],i[e+f],d);a.length=n;return}else u=t}for(let d=0;d<n;++d)a[d]=i[u+d];a.length=n}function Mc(i,t,e,n,s){let r=i[t],a=i[t+1];for(t+=n;t<e;t+=n){const o=i[t],h=i[t+1],l=In(r,a,o,h);l>s&&(s=l),r=o,a=h}return s}function Af(i,t,e,n,s){for(let r=0,a=e.length;r<a;++r){const o=e[r];s=Mc(i,t,o,n,s),t=o}return s}function wc(i,t,e,n,s,r,a,o,h,l,c){if(t==e)return l;let u,d;if(s===0){if(d=In(a,o,i[t],i[t+1]),d<l){for(u=0;u<n;++u)h[u]=i[t+u];return h.length=n,d}return l}c=c||[NaN,NaN];let f=t+n;for(;f<e;)if(Fh(i,f-n,f,n,a,o,c),d=In(a,o,c[0],c[1]),d<l){for(l=d,u=0;u<n;++u)h[u]=c[u];h.length=n,f+=n}else f+=n*Math.max((Math.sqrt(d)-Math.sqrt(l))/s|0,1);if(Fh(i,e-n,t,n,a,o,c),d=In(a,o,c[0],c[1]),d<l){for(l=d,u=0;u<n;++u)h[u]=c[u];h.length=n}return l}function Tf(i,t,e,n,s,r,a,o,h,l,c){c=c||[NaN,NaN];for(let u=0,d=e.length;u<d;++u){const f=e[u];l=wc(i,t,f,n,s,r,a,o,h,l,c),t=f}return l}function bf(i,t,e,n){for(let s=0,r=e.length;s<r;++s)i[t++]=e[s];return t}function Sc(i,t,e,n){for(let s=0,r=e.length;s<r;++s){const a=e[s];for(let o=0;o<n;++o)i[t++]=a[o]}return t}function Pf(i,t,e,n,s){s=s||[];let r=0;for(let a=0,o=e.length;a<o;++a){const h=Sc(i,t,e[a],n);s[r++]=h,t=h}return s.length=r,s}function xn(i,t,e,n,s){s=s!==void 0?s:[];let r=0;for(let a=t;a<e;a+=n)s[r++]=i.slice(a,a+n);return s.length=r,s}function br(i,t,e,n,s){s=s!==void 0?s:[];let r=0;for(let a=0,o=e.length;a<o;++a){const h=e[a];s[r++]=xn(i,t,h,n,s[r]),t=h}return s.length=r,s}function kh(i,t,e,n,s){s=s!==void 0?s:[];let r=0;for(let a=0,o=e.length;a<o;++a){const h=e[a];s[r++]=h.length===1&&h[0]===t?[]:br(i,t,h,n,s[r]),t=h[h.length-1]}return s.length=r,s}function bo(i,t,e,n,s,r,a){const o=(e-t)/n;if(o<3){for(;t<e;t+=n)r[a++]=i[t],r[a++]=i[t+1];return a}const h=new Array(o);h[0]=1,h[o-1]=1;const l=[t,e-n];let c=0;for(;l.length>0;){const u=l.pop(),d=l.pop();let f=0;const g=i[d],_=i[d+1],m=i[u],y=i[u+1];for(let p=d+n;p<u;p+=n){const x=i[p],v=i[p+1],M=bd(x,v,g,_,m,y);M>f&&(c=p,f=M)}f>s&&(h[(c-t)/n]=1,d+n<c&&l.push(d,c),c+n<u&&l.push(c,u))}for(let u=0;u<o;++u)h[u]&&(r[a++]=i[t+u*n],r[a++]=i[t+u*n+1]);return a}function Lf(i,t,e,n,s,r,a,o){for(let h=0,l=e.length;h<l;++h){const c=e[h];a=bo(i,t,c,n,s,r,a),o.push(a),t=c}return a}function zi(i,t){return t*Math.round(i/t)}function Gf(i,t,e,n,s,r,a){if(t==e)return a;let o=zi(i[t],s),h=zi(i[t+1],s);t+=n,r[a++]=o,r[a++]=h;let l,c;do if(l=zi(i[t],s),c=zi(i[t+1],s),t+=n,t==e)return r[a++]=l,r[a++]=c,a;while(l==o&&c==h);for(;t<e;){const u=zi(i[t],s),d=zi(i[t+1],s);if(t+=n,u==l&&d==c)continue;const f=l-o,g=c-h,_=u-o,m=d-h;if(f*m==g*_&&(f<0&&_<f||f==_||f>0&&_>f)&&(g<0&&m<g||g==m||g>0&&m>g)){l=u,c=d;continue}r[a++]=l,r[a++]=c,o=l,h=c,l=u,c=d}return r[a++]=l,r[a++]=c,a}function Cc(i,t,e,n,s,r,a,o){for(let h=0,l=e.length;h<l;++h){const c=e[h];a=Gf(i,t,c,n,s,r,a),o.push(a),t=c}return a}class ws extends To{constructor(t,e){super(),this.maxDelta_=-1,this.maxDeltaRevision_=-1,e!==void 0&&!Array.isArray(t[0])?this.setFlatCoordinates(e,t):this.setCoordinates(t,e)}clone(){return new ws(this.flatCoordinates.slice(),this.layout)}closestPointXY(t,e,n,s){return s<Jl(this.getExtent(),t,e)?s:(this.maxDeltaRevision_!=this.getRevision()&&(this.maxDelta_=Math.sqrt(Mc(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,0)),this.maxDeltaRevision_=this.getRevision()),wc(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,this.maxDelta_,!0,t,e,n,s))}getArea(){return xc(this.flatCoordinates,0,this.flatCoordinates.length,this.stride)}getCoordinates(){return xn(this.flatCoordinates,0,this.flatCoordinates.length,this.stride)}getSimplifiedGeometryInternal(t){const e=[];return e.length=bo(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,t,e,0),new ws(e,"XY")}getType(){return"LinearRing"}intersectsExtent(t){return!1}setCoordinates(t,e){this.setLayout(e,t,1),this.flatCoordinates||(this.flatCoordinates=[]),this.flatCoordinates.length=Sc(this.flatCoordinates,0,t,this.stride),this.changed()}}let Po=class Ic extends To{constructor(t,e){super(),this.setCoordinates(t,e)}clone(){const t=new Ic(this.flatCoordinates.slice(),this.layout);return t.applyProperties(this),t}closestPointXY(t,e,n,s){const r=this.flatCoordinates,a=In(t,e,r[0],r[1]);if(a<s){const o=this.stride;for(let h=0;h<o;++h)n[h]=r[h];return n.length=o,a}return s}getCoordinates(){return this.flatCoordinates.slice()}computeExtent(t){return vo(this.flatCoordinates,t)}getType(){return"Point"}intersectsExtent(t){return Ql(t,this.flatCoordinates[0],this.flatCoordinates[1])}setCoordinates(t,e){this.setLayout(e,t,0),this.flatCoordinates||(this.flatCoordinates=[]),this.flatCoordinates.length=bf(this.flatCoordinates,0,t,this.stride),this.changed()}};function Of(i,t,e,n,s){return!ic(s,function(a){return!Xi(i,t,e,n,a[0],a[1])})}function Xi(i,t,e,n,s,r){let a=0,o=i[e-n],h=i[e-n+1];for(;t<e;t+=n){const l=i[t],c=i[t+1];h<=r?c>r&&(l-o)*(r-h)-(s-o)*(c-h)>0&&a++:c<=r&&(l-o)*(r-h)-(s-o)*(c-h)<0&&a--,o=l,h=c}return a!==0}function Rc(i,t,e,n,s,r){if(e.length===0||!Xi(i,t,e[0],n,s,r))return!1;for(let a=1,o=e.length;a<o;++a)if(Xi(i,e[a-1],e[a],n,s,r))return!1;return!0}function Lo(i,t,e,n,s,r,a){let o,h,l,c,u,d,f;const g=s[r+1],_=[];for(let p=0,x=e.length;p<x;++p){const v=e[p];for(c=i[v-n],d=i[v-n+1],o=t;o<v;o+=n)u=i[o],f=i[o+1],(g<=d&&f<=g||d<=g&&g<=f)&&(l=(g-d)/(f-d)*(u-c)+c,_.push(l)),c=u,d=f}let m=NaN,y=-1/0;for(_.sort(ri),c=_[0],o=1,h=_.length;o<h;++o){u=_[o];const p=Math.abs(u-c);p>y&&(l=(c+u)/2,Rc(i,t,e,n,l,g)&&(m=l,y=p)),c=u}return isNaN(m)&&(m=s[r]),a?(a.push(m,g,y),a):[m,g,y]}function Df(i,t,e,n,s){let r=[];for(let a=0,o=e.length;a<o;++a){const h=e[a];r=Lo(i,t,h,n,s,2*a,r),t=h[h.length-1]}return r}function Nf(i,t,e,n,s){let r;for(t+=n;t<e;t+=n)if(r=s(i.slice(t-n,t),i.slice(t,t+n)),r)return r;return!1}function Ac(i,t,e,n,s,r){return r=r??ec(fe(),i,t,e,n),ie(s,r)?r[0]>=s[0]&&r[2]<=s[2]||r[1]>=s[1]&&r[3]<=s[3]?!0:Nf(i,t,e,n,function(a,o){return Ad(s,a,o)}):!1}function Tc(i,t,e,n,s){return!!(Ac(i,t,e,n,s)||Xi(i,t,e,n,s[0],s[1])||Xi(i,t,e,n,s[0],s[3])||Xi(i,t,e,n,s[2],s[1])||Xi(i,t,e,n,s[2],s[3]))}function Ff(i,t,e,n,s){if(!Tc(i,t,e[0],n,s))return!1;if(e.length===1)return!0;for(let r=1,a=e.length;r<a;++r)if(Of(i,e[r-1],e[r],n,s)&&!Ac(i,e[r-1],e[r],n,s))return!1;return!0}function kf(i,t,e,n){for(;t<e-n;){for(let s=0;s<n;++s){const r=i[t+s];i[t+s]=i[e-n+s],i[e-n+s]=r}t+=n,e-=n}}function Go(i,t,e,n){let s=0,r=i[e-n],a=i[e-n+1];for(;t<e;t+=n){const o=i[t],h=i[t+1];s+=(o-r)*(h+a),r=o,a=h}return s===0?void 0:s>0}function zf(i,t,e,n,s){s=s!==void 0?s:!1;for(let r=0,a=e.length;r<a;++r){const o=e[r],h=Go(i,t,o,n);if(r===0){if(s&&h||!s&&!h)return!1}else if(s&&!h||!s&&h)return!1;t=o}return!0}function zh(i,t,e,n,s){s=s!==void 0?s:!1;for(let r=0,a=e.length;r<a;++r){const o=e[r],h=Go(i,t,o,n);(r===0?s&&h||!s&&!h:s&&!h||!s&&h)&&kf(i,t,o,n),t=o}return t}function Uf(i,t){const e=[];let n=0,s=0,r;for(let a=0,o=t.length;a<o;++a){const h=t[a],l=Go(i,n,h,2);if(r===void 0&&(r=l),l===r)e.push(t.slice(s,a+1));else{if(e.length===0)continue;e[e.length-1].push(t[s])}s=a+1,n=h}return e}class Fn extends To{constructor(t,e,n){super(),this.ends_=[],this.flatInteriorPointRevision_=-1,this.flatInteriorPoint_=null,this.maxDelta_=-1,this.maxDeltaRevision_=-1,this.orientedRevision_=-1,this.orientedFlatCoordinates_=null,e!==void 0&&n?(this.setFlatCoordinates(e,t),this.ends_=n):this.setCoordinates(t,e)}appendLinearRing(t){this.flatCoordinates?_o(this.flatCoordinates,t.getFlatCoordinates()):this.flatCoordinates=t.getFlatCoordinates().slice(),this.ends_.push(this.flatCoordinates.length),this.changed()}clone(){const t=new Fn(this.flatCoordinates.slice(),this.layout,this.ends_.slice());return t.applyProperties(this),t}closestPointXY(t,e,n,s){return s<Jl(this.getExtent(),t,e)?s:(this.maxDeltaRevision_!=this.getRevision()&&(this.maxDelta_=Math.sqrt(Af(this.flatCoordinates,0,this.ends_,this.stride,0)),this.maxDeltaRevision_=this.getRevision()),Tf(this.flatCoordinates,0,this.ends_,this.stride,this.maxDelta_,!0,t,e,n,s))}containsXY(t,e){return Rc(this.getOrientedFlatCoordinates(),0,this.ends_,this.stride,t,e)}getArea(){return Rf(this.getOrientedFlatCoordinates(),0,this.ends_,this.stride)}getCoordinates(t){let e;return t!==void 0?(e=this.getOrientedFlatCoordinates().slice(),zh(e,0,this.ends_,this.stride,t)):e=this.flatCoordinates,br(e,0,this.ends_,this.stride)}getEnds(){return this.ends_}getFlatInteriorPoint(){if(this.flatInteriorPointRevision_!=this.getRevision()){const t=Ve(this.getExtent());this.flatInteriorPoint_=Lo(this.getOrientedFlatCoordinates(),0,this.ends_,this.stride,t,0),this.flatInteriorPointRevision_=this.getRevision()}return this.flatInteriorPoint_}getInteriorPoint(){return new Po(this.getFlatInteriorPoint(),"XYM")}getLinearRingCount(){return this.ends_.length}getLinearRing(t){return t<0||this.ends_.length<=t?null:new ws(this.flatCoordinates.slice(t===0?0:this.ends_[t-1],this.ends_[t]),this.layout)}getLinearRings(){const t=this.layout,e=this.flatCoordinates,n=this.ends_,s=[];let r=0;for(let a=0,o=n.length;a<o;++a){const h=n[a],l=new ws(e.slice(r,h),t);s.push(l),r=h}return s}getOrientedFlatCoordinates(){if(this.orientedRevision_!=this.getRevision()){const t=this.flatCoordinates;zf(t,0,this.ends_,this.stride)?this.orientedFlatCoordinates_=t:(this.orientedFlatCoordinates_=t.slice(),this.orientedFlatCoordinates_.length=zh(this.orientedFlatCoordinates_,0,this.ends_,this.stride)),this.orientedRevision_=this.getRevision()}return this.orientedFlatCoordinates_}getSimplifiedGeometryInternal(t){const e=[],n=[];return e.length=Cc(this.flatCoordinates,0,this.ends_,this.stride,Math.sqrt(t),e,0,n),new Fn(e,"XY",n)}getType(){return"Polygon"}intersectsExtent(t){return Ff(this.getOrientedFlatCoordinates(),0,this.ends_,this.stride,t)}setCoordinates(t,e){this.setLayout(e,t,2),this.flatCoordinates||(this.flatCoordinates=[]);const n=Pf(this.flatCoordinates,0,t,this.stride,this.ends_);this.flatCoordinates.length=n.length===0?0:n[n.length-1],this.changed()}}function Uh(i){if(en(i))throw new Error("Cannot create polygon from empty extent");const t=i[0],e=i[1],n=i[2],s=i[3],r=[t,e,t,s,n,s,n,e,t,e];return new Fn(r,"XY",[r.length])}function Oo(i,t,e,n){const s=gt(t)/e[0],r=Wt(t)/e[1];return n?Math.min(i,Math.max(s,r)):Math.min(i,Math.min(s,r))}function Do(i,t,e){let n=Math.min(i,t);const s=50;return n*=Math.log(1+s*Math.max(0,i/t-1))/s+1,e&&(n=Math.max(n,e),n/=Math.log(1+s*Math.max(0,e/i-1))/s+1),Pt(n,e/2,t*2)}function Wf(i,t,e,n){return t=t!==void 0?t:!0,(function(s,r,a,o){if(s!==void 0){const h=i[0],l=i[i.length-1],c=e?Oo(h,e,a,n):h;if(o)return t?Do(s,c,l):Pt(s,l,c);const u=Math.min(c,s),d=Math.floor(qr(i,u,r));return i[d]>c&&d<i.length-1?i[d+1]:i[d]}})}function Bf(i,t,e,n,s,r){return n=n!==void 0?n:!0,e=e!==void 0?e:0,(function(a,o,h,l){if(a!==void 0){const c=s?Oo(t,s,h,r):t;if(l)return n?Do(a,c,e):Pt(a,e,c);const u=1e-9,d=Math.ceil(Math.log(t/c)/Math.log(i)-u),f=-o*(.5-u)+.5,g=Math.min(c,a),_=Math.floor(Math.log(t/g)/Math.log(i)+f),m=Math.max(d,_),y=t/Math.pow(i,m);return Pt(y,e,c)}})}function Wh(i,t,e,n,s){return e=e!==void 0?e:!0,(function(r,a,o,h){if(r!==void 0){const l=n?Oo(i,n,o,s):i;return!e||!h?Pt(r,t,l):Do(r,l,t)}})}function No(i){if(i!==void 0)return 0}function Bh(i){if(i!==void 0)return i}function Xf(i){const t=2*Math.PI/i;return(function(e,n){if(n)return e;if(e!==void 0)return e=Math.floor(e/t+.5)*t,e})}function qf(i){const t=Ii(5);return(function(e,n){return n||e===void 0?e:Math.abs(e)<=t?0:e})}const jf=42,Fo=256,ga=0;class Be extends He{constructor(t){super(),this.on,this.once,this.un,t=Object.assign({},t),this.hints_=[0,0],this.animations_=[],this.updateAnimationKey_,this.projection_=Ao(t.projection,"EPSG:3857"),this.viewportSize_=[100,100],this.targetCenter_=null,this.targetResolution_,this.targetRotation_,this.nextCenter_=null,this.nextResolution_,this.nextRotation_,this.cancelAnchor_=void 0,t.projection&&nf(),t.center&&(t.center=De(t.center,this.projection_)),t.extent&&(t.extent=qe(t.extent,this.projection_)),this.applyOptions_(t)}applyOptions_(t){const e=Object.assign({},t);for(const o in Ge)delete e[o];this.setProperties(e,!0);const n=Kf(t);this.maxResolution_=n.maxResolution,this.minResolution_=n.minResolution,this.zoomFactor_=n.zoomFactor,this.resolutions_=t.resolutions,this.padding_=t.padding,this.minZoom_=n.minZoom;const s=Yf(t),r=n.constraint,a=Vf(t);this.constraints_={center:s,resolution:r,rotation:a},this.setRotation(t.rotation!==void 0?t.rotation:0),this.setCenterInternal(t.center!==void 0?t.center:null),t.resolution!==void 0?this.setResolution(t.resolution):t.zoom!==void 0&&this.setZoom(t.zoom)}get padding(){return this.padding_}set padding(t){let e=this.padding_;this.padding_=t;const n=this.getCenterInternal();if(n){const s=t||[0,0,0,0];e=e||[0,0,0,0];const r=this.getResolution(),a=r/2*(s[3]-e[3]+e[1]-s[1]),o=r/2*(s[0]-e[0]+e[2]-s[2]);this.setCenterInternal([n[0]+a,n[1]-o])}}getUpdatedOptions_(t){const e=this.getProperties();return e.resolution!==void 0?e.resolution=this.getResolution():e.zoom=this.getZoom(),e.center=this.getCenterInternal(),e.rotation=this.getRotation(),Object.assign({},e,t)}animate(t){this.isDef()&&!this.getAnimating()&&this.resolveConstraints(0);const e=new Array(arguments.length);for(let n=0;n<e.length;++n){let s=arguments[n];s.center&&(s=Object.assign({},s),s.center=De(s.center,this.getProjection())),s.anchor&&(s=Object.assign({},s),s.anchor=De(s.anchor,this.getProjection())),e[n]=s}this.animateInternal.apply(this,e)}animateInternal(t){let e=arguments.length,n;e>1&&typeof arguments[e-1]=="function"&&(n=arguments[e-1],--e);let s=0;for(;s<e&&!this.isDef();++s){const c=arguments[s];c.center&&this.setCenterInternal(c.center),c.zoom!==void 0?this.setZoom(c.zoom):c.resolution&&this.setResolution(c.resolution),c.rotation!==void 0&&this.setRotation(c.rotation)}if(s===e){n&&hr(n,!0);return}let r=Date.now(),a=this.targetCenter_.slice(),o=this.targetResolution_,h=this.targetRotation_;const l=[];for(;s<e;++s){const c=arguments[s],u={start:r,complete:!1,anchor:c.anchor,duration:c.duration!==void 0?c.duration:1e3,easing:c.easing||gf,callback:n};if(c.center&&(u.sourceCenter=a,u.targetCenter=c.center.slice(),a=u.targetCenter),c.zoom!==void 0?(u.sourceResolution=o,u.targetResolution=this.getResolutionForZoom(c.zoom),o=u.targetResolution):c.resolution&&(u.sourceResolution=o,u.targetResolution=c.resolution,o=u.targetResolution),c.rotation!==void 0){u.sourceRotation=h;const d=Yi(c.rotation-h+Math.PI,2*Math.PI)-Math.PI;u.targetRotation=h+d,h=u.targetRotation}Zf(u)?u.complete=!0:r+=u.duration,l.push(u)}this.animations_.push(l),this.setHint(Yt.ANIMATING,1),this.updateAnimations_()}getAnimating(){return this.hints_[Yt.ANIMATING]>0}getInteracting(){return this.hints_[Yt.INTERACTING]>0}cancelAnimations(){this.setHint(Yt.ANIMATING,-this.hints_[Yt.ANIMATING]);let t;for(let e=0,n=this.animations_.length;e<n;++e){const s=this.animations_[e];if(s[0].callback&&hr(s[0].callback,!1),!t)for(let r=0,a=s.length;r<a;++r){const o=s[r];if(!o.complete){t=o.anchor;break}}}this.animations_.length=0,this.cancelAnchor_=t,this.nextCenter_=null,this.nextResolution_=NaN,this.nextRotation_=NaN}updateAnimations_(){if(this.updateAnimationKey_!==void 0&&(cancelAnimationFrame(this.updateAnimationKey_),this.updateAnimationKey_=void 0),!this.getAnimating())return;const t=Date.now();let e=!1;for(let n=this.animations_.length-1;n>=0;--n){const s=this.animations_[n];let r=!0;for(let a=0,o=s.length;a<o;++a){const h=s[a];if(h.complete)continue;const l=t-h.start;let c=h.duration>0?l/h.duration:1;c>=1?(h.complete=!0,c=1):r=!1;const u=h.easing(c);if(h.sourceCenter){const d=h.sourceCenter[0],f=h.sourceCenter[1],g=h.targetCenter[0],_=h.targetCenter[1];this.nextCenter_=h.targetCenter;const m=d+u*(g-d),y=f+u*(_-f);this.targetCenter_=[m,y]}if(h.sourceResolution&&h.targetResolution){const d=u===1?h.targetResolution:h.sourceResolution+u*(h.targetResolution-h.sourceResolution);if(h.anchor){const f=this.getViewportSize_(this.getRotation()),g=this.constraints_.resolution(d,0,f,!0);this.targetCenter_=this.calculateCenterZoom(g,h.anchor)}this.nextResolution_=h.targetResolution,this.targetResolution_=d,this.applyTargetState_(!0)}if(h.sourceRotation!==void 0&&h.targetRotation!==void 0){const d=u===1?Yi(h.targetRotation+Math.PI,2*Math.PI)-Math.PI:h.sourceRotation+u*(h.targetRotation-h.sourceRotation);if(h.anchor){const f=this.constraints_.rotation(d,!0);this.targetCenter_=this.calculateCenterRotate(f,h.anchor)}this.nextRotation_=h.targetRotation,this.targetRotation_=d}if(this.applyTargetState_(!0),e=!0,!h.complete)break}if(r){this.animations_[n]=null,this.setHint(Yt.ANIMATING,-1),this.nextCenter_=null,this.nextResolution_=NaN,this.nextRotation_=NaN;const a=s[0].callback;a&&hr(a,!0)}}this.animations_=this.animations_.filter(Boolean),e&&this.updateAnimationKey_===void 0&&(this.updateAnimationKey_=requestAnimationFrame(this.updateAnimations_.bind(this)))}calculateCenterRotate(t,e){let n;const s=this.getCenterInternal();return s!==void 0&&(n=[s[0]-e[0],s[1]-e[1]],wo(n,t-this.getRotation()),ac(n,e)),n}calculateCenterZoom(t,e){let n;const s=this.getCenterInternal(),r=this.getResolution();if(s!==void 0&&r!==void 0){const a=e[0]-t*(e[0]-s[0])/r,o=e[1]-t*(e[1]-s[1])/r;n=[a,o]}return n}getViewportSize_(t){const e=this.viewportSize_;if(t){const n=e[0],s=e[1];return[Math.abs(n*Math.cos(t))+Math.abs(s*Math.sin(t)),Math.abs(n*Math.sin(t))+Math.abs(s*Math.cos(t))]}return e}setViewportSize(t){this.viewportSize_=Array.isArray(t)?t.slice():[100,100],this.getAnimating()||this.resolveConstraints(0)}getCenter(){const t=this.getCenterInternal();return t&&to(t,this.getProjection())}getCenterInternal(){return this.get(Ge.CENTER)}getConstraints(){return this.constraints_}getConstrainResolution(){return this.get("constrainResolution")}getHints(t){return t!==void 0?(t[0]=this.hints_[0],t[1]=this.hints_[1],t):this.hints_.slice()}calculateExtent(t){const e=this.calculateExtentInternal(t);return Ar(e,this.getProjection())}calculateExtentInternal(t){t=t||this.getViewportSizeMinusPadding_();const e=this.getCenterInternal();vt(e,"The view center is not defined");const n=this.getResolution();vt(n!==void 0,"The view resolution is not defined");const s=this.getRotation();return vt(s!==void 0,"The view rotation is not defined"),vs(e,n,s,t)}getMaxResolution(){return this.maxResolution_}getMinResolution(){return this.minResolution_}getMaxZoom(){return this.getZoomForResolution(this.minResolution_)}setMaxZoom(t){this.applyOptions_(this.getUpdatedOptions_({maxZoom:t}))}getMinZoom(){return this.getZoomForResolution(this.maxResolution_)}setMinZoom(t){this.applyOptions_(this.getUpdatedOptions_({minZoom:t}))}setConstrainResolution(t){this.applyOptions_(this.getUpdatedOptions_({constrainResolution:t}))}getProjection(){return this.projection_}getResolution(){return this.get(Ge.RESOLUTION)}getResolutions(){return this.resolutions_}getResolutionForExtent(t,e){return this.getResolutionForExtentInternal(qe(t,this.getProjection()),e)}getResolutionForExtentInternal(t,e){e=e||this.getViewportSizeMinusPadding_();const n=gt(t)/e[0],s=Wt(t)/e[1];return Math.max(n,s)}getResolutionForValueFunction(t){t=t||2;const e=this.getConstrainedResolution(this.maxResolution_),n=this.minResolution_,s=Math.log(e/n)/Math.log(t);return(function(r){return e/Math.pow(t,r*s)})}getRotation(){return this.get(Ge.ROTATION)}getValueForResolutionFunction(t){const e=Math.log(t||2),n=this.getConstrainedResolution(this.maxResolution_),s=this.minResolution_,r=Math.log(n/s)/e;return(function(a){return Math.log(n/a)/e/r})}getViewportSizeMinusPadding_(t){let e=this.getViewportSize_(t);const n=this.padding_;return n&&(e=[e[0]-n[1]-n[3],e[1]-n[0]-n[2]]),e}getState(){const t=this.getProjection(),e=this.getResolution(),n=this.getRotation();let s=this.getCenterInternal();const r=this.padding_;if(r){const a=this.getViewportSizeMinusPadding_();s=_a(s,this.getViewportSize_(),[a[0]/2+r[3],a[1]/2+r[0]],e,n)}return{center:s.slice(0),projection:t!==void 0?t:null,resolution:e,nextCenter:this.nextCenter_,nextResolution:this.nextResolution_,nextRotation:this.nextRotation_,rotation:n,zoom:this.getZoom()}}getViewStateAndExtent(){return{viewState:this.getState(),extent:this.calculateExtent()}}getZoom(){let t;const e=this.getResolution();return e!==void 0&&(t=this.getZoomForResolution(e)),t}getZoomForResolution(t){let e=this.minZoom_||0,n,s;if(this.resolutions_){const r=qr(this.resolutions_,t,1);e=r,n=this.resolutions_[r],r==this.resolutions_.length-1?s=2:s=n/this.resolutions_[r+1]}else n=this.maxResolution_,s=this.zoomFactor_;return e+Math.log(n/t)/Math.log(s)}getResolutionForZoom(t){if(this.resolutions_?.length){if(this.resolutions_.length===1)return this.resolutions_[0];const e=Pt(Math.floor(t),0,this.resolutions_.length-2),n=this.resolutions_[e]/this.resolutions_[e+1];return this.resolutions_[e]/Math.pow(n,Pt(t-e,0,1))}return this.maxResolution_/Math.pow(this.zoomFactor_,t-this.minZoom_)}fit(t,e){let n;if(vt(Array.isArray(t)||typeof t.getSimplifiedGeometry=="function","Invalid extent or geometry provided as `geometry`"),Array.isArray(t)){vt(!en(t),"Cannot fit empty extent provided as `geometry`");const s=qe(t,this.getProjection());n=Uh(s)}else if(t.getType()==="Circle"){const s=qe(t.getExtent(),this.getProjection());n=Uh(s),n.rotate(this.getRotation(),Ve(s))}else{const s=Ms();s?n=t.clone().transform(s,this.getProjection()):n=t}this.fitInternal(n,e)}rotatedExtentForGeometry(t){const e=this.getRotation(),n=Math.cos(e),s=Math.sin(-e),r=t.getFlatCoordinates(),a=t.getStride();let o=1/0,h=1/0,l=-1/0,c=-1/0;for(let u=0,d=r.length;u<d;u+=a){const f=r[u]*n-r[u+1]*s,g=r[u]*s+r[u+1]*n;o=Math.min(o,f),h=Math.min(h,g),l=Math.max(l,f),c=Math.max(c,g)}return[o,h,l,c]}fitInternal(t,e){e=e||{};let n=e.size;n||(n=this.getViewportSizeMinusPadding_());const s=e.padding!==void 0?e.padding:[0,0,0,0],r=e.nearest!==void 0?e.nearest:!1;let a;e.minResolution!==void 0?a=e.minResolution:e.maxZoom!==void 0?a=this.getResolutionForZoom(e.maxZoom):a=0;const o=this.rotatedExtentForGeometry(t);let h=this.getResolutionForExtentInternal(o,[n[0]-s[1]-s[3],n[1]-s[0]-s[2]]);h=isNaN(h)?a:Math.max(h,a),h=this.getConstrainedResolution(h,r?0:1);const l=this.getRotation(),c=Math.sin(l),u=Math.cos(l),d=Ve(o);d[0]+=(s[1]-s[3])/2*h,d[1]+=(s[0]-s[2])/2*h;const f=d[0]*u-d[1]*c,g=d[1]*u+d[0]*c,_=this.getConstrainedCenter([f,g],h),m=e.callback?e.callback:Es;e.duration!==void 0?this.animateInternal({resolution:h,center:_,duration:e.duration,easing:e.easing},m):(this.targetResolution_=h,this.targetCenter_=_,this.applyTargetState_(!1,!0),hr(m,!0))}centerOn(t,e,n){this.centerOnInternal(De(t,this.getProjection()),e,n)}centerOnInternal(t,e,n){this.setCenterInternal(_a(t,e,n,this.getResolution(),this.getRotation()))}calculateCenterShift(t,e,n,s){let r;const a=this.padding_;if(a&&t){const o=this.getViewportSizeMinusPadding_(-n),h=_a(t,s,[o[0]/2+a[3],o[1]/2+a[0]],e,n);r=[t[0]-h[0],t[1]-h[1]]}return r}isDef(){return!!this.getCenterInternal()&&this.getResolution()!==void 0}adjustCenter(t){const e=to(this.targetCenter_,this.getProjection());this.setCenter([e[0]+t[0],e[1]+t[1]])}adjustCenterInternal(t){const e=this.targetCenter_;this.setCenterInternal([e[0]+t[0],e[1]+t[1]])}adjustResolution(t,e){e=e&&De(e,this.getProjection()),this.adjustResolutionInternal(t,e)}adjustResolutionInternal(t,e){const n=this.getAnimating()||this.getInteracting(),s=this.getViewportSize_(this.getRotation()),r=this.constraints_.resolution(this.targetResolution_*t,0,s,n);e&&(this.targetCenter_=this.calculateCenterZoom(r,e)),this.targetResolution_*=t,this.applyTargetState_()}adjustZoom(t,e){this.adjustResolution(Math.pow(this.zoomFactor_,-t),e)}adjustRotation(t,e){e&&(e=De(e,this.getProjection())),this.adjustRotationInternal(t,e)}adjustRotationInternal(t,e){const n=this.getAnimating()||this.getInteracting(),s=this.constraints_.rotation(this.targetRotation_+t,n);e&&(this.targetCenter_=this.calculateCenterRotate(s,e)),this.targetRotation_+=t,this.applyTargetState_()}setCenter(t){this.setCenterInternal(t&&De(t,this.getProjection()))}setCenterInternal(t){this.targetCenter_=t,this.applyTargetState_()}setHint(t,e){return this.hints_[t]+=e,this.changed(),this.hints_[t]}setResolution(t){this.targetResolution_=t,this.applyTargetState_()}setRotation(t){this.targetRotation_=t,this.applyTargetState_()}setZoom(t){this.setResolution(this.getResolutionForZoom(t))}applyTargetState_(t,e){const n=this.getAnimating()||this.getInteracting()||e,s=this.constraints_.rotation(this.targetRotation_,n),r=this.getViewportSize_(s),a=this.constraints_.resolution(this.targetResolution_,0,r,n),o=this.constraints_.center(this.targetCenter_,a,r,n,this.calculateCenterShift(this.targetCenter_,a,s,r));this.get(Ge.ROTATION)!==s&&this.set(Ge.ROTATION,s),this.get(Ge.RESOLUTION)!==a&&(this.set(Ge.RESOLUTION,a),this.set("zoom",this.getZoom(),!0)),(!o||!this.get(Ge.CENTER)||!Sr(this.get(Ge.CENTER),o))&&this.set(Ge.CENTER,o),this.getAnimating()&&!t&&this.cancelAnimations(),this.cancelAnchor_=void 0}resolveConstraints(t,e,n){t=t!==void 0?t:200;const s=e||0,r=this.constraints_.rotation(this.targetRotation_),a=this.getViewportSize_(r),o=this.constraints_.resolution(this.targetResolution_,s,a),h=this.constraints_.center(this.targetCenter_,o,a,!1,this.calculateCenterShift(this.targetCenter_,o,r,a));if(t===0&&!this.cancelAnchor_){this.targetResolution_=o,this.targetRotation_=r,this.targetCenter_=h,this.applyTargetState_();return}n=n||(t===0?this.cancelAnchor_:void 0),this.cancelAnchor_=void 0,(this.getResolution()!==o||this.getRotation()!==r||!this.getCenterInternal()||!Sr(this.getCenterInternal(),h))&&(this.getAnimating()&&this.cancelAnimations(),this.animateInternal({rotation:r,center:h,resolution:o,duration:t,easing:Xn,anchor:n}))}beginInteraction(){this.resolveConstraints(0),this.setHint(Yt.INTERACTING,1)}endInteraction(t,e,n){n=n&&De(n,this.getProjection()),this.endInteractionInternal(t,e,n)}endInteractionInternal(t,e,n){this.getInteracting()&&(this.setHint(Yt.INTERACTING,-1),this.resolveConstraints(t,e,n))}getConstrainedCenter(t,e){const n=this.getViewportSize_(this.getRotation());return this.constraints_.center(t,e||this.getResolution(),n)}getConstrainedZoom(t,e){const n=this.getResolutionForZoom(t);return this.getZoomForResolution(this.getConstrainedResolution(n,e))}getConstrainedResolution(t,e){e=e||0;const n=this.getViewportSize_(this.getRotation());return this.constraints_.resolution(t,e,n)}}function hr(i,t){setTimeout(function(){i(t)},0)}function Yf(i){if(i.extent!==void 0){const e=i.smoothExtentConstraint!==void 0?i.smoothExtentConstraint:!0;return Gh(i.extent,i.constrainOnlyCenter,e)}const t=Ao(i.projection,"EPSG:3857");if(i.multiWorld!==!0&&t.isGlobal()){const e=t.getExtent().slice();return e[0]=-1/0,e[2]=1/0,Gh(e,!1,!1)}return ff}function Kf(i){let t,e,n,a=i.minZoom!==void 0?i.minZoom:ga,o=i.maxZoom!==void 0?i.maxZoom:28;const h=i.zoomFactor!==void 0?i.zoomFactor:2,l=i.multiWorld!==void 0?i.multiWorld:!1,c=i.smoothResolutionConstraint!==void 0?i.smoothResolutionConstraint:!0,u=i.showFullExtent!==void 0?i.showFullExtent:!1,d=Ao(i.projection,"EPSG:3857"),f=d.getExtent();let g=i.constrainOnlyCenter,_=i.extent;if(!l&&!_&&d.isGlobal()&&(g=!1,_=f),i.resolutions!==void 0){const m=i.resolutions;e=m[a],n=m[o]!==void 0?m[o]:m[m.length-1],i.constrainResolution?t=Wf(m,c,!g&&_,u):t=Wh(e,n,c,!g&&_,u)}else{const y=(f?Math.max(gt(f),Wt(f)):360*So.degrees/d.getMetersPerUnit())/Fo/Math.pow(2,ga),p=y/Math.pow(2,28-ga);e=i.maxResolution,e!==void 0?a=0:e=y/Math.pow(h,a),n=i.minResolution,n===void 0&&(i.maxZoom!==void 0?i.maxResolution!==void 0?n=e/Math.pow(h,o):n=y/Math.pow(h,o):n=p),o=a+Math.floor(Math.log(e/n)/Math.log(h)),n=e/Math.pow(h,o-a),i.constrainResolution?t=Bf(h,e,n,c,!g&&_,u):t=Wh(e,n,c,!g&&_,u)}return{constraint:t,maxResolution:e,minResolution:n,minZoom:a,zoomFactor:h}}function Vf(i){if(i.enableRotation!==void 0?i.enableRotation:!0){const e=i.constrainRotation;return e===void 0||e===!0?qf():e===!1?Bh:typeof e=="number"?Xf(e):Bh}return No}function Zf(i){return!(i.sourceCenter&&i.targetCenter&&!Sr(i.sourceCenter,i.targetCenter)||i.sourceResolution!==i.targetResolution||i.sourceRotation!==i.targetRotation)}function _a(i,t,e,n,s){const r=Math.cos(-s);let a=Math.sin(-s),o=i[0]*r-i[1]*a,h=i[1]*r+i[0]*a;o+=(t[0]/2-e[0])*n,h+=(e[1]-t[1]/2)*n,a=-a;const l=o*r-h*a,c=h*r+o*a;return[l,c]}class $f extends Eo{constructor(t){t=t||{},super({element:document.createElement("div"),render:t.render,target:t.target});const e=t.className!==void 0?t.className:"ol-rotate",n=t.label!==void 0?t.label:"⇧",s=t.compassClassName!==void 0?t.compassClassName:"ol-compass";this.label_=null,typeof n=="string"?(this.label_=document.createElement("span"),this.label_.className=s,this.label_.textContent=n):(this.label_=n,this.label_.classList.add(s));const r=t.tipLabel?t.tipLabel:"Reset rotation",a=document.createElement("button");a.className=e+"-reset",a.setAttribute("type","button"),a.title=r,a.appendChild(this.label_),a.addEventListener(et.CLICK,this.handleClick_.bind(this),!1);const o=e+" "+jr+" "+mo,h=this.element;h.className=o,h.appendChild(a),this.callResetNorth_=t.resetNorth?t.resetNorth:void 0,this.duration_=t.duration!==void 0?t.duration:250,this.autoHide_=t.autoHide!==void 0?t.autoHide:!0,this.rotation_=void 0,this.autoHide_&&this.element.classList.add(rr)}handleClick_(t){t.preventDefault(),this.callResetNorth_!==void 0?this.callResetNorth_():this.resetNorth_()}resetNorth_(){const e=this.getMap().getView();if(!e)return;const n=e.getRotation();n!==void 0&&(this.duration_>0&&n%(2*Math.PI)!==0?e.animate({rotation:0,duration:this.duration_,easing:Xn}):e.setRotation(0))}render(t){const e=t.frameState;if(!e)return;const n=e.viewState.rotation;if(n!=this.rotation_){const s="rotate("+n+"rad)";if(this.autoHide_){const r=this.element.classList.contains(rr);!r&&n===0?this.element.classList.add(rr):r&&n!==0&&this.element.classList.remove(rr)}this.label_.style.transform=s}this.rotation_=n}}class Hf extends Eo{constructor(t){t=t||{},super({element:document.createElement("div"),target:t.target});const e=t.className!==void 0?t.className:"ol-zoom",n=t.delta!==void 0?t.delta:1,s=t.zoomInClassName!==void 0?t.zoomInClassName:e+"-in",r=t.zoomOutClassName!==void 0?t.zoomOutClassName:e+"-out",a=t.zoomInLabel!==void 0?t.zoomInLabel:"+",o=t.zoomOutLabel!==void 0?t.zoomOutLabel:"–",h=t.zoomInTipLabel!==void 0?t.zoomInTipLabel:"Zoom in",l=t.zoomOutTipLabel!==void 0?t.zoomOutTipLabel:"Zoom out",c=document.createElement("button");c.className=s,c.setAttribute("type","button"),c.title=h,c.appendChild(typeof a=="string"?document.createTextNode(a):a),c.addEventListener(et.CLICK,this.handleClick_.bind(this,n),!1);const u=document.createElement("button");u.className=r,u.setAttribute("type","button"),u.title=l,u.appendChild(typeof o=="string"?document.createTextNode(o):o),u.addEventListener(et.CLICK,this.handleClick_.bind(this,-n),!1);const d=e+" "+jr+" "+mo,f=this.element;f.className=d,f.appendChild(c),f.appendChild(u),this.duration_=t.duration!==void 0?t.duration:250}handleClick_(t,e){e.preventDefault(),this.zoomByDelta_(t)}zoomByDelta_(t){const n=this.getMap().getView();if(!n)return;const s=n.getZoom();if(s!==void 0){const r=n.getConstrainedZoom(s+t);this.duration_>0?(n.getAnimating()&&n.cancelAnimations(),n.animate({zoom:r,duration:this.duration_,easing:Xn})):n.setZoom(r)}}}function bc(i){i=i||{};const t=new ne;return(i.zoom===void 0||i.zoom)&&t.push(new Hf(i.zoomOptions)),(i.rotate===void 0||i.rotate)&&t.push(new $f(i.rotateOptions)),(i.attribution===void 0||i.attribution)&&t.push(new wd(i.attributionOptions)),t}class Jf{constructor(t,e,n){this.decay_=t,this.minVelocity_=e,this.delay_=n,this.points_=[],this.angle_=0,this.initialVelocity_=0}begin(){this.points_.length=0,this.angle_=0,this.initialVelocity_=0}update(t,e){this.points_.push(t,e,Date.now())}end(){if(this.points_.length<6)return!1;const t=Date.now()-this.delay_,e=this.points_.length-3;if(this.points_[e+2]<t)return!1;let n=e-3;for(;n>0&&this.points_[n+2]>t;)n-=3;const s=this.points_[e+2]-this.points_[n+2];if(s<1e3/60)return!1;const r=this.points_[e]-this.points_[n],a=this.points_[e+1]-this.points_[n+1];return this.angle_=Math.atan2(a,r),this.initialVelocity_=Math.sqrt(r*r+a*a)/s,this.initialVelocity_>this.minVelocity_}getDistance(){return(this.minVelocity_-this.initialVelocity_)/this.decay_}getAngle(){return this.angle_}}const eo={ACTIVE:"active"};class Xs extends He{constructor(t){super(),this.on,this.once,this.un,t&&t.handleEvent&&(this.handleEvent=t.handleEvent),this.map_=null,this.setActive(!0)}getActive(){return this.get(eo.ACTIVE)}getMap(){return this.map_}handleEvent(t){return!0}setActive(t){this.set(eo.ACTIVE,t)}setMap(t){this.map_=t}}function Qf(i,t,e){const n=i.getCenterInternal();if(n){const s=[n[0]+t[0],n[1]+t[1]];i.animateInternal({duration:e!==void 0?e:250,easing:_f,center:i.getConstrainedCenter(s)})}}function ko(i,t,e,n){const s=i.getZoom();if(s===void 0)return;const r=i.getConstrainedZoom(s+t),a=i.getResolutionForZoom(r);i.getAnimating()&&i.cancelAnimations(),i.animate({resolution:a,anchor:e,duration:n!==void 0?n:250,easing:Xn})}class t0 extends Xs{constructor(t){super(),t=t||{},this.delta_=t.delta?t.delta:1,this.duration_=t.duration!==void 0?t.duration:250}handleEvent(t){let e=!1;if(t.type==Dt.DBLCLICK){const n=t.originalEvent,s=t.map,r=t.coordinate,a=n.shiftKey?-this.delta_:this.delta_,o=s.getView();ko(o,a,r,this.duration_),n.preventDefault(),e=!0}return!e}}function io(i){const t=arguments;return function(e){let n=!0;for(let s=0,r=t.length;s<r&&(n=n&&t[s](e),!!n);++s);return n}}const e0=function(i){const t=i.originalEvent;return t.altKey&&!(t.metaKey||t.ctrlKey)&&t.shiftKey},i0=function(i){const t=i.map.getTargetElement(),e=t.getRootNode(),n=i.map.getOwnerDocument().activeElement;return e instanceof ShadowRoot?e.host.contains(n):t.contains(n)},Pc=function(i){const t=i.map.getTargetElement(),e=t.getRootNode();return(e instanceof ShadowRoot?e.host:t).hasAttribute("tabindex")?i0(i):!0},Lc=Vi,Gc=function(i){const t=i.originalEvent;return"pointerId"in t&&t.button==0&&!(yd&&Yl&&t.ctrlKey)},Oc=function(i){const t=i.originalEvent;return!t.altKey&&!(t.metaKey||t.ctrlKey)&&!t.shiftKey},n0=function(i){const t=i.originalEvent;return Yl?t.metaKey:t.ctrlKey},s0=function(i){const t=i.originalEvent;return!t.altKey&&!(t.metaKey||t.ctrlKey)&&t.shiftKey},Dc=function(i){const t=i.originalEvent,e=t.target.tagName;return e!=="INPUT"&&e!=="SELECT"&&e!=="TEXTAREA"&&!t.target.isContentEditable},ma=function(i){const t=i.originalEvent;return"pointerId"in t&&t.pointerType=="mouse"},r0=function(i){const t=i.originalEvent;return"pointerId"in t&&t.isPrimary&&t.button===0};class qn extends Xs{constructor(t){t=t||{},super(t),t.handleDownEvent&&(this.handleDownEvent=t.handleDownEvent),t.handleDragEvent&&(this.handleDragEvent=t.handleDragEvent),t.handleMoveEvent&&(this.handleMoveEvent=t.handleMoveEvent),t.handleUpEvent&&(this.handleUpEvent=t.handleUpEvent),t.stopDown&&(this.stopDown=t.stopDown),this.handlingDownUpSequence=!1,this.targetPointers=[]}getPointerCount(){return this.targetPointers.length}handleDownEvent(t){return!1}handleDragEvent(t){}handleEvent(t){if(!t.originalEvent)return!0;let e=!1;if(this.updateTrackedPointers_(t),this.handlingDownUpSequence){if(t.type==Dt.POINTERDRAG)this.handleDragEvent(t),t.originalEvent.preventDefault();else if(t.type==Dt.POINTERUP){const n=this.handleUpEvent(t);this.handlingDownUpSequence=n&&this.targetPointers.length>0}}else if(t.type==Dt.POINTERDOWN){const n=this.handleDownEvent(t);this.handlingDownUpSequence=n,e=this.stopDown(n)}else t.type==Dt.POINTERMOVE&&this.handleMoveEvent(t);return!e}handleMoveEvent(t){}handleUpEvent(t){return!1}stopDown(t){return t}updateTrackedPointers_(t){t.activePointers&&(this.targetPointers=t.activePointers)}}function zo(i){const t=i.length;let e=0,n=0;for(let s=0;s<t;s++)e+=i[s].clientX,n+=i[s].clientY;return{clientX:e/t,clientY:n/t}}class a0 extends qn{constructor(t){super({stopDown:Kr}),t=t||{},this.kinetic_=t.kinetic,this.lastCentroid=null,this.lastPointersCount_,this.panning_=!1;const e=t.condition?t.condition:io(Oc,r0);this.condition_=t.onFocusOnly?io(Pc,e):e,this.noKinetic_=!1}handleDragEvent(t){const e=t.map;this.panning_||(this.panning_=!0,e.getView().beginInteraction());const n=this.targetPointers,s=e.getEventPixel(zo(n));if(n.length==this.lastPointersCount_){if(this.kinetic_&&this.kinetic_.update(s[0],s[1]),this.lastCentroid){const r=[this.lastCentroid[0]-s[0],s[1]-this.lastCentroid[1]],o=t.map.getView();oc(r,o.getResolution()),wo(r,o.getRotation()),o.adjustCenterInternal(r)}}else this.kinetic_&&this.kinetic_.begin();this.lastCentroid=s,this.lastPointersCount_=n.length,t.originalEvent.preventDefault()}handleUpEvent(t){const e=t.map,n=e.getView();if(this.targetPointers.length===0){if(!this.noKinetic_&&this.kinetic_&&this.kinetic_.end()){const s=this.kinetic_.getDistance(),r=this.kinetic_.getAngle(),a=n.getCenterInternal(),o=e.getPixelFromCoordinateInternal(a),h=e.getCoordinateFromPixelInternal([o[0]-s*Math.cos(r),o[1]-s*Math.sin(r)]);n.animateInternal({center:n.getConstrainedCenter(h),duration:500,easing:Xn})}return this.panning_&&(this.panning_=!1,n.endInteraction()),!1}return this.kinetic_&&this.kinetic_.begin(),this.lastCentroid=null,!0}handleDownEvent(t){if(this.targetPointers.length>0&&this.condition_(t)){const n=t.map.getView();return this.lastCentroid=null,n.getAnimating()&&n.cancelAnimations(),this.kinetic_&&this.kinetic_.begin(),this.noKinetic_=this.targetPointers.length>1,!0}return!1}}class o0 extends qn{constructor(t){t=t||{},super({stopDown:Kr}),this.condition_=t.condition?t.condition:e0,this.lastAngle_=void 0,this.duration_=t.duration!==void 0?t.duration:250}handleDragEvent(t){if(!ma(t))return;const e=t.map,n=e.getView();if(n.getConstraints().rotation===No)return;const s=e.getSize(),r=t.pixel,a=Math.atan2(s[1]/2-r[1],r[0]-s[0]/2);if(this.lastAngle_!==void 0){const o=a-this.lastAngle_;n.adjustRotationInternal(-o)}this.lastAngle_=a}handleUpEvent(t){return ma(t)?(t.map.getView().endInteraction(this.duration_),!1):!0}handleDownEvent(t){return ma(t)&&Gc(t)&&this.condition_(t)?(t.map.getView().beginInteraction(),this.lastAngle_=void 0,!0):!1}}class h0 extends Vr{constructor(t){super(),this.geometry_=null,this.element_=document.createElement("div"),this.element_.style.position="absolute",this.element_.style.pointerEvents="auto",this.element_.className="ol-box "+t,this.map_=null,this.startPixel_=null,this.endPixel_=null}disposeInternal(){this.setMap(null)}render_(){const t=this.startPixel_,e=this.endPixel_,n="px",s=this.element_.style;s.left=Math.min(t[0],e[0])+n,s.top=Math.min(t[1],e[1])+n,s.width=Math.abs(e[0]-t[0])+n,s.height=Math.abs(e[1]-t[1])+n}setMap(t){if(this.map_){this.map_.getOverlayContainer().removeChild(this.element_);const e=this.element_.style;e.left="inherit",e.top="inherit",e.width="inherit",e.height="inherit"}this.map_=t,this.map_&&this.map_.getOverlayContainer().appendChild(this.element_)}setPixels(t,e){this.startPixel_=t,this.endPixel_=e,this.createOrUpdateGeometry(),this.render_()}createOrUpdateGeometry(){if(!this.map_)return;const t=this.startPixel_,e=this.endPixel_,s=[t,[t[0],e[1]],e,[e[0],t[1]]].map(this.map_.getCoordinateFromPixelInternal,this.map_);s[4]=s[0].slice(),this.geometry_?this.geometry_.setCoordinates([s]):this.geometry_=new Fn([s])}getGeometry(){return this.geometry_}}const hn={BOXSTART:"boxstart",BOXDRAG:"boxdrag",BOXEND:"boxend",BOXCANCEL:"boxcancel"};class $n extends We{constructor(t,e,n){super(t),this.coordinate=e,this.mapBrowserEvent=n}}class l0 extends qn{constructor(t){super(),this.on,this.once,this.un,t=t??{},this.box_=new h0(t.className||"ol-dragbox"),this.minArea_=t.minArea??64,t.onBoxEnd&&(this.onBoxEnd=t.onBoxEnd),this.startPixel_=null,this.condition_=t.condition??Gc,this.boxEndCondition_=t.boxEndCondition??this.defaultBoxEndCondition}defaultBoxEndCondition(t,e,n){const s=n[0]-e[0],r=n[1]-e[1];return s*s+r*r>=this.minArea_}getGeometry(){return this.box_.getGeometry()}handleDragEvent(t){this.startPixel_&&(this.box_.setPixels(this.startPixel_,t.pixel),this.dispatchEvent(new $n(hn.BOXDRAG,t.coordinate,t)))}handleUpEvent(t){if(!this.startPixel_)return!1;const e=this.boxEndCondition_(t,this.startPixel_,t.pixel);return e&&this.onBoxEnd(t),this.dispatchEvent(new $n(e?hn.BOXEND:hn.BOXCANCEL,t.coordinate,t)),this.box_.setMap(null),this.startPixel_=null,!1}handleDownEvent(t){return this.condition_(t)?(this.startPixel_=t.pixel,this.box_.setMap(t.map),this.box_.setPixels(this.startPixel_,this.startPixel_),this.dispatchEvent(new $n(hn.BOXSTART,t.coordinate,t)),!0):!1}onBoxEnd(t){}setActive(t){t||(this.box_.setMap(null),this.startPixel_&&(this.dispatchEvent(new $n(hn.BOXCANCEL,this.startPixel_,null)),this.startPixel_=null)),super.setActive(t)}setMap(t){this.getMap()&&(this.box_.setMap(null),this.startPixel_&&(this.dispatchEvent(new $n(hn.BOXCANCEL,this.startPixel_,null)),this.startPixel_=null)),super.setMap(t)}}class c0 extends l0{constructor(t){t=t||{};const e=t.condition?t.condition:s0;super({condition:e,className:t.className||"ol-dragzoom",minArea:t.minArea}),this.duration_=t.duration!==void 0?t.duration:200,this.out_=t.out!==void 0?t.out:!1}onBoxEnd(t){const n=this.getMap().getView();let s=this.getGeometry();if(this.out_){const r=n.rotatedExtentForGeometry(s),a=n.getResolutionForExtentInternal(r),o=n.getResolution()/a;s=s.clone(),s.scale(o*o)}n.fitInternal(s,{duration:this.duration_,easing:Xn})}}const ki={LEFT:"ArrowLeft",UP:"ArrowUp",RIGHT:"ArrowRight",DOWN:"ArrowDown"};class u0 extends Xs{constructor(t){super(),t=t||{},this.defaultCondition_=function(e){return Oc(e)&&Dc(e)},this.condition_=t.condition!==void 0?t.condition:this.defaultCondition_,this.duration_=t.duration!==void 0?t.duration:100,this.pixelDelta_=t.pixelDelta!==void 0?t.pixelDelta:128}handleEvent(t){let e=!1;if(t.type==et.KEYDOWN){const n=t.originalEvent,s=n.key;if(this.condition_(t)&&(s==ki.DOWN||s==ki.LEFT||s==ki.RIGHT||s==ki.UP)){const a=t.map.getView(),o=a.getResolution()*this.pixelDelta_;let h=0,l=0;s==ki.DOWN?l=-o:s==ki.LEFT?h=-o:s==ki.RIGHT?h=o:l=o;const c=[h,l];wo(c,a.getRotation()),Qf(a,c,this.duration_),n.preventDefault(),e=!0}}return!e}}class d0 extends Xs{constructor(t){super(),t=t||{},this.condition_=t.condition?t.condition:function(e){return!n0(e)&&Dc(e)},this.delta_=t.delta?t.delta:1,this.duration_=t.duration!==void 0?t.duration:100}handleEvent(t){let e=!1;if(t.type==et.KEYDOWN||t.type==et.KEYPRESS){const n=t.originalEvent,s=n.key;if(this.condition_(t)&&(s==="+"||s==="-")){const r=t.map,a=s==="+"?this.delta_:-this.delta_,o=r.getView();ko(o,a,void 0,this.duration_),n.preventDefault(),e=!0}}return!e}}const f0=40,g0=300;class _0 extends Xs{constructor(t){t=t||{},super(t),this.totalDelta_=0,this.lastDelta_=0,this.maxDelta_=t.maxDelta!==void 0?t.maxDelta:1,this.duration_=t.duration!==void 0?t.duration:250,this.timeout_=t.timeout!==void 0?t.timeout:80,this.useAnchor_=t.useAnchor!==void 0?t.useAnchor:!0,this.constrainResolution_=t.constrainResolution!==void 0?t.constrainResolution:!1;const e=t.condition?t.condition:Lc;this.condition_=t.onFocusOnly?io(Pc,e):e,this.lastAnchor_=null,this.startTime_=void 0,this.timeoutId_,this.mode_=void 0,this.trackpadEventGap_=400,this.trackpadTimeoutId_,this.deltaPerZoom_=300}endInteraction_(){this.trackpadTimeoutId_=void 0;const t=this.getMap();if(!t)return;t.getView().endInteraction(void 0,this.lastDelta_?this.lastDelta_>0?1:-1:0,this.lastAnchor_?t.getCoordinateFromPixel(this.lastAnchor_):null)}handleEvent(t){if(!this.condition_(t)||t.type!==et.WHEEL)return!0;const n=t.map,s=t.originalEvent;s.preventDefault(),this.useAnchor_&&(this.lastAnchor_=t.pixel);let r=s.deltaY;switch(s.deltaMode){case WheelEvent.DOM_DELTA_LINE:r*=f0;break;case WheelEvent.DOM_DELTA_PAGE:r*=g0;break}if(r===0)return!1;this.lastDelta_=r;const a=Date.now();this.startTime_===void 0&&(this.startTime_=a),(!this.mode_||a-this.startTime_>this.trackpadEventGap_)&&(this.mode_=Math.abs(r)<4?"trackpad":"wheel");const o=n.getView();if(this.mode_==="trackpad"&&!(o.getConstrainResolution()||this.constrainResolution_))return this.trackpadTimeoutId_?clearTimeout(this.trackpadTimeoutId_):(o.getAnimating()&&o.cancelAnimations(),o.beginInteraction()),this.trackpadTimeoutId_=setTimeout(this.endInteraction_.bind(this),this.timeout_),o.adjustZoom(-r/this.deltaPerZoom_,this.lastAnchor_?n.getCoordinateFromPixel(this.lastAnchor_):null),this.startTime_=a,!1;this.totalDelta_+=r;const h=Math.max(this.timeout_-(a-this.startTime_),0);return clearTimeout(this.timeoutId_),this.timeoutId_=setTimeout(this.handleWheelZoom_.bind(this,n),h),!1}handleWheelZoom_(t){const e=t.getView();e.getAnimating()&&e.cancelAnimations();let n=-Pt(this.totalDelta_,-this.maxDelta_*this.deltaPerZoom_,this.maxDelta_*this.deltaPerZoom_)/this.deltaPerZoom_;(e.getConstrainResolution()||this.constrainResolution_)&&(n=n?n>0?1:-1:0),ko(e,n,this.lastAnchor_?t.getCoordinateFromPixel(this.lastAnchor_):null,this.duration_),this.mode_=void 0,this.totalDelta_=0,this.lastAnchor_=null,this.startTime_=void 0,this.timeoutId_=void 0}setMouseAnchor(t){this.useAnchor_=t,t||(this.lastAnchor_=null)}}class m0 extends qn{constructor(t){t=t||{};const e=t;e.stopDown||(e.stopDown=Kr),super(e),this.anchor_=null,this.lastAngle_=void 0,this.rotating_=!1,this.rotationDelta_=0,this.threshold_=t.threshold!==void 0?t.threshold:.3,this.duration_=t.duration!==void 0?t.duration:250}handleDragEvent(t){let e=0;const n=this.targetPointers[0],s=this.targetPointers[1],r=Math.atan2(s.clientY-n.clientY,s.clientX-n.clientX);if(this.lastAngle_!==void 0){const h=r-this.lastAngle_;this.rotationDelta_+=h,!this.rotating_&&Math.abs(this.rotationDelta_)>this.threshold_&&(this.rotating_=!0),e=h}this.lastAngle_=r;const a=t.map,o=a.getView();o.getConstraints().rotation!==No&&(this.anchor_=a.getCoordinateFromPixelInternal(a.getEventPixel(zo(this.targetPointers))),this.rotating_&&(a.render(),o.adjustRotationInternal(e,this.anchor_)))}handleUpEvent(t){return this.targetPointers.length<2?(t.map.getView().endInteraction(this.duration_),!1):!0}handleDownEvent(t){if(this.targetPointers.length>=2){const e=t.map;return this.anchor_=null,this.lastAngle_=void 0,this.rotating_=!1,this.rotationDelta_=0,this.handlingDownUpSequence||e.getView().beginInteraction(),!0}return!1}}class y0 extends qn{constructor(t){t=t||{};const e=t;e.stopDown||(e.stopDown=Kr),super(e),this.anchor_=null,this.duration_=t.duration!==void 0?t.duration:400,this.lastDistance_=void 0,this.lastScaleDelta_=1}handleDragEvent(t){let e=1;const n=this.targetPointers[0],s=this.targetPointers[1],r=n.clientX-s.clientX,a=n.clientY-s.clientY,o=Math.sqrt(r*r+a*a);this.lastDistance_!==void 0&&(e=this.lastDistance_/o),this.lastDistance_=o;const h=t.map,l=h.getView();e!=1&&(this.lastScaleDelta_=e),this.anchor_=h.getCoordinateFromPixelInternal(h.getEventPixel(zo(this.targetPointers))),h.render(),l.adjustResolutionInternal(e,this.anchor_)}handleUpEvent(t){if(this.targetPointers.length<2){const n=t.map.getView(),s=this.lastScaleDelta_>1?1:-1;return n.endInteraction(this.duration_,s),!1}return!0}handleDownEvent(t){if(this.targetPointers.length>=2){const e=t.map;return this.anchor_=null,this.lastDistance_=void 0,this.lastScaleDelta_=1,this.handlingDownUpSequence||e.getView().beginInteraction(),!0}return!1}}function Nc(i){i=i||{};const t=new ne,e=new Jf(-.005,.05,100);return(i.altShiftDragRotate===void 0||i.altShiftDragRotate)&&t.push(new o0),(i.doubleClickZoom===void 0||i.doubleClickZoom)&&t.push(new t0({delta:i.zoomDelta,duration:i.zoomDuration})),(i.dragPan===void 0||i.dragPan)&&t.push(new a0({onFocusOnly:i.onFocusOnly,kinetic:e})),(i.pinchRotate===void 0||i.pinchRotate)&&t.push(new m0),(i.pinchZoom===void 0||i.pinchZoom)&&t.push(new y0({duration:i.zoomDuration})),(i.keyboard===void 0||i.keyboard)&&(t.push(new u0),t.push(new d0({delta:i.zoomDelta,duration:i.zoomDuration}))),(i.mouseWheelZoom===void 0||i.mouseWheelZoom)&&t.push(new _0({onFocusOnly:i.onFocusOnly,duration:i.zoomDuration})),(i.shiftDragZoom===void 0||i.shiftDragZoom)&&t.push(new c0({duration:i.zoomDuration})),t}const St={OPACITY:"opacity",VISIBLE:"visible",EXTENT:"extent",Z_INDEX:"zIndex",MAX_RESOLUTION:"maxResolution",MIN_RESOLUTION:"minResolution",MAX_ZOOM:"maxZoom",MIN_ZOOM:"minZoom",SOURCE:"source",MAP:"map"};class Fc extends He{constructor(t){super(),this.on,this.once,this.un,this.background_=t.background;const e=Object.assign({},t);typeof t.properties=="object"&&(delete e.properties,Object.assign(e,t.properties)),e[St.OPACITY]=t.opacity!==void 0?t.opacity:1,vt(typeof e[St.OPACITY]=="number","Layer opacity must be a number"),e[St.VISIBLE]=t.visible!==void 0?t.visible:!0,e[St.Z_INDEX]=t.zIndex,e[St.MAX_RESOLUTION]=t.maxResolution!==void 0?t.maxResolution:1/0,e[St.MIN_RESOLUTION]=t.minResolution!==void 0?t.minResolution:0,e[St.MIN_ZOOM]=t.minZoom!==void 0?t.minZoom:-1/0,e[St.MAX_ZOOM]=t.maxZoom!==void 0?t.maxZoom:1/0,this.className_=e.className!==void 0?e.className:"ol-layer",delete e.className,this.setProperties(e),this.state_=null}getBackground(){return this.background_}getClassName(){return this.className_}getLayerState(t){const e=this.state_||{layer:this,managed:t===void 0?!0:t},n=this.getZIndex();return e.opacity=Pt(Math.round(this.getOpacity()*100)/100,0,1),e.visible=this.getVisible(),e.extent=this.getExtent(),e.zIndex=n===void 0&&!e.managed?1/0:n,e.maxResolution=this.getMaxResolution(),e.minResolution=Math.max(this.getMinResolution(),0),e.minZoom=this.getMinZoom(),e.maxZoom=this.getMaxZoom(),this.state_=e,e}getLayersArray(t){return yt()}getLayerStatesArray(t){return yt()}getExtent(){return this.get(St.EXTENT)}getMaxResolution(){return this.get(St.MAX_RESOLUTION)}getMinResolution(){return this.get(St.MIN_RESOLUTION)}getMinZoom(){return this.get(St.MIN_ZOOM)}getMaxZoom(){return this.get(St.MAX_ZOOM)}getOpacity(){return this.get(St.OPACITY)}getSourceState(){return yt()}getVisible(){return this.get(St.VISIBLE)}getZIndex(){return this.get(St.Z_INDEX)}setBackground(t){this.background_=t,this.changed()}setExtent(t){this.set(St.EXTENT,t)}setMaxResolution(t){this.set(St.MAX_RESOLUTION,t)}setMinResolution(t){this.set(St.MIN_RESOLUTION,t)}setMaxZoom(t){this.set(St.MAX_ZOOM,t)}setMinZoom(t){this.set(St.MIN_ZOOM,t)}setOpacity(t){vt(typeof t=="number","Layer opacity must be a number"),this.set(St.OPACITY,t)}setVisible(t){this.set(St.VISIBLE,t)}setZIndex(t){this.set(St.Z_INDEX,t)}disposeInternal(){this.state_&&(this.state_.layer=null,this.state_=null),super.disposeInternal()}}class vi extends We{constructor(t,e){super(t),this.layer=e}}const ya={LAYERS:"layers"};class jn extends Fc{constructor(t){t=t||{};const e=Object.assign({},t);delete e.layers;let n=t.layers;super(e),this.on,this.once,this.un,this.layersListenerKeys_=[],this.listenerKeys_={},this.addChangeListener(ya.LAYERS,this.handleLayersChanged_),n?Array.isArray(n)?n=new ne(n.slice(),{unique:!0}):vt(typeof n.getArray=="function","Expected `layers` to be an array or a `Collection`"):n=new ne(void 0,{unique:!0}),this.setLayers(n)}handleLayerChange_(){this.changed()}handleLayersChanged_(){this.layersListenerKeys_.forEach(bt),this.layersListenerKeys_.length=0;const t=this.getLayers();this.layersListenerKeys_.push(mt(t,oe.ADD,this.handleLayersAdd_,this),mt(t,oe.REMOVE,this.handleLayersRemove_,this));for(const n in this.listenerKeys_)this.listenerKeys_[n].forEach(bt);Ns(this.listenerKeys_);const e=t.getArray();for(let n=0,s=e.length;n<s;n++){const r=e[n];this.registerLayerListeners_(r),this.dispatchEvent(new vi("addlayer",r))}this.changed()}registerLayerListeners_(t){const e=[mt(t,Ln.PROPERTYCHANGE,this.handleLayerChange_,this),mt(t,et.CHANGE,this.handleLayerChange_,this)];t instanceof jn&&e.push(mt(t,"addlayer",this.handleLayerGroupAdd_,this),mt(t,"removelayer",this.handleLayerGroupRemove_,this)),this.listenerKeys_[_t(t)]=e}handleLayerGroupAdd_(t){this.dispatchEvent(new vi("addlayer",t.layer))}handleLayerGroupRemove_(t){this.dispatchEvent(new vi("removelayer",t.layer))}handleLayersAdd_(t){const e=t.element;this.registerLayerListeners_(e),this.dispatchEvent(new vi("addlayer",e)),this.changed()}handleLayersRemove_(t){const e=t.element,n=_t(e);this.listenerKeys_[n].forEach(bt),delete this.listenerKeys_[n],this.dispatchEvent(new vi("removelayer",e)),this.changed()}getLayers(){return this.get(ya.LAYERS)}setLayers(t){const e=this.getLayers();if(e){const n=e.getArray();for(let s=0,r=n.length;s<r;++s)this.dispatchEvent(new vi("removelayer",n[s]))}this.set(ya.LAYERS,t)}getLayersArray(t){return t=t!==void 0?t:[],this.getLayers().forEach(function(e){e.getLayersArray(t)}),t}getLayerStatesArray(t){const e=t!==void 0?t:[],n=e.length;this.getLayers().forEach(function(a){a.getLayerStatesArray(e)});const s=this.getLayerState();let r=s.zIndex;!t&&s.zIndex===void 0&&(r=0);for(let a=n,o=e.length;a<o;a++){const h=e[a];h.opacity*=s.opacity,h.visible=h.visible&&s.visible,h.maxResolution=Math.min(h.maxResolution,s.maxResolution),h.minResolution=Math.max(h.minResolution,s.minResolution),h.minZoom=Math.max(h.minZoom,s.minZoom),h.maxZoom=Math.min(h.maxZoom,s.maxZoom),s.extent!==void 0&&(h.extent!==void 0?h.extent=ai(h.extent,s.extent):h.extent=s.extent),h.zIndex===void 0&&(h.zIndex=r)}return e}getSourceState(){return"ready"}}const Ce={PRERENDER:"prerender",POSTRENDER:"postrender",PRECOMPOSE:"precompose",POSTCOMPOSE:"postcompose",RENDERCOMPLETE:"rendercomplete"};class qs extends Fc{constructor(t){const e=Object.assign({},t);delete e.source,super(e),this.on,this.once,this.un,this.mapPrecomposeKey_=null,this.mapRenderKey_=null,this.sourceChangeKey_=null,this.renderer_=null,this.sourceReady_=!1,this.rendered=!1,t.render&&(this.render=t.render),t.map&&this.setMap(t.map),this.addChangeListener(St.SOURCE,this.handleSourcePropertyChange_);const n=t.source?t.source:null;this.setSource(n)}getLayersArray(t){return t=t||[],t.push(this),t}getLayerStatesArray(t){return t=t||[],t.push(this.getLayerState()),t}getSource(){return this.get(St.SOURCE)||null}getRenderSource(){return this.getSource()}getSourceState(){const t=this.getSource();return t?t.getState():"undefined"}handleSourceChange_(){this.changed(),!(this.sourceReady_||this.getSource().getState()!=="ready")&&(this.sourceReady_=!0,this.dispatchEvent("sourceready"))}handleSourcePropertyChange_(){this.sourceChangeKey_&&(bt(this.sourceChangeKey_),this.sourceChangeKey_=null),this.sourceReady_=!1;const t=this.getSource();t&&(this.sourceChangeKey_=mt(t,et.CHANGE,this.handleSourceChange_,this),t.getState()==="ready"&&(this.sourceReady_=!0,setTimeout(()=>{this.dispatchEvent("sourceready")},0))),this.changed()}getFeatures(t){return this.renderer_?this.renderer_.getFeatures(t):Promise.resolve([])}getData(t){return!this.renderer_||!this.rendered?null:this.renderer_.getData(t)}isVisible(t){let e;const n=this.getMapInternal();!t&&n&&(t=n.getView()),t instanceof Be?e={viewState:t.getState(),extent:t.calculateExtent()}:e=t,!e.layerStatesArray&&n&&(e.layerStatesArray=n.getLayerGroup().getLayerStatesArray());let s;if(e.layerStatesArray){if(s=e.layerStatesArray.find(a=>a.layer===this),!s)return!1}else s=this.getLayerState();const r=this.getExtent();return Uo(s,e.viewState)&&(!r||ie(r,e.extent))}getAttributions(t){if(!this.isVisible(t))return[];const e=this.getSource()?.getAttributions();if(!e)return[];const n=t instanceof Be?t.getViewStateAndExtent():t;let s=e(n);return Array.isArray(s)||(s=[s]),s}render(t,e){const n=this.getRenderer();return n.prepareFrame(t)?(this.rendered=!0,n.renderFrame(t,e)):null}unrender(){this.rendered=!1}getDeclutter(){}renderDeclutter(t,e){}renderDeferred(t){const e=this.getRenderer();e&&e.renderDeferred(t)}setMapInternal(t){t||this.unrender(),this.set(St.MAP,t)}getMapInternal(){return this.get(St.MAP)}setMap(t){this.mapPrecomposeKey_&&(bt(this.mapPrecomposeKey_),this.mapPrecomposeKey_=null),t||this.changed(),this.mapRenderKey_&&(bt(this.mapRenderKey_),this.mapRenderKey_=null),t&&(this.mapPrecomposeKey_=mt(t,Ce.PRECOMPOSE,this.handlePrecompose_,this),this.mapRenderKey_=mt(this,et.CHANGE,t.render,t),this.changed())}handlePrecompose_(t){const e=t.frameState.layerStatesArray,n=this.getLayerState(!1);vt(!e.some(s=>s.layer===n.layer),"A layer can only be added to the map once. Use either `layer.setMap()` or `map.addLayer()`, not both."),e.push(n)}setSource(t){this.set(St.SOURCE,t)}getRenderer(){return this.renderer_||(this.renderer_=this.createRenderer()),this.renderer_}hasRenderer(){return!!this.renderer_}createRenderer(){return null}clearRenderer(){this.renderer_&&(this.renderer_.dispose(),delete this.renderer_)}disposeInternal(){this.clearRenderer(),this.setSource(null),super.disposeInternal()}}function Uo(i,t){if(!i.visible)return!1;const e=t.resolution;if(e<i.minResolution||e>=i.maxResolution)return!1;const n=t.zoom;return n>i.minZoom&&n<=i.maxZoom}function kc(i,t,e=0,n=i.length-1,s=p0){for(;n>e;){if(n-e>600){const h=n-e+1,l=t-e+1,c=Math.log(h),u=.5*Math.exp(2*c/3),d=.5*Math.sqrt(c*u*(h-u)/h)*(l-h/2<0?-1:1),f=Math.max(e,Math.floor(t-l*u/h+d)),g=Math.min(n,Math.floor(t+(h-l)*u/h+d));kc(i,t,f,g,s)}const r=i[t];let a=e,o=n;for(Hn(i,e,t),s(i[n],r)>0&&Hn(i,e,n);a<o;){for(Hn(i,a,o),a++,o--;s(i[a],r)<0;)a++;for(;s(i[o],r)>0;)o--}s(i[e],r)===0?Hn(i,e,o):(o++,Hn(i,o,n)),o<=t&&(e=o+1),t<=o&&(n=o-1)}}function Hn(i,t,e){const n=i[t];i[t]=i[e],i[e]=n}function p0(i,t){return i<t?-1:i>t?1:0}let zc=class{constructor(t=9){this._maxEntries=Math.max(4,t),this._minEntries=Math.max(2,Math.ceil(this._maxEntries*.4)),this.clear()}all(){return this._all(this.data,[])}search(t){let e=this.data;const n=[];if(!cr(t,e))return n;const s=this.toBBox,r=[];for(;e;){for(let a=0;a<e.children.length;a++){const o=e.children[a],h=e.leaf?s(o):o;cr(t,h)&&(e.leaf?n.push(o):Ea(t,h)?this._all(o,n):r.push(o))}e=r.pop()}return n}collides(t){let e=this.data;if(!cr(t,e))return!1;const n=[];for(;e;){for(let s=0;s<e.children.length;s++){const r=e.children[s],a=e.leaf?this.toBBox(r):r;if(cr(t,a)){if(e.leaf||Ea(t,a))return!0;n.push(r)}}e=n.pop()}return!1}load(t){if(!(t&&t.length))return this;if(t.length<this._minEntries){for(let n=0;n<t.length;n++)this.insert(t[n]);return this}let e=this._build(t.slice(),0,t.length-1,0);if(!this.data.children.length)this.data=e;else if(this.data.height===e.height)this._splitRoot(this.data,e);else{if(this.data.height<e.height){const n=this.data;this.data=e,e=n}this._insert(e,this.data.height-e.height-1,!0)}return this}insert(t){return t&&this._insert(t,this.data.height-1),this}clear(){return this.data=_n([]),this}remove(t,e){if(!t)return this;let n=this.data;const s=this.toBBox(t),r=[],a=[];let o,h,l;for(;n||r.length;){if(n||(n=r.pop(),h=r[r.length-1],o=a.pop(),l=!0),n.leaf){const c=E0(t,n.children,e);if(c!==-1)return n.children.splice(c,1),r.push(n),this._condense(r),this}!l&&!n.leaf&&Ea(n,s)?(r.push(n),a.push(o),o=0,h=n,n=n.children[0]):h?(o++,n=h.children[o],l=!1):n=null}return this}toBBox(t){return t}compareMinX(t,e){return t.minX-e.minX}compareMinY(t,e){return t.minY-e.minY}toJSON(){return this.data}fromJSON(t){return this.data=t,this}_all(t,e){const n=[];for(;t;)t.leaf?e.push(...t.children):n.push(...t.children),t=n.pop();return e}_build(t,e,n,s){const r=n-e+1;let a=this._maxEntries,o;if(r<=a)return o=_n(t.slice(e,n+1)),ln(o,this.toBBox),o;s||(s=Math.ceil(Math.log(r)/Math.log(a)),a=Math.ceil(r/Math.pow(a,s-1))),o=_n([]),o.leaf=!1,o.height=s;const h=Math.ceil(r/a),l=h*Math.ceil(Math.sqrt(a));Xh(t,e,n,l,this.compareMinX);for(let c=e;c<=n;c+=l){const u=Math.min(c+l-1,n);Xh(t,c,u,h,this.compareMinY);for(let d=c;d<=u;d+=h){const f=Math.min(d+h-1,u);o.children.push(this._build(t,d,f,s-1))}}return ln(o,this.toBBox),o}_chooseSubtree(t,e,n,s){for(;s.push(e),!(e.leaf||s.length-1===n);){let r=1/0,a=1/0,o;for(let h=0;h<e.children.length;h++){const l=e.children[h],c=pa(l),u=M0(t,l)-c;u<a?(a=u,r=c<r?c:r,o=l):u===a&&c<r&&(r=c,o=l)}e=o||e.children[0]}return e}_insert(t,e,n){const s=n?t:this.toBBox(t),r=[],a=this._chooseSubtree(s,this.data,e,r);for(a.children.push(t),ns(a,s);e>=0&&r[e].children.length>this._maxEntries;)this._split(r,e),e--;this._adjustParentBBoxes(s,r,e)}_split(t,e){const n=t[e],s=n.children.length,r=this._minEntries;this._chooseSplitAxis(n,r,s);const a=this._chooseSplitIndex(n,r,s),o=_n(n.children.splice(a,n.children.length-a));o.height=n.height,o.leaf=n.leaf,ln(n,this.toBBox),ln(o,this.toBBox),e?t[e-1].children.push(o):this._splitRoot(n,o)}_splitRoot(t,e){this.data=_n([t,e]),this.data.height=t.height+1,this.data.leaf=!1,ln(this.data,this.toBBox)}_chooseSplitIndex(t,e,n){let s,r=1/0,a=1/0;for(let o=e;o<=n-e;o++){const h=is(t,0,o,this.toBBox),l=is(t,o,n,this.toBBox),c=w0(h,l),u=pa(h)+pa(l);c<r?(r=c,s=o,a=u<a?u:a):c===r&&u<a&&(a=u,s=o)}return s||n-e}_chooseSplitAxis(t,e,n){const s=t.leaf?this.compareMinX:v0,r=t.leaf?this.compareMinY:x0,a=this._allDistMargin(t,e,n,s),o=this._allDistMargin(t,e,n,r);a<o&&t.children.sort(s)}_allDistMargin(t,e,n,s){t.children.sort(s);const r=this.toBBox,a=is(t,0,e,r),o=is(t,n-e,n,r);let h=lr(a)+lr(o);for(let l=e;l<n-e;l++){const c=t.children[l];ns(a,t.leaf?r(c):c),h+=lr(a)}for(let l=n-e-1;l>=e;l--){const c=t.children[l];ns(o,t.leaf?r(c):c),h+=lr(o)}return h}_adjustParentBBoxes(t,e,n){for(let s=n;s>=0;s--)ns(e[s],t)}_condense(t){for(let e=t.length-1,n;e>=0;e--)t[e].children.length===0?e>0?(n=t[e-1].children,n.splice(n.indexOf(t[e]),1)):this.clear():ln(t[e],this.toBBox)}};function E0(i,t,e){if(!e)return t.indexOf(i);for(let n=0;n<t.length;n++)if(e(i,t[n]))return n;return-1}function ln(i,t){is(i,0,i.children.length,t,i)}function is(i,t,e,n,s){s||(s=_n(null)),s.minX=1/0,s.minY=1/0,s.maxX=-1/0,s.maxY=-1/0;for(let r=t;r<e;r++){const a=i.children[r];ns(s,i.leaf?n(a):a)}return s}function ns(i,t){return i.minX=Math.min(i.minX,t.minX),i.minY=Math.min(i.minY,t.minY),i.maxX=Math.max(i.maxX,t.maxX),i.maxY=Math.max(i.maxY,t.maxY),i}function v0(i,t){return i.minX-t.minX}function x0(i,t){return i.minY-t.minY}function pa(i){return(i.maxX-i.minX)*(i.maxY-i.minY)}function lr(i){return i.maxX-i.minX+(i.maxY-i.minY)}function M0(i,t){return(Math.max(t.maxX,i.maxX)-Math.min(t.minX,i.minX))*(Math.max(t.maxY,i.maxY)-Math.min(t.minY,i.minY))}function w0(i,t){const e=Math.max(i.minX,t.minX),n=Math.max(i.minY,t.minY),s=Math.min(i.maxX,t.maxX),r=Math.min(i.maxY,t.maxY);return Math.max(0,s-e)*Math.max(0,r-n)}function Ea(i,t){return i.minX<=t.minX&&i.minY<=t.minY&&t.maxX<=i.maxX&&t.maxY<=i.maxY}function cr(i,t){return t.minX<=i.maxX&&t.minY<=i.maxY&&t.maxX>=i.minX&&t.maxY>=i.minY}function _n(i){return{children:i,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function Xh(i,t,e,n,s){const r=[t,e];for(;r.length;){if(e=r.pop(),t=r.pop(),e-t<=n)continue;const a=t+Math.ceil((e-t)/n/2)*n;kc(i,a,t,e,s),r.push(t,a,a,e)}}const Wo=[NaN,NaN,NaN,0];let va;function S0(){return va||(va=Bt(1,1,void 0,{willReadFrequently:!0,desynchronized:!0})),va}const C0=/^rgba?\(\s*(\d+%?)\s+(\d+%?)\s+(\d+%?)(?:\s*\/\s*(\d+%|\d*\.\d+|[01]))?\s*\)$/i,I0=/^rgba?\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)(?:\s*,\s*(\d+%|\d*\.\d+|[01]))?\s*\)$/i,R0=/^rgba?\(\s*(\d+%)\s*,\s*(\d+%)\s*,\s*(\d+%)(?:\s*,\s*(\d+%|\d*\.\d+|[01]))?\s*\)$/i,A0=/^#([\da-f]{3,4}|[\da-f]{6}|[\da-f]{8})$/i;function ur(i,t){return i.endsWith("%")?Number(i.substring(0,i.length-1))/t:Number(i)}function fs(i){throw new Error('failed to parse "'+i+'" as color')}function Uc(i){if(i.toLowerCase().startsWith("rgb")){const r=i.match(I0)||i.match(C0)||i.match(R0);if(r){const a=r[4],o=100/255;return[Pt(ur(r[1],o)+.5|0,0,255),Pt(ur(r[2],o)+.5|0,0,255),Pt(ur(r[3],o)+.5|0,0,255),a!==void 0?Pt(ur(a,100),0,1):1]}fs(i)}if(i.startsWith("#")){if(A0.test(i)){const r=i.substring(1),a=r.length<=4?1:2,o=[0,0,0,255];for(let h=0,l=r.length;h<l;h+=a){let c=parseInt(r.substring(h,h+a),16);a===1&&(c+=c<<4),o[h/a]=c}return o[3]=o[3]/255,o}fs(i)}const t=S0();t.fillStyle="#abcdef";let e=t.fillStyle;t.fillStyle=i,t.fillStyle===e&&(t.fillStyle="#fedcba",e=t.fillStyle,t.fillStyle=i,t.fillStyle===e&&fs(i));const n=t.fillStyle;if(n.startsWith("#")||n.startsWith("rgba"))return Uc(n);t.clearRect(0,0,1,1),t.fillRect(0,0,1,1);const s=Array.from(t.getImageData(0,0,1,1).data);return s[3]=Us(s[3]/255,3),s}function T0(i){return typeof i=="string"?i:Xo(i)}const b0=1024,Jn={};let xa=0;function P0(i){if(i.length===4)return i;const t=i.slice();return t[3]=1,t}function Ma(i){return i>.0031308?Math.pow(i,1/2.4)*269.025-14.025:i*3294.6}function wa(i){return i>.2068965?Math.pow(i,3):(i-4/29)*(108/841)}function Sa(i){return i>10.314724?Math.pow((i+14.025)/269.025,2.4):i/3294.6}function Ca(i){return i>.0088564?Math.pow(i,1/3):i/(108/841)+4/29}function qh(i){const t=Sa(i[0]),e=Sa(i[1]),n=Sa(i[2]),s=Ca(t*.222488403+e*.716873169+n*.06060791),r=500*(Ca(t*.452247074+e*.399439023+n*.148375274)-s),a=200*(s-Ca(t*.016863605+e*.117638439+n*.865350722)),o=Math.atan2(a,r)*(180/Math.PI);return[116*s-16,Math.sqrt(r*r+a*a),o<0?o+360:o,i[3]]}function L0(i){const t=(i[0]+16)/116,e=i[1],n=i[2]*Math.PI/180,s=wa(t),r=wa(t+e/500*Math.cos(n)),a=wa(t-e/200*Math.sin(n)),o=Ma(r*3.021973625-s*1.617392459-a*.404875592),h=Ma(r*-.943766287+s*1.916279586+a*.027607165),l=Ma(r*.069407491-s*.22898585+a*1.159737864);return[Pt(o+.5|0,0,255),Pt(h+.5|0,0,255),Pt(l+.5|0,0,255),i[3]]}function Bo(i){if(i==="none")return Wo;if(Jn.hasOwnProperty(i))return Jn[i];if(xa>=b0){let e=0;for(const n in Jn)(e++&3)===0&&(delete Jn[n],--xa)}const t=Uc(i);t.length!==4&&fs(i);for(const e of t)isNaN(e)&&fs(i);return Jn[i]=t,++xa,t}function kn(i){return Array.isArray(i)?i:Bo(i)}function Xo(i){let t=i[0];t!=(t|0)&&(t=t+.5|0);let e=i[1];e!=(e|0)&&(e=e+.5|0);let n=i[2];n!=(n|0)&&(n=n+.5|0);const s=i[3]===void 0?1:Math.round(i[3]*1e3)/1e3;return"rgba("+t+","+e+","+n+","+s+")"}function jh(i){return i[0]>0&&i[1]>0}function G0(i,t,e){return e===void 0&&(e=[0,0]),e[0]=i[0]*t+.5|0,e[1]=i[1]*t+.5|0,e}function de(i,t){return Array.isArray(i)?i:(t===void 0?t=[i,i]:(t[0]=i,t[1]=i),t)}let nn=0;const ee=1<<nn++,ft=1<<nn++,he=1<<nn++,Fe=1<<nn++,Hi=1<<nn++,ss=1<<nn++,dr=Math.pow(2,nn)-1,qo={[ee]:"boolean",[ft]:"number",[he]:"string",[Fe]:"color",[Hi]:"number[]",[ss]:"size"},O0=Object.keys(qo).map(Number).sort(ri);function D0(i){return i in qo}function rs(i){const t=[];for(const e of O0)as(i,e)&&t.push(qo[e]);return t.length===0?"untyped":t.length<3?t.join(" or "):t.slice(0,-1).join(", ")+", or "+t[t.length-1]}function as(i,t){return(i&t)===t}function fi(i,t){return i===t}class zt{constructor(t,e){if(!D0(t))throw new Error(`literal expressions must have a specific type, got ${rs(t)}`);this.type=t,this.value=e}}class N0{constructor(t,e,...n){this.type=t,this.operator=e,this.args=n}}function Wc(){return{variables:new Set,properties:new Set,featureId:!1,geometryType:!1,mapState:!1}}function Vt(i,t,e){switch(typeof i){case"boolean":{if(fi(t,he))return new zt(he,i?"true":"false");if(!as(t,ee))throw new Error(`got a boolean, but expected ${rs(t)}`);return new zt(ee,i)}case"number":{if(fi(t,ss))return new zt(ss,de(i));if(fi(t,ee))return new zt(ee,!!i);if(fi(t,he))return new zt(he,i.toString());if(!as(t,ft))throw new Error(`got a number, but expected ${rs(t)}`);return new zt(ft,i)}case"string":{if(fi(t,Fe))return new zt(Fe,Bo(i));if(fi(t,ee))return new zt(ee,!!i);if(!as(t,he))throw new Error(`got a string, but expected ${rs(t)}`);return new zt(he,i)}}if(!Array.isArray(i))throw new Error("expression must be an array or a primitive value");if(i.length===0)throw new Error("empty expression");if(typeof i[0]=="string")return K0(i,t,e);for(const n of i)if(typeof n!="number")throw new Error("expected an array of numbers");if(fi(t,ss)){if(i.length!==2)throw new Error(`expected an array of two values for a size, got ${i.length}`);return new zt(ss,i)}if(fi(t,Fe)){if(i.length===3)return new zt(Fe,[...i,1]);if(i.length===4)return new zt(Fe,i);throw new Error(`expected an array of 3 or 4 values for a color, got ${i.length}`)}if(!as(t,Hi))throw new Error(`got an array of numbers, but expected ${rs(t)}`);return new zt(Hi,i)}const A={Get:"get",Var:"var",Concat:"concat",GeometryType:"geometry-type",LineMetric:"line-metric",Any:"any",All:"all",Not:"!",Resolution:"resolution",Zoom:"zoom",Time:"time",Equal:"==",NotEqual:"!=",GreaterThan:">",GreaterThanOrEqualTo:">=",LessThan:"<",LessThanOrEqualTo:"<=",Multiply:"*",Divide:"/",Add:"+",Subtract:"-",Clamp:"clamp",Mod:"%",Pow:"^",Abs:"abs",Floor:"floor",Ceil:"ceil",Round:"round",Sin:"sin",Cos:"cos",Atan:"atan",Sqrt:"sqrt",Match:"match",Between:"between",Interpolate:"interpolate",Coalesce:"coalesce",Case:"case",In:"in",Number:"number",String:"string",Array:"array",Color:"color",Id:"id",Band:"band",Palette:"palette",ToString:"to-string",Has:"has"},F0={[A.Get]:tt(rt(1,1/0),Yh),[A.Var]:tt(rt(1,1),k0),[A.Has]:tt(rt(1,1/0),Yh),[A.Id]:tt(z0,cn),[A.Concat]:tt(rt(2,1/0),Et(he)),[A.GeometryType]:tt(U0,cn),[A.LineMetric]:tt(cn),[A.Resolution]:tt(Ia,cn),[A.Zoom]:tt(Ia,cn),[A.Time]:tt(Ia,cn),[A.Any]:tt(rt(2,1/0),Et(ee)),[A.All]:tt(rt(2,1/0),Et(ee)),[A.Not]:tt(rt(1,1),Et(ee)),[A.Equal]:tt(rt(2,2),Et(dr)),[A.NotEqual]:tt(rt(2,2),Et(dr)),[A.GreaterThan]:tt(rt(2,2),Et(ft)),[A.GreaterThanOrEqualTo]:tt(rt(2,2),Et(ft)),[A.LessThan]:tt(rt(2,2),Et(ft)),[A.LessThanOrEqualTo]:tt(rt(2,2),Et(ft)),[A.Multiply]:tt(rt(2,1/0),Kh),[A.Coalesce]:tt(rt(2,1/0),Kh),[A.Divide]:tt(rt(2,2),Et(ft)),[A.Add]:tt(rt(2,1/0),Et(ft)),[A.Subtract]:tt(rt(2,2),Et(ft)),[A.Clamp]:tt(rt(3,3),Et(ft)),[A.Mod]:tt(rt(2,2),Et(ft)),[A.Pow]:tt(rt(2,2),Et(ft)),[A.Abs]:tt(rt(1,1),Et(ft)),[A.Floor]:tt(rt(1,1),Et(ft)),[A.Ceil]:tt(rt(1,1),Et(ft)),[A.Round]:tt(rt(1,1),Et(ft)),[A.Sin]:tt(rt(1,1),Et(ft)),[A.Cos]:tt(rt(1,1),Et(ft)),[A.Atan]:tt(rt(1,2),Et(ft)),[A.Sqrt]:tt(rt(1,1),Et(ft)),[A.Match]:tt(rt(4,1/0),Vh,B0),[A.Between]:tt(rt(3,3),Et(ft)),[A.Interpolate]:tt(rt(6,1/0),Vh,X0),[A.Case]:tt(rt(3,1/0),W0,q0),[A.In]:tt(rt(2,2),j0),[A.Number]:tt(rt(1,1/0),Et(dr)),[A.String]:tt(rt(1,1/0),Et(dr)),[A.Array]:tt(rt(1,1/0),Et(ft)),[A.Color]:tt(rt(1,4),Et(ft)),[A.Band]:tt(rt(1,3),Et(ft)),[A.Palette]:tt(rt(2,2),Y0),[A.ToString]:tt(rt(1,1),Et(ee|ft|he|Fe))};function Yh(i,t,e){const n=i.length-1,s=new Array(n);for(let r=0;r<n;++r){const a=i[r+1];switch(typeof a){case"number":{s[r]=new zt(ft,a);break}case"string":{s[r]=new zt(he,a);break}default:throw new Error(`expected a string key or numeric array index for a get operation, got ${a}`)}r===0&&e.properties.add(String(a))}return s}function k0(i,t,e){const n=i[1];if(typeof n!="string")throw new Error("expected a string argument for var operation");return e.variables.add(n),[new zt(he,n)]}function z0(i,t,e){e.featureId=!0}function U0(i,t,e){e.geometryType=!0}function Ia(i,t,e){e.mapState=!0}function cn(i,t,e){const n=i[0];if(i.length!==1)throw new Error(`expected no arguments for ${n} operation`);return[]}function rt(i,t){return function(e,n,s){const r=e[0],a=e.length-1;if(i===t){if(a!==i){const o=i===1?"":"s";throw new Error(`expected ${i} argument${o} for ${r}, got ${a}`)}}else if(a<i||a>t){const o=t===1/0?`${i} or more`:`${i} to ${t}`;throw new Error(`expected ${o} arguments for ${r}, got ${a}`)}}}function Kh(i,t,e){const n=i.length-1,s=new Array(n);for(let r=0;r<n;++r){const a=Vt(i[r+1],t,e);s[r]=a}return s}function Et(i){return function(t,e,n){const s=t.length-1,r=new Array(s);for(let a=0;a<s;++a){const o=Vt(t[a+1],i,n);r[a]=o}return r}}function W0(i,t,e){const n=i[0],s=i.length-1;if(s%2===0)throw new Error(`expected an odd number of arguments for ${n}, got ${s} instead`)}function Vh(i,t,e){const n=i[0],s=i.length-1;if(s%2===1)throw new Error(`expected an even number of arguments for operation ${n}, got ${s} instead`)}function B0(i,t,e){const n=i.length-1,s=he|ft|ee,r=Vt(i[1],s,e),a=Vt(i[i.length-1],t,e),o=new Array(n-2);for(let h=0;h<n-2;h+=2){try{const l=Vt(i[h+2],r.type,e);o[h]=l}catch(l){throw new Error(`failed to parse argument ${h+1} of match expression: ${l.message}`)}try{const l=Vt(i[h+3],a.type,e);o[h+1]=l}catch(l){throw new Error(`failed to parse argument ${h+2} of match expression: ${l.message}`)}}return[r,...o,a]}function X0(i,t,e){const n=i[1];let s;switch(n[0]){case"linear":s=1;break;case"exponential":const h=n[1];if(typeof h!="number"||h<=0)throw new Error(`expected a number base for exponential interpolation, got ${JSON.stringify(h)} instead`);s=h;break;default:throw new Error(`invalid interpolation type: ${JSON.stringify(n)}`)}const r=new zt(ft,s);let a;try{a=Vt(i[2],ft,e)}catch(h){throw new Error(`failed to parse argument 1 in interpolate expression: ${h.message}`)}const o=new Array(i.length-3);for(let h=0;h<o.length;h+=2){try{const l=Vt(i[h+3],ft,e);o[h]=l}catch(l){throw new Error(`failed to parse argument ${h+2} for interpolate expression: ${l.message}`)}try{const l=Vt(i[h+4],t,e);o[h+1]=l}catch(l){throw new Error(`failed to parse argument ${h+3} for interpolate expression: ${l.message}`)}}return[r,a,...o]}function q0(i,t,e){const n=Vt(i[i.length-1],t,e),s=new Array(i.length-1);for(let r=0;r<s.length-1;r+=2){try{const a=Vt(i[r+1],ee,e);s[r]=a}catch(a){throw new Error(`failed to parse argument ${r} of case expression: ${a.message}`)}try{const a=Vt(i[r+2],n.type,e);s[r+1]=a}catch(a){throw new Error(`failed to parse argument ${r+1} of case expression: ${a.message}`)}}return s[s.length-1]=n,s}function j0(i,t,e){let n=i[2];if(!Array.isArray(n))throw new Error('the second argument for the "in" operator must be an array');let s;if(typeof n[0]=="string"){if(n[0]!=="literal")throw new Error('for the "in" operator, a string array should be wrapped in a "literal" operator to disambiguate from expressions');if(!Array.isArray(n[1]))throw new Error('failed to parse "in" expression: the literal operator must be followed by an array');n=n[1],s=he}else s=ft;const r=new Array(n.length);for(let o=0;o<r.length;o++)try{const h=Vt(n[o],s,e);r[o]=h}catch(h){throw new Error(`failed to parse haystack item ${o} for "in" expression: ${h.message}`)}return[Vt(i[1],s,e),...r]}function Y0(i,t,e){let n;try{n=Vt(i[1],ft,e)}catch(a){throw new Error(`failed to parse first argument in palette expression: ${a.message}`)}const s=i[2];if(!Array.isArray(s))throw new Error("the second argument of palette must be an array");const r=new Array(s.length);for(let a=0;a<r.length;a++){let o;try{o=Vt(s[a],Fe,e)}catch(h){throw new Error(`failed to parse color at index ${a} in palette expression: ${h.message}`)}if(!(o instanceof zt))throw new Error(`the palette color at index ${a} must be a literal value`);r[a]=o}return[n,...r]}function tt(...i){return function(t,e,n){const s=t[0];let r;for(let a=0;a<i.length;a++){const o=i[a](t,e,n);if(a==i.length-1){if(!o)throw new Error("expected last argument validator to return the parsed args");r=o}}return new N0(e,s,...r)}}function K0(i,t,e){const n=i[0],s=F0[n];if(!s)throw new Error(`unknown operator: ${n}`);return s(i,t,e)}function Bc(i){if(!i)return"";const t=i.getType();switch(t){case"Point":case"LineString":case"Polygon":return t;case"MultiPoint":case"MultiLineString":case"MultiPolygon":return t.substring(5);case"Circle":return"Polygon";case"GeometryCollection":return Bc(i.getGeometries()[0]);default:return""}}function Xc(){return{variables:{},properties:{},resolution:NaN,featureId:null,geometryType:""}}function ci(i,t,e){const n=Vt(i,t,e);return Ue(n)}function Ue(i,t){if(i instanceof zt){if(i.type===Fe&&typeof i.value=="string"){const n=Bo(i.value);return function(){return n}}return function(){return i.value}}const e=i.operator;switch(e){case A.Number:case A.String:case A.Coalesce:return V0(i);case A.Get:case A.Var:case A.Has:return Z0(i);case A.Id:return n=>n.featureId;case A.GeometryType:return n=>n.geometryType;case A.Concat:{const n=i.args.map(s=>Ue(s));return s=>"".concat(...n.map(r=>r(s).toString()))}case A.Resolution:return n=>n.resolution;case A.Any:case A.All:case A.Between:case A.In:case A.Not:return H0(i);case A.Equal:case A.NotEqual:case A.LessThan:case A.LessThanOrEqualTo:case A.GreaterThan:case A.GreaterThanOrEqualTo:return $0(i);case A.Multiply:case A.Divide:case A.Add:case A.Subtract:case A.Clamp:case A.Mod:case A.Pow:case A.Abs:case A.Floor:case A.Ceil:case A.Round:case A.Sin:case A.Cos:case A.Atan:case A.Sqrt:return J0(i);case A.Case:return Q0(i);case A.Match:return tg(i);case A.Interpolate:return eg(i);case A.ToString:return ig(i);default:throw new Error(`Unsupported operator ${e}`)}}function V0(i,t){const e=i.operator,n=i.args.length,s=new Array(n);for(let r=0;r<n;++r)s[r]=Ue(i.args[r]);switch(e){case A.Coalesce:return r=>{for(let a=0;a<n;++a){const o=s[a](r);if(typeof o<"u"&&o!==null)return o}throw new Error("Expected one of the values to be non-null")};case A.Number:case A.String:return r=>{for(let a=0;a<n;++a){const o=s[a](r);if(typeof o===e)return o}throw new Error(`Expected one of the values to be a ${e}`)};default:throw new Error(`Unsupported assertion operator ${e}`)}}function Z0(i,t){const n=i.args[0].value;switch(i.operator){case A.Get:return s=>{const r=i.args;let a=s.properties[n];for(let o=1,h=r.length;o<h;++o){const c=r[o].value;a=a[c]}return a};case A.Var:return s=>s.variables[n];case A.Has:return s=>{const r=i.args;if(!(n in s.properties))return!1;let a=s.properties[n];for(let o=1,h=r.length;o<h;++o){const c=r[o].value;if(!a||!Object.hasOwn(a,c))return!1;a=a[c]}return!0};default:throw new Error(`Unsupported accessor operator ${i.operator}`)}}function $0(i,t){const e=i.operator,n=Ue(i.args[0]),s=Ue(i.args[1]);switch(e){case A.Equal:return r=>n(r)===s(r);case A.NotEqual:return r=>n(r)!==s(r);case A.LessThan:return r=>n(r)<s(r);case A.LessThanOrEqualTo:return r=>n(r)<=s(r);case A.GreaterThan:return r=>n(r)>s(r);case A.GreaterThanOrEqualTo:return r=>n(r)>=s(r);default:throw new Error(`Unsupported comparison operator ${e}`)}}function H0(i,t){const e=i.operator,n=i.args.length,s=new Array(n);for(let r=0;r<n;++r)s[r]=Ue(i.args[r]);switch(e){case A.Any:return r=>{for(let a=0;a<n;++a)if(s[a](r))return!0;return!1};case A.All:return r=>{for(let a=0;a<n;++a)if(!s[a](r))return!1;return!0};case A.Between:return r=>{const a=s[0](r),o=s[1](r),h=s[2](r);return a>=o&&a<=h};case A.In:return r=>{const a=s[0](r);for(let o=1;o<n;++o)if(a===s[o](r))return!0;return!1};case A.Not:return r=>!s[0](r);default:throw new Error(`Unsupported logical operator ${e}`)}}function J0(i,t){const e=i.operator,n=i.args.length,s=new Array(n);for(let r=0;r<n;++r)s[r]=Ue(i.args[r]);switch(e){case A.Multiply:return r=>{let a=1;for(let o=0;o<n;++o)a*=s[o](r);return a};case A.Divide:return r=>s[0](r)/s[1](r);case A.Add:return r=>{let a=0;for(let o=0;o<n;++o)a+=s[o](r);return a};case A.Subtract:return r=>s[0](r)-s[1](r);case A.Clamp:return r=>{const a=s[0](r),o=s[1](r);if(a<o)return o;const h=s[2](r);return a>h?h:a};case A.Mod:return r=>s[0](r)%s[1](r);case A.Pow:return r=>Math.pow(s[0](r),s[1](r));case A.Abs:return r=>Math.abs(s[0](r));case A.Floor:return r=>Math.floor(s[0](r));case A.Ceil:return r=>Math.ceil(s[0](r));case A.Round:return r=>Math.round(s[0](r));case A.Sin:return r=>Math.sin(s[0](r));case A.Cos:return r=>Math.cos(s[0](r));case A.Atan:return n===2?r=>Math.atan2(s[0](r),s[1](r)):r=>Math.atan(s[0](r));case A.Sqrt:return r=>Math.sqrt(s[0](r));default:throw new Error(`Unsupported numeric operator ${e}`)}}function Q0(i,t){const e=i.args.length,n=new Array(e);for(let s=0;s<e;++s)n[s]=Ue(i.args[s]);return s=>{for(let r=0;r<e-1;r+=2)if(n[r](s))return n[r+1](s);return n[e-1](s)}}function tg(i,t){const e=i.args.length,n=new Array(e);for(let s=0;s<e;++s)n[s]=Ue(i.args[s]);return s=>{const r=n[0](s);for(let a=1;a<e-1;a+=2)if(r===n[a](s))return n[a+1](s);return n[e-1](s)}}function eg(i,t){const e=i.args.length,n=new Array(e);for(let s=0;s<e;++s)n[s]=Ue(i.args[s]);return s=>{const r=n[0](s),a=n[1](s);let o,h;for(let l=2;l<e;l+=2){const c=n[l](s);let u=n[l+1](s);const d=Array.isArray(u);if(d&&(u=P0(u)),c>=a)return l===2?u:d?ng(r,a,o,h,c,u):os(r,a,o,h,c,u);o=c,h=u}return h}}function ig(i,t){const e=i.operator,n=i.args.length,s=new Array(n);for(let r=0;r<n;++r)s[r]=Ue(i.args[r]);if(e===A.ToString)return r=>{const a=s[0](r);return i.args[0].type===Fe?Xo(a):a.toString()};throw new Error(`Unsupported convert operator ${e}`)}function os(i,t,e,n,s,r){const a=s-e;if(a===0)return n;const o=t-e,h=i===1?o/a:(Math.pow(i,o)-1)/(Math.pow(i,a)-1);return n+h*(r-n)}function ng(i,t,e,n,s,r){if(s-e===0)return n;const o=qh(n),h=qh(r);let l=h[2]-o[2];l>180?l-=360:l<-180&&(l+=360);const c=[os(i,t,e,o[0],s,h[0]),os(i,t,e,o[1],s,h[1]),o[2]+os(i,t,e,0,s,l),os(i,t,e,n[3],s,r[3])];return L0(c)}const j={IDLE:0,LOADING:1,LOADED:2,ERROR:3,EMPTY:4};class qc extends Fs{constructor(t,e,n,s){super(),this.extent=t,this.pixelRatio_=n,this.resolution=e,this.state=typeof s=="function"?j.IDLE:s,this.image_=null,this.loader=typeof s=="function"?s:null}changed(){this.dispatchEvent(et.CHANGE)}getExtent(){return this.extent}getImage(){return this.image_}getPixelRatio(){return this.pixelRatio_}getResolution(){return this.resolution}getState(){return this.state}load(){if(this.state==j.IDLE&&this.loader){this.state=j.LOADING,this.changed();const t=this.getResolution(),e=Array.isArray(t)?t[0]:t;$l(()=>this.loader(this.getExtent(),e,this.getPixelRatio())).then(n=>{"image"in n&&(this.image_=n.image),"extent"in n&&(this.extent=n.extent),"resolution"in n&&(this.resolution=n.resolution),"pixelRatio"in n&&(this.pixelRatio_=n.pixelRatio),(n instanceof HTMLImageElement||Kl&&n instanceof ImageBitmap||n instanceof HTMLCanvasElement||n instanceof HTMLVideoElement)&&(this.image_=n),this.state=j.LOADED}).catch(n=>{this.state=j.ERROR,console.error(n)}).finally(()=>this.changed())}}setImage(t){this.image_=t}setResolution(t){this.resolution=t}}function sg(i,t,e){const n=i;let s=!0,r=!1,a=!1;const o=[wr(n,et.LOAD,function(){a=!0,r||t()})];return n.src&&po?(r=!0,n.decode().then(function(){s&&t()}).catch(function(h){s&&(a?t():e())})):o.push(wr(n,et.ERROR,e)),function(){s=!1,o.forEach(bt)}}function rg(i,t){return new Promise((e,n)=>{function s(){a(),e(i)}function r(){a(),n(new Error("Image load error"))}function a(){i.removeEventListener("load",s),i.removeEventListener("error",r)}i.addEventListener("load",s),i.addEventListener("error",r)})}function jc(i,t){return t&&(i.src=t),i.src&&po?new Promise((e,n)=>i.decode().then(()=>e(i)).catch(s=>i.complete&&i.width?e(i):n(s))):rg(i)}function Yc(i,t){return t&&(i.src=t),i.src&&po&&Kl?i.decode().then(()=>createImageBitmap(i)).catch(e=>{if(i.complete&&i.width)return i;throw e}):jc(i)}class ag{constructor(){this.cache_={},this.patternCache_={},this.cacheSize_=0,this.maxCacheSize_=1024}clear(){this.cache_={},this.patternCache_={},this.cacheSize_=0}canExpireCache(){return this.cacheSize_>this.maxCacheSize_}expire(){if(this.canExpireCache()){let t=0;for(const e in this.cache_){const n=this.cache_[e];(t++&3)===0&&!n.hasListener()&&(delete this.cache_[e],delete this.patternCache_[e],--this.cacheSize_)}}}get(t,e,n){const s=Ra(t,e,n);return s in this.cache_?this.cache_[s]:null}getPattern(t,e,n){const s=Ra(t,e,n);return s in this.patternCache_?this.patternCache_[s]:null}set(t,e,n,s,r){const a=Ra(t,e,n),o=a in this.cache_;this.cache_[a]=s,r&&(s.getImageState()===j.IDLE&&s.load(),s.getImageState()===j.LOADING?s.ready().then(()=>{this.patternCache_[a]=Mr().createPattern(s.getImage(1),"repeat")}):this.patternCache_[a]=Mr().createPattern(s.getImage(1),"repeat")),o||++this.cacheSize_}setSize(t){this.maxCacheSize_=t,this.expire()}}function Ra(i,t,e){const n=e?kn(e):"null";return t+":"+i+":"+n}const Ie=new ag;let Qn=null;class Kc extends Fs{constructor(t,e,n,s,r){super(),this.hitDetectionImage_=null,this.image_=t,this.crossOrigin_=n,this.canvas_={},this.color_=r,this.imageState_=s===void 0?j.IDLE:s,this.size_=t&&t.width&&t.height?[t.width,t.height]:null,this.src_=e,this.tainted_,this.ready_=null}initializeImage_(){this.image_=new Image,this.crossOrigin_!==null&&(this.image_.crossOrigin=this.crossOrigin_)}isTainted_(){if(this.tainted_===void 0&&this.imageState_===j.LOADED){Qn||(Qn=Bt(1,1,void 0,{willReadFrequently:!0})),Qn.drawImage(this.image_,0,0);try{Qn.getImageData(0,0,1,1),this.tainted_=!1}catch{Qn=null,this.tainted_=!0}}return this.tainted_===!0}dispatchChangeEvent_(){this.dispatchEvent(et.CHANGE)}handleImageError_(){this.imageState_=j.ERROR,this.dispatchChangeEvent_()}handleImageLoad_(){this.imageState_=j.LOADED,this.size_=[this.image_.width,this.image_.height],this.dispatchChangeEvent_()}getImage(t){return this.image_||this.initializeImage_(),this.replaceColor_(t),this.canvas_[t]?this.canvas_[t]:this.image_}getPixelRatio(t){return this.replaceColor_(t),this.canvas_[t]?t:1}getImageState(){return this.imageState_}getHitDetectionImage(){if(this.image_||this.initializeImage_(),!this.hitDetectionImage_)if(this.isTainted_()){const t=this.size_[0],e=this.size_[1],n=Bt(t,e);n.fillRect(0,0,t,e),this.hitDetectionImage_=n.canvas}else this.hitDetectionImage_=this.image_;return this.hitDetectionImage_}getSize(){return this.size_}getSrc(){return this.src_}load(){if(this.imageState_===j.IDLE){this.image_||this.initializeImage_(),this.imageState_=j.LOADING;try{this.src_!==void 0&&(this.image_.src=this.src_)}catch{this.handleImageError_()}this.image_ instanceof HTMLImageElement&&jc(this.image_,this.src_).then(t=>{this.image_=t,this.handleImageLoad_()}).catch(this.handleImageError_.bind(this))}}replaceColor_(t){if(!this.color_||this.canvas_[t]||this.imageState_!==j.LOADED)return;const e=this.image_,n=Bt(Math.ceil(e.width*t),Math.ceil(e.height*t)),s=n.canvas;n.scale(t,t),n.drawImage(e,0,0),n.globalCompositeOperation="multiply",n.fillStyle=T0(this.color_),n.fillRect(0,0,s.width/t,s.height/t),n.globalCompositeOperation="destination-in",n.drawImage(e,0,0),this.canvas_[t]=s}ready(){return this.ready_||(this.ready_=new Promise(t=>{if(this.imageState_===j.LOADED||this.imageState_===j.ERROR)t();else{const e=()=>{(this.imageState_===j.LOADED||this.imageState_===j.ERROR)&&(this.removeEventListener(et.CHANGE,e),t())};this.addEventListener(et.CHANGE,e)}})),this.ready_}}function jo(i,t,e,n,s,r){let a=t===void 0?void 0:Ie.get(t,e,s);return a||(a=new Kc(i,i&&"src"in i?i.src||void 0:t,e,n,s),Ie.set(t,e,s,a,r)),r&&a&&!Ie.getPattern(t,e,s)&&Ie.set(t,e,s,a,r),a}function je(i){return i?Array.isArray(i)?Xo(i):typeof i=="object"&&"src"in i?og(i):i:null}function og(i){if(!i.offset||!i.size)return Ie.getPattern(i.src,"anonymous",i.color);const t=i.src+":"+i.offset,e=Ie.getPattern(t,void 0,i.color);if(e)return e;const n=Ie.get(i.src,"anonymous",null);if(n.getImageState()!==j.LOADED)return null;const s=Bt(i.size[0],i.size[1]);return s.drawImage(n.getImage(1),i.offset[0],i.offset[1],i.size[0],i.size[1],0,0,i.size[0],i.size[1]),jo(s.canvas,t,void 0,j.LOADED,i.color,!0),Ie.getPattern(t,void 0,i.color)}const Vc="10px sans-serif",le="#000",zn="round",oi=[],hi=0,Un="round",Ss=10,Cs="#000",Is="center",Pr="middle",qi=[0,0,0,0],Rs=1,mn=new He;let ts=null,Zh;const no={},hg=new Set(["serif","sans-serif","monospace","cursive","fantasy","system-ui","ui-serif","ui-sans-serif","ui-monospace","ui-rounded","emoji","math","fangsong"]);function lg(i,t,e){return`${i} ${t} 16px "${e}"`}const cg=(function(){let t,e;async function n(r){await e.ready;const a=await e.load(r);if(a.length===0)return!1;const o=ja(r),h=o.families[0].toLowerCase(),l=o.weight;return a.some(c=>{const u=c.family.replace(/^['"]|['"]$/g,"").toLowerCase(),d=qa[c.weight]||c.weight;return u===h&&c.style===o.style&&d==l})}async function s(){await e.ready;let r=!0;const a=mn.getProperties(),o=Object.keys(a).filter(h=>a[h]<100);for(let h=o.length-1;h>=0;--h){const l=o[h];let c=a[l];c<100&&(await n(l)?(Ns(no),mn.set(l,100)):(c+=10,mn.set(l,c,!0),c<100&&(r=!1)))}t=void 0,r||(t=setTimeout(s,100))}return async function(r){e||(e=yo?self.fonts:document.fonts);const a=ja(r);if(!a)return;const o=a.families;let h=!1;for(const l of o){if(hg.has(l))continue;const c=lg(a.style,a.weight,l);mn.get(c)===void 0&&(mn.set(c,0,!0),h=!0)}h&&(clearTimeout(t),t=setTimeout(s,100))}})(),ug=(function(){let i;return function(t){let e=no[t];if(e==null){if(yo){const n=ja(t),s=Zc(t,"Žg");e=(isNaN(Number(n.lineHeight))?1.2:Number(n.lineHeight))*(s.actualBoundingBoxAscent+s.actualBoundingBoxDescent)}else i||(i=document.createElement("div"),i.innerHTML="M",i.style.minHeight="0",i.style.maxHeight="none",i.style.height="auto",i.style.padding="0",i.style.border="none",i.style.position="absolute",i.style.display="block",i.style.left="-99999px"),i.style.font=t,document.body.appendChild(i),e=i.offsetHeight,document.body.removeChild(i);no[t]=e}return e}})();function Zc(i,t){return ts||(ts=Bt(1,1)),i!=Zh&&(ts.font=i,Zh=ts.font),ts.measureText(t)}function $c(i,t){return Zc(i,t).width}function $h(i,t,e){if(t in e)return e[t];const n=t.split(`
`).reduce((s,r)=>Math.max(s,$c(i,r)),0);return e[t]=n,n}function dg(i,t){const e=[],n=[],s=[];let r=0,a=0,o=0,h=0;for(let l=0,c=t.length;l<=c;l+=2){const u=t[l];if(u===`
`||l===c){r=Math.max(r,a),s.push(a),a=0,o+=h,h=0;continue}const d=t[l+1]||i.font,f=$c(d,u);e.push(f),a+=f;const g=ug(d);n.push(g),h=Math.max(h,g)}return{width:r,height:o,widths:e,heights:n,lineWidths:s}}function fg(i,t,e,n,s,r,a,o,h,l,c){i.save(),e!==1&&(i.globalAlpha===void 0?i.globalAlpha=u=>u.globalAlpha*=e:i.globalAlpha*=e),t&&i.transform.apply(i,t),n.contextInstructions?(i.translate(h,l),i.scale(c[0],c[1]),gg(n,i)):c[0]<0||c[1]<0?(i.translate(h,l),i.scale(c[0],c[1]),i.drawImage(n,s,r,a,o,0,0,a,o)):i.drawImage(n,s,r,a,o,h,l,a*c[0],o*c[1]),i.restore()}function gg(i,t){const e=i.contextInstructions;for(let n=0,s=e.length;n<s;n+=2)Array.isArray(e[n+1])?t[e[n]].apply(t,e[n+1]):t[e[n]]=e[n+1]}class ea{constructor(t){this.opacity_=t.opacity,this.rotateWithView_=t.rotateWithView,this.rotation_=t.rotation,this.scale_=t.scale,this.scaleArray_=de(t.scale),this.displacement_=t.displacement,this.declutterMode_=t.declutterMode}clone(){const t=this.getScale();return new ea({opacity:this.getOpacity(),scale:Array.isArray(t)?t.slice():t,rotation:this.getRotation(),rotateWithView:this.getRotateWithView(),displacement:this.getDisplacement().slice(),declutterMode:this.getDeclutterMode()})}getOpacity(){return this.opacity_}getRotateWithView(){return this.rotateWithView_}getRotation(){return this.rotation_}getScale(){return this.scale_}getScaleArray(){return this.scaleArray_}getDisplacement(){return this.displacement_}getDeclutterMode(){return this.declutterMode_}getAnchor(){return yt()}getImage(t){return yt()}getHitDetectionImage(){return yt()}getPixelRatio(t){return 1}getImageState(){return yt()}getImageSize(){return yt()}getOrigin(){return yt()}getSize(){return yt()}setDisplacement(t){this.displacement_=t}setOpacity(t){this.opacity_=t}setRotateWithView(t){this.rotateWithView_=t}setRotation(t){this.rotation_=t}setScale(t){this.scale_=t,this.scaleArray_=de(t)}listenImageChange(t){yt()}load(){yt()}unlistenImageChange(t){yt()}ready(){return Promise.resolve()}}class ia extends ea{constructor(t){super({opacity:1,rotateWithView:t.rotateWithView!==void 0?t.rotateWithView:!1,rotation:t.rotation!==void 0?t.rotation:0,scale:t.scale!==void 0?t.scale:1,displacement:t.displacement!==void 0?t.displacement:[0,0],declutterMode:t.declutterMode}),this.hitDetectionCanvas_=null,this.fill_=t.fill!==void 0?t.fill:null,this.origin_=[0,0],this.points_=t.points,this.radius=t.radius,this.radius2_=t.radius2,this.angle_=t.angle!==void 0?t.angle:0,this.stroke_=t.stroke!==void 0?t.stroke:null,this.size_,this.renderOptions_,this.imageState_=this.fill_&&this.fill_.loading()?j.LOADING:j.LOADED,this.imageState_===j.LOADING&&this.ready().then(()=>this.imageState_=j.LOADED),this.render()}clone(){const t=this.getScale(),e=new ia({fill:this.getFill()?this.getFill().clone():void 0,points:this.getPoints(),radius:this.getRadius(),radius2:this.getRadius2(),angle:this.getAngle(),stroke:this.getStroke()?this.getStroke().clone():void 0,rotation:this.getRotation(),rotateWithView:this.getRotateWithView(),scale:Array.isArray(t)?t.slice():t,displacement:this.getDisplacement().slice(),declutterMode:this.getDeclutterMode()});return e.setOpacity(this.getOpacity()),e}getAnchor(){const t=this.size_,e=this.getDisplacement(),n=this.getScaleArray();return[t[0]/2-e[0]/n[0],t[1]/2+e[1]/n[1]]}getAngle(){return this.angle_}getFill(){return this.fill_}setFill(t){this.fill_=t,this.render()}getHitDetectionImage(){return this.hitDetectionCanvas_||(this.hitDetectionCanvas_=this.createHitDetectionCanvas_(this.renderOptions_)),this.hitDetectionCanvas_}getImage(t){const e=this.fill_?.getKey(),n=`${t},${this.angle_},${this.radius},${this.radius2_},${this.points_},${e}`+Object.values(this.renderOptions_).join(",");let s=Ie.get(n,null,null)?.getImage(1);if(!s){const r=this.renderOptions_,a=Math.ceil(r.size*t),o=Bt(a,a);this.draw_(r,o,t),s=o.canvas,Ie.set(n,null,null,new Kc(s,void 0,null,j.LOADED,null))}return s}getPixelRatio(t){return t}getImageSize(){return this.size_}getImageState(){return this.imageState_}getOrigin(){return this.origin_}getPoints(){return this.points_}getRadius(){return this.radius}getRadius2(){return this.radius2_}getSize(){return this.size_}getStroke(){return this.stroke_}setStroke(t){this.stroke_=t,this.render()}listenImageChange(t){}load(){}unlistenImageChange(t){}calculateLineJoinSize_(t,e,n){if(e===0||this.points_===1/0||t!=="bevel"&&t!=="miter")return e;let s=this.radius,r=this.radius2_===void 0?s:this.radius2_;if(s<r){const C=s;s=r,r=C}const a=this.radius2_===void 0?this.points_:this.points_*2,o=2*Math.PI/a,h=r*Math.sin(o),l=Math.sqrt(r*r-h*h),c=s-l,u=Math.sqrt(h*h+c*c),d=u/h;if(t==="miter"&&d<=n)return d*e;const f=e/2/d,g=e/2*(c/u),m=Math.sqrt((s+f)*(s+f)+g*g)-s;if(this.radius2_===void 0||t==="bevel")return m*2;const y=s*Math.sin(o),p=Math.sqrt(s*s-y*y),x=r-p,M=Math.sqrt(y*y+x*x)/y;if(M<=n){const C=M*e/2-r-s;return 2*Math.max(m,C)}return m*2}createRenderOptions(){let t=zn,e=Un,n=0,s=null,r=0,a,o=0;this.stroke_&&(a=je(this.stroke_.getColor()??Cs),o=this.stroke_.getWidth()??Rs,s=this.stroke_.getLineDash(),r=this.stroke_.getLineDashOffset()??0,e=this.stroke_.getLineJoin()??Un,t=this.stroke_.getLineCap()??zn,n=this.stroke_.getMiterLimit()??Ss);const h=this.calculateLineJoinSize_(e,o,n),l=Math.max(this.radius,this.radius2_||0),c=Math.ceil(2*l+h);return{strokeStyle:a,strokeWidth:o,size:c,lineCap:t,lineDash:s,lineDashOffset:r,lineJoin:e,miterLimit:n}}render(){this.renderOptions_=this.createRenderOptions();const t=this.renderOptions_.size;this.hitDetectionCanvas_=null,this.size_=[t,t]}draw_(t,e,n){if(e.scale(n,n),e.translate(t.size/2,t.size/2),this.createPath_(e),this.fill_){let s=this.fill_.getColor();s===null&&(s=le),e.fillStyle=je(s),e.fill()}t.strokeStyle&&(e.strokeStyle=t.strokeStyle,e.lineWidth=t.strokeWidth,t.lineDash&&(e.setLineDash(t.lineDash),e.lineDashOffset=t.lineDashOffset),e.lineCap=t.lineCap,e.lineJoin=t.lineJoin,e.miterLimit=t.miterLimit,e.stroke())}createHitDetectionCanvas_(t){let e;if(this.fill_){let n=this.fill_.getColor(),s=0;typeof n=="string"&&(n=kn(n)),n===null?s=1:Array.isArray(n)&&(s=n.length===4?n[3]:1),s===0&&(e=Bt(t.size,t.size),this.drawHitDetectionCanvas_(t,e))}return e?e.canvas:this.getImage(1)}createPath_(t){let e=this.points_;const n=this.radius;if(e===1/0)t.arc(0,0,n,0,2*Math.PI);else{const s=this.radius2_===void 0?n:this.radius2_;this.radius2_!==void 0&&(e*=2);const r=this.angle_-Math.PI/2,a=2*Math.PI/e;for(let o=0;o<e;o++){const h=r+o*a,l=o%2===0?n:s;t.lineTo(l*Math.cos(h),l*Math.sin(h))}t.closePath()}}drawHitDetectionCanvas_(t,e){e.translate(t.size/2,t.size/2),this.createPath_(e),e.fillStyle=le,e.fill(),t.strokeStyle&&(e.strokeStyle=t.strokeStyle,e.lineWidth=t.strokeWidth,t.lineDash&&(e.setLineDash(t.lineDash),e.lineDashOffset=t.lineDashOffset),e.lineJoin=t.lineJoin,e.miterLimit=t.miterLimit,e.stroke())}ready(){return this.fill_?this.fill_.ready():Promise.resolve()}}class na extends ia{constructor(t){t=t||{radius:5},super({points:1/0,fill:t.fill,radius:t.radius,stroke:t.stroke,scale:t.scale!==void 0?t.scale:1,rotation:t.rotation!==void 0?t.rotation:0,rotateWithView:t.rotateWithView!==void 0?t.rotateWithView:!1,displacement:t.displacement!==void 0?t.displacement:[0,0],declutterMode:t.declutterMode})}clone(){const t=this.getScale(),e=new na({fill:this.getFill()?this.getFill().clone():void 0,stroke:this.getStroke()?this.getStroke().clone():void 0,radius:this.getRadius(),scale:Array.isArray(t)?t.slice():t,rotation:this.getRotation(),rotateWithView:this.getRotateWithView(),displacement:this.getDisplacement().slice(),declutterMode:this.getDeclutterMode()});return e.setOpacity(this.getOpacity()),e}setRadius(t){this.radius=t,this.render()}}class sn{constructor(t){t=t||{},this.patternImage_=null,this.color_=null,t.color!==void 0&&this.setColor(t.color)}clone(){const t=this.getColor();return new sn({color:Array.isArray(t)?t.slice():t||void 0})}getColor(){return this.color_}setColor(t){if(t!==null&&typeof t=="object"&&"src"in t){const e=jo(null,t.src,"anonymous",void 0,t.offset?null:t.color?t.color:null,!(t.offset&&t.size));e.ready().then(()=>{this.patternImage_=null}),e.getImageState()===j.IDLE&&e.load(),e.getImageState()===j.LOADING&&(this.patternImage_=e)}this.color_=t}getKey(){const t=this.getColor();return t?t instanceof CanvasPattern||t instanceof CanvasGradient?_t(t):typeof t=="object"&&"src"in t?t.src+":"+t.offset:kn(t).toString():""}loading(){return!!this.patternImage_}ready(){return this.patternImage_?this.patternImage_.ready():Promise.resolve()}}function Hh(i,t,e,n){return e!==void 0&&n!==void 0?[e/i,n/t]:e!==void 0?e/i:n!==void 0?n/t:1}class js extends ea{constructor(t){t=t||{};const e=t.opacity!==void 0?t.opacity:1,n=t.rotation!==void 0?t.rotation:0,s=t.scale!==void 0?t.scale:1,r=t.rotateWithView!==void 0?t.rotateWithView:!1;super({opacity:e,rotation:n,scale:s,displacement:t.displacement!==void 0?t.displacement:[0,0],rotateWithView:r,declutterMode:t.declutterMode}),this.anchor_=t.anchor!==void 0?t.anchor:[.5,.5],this.normalizedAnchor_=null,this.anchorOrigin_=t.anchorOrigin!==void 0?t.anchorOrigin:"top-left",this.anchorXUnits_=t.anchorXUnits!==void 0?t.anchorXUnits:"fraction",this.anchorYUnits_=t.anchorYUnits!==void 0?t.anchorYUnits:"fraction",this.crossOrigin_=t.crossOrigin!==void 0?t.crossOrigin:null;const a=t.img!==void 0?t.img:null;let o=t.src;vt(!(o!==void 0&&a),"`image` and `src` cannot be provided at the same time"),(o===void 0||o.length===0)&&a&&(o=a.src||_t(a)),vt(o!==void 0&&o.length>0,"A defined and non-empty `src` or `image` must be provided"),vt(!((t.width!==void 0||t.height!==void 0)&&t.scale!==void 0),"`width` or `height` cannot be provided together with `scale`");let h;if(t.src!==void 0?h=j.IDLE:a!==void 0&&("complete"in a?a.complete?h=a.src?j.LOADED:j.IDLE:h=j.LOADING:h=j.LOADED),this.color_=t.color!==void 0?kn(t.color):null,this.iconImage_=jo(a,o,this.crossOrigin_,h,this.color_),this.offset_=t.offset!==void 0?t.offset:[0,0],this.offsetOrigin_=t.offsetOrigin!==void 0?t.offsetOrigin:"top-left",this.origin_=null,this.size_=t.size!==void 0?t.size:null,this.initialOptions_,t.width!==void 0||t.height!==void 0){let l,c;if(t.size)[l,c]=t.size;else{const u=this.getImage(1);if(u.width&&u.height)l=u.width,c=u.height;else if(u instanceof HTMLImageElement){this.initialOptions_=t;const d=()=>{if(this.unlistenImageChange(d),!this.initialOptions_)return;const f=this.iconImage_.getSize();this.setScale(Hh(f[0],f[1],t.width,t.height))};this.listenImageChange(d);return}}l!==void 0&&this.setScale(Hh(l,c,t.width,t.height))}}clone(){let t,e,n;return this.initialOptions_?(e=this.initialOptions_.width,n=this.initialOptions_.height):(t=this.getScale(),t=Array.isArray(t)?t.slice():t),new js({anchor:this.anchor_.slice(),anchorOrigin:this.anchorOrigin_,anchorXUnits:this.anchorXUnits_,anchorYUnits:this.anchorYUnits_,color:this.color_&&this.color_.slice?this.color_.slice():this.color_||void 0,crossOrigin:this.crossOrigin_,offset:this.offset_.slice(),offsetOrigin:this.offsetOrigin_,opacity:this.getOpacity(),rotateWithView:this.getRotateWithView(),rotation:this.getRotation(),scale:t,width:e,height:n,size:this.size_!==null?this.size_.slice():void 0,src:this.getSrc(),displacement:this.getDisplacement().slice(),declutterMode:this.getDeclutterMode()})}getAnchor(){let t=this.normalizedAnchor_;if(!t){t=this.anchor_;const s=this.getSize();if(this.anchorXUnits_=="fraction"||this.anchorYUnits_=="fraction"){if(!s)return null;t=this.anchor_.slice(),this.anchorXUnits_=="fraction"&&(t[0]*=s[0]),this.anchorYUnits_=="fraction"&&(t[1]*=s[1])}if(this.anchorOrigin_!="top-left"){if(!s)return null;t===this.anchor_&&(t=this.anchor_.slice()),(this.anchorOrigin_=="top-right"||this.anchorOrigin_=="bottom-right")&&(t[0]=-t[0]+s[0]),(this.anchorOrigin_=="bottom-left"||this.anchorOrigin_=="bottom-right")&&(t[1]=-t[1]+s[1])}this.normalizedAnchor_=t}const e=this.getDisplacement(),n=this.getScaleArray();return[t[0]-e[0]/n[0],t[1]+e[1]/n[1]]}setAnchor(t){this.anchor_=t,this.normalizedAnchor_=null}getColor(){return this.color_}getImage(t){return this.iconImage_.getImage(t)}getPixelRatio(t){return this.iconImage_.getPixelRatio(t)}getImageSize(){return this.iconImage_.getSize()}getImageState(){return this.iconImage_.getImageState()}getHitDetectionImage(){return this.iconImage_.getHitDetectionImage()}getOrigin(){if(this.origin_)return this.origin_;let t=this.offset_;if(this.offsetOrigin_!="top-left"){const e=this.getSize(),n=this.iconImage_.getSize();if(!e||!n)return null;t=t.slice(),(this.offsetOrigin_=="top-right"||this.offsetOrigin_=="bottom-right")&&(t[0]=n[0]-e[0]-t[0]),(this.offsetOrigin_=="bottom-left"||this.offsetOrigin_=="bottom-right")&&(t[1]=n[1]-e[1]-t[1])}return this.origin_=t,this.origin_}getSrc(){return this.iconImage_.getSrc()}getSize(){return this.size_?this.size_:this.iconImage_.getSize()}getWidth(){const t=this.getScaleArray();if(this.size_)return this.size_[0]*t[0];if(this.iconImage_.getImageState()==j.LOADED)return this.iconImage_.getSize()[0]*t[0]}getHeight(){const t=this.getScaleArray();if(this.size_)return this.size_[1]*t[1];if(this.iconImage_.getImageState()==j.LOADED)return this.iconImage_.getSize()[1]*t[1]}setScale(t){delete this.initialOptions_,super.setScale(t)}listenImageChange(t){this.iconImage_.addEventListener(et.CHANGE,t)}load(){this.iconImage_.load()}unlistenImageChange(t){this.iconImage_.removeEventListener(et.CHANGE,t)}ready(){return this.iconImage_.ready()}}class Yn{constructor(t){t=t||{},this.color_=t.color!==void 0?t.color:null,this.lineCap_=t.lineCap,this.lineDash_=t.lineDash!==void 0?t.lineDash:null,this.lineDashOffset_=t.lineDashOffset,this.lineJoin_=t.lineJoin,this.miterLimit_=t.miterLimit,this.width_=t.width}clone(){const t=this.getColor();return new Yn({color:Array.isArray(t)?t.slice():t||void 0,lineCap:this.getLineCap(),lineDash:this.getLineDash()?this.getLineDash().slice():void 0,lineDashOffset:this.getLineDashOffset(),lineJoin:this.getLineJoin(),miterLimit:this.getMiterLimit(),width:this.getWidth()})}getColor(){return this.color_}getLineCap(){return this.lineCap_}getLineDash(){return this.lineDash_}getLineDashOffset(){return this.lineDashOffset_}getLineJoin(){return this.lineJoin_}getMiterLimit(){return this.miterLimit_}getWidth(){return this.width_}setColor(t){this.color_=t}setLineCap(t){this.lineCap_=t}setLineDash(t){this.lineDash_=t}setLineDashOffset(t){this.lineDashOffset_=t}setLineJoin(t){this.lineJoin_=t}setMiterLimit(t){this.miterLimit_=t}setWidth(t){this.width_=t}}class Ai{constructor(t){t=t||{},this.geometry_=null,this.geometryFunction_=Jh,t.geometry!==void 0&&this.setGeometry(t.geometry),this.fill_=t.fill!==void 0?t.fill:null,this.image_=t.image!==void 0?t.image:null,this.renderer_=t.renderer!==void 0?t.renderer:null,this.hitDetectionRenderer_=t.hitDetectionRenderer!==void 0?t.hitDetectionRenderer:null,this.stroke_=t.stroke!==void 0?t.stroke:null,this.text_=t.text!==void 0?t.text:null,this.zIndex_=t.zIndex}clone(){let t=this.getGeometry();return t&&typeof t=="object"&&(t=t.clone()),new Ai({geometry:t??void 0,fill:this.getFill()?this.getFill().clone():void 0,image:this.getImage()?this.getImage().clone():void 0,renderer:this.getRenderer()??void 0,stroke:this.getStroke()?this.getStroke().clone():void 0,text:this.getText()?this.getText().clone():void 0,zIndex:this.getZIndex()})}getRenderer(){return this.renderer_}setRenderer(t){this.renderer_=t}setHitDetectionRenderer(t){this.hitDetectionRenderer_=t}getHitDetectionRenderer(){return this.hitDetectionRenderer_}getGeometry(){return this.geometry_}getGeometryFunction(){return this.geometryFunction_}getFill(){return this.fill_}setFill(t){this.fill_=t}getImage(){return this.image_}setImage(t){this.image_=t}getStroke(){return this.stroke_}setStroke(t){this.stroke_=t}getText(){return this.text_}setText(t){this.text_=t}getZIndex(){return this.zIndex_}setGeometry(t){typeof t=="function"?this.geometryFunction_=t:typeof t=="string"?this.geometryFunction_=function(e){return e.get(t)}:t?t!==void 0&&(this.geometryFunction_=function(){return t}):this.geometryFunction_=Jh,this.geometry_=t}setZIndex(t){this.zIndex_=t}}function _g(i){let t;if(typeof i=="function")t=i;else{let e;Array.isArray(i)?e=i:(vt(typeof i.getZIndex=="function","Expected an `Style` or an array of `Style`"),e=[i]),t=function(){return e}}return t}let Aa=null;function Hc(i,t){if(!Aa){const e=new sn({color:"rgba(255,255,255,0.4)"}),n=new Yn({color:"#3399CC",width:1.25});Aa=[new Ai({image:new na({fill:e,stroke:n,radius:5}),fill:e,stroke:n})]}return Aa}function Jh(i){return i.getGeometry()}const mg="#333";class Ys{constructor(t){t=t||{},this.font_=t.font,this.rotation_=t.rotation,this.rotateWithView_=t.rotateWithView,this.keepUpright_=t.keepUpright,this.scale_=t.scale,this.scaleArray_=de(t.scale!==void 0?t.scale:1),this.text_=t.text,this.textAlign_=t.textAlign,this.justify_=t.justify,this.repeat_=t.repeat,this.textBaseline_=t.textBaseline,this.fill_=t.fill!==void 0?t.fill:new sn({color:mg}),this.maxAngle_=t.maxAngle!==void 0?t.maxAngle:Math.PI/4,this.placement_=t.placement!==void 0?t.placement:"point",this.overflow_=!!t.overflow,this.stroke_=t.stroke!==void 0?t.stroke:null,this.offsetX_=t.offsetX!==void 0?t.offsetX:0,this.offsetY_=t.offsetY!==void 0?t.offsetY:0,this.backgroundFill_=t.backgroundFill?t.backgroundFill:null,this.backgroundStroke_=t.backgroundStroke?t.backgroundStroke:null,this.padding_=t.padding===void 0?null:t.padding,this.declutterMode_=t.declutterMode}clone(){const t=this.getScale();return new Ys({font:this.getFont(),placement:this.getPlacement(),repeat:this.getRepeat(),maxAngle:this.getMaxAngle(),overflow:this.getOverflow(),rotation:this.getRotation(),rotateWithView:this.getRotateWithView(),keepUpright:this.getKeepUpright(),scale:Array.isArray(t)?t.slice():t,text:this.getText(),textAlign:this.getTextAlign(),justify:this.getJustify(),textBaseline:this.getTextBaseline(),fill:this.getFill()?this.getFill().clone():void 0,stroke:this.getStroke()?this.getStroke().clone():void 0,offsetX:this.getOffsetX(),offsetY:this.getOffsetY(),backgroundFill:this.getBackgroundFill()?this.getBackgroundFill().clone():void 0,backgroundStroke:this.getBackgroundStroke()?this.getBackgroundStroke().clone():void 0,padding:this.getPadding()||void 0,declutterMode:this.getDeclutterMode()})}getOverflow(){return this.overflow_}getFont(){return this.font_}getMaxAngle(){return this.maxAngle_}getPlacement(){return this.placement_}getRepeat(){return this.repeat_}getOffsetX(){return this.offsetX_}getOffsetY(){return this.offsetY_}getFill(){return this.fill_}getRotateWithView(){return this.rotateWithView_}getKeepUpright(){return this.keepUpright_}getRotation(){return this.rotation_}getScale(){return this.scale_}getScaleArray(){return this.scaleArray_}getStroke(){return this.stroke_}getText(){return this.text_}getTextAlign(){return this.textAlign_}getJustify(){return this.justify_}getTextBaseline(){return this.textBaseline_}getBackgroundFill(){return this.backgroundFill_}getBackgroundStroke(){return this.backgroundStroke_}getPadding(){return this.padding_}getDeclutterMode(){return this.declutterMode_}setOverflow(t){this.overflow_=t}setFont(t){this.font_=t}setMaxAngle(t){this.maxAngle_=t}setOffsetX(t){this.offsetX_=t}setOffsetY(t){this.offsetY_=t}setPlacement(t){this.placement_=t}setRepeat(t){this.repeat_=t}setRotateWithView(t){this.rotateWithView_=t}setKeepUpright(t){this.keepUpright_=t}setFill(t){this.fill_=t}setRotation(t){this.rotation_=t}setScale(t){this.scale_=t,this.scaleArray_=de(t!==void 0?t:1)}setStroke(t){this.stroke_=t}setText(t){this.text_=t}setTextAlign(t){this.textAlign_=t}setJustify(t){this.justify_=t}setTextBaseline(t){this.textBaseline_=t}setBackgroundFill(t){this.backgroundFill_=t}setBackgroundStroke(t){this.backgroundStroke_=t}setPadding(t){this.padding_=t}}function yg(i){return!0}function pg(i){const t=Wc(),e=Eg(i,t),n=Xc();return function(s,r){if(n.properties=s.getPropertiesInternal(),n.resolution=r,t.featureId){const a=s.getId();a!==void 0?n.featureId=a:n.featureId=null}return t.geometryType&&(n.geometryType=Bc(s.getGeometry())),e(n)}}function Qh(i){const t=Wc(),e=i.length,n=new Array(e);for(let a=0;a<e;++a)n[a]=so(i[a],t);const s=Xc(),r=new Array(e);return function(a,o){if(s.properties=a.getPropertiesInternal(),s.resolution=o,t.featureId){const l=a.getId();l!==void 0?s.featureId=l:s.featureId=null}let h=0;for(let l=0;l<e;++l){const c=n[l](s);c&&(r[h]=c,h+=1)}return r.length=h,r}}function Eg(i,t){const e=i.length,n=new Array(e);for(let s=0;s<e;++s){const r=i[s],a="filter"in r?ci(r.filter,ee,t):yg;let o;if(Array.isArray(r.style)){const h=r.style.length;o=new Array(h);for(let l=0;l<h;++l)o[l]=so(r.style[l],t)}else o=[so(r.style,t)];n[s]={filter:a,styles:o}}return function(s){const r=[];let a=!1;for(let o=0;o<e;++o){const h=n[o].filter;if(h(s)&&!(i[o].else&&a)){a=!0;for(const l of n[o].styles){const c=l(s);c&&r.push(c)}}}return r}}function so(i,t){const e=As(i,"",t),n=Ts(i,"",t),s=vg(i,t),r=xg(i,t),a=ce(i,"z-index",t);if(!e&&!n&&!s&&!r&&!Gn(i))throw new Error("No fill, stroke, point, or text symbolizer properties in style: "+JSON.stringify(i));const o=new Ai;return function(h){let l=!0;if(e){const c=e(h);c&&(l=!1),o.setFill(c)}if(n){const c=n(h);c&&(l=!1),o.setStroke(c)}if(s){const c=s(h);c&&(l=!1),o.setText(c)}if(r){const c=r(h);c&&(l=!1),o.setImage(c)}return a&&o.setZIndex(a(h)),l?null:o}}function As(i,t,e){let n;if(t+"fill-pattern-src"in i)n=Cg(i,t+"fill-",e);else{if(i[t+"fill-color"]==="none")return r=>null;n=Yo(i,t+"fill-color",e)}if(!n)return null;const s=new sn;return function(r){const a=n(r);return a===Wo?null:(s.setColor(a),s)}}function Ts(i,t,e){const n=ce(i,t+"stroke-width",e),s=Yo(i,t+"stroke-color",e);if(!n&&!s)return null;const r=si(i,t+"stroke-line-cap",e),a=si(i,t+"stroke-line-join",e),o=Jc(i,t+"stroke-line-dash",e),h=ce(i,t+"stroke-line-dash-offset",e),l=ce(i,t+"stroke-miter-limit",e),c=new Yn;return function(u){if(s){const d=s(u);if(d===Wo)return null;c.setColor(d)}if(n&&c.setWidth(n(u)),r){const d=r(u);if(d!=="butt"&&d!=="round"&&d!=="square")throw new Error("Expected butt, round, or square line cap");c.setLineCap(d)}if(a){const d=a(u);if(d!=="bevel"&&d!=="round"&&d!=="miter")throw new Error("Expected bevel, round, or miter line join");c.setLineJoin(d)}return o&&c.setLineDash(o(u)),h&&c.setLineDashOffset(h(u)),l&&c.setMiterLimit(l(u)),c}}function vg(i,t){const e="text-",n=si(i,e+"value",t);if(!n)return null;const s=As(i,e,t),r=As(i,e+"background-",t),a=Ts(i,e,t),o=Ts(i,e+"background-",t),h=si(i,e+"font",t),l=ce(i,e+"max-angle",t),c=ce(i,e+"offset-x",t),u=ce(i,e+"offset-y",t),d=An(i,e+"overflow",t),f=si(i,e+"placement",t),g=ce(i,e+"repeat",t),_=sa(i,e+"scale",t),m=An(i,e+"rotate-with-view",t),y=ce(i,e+"rotation",t),p=si(i,e+"align",t),x=si(i,e+"justify",t),v=si(i,e+"baseline",t),M=An(i,e+"keep-upright",t),C=Jc(i,e+"padding",t),P=ra(i,e+"declutter-mode"),b=new Ys({declutterMode:P});return function(L){if(b.setText(n(L)),s&&b.setFill(s(L)),r&&b.setBackgroundFill(r(L)),a&&b.setStroke(a(L)),o&&b.setBackgroundStroke(o(L)),h&&b.setFont(h(L)),l&&b.setMaxAngle(l(L)),c&&b.setOffsetX(c(L)),u&&b.setOffsetY(u(L)),d&&b.setOverflow(d(L)),f){const N=f(L);if(N!=="point"&&N!=="line")throw new Error("Expected point or line for text-placement");b.setPlacement(N)}if(g&&b.setRepeat(g(L)),_&&b.setScale(_(L)),m&&b.setRotateWithView(m(L)),y&&b.setRotation(y(L)),p){const N=p(L);if(N!=="left"&&N!=="center"&&N!=="right"&&N!=="end"&&N!=="start")throw new Error("Expected left, right, center, start, or end for text-align");b.setTextAlign(N)}if(x){const N=x(L);if(N!=="left"&&N!=="right"&&N!=="center")throw new Error("Expected left, right, or center for text-justify");b.setJustify(N)}if(v){const N=v(L);if(N!=="bottom"&&N!=="top"&&N!=="middle"&&N!=="alphabetic"&&N!=="hanging")throw new Error("Expected bottom, top, middle, alphabetic, or hanging for text-baseline");b.setTextBaseline(N)}return C&&b.setPadding(C(L)),M&&b.setKeepUpright(M(L)),b}}function xg(i,t){return"icon-src"in i?Mg(i,t):"shape-points"in i?wg(i,t):"circle-radius"in i?Sg(i,t):null}function Mg(i,t){const e="icon-",n=e+"src",s=Qc(i[n],n),r=Lr(i,e+"anchor",t),a=sa(i,e+"scale",t),o=ce(i,e+"opacity",t),h=Lr(i,e+"displacement",t),l=ce(i,e+"rotation",t),c=An(i,e+"rotate-with-view",t),u=el(i,e+"anchor-origin"),d=il(i,e+"anchor-x-units"),f=il(i,e+"anchor-y-units"),g=Tg(i,e+"color"),_=Rg(i,e+"cross-origin"),m=Ag(i,e+"offset"),y=el(i,e+"offset-origin"),p=Gr(i,e+"width"),x=Gr(i,e+"height"),v=Ig(i,e+"size"),M=ra(i,e+"declutter-mode"),C=new js({src:s,anchorOrigin:u,anchorXUnits:d,anchorYUnits:f,color:g,crossOrigin:_,offset:m,offsetOrigin:y,height:x,width:p,size:v,declutterMode:M});return function(P){return o&&C.setOpacity(o(P)),h&&C.setDisplacement(h(P)),l&&C.setRotation(l(P)),c&&C.setRotateWithView(c(P)),a&&C.setScale(a(P)),r&&C.setAnchor(r(P)),C}}function wg(i,t){const e="shape-",n=e+"points",s=e+"radius",r=ro(i[n],n),a=ro(i[s],s),o=As(i,e,t),h=Ts(i,e,t),l=sa(i,e+"scale",t),c=Lr(i,e+"displacement",t),u=ce(i,e+"rotation",t),d=An(i,e+"rotate-with-view",t),f=Gr(i,e+"radius2"),g=Gr(i,e+"angle"),_=ra(i,e+"declutter-mode"),m=new ia({points:r,radius:a,radius2:f,angle:g,declutterMode:_});return function(y){return o&&m.setFill(o(y)),h&&m.setStroke(h(y)),c&&m.setDisplacement(c(y)),u&&m.setRotation(u(y)),d&&m.setRotateWithView(d(y)),l&&m.setScale(l(y)),m}}function Sg(i,t){const e="circle-",n=As(i,e,t),s=Ts(i,e,t),r=ce(i,e+"radius",t),a=sa(i,e+"scale",t),o=Lr(i,e+"displacement",t),h=ce(i,e+"rotation",t),l=An(i,e+"rotate-with-view",t),c=ra(i,e+"declutter-mode"),u=new na({radius:5,declutterMode:c});return function(d){return r&&u.setRadius(r(d)),n&&u.setFill(n(d)),s&&u.setStroke(s(d)),o&&u.setDisplacement(o(d)),h&&u.setRotation(h(d)),l&&u.setRotateWithView(l(d)),a&&u.setScale(a(d)),u}}function ce(i,t,e){if(!(t in i))return;const n=ci(i[t],ft,e);return function(s){return ro(n(s),t)}}function si(i,t,e){if(!(t in i))return null;const n=ci(i[t],he,e);return function(s){return Qc(n(s),t)}}function Cg(i,t,e){const n=si(i,t+"pattern-src",e),s=tl(i,t+"pattern-offset",e),r=tl(i,t+"pattern-size",e),a=Yo(i,t+"color",e);return function(o){return{src:n(o),offset:s&&s(o),size:r&&r(o),color:a&&a(o)}}}function An(i,t,e){if(!(t in i))return null;const n=ci(i[t],ee,e);return function(s){const r=n(s);if(typeof r!="boolean")throw new Error(`Expected a boolean for ${t}`);return r}}function Yo(i,t,e){if(!(t in i))return null;const n=ci(i[t],Fe,e);return function(s){return tu(n(s),t)}}function Jc(i,t,e){if(!(t in i))return null;const n=ci(i[t],Hi,e);return function(s){return Ks(n(s),t)}}function Lr(i,t,e){if(!(t in i))return null;const n=ci(i[t],Hi,e);return function(s){const r=Ks(n(s),t);if(r.length!==2)throw new Error(`Expected two numbers for ${t}`);return r}}function tl(i,t,e){if(!(t in i))return null;const n=ci(i[t],Hi,e);return function(s){return eu(n(s),t)}}function sa(i,t,e){if(!(t in i))return null;const n=ci(i[t],Hi|ft,e);return function(s){return bg(n(s),t)}}function Gr(i,t){const e=i[t];if(e!==void 0){if(typeof e!="number")throw new Error(`Expected a number for ${t}`);return e}}function Ig(i,t){const e=i[t];if(e!==void 0){if(typeof e=="number")return de(e);if(!Array.isArray(e))throw new Error(`Expected a number or size array for ${t}`);if(e.length!==2||typeof e[0]!="number"||typeof e[1]!="number")throw new Error(`Expected a number or size array for ${t}`);return e}}function Rg(i,t){const e=i[t];if(e!==void 0){if(typeof e!="string")throw new Error(`Expected a string for ${t}`);return e}}function el(i,t){const e=i[t];if(e!==void 0){if(e!=="bottom-left"&&e!=="bottom-right"&&e!=="top-left"&&e!=="top-right")throw new Error(`Expected bottom-left, bottom-right, top-left, or top-right for ${t}`);return e}}function il(i,t){const e=i[t];if(e!==void 0){if(e!=="pixels"&&e!=="fraction")throw new Error(`Expected pixels or fraction for ${t}`);return e}}function Ag(i,t){const e=i[t];if(e!==void 0)return Ks(e,t)}function ra(i,t){const e=i[t];if(e!==void 0){if(typeof e!="string")throw new Error(`Expected a string for ${t}`);if(e!=="declutter"&&e!=="obstacle"&&e!=="none")throw new Error(`Expected declutter, obstacle, or none for ${t}`);return e}}function Tg(i,t){const e=i[t];if(e!==void 0)return tu(e,t)}function Ks(i,t){if(!Array.isArray(i))throw new Error(`Expected an array for ${t}`);const e=i.length;for(let n=0;n<e;++n)if(typeof i[n]!="number")throw new Error(`Expected an array of numbers for ${t}`);return i}function Qc(i,t){if(typeof i!="string")throw new Error(`Expected a string for ${t}`);return i}function ro(i,t){if(typeof i!="number")throw new Error(`Expected a number for ${t}`);return i}function tu(i,t){if(typeof i=="string")return i;const e=Ks(i,t),n=e.length;if(n<3||n>4)throw new Error(`Expected a color with 3 or 4 values for ${t}`);return e}function eu(i,t){const e=Ks(i,t);if(e.length!==2)throw new Error(`Expected an array of two numbers for ${t}`);return e}function bg(i,t){return typeof i=="number"?i:eu(i,t)}const nl={RENDER_ORDER:"renderOrder"};class iu extends qs{constructor(t){t=t||{};const e=Object.assign({},t);delete e.style,delete e.renderBuffer,delete e.updateWhileAnimating,delete e.updateWhileInteracting,super(e),this.declutter_=t.declutter?String(t.declutter):void 0,this.renderBuffer_=t.renderBuffer!==void 0?t.renderBuffer:100,this.style_=null,this.styleFunction_=void 0,this.setStyle(t.style),this.updateWhileAnimating_=t.updateWhileAnimating!==void 0?t.updateWhileAnimating:!1,this.updateWhileInteracting_=t.updateWhileInteracting!==void 0?t.updateWhileInteracting:!1}getDeclutter(){return this.declutter_}getFeatures(t){return super.getFeatures(t)}getRenderBuffer(){return this.renderBuffer_}getRenderOrder(){return this.get(nl.RENDER_ORDER)}getStyle(){return this.style_}getStyleFunction(){return this.styleFunction_}getUpdateWhileAnimating(){return this.updateWhileAnimating_}getUpdateWhileInteracting(){return this.updateWhileInteracting_}renderDeclutter(t,e){const n=this.getDeclutter();n in t.declutter||(t.declutter[n]=new zc(9)),this.getRenderer().renderDeclutter(t,e)}setRenderOrder(t){this.set(nl.RENDER_ORDER,t)}setStyle(t){this.style_=t===void 0?Hc:t;const e=Pg(t);this.styleFunction_=t===null?void 0:_g(e),this.changed()}setDeclutter(t){this.declutter_=t?String(t):void 0,this.changed()}}function Pg(i){if(i===void 0)return Hc;if(!i)return null;if(typeof i=="function"||i instanceof Ai)return i;if(!Array.isArray(i))return Qh([i]);if(i.length===0)return[];const t=i.length,e=i[0];if(e instanceof Ai){const s=new Array(t);for(let r=0;r<t;++r){const a=i[r];if(!(a instanceof Ai))throw new Error("Expected a list of style instances");s[r]=a}return s}if("style"in e){const s=new Array(t);for(let r=0;r<t;++r){const a=i[r];if(!("style"in a))throw new Error("Expected a list of rules with a style property");s[r]=a}return pg(s)}return Qh(i)}class nu extends We{constructor(t,e,n,s){super(t),this.inversePixelTransform=e,this.frameState=n,this.context=s}}class Lg extends Vr{constructor(t){super(),this.map_=t}dispatchRenderEvent(t,e){yt()}calculateMatrices2D(t){const e=t.viewState,n=t.coordinateToPixelTransform,s=t.pixelToCoordinateTransform;Ze(n,t.size[0]/2,t.size[1]/2,1/e.resolution,-1/e.resolution,-e.rotation,-e.center[0],-e.center[1]),Ec(s,n)}forEachFeatureAtCoordinate(t,e,n,s,r,a,o,h){let l;const c=e.viewState;function u(v,M,C,P){return r.call(a,M,v?C:null,P)}const d=c.projection,f=hc(t.slice(),d),g=[[0,0]];if(d.canWrapX()&&s){const v=d.getExtent(),M=gt(v);g.push([-M,0],[M,0])}const _=e.layerStatesArray,m=_.length,y=[],p=[];for(let v=0;v<g.length;v++)for(let M=m-1;M>=0;--M){const C=_[M],P=C.layer;if(P.hasRenderer()&&Uo(C,c)&&o.call(h,P)){const b=P.getRenderer(),L=P.getSource();if(b&&L){const N=L.getWrapX()?f:t,B=u.bind(null,C.managed);p[0]=N[0]+g[v][0],p[1]=N[1]+g[v][1],l=b.forEachFeatureAtCoordinate(p,e,n,B,y)}if(l)return l}}if(y.length===0)return;const x=1/y.length;return y.forEach((v,M)=>v.distanceSq+=M*x),y.sort((v,M)=>v.distanceSq-M.distanceSq),y.some(v=>l=v.callback(v.feature,v.layer,v.geometry)),l}hasFeatureAtCoordinate(t,e,n,s,r,a){return this.forEachFeatureAtCoordinate(t,e,n,s,Vi,this,r,a)!==void 0}getMap(){return this.map_}renderFrame(t){yt()}scheduleExpireIconCache(t){Ie.canExpireCache()&&t.postRenderFunctions.push(Gg)}}function Gg(i,t){Ie.expire()}class Og extends Lg{constructor(t){super(t),this.fontChangeListenerKey_=mt(mn,Ln.PROPERTYCHANGE,t.redrawText,t),this.element_=document.createElement("div");const e=this.element_.style;e.position="absolute",e.width="100%",e.height="100%",e.zIndex="0",this.element_.className=jr+" ol-layers";const n=t.getViewport();n.insertBefore(this.element_,n.firstChild||null),this.children_=[],this.renderedVisible_=!0}dispatchRenderEvent(t,e){const n=this.getMap();if(n.hasListener(t)){const s=new nu(t,void 0,e);n.dispatchEvent(s)}}disposeInternal(){bt(this.fontChangeListenerKey_),this.element_.remove(),super.disposeInternal()}renderFrame(t){if(!t){this.renderedVisible_&&(this.element_.style.display="none",this.renderedVisible_=!1);return}this.calculateMatrices2D(t),this.dispatchRenderEvent(Ce.PRECOMPOSE,t);const e=t.layerStatesArray.sort((o,h)=>o.zIndex-h.zIndex);e.some(o=>o.layer instanceof iu&&o.layer.getDeclutter())&&(t.declutter={});const s=t.viewState;this.children_.length=0;const r=[];let a=null;for(let o=0,h=e.length;o<h;++o){const l=e[o];t.layerIndex=o;const c=l.layer,u=c.getSourceState();if(!Uo(l,s)||u!="ready"&&u!="undefined"){c.unrender();continue}const d=c.render(t,a);d&&(d!==a&&(this.children_.push(d),a=d),r.push(l))}this.declutter(t,r),vd(this.element_,this.children_),this.dispatchRenderEvent(Ce.POSTCOMPOSE,t),this.renderedVisible_||(this.element_.style.display="",this.renderedVisible_=!0),this.scheduleExpireIconCache(t)}declutter(t,e){if(t.declutter){for(let n=e.length-1;n>=0;--n){const s=e[n],r=s.layer;r.getDeclutter()&&r.renderDeclutter(t,s)}e.forEach(n=>n.layer.renderDeferred(t))}}}function su(i){if(i instanceof qs){i.setMapInternal(null);return}i instanceof jn&&i.getLayers().forEach(su)}function ru(i,t){if(i instanceof qs){i.setMapInternal(t);return}if(i instanceof jn){const e=i.getLayers().getArray();for(let n=0,s=e.length;n<s;++n)ru(e[n],t)}}let Dg=class extends He{constructor(t){super(),t=t||{},this.on,this.once,this.un;const e=Ng(t);this.renderComplete_=!1,this.loaded_=!0,this.boundHandleBrowserEvent_=this.handleBrowserEvent.bind(this),this.maxTilesLoading_=t.maxTilesLoading!==void 0?t.maxTilesLoading:16,this.pixelRatio_=t.pixelRatio!==void 0?t.pixelRatio:pd,this.postRenderTimeoutHandle_,this.animationDelayKey_,this.animationDelay_=this.animationDelay_.bind(this),this.coordinateToPixelTransform_=ke(),this.pixelToCoordinateTransform_=ke(),this.frameIndex_=0,this.frameState_=null,this.previousExtent_=null,this.viewPropertyListenerKey_=null,this.viewChangeListenerKey_=null,this.layerGroupPropertyListenerKeys_=null,this.viewport_=document.createElement("div"),this.viewport_.className="ol-viewport"+("ontouchstart"in window?" ol-touch":""),this.viewport_.style.position="relative",this.viewport_.style.overflow="hidden",this.viewport_.style.width="100%",this.viewport_.style.height="100%",this.overlayContainer_=document.createElement("div"),this.overlayContainer_.style.position="absolute",this.overlayContainer_.style.zIndex="0",this.overlayContainer_.style.width="100%",this.overlayContainer_.style.height="100%",this.overlayContainer_.style.pointerEvents="none",this.overlayContainer_.className="ol-overlaycontainer",this.viewport_.appendChild(this.overlayContainer_),this.overlayContainerStopEvent_=document.createElement("div"),this.overlayContainerStopEvent_.style.position="absolute",this.overlayContainerStopEvent_.style.zIndex="0",this.overlayContainerStopEvent_.style.width="100%",this.overlayContainerStopEvent_.style.height="100%",this.overlayContainerStopEvent_.style.pointerEvents="none",this.overlayContainerStopEvent_.className="ol-overlaycontainer-stopevent",this.viewport_.appendChild(this.overlayContainerStopEvent_),this.mapBrowserEventHandler_=null,this.moveTolerance_=t.moveTolerance,this.keyboardEventTarget_=e.keyboardEventTarget,this.targetChangeHandlerKeys_=null,this.targetElement_=null,this.resizeObserver_=new ResizeObserver(()=>this.updateSize()),this.controls=e.controls||bc(),this.interactions=e.interactions||Nc({onFocusOnly:!0}),this.overlays_=e.overlays,this.overlayIdIndex_={},this.renderer_=null,this.postRenderFunctions_=[],this.tileQueue_=new uf(this.getTilePriority.bind(this),this.handleTileChange_.bind(this)),this.addChangeListener(Jt.LAYERGROUP,this.handleLayerGroupChanged_),this.addChangeListener(Jt.VIEW,this.handleViewChanged_),this.addChangeListener(Jt.SIZE,this.handleSizeChanged_),this.addChangeListener(Jt.TARGET,this.handleTargetChanged_),this.setProperties(e.values);const n=this;t.view&&!(t.view instanceof Be)&&t.view.then(function(s){n.setView(new Be(s))}),this.controls.addEventListener(oe.ADD,s=>{s.element.setMap(this)}),this.controls.addEventListener(oe.REMOVE,s=>{s.element.setMap(null)}),this.interactions.addEventListener(oe.ADD,s=>{s.element.setMap(this)}),this.interactions.addEventListener(oe.REMOVE,s=>{s.element.setMap(null)}),this.overlays_.addEventListener(oe.ADD,s=>{this.addOverlayInternal_(s.element)}),this.overlays_.addEventListener(oe.REMOVE,s=>{const r=s.element.getId();r!==void 0&&delete this.overlayIdIndex_[r.toString()],s.element.setMap(null)}),this.controls.forEach(s=>{s.setMap(this)}),this.interactions.forEach(s=>{s.setMap(this)}),this.overlays_.forEach(this.addOverlayInternal_.bind(this))}addControl(t){this.getControls().push(t)}addInteraction(t){this.getInteractions().push(t)}addLayer(t){this.getLayerGroup().getLayers().push(t)}handleLayerAdd_(t){ru(t.layer,this)}addOverlay(t){this.getOverlays().push(t)}addOverlayInternal_(t){const e=t.getId();e!==void 0&&(this.overlayIdIndex_[e.toString()]=t),t.setMap(this)}disposeInternal(){this.controls.clear(),this.interactions.clear(),this.overlays_.clear(),this.resizeObserver_.disconnect(),this.setTarget(null),super.disposeInternal()}forEachFeatureAtPixel(t,e,n){if(!this.frameState_||!this.renderer_)return;const s=this.getCoordinateFromPixelInternal(t);n=n!==void 0?n:{};const r=n.hitTolerance!==void 0?n.hitTolerance:0,a=n.layerFilter!==void 0?n.layerFilter:Vi,o=n.checkWrapped!==!1;return this.renderer_.forEachFeatureAtCoordinate(s,this.frameState_,r,o,e,null,a,null)}getFeaturesAtPixel(t,e){const n=[];return this.forEachFeatureAtPixel(t,function(s){n.push(s)},e),n}getAllLayers(){const t=[];function e(n){n.forEach(function(s){s instanceof jn?e(s.getLayers()):t.push(s)})}return e(this.getLayers()),t}hasFeatureAtPixel(t,e){if(!this.frameState_||!this.renderer_)return!1;const n=this.getCoordinateFromPixelInternal(t);e=e!==void 0?e:{};const s=e.layerFilter!==void 0?e.layerFilter:Vi,r=e.hitTolerance!==void 0?e.hitTolerance:0,a=e.checkWrapped!==!1;return this.renderer_.hasFeatureAtCoordinate(n,this.frameState_,r,a,s,null)}getEventCoordinate(t){return this.getCoordinateFromPixel(this.getEventPixel(t))}getEventCoordinateInternal(t){return this.getCoordinateFromPixelInternal(this.getEventPixel(t))}getEventPixel(t){const n=this.viewport_.getBoundingClientRect(),s=this.getSize(),r=n.width/s[0],a=n.height/s[1],o="changedTouches"in t?t.changedTouches[0]:t;return[(o.clientX-n.left)/r,(o.clientY-n.top)/a]}getTarget(){return this.get(Jt.TARGET)}getTargetElement(){return this.targetElement_}getCoordinateFromPixel(t){return to(this.getCoordinateFromPixelInternal(t),this.getView().getProjection())}getCoordinateFromPixelInternal(t){const e=this.frameState_;return e?Ut(e.pixelToCoordinateTransform,t.slice()):null}getControls(){return this.controls}getOverlays(){return this.overlays_}getOverlayById(t){const e=this.overlayIdIndex_[t.toString()];return e!==void 0?e:null}getInteractions(){return this.interactions}getLayerGroup(){return this.get(Jt.LAYERGROUP)}setLayers(t){const e=this.getLayerGroup();if(t instanceof ne){e.setLayers(t);return}const n=e.getLayers();n.clear(),n.extend(t)}getLayers(){return this.getLayerGroup().getLayers()}getLoadingOrNotReady(){const t=this.getLayerGroup().getLayerStatesArray();for(let e=0,n=t.length;e<n;++e){const s=t[e];if(!s.visible)continue;const r=s.layer.getRenderer();if(r&&!r.ready)return!0;const a=s.layer.getSource();if(a&&a.loading)return!0}return!1}getPixelFromCoordinate(t){const e=De(t,this.getView().getProjection());return this.getPixelFromCoordinateInternal(e)}getPixelFromCoordinateInternal(t){const e=this.frameState_;return e?Ut(e.coordinateToPixelTransform,t.slice(0,2)):null}getRenderer(){return this.renderer_}getSize(){return this.get(Jt.SIZE)}getView(){return this.get(Jt.VIEW)}getViewport(){return this.viewport_}getOverlayContainer(){return this.overlayContainer_}getOverlayContainerStopEvent(){return this.overlayContainerStopEvent_}getOwnerDocument(){const t=this.getTargetElement();return t?t.ownerDocument:document}getTilePriority(t,e,n,s){return df(this.frameState_,t,e,n,s)}handleBrowserEvent(t,e){e=e||t.type;const n=new Ei(e,this,t);this.handleMapBrowserEvent(n)}handleMapBrowserEvent(t){if(!this.frameState_)return;const e=t.originalEvent,n=e.type;if(n===Za.POINTERDOWN||n===et.WHEEL||n===et.KEYDOWN){const s=this.getOwnerDocument(),r=this.viewport_.getRootNode?this.viewport_.getRootNode():s,a=e.target,o=r instanceof ShadowRoot?r.host===a?r.host.ownerDocument:r:r===s?s.documentElement:r;if(this.overlayContainerStopEvent_.contains(a)||!o.contains(a))return}if(t.frameState=this.frameState_,this.dispatchEvent(t)!==!1){const s=this.getInteractions().getArray().slice();for(let r=s.length-1;r>=0;r--){const a=s[r];if(a.getMap()!==this||!a.getActive()||!this.getTargetElement())continue;if(!a.handleEvent(t)||t.propagationStopped)break}}}handlePostRender(){const t=this.frameState_,e=this.tileQueue_;if(!e.isEmpty()){let s=this.maxTilesLoading_,r=s;if(t){const a=t.viewHints;if(a[Yt.ANIMATING]||a[Yt.INTERACTING]){const o=Date.now()-t.time>8;s=o?0:8,r=o?0:2}}e.getTilesLoading()<s&&(e.reprioritize(),e.loadMoreTiles(s,r))}t&&this.renderer_&&!t.animate&&(this.renderComplete_?(this.hasListener(Ce.RENDERCOMPLETE)&&this.renderer_.dispatchRenderEvent(Ce.RENDERCOMPLETE,t),this.loaded_===!1&&(this.loaded_=!0,this.dispatchEvent(new gn(pi.LOADEND,this,t)))):this.loaded_===!0&&(this.loaded_=!1,this.dispatchEvent(new gn(pi.LOADSTART,this,t))));const n=this.postRenderFunctions_;if(t)for(let s=0,r=n.length;s<r;++s)n[s](this,t);n.length=0}handleSizeChanged_(){this.getView()&&!this.getView().getAnimating()&&this.getView().resolveConstraints(0),this.render()}handleTargetChanged_(){if(this.mapBrowserEventHandler_){for(let n=0,s=this.targetChangeHandlerKeys_.length;n<s;++n)bt(this.targetChangeHandlerKeys_[n]);this.targetChangeHandlerKeys_=null,this.viewport_.removeEventListener(et.CONTEXTMENU,this.boundHandleBrowserEvent_),this.viewport_.removeEventListener(et.WHEEL,this.boundHandleBrowserEvent_),this.mapBrowserEventHandler_.dispose(),this.mapBrowserEventHandler_=null,this.viewport_.remove()}if(this.targetElement_){this.resizeObserver_.unobserve(this.targetElement_);const n=this.targetElement_.getRootNode();n instanceof ShadowRoot&&this.resizeObserver_.unobserve(n.host),this.setSize(void 0)}const t=this.getTarget(),e=typeof t=="string"?document.getElementById(t):t;if(this.targetElement_=e,!e)this.renderer_&&(clearTimeout(this.postRenderTimeoutHandle_),this.postRenderTimeoutHandle_=void 0,this.postRenderFunctions_.length=0,this.renderer_.dispose(),this.renderer_=null),this.animationDelayKey_&&(cancelAnimationFrame(this.animationDelayKey_),this.animationDelayKey_=void 0);else{e.appendChild(this.viewport_),this.renderer_||(this.renderer_=new Og(this)),this.mapBrowserEventHandler_=new lf(this,this.moveTolerance_);for(const r in Dt)this.mapBrowserEventHandler_.addEventListener(Dt[r],this.handleMapBrowserEvent.bind(this));this.viewport_.addEventListener(et.CONTEXTMENU,this.boundHandleBrowserEvent_,!1),this.viewport_.addEventListener(et.WHEEL,this.boundHandleBrowserEvent_,Vl?{passive:!1}:!1);let n;if(this.keyboardEventTarget_)n=this.keyboardEventTarget_;else{const r=e.getRootNode();n=r instanceof ShadowRoot?r.host:e}this.targetChangeHandlerKeys_=[mt(n,et.KEYDOWN,this.handleBrowserEvent,this),mt(n,et.KEYPRESS,this.handleBrowserEvent,this)];const s=e.getRootNode();s instanceof ShadowRoot&&this.resizeObserver_.observe(s.host),this.resizeObserver_.observe(e)}this.updateSize()}handleTileChange_(){this.render()}handleViewPropertyChanged_(){this.render()}handleViewChanged_(){this.viewPropertyListenerKey_&&(bt(this.viewPropertyListenerKey_),this.viewPropertyListenerKey_=null),this.viewChangeListenerKey_&&(bt(this.viewChangeListenerKey_),this.viewChangeListenerKey_=null);const t=this.getView();t&&(this.updateViewportSize_(this.getSize()),this.viewPropertyListenerKey_=mt(t,Ln.PROPERTYCHANGE,this.handleViewPropertyChanged_,this),this.viewChangeListenerKey_=mt(t,et.CHANGE,this.handleViewPropertyChanged_,this),t.resolveConstraints(0)),this.render()}handleLayerGroupChanged_(){this.layerGroupPropertyListenerKeys_&&(this.layerGroupPropertyListenerKeys_.forEach(bt),this.layerGroupPropertyListenerKeys_=null);const t=this.getLayerGroup();t&&(this.handleLayerAdd_(new vi("addlayer",t)),this.layerGroupPropertyListenerKeys_=[mt(t,Ln.PROPERTYCHANGE,this.render,this),mt(t,et.CHANGE,this.render,this),mt(t,"addlayer",this.handleLayerAdd_,this),mt(t,"removelayer",this.handleLayerRemove_,this)]),this.render()}isRendered(){return!!this.frameState_}animationDelay_(){this.animationDelayKey_=void 0,this.renderFrame_(Date.now())}renderSync(){this.animationDelayKey_&&cancelAnimationFrame(this.animationDelayKey_),this.animationDelay_()}redrawText(){if(!this.frameState_)return;const t=this.frameState_.layerStatesArray;for(let e=0,n=t.length;e<n;++e){const s=t[e].layer;s.hasRenderer()&&s.getRenderer().handleFontsChanged()}}render(){this.renderer_&&this.animationDelayKey_===void 0&&(this.animationDelayKey_=requestAnimationFrame(this.animationDelay_))}removeControl(t){return this.getControls().remove(t)}removeInteraction(t){return this.getInteractions().remove(t)}removeLayer(t){return this.getLayerGroup().getLayers().remove(t)}handleLayerRemove_(t){su(t.layer)}removeOverlay(t){return this.getOverlays().remove(t)}renderFrame_(t){const e=this.getSize(),n=this.getView(),s=this.frameState_;let r=null;if(e!==void 0&&jh(e)&&n&&n.isDef()){const a=n.getHints(this.frameState_?this.frameState_.viewHints:void 0),o=n.getState();if(r={animate:!1,coordinateToPixelTransform:this.coordinateToPixelTransform_,declutter:null,extent:vs(o.center,o.resolution,o.rotation,e),index:this.frameIndex_++,layerIndex:0,layerStatesArray:this.getLayerGroup().getLayerStatesArray(),pixelRatio:this.pixelRatio_,pixelToCoordinateTransform:this.pixelToCoordinateTransform_,postRenderFunctions:[],size:e,tileQueue:this.tileQueue_,time:t,usedTiles:{},viewState:o,viewHints:a,wantedTiles:{},mapId:_t(this),renderTargets:{}},o.nextCenter&&o.nextResolution){const h=isNaN(o.nextRotation)?o.rotation:o.nextRotation;r.nextExtent=vs(o.nextCenter,o.nextResolution,h,e)}}this.frameState_=r,this.renderer_.renderFrame(r),r&&(r.animate&&this.render(),Array.prototype.push.apply(this.postRenderFunctions_,r.postRenderFunctions),s&&(!this.previousExtent_||!en(this.previousExtent_)&&!Dn(r.extent,this.previousExtent_))&&(this.dispatchEvent(new gn(pi.MOVESTART,this,s)),this.previousExtent_=zs(this.previousExtent_)),this.previousExtent_&&!r.viewHints[Yt.ANIMATING]&&!r.viewHints[Yt.INTERACTING]&&!Dn(r.extent,this.previousExtent_)&&(this.dispatchEvent(new gn(pi.MOVEEND,this,r)),Hl(r.extent,this.previousExtent_))),this.dispatchEvent(new gn(pi.POSTRENDER,this,r)),this.renderComplete_=(this.hasListener(pi.LOADSTART)||this.hasListener(pi.LOADEND)||this.hasListener(Ce.RENDERCOMPLETE))&&!this.tileQueue_.getTilesLoading()&&!this.tileQueue_.getCount()&&!this.getLoadingOrNotReady(),this.postRenderTimeoutHandle_||(this.postRenderTimeoutHandle_=setTimeout(()=>{this.postRenderTimeoutHandle_=void 0,this.handlePostRender()},0))}setLayerGroup(t){const e=this.getLayerGroup();e&&this.handleLayerRemove_(new vi("removelayer",e)),this.set(Jt.LAYERGROUP,t)}setSize(t){this.set(Jt.SIZE,t)}setTarget(t){this.set(Jt.TARGET,t)}setView(t){if(!t||t instanceof Be){this.set(Jt.VIEW,t);return}this.set(Jt.VIEW,new Be);const e=this;t.then(function(n){e.setView(new Be(n))})}updateSize(){const t=this.getTargetElement();let e;if(t){const s=getComputedStyle(t),r=t.offsetWidth-parseFloat(s.borderLeftWidth)-parseFloat(s.paddingLeft)-parseFloat(s.paddingRight)-parseFloat(s.borderRightWidth),a=t.offsetHeight-parseFloat(s.borderTopWidth)-parseFloat(s.paddingTop)-parseFloat(s.paddingBottom)-parseFloat(s.borderBottomWidth);!isNaN(r)&&!isNaN(a)&&(e=[Math.max(0,r),Math.max(0,a)],!jh(e)&&(t.offsetWidth||t.offsetHeight||t.getClientRects().length)&&cc("No map visible because the map container's width or height are 0."))}const n=this.getSize();e&&(!n||!Li(e,n))&&(this.setSize(e),this.updateViewportSize_(e))}updateViewportSize_(t){const e=this.getView();e&&e.setViewportSize(t)}};function Ng(i){let t=null;i.keyboardEventTarget!==void 0&&(t=typeof i.keyboardEventTarget=="string"?document.getElementById(i.keyboardEventTarget):i.keyboardEventTarget);const e={},n=i.layers&&typeof i.layers.getLayers=="function"?i.layers:new jn({layers:i.layers});e[Jt.LAYERGROUP]=n,e[Jt.TARGET]=i.target,e[Jt.VIEW]=i.view instanceof Be?i.view:new Be;let s;i.controls!==void 0&&(Array.isArray(i.controls)?s=new ne(i.controls.slice()):(vt(typeof i.controls.getArray=="function","Expected `controls` to be an array or an `ol/Collection.js`"),s=i.controls));let r;i.interactions!==void 0&&(Array.isArray(i.interactions)?r=new ne(i.interactions.slice()):(vt(typeof i.interactions.getArray=="function","Expected `interactions` to be an array or an `ol/Collection.js`"),r=i.interactions));let a;return i.overlays!==void 0?Array.isArray(i.overlays)?a=new ne(i.overlays.slice()):(vt(typeof i.overlays.getArray=="function","Expected `overlays` to be an array or an `ol/Collection.js`"),a=i.overlays):a=new ne,{controls:s,interactions:r,keyboardEventTarget:t,overlays:a,values:e}}class Vs extends He{constructor(t){if(super(),this.on,this.once,this.un,this.id_=void 0,this.geometryName_="geometry",this.style_=null,this.styleFunction_=void 0,this.geometryChangeKey_=null,this.addChangeListener(this.geometryName_,this.handleGeometryChanged_),t)if(typeof t.getSimplifiedGeometry=="function"){const e=t;this.setGeometry(e)}else{const e=t;this.setProperties(e)}}clone(){const t=new Vs(this.hasProperties()?this.getProperties():null);t.setGeometryName(this.getGeometryName());const e=this.getGeometry();e&&t.setGeometry(e.clone());const n=this.getStyle();return n&&t.setStyle(n),t}getGeometry(){return this.get(this.geometryName_)}getId(){return this.id_}getGeometryName(){return this.geometryName_}getStyle(){return this.style_}getStyleFunction(){return this.styleFunction_}handleGeometryChange_(){this.changed()}handleGeometryChanged_(){this.geometryChangeKey_&&(bt(this.geometryChangeKey_),this.geometryChangeKey_=null);const t=this.getGeometry();t&&(this.geometryChangeKey_=mt(t,et.CHANGE,this.handleGeometryChange_,this)),this.changed()}setGeometry(t){this.set(this.geometryName_,t)}setStyle(t){this.style_=t,this.styleFunction_=t?Fg(t):void 0,this.changed()}setId(t){this.id_=t,this.changed()}setGeometryName(t){this.removeChangeListener(this.geometryName_,this.handleGeometryChanged_),this.geometryName_=t,this.addChangeListener(this.geometryName_,this.handleGeometryChanged_),this.handleGeometryChanged_()}}function Fg(i){if(typeof i=="function")return i;let t;return Array.isArray(i)?t=i:(vt(typeof i.getZIndex=="function","Expected an `ol/style/Style` or an array of `ol/style/Style.js`"),t=[i]),function(){return t}}function sl(i,t,e,n,s,r,a){let o,h;const l=(e-t)/n;if(l===1)o=t;else if(l===2)o=t,h=s;else if(l!==0){let c=i[t],u=i[t+1],d=0;const f=[0];for(let m=t+n;m<e;m+=n){const y=i[m],p=i[m+1];d+=Math.sqrt((y-c)*(y-c)+(p-u)*(p-u)),f.push(d),c=y,u=p}const g=s*d,_=ud(f,g);_<0?(h=(g-f[-_-2])/(f[-_-1]-f[-_-2]),o=t+(-_-2)*n):o=t+_*n}a=a>1?a:2,r=r||new Array(a);for(let c=0;c<a;++c)r[c]=o===void 0?NaN:h===void 0?i[o+c]:Se(i[o+c],i[o+n+c],h);return r}function kg(i,t,e,n){let s=i[t],r=i[t+1],a=0;for(let o=t+n;o<e;o+=n){const h=i[o],l=i[o+1];a+=Math.sqrt((h-s)*(h-s)+(l-r)*(l-r)),s=h,r=l}return a}function zg(i,t,e,n){const s=[];let r=fe();for(let a=0,o=e.length;a<o;++a){const h=e[a];r=xo(i,t,h[0],n),s.push((r[0]+r[2])/2,(r[1]+r[3])/2),t=h[h.length-1]}return s}class au{drawCustom(t,e,n,s,r){}drawGeometry(t){}setStyle(t){}drawCircle(t,e,n){}drawFeature(t,e,n){}drawGeometryCollection(t,e,n){}drawLineString(t,e,n){}drawMultiLineString(t,e,n){}drawMultiPoint(t,e,n){}drawMultiPolygon(t,e,n){}drawPoint(t,e,n){}drawPolygon(t,e,n){}drawText(t,e,n){}setFillStrokeStyle(t,e){}setImageStyle(t,e){}setTextStyle(t,e){}}const Z={BEGIN_GEOMETRY:0,BEGIN_PATH:1,CIRCLE:2,CLOSE_PATH:3,CUSTOM:4,DRAW_CHARS:5,DRAW_IMAGE:6,END_GEOMETRY:7,FILL:8,MOVE_TO_LINE_TO:9,SET_FILL_STYLE:10,SET_STROKE_STYLE:11,STROKE:12},fr=[Z.FILL],wi=[Z.STROKE],ji=[Z.BEGIN_PATH],rl=[Z.CLOSE_PATH];class Zs extends au{constructor(t,e,n,s){super(),this.tolerance=t,this.maxExtent=e,this.pixelRatio=s,this.maxLineWidth=0,this.resolution=n,this.beginGeometryInstruction1_=null,this.beginGeometryInstruction2_=null,this.bufferedMaxExtent_=null,this.instructions=[],this.coordinates=[],this.tmpCoordinate_=[],this.hitDetectionInstructions=[],this.state={}}applyPixelRatio(t){const e=this.pixelRatio;return e==1?t:t.map(function(n){return n*e})}appendFlatPointCoordinates(t,e){const n=this.getBufferedMaxExtent(),s=this.tmpCoordinate_,r=this.coordinates;let a=r.length;for(let o=0,h=t.length;o<h;o+=e)s[0]=t[o],s[1]=t[o+1],Zi(n,s)&&(r[a++]=s[0],r[a++]=s[1]);return a}appendFlatLineCoordinates(t,e,n,s,r,a){const o=this.coordinates;let h=o.length;const l=this.getBufferedMaxExtent();a&&(e+=s);let c=t[e],u=t[e+1];const d=this.tmpCoordinate_;let f=!0,g,_,m;for(g=e+s;g<n;g+=s)d[0]=t[g],d[1]=t[g+1],m=Ya(l,d),m!==_?(f&&(o[h++]=c,o[h++]=u,f=!1),o[h++]=d[0],o[h++]=d[1]):m===jt.INTERSECTING?(o[h++]=d[0],o[h++]=d[1],f=!1):f=!0,c=d[0],u=d[1],_=m;return(r&&f||g===e+s)&&(o[h++]=c,o[h++]=u),h}drawCustomCoordinates_(t,e,n,s,r){for(let a=0,o=n.length;a<o;++a){const h=n[a],l=this.appendFlatLineCoordinates(t,e,h,s,!1,!1);r.push(l),e=h}return e}drawCustom(t,e,n,s,r){this.beginGeometry(t,e,r);const a=t.getType(),o=t.getStride(),h=this.coordinates.length;let l,c,u,d,f;switch(a){case"MultiPolygon":l=t.getOrientedFlatCoordinates(),d=[];const g=t.getEndss();f=0;for(let _=0,m=g.length;_<m;++_){const y=[];f=this.drawCustomCoordinates_(l,f,g[_],o,y),d.push(y)}this.instructions.push([Z.CUSTOM,h,d,t,n,kh,r]),this.hitDetectionInstructions.push([Z.CUSTOM,h,d,t,s||n,kh,r]);break;case"Polygon":case"MultiLineString":u=[],l=a=="Polygon"?t.getOrientedFlatCoordinates():t.getFlatCoordinates(),f=this.drawCustomCoordinates_(l,0,t.getEnds(),o,u),this.instructions.push([Z.CUSTOM,h,u,t,n,br,r]),this.hitDetectionInstructions.push([Z.CUSTOM,h,u,t,s||n,br,r]);break;case"LineString":case"Circle":l=t.getFlatCoordinates(),c=this.appendFlatLineCoordinates(l,0,l.length,o,!1,!1),this.instructions.push([Z.CUSTOM,h,c,t,n,xn,r]),this.hitDetectionInstructions.push([Z.CUSTOM,h,c,t,s||n,xn,r]);break;case"MultiPoint":l=t.getFlatCoordinates(),c=this.appendFlatPointCoordinates(l,o),c>h&&(this.instructions.push([Z.CUSTOM,h,c,t,n,xn,r]),this.hitDetectionInstructions.push([Z.CUSTOM,h,c,t,s||n,xn,r]));break;case"Point":l=t.getFlatCoordinates(),this.coordinates.push(l[0],l[1]),c=this.coordinates.length,this.instructions.push([Z.CUSTOM,h,c,t,n,void 0,r]),this.hitDetectionInstructions.push([Z.CUSTOM,h,c,t,s||n,void 0,r]);break}this.endGeometry(e)}beginGeometry(t,e,n){this.beginGeometryInstruction1_=[Z.BEGIN_GEOMETRY,e,0,t,n],this.instructions.push(this.beginGeometryInstruction1_),this.beginGeometryInstruction2_=[Z.BEGIN_GEOMETRY,e,0,t,n],this.hitDetectionInstructions.push(this.beginGeometryInstruction2_)}finish(){return{instructions:this.instructions,hitDetectionInstructions:this.hitDetectionInstructions,coordinates:this.coordinates}}reverseHitDetectionInstructions(){const t=this.hitDetectionInstructions;t.reverse();let e;const n=t.length;let s,r,a=-1;for(e=0;e<n;++e)s=t[e],r=s[0],r==Z.END_GEOMETRY?a=e:r==Z.BEGIN_GEOMETRY&&(s[2]=e,fd(this.hitDetectionInstructions,a,e),a=-1)}fillStyleToState(t,e={}){if(t){const n=t.getColor();e.fillPatternScale=n&&typeof n=="object"&&"src"in n?this.pixelRatio:1,e.fillStyle=je(n||le)}else e.fillStyle=void 0;return e}strokeStyleToState(t,e={}){if(t){const n=t.getColor();e.strokeStyle=je(n||Cs);const s=t.getLineCap();e.lineCap=s!==void 0?s:zn;const r=t.getLineDash();e.lineDash=r?r.slice():oi;const a=t.getLineDashOffset();e.lineDashOffset=a||hi;const o=t.getLineJoin();e.lineJoin=o!==void 0?o:Un;const h=t.getWidth();e.lineWidth=h!==void 0?h:Rs;const l=t.getMiterLimit();e.miterLimit=l!==void 0?l:Ss,e.lineWidth>this.maxLineWidth&&(this.maxLineWidth=e.lineWidth,this.bufferedMaxExtent_=null)}else e.strokeStyle=void 0,e.lineCap=void 0,e.lineDash=null,e.lineDashOffset=void 0,e.lineJoin=void 0,e.lineWidth=void 0,e.miterLimit=void 0;return e}setFillStrokeStyle(t,e){const n=this.state;this.fillStyleToState(t,n),this.strokeStyleToState(e,n)}createFill(t){const e=t.fillStyle,n=[Z.SET_FILL_STYLE,e];return typeof e!="string"&&n.push(t.fillPatternScale),n}applyStroke(t){this.instructions.push(this.createStroke(t))}createStroke(t){return[Z.SET_STROKE_STYLE,t.strokeStyle,t.lineWidth*this.pixelRatio,t.lineCap,t.lineJoin,t.miterLimit,t.lineDash?this.applyPixelRatio(t.lineDash):null,t.lineDashOffset*this.pixelRatio]}updateFillStyle(t,e){const n=t.fillStyle;(typeof n!="string"||t.currentFillStyle!=n)&&(this.instructions.push(e.call(this,t)),t.currentFillStyle=n)}updateStrokeStyle(t,e){const n=t.strokeStyle,s=t.lineCap,r=t.lineDash,a=t.lineDashOffset,o=t.lineJoin,h=t.lineWidth,l=t.miterLimit;(t.currentStrokeStyle!=n||t.currentLineCap!=s||r!=t.currentLineDash&&!Li(t.currentLineDash,r)||t.currentLineDashOffset!=a||t.currentLineJoin!=o||t.currentLineWidth!=h||t.currentMiterLimit!=l)&&(e.call(this,t),t.currentStrokeStyle=n,t.currentLineCap=s,t.currentLineDash=r,t.currentLineDashOffset=a,t.currentLineJoin=o,t.currentLineWidth=h,t.currentMiterLimit=l)}endGeometry(t){this.beginGeometryInstruction1_[2]=this.instructions.length,this.beginGeometryInstruction1_=null,this.beginGeometryInstruction2_[2]=this.hitDetectionInstructions.length,this.beginGeometryInstruction2_=null;const e=[Z.END_GEOMETRY,t];this.instructions.push(e),this.hitDetectionInstructions.push(e)}getBufferedMaxExtent(){if(!this.bufferedMaxExtent_&&(this.bufferedMaxExtent_=Hl(this.maxExtent),this.maxLineWidth>0)){const t=this.resolution*(this.maxLineWidth+1)/2;On(this.bufferedMaxExtent_,t,this.bufferedMaxExtent_)}return this.bufferedMaxExtent_}}class Ug extends Zs{constructor(t,e,n,s){super(t,e,n,s),this.hitDetectionImage_=null,this.image_=null,this.imagePixelRatio_=void 0,this.anchorX_=void 0,this.anchorY_=void 0,this.height_=void 0,this.opacity_=void 0,this.originX_=void 0,this.originY_=void 0,this.rotateWithView_=void 0,this.rotation_=void 0,this.scale_=void 0,this.width_=void 0,this.declutterMode_=void 0,this.declutterImageWithText_=void 0}drawPoint(t,e,n){if(!this.image_||this.maxExtent&&!Zi(this.maxExtent,t.getFlatCoordinates()))return;this.beginGeometry(t,e,n);const s=t.getFlatCoordinates(),r=t.getStride(),a=this.coordinates.length,o=this.appendFlatPointCoordinates(s,r);this.instructions.push([Z.DRAW_IMAGE,a,o,this.image_,this.anchorX_*this.imagePixelRatio_,this.anchorY_*this.imagePixelRatio_,Math.ceil(this.height_*this.imagePixelRatio_),this.opacity_,this.originX_*this.imagePixelRatio_,this.originY_*this.imagePixelRatio_,this.rotateWithView_,this.rotation_,[this.scale_[0]*this.pixelRatio/this.imagePixelRatio_,this.scale_[1]*this.pixelRatio/this.imagePixelRatio_],Math.ceil(this.width_*this.imagePixelRatio_),this.declutterMode_,this.declutterImageWithText_]),this.hitDetectionInstructions.push([Z.DRAW_IMAGE,a,o,this.hitDetectionImage_,this.anchorX_,this.anchorY_,this.height_,1,this.originX_,this.originY_,this.rotateWithView_,this.rotation_,this.scale_,this.width_,this.declutterMode_,this.declutterImageWithText_]),this.endGeometry(e)}drawMultiPoint(t,e,n){if(!this.image_)return;this.beginGeometry(t,e,n);const s=t.getFlatCoordinates(),r=[];for(let h=0,l=s.length;h<l;h+=t.getStride())(!this.maxExtent||Zi(this.maxExtent,s.slice(h,h+2)))&&r.push(s[h],s[h+1]);const a=this.coordinates.length,o=this.appendFlatPointCoordinates(r,2);this.instructions.push([Z.DRAW_IMAGE,a,o,this.image_,this.anchorX_*this.imagePixelRatio_,this.anchorY_*this.imagePixelRatio_,Math.ceil(this.height_*this.imagePixelRatio_),this.opacity_,this.originX_*this.imagePixelRatio_,this.originY_*this.imagePixelRatio_,this.rotateWithView_,this.rotation_,[this.scale_[0]*this.pixelRatio/this.imagePixelRatio_,this.scale_[1]*this.pixelRatio/this.imagePixelRatio_],Math.ceil(this.width_*this.imagePixelRatio_),this.declutterMode_,this.declutterImageWithText_]),this.hitDetectionInstructions.push([Z.DRAW_IMAGE,a,o,this.hitDetectionImage_,this.anchorX_,this.anchorY_,this.height_,1,this.originX_,this.originY_,this.rotateWithView_,this.rotation_,this.scale_,this.width_,this.declutterMode_,this.declutterImageWithText_]),this.endGeometry(e)}finish(){return this.reverseHitDetectionInstructions(),this.anchorX_=void 0,this.anchorY_=void 0,this.hitDetectionImage_=null,this.image_=null,this.imagePixelRatio_=void 0,this.height_=void 0,this.scale_=void 0,this.opacity_=void 0,this.originX_=void 0,this.originY_=void 0,this.rotateWithView_=void 0,this.rotation_=void 0,this.width_=void 0,super.finish()}setImageStyle(t,e){const n=t.getAnchor(),s=t.getSize(),r=t.getOrigin();this.imagePixelRatio_=t.getPixelRatio(this.pixelRatio),this.anchorX_=n[0],this.anchorY_=n[1],this.hitDetectionImage_=t.getHitDetectionImage(),this.image_=t.getImage(this.pixelRatio),this.height_=s[1],this.opacity_=t.getOpacity(),this.originX_=r[0],this.originY_=r[1],this.rotateWithView_=t.getRotateWithView(),this.rotation_=t.getRotation(),this.scale_=t.getScaleArray(),this.width_=s[0],this.declutterMode_=t.getDeclutterMode(),this.declutterImageWithText_=e}}class Wg extends Zs{constructor(t,e,n,s){super(t,e,n,s)}drawFlatCoordinates_(t,e,n,s){const r=this.coordinates.length,a=this.appendFlatLineCoordinates(t,e,n,s,!1,!1),o=[Z.MOVE_TO_LINE_TO,r,a];return this.instructions.push(o),this.hitDetectionInstructions.push(o),n}drawLineString(t,e,n){const s=this.state,r=s.strokeStyle,a=s.lineWidth;if(r===void 0||a===void 0)return;this.updateStrokeStyle(s,this.applyStroke),this.beginGeometry(t,e,n),this.hitDetectionInstructions.push([Z.SET_STROKE_STYLE,s.strokeStyle,s.lineWidth,s.lineCap,s.lineJoin,s.miterLimit,oi,hi],ji);const o=t.getFlatCoordinates(),h=t.getStride();this.drawFlatCoordinates_(o,0,o.length,h),this.hitDetectionInstructions.push(wi),this.endGeometry(e)}drawMultiLineString(t,e,n){const s=this.state,r=s.strokeStyle,a=s.lineWidth;if(r===void 0||a===void 0)return;this.updateStrokeStyle(s,this.applyStroke),this.beginGeometry(t,e,n),this.hitDetectionInstructions.push([Z.SET_STROKE_STYLE,s.strokeStyle,s.lineWidth,s.lineCap,s.lineJoin,s.miterLimit,oi,hi],ji);const o=t.getEnds(),h=t.getFlatCoordinates(),l=t.getStride();let c=0;for(let u=0,d=o.length;u<d;++u)c=this.drawFlatCoordinates_(h,c,o[u],l);this.hitDetectionInstructions.push(wi),this.endGeometry(e)}finish(){const t=this.state;return t.lastStroke!=null&&t.lastStroke!=this.coordinates.length&&this.instructions.push(wi),this.reverseHitDetectionInstructions(),this.state=null,super.finish()}applyStroke(t){t.lastStroke!=null&&t.lastStroke!=this.coordinates.length&&(this.instructions.push(wi),t.lastStroke=this.coordinates.length),t.lastStroke=0,super.applyStroke(t),this.instructions.push(ji)}}class al extends Zs{constructor(t,e,n,s){super(t,e,n,s)}drawFlatCoordinatess_(t,e,n,s){const r=this.state,a=r.fillStyle!==void 0,o=r.strokeStyle!==void 0,h=n.length;this.instructions.push(ji),this.hitDetectionInstructions.push(ji);for(let l=0;l<h;++l){const c=n[l],u=this.coordinates.length,d=this.appendFlatLineCoordinates(t,e,c,s,!0,!o),f=[Z.MOVE_TO_LINE_TO,u,d];this.instructions.push(f),this.hitDetectionInstructions.push(f),o&&(this.instructions.push(rl),this.hitDetectionInstructions.push(rl)),e=c}return a&&(this.instructions.push(fr),this.hitDetectionInstructions.push(fr)),o&&(this.instructions.push(wi),this.hitDetectionInstructions.push(wi)),e}drawCircle(t,e,n){const s=this.state,r=s.fillStyle,a=s.strokeStyle;if(r===void 0&&a===void 0)return;this.setFillStrokeStyles_(),this.beginGeometry(t,e,n),s.fillStyle!==void 0&&this.hitDetectionInstructions.push([Z.SET_FILL_STYLE,le]),s.strokeStyle!==void 0&&this.hitDetectionInstructions.push([Z.SET_STROKE_STYLE,s.strokeStyle,s.lineWidth,s.lineCap,s.lineJoin,s.miterLimit,oi,hi]);const o=t.getFlatCoordinates(),h=t.getStride(),l=this.coordinates.length;this.appendFlatLineCoordinates(o,0,o.length,h,!1,!1);const c=[Z.CIRCLE,l];this.instructions.push(ji,c),this.hitDetectionInstructions.push(ji,c),s.fillStyle!==void 0&&(this.instructions.push(fr),this.hitDetectionInstructions.push(fr)),s.strokeStyle!==void 0&&(this.instructions.push(wi),this.hitDetectionInstructions.push(wi)),this.endGeometry(e)}drawPolygon(t,e,n){const s=this.state,r=s.fillStyle,a=s.strokeStyle;if(r===void 0&&a===void 0)return;this.setFillStrokeStyles_(),this.beginGeometry(t,e,n),s.fillStyle!==void 0&&this.hitDetectionInstructions.push([Z.SET_FILL_STYLE,le]),s.strokeStyle!==void 0&&this.hitDetectionInstructions.push([Z.SET_STROKE_STYLE,s.strokeStyle,s.lineWidth,s.lineCap,s.lineJoin,s.miterLimit,oi,hi]);const o=t.getEnds(),h=t.getOrientedFlatCoordinates(),l=t.getStride();this.drawFlatCoordinatess_(h,0,o,l),this.endGeometry(e)}drawMultiPolygon(t,e,n){const s=this.state,r=s.fillStyle,a=s.strokeStyle;if(r===void 0&&a===void 0)return;this.setFillStrokeStyles_(),this.beginGeometry(t,e,n),s.fillStyle!==void 0&&this.hitDetectionInstructions.push([Z.SET_FILL_STYLE,le]),s.strokeStyle!==void 0&&this.hitDetectionInstructions.push([Z.SET_STROKE_STYLE,s.strokeStyle,s.lineWidth,s.lineCap,s.lineJoin,s.miterLimit,oi,hi]);const o=t.getEndss(),h=t.getOrientedFlatCoordinates(),l=t.getStride();let c=0;for(let u=0,d=o.length;u<d;++u)c=this.drawFlatCoordinatess_(h,c,o[u],l);this.endGeometry(e)}finish(){this.reverseHitDetectionInstructions(),this.state=null;const t=this.tolerance;if(t!==0){const e=this.coordinates;for(let n=0,s=e.length;n<s;++n)e[n]=zi(e[n],t)}return super.finish()}setFillStrokeStyles_(){const t=this.state;this.updateFillStyle(t,this.createFill),this.updateStrokeStyle(t,this.applyStroke)}}function Bg(i,t,e,n,s){const r=[];let a=e,o=0,h=t.slice(e,2);for(;o<i&&a+s<n;){const[l,c]=h.slice(-2),u=t[a+s],d=t[a+s+1],f=Math.sqrt((u-l)*(u-l)+(d-c)*(d-c));if(o+=f,o>=i){const g=(i-o+f)/f,_=Se(l,u,g),m=Se(c,d,g);h.push(_,m),r.push(h),h=[_,m],o==i&&(a+=s),o=0}else if(o<i)h.push(t[a+s],t[a+s+1]),a+=s;else{const g=f-o,_=Se(l,u,g/f),m=Se(c,d,g/f);h.push(_,m),r.push(h),h=[_,m],o=0,a+=s}}return o>0&&r.push(h),r}function Xg(i,t,e,n,s){let r=e,a=e,o=0,h=0,l=e,c,u,d,f,g,_,m,y,p,x;for(u=e;u<n;u+=s){const v=t[u],M=t[u+1];g!==void 0&&(p=v-g,x=M-_,f=Math.sqrt(p*p+x*x),m!==void 0&&(h+=d,c=Math.acos((m*p+y*x)/(d*f)),c>i&&(h>o&&(o=h,r=l,a=u),h=0,l=u-s)),d=f,m=p,y=x),g=v,_=M}return h+=f,h>o?[l,u]:[r,a]}const Or={left:0,center:.5,right:1,top:0,middle:.5,hanging:.2,alphabetic:.8,ideographic:.8,bottom:1};class qg extends Zs{constructor(t,e,n,s){super(t,e,n,s),this.labels_=null,this.text_="",this.textOffsetX_=0,this.textOffsetY_=0,this.textRotateWithView_=void 0,this.textKeepUpright_=void 0,this.textRotation_=0,this.textFillState_=null,this.fillStates={},this.fillStates[le]={fillStyle:le},this.textStrokeState_=null,this.strokeStates={},this.textState_={},this.textStates={},this.textKey_="",this.fillKey_="",this.strokeKey_="",this.declutterMode_=void 0,this.declutterImageWithText_=void 0}finish(){const t=super.finish();return t.textStates=this.textStates,t.fillStates=this.fillStates,t.strokeStates=this.strokeStates,t}drawText(t,e,n){const s=this.textFillState_,r=this.textStrokeState_,a=this.textState_;if(this.text_===""||!a||!s&&!r)return;const o=this.coordinates;let h=o.length;const l=t.getType();let c=null,u=t.getStride();if(a.placement==="line"&&(l=="LineString"||l=="MultiLineString"||l=="Polygon"||l=="MultiPolygon")){if(!ie(this.maxExtent,t.getExtent()))return;let d;if(c=t.getFlatCoordinates(),l=="LineString")d=[c.length];else if(l=="MultiLineString")d=t.getEnds();else if(l=="Polygon")d=t.getEnds().slice(0,1);else if(l=="MultiPolygon"){const m=t.getEndss();d=[];for(let y=0,p=m.length;y<p;++y)d.push(m[y][0])}this.beginGeometry(t,e,n);const f=a.repeat,g=f?void 0:a.textAlign;let _=0;for(let m=0,y=d.length;m<y;++m){let p;f?p=Bg(f*this.resolution,c,_,d[m],u):p=[c.slice(_,d[m])];for(let x=0,v=p.length;x<v;++x){const M=p[x];let C=0,P=M.length;if(g==null){const L=Xg(a.maxAngle,M,0,M.length,2);C=L[0],P=L[1]}for(let L=C;L<P;L+=u)o.push(M[L],M[L+1]);const b=o.length;_=d[m],this.drawChars_(h,b),h=b}}this.endGeometry(e)}else{let d=a.overflow?null:[];switch(l){case"Point":case"MultiPoint":c=t.getFlatCoordinates();break;case"LineString":c=t.getFlatMidpoint();break;case"Circle":c=t.getCenter();break;case"MultiLineString":c=t.getFlatMidpoints(),u=2;break;case"Polygon":c=t.getFlatInteriorPoint(),a.overflow||d.push(c[2]/this.resolution),u=3;break;case"MultiPolygon":const v=t.getFlatInteriorPoints();c=[];for(let M=0,C=v.length;M<C;M+=3)a.overflow||d.push(v[M+2]/this.resolution),c.push(v[M],v[M+1]);if(c.length===0)return;u=2;break}const f=this.appendFlatPointCoordinates(c,u);if(f===h)return;if(d&&(f-h)/2!==c.length/u){let v=h/2;d=d.filter((M,C)=>{const P=o[(v+C)*2]===c[C*u]&&o[(v+C)*2+1]===c[C*u+1];return P||--v,P})}this.saveTextStates_();const g=a.backgroundFill?this.createFill(this.fillStyleToState(a.backgroundFill)):null,_=a.backgroundStroke?this.createStroke(this.strokeStyleToState(a.backgroundStroke)):null;this.beginGeometry(t,e,n);let m=a.padding;if(m!=qi&&(a.scale[0]<0||a.scale[1]<0)){let v=a.padding[0],M=a.padding[1],C=a.padding[2],P=a.padding[3];a.scale[0]<0&&(M=-M,P=-P),a.scale[1]<0&&(v=-v,C=-C),m=[v,M,C,P]}const y=this.pixelRatio;this.instructions.push([Z.DRAW_IMAGE,h,f,null,NaN,NaN,NaN,1,0,0,this.textRotateWithView_,this.textRotation_,[1,1],NaN,this.declutterMode_,this.declutterImageWithText_,m==qi?qi:m.map(function(v){return v*y}),g,_,this.text_,this.textKey_,this.strokeKey_,this.fillKey_,this.textOffsetX_,this.textOffsetY_,d]);const p=1/y,x=g?g.slice(0):null;x&&(x[1]=le),this.hitDetectionInstructions.push([Z.DRAW_IMAGE,h,f,null,NaN,NaN,NaN,1,0,0,this.textRotateWithView_,this.textRotation_,[p,p],NaN,this.declutterMode_,this.declutterImageWithText_,m,x,_,this.text_,this.textKey_,this.strokeKey_,this.fillKey_?le:this.fillKey_,this.textOffsetX_,this.textOffsetY_,d]),this.endGeometry(e)}}saveTextStates_(){const t=this.textStrokeState_,e=this.textState_,n=this.textFillState_,s=this.strokeKey_;t&&(s in this.strokeStates||(this.strokeStates[s]={strokeStyle:t.strokeStyle,lineCap:t.lineCap,lineDashOffset:t.lineDashOffset,lineWidth:t.lineWidth,lineJoin:t.lineJoin,miterLimit:t.miterLimit,lineDash:t.lineDash}));const r=this.textKey_;r in this.textStates||(this.textStates[r]={font:e.font,textAlign:e.textAlign||Is,justify:e.justify,textBaseline:e.textBaseline||Pr,scale:e.scale});const a=this.fillKey_;n&&(a in this.fillStates||(this.fillStates[a]={fillStyle:n.fillStyle}))}drawChars_(t,e){const n=this.textStrokeState_,s=this.textState_,r=this.strokeKey_,a=this.textKey_,o=this.fillKey_;this.saveTextStates_();const h=this.pixelRatio,l=Or[s.textBaseline],c=this.textOffsetY_*h,u=this.text_,d=n?n.lineWidth*Math.abs(s.scale[0])/2:0;this.instructions.push([Z.DRAW_CHARS,t,e,l,s.overflow,o,s.maxAngle,h,c,r,d*h,u,a,1,this.declutterMode_,this.textKeepUpright_]),this.hitDetectionInstructions.push([Z.DRAW_CHARS,t,e,l,s.overflow,o&&le,s.maxAngle,h,c,r,d*h,u,a,1/h,this.declutterMode_,this.textKeepUpright_])}setTextStyle(t,e){let n,s,r;if(!t)this.text_="";else{const a=t.getFill();a?(s=this.textFillState_,s||(s={},this.textFillState_=s),s.fillStyle=je(a.getColor()||le)):(s=null,this.textFillState_=s);const o=t.getStroke();if(!o)r=null,this.textStrokeState_=r;else{r=this.textStrokeState_,r||(r={},this.textStrokeState_=r);const _=o.getLineDash(),m=o.getLineDashOffset(),y=o.getWidth(),p=o.getMiterLimit();r.lineCap=o.getLineCap()||zn,r.lineDash=_?_.slice():oi,r.lineDashOffset=m===void 0?hi:m,r.lineJoin=o.getLineJoin()||Un,r.lineWidth=y===void 0?Rs:y,r.miterLimit=p===void 0?Ss:p,r.strokeStyle=je(o.getColor()||Cs)}n=this.textState_;const h=t.getFont()||Vc;cg(h);const l=t.getScaleArray();n.overflow=t.getOverflow(),n.font=h,n.maxAngle=t.getMaxAngle(),n.placement=t.getPlacement(),n.textAlign=t.getTextAlign(),n.repeat=t.getRepeat(),n.justify=t.getJustify(),n.textBaseline=t.getTextBaseline()||Pr,n.backgroundFill=t.getBackgroundFill(),n.backgroundStroke=t.getBackgroundStroke(),n.padding=t.getPadding()||qi,n.scale=l===void 0?[1,1]:l;const c=t.getOffsetX(),u=t.getOffsetY(),d=t.getRotateWithView(),f=t.getKeepUpright(),g=t.getRotation();this.text_=t.getText()||"",this.textOffsetX_=c===void 0?0:c,this.textOffsetY_=u===void 0?0:u,this.textRotateWithView_=d===void 0?!1:d,this.textKeepUpright_=f===void 0?!0:f,this.textRotation_=g===void 0?0:g,this.strokeKey_=r?(typeof r.strokeStyle=="string"?r.strokeStyle:_t(r.strokeStyle))+r.lineCap+r.lineDashOffset+"|"+r.lineWidth+r.lineJoin+r.miterLimit+"["+r.lineDash.join()+"]":"",this.textKey_=n.font+n.scale+(n.textAlign||"?")+(n.repeat||"?")+(n.justify||"?")+(n.textBaseline||"?"),this.fillKey_=s&&s.fillStyle?typeof s.fillStyle=="string"?s.fillStyle:"|"+_t(s.fillStyle):""}this.declutterMode_=t.getDeclutterMode(),this.declutterImageWithText_=e}}const jg={Circle:al,Default:Zs,Image:Ug,LineString:Wg,Polygon:al,Text:qg};class Yg{constructor(t,e,n,s){this.tolerance_=t,this.maxExtent_=e,this.pixelRatio_=s,this.resolution_=n,this.buildersByZIndex_={}}finish(){const t={};for(const e in this.buildersByZIndex_){t[e]=t[e]||{};const n=this.buildersByZIndex_[e];for(const s in n){const r=n[s].finish();t[e][s]=r}}return t}getBuilder(t,e){const n=t!==void 0?t.toString():"0";let s=this.buildersByZIndex_[n];s===void 0&&(s={},this.buildersByZIndex_[n]=s);let r=s[e];if(r===void 0){const a=jg[e];r=new a(this.tolerance_,this.maxExtent_,this.resolution_,this.pixelRatio_),s[e]=r}return r}}function Kg(i,t,e,n,s,r,a,o,h,l,c,u,d=!0){let f=i[t],g=i[t+1],_=0,m=0,y=0,p=0;function x(){_=f,m=g,t+=n,f=i[t],g=i[t+1],p+=y,y=Math.sqrt((f-_)*(f-_)+(g-m)*(g-m))}do x();while(t<e-n&&p+y<r);let v=y===0?0:(r-p)/y;const M=Se(_,f,v),C=Se(m,g,v),P=t-n,b=p,L=r+o*h(l,s,c);for(;t<e-n&&p+y<L;)x();v=y===0?0:(L-p)/y;const N=Se(_,f,v),B=Se(m,g,v);let U=!1;if(d)if(u){const W=[M,C,N,B];vc(W,0,4,2,u,W,W),U=W[0]>W[2]}else U=M>N;const z=Math.PI,Q=[],X=P+n===t;t=P,y=0,p=b,f=i[t],g=i[t+1];let H;if(X){x(),H=Math.atan2(g-m,f-_),U&&(H+=H>0?-z:z);const W=(N+M)/2,w=(B+C)/2;return Q[0]=[W,w,(L-r)/2,H,s],Q}s=s.replace(/\n/g," ");for(let W=0,w=s.length;W<w;){x();let S=Math.atan2(g-m,f-_);if(U&&(S+=S>0?-z:z),H!==void 0){let K=S-H;if(K+=K>z?-2*z:K<-z?2*z:0,Math.abs(K)>a)return null}H=S;const R=W;let T=0;for(;W<w;++W){const K=U?w-W-1:W,at=o*h(l,s[K],c);if(t+n<e&&p+y<r+T+at/2)break;T+=at}if(W===R)continue;const E=U?s.substring(w-R,w-W):s.substring(R,W);v=y===0?0:(r+T/2-p)/y;const I=Se(_,f,v),D=Se(m,g,v);Q.push([I,D,T/2,S,E]),r+=T}return Q}class ou{constructor(){this.instructions_=[],this.zIndex=0,this.offset_=0,this.context_=new Proxy(Mr(),{get:(t,e)=>{if(typeof Mr()[e]=="function")return this.push_(e),this.pushMethodArgs_},set:(t,e,n)=>(this.push_(e,n),!0)})}push_(...t){const e=this.instructions_,n=this.zIndex+this.offset_;e[n]||(e[n]=[]),e[n].push(...t)}pushMethodArgs_=(...t)=>(this.push_(t),this);pushFunction(t){this.push_(t)}getContext(){return this.context_}draw(t){this.instructions_.forEach(e=>{for(let n=0,s=e.length;n<s;++n){const r=e[n];if(typeof r=="function"){r(t);continue}const a=e[++n];if(typeof t[r]=="function")t[r](...a);else{if(typeof a=="function"){t[r]=a(t);continue}t[r]=a}}})}clear(){this.instructions_.length=0,this.zIndex=0,this.offset_=0}offset(){this.offset_=this.instructions_.length,this.zIndex=0}}const un=fe(),gi=[],ii=[],ni=[],_i=[];function ol(i){return i[3].declutterBox}const hl=new RegExp("[֑-ࣿיִ-﷿ﹰ-ﻼࠀ-࿿-]");function Ta(i,t){return t==="start"?t=hl.test(i)?"right":"left":t==="end"&&(t=hl.test(i)?"left":"right"),Or[t]}function Vg(i,t,e){return e>0&&i.push(`
`,""),i.push(t,""),i}function Zg(i,t,e){return e%2===0&&(i+=t),i}class $g{constructor(t,e,n,s,r){this.overlaps=n,this.pixelRatio=e,this.resolution=t,this.alignAndScaleFill_,this.instructions=s.instructions,this.coordinates=s.coordinates,this.coordinateCache_={},this.renderedTransform_=ke(),this.hitDetectionInstructions=s.hitDetectionInstructions,this.pixelCoordinates_=null,this.viewRotation_=0,this.fillStates=s.fillStates||{},this.strokeStates=s.strokeStates||{},this.textStates=s.textStates||{},this.widths_={},this.labels_={},this.zIndexContext_=r?new ou:null}getZIndexContext(){return this.zIndexContext_}createLabel(t,e,n,s){const r=t+e+n+s;if(this.labels_[r])return this.labels_[r];const a=s?this.strokeStates[s]:null,o=n?this.fillStates[n]:null,h=this.textStates[e],l=this.pixelRatio,c=[h.scale[0]*l,h.scale[1]*l],u=h.justify?Or[h.justify]:Ta(Array.isArray(t)?t[0]:t,h.textAlign||Is),d=s&&a.lineWidth?a.lineWidth:0,f=Array.isArray(t)?t:String(t).split(`
`).reduce(Vg,[]),{width:g,height:_,widths:m,heights:y,lineWidths:p}=dg(h,f),x=g+d,v=[],M=(x+2)*c[0],C=(_+d)*c[1],P={width:M<0?Math.floor(M):Math.ceil(M),height:C<0?Math.floor(C):Math.ceil(C),contextInstructions:v};(c[0]!=1||c[1]!=1)&&v.push("scale",c),s&&(v.push("strokeStyle",a.strokeStyle),v.push("lineWidth",d),v.push("lineCap",a.lineCap),v.push("lineJoin",a.lineJoin),v.push("miterLimit",a.miterLimit),v.push("setLineDash",[a.lineDash]),v.push("lineDashOffset",a.lineDashOffset)),n&&v.push("fillStyle",o.fillStyle),v.push("textBaseline","middle"),v.push("textAlign","center");const b=.5-u;let L=u*x+b*d;const N=[],B=[];let U=0,z=0,Q=0,X=0,H;for(let W=0,w=f.length;W<w;W+=2){const S=f[W];if(S===`
`){z+=U,U=0,L=u*x+b*d,++X;continue}const R=f[W+1]||h.font;R!==H&&(s&&N.push("font",R),n&&B.push("font",R),H=R),U=Math.max(U,y[Q]);const T=[S,L+b*m[Q]+u*(m[Q]-p[X]),.5*(d+U)+z];L+=m[Q],s&&N.push("strokeText",T),n&&B.push("fillText",T),++Q}return Array.prototype.push.apply(v,N),Array.prototype.push.apply(v,B),this.labels_[r]=P,P}replayTextBackground_(t,e,n,s,r,a,o){t.beginPath(),t.moveTo.apply(t,e),t.lineTo.apply(t,n),t.lineTo.apply(t,s),t.lineTo.apply(t,r),t.lineTo.apply(t,e),a&&(this.alignAndScaleFill_=a[2],t.fillStyle=a[1],this.fill_(t)),o&&(this.setStrokeStyle_(t,o),t.stroke())}calculateImageOrLabelDimensions_(t,e,n,s,r,a,o,h,l,c,u,d,f,g,_,m){o*=d[0],h*=d[1];let y=n-o,p=s-h;const x=r+l>t?t-l:r,v=a+c>e?e-c:a,M=g[3]+x*d[0]+g[1],C=g[0]+v*d[1]+g[2],P=y-g[3],b=p-g[0];(_||u!==0)&&(gi[0]=P,_i[0]=P,gi[1]=b,ii[1]=b,ii[0]=P+M,ni[0]=ii[0],ni[1]=b+C,_i[1]=ni[1]);let L;return u!==0?(L=Ze(ke(),n,s,1,1,u,-n,-s),Ut(L,gi),Ut(L,ii),Ut(L,ni),Ut(L,_i),li(Math.min(gi[0],ii[0],ni[0],_i[0]),Math.min(gi[1],ii[1],ni[1],_i[1]),Math.max(gi[0],ii[0],ni[0],_i[0]),Math.max(gi[1],ii[1],ni[1],_i[1]),un)):li(Math.min(P,P+M),Math.min(b,b+C),Math.max(P,P+M),Math.max(b,b+C),un),f&&(y=Math.round(y),p=Math.round(p)),{drawImageX:y,drawImageY:p,drawImageW:x,drawImageH:v,originX:l,originY:c,declutterBox:{minX:un[0],minY:un[1],maxX:un[2],maxY:un[3],value:m},canvasTransform:L,scale:d}}replayImageOrLabel_(t,e,n,s,r,a,o){const h=!!(a||o),l=s.declutterBox,c=o?o[2]*s.scale[0]/2:0;return l.minX-c<=e[0]&&l.maxX+c>=0&&l.minY-c<=e[1]&&l.maxY+c>=0&&(h&&this.replayTextBackground_(t,gi,ii,ni,_i,a,o),fg(t,s.canvasTransform,r,n,s.originX,s.originY,s.drawImageW,s.drawImageH,s.drawImageX,s.drawImageY,s.scale)),!0}fill_(t){const e=this.alignAndScaleFill_;if(e){const n=Ut(this.renderedTransform_,[0,0]),s=512*this.pixelRatio;t.save(),t.translate(n[0]%s,n[1]%s),e!==1&&t.scale(e,e),t.rotate(this.viewRotation_)}t.fill(),e&&t.restore()}setStrokeStyle_(t,e){t.strokeStyle=e[1],e[1]&&(t.lineWidth=e[2],t.lineCap=e[3],t.lineJoin=e[4],t.miterLimit=e[5],t.lineDashOffset=e[7],t.setLineDash(e[6]))}drawLabelWithPointPlacement_(t,e,n,s){const r=this.textStates[e],a=this.createLabel(t,e,s,n),o=this.strokeStates[n],h=this.pixelRatio,l=Ta(Array.isArray(t)?t[0]:t,r.textAlign||Is),c=Or[r.textBaseline||Pr],u=o&&o.lineWidth?o.lineWidth:0,d=a.width/h-2*r.scale[0],f=l*d+2*(.5-l)*u,g=c*a.height/h+2*(.5-c)*u;return{label:a,anchorX:f,anchorY:g}}execute_(t,e,n,s,r,a,o,h){const l=this.zIndexContext_;let c;this.pixelCoordinates_&&Li(n,this.renderedTransform_)?c=this.pixelCoordinates_:(this.pixelCoordinates_||(this.pixelCoordinates_=[]),c=Ri(this.coordinates,0,this.coordinates.length,2,n,this.pixelCoordinates_),mf(this.renderedTransform_,n));let u=0;const d=s.length;let f=0,g,_,m,y,p,x,v,M,C,P,b,L,N,B=0,U=0;const z=this.coordinateCache_,Q=this.viewRotation_,X=Math.round(Math.atan2(-n[1],n[0])*1e12)/1e12,H={context:t,pixelRatio:this.pixelRatio,resolution:this.resolution,rotation:Q},W=this.instructions!=s||this.overlaps?0:200;let w,S,R,T;for(;u<d;){const E=s[u];switch(E[0]){case Z.BEGIN_GEOMETRY:w=E[1],T=E[3],w.getGeometry()?o!==void 0&&!ie(o,T.getExtent())?u=E[2]+1:++u:u=E[2],l&&(l.zIndex=E[4]);break;case Z.BEGIN_PATH:B>W&&(this.fill_(t),B=0),U>W&&(t.stroke(),U=0),!B&&!U&&(t.beginPath(),p=NaN,x=NaN),++u;break;case Z.CIRCLE:f=E[1];const D=c[f],K=c[f+1],at=c[f+2],Y=c[f+3],ot=at-D,q=Y-K,J=Math.sqrt(ot*ot+q*q);t.moveTo(D+J,K),t.arc(D,K,J,0,2*Math.PI,!0),++u;break;case Z.CLOSE_PATH:t.closePath(),++u;break;case Z.CUSTOM:f=E[1],g=E[2];const lt=E[3],O=E[4],nt=E[5];H.geometry=lt,H.feature=w,u in z||(z[u]=[]);const ht=z[u];nt?nt(c,f,g,2,ht):(ht[0]=c[f],ht[1]=c[f+1],ht.length=2),l&&(l.zIndex=E[6]),O(ht,H),++u;break;case Z.DRAW_IMAGE:f=E[1],g=E[2],C=E[3],_=E[4],m=E[5];let ct=E[6];const ut=E[7],pt=E[8],xt=E[9],It=E[10];let Rt=E[11];const st=E[12];let it=E[13];y=E[14]||"declutter";const V=E[15];if(!C&&E.length>=20){P=E[19],b=E[20],L=E[21],N=E[22];const kt=this.drawLabelWithPointPlacement_(P,b,L,N);C=kt.label,E[3]=C;const Le=E[23];_=(kt.anchorX-Le)*this.pixelRatio,E[4]=_;const Kt=E[24];m=(kt.anchorY-Kt)*this.pixelRatio,E[5]=m,ct=C.height,E[6]=ct,it=C.width,E[13]=it}let At;E.length>25&&(At=E[25]);let Ot,me,ye;E.length>17?(Ot=E[16],me=E[17],ye=E[18]):(Ot=qi,me=null,ye=null),It&&X?Rt+=Q:!It&&!X&&(Rt-=Q);let Oi=0;for(;f<g;f+=2){if(At&&At[Oi++]<it/this.pixelRatio)continue;const kt=this.calculateImageOrLabelDimensions_(C.width,C.height,c[f],c[f+1],it,ct,_,m,pt,xt,Rt,st,r,Ot,!!me||!!ye,w),Le=[t,e,C,kt,ut,me,ye];if(h){let Kt,re,Ht;if(V){const Tt=g-f;if(!V[Tt]){V[Tt]={args:Le,declutterMode:y};continue}const Ft=V[Tt];Kt=Ft.args,re=Ft.declutterMode,delete V[Tt],Ht=ol(Kt)}let Ee,xe;if(Kt&&(re!=="declutter"||!h.collides(Ht))&&(Ee=!0),(y!=="declutter"||!h.collides(kt.declutterBox))&&(xe=!0),re==="declutter"&&y==="declutter"){const Tt=Ee&&xe;Ee=Tt,xe=Tt}Ee&&(re!=="none"&&h.insert(Ht),this.replayImageOrLabel_.apply(this,Kt)),xe&&(y!=="none"&&h.insert(kt.declutterBox),this.replayImageOrLabel_.apply(this,Le))}else this.replayImageOrLabel_.apply(this,Le)}++u;break;case Z.DRAW_CHARS:const pe=E[1],dt=E[2],Xt=E[3],qt=E[4];N=E[5];const Zt=E[6],$t=E[7],Di=E[8];L=E[9];const di=E[10];P=E[11],Array.isArray(P)&&(P=P.reduce(Zg,"")),b=E[12];const Qe=[E[13],E[13]];y=E[14]||"declutter";const ti=E[15],ei=this.textStates[b],Te=ei.font,be=[ei.scale[0]*$t,ei.scale[1]*$t];let Pe;Te in this.widths_?Pe=this.widths_[Te]:(Pe={},this.widths_[Te]=Pe);const Ni=kg(c,pe,dt,2),rn=Math.abs(be[0])*$h(Te,P,Pe);if(qt||rn<=Ni){const kt=this.textStates[b].textAlign,Le=(Ni-rn)*Ta(P,kt),Kt=Kg(c,pe,dt,2,P,Le,Zt,Math.abs(be[0]),$h,Te,Pe,X?0:this.viewRotation_,ti);t:if(Kt){const re=[];let Ht,Ee,xe,Tt,Ft;if(L)for(Ht=0,Ee=Kt.length;Ht<Ee;++Ht){Ft=Kt[Ht],xe=Ft[4],Tt=this.createLabel(xe,b,"",L),_=Ft[2]+(be[0]<0?-di:di),m=Xt*Tt.height+(.5-Xt)*2*di*be[1]/be[0]-Di;const ve=this.calculateImageOrLabelDimensions_(Tt.width,Tt.height,Ft[0],Ft[1],Tt.width,Tt.height,_,m,0,0,Ft[3],Qe,!1,qi,!1,w);if(h&&y==="declutter"&&h.collides(ve.declutterBox))break t;re.push([t,e,Tt,ve,1,null,null])}if(N)for(Ht=0,Ee=Kt.length;Ht<Ee;++Ht){Ft=Kt[Ht],xe=Ft[4],Tt=this.createLabel(xe,b,N,""),_=Ft[2],m=Xt*Tt.height-Di;const ve=this.calculateImageOrLabelDimensions_(Tt.width,Tt.height,Ft[0],Ft[1],Tt.width,Tt.height,_,m,0,0,Ft[3],Qe,!1,qi,!1,w);if(h&&y==="declutter"&&h.collides(ve.declutterBox))break t;re.push([t,e,Tt,ve,1,null,null])}h&&y!=="none"&&h.load(re.map(ol));for(let ve=0,an=re.length;ve<an;++ve)this.replayImageOrLabel_.apply(this,re[ve])}}++u;break;case Z.END_GEOMETRY:if(a!==void 0){w=E[1];const kt=a(w,T,y);if(kt)return kt}++u;break;case Z.FILL:W?B++:this.fill_(t),++u;break;case Z.MOVE_TO_LINE_TO:for(f=E[1],g=E[2],S=c[f],R=c[f+1],t.moveTo(S,R),p=S+.5|0,x=R+.5|0,f+=2;f<g;f+=2)S=c[f],R=c[f+1],v=S+.5|0,M=R+.5|0,(f==g-2||v!==p||M!==x)&&(t.lineTo(S,R),p=v,x=M);++u;break;case Z.SET_FILL_STYLE:this.alignAndScaleFill_=E[2],B&&(this.fill_(t),B=0,U&&(t.stroke(),U=0)),t.fillStyle=E[1],++u;break;case Z.SET_STROKE_STYLE:U&&(t.stroke(),U=0),this.setStrokeStyle_(t,E),++u;break;case Z.STROKE:W?U++:t.stroke(),++u;break;default:++u;break}}B&&this.fill_(t),U&&t.stroke()}execute(t,e,n,s,r,a){this.viewRotation_=s,this.execute_(t,e,n,this.instructions,r,void 0,void 0,a)}executeHitDetection(t,e,n,s,r){return this.viewRotation_=n,this.execute_(t,[t.canvas.width,t.canvas.height],e,this.hitDetectionInstructions,!0,s,r)}}const Wi=["Polygon","Circle","LineString","Image","Text","Default"],hu=["Image","Text"],Hg=Wi.filter(i=>!hu.includes(i));class Jg{constructor(t,e,n,s,r,a,o){this.maxExtent_=t,this.overlaps_=s,this.pixelRatio_=n,this.resolution_=e,this.renderBuffer_=a,this.executorsByZIndex_={},this.hitDetectionContext_=null,this.hitDetectionTransform_=ke(),this.renderedContext_=null,this.deferredZIndexContexts_={},this.createExecutors_(r,o)}clip(t,e){const n=this.getClipCoords(e);t.beginPath(),t.moveTo(n[0],n[1]),t.lineTo(n[2],n[3]),t.lineTo(n[4],n[5]),t.lineTo(n[6],n[7]),t.clip()}createExecutors_(t,e){for(const n in t){let s=this.executorsByZIndex_[n];s===void 0&&(s={},this.executorsByZIndex_[n]=s);const r=t[n];for(const a in r){const o=r[a];s[a]=new $g(this.resolution_,this.pixelRatio_,this.overlaps_,o,e)}}}hasExecutors(t){for(const e in this.executorsByZIndex_){const n=this.executorsByZIndex_[e];for(let s=0,r=t.length;s<r;++s)if(t[s]in n)return!0}return!1}forEachFeatureAtCoordinate(t,e,n,s,r,a){s=Math.round(s);const o=s*2+1,h=Ze(this.hitDetectionTransform_,s+.5,s+.5,1/e,-1/e,-n,-t[0],-t[1]),l=!this.hitDetectionContext_;l&&(this.hitDetectionContext_=Bt(o,o));const c=this.hitDetectionContext_;c.canvas.width!==o||c.canvas.height!==o?(c.canvas.width=o,c.canvas.height=o):l||c.clearRect(0,0,o,o);let u;this.renderBuffer_!==void 0&&(u=fe(),us(u,t),On(u,e*(this.renderBuffer_+s),u));const d=Qg(s);let f;function g(M,C,P){const b=c.getImageData(0,0,o,o).data;for(let L=0,N=d.length;L<N;L++)if(b[d[L]]>0){if(!a||P==="none"||f!=="Image"&&f!=="Text"||a.includes(M)){const B=(d[L]-3)/4,U=s-B%o,z=s-(B/o|0),Q=r(M,C,U*U+z*z);if(Q)return Q}c.clearRect(0,0,o,o);break}}const _=Object.keys(this.executorsByZIndex_).map(Number);_.sort(ri);let m,y,p,x,v;for(m=_.length-1;m>=0;--m){const M=_[m].toString();for(p=this.executorsByZIndex_[M],y=Wi.length-1;y>=0;--y)if(f=Wi[y],x=p[f],x!==void 0&&(v=x.executeHitDetection(c,h,n,g,u),v))return v}}getClipCoords(t){const e=this.maxExtent_;if(!e)return null;const n=e[0],s=e[1],r=e[2],a=e[3],o=[n,s,n,a,r,a,r,s];return Ri(o,0,8,2,t,o),o}isEmpty(){return Gn(this.executorsByZIndex_)}execute(t,e,n,s,r,a,o){const h=Object.keys(this.executorsByZIndex_).map(Number);h.sort(o?dd:ri),a=a||Wi;const l=Wi.length;for(let c=0,u=h.length;c<u;++c){const d=h[c].toString(),f=this.executorsByZIndex_[d];for(let g=0,_=a.length;g<_;++g){const m=a[g],y=f[m];if(y!==void 0){const p=o===null?void 0:y.getZIndexContext(),x=p?p.getContext():t,v=this.maxExtent_&&m!=="Image"&&m!=="Text";if(v&&(x.save(),this.clip(x,n)),!p||m==="Text"||m==="Image"?y.execute(x,e,n,s,r,o):p.pushFunction(M=>y.execute(M,e,n,s,r,o)),v&&x.restore(),p){p.offset();const M=h[c]*l+Wi.indexOf(m);this.deferredZIndexContexts_[M]||(this.deferredZIndexContexts_[M]=[]),this.deferredZIndexContexts_[M].push(p)}}}}this.renderedContext_=t}getDeferredZIndexContexts(){return this.deferredZIndexContexts_}getRenderedContext(){return this.renderedContext_}renderDeferred(){const t=this.deferredZIndexContexts_,e=Object.keys(t).map(Number).sort(ri);for(let n=0,s=e.length;n<s;++n)t[e[n]].forEach(r=>{r.draw(this.renderedContext_),r.clear()}),t[e[n]].length=0}}const ba={};function Qg(i){if(ba[i]!==void 0)return ba[i];const t=i*2+1,e=i*i,n=new Array(e+1);for(let r=0;r<=i;++r)for(let a=0;a<=i;++a){const o=r*r+a*a;if(o>e)break;let h=n[o];h||(h=[],n[o]=h),h.push(((i+r)*t+(i+a))*4+3),r>0&&h.push(((i-r)*t+(i+a))*4+3),a>0&&(h.push(((i+r)*t+(i-a))*4+3),r>0&&h.push(((i-r)*t+(i-a))*4+3))}const s=[];for(let r=0,a=n.length;r<a;++r)n[r]&&s.push(...n[r]);return ba[i]=s,s}class t_ extends au{constructor(t,e,n,s,r,a,o){super(),this.context_=t,this.pixelRatio_=e,this.extent_=n,this.transform_=s,this.transformRotation_=s?Us(Math.atan2(s[1],s[0]),10):0,this.viewRotation_=r,this.squaredTolerance_=a,this.userTransform_=o,this.contextFillState_=null,this.contextStrokeState_=null,this.contextTextState_=null,this.fillState_=null,this.strokeState_=null,this.image_=null,this.imageAnchorX_=0,this.imageAnchorY_=0,this.imageHeight_=0,this.imageOpacity_=0,this.imageOriginX_=0,this.imageOriginY_=0,this.imageRotateWithView_=!1,this.imageRotation_=0,this.imageScale_=[0,0],this.imageWidth_=0,this.text_="",this.textOffsetX_=0,this.textOffsetY_=0,this.textRotateWithView_=!1,this.textRotation_=0,this.textScale_=[0,0],this.textFillState_=null,this.textStrokeState_=null,this.textState_=null,this.pixelCoordinates_=[],this.tmpLocalTransform_=ke()}drawImages_(t,e,n,s){if(!this.image_)return;const r=Ri(t,e,n,s,this.transform_,this.pixelCoordinates_),a=this.context_,o=this.tmpLocalTransform_,h=a.globalAlpha;this.imageOpacity_!=1&&(a.globalAlpha=h*this.imageOpacity_);let l=this.imageRotation_;this.transformRotation_===0&&(l-=this.viewRotation_),this.imageRotateWithView_&&(l+=this.viewRotation_);for(let c=0,u=r.length;c<u;c+=2){const d=r[c]-this.imageAnchorX_,f=r[c+1]-this.imageAnchorY_;if(l!==0||this.imageScale_[0]!=1||this.imageScale_[1]!=1){const g=d+this.imageAnchorX_,_=f+this.imageAnchorY_;Ze(o,g,_,1,1,l,-g,-_),a.save(),a.transform.apply(a,o),a.translate(g,_),a.scale(this.imageScale_[0],this.imageScale_[1]),a.drawImage(this.image_,this.imageOriginX_,this.imageOriginY_,this.imageWidth_,this.imageHeight_,-this.imageAnchorX_,-this.imageAnchorY_,this.imageWidth_,this.imageHeight_),a.restore()}else a.drawImage(this.image_,this.imageOriginX_,this.imageOriginY_,this.imageWidth_,this.imageHeight_,d,f,this.imageWidth_,this.imageHeight_)}this.imageOpacity_!=1&&(a.globalAlpha=h)}drawText_(t,e,n,s){if(!this.textState_||this.text_==="")return;this.textFillState_&&this.setContextFillState_(this.textFillState_),this.textStrokeState_&&this.setContextStrokeState_(this.textStrokeState_),this.setContextTextState_(this.textState_);const r=Ri(t,e,n,s,this.transform_,this.pixelCoordinates_),a=this.context_;let o=this.textRotation_;for(this.transformRotation_===0&&(o-=this.viewRotation_),this.textRotateWithView_&&(o+=this.viewRotation_);e<n;e+=s){const h=r[e]+this.textOffsetX_,l=r[e+1]+this.textOffsetY_;o!==0||this.textScale_[0]!=1||this.textScale_[1]!=1?(a.save(),a.translate(h-this.textOffsetX_,l-this.textOffsetY_),a.rotate(o),a.translate(this.textOffsetX_,this.textOffsetY_),a.scale(this.textScale_[0],this.textScale_[1]),this.textStrokeState_&&a.strokeText(this.text_,0,0),this.textFillState_&&a.fillText(this.text_,0,0),a.restore()):(this.textStrokeState_&&a.strokeText(this.text_,h,l),this.textFillState_&&a.fillText(this.text_,h,l))}}moveToLineTo_(t,e,n,s,r){const a=this.context_,o=Ri(t,e,n,s,this.transform_,this.pixelCoordinates_);a.moveTo(o[0],o[1]);let h=o.length;r&&(h-=2);for(let l=2;l<h;l+=2)a.lineTo(o[l],o[l+1]);return r&&a.closePath(),n}drawRings_(t,e,n,s){for(let r=0,a=n.length;r<a;++r)e=this.moveToLineTo_(t,e,n[r],s,!0);return e}drawCircle(t){if(this.squaredTolerance_&&(t=t.simplifyTransformed(this.squaredTolerance_,this.userTransform_)),!!ie(this.extent_,t.getExtent())){if(this.fillState_||this.strokeState_){this.fillState_&&this.setContextFillState_(this.fillState_),this.strokeState_&&this.setContextStrokeState_(this.strokeState_);const e=If(t,this.transform_,this.pixelCoordinates_),n=e[2]-e[0],s=e[3]-e[1],r=Math.sqrt(n*n+s*s),a=this.context_;a.beginPath(),a.arc(e[0],e[1],r,0,2*Math.PI),this.fillState_&&a.fill(),this.strokeState_&&a.stroke()}this.text_!==""&&this.drawText_(t.getCenter(),0,2,2)}}setStyle(t){this.setFillStrokeStyle(t.getFill(),t.getStroke()),this.setImageStyle(t.getImage()),this.setTextStyle(t.getText())}setTransform(t){this.transform_=t}drawGeometry(t){switch(t.getType()){case"Point":this.drawPoint(t);break;case"LineString":this.drawLineString(t);break;case"Polygon":this.drawPolygon(t);break;case"MultiPoint":this.drawMultiPoint(t);break;case"MultiLineString":this.drawMultiLineString(t);break;case"MultiPolygon":this.drawMultiPolygon(t);break;case"GeometryCollection":this.drawGeometryCollection(t);break;case"Circle":this.drawCircle(t);break}}drawFeature(t,e){const n=e.getGeometryFunction()(t);n&&(this.setStyle(e),this.drawGeometry(n))}drawGeometryCollection(t){const e=t.getGeometriesArray();for(let n=0,s=e.length;n<s;++n)this.drawGeometry(e[n])}drawPoint(t){this.squaredTolerance_&&(t=t.simplifyTransformed(this.squaredTolerance_,this.userTransform_));const e=t.getFlatCoordinates(),n=t.getStride();this.image_&&this.drawImages_(e,0,e.length,n),this.text_!==""&&this.drawText_(e,0,e.length,n)}drawMultiPoint(t){this.squaredTolerance_&&(t=t.simplifyTransformed(this.squaredTolerance_,this.userTransform_));const e=t.getFlatCoordinates(),n=t.getStride();this.image_&&this.drawImages_(e,0,e.length,n),this.text_!==""&&this.drawText_(e,0,e.length,n)}drawLineString(t){if(this.squaredTolerance_&&(t=t.simplifyTransformed(this.squaredTolerance_,this.userTransform_)),!!ie(this.extent_,t.getExtent())){if(this.strokeState_){this.setContextStrokeState_(this.strokeState_);const e=this.context_,n=t.getFlatCoordinates();e.beginPath(),this.moveToLineTo_(n,0,n.length,t.getStride(),!1),e.stroke()}if(this.text_!==""){const e=t.getFlatMidpoint();this.drawText_(e,0,2,2)}}}drawMultiLineString(t){this.squaredTolerance_&&(t=t.simplifyTransformed(this.squaredTolerance_,this.userTransform_));const e=t.getExtent();if(ie(this.extent_,e)){if(this.strokeState_){this.setContextStrokeState_(this.strokeState_);const n=this.context_,s=t.getFlatCoordinates();let r=0;const a=t.getEnds(),o=t.getStride();n.beginPath();for(let h=0,l=a.length;h<l;++h)r=this.moveToLineTo_(s,r,a[h],o,!1);n.stroke()}if(this.text_!==""){const n=t.getFlatMidpoints();this.drawText_(n,0,n.length,2)}}}drawPolygon(t){if(this.squaredTolerance_&&(t=t.simplifyTransformed(this.squaredTolerance_,this.userTransform_)),!!ie(this.extent_,t.getExtent())){if(this.strokeState_||this.fillState_){this.fillState_&&this.setContextFillState_(this.fillState_),this.strokeState_&&this.setContextStrokeState_(this.strokeState_);const e=this.context_;e.beginPath(),this.drawRings_(t.getOrientedFlatCoordinates(),0,t.getEnds(),t.getStride()),this.fillState_&&e.fill(),this.strokeState_&&e.stroke()}if(this.text_!==""){const e=t.getFlatInteriorPoint();this.drawText_(e,0,2,2)}}}drawMultiPolygon(t){if(this.squaredTolerance_&&(t=t.simplifyTransformed(this.squaredTolerance_,this.userTransform_)),!!ie(this.extent_,t.getExtent())){if(this.strokeState_||this.fillState_){this.fillState_&&this.setContextFillState_(this.fillState_),this.strokeState_&&this.setContextStrokeState_(this.strokeState_);const e=this.context_,n=t.getOrientedFlatCoordinates();let s=0;const r=t.getEndss(),a=t.getStride();e.beginPath();for(let o=0,h=r.length;o<h;++o){const l=r[o];s=this.drawRings_(n,s,l,a)}this.fillState_&&e.fill(),this.strokeState_&&e.stroke()}if(this.text_!==""){const e=t.getFlatInteriorPoints();this.drawText_(e,0,e.length,2)}}}setContextFillState_(t){const e=this.context_,n=this.contextFillState_;n?n.fillStyle!=t.fillStyle&&(n.fillStyle=t.fillStyle,e.fillStyle=t.fillStyle):(e.fillStyle=t.fillStyle,this.contextFillState_={fillStyle:t.fillStyle})}setContextStrokeState_(t){const e=this.context_,n=this.contextStrokeState_;n?(n.lineCap!=t.lineCap&&(n.lineCap=t.lineCap,e.lineCap=t.lineCap),Li(n.lineDash,t.lineDash)||e.setLineDash(n.lineDash=t.lineDash),n.lineDashOffset!=t.lineDashOffset&&(n.lineDashOffset=t.lineDashOffset,e.lineDashOffset=t.lineDashOffset),n.lineJoin!=t.lineJoin&&(n.lineJoin=t.lineJoin,e.lineJoin=t.lineJoin),n.lineWidth!=t.lineWidth&&(n.lineWidth=t.lineWidth,e.lineWidth=t.lineWidth),n.miterLimit!=t.miterLimit&&(n.miterLimit=t.miterLimit,e.miterLimit=t.miterLimit),n.strokeStyle!=t.strokeStyle&&(n.strokeStyle=t.strokeStyle,e.strokeStyle=t.strokeStyle)):(e.lineCap=t.lineCap,e.setLineDash(t.lineDash),e.lineDashOffset=t.lineDashOffset,e.lineJoin=t.lineJoin,e.lineWidth=t.lineWidth,e.miterLimit=t.miterLimit,e.strokeStyle=t.strokeStyle,this.contextStrokeState_={lineCap:t.lineCap,lineDash:t.lineDash,lineDashOffset:t.lineDashOffset,lineJoin:t.lineJoin,lineWidth:t.lineWidth,miterLimit:t.miterLimit,strokeStyle:t.strokeStyle})}setContextTextState_(t){const e=this.context_,n=this.contextTextState_,s=t.textAlign?t.textAlign:Is;n?(n.font!=t.font&&(n.font=t.font,e.font=t.font),n.textAlign!=s&&(n.textAlign=s,e.textAlign=s),n.textBaseline!=t.textBaseline&&(n.textBaseline=t.textBaseline,e.textBaseline=t.textBaseline)):(e.font=t.font,e.textAlign=s,e.textBaseline=t.textBaseline,this.contextTextState_={font:t.font,textAlign:s,textBaseline:t.textBaseline})}setFillStrokeStyle(t,e){if(!t)this.fillState_=null;else{const n=t.getColor();this.fillState_={fillStyle:je(n||le)}}if(!e)this.strokeState_=null;else{const n=e.getColor(),s=e.getLineCap(),r=e.getLineDash(),a=e.getLineDashOffset(),o=e.getLineJoin(),h=e.getWidth(),l=e.getMiterLimit(),c=r||oi;this.strokeState_={lineCap:s!==void 0?s:zn,lineDash:this.pixelRatio_===1?c:c.map(u=>u*this.pixelRatio_),lineDashOffset:(a||hi)*this.pixelRatio_,lineJoin:o!==void 0?o:Un,lineWidth:(h!==void 0?h:Rs)*this.pixelRatio_,miterLimit:l!==void 0?l:Ss,strokeStyle:je(n||Cs)}}}setImageStyle(t){let e;if(!t||!(e=t.getSize())){this.image_=null;return}const n=t.getPixelRatio(this.pixelRatio_),s=t.getAnchor(),r=t.getOrigin();this.image_=t.getImage(this.pixelRatio_),this.imageAnchorX_=s[0]*n,this.imageAnchorY_=s[1]*n,this.imageHeight_=e[1]*n,this.imageOpacity_=t.getOpacity(),this.imageOriginX_=r[0],this.imageOriginY_=r[1],this.imageRotateWithView_=t.getRotateWithView(),this.imageRotation_=t.getRotation();const a=t.getScaleArray();this.imageScale_=[a[0]*this.pixelRatio_/n,a[1]*this.pixelRatio_/n],this.imageWidth_=e[0]*n}setTextStyle(t){if(!t)this.text_="";else{const e=t.getFill();if(!e)this.textFillState_=null;else{const f=e.getColor();this.textFillState_={fillStyle:je(f||le)}}const n=t.getStroke();if(!n)this.textStrokeState_=null;else{const f=n.getColor(),g=n.getLineCap(),_=n.getLineDash(),m=n.getLineDashOffset(),y=n.getLineJoin(),p=n.getWidth(),x=n.getMiterLimit();this.textStrokeState_={lineCap:g!==void 0?g:zn,lineDash:_||oi,lineDashOffset:m||hi,lineJoin:y!==void 0?y:Un,lineWidth:p!==void 0?p:Rs,miterLimit:x!==void 0?x:Ss,strokeStyle:je(f||Cs)}}const s=t.getFont(),r=t.getOffsetX(),a=t.getOffsetY(),o=t.getRotateWithView(),h=t.getRotation(),l=t.getScaleArray(),c=t.getText(),u=t.getTextAlign(),d=t.getTextBaseline();this.textState_={font:s!==void 0?s:Vc,textAlign:u!==void 0?u:Is,textBaseline:d!==void 0?d:Pr},this.text_=c!==void 0?Array.isArray(c)?c.reduce((f,g,_)=>f+=_%2?" ":g,""):c:"",this.textOffsetX_=r!==void 0?this.pixelRatio_*r:0,this.textOffsetY_=a!==void 0?this.pixelRatio_*a:0,this.textRotateWithView_=o!==void 0?o:!1,this.textRotation_=h!==void 0?h:0,this.textScale_=[this.pixelRatio_*l[0],this.pixelRatio_*l[1]]}}}const Xe=.5;function e_(i,t,e,n,s,r,a,o,h){const l=h?Ar(s,h):s,c=i[0]*Xe,u=i[1]*Xe,d=Bt(c,u);d.imageSmoothingEnabled=!1;const f=d.canvas,g=new t_(d,Xe,s,null,a,o,h?Bs(Ms(),h):null),_=e.length,m=Math.floor((256*256*256-1)/_),y={};for(let x=1;x<=_;++x){const v=e[x-1],M=v.getStyleFunction()||n;if(!M)continue;let C=M(v,r);if(!C)continue;Array.isArray(C)||(C=[C]);const b=(x*m).toString(16).padStart(7,"#00000");for(let L=0,N=C.length;L<N;++L){const B=C[L],U=B.getGeometryFunction()(v);if(!U||!ie(l,U.getExtent()))continue;const z=B.clone(),Q=z.getFill();Q&&Q.setColor(b);const X=z.getStroke();X&&(X.setColor(b),X.setLineDash(null)),z.setText(void 0);const H=B.getImage();if(H){const R=H.getImageSize();if(!R)continue;const T=Bt(R[0],R[1],void 0,{alpha:!1}),E=T.canvas;T.fillStyle=b,T.fillRect(0,0,E.width,E.height),z.setImage(new js({img:E,anchor:H.getAnchor(),anchorXUnits:"pixels",anchorYUnits:"pixels",offset:H.getOrigin(),opacity:1,size:H.getSize(),scale:H.getScale(),rotation:H.getRotation(),rotateWithView:H.getRotateWithView()}))}const W=z.getZIndex()||0;let w=y[W];w||(w={},y[W]=w,w.Polygon=[],w.Circle=[],w.LineString=[],w.Point=[]);const S=U.getType();if(S==="GeometryCollection"){const R=U.getGeometriesArrayRecursive();for(let T=0,E=R.length;T<E;++T){const I=R[T];w[I.getType().replace("Multi","")].push(I,z)}}else w[S.replace("Multi","")].push(U,z)}}const p=Object.keys(y).map(Number).sort(ri);for(let x=0,v=p.length;x<v;++x){const M=y[p[x]];for(const C in M){const P=M[C];for(let b=0,L=P.length;b<L;b+=2){g.setStyle(P[b+1]);for(let N=0,B=t.length;N<B;++N)g.setTransform(t[N]),g.drawGeometry(P[b])}}}return d.getImageData(0,0,f.width,f.height)}function i_(i,t,e){const n=[];if(e){const s=Math.floor(Math.round(i[0])*Xe),r=Math.floor(Math.round(i[1])*Xe),a=(Pt(s,0,e.width-1)+Pt(r,0,e.height-1)*e.width)*4,o=e.data[a],h=e.data[a+1],c=e.data[a+2]+256*(h+256*o),u=Math.floor((256*256*256-1)/t.length);c&&c%u===0&&n.push(t[c/u-1])}return n}const n_=.5,lu={Point:u_,LineString:h_,Polygon:f_,MultiPoint:d_,MultiLineString:l_,MultiPolygon:c_,GeometryCollection:o_,Circle:r_};function s_(i,t){return parseInt(_t(i),10)-parseInt(_t(t),10)}function ll(i,t){const e=cu(i,t);return e*e}function cu(i,t){return n_*i/t}function r_(i,t,e,n,s){const r=e.getFill(),a=e.getStroke();if(r||a){const h=i.getBuilder(e.getZIndex(),"Circle");h.setFillStrokeStyle(r,a),h.drawCircle(t,n,s)}const o=e.getText();if(o&&o.getText()){const h=i.getBuilder(e.getZIndex(),"Text");h.setTextStyle(o),h.drawText(t,n)}}function cl(i,t,e,n,s,r,a,o){const h=[],l=e.getImage();if(l){let d=!0;const f=l.getImageState();f==j.LOADED||f==j.ERROR?d=!1:f==j.IDLE&&l.load(),d&&h.push(l.ready())}const c=e.getFill();c&&c.loading()&&h.push(c.ready());const u=h.length>0;return u&&Promise.all(h).then(()=>s(null)),a_(i,t,e,n,r,a,o),u}function a_(i,t,e,n,s,r,a){const o=e.getGeometryFunction()(t);if(!o)return;const h=o.simplifyTransformed(n,s);if(e.getRenderer())uu(i,h,e,t,a);else{const c=lu[h.getType()];c(i,h,e,t,a,r)}}function uu(i,t,e,n,s){if(t.getType()=="GeometryCollection"){const a=t.getGeometries();for(let o=0,h=a.length;o<h;++o)uu(i,a[o],e,n,s);return}i.getBuilder(e.getZIndex(),"Default").drawCustom(t,n,e.getRenderer(),e.getHitDetectionRenderer(),s)}function o_(i,t,e,n,s,r){const a=t.getGeometriesArray();let o,h;for(o=0,h=a.length;o<h;++o){const l=lu[a[o].getType()];l(i,a[o],e,n,s,r)}}function h_(i,t,e,n,s){const r=e.getStroke();if(r){const o=i.getBuilder(e.getZIndex(),"LineString");o.setFillStrokeStyle(null,r),o.drawLineString(t,n,s)}const a=e.getText();if(a&&a.getText()){const o=i.getBuilder(e.getZIndex(),"Text");o.setTextStyle(a),o.drawText(t,n,s)}}function l_(i,t,e,n,s){const r=e.getStroke();if(r){const o=i.getBuilder(e.getZIndex(),"LineString");o.setFillStrokeStyle(null,r),o.drawMultiLineString(t,n,s)}const a=e.getText();if(a&&a.getText()){const o=i.getBuilder(e.getZIndex(),"Text");o.setTextStyle(a),o.drawText(t,n,s)}}function c_(i,t,e,n,s){const r=e.getFill(),a=e.getStroke();if(a||r){const h=i.getBuilder(e.getZIndex(),"Polygon");h.setFillStrokeStyle(r,a),h.drawMultiPolygon(t,n,s)}const o=e.getText();if(o&&o.getText()){const h=i.getBuilder(e.getZIndex(),"Text");h.setTextStyle(o),h.drawText(t,n,s)}}function u_(i,t,e,n,s,r){const a=e.getImage(),o=e.getText(),h=o&&o.getText(),l=r&&a&&h?{}:void 0;if(a){if(a.getImageState()!=j.LOADED)return;const c=i.getBuilder(e.getZIndex(),"Image");c.setImageStyle(a,l),c.drawPoint(t,n,s)}if(h){const c=i.getBuilder(e.getZIndex(),"Text");c.setTextStyle(o,l),c.drawText(t,n,s)}}function d_(i,t,e,n,s,r){const a=e.getImage(),o=a&&a.getOpacity()!==0,h=e.getText(),l=h&&h.getText(),c=r&&o&&l?{}:void 0;if(o){if(a.getImageState()!=j.LOADED)return;const u=i.getBuilder(e.getZIndex(),"Image");u.setImageStyle(a,c),u.drawMultiPoint(t,n,s)}if(l){const u=i.getBuilder(e.getZIndex(),"Text");u.setTextStyle(h,c),u.drawText(t,n,s)}}function f_(i,t,e,n,s){const r=e.getFill(),a=e.getStroke();if(r||a){const h=i.getBuilder(e.getZIndex(),"Polygon");h.setFillStrokeStyle(r,a),h.drawPolygon(t,n,s)}const o=e.getText();if(o&&o.getText()){const h=i.getBuilder(e.getZIndex(),"Text");h.setTextStyle(o),h.drawText(t,n,s)}}const g_=5;class __ extends ks{constructor(t){super(),this.ready=!0,this.boundHandleImageChange_=this.handleImageChange_.bind(this),this.layer_=t,this.staleKeys_=new Array,this.maxStaleKeys=g_}getStaleKeys(){return this.staleKeys_}prependStaleKey(t){this.staleKeys_.unshift(t),this.staleKeys_.length>this.maxStaleKeys&&(this.staleKeys_.length=this.maxStaleKeys)}getFeatures(t){return yt()}getData(t){return null}prepareFrame(t){return yt()}renderFrame(t,e){return yt()}forEachFeatureAtCoordinate(t,e,n,s,r){}getLayer(){return this.layer_}handleFontsChanged(){}handleImageChange_(t){const e=t.target;(e.getState()===j.LOADED||e.getState()===j.ERROR)&&this.renderIfReadyAndVisible()}loadImage(t){let e=t.getState();return e!=j.LOADED&&e!=j.ERROR&&t.addEventListener(et.CHANGE,this.boundHandleImageChange_),e==j.IDLE&&(t.load(),e=t.getState()),e==j.LOADED}renderIfReadyAndVisible(){const t=this.getLayer();t&&t.getVisible()&&t.getSourceState()==="ready"&&t.changed()}renderDeferred(t){}disposeInternal(){delete this.layer_,super.disposeInternal()}}const ul=[];let yn=null;function m_(){yn=Bt(1,1,void 0,{willReadFrequently:!0})}class Ko extends __{constructor(t){super(t),this.container=null,this.renderedResolution,this.tempTransform=ke(),this.pixelTransform=ke(),this.inversePixelTransform=ke(),this.context=null,this.deferredContext_=null,this.containerReused=!1,this.frameState=null}getImageData(t,e,n){yn||m_(),yn.clearRect(0,0,1,1);let s;try{yn.drawImage(t,e,n,1,1,0,0,1,1),s=yn.getImageData(0,0,1,1).data}catch{return yn=null,null}return s}getBackground(t){let n=this.getLayer().getBackground();return typeof n=="function"&&(n=n(t.viewState.resolution)),n||void 0}useContainer(t,e,n){const s=this.getLayer().getClassName();let r,a;if(t&&t.className===s&&(!n||t&&t.style.backgroundColor&&Li(kn(t.style.backgroundColor),kn(n)))){const o=t.firstElementChild;o instanceof HTMLCanvasElement&&(a=o.getContext("2d"))}if(a&&vf(a.canvas.style.transform,e)?(this.container=t,this.context=a,this.containerReused=!0):this.containerReused?(this.container=null,this.context=null,this.containerReused=!1):this.container&&(this.container.style.backgroundColor=null),!this.container){r=document.createElement("div"),r.className=s;let o=r.style;o.position="absolute",o.width="100%",o.height="100%",a=Bt();const h=a.canvas;r.appendChild(h),o=h.style,o.position="absolute",o.left="0",o.transformOrigin="top left",this.container=r,this.context=a}!this.containerReused&&n&&!this.container.style.backgroundColor&&(this.container.style.backgroundColor=n)}clipUnrotated(t,e,n){const s=tn(n),r=Hr(n),a=$r(n),o=Zr(n);Ut(e.coordinateToPixelTransform,s),Ut(e.coordinateToPixelTransform,r),Ut(e.coordinateToPixelTransform,a),Ut(e.coordinateToPixelTransform,o);const h=this.inversePixelTransform;Ut(h,s),Ut(h,r),Ut(h,a),Ut(h,o),t.save(),t.beginPath(),t.moveTo(Math.round(s[0]),Math.round(s[1])),t.lineTo(Math.round(r[0]),Math.round(r[1])),t.lineTo(Math.round(a[0]),Math.round(a[1])),t.lineTo(Math.round(o[0]),Math.round(o[1])),t.clip()}prepareContainer(t,e){const n=t.extent,s=t.viewState.resolution,r=t.viewState.rotation,a=t.pixelRatio,o=Math.round(gt(n)/s*a),h=Math.round(Wt(n)/s*a);Ze(this.pixelTransform,t.size[0]/2,t.size[1]/2,1/a,1/a,r,-o/2,-h/2),Ec(this.inversePixelTransform,this.pixelTransform);const l=Ef(this.pixelTransform);if(this.useContainer(e,l,this.getBackground(t)),!this.containerReused){const c=this.context.canvas;c.width!=o||c.height!=h?(c.width=o,c.height=h):this.context.clearRect(0,0,o,h),l!==c.style.transform&&(c.style.transform=l)}}dispatchRenderEvent_(t,e,n){const s=this.getLayer();if(s.hasListener(t)){const r=new nu(t,this.inversePixelTransform,n,e);s.dispatchEvent(r)}}preRender(t,e){this.frameState=e,!e.declutter&&this.dispatchRenderEvent_(Ce.PRERENDER,t,e)}postRender(t,e){e.declutter||this.dispatchRenderEvent_(Ce.POSTRENDER,t,e)}renderDeferredInternal(t){}getRenderContext(t){return t.declutter&&!this.deferredContext_&&(this.deferredContext_=new ou),t.declutter?this.deferredContext_.getContext():this.context}renderDeferred(t){t.declutter&&(this.dispatchRenderEvent_(Ce.PRERENDER,this.context,t),t.declutter&&this.deferredContext_&&(this.deferredContext_.draw(this.context),this.deferredContext_.clear()),this.renderDeferredInternal(t),this.dispatchRenderEvent_(Ce.POSTRENDER,this.context,t))}getRenderTransform(t,e,n,s,r,a,o){const h=r/2,l=a/2,c=s/e,u=-c,d=-t[0]+o,f=-t[1];return Ze(this.tempTransform,h,l,c,u,-n,d,f)}disposeInternal(){delete this.frameState,super.disposeInternal()}}class y_ extends Ko{constructor(t){super(t),this.boundHandleStyleImageChange_=this.handleStyleImageChange_.bind(this),this.animatingOrInteracting_,this.hitDetectionImageData_=null,this.clipped_=!1,this.renderedFeatures_=null,this.renderedRevision_=-1,this.renderedResolution_=NaN,this.renderedExtent_=fe(),this.wrappedRenderedExtent_=fe(),this.renderedRotation_,this.renderedCenter_=null,this.renderedProjection_=null,this.renderedPixelRatio_=1,this.renderedRenderOrder_=null,this.renderedFrameDeclutter_,this.replayGroup_=null,this.replayGroupChanged=!0,this.clipping=!0,this.targetContext_=null,this.opacity_=1}renderWorlds(t,e,n){const s=e.extent,r=e.viewState,a=r.center,o=r.resolution,h=r.projection,l=r.rotation,c=h.getExtent(),u=this.getLayer().getSource(),d=this.getLayer().getDeclutter(),f=e.pixelRatio,g=e.viewHints,_=!(g[Yt.ANIMATING]||g[Yt.INTERACTING]),m=this.context,y=Math.round(gt(s)/o*f),p=Math.round(Wt(s)/o*f),x=u.getWrapX()&&h.canWrapX(),v=x?gt(c):null,M=x?Math.ceil((s[2]-c[2])/v)+1:1;let C=x?Math.floor((s[0]-c[0])/v):0;do{let P=this.getRenderTransform(a,o,0,f,y,p,C*v);e.declutter&&(P=P.slice(0)),t.execute(m,[m.canvas.width,m.canvas.height],P,l,_,n===void 0?Wi:n?hu:Hg,n?d&&e.declutter[d]:void 0)}while(++C<M)}setDrawContext_(){this.opacity_!==1&&(this.targetContext_=this.context,this.context=Bt(this.context.canvas.width,this.context.canvas.height,ul))}resetDrawContext_(){if(this.opacity_!==1&&this.targetContext_){const t=this.targetContext_.globalAlpha;this.targetContext_.globalAlpha=this.opacity_,this.targetContext_.drawImage(this.context.canvas,0,0),this.targetContext_.globalAlpha=t,Yr(this.context),ul.push(this.context.canvas),this.context=this.targetContext_,this.targetContext_=null}}renderDeclutter(t){!this.replayGroup_||!this.getLayer().getDeclutter()||this.renderWorlds(this.replayGroup_,t,!0)}renderDeferredInternal(t){this.replayGroup_&&(this.replayGroup_.renderDeferred(),this.clipped_&&this.context.restore(),this.resetDrawContext_())}renderFrame(t,e){const n=t.layerStatesArray[t.layerIndex];this.opacity_=n.opacity;const s=t.viewState;this.prepareContainer(t,e);const r=this.context,a=this.replayGroup_;let o=a&&!a.isEmpty();if(!o&&!(this.getLayer().hasListener(Ce.PRERENDER)||this.getLayer().hasListener(Ce.POSTRENDER)))return this.container;this.setDrawContext_(),this.preRender(r,t);const h=s.projection;if(this.clipped_=!1,o&&n.extent&&this.clipping){const l=qe(n.extent,h);o=ie(l,t.extent),this.clipped_=o&&!xi(l,t.extent),this.clipped_&&this.clipUnrotated(r,t,l)}return o&&this.renderWorlds(a,t,this.getLayer().getDeclutter()?!1:void 0),!t.declutter&&this.clipped_&&r.restore(),this.postRender(r,t),this.renderedRotation_!==s.rotation&&(this.renderedRotation_=s.rotation,this.hitDetectionImageData_=null),t.declutter||this.resetDrawContext_(),this.container}getFeatures(t){return new Promise(e=>{if(this.frameState&&!this.hitDetectionImageData_&&!this.animatingOrInteracting_){const n=this.frameState.size.slice(),s=this.renderedCenter_,r=this.renderedResolution_,a=this.renderedRotation_,o=this.renderedProjection_,h=this.wrappedRenderedExtent_,l=this.getLayer(),c=[],u=n[0]*Xe,d=n[1]*Xe;c.push(this.getRenderTransform(s,r,a,Xe,u,d,0).slice());const f=l.getSource(),g=o.getExtent();if(f.getWrapX()&&o.canWrapX()&&!xi(g,h)){let m=h[0];const y=gt(g);let p=0,x;for(;m<g[0];)--p,x=y*p,c.push(this.getRenderTransform(s,r,a,Xe,u,d,x).slice()),m+=y;for(p=0,m=h[2];m>g[2];)++p,x=y*p,c.push(this.getRenderTransform(s,r,a,Xe,u,d,x).slice()),m-=y}const _=Ms();this.hitDetectionImageData_=e_(n,c,this.renderedFeatures_,l.getStyleFunction(),h,r,a,ll(r,this.renderedPixelRatio_),_?o:null)}e(i_(t,this.renderedFeatures_,this.hitDetectionImageData_))})}forEachFeatureAtCoordinate(t,e,n,s,r){if(!this.replayGroup_)return;const a=e.viewState.resolution,o=e.viewState.rotation,h=this.getLayer(),l={},c=function(d,f,g){const _=_t(d),m=l[_];if(m){if(m!==!0&&g<m.distanceSq){if(g===0)return l[_]=!0,r.splice(r.lastIndexOf(m),1),s(d,h,f);m.geometry=f,m.distanceSq=g}}else{if(g===0)return l[_]=!0,s(d,h,f);r.push(l[_]={feature:d,layer:h,geometry:f,distanceSq:g,callback:s})}},u=this.getLayer().getDeclutter();return this.replayGroup_.forEachFeatureAtCoordinate(t,a,o,n,c,u?e.declutter?.[u]?.all().map(d=>d.value):null)}handleFontsChanged(){const t=this.getLayer();t.getVisible()&&this.replayGroup_&&t.changed()}handleStyleImageChange_(t){this.renderIfReadyAndVisible()}prepareFrame(t){const e=this.getLayer(),n=e.getSource();if(!n)return!1;const s=t.viewHints[Yt.ANIMATING],r=t.viewHints[Yt.INTERACTING],a=e.getUpdateWhileAnimating(),o=e.getUpdateWhileInteracting();if(this.ready&&!a&&s||!o&&r)return this.animatingOrInteracting_=!0,!0;this.animatingOrInteracting_=!1;const h=t.extent,l=t.viewState,c=l.projection,u=l.resolution,d=t.pixelRatio,f=e.getRevision(),g=e.getRenderBuffer();let _=e.getRenderOrder();_===void 0&&(_=s_);const m=l.center.slice(),y=On(h,g*u),p=y.slice(),x=[y.slice()],v=c.getExtent();if(n.getWrapX()&&c.canWrapX()&&!xi(v,t.extent)){const X=gt(v),H=Math.max(gt(y)/2,X);y[0]=v[0]-H,y[2]=v[2]+H,hc(m,c);const W=sc(x[0],c);W[0]<v[0]&&W[2]<v[2]?x.push([W[0]+X,W[1],W[2]+X,W[3]]):W[0]>v[0]&&W[2]>v[2]&&x.push([W[0]-X,W[1],W[2]-X,W[3]])}if(this.ready&&this.renderedResolution_==u&&this.renderedRevision_==f&&this.renderedRenderOrder_==_&&this.renderedFrameDeclutter_===!!t.declutter&&xi(this.wrappedRenderedExtent_,y))return Li(this.renderedExtent_,p)||(this.hitDetectionImageData_=null,this.renderedExtent_=p),this.renderedCenter_=m,this.replayGroupChanged=!1,!0;this.replayGroup_=null;const M=new Yg(cu(u,d),y,u,d),C=Ms();let P;if(C){for(let X=0,H=x.length;X<H;++X){const W=x[X],w=Ar(W,c);n.loadFeatures(w,of(u,c),C)}P=Bs(C,c)}else for(let X=0,H=x.length;X<H;++X)n.loadFeatures(x[X],u,c);const b=ll(u,d);let L=!0;const N=(X,H)=>{let W;const w=X.getStyleFunction()||e.getStyleFunction();if(w&&(W=w(X,u)),W){const S=this.renderFeature(X,b,W,M,P,this.getLayer().getDeclutter(),H);L=L&&!S}},B=Ar(y,c),U=n.getFeaturesInExtent(B);_&&U.sort(_);for(let X=0,H=U.length;X<H;++X)N(U[X],X);this.renderedFeatures_=U,this.ready=L;const z=M.finish(),Q=new Jg(y,u,d,n.getOverlaps(),z,e.getRenderBuffer(),!!t.declutter);return this.renderedResolution_=u,this.renderedRevision_=f,this.renderedRenderOrder_=_,this.renderedFrameDeclutter_=!!t.declutter,this.renderedExtent_=p,this.wrappedRenderedExtent_=y,this.renderedCenter_=m,this.renderedProjection_=c,this.renderedPixelRatio_=d,this.replayGroup_=Q,this.hitDetectionImageData_=null,this.replayGroupChanged=!0,!0}renderFeature(t,e,n,s,r,a,o){if(!n)return!1;let h=!1;if(Array.isArray(n))for(let l=0,c=n.length;l<c;++l)h=cl(s,t,n[l],e,this.boundHandleStyleImageChange_,r,a,o)||h;else h=cl(s,t,n,e,this.boundHandleStyleImageChange_,r,a,o);return h}}class p_ extends iu{constructor(t){super(t)}createRenderer(){return new y_(this)}}let E_=!1;function v_(i,t,e,n,s,r,a){const o=new XMLHttpRequest;o.open("GET",typeof i=="function"?i(e,n,s):i,!0),t.getType()=="arraybuffer"&&(o.responseType="arraybuffer"),o.withCredentials=E_,o.onload=function(h){if(!o.status||o.status>=200&&o.status<300){const l=t.getType();try{let c;l=="text"||l=="json"?c=o.responseText:l=="xml"?c=o.responseXML||o.responseText:l=="arraybuffer"&&(c=o.response),c?r(t.readFeatures(c,{extent:e,featureProjection:s}),t.readProjection(c)):a()}catch{a()}}else a()},o.onerror=a,o.send()}function dl(i,t){return function(e,n,s,r,a){v_(i,t,e,n,s,(o,h)=>{this.addFeatures(o),r!==void 0&&r(o)},()=>{this.changed(),a!==void 0&&a()})}}function x_(i,t){return[[-1/0,-1/0,1/0,1/0]]}const fl=ke();class Ne{constructor(t,e,n,s,r,a){this.styleFunction,this.extent_,this.id_=a,this.type_=t,this.flatCoordinates_=e,this.flatInteriorPoints_=null,this.flatMidpoints_=null,this.ends_=n||null,this.properties_=r,this.squaredTolerance_,this.stride_=s,this.simplifiedGeometry_}get(t){return this.properties_[t]}getExtent(){return this.extent_||(this.extent_=this.type_==="Point"?vo(this.flatCoordinates_):xo(this.flatCoordinates_,0,this.flatCoordinates_.length,2)),this.extent_}getFlatInteriorPoint(){if(!this.flatInteriorPoints_){const t=Ve(this.getExtent());this.flatInteriorPoints_=Lo(this.flatCoordinates_,0,this.ends_,2,t,0)}return this.flatInteriorPoints_}getFlatInteriorPoints(){if(!this.flatInteriorPoints_){const t=Uf(this.flatCoordinates_,this.ends_),e=zg(this.flatCoordinates_,0,t,2);this.flatInteriorPoints_=Df(this.flatCoordinates_,0,t,2,e)}return this.flatInteriorPoints_}getFlatMidpoint(){return this.flatMidpoints_||(this.flatMidpoints_=sl(this.flatCoordinates_,0,this.flatCoordinates_.length,2,.5)),this.flatMidpoints_}getFlatMidpoints(){if(!this.flatMidpoints_){this.flatMidpoints_=[];const t=this.flatCoordinates_;let e=0;const n=this.ends_;for(let s=0,r=n.length;s<r;++s){const a=n[s],o=sl(t,e,a,2,.5);_o(this.flatMidpoints_,o),e=a}}return this.flatMidpoints_}getId(){return this.id_}getOrientedFlatCoordinates(){return this.flatCoordinates_}getGeometry(){return this}getSimplifiedGeometry(t){return this}simplifyTransformed(t,e){return this}getProperties(){return this.properties_}getPropertiesInternal(){return this.properties_}getStride(){return this.stride_}getStyleFunction(){return this.styleFunction}getType(){return this.type_}transform(t){t=Gt(t);const e=t.getExtent(),n=t.getWorldExtent();if(e&&n){const s=Wt(n)/Wt(e);Ze(fl,n[0],n[3],s,-s,0,0,0),Ri(this.flatCoordinates_,0,this.flatCoordinates_.length,2,fl,this.flatCoordinates_)}}applyTransform(t){t(this.flatCoordinates_,this.flatCoordinates_,this.stride_)}clone(){return new Ne(this.type_,this.flatCoordinates_.slice(),this.ends_?.slice(),this.stride_,Object.assign({},this.properties_),this.id_)}getEnds(){return this.ends_}enableSimplifyTransformed(){return this.simplifyTransformed=Zl((t,e)=>{if(t===this.squaredTolerance_)return this.simplifiedGeometry_;this.simplifiedGeometry_=this.clone(),e&&this.simplifiedGeometry_.applyTransform(e);const n=this.simplifiedGeometry_.getFlatCoordinates();let s;switch(this.type_){case"LineString":n.length=bo(n,0,this.simplifiedGeometry_.flatCoordinates_.length,this.simplifiedGeometry_.stride_,t,n,0),s=[n.length];break;case"MultiLineString":s=[],n.length=Lf(n,0,this.simplifiedGeometry_.ends_,this.simplifiedGeometry_.stride_,t,n,0,s);break;case"Polygon":s=[],n.length=Cc(n,0,this.simplifiedGeometry_.ends_,this.simplifiedGeometry_.stride_,Math.sqrt(t),n,0,s);break}return s&&(this.simplifiedGeometry_=new Ne(this.type_,n,s,2,this.properties_,this.id_)),this.squaredTolerance_=t,this.simplifiedGeometry_}),this}}Ne.prototype.getFlatCoordinates=Ne.prototype.getOrientedFlatCoordinates;class gl{constructor(t){this.rbush_=new zc(t),this.items_={}}insert(t,e){const n={minX:t[0],minY:t[1],maxX:t[2],maxY:t[3],value:e};this.rbush_.insert(n),this.items_[_t(e)]=n}load(t,e){const n=new Array(e.length);for(let s=0,r=e.length;s<r;s++){const a=t[s],o=e[s],h={minX:a[0],minY:a[1],maxX:a[2],maxY:a[3],value:o};n[s]=h,this.items_[_t(o)]=h}this.rbush_.load(n)}remove(t){const e=_t(t),n=this.items_[e];return delete this.items_[e],this.rbush_.remove(n)!==null}update(t,e){const n=this.items_[_t(e)],s=[n.minX,n.minY,n.maxX,n.maxY];Dn(s,t)||(this.remove(e),this.insert(t,e))}getAll(){return this.rbush_.all().map(function(e){return e.value})}getInExtent(t){const e={minX:t[0],minY:t[1],maxX:t[2],maxY:t[3]};return this.rbush_.search(e).map(function(s){return s.value})}forEach(t){return this.forEach_(this.getAll(),t)}forEachInExtent(t,e){return this.forEach_(this.getInExtent(t),e)}forEach_(t,e){let n;for(let s=0,r=t.length;s<r;s++)if(n=e(t[s]),n)return n;return n}isEmpty(){return Gn(this.items_)}clear(){this.rbush_.clear(),this.items_={}}getExtent(t){const e=this.rbush_.toJSON();return li(e.minX,e.minY,e.maxX,e.maxY,t)}concat(t){this.rbush_.load(t.rbush_.all());for(const e in t.items_)this.items_[e]=t.items_[e]}}class Vo extends He{constructor(t){super(),this.projection=Gt(t.projection),this.attributions_=_l(t.attributions),this.attributionsCollapsible_=t.attributionsCollapsible??!0,this.loading=!1,this.state_=t.state!==void 0?t.state:"ready",this.wrapX_=t.wrapX!==void 0?t.wrapX:!1,this.interpolate_=!!t.interpolate,this.viewResolver=null,this.viewRejector=null;const e=this;this.viewPromise_=new Promise(function(n,s){e.viewResolver=n,e.viewRejector=s})}getAttributions(){return this.attributions_}getAttributionsCollapsible(){return this.attributionsCollapsible_}getProjection(){return this.projection}getResolutions(t){return null}getView(){return this.viewPromise_}getState(){return this.state_}getWrapX(){return this.wrapX_}getInterpolate(){return this.interpolate_}refresh(){this.changed()}setAttributions(t){this.attributions_=_l(t),this.changed()}setState(t){this.state_=t,this.changed()}}function _l(i){return i?typeof i=="function"?i:(Array.isArray(i)||(i=[i]),t=>i):null}const Me={ADDFEATURE:"addfeature",CHANGEFEATURE:"changefeature",CLEAR:"clear",REMOVEFEATURE:"removefeature",FEATURESLOADSTART:"featuresloadstart",FEATURESLOADEND:"featuresloadend",FEATURESLOADERROR:"featuresloaderror"};class mi extends We{constructor(t,e,n){super(t),this.feature=e,this.features=n}}class aa extends Vo{constructor(t){t=t||{},super({attributions:t.attributions,interpolate:!0,projection:void 0,state:"ready",wrapX:t.wrapX!==void 0?t.wrapX:!0}),this.on,this.once,this.un,this.loader_=Es,this.format_=t.format||null,this.overlaps_=t.overlaps===void 0?!0:t.overlaps,this.url_=t.url,t.loader!==void 0?this.loader_=t.loader:this.url_!==void 0&&(vt(this.format_,"`format` must be set when `url` is set"),this.loader_=dl(this.url_,this.format_)),this.strategy_=t.strategy!==void 0?t.strategy:x_;const e=t.useSpatialIndex!==void 0?t.useSpatialIndex:!0;this.featuresRtree_=e?new gl:null,this.loadedExtentsRtree_=new gl,this.loadingExtentsCount_=0,this.nullGeometryFeatures_={},this.idIndex_={},this.uidIndex_={},this.featureChangeKeys_={},this.featuresCollection_=null;let n,s;Array.isArray(t.features)?s=t.features:t.features&&(n=t.features,s=n.getArray()),!e&&n===void 0&&(n=new ne(s)),s!==void 0&&this.addFeaturesInternal(s),n!==void 0&&this.bindFeaturesCollection_(n)}addFeature(t){this.addFeatureInternal(t),this.changed()}addFeatureInternal(t){const e=_t(t);if(!this.addToIndex_(e,t)){this.featuresCollection_&&this.featuresCollection_.remove(t);return}this.setupChangeEvents_(e,t);const n=t.getGeometry();if(n){const s=n.getExtent();this.featuresRtree_&&this.featuresRtree_.insert(s,t)}else this.nullGeometryFeatures_[e]=t;this.dispatchEvent(new mi(Me.ADDFEATURE,t))}setupChangeEvents_(t,e){e instanceof Ne||(this.featureChangeKeys_[t]=[mt(e,et.CHANGE,this.handleFeatureChange_,this),mt(e,Ln.PROPERTYCHANGE,this.handleFeatureChange_,this)])}addToIndex_(t,e){let n=!0;if(e.getId()!==void 0){const s=String(e.getId());if(!(s in this.idIndex_))this.idIndex_[s]=e;else if(e instanceof Ne){const r=this.idIndex_[s];r instanceof Ne?Array.isArray(r)?r.push(e):this.idIndex_[s]=[r,e]:n=!1}else n=!1}return n&&(vt(!(t in this.uidIndex_),"The passed `feature` was already added to the source"),this.uidIndex_[t]=e),n}addFeatures(t){this.addFeaturesInternal(t),this.changed()}addFeaturesInternal(t){const e=[],n=[],s=[];for(let r=0,a=t.length;r<a;r++){const o=t[r],h=_t(o);this.addToIndex_(h,o)&&n.push(o)}for(let r=0,a=n.length;r<a;r++){const o=n[r],h=_t(o);this.setupChangeEvents_(h,o);const l=o.getGeometry();if(l){const c=l.getExtent();e.push(c),s.push(o)}else this.nullGeometryFeatures_[h]=o}if(this.featuresRtree_&&this.featuresRtree_.load(e,s),this.hasListener(Me.ADDFEATURE))for(let r=0,a=n.length;r<a;r++)this.dispatchEvent(new mi(Me.ADDFEATURE,n[r]))}bindFeaturesCollection_(t){let e=!1;this.addEventListener(Me.ADDFEATURE,function(n){e||(e=!0,t.push(n.feature),e=!1)}),this.addEventListener(Me.REMOVEFEATURE,function(n){e||(e=!0,t.remove(n.feature),e=!1)}),t.addEventListener(oe.ADD,n=>{e||(e=!0,this.addFeature(n.element),e=!1)}),t.addEventListener(oe.REMOVE,n=>{e||(e=!0,this.removeFeature(n.element),e=!1)}),this.featuresCollection_=t}clear(t){if(t){for(const n in this.featureChangeKeys_)this.featureChangeKeys_[n].forEach(bt);this.featuresCollection_||(this.featureChangeKeys_={},this.idIndex_={},this.uidIndex_={})}else if(this.featuresRtree_){this.featuresRtree_.forEach(n=>{this.removeFeatureInternal(n)});for(const n in this.nullGeometryFeatures_)this.removeFeatureInternal(this.nullGeometryFeatures_[n])}this.featuresCollection_&&this.featuresCollection_.clear(),this.featuresRtree_&&this.featuresRtree_.clear(),this.nullGeometryFeatures_={};const e=new mi(Me.CLEAR);this.dispatchEvent(e),this.changed()}forEachFeature(t){if(this.featuresRtree_)return this.featuresRtree_.forEach(t);this.featuresCollection_&&this.featuresCollection_.forEach(t)}forEachFeatureAtCoordinateDirect(t,e){const n=[t[0],t[1],t[0],t[1]];return this.forEachFeatureInExtent(n,function(s){const r=s.getGeometry();if(r instanceof Ne||r.intersectsCoordinate(t))return e(s)})}forEachFeatureInExtent(t,e){if(this.featuresRtree_)return this.featuresRtree_.forEachInExtent(t,e);this.featuresCollection_&&this.featuresCollection_.forEach(e)}forEachFeatureIntersectingExtent(t,e){return this.forEachFeatureInExtent(t,function(n){const s=n.getGeometry();if(s instanceof Ne||s.intersectsExtent(t)){const r=e(n);if(r)return r}})}getFeaturesCollection(){return this.featuresCollection_}getFeatures(){let t;return this.featuresCollection_?t=this.featuresCollection_.getArray().slice(0):this.featuresRtree_&&(t=this.featuresRtree_.getAll(),Gn(this.nullGeometryFeatures_)||_o(t,Object.values(this.nullGeometryFeatures_))),t}getFeaturesAtCoordinate(t){const e=[];return this.forEachFeatureAtCoordinateDirect(t,function(n){e.push(n)}),e}getFeaturesInExtent(t,e){if(this.featuresRtree_){if(!(e&&e.canWrapX()&&this.getWrapX()))return this.featuresRtree_.getInExtent(t);const s=rc(t,e);return[].concat(...s.map(r=>this.featuresRtree_.getInExtent(r)))}return this.featuresCollection_?this.featuresCollection_.getArray().slice(0):[]}getClosestFeatureToCoordinate(t,e){const n=t[0],s=t[1];let r=null;const a=[NaN,NaN];let o=1/0;const h=[-1/0,-1/0,1/0,1/0];return e=e||Vi,this.featuresRtree_.forEachInExtent(h,function(l){if(e(l)){const c=l.getGeometry(),u=o;if(o=c instanceof Ne?0:c.closestPointXY(n,s,a,o),o<u){r=l;const d=Math.sqrt(o);h[0]=n-d,h[1]=s-d,h[2]=n+d,h[3]=s+d}}}),r}getExtent(t){return this.featuresRtree_.getExtent(t)}getFeatureById(t){const e=this.idIndex_[t.toString()];return e!==void 0?e:null}getFeatureByUid(t){const e=this.uidIndex_[t];return e!==void 0?e:null}getFormat(){return this.format_}getOverlaps(){return this.overlaps_}getUrl(){return this.url_}handleFeatureChange_(t){const e=t.target,n=_t(e),s=e.getGeometry();if(!s)n in this.nullGeometryFeatures_||(this.featuresRtree_&&this.featuresRtree_.remove(e),this.nullGeometryFeatures_[n]=e);else{const a=s.getExtent();n in this.nullGeometryFeatures_?(delete this.nullGeometryFeatures_[n],this.featuresRtree_&&this.featuresRtree_.insert(a,e)):this.featuresRtree_&&this.featuresRtree_.update(a,e)}const r=e.getId();if(r!==void 0){const a=r.toString();this.idIndex_[a]!==e&&(this.removeFromIdIndex_(e),this.idIndex_[a]=e)}else this.removeFromIdIndex_(e),this.uidIndex_[n]=e;this.changed(),this.dispatchEvent(new mi(Me.CHANGEFEATURE,e))}hasFeature(t){const e=t.getId();return e!==void 0?e in this.idIndex_:_t(t)in this.uidIndex_}isEmpty(){return this.featuresRtree_?this.featuresRtree_.isEmpty()&&Gn(this.nullGeometryFeatures_):this.featuresCollection_?this.featuresCollection_.getLength()===0:!0}loadFeatures(t,e,n){const s=this.loadedExtentsRtree_,r=this.strategy_(t,e,n);for(let a=0,o=r.length;a<o;++a){const h=r[a];s.forEachInExtent(h,function(c){return xi(c.extent,h)})||(++this.loadingExtentsCount_,this.dispatchEvent(new mi(Me.FEATURESLOADSTART)),this.loader_.call(this,h,e,n,c=>{--this.loadingExtentsCount_,this.dispatchEvent(new mi(Me.FEATURESLOADEND,void 0,c))},()=>{--this.loadingExtentsCount_,this.dispatchEvent(new mi(Me.FEATURESLOADERROR))}),s.insert(h,{extent:h.slice()}))}this.loading=this.loader_.length<4?!1:this.loadingExtentsCount_>0}refresh(){this.clear(!0),this.loadedExtentsRtree_.clear(),super.refresh()}removeLoadedExtent(t){const e=this.loadedExtentsRtree_,n=e.forEachInExtent(t,function(s){if(Dn(s.extent,t))return s});n&&e.remove(n)}removeFeatures(t){let e=!1;for(let n=0,s=t.length;n<s;++n)e=this.removeFeatureInternal(t[n])||e;e&&this.changed()}removeFeature(t){if(!t)return;this.removeFeatureInternal(t)&&this.changed()}removeFeatureInternal(t){const e=_t(t);if(!(e in this.uidIndex_))return!1;e in this.nullGeometryFeatures_?delete this.nullGeometryFeatures_[e]:this.featuresRtree_&&this.featuresRtree_.remove(t),this.featureChangeKeys_[e]?.forEach(bt),delete this.featureChangeKeys_[e];const s=t.getId();if(s!==void 0){const r=s.toString(),a=this.idIndex_[r];a===t?delete this.idIndex_[r]:Array.isArray(a)&&(a.splice(a.indexOf(t),1),a.length===1&&(this.idIndex_[r]=a[0]))}return delete this.uidIndex_[e],this.hasListener(Me.REMOVEFEATURE)&&this.dispatchEvent(new mi(Me.REMOVEFEATURE,t)),!0}removeFromIdIndex_(t){for(const e in this.idIndex_)if(this.idIndex_[e]===t){delete this.idIndex_[e];break}}setLoader(t){this.loader_=t}setUrl(t){vt(this.format_,"`format` must be set when `url` is set"),this.url_=t,this.setLoader(dl(t,this.format_))}setOverlaps(t){this.overlaps_=t,this.changed()}}const Pa={TRANSLATESTART:"translatestart",TRANSLATING:"translating",TRANSLATEEND:"translateend"};class La extends We{constructor(t,e,n,s,r){super(t),this.features=e,this.coordinate=n,this.startCoordinate=s,this.mapBrowserEvent=r}}class M_ extends qn{constructor(t){t=t||{},super(t),this.on,this.once,this.un,this.lastCoordinate_=null,this.startCoordinate_=null,this.features_=t.features!==void 0?t.features:null;let e;if(t.layers&&!this.features_)if(typeof t.layers=="function")e=t.layers;else{const n=t.layers;e=function(s){return n.includes(s)}}else e=Vi;this.layerFilter_=e,this.filter_=t.filter&&!this.features_?t.filter:Vi,this.hitTolerance_=t.hitTolerance?t.hitTolerance:0,this.condition_=t.condition?t.condition:Lc,this.lastFeature_=null,this.addChangeListener(eo.ACTIVE,this.handleActiveChanged_)}handleDownEvent(t){if(!t.originalEvent||!this.condition_(t))return!1;if(this.lastFeature_=this.featuresAtPixel_(t.pixel,t.map),!this.lastCoordinate_&&this.lastFeature_){this.startCoordinate_=t.coordinate,this.lastCoordinate_=t.coordinate,this.handleMoveEvent(t);const e=this.features_||new ne([this.lastFeature_]);return this.dispatchEvent(new La(Pa.TRANSLATESTART,e,t.coordinate,this.startCoordinate_,t)),!0}return!1}handleUpEvent(t){if(this.lastCoordinate_){this.lastCoordinate_=null,this.handleMoveEvent(t);const e=this.features_||new ne([this.lastFeature_]);return this.dispatchEvent(new La(Pa.TRANSLATEEND,e,t.coordinate,this.startCoordinate_,t)),this.startCoordinate_=null,!0}return!1}handleDragEvent(t){if(this.lastCoordinate_){const e=t.coordinate,n=t.map.getView().getProjection(),s=De(e,n),r=De(this.lastCoordinate_,n),a=s[0]-r[0],o=s[1]-r[1],h=this.features_||new ne([this.lastFeature_]),l=Ms();h.forEach(function(c){const u=c.getGeometry();l?(u.transform(l,n),u.translate(a,o),u.transform(n,l)):u.translate(a,o),c.setGeometry(u)}),this.lastCoordinate_=e,this.dispatchEvent(new La(Pa.TRANSLATING,h,e,this.startCoordinate_,t))}}handleMoveEvent(t){const e=t.map.getViewport();this.featuresAtPixel_(t.pixel,t.map)?(e.classList.remove(this.lastCoordinate_?"ol-grab":"ol-grabbing"),e.classList.add(this.lastCoordinate_?"ol-grabbing":"ol-grab")):e.classList.remove("ol-grab","ol-grabbing")}featuresAtPixel_(t,e){return e.forEachFeatureAtPixel(t,(n,s)=>{if(!(!(n instanceof Vs)||!this.filter_(n,s))&&!(this.features_&&!this.features_.getArray().includes(n)))return n},{layerFilter:this.layerFilter_,hitTolerance:this.hitTolerance_})}getHitTolerance(){return this.hitTolerance_}setHitTolerance(t){this.hitTolerance_=t}setMap(t){const e=this.getMap();super.setMap(t),this.updateState_(e)}handleActiveChanged_(){this.updateState_(null)}updateState_(t){let e=this.getMap();const n=this.getActive();(!e||!n)&&(e=e||t,e&&e.getViewport().classList.remove("ol-grab","ol-grabbing"))}}/**
 * @license
 * Copyright (c) 2000 - 2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const w_=i=>class extends nd(sd(i)){constructor(){super(),this._mapTarget=document.createElement("div"),this._mapTarget.id="map",this._mapTarget.setAttribute("tabindex","0");const t={controls:bc({rotate:!1,zoomOptions:{zoomInLabel:"",zoomOutLabel:""}}),interactions:Nc({onFocusOnly:!1}),target:this._mapTarget};this._configuration=new Dg(t)}get configuration(){return this._configuration}ready(){super.ready(),this.shadowRoot.appendChild(this._mapTarget),this.__addMapFocusListeners()}_onResize(t){this._configuration.updateSize()}__addMapFocusListeners(){this._mapTarget.addEventListener("focusin",t=>{t.target===this._mapTarget&&this._setFocused(!0)}),this._mapTarget.addEventListener("focusout",()=>{this._setFocused(!1)})}_shouldSetFocus(t){return!1}};/**
 * @license
 * Copyright (c) 2000 - 2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */let S_=class extends w_(rd(ad(od(hd(ed))))){static get is(){return"vaadin-map"}static get cvdlName(){return"vaadin-map"}static get styles(){return cd}static get lumoInjector(){return{...super.lumoInjector,includeBaseStyles:!0}}render(){return id``}};ld(S_);function C_(i){const t=Object.keys(i.defs),e=t.length;let n,s;for(n=0;n<e;++n){const r=t[n];if(!yr(r)){const a=i.defs(r);let o=a.units;!o&&a.projName==="longlat"&&(o="degrees"),Rr(new Jr({code:r,axisOrientation:a.axis,metersPerUnit:a.to_meter,units:o}))}}for(n=0;n<e;++n){const r=t[n],a=yr(r);for(s=0;s<e;++s){const o=t[s],h=yr(o);if(!pr(r,o))if(i.defs[r]===i.defs[o])Ja([a,h]);else{const l=i(r,o);af(a,h,Ph(a,h,l.forward),Ph(h,a,l.inverse))}}}}function I_(i){i("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),i("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),i("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs");for(var t=1;t<=60;++t)i("EPSG:"+(32600+t),"+proj=utm +zone="+t+" +datum=WGS84 +units=m"),i("EPSG:"+(32700+t),"+proj=utm +zone="+t+" +south +datum=WGS84 +units=m");i.WGS84=i["EPSG:4326"],i["EPSG:3785"]=i["EPSG:3857"],i.GOOGLE=i["EPSG:3857"],i["EPSG:900913"]=i["EPSG:3857"],i["EPSG:102113"]=i["EPSG:3857"]}var Ji=1,Qi=2,Tn=3,R_=4,ao=5,ml=6378137,A_=6356752314e-3,yl=.0066943799901413165,gs=484813681109536e-20,G=Math.PI/2,T_=.16666666666666666,b_=.04722222222222222,P_=.022156084656084655,F=1e-10,Ct=.017453292519943295,Ye=57.29577951308232,Mt=Math.PI/4,bs=Math.PI*2,Nt=3.14159265359,_e={};_e.greenwich=0;_e.lisbon=-9.131906111111;_e.paris=2.337229166667;_e.bogota=-74.080916666667;_e.madrid=-3.687938888889;_e.rome=12.452333333333;_e.bern=7.439583333333;_e.jakarta=106.807719444444;_e.ferro=-17.666666666667;_e.brussels=4.367975;_e.stockholm=18.058277777778;_e.athens=23.7163375;_e.oslo=10.722916666667;const L_={mm:{to_meter:.001},cm:{to_meter:.01},ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937},fath:{to_meter:1.8288},kmi:{to_meter:1852},"us-ch":{to_meter:20.1168402336805},"us-mi":{to_meter:1609.34721869444},km:{to_meter:1e3},"ind-ft":{to_meter:.30479841},"ind-yd":{to_meter:.91439523},mi:{to_meter:1609.344},yd:{to_meter:.9144},ch:{to_meter:20.1168},link:{to_meter:.201168},dm:{to_meter:.1},in:{to_meter:.0254},"ind-ch":{to_meter:20.11669506},"us-in":{to_meter:.025400050800101},"us-yd":{to_meter:.914401828803658}};var pl=/[\s_\-\/\(\)]/g;function bi(i,t){if(i[t])return i[t];for(var e=Object.keys(i),n=t.toLowerCase().replace(pl,""),s=-1,r,a;++s<e.length;)if(r=e[s],a=r.toLowerCase().replace(pl,""),a===n)return i[r]}function oo(i){var t={},e=i.split("+").map(function(o){return o.trim()}).filter(function(o){return o}).reduce(function(o,h){var l=h.split("=");return l.push(!0),o[l[0].toLowerCase()]=l[1],o},{}),n,s,r,a={proj:"projName",datum:"datumCode",rf:function(o){t.rf=parseFloat(o)},lat_0:function(o){t.lat0=o*Ct},lat_1:function(o){t.lat1=o*Ct},lat_2:function(o){t.lat2=o*Ct},lat_ts:function(o){t.lat_ts=o*Ct},lon_0:function(o){t.long0=o*Ct},lon_1:function(o){t.long1=o*Ct},lon_2:function(o){t.long2=o*Ct},alpha:function(o){t.alpha=parseFloat(o)*Ct},gamma:function(o){t.rectified_grid_angle=parseFloat(o)*Ct},lonc:function(o){t.longc=o*Ct},x_0:function(o){t.x0=parseFloat(o)},y_0:function(o){t.y0=parseFloat(o)},k_0:function(o){t.k0=parseFloat(o)},k:function(o){t.k0=parseFloat(o)},a:function(o){t.a=parseFloat(o)},b:function(o){t.b=parseFloat(o)},r:function(o){t.a=t.b=parseFloat(o)},r_a:function(){t.R_A=!0},zone:function(o){t.zone=parseInt(o,10)},south:function(){t.utmSouth=!0},towgs84:function(o){t.datum_params=o.split(",").map(function(h){return parseFloat(h)})},to_meter:function(o){t.to_meter=parseFloat(o)},units:function(o){t.units=o;var h=bi(L_,o);h&&(t.to_meter=h.to_meter)},from_greenwich:function(o){t.from_greenwich=o*Ct},pm:function(o){var h=bi(_e,o);t.from_greenwich=(h||parseFloat(o))*Ct},nadgrids:function(o){o==="@null"?t.datumCode="none":t.nadgrids=o},axis:function(o){var h="ewnsud";o.length===3&&h.indexOf(o.substr(0,1))!==-1&&h.indexOf(o.substr(1,1))!==-1&&h.indexOf(o.substr(2,1))!==-1&&(t.axis=o)},approx:function(){t.approx=!0}};for(n in e)s=e[n],n in a?(r=a[n],typeof r=="function"?r(s):t[r]=s):t[n]=s;return typeof t.datumCode=="string"&&t.datumCode!=="WGS84"&&(t.datumCode=t.datumCode.toLowerCase()),t}class du{static getId(t){const e=t.find(n=>Array.isArray(n)&&n[0]==="ID");return e&&e.length>=3?{authority:e[1],code:parseInt(e[2],10)}:null}static convertUnit(t,e="unit"){if(!t||t.length<3)return{type:e,name:"unknown",conversion_factor:null};const n=t[1],s=parseFloat(t[2])||null,r=t.find(o=>Array.isArray(o)&&o[0]==="ID"),a=r?{authority:r[1],code:parseInt(r[2],10)}:null;return{type:e,name:n,conversion_factor:s,id:a}}static convertAxis(t){const e=t[1]||"Unknown";let n;const s=e.match(/^\((.)\)$/);if(s){const l=s[1].toUpperCase();if(l==="E")n="east";else if(l==="N")n="north";else if(l==="U")n="up";else throw new Error(`Unknown axis abbreviation: ${l}`)}else n=t[2]?t[2].toLowerCase():"unknown";const r=t.find(l=>Array.isArray(l)&&l[0]==="ORDER"),a=r?parseInt(r[1],10):null,o=t.find(l=>Array.isArray(l)&&(l[0]==="LENGTHUNIT"||l[0]==="ANGLEUNIT"||l[0]==="SCALEUNIT")),h=this.convertUnit(o);return{name:e,direction:n,unit:h,order:a}}static extractAxes(t){return t.filter(e=>Array.isArray(e)&&e[0]==="AXIS").map(e=>this.convertAxis(e)).sort((e,n)=>(e.order||0)-(n.order||0))}static convert(t,e={}){switch(t[0]){case"PROJCRS":e.type="ProjectedCRS",e.name=t[1],e.base_crs=t.find(d=>Array.isArray(d)&&d[0]==="BASEGEOGCRS")?this.convert(t.find(d=>Array.isArray(d)&&d[0]==="BASEGEOGCRS")):null,e.conversion=t.find(d=>Array.isArray(d)&&d[0]==="CONVERSION")?this.convert(t.find(d=>Array.isArray(d)&&d[0]==="CONVERSION")):null;const n=t.find(d=>Array.isArray(d)&&d[0]==="CS");n&&(e.coordinate_system={type:n[1],axis:this.extractAxes(t)});const s=t.find(d=>Array.isArray(d)&&d[0]==="LENGTHUNIT");if(s){const d=this.convertUnit(s);e.coordinate_system.unit=d}e.id=this.getId(t);break;case"BASEGEOGCRS":case"GEOGCRS":e.type="GeographicCRS",e.name=t[1];const r=t.find(d=>Array.isArray(d)&&(d[0]==="DATUM"||d[0]==="ENSEMBLE"));if(r){const d=this.convert(r);r[0]==="ENSEMBLE"?e.datum_ensemble=d:e.datum=d;const f=t.find(g=>Array.isArray(g)&&g[0]==="PRIMEM");f&&f[1]!=="Greenwich"&&(d.prime_meridian={name:f[1],longitude:parseFloat(f[2])})}e.coordinate_system={type:"ellipsoidal",axis:this.extractAxes(t)},e.id=this.getId(t);break;case"DATUM":e.type="GeodeticReferenceFrame",e.name=t[1],e.ellipsoid=t.find(d=>Array.isArray(d)&&d[0]==="ELLIPSOID")?this.convert(t.find(d=>Array.isArray(d)&&d[0]==="ELLIPSOID")):null;break;case"ENSEMBLE":e.type="DatumEnsemble",e.name=t[1],e.members=t.filter(d=>Array.isArray(d)&&d[0]==="MEMBER").map(d=>({type:"DatumEnsembleMember",name:d[1],id:this.getId(d)}));const a=t.find(d=>Array.isArray(d)&&d[0]==="ENSEMBLEACCURACY");a&&(e.accuracy=parseFloat(a[1]));const o=t.find(d=>Array.isArray(d)&&d[0]==="ELLIPSOID");o&&(e.ellipsoid=this.convert(o)),e.id=this.getId(t);break;case"ELLIPSOID":e.type="Ellipsoid",e.name=t[1],e.semi_major_axis=parseFloat(t[2]),e.inverse_flattening=parseFloat(t[3]),t.find(d=>Array.isArray(d)&&d[0]==="LENGTHUNIT")&&this.convert(t.find(d=>Array.isArray(d)&&d[0]==="LENGTHUNIT"),e);break;case"CONVERSION":e.type="Conversion",e.name=t[1],e.method=t.find(d=>Array.isArray(d)&&d[0]==="METHOD")?this.convert(t.find(d=>Array.isArray(d)&&d[0]==="METHOD")):null,e.parameters=t.filter(d=>Array.isArray(d)&&d[0]==="PARAMETER").map(d=>this.convert(d));break;case"METHOD":e.type="Method",e.name=t[1],e.id=this.getId(t);break;case"PARAMETER":e.type="Parameter",e.name=t[1],e.value=parseFloat(t[2]),e.unit=this.convertUnit(t.find(d=>Array.isArray(d)&&(d[0]==="LENGTHUNIT"||d[0]==="ANGLEUNIT"||d[0]==="SCALEUNIT"))),e.id=this.getId(t);break;case"BOUNDCRS":e.type="BoundCRS";const h=t.find(d=>Array.isArray(d)&&d[0]==="SOURCECRS");if(h){const d=h.find(f=>Array.isArray(f));e.source_crs=d?this.convert(d):null}const l=t.find(d=>Array.isArray(d)&&d[0]==="TARGETCRS");if(l){const d=l.find(f=>Array.isArray(f));e.target_crs=d?this.convert(d):null}const c=t.find(d=>Array.isArray(d)&&d[0]==="ABRIDGEDTRANSFORMATION");c?e.transformation=this.convert(c):e.transformation=null;break;case"ABRIDGEDTRANSFORMATION":if(e.type="Transformation",e.name=t[1],e.method=t.find(d=>Array.isArray(d)&&d[0]==="METHOD")?this.convert(t.find(d=>Array.isArray(d)&&d[0]==="METHOD")):null,e.parameters=t.filter(d=>Array.isArray(d)&&(d[0]==="PARAMETER"||d[0]==="PARAMETERFILE")).map(d=>{if(d[0]==="PARAMETER")return this.convert(d);if(d[0]==="PARAMETERFILE")return{name:d[1],value:d[2],id:{authority:"EPSG",code:8656}}}),e.parameters.length===7){const d=e.parameters[6];d.name==="Scale difference"&&(d.value=Math.round((d.value-1)*1e12)/1e6)}e.id=this.getId(t);break;case"AXIS":e.coordinate_system||(e.coordinate_system={type:"unspecified",axis:[]}),e.coordinate_system.axis.push(this.convertAxis(t));break;case"LENGTHUNIT":const u=this.convertUnit(t,"LinearUnit");e.coordinate_system&&e.coordinate_system.axis&&e.coordinate_system.axis.forEach(d=>{d.unit||(d.unit=u)}),u.conversion_factor&&u.conversion_factor!==1&&e.semi_major_axis&&(e.semi_major_axis={value:e.semi_major_axis,unit:u});break;default:e.keyword=t[0];break}return e}}class G_ extends du{static convert(t,e={}){return super.convert(t,e),e.coordinate_system&&e.coordinate_system.subtype==="Cartesian"&&delete e.coordinate_system,e.usage&&delete e.usage,e}}class O_ extends du{static convert(t,e={}){super.convert(t,e);const n=t.find(r=>Array.isArray(r)&&r[0]==="CS");n&&(e.coordinate_system={subtype:n[1],axis:this.extractAxes(t)});const s=t.find(r=>Array.isArray(r)&&r[0]==="USAGE");if(s){const r=s.find(h=>Array.isArray(h)&&h[0]==="SCOPE"),a=s.find(h=>Array.isArray(h)&&h[0]==="AREA"),o=s.find(h=>Array.isArray(h)&&h[0]==="BBOX");e.usage={},r&&(e.usage.scope=r[1]),a&&(e.usage.area=a[1]),o&&(e.usage.bbox=o.slice(1))}return e}}function D_(i){return i.find(t=>Array.isArray(t)&&t[0]==="USAGE")?"2019":(i.find(t=>Array.isArray(t)&&t[0]==="CS")||i[0]==="BOUNDCRS"||i[0]==="PROJCRS"||i[0]==="GEOGCRS","2015")}function N_(i){return(D_(i)==="2019"?O_:G_).convert(i)}function F_(i){const t=i.toUpperCase();return t.includes("PROJCRS")||t.includes("GEOGCRS")||t.includes("BOUNDCRS")||t.includes("VERTCRS")||t.includes("LENGTHUNIT")||t.includes("ANGLEUNIT")||t.includes("SCALEUNIT")?"WKT2":(t.includes("PROJCS")||t.includes("GEOGCS")||t.includes("LOCAL_CS")||t.includes("VERT_CS")||t.includes("UNIT"),"WKT1")}var Ps=1,fu=2,gu=3,Dr=4,_u=5,Zo=-1,k_=/\s/,z_=/[A-Za-z]/,U_=/[A-Za-z84_]/,oa=/[,\]]/,mu=/[\d\.E\-\+]/;function ui(i){if(typeof i!="string")throw new Error("not a string");this.text=i.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=Ps}ui.prototype.readCharicter=function(){var i=this.text[this.place++];if(this.state!==Dr)for(;k_.test(i);){if(this.place>=this.text.length)return;i=this.text[this.place++]}switch(this.state){case Ps:return this.neutral(i);case fu:return this.keyword(i);case Dr:return this.quoted(i);case _u:return this.afterquote(i);case gu:return this.number(i);case Zo:return}};ui.prototype.afterquote=function(i){if(i==='"'){this.word+='"',this.state=Dr;return}if(oa.test(i)){this.word=this.word.trim(),this.afterItem(i);return}throw new Error(`havn't handled "`+i+'" in afterquote yet, index '+this.place)};ui.prototype.afterItem=function(i){if(i===","){this.word!==null&&this.currentObject.push(this.word),this.word=null,this.state=Ps;return}if(i==="]"){this.level--,this.word!==null&&(this.currentObject.push(this.word),this.word=null),this.state=Ps,this.currentObject=this.stack.pop(),this.currentObject||(this.state=Zo);return}};ui.prototype.number=function(i){if(mu.test(i)){this.word+=i;return}if(oa.test(i)){this.word=parseFloat(this.word),this.afterItem(i);return}throw new Error(`havn't handled "`+i+'" in number yet, index '+this.place)};ui.prototype.quoted=function(i){if(i==='"'){this.state=_u;return}this.word+=i};ui.prototype.keyword=function(i){if(U_.test(i)){this.word+=i;return}if(i==="["){var t=[];t.push(this.word),this.level++,this.root===null?this.root=t:this.currentObject.push(t),this.stack.push(this.currentObject),this.currentObject=t,this.state=Ps;return}if(oa.test(i)){this.afterItem(i);return}throw new Error(`havn't handled "`+i+'" in keyword yet, index '+this.place)};ui.prototype.neutral=function(i){if(z_.test(i)){this.word=i,this.state=fu;return}if(i==='"'){this.word="",this.state=Dr;return}if(mu.test(i)){this.word=i,this.state=gu;return}if(oa.test(i)){this.afterItem(i);return}throw new Error(`havn't handled "`+i+'" in neutral yet, index '+this.place)};ui.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(this.state===Zo)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)};function W_(i){var t=new ui(i);return t.output()}function Ga(i,t,e){Array.isArray(t)&&(e.unshift(t),t=null);var n=t?{}:i,s=e.reduce(function(r,a){return Mn(a,r),r},n);t&&(i[t]=s)}function Mn(i,t){if(!Array.isArray(i)){t[i]=!0;return}var e=i.shift();if(e==="PARAMETER"&&(e=i.shift()),i.length===1){if(Array.isArray(i[0])){t[e]={},Mn(i[0],t[e]);return}t[e]=i[0];return}if(!i.length){t[e]=!0;return}if(e==="TOWGS84"){t[e]=i;return}if(e==="AXIS"){e in t||(t[e]=[]),t[e].push(i);return}Array.isArray(e)||(t[e]={});var n;switch(e){case"UNIT":case"PRIMEM":case"VERT_DATUM":t[e]={name:i[0].toLowerCase(),convert:i[1]},i.length===3&&Mn(i[2],t[e]);return;case"SPHEROID":case"ELLIPSOID":t[e]={name:i[0],a:i[1],rf:i[2]},i.length===4&&Mn(i[3],t[e]);return;case"EDATUM":case"ENGINEERINGDATUM":case"LOCAL_DATUM":case"DATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":i[0]=["name",i[0]],Ga(t,e,i);return;case"COMPD_CS":case"COMPOUNDCRS":case"FITTED_CS":case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"ENGCRS":case"ENGINEERINGCRS":i[0]=["name",i[0]],Ga(t,e,i),t[e].type=e;return;default:for(n=-1;++n<i.length;)if(!Array.isArray(i[n]))return Mn(i,t[e]);return Ga(t,e,i)}}var B_=.017453292519943295;function Oe(i){return i*B_}function yu(i){const t=(i.projName||"").toLowerCase().replace(/_/g," ");!i.long0&&i.longc&&(t==="albers conic equal area"||t==="lambert azimuthal equal area")&&(i.long0=i.longc),!i.lat_ts&&i.lat1&&(t==="stereographic south pole"||t==="polar stereographic (variant b)")?(i.lat0=Oe(i.lat1>0?90:-90),i.lat_ts=i.lat1,delete i.lat1):!i.lat_ts&&i.lat0&&(t==="polar stereographic"||t==="polar stereographic (variant a)")&&(i.lat_ts=i.lat0,i.lat0=Oe(i.lat0>0?90:-90),delete i.lat1)}function El(i){let t={units:null,to_meter:void 0};return typeof i=="string"?(t.units=i.toLowerCase(),t.units==="metre"&&(t.units="meter"),t.units==="meter"&&(t.to_meter=1)):i&&i.name&&(t.units=i.name.toLowerCase(),t.units==="metre"&&(t.units="meter"),t.to_meter=i.conversion_factor),t}function vl(i){return typeof i=="object"?i.value*i.unit.conversion_factor:i}function xl(i,t){i.ellipsoid.radius?(t.a=i.ellipsoid.radius,t.rf=0):(t.a=vl(i.ellipsoid.semi_major_axis),i.ellipsoid.inverse_flattening!==void 0?t.rf=i.ellipsoid.inverse_flattening:i.ellipsoid.semi_major_axis!==void 0&&i.ellipsoid.semi_minor_axis!==void 0&&(t.rf=t.a/(t.a-vl(i.ellipsoid.semi_minor_axis))))}function Nr(i,t={}){return!i||typeof i!="object"?i:i.type==="BoundCRS"?(Nr(i.source_crs,t),i.transformation&&(i.transformation.method&&i.transformation.method.name==="NTv2"?t.nadgrids=i.transformation.parameters[0].value:t.datum_params=i.transformation.parameters.map(e=>e.value)),t):(Object.keys(i).forEach(e=>{const n=i[e];if(n!==null)switch(e){case"name":if(t.srsCode)break;t.name=n,t.srsCode=n;break;case"type":n==="GeographicCRS"?t.projName="longlat":n==="ProjectedCRS"&&i.conversion&&i.conversion.method&&(t.projName=i.conversion.method.name);break;case"datum":case"datum_ensemble":n.ellipsoid&&(t.ellps=n.ellipsoid.name,xl(n,t)),n.prime_meridian&&(t.from_greenwich=n.prime_meridian.longitude*Math.PI/180);break;case"ellipsoid":t.ellps=n.name,xl(n,t);break;case"prime_meridian":t.long0=(n.longitude||0)*Math.PI/180;break;case"coordinate_system":if(n.axis){if(t.axis=n.axis.map(s=>{const r=s.direction;if(r==="east")return"e";if(r==="north")return"n";if(r==="west")return"w";if(r==="south")return"s";throw new Error(`Unknown axis direction: ${r}`)}).join("")+"u",n.unit){const{units:s,to_meter:r}=El(n.unit);t.units=s,t.to_meter=r}else if(n.axis[0]&&n.axis[0].unit){const{units:s,to_meter:r}=El(n.axis[0].unit);t.units=s,t.to_meter=r}}break;case"id":n.authority&&n.code&&(t.title=n.authority+":"+n.code);break;case"conversion":n.method&&n.method.name&&(t.projName=n.method.name),n.parameters&&n.parameters.forEach(s=>{const r=s.name.toLowerCase().replace(/\s+/g,"_"),a=s.value;s.unit&&s.unit.conversion_factor?t[r]=a*s.unit.conversion_factor:s.unit==="degree"?t[r]=a*Math.PI/180:t[r]=a});break;case"unit":n.name&&(t.units=n.name.toLowerCase(),t.units==="metre"&&(t.units="meter")),n.conversion_factor&&(t.to_meter=n.conversion_factor);break;case"base_crs":Nr(n,t),t.datumCode=n.id?n.id.authority+"_"+n.id.code:n.name;break}}),t.latitude_of_false_origin!==void 0&&(t.lat0=t.latitude_of_false_origin),t.longitude_of_false_origin!==void 0&&(t.long0=t.longitude_of_false_origin),t.latitude_of_standard_parallel!==void 0&&(t.lat0=t.latitude_of_standard_parallel,t.lat1=t.latitude_of_standard_parallel),t.latitude_of_1st_standard_parallel!==void 0&&(t.lat1=t.latitude_of_1st_standard_parallel),t.latitude_of_2nd_standard_parallel!==void 0&&(t.lat2=t.latitude_of_2nd_standard_parallel),t.latitude_of_projection_centre!==void 0&&(t.lat0=t.latitude_of_projection_centre),t.longitude_of_projection_centre!==void 0&&(t.longc=t.longitude_of_projection_centre),t.easting_at_false_origin!==void 0&&(t.x0=t.easting_at_false_origin),t.northing_at_false_origin!==void 0&&(t.y0=t.northing_at_false_origin),t.latitude_of_natural_origin!==void 0&&(t.lat0=t.latitude_of_natural_origin),t.longitude_of_natural_origin!==void 0&&(t.long0=t.longitude_of_natural_origin),t.longitude_of_origin!==void 0&&(t.long0=t.longitude_of_origin),t.false_easting!==void 0&&(t.x0=t.false_easting),t.easting_at_projection_centre&&(t.x0=t.easting_at_projection_centre),t.false_northing!==void 0&&(t.y0=t.false_northing),t.northing_at_projection_centre&&(t.y0=t.northing_at_projection_centre),t.standard_parallel_1!==void 0&&(t.lat1=t.standard_parallel_1),t.standard_parallel_2!==void 0&&(t.lat2=t.standard_parallel_2),t.scale_factor_at_natural_origin!==void 0&&(t.k0=t.scale_factor_at_natural_origin),t.scale_factor_at_projection_centre!==void 0&&(t.k0=t.scale_factor_at_projection_centre),t.scale_factor_on_pseudo_standard_parallel!==void 0&&(t.k0=t.scale_factor_on_pseudo_standard_parallel),t.azimuth!==void 0&&(t.alpha=t.azimuth),t.azimuth_at_projection_centre!==void 0&&(t.alpha=t.azimuth_at_projection_centre),t.angle_from_rectified_to_skew_grid&&(t.rectified_grid_angle=t.angle_from_rectified_to_skew_grid),yu(t),t)}var X_=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];function q_(i,t){var e=t[0],n=t[1];!(e in i)&&n in i&&(i[e]=i[n],t.length===3&&(i[e]=t[2](i[e])))}function pu(i){for(var t=Object.keys(i),e=0,n=t.length;e<n;++e){var s=t[e];X_.indexOf(s)!==-1&&j_(i[s]),typeof i[s]=="object"&&pu(i[s])}}function j_(i){if(i.AUTHORITY){var t=Object.keys(i.AUTHORITY)[0];t&&t in i.AUTHORITY&&(i.title=t+":"+i.AUTHORITY[t])}if(i.type==="GEOGCS"?i.projName="longlat":i.type==="LOCAL_CS"?(i.projName="identity",i.local=!0):typeof i.PROJECTION=="object"?i.projName=Object.keys(i.PROJECTION)[0]:i.projName=i.PROJECTION,i.AXIS){for(var e="",n=0,s=i.AXIS.length;n<s;++n){var r=[i.AXIS[n][0].toLowerCase(),i.AXIS[n][1].toLowerCase()];r[0].indexOf("north")!==-1||(r[0]==="y"||r[0]==="lat")&&r[1]==="north"?e+="n":r[0].indexOf("south")!==-1||(r[0]==="y"||r[0]==="lat")&&r[1]==="south"?e+="s":r[0].indexOf("east")!==-1||(r[0]==="x"||r[0]==="lon")&&r[1]==="east"?e+="e":(r[0].indexOf("west")!==-1||(r[0]==="x"||r[0]==="lon")&&r[1]==="west")&&(e+="w")}e.length===2&&(e+="u"),e.length===3&&(i.axis=e)}i.UNIT&&(i.units=i.UNIT.name.toLowerCase(),i.units==="metre"&&(i.units="meter"),i.UNIT.convert&&(i.type==="GEOGCS"?i.DATUM&&i.DATUM.SPHEROID&&(i.to_meter=i.UNIT.convert*i.DATUM.SPHEROID.a):i.to_meter=i.UNIT.convert));var a=i.GEOGCS;i.type==="GEOGCS"&&(a=i),a&&(a.DATUM?i.datumCode=a.DATUM.name.toLowerCase():i.datumCode=a.name.toLowerCase(),i.datumCode.slice(0,2)==="d_"&&(i.datumCode=i.datumCode.slice(2)),i.datumCode==="new_zealand_1949"&&(i.datumCode="nzgd49"),(i.datumCode==="wgs_1984"||i.datumCode==="world_geodetic_system_1984")&&(i.PROJECTION==="Mercator_Auxiliary_Sphere"&&(i.sphere=!0),i.datumCode="wgs84"),i.datumCode==="belge_1972"&&(i.datumCode="rnb72"),a.DATUM&&a.DATUM.SPHEROID&&(i.ellps=a.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),i.ellps.toLowerCase().slice(0,13)==="international"&&(i.ellps="intl"),i.a=a.DATUM.SPHEROID.a,i.rf=parseFloat(a.DATUM.SPHEROID.rf,10)),a.DATUM&&a.DATUM.TOWGS84&&(i.datum_params=a.DATUM.TOWGS84),~i.datumCode.indexOf("osgb_1936")&&(i.datumCode="osgb36"),~i.datumCode.indexOf("osni_1952")&&(i.datumCode="osni52"),(~i.datumCode.indexOf("tm65")||~i.datumCode.indexOf("geodetic_datum_of_1965"))&&(i.datumCode="ire65"),i.datumCode==="ch1903+"&&(i.datumCode="ch1903"),~i.datumCode.indexOf("israel")&&(i.datumCode="isr93")),i.b&&!isFinite(i.b)&&(i.b=i.a),i.rectified_grid_angle&&(i.rectified_grid_angle=Oe(i.rectified_grid_angle));function o(c){var u=i.to_meter||1;return c*u}var h=function(c){return q_(i,c)},l=[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_1","Latitude of 1st standard parallel"],["standard_parallel_2","Standard_Parallel_2"],["standard_parallel_2","Latitude of 2nd standard parallel"],["false_easting","False_Easting"],["false_easting","False easting"],["false-easting","Easting at false origin"],["false_northing","False_Northing"],["false_northing","False northing"],["false_northing","Northing at false origin"],["central_meridian","Central_Meridian"],["central_meridian","Longitude of natural origin"],["central_meridian","Longitude of false origin"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["latitude_of_origin","Latitude of natural origin"],["latitude_of_origin","Latitude of false origin"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",Oe],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",Oe],["x0","false_easting",o],["y0","false_northing",o],["long0","central_meridian",Oe],["lat0","latitude_of_origin",Oe],["lat0","standard_parallel_1",Oe],["lat1","standard_parallel_1",Oe],["lat2","standard_parallel_2",Oe],["azimuth","Azimuth"],["alpha","azimuth",Oe],["srsCode","name"]];l.forEach(h),yu(i)}function ho(i){if(typeof i=="object")return Nr(i);const t=F_(i);var e=W_(i);if(t==="WKT2"){const r=N_(e);return Nr(r)}var n=e[0],s={};return Mn(e,s),pu(s),s[n]}function te(i){var t=this;if(arguments.length===2){var e=arguments[1];typeof e=="string"?e.charAt(0)==="+"?te[i]=oo(arguments[1]):te[i]=ho(arguments[1]):te[i]=e}else if(arguments.length===1){if(Array.isArray(i))return i.map(function(n){Array.isArray(n)?te.apply(t,n):te(n)});if(typeof i=="string"){if(i in te)return te[i]}else"EPSG"in i?te["EPSG:"+i.EPSG]=i:"ESRI"in i?te["ESRI:"+i.ESRI]=i:"IAU2000"in i?te["IAU2000:"+i.IAU2000]=i:console.log(i);return}}I_(te);function Y_(i){return typeof i=="string"}function K_(i){return i in te}function V_(i){return i.indexOf("+")!==0&&i.indexOf("[")!==-1||typeof i=="object"&&!("srsCode"in i)}var Z_=["3857","900913","3785","102113"];function $_(i){var t=bi(i,"authority");if(t){var e=bi(t,"epsg");return e&&Z_.indexOf(e)>-1}}function H_(i){var t=bi(i,"extension");if(t)return bi(t,"proj4")}function J_(i){return i[0]==="+"}function Q_(i){if(Y_(i)){if(K_(i))return te[i];if(V_(i)){var t=ho(i);if($_(t))return te["EPSG:3857"];var e=H_(t);return e?oo(e):t}if(J_(i))return oo(i)}else return i.projName?i:ho(i)}function Ml(i,t){i=i||{};var e,n;if(!t)return i;for(n in t)e=t[n],e!==void 0&&(i[n]=e);return i}function $e(i,t,e){var n=i*t;return e/Math.sqrt(1-n*n)}function $s(i){return i<0?-1:1}function k(i){return Math.abs(i)<=Nt?i:i-$s(i)*bs}function ze(i,t,e){var n=i*e,s=.5*i;return n=Math.pow((1-n)/(1+n),s),Math.tan(.5*(G-t))/n}function Ls(i,t){for(var e=.5*i,n,s,r=G-2*Math.atan(t),a=0;a<=15;a++)if(n=i*Math.sin(r),s=G-2*Math.atan(t*Math.pow((1-n)/(1+n),e))-r,r+=s,Math.abs(s)<=1e-10)return r;return-9999}function t1(){var i=this.b/this.a;this.es=1-i*i,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=$e(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function e1(i){var t=i.x,e=i.y;if(e*Ye>90&&e*Ye<-90&&t*Ye>180&&t*Ye<-180)return null;var n,s;if(Math.abs(Math.abs(e)-G)<=F)return null;if(this.sphere)n=this.x0+this.a*this.k0*k(t-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(Mt+.5*e));else{var r=Math.sin(e),a=ze(this.e,e,r);n=this.x0+this.a*this.k0*k(t-this.long0),s=this.y0-this.a*this.k0*Math.log(a)}return i.x=n,i.y=s,i}function i1(i){var t=i.x-this.x0,e=i.y-this.y0,n,s;if(this.sphere)s=G-2*Math.atan(Math.exp(-e/(this.a*this.k0)));else{var r=Math.exp(-e/(this.a*this.k0));if(s=Ls(this.e,r),s===-9999)return null}return n=k(this.long0+t/(this.a*this.k0)),i.x=n,i.y=s,i}var n1=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","Mercator_Variant_A","merc"];const s1={init:t1,forward:e1,inverse:i1,names:n1};function r1(){}function wl(i){return i}var a1=["longlat","identity"];const o1={init:r1,forward:wl,inverse:wl,names:a1};var h1=[s1,o1],Ui={},wn=[];function Eu(i,t){var e=wn.length;return i.names?(wn[e]=i,i.names.forEach(function(n){Ui[n.toLowerCase()]=e}),this):(console.log(t),!0)}function vu(i){return i.replace(/[-\(\)\s]+/g," ").trim().replace(/ /g,"_")}function l1(i){if(!i)return!1;var t=i.toLowerCase();if(typeof Ui[t]<"u"&&wn[Ui[t]]||(t=vu(t),t in Ui&&wn[Ui[t]]))return wn[Ui[t]]}function c1(){h1.forEach(Eu)}const u1={start:c1,add:Eu,get:l1};var xu={MERIT:{a:6378137,rf:298.257,ellipseName:"MERIT 1983"},SGS85:{a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},GRS80:{a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},IAU76:{a:6378140,rf:298.257,ellipseName:"IAU 1976"},airy:{a:6377563396e-3,b:635625691e-2,ellipseName:"Airy 1830"},APL4:{a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},NWL9D:{a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},mod_airy:{a:6377340189e-3,b:6356034446e-3,ellipseName:"Modified Airy"},andrae:{a:637710443e-2,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},aust_SA:{a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},GRS67:{a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},bessel:{a:6377397155e-3,rf:299.1528128,ellipseName:"Bessel 1841"},bess_nam:{a:6377483865e-3,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},clrk66:{a:63782064e-1,b:63565838e-1,ellipseName:"Clarke 1866"},clrk80:{a:6378249145e-3,rf:293.4663,ellipseName:"Clarke 1880 mod."},clrk80ign:{a:63782492e-1,b:6356515,rf:293.4660213,ellipseName:"Clarke 1880 (IGN)"},clrk58:{a:6378293645208759e-9,rf:294.2606763692654,ellipseName:"Clarke 1858"},CPM:{a:63757387e-1,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},delmbr:{a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},engelis:{a:637813605e-2,rf:298.2566,ellipseName:"Engelis 1985"},evrst30:{a:6377276345e-3,rf:300.8017,ellipseName:"Everest 1830"},evrst48:{a:6377304063e-3,rf:300.8017,ellipseName:"Everest 1948"},evrst56:{a:6377301243e-3,rf:300.8017,ellipseName:"Everest 1956"},evrst69:{a:6377295664e-3,rf:300.8017,ellipseName:"Everest 1969"},evrstSS:{a:6377298556e-3,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},fschr60:{a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},fschr60m:{a:6378155,rf:298.3,ellipseName:"Fischer 1960"},fschr68:{a:6378150,rf:298.3,ellipseName:"Fischer 1968"},helmert:{a:6378200,rf:298.3,ellipseName:"Helmert 1906"},hough:{a:6378270,rf:297,ellipseName:"Hough"},intl:{a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},kaula:{a:6378163,rf:298.24,ellipseName:"Kaula 1961"},lerch:{a:6378139,rf:298.257,ellipseName:"Lerch 1979"},mprts:{a:6397300,rf:191,ellipseName:"Maupertius 1738"},new_intl:{a:63781575e-1,b:63567722e-1,ellipseName:"New International 1967"},plessis:{a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},krass:{a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},SEasia:{a:6378155,b:63567733205e-4,ellipseName:"Southeast Asia"},walbeck:{a:6376896,b:63558348467e-4,ellipseName:"Walbeck"},WGS60:{a:6378165,rf:298.3,ellipseName:"WGS 60"},WGS66:{a:6378145,rf:298.25,ellipseName:"WGS 66"},WGS7:{a:6378135,rf:298.26,ellipseName:"WGS 72"},WGS84:{a:6378137,rf:298.257223563,ellipseName:"WGS 84"},sphere:{a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}};const d1=xu.WGS84;function f1(i,t,e,n){var s=i*i,r=t*t,a=(s-r)/s,o=0;n?(i*=1-a*(T_+a*(b_+a*P_)),s=i*i,a=0):o=Math.sqrt(a);var h=(s-r)/r;return{es:a,e:o,ep2:h}}function g1(i,t,e,n,s){if(!i){var r=bi(xu,n);r||(r=d1),i=r.a,t=r.b,e=r.rf}return e&&!t&&(t=(1-1/e)*i),(e===0||Math.abs(i-t)<F)&&(s=!0,t=i),{a:i,b:t,rf:e,sphere:s}}var Er={wgs84:{towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},ch1903:{towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},ggrs87:{towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},nad83:{towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},nad27:{nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},potsdam:{towgs84:"598.1,73.7,418.2,0.202,0.045,-2.455,6.7",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},carthage:{towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},hermannskogel:{towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Hermannskogel"},mgi:{towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Militar-Geographische Institut"},osni52:{towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},ire65:{towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},rassadiran:{towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},nzgd49:{towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},osgb36:{towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Ordnance Survey of Great Britain 1936"},s_jtsk:{towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},beduaram:{towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},gunung_segara:{towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},rnb72:{towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"},EPSG_5451:{towgs84:"6.41,-49.05,-11.28,1.5657,0.5242,6.9718,-5.7649"},IGNF_LURESG:{towgs84:"-192.986,13.673,-39.309,-0.4099,-2.9332,2.6881,0.43"},EPSG_4614:{towgs84:"-119.4248,-303.65872,-11.00061,1.164298,0.174458,1.096259,3.657065"},EPSG_4615:{towgs84:"-494.088,-312.129,279.877,-1.423,-1.013,1.59,-0.748"},ESRI_37241:{towgs84:"-76.822,257.457,-12.817,2.136,-0.033,-2.392,-0.031"},ESRI_37249:{towgs84:"-440.296,58.548,296.265,1.128,10.202,4.559,-0.438"},ESRI_37245:{towgs84:"-511.151,-181.269,139.609,1.05,2.703,1.798,3.071"},EPSG_4178:{towgs84:"24.9,-126.4,-93.2,-0.063,-0.247,-0.041,1.01"},EPSG_4622:{towgs84:"-472.29,-5.63,-304.12,0.4362,-0.8374,0.2563,1.8984"},EPSG_4625:{towgs84:"126.93,547.94,130.41,-2.7867,5.1612,-0.8584,13.8227"},EPSG_5252:{towgs84:"0.023,0.036,-0.068,0.00176,0.00912,-0.01136,0.00439"},EPSG_4314:{towgs84:"597.1,71.4,412.1,0.894,0.068,-1.563,7.58"},EPSG_4282:{towgs84:"-178.3,-316.7,-131.5,5.278,6.077,10.979,19.166"},EPSG_4231:{towgs84:"-83.11,-97.38,-117.22,0.0276,-0.2167,0.2147,0.1218"},EPSG_4274:{towgs84:"-230.994,102.591,25.199,0.633,-0.239,0.9,1.95"},EPSG_4134:{towgs84:"-180.624,-225.516,173.919,-0.81,-1.898,8.336,16.71006"},EPSG_4254:{towgs84:"18.38,192.45,96.82,0.056,-0.142,-0.2,-0.0013"},EPSG_4159:{towgs84:"-194.513,-63.978,-25.759,-3.4027,3.756,-3.352,-0.9175"},EPSG_4687:{towgs84:"0.072,-0.507,-0.245,0.0183,-0.0003,0.007,-0.0093"},EPSG_4227:{towgs84:"-83.58,-397.54,458.78,-17.595,-2.847,4.256,3.225"},EPSG_4746:{towgs84:"599.4,72.4,419.2,-0.062,-0.022,-2.723,6.46"},EPSG_4745:{towgs84:"612.4,77,440.2,-0.054,0.057,-2.797,2.55"},EPSG_6311:{towgs84:"8.846,-4.394,-1.122,-0.00237,-0.146528,0.130428,0.783926"},EPSG_4289:{towgs84:"565.7381,50.4018,465.2904,-1.91514,1.60363,-9.09546,4.07244"},EPSG_4230:{towgs84:"-68.863,-134.888,-111.49,-0.53,-0.14,0.57,-3.4"},EPSG_4154:{towgs84:"-123.02,-158.95,-168.47"},EPSG_4156:{towgs84:"570.8,85.7,462.8,4.998,1.587,5.261,3.56"},EPSG_4299:{towgs84:"482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15"},EPSG_4179:{towgs84:"33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84"},EPSG_4313:{towgs84:"-106.8686,52.2978,-103.7239,0.3366,-0.457,1.8422,-1.2747"},EPSG_4194:{towgs84:"163.511,127.533,-159.789"},EPSG_4195:{towgs84:"105,326,-102.5"},EPSG_4196:{towgs84:"-45,417,-3.5"},EPSG_4611:{towgs84:"-162.619,-276.959,-161.764,0.067753,-2.243649,-1.158827,-1.094246"},EPSG_4633:{towgs84:"137.092,131.66,91.475,-1.9436,-11.5993,-4.3321,-7.4824"},EPSG_4641:{towgs84:"-408.809,366.856,-412.987,1.8842,-0.5308,2.1655,-121.0993"},EPSG_4643:{towgs84:"-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7002"},EPSG_4300:{towgs84:"482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15"},EPSG_4188:{towgs84:"482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15"},EPSG_4660:{towgs84:"982.6087,552.753,-540.873,32.39344,-153.25684,-96.2266,16.805"},EPSG_4662:{towgs84:"97.295,-263.247,310.882,-1.5999,0.8386,3.1409,13.3259"},EPSG_3906:{towgs84:"577.88891,165.22205,391.18289,4.9145,-0.94729,-13.05098,7.78664"},EPSG_4307:{towgs84:"-209.3622,-87.8162,404.6198,0.0046,3.4784,0.5805,-1.4547"},EPSG_6892:{towgs84:"-76.269,-16.683,68.562,-6.275,10.536,-4.286,-13.686"},EPSG_4690:{towgs84:"221.597,152.441,176.523,2.403,1.3893,0.884,11.4648"},EPSG_4691:{towgs84:"218.769,150.75,176.75,3.5231,2.0037,1.288,10.9817"},EPSG_4629:{towgs84:"72.51,345.411,79.241,-1.5862,-0.8826,-0.5495,1.3653"},EPSG_4630:{towgs84:"165.804,216.213,180.26,-0.6251,-0.4515,-0.0721,7.4111"},EPSG_4692:{towgs84:"217.109,86.452,23.711,0.0183,-0.0003,0.007,-0.0093"},EPSG_9333:{towgs84:"0,0,0,-8.393,0.749,-10.276,0"},EPSG_9059:{towgs84:"0,0,0"},EPSG_4312:{towgs84:"601.705,84.263,485.227,4.7354,1.3145,5.393,-2.3887"},EPSG_4123:{towgs84:"-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496"},EPSG_4309:{towgs84:"-124.45,183.74,44.64,-0.4384,0.5446,-0.9706,-2.1365"},ESRI_104106:{towgs84:"-283.088,-70.693,117.445,-1.157,0.059,-0.652,-4.058"},EPSG_4281:{towgs84:"-219.247,-73.802,269.529"},EPSG_4322:{towgs84:"0,0,4.5"},EPSG_4324:{towgs84:"0,0,1.9"},EPSG_4284:{towgs84:"43.822,-108.842,-119.585,1.455,-0.761,0.737,0.549"},EPSG_4277:{towgs84:"446.448,-125.157,542.06,0.15,0.247,0.842,-20.489"},EPSG_4207:{towgs84:"-282.1,-72.2,120,-1.529,0.145,-0.89,-4.46"},EPSG_4688:{towgs84:"347.175,1077.618,2623.677,33.9058,-70.6776,9.4013,186.0647"},EPSG_4689:{towgs84:"410.793,54.542,80.501,-2.5596,-2.3517,-0.6594,17.3218"},EPSG_4720:{towgs84:"0,0,4.5"},EPSG_4273:{towgs84:"278.3,93,474.5,7.889,0.05,-6.61,6.21"},EPSG_4240:{towgs84:"204.64,834.74,293.8"},EPSG_4817:{towgs84:"278.3,93,474.5,7.889,0.05,-6.61,6.21"},ESRI_104131:{towgs84:"426.62,142.62,460.09,4.98,4.49,-12.42,-17.1"},EPSG_4265:{towgs84:"-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68"},EPSG_4263:{towgs84:"-111.92,-87.85,114.5,1.875,0.202,0.219,0.032"},EPSG_4298:{towgs84:"-689.5937,623.84046,-65.93566,-0.02331,1.17094,-0.80054,5.88536"},EPSG_4270:{towgs84:"-253.4392,-148.452,386.5267,0.15605,0.43,-0.1013,-0.0424"},EPSG_4229:{towgs84:"-121.8,98.1,-10.7"},EPSG_4220:{towgs84:"-55.5,-348,-229.2"},EPSG_4214:{towgs84:"12.646,-155.176,-80.863"},EPSG_4232:{towgs84:"-345,3,223"},EPSG_4238:{towgs84:"-1.977,-13.06,-9.993,0.364,0.254,0.689,-1.037"},EPSG_4168:{towgs84:"-170,33,326"},EPSG_4131:{towgs84:"199,931,318.9"},EPSG_4152:{towgs84:"-0.9102,2.0141,0.5602,0.029039,0.010065,0.010101,0"},EPSG_5228:{towgs84:"572.213,85.334,461.94,4.9732,1.529,5.2484,3.5378"},EPSG_8351:{towgs84:"485.021,169.465,483.839,7.786342,4.397554,4.102655,0"},EPSG_4683:{towgs84:"-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06"},EPSG_4133:{towgs84:"0,0,0"},EPSG_7373:{towgs84:"0.819,-0.5762,-1.6446,-0.00378,-0.03317,0.00318,0.0693"},EPSG_9075:{towgs84:"-0.9102,2.0141,0.5602,0.029039,0.010065,0.010101,0"},EPSG_9072:{towgs84:"-0.9102,2.0141,0.5602,0.029039,0.010065,0.010101,0"},EPSG_9294:{towgs84:"1.16835,-1.42001,-2.24431,-0.00822,-0.05508,0.01818,0.23388"},EPSG_4212:{towgs84:"-267.434,173.496,181.814,-13.4704,8.7154,7.3926,14.7492"},EPSG_4191:{towgs84:"-44.183,-0.58,-38.489,2.3867,2.7072,-3.5196,-8.2703"},EPSG_4237:{towgs84:"52.684,-71.194,-13.975,-0.312,-0.1063,-0.3729,1.0191"},EPSG_4740:{towgs84:"-1.08,-0.27,-0.9"},EPSG_4124:{towgs84:"419.3836,99.3335,591.3451,0.850389,1.817277,-7.862238,-0.99496"},EPSG_5681:{towgs84:"584.9636,107.7175,413.8067,1.1155,0.2824,-3.1384,7.9922"},EPSG_4141:{towgs84:"23.772,17.49,17.859,-0.3132,-1.85274,1.67299,-5.4262"},EPSG_4204:{towgs84:"-85.645,-273.077,-79.708,2.289,-1.421,2.532,3.194"},EPSG_4319:{towgs84:"226.702,-193.337,-35.371,-2.229,-4.391,9.238,0.9798"},EPSG_4200:{towgs84:"24.82,-131.21,-82.66"},EPSG_4130:{towgs84:"0,0,0"},EPSG_4127:{towgs84:"-82.875,-57.097,-156.768,-2.158,1.524,-0.982,-0.359"},EPSG_4149:{towgs84:"674.374,15.056,405.346"},EPSG_4617:{towgs84:"-0.991,1.9072,0.5129,1.25033e-7,4.6785e-8,5.6529e-8,0"},EPSG_4663:{towgs84:"-210.502,-66.902,-48.476,2.094,-15.067,-5.817,0.485"},EPSG_4664:{towgs84:"-211.939,137.626,58.3,-0.089,0.251,0.079,0.384"},EPSG_4665:{towgs84:"-105.854,165.589,-38.312,-0.003,-0.026,0.024,-0.048"},EPSG_4666:{towgs84:"631.392,-66.551,481.442,1.09,-4.445,-4.487,-4.43"},EPSG_4756:{towgs84:"-192.873,-39.382,-111.202,-0.00205,-0.0005,0.00335,0.0188"},EPSG_4723:{towgs84:"-179.483,-69.379,-27.584,-7.862,8.163,6.042,-13.925"},EPSG_4726:{towgs84:"8.853,-52.644,180.304,-0.393,-2.323,2.96,-24.081"},EPSG_4267:{towgs84:"-8.0,160.0,176.0"},EPSG_5365:{towgs84:"-0.16959,0.35312,0.51846,0.03385,-0.16325,0.03446,0.03693"},EPSG_4218:{towgs84:"304.5,306.5,-318.1"},EPSG_4242:{towgs84:"-33.722,153.789,94.959,-8.581,-4.478,4.54,8.95"},EPSG_4216:{towgs84:"-292.295,248.758,429.447,4.9971,2.99,6.6906,1.0289"},ESRI_104105:{towgs84:"631.392,-66.551,481.442,1.09,-4.445,-4.487,-4.43"},ESRI_104129:{towgs84:"0,0,0"},EPSG_4673:{towgs84:"174.05,-25.49,112.57"},EPSG_4202:{towgs84:"-124,-60,154"},EPSG_4203:{towgs84:"-117.763,-51.51,139.061,0.292,0.443,0.277,-0.191"},EPSG_3819:{towgs84:"595.48,121.69,515.35,4.115,-2.9383,0.853,-3.408"},EPSG_8694:{towgs84:"-93.799,-132.737,-219.073,-1.844,0.648,-6.37,-0.169"},EPSG_4145:{towgs84:"275.57,676.78,229.6"},EPSG_4283:{towgs84:"61.55,-10.87,-40.19,39.4924,32.7221,32.8979,-9.994"},EPSG_4317:{towgs84:"2.3287,-147.0425,-92.0802,-0.3092483,0.32482185,0.49729934,5.68906266"},EPSG_4272:{towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993"},EPSG_4248:{towgs84:"-307.7,265.3,-363.5"},EPSG_5561:{towgs84:"24,-121,-76"},EPSG_5233:{towgs84:"-0.293,766.95,87.713,0.195704,1.695068,3.473016,-0.039338"},ESRI_104130:{towgs84:"-86,-98,-119"},ESRI_104102:{towgs84:"682,-203,480"},ESRI_37207:{towgs84:"7,-10,-26"},EPSG_4675:{towgs84:"59.935,118.4,-10.871"},ESRI_104109:{towgs84:"-89.121,-348.182,260.871"},ESRI_104112:{towgs84:"-185.583,-230.096,281.361"},ESRI_104113:{towgs84:"25.1,-275.6,222.6"},IGNF_WGS72G:{towgs84:"0,12,6"},IGNF_NTFG:{towgs84:"-168,-60,320"},IGNF_EFATE57G:{towgs84:"-127,-769,472"},IGNF_PGP50G:{towgs84:"324.8,153.6,172.1"},IGNF_REUN47G:{towgs84:"94,-948,-1262"},IGNF_CSG67G:{towgs84:"-186,230,110"},IGNF_GUAD48G:{towgs84:"-467,-16,-300"},IGNF_TAHI51G:{towgs84:"162,117,154"},IGNF_TAHAAG:{towgs84:"65,342,77"},IGNF_NUKU72G:{towgs84:"84,274,65"},IGNF_PETRELS72G:{towgs84:"365,194,166"},IGNF_WALL78G:{towgs84:"253,-133,-127"},IGNF_MAYO50G:{towgs84:"-382,-59,-262"},IGNF_TANNAG:{towgs84:"-139,-967,436"},IGNF_IGN72G:{towgs84:"-13,-348,292"},IGNF_ATIGG:{towgs84:"1118,23,66"},IGNF_FANGA84G:{towgs84:"150.57,158.33,118.32"},IGNF_RUSAT84G:{towgs84:"202.13,174.6,-15.74"},IGNF_KAUE70G:{towgs84:"126.74,300.1,-75.49"},IGNF_MOP90G:{towgs84:"-10.8,-1.8,12.77"},IGNF_MHPF67G:{towgs84:"338.08,212.58,-296.17"},IGNF_TAHI79G:{towgs84:"160.61,116.05,153.69"},IGNF_ANAA92G:{towgs84:"1.5,3.84,4.81"},IGNF_MARQUI72G:{towgs84:"330.91,-13.92,58.56"},IGNF_APAT86G:{towgs84:"143.6,197.82,74.05"},IGNF_TUBU69G:{towgs84:"237.17,171.61,-77.84"},IGNF_STPM50G:{towgs84:"11.363,424.148,373.13"},EPSG_4150:{towgs84:"674.374,15.056,405.346"},EPSG_4754:{towgs84:"-208.4058,-109.8777,-2.5764"},ESRI_104101:{towgs84:"374,150,588"},EPSG_4693:{towgs84:"0,-0.15,0.68"},EPSG_6207:{towgs84:"293.17,726.18,245.36"},EPSG_4153:{towgs84:"-133.63,-157.5,-158.62"},EPSG_4132:{towgs84:"-241.54,-163.64,396.06"},EPSG_4221:{towgs84:"-154.5,150.7,100.4"},EPSG_4266:{towgs84:"-80.7,-132.5,41.1"},EPSG_4193:{towgs84:"-70.9,-151.8,-41.4"},EPSG_5340:{towgs84:"-0.41,0.46,-0.35"},EPSG_4246:{towgs84:"-294.7,-200.1,525.5"},EPSG_4318:{towgs84:"-3.2,-5.7,2.8"},EPSG_4121:{towgs84:"-199.87,74.79,246.62"},EPSG_4223:{towgs84:"-260.1,5.5,432.2"},EPSG_4158:{towgs84:"-0.465,372.095,171.736"},EPSG_4285:{towgs84:"-128.16,-282.42,21.93"},EPSG_4613:{towgs84:"-404.78,685.68,45.47"},EPSG_4607:{towgs84:"195.671,332.517,274.607"},EPSG_4475:{towgs84:"-381.788,-57.501,-256.673"},EPSG_4208:{towgs84:"-157.84,308.54,-146.6"},EPSG_4743:{towgs84:"70.995,-335.916,262.898"},EPSG_4710:{towgs84:"-323.65,551.39,-491.22"},EPSG_7881:{towgs84:"-0.077,0.079,0.086"},EPSG_4682:{towgs84:"283.729,735.942,261.143"},EPSG_4739:{towgs84:"-156,-271,-189"},EPSG_4679:{towgs84:"-80.01,253.26,291.19"},EPSG_4750:{towgs84:"-56.263,16.136,-22.856"},EPSG_4644:{towgs84:"-10.18,-350.43,291.37"},EPSG_4695:{towgs84:"-103.746,-9.614,-255.95"},EPSG_4292:{towgs84:"-355,21,72"},EPSG_4302:{towgs84:"-61.702,284.488,472.052"},EPSG_4143:{towgs84:"-124.76,53,466.79"},EPSG_4606:{towgs84:"-153,153,307"},EPSG_4699:{towgs84:"-770.1,158.4,-498.2"},EPSG_4247:{towgs84:"-273.5,110.6,-357.9"},EPSG_4160:{towgs84:"8.88,184.86,106.69"},EPSG_4161:{towgs84:"-233.43,6.65,173.64"},EPSG_9251:{towgs84:"-9.5,122.9,138.2"},EPSG_9253:{towgs84:"-78.1,101.6,133.3"},EPSG_4297:{towgs84:"-198.383,-240.517,-107.909"},EPSG_4269:{towgs84:"0,0,0"},EPSG_4301:{towgs84:"-147,506,687"},EPSG_4618:{towgs84:"-59,-11,-52"},EPSG_4612:{towgs84:"0,0,0"},EPSG_4678:{towgs84:"44.585,-131.212,-39.544"},EPSG_4250:{towgs84:"-130,29,364"},EPSG_4144:{towgs84:"214,804,268"},EPSG_4147:{towgs84:"-17.51,-108.32,-62.39"},EPSG_4259:{towgs84:"-254.1,-5.36,-100.29"},EPSG_4164:{towgs84:"-76,-138,67"},EPSG_4211:{towgs84:"-378.873,676.002,-46.255"},EPSG_4182:{towgs84:"-422.651,-172.995,84.02"},EPSG_4224:{towgs84:"-143.87,243.37,-33.52"},EPSG_4225:{towgs84:"-205.57,168.77,-4.12"},EPSG_5527:{towgs84:"-67.35,3.88,-38.22"},EPSG_4752:{towgs84:"98,390,-22"},EPSG_4310:{towgs84:"-30,190,89"},EPSG_9248:{towgs84:"-192.26,65.72,132.08"},EPSG_4680:{towgs84:"124.5,-63.5,-281"},EPSG_4701:{towgs84:"-79.9,-158,-168.9"},EPSG_4706:{towgs84:"-146.21,112.63,4.05"},EPSG_4805:{towgs84:"682,-203,480"},EPSG_4201:{towgs84:"-165,-11,206"},EPSG_4210:{towgs84:"-157,-2,-299"},EPSG_4183:{towgs84:"-104,167,-38"},EPSG_4139:{towgs84:"11,72,-101"},EPSG_4668:{towgs84:"-86,-98,-119"},EPSG_4717:{towgs84:"-2,151,181"},EPSG_4732:{towgs84:"102,52,-38"},EPSG_4280:{towgs84:"-377,681,-50"},EPSG_4209:{towgs84:"-138,-105,-289"},EPSG_4261:{towgs84:"31,146,47"},EPSG_4658:{towgs84:"-73,46,-86"},EPSG_4721:{towgs84:"265.025,384.929,-194.046"},EPSG_4222:{towgs84:"-136,-108,-292"},EPSG_4601:{towgs84:"-255,-15,71"},EPSG_4602:{towgs84:"725,685,536"},EPSG_4603:{towgs84:"72,213.7,93"},EPSG_4605:{towgs84:"9,183,236"},EPSG_4621:{towgs84:"137,248,-430"},EPSG_4657:{towgs84:"-28,199,5"},EPSG_4316:{towgs84:"103.25,-100.4,-307.19"},EPSG_4642:{towgs84:"-13,-348,292"},EPSG_4698:{towgs84:"145,-187,103"},EPSG_4192:{towgs84:"-206.1,-174.7,-87.7"},EPSG_4311:{towgs84:"-265,120,-358"},EPSG_4135:{towgs84:"58,-283,-182"},ESRI_104138:{towgs84:"198,-226,-347"},EPSG_4245:{towgs84:"-11,851,5"},EPSG_4142:{towgs84:"-125,53,467"},EPSG_4213:{towgs84:"-106,-87,188"},EPSG_4253:{towgs84:"-133,-77,-51"},EPSG_4129:{towgs84:"-132,-110,-335"},EPSG_4713:{towgs84:"-77,-128,142"},EPSG_4239:{towgs84:"217,823,299"},EPSG_4146:{towgs84:"295,736,257"},EPSG_4155:{towgs84:"-83,37,124"},EPSG_4165:{towgs84:"-173,253,27"},EPSG_4672:{towgs84:"175,-38,113"},EPSG_4236:{towgs84:"-637,-549,-203"},EPSG_4251:{towgs84:"-90,40,88"},EPSG_4271:{towgs84:"-2,374,172"},EPSG_4175:{towgs84:"-88,4,101"},EPSG_4716:{towgs84:"298,-304,-375"},EPSG_4315:{towgs84:"-23,259,-9"},EPSG_4744:{towgs84:"-242.2,-144.9,370.3"},EPSG_4244:{towgs84:"-97,787,86"},EPSG_4293:{towgs84:"616,97,-251"},EPSG_4714:{towgs84:"-127,-769,472"},EPSG_4736:{towgs84:"260,12,-147"},EPSG_6883:{towgs84:"-235,-110,393"},EPSG_6894:{towgs84:"-63,176,185"},EPSG_4205:{towgs84:"-43,-163,45"},EPSG_4256:{towgs84:"41,-220,-134"},EPSG_4262:{towgs84:"639,405,60"},EPSG_4604:{towgs84:"174,359,365"},EPSG_4169:{towgs84:"-115,118,426"},EPSG_4620:{towgs84:"-106,-129,165"},EPSG_4184:{towgs84:"-203,141,53"},EPSG_4616:{towgs84:"-289,-124,60"},EPSG_9403:{towgs84:"-307,-92,127"},EPSG_4684:{towgs84:"-133,-321,50"},EPSG_4708:{towgs84:"-491,-22,435"},EPSG_4707:{towgs84:"114,-116,-333"},EPSG_4709:{towgs84:"145,75,-272"},EPSG_4712:{towgs84:"-205,107,53"},EPSG_4711:{towgs84:"124,-234,-25"},EPSG_4718:{towgs84:"230,-199,-752"},EPSG_4719:{towgs84:"211,147,111"},EPSG_4724:{towgs84:"208,-435,-229"},EPSG_4725:{towgs84:"189,-79,-202"},EPSG_4735:{towgs84:"647,1777,-1124"},EPSG_4722:{towgs84:"-794,119,-298"},EPSG_4728:{towgs84:"-307,-92,127"},EPSG_4734:{towgs84:"-632,438,-609"},EPSG_4727:{towgs84:"912,-58,1227"},EPSG_4729:{towgs84:"185,165,42"},EPSG_4730:{towgs84:"170,42,84"},EPSG_4733:{towgs84:"276,-57,149"},ESRI_37218:{towgs84:"230,-199,-752"},ESRI_37240:{towgs84:"-7,215,225"},ESRI_37221:{towgs84:"252,-209,-751"},ESRI_4305:{towgs84:"-123,-206,219"},ESRI_104139:{towgs84:"-73,-247,227"},EPSG_4748:{towgs84:"51,391,-36"},EPSG_4219:{towgs84:"-384,664,-48"},EPSG_4255:{towgs84:"-333,-222,114"},EPSG_4257:{towgs84:"-587.8,519.75,145.76"},EPSG_4646:{towgs84:"-963,510,-359"},EPSG_6881:{towgs84:"-24,-203,268"},EPSG_6882:{towgs84:"-183,-15,273"},EPSG_4715:{towgs84:"-104,-129,239"},IGNF_RGF93GDD:{towgs84:"0,0,0"},IGNF_RGM04GDD:{towgs84:"0,0,0"},IGNF_RGSPM06GDD:{towgs84:"0,0,0"},IGNF_RGTAAF07GDD:{towgs84:"0,0,0"},IGNF_RGFG95GDD:{towgs84:"0,0,0"},IGNF_RGNCG:{towgs84:"0,0,0"},IGNF_RGPFGDD:{towgs84:"0,0,0"},IGNF_ETRS89G:{towgs84:"0,0,0"},IGNF_RGR92GDD:{towgs84:"0,0,0"},EPSG_4173:{towgs84:"0,0,0"},EPSG_4180:{towgs84:"0,0,0"},EPSG_4619:{towgs84:"0,0,0"},EPSG_4667:{towgs84:"0,0,0"},EPSG_4075:{towgs84:"0,0,0"},EPSG_6706:{towgs84:"0,0,0"},EPSG_7798:{towgs84:"0,0,0"},EPSG_4661:{towgs84:"0,0,0"},EPSG_4669:{towgs84:"0,0,0"},EPSG_8685:{towgs84:"0,0,0"},EPSG_4151:{towgs84:"0,0,0"},EPSG_9702:{towgs84:"0,0,0"},EPSG_4758:{towgs84:"0,0,0"},EPSG_4761:{towgs84:"0,0,0"},EPSG_4765:{towgs84:"0,0,0"},EPSG_8997:{towgs84:"0,0,0"},EPSG_4023:{towgs84:"0,0,0"},EPSG_4670:{towgs84:"0,0,0"},EPSG_4694:{towgs84:"0,0,0"},EPSG_4148:{towgs84:"0,0,0"},EPSG_4163:{towgs84:"0,0,0"},EPSG_4167:{towgs84:"0,0,0"},EPSG_4189:{towgs84:"0,0,0"},EPSG_4190:{towgs84:"0,0,0"},EPSG_4176:{towgs84:"0,0,0"},EPSG_4659:{towgs84:"0,0,0"},EPSG_3824:{towgs84:"0,0,0"},EPSG_3889:{towgs84:"0,0,0"},EPSG_4046:{towgs84:"0,0,0"},EPSG_4081:{towgs84:"0,0,0"},EPSG_4558:{towgs84:"0,0,0"},EPSG_4483:{towgs84:"0,0,0"},EPSG_5013:{towgs84:"0,0,0"},EPSG_5264:{towgs84:"0,0,0"},EPSG_5324:{towgs84:"0,0,0"},EPSG_5354:{towgs84:"0,0,0"},EPSG_5371:{towgs84:"0,0,0"},EPSG_5373:{towgs84:"0,0,0"},EPSG_5381:{towgs84:"0,0,0"},EPSG_5393:{towgs84:"0,0,0"},EPSG_5489:{towgs84:"0,0,0"},EPSG_5593:{towgs84:"0,0,0"},EPSG_6135:{towgs84:"0,0,0"},EPSG_6365:{towgs84:"0,0,0"},EPSG_5246:{towgs84:"0,0,0"},EPSG_7886:{towgs84:"0,0,0"},EPSG_8431:{towgs84:"0,0,0"},EPSG_8427:{towgs84:"0,0,0"},EPSG_8699:{towgs84:"0,0,0"},EPSG_8818:{towgs84:"0,0,0"},EPSG_4757:{towgs84:"0,0,0"},EPSG_9140:{towgs84:"0,0,0"},EPSG_8086:{towgs84:"0,0,0"},EPSG_4686:{towgs84:"0,0,0"},EPSG_4737:{towgs84:"0,0,0"},EPSG_4702:{towgs84:"0,0,0"},EPSG_4747:{towgs84:"0,0,0"},EPSG_4749:{towgs84:"0,0,0"},EPSG_4674:{towgs84:"0,0,0"},EPSG_4755:{towgs84:"0,0,0"},EPSG_4759:{towgs84:"0,0,0"},EPSG_4762:{towgs84:"0,0,0"},EPSG_4763:{towgs84:"0,0,0"},EPSG_4764:{towgs84:"0,0,0"},EPSG_4166:{towgs84:"0,0,0"},EPSG_4170:{towgs84:"0,0,0"},EPSG_5546:{towgs84:"0,0,0"},EPSG_7844:{towgs84:"0,0,0"},EPSG_4818:{towgs84:"589,76,480"}};for(var _1 in Er){var Oa=Er[_1];Oa.datumName&&(Er[Oa.datumName]=Oa)}function m1(i,t,e,n,s,r,a){var o={};return i===void 0||i==="none"?o.datum_type=ao:o.datum_type=R_,t&&(o.datum_params=t.map(parseFloat),(o.datum_params[0]!==0||o.datum_params[1]!==0||o.datum_params[2]!==0)&&(o.datum_type=Ji),o.datum_params.length>3&&(o.datum_params[3]!==0||o.datum_params[4]!==0||o.datum_params[5]!==0||o.datum_params[6]!==0)&&(o.datum_type=Qi,o.datum_params[3]*=gs,o.datum_params[4]*=gs,o.datum_params[5]*=gs,o.datum_params[6]=o.datum_params[6]/1e6+1)),a&&(o.datum_type=Tn,o.grids=a),o.a=e,o.b=n,o.es=s,o.ep2=r,o}var $o={};function y1(i,t,e){return t instanceof ArrayBuffer?p1(i,t,e):{ready:E1(i,t)}}function p1(i,t,e){var n=!0;e!==void 0&&e.includeErrorFields===!1&&(n=!1);var s=new DataView(t),r=M1(s),a=w1(s,r),o=S1(s,a,r,n),h={header:a,subgrids:o};return $o[i]=h,h}async function E1(i,t){for(var e=[],n=await t.getImageCount(),s=n-1;s>=0;s--){var r=await t.getImage(s),a=await r.readRasters(),o=a,h=[r.getWidth(),r.getHeight()],l=r.getBoundingBox().map(Sl),c=[r.fileDirectory.ModelPixelScale[0],r.fileDirectory.ModelPixelScale[1]].map(Sl),u=l[0]+(h[0]-1)*c[0],d=l[3]-(h[1]-1)*c[1],f=o[0],g=o[1],_=[];for(let p=h[1]-1;p>=0;p--)for(let x=h[0]-1;x>=0;x--){var m=p*h[0]+x;_.push([-Si(g[m]),Si(f[m])])}e.push({del:c,lim:h,ll:[-u,d],cvs:_})}var y={header:{nSubgrids:n},subgrids:e};return $o[i]=y,y}function v1(i){if(i===void 0)return null;var t=i.split(",");return t.map(x1)}function x1(i){if(i.length===0)return null;var t=i[0]==="@";return t&&(i=i.slice(1)),i==="null"?{name:"null",mandatory:!t,grid:null,isNull:!0}:{name:i,mandatory:!t,grid:$o[i]||null,isNull:!1}}function Sl(i){return i*Math.PI/180}function Si(i){return i/3600*Math.PI/180}function M1(i){var t=i.getInt32(8,!1);return t===11?!1:(t=i.getInt32(8,!0),t!==11&&console.warn("Failed to detect nadgrid endian-ness, defaulting to little-endian"),!0)}function w1(i,t){return{nFields:i.getInt32(8,t),nSubgridFields:i.getInt32(24,t),nSubgrids:i.getInt32(40,t),shiftType:lo(i,56,64).trim(),fromSemiMajorAxis:i.getFloat64(120,t),fromSemiMinorAxis:i.getFloat64(136,t),toSemiMajorAxis:i.getFloat64(152,t),toSemiMinorAxis:i.getFloat64(168,t)}}function lo(i,t,e){return String.fromCharCode.apply(null,new Uint8Array(i.buffer.slice(t,e)))}function S1(i,t,e,n){for(var s=176,r=[],a=0;a<t.nSubgrids;a++){var o=I1(i,s,e),h=R1(i,s,o,e,n),l=Math.round(1+(o.upperLongitude-o.lowerLongitude)/o.longitudeInterval),c=Math.round(1+(o.upperLatitude-o.lowerLatitude)/o.latitudeInterval);r.push({ll:[Si(o.lowerLongitude),Si(o.lowerLatitude)],del:[Si(o.longitudeInterval),Si(o.latitudeInterval)],lim:[l,c],count:o.gridNodeCount,cvs:C1(h)});var u=16;n===!1&&(u=8),s+=176+o.gridNodeCount*u}return r}function C1(i){return i.map(function(t){return[Si(t.longitudeShift),Si(t.latitudeShift)]})}function I1(i,t,e){return{name:lo(i,t+8,t+16).trim(),parent:lo(i,t+24,t+24+8).trim(),lowerLatitude:i.getFloat64(t+72,e),upperLatitude:i.getFloat64(t+88,e),lowerLongitude:i.getFloat64(t+104,e),upperLongitude:i.getFloat64(t+120,e),latitudeInterval:i.getFloat64(t+136,e),longitudeInterval:i.getFloat64(t+152,e),gridNodeCount:i.getInt32(t+168,e)}}function R1(i,t,e,n,s){var r=t+176,a=16;s===!1&&(a=8);for(var o=[],h=0;h<e.gridNodeCount;h++){var l={latitudeShift:i.getFloat32(r+h*a,n),longitudeShift:i.getFloat32(r+h*a+4,n)};s!==!1&&(l.latitudeAccuracy=i.getFloat32(r+h*a+8,n),l.longitudeAccuracy=i.getFloat32(r+h*a+12,n)),o.push(l)}return o}function Ke(i,t){if(!(this instanceof Ke))return new Ke(i);t=t||function(l){if(l)throw l};var e=Q_(i);if(typeof e!="object"){t("Could not parse to valid json: "+i);return}var n=Ke.projections.get(e.projName);if(!n){t("Could not get projection name from: "+i);return}if(e.datumCode&&e.datumCode!=="none"){var s=bi(Er,e.datumCode);s&&(e.datum_params=e.datum_params||(s.towgs84?s.towgs84.split(","):null),e.ellps=s.ellipse,e.datumName=s.datumName?s.datumName:e.datumCode)}e.k0=e.k0||1,e.axis=e.axis||"enu",e.ellps=e.ellps||"wgs84",e.lat1=e.lat1||e.lat0;var r=g1(e.a,e.b,e.rf,e.ellps,e.sphere),a=f1(r.a,r.b,r.rf,e.R_A),o=v1(e.nadgrids),h=e.datum||m1(e.datumCode,e.datum_params,r.a,r.b,a.es,a.ep2,o);Ml(this,e),Ml(this,n),this.a=r.a,this.b=r.b,this.rf=r.rf,this.sphere=r.sphere,this.es=a.es,this.e=a.e,this.ep2=a.ep2,this.datum=h,this.init(),t(null,this)}Ke.projections=u1;Ke.projections.start();function A1(i,t){return i.datum_type!==t.datum_type||i.a!==t.a||Math.abs(i.es-t.es)>5e-11?!1:i.datum_type===Ji?i.datum_params[0]===t.datum_params[0]&&i.datum_params[1]===t.datum_params[1]&&i.datum_params[2]===t.datum_params[2]:i.datum_type===Qi?i.datum_params[0]===t.datum_params[0]&&i.datum_params[1]===t.datum_params[1]&&i.datum_params[2]===t.datum_params[2]&&i.datum_params[3]===t.datum_params[3]&&i.datum_params[4]===t.datum_params[4]&&i.datum_params[5]===t.datum_params[5]&&i.datum_params[6]===t.datum_params[6]:!0}function Mu(i,t,e){var n=i.x,s=i.y,r=i.z?i.z:0,a,o,h,l;if(s<-G&&s>-1.001*G)s=-G;else if(s>G&&s<1.001*G)s=G;else{if(s<-G)return{x:-1/0,y:-1/0,z:i.z};if(s>G)return{x:1/0,y:1/0,z:i.z}}return n>Math.PI&&(n-=2*Math.PI),o=Math.sin(s),l=Math.cos(s),h=o*o,a=e/Math.sqrt(1-t*h),{x:(a+r)*l*Math.cos(n),y:(a+r)*l*Math.sin(n),z:(a*(1-t)+r)*o}}function wu(i,t,e,n){var s=1e-12,r=s*s,a=30,o,h,l,c,u,d,f,g,_,m,y,p,x,v=i.x,M=i.y,C=i.z?i.z:0,P,b,L;if(o=Math.sqrt(v*v+M*M),h=Math.sqrt(v*v+M*M+C*C),o/e<s){if(P=0,h/e<s)return b=G,L=-n,{x:i.x,y:i.y,z:i.z}}else P=Math.atan2(M,v);l=C/h,c=o/h,u=1/Math.sqrt(1-t*(2-t)*c*c),g=c*(1-t)*u,_=l*u,x=0;do x++,f=e/Math.sqrt(1-t*_*_),L=o*g+C*_-f*(1-t*_*_),d=t*f/(f+L),u=1/Math.sqrt(1-d*(2-d)*c*c),m=c*(1-d)*u,y=l*u,p=y*g-m*_,g=m,_=y;while(p*p>r&&x<a);return b=Math.atan(y/Math.abs(m)),{x:P,y:b,z:L}}function T1(i,t,e){if(t===Ji)return{x:i.x+e[0],y:i.y+e[1],z:i.z+e[2]};if(t===Qi){var n=e[0],s=e[1],r=e[2],a=e[3],o=e[4],h=e[5],l=e[6];return{x:l*(i.x-h*i.y+o*i.z)+n,y:l*(h*i.x+i.y-a*i.z)+s,z:l*(-o*i.x+a*i.y+i.z)+r}}}function b1(i,t,e){if(t===Ji)return{x:i.x-e[0],y:i.y-e[1],z:i.z-e[2]};if(t===Qi){var n=e[0],s=e[1],r=e[2],a=e[3],o=e[4],h=e[5],l=e[6],c=(i.x-n)/l,u=(i.y-s)/l,d=(i.z-r)/l;return{x:c+h*u-o*d,y:-h*c+u+a*d,z:o*c-a*u+d}}}function gr(i){return i===Ji||i===Qi}function P1(i,t,e){if(A1(i,t)||i.datum_type===ao||t.datum_type===ao)return e;var n=i.a,s=i.es;if(i.datum_type===Tn){var r=Cl(i,!1,e);if(r!==0)return;n=ml,s=yl}var a=t.a,o=t.b,h=t.es;if(t.datum_type===Tn&&(a=ml,o=A_,h=yl),s===h&&n===a&&!gr(i.datum_type)&&!gr(t.datum_type))return e;if(e=Mu(e,s,n),gr(i.datum_type)&&(e=T1(e,i.datum_type,i.datum_params)),gr(t.datum_type)&&(e=b1(e,t.datum_type,t.datum_params)),e=wu(e,h,a,o),t.datum_type===Tn){var l=Cl(t,!0,e);if(l!==0)return}return e}function Cl(i,t,e){if(i.grids===null||i.grids.length===0)return console.log("Grid shift grids not found"),-1;var n={x:-e.x,y:e.y},s={x:Number.NaN,y:Number.NaN},r=[];t:for(var a=0;a<i.grids.length;a++){var o=i.grids[a];if(r.push(o.name),o.isNull){s=n;break}if(o.grid===null){if(o.mandatory)return console.log("Unable to find mandatory grid '"+o.name+"'"),-1;continue}for(var h=o.grid.subgrids,l=0,c=h.length;l<c;l++){var u=h[l],d=(Math.abs(u.del[1])+Math.abs(u.del[0]))/1e4,f=u.ll[0]-d,g=u.ll[1]-d,_=u.ll[0]+(u.lim[0]-1)*u.del[0]+d,m=u.ll[1]+(u.lim[1]-1)*u.del[1]+d;if(!(g>n.y||f>n.x||m<n.y||_<n.x)&&(s=L1(n,t,u),!isNaN(s.x)))break t}}return isNaN(s.x)?(console.log("Failed to find a grid shift table for location '"+-n.x*Ye+" "+n.y*Ye+" tried: '"+r+"'"),-1):(e.x=-s.x,e.y=s.y,0)}function L1(i,t,e){var n={x:Number.NaN,y:Number.NaN};if(isNaN(i.x))return n;var s={x:i.x,y:i.y};s.x-=e.ll[0],s.y-=e.ll[1],s.x=k(s.x-Math.PI)+Math.PI;var r=Il(s,e);if(t){if(isNaN(r.x))return n;r.x=s.x-r.x,r.y=s.y-r.y;var a=9,o=1e-12,h,l;do{if(l=Il(r,e),isNaN(l.x)){console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");break}h={x:s.x-(l.x+r.x),y:s.y-(l.y+r.y)},r.x+=h.x,r.y+=h.y}while(a--&&Math.abs(h.x)>o&&Math.abs(h.y)>o);if(a<0)return console.log("Inverse grid shift iterator failed to converge."),n;n.x=k(r.x+e.ll[0]),n.y=r.y+e.ll[1]}else isNaN(r.x)||(n.x=i.x+r.x,n.y=i.y+r.y);return n}function Il(i,t){var e={x:i.x/t.del[0],y:i.y/t.del[1]},n={x:Math.floor(e.x),y:Math.floor(e.y)},s={x:e.x-1*n.x,y:e.y-1*n.y},r={x:Number.NaN,y:Number.NaN},a;if(n.x<0||n.x>=t.lim[0]||n.y<0||n.y>=t.lim[1])return r;a=n.y*t.lim[0]+n.x;var o={x:t.cvs[a][0],y:t.cvs[a][1]};a++;var h={x:t.cvs[a][0],y:t.cvs[a][1]};a+=t.lim[0];var l={x:t.cvs[a][0],y:t.cvs[a][1]};a--;var c={x:t.cvs[a][0],y:t.cvs[a][1]},u=s.x*s.y,d=s.x*(1-s.y),f=(1-s.x)*(1-s.y),g=(1-s.x)*s.y;return r.x=f*o.x+d*h.x+g*c.x+u*l.x,r.y=f*o.y+d*h.y+g*c.y+u*l.y,r}function Rl(i,t,e){var n=e.x,s=e.y,r=e.z||0,a,o,h,l={};for(h=0;h<3;h++)if(!(t&&h===2&&e.z===void 0))switch(h===0?(a=n,"ew".indexOf(i.axis[h])!==-1?o="x":o="y"):h===1?(a=s,"ns".indexOf(i.axis[h])!==-1?o="y":o="x"):(a=r,o="z"),i.axis[h]){case"e":l[o]=a;break;case"w":l[o]=-a;break;case"n":l[o]=a;break;case"s":l[o]=-a;break;case"u":e[o]!==void 0&&(l.z=a);break;case"d":e[o]!==void 0&&(l.z=-a);break;default:return null}return l}function Su(i){var t={x:i[0],y:i[1]};return i.length>2&&(t.z=i[2]),i.length>3&&(t.m=i[3]),t}function G1(i){Al(i.x),Al(i.y)}function Al(i){if(typeof Number.isFinite=="function"){if(Number.isFinite(i))return;throw new TypeError("coordinates must be finite numbers")}if(typeof i!="number"||i!==i||!isFinite(i))throw new TypeError("coordinates must be finite numbers")}function O1(i,t){return(i.datum.datum_type===Ji||i.datum.datum_type===Qi||i.datum.datum_type===Tn)&&t.datumCode!=="WGS84"||(t.datum.datum_type===Ji||t.datum.datum_type===Qi||t.datum.datum_type===Tn)&&i.datumCode!=="WGS84"}function Fr(i,t,e,n){var s;Array.isArray(e)?e=Su(e):e={x:e.x,y:e.y,z:e.z,m:e.m};var r=e.z!==void 0;if(G1(e),i.datum&&t.datum&&O1(i,t)&&(s=new Ke("WGS84"),e=Fr(i,s,e,n),i=s),n&&i.axis!=="enu"&&(e=Rl(i,!1,e)),i.projName==="longlat")e={x:e.x*Ct,y:e.y*Ct,z:e.z||0};else if(i.to_meter&&(e={x:e.x*i.to_meter,y:e.y*i.to_meter,z:e.z||0}),e=i.inverse(e),!e)return;if(i.from_greenwich&&(e.x+=i.from_greenwich),e=P1(i.datum,t.datum,e),!!e)return t.from_greenwich&&(e={x:e.x-t.from_greenwich,y:e.y,z:e.z||0}),t.projName==="longlat"?e={x:e.x*Ye,y:e.y*Ye,z:e.z||0}:(e=t.forward(e),t.to_meter&&(e={x:e.x/t.to_meter,y:e.y/t.to_meter,z:e.z||0})),n&&t.axis!=="enu"?Rl(t,!0,e):(e&&!r&&delete e.z,e)}var Tl=Ke("WGS84");function Da(i,t,e,n){var s,r,a;return Array.isArray(e)?(s=Fr(i,t,e,n)||{x:NaN,y:NaN},e.length>2?typeof i.name<"u"&&i.name==="geocent"||typeof t.name<"u"&&t.name==="geocent"?typeof s.z=="number"?[s.x,s.y,s.z].concat(e.slice(3)):[s.x,s.y,e[2]].concat(e.slice(3)):[s.x,s.y].concat(e.slice(2)):[s.x,s.y]):(r=Fr(i,t,e,n),a=Object.keys(e),a.length===2||a.forEach(function(o){if(typeof i.name<"u"&&i.name==="geocent"||typeof t.name<"u"&&t.name==="geocent"){if(o==="x"||o==="y"||o==="z")return}else if(o==="x"||o==="y")return;r[o]=e[o]}),r)}function bl(i){return i instanceof Ke?i:i.oProj?i.oProj:Ke(i)}function ge(i,t,e){i=bl(i);var n=!1,s;return typeof t>"u"?(t=i,i=Tl,n=!0):(typeof t.x<"u"||Array.isArray(t))&&(e=t,t=i,i=Tl,n=!0),t=bl(t),e?Da(i,t,e):(s={forward:function(r,a){return Da(i,t,r,a)},inverse:function(r,a){return Da(t,i,r,a)}},n&&(s.oProj=t),s)}var Pl=6,Cu="AJSAJS",Iu="AFAFAF",Sn=65,ae=73,we=79,hs=86,ls=90;const D1={forward:Ru,inverse:N1,toPoint:Au};function Ru(i,t){return t=t||5,z1(F1({lat:i[1],lon:i[0]}),t)}function N1(i){var t=Ho(bu(i.toUpperCase()));return t.lat&&t.lon?[t.lon,t.lat,t.lon,t.lat]:[t.left,t.bottom,t.right,t.top]}function Au(i){var t=Ho(bu(i.toUpperCase()));return t.lat&&t.lon?[t.lon,t.lat]:[(t.left+t.right)/2,(t.top+t.bottom)/2]}function Na(i){return i*(Math.PI/180)}function Ll(i){return 180*(i/Math.PI)}function F1(i){var t=i.lat,e=i.lon,n=6378137,s=.00669438,r=.9996,a,o,h,l,c,u,d,f=Na(t),g=Na(e),_,m;m=Math.floor((e+180)/6)+1,e===180&&(m=60),t>=56&&t<64&&e>=3&&e<12&&(m=32),t>=72&&t<84&&(e>=0&&e<9?m=31:e>=9&&e<21?m=33:e>=21&&e<33?m=35:e>=33&&e<42&&(m=37)),a=(m-1)*6-180+3,_=Na(a),o=s/(1-s),h=n/Math.sqrt(1-s*Math.sin(f)*Math.sin(f)),l=Math.tan(f)*Math.tan(f),c=o*Math.cos(f)*Math.cos(f),u=Math.cos(f)*(g-_),d=n*((1-s/4-3*s*s/64-5*s*s*s/256)*f-(3*s/8+3*s*s/32+45*s*s*s/1024)*Math.sin(2*f)+(15*s*s/256+45*s*s*s/1024)*Math.sin(4*f)-35*s*s*s/3072*Math.sin(6*f));var y=r*h*(u+(1-l+c)*u*u*u/6+(5-18*l+l*l+72*c-58*o)*u*u*u*u*u/120)+5e5,p=r*(d+h*Math.tan(f)*(u*u/2+(5-l+9*c+4*c*c)*u*u*u*u/24+(61-58*l+l*l+600*c-330*o)*u*u*u*u*u*u/720));return t<0&&(p+=1e7),{northing:Math.round(p),easting:Math.round(y),zoneNumber:m,zoneLetter:k1(t)}}function Ho(i){var t=i.northing,e=i.easting,n=i.zoneLetter,s=i.zoneNumber;if(s<0||s>60)return null;var r=.9996,a=6378137,o=.00669438,h,l=(1-Math.sqrt(1-o))/(1+Math.sqrt(1-o)),c,u,d,f,g,_,m,y,p,x=e-5e5,v=t;n<"N"&&(v-=1e7),m=(s-1)*6-180+3,h=o/(1-o),_=v/r,y=_/(a*(1-o/4-3*o*o/64-5*o*o*o/256)),p=y+(3*l/2-27*l*l*l/32)*Math.sin(2*y)+(21*l*l/16-55*l*l*l*l/32)*Math.sin(4*y)+151*l*l*l/96*Math.sin(6*y),c=a/Math.sqrt(1-o*Math.sin(p)*Math.sin(p)),u=Math.tan(p)*Math.tan(p),d=h*Math.cos(p)*Math.cos(p),f=a*(1-o)/Math.pow(1-o*Math.sin(p)*Math.sin(p),1.5),g=x/(c*r);var M=p-c*Math.tan(p)/f*(g*g/2-(5+3*u+10*d-4*d*d-9*h)*g*g*g*g/24+(61+90*u+298*d+45*u*u-252*h-3*d*d)*g*g*g*g*g*g/720);M=Ll(M);var C=(g-(1+2*u+d)*g*g*g/6+(5-2*d+28*u-3*d*d+8*h+24*u*u)*g*g*g*g*g/120)/Math.cos(p);C=m+Ll(C);var P;if(i.accuracy){var b=Ho({northing:i.northing+i.accuracy,easting:i.easting+i.accuracy,zoneLetter:i.zoneLetter,zoneNumber:i.zoneNumber});P={top:b.lat,right:b.lon,bottom:M,left:C}}else P={lat:M,lon:C};return P}function k1(i){var t="Z";return 84>=i&&i>=72?t="X":72>i&&i>=64?t="W":64>i&&i>=56?t="V":56>i&&i>=48?t="U":48>i&&i>=40?t="T":40>i&&i>=32?t="S":32>i&&i>=24?t="R":24>i&&i>=16?t="Q":16>i&&i>=8?t="P":8>i&&i>=0?t="N":0>i&&i>=-8?t="M":-8>i&&i>=-16?t="L":-16>i&&i>=-24?t="K":-24>i&&i>=-32?t="J":-32>i&&i>=-40?t="H":-40>i&&i>=-48?t="G":-48>i&&i>=-56?t="F":-56>i&&i>=-64?t="E":-64>i&&i>=-72?t="D":-72>i&&i>=-80&&(t="C"),t}function z1(i,t){var e="00000"+i.easting,n="00000"+i.northing;return i.zoneNumber+i.zoneLetter+U1(i.easting,i.northing,i.zoneNumber)+e.substr(e.length-5,t)+n.substr(n.length-5,t)}function U1(i,t,e){var n=Tu(e),s=Math.floor(i/1e5),r=Math.floor(t/1e5)%20;return W1(s,r,n)}function Tu(i){var t=i%Pl;return t===0&&(t=Pl),t}function W1(i,t,e){var n=e-1,s=Cu.charCodeAt(n),r=Iu.charCodeAt(n),a=s+i-1,o=r+t,h=!1;a>ls&&(a=a-ls+Sn-1,h=!0),(a===ae||s<ae&&a>ae||(a>ae||s<ae)&&h)&&a++,(a===we||s<we&&a>we||(a>we||s<we)&&h)&&(a++,a===ae&&a++),a>ls&&(a=a-ls+Sn-1),o>hs?(o=o-hs+Sn-1,h=!0):h=!1,(o===ae||r<ae&&o>ae||(o>ae||r<ae)&&h)&&o++,(o===we||r<we&&o>we||(o>we||r<we)&&h)&&(o++,o===ae&&o++),o>hs&&(o=o-hs+Sn-1);var l=String.fromCharCode(a)+String.fromCharCode(o);return l}function bu(i){if(i&&i.length===0)throw"MGRSPoint coverting from nothing";for(var t=i.length,e=null,n="",s,r=0;!/[A-Z]/.test(s=i.charAt(r));){if(r>=2)throw"MGRSPoint bad conversion from: "+i;n+=s,r++}var a=parseInt(n,10);if(r===0||r+3>t)throw"MGRSPoint bad conversion from: "+i;var o=i.charAt(r++);if(o<="A"||o==="B"||o==="Y"||o>="Z"||o==="I"||o==="O")throw"MGRSPoint zone letter "+o+" not handled: "+i;e=i.substring(r,r+=2);for(var h=Tu(a),l=B1(e.charAt(0),h),c=X1(e.charAt(1),h);c<q1(o);)c+=2e6;var u=t-r;if(u%2!==0)throw`MGRSPoint has to have an even number 
of digits after the zone letter and two 100km letters - front 
half for easting meters, second half for 
northing meters`+i;var d=u/2,f=0,g=0,_,m,y,p,x;return d>0&&(_=1e5/Math.pow(10,d),m=i.substring(r,r+d),f=parseFloat(m)*_,y=i.substring(r+d),g=parseFloat(y)*_),p=f+l,x=g+c,{easting:p,northing:x,zoneLetter:o,zoneNumber:a,accuracy:_}}function B1(i,t){for(var e=Cu.charCodeAt(t-1),n=1e5,s=!1;e!==i.charCodeAt(0);){if(e++,e===ae&&e++,e===we&&e++,e>ls){if(s)throw"Bad character: "+i;e=Sn,s=!0}n+=1e5}return n}function X1(i,t){if(i>"V")throw"MGRSPoint given invalid Northing "+i;for(var e=Iu.charCodeAt(t-1),n=0,s=!1;e!==i.charCodeAt(0);){if(e++,e===ae&&e++,e===we&&e++,e>hs){if(s)throw"Bad character: "+i;e=Sn,s=!0}n+=1e5}return n}function q1(i){var t;switch(i){case"C":t=11e5;break;case"D":t=2e6;break;case"E":t=28e5;break;case"F":t=37e5;break;case"G":t=46e5;break;case"H":t=55e5;break;case"J":t=64e5;break;case"K":t=73e5;break;case"L":t=82e5;break;case"M":t=91e5;break;case"N":t=0;break;case"P":t=8e5;break;case"Q":t=17e5;break;case"R":t=26e5;break;case"S":t=35e5;break;case"T":t=44e5;break;case"U":t=53e5;break;case"V":t=62e5;break;case"W":t=7e6;break;case"X":t=79e5;break;default:t=-1}if(t>=0)return t;throw"Invalid zone letter: "+i}function Wn(i,t,e){if(!(this instanceof Wn))return new Wn(i,t,e);if(Array.isArray(i))this.x=i[0],this.y=i[1],this.z=i[2]||0;else if(typeof i=="object")this.x=i.x,this.y=i.y,this.z=i.z||0;else if(typeof i=="string"&&typeof t>"u"){var n=i.split(",");this.x=parseFloat(n[0],10),this.y=parseFloat(n[1],10),this.z=parseFloat(n[2],10)||0}else this.x=i,this.y=t,this.z=e||0;console.warn("proj4.Point will be removed in version 3, use proj4.toPoint")}Wn.fromMGRS=function(i){return new Wn(Au(i))};Wn.prototype.toMGRS=function(i){return Ru([this.x,this.y],i)};var j1=1,Y1=.25,Gl=.046875,Ol=.01953125,Dl=.01068115234375,K1=.75,V1=.46875,Z1=.013020833333333334,$1=.007120768229166667,H1=.3645833333333333,J1=.005696614583333333,Q1=.3076171875;function Jo(i){var t=[];t[0]=j1-i*(Y1+i*(Gl+i*(Ol+i*Dl))),t[1]=i*(K1-i*(Gl+i*(Ol+i*Dl)));var e=i*i;return t[2]=e*(V1-i*(Z1+i*$1)),e*=i,t[3]=e*(H1-i*J1),t[4]=e*i*Q1,t}function Kn(i,t,e,n){return e*=t,t*=t,n[0]*i-e*(n[1]+t*(n[2]+t*(n[3]+t*n[4])))}var tm=20;function Qo(i,t,e){for(var n=1/(1-t),s=i,r=tm;r;--r){var a=Math.sin(s),o=1-t*a*a;if(o=(Kn(s,a,Math.cos(s),e)-i)*(o*Math.sqrt(o))*n,s-=o,Math.abs(o)<F)return s}return s}function em(){this.x0=this.x0!==void 0?this.x0:0,this.y0=this.y0!==void 0?this.y0:0,this.long0=this.long0!==void 0?this.long0:0,this.lat0=this.lat0!==void 0?this.lat0:0,this.es&&(this.en=Jo(this.es),this.ml0=Kn(this.lat0,Math.sin(this.lat0),Math.cos(this.lat0),this.en))}function im(i){var t=i.x,e=i.y,n=k(t-this.long0),s,r,a,o=Math.sin(e),h=Math.cos(e);if(this.es){var c=h*n,u=Math.pow(c,2),d=this.ep2*Math.pow(h,2),f=Math.pow(d,2),g=Math.abs(h)>F?Math.tan(e):0,_=Math.pow(g,2),m=Math.pow(_,2);s=1-this.es*Math.pow(o,2),c=c/Math.sqrt(s);var y=Kn(e,o,h,this.en);r=this.a*(this.k0*c*(1+u/6*(1-_+d+u/20*(5-18*_+m+14*d-58*_*d+u/42*(61+179*m-m*_-479*_)))))+this.x0,a=this.a*(this.k0*(y-this.ml0+o*n*c/2*(1+u/12*(5-_+9*d+4*f+u/30*(61+m-58*_+270*d-330*_*d+u/56*(1385+543*m-m*_-3111*_))))))+this.y0}else{var l=h*Math.sin(n);if(Math.abs(Math.abs(l)-1)<F)return 93;if(r=.5*this.a*this.k0*Math.log((1+l)/(1-l))+this.x0,a=h*Math.cos(n)/Math.sqrt(1-Math.pow(l,2)),l=Math.abs(a),l>=1){if(l-1>F)return 93;a=0}else a=Math.acos(a);e<0&&(a=-a),a=this.a*this.k0*(a-this.lat0)+this.y0}return i.x=r,i.y=a,i}function nm(i){var t,e,n,s,r=(i.x-this.x0)*(1/this.a),a=(i.y-this.y0)*(1/this.a);if(this.es)if(t=this.ml0+a/this.k0,e=Qo(t,this.es,this.en),Math.abs(e)<G){var u=Math.sin(e),d=Math.cos(e),f=Math.abs(d)>F?Math.tan(e):0,g=this.ep2*Math.pow(d,2),_=Math.pow(g,2),m=Math.pow(f,2),y=Math.pow(m,2);t=1-this.es*Math.pow(u,2);var p=r*Math.sqrt(t)/this.k0,x=Math.pow(p,2);t=t*f,n=e-t*x/(1-this.es)*.5*(1-x/12*(5+3*m-9*g*m+g-4*_-x/30*(61+90*m-252*g*m+45*y+46*g-x/56*(1385+3633*m+4095*y+1574*y*m)))),s=k(this.long0+p*(1-x/6*(1+2*m+g-x/20*(5+28*m+24*y+8*g*m+6*g-x/42*(61+662*m+1320*y+720*y*m))))/d)}else n=G*$s(a),s=0;else{var o=Math.exp(r/this.k0),h=.5*(o-1/o),l=this.lat0+a/this.k0,c=Math.cos(l);t=Math.sqrt((1-Math.pow(c,2))/(1+Math.pow(h,2))),n=Math.asin(t),a<0&&(n=-n),h===0&&c===0?s=0:s=k(Math.atan2(h,c)+this.long0)}return i.x=s,i.y=n,i}var sm=["Fast_Transverse_Mercator","Fast Transverse Mercator"];const vr={init:em,forward:im,inverse:nm,names:sm};function Pu(i){var t=Math.exp(i);return t=(t-1/t)/2,t}function ue(i,t){i=Math.abs(i),t=Math.abs(t);var e=Math.max(i,t),n=Math.min(i,t)/(e||1);return e*Math.sqrt(1+Math.pow(n,2))}function rm(i){var t=1+i,e=t-1;return e===0?i:i*Math.log(t)/e}function am(i){var t=Math.abs(i);return t=rm(t*(1+t/(ue(1,t)+1))),i<0?-t:t}function th(i,t){for(var e=2*Math.cos(2*t),n=i.length-1,s=i[n],r=0,a;--n>=0;)a=-r+e*s+i[n],r=s,s=a;return t+a*Math.sin(2*t)}function om(i,t){for(var e=2*Math.cos(t),n=i.length-1,s=i[n],r=0,a;--n>=0;)a=-r+e*s+i[n],r=s,s=a;return Math.sin(t)*a}function hm(i){var t=Math.exp(i);return t=(t+1/t)/2,t}function Lu(i,t,e){for(var n=Math.sin(t),s=Math.cos(t),r=Pu(e),a=hm(e),o=2*s*a,h=-2*n*r,l=i.length-1,c=i[l],u=0,d=0,f=0,g,_;--l>=0;)g=d,_=u,d=c,u=f,c=-g+o*d-h*u+i[l],f=-_+h*d+o*u;return o=n*a,h=s*r,[o*c-h*f,o*f+h*c]}function lm(){if(!this.approx&&(isNaN(this.es)||this.es<=0))throw new Error('Incorrect elliptical usage. Try using the +approx option in the proj string, or PROJECTION["Fast_Transverse_Mercator"] in the WKT.');this.approx&&(vr.init.apply(this),this.forward=vr.forward,this.inverse=vr.inverse),this.x0=this.x0!==void 0?this.x0:0,this.y0=this.y0!==void 0?this.y0:0,this.long0=this.long0!==void 0?this.long0:0,this.lat0=this.lat0!==void 0?this.lat0:0,this.cgb=[],this.cbg=[],this.utg=[],this.gtu=[];var i=this.es/(1+Math.sqrt(1-this.es)),t=i/(2-i),e=t;this.cgb[0]=t*(2+t*(-2/3+t*(-2+t*(116/45+t*(26/45+t*(-2854/675)))))),this.cbg[0]=t*(-2+t*(2/3+t*(4/3+t*(-82/45+t*(32/45+t*(4642/4725)))))),e=e*t,this.cgb[1]=e*(7/3+t*(-8/5+t*(-227/45+t*(2704/315+t*(2323/945))))),this.cbg[1]=e*(5/3+t*(-16/15+t*(-13/9+t*(904/315+t*(-1522/945))))),e=e*t,this.cgb[2]=e*(56/15+t*(-136/35+t*(-1262/105+t*(73814/2835)))),this.cbg[2]=e*(-26/15+t*(34/21+t*(8/5+t*(-12686/2835)))),e=e*t,this.cgb[3]=e*(4279/630+t*(-332/35+t*(-399572/14175))),this.cbg[3]=e*(1237/630+t*(-12/5+t*(-24832/14175))),e=e*t,this.cgb[4]=e*(4174/315+t*(-144838/6237)),this.cbg[4]=e*(-734/315+t*(109598/31185)),e=e*t,this.cgb[5]=e*(601676/22275),this.cbg[5]=e*(444337/155925),e=Math.pow(t,2),this.Qn=this.k0/(1+t)*(1+e*(1/4+e*(1/64+e/256))),this.utg[0]=t*(-.5+t*(2/3+t*(-37/96+t*(1/360+t*(81/512+t*(-96199/604800)))))),this.gtu[0]=t*(.5+t*(-2/3+t*(5/16+t*(41/180+t*(-127/288+t*(7891/37800)))))),this.utg[1]=e*(-1/48+t*(-1/15+t*(437/1440+t*(-46/105+t*(1118711/3870720))))),this.gtu[1]=e*(13/48+t*(-3/5+t*(557/1440+t*(281/630+t*(-1983433/1935360))))),e=e*t,this.utg[2]=e*(-17/480+t*(37/840+t*(209/4480+t*(-5569/90720)))),this.gtu[2]=e*(61/240+t*(-103/140+t*(15061/26880+t*(167603/181440)))),e=e*t,this.utg[3]=e*(-4397/161280+t*(11/504+t*(830251/7257600))),this.gtu[3]=e*(49561/161280+t*(-179/168+t*(6601661/7257600))),e=e*t,this.utg[4]=e*(-4583/161280+t*(108847/3991680)),this.gtu[4]=e*(34729/80640+t*(-3418889/1995840)),e=e*t,this.utg[5]=e*(-20648693/638668800),this.gtu[5]=e*(212378941/319334400);var n=th(this.cbg,this.lat0);this.Zb=-this.Qn*(n+om(this.gtu,2*n))}function cm(i){var t=k(i.x-this.long0),e=i.y;e=th(this.cbg,e);var n=Math.sin(e),s=Math.cos(e),r=Math.sin(t),a=Math.cos(t);e=Math.atan2(n,a*s),t=Math.atan2(r*s,ue(n,s*a)),t=am(Math.tan(t));var o=Lu(this.gtu,2*e,2*t);e=e+o[0],t=t+o[1];var h,l;return Math.abs(t)<=2.623395162778?(h=this.a*(this.Qn*t)+this.x0,l=this.a*(this.Qn*e+this.Zb)+this.y0):(h=1/0,l=1/0),i.x=h,i.y=l,i}function um(i){var t=(i.x-this.x0)*(1/this.a),e=(i.y-this.y0)*(1/this.a);e=(e-this.Zb)/this.Qn,t=t/this.Qn;var n,s;if(Math.abs(t)<=2.623395162778){var r=Lu(this.utg,2*e,2*t);e=e+r[0],t=t+r[1],t=Math.atan(Pu(t));var a=Math.sin(e),o=Math.cos(e),h=Math.sin(t),l=Math.cos(t);e=Math.atan2(a*l,ue(h,l*o)),t=Math.atan2(h,l*o),n=k(t+this.long0),s=th(this.cgb,e)}else n=1/0,s=1/0;return i.x=n,i.y=s,i}var dm=["Extended_Transverse_Mercator","Extended Transverse Mercator","etmerc","Transverse_Mercator","Transverse Mercator","Gauss Kruger","Gauss_Kruger","tmerc"];const xr={init:lm,forward:cm,inverse:um,names:dm};function fm(i,t){if(i===void 0){if(i=Math.floor((k(t)+Math.PI)*30/Math.PI)+1,i<0)return 0;if(i>60)return 60}return i}var gm="etmerc";function _m(){var i=fm(this.zone,this.long0);if(i===void 0)throw new Error("unknown utm zone");this.lat0=0,this.long0=(6*Math.abs(i)-183)*Ct,this.x0=5e5,this.y0=this.utmSouth?1e7:0,this.k0=.9996,xr.init.apply(this),this.forward=xr.forward,this.inverse=xr.inverse}var mm=["Universal Transverse Mercator System","utm"];const ym={init:_m,names:mm,dependsOn:gm};function eh(i,t){return Math.pow((1-i)/(1+i),t)}var pm=20;function Em(){var i=Math.sin(this.lat0),t=Math.cos(this.lat0);t*=t,this.rc=Math.sqrt(1-this.es)/(1-this.es*i*i),this.C=Math.sqrt(1+this.es*t*t/(1-this.es)),this.phic0=Math.asin(i/this.C),this.ratexp=.5*this.C*this.e,this.K=Math.tan(.5*this.phic0+Mt)/(Math.pow(Math.tan(.5*this.lat0+Mt),this.C)*eh(this.e*i,this.ratexp))}function vm(i){var t=i.x,e=i.y;return i.y=2*Math.atan(this.K*Math.pow(Math.tan(.5*e+Mt),this.C)*eh(this.e*Math.sin(e),this.ratexp))-G,i.x=this.C*t,i}function xm(i){for(var t=1e-14,e=i.x/this.C,n=i.y,s=Math.pow(Math.tan(.5*n+Mt)/this.K,1/this.C),r=pm;r>0&&(n=2*Math.atan(s*eh(this.e*Math.sin(i.y),-.5*this.e))-G,!(Math.abs(n-i.y)<t));--r)i.y=n;return r?(i.x=e,i.y=n,i):null}const ih={init:Em,forward:vm,inverse:xm};function Mm(){ih.init.apply(this),this.rc&&(this.sinc0=Math.sin(this.phic0),this.cosc0=Math.cos(this.phic0),this.R2=2*this.rc,this.title||(this.title="Oblique Stereographic Alternative"))}function wm(i){var t,e,n,s;return i.x=k(i.x-this.long0),ih.forward.apply(this,[i]),t=Math.sin(i.y),e=Math.cos(i.y),n=Math.cos(i.x),s=this.k0*this.R2/(1+this.sinc0*t+this.cosc0*e*n),i.x=s*e*Math.sin(i.x),i.y=s*(this.cosc0*t-this.sinc0*e*n),i.x=this.a*i.x+this.x0,i.y=this.a*i.y+this.y0,i}function Sm(i){var t,e,n,s,r;if(i.x=(i.x-this.x0)/this.a,i.y=(i.y-this.y0)/this.a,i.x/=this.k0,i.y/=this.k0,r=ue(i.x,i.y)){var a=2*Math.atan2(r,this.R2);t=Math.sin(a),e=Math.cos(a),s=Math.asin(e*this.sinc0+i.y*t*this.cosc0/r),n=Math.atan2(i.x*t,r*this.cosc0*e-i.y*this.sinc0*t)}else s=this.phic0,n=0;return i.x=n,i.y=s,ih.inverse.apply(this,[i]),i.x=k(i.x+this.long0),i}var Cm=["Stereographic_North_Pole","Oblique_Stereographic","sterea","Oblique Stereographic Alternative","Double_Stereographic"];const Im={init:Mm,forward:wm,inverse:Sm,names:Cm};function Rm(i,t,e){return t*=e,Math.tan(.5*(G+i))*Math.pow((1-t)/(1+t),.5*e)}function Am(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.coslat0=Math.cos(this.lat0),this.sinlat0=Math.sin(this.lat0),this.sphere?this.k0===1&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=F&&(this.k0=.5*(1+$s(this.lat0)*Math.sin(this.lat_ts))):(Math.abs(this.coslat0)<=F&&(this.lat0>0?this.con=1:this.con=-1),this.cons=Math.sqrt(Math.pow(1+this.e,1+this.e)*Math.pow(1-this.e,1-this.e)),this.k0===1&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=F&&Math.abs(Math.cos(this.lat_ts))>F&&(this.k0=.5*this.cons*$e(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts))/ze(this.e,this.con*this.lat_ts,this.con*Math.sin(this.lat_ts))),this.ms1=$e(this.e,this.sinlat0,this.coslat0),this.X0=2*Math.atan(this.ssfn_(this.lat0,this.sinlat0,this.e))-G,this.cosX0=Math.cos(this.X0),this.sinX0=Math.sin(this.X0))}function Tm(i){var t=i.x,e=i.y,n=Math.sin(e),s=Math.cos(e),r,a,o,h,l,c,u=k(t-this.long0);return Math.abs(Math.abs(t-this.long0)-Math.PI)<=F&&Math.abs(e+this.lat0)<=F?(i.x=NaN,i.y=NaN,i):this.sphere?(r=2*this.k0/(1+this.sinlat0*n+this.coslat0*s*Math.cos(u)),i.x=this.a*r*s*Math.sin(u)+this.x0,i.y=this.a*r*(this.coslat0*n-this.sinlat0*s*Math.cos(u))+this.y0,i):(a=2*Math.atan(this.ssfn_(e,n,this.e))-G,h=Math.cos(a),o=Math.sin(a),Math.abs(this.coslat0)<=F?(l=ze(this.e,e*this.con,this.con*n),c=2*this.a*this.k0*l/this.cons,i.x=this.x0+c*Math.sin(t-this.long0),i.y=this.y0-this.con*c*Math.cos(t-this.long0),i):(Math.abs(this.sinlat0)<F?(r=2*this.a*this.k0/(1+h*Math.cos(u)),i.y=r*o):(r=2*this.a*this.k0*this.ms1/(this.cosX0*(1+this.sinX0*o+this.cosX0*h*Math.cos(u))),i.y=r*(this.cosX0*o-this.sinX0*h*Math.cos(u))+this.y0),i.x=r*h*Math.sin(u)+this.x0,i))}function bm(i){i.x-=this.x0,i.y-=this.y0;var t,e,n,s,r,a=Math.sqrt(i.x*i.x+i.y*i.y);if(this.sphere){var o=2*Math.atan(a/(2*this.a*this.k0));return t=this.long0,e=this.lat0,a<=F?(i.x=t,i.y=e,i):(e=Math.asin(Math.cos(o)*this.sinlat0+i.y*Math.sin(o)*this.coslat0/a),Math.abs(this.coslat0)<F?this.lat0>0?t=k(this.long0+Math.atan2(i.x,-1*i.y)):t=k(this.long0+Math.atan2(i.x,i.y)):t=k(this.long0+Math.atan2(i.x*Math.sin(o),a*this.coslat0*Math.cos(o)-i.y*this.sinlat0*Math.sin(o))),i.x=t,i.y=e,i)}else if(Math.abs(this.coslat0)<=F){if(a<=F)return e=this.lat0,t=this.long0,i.x=t,i.y=e,i;i.x*=this.con,i.y*=this.con,n=a*this.cons/(2*this.a*this.k0),e=this.con*Ls(this.e,n),t=this.con*k(this.con*this.long0+Math.atan2(i.x,-1*i.y))}else s=2*Math.atan(a*this.cosX0/(2*this.a*this.k0*this.ms1)),t=this.long0,a<=F?r=this.X0:(r=Math.asin(Math.cos(s)*this.sinX0+i.y*Math.sin(s)*this.cosX0/a),t=k(this.long0+Math.atan2(i.x*Math.sin(s),a*this.cosX0*Math.cos(s)-i.y*this.sinX0*Math.sin(s)))),e=-1*Ls(this.e,Math.tan(.5*(G+r)));return i.x=t,i.y=e,i}var Pm=["stere","Stereographic_South_Pole","Polar_Stereographic_variant_A","Polar_Stereographic_variant_B","Polar_Stereographic"];const Lm={init:Am,forward:Tm,inverse:bm,names:Pm,ssfn_:Rm};function Gm(){var i=this.lat0;this.lambda0=this.long0;var t=Math.sin(i),e=this.a,n=this.rf,s=1/n,r=2*s-Math.pow(s,2),a=this.e=Math.sqrt(r);this.R=this.k0*e*Math.sqrt(1-r)/(1-r*Math.pow(t,2)),this.alpha=Math.sqrt(1+r/(1-r)*Math.pow(Math.cos(i),4)),this.b0=Math.asin(t/this.alpha);var o=Math.log(Math.tan(Math.PI/4+this.b0/2)),h=Math.log(Math.tan(Math.PI/4+i/2)),l=Math.log((1+a*t)/(1-a*t));this.K=o-this.alpha*h+this.alpha*a/2*l}function Om(i){var t=Math.log(Math.tan(Math.PI/4-i.y/2)),e=this.e/2*Math.log((1+this.e*Math.sin(i.y))/(1-this.e*Math.sin(i.y))),n=-this.alpha*(t+e)+this.K,s=2*(Math.atan(Math.exp(n))-Math.PI/4),r=this.alpha*(i.x-this.lambda0),a=Math.atan(Math.sin(r)/(Math.sin(this.b0)*Math.tan(s)+Math.cos(this.b0)*Math.cos(r))),o=Math.asin(Math.cos(this.b0)*Math.sin(s)-Math.sin(this.b0)*Math.cos(s)*Math.cos(r));return i.y=this.R/2*Math.log((1+Math.sin(o))/(1-Math.sin(o)))+this.y0,i.x=this.R*a+this.x0,i}function Dm(i){for(var t=i.x-this.x0,e=i.y-this.y0,n=t/this.R,s=2*(Math.atan(Math.exp(e/this.R))-Math.PI/4),r=Math.asin(Math.cos(this.b0)*Math.sin(s)+Math.sin(this.b0)*Math.cos(s)*Math.cos(n)),a=Math.atan(Math.sin(n)/(Math.cos(this.b0)*Math.cos(n)-Math.sin(this.b0)*Math.tan(s))),o=this.lambda0+a/this.alpha,h=0,l=r,c=-1e3,u=0;Math.abs(l-c)>1e-7;){if(++u>20)return;h=1/this.alpha*(Math.log(Math.tan(Math.PI/4+r/2))-this.K)+this.e*Math.log(Math.tan(Math.PI/4+Math.asin(this.e*Math.sin(l))/2)),c=l,l=2*Math.atan(Math.exp(h))-Math.PI/2}return i.x=o,i.y=l,i}var Nm=["somerc"];const Fm={init:Gm,forward:Om,inverse:Dm,names:Nm};var pn=1e-7;function km(i){var t=["Hotine_Oblique_Mercator","Hotine_Oblique_Mercator_variant_A","Hotine_Oblique_Mercator_Azimuth_Natural_Origin"],e=typeof i.projName=="object"?Object.keys(i.projName)[0]:i.projName;return"no_uoff"in i||"no_off"in i||t.indexOf(e)!==-1||t.indexOf(vu(e))!==-1}function zm(){var i,t,e,n,s,r,a,o,h,l,c=0,u,d=0,f=0,g=0,_=0,m=0,y=0;this.no_off=km(this),this.no_rot="no_rot"in this;var p=!1;"alpha"in this&&(p=!0);var x=!1;if("rectified_grid_angle"in this&&(x=!0),p&&(y=this.alpha),x&&(c=this.rectified_grid_angle),p||x)d=this.longc;else if(f=this.long1,_=this.lat1,g=this.long2,m=this.lat2,Math.abs(_-m)<=pn||(i=Math.abs(_))<=pn||Math.abs(i-G)<=pn||Math.abs(Math.abs(this.lat0)-G)<=pn||Math.abs(Math.abs(m)-G)<=pn)throw new Error;var v=1-this.es;t=Math.sqrt(v),Math.abs(this.lat0)>F?(o=Math.sin(this.lat0),e=Math.cos(this.lat0),i=1-this.es*o*o,this.B=e*e,this.B=Math.sqrt(1+this.es*this.B*this.B/v),this.A=this.B*this.k0*t/i,n=this.B*t/(e*Math.sqrt(i)),s=n*n-1,s<=0?s=0:(s=Math.sqrt(s),this.lat0<0&&(s=-s)),this.E=s+=n,this.E*=Math.pow(ze(this.e,this.lat0,o),this.B)):(this.B=1/t,this.A=this.k0,this.E=n=s=1),p||x?(p?(u=Math.asin(Math.sin(y)/n),x||(c=y)):(u=c,y=Math.asin(n*Math.sin(u))),this.lam0=d-Math.asin(.5*(s-1/s)*Math.tan(u))/this.B):(r=Math.pow(ze(this.e,_,Math.sin(_)),this.B),a=Math.pow(ze(this.e,m,Math.sin(m)),this.B),s=this.E/r,h=(a-r)/(a+r),l=this.E*this.E,l=(l-a*r)/(l+a*r),i=f-g,i<-Math.pi?g-=bs:i>Math.pi&&(g+=bs),this.lam0=k(.5*(f+g)-Math.atan(l*Math.tan(.5*this.B*(f-g))/h)/this.B),u=Math.atan(2*Math.sin(this.B*k(f-this.lam0))/(s-1/s)),c=y=Math.asin(n*Math.sin(u))),this.singam=Math.sin(u),this.cosgam=Math.cos(u),this.sinrot=Math.sin(c),this.cosrot=Math.cos(c),this.rB=1/this.B,this.ArB=this.A*this.rB,this.BrA=1/this.ArB,this.no_off?this.u_0=0:(this.u_0=Math.abs(this.ArB*Math.atan(Math.sqrt(n*n-1)/Math.cos(y))),this.lat0<0&&(this.u_0=-this.u_0)),s=.5*u,this.v_pole_n=this.ArB*Math.log(Math.tan(Mt-s)),this.v_pole_s=this.ArB*Math.log(Math.tan(Mt+s))}function Um(i){var t={},e,n,s,r,a,o,h,l;if(i.x=i.x-this.lam0,Math.abs(Math.abs(i.y)-G)>F){if(a=this.E/Math.pow(ze(this.e,i.y,Math.sin(i.y)),this.B),o=1/a,e=.5*(a-o),n=.5*(a+o),r=Math.sin(this.B*i.x),s=(e*this.singam-r*this.cosgam)/n,Math.abs(Math.abs(s)-1)<F)throw new Error;l=.5*this.ArB*Math.log((1-s)/(1+s)),o=Math.cos(this.B*i.x),Math.abs(o)<pn?h=this.A*i.x:h=this.ArB*Math.atan2(e*this.cosgam+r*this.singam,o)}else l=i.y>0?this.v_pole_n:this.v_pole_s,h=this.ArB*i.y;return this.no_rot?(t.x=h,t.y=l):(h-=this.u_0,t.x=l*this.cosrot+h*this.sinrot,t.y=h*this.cosrot-l*this.sinrot),t.x=this.a*t.x+this.x0,t.y=this.a*t.y+this.y0,t}function Wm(i){var t,e,n,s,r,a,o,h={};if(i.x=(i.x-this.x0)*(1/this.a),i.y=(i.y-this.y0)*(1/this.a),this.no_rot?(e=i.y,t=i.x):(e=i.x*this.cosrot-i.y*this.sinrot,t=i.y*this.cosrot+i.x*this.sinrot+this.u_0),n=Math.exp(-this.BrA*e),s=.5*(n-1/n),r=.5*(n+1/n),a=Math.sin(this.BrA*t),o=(a*this.cosgam+s*this.singam)/r,Math.abs(Math.abs(o)-1)<F)h.x=0,h.y=o<0?-G:G;else{if(h.y=this.E/Math.sqrt((1+o)/(1-o)),h.y=Ls(this.e,Math.pow(h.y,1/this.B)),h.y===1/0)throw new Error;h.x=-this.rB*Math.atan2(s*this.cosgam-a*this.singam,Math.cos(this.BrA*t))}return h.x+=this.lam0,h}var Bm=["Hotine_Oblique_Mercator","Hotine Oblique Mercator","Hotine_Oblique_Mercator_variant_A","Hotine_Oblique_Mercator_Variant_B","Hotine_Oblique_Mercator_Azimuth_Natural_Origin","Hotine_Oblique_Mercator_Two_Point_Natural_Origin","Hotine_Oblique_Mercator_Azimuth_Center","Oblique_Mercator","omerc"];const Xm={init:zm,forward:Um,inverse:Wm,names:Bm};function qm(){if(this.lat2||(this.lat2=this.lat1),this.k0||(this.k0=1),this.x0=this.x0||0,this.y0=this.y0||0,!(Math.abs(this.lat1+this.lat2)<F)){var i=this.b/this.a;this.e=Math.sqrt(1-i*i);var t=Math.sin(this.lat1),e=Math.cos(this.lat1),n=$e(this.e,t,e),s=ze(this.e,this.lat1,t),r=Math.sin(this.lat2),a=Math.cos(this.lat2),o=$e(this.e,r,a),h=ze(this.e,this.lat2,r),l=Math.abs(Math.abs(this.lat0)-G)<F?0:ze(this.e,this.lat0,Math.sin(this.lat0));Math.abs(this.lat1-this.lat2)>F?this.ns=Math.log(n/o)/Math.log(s/h):this.ns=t,isNaN(this.ns)&&(this.ns=t),this.f0=n/(this.ns*Math.pow(s,this.ns)),this.rh=this.a*this.f0*Math.pow(l,this.ns),this.title||(this.title="Lambert Conformal Conic")}}function jm(i){var t=i.x,e=i.y;Math.abs(2*Math.abs(e)-Math.PI)<=F&&(e=$s(e)*(G-2*F));var n=Math.abs(Math.abs(e)-G),s,r;if(n>F)s=ze(this.e,e,Math.sin(e)),r=this.a*this.f0*Math.pow(s,this.ns);else{if(n=e*this.ns,n<=0)return null;r=0}var a=this.ns*k(t-this.long0);return i.x=this.k0*(r*Math.sin(a))+this.x0,i.y=this.k0*(this.rh-r*Math.cos(a))+this.y0,i}function Ym(i){var t,e,n,s,r,a=(i.x-this.x0)/this.k0,o=this.rh-(i.y-this.y0)/this.k0;this.ns>0?(t=Math.sqrt(a*a+o*o),e=1):(t=-Math.sqrt(a*a+o*o),e=-1);var h=0;if(t!==0&&(h=Math.atan2(e*a,e*o)),t!==0||this.ns>0){if(e=1/this.ns,n=Math.pow(t/(this.a*this.f0),e),s=Ls(this.e,n),s===-9999)return null}else s=-G;return r=k(h/this.ns+this.long0),i.x=r,i.y=s,i}var Km=["Lambert Tangential Conformal Conic Projection","Lambert_Conformal_Conic","Lambert_Conformal_Conic_1SP","Lambert_Conformal_Conic_2SP","lcc","Lambert Conic Conformal (1SP)","Lambert Conic Conformal (2SP)"];const Vm={init:qm,forward:jm,inverse:Ym,names:Km};function Zm(){this.a=6377397155e-3,this.es=.006674372230614,this.e=Math.sqrt(this.es),this.lat0||(this.lat0=.863937979737193),this.long0||(this.long0=.7417649320975901-.308341501185665),this.k0||(this.k0=.9999),this.s45=.785398163397448,this.s90=2*this.s45,this.fi0=this.lat0,this.e2=this.es,this.e=Math.sqrt(this.e2),this.alfa=Math.sqrt(1+this.e2*Math.pow(Math.cos(this.fi0),4)/(1-this.e2)),this.uq=1.04216856380474,this.u0=Math.asin(Math.sin(this.fi0)/this.alfa),this.g=Math.pow((1+this.e*Math.sin(this.fi0))/(1-this.e*Math.sin(this.fi0)),this.alfa*this.e/2),this.k=Math.tan(this.u0/2+this.s45)/Math.pow(Math.tan(this.fi0/2+this.s45),this.alfa)*this.g,this.k1=this.k0,this.n0=this.a*Math.sqrt(1-this.e2)/(1-this.e2*Math.pow(Math.sin(this.fi0),2)),this.s0=1.37008346281555,this.n=Math.sin(this.s0),this.ro0=this.k1*this.n0/Math.tan(this.s0),this.ad=this.s90-this.uq}function $m(i){var t,e,n,s,r,a,o,h=i.x,l=i.y,c=k(h-this.long0);return t=Math.pow((1+this.e*Math.sin(l))/(1-this.e*Math.sin(l)),this.alfa*this.e/2),e=2*(Math.atan(this.k*Math.pow(Math.tan(l/2+this.s45),this.alfa)/t)-this.s45),n=-c*this.alfa,s=Math.asin(Math.cos(this.ad)*Math.sin(e)+Math.sin(this.ad)*Math.cos(e)*Math.cos(n)),r=Math.asin(Math.cos(e)*Math.sin(n)/Math.cos(s)),a=this.n*r,o=this.ro0*Math.pow(Math.tan(this.s0/2+this.s45),this.n)/Math.pow(Math.tan(s/2+this.s45),this.n),i.y=o*Math.cos(a)/1,i.x=o*Math.sin(a)/1,this.czech||(i.y*=-1,i.x*=-1),i}function Hm(i){var t,e,n,s,r,a,o,h,l=i.x;i.x=i.y,i.y=l,this.czech||(i.y*=-1,i.x*=-1),a=Math.sqrt(i.x*i.x+i.y*i.y),r=Math.atan2(i.y,i.x),s=r/Math.sin(this.s0),n=2*(Math.atan(Math.pow(this.ro0/a,1/this.n)*Math.tan(this.s0/2+this.s45))-this.s45),t=Math.asin(Math.cos(this.ad)*Math.sin(n)-Math.sin(this.ad)*Math.cos(n)*Math.cos(s)),e=Math.asin(Math.cos(n)*Math.sin(s)/Math.cos(t)),i.x=this.long0-e/this.alfa,o=t,h=0;var c=0;do i.y=2*(Math.atan(Math.pow(this.k,-1/this.alfa)*Math.pow(Math.tan(t/2+this.s45),1/this.alfa)*Math.pow((1+this.e*Math.sin(o))/(1-this.e*Math.sin(o)),this.e/2))-this.s45),Math.abs(o-i.y)<1e-10&&(h=1),o=i.y,c+=1;while(h===0&&c<15);return c>=15?null:i}var Jm=["Krovak","krovak"];const Qm={init:Zm,forward:$m,inverse:Hm,names:Jm};function se(i,t,e,n,s){return i*s-t*Math.sin(2*s)+e*Math.sin(4*s)-n*Math.sin(6*s)}function Hs(i){return 1-.25*i*(1+i/16*(3+1.25*i))}function Js(i){return .375*i*(1+.25*i*(1+.46875*i))}function Qs(i){return .05859375*i*i*(1+.75*i)}function tr(i){return i*i*i*(35/3072)}function nh(i,t,e){var n=t*e;return i/Math.sqrt(1-n*n)}function Gi(i){return Math.abs(i)<G?i:i-$s(i)*Math.PI}function kr(i,t,e,n,s){var r,a;r=i/t;for(var o=0;o<15;o++)if(a=(i-(t*r-e*Math.sin(2*r)+n*Math.sin(4*r)-s*Math.sin(6*r)))/(t-2*e*Math.cos(2*r)+4*n*Math.cos(4*r)-6*s*Math.cos(6*r)),r+=a,Math.abs(a)<=1e-10)return r;return NaN}function ty(){this.sphere||(this.e0=Hs(this.es),this.e1=Js(this.es),this.e2=Qs(this.es),this.e3=tr(this.es),this.ml0=this.a*se(this.e0,this.e1,this.e2,this.e3,this.lat0))}function ey(i){var t,e,n=i.x,s=i.y;if(n=k(n-this.long0),this.sphere)t=this.a*Math.asin(Math.cos(s)*Math.sin(n)),e=this.a*(Math.atan2(Math.tan(s),Math.cos(n))-this.lat0);else{var r=Math.sin(s),a=Math.cos(s),o=nh(this.a,this.e,r),h=Math.tan(s)*Math.tan(s),l=n*Math.cos(s),c=l*l,u=this.es*a*a/(1-this.es),d=this.a*se(this.e0,this.e1,this.e2,this.e3,s);t=o*l*(1-c*h*(1/6-(8-h+8*u)*c/120)),e=d-this.ml0+o*r/a*c*(.5+(5-h+6*u)*c/24)}return i.x=t+this.x0,i.y=e+this.y0,i}function iy(i){i.x-=this.x0,i.y-=this.y0;var t=i.x/this.a,e=i.y/this.a,n,s;if(this.sphere){var r=e+this.lat0;n=Math.asin(Math.sin(r)*Math.cos(t)),s=Math.atan2(Math.tan(t),Math.cos(r))}else{var a=this.ml0/this.a+e,o=kr(a,this.e0,this.e1,this.e2,this.e3);if(Math.abs(Math.abs(o)-G)<=F)return i.x=this.long0,i.y=G,e<0&&(i.y*=-1),i;var h=nh(this.a,this.e,Math.sin(o)),l=h*h*h/this.a/this.a*(1-this.es),c=Math.pow(Math.tan(o),2),u=t*this.a/h,d=u*u;n=o-h*Math.tan(o)/l*u*u*(.5-(1+3*c)*u*u/24),s=u*(1-d*(c/3+(1+3*c)*c*d/15))/Math.cos(o)}return i.x=k(s+this.long0),i.y=Gi(n),i}var ny=["Cassini","Cassini_Soldner","cass"];const sy={init:ty,forward:ey,inverse:iy,names:ny};function Ti(i,t){var e;return i>1e-7?(e=i*t,(1-i*i)*(t/(1-e*e)-.5/i*Math.log((1-e)/(1+e)))):2*t}var ry=1,ay=2,oy=3,hy=4;function ly(){var i=Math.abs(this.lat0);if(Math.abs(i-G)<F?this.mode=this.lat0<0?this.S_POLE:this.N_POLE:Math.abs(i)<F?this.mode=this.EQUIT:this.mode=this.OBLIQ,this.es>0){var t;switch(this.qp=Ti(this.e,1),this.mmf=.5/(1-this.es),this.apa=py(this.es),this.mode){case this.N_POLE:this.dd=1;break;case this.S_POLE:this.dd=1;break;case this.EQUIT:this.rq=Math.sqrt(.5*this.qp),this.dd=1/this.rq,this.xmf=1,this.ymf=.5*this.qp;break;case this.OBLIQ:this.rq=Math.sqrt(.5*this.qp),t=Math.sin(this.lat0),this.sinb1=Ti(this.e,t)/this.qp,this.cosb1=Math.sqrt(1-this.sinb1*this.sinb1),this.dd=Math.cos(this.lat0)/(Math.sqrt(1-this.es*t*t)*this.rq*this.cosb1),this.ymf=(this.xmf=this.rq)/this.dd,this.xmf*=this.dd;break}}else this.mode===this.OBLIQ&&(this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0))}function cy(i){var t,e,n,s,r,a,o,h,l,c,u=i.x,d=i.y;if(u=k(u-this.long0),this.sphere){if(r=Math.sin(d),c=Math.cos(d),n=Math.cos(u),this.mode===this.OBLIQ||this.mode===this.EQUIT){if(e=this.mode===this.EQUIT?1+c*n:1+this.sinph0*r+this.cosph0*c*n,e<=F)return null;e=Math.sqrt(2/e),t=e*c*Math.sin(u),e*=this.mode===this.EQUIT?r:this.cosph0*r-this.sinph0*c*n}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(this.mode===this.N_POLE&&(n=-n),Math.abs(d+this.lat0)<F)return null;e=Mt-d*.5,e=2*(this.mode===this.S_POLE?Math.cos(e):Math.sin(e)),t=e*Math.sin(u),e*=n}}else{switch(o=0,h=0,l=0,n=Math.cos(u),s=Math.sin(u),r=Math.sin(d),a=Ti(this.e,r),(this.mode===this.OBLIQ||this.mode===this.EQUIT)&&(o=a/this.qp,h=Math.sqrt(1-o*o)),this.mode){case this.OBLIQ:l=1+this.sinb1*o+this.cosb1*h*n;break;case this.EQUIT:l=1+h*n;break;case this.N_POLE:l=G+d,a=this.qp-a;break;case this.S_POLE:l=d-G,a=this.qp+a;break}if(Math.abs(l)<F)return null;switch(this.mode){case this.OBLIQ:case this.EQUIT:l=Math.sqrt(2/l),this.mode===this.OBLIQ?e=this.ymf*l*(this.cosb1*o-this.sinb1*h*n):e=(l=Math.sqrt(2/(1+h*n)))*o*this.ymf,t=this.xmf*l*h*s;break;case this.N_POLE:case this.S_POLE:a>=0?(t=(l=Math.sqrt(a))*s,e=n*(this.mode===this.S_POLE?l:-l)):t=e=0;break}}return i.x=this.a*t+this.x0,i.y=this.a*e+this.y0,i}function uy(i){i.x-=this.x0,i.y-=this.y0;var t=i.x/this.a,e=i.y/this.a,n,s,r,a,o,h,l;if(this.sphere){var c=0,u,d=0;if(u=Math.sqrt(t*t+e*e),s=u*.5,s>1)return null;switch(s=2*Math.asin(s),(this.mode===this.OBLIQ||this.mode===this.EQUIT)&&(d=Math.sin(s),c=Math.cos(s)),this.mode){case this.EQUIT:s=Math.abs(u)<=F?0:Math.asin(e*d/u),t*=d,e=c*u;break;case this.OBLIQ:s=Math.abs(u)<=F?this.lat0:Math.asin(c*this.sinph0+e*d*this.cosph0/u),t*=d*this.cosph0,e=(c-Math.sin(s)*this.sinph0)*u;break;case this.N_POLE:e=-e,s=G-s;break;case this.S_POLE:s-=G;break}n=e===0&&(this.mode===this.EQUIT||this.mode===this.OBLIQ)?0:Math.atan2(t,e)}else{if(l=0,this.mode===this.OBLIQ||this.mode===this.EQUIT){if(t/=this.dd,e*=this.dd,h=Math.sqrt(t*t+e*e),h<F)return i.x=this.long0,i.y=this.lat0,i;a=2*Math.asin(.5*h/this.rq),r=Math.cos(a),t*=a=Math.sin(a),this.mode===this.OBLIQ?(l=r*this.sinb1+e*a*this.cosb1/h,o=this.qp*l,e=h*this.cosb1*r-e*this.sinb1*a):(l=e*a/h,o=this.qp*l,e=h*r)}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(this.mode===this.N_POLE&&(e=-e),o=t*t+e*e,!o)return i.x=this.long0,i.y=this.lat0,i;l=1-o/this.qp,this.mode===this.S_POLE&&(l=-l)}n=Math.atan2(t,e),s=Ey(Math.asin(l),this.apa)}return i.x=k(this.long0+n),i.y=s,i}var dy=.3333333333333333,fy=.17222222222222222,gy=.10257936507936508,_y=.06388888888888888,my=.0664021164021164,yy=.016415012942191543;function py(i){var t,e=[];return e[0]=i*dy,t=i*i,e[0]+=t*fy,e[1]=t*_y,t*=i,e[0]+=t*gy,e[1]+=t*my,e[2]=t*yy,e}function Ey(i,t){var e=i+i;return i+t[0]*Math.sin(e)+t[1]*Math.sin(e+e)+t[2]*Math.sin(e+e+e)}var vy=["Lambert Azimuthal Equal Area","Lambert_Azimuthal_Equal_Area","laea"];const xy={init:ly,forward:cy,inverse:uy,names:vy,S_POLE:ry,N_POLE:ay,EQUIT:oy,OBLIQ:hy};function Pi(i){return Math.abs(i)>1&&(i=i>1?1:-1),Math.asin(i)}function My(){Math.abs(this.lat1+this.lat2)<F||(this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e3=Math.sqrt(this.es),this.sin_po=Math.sin(this.lat1),this.cos_po=Math.cos(this.lat1),this.t1=this.sin_po,this.con=this.sin_po,this.ms1=$e(this.e3,this.sin_po,this.cos_po),this.qs1=Ti(this.e3,this.sin_po),this.sin_po=Math.sin(this.lat2),this.cos_po=Math.cos(this.lat2),this.t2=this.sin_po,this.ms2=$e(this.e3,this.sin_po,this.cos_po),this.qs2=Ti(this.e3,this.sin_po),this.sin_po=Math.sin(this.lat0),this.cos_po=Math.cos(this.lat0),this.t3=this.sin_po,this.qs0=Ti(this.e3,this.sin_po),Math.abs(this.lat1-this.lat2)>F?this.ns0=(this.ms1*this.ms1-this.ms2*this.ms2)/(this.qs2-this.qs1):this.ns0=this.con,this.c=this.ms1*this.ms1+this.ns0*this.qs1,this.rh=this.a*Math.sqrt(this.c-this.ns0*this.qs0)/this.ns0)}function wy(i){var t=i.x,e=i.y;this.sin_phi=Math.sin(e),this.cos_phi=Math.cos(e);var n=Ti(this.e3,this.sin_phi),s=this.a*Math.sqrt(this.c-this.ns0*n)/this.ns0,r=this.ns0*k(t-this.long0),a=s*Math.sin(r)+this.x0,o=this.rh-s*Math.cos(r)+this.y0;return i.x=a,i.y=o,i}function Sy(i){var t,e,n,s,r,a;return i.x-=this.x0,i.y=this.rh-i.y+this.y0,this.ns0>=0?(t=Math.sqrt(i.x*i.x+i.y*i.y),n=1):(t=-Math.sqrt(i.x*i.x+i.y*i.y),n=-1),s=0,t!==0&&(s=Math.atan2(n*i.x,n*i.y)),n=t*this.ns0/this.a,this.sphere?a=Math.asin((this.c-n*n)/(2*this.ns0)):(e=(this.c-n*n)/this.ns0,a=this.phi1z(this.e3,e)),r=k(s/this.ns0+this.long0),i.x=r,i.y=a,i}function Cy(i,t){var e,n,s,r,a,o=Pi(.5*t);if(i<F)return o;for(var h=i*i,l=1;l<=25;l++)if(e=Math.sin(o),n=Math.cos(o),s=i*e,r=1-s*s,a=.5*r*r/n*(t/(1-h)-e/r+.5/i*Math.log((1-s)/(1+s))),o=o+a,Math.abs(a)<=1e-7)return o;return null}var Iy=["Albers_Conic_Equal_Area","Albers_Equal_Area","Albers","aea"];const Ry={init:My,forward:wy,inverse:Sy,names:Iy,phi1z:Cy};function Ay(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0),this.infinity_dist=1e3*this.a,this.rc=1}function Ty(i){var t,e,n,s,r,a,o,h,l=i.x,c=i.y;return n=k(l-this.long0),t=Math.sin(c),e=Math.cos(c),s=Math.cos(n),a=this.sin_p14*t+this.cos_p14*e*s,r=1,a>0||Math.abs(a)<=F?(o=this.x0+this.a*r*e*Math.sin(n)/a,h=this.y0+this.a*r*(this.cos_p14*t-this.sin_p14*e*s)/a):(o=this.x0+this.infinity_dist*e*Math.sin(n),h=this.y0+this.infinity_dist*(this.cos_p14*t-this.sin_p14*e*s)),i.x=o,i.y=h,i}function by(i){var t,e,n,s,r,a;return i.x=(i.x-this.x0)/this.a,i.y=(i.y-this.y0)/this.a,i.x/=this.k0,i.y/=this.k0,(t=Math.sqrt(i.x*i.x+i.y*i.y))?(s=Math.atan2(t,this.rc),e=Math.sin(s),n=Math.cos(s),a=Pi(n*this.sin_p14+i.y*e*this.cos_p14/t),r=Math.atan2(i.x*e,t*this.cos_p14*n-i.y*this.sin_p14*e),r=k(this.long0+r)):(a=this.phic0,r=0),i.x=r,i.y=a,i}var Py=["gnom"];const Ly={init:Ay,forward:Ty,inverse:by,names:Py};function Gy(i,t){var e=1-(1-i*i)/(2*i)*Math.log((1-i)/(1+i));if(Math.abs(Math.abs(t)-e)<1e-6)return t<0?-1*G:G;for(var n=Math.asin(.5*t),s,r,a,o,h=0;h<30;h++)if(r=Math.sin(n),a=Math.cos(n),o=i*r,s=Math.pow(1-o*o,2)/(2*a)*(t/(1-i*i)-r/(1-o*o)+.5/i*Math.log((1-o)/(1+o))),n+=s,Math.abs(s)<=1e-10)return n;return NaN}function Oy(){this.sphere||(this.k0=$e(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)))}function Dy(i){var t=i.x,e=i.y,n,s,r=k(t-this.long0);if(this.sphere)n=this.x0+this.a*r*Math.cos(this.lat_ts),s=this.y0+this.a*Math.sin(e)/Math.cos(this.lat_ts);else{var a=Ti(this.e,Math.sin(e));n=this.x0+this.a*this.k0*r,s=this.y0+this.a*a*.5/this.k0}return i.x=n,i.y=s,i}function Ny(i){i.x-=this.x0,i.y-=this.y0;var t,e;return this.sphere?(t=k(this.long0+i.x/this.a/Math.cos(this.lat_ts)),e=Math.asin(i.y/this.a*Math.cos(this.lat_ts))):(e=Gy(this.e,2*i.y*this.k0/this.a),t=k(this.long0+i.x/(this.a*this.k0))),i.x=t,i.y=e,i}var Fy=["cea"];const ky={init:Oy,forward:Dy,inverse:Ny,names:Fy};function zy(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Equidistant Cylindrical (Plate Carre)",this.rc=Math.cos(this.lat_ts)}function Uy(i){var t=i.x,e=i.y,n=k(t-this.long0),s=Gi(e-this.lat0);return i.x=this.x0+this.a*n*this.rc,i.y=this.y0+this.a*s,i}function Wy(i){var t=i.x,e=i.y;return i.x=k(this.long0+(t-this.x0)/(this.a*this.rc)),i.y=Gi(this.lat0+(e-this.y0)/this.a),i}var By=["Equirectangular","Equidistant_Cylindrical","Equidistant_Cylindrical_Spherical","eqc"];const Xy={init:zy,forward:Uy,inverse:Wy,names:By};var Nl=20;function qy(){this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=Hs(this.es),this.e1=Js(this.es),this.e2=Qs(this.es),this.e3=tr(this.es),this.ml0=this.a*se(this.e0,this.e1,this.e2,this.e3,this.lat0)}function jy(i){var t=i.x,e=i.y,n,s,r,a=k(t-this.long0);if(r=a*Math.sin(e),this.sphere)Math.abs(e)<=F?(n=this.a*a,s=-1*this.a*this.lat0):(n=this.a*Math.sin(r)/Math.tan(e),s=this.a*(Gi(e-this.lat0)+(1-Math.cos(r))/Math.tan(e)));else if(Math.abs(e)<=F)n=this.a*a,s=-1*this.ml0;else{var o=nh(this.a,this.e,Math.sin(e))/Math.tan(e);n=o*Math.sin(r),s=this.a*se(this.e0,this.e1,this.e2,this.e3,e)-this.ml0+o*(1-Math.cos(r))}return i.x=n+this.x0,i.y=s+this.y0,i}function Yy(i){var t,e,n,s,r,a,o,h,l;if(n=i.x-this.x0,s=i.y-this.y0,this.sphere)if(Math.abs(s+this.a*this.lat0)<=F)t=k(n/this.a+this.long0),e=0;else{a=this.lat0+s/this.a,o=n*n/this.a/this.a+a*a,h=a;var c;for(r=Nl;r;--r)if(c=Math.tan(h),l=-1*(a*(h*c+1)-h-.5*(h*h+o)*c)/((h-a)/c-1),h+=l,Math.abs(l)<=F){e=h;break}t=k(this.long0+Math.asin(n*Math.tan(h)/this.a)/Math.sin(e))}else if(Math.abs(s+this.ml0)<=F)e=0,t=k(this.long0+n/this.a);else{a=(this.ml0+s)/this.a,o=n*n/this.a/this.a+a*a,h=a;var u,d,f,g,_;for(r=Nl;r;--r)if(_=this.e*Math.sin(h),u=Math.sqrt(1-_*_)*Math.tan(h),d=this.a*se(this.e0,this.e1,this.e2,this.e3,h),f=this.e0-2*this.e1*Math.cos(2*h)+4*this.e2*Math.cos(4*h)-6*this.e3*Math.cos(6*h),g=d/this.a,l=(a*(u*g+1)-g-.5*u*(g*g+o))/(this.es*Math.sin(2*h)*(g*g+o-2*a*g)/(4*u)+(a-g)*(u*f-2/Math.sin(2*h))-f),h-=l,Math.abs(l)<=F){e=h;break}u=Math.sqrt(1-this.es*Math.pow(Math.sin(e),2))*Math.tan(e),t=k(this.long0+Math.asin(n*u/this.a)/Math.sin(e))}return i.x=t,i.y=e,i}var Ky=["Polyconic","American_Polyconic","poly"];const Vy={init:qy,forward:jy,inverse:Yy,names:Ky};function Zy(){this.A=[],this.A[1]=.6399175073,this.A[2]=-.1358797613,this.A[3]=.063294409,this.A[4]=-.02526853,this.A[5]=.0117879,this.A[6]=-.0055161,this.A[7]=.0026906,this.A[8]=-.001333,this.A[9]=67e-5,this.A[10]=-34e-5,this.B_re=[],this.B_im=[],this.B_re[1]=.7557853228,this.B_im[1]=0,this.B_re[2]=.249204646,this.B_im[2]=.003371507,this.B_re[3]=-.001541739,this.B_im[3]=.04105856,this.B_re[4]=-.10162907,this.B_im[4]=.01727609,this.B_re[5]=-.26623489,this.B_im[5]=-.36249218,this.B_re[6]=-.6870983,this.B_im[6]=-1.1651967,this.C_re=[],this.C_im=[],this.C_re[1]=1.3231270439,this.C_im[1]=0,this.C_re[2]=-.577245789,this.C_im[2]=-.007809598,this.C_re[3]=.508307513,this.C_im[3]=-.112208952,this.C_re[4]=-.15094762,this.C_im[4]=.18200602,this.C_re[5]=1.01418179,this.C_im[5]=1.64497696,this.C_re[6]=1.9660549,this.C_im[6]=2.5127645,this.D=[],this.D[1]=1.5627014243,this.D[2]=.5185406398,this.D[3]=-.03333098,this.D[4]=-.1052906,this.D[5]=-.0368594,this.D[6]=.007317,this.D[7]=.0122,this.D[8]=.00394,this.D[9]=-.0013}function $y(i){var t,e=i.x,n=i.y,s=n-this.lat0,r=e-this.long0,a=s/gs*1e-5,o=r,h=1,l=0;for(t=1;t<=10;t++)h=h*a,l=l+this.A[t]*h;var c=l,u=o,d=1,f=0,g,_,m=0,y=0;for(t=1;t<=6;t++)g=d*c-f*u,_=f*c+d*u,d=g,f=_,m=m+this.B_re[t]*d-this.B_im[t]*f,y=y+this.B_im[t]*d+this.B_re[t]*f;return i.x=y*this.a+this.x0,i.y=m*this.a+this.y0,i}function Hy(i){var t,e=i.x,n=i.y,s=e-this.x0,r=n-this.y0,a=r/this.a,o=s/this.a,h=1,l=0,c,u,d=0,f=0;for(t=1;t<=6;t++)c=h*a-l*o,u=l*a+h*o,h=c,l=u,d=d+this.C_re[t]*h-this.C_im[t]*l,f=f+this.C_im[t]*h+this.C_re[t]*l;for(var g=0;g<this.iterations;g++){var _=d,m=f,y,p,x=a,v=o;for(t=2;t<=6;t++)y=_*d-m*f,p=m*d+_*f,_=y,m=p,x=x+(t-1)*(this.B_re[t]*_-this.B_im[t]*m),v=v+(t-1)*(this.B_im[t]*_+this.B_re[t]*m);_=1,m=0;var M=this.B_re[1],C=this.B_im[1];for(t=2;t<=6;t++)y=_*d-m*f,p=m*d+_*f,_=y,m=p,M=M+t*(this.B_re[t]*_-this.B_im[t]*m),C=C+t*(this.B_im[t]*_+this.B_re[t]*m);var P=M*M+C*C;d=(x*M+v*C)/P,f=(v*M-x*C)/P}var b=d,L=f,N=1,B=0;for(t=1;t<=9;t++)N=N*b,B=B+this.D[t]*N;var U=this.lat0+B*gs*1e5,z=this.long0+L;return i.x=z,i.y=U,i}var Jy=["New_Zealand_Map_Grid","nzmg"];const Qy={init:Zy,forward:$y,inverse:Hy,names:Jy};function tp(){}function ep(i){var t=i.x,e=i.y,n=k(t-this.long0),s=this.x0+this.a*n,r=this.y0+this.a*Math.log(Math.tan(Math.PI/4+e/2.5))*1.25;return i.x=s,i.y=r,i}function ip(i){i.x-=this.x0,i.y-=this.y0;var t=k(this.long0+i.x/this.a),e=2.5*(Math.atan(Math.exp(.8*i.y/this.a))-Math.PI/4);return i.x=t,i.y=e,i}var np=["Miller_Cylindrical","mill"];const sp={init:tp,forward:ep,inverse:ip,names:np};var rp=20;function ap(){this.sphere?(this.n=1,this.m=0,this.es=0,this.C_y=Math.sqrt((this.m+1)/this.n),this.C_x=this.C_y/(this.m+1)):this.en=Jo(this.es)}function op(i){var t,e,n=i.x,s=i.y;if(n=k(n-this.long0),this.sphere){if(!this.m)s=this.n!==1?Math.asin(this.n*Math.sin(s)):s;else for(var r=this.n*Math.sin(s),a=rp;a;--a){var o=(this.m*s+Math.sin(s)-r)/(this.m+Math.cos(s));if(s-=o,Math.abs(o)<F)break}t=this.a*this.C_x*n*(this.m+Math.cos(s)),e=this.a*this.C_y*s}else{var h=Math.sin(s),l=Math.cos(s);e=this.a*Kn(s,h,l,this.en),t=this.a*n*l/Math.sqrt(1-this.es*h*h)}return i.x=t,i.y=e,i}function hp(i){var t,e,n,s;return i.x-=this.x0,n=i.x/this.a,i.y-=this.y0,t=i.y/this.a,this.sphere?(t/=this.C_y,n=n/(this.C_x*(this.m+Math.cos(t))),this.m?t=Pi((this.m*t+Math.sin(t))/this.n):this.n!==1&&(t=Pi(Math.sin(t)/this.n)),n=k(n+this.long0),t=Gi(t)):(t=Qo(i.y/this.a,this.es,this.en),s=Math.abs(t),s<G?(s=Math.sin(t),e=this.long0+i.x*Math.sqrt(1-this.es*s*s)/(this.a*Math.cos(t)),n=k(e)):s-F<G&&(n=this.long0)),i.x=n,i.y=t,i}var lp=["Sinusoidal","sinu"];const cp={init:ap,forward:op,inverse:hp,names:lp};function up(){}function dp(i){for(var t=i.x,e=i.y,n=k(t-this.long0),s=e,r=Math.PI*Math.sin(e);;){var a=-(s+Math.sin(s)-r)/(1+Math.cos(s));if(s+=a,Math.abs(a)<F)break}s/=2,Math.PI/2-Math.abs(e)<F&&(n=0);var o=.900316316158*this.a*n*Math.cos(s)+this.x0,h=1.4142135623731*this.a*Math.sin(s)+this.y0;return i.x=o,i.y=h,i}function fp(i){var t,e;i.x-=this.x0,i.y-=this.y0,e=i.y/(1.4142135623731*this.a),Math.abs(e)>.999999999999&&(e=.999999999999),t=Math.asin(e);var n=k(this.long0+i.x/(.900316316158*this.a*Math.cos(t)));n<-Math.PI&&(n=-Math.PI),n>Math.PI&&(n=Math.PI),e=(2*t+Math.sin(2*t))/Math.PI,Math.abs(e)>1&&(e=1);var s=Math.asin(e);return i.x=n,i.y=s,i}var gp=["Mollweide","moll"];const _p={init:up,forward:dp,inverse:fp,names:gp};function mp(){Math.abs(this.lat1+this.lat2)<F||(this.lat2=this.lat2||this.lat1,this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=Hs(this.es),this.e1=Js(this.es),this.e2=Qs(this.es),this.e3=tr(this.es),this.sinphi=Math.sin(this.lat1),this.cosphi=Math.cos(this.lat1),this.ms1=$e(this.e,this.sinphi,this.cosphi),this.ml1=se(this.e0,this.e1,this.e2,this.e3,this.lat1),Math.abs(this.lat1-this.lat2)<F?this.ns=this.sinphi:(this.sinphi=Math.sin(this.lat2),this.cosphi=Math.cos(this.lat2),this.ms2=$e(this.e,this.sinphi,this.cosphi),this.ml2=se(this.e0,this.e1,this.e2,this.e3,this.lat2),this.ns=(this.ms1-this.ms2)/(this.ml2-this.ml1)),this.g=this.ml1+this.ms1/this.ns,this.ml0=se(this.e0,this.e1,this.e2,this.e3,this.lat0),this.rh=this.a*(this.g-this.ml0))}function yp(i){var t=i.x,e=i.y,n;if(this.sphere)n=this.a*(this.g-e);else{var s=se(this.e0,this.e1,this.e2,this.e3,e);n=this.a*(this.g-s)}var r=this.ns*k(t-this.long0),a=this.x0+n*Math.sin(r),o=this.y0+this.rh-n*Math.cos(r);return i.x=a,i.y=o,i}function pp(i){i.x-=this.x0,i.y=this.rh-i.y+this.y0;var t,e,n,s;this.ns>=0?(e=Math.sqrt(i.x*i.x+i.y*i.y),t=1):(e=-Math.sqrt(i.x*i.x+i.y*i.y),t=-1);var r=0;if(e!==0&&(r=Math.atan2(t*i.x,t*i.y)),this.sphere)return s=k(this.long0+r/this.ns),n=Gi(this.g-e/this.a),i.x=s,i.y=n,i;var a=this.g-e/this.a;return n=kr(a,this.e0,this.e1,this.e2,this.e3),s=k(this.long0+r/this.ns),i.x=s,i.y=n,i}var Ep=["Equidistant_Conic","eqdc"];const vp={init:mp,forward:yp,inverse:pp,names:Ep};function xp(){this.R=this.a}function Mp(i){var t=i.x,e=i.y,n=k(t-this.long0),s,r;Math.abs(e)<=F&&(s=this.x0+this.R*n,r=this.y0);var a=Pi(2*Math.abs(e/Math.PI));(Math.abs(n)<=F||Math.abs(Math.abs(e)-G)<=F)&&(s=this.x0,e>=0?r=this.y0+Math.PI*this.R*Math.tan(.5*a):r=this.y0+Math.PI*this.R*-Math.tan(.5*a));var o=.5*Math.abs(Math.PI/n-n/Math.PI),h=o*o,l=Math.sin(a),c=Math.cos(a),u=c/(l+c-1),d=u*u,f=u*(2/l-1),g=f*f,_=Math.PI*this.R*(o*(u-g)+Math.sqrt(h*(u-g)*(u-g)-(g+h)*(d-g)))/(g+h);n<0&&(_=-_),s=this.x0+_;var m=h+u;return _=Math.PI*this.R*(f*m-o*Math.sqrt((g+h)*(h+1)-m*m))/(g+h),e>=0?r=this.y0+_:r=this.y0-_,i.x=s,i.y=r,i}function wp(i){var t,e,n,s,r,a,o,h,l,c,u,d,f;return i.x-=this.x0,i.y-=this.y0,u=Math.PI*this.R,n=i.x/u,s=i.y/u,r=n*n+s*s,a=-Math.abs(s)*(1+r),o=a-2*s*s+n*n,h=-2*a+1+2*s*s+r*r,f=s*s/h+(2*o*o*o/h/h/h-9*a*o/h/h)/27,l=(a-o*o/3/h)/h,c=2*Math.sqrt(-l/3),u=3*f/l/c,Math.abs(u)>1&&(u>=0?u=1:u=-1),d=Math.acos(u)/3,i.y>=0?e=(-c*Math.cos(d+Math.PI/3)-o/3/h)*Math.PI:e=-(-c*Math.cos(d+Math.PI/3)-o/3/h)*Math.PI,Math.abs(n)<F?t=this.long0:t=k(this.long0+Math.PI*(r-1+Math.sqrt(1+2*(n*n-s*s)+r*r))/2/n),i.x=t,i.y=e,i}var Sp=["Van_der_Grinten_I","VanDerGrinten","Van_der_Grinten","vandg"];const Cp={init:xp,forward:Mp,inverse:wp,names:Sp};var Fa={exports:{}},Fl;function Ip(){return Fl||(Fl=1,(function(i){(function(t){var e={};e.Constants={},e.Math={},e.Accumulator={},(function(n){n.WGS84={a:6378137,f:1/298.257223563},n.version={major:2,minor:2,patch:0},n.version_string="2.2.0"})(e.Constants),(function(n){n.digits=53,n.epsilon=Math.pow(.5,n.digits-1),n.degree=Math.PI/180,n.sq=function(s){return s*s},n.hypot=function(s,r){return Math.sqrt(s*s+r*r)},n.cbrt=Math.cbrt||function(s){var r=Math.pow(Math.abs(s),.3333333333333333);return s>0?r:s<0?-r:s},n.log1p=Math.log1p||function(s){var r=1+s,a=r-1;return a===0?s:s*Math.log(r)/a},n.atanh=Math.atanh||function(s){var r=Math.abs(s);return r=n.log1p(2*r/(1-r))/2,s>0?r:s<0?-r:s},n.copysign=function(s,r){return Math.abs(s)*(r<0||r===0&&1/r<0?-1:1)},n.sum=function(s,r){var a=s+r,o=a-r,h=a-o,l;return o-=s,h-=r,l=a&&0-(o+h),{s:a,t:l}},n.polyval=function(s,r,a,o){for(var h=s<0?0:r[a++];--s>=0;)h=h*o+r[a++];return h},n.AngRound=function(s){var r=.0625,a=Math.abs(s);return a=a<r?r-(r-a):a,n.copysign(a,s)},n.remainder=function(s,r){return s%=r,s<-r/2?s+r:s<r/2?s:s-r},n.AngNormalize=function(s){var r=n.remainder(s,360);return Math.abs(r)===180?n.copysign(180,s):r},n.LatFix=function(s){return Math.abs(s)>90?NaN:s},n.AngDiff=function(s,r){var a=n.sum(n.remainder(-s,360),n.remainder(r,360)),o,h;return a=n.sum(n.remainder(a.s,360),a.t),o=a.s,h=a.t,(o===0||Math.abs(o)===180)&&(o=n.copysign(o,h===0?r-s:-h)),{d:o,e:h}},n.sincosd=function(s){var r,a,o,h,l,c,u;switch(r=s%360,o=Math.round(r/90),r-=90*o,a=r*this.degree,h=Math.sin(a),l=Math.cos(a),Math.abs(r)===45?(l=Math.sqrt(.5),h=n.copysign(l,a)):Math.abs(r)===30&&(l=Math.sqrt(.75),h=n.copysign(.5,a)),o&3){case 0:c=h,u=l;break;case 1:c=l,u=-h;break;case 2:c=-h,u=-l;break;default:c=-l,u=h;break}return u+=0,c===0&&(c=n.copysign(c,s)),{s:c,c:u}},n.sincosde=function(s,r){var a,o,h,l,c,u,d;switch(a=s%360,h=Math.round(a/90),a=n.AngRound(a-90*h+r),o=a*this.degree,l=Math.sin(o),c=Math.cos(o),Math.abs(a)===45?(c=Math.sqrt(.5),l=n.copysign(c,o)):Math.abs(a)===30&&(c=Math.sqrt(.75),l=n.copysign(.5,o)),h&3){case 0:u=l,d=c;break;case 1:u=c,d=-l;break;case 2:u=-l,d=-c;break;default:u=-c,d=l;break}return d+=0,u===0&&(u=n.copysign(u,s+r)),{s:u,c:d}},n.atan2d=function(s,r){var a=0,o;switch(Math.abs(s)>Math.abs(r)&&([s,r]=[r,s],a=2),n.copysign(1,r)<0&&(r=-r,++a),o=Math.atan2(s,r)/this.degree,a){case 1:o=n.copysign(180,s)-o;break;case 2:o=90-o;break;case 3:o=-90+o;break}return o}})(e.Math),(function(n,s){n.Accumulator=function(r){this.Set(r)},n.Accumulator.prototype.Set=function(r){r||(r=0),r.constructor===n.Accumulator?(this._s=r._s,this._t=r._t):(this._s=r,this._t=0)},n.Accumulator.prototype.Add=function(r){var a=s.sum(r,this._t),o=s.sum(a.s,this._s);a=a.t,this._s=o.s,this._t=o.t,this._s===0?this._s=a:this._t+=a},n.Accumulator.prototype.Sum=function(r){var a;return r?(a=new n.Accumulator(this),a.Add(r),a._s):this._s},n.Accumulator.prototype.Negate=function(){this._s*=-1,this._t*=-1},n.Accumulator.prototype.Remainder=function(r){this._s=s.remainder(this._s,r),this.Add(0)}})(e.Accumulator,e.Math),e.Geodesic={},e.GeodesicLine={},e.PolygonArea={},(function(n,s,r,a,o){var h=6,l=h,c=h,u=h,d=u,f,g,_=20,m=_+a.digits+10,y=a.epsilon,p=200*y,x=Math.sqrt(y),v=y,M=1e3*x,C=0,P=31,b=32640,L,N,B,U,z,Q,X,H,W;n.tiny_=Math.sqrt(Number.MIN_VALUE/Number.EPSILON),n.nC1_=h,n.nC1p_=h,n.nC2_=h,n.nC3_=h,n.nC4_=h,f=n.nC3_*(n.nC3_-1)/2,g=n.nC4_*(n.nC4_+1)/2,n.CAP_C1=1,n.CAP_C1p=2,n.CAP_C2=4,n.CAP_C3=8,n.CAP_C4=16,n.NONE=0,n.ARC=64,n.LATITUDE=128|C,n.LONGITUDE=256|n.CAP_C3,n.AZIMUTH=512|C,n.DISTANCE=1024|n.CAP_C1,n.STANDARD=n.LATITUDE|n.LONGITUDE|n.AZIMUTH|n.DISTANCE,n.DISTANCE_IN=2048|n.CAP_C1|n.CAP_C1p,n.REDUCEDLENGTH=4096|n.CAP_C1|n.CAP_C2,n.GEODESICSCALE=8192|n.CAP_C1|n.CAP_C2,n.AREA=16384|n.CAP_C4,n.ALL=b|P,n.LONG_UNROLL=32768,n.OUT_MASK=b|n.LONG_UNROLL,n.SinCosSeries=function(w,S,R,T){var E=T.length,I=E-(w?1:0),D=2*(R-S)*(R+S),K=I&1?T[--E]:0,at=0;for(I=Math.floor(I/2);I--;)at=D*K-at+T[--E],K=D*at-K+T[--E];return w?2*S*R*K:R*(K-at)},L=function(w,S){var R,T=a.sq(w),E=a.sq(S),I=(T+E-1)/6,D,K,at,Y,ot,q,J,lt,O,nt,ht;return E===0&&I<=0?R=0:(D=T*E/4,K=a.sq(I),at=I*K,Y=D*(D+2*at),ot=I,Y>=0?(q=D+at,q+=q<0?-Math.sqrt(Y):Math.sqrt(Y),J=a.cbrt(q),ot+=J+(J!==0?K/J:0)):(lt=Math.atan2(Math.sqrt(-Y),-(D+at)),ot+=2*I*Math.cos(lt/3)),O=Math.sqrt(a.sq(ot)+E),nt=ot<0?E/(O-ot):ot+O,ht=(nt-E)/(2*O),R=nt/(Math.sqrt(nt+a.sq(ht))+ht)),R},N=[1,4,64,0,256],n.A1m1f=function(w){var S=Math.floor(l/2),R=a.polyval(S,N,0,a.sq(w))/N[S+1];return(R+w)/(1-w)},B=[-1,6,-16,32,-9,64,-128,2048,9,-16,768,3,-5,512,-7,1280,-7,2048],n.C1f=function(w,S){var R=a.sq(w),T=w,E=0,I,D;for(I=1;I<=n.nC1_;++I)D=Math.floor((n.nC1_-I)/2),S[I]=T*a.polyval(D,B,E,R)/B[E+D+1],E+=D+2,T*=w},U=[205,-432,768,1536,4005,-4736,3840,12288,-225,116,384,-7173,2695,7680,3467,7680,38081,61440],n.C1pf=function(w,S){var R=a.sq(w),T=w,E=0,I,D;for(I=1;I<=n.nC1p_;++I)D=Math.floor((n.nC1p_-I)/2),S[I]=T*a.polyval(D,U,E,R)/U[E+D+1],E+=D+2,T*=w},z=[-11,-28,-192,0,256],n.A2m1f=function(w){var S=Math.floor(c/2),R=a.polyval(S,z,0,a.sq(w))/z[S+1];return(R-w)/(1+w)},Q=[1,2,16,32,35,64,384,2048,15,80,768,7,35,512,63,1280,77,2048],n.C2f=function(w,S){var R=a.sq(w),T=w,E=0,I,D;for(I=1;I<=n.nC2_;++I)D=Math.floor((n.nC2_-I)/2),S[I]=T*a.polyval(D,Q,E,R)/Q[E+D+1],E+=D+2,T*=w},n.Geodesic=function(w,S){if(this.a=w,this.f=S,this._f1=1-this.f,this._e2=this.f*(2-this.f),this._ep2=this._e2/a.sq(this._f1),this._n=this.f/(2-this.f),this._b=this.a*this._f1,this._c2=(a.sq(this.a)+a.sq(this._b)*(this._e2===0?1:(this._e2>0?a.atanh(Math.sqrt(this._e2)):Math.atan(Math.sqrt(-this._e2)))/Math.sqrt(Math.abs(this._e2))))/2,this._etol2=.1*x/Math.sqrt(Math.max(.001,Math.abs(this.f))*Math.min(1,1-this.f/2)/2),!(isFinite(this.a)&&this.a>0))throw new Error("Equatorial radius is not positive");if(!(isFinite(this._b)&&this._b>0))throw new Error("Polar semi-axis is not positive");this._A3x=new Array(d),this._C3x=new Array(f),this._C4x=new Array(g),this.A3coeff(),this.C3coeff(),this.C4coeff()},X=[-3,128,-2,-3,64,-1,-3,-1,16,3,-1,-2,8,1,-1,2,1,1],n.Geodesic.prototype.A3coeff=function(){var w=0,S=0,R,T;for(R=u-1;R>=0;--R)T=Math.min(u-R-1,R),this._A3x[S++]=a.polyval(T,X,w,this._n)/X[w+T+1],w+=T+2},H=[3,128,2,5,128,-1,3,3,64,-1,0,1,8,-1,1,4,5,256,1,3,128,-3,-2,3,64,1,-3,2,32,7,512,-10,9,384,5,-9,5,192,7,512,-14,7,512,21,2560],n.Geodesic.prototype.C3coeff=function(){var w=0,S=0,R,T,E;for(R=1;R<n.nC3_;++R)for(T=n.nC3_-1;T>=R;--T)E=Math.min(n.nC3_-T-1,T),this._C3x[S++]=a.polyval(E,H,w,this._n)/H[w+E+1],w+=E+2},W=[97,15015,1088,156,45045,-224,-4784,1573,45045,-10656,14144,-4576,-858,45045,64,624,-4576,6864,-3003,15015,100,208,572,3432,-12012,30030,45045,1,9009,-2944,468,135135,5792,1040,-1287,135135,5952,-11648,9152,-2574,135135,-64,-624,4576,-6864,3003,135135,8,10725,1856,-936,225225,-8448,4992,-1144,225225,-1440,4160,-4576,1716,225225,-136,63063,1024,-208,105105,3584,-3328,1144,315315,-128,135135,-2560,832,405405,128,99099],n.Geodesic.prototype.C4coeff=function(){var w=0,S=0,R,T,E;for(R=0;R<n.nC4_;++R)for(T=n.nC4_-1;T>=R;--T)E=n.nC4_-T-1,this._C4x[S++]=a.polyval(E,W,w,this._n)/W[w+E+1],w+=E+2},n.Geodesic.prototype.A3f=function(w){return a.polyval(d-1,this._A3x,0,w)},n.Geodesic.prototype.C3f=function(w,S){var R=1,T=0,E,I;for(E=1;E<n.nC3_;++E)I=n.nC3_-E-1,R*=w,S[E]=R*a.polyval(I,this._C3x,T,w),T+=I+1},n.Geodesic.prototype.C4f=function(w,S){var R=1,T=0,E,I;for(E=0;E<n.nC4_;++E)I=n.nC4_-E-1,S[E]=R*a.polyval(I,this._C4x,T,w),T+=I+1,R*=w},n.Geodesic.prototype.Lengths=function(w,S,R,T,E,I,D,K,at,Y,ot,q,J){ot&=n.OUT_MASK;var lt={},O=0,nt=0,ht=0,ct=0,ut,pt,xt,It,Rt;if(ot&(n.DISTANCE|n.REDUCEDLENGTH|n.GEODESICSCALE)&&(ht=n.A1m1f(w),n.C1f(w,q),ot&(n.REDUCEDLENGTH|n.GEODESICSCALE)&&(ct=n.A2m1f(w),n.C2f(w,J),O=ht-ct,ct=1+ct),ht=1+ht),ot&n.DISTANCE)ut=n.SinCosSeries(!0,I,D,q)-n.SinCosSeries(!0,R,T,q),lt.s12b=ht*(S+ut),ot&(n.REDUCEDLENGTH|n.GEODESICSCALE)&&(pt=n.SinCosSeries(!0,I,D,J)-n.SinCosSeries(!0,R,T,J),nt=O*S+(ht*ut-ct*pt));else if(ot&(n.REDUCEDLENGTH|n.GEODESICSCALE)){for(xt=1;xt<=n.nC2_;++xt)J[xt]=ht*q[xt]-ct*J[xt];nt=O*S+(n.SinCosSeries(!0,I,D,J)-n.SinCosSeries(!0,R,T,J))}return ot&n.REDUCEDLENGTH?(lt.m0=O,lt.m12b=K*(T*I)-E*(R*D)-T*D*nt):lt.m12b=NaN,ot&n.GEODESICSCALE&&(It=T*D+R*I,Rt=this._ep2*(at-Y)*(at+Y)/(E+K),lt.M12=It+(Rt*I-D*nt)*R/E,lt.M21=It-(Rt*R-T*nt)*I/K),lt},n.Geodesic.prototype.InverseStart=function(w,S,R,T,E,I,D,K,at,Y,ot){var q={},J=T*S-E*w,lt=E*S+T*w,O,nt,ht,ct,ut,pt,xt,It,Rt,st,it,V,At,Ot,me,ye,Oi,pe,dt,Xt,qt,Zt,$t;return q.sig12=-1,O=T*S,O+=E*w,nt=lt>=0&&J<.5&&E*D<.5,nt?(ct=a.sq(w+T),ct/=ct+a.sq(S+E),q.dnm=Math.sqrt(1+this._ep2*ct),ht=D/(this._f1*q.dnm),ut=Math.sin(ht),pt=Math.cos(ht)):(ut=K,pt=at),q.salp1=E*ut,q.calp1=pt>=0?J+E*w*a.sq(ut)/(1+pt):O-E*w*a.sq(ut)/(1-pt),It=a.hypot(q.salp1,q.calp1),Rt=w*T+S*E*pt,nt&&It<this._etol2?(q.salp2=S*ut,q.calp2=J-S*T*(pt>=0?a.sq(ut)/(1+pt):1-pt),xt=a.hypot(q.salp2,q.calp2),q.salp2/=xt,q.calp2/=xt,q.sig12=Math.atan2(It,Rt)):Math.abs(this._n)>.1||Rt>=0||It>=6*Math.abs(this._n)*Math.PI*a.sq(S)||($t=Math.atan2(-K,-at),this.f>=0?(Ot=a.sq(w)*this._ep2,me=Ot/(2*(1+Math.sqrt(1+Ot))+Ot),V=this.f*S*this.A3f(me)*Math.PI,At=V*S,st=$t/V,it=O/At):(ye=E*S-T*w,Oi=Math.atan2(O,ye),Xt=this.Lengths(this._n,Math.PI+Oi,w,-S,R,T,E,I,S,E,n.REDUCEDLENGTH,Y,ot),pe=Xt.m12b,dt=Xt.m0,st=-1+pe/(S*E*dt*Math.PI),At=st<-.01?O/st:-this.f*a.sq(S)*Math.PI,V=At/S,it=D/V),it>-p&&st>-1-M?this.f>=0?(q.salp1=Math.min(1,-st),q.calp1=-Math.sqrt(1-a.sq(q.salp1))):(q.calp1=Math.max(st>-p?0:-1,st),q.salp1=Math.sqrt(1-a.sq(q.calp1))):(qt=L(st,it),Zt=V*(this.f>=0?-st*qt/(1+qt):-it*(1+qt)/qt),ut=Math.sin(Zt),pt=-Math.cos(Zt),q.salp1=E*ut,q.calp1=O-E*w*a.sq(ut)/(1-pt))),q.salp1<=0?(q.salp1=1,q.calp1=0):(xt=a.hypot(q.salp1,q.calp1),q.salp1/=xt,q.calp1/=xt),q},n.Geodesic.prototype.Lambda12=function(w,S,R,T,E,I,D,K,at,Y,ot,q,J,lt){var O={},nt,ht,ct,ut,pt,xt,It,Rt,st,it,V,At,Ot;return w===0&&K===0&&(K=-n.tiny_),ht=D*S,ct=a.hypot(K,D*w),O.ssig1=w,ut=ht*w,O.csig1=pt=K*S,nt=a.hypot(O.ssig1,O.csig1),O.ssig1/=nt,O.csig1/=nt,O.salp2=E!==S?ht/E:D,O.calp2=E!==S||Math.abs(T)!==-w?Math.sqrt(a.sq(K*S)+(S<-w?(E-S)*(S+E):(w-T)*(w+T)))/E:Math.abs(K),O.ssig2=T,xt=ht*T,O.csig2=It=O.calp2*E,nt=a.hypot(O.ssig2,O.csig2),O.ssig2/=nt,O.csig2/=nt,O.sig12=Math.atan2(Math.max(0,O.csig1*O.ssig2-O.ssig1*O.csig2),O.csig1*O.csig2+O.ssig1*O.ssig2),Rt=Math.max(0,pt*xt-ut*It),st=pt*It+ut*xt,V=Math.atan2(Rt*Y-st*at,st*Y+Rt*at),At=a.sq(ct)*this._ep2,O.eps=At/(2*(1+Math.sqrt(1+At))+At),this.C3f(O.eps,lt),it=n.SinCosSeries(!0,O.ssig2,O.csig2,lt)-n.SinCosSeries(!0,O.ssig1,O.csig1,lt),O.domg12=-this.f*this.A3f(O.eps)*ht*(O.sig12+it),O.lam12=V+O.domg12,ot&&(O.calp2===0?O.dlam12=-2*this._f1*R/w:(Ot=this.Lengths(O.eps,O.sig12,O.ssig1,O.csig1,R,O.ssig2,O.csig2,I,S,E,n.REDUCEDLENGTH,q,J),O.dlam12=Ot.m12b,O.dlam12*=this._f1/(O.calp2*E))),O},n.Geodesic.prototype.Inverse=function(w,S,R,T,E){var I,D;return E||(E=n.STANDARD),E===n.LONG_UNROLL&&(E|=n.STANDARD),E&=n.OUT_MASK,I=this.InverseInt(w,S,R,T,E),D=I.vals,E&n.AZIMUTH&&(D.azi1=a.atan2d(I.salp1,I.calp1),D.azi2=a.atan2d(I.salp2,I.calp2)),D},n.Geodesic.prototype.InverseInt=function(w,S,R,T,E){var I={},D,K,at,Y,ot,q,J,lt,O,nt,ht,ct,ut,pt,xt,It,Rt,st,it,V,At,Ot,me,ye,Oi,pe,dt,Xt,qt,Zt,$t,Di,di,Qe,ti,ei,Te,be,Pe,Ni,rn,kt,Le,Kt,re,Ht,Ee,xe,Tt,Ft,ve,an,dh,er,fh,gh,Vn,ir,Zn,ha,la,nr,sr,ca,ua;if(I.lat1=w=a.LatFix(w),I.lat2=R=a.LatFix(R),w=a.AngRound(w),R=a.AngRound(R),D=a.AngDiff(S,T),K=D.e,D=D.d,E&n.LONG_UNROLL?(I.lon1=S,I.lon2=S+D+K):(I.lon1=a.AngNormalize(S),I.lon2=a.AngNormalize(T)),at=a.copysign(1,D),D*=at,K*=at,xt=D*a.degree,Y=a.sincosde(D,K),It=Y.s,Rt=Y.c,K=180-D-K,ot=Math.abs(w)<Math.abs(R)||isNaN(R)?-1:1,ot<0&&(at*=-1,[R,w]=[w,R]),q=a.copysign(1,-w),w*=q,R*=q,Y=a.sincosd(w),J=this._f1*Y.s,lt=Y.c,Y=a.hypot(J,lt),J/=Y,lt/=Y,lt=Math.max(n.tiny_,lt),Y=a.sincosd(R),O=this._f1*Y.s,nt=Y.c,Y=a.hypot(O,nt),O/=Y,nt/=Y,nt=Math.max(n.tiny_,nt),lt<-J?nt===lt&&(O=a.copysign(J,O)):Math.abs(O)===-J&&(nt=lt),ut=Math.sqrt(1+this._ep2*a.sq(J)),pt=Math.sqrt(1+this._ep2*a.sq(O)),me=new Array(n.nC1_+1),ye=new Array(n.nC2_+1),Oi=new Array(n.nC3_),pe=w===-90||It===0,pe&&(it=Rt,V=It,At=1,Ot=0,Xt=J,qt=it*lt,Zt=O,$t=At*nt,st=Math.atan2(Math.max(0,qt*Zt-Xt*$t),qt*$t+Xt*Zt),dt=this.Lengths(this._n,st,Xt,qt,ut,Zt,$t,pt,lt,nt,E|n.DISTANCE|n.REDUCEDLENGTH,me,ye),ht=dt.s12b,ct=dt.m12b,E&n.GEODESICSCALE&&(I.M12=dt.M12,I.M21=dt.M21),st<x||ct>=0?((st<3*n.tiny_||st<y&&(ht<0||ct<0))&&(st=ct=ht=0),ct*=this._b,ht*=this._b,I.a12=st/a.degree):pe=!1),Vn=2,!pe&&J===0&&(this.f<=0||K>=this.f*180))it=At=0,V=Ot=1,ht=this.a*xt,st=di=xt/this._f1,ct=this._b*Math.sin(st),E&n.GEODESICSCALE&&(I.M12=I.M21=Math.cos(st)),I.a12=D/this._f1;else if(!pe)if(dt=this.InverseStart(J,lt,ut,O,nt,pt,xt,It,Rt,me,ye),st=dt.sig12,V=dt.salp1,it=dt.calp1,st>=0)Ot=dt.salp2,At=dt.calp2,Qe=dt.dnm,ht=st*this._b*Qe,ct=a.sq(Qe)*this._b*Math.sin(st/Qe),E&n.GEODESICSCALE&&(I.M12=I.M21=Math.cos(st/Qe)),I.a12=st/a.degree,di=xt/(this._f1*Qe);else{for(ti=0,ei=n.tiny_,Te=1,be=n.tiny_,Pe=-1,Ni=!1,rn=!1;dt=this.Lambda12(J,lt,ut,O,nt,pt,V,it,It,Rt,ti<_,me,ye,Oi),kt=dt.lam12,Ot=dt.salp2,At=dt.calp2,st=dt.sig12,Xt=dt.ssig1,qt=dt.csig1,Zt=dt.ssig2,$t=dt.csig2,Di=dt.eps,Zn=dt.domg12,Le=dt.dlam12,!(rn||!(Math.abs(kt)>=(Ni?8:1)*y)||ti==m);++ti){if(kt>0&&(ti<_||it/V>Pe/be)?(be=V,Pe=it):kt<0&&(ti<_||it/V<Te/ei)&&(ei=V,Te=it),ti<_&&Le>0&&(Kt=-kt/Le,Math.abs(Kt)<Math.PI&&(re=Math.sin(Kt),Ht=Math.cos(Kt),Ee=V*Ht+it*re,Ee>0))){it=it*Ht-V*re,V=Ee,Y=a.hypot(V,it),V/=Y,it/=Y,Ni=Math.abs(kt)<=16*y;continue}V=(ei+be)/2,it=(Te+Pe)/2,Y=a.hypot(V,it),V/=Y,it/=Y,Ni=!1,rn=Math.abs(ei-V)+(Te-it)<v||Math.abs(V-be)+(it-Pe)<v}xe=E|(E&(n.REDUCEDLENGTH|n.GEODESICSCALE)?n.DISTANCE:n.NONE),dt=this.Lengths(Di,st,Xt,qt,ut,Zt,$t,pt,lt,nt,xe,me,ye),ht=dt.s12b,ct=dt.m12b,E&n.GEODESICSCALE&&(I.M12=dt.M12,I.M21=dt.M21),ct*=this._b,ht*=this._b,I.a12=st/a.degree,E&n.AREA&&(ca=Math.sin(Zn),ua=Math.cos(Zn),Vn=It*ua-Rt*ca,ir=Rt*ua+It*ca)}return E&n.DISTANCE&&(I.s12=0+ht),E&n.REDUCEDLENGTH&&(I.m12=0+ct),E&n.AREA&&(Tt=V*lt,Ft=a.hypot(it,V*J),Ft!==0&&Tt!==0?(Xt=J,qt=it*lt,Zt=O,$t=At*nt,an=a.sq(Ft)*this._ep2,Di=an/(2*(1+Math.sqrt(1+an))+an),dh=a.sq(this.a)*Ft*Tt*this._e2,Y=a.hypot(Xt,qt),Xt/=Y,qt/=Y,Y=a.hypot(Zt,$t),Zt/=Y,$t/=Y,er=new Array(n.nC4_),this.C4f(Di,er),fh=n.SinCosSeries(!1,Xt,qt,er),gh=n.SinCosSeries(!1,Zt,$t,er),I.S12=dh*(gh-fh)):I.S12=0,!pe&&Vn==2&&(Vn=Math.sin(di),ir=Math.cos(di)),!pe&&ir>-.7071&&O-J<1.75?(Zn=1+ir,ha=1+lt,la=1+nt,ve=2*Math.atan2(Vn*(J*la+O*ha),Zn*(J*O+ha*la))):(nr=Ot*it-At*V,sr=At*it+Ot*V,nr===0&&sr<0&&(nr=n.tiny_*it,sr=-1),ve=Math.atan2(nr,sr)),I.S12+=this._c2*ve,I.S12*=ot*at*q,I.S12+=0),ot<0&&([Ot,V]=[V,Ot],[At,it]=[it,At],E&n.GEODESICSCALE&&([I.M21,I.M12]=[I.M12,I.M21])),V*=ot*at,it*=ot*q,Ot*=ot*at,At*=ot*q,{vals:I,salp1:V,calp1:it,salp2:Ot,calp2:At}},n.Geodesic.prototype.GenDirect=function(w,S,R,T,E,I){var D;return I?I===n.LONG_UNROLL&&(I|=n.STANDARD):I=n.STANDARD,T||(I|=n.DISTANCE_IN),D=new s.GeodesicLine(this,w,S,R,I),D.GenPosition(T,E,I)},n.Geodesic.prototype.Direct=function(w,S,R,T,E){return this.GenDirect(w,S,R,!1,T,E)},n.Geodesic.prototype.ArcDirect=function(w,S,R,T,E){return this.GenDirect(w,S,R,!0,T,E)},n.Geodesic.prototype.Line=function(w,S,R,T){return new s.GeodesicLine(this,w,S,R,T)},n.Geodesic.prototype.DirectLine=function(w,S,R,T,E){return this.GenDirectLine(w,S,R,!1,T,E)},n.Geodesic.prototype.ArcDirectLine=function(w,S,R,T,E){return this.GenDirectLine(w,S,R,!0,T,E)},n.Geodesic.prototype.GenDirectLine=function(w,S,R,T,E,I){var D;return I||(I=n.STANDARD|n.DISTANCE_IN),T||(I|=n.DISTANCE_IN),D=new s.GeodesicLine(this,w,S,R,I),D.GenSetDistance(T,E),D},n.Geodesic.prototype.InverseLine=function(w,S,R,T,E){var I,D,K;return E||(E=n.STANDARD|n.DISTANCE_IN),I=this.InverseInt(w,S,R,T,n.ARC),K=a.atan2d(I.salp1,I.calp1),E&(n.OUT_MASK&n.DISTANCE_IN)&&(E|=n.DISTANCE),D=new s.GeodesicLine(this,w,S,K,E,I.salp1,I.calp1),D.SetArc(I.vals.a12),D},n.Geodesic.prototype.Polygon=function(w){return new r.PolygonArea(this,w)},n.WGS84=new n.Geodesic(o.WGS84.a,o.WGS84.f)})(e.Geodesic,e.GeodesicLine,e.PolygonArea,e.Math,e.Constants),(function(n,s,r){s.GeodesicLine=function(a,o,h,l,c,u,d){var f,g,_,m,y,p;c||(c=n.STANDARD|n.DISTANCE_IN),this.a=a.a,this.f=a.f,this._b=a._b,this._c2=a._c2,this._f1=a._f1,this.caps=c|n.LATITUDE|n.AZIMUTH|n.LONG_UNROLL,this.lat1=r.LatFix(o),this.lon1=h,typeof u>"u"||typeof d>"u"?(this.azi1=r.AngNormalize(l),f=r.sincosd(r.AngRound(this.azi1)),this.salp1=f.s,this.calp1=f.c):(this.azi1=l,this.salp1=u,this.calp1=d),f=r.sincosd(r.AngRound(this.lat1)),_=this._f1*f.s,g=f.c,f=r.hypot(_,g),_/=f,g/=f,g=Math.max(n.tiny_,g),this._dn1=Math.sqrt(1+a._ep2*r.sq(_)),this._salp0=this.salp1*g,this._calp0=r.hypot(this.calp1,this.salp1*_),this._ssig1=_,this._somg1=this._salp0*_,this._csig1=this._comg1=_!==0||this.calp1!==0?g*this.calp1:1,f=r.hypot(this._ssig1,this._csig1),this._ssig1/=f,this._csig1/=f,this._k2=r.sq(this._calp0)*a._ep2,m=this._k2/(2*(1+Math.sqrt(1+this._k2))+this._k2),this.caps&n.CAP_C1&&(this._A1m1=n.A1m1f(m),this._C1a=new Array(n.nC1_+1),n.C1f(m,this._C1a),this._B11=n.SinCosSeries(!0,this._ssig1,this._csig1,this._C1a),y=Math.sin(this._B11),p=Math.cos(this._B11),this._stau1=this._ssig1*p+this._csig1*y,this._ctau1=this._csig1*p-this._ssig1*y),this.caps&n.CAP_C1p&&(this._C1pa=new Array(n.nC1p_+1),n.C1pf(m,this._C1pa)),this.caps&n.CAP_C2&&(this._A2m1=n.A2m1f(m),this._C2a=new Array(n.nC2_+1),n.C2f(m,this._C2a),this._B21=n.SinCosSeries(!0,this._ssig1,this._csig1,this._C2a)),this.caps&n.CAP_C3&&(this._C3a=new Array(n.nC3_),a.C3f(m,this._C3a),this._A3c=-this.f*this._salp0*a.A3f(m),this._B31=n.SinCosSeries(!0,this._ssig1,this._csig1,this._C3a)),this.caps&n.CAP_C4&&(this._C4a=new Array(n.nC4_),a.C4f(m,this._C4a),this._A4=r.sq(this.a)*this._calp0*this._salp0*a._e2,this._B41=n.SinCosSeries(!1,this._ssig1,this._csig1,this._C4a)),this.a13=this.s13=NaN},s.GeodesicLine.prototype.GenPosition=function(a,o,h){var l={},c,u,d,f,g,_,m,y,p,x,v,M,C,P,b,L,N,B,U,z,Q,X,H,W,w,S,R,T,E;return h?h===n.LONG_UNROLL&&(h|=n.STANDARD):h=n.STANDARD,h&=this.caps&n.OUT_MASK,l.lat1=this.lat1,l.azi1=this.azi1,l.lon1=h&n.LONG_UNROLL?this.lon1:r.AngNormalize(this.lon1),a?l.a12=o:l.s12=o,a||this.caps&n.DISTANCE_IN&n.OUT_MASK?(f=0,g=0,a?(c=o*r.degree,S=r.sincosd(o),u=S.s,d=S.c):(y=o/(this._b*(1+this._A1m1)),p=Math.sin(y),x=Math.cos(y),f=-n.SinCosSeries(!0,this._stau1*x+this._ctau1*p,this._ctau1*x-this._stau1*p,this._C1pa),c=y-(f-this._B11),u=Math.sin(c),d=Math.cos(c),Math.abs(this.f)>.01&&(_=this._ssig1*d+this._csig1*u,m=this._csig1*d-this._ssig1*u,f=n.SinCosSeries(!0,_,m,this._C1a),v=(1+this._A1m1)*(c+(f-this._B11))-o/this._b,c=c-v/Math.sqrt(1+this._k2*r.sq(_)),u=Math.sin(c),d=Math.cos(c))),_=this._ssig1*d+this._csig1*u,m=this._csig1*d-this._ssig1*u,X=Math.sqrt(1+this._k2*r.sq(_)),h&(n.DISTANCE|n.REDUCEDLENGTH|n.GEODESICSCALE)&&((a||Math.abs(this.f)>.01)&&(f=n.SinCosSeries(!0,_,m,this._C1a)),g=(1+this._A1m1)*(f-this._B11)),L=this._calp0*_,N=r.hypot(this._salp0,this._calp0*m),N===0&&(N=m=n.tiny_),z=this._salp0,Q=this._calp0*m,a&&h&n.DISTANCE&&(l.s12=this._b*((1+this._A1m1)*c+g)),h&n.LONGITUDE&&(B=this._salp0*_,U=m,b=r.copysign(1,this._salp0),M=h&n.LONG_UNROLL?b*(c-(Math.atan2(_,m)-Math.atan2(this._ssig1,this._csig1))+(Math.atan2(b*B,U)-Math.atan2(b*this._somg1,this._comg1))):Math.atan2(B*this._comg1-U*this._somg1,U*this._comg1+B*this._somg1),C=M+this._A3c*(c+(n.SinCosSeries(!0,_,m,this._C3a)-this._B31)),P=C/r.degree,l.lon2=h&n.LONG_UNROLL?this.lon1+P:r.AngNormalize(r.AngNormalize(this.lon1)+r.AngNormalize(P))),h&n.LATITUDE&&(l.lat2=r.atan2d(L,this._f1*N)),h&n.AZIMUTH&&(l.azi2=r.atan2d(z,Q)),h&(n.REDUCEDLENGTH|n.GEODESICSCALE)&&(H=n.SinCosSeries(!0,_,m,this._C2a),W=(1+this._A2m1)*(H-this._B21),w=(this._A1m1-this._A2m1)*c+(g-W),h&n.REDUCEDLENGTH&&(l.m12=this._b*(X*(this._csig1*_)-this._dn1*(this._ssig1*m)-this._csig1*m*w)),h&n.GEODESICSCALE&&(S=this._k2*(_-this._ssig1)*(_+this._ssig1)/(this._dn1+X),l.M12=d+(S*_-m*w)*this._ssig1/this._dn1,l.M21=d-(S*this._ssig1-this._csig1*w)*_/X)),h&n.AREA&&(R=n.SinCosSeries(!1,_,m,this._C4a),this._calp0===0||this._salp0===0?(T=z*this.calp1-Q*this.salp1,E=Q*this.calp1+z*this.salp1):(T=this._calp0*this._salp0*(d<=0?this._csig1*(1-d)+u*this._ssig1:u*(this._csig1*u/(1+d)+this._ssig1)),E=r.sq(this._salp0)+r.sq(this._calp0)*this._csig1*m),l.S12=this._c2*Math.atan2(T,E)+this._A4*(R-this._B41)),a||(l.a12=c/r.degree),l):(l.a12=NaN,l)},s.GeodesicLine.prototype.Position=function(a,o){return this.GenPosition(!1,a,o)},s.GeodesicLine.prototype.ArcPosition=function(a,o){return this.GenPosition(!0,a,o)},s.GeodesicLine.prototype.GenSetDistance=function(a,o){a?this.SetArc(o):this.SetDistance(o)},s.GeodesicLine.prototype.SetDistance=function(a){var o;this.s13=a,o=this.GenPosition(!1,this.s13,n.ARC),this.a13=0+o.a12},s.GeodesicLine.prototype.SetArc=function(a){var o;this.a13=a,o=this.GenPosition(!0,this.a13,n.DISTANCE),this.s13=0+o.s12}})(e.Geodesic,e.GeodesicLine,e.Math),(function(n,s,r,a){var o,h,l,c;o=function(u,d){var f=r.AngDiff(u,d).d;return u=r.AngNormalize(u),d=r.AngNormalize(d),f>0&&(u<0&&d>=0||u>0&&d===0)?1:f<0&&u>=0&&d<0?-1:0},h=function(u,d){return u=u%720,d=d%720,(0<=d&&d<360||d<-360?0:1)-(0<=u&&u<360||u<-360?0:1)},l=function(u,d,f,g,_){return u.Remainder(d),f&1&&u.Add((u.Sum()<0?1:-1)*d/2),g||u.Negate(),_?u.Sum()>d/2?u.Add(-d):u.Sum()<=-d/2&&u.Add(+d):u.Sum()>=d?u.Add(-d):u.Sum()<0&&u.Add(+d),0+u.Sum()},c=function(u,d,f,g,_){return u=r.remainder(u,d),f&1&&(u+=(u<0?1:-1)*d/2),g||(u*=-1),_?u>d/2?u-=d:u<=-d/2&&(u+=d):u>=d?u-=d:u<0&&(u+=d),0+u},n.PolygonArea=function(u,d){this._geod=u,this.a=this._geod.a,this.f=this._geod.f,this._area0=4*Math.PI*u._c2,this.polyline=d||!1,this._mask=s.LATITUDE|s.LONGITUDE|s.DISTANCE|(this.polyline?s.NONE:s.AREA|s.LONG_UNROLL),this.polyline||(this._areasum=new a.Accumulator(0)),this._perimetersum=new a.Accumulator(0),this.Clear()},n.PolygonArea.prototype.Clear=function(){this.num=0,this._crossings=0,this.polyline||this._areasum.Set(0),this._perimetersum.Set(0),this._lat0=this._lon0=this.lat=this.lon=NaN},n.PolygonArea.prototype.AddPoint=function(u,d){var f;this.num===0?(this._lat0=this.lat=u,this._lon0=this.lon=d):(f=this._geod.Inverse(this.lat,this.lon,u,d,this._mask),this._perimetersum.Add(f.s12),this.polyline||(this._areasum.Add(f.S12),this._crossings+=o(this.lon,d)),this.lat=u,this.lon=d),++this.num},n.PolygonArea.prototype.AddEdge=function(u,d){var f;this.num&&(f=this._geod.Direct(this.lat,this.lon,u,d,this._mask),this._perimetersum.Add(d),this.polyline||(this._areasum.Add(f.S12),this._crossings+=h(this.lon,f.lon2)),this.lat=f.lat2,this.lon=f.lon2),++this.num},n.PolygonArea.prototype.Compute=function(u,d){var f={number:this.num},g,_;return this.num<2?(f.perimeter=0,this.polyline||(f.area=0),f):this.polyline?(f.perimeter=this._perimetersum.Sum(),f):(g=this._geod.Inverse(this.lat,this.lon,this._lat0,this._lon0,this._mask),f.perimeter=this._perimetersum.Sum(g.s12),_=new a.Accumulator(this._areasum),_.Add(g.S12),f.area=l(_,this._area0,this._crossings+o(this.lon,this._lon0),u,d),f)},n.PolygonArea.prototype.TestPoint=function(u,d,f,g){var _={number:this.num+1},m,y,p,x;if(this.num===0)return _.perimeter=0,this.polyline||(_.area=0),_;for(_.perimeter=this._perimetersum.Sum(),y=this.polyline?0:this._areasum.Sum(),p=this._crossings,x=0;x<(this.polyline?1:2);++x)m=this._geod.Inverse(x===0?this.lat:u,x===0?this.lon:d,x!==0?this._lat0:u,x!==0?this._lon0:d,this._mask),_.perimeter+=m.s12,this.polyline||(y+=m.S12,p+=o(x===0?this.lon:d,x!==0?this._lon0:d));return this.polyline||(_.area=c(y,this._area0,p,f,g)),_},n.PolygonArea.prototype.TestEdge=function(u,d,f,g){var _={number:this.num?this.num+1:0},m,y,p;return this.num===0||(_.perimeter=this._perimetersum.Sum()+d,this.polyline)||(y=this._areasum.Sum(),p=this._crossings,m=this._geod.Direct(this.lat,this.lon,u,d,this._mask),y+=m.S12,p+=h(this.lon,m.lon2),p+=o(m.lon2,this._lon0),m=this._geod.Inverse(m.lat2,m.lon2,this._lat0,this._lon0,this._mask),_.perimeter+=m.s12,y+=m.S12,_.area=c(y,this._area0,p,f,g)),_}})(e.PolygonArea,e.Geodesic,e.Math,e.Accumulator),t(e)})(function(t){i.exports?i.exports=t:window.geodesic=t})})(Fa)),Fa.exports}var Rp=Ip();function Ap(){this.sin_p12=Math.sin(this.lat0),this.cos_p12=Math.cos(this.lat0),this.g=new Rp.Geodesic.Geodesic(this.a,this.es/(1+Math.sqrt(1-this.es)))}function Tp(i){var t=i.x,e=i.y,n=Math.sin(i.y),s=Math.cos(i.y),r=k(t-this.long0),a,o,h,l,c,u,d,f,g,_,m,y,p,x,v;return this.sphere?Math.abs(this.sin_p12-1)<=F?(i.x=this.x0+this.a*(G-e)*Math.sin(r),i.y=this.y0-this.a*(G-e)*Math.cos(r),i):Math.abs(this.sin_p12+1)<=F?(i.x=this.x0+this.a*(G+e)*Math.sin(r),i.y=this.y0+this.a*(G+e)*Math.cos(r),i):(g=this.sin_p12*n+this.cos_p12*s*Math.cos(r),d=Math.acos(g),f=d?d/Math.sin(d):1,i.x=this.x0+this.a*f*s*Math.sin(r),i.y=this.y0+this.a*f*(this.cos_p12*n-this.sin_p12*s*Math.cos(r)),i):(a=Hs(this.es),o=Js(this.es),h=Qs(this.es),l=tr(this.es),Math.abs(this.sin_p12-1)<=F?(c=this.a*se(a,o,h,l,G),u=this.a*se(a,o,h,l,e),i.x=this.x0+(c-u)*Math.sin(r),i.y=this.y0-(c-u)*Math.cos(r),i):Math.abs(this.sin_p12+1)<=F?(c=this.a*se(a,o,h,l,G),u=this.a*se(a,o,h,l,e),i.x=this.x0+(c+u)*Math.sin(r),i.y=this.y0+(c+u)*Math.cos(r),i):Math.abs(t)<F&&Math.abs(e-this.lat0)<F?(i.x=i.y=0,i):(_=this.lat0/Ct,m=this.long0/Ct,y=e/Ct,p=t/Ct,x=this.g.Inverse(_,m,y,p,this.g.AZIMUTH),v=x.azi1*Ct,i.x=x.s12*Math.sin(v),i.y=x.s12*Math.cos(v),i))}function bp(i){i.x-=this.x0,i.y-=this.y0;var t,e,n,s,r,a,o,h,l,c,u,d,f,g,_,m,y,p;return this.sphere?(t=Math.sqrt(i.x*i.x+i.y*i.y),t>2*G*this.a?void 0:(e=t/this.a,n=Math.sin(e),s=Math.cos(e),r=this.long0,Math.abs(t)<=F?a=this.lat0:(a=Pi(s*this.sin_p12+i.y*n*this.cos_p12/t),o=Math.abs(this.lat0)-G,Math.abs(o)<=F?this.lat0>=0?r=k(this.long0+Math.atan2(i.x,-i.y)):r=k(this.long0-Math.atan2(-i.x,i.y)):r=k(this.long0+Math.atan2(i.x*n,t*this.cos_p12*s-i.y*this.sin_p12*n))),i.x=r,i.y=a,i)):(h=Hs(this.es),l=Js(this.es),c=Qs(this.es),u=tr(this.es),Math.abs(this.sin_p12-1)<=F?(d=this.a*se(h,l,c,u,G),t=Math.sqrt(i.x*i.x+i.y*i.y),f=d-t,a=kr(f/this.a,h,l,c,u),r=k(this.long0+Math.atan2(i.x,-1*i.y)),i.x=r,i.y=a,i):Math.abs(this.sin_p12+1)<=F?(d=this.a*se(h,l,c,u,G),t=Math.sqrt(i.x*i.x+i.y*i.y),f=t-d,a=kr(f/this.a,h,l,c,u),r=k(this.long0+Math.atan2(i.x,i.y)),i.x=r,i.y=a,i):(g=this.lat0/Ct,_=this.long0/Ct,m=Math.atan2(i.x,i.y)/Ct,y=Math.sqrt(i.x*i.x+i.y*i.y),p=this.g.Direct(g,_,m,y,this.g.STANDARD),i.x=p.lon2*Ct,i.y=p.lat2*Ct,i))}var Pp=["Azimuthal_Equidistant","aeqd"];const Lp={init:Ap,forward:Tp,inverse:bp,names:Pp};function Gp(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0)}function Op(i){var t,e,n,s,r,a,o,h,l=i.x,c=i.y;return n=k(l-this.long0),t=Math.sin(c),e=Math.cos(c),s=Math.cos(n),a=this.sin_p14*t+this.cos_p14*e*s,r=1,(a>0||Math.abs(a)<=F)&&(o=this.a*r*e*Math.sin(n),h=this.y0+this.a*r*(this.cos_p14*t-this.sin_p14*e*s)),i.x=o,i.y=h,i}function Dp(i){var t,e,n,s,r,a,o;return i.x-=this.x0,i.y-=this.y0,t=Math.sqrt(i.x*i.x+i.y*i.y),e=Pi(t/this.a),n=Math.sin(e),s=Math.cos(e),a=this.long0,Math.abs(t)<=F?(o=this.lat0,i.x=a,i.y=o,i):(o=Pi(s*this.sin_p14+i.y*n*this.cos_p14/t),r=Math.abs(this.lat0)-G,Math.abs(r)<=F?(this.lat0>=0?a=k(this.long0+Math.atan2(i.x,-i.y)):a=k(this.long0-Math.atan2(-i.x,i.y)),i.x=a,i.y=o,i):(a=k(this.long0+Math.atan2(i.x*n,t*this.cos_p14*s-i.y*this.sin_p14*n)),i.x=a,i.y=o,i))}var Np=["ortho"];const Fp={init:Gp,forward:Op,inverse:Dp,names:Np};var Lt={FRONT:1,RIGHT:2,BACK:3,LEFT:4,TOP:5,BOTTOM:6},wt={AREA_0:1,AREA_1:2,AREA_2:3,AREA_3:4};function kp(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Quadrilateralized Spherical Cube",this.lat0>=G-Mt/2?this.face=Lt.TOP:this.lat0<=-(G-Mt/2)?this.face=Lt.BOTTOM:Math.abs(this.long0)<=Mt?this.face=Lt.FRONT:Math.abs(this.long0)<=G+Mt?this.face=this.long0>0?Lt.RIGHT:Lt.LEFT:this.face=Lt.BACK,this.es!==0&&(this.one_minus_f=1-(this.a-this.b)/this.a,this.one_minus_f_squared=this.one_minus_f*this.one_minus_f)}function zp(i){var t={x:0,y:0},e,n,s,r,a,o,h={value:0};if(i.x-=this.long0,this.es!==0?e=Math.atan(this.one_minus_f_squared*Math.tan(i.y)):e=i.y,n=i.x,this.face===Lt.TOP)r=G-e,n>=Mt&&n<=G+Mt?(h.value=wt.AREA_0,s=n-G):n>G+Mt||n<=-(G+Mt)?(h.value=wt.AREA_1,s=n>0?n-Nt:n+Nt):n>-(G+Mt)&&n<=-Mt?(h.value=wt.AREA_2,s=n+G):(h.value=wt.AREA_3,s=n);else if(this.face===Lt.BOTTOM)r=G+e,n>=Mt&&n<=G+Mt?(h.value=wt.AREA_0,s=-n+G):n<Mt&&n>=-Mt?(h.value=wt.AREA_1,s=-n):n<-Mt&&n>=-(G+Mt)?(h.value=wt.AREA_2,s=-n-G):(h.value=wt.AREA_3,s=n>0?-n+Nt:-n-Nt);else{var l,c,u,d,f,g,_;this.face===Lt.RIGHT?n=bn(n,+G):this.face===Lt.BACK?n=bn(n,+Nt):this.face===Lt.LEFT&&(n=bn(n,-G)),d=Math.sin(e),f=Math.cos(e),g=Math.sin(n),_=Math.cos(n),l=f*_,c=f*g,u=d,this.face===Lt.FRONT?(r=Math.acos(l),s=_r(r,u,c,h)):this.face===Lt.RIGHT?(r=Math.acos(c),s=_r(r,u,-l,h)):this.face===Lt.BACK?(r=Math.acos(-l),s=_r(r,u,-c,h)):this.face===Lt.LEFT?(r=Math.acos(-c),s=_r(r,u,l,h)):(r=s=0,h.value=wt.AREA_0)}return o=Math.atan(12/Nt*(s+Math.acos(Math.sin(s)*Math.cos(Mt))-G)),a=Math.sqrt((1-Math.cos(r))/(Math.cos(o)*Math.cos(o))/(1-Math.cos(Math.atan(1/Math.cos(s))))),h.value===wt.AREA_1?o+=G:h.value===wt.AREA_2?o+=Nt:h.value===wt.AREA_3&&(o+=1.5*Nt),t.x=a*Math.cos(o),t.y=a*Math.sin(o),t.x=t.x*this.a+this.x0,t.y=t.y*this.a+this.y0,i.x=t.x,i.y=t.y,i}function Up(i){var t={lam:0,phi:0},e,n,s,r,a,o,h,l,c,u={value:0};if(i.x=(i.x-this.x0)/this.a,i.y=(i.y-this.y0)/this.a,n=Math.atan(Math.sqrt(i.x*i.x+i.y*i.y)),e=Math.atan2(i.y,i.x),i.x>=0&&i.x>=Math.abs(i.y)?u.value=wt.AREA_0:i.y>=0&&i.y>=Math.abs(i.x)?(u.value=wt.AREA_1,e-=G):i.x<0&&-i.x>=Math.abs(i.y)?(u.value=wt.AREA_2,e=e<0?e+Nt:e-Nt):(u.value=wt.AREA_3,e+=G),c=Nt/12*Math.tan(e),a=Math.sin(c)/(Math.cos(c)-1/Math.sqrt(2)),o=Math.atan(a),s=Math.cos(e),r=Math.tan(n),h=1-s*s*r*r*(1-Math.cos(Math.atan(1/Math.cos(o)))),h<-1?h=-1:h>1&&(h=1),this.face===Lt.TOP)l=Math.acos(h),t.phi=G-l,u.value===wt.AREA_0?t.lam=o+G:u.value===wt.AREA_1?t.lam=o<0?o+Nt:o-Nt:u.value===wt.AREA_2?t.lam=o-G:t.lam=o;else if(this.face===Lt.BOTTOM)l=Math.acos(h),t.phi=l-G,u.value===wt.AREA_0?t.lam=-o+G:u.value===wt.AREA_1?t.lam=-o:u.value===wt.AREA_2?t.lam=-o-G:t.lam=o<0?-o-Nt:-o+Nt;else{var d,f,g;d=h,c=d*d,c>=1?g=0:g=Math.sqrt(1-c)*Math.sin(o),c+=g*g,c>=1?f=0:f=Math.sqrt(1-c),u.value===wt.AREA_1?(c=f,f=-g,g=c):u.value===wt.AREA_2?(f=-f,g=-g):u.value===wt.AREA_3&&(c=f,f=g,g=-c),this.face===Lt.RIGHT?(c=d,d=-f,f=c):this.face===Lt.BACK?(d=-d,f=-f):this.face===Lt.LEFT&&(c=d,d=f,f=-c),t.phi=Math.acos(-g)-G,t.lam=Math.atan2(f,d),this.face===Lt.RIGHT?t.lam=bn(t.lam,-G):this.face===Lt.BACK?t.lam=bn(t.lam,-Nt):this.face===Lt.LEFT&&(t.lam=bn(t.lam,+G))}if(this.es!==0){var _,m,y;_=t.phi<0?1:0,m=Math.tan(t.phi),y=this.b/Math.sqrt(m*m+this.one_minus_f_squared),t.phi=Math.atan(Math.sqrt(this.a*this.a-y*y)/(this.one_minus_f*y)),_&&(t.phi=-t.phi)}return t.lam+=this.long0,i.x=t.lam,i.y=t.phi,i}function _r(i,t,e,n){var s;return i<F?(n.value=wt.AREA_0,s=0):(s=Math.atan2(t,e),Math.abs(s)<=Mt?n.value=wt.AREA_0:s>Mt&&s<=G+Mt?(n.value=wt.AREA_1,s-=G):s>G+Mt||s<=-(G+Mt)?(n.value=wt.AREA_2,s=s>=0?s-Nt:s+Nt):(n.value=wt.AREA_3,s+=G)),s}function bn(i,t){var e=i+t;return e<-Nt?e+=bs:e>+Nt&&(e-=bs),e}var Wp=["Quadrilateralized Spherical Cube","Quadrilateralized_Spherical_Cube","qsc"];const Bp={init:kp,forward:zp,inverse:Up,names:Wp};var co=[[1,22199e-21,-715515e-10,31103e-10],[.9986,-482243e-9,-24897e-9,-13309e-10],[.9954,-83103e-8,-448605e-10,-986701e-12],[.99,-.00135364,-59661e-9,36777e-10],[.9822,-.00167442,-449547e-11,-572411e-11],[.973,-.00214868,-903571e-10,18736e-12],[.96,-.00305085,-900761e-10,164917e-11],[.9427,-.00382792,-653386e-10,-26154e-10],[.9216,-.00467746,-10457e-8,481243e-11],[.8962,-.00536223,-323831e-10,-543432e-11],[.8679,-.00609363,-113898e-9,332484e-11],[.835,-.00698325,-640253e-10,934959e-12],[.7986,-.00755338,-500009e-10,935324e-12],[.7597,-.00798324,-35971e-9,-227626e-11],[.7186,-.00851367,-701149e-10,-86303e-10],[.6732,-.00986209,-199569e-9,191974e-10],[.6213,-.010418,883923e-10,624051e-11],[.5722,-.00906601,182e-6,624051e-11],[.5322,-.00677797,275608e-9,624051e-11]],cs=[[-520417e-23,.0124,121431e-23,-845284e-16],[.062,.0124,-126793e-14,422642e-15],[.124,.0124,507171e-14,-160604e-14],[.186,.0123999,-190189e-13,600152e-14],[.248,.0124002,710039e-13,-224e-10],[.31,.0123992,-264997e-12,835986e-13],[.372,.0124029,988983e-12,-311994e-12],[.434,.0123893,-369093e-11,-435621e-12],[.4958,.0123198,-102252e-10,-345523e-12],[.5571,.0121916,-154081e-10,-582288e-12],[.6176,.0119938,-241424e-10,-525327e-12],[.6769,.011713,-320223e-10,-516405e-12],[.7346,.0113541,-397684e-10,-609052e-12],[.7903,.0109107,-489042e-10,-104739e-11],[.8435,.0103431,-64615e-9,-140374e-14],[.8936,.00969686,-64636e-9,-8547e-9],[.9394,.00840947,-192841e-9,-42106e-10],[.9761,.00616527,-256e-6,-42106e-10],[1,.00328947,-319159e-9,-42106e-10]],Gu=.8487,Ou=1.3523,Du=Ye/5,Xp=1/Du,Cn=18,zr=function(i,t){return i[0]+t*(i[1]+t*(i[2]+t*i[3]))},qp=function(i,t){return i[1]+t*(2*i[2]+t*3*i[3])};function jp(i,t,e,n){for(var s=t;n;--n){var r=i(s);if(s-=r,Math.abs(r)<e)break}return s}function Yp(){this.x0=this.x0||0,this.y0=this.y0||0,this.long0=this.long0||0,this.es=0,this.title=this.title||"Robinson"}function Kp(i){var t=k(i.x-this.long0),e=Math.abs(i.y),n=Math.floor(e*Du);n<0?n=0:n>=Cn&&(n=Cn-1),e=Ye*(e-Xp*n);var s={x:zr(co[n],e)*t,y:zr(cs[n],e)};return i.y<0&&(s.y=-s.y),s.x=s.x*this.a*Gu+this.x0,s.y=s.y*this.a*Ou+this.y0,s}function Vp(i){var t={x:(i.x-this.x0)/(this.a*Gu),y:Math.abs(i.y-this.y0)/(this.a*Ou)};if(t.y>=1)t.x/=co[Cn][0],t.y=i.y<0?-G:G;else{var e=Math.floor(t.y*Cn);for(e<0?e=0:e>=Cn&&(e=Cn-1);;)if(cs[e][0]>t.y)--e;else if(cs[e+1][0]<=t.y)++e;else break;var n=cs[e],s=5*(t.y-n[0])/(cs[e+1][0]-n[0]);s=jp(function(r){return(zr(n,r)-t.y)/qp(n,r)},s,F,100),t.x/=zr(co[e],s),t.y=(5*e+s)*Ct,i.y<0&&(t.y=-t.y)}return t.x=k(t.x+this.long0),t}var Zp=["Robinson","robin"];const $p={init:Yp,forward:Kp,inverse:Vp,names:Zp};function Hp(){this.name="geocent"}function Jp(i){var t=Mu(i,this.es,this.a);return t}function Qp(i){var t=wu(i,this.es,this.a,this.b);return t}var t2=["Geocentric","geocentric","geocent","Geocent"];const e2={init:Hp,forward:Jp,inverse:Qp,names:t2};var Qt={N_POLE:0,S_POLE:1,EQUIT:2,OBLIQ:3},es={h:{def:1e5,num:!0},azi:{def:0,num:!0,degrees:!0},tilt:{def:0,num:!0,degrees:!0},long0:{def:0,num:!0},lat0:{def:0,num:!0}};function i2(){if(Object.keys(es).forEach(function(e){if(typeof this[e]>"u")this[e]=es[e].def;else{if(es[e].num&&isNaN(this[e]))throw new Error("Invalid parameter value, must be numeric "+e+" = "+this[e]);es[e].num&&(this[e]=parseFloat(this[e]))}es[e].degrees&&(this[e]=this[e]*Ct)}.bind(this)),Math.abs(Math.abs(this.lat0)-G)<F?this.mode=this.lat0<0?Qt.S_POLE:Qt.N_POLE:Math.abs(this.lat0)<F?this.mode=Qt.EQUIT:(this.mode=Qt.OBLIQ,this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0)),this.pn1=this.h/this.a,this.pn1<=0||this.pn1>1e10)throw new Error("Invalid height");this.p=1+this.pn1,this.rp=1/this.p,this.h1=1/this.pn1,this.pfact=(this.p+1)*this.h1,this.es=0;var i=this.tilt,t=this.azi;this.cg=Math.cos(t),this.sg=Math.sin(t),this.cw=Math.cos(i),this.sw=Math.sin(i)}function n2(i){i.x-=this.long0;var t=Math.sin(i.y),e=Math.cos(i.y),n=Math.cos(i.x),s,r;switch(this.mode){case Qt.OBLIQ:r=this.sinph0*t+this.cosph0*e*n;break;case Qt.EQUIT:r=e*n;break;case Qt.S_POLE:r=-t;break;case Qt.N_POLE:r=t;break}switch(r=this.pn1/(this.p-r),s=r*e*Math.sin(i.x),this.mode){case Qt.OBLIQ:r*=this.cosph0*t-this.sinph0*e*n;break;case Qt.EQUIT:r*=t;break;case Qt.N_POLE:r*=-(e*n);break;case Qt.S_POLE:r*=e*n;break}var a,o;return a=r*this.cg+s*this.sg,o=1/(a*this.sw*this.h1+this.cw),s=(s*this.cg-r*this.sg)*this.cw*o,r=a*o,i.x=s*this.a,i.y=r*this.a,i}function s2(i){i.x/=this.a,i.y/=this.a;var t={x:i.x,y:i.y},e,n,s;s=1/(this.pn1-i.y*this.sw),e=this.pn1*i.x*s,n=this.pn1*i.y*this.cw*s,i.x=e*this.cg+n*this.sg,i.y=n*this.cg-e*this.sg;var r=ue(i.x,i.y);if(Math.abs(r)<F)t.x=0,t.y=i.y;else{var a,o;switch(o=1-r*r*this.pfact,o=(this.p-Math.sqrt(o))/(this.pn1/r+r/this.pn1),a=Math.sqrt(1-o*o),this.mode){case Qt.OBLIQ:t.y=Math.asin(a*this.sinph0+i.y*o*this.cosph0/r),i.y=(a-this.sinph0*Math.sin(t.y))*r,i.x*=o*this.cosph0;break;case Qt.EQUIT:t.y=Math.asin(i.y*o/r),i.y=a*r,i.x*=o;break;case Qt.N_POLE:t.y=Math.asin(a),i.y=-i.y;break;case Qt.S_POLE:t.y=-Math.asin(a);break}t.x=Math.atan2(i.x,i.y)}return i.x=t.x+this.long0,i.y=t.y,i}var r2=["Tilted_Perspective","tpers"];const a2={init:i2,forward:n2,inverse:s2,names:r2};function o2(){if(this.flip_axis=this.sweep==="x"?1:0,this.h=Number(this.h),this.radius_g_1=this.h/this.a,this.radius_g_1<=0||this.radius_g_1>1e10)throw new Error;if(this.radius_g=1+this.radius_g_1,this.C=this.radius_g*this.radius_g-1,this.es!==0){var i=1-this.es,t=1/i;this.radius_p=Math.sqrt(i),this.radius_p2=i,this.radius_p_inv2=t,this.shape="ellipse"}else this.radius_p=1,this.radius_p2=1,this.radius_p_inv2=1,this.shape="sphere";this.title||(this.title="Geostationary Satellite View")}function h2(i){var t=i.x,e=i.y,n,s,r,a;if(t=t-this.long0,this.shape==="ellipse"){e=Math.atan(this.radius_p2*Math.tan(e));var o=this.radius_p/ue(this.radius_p*Math.cos(e),Math.sin(e));if(s=o*Math.cos(t)*Math.cos(e),r=o*Math.sin(t)*Math.cos(e),a=o*Math.sin(e),(this.radius_g-s)*s-r*r-a*a*this.radius_p_inv2<0)return i.x=Number.NaN,i.y=Number.NaN,i;n=this.radius_g-s,this.flip_axis?(i.x=this.radius_g_1*Math.atan(r/ue(a,n)),i.y=this.radius_g_1*Math.atan(a/n)):(i.x=this.radius_g_1*Math.atan(r/n),i.y=this.radius_g_1*Math.atan(a/ue(r,n)))}else this.shape==="sphere"&&(n=Math.cos(e),s=Math.cos(t)*n,r=Math.sin(t)*n,a=Math.sin(e),n=this.radius_g-s,this.flip_axis?(i.x=this.radius_g_1*Math.atan(r/ue(a,n)),i.y=this.radius_g_1*Math.atan(a/n)):(i.x=this.radius_g_1*Math.atan(r/n),i.y=this.radius_g_1*Math.atan(a/ue(r,n))));return i.x=i.x*this.a,i.y=i.y*this.a,i}function l2(i){var t=-1,e=0,n=0,s,r,a,o;if(i.x=i.x/this.a,i.y=i.y/this.a,this.shape==="ellipse"){this.flip_axis?(n=Math.tan(i.y/this.radius_g_1),e=Math.tan(i.x/this.radius_g_1)*ue(1,n)):(e=Math.tan(i.x/this.radius_g_1),n=Math.tan(i.y/this.radius_g_1)*ue(1,e));var h=n/this.radius_p;if(s=e*e+h*h+t*t,r=2*this.radius_g*t,a=r*r-4*s*this.C,a<0)return i.x=Number.NaN,i.y=Number.NaN,i;o=(-r-Math.sqrt(a))/(2*s),t=this.radius_g+o*t,e*=o,n*=o,i.x=Math.atan2(e,t),i.y=Math.atan(n*Math.cos(i.x)/t),i.y=Math.atan(this.radius_p_inv2*Math.tan(i.y))}else if(this.shape==="sphere"){if(this.flip_axis?(n=Math.tan(i.y/this.radius_g_1),e=Math.tan(i.x/this.radius_g_1)*Math.sqrt(1+n*n)):(e=Math.tan(i.x/this.radius_g_1),n=Math.tan(i.y/this.radius_g_1)*Math.sqrt(1+e*e)),s=e*e+n*n+t*t,r=2*this.radius_g*t,a=r*r-4*s*this.C,a<0)return i.x=Number.NaN,i.y=Number.NaN,i;o=(-r-Math.sqrt(a))/(2*s),t=this.radius_g+o*t,e*=o,n*=o,i.x=Math.atan2(e,t),i.y=Math.atan(n*Math.cos(i.x)/t)}return i.x=i.x+this.long0,i}var c2=["Geostationary Satellite View","Geostationary_Satellite","geos"];const u2={init:o2,forward:h2,inverse:l2,names:c2};var _s=1.340264,ms=-.081106,ys=893e-6,ps=.003796,Ur=Math.sqrt(3)/2;function d2(){this.es=0,this.long0=this.long0!==void 0?this.long0:0}function f2(i){var t=k(i.x-this.long0),e=i.y,n=Math.asin(Ur*Math.sin(e)),s=n*n,r=s*s*s;return i.x=t*Math.cos(n)/(Ur*(_s+3*ms*s+r*(7*ys+9*ps*s))),i.y=n*(_s+ms*s+r*(ys+ps*s)),i.x=this.a*i.x+this.x0,i.y=this.a*i.y+this.y0,i}function g2(i){i.x=(i.x-this.x0)/this.a,i.y=(i.y-this.y0)/this.a;var t=1e-9,e=12,n=i.y,s,r,a,o,h,l;for(l=0;l<e&&(s=n*n,r=s*s*s,a=n*(_s+ms*s+r*(ys+ps*s))-i.y,o=_s+3*ms*s+r*(7*ys+9*ps*s),n-=h=a/o,!(Math.abs(h)<t));++l);return s=n*n,r=s*s*s,i.x=Ur*i.x*(_s+3*ms*s+r*(7*ys+9*ps*s))/Math.cos(n),i.y=Math.asin(Math.sin(n)/Ur),i.x=k(i.x+this.long0),i}var _2=["eqearth","Equal Earth","Equal_Earth"];const m2={init:d2,forward:f2,inverse:g2,names:_2};var Gs=1e-10;function y2(){var i;if(this.phi1=this.lat1,Math.abs(this.phi1)<Gs)throw new Error;this.es?(this.en=Jo(this.es),this.m1=Kn(this.phi1,this.am1=Math.sin(this.phi1),i=Math.cos(this.phi1),this.en),this.am1=i/(Math.sqrt(1-this.es*this.am1*this.am1)*this.am1),this.inverse=E2,this.forward=p2):(Math.abs(this.phi1)+Gs>=G?this.cphi1=0:this.cphi1=1/Math.tan(this.phi1),this.inverse=x2,this.forward=v2)}function p2(i){var t=k(i.x-(this.long0||0)),e=i.y,n,s,r;return n=this.am1+this.m1-Kn(e,s=Math.sin(e),r=Math.cos(e),this.en),s=r*t/(n*Math.sqrt(1-this.es*s*s)),i.x=n*Math.sin(s),i.y=this.am1-n*Math.cos(s),i.x=this.a*i.x+(this.x0||0),i.y=this.a*i.y+(this.y0||0),i}function E2(i){i.x=(i.x-(this.x0||0))/this.a,i.y=(i.y-(this.y0||0))/this.a;var t,e,n,s;if(e=ue(i.x,i.y=this.am1-i.y),s=Qo(this.am1+this.m1-e,this.es,this.en),(t=Math.abs(s))<G)t=Math.sin(s),n=e*Math.atan2(i.x,i.y)*Math.sqrt(1-this.es*t*t)/Math.cos(s);else if(Math.abs(t-G)<=Gs)n=0;else throw new Error;return i.x=k(n+(this.long0||0)),i.y=Gi(s),i}function v2(i){var t=k(i.x-(this.long0||0)),e=i.y,n,s;return s=this.cphi1+this.phi1-e,Math.abs(s)>Gs?(i.x=s*Math.sin(n=t*Math.cos(e)/s),i.y=this.cphi1-s*Math.cos(n)):i.x=i.y=0,i.x=this.a*i.x+(this.x0||0),i.y=this.a*i.y+(this.y0||0),i}function x2(i){i.x=(i.x-(this.x0||0))/this.a,i.y=(i.y-(this.y0||0))/this.a;var t,e,n=ue(i.x,i.y=this.cphi1-i.y);if(e=this.cphi1+this.phi1-n,Math.abs(e)>G)throw new Error;return Math.abs(Math.abs(e)-G)<=Gs?t=0:t=n*Math.atan2(i.x,i.y)/Math.cos(e),i.x=k(t+(this.long0||0)),i.y=Gi(e),i}var M2=["bonne","Bonne (Werner lat_1=90)"];const w2={init:y2,names:M2};function S2(i){i.Proj.projections.add(vr),i.Proj.projections.add(xr),i.Proj.projections.add(ym),i.Proj.projections.add(Im),i.Proj.projections.add(Lm),i.Proj.projections.add(Fm),i.Proj.projections.add(Xm),i.Proj.projections.add(Vm),i.Proj.projections.add(Qm),i.Proj.projections.add(sy),i.Proj.projections.add(xy),i.Proj.projections.add(Ry),i.Proj.projections.add(Ly),i.Proj.projections.add(ky),i.Proj.projections.add(Xy),i.Proj.projections.add(Vy),i.Proj.projections.add(Qy),i.Proj.projections.add(sp),i.Proj.projections.add(cp),i.Proj.projections.add(_p),i.Proj.projections.add(vp),i.Proj.projections.add(Cp),i.Proj.projections.add(Lp),i.Proj.projections.add(Fp),i.Proj.projections.add(Bp),i.Proj.projections.add($p),i.Proj.projections.add(e2),i.Proj.projections.add(a2),i.Proj.projections.add(u2),i.Proj.projections.add(m2),i.Proj.projections.add(w2)}ge.defaultDatum="WGS84";ge.Proj=Ke;ge.WGS84=new ge.Proj("WGS84");ge.Point=Wn;ge.toPoint=Su;ge.defs=te;ge.nadgrid=y1;ge.transform=Fr;ge.mgrs=D1;ge.version="__VERSION__";S2(ge);class C2 extends Ko{constructor(t){super(t),this.image=null}getImage(){return this.image?this.image.getImage():null}prepareFrame(t){const e=t.layerStatesArray[t.layerIndex],n=t.pixelRatio,s=t.viewState,r=s.resolution,a=this.getLayer().getSource(),o=t.viewHints;let h=t.extent;if(e.extent!==void 0&&(h=ai(h,qe(e.extent,s.projection))),!o[Yt.ANIMATING]&&!o[Yt.INTERACTING]&&!en(h))if(a){const l=s.projection,c=a.getImage(h,r,n,l);c&&(this.loadImage(c)?this.image=c:c.getState()===j.EMPTY&&(this.image=null))}else this.image=null;return!!this.image}getData(t){const e=this.frameState;if(!e)return null;const n=this.getLayer(),s=Ut(e.pixelToCoordinateTransform,t.slice()),r=n.getExtent();if(r&&!Zi(r,s))return null;const a=this.image.getExtent(),o=this.image.getImage(),h=gt(a),l=Math.floor(o.width*((s[0]-a[0])/h));if(l<0||l>=o.width)return null;const c=Wt(a),u=Math.floor(o.height*((a[3]-s[1])/c));return u<0||u>=o.height?null:this.getImageData(o,l,u)}renderFrame(t,e){const n=this.image,s=n.getExtent(),r=n.getResolution(),[a,o]=Array.isArray(r)?r:[r,r],h=n.getPixelRatio(),l=t.layerStatesArray[t.layerIndex],c=t.pixelRatio,u=t.viewState,d=u.center,f=u.resolution,g=c*a/(f*h),_=c*o/(f*h);this.prepareContainer(t,e);const m=this.context.canvas.width,y=this.context.canvas.height,p=this.getRenderContext(t);let x=!1,v=!0;if(l.extent){const L=qe(l.extent,u.projection);v=ie(L,t.extent),x=v&&!xi(L,t.extent),x&&this.clipUnrotated(p,t,L)}const M=n.getImage(),C=Ze(this.tempTransform,m/2,y/2,g,_,0,h*(s[0]-d[0])/a,h*(d[1]-s[3])/o);this.renderedResolution=o*c/h;const P=M.width*C[0],b=M.height*C[3];if(this.getLayer().getSource().getInterpolate()||(p.imageSmoothingEnabled=!1),this.preRender(p,t),v&&P>=.5&&b>=.5){const L=C[4],N=C[5],B=l.opacity;B!==1&&(p.save(),p.globalAlpha=B),p.drawImage(M,0,0,+M.width,+M.height,L,N,P,b),B!==1&&p.restore()}return this.postRender(this.context,t),x&&p.restore(),p.imageSmoothingEnabled=!0,this.container}}class I2 extends qs{constructor(t){t=t||{},super(t)}}class R2 extends I2{constructor(t){super(t)}createRenderer(){return new C2(this)}getData(t){return super.getData(t)}}class sh extends Fs{constructor(t,e,n){super(),n=n||{},this.tileCoord=t,this.state=e,this.key="",this.transition_=n.transition===void 0?250:n.transition,this.transitionStarts_={},this.interpolate=!!n.interpolate}changed(){this.dispatchEvent(et.CHANGE)}release(){this.setState($.EMPTY)}getKey(){return this.key+"/"+this.tileCoord}getTileCoord(){return this.tileCoord}getState(){return this.state}setState(t){if(this.state!==$.EMPTY){if(this.state!==$.ERROR&&this.state>t)throw new Error("Tile load sequence violation");this.state=t,this.changed()}}load(){yt()}getAlpha(t,e){if(!this.transition_)return 1;let n=this.transitionStarts_[t];if(!n)n=e,this.transitionStarts_[t]=n;else if(n===-1)return 1;const s=e-n+1e3/60;return s>=this.transition_?1:pc(s/this.transition_)}inTransition(t){return this.transition_?this.transitionStarts_[t]!==-1:!1}endTransition(t){this.transition_&&(this.transitionStarts_[t]=-1)}disposeInternal(){this.release(),super.disposeInternal()}}function uo(i){return i instanceof Image||i instanceof HTMLCanvasElement||i instanceof HTMLVideoElement||i instanceof ImageBitmap?i:null}const A2=new Error("disposed"),T2=[256,256];class kl extends sh{constructor(t){const e=$.IDLE;super(t.tileCoord,e,{transition:t.transition,interpolate:t.interpolate}),this.loader_=t.loader,this.data_=null,this.error_=null,this.size_=t.size||null,this.controller_=t.controller||null}getSize(){if(this.size_)return this.size_;const t=uo(this.data_);return t?[t.width,t.height]:T2}getData(){return this.data_}getError(){return this.error_}load(){if(this.state!==$.IDLE&&this.state!==$.ERROR)return;this.state=$.LOADING,this.changed();const t=this;this.loader_().then(function(e){t.data_=e,t.state=$.LOADED,t.changed()}).catch(function(e){t.error_=e,t.state=$.ERROR,t.changed()})}disposeInternal(){this.controller_&&(this.controller_.abort(A2),this.controller_=null),super.disposeInternal()}}class Nu extends sh{constructor(t,e,n,s,r,a){super(t,e,a),this.crossOrigin_=s,this.src_=n,this.key=n,this.image_=new Image,s!==null&&(this.image_.crossOrigin=s),this.unlisten_=null,this.tileLoadFunction_=r}getImage(){return this.image_}setImage(t){this.image_=t,this.state=$.LOADED,this.unlistenImage_(),this.changed()}handleImageError_(){this.state=$.ERROR,this.unlistenImage_(),this.image_=b2(),this.changed()}handleImageLoad_(){const t=this.image_;t.naturalWidth&&t.naturalHeight?this.state=$.LOADED:this.state=$.EMPTY,this.unlistenImage_(),this.changed()}load(){this.state==$.ERROR&&(this.state=$.IDLE,this.image_=new Image,this.crossOrigin_!==null&&(this.image_.crossOrigin=this.crossOrigin_)),this.state==$.IDLE&&(this.state=$.LOADING,this.changed(),this.tileLoadFunction_(this,this.src_),this.unlisten_=sg(this.image_,this.handleImageLoad_.bind(this),this.handleImageError_.bind(this)))}unlistenImage_(){this.unlisten_&&(this.unlisten_(),this.unlisten_=null)}disposeInternal(){this.unlistenImage_(),this.image_=null,super.disposeInternal()}}function b2(){const i=Bt(1,1);return i.fillStyle="rgba(0,0,0,0)",i.fillRect(0,0,1,1),i.canvas}class rh{constructor(t,e,n,s){this.minX=t,this.maxX=e,this.minY=n,this.maxY=s}contains(t){return this.containsXY(t[1],t[2])}containsTileRange(t){return this.minX<=t.minX&&t.maxX<=this.maxX&&this.minY<=t.minY&&t.maxY<=this.maxY}containsXY(t,e){return this.minX<=t&&t<=this.maxX&&this.minY<=e&&e<=this.maxY}equals(t){return this.minX==t.minX&&this.minY==t.minY&&this.maxX==t.maxX&&this.maxY==t.maxY}extend(t){t.minX<this.minX&&(this.minX=t.minX),t.maxX>this.maxX&&(this.maxX=t.maxX),t.minY<this.minY&&(this.minY=t.minY),t.maxY>this.maxY&&(this.maxY=t.maxY)}getHeight(){return this.maxY-this.minY+1}getSize(){return[this.getWidth(),this.getHeight()]}getWidth(){return this.maxX-this.minX+1}intersects(t){return this.minX<=t.maxX&&this.maxX>=t.minX&&this.minY<=t.maxY&&this.maxY>=t.minY}}function dn(i,t,e,n,s){return s!==void 0?(s.minX=i,s.maxX=t,s.minY=e,s.maxY=n,s):new rh(i,t,e,n)}let ka;const Pn=[];function zl(i,t,e,n,s){i.beginPath(),i.moveTo(0,0),i.lineTo(t,e),i.lineTo(n,s),i.closePath(),i.save(),i.clip(),i.fillRect(0,0,Math.max(t,n)+1,Math.max(e,s)),i.restore()}function za(i,t){return Math.abs(i[t*4]-210)>2||Math.abs(i[t*4+3]-.75*255)>2}function P2(){if(ka===void 0){const i=Bt(6,6,Pn);i.globalCompositeOperation="lighter",i.fillStyle="rgba(210, 0, 0, 0.75)",zl(i,4,5,4,0),zl(i,4,5,0,5);const t=i.getImageData(0,0,3,3).data;ka=za(t,0)||za(t,4)||za(t,8),Yr(i),Pn.push(i.canvas)}return ka}function Os(i,t,e,n){const s=Bn(e,t,i);let r=bh(t,n,e);const a=t.getMetersPerUnit();a!==void 0&&(r*=a);const o=i.getMetersPerUnit();o!==void 0&&(r/=o);const h=i.getExtent();if(!h||Zi(h,s)){const l=bh(i,r,s)/r;isFinite(l)&&l>0&&(r/=l)}return r}function L2(i,t,e,n){const s=Ve(e);let r=Os(i,t,s,n);return(!isFinite(r)||r<=0)&&ic(e,function(a){return r=Os(i,t,a,n),isFinite(r)&&r>0}),r}function Fu(i,t,e,n,s,r,a,o,h,l,c,u,d,f){const g=Bt(Math.round(e*i),Math.round(e*t),Pn);if(u||(g.imageSmoothingEnabled=!1),h.length===0)return g.canvas;g.scale(e,e);function _(M){return Math.round(M*e)/e}g.globalCompositeOperation="lighter";const m=fe();h.forEach(function(M,C,P){tc(m,M.extent)});let y;const p=e/n,x=(u?1:1+Math.pow(2,-24))/p;(!d||h.length!==1||l!==0)&&(y=Bt(Math.round(gt(m)*p),Math.round(Wt(m)*p),Pn),u||(y.imageSmoothingEnabled=!1),h.forEach(function(M,C,P){if(M.image.width>0&&M.image.height>0){if(M.clipExtent){y.save();const U=(M.clipExtent[0]-m[0])*p,z=-(M.clipExtent[3]-m[3])*p,Q=gt(M.clipExtent)*p,X=Wt(M.clipExtent)*p;y.rect(u?U:Math.round(U),u?z:Math.round(z),u?Q:Math.round(U+Q)-Math.round(U),u?X:Math.round(z+X)-Math.round(z)),y.clip()}const b=(M.extent[0]-m[0])*p,L=-(M.extent[3]-m[3])*p,N=gt(M.extent)*p,B=Wt(M.extent)*p;y.drawImage(M.image,l,l,M.image.width-2*l,M.image.height-2*l,u?b:Math.round(b),u?L:Math.round(L),u?N:Math.round(b+N)-Math.round(b),u?B:Math.round(L+B)-Math.round(L)),M.clipExtent&&y.restore()}}));const v=tn(a);return o.getTriangles().forEach(function(M,C,P){const b=M.source,L=M.target;let N=b[0][0],B=b[0][1],U=b[1][0],z=b[1][1],Q=b[2][0],X=b[2][1];const H=_((L[0][0]-v[0])/r),W=_(-(L[0][1]-v[1])/r),w=_((L[1][0]-v[0])/r),S=_(-(L[1][1]-v[1])/r),R=_((L[2][0]-v[0])/r),T=_(-(L[2][1]-v[1])/r),E=N,I=B;N=0,B=0,U-=E,z-=I,Q-=E,X-=I;const D=[[U,z,0,0,w-H],[Q,X,0,0,R-H],[0,0,U,z,S-W],[0,0,Q,X,T-W]],K=Pd(D);if(!K)return;if(g.save(),g.beginPath(),P2()||!u){g.moveTo(w,S);const Y=4,ot=H-w,q=W-S;for(let J=0;J<Y;J++)g.lineTo(w+_((J+1)*ot/Y),S+_(J*q/(Y-1))),J!=Y-1&&g.lineTo(w+_((J+1)*ot/Y),S+_((J+1)*q/(Y-1)));g.lineTo(R,T)}else g.moveTo(w,S),g.lineTo(H,W),g.lineTo(R,T);g.clip(),g.transform(K[0],K[2],K[1],K[3],H,W),g.translate(m[0]-E,m[3]-I);let at;if(y)at=y.canvas,g.scale(x,-x);else{const Y=h[0],ot=Y.extent;at=Y.image,g.scale(gt(ot)/at.width,-Wt(ot)/at.height)}g.drawImage(at,0,0),g.restore()}),y&&(Yr(y),Pn.push(y.canvas)),c&&(g.save(),g.globalCompositeOperation="source-over",g.strokeStyle="black",g.lineWidth=1,o.getTriangles().forEach(function(M,C,P){const b=M.target,L=(b[0][0]-v[0])/r,N=-(b[0][1]-v[1])/r,B=(b[1][0]-v[0])/r,U=-(b[1][1]-v[1])/r,z=(b[2][0]-v[0])/r,Q=-(b[2][1]-v[1])/r;g.beginPath(),g.moveTo(B,U),g.lineTo(L,N),g.lineTo(z,Q),g.closePath(),g.stroke()}),g.restore()),g.canvas}const G2=10,Ul=.25;class ku{constructor(t,e,n,s,r,a,o){this.sourceProj_=t,this.targetProj_=e;let h={};const l=o?Qa(x=>Ut(o,Bn(x,this.targetProj_,this.sourceProj_))):xs(this.targetProj_,this.sourceProj_);this.transformInv_=function(x){const v=x[0]+"/"+x[1];return h[v]||(h[v]=l(x)),h[v]},this.maxSourceExtent_=s,this.errorThresholdSquared_=r*r,this.triangles_=[],this.wrapsXInSource_=!1,this.canWrapXInSource_=this.sourceProj_.canWrapX()&&!!s&&!!this.sourceProj_.getExtent()&&gt(s)>=gt(this.sourceProj_.getExtent()),this.sourceWorldWidth_=this.sourceProj_.getExtent()?gt(this.sourceProj_.getExtent()):null,this.targetWorldWidth_=this.targetProj_.getExtent()?gt(this.targetProj_.getExtent()):null;const c=tn(n),u=Hr(n),d=$r(n),f=Zr(n),g=this.transformInv_(c),_=this.transformInv_(u),m=this.transformInv_(d),y=this.transformInv_(f),p=G2+(a?Math.max(0,Math.ceil(Math.log2(Ka(n)/(a*a*256*256)))):0);if(this.addQuad_(c,u,d,f,g,_,m,y,p),this.wrapsXInSource_){let x=1/0;this.triangles_.forEach(function(v,M,C){x=Math.min(x,v.source[0][0],v.source[1][0],v.source[2][0])}),this.triangles_.forEach(v=>{if(Math.max(v.source[0][0],v.source[1][0],v.source[2][0])-x>this.sourceWorldWidth_/2){const M=[[v.source[0][0],v.source[0][1]],[v.source[1][0],v.source[1][1]],[v.source[2][0],v.source[2][1]]];M[0][0]-x>this.sourceWorldWidth_/2&&(M[0][0]-=this.sourceWorldWidth_),M[1][0]-x>this.sourceWorldWidth_/2&&(M[1][0]-=this.sourceWorldWidth_),M[2][0]-x>this.sourceWorldWidth_/2&&(M[2][0]-=this.sourceWorldWidth_);const C=Math.min(M[0][0],M[1][0],M[2][0]);Math.max(M[0][0],M[1][0],M[2][0])-C<this.sourceWorldWidth_/2&&(v.source=M)}})}h={}}addTriangle_(t,e,n,s,r,a){this.triangles_.push({source:[s,r,a],target:[t,e,n]})}addQuad_(t,e,n,s,r,a,o,h,l){const c=Eh([r,a,o,h]),u=this.sourceWorldWidth_?gt(c)/this.sourceWorldWidth_:null,d=this.sourceWorldWidth_,f=this.sourceProj_.canWrapX()&&u>.5&&u<1;let g=!1;if(l>0){if(this.targetProj_.isGlobal()&&this.targetWorldWidth_){const m=Eh([t,e,n,s]);g=gt(m)/this.targetWorldWidth_>Ul||g}!f&&this.sourceProj_.isGlobal()&&u&&(g=u>Ul||g)}if(!g&&this.maxSourceExtent_&&isFinite(c[0])&&isFinite(c[1])&&isFinite(c[2])&&isFinite(c[3])&&!ie(c,this.maxSourceExtent_))return;let _=0;if(!g&&(!isFinite(r[0])||!isFinite(r[1])||!isFinite(a[0])||!isFinite(a[1])||!isFinite(o[0])||!isFinite(o[1])||!isFinite(h[0])||!isFinite(h[1]))){if(l>0)g=!0;else if(_=(!isFinite(r[0])||!isFinite(r[1])?8:0)+(!isFinite(a[0])||!isFinite(a[1])?4:0)+(!isFinite(o[0])||!isFinite(o[1])?2:0)+(!isFinite(h[0])||!isFinite(h[1])?1:0),_!=1&&_!=2&&_!=4&&_!=8)return}if(l>0){if(!g){const m=[(t[0]+n[0])/2,(t[1]+n[1])/2],y=this.transformInv_(m);let p;f?p=(Yi(r[0],d)+Yi(o[0],d))/2-Yi(y[0],d):p=(r[0]+o[0])/2-y[0];const x=(r[1]+o[1])/2-y[1];g=p*p+x*x>this.errorThresholdSquared_}if(g){if(Math.abs(t[0]-n[0])<=Math.abs(t[1]-n[1])){const m=[(e[0]+n[0])/2,(e[1]+n[1])/2],y=this.transformInv_(m),p=[(s[0]+t[0])/2,(s[1]+t[1])/2],x=this.transformInv_(p);this.addQuad_(t,e,m,p,r,a,y,x,l-1),this.addQuad_(p,m,n,s,x,y,o,h,l-1)}else{const m=[(t[0]+e[0])/2,(t[1]+e[1])/2],y=this.transformInv_(m),p=[(n[0]+s[0])/2,(n[1]+s[1])/2],x=this.transformInv_(p);this.addQuad_(t,m,p,s,r,y,x,h,l-1),this.addQuad_(m,e,n,p,y,a,o,x,l-1)}return}}if(f){if(!this.canWrapXInSource_)return;this.wrapsXInSource_=!0}(_&11)==0&&this.addTriangle_(t,n,s,r,o,h),(_&14)==0&&this.addTriangle_(t,n,e,r,o,a),_&&((_&13)==0&&this.addTriangle_(e,s,t,a,h,r),(_&7)==0&&this.addTriangle_(e,s,n,a,h,o))}calculateSourceExtent(){const t=fe();return this.triangles_.forEach(function(e,n,s){const r=e.source;us(t,r[0]),us(t,r[1]),us(t,r[2])}),t}getTriangles(){return this.triangles_}}const zu=.5;class Uu extends sh{constructor(t,e,n,s,r,a,o,h,l,c,u,d){super(r,$.IDLE,d),this.renderEdges_=u!==void 0?u:!1,this.pixelRatio_=o,this.gutter_=h,this.canvas_=null,this.sourceTileGrid_=e,this.targetTileGrid_=s,this.wrappedTileCoord_=a||r,this.sourceTiles_=[],this.sourcesListenerKeys_=null,this.sourceZ_=0,this.clipExtent_=t.canWrapX()?t.getExtent():void 0;const f=s.getTileCoordExtent(this.wrappedTileCoord_),g=this.targetTileGrid_.getExtent();let _=this.sourceTileGrid_.getExtent();const m=g?ai(f,g):f;if(Ka(m)===0){this.state=$.EMPTY;return}const y=t.getExtent();y&&(_?_=ai(_,y):_=y);const p=s.getResolution(this.wrappedTileCoord_[0]),x=L2(t,n,m,p);if(!isFinite(x)||x<=0){this.state=$.EMPTY;return}const v=c!==void 0?c:zu;if(this.triangulation_=new ku(t,n,m,_,x*v,p),this.triangulation_.getTriangles().length===0){this.state=$.EMPTY;return}this.sourceZ_=e.getZForResolution(x);let M=this.triangulation_.calculateSourceExtent();if(_&&(t.canWrapX()?(M[1]=Pt(M[1],_[1],_[3]),M[3]=Pt(M[3],_[1],_[3])):M=ai(M,_)),!Ka(M))this.state=$.EMPTY;else{let C=0,P=0;t.canWrapX()&&(C=gt(y),P=Math.floor((M[0]-y[0])/C)),rc(M.slice(),t,!0).forEach(L=>{const N=e.getTileRangeForExtentAndZ(L,this.sourceZ_);for(let B=N.minX;B<=N.maxX;B++)for(let U=N.minY;U<=N.maxY;U++){const z=l(this.sourceZ_,B,U,o);if(z){const Q=P*C;this.sourceTiles_.push({tile:z,offset:Q})}}++P}),this.sourceTiles_.length===0&&(this.state=$.EMPTY)}}getImage(){return this.canvas_}reproject_(){const t=[];if(this.sourceTiles_.forEach(e=>{const n=e.tile;if(n&&n.getState()==$.LOADED){const s=this.sourceTileGrid_.getTileCoordExtent(n.tileCoord);s[0]+=e.offset,s[2]+=e.offset;const r=this.clipExtent_?.slice();r&&(r[0]+=e.offset,r[2]+=e.offset),t.push({extent:s,clipExtent:r,image:n.getImage()})}}),this.sourceTiles_.length=0,t.length===0)this.state=$.ERROR;else{const e=this.wrappedTileCoord_[0],n=this.targetTileGrid_.getTileSize(e),s=typeof n=="number"?n:n[0],r=typeof n=="number"?n:n[1],a=this.targetTileGrid_.getResolution(e),o=this.sourceTileGrid_.getResolution(this.sourceZ_),h=this.targetTileGrid_.getTileCoordExtent(this.wrappedTileCoord_);this.canvas_=Fu(s,r,this.pixelRatio_,o,this.sourceTileGrid_.getExtent(),a,h,this.triangulation_,t,this.gutter_,this.renderEdges_,this.interpolate),this.state=$.LOADED}this.changed()}load(){if(this.state==$.IDLE){this.state=$.LOADING,this.changed();let t=0;this.sourcesListenerKeys_=[],this.sourceTiles_.forEach(({tile:e})=>{const n=e.getState();if(n==$.IDLE||n==$.LOADING){t++;const s=mt(e,et.CHANGE,r=>{const a=e.getState();(a==$.LOADED||a==$.ERROR||a==$.EMPTY)&&(bt(s),t--,t===0&&(this.unlistenSources_(),this.reproject_()))});this.sourcesListenerKeys_.push(s)}}),t===0?setTimeout(this.reproject_.bind(this),0):this.sourceTiles_.forEach(function({tile:e},n,s){e.getState()==$.IDLE&&e.load()})}}unlistenSources_(){this.sourcesListenerKeys_.forEach(bt),this.sourcesListenerKeys_=null}release(){this.canvas_&&(Yr(this.canvas_.getContext("2d")),Pn.push(this.canvas_),this.canvas_=null),super.release()}}class O2{constructor(t){this.highWaterMark=t!==void 0?t:2048,this.count_=0,this.entries_={},this.oldest_=null,this.newest_=null}deleteOldest(){const t=this.pop();t instanceof Vr&&t.dispose()}canExpireCache(){return this.highWaterMark>0&&this.getCount()>this.highWaterMark}expireCache(t){for(;this.canExpireCache();)this.deleteOldest()}clear(){for(;this.oldest_;)this.deleteOldest()}containsKey(t){return this.entries_.hasOwnProperty(t)}forEach(t){let e=this.oldest_;for(;e;)t(e.value_,e.key_,this),e=e.newer}get(t,e){const n=this.entries_[t];return vt(n!==void 0,"Tried to get a value for a key that does not exist in the cache"),n===this.newest_||(n===this.oldest_?(this.oldest_=this.oldest_.newer,this.oldest_.older=null):(n.newer.older=n.older,n.older.newer=n.newer),n.newer=null,n.older=this.newest_,this.newest_.newer=n,this.newest_=n),n.value_}remove(t){const e=this.entries_[t];return vt(e!==void 0,"Tried to get a value for a key that does not exist in the cache"),e===this.newest_?(this.newest_=e.older,this.newest_&&(this.newest_.newer=null)):e===this.oldest_?(this.oldest_=e.newer,this.oldest_&&(this.oldest_.older=null)):(e.newer.older=e.older,e.older.newer=e.newer),delete this.entries_[t],--this.count_,e.value_}getCount(){return this.count_}getKeys(){const t=new Array(this.count_);let e=0,n;for(n=this.newest_;n;n=n.older)t[e++]=n.key_;return t}getValues(){const t=new Array(this.count_);let e=0,n;for(n=this.newest_;n;n=n.older)t[e++]=n.value_;return t}peekLast(){return this.oldest_.value_}peekLastKey(){return this.oldest_.key_}peekFirstKey(){return this.newest_.key_}peek(t){return this.entries_[t]?.value_}pop(){const t=this.oldest_;return delete this.entries_[t.key_],t.newer&&(t.newer.older=null),this.oldest_=t.newer,this.oldest_||(this.newest_=null),--this.count_,t.value_}replace(t,e){this.get(t),this.entries_[t].value_=e}set(t,e){vt(!(t in this.entries_),"Tried to set a value for a key that is used already");const n={key_:t,newer:null,older:this.newest_,value_:e};this.newest_?this.newest_.newer=n:this.oldest_=n,this.newest_=n,this.entries_[t]=n,++this.count_}setSize(t){this.highWaterMark=t}}function Wr(i,t,e,n){return n!==void 0?(n[0]=i,n[1]=t,n[2]=e,n):[i,t,e]}function D2(i,t,e){return i+"/"+t+"/"+e}function Wu(i){return N2(i[0],i[1],i[2])}function N2(i,t,e){return(t<<i)+e}function F2(i,t){const e=i[0],n=i[1],s=i[2];if(t.getMinZoom()>e||e>t.getMaxZoom())return!1;const r=t.getFullTileRange(e);return r?r.containsXY(n,s):!0}function Ua(i,t,e,n,s){return`${_t(i)},${t},${D2(e,n,s)}`}function Wa(i,t,e){if(!(e in i))return i[e]=new Set([t]),!0;const n=i[e],s=n.has(t);return s||n.add(t),!s}function k2(i,t,e){const n=i[e];return n?n.delete(t):!1}function Wl(i,t){const e=i.layerStatesArray[i.layerIndex];e.extent&&(t=ai(t,qe(e.extent,i.viewState.projection)));const n=e.layer.getRenderSource();if(!n.getWrapX()){const s=n.getTileGridForProjection(i.viewState.projection).getExtent();s&&(t=ai(t,s))}return t}class z2 extends Ko{constructor(t,e){super(t),e=e||{},this.extentChanged=!0,this.renderComplete=!1,this.renderedExtent_=null,this.renderedPixelRatio,this.renderedProjection=null,this.renderedTiles=[],this.renderedSourceKey_,this.renderedSourceRevision_,this.tempExtent=fe(),this.tempTileRange_=new rh(0,0,0,0),this.tempTileCoord_=Wr(0,0,0);const n=e.cacheSize!==void 0?e.cacheSize:512;this.tileCache_=new O2(n),this.maxStaleKeys=n*.5}getTileCache(){return this.tileCache_}getOrCreateTile(t,e,n,s){const r=this.tileCache_,o=this.getLayer().getSource(),h=Ua(o,o.getKey(),t,e,n);let l;if(r.containsKey(h))l=r.get(h);else{if(l=o.getTile(t,e,n,s.pixelRatio,s.viewState.projection),!l)return null;r.set(h,l)}return l}getTile(t,e,n,s){const r=this.getOrCreateTile(t,e,n,s);return r||null}getData(t){const e=this.frameState;if(!e)return null;const n=this.getLayer(),s=Ut(e.pixelToCoordinateTransform,t.slice()),r=n.getExtent();if(r&&!Zi(r,s))return null;const a=e.viewState,o=n.getRenderSource(),h=o.getTileGridForProjection(a.projection),l=o.getTilePixelRatio(e.pixelRatio);for(let c=h.getZForResolution(a.resolution);c>=h.getMinZoom();--c){const u=h.getTileCoordForCoordAndZ(s,c),d=this.getTile(c,u[1],u[2],e);if(!d||d.getState()!==$.LOADED)continue;const f=h.getOrigin(c),g=de(h.getTileSize(c)),_=h.getResolution(c);let m;if(d instanceof Nu||d instanceof Uu)m=d.getImage();else if(d instanceof kl){if(m=uo(d.getData()),!m)continue}else continue;const y=Math.floor(l*((s[0]-f[0])/_-u[1]*g[0])),p=Math.floor(l*((f[1]-s[1])/_-u[2]*g[1])),x=Math.round(l*o.getGutterForProjection(a.projection));return this.getImageData(m,y+x,p+x)}return null}prepareFrame(t){this.renderedProjection?t.viewState.projection!==this.renderedProjection&&(this.tileCache_.clear(),this.renderedProjection=t.viewState.projection):this.renderedProjection=t.viewState.projection;const e=this.getLayer().getSource();if(!e)return!1;const n=e.getRevision();return this.renderedSourceRevision_?this.renderedSourceRevision_!==n&&(this.renderedSourceRevision_=n,this.renderedSourceKey_===e.getKey()&&this.tileCache_.clear()):this.renderedSourceRevision_=n,!0}enqueueTiles(t,e,n,s,r){const a=t.viewState,o=this.getLayer(),h=o.getRenderSource(),l=h.getTileGridForProjection(a.projection),c=_t(h);c in t.wantedTiles||(t.wantedTiles[c]={});const u=t.wantedTiles[c],d=o.getMapInternal(),f=Math.max(n-r,l.getMinZoom(),l.getZForResolution(Math.min(o.getMaxResolution(),d?d.getView().getResolutionForZoom(Math.max(o.getMinZoom(),0)):l.getResolution(0)),h.zDirection)),g=a.rotation,_=g?nc(a.center,a.resolution,g,t.size):void 0;for(let m=n;m>=f;--m){const y=l.getTileRangeForExtentAndZ(e,m,this.tempTileRange_),p=l.getResolution(m);for(let x=y.minX;x<=y.maxX;++x)for(let v=y.minY;v<=y.maxY;++v){if(g&&!l.tileCoordIntersectsViewport([m,x,v],_))continue;const M=this.getTile(m,x,v,t);if(!M||!Wa(s,M,m))continue;const P=M.getKey();if(u[P]=!0,M.getState()===$.IDLE&&!t.tileQueue.isKeyQueued(P)){const b=Wr(m,x,v,this.tempTileCoord_);t.tileQueue.enqueue([M,c,l.getTileCoordCenter(b),p])}}}}findStaleTile_(t,e){const n=this.tileCache_,s=t[0],r=t[1],a=t[2],o=this.getStaleKeys();for(let h=0;h<o.length;++h){const l=Ua(this.getLayer().getSource(),o[h],s,r,a);if(n.containsKey(l)){const c=n.peek(l);if(c.getState()===$.LOADED)return c.endTransition(_t(this)),Wa(e,c,s),!0}}return!1}findAltTiles_(t,e,n,s){const r=t.getTileRangeForTileCoordAndZ(e,n,this.tempTileRange_);if(!r)return!1;let a=!0;const o=this.tileCache_,h=this.getLayer().getRenderSource(),l=h.getKey();for(let c=r.minX;c<=r.maxX;++c)for(let u=r.minY;u<=r.maxY;++u){const d=Ua(h,l,n,c,u);let f=!1;if(o.containsKey(d)){const g=o.peek(d);g.getState()===$.LOADED&&(Wa(s,g,n),f=!0)}f||(a=!1)}return a}renderFrame(t,e){this.renderComplete=!0;const n=t.layerStatesArray[t.layerIndex],s=t.viewState,r=s.projection,a=s.resolution,o=s.center,h=t.pixelRatio,l=this.getLayer(),c=l.getSource(),u=c.getTileGridForProjection(r),d=u.getZForResolution(a,c.zDirection),f=u.getResolution(d),g=c.getKey();this.renderedSourceKey_?this.renderedSourceKey_!==g&&(this.prependStaleKey(this.renderedSourceKey_),this.renderedSourceKey_=g):this.renderedSourceKey_=g;let _=t.extent;const m=c.getTilePixelRatio(h);this.prepareContainer(t,e);const y=this.context.canvas.width,p=this.context.canvas.height,x=n.extent&&qe(n.extent,r);x&&(_=ai(_,qe(n.extent,r)));const v=f*y/2/m,M=f*p/2/m,C=[o[0]-v,o[1]-M,o[0]+v,o[1]+M],P={};this.renderedTiles.length=0;const b=l.getPreload();if(t.nextExtent){const w=u.getZForResolution(s.nextResolution,c.zDirection),S=Wl(t,t.nextExtent);this.enqueueTiles(t,S,w,P,b)}const L=Wl(t,_);if(this.enqueueTiles(t,L,d,P,0),b>0&&setTimeout(()=>{this.enqueueTiles(t,L,d-1,P,b-1)},0),!(d in P))return this.container;const N=_t(this),B=t.time;for(const w of P[d]){const S=w.getState();if(S===$.EMPTY)continue;const R=w.tileCoord;if(S===$.LOADED&&w.getAlpha(N,B)===1){w.endTransition(N);continue}if(S!==$.ERROR&&(this.renderComplete=!1),this.findStaleTile_(R,P)){k2(P,w,d),t.animate=!0;continue}if(this.findAltTiles_(u,R,d+1,P))continue;const I=u.getMinZoom();for(let D=d-1;D>=I&&!this.findAltTiles_(u,R,D,P);--D);}const U=f/a*h/m,z=this.getRenderContext(t);Ze(this.tempTransform,y/2,p/2,U,U,0,-y/2,-p/2),n.extent&&this.clipUnrotated(z,t,x),c.getInterpolate()||(z.imageSmoothingEnabled=!1),this.preRender(z,t);const Q=Object.keys(P).map(Number);Q.sort(ri);let X;const H=[],W=[];for(let w=Q.length-1;w>=0;--w){const S=Q[w],R=c.getTilePixelSize(S,h,r),E=u.getResolution(S)/f,I=R[0]*E*U,D=R[1]*E*U,K=u.getTileCoordForCoordAndZ(tn(C),S),at=u.getTileCoordExtent(K),Y=Ut(this.tempTransform,[m*(at[0]-C[0])/f,m*(C[3]-at[3])/f]),ot=m*c.getGutterForProjection(r);for(const q of P[S]){if(q.getState()!==$.LOADED)continue;const J=q.tileCoord,lt=K[1]-J[1],O=Math.round(Y[0]-(lt-1)*I),nt=K[2]-J[2],ht=Math.round(Y[1]-(nt-1)*D),ct=Math.round(Y[0]-lt*I),ut=Math.round(Y[1]-nt*D),pt=O-ct,xt=ht-ut,It=Q.length===1;let Rt=!1;X=[ct,ut,ct+pt,ut,ct+pt,ut+xt,ct,ut+xt];for(let st=0,it=H.length;st<it;++st)if(!It&&S<W[st]){const V=H[st];ie([ct,ut,ct+pt,ut+xt],[V[0],V[3],V[4],V[7]])&&(Rt||(z.save(),Rt=!0),z.beginPath(),z.moveTo(X[0],X[1]),z.lineTo(X[2],X[3]),z.lineTo(X[4],X[5]),z.lineTo(X[6],X[7]),z.moveTo(V[6],V[7]),z.lineTo(V[4],V[5]),z.lineTo(V[2],V[3]),z.lineTo(V[0],V[1]),z.clip())}H.push(X),W.push(S),this.drawTile(q,t,ct,ut,pt,xt,ot,It),Rt&&z.restore(),this.renderedTiles.unshift(q),this.updateUsedTiles(t.usedTiles,c,q)}}if(this.renderedResolution=f,this.extentChanged=!this.renderedExtent_||!Dn(this.renderedExtent_,C),this.renderedExtent_=C,this.renderedPixelRatio=h,this.postRender(this.context,t),n.extent&&z.restore(),z.imageSmoothingEnabled=!0,this.renderComplete){const w=(S,R)=>{const T=_t(c),E=R.wantedTiles[T],I=E?Object.keys(E).length:0;this.updateCacheSize(I),this.tileCache_.expireCache()};t.postRenderFunctions.push(w)}return this.container}updateCacheSize(t){this.tileCache_.highWaterMark=Math.max(this.tileCache_.highWaterMark,t*2)}drawTile(t,e,n,s,r,a,o,h){let l;if(t instanceof kl){if(l=uo(t.getData()),!l)throw new Error("Rendering array data is not yet supported")}else l=this.getTileImage(t);if(!l)return;const c=this.getRenderContext(e),u=_t(this),d=e.layerStatesArray[e.layerIndex],f=d.opacity*(h?t.getAlpha(u,e.time):1),g=f!==c.globalAlpha;g&&(c.save(),c.globalAlpha=f),c.drawImage(l,o,o,l.width-2*o,l.height-2*o,n,s,r,a),g&&c.restore(),f!==d.opacity?e.animate=!0:h&&t.endTransition(u)}getImage(){const t=this.context;return t?t.canvas:null}getTileImage(t){return t.getImage()}updateUsedTiles(t,e,n){const s=_t(e);s in t||(t[s]={}),t[s][n.getKey()]=!0}}const mr={PRELOAD:"preload",USE_INTERIM_TILES_ON_ERROR:"useInterimTilesOnError"};class U2 extends qs{constructor(t){t=t||{};const e=Object.assign({},t),n=t.cacheSize;delete t.cacheSize,delete e.preload,delete e.useInterimTilesOnError,super(e),this.on,this.once,this.un,this.cacheSize_=n,this.setPreload(t.preload!==void 0?t.preload:0),this.setUseInterimTilesOnError(t.useInterimTilesOnError!==void 0?t.useInterimTilesOnError:!0)}getCacheSize(){return this.cacheSize_}getPreload(){return this.get(mr.PRELOAD)}setPreload(t){this.set(mr.PRELOAD,t)}getUseInterimTilesOnError(){return this.get(mr.USE_INTERIM_TILES_ON_ERROR)}setUseInterimTilesOnError(t){this.set(mr.USE_INTERIM_TILES_ON_ERROR,t)}getData(t){return super.getData(t)}}class W2 extends U2{constructor(t){super(t)}createRenderer(){return new z2(this,{cacheSize:this.getCacheSize()})}}/**
 * @license
 * Copyright 2000-2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */function Ds(i){return[i.x,i.y]}function Bl(i){return i.map(t=>t.map(e=>Ds(e)))}function B2(i){return[i.width,i.height]}function fo(i){return i.toLowerCase().replace(/_/,"-")}function ah(i,t,e){if(!(t.length!==i.getLength()||i.getArray().some((r,a)=>r.id!==t[a])))return;const s=t.map(r=>e.lookup.get(r)).filter(r=>!!r);i.clear(),s.forEach(r=>i.push(r))}function Je(i){const t={...i};return Object.keys(i).forEach(e=>{i[e]===null&&delete t[e]}),t}/**
 * @license
 * Copyright 2000-2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */function oh(i,t,e){if(!i)throw new Error("Can not instantiate base class: ol/layer/Layer");return i.setOpacity(t.opacity),i.setVisible(t.visible),i.setZIndex(t.zIndex||void 0),i.setMinZoom(t.minZoom||-1/0),i.setMaxZoom(t.maxZoom||1/0),i.setBackground(t.background||void 0),i}function X2(i,t,e){return i||(i=new W2(Je({...t,source:e.lookup.get(t.source)}))),oh(i,t),i.setSource(e.lookup.get(t.source)),i}function Bu(i,t,e){return i||(i=new p_(Je({...t,source:e.lookup.get(t.source),style:void 0}))),oh(i,t),i.setSource(e.lookup.get(t.source)),i}function q2(i,t,e){i=Bu(i,t,e);const n=e.lookup.get(t.clusterStyle);return i.setStyle(s=>{const r=s.get("features").length;if(r===1){const o=s.get("features")[0];let h=o.getStyle();if(typeof h=="function"&&(h=h(o)),h)return h}const a=n?n.getText():null;return a&&a.setText(r.toString()),n}),i}function j2(i,t,e){return i||(i=new R2(Je({...t,source:e.lookup.get(t.source)}))),oh(i,t),i.setSource(e.lookup.get(t.source)),i}class Y2 extends aa{constructor(t){t=t||{},super({attributions:t.attributions,wrapX:t.wrapX}),this.resolution=void 0,this.distance=t.distance!==void 0?t.distance:20,this.minDistance=t.minDistance||0,this.interpolationRatio=0,this.features=[],this.geometryFunction=t.geometryFunction||function(e){const n=e.getGeometry();return vt(!n||n.getType()==="Point","The default `geometryFunction` can only handle `Point` or null geometries"),n},this.createCustomCluster_=t.createCluster,this.source=null,this.boundRefresh_=this.refresh.bind(this),this.updateDistance(this.distance,this.minDistance),this.setSource(t.source||null)}clear(t){this.features.length=0,super.clear(t)}getDistance(){return this.distance}getSource(){return this.source}loadFeatures(t,e,n){this.source?.loadFeatures(t,e,n),e!==this.resolution&&(this.resolution=e,this.refresh())}setDistance(t){this.updateDistance(t,this.minDistance)}setMinDistance(t){this.updateDistance(this.distance,t)}getMinDistance(){return this.minDistance}setSource(t){this.source&&this.source.removeEventListener(et.CHANGE,this.boundRefresh_),this.source=t,t&&t.addEventListener(et.CHANGE,this.boundRefresh_),this.refresh()}refresh(){this.clear(),this.cluster(),this.addFeatures(this.features)}updateDistance(t,e){const n=t===0?0:Math.min(e,t)/t,s=t!==this.distance||this.interpolationRatio!==n;this.distance=t,this.minDistance=e,this.interpolationRatio=n,s&&this.refresh()}cluster(){if(this.resolution===void 0||!this.source)return;const t=fe(),e=this.distance*this.resolution,n=this.source.getFeatures(),s={};for(let r=0,a=n.length;r<a;r++){const o=n[r];if(!(_t(o)in s)){const h=this.geometryFunction(o);if(h){const l=h.getCoordinates();vo(l,t),On(t,e,t);const c=this.source.getFeaturesInExtent(t).filter(function(u){const d=_t(u);return d in s?!1:(s[d]=!0,!0)});this.features.push(this.createCluster(c,t))}}}}createCluster(t,e){const n=[0,0];for(let o=t.length-1;o>=0;--o){const h=this.geometryFunction(t[o]);h?ac(n,h.getCoordinates()):t.splice(o,1)}oc(n,1/t.length);const s=Ve(e),r=this.interpolationRatio,a=new Po([n[0]*(1-r)+s[0]*r,n[1]*(1-r)+s[1]*r]);return this.createCustomCluster_?this.createCustomCluster_(a,t):new Vs({geometry:a,features:t})}}function go(i){return Array.isArray(i)?Math.min(...i):i}class K2 extends qc{constructor(t,e,n,s,r,a,o){let h=t.getExtent();h&&t.canWrapX()&&(h=h.slice(),h[0]=-1/0,h[2]=1/0);let l=e.getExtent();l&&e.canWrapX()&&(l=l.slice(),l[0]=-1/0,l[2]=1/0);const c=l?ai(n,l):n,u=Ve(c),d=Os(t,e,u,s),f=zu,g=new ku(t,e,c,h,d*f,s),_=g.calculateSourceExtent(),m=en(_)?null:a(_,d,r),y=m?j.IDLE:j.EMPTY,p=m?m.getPixelRatio():1;super(n,s,p,y),this.targetProj_=e,this.maxSourceExtent_=h,this.triangulation_=g,this.targetResolution_=s,this.targetExtent_=n,this.sourceImage_=m,this.sourcePixelRatio_=p,this.interpolate_=o,this.canvas_=null,this.sourceListenerKey_=null}disposeInternal(){this.state==j.LOADING&&this.unlistenSource_(),super.disposeInternal()}getImage(){return this.canvas_}getProjection(){return this.targetProj_}reproject_(){const t=this.sourceImage_.getState();if(t==j.LOADED){const e=gt(this.targetExtent_)/this.targetResolution_,n=Wt(this.targetExtent_)/this.targetResolution_;this.canvas_=Fu(e,n,this.sourcePixelRatio_,go(this.sourceImage_.getResolution()),this.maxSourceExtent_,this.targetResolution_,this.targetExtent_,this.triangulation_,[{extent:this.sourceImage_.getExtent(),image:this.sourceImage_.getImage()}],0,void 0,this.interpolate_,!0)}this.state=t,this.changed()}load(){if(this.state==j.IDLE){this.state=j.LOADING,this.changed();const t=this.sourceImage_.getState();t==j.LOADED||t==j.ERROR?this.reproject_():(this.sourceListenerKey_=mt(this.sourceImage_,et.CHANGE,e=>{const n=this.sourceImage_.getState();(n==j.LOADED||n==j.ERROR)&&(this.unlistenSource_(),this.reproject_())}),this.sourceImage_.load())}}unlistenSource_(){bt(this.sourceListenerKey_),this.sourceListenerKey_=null}}const Ci=4,Ba={IMAGELOADSTART:"imageloadstart",IMAGELOADEND:"imageloadend",IMAGELOADERROR:"imageloaderror"};class V2 extends We{constructor(t,e){super(t),this.image=e}}class Z2 extends Vo{constructor(t){super({attributions:t.attributions,projection:t.projection,state:t.state,interpolate:t.interpolate!==void 0?t.interpolate:!0}),this.on,this.once,this.un,this.loader=t.loader||null,this.resolutions_=t.resolutions!==void 0?t.resolutions:null,this.reprojectedImage_=null,this.reprojectedRevision_=0,this.image=null,this.wantedExtent_,this.wantedResolution_,this.static_=t.loader?t.loader.length===0:!1,this.wantedProjection_=null}getResolutions(){return this.resolutions_}setResolutions(t){this.resolutions_=t}findNearestResolution(t){const e=this.getResolutions();if(e){const n=qr(e,t,0);t=e[n]}return t}getImage(t,e,n,s){const r=this.getProjection();if(!r||!s||ds(r,s))return r&&(s=r),this.getImageInternal(t,e,n,s);if(this.reprojectedImage_){if(this.reprojectedRevision_==this.getRevision()&&ds(this.reprojectedImage_.getProjection(),s)&&this.reprojectedImage_.getResolution()==e&&Dn(this.reprojectedImage_.getExtent(),t))return this.reprojectedImage_;this.reprojectedImage_.dispose(),this.reprojectedImage_=null}return this.reprojectedImage_=new K2(r,s,t,e,n,(a,o,h)=>this.getImageInternal(a,o,h,r),this.getInterpolate()),this.reprojectedRevision_=this.getRevision(),this.reprojectedImage_}getImageInternal(t,e,n,s){if(this.loader){const r=Xu(t,e,n,1),a=this.findNearestResolution(e);if(this.image&&(this.static_||this.wantedProjection_===s&&(this.wantedExtent_&&xi(this.wantedExtent_,r)||xi(this.image.getExtent(),r))&&(this.wantedResolution_&&go(this.wantedResolution_)===a||go(this.image.getResolution())===a)))return this.image;this.wantedProjection_=s,this.wantedExtent_=r,this.wantedResolution_=a,this.image=new qc(r,a,n,this.loader),this.image.addEventListener(et.CHANGE,this.handleImageChange.bind(this))}return this.image}handleImageChange(t){const e=t.target;let n;switch(e.getState()){case j.LOADING:this.loading=!0,n=Ba.IMAGELOADSTART;break;case j.LOADED:this.loading=!1,n=Ba.IMAGELOADEND;break;case j.ERROR:this.loading=!1,n=Ba.IMAGELOADERROR;break;default:return}this.hasListener(n)&&this.dispatchEvent(new V2(n,e))}}function $2(i,t){i.getImage().src=t}function Xu(i,t,e,n){const s=t/e,r=Ve(i),a=Mi(gt(i)/s,Ci),o=Mi(Wt(i)/s,Ci),h=Mi((n-1)*a/2,Ci),l=a+2*h,c=Mi((n-1)*o/2,Ci),u=o+2*c;return vs(r,s,0,[l,u])}function hh(i,t){const e=[];Object.keys(t).forEach(function(s){t[s]!==null&&t[s]!==void 0&&e.push(s+"="+encodeURIComponent(t[s]))});const n=e.join("&");return i=i.replace(/[?&]$/,""),i+=i.includes("?")?"&":"?",i+n}const H2=/\{z\}/g,J2=/\{x\}/g,Q2=/\{y\}/g,tE=/\{-y\}/g;function eE(i,t,e,n,s){return i.replace(H2,t.toString()).replace(J2,e.toString()).replace(Q2,n.toString()).replace(tE,function(){if(s===void 0)throw new Error("If the URL template has a {-y} placeholder, the grid extent must be known");return(s-n).toString()})}function iE(i){const t=[];let e=/\{([a-z])-([a-z])\}/.exec(i);if(e){const n=e[1].charCodeAt(0),s=e[2].charCodeAt(0);let r;for(r=n;r<=s;++r)t.push(i.replace(e[0],String.fromCharCode(r)));return t}if(e=/\{(\d+)-(\d+)\}/.exec(i),e){const n=parseInt(e[2],10);for(let s=parseInt(e[1],10);s<=n;s++)t.push(i.replace(e[0],s.toString()));return t}return t.push(i),t}const Br="1.3.0",Xl=[101,101];function qu(i,t,e,n,s){s.WIDTH=e[0],s.HEIGHT=e[1];const r=n.getAxisOrientation(),a=Mo(s.VERSION,"1.3")>=0;s[a?"CRS":"SRS"]=n.getCode();const o=a&&r.startsWith("ne")?[t[1],t[0],t[3],t[2]]:t;return s.BBOX=o.join(","),hh(i,s)}function ju(i,t,e,n,s,r,a){r=Object.assign({REQUEST:"GetMap"},r);const o=t/e,h=[xh(gt(i)/o,Ci),xh(Wt(i)/o,Ci)];if(e!=1)switch(a){case"geoserver":const c=90*e+.5|0;"FORMAT_OPTIONS"in r?r.FORMAT_OPTIONS+=";dpi:"+c:r.FORMAT_OPTIONS="dpi:"+c;break;case"mapserver":r.MAP_RESOLUTION=90*e;break;case"carmentaserver":case"qgis":r.DPI=90*e;break;default:throw new Error("Unknown `serverType` configured")}return qu(s,i,h,n,r)}function Xr(i,t){return Object.assign({REQUEST:t,SERVICE:"WMS",VERSION:Br,FORMAT:"image/png",STYLES:"",TRANSPARENT:"TRUE"},i)}function nE(i){const t=i.hidpi===void 0?!0:i.hidpi,e=Gt(i.projection||"EPSG:3857"),n=i.ratio||1.5,s=i.load||Yc,r=i.crossOrigin??null;return(a,o,h)=>{a=Xu(a,o,h,n),h!=1&&(!t||i.serverType===void 0)&&(h=1);const l=ju(a,o,h,e,i.url,Xr(i.params,"GetMap"),i.serverType),c=new Image;return c.crossOrigin=r,s(c,l).then(u=>({image:u,extent:a,pixelRatio:h}))}}function sE(i,t,e){if(i.url===void 0)return;const n=Gt(i.projection||"EPSG:3857"),s=vs(t,e,0,Xl),r={QUERY_LAYERS:i.params.LAYERS,INFO_FORMAT:"application/json"};Object.assign(r,Xr(i.params,"GetFeatureInfo"),i.params);const a=En((t[0]-s[0])/e,Ci),o=En((s[3]-t[1])/e,Ci),h=Mo(r.VERSION,"1.3")>=0;return r[h?"I":"X"]=a,r[h?"J":"Y"]=o,qu(i.url,s,Xl,n,r)}function rE(i,t){if(i.url===void 0)return;const e={SERVICE:"WMS",VERSION:Br,REQUEST:"GetLegendGraphic",FORMAT:"image/png"};if(t!==void 0){const n=Gt(i.projection||"EPSG:3857").getMetersPerUnit()||1,s=28e-5;e.SCALE=t*n/s}if(Object.assign(e,i.params),i.params!==void 0&&e.LAYER===void 0){const n=e.LAYERS;if(!(!Array.isArray(n)||n.length!==1))return;e.LAYER=n}return hh(i.url,e)}class aE extends Z2{constructor(t){t=t||{},super({attributions:t.attributions,interpolate:t.interpolate,projection:t.projection,resolutions:t.resolutions}),this.crossOrigin_=t.crossOrigin!==void 0?t.crossOrigin:null,this.url_=t.url,this.imageLoadFunction_=t.imageLoadFunction!==void 0?t.imageLoadFunction:$2,this.params_=Object.assign({},t.params),this.serverType_=t.serverType,this.hidpi_=t.hidpi!==void 0?t.hidpi:!0,this.renderedRevision_=0,this.ratio_=t.ratio!==void 0?t.ratio:1.5,this.loaderProjection_=null}getFeatureInfoUrl(t,e,n,s){const r=Gt(n),a=this.getProjection();a&&a!==r&&(e=Os(a,r,t,e),t=Bn(t,r,a));const o={url:this.url_,params:{...this.params_,...s},projection:a||r};return sE(o,t,e)}getLegendUrl(t,e){return rE({url:this.url_,params:{...this.params_,...e}},t)}getParams(){return this.params_}getImageInternal(t,e,n,s){return this.url_===void 0?null:((!this.loader||this.loaderProjection_!==s)&&(this.loaderProjection_=s,this.loader=nE({crossOrigin:this.crossOrigin_,params:this.params_,projection:s,serverType:this.serverType_,hidpi:this.hidpi_,url:this.url_,ratio:this.ratio_,load:(r,a)=>(this.image.setImage(r),this.imageLoadFunction_(this.image,a),Yc(r))})),super.getImageInternal(t,e,n,s))}getImageLoadFunction(){return this.imageLoadFunction_}getUrl(){return this.url_}setImageLoadFunction(t){this.imageLoadFunction_=t,this.changed()}setUrl(t){t!=this.url_&&(this.url_=t,this.loader=null,this.changed())}setParams(t){this.params_=Object.assign({},t),this.changed()}updateParams(t){Object.assign(this.params_,t),this.changed()}changed(){this.image=null,super.changed()}}const fn=[0,0,0],yi=5;class Yu{constructor(t){this.minZoom=t.minZoom!==void 0?t.minZoom:0,this.resolutions_=t.resolutions,vt(gd(this.resolutions_,(s,r)=>r-s),"`resolutions` must be sorted in descending order");let e;if(!t.origins){for(let s=0,r=this.resolutions_.length-1;s<r;++s)if(!e)e=this.resolutions_[s]/this.resolutions_[s+1];else if(this.resolutions_[s]/this.resolutions_[s+1]!==e){e=void 0;break}}this.zoomFactor_=e,this.maxZoom=this.resolutions_.length-1,this.origin_=t.origin!==void 0?t.origin:null,this.origins_=null,t.origins!==void 0&&(this.origins_=t.origins,vt(this.origins_.length==this.resolutions_.length,"Number of `origins` and `resolutions` must be equal"));const n=t.extent;n!==void 0&&!this.origin_&&!this.origins_&&(this.origin_=tn(n)),vt(!this.origin_&&this.origins_||this.origin_&&!this.origins_,"Either `origin` or `origins` must be configured, never both"),this.tileSizes_=null,t.tileSizes!==void 0&&(this.tileSizes_=t.tileSizes,vt(this.tileSizes_.length==this.resolutions_.length,"Number of `tileSizes` and `resolutions` must be equal")),this.tileSize_=t.tileSize!==void 0?t.tileSize:this.tileSizes_?null:Fo,vt(!this.tileSize_&&this.tileSizes_||this.tileSize_&&!this.tileSizes_,"Either `tileSize` or `tileSizes` must be configured, never both"),this.extent_=n!==void 0?n:null,this.fullTileRanges_=null,this.tmpSize_=[0,0],this.tmpExtent_=[0,0,0,0],t.sizes!==void 0?this.fullTileRanges_=t.sizes.map((s,r)=>{const a=new rh(Math.min(0,s[0]),Math.max(s[0]-1,-1),Math.min(0,s[1]),Math.max(s[1]-1,-1));if(n){const o=this.getTileRangeForExtentAndZ(n,r);a.minX=Math.max(o.minX,a.minX),a.maxX=Math.min(o.maxX,a.maxX),a.minY=Math.max(o.minY,a.minY),a.maxY=Math.min(o.maxY,a.maxY)}return a}):n&&this.calculateTileRanges_(n)}forEachTileCoord(t,e,n){const s=this.getTileRangeForExtentAndZ(t,e);for(let r=s.minX,a=s.maxX;r<=a;++r)for(let o=s.minY,h=s.maxY;o<=h;++o)n([e,r,o])}forEachTileCoordParentTileRange(t,e,n,s){let r,a,o,h=null,l=t[0]-1;for(this.zoomFactor_===2?(a=t[1],o=t[2]):h=this.getTileCoordExtent(t,s);l>=this.minZoom;){if(a!==void 0&&o!==void 0?(a=Math.floor(a/2),o=Math.floor(o/2),r=dn(a,a,o,o,n)):r=this.getTileRangeForExtentAndZ(h,l,n),e(l,r))return!0;--l}return!1}getExtent(){return this.extent_}getMaxZoom(){return this.maxZoom}getMinZoom(){return this.minZoom}getOrigin(t){return this.origin_?this.origin_:this.origins_[t]}getResolution(t){return this.resolutions_[t]}getResolutions(){return this.resolutions_}getTileCoordChildTileRange(t,e,n){if(t[0]<this.maxZoom){if(this.zoomFactor_===2){const r=t[1]*2,a=t[2]*2;return dn(r,r+1,a,a+1,e)}const s=this.getTileCoordExtent(t,n||this.tmpExtent_);return this.getTileRangeForExtentAndZ(s,t[0]+1,e)}return null}getTileRangeForTileCoordAndZ(t,e,n){if(e>this.maxZoom||e<this.minZoom)return null;const s=t[0],r=t[1],a=t[2];if(e===s)return dn(r,a,r,a,n);if(this.zoomFactor_){const h=Math.pow(this.zoomFactor_,e-s),l=Math.floor(r*h),c=Math.floor(a*h);if(e<s)return dn(l,l,c,c,n);const u=Math.floor(h*(r+1))-1,d=Math.floor(h*(a+1))-1;return dn(l,u,c,d,n)}const o=this.getTileCoordExtent(t,this.tmpExtent_);return this.getTileRangeForExtentAndZ(o,e,n)}getTileRangeForExtentAndZ(t,e,n){this.getTileCoordForXYAndZ_(t[0],t[3],e,!1,fn);const s=fn[1],r=fn[2];this.getTileCoordForXYAndZ_(t[2],t[1],e,!0,fn);const a=fn[1],o=fn[2];return dn(s,a,r,o,n)}getTileCoordCenter(t){const e=this.getOrigin(t[0]),n=this.getResolution(t[0]),s=de(this.getTileSize(t[0]),this.tmpSize_);return[e[0]+(t[1]+.5)*s[0]*n,e[1]-(t[2]+.5)*s[1]*n]}getTileCoordExtent(t,e){const n=this.getOrigin(t[0]),s=this.getResolution(t[0]),r=de(this.getTileSize(t[0]),this.tmpSize_),a=n[0]+t[1]*r[0]*s,o=n[1]-(t[2]+1)*r[1]*s,h=a+r[0]*s,l=o+r[1]*s;return li(a,o,h,l,e)}getTileCoordForCoordAndResolution(t,e,n){return this.getTileCoordForXYAndResolution_(t[0],t[1],e,!1,n)}getTileCoordForXYAndResolution_(t,e,n,s,r){const a=this.getZForResolution(n),o=n/this.getResolution(a),h=this.getOrigin(a),l=de(this.getTileSize(a),this.tmpSize_);let c=o*(t-h[0])/n/l[0],u=o*(h[1]-e)/n/l[1];return s?(c=Mi(c,yi)-1,u=Mi(u,yi)-1):(c=En(c,yi),u=En(u,yi)),Wr(a,c,u,r)}getTileCoordForXYAndZ_(t,e,n,s,r){const a=this.getOrigin(n),o=this.getResolution(n),h=de(this.getTileSize(n),this.tmpSize_);let l=(t-a[0])/o/h[0],c=(a[1]-e)/o/h[1];return s?(l=Mi(l,yi)-1,c=Mi(c,yi)-1):(l=En(l,yi),c=En(c,yi)),Wr(n,l,c,r)}getTileCoordForCoordAndZ(t,e,n){return this.getTileCoordForXYAndZ_(t[0],t[1],e,!1,n)}getTileCoordResolution(t){return this.resolutions_[t[0]]}getTileSize(t){return this.tileSize_?this.tileSize_:this.tileSizes_[t]}getFullTileRange(t){return this.fullTileRanges_?this.fullTileRanges_[t]:this.extent_?this.getTileRangeForExtentAndZ(this.extent_,t):null}getZForResolution(t,e){const n=qr(this.resolutions_,t,e||0);return Pt(n,this.minZoom,this.maxZoom)}tileCoordIntersectsViewport(t,e){return Tc(e,0,e.length,2,this.getTileCoordExtent(t))}calculateTileRanges_(t){const e=this.resolutions_.length,n=new Array(e);for(let s=this.minZoom;s<e;++s)n[s]=this.getTileRangeForExtentAndZ(t,s);this.fullTileRanges_=n}}function Ku(i){let t=i.getDefaultTileGrid();return t||(t=cE(i),i.setDefaultTileGrid(t)),t}function oE(i,t,e){const n=t[0],s=i.getTileCoordCenter(t),r=lh(e);if(!Zi(r,s)){const a=gt(r),o=Math.ceil((r[0]-s[0])/a);return s[0]+=a*o,i.getTileCoordForCoordAndZ(s,n)}return t}function hE(i,t,e,n){n=n!==void 0?n:"top-left";const s=Vu(i,t,e);return new Yu({extent:i,origin:Id(i,n),resolutions:s,tileSize:e})}function lE(i){const t=i||{},e=t.extent||Gt("EPSG:3857").getExtent(),n={extent:e,minZoom:t.minZoom,tileSize:t.tileSize,resolutions:Vu(e,t.maxZoom,t.tileSize,t.maxResolution)};return new Yu(n)}function Vu(i,t,e,n){t=t!==void 0?t:jf,e=de(e!==void 0?e:Fo);const s=Wt(i),r=gt(i);n=n>0?n:Math.max(r/e[0],s/e[1]);const a=t+1,o=new Array(a);for(let h=0;h<a;++h)o[h]=n/Math.pow(2,h);return o}function cE(i,t,e,n){const s=lh(i);return hE(s,t,e,n)}function lh(i){i=Gt(i);let t=i.getExtent();if(!t){const e=180*So.degrees/i.getMetersPerUnit();t=li(-e,-e,e,e)}return t}function uE(i,t){return(function(e,n,s){if(!e)return;let r;const a=e[0];if(t){const o=t.getFullTileRange(a);o&&(r=o.getHeight()-1)}return eE(i,a,e[1],e[2],r)})}function dE(i,t){const e=i.length,n=new Array(e);for(let s=0;s<e;++s)n[s]=uE(i[s],t);return fE(n)}function fE(i){return i.length===1?i[0]:(function(t,e,n){if(!t)return;const s=Wu(t),r=Yi(s,i.length);return i[r](t,e,n)})}class gE extends Vo{constructor(t){super({attributions:t.attributions,attributionsCollapsible:t.attributionsCollapsible,projection:t.projection,state:t.state,wrapX:t.wrapX,interpolate:t.interpolate}),this.on,this.once,this.un,this.tilePixelRatio_=t.tilePixelRatio!==void 0?t.tilePixelRatio:1,this.tileGrid=t.tileGrid!==void 0?t.tileGrid:null;const e=[256,256];this.tileGrid&&de(this.tileGrid.getTileSize(this.tileGrid.getMinZoom()),e),this.tmpSize=[0,0],this.key_=t.key||_t(this),this.tileOptions={transition:t.transition,interpolate:t.interpolate},this.zDirection=t.zDirection?t.zDirection:0}getGutterForProjection(t){return 0}getKey(){return this.key_}setKey(t){this.key_!==t&&(this.key_=t,this.changed())}getResolutions(t){const e=t?this.getTileGridForProjection(t):this.tileGrid;return e?e.getResolutions():null}getTile(t,e,n,s,r){return yt()}getTileGrid(){return this.tileGrid}getTileGridForProjection(t){return this.tileGrid?this.tileGrid:Ku(t)}getTilePixelRatio(t){return this.tilePixelRatio_}getTilePixelSize(t,e,n){const s=this.getTileGridForProjection(n),r=this.getTilePixelRatio(e),a=de(s.getTileSize(t),this.tmpSize);return r==1?a:G0(a,r,this.tmpSize)}getTileCoordForTileUrlFunction(t,e){const n=e!==void 0?e:this.getProjection(),s=e!==void 0?this.getTileGridForProjection(n):this.tileGrid||this.getTileGridForProjection(n);return this.getWrapX()&&n.isGlobal()&&(t=oE(s,t,n)),F2(t,s)?t:null}clear(){}refresh(){this.clear(),super.refresh()}}class _E extends We{constructor(t,e){super(t),this.tile=e}}const Xa={TILELOADSTART:"tileloadstart",TILELOADEND:"tileloadend",TILELOADERROR:"tileloaderror"};class ch extends gE{constructor(t){super({attributions:t.attributions,cacheSize:t.cacheSize,projection:t.projection,state:t.state,tileGrid:t.tileGrid,tilePixelRatio:t.tilePixelRatio,wrapX:t.wrapX,transition:t.transition,interpolate:t.interpolate,key:t.key,attributionsCollapsible:t.attributionsCollapsible,zDirection:t.zDirection}),this.generateTileUrlFunction_=this.tileUrlFunction===ch.prototype.tileUrlFunction,this.tileLoadFunction=t.tileLoadFunction,t.tileUrlFunction&&(this.tileUrlFunction=t.tileUrlFunction),this.urls=null,t.urls?this.setUrls(t.urls):t.url&&this.setUrl(t.url),this.tileLoadingKeys_={}}getTileLoadFunction(){return this.tileLoadFunction}getTileUrlFunction(){return Object.getPrototypeOf(this).tileUrlFunction===this.tileUrlFunction?this.tileUrlFunction.bind(this):this.tileUrlFunction}getUrls(){return this.urls}handleTileChange(t){const e=t.target,n=_t(e),s=e.getState();let r;s==$.LOADING?(this.tileLoadingKeys_[n]=!0,r=Xa.TILELOADSTART):n in this.tileLoadingKeys_&&(delete this.tileLoadingKeys_[n],r=s==$.ERROR?Xa.TILELOADERROR:s==$.LOADED?Xa.TILELOADEND:void 0),r!=null&&this.dispatchEvent(new _E(r,e))}setTileLoadFunction(t){this.tileLoadFunction=t,this.changed()}setTileUrlFunction(t,e){this.tileUrlFunction=t,typeof e<"u"?this.setKey(e):this.changed()}setUrl(t){const e=iE(t);this.urls=e,this.setUrls(e)}setUrls(t){this.urls=t;const e=t.join(`
`);this.generateTileUrlFunction_?this.setTileUrlFunction(dE(t,this.tileGrid),e):this.setKey(e)}tileUrlFunction(t,e,n){}}class Zu extends ch{constructor(t){super({attributions:t.attributions,cacheSize:t.cacheSize,projection:t.projection,state:t.state,tileGrid:t.tileGrid,tileLoadFunction:t.tileLoadFunction?t.tileLoadFunction:mE,tilePixelRatio:t.tilePixelRatio,tileUrlFunction:t.tileUrlFunction,url:t.url,urls:t.urls,wrapX:t.wrapX,transition:t.transition,interpolate:t.interpolate!==void 0?t.interpolate:!0,key:t.key,attributionsCollapsible:t.attributionsCollapsible,zDirection:t.zDirection}),this.crossOrigin=t.crossOrigin!==void 0?t.crossOrigin:null,this.tileClass=t.tileClass!==void 0?t.tileClass:Nu,this.tileGridForProjection={},this.reprojectionErrorThreshold_=t.reprojectionErrorThreshold,this.renderReprojectionEdges_=!1}getGutterForProjection(t){return this.getProjection()&&t&&!ds(this.getProjection(),t)?0:this.getGutter()}getGutter(){return 0}getKey(){let t=super.getKey();return this.getInterpolate()||(t+=":disable-interpolation"),t}getTileGridForProjection(t){const e=this.getProjection();if(this.tileGrid&&(!e||ds(e,t)))return this.tileGrid;const n=_t(t);return n in this.tileGridForProjection||(this.tileGridForProjection[n]=Ku(t)),this.tileGridForProjection[n]}createTile_(t,e,n,s,r,a){const o=[t,e,n],h=this.getTileCoordForTileUrlFunction(o,r),l=h?this.tileUrlFunction(h,s,r):void 0,c=new this.tileClass(o,l!==void 0?$.IDLE:$.EMPTY,l!==void 0?l:"",this.crossOrigin,this.tileLoadFunction,this.tileOptions);return c.key=a,c.addEventListener(et.CHANGE,this.handleTileChange.bind(this)),c}getTile(t,e,n,s,r){const a=this.getProjection();if(!a||!r||ds(a,r))return this.getTileInternal(t,e,n,s,a||r);const o=[t,e,n],h=this.getKey(),l=this.getTileGridForProjection(a),c=this.getTileGridForProjection(r),u=this.getTileCoordForTileUrlFunction(o,r),d=new Uu(a,l,r,c,o,u,this.getTilePixelRatio(s),this.getGutter(),(f,g,_,m)=>this.getTileInternal(f,g,_,m,a),this.reprojectionErrorThreshold_,this.renderReprojectionEdges_,this.tileOptions);return d.key=h,d}getTileInternal(t,e,n,s,r){const a=this.getKey();return this.createTile_(t,e,n,s,r,a)}setRenderReprojectionEdges(t){this.renderReprojectionEdges_!=t&&(this.renderReprojectionEdges_=t,this.changed())}setTileGridForProjection(t,e){const n=Gt(t);if(n){const s=_t(n);s in this.tileGridForProjection||(this.tileGridForProjection[s]=e)}}}function mE(i,t){i.getImage().src=t}class $u extends Zu{constructor(t){t=t||{};const e=t.projection!==void 0?t.projection:"EPSG:3857",n=t.tileGrid!==void 0?t.tileGrid:lE({extent:lh(e),maxResolution:t.maxResolution,maxZoom:t.maxZoom,minZoom:t.minZoom,tileSize:t.tileSize});super({attributions:t.attributions,cacheSize:t.cacheSize,crossOrigin:t.crossOrigin,interpolate:t.interpolate,projection:e,reprojectionErrorThreshold:t.reprojectionErrorThreshold,tileGrid:n,tileLoadFunction:t.tileLoadFunction,tilePixelRatio:t.tilePixelRatio,tileUrlFunction:t.tileUrlFunction,url:t.url,urls:t.urls,wrapX:t.wrapX!==void 0?t.wrapX:!0,transition:t.transition,attributionsCollapsible:t.attributionsCollapsible,zDirection:t.zDirection}),this.gutter_=t.gutter!==void 0?t.gutter:0}getGutter(){return this.gutter_}}const Hu='&#169; <a href="https://www.openstreetmap.org/copyright" target="_blank">OpenStreetMap</a> contributors.';class yE extends $u{constructor(t){t=t||{};let e;t.attributions!==void 0?e=t.attributions:e=[Hu];const n=t.crossOrigin!==void 0?t.crossOrigin:"anonymous",s=t.url!==void 0?t.url:"https://tile.openstreetmap.org/{z}/{x}/{y}.png";super({attributions:e,attributionsCollapsible:!1,cacheSize:t.cacheSize,crossOrigin:n,interpolate:t.interpolate,maxZoom:t.maxZoom!==void 0?t.maxZoom:19,reprojectionErrorThreshold:t.reprojectionErrorThreshold,tileLoadFunction:t.tileLoadFunction,transition:t.transition,url:s,wrapX:t.wrapX,zDirection:t.zDirection})}}class pE extends Zu{constructor(t){t=t||{};const e=Object.assign({},t.params);super({attributions:t.attributions,attributionsCollapsible:t.attributionsCollapsible,cacheSize:t.cacheSize,crossOrigin:t.crossOrigin,interpolate:t.interpolate,projection:t.projection,reprojectionErrorThreshold:t.reprojectionErrorThreshold,tileClass:t.tileClass,tileGrid:t.tileGrid,tileLoadFunction:t.tileLoadFunction,url:t.url,urls:t.urls,wrapX:t.wrapX!==void 0?t.wrapX:!0,transition:t.transition,zDirection:t.zDirection}),this.gutter_=t.gutter!==void 0?t.gutter:0,this.params_=e,this.v13_=!0,this.serverType_=t.serverType,this.hidpi_=t.hidpi!==void 0?t.hidpi:!0,this.tmpExtent_=fe(),this.updateV13_(),this.setKey(this.getKeyForParams_())}getFeatureInfoUrl(t,e,n,s){const r=Gt(n),a=this.getProjection()||r;let o=this.getTileGrid();o||(o=this.getTileGridForProjection(a));const h=Bn(t,r,a),l=Os(a,r,t,e),c=o.getZForResolution(l,this.zDirection),u=o.getResolution(c),d=o.getTileCoordForCoordAndZ(h,c);if(o.getResolutions().length<=d[0])return;let f=o.getTileCoordExtent(d,this.tmpExtent_);const g=this.gutter_;g!==0&&(f=On(f,u*g,f));const _={QUERY_LAYERS:this.params_.LAYERS};Object.assign(_,Xr(this.params_,"GetFeatureInfo"),s);const m=Math.floor((h[0]-f[0])/u),y=Math.floor((f[3]-h[1])/u);return _[this.v13_?"I":"X"]=m,_[this.v13_?"J":"Y"]=y,this.getRequestUrl_(d,f,1,a||r,_)}getLegendUrl(t,e){if(this.urls[0]===void 0)return;const n={SERVICE:"WMS",VERSION:Br,REQUEST:"GetLegendGraphic",FORMAT:"image/png"};if(e===void 0||e.LAYER===void 0){const s=this.params_.LAYERS;if(!(!Array.isArray(s)||s.length===1))return;n.LAYER=s}if(t!==void 0){const s=this.getProjection()?this.getProjection().getMetersPerUnit():1,r=28e-5;n.SCALE=t*s/r}return Object.assign(n,e),hh(this.urls[0],n)}getGutter(){return this.gutter_}getParams(){return this.params_}getRequestUrl_(t,e,n,s,r){const a=this.urls;if(!a)return;let o;if(a.length==1)o=a[0];else{const h=Yi(Wu(t),a.length);o=a[h]}return ju(e,(this.tileGrid||this.getTileGridForProjection(s)).getResolution(t[0]),n,s,o,r,this.serverType_)}getTilePixelRatio(t){return!this.hidpi_||this.serverType_===void 0?1:t}getKeyForParams_(){let t=0;const e=[];for(const n in this.params_)e[t++]=n+"-"+this.params_[n];return e.join("/")}setParams_(t){this.params_=t,this.updateV13_(),this.setKey(this.getKeyForParams_())}setParams(t){this.setParams_(Object.assign({},t))}updateParams(t){this.setParams_(Object.assign(this.params_,t))}updateV13_(){const t=this.params_.VERSION||Br;this.v13_=Mo(t,"1.3")>=0}tileUrlFunction(t,e,n){let s=this.getTileGrid();if(s||(s=this.getTileGridForProjection(n)),s.getResolutions().length<=t[0])return;e!=1&&(!this.hidpi_||this.serverType_===void 0)&&(e=1);const r=s.getResolution(t[0]);let a=s.getTileCoordExtent(t,this.tmpExtent_);const o=this.gutter_;o!==0&&(a=On(a,r*o,a));const h=Object.assign({},Xr(this.params_,"GetMap"));return this.getRequestUrl_(t,a,e,n,h)}}/**
 * @license
 * Copyright 2000-2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */function uh(i,t,e){if(!i)throw new Error("Can not instantiate base class: ol/source/Source");return i.setAttributions(t.attributions),i}function EE(i,t,e){if(!i)throw new Error("Can not instantiate base class: ol/source/Tile");return uh(i,t),i}function vE(i,t,e){if(!i)throw new Error("Can not instantiate base class: ol/source/UrlTile");return EE(i,t),t.url&&i.setUrl(t.url),i}function Ju(i,t,e){if(!i)throw new Error("Can not instantiate base class: ol/source/TileImage");return vE(i,t),i}function xE(i,t,e){return i||(i=new pE(Je(t))),Ju(i,t),i}function Qu(i,t,e){return i||(i=new $u(Je(t))),Ju(i,t),i}function ME(i,t,e){return i||(i=new yE(Je(t))),t.attributions||(t.attributions=Hu),Qu(i,t),i}function wE(i,t,e){if(!i)throw new Error("Can not instantiate base class: ol/source/Image");return uh(i,t),i}function SE(i,t,e){return i||(i=new aE(Je(t))),wE(i,t),t.url&&i.setUrl(t.url),i}function CE(i,t,e){return i||(i=new aa(Je({...t,features:new ne}))),uh(i,t),ah(i.getFeaturesCollection(),t.features,e),i}function IE(i,t,e){return i||(i=new Y2(Je({...t,source:new aa({features:new ne})}))),i.setDistance(t.distance),i.setMinDistance(t.minDistance),ah(i.getSource().getFeaturesCollection(),t.features,e),i}/**
 * @license
 * Copyright 2000-2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */function RE(i,t,e){return i||(i=new sn),i.setColor(t.color),e.connector.forceRender(),i}function AE(i,t,e){return i||(i=new Yn),i.setColor(t.color),i.setWidth(t.width),e.connector.forceRender(),i}function TE(i,t,e){if(!i)throw new Error("Can not instantiate base class: ol/style/Image");return i.setOpacity(t.opacity),i.setRotateWithView(t.rotateWithView),i.setRotation(t.rotation),i.setScale(t.scale),i}function bE(i,t,e){if(!i){const n=t.img||t.src;i=new js(Je({...t,img:void 0,src:n,imgSize:t.imgSize?B2(t.imgSize):void 0,anchor:t.anchor?Ds(t.anchor):void 0,anchorOrigin:t.anchorOrigin?fo(t.anchorOrigin):void 0}))}return TE(i,t),e.connector.forceRender(),i}function PE(i,t,e){return i||(i=new Ys),i.setFont(t.font),i.setOffsetX(t.offset&&t.offset.x||0),i.setOffsetY(t.offset&&t.offset.y||0),i.setScale(t.scale),i.setRotation(t.rotation),i.setRotateWithView(t.rotateWithView),i.setTextAlign(t.textAlign?fo(t.textAlign):void 0),i.setTextBaseline(t.textBaseline?fo(t.textBaseline):void 0),i.setFill(t.fill?e.lookup.get(t.fill):void 0),i.setStroke(t.stroke?e.lookup.get(t.stroke):void 0),i.setBackgroundFill(t.backgroundFill?e.lookup.get(t.backgroundFill):void 0),i.setBackgroundStroke(t.backgroundStroke?e.lookup.get(t.backgroundStroke):void 0),i.setPadding([t.padding,t.padding,t.padding,t.padding]),e.connector.forceRender(),i}function LE(i,t,e){return i||(i=new Ai),i.setImage(t.image?e.lookup.get(t.image):void 0),i.setFill(t.fill?e.lookup.get(t.fill):void 0),i.setStroke(t.stroke?e.lookup.get(t.stroke):void 0),i.setText(t.text?e.lookup.get(t.text):void 0),e.connector.forceRender(),i}/**
 * @license
 * Copyright 2000-2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */const GE=new Ys({font:"13px sans-serif",offsetY:10,fill:new sn({color:"#333"}),stroke:new Yn({color:"#fff",width:3})});function OE(i,t,e){if(!i)throw new Error("Existing map instance must be provided");return ah(i.getLayers(),t.layers,e),i.setView(e.lookup.get(t.view)),i}function DE(i,t,e){return i||(i=new Be({projection:t.projection})),i.setCenter(t.center?Ds(t.center):[0,0]),i.setRotation(t.rotation||0),i.setZoom(t.zoom||0),i}function NE(i,t,e){return i||(i=new Po(Ds(t.coordinates))),i.setCoordinates(Ds(t.coordinates)),i}function FE(i,t,e){return i||(i=new Fn(Bl(t.coordinates))),i.setCoordinates(Bl(t.coordinates)),i}function kE(i,t,e){i||(i=new Vs),i.setGeometry(e.lookup.get(t.geometry));const n=e.lookup.get(t.style);return i.setStyle(()=>{if(n)return t.text&&!n.getText()&&n.setText(GE),n.getText()&&n.getText().setText(t.text),n}),i.draggable=t.draggable,i}const zE={"ol/Feature":kE,"ol/Map":OE,"ol/View":DE,"ol/layer/Feature":q2,"ol/layer/Image":j2,"ol/layer/Tile":X2,"ol/layer/Vector":Bu,"ol/source/Cluster":IE,"ol/source/ImageWMS":SE,"ol/source/OSM":ME,"ol/source/TileWMS":xE,"ol/source/Vector":CE,"ol/source/XYZ":Qu,"ol/geom/Point":NE,"ol/geom/Polygon":FE,"ol/style/Icon":bE,"ol/style/Fill":RE,"ol/style/Stroke":AE,"ol/style/Style":LE,"ol/style/Text":PE};function ql(i,t){const e=i.type;if(!e)throw new Error("Configuration object must have a type");if(!i.id)throw new Error("Configuration object must have an ID");let n=t.lookup.get(i.id);const s=zE[e];if(!s)throw new Error(`Unsupported configuration object type: ${e}`);return n=s(n,i,t),t.lookup.put(i.id,n),n.id=i.id,n.typeName=e,n}/**
 * @license
 * Copyright 2000-2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */class UE{constructor(){this.map=new Map}get(t){return this.map.get(t)}put(t,e){this.map.set(t,e)}}class WE{constructor(){this.map=new Map,this.registry=new FinalizationRegistry(t=>{this.map.delete(t)})}get(t){const e=this.map.get(t);return e?e.deref():void 0}put(t,e){if(this.map.has(t))return;const n=new WeakRef(e);this.map.set(t,n),this.registry.register(e,t)}}const BE=window.WeakRef&&window.FinalizationRegistry;function XE(){return BE?new WE:new UE}function jl(i,t){const e=i.getLayers().getArray().find(a=>{const o=a.getSource&&a.getSource();return o&&o instanceof aa&&o.getFeatures().includes(t)}),n=e&&e.getSource(),s=t.get("features");Array.isArray(s)&&s.length===1&&(t=s[0]);const r=Array.isArray(s)&&s.length>1;return{feature:t,layer:e,source:n,isCluster:r}}/**
 * @license
 * Copyright 2000-2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */yc("EPSG:4326");function qE(i){i.$connector={lookup:XE(),synchronize(e){const n={synchronize:ql,lookup:this.lookup,mapElement:i,connector:i.$connector};e.forEach(s=>{s.type==="ol/Map"&&this.lookup.put(s.id,i.configuration),ql(s,n)})},forceRender(){this._forceRenderTimeout||(this._forceRenderTimeout=setTimeout(()=>{this._forceRenderTimeout=null,i.configuration.getLayers().getArray().forEach(e=>e.changed())}))},zoomToFit(e,n){setTimeout(()=>{const s=e.map(c=>this.lookup.get(c)).filter(Boolean);if(s.length===0)return;let r;s.forEach(c=>{const u=c.getGeometry().getExtent();r?tc(r,u):r=u.slice()});const a=n?.padding??0,o=n?.duration??0,h=i.getBoundingClientRect(),l=[h.width,h.height];i.configuration.getView().fit(r,{padding:[a,a,a,a],duration:o,size:l})})}},i.configuration.on("moveend",e=>{const n=i.configuration.getView(),s=n.getCenter(),r=n.getRotation(),a=n.getZoom(),o=n.calculateExtent(),h=new CustomEvent("map-view-moveend",{detail:{center:s,rotation:r,zoom:a,extent:o}});i.dispatchEvent(h)}),i.configuration.on("singleclick",e=>{const n=e.coordinate,s=e.pixel,a=i.configuration.getFeaturesAtPixel(s).map(c=>jl(i.configuration,c)),o=a.filter(c=>c&&!c.isCluster),h=new CustomEvent("map-click",{detail:{coordinate:n,features:o,originalEvent:e.originalEvent}});if(i.dispatchEvent(h),o.length>0){const c=o[0],u=new CustomEvent("map-feature-click",{detail:{feature:c.feature,layer:c.layer,originalEvent:e.originalEvent}});i.dispatchEvent(u)}const l=a.filter(c=>c&&c.isCluster);if(l.length>0){const c=l[0],u=new CustomEvent("map-cluster-click",{detail:{features:c.feature.get("features"),layer:c.layer,originalEvent:e.originalEvent}});i.dispatchEvent(u)}});const t=new M_({filter(e){return!!e.draggable}});t.on("translateend",e=>{const n=e.features.item(0);if(!n)return;const s=jl(i.configuration,n),r=new CustomEvent("map-feature-drop",{detail:{feature:n,layer:s.layer,coordinate:e.coordinate,startCoordinate:e.startCoordinate}});i.dispatchEvent(r)}),i.configuration.addInteraction(t)}function jE(i){yc(i)}function YE(i,t){ge.defs(i,t),C_(ge)}window.Vaadin.Flow.mapConnector={init:qE,setUserProjection:jE,defineProjection:YE};
