import{i,a as addLumoGlobalStyles,r as registerStyles$1,f as f$1,T as ThemableMixin,b as i$1,c as b,d as defineCustomElement,t as themeRegistry,e as r$2,g as ThemePropertyMixin,A as A$1,D,h as addGlobalThemeStyles,j as i$2,k as t$1,l as e$2,E,w as w$1,m as color$h,n as typography,_ as __vitePreload,o as reactExports,p as clientExports,q as jsxRuntimeExports,O as Outlet}from"./indexhtml-DrWFOmDx.js";/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const userColors=i`
  :host {
    --vaadin-user-color-0: #df0b92;
    --vaadin-user-color-1: #650acc;
    --vaadin-user-color-2: #097faa;
    --vaadin-user-color-3: #ad6200;
    --vaadin-user-color-4: #bf16f3;
    --vaadin-user-color-5: #084391;
    --vaadin-user-color-6: #078836;
  }

  [theme~='dark'] {
    --vaadin-user-color-0: #ff66c7;
    --vaadin-user-color-1: #9d8aff;
    --vaadin-user-color-2: #8aff66;
    --vaadin-user-color-3: #ffbd66;
    --vaadin-user-color-4: #dc6bff;
    --vaadin-user-color-5: #66fffa;
    --vaadin-user-color-6: #e6ff66;
  }
`;addLumoGlobalStyles("user-color-props",userColors);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-field-outline",i`
    :host {
      transition: opacity 0.3s;
      -webkit-mask-image: none !important;
      mask-image: none !important;
    }

    :host::before {
      content: '';
      position: absolute;
      inset: 0;
      box-shadow: 0 0 0 2px var(--_active-user-color);
      border-radius: var(--lumo-border-radius-s);
      transition: box-shadow 0.3s;
    }

    :host([context$='checkbox'])::before {
      box-shadow:
        0 0 0 2px var(--lumo-base-color),
        0 0 0 4px var(--_active-user-color);
    }

    :host([context$='radio-button'])::before {
      border-radius: 50%;
      box-shadow:
        0 0 0 3px var(--lumo-base-color),
        0 0 0 5px var(--_active-user-color);
    }

    :host([context$='item'])::before {
      box-shadow: inset 0 0 0 2px var(--_active-user-color);
    }
  `,{moduleId:"lumo-field-outline"});/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const overlay=i`
  :host {
    top: var(--lumo-space-m);
    right: var(--lumo-space-m);
    bottom: var(--lumo-space-m);
    left: var(--lumo-space-m);
    /* Workaround for Edge issue (only on Surface), where an overflowing vaadin-list-box inside vaadin-select-overlay makes the overlay transparent */
    /* stylelint-disable-next-line */
    outline: 0px solid transparent;
  }

  [part='overlay'] {
    background-color: var(--lumo-base-color);
    background-image: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct));
    border-radius: var(--lumo-border-radius-m);
    box-shadow:
      0 0 0 1px var(--lumo-shade-5pct),
      var(--lumo-box-shadow-m);
    color: var(--lumo-body-text-color);
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    font-weight: 400;
    line-height: var(--lumo-line-height-m);
    letter-spacing: 0;
    text-transform: none;
    -webkit-text-size-adjust: 100%;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  [part='content'] {
    padding: var(--lumo-space-xs);
  }

  [part='backdrop'] {
    background-color: var(--lumo-shade-20pct);
    animation: 0.2s lumo-overlay-backdrop-enter both;
    will-change: opacity;
  }

  @keyframes lumo-overlay-backdrop-enter {
    0% {
      opacity: 0;
    }
  }

  :host([closing]) [part='backdrop'] {
    animation: 0.2s lumo-overlay-backdrop-exit both;
  }

  @keyframes lumo-overlay-backdrop-exit {
    100% {
      opacity: 0;
    }
  }

  @keyframes lumo-overlay-dummy-animation {
    0% {
      opacity: 1;
    }

    100% {
      opacity: 1;
    }
  }
`;registerStyles$1("",overlay,{moduleId:"lumo-overlay"});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-user-tags-overlay",[overlay,i`
      [part='overlay'] {
        box-shadow: none;
        background: transparent;
        will-change: opacity, transform;
      }

      [part='content'] {
        padding: 0;
      }

      :host([opening]) [part='overlay'] {
        animation: 0.1s lumo-user-tags-enter ease-out both;
      }

      @keyframes lumo-user-tags-enter {
        0% {
          opacity: 0;
        }
      }

      :host([closing]) [part='overlay'] {
        animation: 0.1s lumo-user-tags-exit both;
      }

      @keyframes lumo-user-tags-exit {
        100% {
          opacity: 0;
        }
      }
    `],{moduleId:"lumo-user-tags-overlay"});registerStyles$1("vaadin-user-tag",i`
    :host {
      font-family: var(--lumo-font-family);
      font-size: var(--lumo-font-size-xxs);
      border-radius: var(--lumo-border-radius-s);
      box-shadow: var(--lumo-box-shadow-xs);
      --vaadin-user-tag-offset: var(--lumo-space-xs);
    }

    [part='name'] {
      color: var(--lumo-primary-contrast-color);
      padding: 0.3em calc(0.3em + var(--lumo-border-radius-s) / 4);
      line-height: 1;
      font-weight: 500;
      min-width: calc(var(--lumo-line-height-xs) * 1em + 0.45em);
    }
  `,{moduleId:"lumo-user-tag"});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const directionSubscribers=[];function alignDirs(g,d,a=g.getAttribute("dir")){d?g.setAttribute("dir",d):a!=null&&g.removeAttribute("dir")}function getDocumentDir(){return document.documentElement.getAttribute("dir")}function directionUpdater(){const g=getDocumentDir();directionSubscribers.forEach(d=>{alignDirs(d,g)})}const directionObserver=new MutationObserver(directionUpdater);directionObserver.observe(document.documentElement,{attributes:!0,attributeFilter:["dir"]});const DirMixin=g=>class extends g{static get properties(){return{dir:{type:String,value:"",reflectToAttribute:!0,converter:{fromAttribute:a=>a||"",toAttribute:a=>a===""?null:a}}}}get __isRTL(){return this.getAttribute("dir")==="rtl"}connectedCallback(){super.connectedCallback(),(!this.hasAttribute("dir")||this.__restoreSubscription)&&(this.__subscribe(),alignDirs(this,getDocumentDir(),null))}attributeChangedCallback(a,u,v){if(super.attributeChangedCallback(a,u,v),a!=="dir")return;const x=getDocumentDir(),S=v===x&&directionSubscribers.indexOf(this)===-1,T=!v&&u&&directionSubscribers.indexOf(this)===-1;S||T?(this.__subscribe(),alignDirs(this,x,v)):v!==x&&u===x&&this.__unsubscribe()}disconnectedCallback(){super.disconnectedCallback(),this.__restoreSubscription=directionSubscribers.includes(this),this.__unsubscribe()}_valueToNodeAttribute(a,u,v){v==="dir"&&u===""&&!a.hasAttribute("dir")||super._valueToNodeAttribute(a,u,v)}_attributeToProperty(a,u,v){a==="dir"&&!u?this.dir="":super._attributeToProperty(a,u,v)}__subscribe(){directionSubscribers.includes(this)||directionSubscribers.push(this)}__unsubscribe(){directionSubscribers.includes(this)&&directionSubscribers.splice(directionSubscribers.indexOf(this),1)}},appliedClassMixins=new WeakMap;function wasMixinPreviouslyApplied(g,d){let a=d;for(;a;){if(appliedClassMixins.get(a)===g)return!0;a=Object.getPrototypeOf(a)}return!1}function dedupeMixin(g){return d=>{if(wasMixinPreviouslyApplied(g,d))return d;const a=g(d);return appliedClassMixins.set(a,g),a}}/**
 * @license
 * Copyright (c) 2023 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function get$7(g,d){return g.split(".").reduce((a,u)=>a?a[u]:void 0,d)}function set$2(g,d,a){const u=g.split("."),v=u.pop(),x=u.reduce((S,T)=>S[T],a);x[v]=d}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const caseMap$1={},CAMEL_TO_DASH$1=/([A-Z])/gu;function camelToDash(g){return caseMap$1[g]||(caseMap$1[g]=g.replace(CAMEL_TO_DASH$1,"-$1").toLowerCase()),caseMap$1[g]}function upper$1(g){return g[0].toUpperCase()+g.substring(1)}function parseObserver(g){const[d,a]=g.split("("),u=a.replace(")","").split(",").map(v=>v.trim());return{method:d,observerProps:u}}function getOrCreateMap(g,d){return Object.prototype.hasOwnProperty.call(g,d)||(g[d]=new Map(g[d])),g[d]}const PolylitMixinImplementation=g=>{class d extends g{static enabledWarnings=[];static createProperty(u,v){[String,Boolean,Number,Array].includes(v)&&(v={type:v}),v&&v.reflectToAttribute&&(v.reflect=!0),super.createProperty(u,v)}static getOrCreateMap(u){return getOrCreateMap(this,u)}static finalize(){if(window.litIssuedWarnings&&(window.litIssuedWarnings.add("no-override-create-property"),window.litIssuedWarnings.add("no-override-get-property-descriptor")),super.finalize(),Array.isArray(this.observers)){const u=this.getOrCreateMap("__complexObservers");this.observers.forEach(v=>{const{method:x,observerProps:S}=parseObserver(v);u.set(x,S)})}}static addCheckedInitializer(u){super.addInitializer(v=>{v instanceof this&&u(v)})}static getPropertyDescriptor(u,v,x){const S=super.getPropertyDescriptor(u,v,x);let T=S;if(this.getOrCreateMap("__propKeys").set(u,v),x.sync&&(T={get:S.get,set(P){const z=this[u];f$1(P,z)&&(this[v]=P,this.requestUpdate(u,z,x),this.hasUpdated&&this.performUpdate())},configurable:!0,enumerable:!0}),x.readOnly){const P=T.set;this.addCheckedInitializer(z=>{z[`_set${upper$1(u)}`]=function(L){P.call(z,L)}}),T={get:T.get,set(){},configurable:!0,enumerable:!0}}if("value"in x&&this.addCheckedInitializer(P=>{const z=typeof x.value=="function"?x.value.call(P):x.value;x.readOnly?P[`_set${upper$1(u)}`](z):P[u]=z}),x.observer){const P=x.observer;this.getOrCreateMap("__observers").set(u,P),this.addCheckedInitializer(z=>{z[P]||console.warn(`observer method ${P} not defined`)})}if(x.notify){if(!this.__notifyProps)this.__notifyProps=new Set;else if(!this.hasOwnProperty("__notifyProps")){const P=this.__notifyProps;this.__notifyProps=new Set(P)}this.__notifyProps.add(u)}if(x.computed){const P=`__assignComputed${u}`,z=parseObserver(x.computed);this.prototype[P]=function(...L){this[u]=this[z.method](...L)},this.getOrCreateMap("__computedObservers").set(P,z.observerProps)}return x.attribute||(x.attribute=camelToDash(u)),T}static get polylitConfig(){return{asyncFirstRender:!1}}constructor(){super(),this.__hasPolylitMixin=!0}connectedCallback(){super.connectedCallback();const u=this.getRootNode().host;u&&u.__hasPolylitMixin&&this.id&&(u.$||={},u.$[this.id]=this);const{polylitConfig:v}=this.constructor;!this.hasUpdated&&!v.asyncFirstRender&&this.performUpdate()}firstUpdated(){super.firstUpdated(),this.$||(this.$={}),[...Object.values(this.$),this.renderRoot].forEach(u=>{u.querySelectorAll("[id]").forEach(v=>{this.$[v.id]=v})})}ready(){}willUpdate(u){this.constructor.__computedObservers&&this.__runComplexObservers(u,this.constructor.__computedObservers)}updated(u){const v=this.__isReadyInvoked;this.__isReadyInvoked=!0,this.constructor.__observers&&this.__runObservers(u,this.constructor.__observers),this.constructor.__complexObservers&&this.__runComplexObservers(u,this.constructor.__complexObservers),this.__dynamicPropertyObservers&&this.__runDynamicObservers(u,this.__dynamicPropertyObservers),this.__dynamicMethodObservers&&this.__runComplexObservers(u,this.__dynamicMethodObservers),this.constructor.__notifyProps&&this.__runNotifyProps(u,this.constructor.__notifyProps),v||this.ready()}setProperties(u){Object.entries(u).forEach(([v,x])=>{const S=this.constructor.__propKeys.get(v),T=this[S];this[S]=x,this.requestUpdate(v,T)}),this.hasUpdated&&this.performUpdate()}_createMethodObserver(u){const v=getOrCreateMap(this,"__dynamicMethodObservers"),{method:x,observerProps:S}=parseObserver(u);v.set(x,S)}_createPropertyObserver(u,v){getOrCreateMap(this,"__dynamicPropertyObservers").set(v,u)}__runComplexObservers(u,v){v.forEach((x,S)=>{x.some(T=>u.has(T))&&(this[S]?this[S](...x.map(T=>this[T])):console.warn(`observer method ${S} not defined`))})}__runDynamicObservers(u,v){v.forEach((x,S)=>{u.has(x)&&this[S]&&this[S](this[x],u.get(x))})}__runObservers(u,v){u.forEach((x,S)=>{const T=v.get(S);T!==void 0&&this[T]&&this[T](this[S],x)})}__runNotifyProps(u,v){u.forEach((x,S)=>{v.has(S)&&this.dispatchEvent(new CustomEvent(`${camelToDash(S)}-changed`,{detail:{value:this[S]}}))})}_get(u,v){return get$7(u,v)}_set(u,v,x){set$2(u,v,x)}}return d},PolylitMixin=dedupeMixin(PolylitMixinImplementation);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const fieldOutlineStyles=i`
  :host {
    display: block;
    box-sizing: border-box;
    position: absolute;
    inset: 0;
    width: 100%;
    height: 100%;
    pointer-events: none;
    user-select: none;
    opacity: 0;
    --_active-user-color: transparent;
  }

  :host([has-active-user]) {
    opacity: 1;
  }
`,userTagStyles=i`
  :host {
    display: block;
    box-sizing: border-box;
    margin: 0 0 var(--vaadin-user-tag-offset);
    opacity: 0;
    height: 1.3rem;
    transition: opacity 0.2s ease-in-out;
    background-color: var(--vaadin-user-tag-color);
    color: #fff;
    cursor: default;
    -webkit-user-select: none;
    user-select: none;
    --vaadin-user-tag-offset: 4px;
  }

  :host(.show) {
    opacity: 1;
  }

  :host(:last-of-type) {
    margin-bottom: 0;
  }

  [part='name'] {
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    box-sizing: border-box;
    padding: 2px 4px;
    height: 1.3rem;
    font-size: 13px;
  }
`,userTagsOverlayStyles=i`
  [part='overlay'] {
    position: relative;
    left: -4px;
    padding: 4px;
    outline: none;
    overflow: visible;
  }

  ::slotted([part='tags']) {
    display: flex;
    flex-direction: column;
    align-items: flex-start;
  }

  :host([dir='rtl']) [part='overlay'] {
    left: auto;
    right: -4px;
  }

  :host([opening]),
  :host([closing]) {
    animation: 0.14s user-tags-overlay-dummy-animation;
  }

  @keyframes user-tags-overlay-dummy-animation {
    0% {
      opacity: 1;
    }

    100% {
      opacity: 1;
    }
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class UserTag extends ThemableMixin(DirMixin(PolylitMixin(i$1))){static get is(){return"vaadin-user-tag"}static get styles(){return userTagStyles}render(){return b`<div part="name">${this.name}</div>`}static get properties(){return{name:{type:String},uid:{type:String},colorIndex:{type:Number,observer:"_colorIndexChanged"}}}ready(){super.ready(),this.addEventListener("mousedown",this._onClick.bind(this),!0)}_colorIndexChanged(d){d!=null&&this.style.setProperty("--vaadin-user-tag-color",`var(--vaadin-user-color-${d})`)}_onClick(d){d.preventDefault(),this.dispatchEvent(new CustomEvent("user-tag-click",{bubbles:!0,composed:!0,detail:{name:this.name}}))}}defineCustomElement(UserTag);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const testUserAgent=g=>g.test(navigator.userAgent),testPlatform=g=>g.test(navigator.platform),testVendor=g=>g.test(navigator.vendor),isAndroid=testUserAgent(/Android/u),isChrome=testUserAgent(/Chrome/u)&&testVendor(/Google Inc/u),isFirefox$4=testUserAgent(/Firefox/u),isIPad=testPlatform(/^iPad/u)||testPlatform(/^Mac/u)&&navigator.maxTouchPoints>1,isIPhone=testPlatform(/^iPhone/u),isIOS=isIPhone||isIPad,isSafari=testUserAgent(/^((?!chrome|android).)*safari/iu),isTouch=(()=>{try{return document.createEvent("TouchEvent"),!0}catch{return!1}})(),supportsAdoptingStyleSheets$1=window.ShadowRoot&&"adoptedStyleSheets"in Document.prototype&&"replace"in CSSStyleSheet.prototype;/**
 * @license
 * Copyright (c) 2017 Anton Korzunov
 * SPDX-License-Identifier: MIT
 */let counterMap=new WeakMap,uncontrolledNodes=new WeakMap,markerMap={},lockCount=0;const isElement=g=>g&&g.nodeType===Node.ELEMENT_NODE,logError=(...g)=>{console.error(`Error: ${g.join(" ")}. Skip setting aria-hidden.`)},correctTargets=(g,d)=>isElement(g)?d.map(a=>{if(!isElement(a))return logError(a,"is not a valid element"),null;let u=a;for(;u&&u!==g;){if(g.contains(u))return a;u=u.getRootNode().host}return logError(a,"is not contained inside",g),null}).filter(a=>!!a):(logError(g,"is not a valid element"),[]),applyAttributeToOthers=(g,d,a,u)=>{const v=correctTargets(d,Array.isArray(g)?g:[g]);markerMap[a]||(markerMap[a]=new WeakMap);const x=markerMap[a],S=[],T=new Set,P=new Set(v),z=N=>{if(!N||T.has(N))return;T.add(N);const $=N.assignedSlot;$&&z($),z(N.parentNode||N.host)};v.forEach(z);const L=N=>{if(!N||P.has(N))return;const $=N.shadowRoot;($?[...N.children,...$.children]:[...N.children]).forEach(U=>{if(!["template","script","style"].includes(U.localName))if(T.has(U))L(U);else{const j=U.getAttribute(u),Y=j!==null&&j!=="false",q=(counterMap.get(U)||0)+1,Q=(x.get(U)||0)+1;counterMap.set(U,q),x.set(U,Q),S.push(U),q===1&&Y&&uncontrolledNodes.set(U,!0),Q===1&&U.setAttribute(a,"true"),Y||U.setAttribute(u,"true")}})};return L(d),T.clear(),lockCount+=1,()=>{S.forEach(N=>{const $=counterMap.get(N)-1,B=x.get(N)-1;counterMap.set(N,$),x.set(N,B),$||(uncontrolledNodes.has(N)?uncontrolledNodes.delete(N):N.removeAttribute(u)),B||N.removeAttribute(a)}),lockCount-=1,lockCount||(counterMap=new WeakMap,counterMap=new WeakMap,uncontrolledNodes=new WeakMap,markerMap={})}},hideOthers=(g,d=document.body,a="data-aria-hidden")=>{const u=Array.from(Array.isArray(g)?g:[g]);return d&&u.push(...Array.from(d.querySelectorAll("[aria-live]"))),applyAttributeToOthers(u,d,a,"aria-hidden")};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AriaModalController{constructor(d,a){this.host=d,this.callback=typeof a=="function"?a:()=>d}showModal(){const d=this.callback();this.__showOthers=hideOthers(d)}close(){this.__showOthers&&(this.__showOthers(),this.__showOthers=null)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let keyboardActive=!1;window.addEventListener("keydown",()=>{keyboardActive=!0},{capture:!0});window.addEventListener("mousedown",()=>{keyboardActive=!1},{capture:!0});function getDeepActiveElement(){let g=document.activeElement||document.body;for(;g.shadowRoot&&g.shadowRoot.activeElement;)g=g.shadowRoot.activeElement;return g}function isKeyboardActive(){return keyboardActive}function isElementHiddenDirectly(g){const d=g.style;if(d.visibility==="hidden"||d.display==="none")return!0;const a=window.getComputedStyle(g);return a.visibility==="hidden"||a.display==="none"}function hasLowerTabOrder(g,d){const a=Math.max(g.tabIndex,0),u=Math.max(d.tabIndex,0);return a===0||u===0?u>a:a>u}function mergeSortByTabIndex(g,d){const a=[];for(;g.length>0&&d.length>0;)hasLowerTabOrder(g[0],d[0])?a.push(d.shift()):a.push(g.shift());return a.concat(g,d)}function sortElementsByTabIndex(g){const d=g.length;if(d<2)return g;const a=Math.ceil(d/2),u=sortElementsByTabIndex(g.slice(0,a)),v=sortElementsByTabIndex(g.slice(a));return mergeSortByTabIndex(u,v)}function isElementHidden(g){return g.checkVisibility?!g.checkVisibility({visibilityProperty:!0}):g.offsetParent===null&&g.clientWidth===0&&g.clientHeight===0?!0:isElementHiddenDirectly(g)}function isElementFocusable(g){return g.matches('[tabindex="-1"]')?!1:g.matches("input, select, textarea, button, object")?g.matches(":not([disabled])"):g.matches("a[href], area[href], iframe, [tabindex], [contentEditable]")}function isElementFocused(g){return g.getRootNode().activeElement===g}function normalizeTabIndex(g){if(!isElementFocusable(g))return-1;const d=g.getAttribute("tabindex")||0;return Number(d)}function collectFocusableNodes(g,d){if(g.nodeType!==Node.ELEMENT_NODE||isElementHiddenDirectly(g))return!1;const a=g,u=normalizeTabIndex(a);let v=u>0;u>=0&&d.push(a);let x=[];return a.localName==="slot"?x=a.assignedNodes({flatten:!0}):x=(a.shadowRoot||a).children,[...x].forEach(S=>{v=collectFocusableNodes(S,d)||v}),v}function getFocusableElements(g){const d=[];return collectFocusableNodes(g,d)?sortElementsByTabIndex(d):d}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class FocusRestorationController{saveFocus(d){this.focusNode=d||getDeepActiveElement()}restoreFocus(d){const a=this.focusNode;if(!a)return;const u=d?d.preventScroll:!1;getDeepActiveElement()===document.body?setTimeout(()=>a.focus({preventScroll:u})):a.focus({preventScroll:u}),this.focusNode=null}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const instances=[];class FocusTrapController{constructor(d){this.host=d,this.__trapNode=null,this.__onKeyDown=this.__onKeyDown.bind(this)}get __focusableElements(){return getFocusableElements(this.__trapNode)}get __focusedElementIndex(){const d=this.__focusableElements;return d.indexOf(d.filter(isElementFocused).pop())}hostConnected(){document.addEventListener("keydown",this.__onKeyDown)}hostDisconnected(){document.removeEventListener("keydown",this.__onKeyDown)}trapFocus(d){if(this.__trapNode=d,this.__focusableElements.length===0)throw this.__trapNode=null,new Error("The trap node should have at least one focusable descendant or be focusable itself.");instances.push(this),this.__focusedElementIndex===-1&&this.__focusableElements[0].focus()}releaseFocus(){this.__trapNode=null,instances.pop()}__onKeyDown(d){if(this.__trapNode&&this===Array.from(instances).pop()&&d.key==="Tab"){d.preventDefault();const a=d.shiftKey;this.__focusNextElement(a)}}__focusNextElement(d=!1){const a=this.__focusableElements,u=d?-1:1,v=this.__focusedElementIndex,x=(a.length+v+u)%a.length,S=a[x];S.focus(),S.localName==="input"&&S.select()}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ControllerMixin=dedupeMixin(g=>typeof g.prototype.addController=="function"?g:class extends g{constructor(){super(),this.__controllers=new Set}connectedCallback(){super.connectedCallback(),this.__controllers.forEach(a=>{a.hostConnected&&a.hostConnected()})}disconnectedCallback(){super.disconnectedCallback(),this.__controllers.forEach(a=>{a.hostDisconnected&&a.hostDisconnected()})}addController(a){this.__controllers.add(a),this.$!==void 0&&this.isConnected&&a.hostConnected&&a.hostConnected()}removeController(a){this.__controllers.delete(a)}});/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const OverlayFocusMixin=g=>class extends ControllerMixin(g){static get properties(){return{focusTrap:{type:Boolean,value:!1},restoreFocusOnClose:{type:Boolean,value:!1},restoreFocusNode:{type:HTMLElement}}}constructor(){super(),this.__ariaModalController=new AriaModalController(this),this.__focusTrapController=new FocusTrapController(this),this.__focusRestorationController=new FocusRestorationController}ready(){super.ready(),this.addController(this.__ariaModalController),this.addController(this.__focusTrapController),this.addController(this.__focusRestorationController)}_resetFocus(){if(this.focusTrap&&(this.__ariaModalController.close(),this.__focusTrapController.releaseFocus()),this.restoreFocusOnClose&&this._shouldRestoreFocus()){const a=!isKeyboardActive();this.__focusRestorationController.restoreFocus({preventScroll:a})}}_saveFocus(){this.restoreFocusOnClose&&this.__focusRestorationController.saveFocus(this.restoreFocusNode)}_trapFocus(){this.focusTrap&&(this.__ariaModalController.showModal(),this.__focusTrapController.trapFocus(this.$.overlay))}_shouldRestoreFocus(){const a=getDeepActiveElement();return a===document.body||this._deepContains(a)}_deepContains(a){if(this.contains(a))return!0;let u=a;const v=a.ownerDocument;for(;u&&u!==v&&u!==this;)u=u.parentNode||u.host;return u===this}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const getAttachedInstances=()=>Array.from(document.body.children).filter(g=>g instanceof HTMLElement&&g._hasOverlayStackMixin&&!g.hasAttribute("closing")).sort((g,d)=>g.__zIndex-d.__zIndex||0),hasOnlyNestedOverlays=g=>{const d=getAttachedInstances(),a=d[d.indexOf(g)+1];return a?a.owner&&!g._deepContains(a.owner)?!1:hasOnlyNestedOverlays(a):!0},getOverlayInstances=()=>getAttachedInstances().filter(g=>g.$.overlay),isLastOverlay$1=(g,d=a=>!0)=>{const a=getOverlayInstances().filter(d);return g===a.pop()},overlayMap=new WeakMap,setNestedOverlay=(g,d)=>{d!=null?overlayMap.set(g,d):overlayMap.delete(g)},OverlayStackMixin=g=>class extends g{constructor(){super(),this._hasOverlayStackMixin=!0}get _last(){return isLastOverlay$1(this)}bringToFront(){let a="";const u=getAttachedInstances().filter(v=>v!==this).pop();u&&(a=u.__zIndex+1),this.style.zIndex=a,this.__zIndex=a||parseFloat(getComputedStyle(this).zIndex),overlayMap.has(this)&&overlayMap.get(this).bringToFront()}_enterModalState(){document.body.style.pointerEvents!=="none"&&(this._previousDocumentPointerEvents=document.body.style.pointerEvents,document.body.style.pointerEvents="none"),getOverlayInstances().forEach(a=>{a!==this&&(a.$.overlay.style.pointerEvents="none")})}_exitModalState(){this._previousDocumentPointerEvents!==void 0&&(document.body.style.pointerEvents=this._previousDocumentPointerEvents,delete this._previousDocumentPointerEvents);const a=getOverlayInstances();let u;for(;(u=a.pop())&&!(u!==this&&(u.$.overlay.style.removeProperty("pointer-events"),!u.modeless)););}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const OverlayMixin=g=>class extends OverlayFocusMixin(OverlayStackMixin(g)){static get properties(){return{opened:{type:Boolean,notify:!0,observer:"_openedChanged",reflectToAttribute:!0,sync:!0},owner:{type:Object,sync:!0},model:{type:Object,sync:!0},renderer:{type:Object,sync:!0},modeless:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_modelessChanged",sync:!0},hidden:{type:Boolean,reflectToAttribute:!0,observer:"_hiddenChanged",sync:!0},withBackdrop:{type:Boolean,value:!1,reflectToAttribute:!0,sync:!0}}}static get observers(){return["_rendererOrDataChanged(renderer, owner, model, opened)"]}constructor(){super(),this._boundMouseDownListener=this._mouseDownListener.bind(this),this._boundMouseUpListener=this._mouseUpListener.bind(this),this._boundOutsideClickListener=this._outsideClickListener.bind(this),this._boundKeydownListener=this._keydownListener.bind(this),isIOS&&(this._boundIosResizeListener=()=>this._detectIosNavbar())}ready(){super.ready(),this.addEventListener("click",()=>{}),this.$.backdrop.addEventListener("click",()=>{}),this.addEventListener("mouseup",()=>{document.activeElement===document.body&&this.$.overlay.getAttribute("tabindex")==="0"&&this.$.overlay.focus()})}connectedCallback(){super.connectedCallback(),this._boundIosResizeListener&&(this._detectIosNavbar(),window.addEventListener("resize",this._boundIosResizeListener))}disconnectedCallback(){super.disconnectedCallback(),this._boundIosResizeListener&&window.removeEventListener("resize",this._boundIosResizeListener)}requestContentUpdate(){this.renderer&&this.renderer.call(this.owner,this,this.owner,this.model)}close(a){const u=new CustomEvent("vaadin-overlay-close",{bubbles:!0,cancelable:!0,detail:{sourceEvent:a}});this.dispatchEvent(u),u.defaultPrevented||(this.opened=!1)}_detectIosNavbar(){if(!this.opened)return;const a=window.innerHeight,v=window.innerWidth>a,x=document.documentElement.clientHeight;v&&x>a?this.style.setProperty("--vaadin-overlay-viewport-bottom",`${x-a}px`):this.style.setProperty("--vaadin-overlay-viewport-bottom","0")}_shouldAddGlobalListeners(){return!this.modeless}_addGlobalListeners(){this.__hasGlobalListeners||(this.__hasGlobalListeners=!0,document.addEventListener("mousedown",this._boundMouseDownListener),document.addEventListener("mouseup",this._boundMouseUpListener),document.documentElement.addEventListener("click",this._boundOutsideClickListener,!0))}_removeGlobalListeners(){this.__hasGlobalListeners&&(this.__hasGlobalListeners=!1,document.removeEventListener("mousedown",this._boundMouseDownListener),document.removeEventListener("mouseup",this._boundMouseUpListener),document.documentElement.removeEventListener("click",this._boundOutsideClickListener,!0))}_rendererOrDataChanged(a,u,v,x){const S=this._oldOwner!==u||this._oldModel!==v;this._oldModel=v,this._oldOwner=u;const T=this._oldRenderer!==a,P=this._oldRenderer!==void 0;this._oldRenderer=a;const z=this._oldOpened!==x;this._oldOpened=x,T&&P&&(this.innerHTML="",delete this._$litPart$),x&&a&&(T||z||S)&&this.requestContentUpdate()}_modelessChanged(a){this.opened&&(this._shouldAddGlobalListeners()?this._addGlobalListeners():this._removeGlobalListeners()),a?this._exitModalState():this.opened&&this._enterModalState()}_openedChanged(a,u){a?(this._saveFocus(),this._animatedOpening(),this.__scheduledOpen=requestAnimationFrame(()=>{setTimeout(()=>{this._trapFocus(),this.dispatchEvent(new CustomEvent("vaadin-overlay-open",{bubbles:!0}))})}),document.addEventListener("keydown",this._boundKeydownListener),this._shouldAddGlobalListeners()&&this._addGlobalListeners()):u&&(this.__scheduledOpen&&(cancelAnimationFrame(this.__scheduledOpen),this.__scheduledOpen=null),this._resetFocus(),this._animatedClosing(),document.removeEventListener("keydown",this._boundKeydownListener),this._shouldAddGlobalListeners()&&this._removeGlobalListeners())}_hiddenChanged(a){a&&this.hasAttribute("closing")&&this._flushAnimation("closing")}_shouldAnimate(){const a=getComputedStyle(this),u=a.getPropertyValue("animation-name");return!(a.getPropertyValue("display")==="none")&&u&&u!=="none"}_enqueueAnimation(a,u){const v=`__${a}Handler`,x=S=>{S&&S.target!==this||(u(),this.removeEventListener("animationend",x),delete this[v])};this[v]=x,this.addEventListener("animationend",x)}_flushAnimation(a){const u=`__${a}Handler`;typeof this[u]=="function"&&this[u]()}_animatedOpening(){this.parentNode===document.body&&this.hasAttribute("closing")&&this._flushAnimation("closing"),this._attachOverlay(),this.modeless||this._enterModalState(),this.setAttribute("opening",""),this._shouldAnimate()?this._enqueueAnimation("opening",()=>{this._finishOpening()}):this._finishOpening()}_attachOverlay(){this._placeholder=document.createComment("vaadin-overlay-placeholder"),this.parentNode.insertBefore(this._placeholder,this),document.body.appendChild(this),this.bringToFront()}_finishOpening(){this.removeAttribute("opening")}_finishClosing(){this._detachOverlay(),this.$.overlay.style.removeProperty("pointer-events"),this.removeAttribute("closing"),this.dispatchEvent(new CustomEvent("vaadin-overlay-closed"))}_animatedClosing(){this.hasAttribute("opening")&&this._flushAnimation("opening"),this._placeholder&&(this._exitModalState(),this.setAttribute("closing",""),this.dispatchEvent(new CustomEvent("vaadin-overlay-closing")),this._shouldAnimate()?this._enqueueAnimation("closing",()=>{this._finishClosing()}):this._finishClosing())}_detachOverlay(){this._placeholder.parentNode.insertBefore(this,this._placeholder),this._placeholder.parentNode.removeChild(this._placeholder)}_mouseDownListener(a){this._mouseDownInside=a.composedPath().indexOf(this.$.overlay)>=0}_mouseUpListener(a){this._mouseUpInside=a.composedPath().indexOf(this.$.overlay)>=0}_shouldCloseOnOutsideClick(a){return this._last}_outsideClickListener(a){if(a.composedPath().includes(this.$.overlay)||this._mouseDownInside||this._mouseUpInside){this._mouseDownInside=!1,this._mouseUpInside=!1;return}if(!this._shouldCloseOnOutsideClick(a))return;const u=new CustomEvent("vaadin-overlay-outside-click",{bubbles:!0,cancelable:!0,detail:{sourceEvent:a}});this.dispatchEvent(u),this.opened&&!u.defaultPrevented&&this.close(a)}_keydownListener(a){if(!(!this._last||a.defaultPrevented)&&!(!this._shouldAddGlobalListeners()&&!a.composedPath().includes(this.$.overlay))&&a.key==="Escape"){const u=new CustomEvent("vaadin-overlay-escape-press",{bubbles:!0,cancelable:!0,detail:{sourceEvent:a}});this.dispatchEvent(u),this.opened&&!u.defaultPrevented&&this.close(a)}}};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function getAncestorRootNodes(g){const d=[];for(;g;){if(g.nodeType===Node.DOCUMENT_NODE){d.push(g);break}if(g.nodeType===Node.DOCUMENT_FRAGMENT_NODE){d.push(g),g=g.host;continue}if(g.assignedSlot){g=g.assignedSlot;continue}g=g.parentNode}return d}function getFlattenedElements(g){const d=[];let a;return g.localName==="slot"?a=g.assignedElements():(d.push(g),a=[...g.children]),a.forEach(u=>d.push(...getFlattenedElements(u))),d}function getClosestElement(g,d){return d?d.closest(g)||getClosestElement(g,d.getRootNode().host):null}function deserializeAttributeValue(g){return g?new Set(g.split(" ")):new Set}function serializeAttributeValue(g){return g?[...g].join(" "):""}function addValueToAttribute(g,d,a){const u=deserializeAttributeValue(g.getAttribute(d));u.add(a),g.setAttribute(d,serializeAttributeValue(u))}function removeValueFromAttribute(g,d,a){const u=deserializeAttributeValue(g.getAttribute(d));if(u.delete(a),u.size===0){g.removeAttribute(d);return}g.setAttribute(d,serializeAttributeValue(u))}function isEmptyTextNode(g){return g.nodeType===Node.TEXT_NODE&&g.textContent.trim()===""}/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function observeMove(g,d){let a=null,u;const v=document.documentElement;function x(){u&&clearTimeout(u),a&&a.disconnect(),a=null}function S(T=!1,P=1){x();const{left:z,top:L,width:N,height:$}=g.getBoundingClientRect();if(T||d(),!N||!$)return;const B=Math.floor(L),U=Math.floor(v.clientWidth-(z+N)),j=Math.floor(v.clientHeight-(L+$)),Y=Math.floor(z),Q={rootMargin:`${-B}px ${-U}px ${-j}px ${-Y}px`,threshold:Math.max(0,Math.min(1,P))||1};let J=!0;function ee(ie){const ne=ie[0].intersectionRatio;if(ne!==P){if(!J)return S();ne?S(!1,ne):u=setTimeout(()=>{S(!1,1e-7)},1e3)}J=!1}a=new IntersectionObserver(ee,Q),a.observe(g)}return S(!0),x}/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PROP_NAMES_VERTICAL={start:"top",end:"bottom"},PROP_NAMES_HORIZONTAL={start:"left",end:"right"},targetResizeObserver=new ResizeObserver(g=>{setTimeout(()=>{g.forEach(d=>{d.target.__overlay&&d.target.__overlay._updatePosition()})})}),PositionMixin=g=>class extends g{static get properties(){return{positionTarget:{type:Object,value:null,sync:!0},horizontalAlign:{type:String,value:"start",sync:!0},verticalAlign:{type:String,value:"top",sync:!0},noHorizontalOverlap:{type:Boolean,value:!1,sync:!0},noVerticalOverlap:{type:Boolean,value:!1,sync:!0},requiredVerticalSpace:{type:Number,value:0,sync:!0}}}static get observers(){return["__positionSettingsChanged(horizontalAlign, verticalAlign, noHorizontalOverlap, noVerticalOverlap, requiredVerticalSpace)","__overlayOpenedChanged(opened, positionTarget)"]}constructor(){super(),this.__onScroll=this.__onScroll.bind(this),this._updatePosition=this._updatePosition.bind(this)}connectedCallback(){super.connectedCallback(),this.opened&&this.__addUpdatePositionEventListeners()}disconnectedCallback(){super.disconnectedCallback(),this.__removeUpdatePositionEventListeners()}__addUpdatePositionEventListeners(){window.visualViewport.addEventListener("resize",this._updatePosition),window.visualViewport.addEventListener("scroll",this.__onScroll,!0),this.__positionTargetAncestorRootNodes=getAncestorRootNodes(this.positionTarget),this.__positionTargetAncestorRootNodes.forEach(a=>{a.addEventListener("scroll",this.__onScroll,!0)}),this.positionTarget&&(this.__observePositionTargetMove=observeMove(this.positionTarget,()=>{this._updatePosition()}))}__removeUpdatePositionEventListeners(){window.visualViewport.removeEventListener("resize",this._updatePosition),window.visualViewport.removeEventListener("scroll",this.__onScroll,!0),this.__positionTargetAncestorRootNodes&&(this.__positionTargetAncestorRootNodes.forEach(a=>{a.removeEventListener("scroll",this.__onScroll,!0)}),this.__positionTargetAncestorRootNodes=null),this.__observePositionTargetMove&&(this.__observePositionTargetMove(),this.__observePositionTargetMove=null)}__overlayOpenedChanged(a,u){if(this.__removeUpdatePositionEventListeners(),u&&(u.__overlay=null,targetResizeObserver.unobserve(u),a&&(this.__addUpdatePositionEventListeners(),u.__overlay=this,targetResizeObserver.observe(u))),a){const v=getComputedStyle(this);this.__margins||(this.__margins={},["top","bottom","left","right"].forEach(x=>{this.__margins[x]=parseInt(v[x],10)})),this._updatePosition(),requestAnimationFrame(()=>this._updatePosition())}}__positionSettingsChanged(){this._updatePosition()}__onScroll(a){a.target instanceof Node&&this.contains(a.target)||this._updatePosition()}_updatePosition(){if(!this.positionTarget||!this.opened||!this.__margins)return;const a=this.positionTarget.getBoundingClientRect();if(a.width===0&&a.height===0&&this.opened){this.opened=!1;return}const u=this.__shouldAlignStartVertically(a);this.style.justifyContent=u?"flex-start":"flex-end";const v=this.__isRTL,x=this.__shouldAlignStartHorizontally(a,v),S=!v&&x||v&&!x;this.style.alignItems=S?"flex-start":"flex-end";const T=this.getBoundingClientRect(),P=this.__calculatePositionInOneDimension(a,T,this.noVerticalOverlap,PROP_NAMES_VERTICAL,this,u),z=this.__calculatePositionInOneDimension(a,T,this.noHorizontalOverlap,PROP_NAMES_HORIZONTAL,this,x);Object.assign(this.style,P,z),this.toggleAttribute("bottom-aligned",!u),this.toggleAttribute("top-aligned",u),this.toggleAttribute("end-aligned",!S),this.toggleAttribute("start-aligned",S)}__shouldAlignStartHorizontally(a,u){const v=Math.max(this.__oldContentWidth||0,this.$.overlay.offsetWidth);this.__oldContentWidth=this.$.overlay.offsetWidth;const x=Math.min(window.innerWidth,document.documentElement.clientWidth),S=!u&&this.horizontalAlign==="start"||u&&this.horizontalAlign==="end";return this.__shouldAlignStart(a,v,x,this.__margins,S,this.noHorizontalOverlap,PROP_NAMES_HORIZONTAL)}__shouldAlignStartVertically(a){const u=this.requiredVerticalSpace||Math.max(this.__oldContentHeight||0,this.$.overlay.offsetHeight);this.__oldContentHeight=this.$.overlay.offsetHeight;const v=Math.min(window.innerHeight,document.documentElement.clientHeight),x=this.verticalAlign==="top";return this.__shouldAlignStart(a,u,v,this.__margins,x,this.noVerticalOverlap,PROP_NAMES_VERTICAL)}__shouldAlignStart(a,u,v,x,S,T,P){const z=v-a[T?P.end:P.start]-x[P.end],L=a[T?P.start:P.end]-x[P.start],N=S?z:L,B=N>(S?L:z)||N>u;return S===B}__adjustBottomProperty(a,u,v){let x;if(a===u.end){if(u.end===PROP_NAMES_VERTICAL.end){const S=Math.min(window.innerHeight,document.documentElement.clientHeight);if(v>S&&this.__oldViewportHeight){const T=this.__oldViewportHeight-S;x=v-T}this.__oldViewportHeight=S}if(u.end===PROP_NAMES_HORIZONTAL.end){const S=Math.min(window.innerWidth,document.documentElement.clientWidth);if(v>S&&this.__oldViewportWidth){const T=this.__oldViewportWidth-S;x=v-T}this.__oldViewportWidth=S}}return x}__calculatePositionInOneDimension(a,u,v,x,S,T){const P=T?x.start:x.end,z=T?x.end:x.start,L=parseFloat(S.style[P]||getComputedStyle(S)[P]),N=this.__adjustBottomProperty(P,x,L),$=u[T?x.start:x.end]-a[v===T?x.end:x.start],B=N?`${N}px`:`${L+$*(T?-1:1)}px`;return{[P]:B,[z]:""}}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const overlayStyles$1=i`
  :host {
    z-index: 200;
    position: fixed;

    /* Despite of what the names say, <vaadin-overlay> is just a container
          for position/sizing/alignment. The actual overlay is the overlay part. */

    /* Default position constraints: the entire viewport. Note: themes can
          override this to introduce gaps between the overlay and the viewport. */
    inset: 0;
    bottom: var(--vaadin-overlay-viewport-bottom);

    /* Use flexbox alignment for the overlay part. */
    display: flex;
    flex-direction: column; /* makes dropdowns sizing easier */
    /* Align to center by default. */
    align-items: center;
    justify-content: center;

    /* Allow centering when max-width/max-height applies. */
    margin: auto;

    /* The host is not clickable, only the overlay part is. */
    pointer-events: none;

    /* Remove tap highlight on touch devices. */
    -webkit-tap-highlight-color: transparent;

    /* CSS API for host */
    --vaadin-overlay-viewport-bottom: 0;
  }

  :host([hidden]),
  :host(:not([opened]):not([closing])),
  :host(:not([opened]):not([closing])) [part='overlay'] {
    display: none !important;
  }

  [part='overlay'] {
    -webkit-overflow-scrolling: touch;
    overflow: auto;
    pointer-events: auto;

    /* Prevent overflowing the host */
    max-width: 100%;
    box-sizing: border-box;

    -webkit-tap-highlight-color: initial; /* reenable tap highlight inside */
  }

  [part='backdrop'] {
    z-index: -1;
    content: '';
    background: rgba(0, 0, 0, 0.5);
    position: fixed;
    inset: 0;
    pointer-events: auto;
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class UserTagsOverlay extends PositionMixin(OverlayMixin(DirMixin(ThemableMixin(PolylitMixin(i$1))))){static get is(){return"vaadin-user-tags-overlay"}static get styles(){return[overlayStyles$1,userTagsOverlayStyles]}render(){return b`
      <div id="backdrop" part="backdrop" ?hidden="${!this.withBackdrop}"></div>
      <div part="overlay" id="overlay">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `}}defineCustomElement(UserTagsOverlay);/**
 * @license
 * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
 */let microtaskCurrHandle$1=0,microtaskLastHandle$1=0;const microtaskCallbacks$1=[];let microtaskScheduled$1=!1;function microtaskFlush$1(){microtaskScheduled$1=!1;const g=microtaskCallbacks$1.length;for(let d=0;d<g;d++){const a=microtaskCallbacks$1[d];if(a)try{a()}catch(u){setTimeout(()=>{throw u})}}microtaskCallbacks$1.splice(0,g),microtaskLastHandle$1+=g}const timeOut$1={after(g){return{run(d){return window.setTimeout(d,g)},cancel(d){window.clearTimeout(d)}}},run(g,d){return window.setTimeout(g,d)},cancel(g){window.clearTimeout(g)}},animationFrame={run(g){return window.requestAnimationFrame(g)},cancel(g){window.cancelAnimationFrame(g)}},idlePeriod$1={run(g){return window.requestIdleCallback?window.requestIdleCallback(g):window.setTimeout(g,16)},cancel(g){window.cancelIdleCallback?window.cancelIdleCallback(g):window.clearTimeout(g)}},microTask$1={run(g){microtaskScheduled$1||(microtaskScheduled$1=!0,queueMicrotask(()=>microtaskFlush$1())),microtaskCallbacks$1.push(g);const d=microtaskCurrHandle$1;return microtaskCurrHandle$1+=1,d},cancel(g){const d=g-microtaskLastHandle$1;if(d>=0){if(!microtaskCallbacks$1[d])throw new Error(`invalid async handle: ${g}`);microtaskCallbacks$1[d]=null}}};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const debouncerQueue$1=new Set;let Debouncer$1=class K_{static debounce(d,a,u){return d instanceof K_?d._cancelAsync():d=new K_,d.setConfig(a,u),d}constructor(){this._asyncModule=null,this._callback=null,this._timer=null}setConfig(d,a){this._asyncModule=d,this._callback=a,this._timer=this._asyncModule.run(()=>{this._timer=null,debouncerQueue$1.delete(this),this._callback()})}cancel(){this.isActive()&&(this._cancelAsync(),debouncerQueue$1.delete(this))}_cancelAsync(){this.isActive()&&(this._asyncModule.cancel(this._timer),this._timer=null)}flush(){this.isActive()&&(this.cancel(),this._callback())}isActive(){return this._timer!=null}};function enqueueDebouncer$1(g){debouncerQueue$1.add(g)}function flushDebouncers$1(){const g=!!debouncerQueue$1.size;return debouncerQueue$1.forEach(d=>{try{d.flush()}catch(a){setTimeout(()=>{throw a})}}),g}const flush$1=()=>{let g;do g=flushDebouncers$1();while(g)};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const listenOnce$1=(g,d)=>new Promise(a=>{const u=()=>{g.removeEventListener(d,u),a()};g.addEventListener(d,u)});class UserTags extends PolylitMixin(i$1){static get is(){return"vaadin-user-tags"}static get styles(){return i`
      :host {
        position: absolute;
      }
    `}render(){return b`
      <vaadin-user-tags-overlay
        id="overlay"
        modeless
        .opened="${this.opened}"
        no-vertical-overlap
        @vaadin-overlay-open="${this._onOverlayOpen}"
      ></vaadin-user-tags-overlay>
    `}static get properties(){return{hasFocus:{type:Boolean,value:!1,observer:"_hasFocusChanged"},opened:{type:Boolean,value:!1,sync:!0},flashing:{type:Boolean,value:!1},target:{type:Object,observer:"__targetChanged"},users:{type:Array,value:()=>[]},duration:{type:Number,value:200},delay:{type:Number,value:2e3},__flashQueue:{type:Array,value:()=>[]},__isTargetVisible:{type:Boolean,value:!1}}}constructor(){super(),this.__targetVisibilityObserver=new IntersectionObserver(([d])=>{this.__onTargetVisibilityChange(d.isIntersecting)},{threshold:1})}get wrapper(){return this.$.overlay.querySelector('[part="tags"]')}connectedCallback(){super.connectedCallback(),this.target&&this.__targetVisibilityObserver.observe(this.target)}disconnectedCallback(){super.disconnectedCallback(),this.opened=!1,this.target&&this.__targetVisibilityObserver.unobserve(this.target)}ready(){super.ready(),this.$.overlay.renderer=d=>{if(!d.firstChild){const a=document.createElement("div");a.setAttribute("part","tags"),d.appendChild(a)}},this.$.overlay.requestContentUpdate()}__onTargetVisibilityChange(d){if(this.__isTargetVisible=d,d&&this.__flashQueue.length>0&&!this.flashing){this.flashTags(this.__flashQueue.shift());return}if(d&&this.hasFocus){this.opened=!0;return}!d&&this.opened&&(this.opened=!1)}__targetChanged(d,a){this.$.overlay.positionTarget=d,a&&this.__targetVisibilityObserver.unobserve(a),d&&this.__targetVisibilityObserver.observe(d)}_hasFocusChanged(d){d&&this.flashing&&this.stopFlash()}createUserTag(d){const a=document.createElement("vaadin-user-tag");return a.name=d.name,a.uid=d.id,a.colorIndex=d.colorIndex,a}getTagForUser(d){return Array.from(this.wrapper.children).find(a=>a.uid===d.id)}getChangedTags(d,a){const u=a.map(x=>this.getTagForUser(x));return{added:d.map(x=>this.getTagForUser(x)||this.createUserTag(x)),removed:u}}applyTagsStart({added:d,removed:a}){const u=this.wrapper;a.forEach(v=>{v&&(v.classList.add("removing"),v.classList.remove("show"))}),d.forEach(v=>u.insertBefore(v,u.firstChild))}applyTagsEnd({added:d,removed:a}){const u=this.wrapper;a.forEach(v=>{v&&v.parentNode===u&&u.removeChild(v)}),d.forEach(v=>v&&v.classList.add("show"))}setUsers(d){this.requestContentUpdate();let a=[],u=[];const v=Array.isArray(d);if(Array.isArray(this.users)){const T=(d||[]).map(P=>P.id);u=this.users.filter(P=>!T.includes(P.id))}if(v){const T=(this.users||[]).map(P=>P.id);a=d.filter(P=>!T.includes(P.id)).reverse()}if(a.length===0&&u.length===0)return;const S=this.getChangedTags(a,u);if(this.__flashQueue.length>0&&u.forEach((T,P)=>{S.removed[P]!==null&&this.__flashQueue.forEach(z=>{z.some(L=>L.uid===T.id)&&(this.__flashQueue=this.__flashQueue.filter((L,N)=>N!==P))})}),this.opened&&this.hasFocus)this.updateTags(d,S);else if(a.length>0&&document.visibilityState!=="hidden"){const T=S.added,P=S.removed;this.updateTagsSync(d,{added:[],removed:P}),this.flashing||!this.__isTargetVisible?this.__flashQueue=[...this.__flashQueue,T]:this.flashTags(T)}else this.updateTagsSync(d,S)}_onOverlayOpen(){Array.from(this.wrapper.children).forEach(d=>{d.classList.contains("removing")||d.classList.add("show")})}flashTags(d){this.flashing=!0;const a=this.wrapper,u=Array.from(a.children);u.forEach(v=>{v.style.display="none"}),d.forEach(v=>{a.insertBefore(v,a.firstChild)}),this.flashPromise=new Promise(v=>{listenOnce$1(this.$.overlay,"vaadin-overlay-open").then(()=>{this._debounceFlashStart=Debouncer$1.debounce(this._debounceFlashStart,timeOut$1.after(this.duration+this.delay),()=>{this.hasFocus||d.forEach(x=>x.classList.remove("show")),this._debounceFlashEnd=Debouncer$1.debounce(this._debounceFlashEnd,timeOut$1.after(this.duration),()=>{const x=()=>{u.forEach(S=>{S.style.display="block"}),this.flashing=!1,v()};this.hasFocus?x():(listenOnce$1(this.$.overlay,"animationend").then(()=>{x()}),this.opened=!1)})})})}).then(()=>{if(this.__flashQueue.length>0){const v=this.__flashQueue[0];this.__flashQueue=[...this.__flashQueue].slice(1),this.flashTags(v)}}),this.opened=!0}stopFlash(){this._debounceFlashStart&&this._debounceFlashStart.flush(),this._debounceFlashEnd&&this._debounceFlashEnd.flush(),this.$.overlay._flushAnimation("closing")}updateTags(d,a){this.applyTagsStart(a),this._debounceRender=Debouncer$1.debounce(this._debounceRender,timeOut$1.after(this.duration),()=>{this.users=d,this.applyTagsEnd(a),d.length===0&&this.opened&&(this.opened=!1)})}updateTagsSync(d,a){this.applyTagsStart(a),this.users=d,this.applyTagsEnd(a)}show(){this.hasFocus=!0,this.__isTargetVisible&&(this.opened=!0)}hide(){this.hasFocus=!1,this.opened=!1}requestContentUpdate(){this._debounceRender&&this._debounceRender.isActive()&&this._debounceRender.flush()}}defineCustomElement(UserTags);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-field-outline",fieldOutlineStyles,{moduleId:"vaadin-field-outline-styles"});class FieldOutline extends ThemableMixin(DirMixin(PolylitMixin(i$1))){static get is(){return"vaadin-field-outline"}static get properties(){return{user:{type:Object,value:null,observer:"_userChanged",sync:!0}}}render(){return b``}ready(){super.ready(),this.setAttribute("part","outline"),this._field=this.getRootNode().host}_userChanged(d){this.toggleAttribute("has-active-user",!!d);const a=d?`var(--vaadin-user-color-${d.colorIndex})`:"transparent",u="--_active-user-color";this.style.setProperty(u,a),this._field&&this._field.style.setProperty(u,a)}}defineCustomElement(FieldOutline);/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const region=document.createElement("div");region.style.position="fixed";region.style.clip="rect(0px, 0px, 0px, 0px)";region.setAttribute("aria-live","polite");document.body.appendChild(region);let alertDebouncer;function announce(g,d={}){const a=d.mode||"polite",u=d.timeout===void 0?150:d.timeout;a==="alert"?(region.removeAttribute("aria-live"),region.removeAttribute("role"),alertDebouncer=Debouncer$1.debounce(alertDebouncer,animationFrame,()=>{region.setAttribute("role","alert")})):(alertDebouncer&&alertDebouncer.cancel(),region.removeAttribute("role"),region.setAttribute("aria-live",a)),region.textContent="",setTimeout(()=>{region.textContent=g},u)}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const getOutlineTarget=(g,d)=>{switch(d){case"vaadin-big-decimal-field":case"vaadin-combo-box":case"vaadin-date-picker":case"vaadin-email-field":case"vaadin-integer-field":case"vaadin-number-field":case"vaadin-password-field":case"vaadin-select":case"vaadin-text-area":case"vaadin-text-field":case"vaadin-time-picker":return g.shadowRoot.querySelector('[part="input-field"]');case"vaadin-checkbox":return g.shadowRoot.querySelector('[part="checkbox"]');case"vaadin-radio-button":return g.shadowRoot.querySelector('[part="radio"]');default:return g}},fields=new WeakMap,initOutline=g=>{if(!fields.has(g)){const d=g.tagName.toLowerCase(),a=getOutlineTarget(g,d);a.style.position="relative",d.endsWith("text-area")&&(a.style.overflow="visible");const u=document.createElement("style");u.textContent=`
      :host([focused]) [part="outline"] {
        opacity: calc(1 - var(--lumo-input-field-pointer-focus-visible, 0));
      }

      :host([active]) [part="outline"],
      :host([focus-ring]) [part="outline"] {
        display: none;
      }
    `,g.shadowRoot.appendChild(u);const v=document.createElement("vaadin-field-outline");(a===g?g.shadowRoot:a).appendChild(v),v.setAttribute("context",d),fields.set(g,{root:g,target:a,outline:v})}return fields.get(g)};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class ComponentObserver{constructor(d){this.component=d,this.initTags(d)}getFields(){return[this.component]}getFieldIndex(d){return this.getFields().indexOf(d)}getFocusTarget(d){return this.component}initTags(d){const a=document.createElement("vaadin-user-tags");d.shadowRoot.appendChild(a),a.target=d,this._tags=a,d.addEventListener("mouseenter",u=>{u.relatedTarget!==this._tags.$.overlay&&(this._mouse=!0,this._mouseDebouncer=Debouncer$1.debounce(this._mouseDebouncer,timeOut$1.after(200),()=>{this._mouse&&this._tags.show()}))}),d.addEventListener("mouseleave",u=>{u.relatedTarget!==this._tags.$.overlay&&(this._mouse=!1,this._hasFocus||this._tags.hide())}),d.addEventListener("vaadin-highlight-show",u=>{this._hasFocus=!0,this._debouncer&&this._debouncer.isActive()?this._debouncer.cancel():this._tags.show()}),d.addEventListener("vaadin-highlight-hide",u=>{this._hasFocus=!1,this._mouse||(this._debouncer=Debouncer$1.debounce(this._debouncer,timeOut$1.after(1),()=>{this._tags.hide()}))}),this._tags.$.overlay.addEventListener("mouseleave",u=>{u.relatedTarget!==d&&(this._mouse=!1,d.hasAttribute("focused")||this._tags.hide())})}setOutlines(d){const a=this.getFields();a.forEach((u,v)=>{const{outline:x}=initOutline(u),S=a.length===1?0:d.map(T=>T.fieldIndex).indexOf(v);x.user=d[S]})}showOutline(d){this.fire("show",d)}hideOutline(d){this.fire("hide",d)}fire(d,a){this.component.dispatchEvent(new CustomEvent(`vaadin-highlight-${d}`,{bubbles:!0,composed:!0,detail:{fieldIndex:this.getFieldIndex(a)}}))}redraw(d){this._tags.setUsers(d),this.setOutlines(d)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class FieldObserver extends ComponentObserver{constructor(d){super(d),this.addListeners(d)}addListeners(d){d.addEventListener("focusin",a=>this.onFocusIn(a)),d.addEventListener("focusout",a=>this.onFocusOut(a))}onFocusIn(d){const a=this.getFocusTarget(d);this.showOutline(a)}onFocusOut(d){const a=this.getFocusTarget(d);this.hideOutline(a)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class CheckboxGroupObserver extends FieldObserver{getFields(){return this.component.__checkboxes}getFocusTarget(d){const a=this.getFields();return Array.from(d.composedPath()).find(u=>a.includes(u))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class DatePickerObserver extends ComponentObserver{constructor(d){super(d),this.datePicker=d,this.blurWhileOpened=!1,this.addListeners(d)}addListeners(d){this.overlay=d.$.overlay,d.addEventListener("opened-changed",a=>this.onOpenedChanged(a)),this.overlay.addEventListener("focusout",a=>this.onOverlayFocusOut(a)),d.addEventListener("focusin",a=>this.onFocusIn(a)),d.addEventListener("focusout",a=>this.onFocusOut(a))}isEventInOverlay(d){return this.datePicker._overlayContent&&this.datePicker._overlayContent.contains(d)}isFullscreen(){return this.datePicker._noInput&&!isKeyboardActive()}onFocusIn(d){if(!this.isEventInOverlay(d.relatedTarget)){if(this.blurWhileOpened){this.blurWhileOpened=!1;return}this.showOutline(this.datePicker)}}onFocusOut(d){this.isEventInOverlay(d.relatedTarget)||(this.datePicker.opened?this.blurWhileOpened=!0:this.hideOutline(this.datePicker))}onOverlayFocusOut(d){this.datePicker.contains(d.relatedTarget)||(this.blurWhileOpened=!0)}onOpenedChanged(d){d.detail.value===!0&&this.isFullscreen()&&this.showOutline(this.datePicker),d.detail.value===!1&&this.blurWhileOpened&&(this.blurWhileOpened=!1,this.hideOutline(this.datePicker))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class DateObserver extends DatePickerObserver{constructor(d,a){super(d),this.component=a}getFieldIndex(){return 0}}class TimeObserver extends FieldObserver{constructor(d,a){super(d),this.component=a,this.timePicker=d}getFocusTarget(d){return this.timePicker}getFieldIndex(){return 1}}class DateTimePickerObserver extends ComponentObserver{constructor(d){super(d);const[a,u]=this.getFields();this.dateObserver=new DateObserver(a,d),this.timeObserver=new TimeObserver(u,d)}getFields(){return[this.component.querySelector("[slot=date-picker]"),this.component.querySelector("[slot=time-picker]")]}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class ListBoxObserver extends FieldObserver{getFields(){return this.component.items||[]}getFocusTarget(d){const a=this.getFields();return Array.from(d.composedPath()).find(u=>a.includes(u))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class RadioGroupObserver extends FieldObserver{getFields(){return this.component.__radioButtons}getFocusTarget(d){const a=this.getFields();return Array.from(d.composedPath()).find(u=>a.includes(u))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SelectObserver extends FieldObserver{constructor(d){super(d),this.blurWhileOpened=!1,this.overlay=d._overlayElement}addListeners(d){super.addListeners(d),d.addEventListener("opened-changed",a=>{d._phone&&a.detail.value===!1&&this.hideOutline(d)})}onFocusIn(d){this.overlay.contains(d.relatedTarget)||!this.component._phone&&this.overlay.hasAttribute("closing")||super.onFocusIn(d)}onFocusOut(d){this.overlay.contains(d.relatedTarget)||super.onFocusOut(d)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const initFieldObserver=g=>{let d;switch(g.tagName.toLowerCase()){case"vaadin-date-picker":d=new DatePickerObserver(g);break;case"vaadin-date-time-picker":d=new DateTimePickerObserver(g);break;case"vaadin-select":d=new SelectObserver(g);break;case"vaadin-checkbox-group":d=new CheckboxGroupObserver(g);break;case"vaadin-radio-group":d=new RadioGroupObserver(g);break;case"vaadin-list-box":d=new ListBoxObserver(g);break;default:d=new FieldObserver(g)}return d};class FieldHighlighterController{constructor(d){this.host=d,this.user=null,this.users=[]}get user(){return this._user}set user(d){if(this._user=d,d){const a=`${d.name} started editing`,{label:u}=this.host;announce(u?`${a} ${u}`:a)}}hostConnected(){this.redraw()}addUser(d){d&&(this.users.push(d),this.redraw(),this.user=d)}setUsers(d){Array.isArray(d)&&(this.users=d,this.redraw(),this.user=d[d.length-1]||null)}removeUser(d){if(d&&d.id!==void 0){let a;for(let u=0;u<this.users.length;u++)if(this.users[u].id===d.id){a=u;break}a!==void 0&&(this.users.splice(a,1),this.redraw(),this.users.length>0?this.user=this.users[this.users.length-1]:this.user=null)}}redraw(){this.observer.redraw([...this.users].reverse())}}class FieldHighlighter extends HTMLElement{static get is(){return"vaadin-field-highlighter"}static init(d){if(!d._highlighterController){const a=new FieldHighlighterController(d);d.setAttribute("has-highlighter",""),a.observer=initFieldObserver(d),d.addController(a),d._highlighterController=a}return d._highlighterController}static addUser(d,a){this.init(d).addUser(a)}static removeUser(d,a){this.init(d).removeUser(a)}static setUsers(d,a){this.init(d).setUsers(a)}}defineCustomElement(FieldHighlighter);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/window.JSCompiler_renameProperty=function(g,d){return g};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let CSS_URL_RX=/(url\()([^)]*)(\))/g,ABS_URL=/(^\/[^\/])|(^#)|(^[\w-\d]*:)/,workingURL,resolveDoc;function resolveUrl(g,d){if(g&&ABS_URL.test(g)||g==="//")return g;if(workingURL===void 0){workingURL=!1;try{const a=new URL("b","http://a");a.pathname="c%20d",workingURL=a.href==="http://a/c%20d"}catch{}}if(d||(d=document.baseURI||window.location.href),workingURL)try{return new URL(g,d).href}catch{return g}return resolveDoc||(resolveDoc=document.implementation.createHTMLDocument("temp"),resolveDoc.base=resolveDoc.createElement("base"),resolveDoc.head.appendChild(resolveDoc.base),resolveDoc.anchor=resolveDoc.createElement("a"),resolveDoc.body.appendChild(resolveDoc.anchor)),resolveDoc.base.href=d,resolveDoc.anchor.href=g,resolveDoc.anchor.href||g}function resolveCss(g,d){return g.replace(CSS_URL_RX,function(a,u,v,x){return u+"'"+resolveUrl(v.replace(/["']/g,""),d)+"'"+x})}function pathFromUrl(g){return g.substring(0,g.lastIndexOf("/")+1)}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const useShadow=!window.ShadyDOM||!window.ShadyDOM.inUse;!window.ShadyCSS||window.ShadyCSS.nativeCss;const supportsAdoptingStyleSheets=useShadow&&"adoptedStyleSheets"in Document.prototype&&"replaceSync"in CSSStyleSheet.prototype&&(()=>{try{const g=new CSSStyleSheet;g.replaceSync("");const d=document.createElement("div");return d.attachShadow({mode:"open"}),d.shadowRoot.adoptedStyleSheets=[g],d.shadowRoot.adoptedStyleSheets[0]===g}catch{return!1}})();let rootPath=window.Polymer&&window.Polymer.rootPath||pathFromUrl(document.baseURI||window.location.href),sanitizeDOMValue=window.Polymer&&window.Polymer.sanitizeDOMValue||void 0;window.Polymer&&window.Polymer.setPassiveTouchGestures;let strictTemplatePolicy=window.Polymer&&window.Polymer.strictTemplatePolicy||!1,allowTemplateFromDomModule=window.Polymer&&window.Polymer.allowTemplateFromDomModule||!1,legacyOptimizations=window.Polymer&&window.Polymer.legacyOptimizations||!1,legacyWarnings=window.Polymer&&window.Polymer.legacyWarnings||!1,syncInitialRender=window.Polymer&&window.Polymer.syncInitialRender||!1,legacyUndefined=window.Polymer&&window.Polymer.legacyUndefined||!1,orderedComputed=window.Polymer&&window.Polymer.orderedComputed||!1,removeNestedTemplates=window.Polymer&&window.Polymer.removeNestedTemplates||!1,fastDomIf=window.Polymer&&window.Polymer.fastDomIf||!1,suppressTemplateNotifications=window.Polymer&&window.Polymer.suppressTemplateNotifications||!1;window.Polymer&&window.Polymer.legacyNoObservedAttributes;let useAdoptedStyleSheetsWithBuiltCSS=window.Polymer&&window.Polymer.useAdoptedStyleSheetsWithBuiltCSS||!1;/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let modules={},lcModules={};function setModule(g,d){modules[g]=lcModules[g.toLowerCase()]=d}function findModule(g){return modules[g]||lcModules[g.toLowerCase()]}function styleOutsideTemplateCheck(g){g.querySelector("style")&&console.warn("dom-module %s has style outside template",g.id)}class DomModule extends HTMLElement{static get observedAttributes(){return["id"]}static import(d,a){if(d){let u=findModule(d);return u&&a?u.querySelector(a):u}return null}attributeChangedCallback(d,a,u,v){a!==u&&this.register()}get assetpath(){if(!this.__assetpath){const d=window.HTMLImports&&HTMLImports.importForElement?HTMLImports.importForElement(this)||document:this.ownerDocument,a=resolveUrl(this.getAttribute("assetpath")||"",d.baseURI);this.__assetpath=pathFromUrl(a)}return this.__assetpath}register(d){if(d=d||this.id,d){if(strictTemplatePolicy&&findModule(d)!==void 0)throw setModule(d,null),new Error(`strictTemplatePolicy: dom-module ${d} re-registered`);this.id=d,setModule(d,this),styleOutsideTemplateCheck(this)}}}DomModule.prototype.modules=modules;customElements.define("dom-module",DomModule);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const MODULE_STYLE_LINK_SELECTOR="link[rel=import][type~=css]",INCLUDE_ATTR="include",SHADY_UNSCOPED_ATTR="shady-unscoped";function importModule(g){return DomModule.import(g)}function styleForImport(g){let d=g.body?g.body:g;const a=resolveCss(d.textContent,g.baseURI),u=document.createElement("style");return u.textContent=a,u}function stylesFromModules(g){const d=g.trim().split(/\s+/),a=[];for(let u=0;u<d.length;u++)a.push(...stylesFromModule(d[u]));return a}function stylesFromModule(g){const d=importModule(g);if(!d)return console.warn("Could not find style data in module named",g),[];if(d._styles===void 0){const a=[];a.push(..._stylesFromModuleImports(d));const u=d.querySelector("template");u&&a.push(...stylesFromTemplate(u,d.assetpath)),d._styles=a}return d._styles}function stylesFromTemplate(g,d){if(!g._styles){const a=[],u=g.content.querySelectorAll("style");for(let v=0;v<u.length;v++){let x=u[v],S=x.getAttribute(INCLUDE_ATTR);S&&a.push(...stylesFromModules(S).filter(function(T,P,z){return z.indexOf(T)===P})),d&&(x.textContent=resolveCss(x.textContent,d)),a.push(x)}g._styles=a}return g._styles}function stylesFromModuleImports(g){let d=importModule(g);return d?_stylesFromModuleImports(d):[]}function _stylesFromModuleImports(g){const d=[],a=g.querySelectorAll(MODULE_STYLE_LINK_SELECTOR);for(let u=0;u<a.length;u++){let v=a[u];if(v.import){const x=v.import,S=v.hasAttribute(SHADY_UNSCOPED_ATTR);if(S&&!x._unscopedStyle){const T=styleForImport(x);T.setAttribute(SHADY_UNSCOPED_ATTR,""),x._unscopedStyle=T}else x._style||(x._style=styleForImport(x));d.push(S?x._unscopedStyle:x._style)}}return d}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let moduleIdIndex=0;function registerStyles(g,d=[],a={}){const u=a.moduleId||`custom-style-module-${moduleIdIndex}`;moduleIdIndex+=1;const v=document.createElement("dom-module");g&&v.setAttribute("theme-for",g);const x=!!(d.length&&a.moduleId),S=[].concat(a.include||[]);S.length===0?v.__allStyles=d:x||(v.__partialStyles=d),v.innerHTML=`
    <template>
      ${S.map(T=>`<style include=${T}></style>`)}
      ${x?`<style>${d.map(T=>T.cssText).join(`
`)}</style>`:""}
    </template>
  `,v.register(u)}function getModuleStyles(g){return stylesFromTemplate(g.querySelector("template")).map(d=>r$2(d.textContent))}function getAllThemes(){const d=DomModule.prototype.modules;return Object.keys(d).map(a=>{const u=d[a],v=u.getAttribute("theme-for");return u.__allStyles||(u.__allStyles=getModuleStyles(u).concat(u.__partialStyles||[])),{themeFor:v,moduleId:a,styles:u.__allStyles}})}window.Vaadin||(window.Vaadin={});window.Vaadin.styleModules={getAllThemes,registerStyles};themeRegistry&&themeRegistry.length>0&&(themeRegistry.forEach(g=>{registerStyles(g.themeFor,g.styles,{moduleId:g.moduleId,include:g.include})}),themeRegistry.length=0);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const fontIcons=i`
  @font-face {
    font-family: 'lumo-icons';
    src: url(data:application/font-woff;charset=utf-8;base64,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)
      format('woff');
    font-weight: normal;
    font-style: normal;
  }

  html {
    --lumo-icons-align-center: '\\ea01';
    --lumo-icons-align-left: '\\ea02';
    --lumo-icons-align-right: '\\ea03';
    --lumo-icons-angle-down: '\\ea04';
    --lumo-icons-angle-left: '\\ea05';
    --lumo-icons-angle-right: '\\ea06';
    --lumo-icons-angle-up: '\\ea07';
    --lumo-icons-arrow-down: '\\ea08';
    --lumo-icons-arrow-left: '\\ea09';
    --lumo-icons-arrow-right: '\\ea0a';
    --lumo-icons-arrow-up: '\\ea0b';
    --lumo-icons-bar-chart: '\\ea0c';
    --lumo-icons-bell: '\\ea0d';
    --lumo-icons-calendar: '\\ea0e';
    --lumo-icons-checkmark: '\\ea0f';
    --lumo-icons-chevron-down: '\\ea10';
    --lumo-icons-chevron-left: '\\ea11';
    --lumo-icons-chevron-right: '\\ea12';
    --lumo-icons-chevron-up: '\\ea13';
    --lumo-icons-clock: '\\ea14';
    --lumo-icons-cog: '\\ea15';
    --lumo-icons-cross: '\\ea16';
    --lumo-icons-download: '\\ea17';
    --lumo-icons-drag-handle: '\\ea18';
    --lumo-icons-dropdown: '\\ea19';
    --lumo-icons-edit: '\\ea1a';
    --lumo-icons-error: '\\ea1b';
    --lumo-icons-eye: '\\ea1c';
    --lumo-icons-eye-disabled: '\\ea1d';
    --lumo-icons-menu: '\\ea1e';
    --lumo-icons-minus: '\\ea1f';
    --lumo-icons-ordered-list: '\\ea20';
    --lumo-icons-phone: '\\ea21';
    --lumo-icons-photo: '\\ea22';
    --lumo-icons-play: '\\ea23';
    --lumo-icons-plus: '\\ea24';
    --lumo-icons-redo: '\\ea25';
    --lumo-icons-reload: '\\ea26';
    --lumo-icons-resize-handle: '\\ea27';
    --lumo-icons-search: '\\ea28';
    --lumo-icons-undo: '\\ea29';
    --lumo-icons-unordered-list: '\\ea2a';
    --lumo-icons-upload: '\\ea2b';
    --lumo-icons-user: '\\ea2c';
  }
`;addLumoGlobalStyles("font-icons",fontIcons);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const sizing=i`
  :host {
    --lumo-size-xs: 1.625rem;
    --lumo-size-s: 1.875rem;
    --lumo-size-m: 2.25rem;
    --lumo-size-l: 2.75rem;
    --lumo-size-xl: 3.5rem;

    /* Icons */
    --lumo-icon-size-s: 1.25em;
    --lumo-icon-size-m: 1.5em;
    --lumo-icon-size-l: 2.25em;
    /* For backwards compatibility */
    --lumo-icon-size: var(--lumo-icon-size-m);
  }
`;addLumoGlobalStyles("sizing-props",sizing);const detailsSummary$1=i`
  :host {
    display: flex;
    align-items: center;
    width: 100%;
    outline: none;
    padding: var(--lumo-space-s) 0;
    box-sizing: border-box;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    font-weight: 500;
    line-height: var(--lumo-line-height-xs);
    color: var(--lumo-secondary-text-color);
    background-color: inherit;
    border-radius: var(--lumo-border-radius-m);
    cursor: var(--lumo-clickable-cursor);
    -webkit-tap-highlight-color: transparent;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  :host([disabled]),
  :host([disabled]) [part='toggle'] {
    color: var(--lumo-disabled-text-color);
    cursor: default;
  }

  @media (hover: hover) {
    :host(:hover:not([disabled])),
    :host(:hover:not([disabled])) [part='toggle'] {
      color: var(--lumo-contrast-80pct);
    }
  }

  [part='toggle'] {
    display: block;
    width: 1em;
    height: 1em;
    margin-left: calc(var(--lumo-space-xs) * -1);
    margin-right: var(--lumo-space-xs);
    font-size: var(--lumo-icon-size-s);
    line-height: 1;
    color: var(--lumo-contrast-60pct);
    font-family: 'lumo-icons';
    cursor: var(--lumo-clickable-cursor);
  }

  [part='toggle']::before {
    content: var(--lumo-icons-angle-right);
  }

  :host([opened]) [part='toggle'] {
    transform: rotate(90deg);
  }

  [part='content'] {
    flex-grow: 1;
  }

  /* RTL styles */
  :host([dir='rtl']) [part='toggle'] {
    margin-left: var(--lumo-space-xs);
    margin-right: calc(var(--lumo-space-xs) * -1);
  }

  :host([dir='rtl']) [part='toggle']::before {
    content: var(--lumo-icons-angle-left);
  }

  :host([opened][dir='rtl']) [part='toggle'] {
    transform: rotate(-90deg);
  }

  /* Small */
  :host([theme~='small']) {
    padding-top: var(--lumo-space-xs);
    padding-bottom: var(--lumo-space-xs);
  }

  :host([theme~='small']) [part='toggle'] {
    margin-right: calc(var(--lumo-space-xs) / 2);
  }

  :host([theme~='small'][dir='rtl']) [part='toggle'] {
    margin-left: calc(var(--lumo-space-xs) / 2);
  }

  /* Filled */
  :host([theme~='filled']) {
    padding: var(--lumo-space-s) calc(var(--lumo-space-s) + var(--lumo-space-xs) / 2);
  }

  /* Reverse */
  :host([theme~='reverse']) {
    justify-content: space-between;
  }

  :host([theme~='reverse']) [part='toggle'] {
    order: 1;
    margin-right: 0;
  }

  :host([theme~='reverse'][dir='rtl']) [part='toggle'] {
    margin-left: 0;
  }

  /* Filled reverse */
  :host([theme~='reverse'][theme~='filled']) {
    padding-left: var(--lumo-space-m);
  }

  :host([theme~='reverse'][theme~='filled'][dir='rtl']) {
    padding-right: var(--lumo-space-m);
  }
`;registerStyles$1("vaadin-details-summary",detailsSummary$1,{moduleId:"lumo-details-summary"});const accordionHeading$1=i`
  :host {
    padding: 0;
  }

  [part='content'] {
    padding: var(--lumo-space-s) 0;
  }

  :host([theme~='filled']) {
    padding-top: 0;
    padding-bottom: 0;
  }
`;registerStyles$1("vaadin-accordion-heading",[detailsSummary$1,accordionHeading$1],{moduleId:"lumo-accordion-heading"});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let dedupeId$1=0;const dedupingMixin=function(g){let d=g.__mixinApplications;d||(d=new WeakMap,g.__mixinApplications=d);let a=dedupeId$1++;function u(v){let x=v.__mixinSet;if(x&&x[a])return v;let S=d,T=S.get(v);if(!T){T=g(v),S.set(v,T);let P=Object.create(T.__mixinSet||x||null);P[a]=!0,T.__mixinSet=P}return T}return u};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const wrap$j=window.ShadyDOM&&window.ShadyDOM.noPatch&&window.ShadyDOM.wrap?window.ShadyDOM.wrap:window.ShadyDOM?g=>ShadyDOM.patch(g):g=>g;/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function isPath(g){return g.indexOf(".")>=0}function root(g){let d=g.indexOf(".");return d===-1?g:g.slice(0,d)}function isAncestor(g,d){return g.indexOf(d+".")===0}function isDescendant(g,d){return d.indexOf(g+".")===0}function translate$1(g,d,a){return d+a.slice(g.length)}function matches(g,d){return g===d||isAncestor(g,d)||isDescendant(g,d)}function normalize$1(g){if(Array.isArray(g)){let d=[];for(let a=0;a<g.length;a++){let u=g[a].toString().split(".");for(let v=0;v<u.length;v++)d.push(u[v])}return d.join(".")}else return g}function split(g){return Array.isArray(g)?normalize$1(g).split("."):g.toString().split(".")}function get$6(g,d,a){let u=g,v=split(d);for(let x=0;x<v.length;x++){if(!u)return;let S=v[x];u=u[S]}return a&&(a.path=v.join(".")),u}function set$1(g,d,a){let u=g,v=split(d),x=v[v.length-1];if(v.length>1){for(let S=0;S<v.length-1;S++){let T=v[S];if(u=u[T],!u)return}u[x]=a}else u[d]=a;return v.join(".")}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const caseMap={},DASH_TO_CAMEL=/-[a-z]/g,CAMEL_TO_DASH=/([A-Z])/g;function dashToCamelCase(g){return caseMap[g]||(caseMap[g]=g.indexOf("-")<0?g:g.replace(DASH_TO_CAMEL,d=>d[1].toUpperCase()))}function camelToDashCase(g){return caseMap[g]||(caseMap[g]=g.replace(CAMEL_TO_DASH,"-$1").toLowerCase())}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let microtaskCurrHandle=0,microtaskLastHandle=0,microtaskCallbacks=[],microtaskNodeContent=0,microtaskScheduled=!1,microtaskNode=document.createTextNode("");new window.MutationObserver(microtaskFlush).observe(microtaskNode,{characterData:!0});function microtaskFlush(){microtaskScheduled=!1;const g=microtaskCallbacks.length;for(let d=0;d<g;d++){let a=microtaskCallbacks[d];if(a)try{a()}catch(u){setTimeout(()=>{throw u})}}microtaskCallbacks.splice(0,g),microtaskLastHandle+=g}const timeOut={after(g){return{run(d){return window.setTimeout(d,g)},cancel(d){window.clearTimeout(d)}}},run(g,d){return window.setTimeout(g,d)},cancel(g){window.clearTimeout(g)}},idlePeriod={run(g){return window.requestIdleCallback?window.requestIdleCallback(g):window.setTimeout(g,16)},cancel(g){window.cancelIdleCallback?window.cancelIdleCallback(g):window.clearTimeout(g)}},microTask={run(g){return microtaskScheduled||(microtaskScheduled=!0,microtaskNode.textContent=microtaskNodeContent++),microtaskCallbacks.push(g),microtaskCurrHandle++},cancel(g){const d=g-microtaskLastHandle;if(d>=0){if(!microtaskCallbacks[d])throw new Error("invalid async handle: "+g);microtaskCallbacks[d]=null}}};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const microtask=microTask,PropertiesChanged=dedupingMixin(g=>{class d extends g{static createProperties(u){const v=this.prototype;for(let x in u)x in v||v._createPropertyAccessor(x)}static attributeNameForProperty(u){return u.toLowerCase()}static typeForProperty(u){}_createPropertyAccessor(u,v){this._addPropertyToAttributeMap(u),this.hasOwnProperty(JSCompiler_renameProperty("__dataHasAccessor",this))||(this.__dataHasAccessor=Object.assign({},this.__dataHasAccessor)),this.__dataHasAccessor[u]||(this.__dataHasAccessor[u]=!0,this._definePropertyAccessor(u,v))}_addPropertyToAttributeMap(u){this.hasOwnProperty(JSCompiler_renameProperty("__dataAttributes",this))||(this.__dataAttributes=Object.assign({},this.__dataAttributes));let v=this.__dataAttributes[u];return v||(v=this.constructor.attributeNameForProperty(u),this.__dataAttributes[v]=u),v}_definePropertyAccessor(u,v){Object.defineProperty(this,u,{get(){return this.__data[u]},set:v?function(){}:function(x){this._setPendingProperty(u,x,!0)&&this._invalidateProperties()}})}constructor(){super(),this.__dataEnabled=!1,this.__dataReady=!1,this.__dataInvalid=!1,this.__data={},this.__dataPending=null,this.__dataOld=null,this.__dataInstanceProps=null,this.__dataCounter=0,this.__serializing=!1,this._initializeProperties()}ready(){this.__dataReady=!0,this._flushProperties()}_initializeProperties(){for(let u in this.__dataHasAccessor)this.hasOwnProperty(u)&&(this.__dataInstanceProps=this.__dataInstanceProps||{},this.__dataInstanceProps[u]=this[u],delete this[u])}_initializeInstanceProperties(u){Object.assign(this,u)}_setProperty(u,v){this._setPendingProperty(u,v)&&this._invalidateProperties()}_getProperty(u){return this.__data[u]}_setPendingProperty(u,v,x){let S=this.__data[u],T=this._shouldPropertyChange(u,v,S);return T&&(this.__dataPending||(this.__dataPending={},this.__dataOld={}),this.__dataOld&&!(u in this.__dataOld)&&(this.__dataOld[u]=S),this.__data[u]=v,this.__dataPending[u]=v),T}_isPropertyPending(u){return!!(this.__dataPending&&this.__dataPending.hasOwnProperty(u))}_invalidateProperties(){!this.__dataInvalid&&this.__dataReady&&(this.__dataInvalid=!0,microtask.run(()=>{this.__dataInvalid&&(this.__dataInvalid=!1,this._flushProperties())}))}_enableProperties(){this.__dataEnabled||(this.__dataEnabled=!0,this.__dataInstanceProps&&(this._initializeInstanceProperties(this.__dataInstanceProps),this.__dataInstanceProps=null),this.ready())}_flushProperties(){this.__dataCounter++;const u=this.__data,v=this.__dataPending,x=this.__dataOld;this._shouldPropertiesChange(u,v,x)&&(this.__dataPending=null,this.__dataOld=null,this._propertiesChanged(u,v,x)),this.__dataCounter--}_shouldPropertiesChange(u,v,x){return!!v}_propertiesChanged(u,v,x){}_shouldPropertyChange(u,v,x){return x!==v&&(x===x||v===v)}attributeChangedCallback(u,v,x,S){v!==x&&this._attributeToProperty(u,x),super.attributeChangedCallback&&super.attributeChangedCallback(u,v,x,S)}_attributeToProperty(u,v,x){if(!this.__serializing){const S=this.__dataAttributes,T=S&&S[u]||u;this[T]=this._deserializeValue(v,x||this.constructor.typeForProperty(T))}}_propertyToAttribute(u,v,x){this.__serializing=!0,x=arguments.length<3?this[u]:x,this._valueToNodeAttribute(this,x,v||this.constructor.attributeNameForProperty(u)),this.__serializing=!1}_valueToNodeAttribute(u,v,x){const S=this._serializeValue(v);(x==="class"||x==="name"||x==="slot")&&(u=wrap$j(u)),S===void 0?u.removeAttribute(x):u.setAttribute(x,S===""&&window.trustedTypes?window.trustedTypes.emptyScript:S)}_serializeValue(u){switch(typeof u){case"boolean":return u?"":void 0;default:return u?.toString()}}_deserializeValue(u,v){switch(v){case Boolean:return u!==null;case Number:return Number(u);default:return u}}}return d});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const nativeProperties={};let proto=HTMLElement.prototype;for(;proto;){let g=Object.getOwnPropertyNames(proto);for(let d=0;d<g.length;d++)nativeProperties[g[d]]=!0;proto=Object.getPrototypeOf(proto)}const isTrustedType=window.trustedTypes?g=>trustedTypes.isHTML(g)||trustedTypes.isScript(g)||trustedTypes.isScriptURL(g):()=>!1;function saveAccessorValue(g,d){if(!nativeProperties[d]){let a=g[d];a!==void 0&&(g.__data?g._setPendingProperty(d,a):(g.__dataProto?g.hasOwnProperty(JSCompiler_renameProperty("__dataProto",g))||(g.__dataProto=Object.create(g.__dataProto)):g.__dataProto={},g.__dataProto[d]=a))}}const PropertyAccessors=dedupingMixin(g=>{const d=PropertiesChanged(g);class a extends d{static createPropertiesForAttributes(){let v=this.observedAttributes;for(let x=0;x<v.length;x++)this.prototype._createPropertyAccessor(dashToCamelCase(v[x]))}static attributeNameForProperty(v){return camelToDashCase(v)}_initializeProperties(){this.__dataProto&&(this._initializeProtoProperties(this.__dataProto),this.__dataProto=null),super._initializeProperties()}_initializeProtoProperties(v){for(let x in v)this._setProperty(x,v[x])}_ensureAttribute(v,x){const S=this;S.hasAttribute(v)||this._valueToNodeAttribute(S,x,v)}_serializeValue(v){switch(typeof v){case"object":if(v instanceof Date)return v.toString();if(v){if(isTrustedType(v))return v;try{return JSON.stringify(v)}catch{return""}}default:return super._serializeValue(v)}}_deserializeValue(v,x){let S;switch(x){case Object:try{S=JSON.parse(v)}catch{S=v}break;case Array:try{S=JSON.parse(v)}catch{S=null,console.warn(`Polymer::Attributes: couldn't decode Array as JSON: ${v}`)}break;case Date:S=isNaN(v)?String(v):Number(v),S=new Date(S);break;default:S=super._deserializeValue(v,x);break}return S}_definePropertyAccessor(v,x){saveAccessorValue(this,v),super._definePropertyAccessor(v,x)}_hasAccessor(v){return this.__dataHasAccessor&&this.__dataHasAccessor[v]}_isPropertyPending(v){return!!(this.__dataPending&&v in this.__dataPending)}}return a});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const templateExtensions={"dom-if":!0,"dom-repeat":!0};let placeholderBugDetect=!1,placeholderBug=!1;function hasPlaceholderBug(){if(!placeholderBugDetect){placeholderBugDetect=!0;const g=document.createElement("textarea");g.placeholder="a",placeholderBug=g.placeholder===g.textContent}return placeholderBug}function fixPlaceholder(g){hasPlaceholderBug()&&g.localName==="textarea"&&g.placeholder&&g.placeholder===g.textContent&&(g.textContent=null)}const copyAttributeWithTemplateEventPolicy=(()=>{const g=window.trustedTypes&&window.trustedTypes.createPolicy("polymer-template-event-attribute-policy",{createScript:d=>d});return(d,a,u)=>{const v=a.getAttribute(u);if(g&&u.startsWith("on-")){d.setAttribute(u,g.createScript(v,u));return}d.setAttribute(u,v)}})();function wrapTemplateExtension(g){let d=g.getAttribute("is");if(d&&templateExtensions[d]){let a=g;for(a.removeAttribute("is"),g=a.ownerDocument.createElement(d),a.parentNode.replaceChild(g,a),g.appendChild(a);a.attributes.length;){const{name:u}=a.attributes[0];copyAttributeWithTemplateEventPolicy(g,a,u),a.removeAttribute(u)}}return g}function findTemplateNode(g,d){let a=d.parentInfo&&findTemplateNode(g,d.parentInfo);if(a){for(let u=a.firstChild,v=0;u;u=u.nextSibling)if(d.parentIndex===v++)return u}else return g}function applyIdToMap(g,d,a,u){u.id&&(d[u.id]=a)}function applyEventListener(g,d,a){if(a.events&&a.events.length)for(let u=0,v=a.events,x;u<v.length&&(x=v[u]);u++)g._addMethodEventListenerToNode(d,x.name,x.value,g)}function applyTemplateInfo(g,d,a,u){a.templateInfo&&(d._templateInfo=a.templateInfo,d._parentTemplateInfo=u)}function createNodeEventHandler(g,d,a){return g=g._methodHost||g,function(v){g[a]?g[a](v,v.detail):console.warn("listener method `"+a+"` not defined")}}const TemplateStamp=dedupingMixin(g=>{class d extends g{static _parseTemplate(u,v){if(!u._templateInfo){let x=u._templateInfo={};x.nodeInfoList=[],x.nestedTemplate=!!v,x.stripWhiteSpace=v&&v.stripWhiteSpace||u.hasAttribute&&u.hasAttribute("strip-whitespace"),this._parseTemplateContent(u,x,{parent:null})}return u._templateInfo}static _parseTemplateContent(u,v,x){return this._parseTemplateNode(u.content,v,x)}static _parseTemplateNode(u,v,x){let S=!1,T=u;return T.localName=="template"&&!T.hasAttribute("preserve-content")?S=this._parseTemplateNestedTemplate(T,v,x)||S:T.localName==="slot"&&(v.hasInsertionPoint=!0),fixPlaceholder(T),T.firstChild&&this._parseTemplateChildNodes(T,v,x),T.hasAttributes&&T.hasAttributes()&&(S=this._parseTemplateNodeAttributes(T,v,x)||S),S||x.noted}static _parseTemplateChildNodes(u,v,x){if(!(u.localName==="script"||u.localName==="style"))for(let S=u.firstChild,T=0,P;S;S=P){if(S.localName=="template"&&(S=wrapTemplateExtension(S)),P=S.nextSibling,S.nodeType===Node.TEXT_NODE){let L=P;for(;L&&L.nodeType===Node.TEXT_NODE;)S.textContent+=L.textContent,P=L.nextSibling,u.removeChild(L),L=P;if(v.stripWhiteSpace&&!S.textContent.trim()){u.removeChild(S);continue}}let z={parentIndex:T,parentInfo:x};this._parseTemplateNode(S,v,z)&&(z.infoIndex=v.nodeInfoList.push(z)-1),S.parentNode&&T++}}static _parseTemplateNestedTemplate(u,v,x){let S=u,T=this._parseTemplate(S,v);return(T.content=S.content.ownerDocument.createDocumentFragment()).appendChild(S.content),x.templateInfo=T,!0}static _parseTemplateNodeAttributes(u,v,x){let S=!1,T=Array.from(u.attributes);for(let P=T.length-1,z;z=T[P];P--)S=this._parseTemplateNodeAttribute(u,v,x,z.name,z.value)||S;return S}static _parseTemplateNodeAttribute(u,v,x,S,T){return S.slice(0,3)==="on-"?(u.removeAttribute(S),x.events=x.events||[],x.events.push({name:S.slice(3),value:T}),!0):S==="id"?(x.id=T,!0):!1}static _contentForTemplate(u){let v=u._templateInfo;return v&&v.content||u.content}_stampTemplate(u,v){u&&!u.content&&window.HTMLTemplateElement&&HTMLTemplateElement.decorate&&HTMLTemplateElement.decorate(u),v=v||this.constructor._parseTemplate(u);let x=v.nodeInfoList,S=v.content||u.content,T=document.importNode(S,!0);T.__noInsertionPoint=!v.hasInsertionPoint;let P=T.nodeList=new Array(x.length);T.$={};for(let z=0,L=x.length,N;z<L&&(N=x[z]);z++){let $=P[z]=findTemplateNode(T,N);applyIdToMap(this,T.$,$,N),applyTemplateInfo(this,$,N,v),applyEventListener(this,$,N)}return T=T,T}_addMethodEventListenerToNode(u,v,x,S){S=S||u;let T=createNodeEventHandler(S,v,x);return this._addEventListenerToNode(u,v,T),T}_addEventListenerToNode(u,v,x){u.addEventListener(v,x)}_removeEventListenerFromNode(u,v,x){u.removeEventListener(v,x)}}return d});/**
 * @fileoverview
 * @suppress {checkPrototypalTypes}
 * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
 * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
 * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
 * Google as part of the polymer project is also subject to an additional IP
 * rights grant found at http://polymer.github.io/PATENTS.txt
 */let dedupeId=0;const NOOP=[],TYPES={COMPUTE:"__computeEffects",REFLECT:"__reflectEffects",NOTIFY:"__notifyEffects",PROPAGATE:"__propagateEffects",OBSERVE:"__observeEffects",READ_ONLY:"__readOnly"},COMPUTE_INFO="__computeInfo",capitalAttributeRegex=/[A-Z]/;function ensureOwnEffectMap(g,d,a){let u=g[d];if(!u)u=g[d]={};else if(!g.hasOwnProperty(d)&&(u=g[d]=Object.create(g[d]),a))for(let v in u){let x=u[v],S=u[v]=Array(x.length);for(let T=0;T<x.length;T++)S[T]=x[T]}return u}function runEffects(g,d,a,u,v,x){if(d){let S=!1;const T=dedupeId++;for(let P in a){let z=v?root(P):P,L=d[z];if(L)for(let N=0,$=L.length,B;N<$&&(B=L[N]);N++)(!B.info||B.info.lastRun!==T)&&(!v||pathMatchesTrigger(P,B.trigger))&&(B.info&&(B.info.lastRun=T),B.fn(g,P,a,u,B.info,v,x),S=!0)}return S}return!1}function runEffectsForProperty(g,d,a,u,v,x,S,T){let P=!1,z=S?root(u):u,L=d[z];if(L)for(let N=0,$=L.length,B;N<$&&(B=L[N]);N++)(!B.info||B.info.lastRun!==a)&&(!S||pathMatchesTrigger(u,B.trigger))&&(B.info&&(B.info.lastRun=a),B.fn(g,u,v,x,B.info,S,T),P=!0);return P}function pathMatchesTrigger(g,d){if(d){let a=d.name;return a==g||!!(d.structured&&isAncestor(a,g))||!!(d.wildcard&&isDescendant(a,g))}else return!0}function runObserverEffect(g,d,a,u,v){let x=typeof v.method=="string"?g[v.method]:v.method,S=v.property;x?x.call(g,g.__data[S],u[S]):v.dynamicFn||console.warn("observer method `"+v.method+"` not defined")}function runNotifyEffects(g,d,a,u,v){let x=g[TYPES.NOTIFY],S,T=dedupeId++;for(let z in d)d[z]&&(x&&runEffectsForProperty(g,x,T,z,a,u,v)||v&&notifyPath(g,z,a))&&(S=!0);let P;S&&(P=g.__dataHost)&&P._invalidateProperties&&P._invalidateProperties()}function notifyPath(g,d,a){let u=root(d);if(u!==d){let v=camelToDashCase(u)+"-changed";return dispatchNotifyEvent(g,v,a[d],d),!0}return!1}function dispatchNotifyEvent(g,d,a,u){let v={value:a,queueProperty:!0};u&&(v.path=u),wrap$j(g).dispatchEvent(new CustomEvent(d,{detail:v}))}function runNotifyEffect(g,d,a,u,v,x){let T=(x?root(d):d)!=d?d:null,P=T?get$6(g,T):g.__data[d];T&&P===void 0&&(P=a[d]),dispatchNotifyEvent(g,v.eventName,P,T)}function handleNotification(g,d,a,u,v){let x,S=g.detail,T=S&&S.path;T?(u=translate$1(a,u,T),x=S&&S.value):x=g.currentTarget[a],x=v?!x:x,(!d[TYPES.READ_ONLY]||!d[TYPES.READ_ONLY][u])&&d._setPendingPropertyOrPath(u,x,!0,!!T)&&(!S||!S.queueProperty)&&d._invalidateProperties()}function runReflectEffect(g,d,a,u,v){let x=g.__data[d];sanitizeDOMValue&&(x=sanitizeDOMValue(x,v.attrName,"attribute",g)),g._propertyToAttribute(d,v.attrName,x)}function runComputedEffects(g,d,a,u){let v=g[TYPES.COMPUTE];if(v)if(orderedComputed){dedupeId++;const x=getComputedOrder(g),S=[];for(let P in d)enqueueEffectsFor(P,v,S,x,u);let T;for(;T=S.shift();)runComputedEffect(g,"",d,a,T)&&enqueueEffectsFor(T.methodInfo,v,S,x,u);Object.assign(a,g.__dataOld),Object.assign(d,g.__dataPending),g.__dataPending=null}else{let x=d;for(;runEffects(g,v,x,a,u);)Object.assign(a,g.__dataOld),Object.assign(d,g.__dataPending),x=g.__dataPending,g.__dataPending=null}}const insertEffect=(g,d,a)=>{let u=0,v=d.length-1,x=-1;for(;u<=v;){const S=u+v>>1,T=a.get(d[S].methodInfo)-a.get(g.methodInfo);if(T<0)u=S+1;else if(T>0)v=S-1;else{x=S;break}}x<0&&(x=v+1),d.splice(x,0,g)},enqueueEffectsFor=(g,d,a,u,v)=>{const x=v?root(g):g,S=d[x];if(S)for(let T=0;T<S.length;T++){const P=S[T];P.info.lastRun!==dedupeId&&(!v||pathMatchesTrigger(g,P.trigger))&&(P.info.lastRun=dedupeId,insertEffect(P.info,a,u))}};function getComputedOrder(g){let d=g.constructor.__orderedComputedDeps;if(!d){d=new Map;const a=g[TYPES.COMPUTE];let{counts:u,ready:v,total:x}=dependencyCounts(g),S;for(;S=v.shift();){d.set(S,d.size);const T=a[S];T&&T.forEach(P=>{const z=P.info.methodInfo;--x,--u[z]===0&&v.push(z)})}x!==0&&console.warn(`Computed graph for ${g.localName} incomplete; circular?`),g.constructor.__orderedComputedDeps=d}return d}function dependencyCounts(g){const d=g[COMPUTE_INFO],a={},u=g[TYPES.COMPUTE],v=[];let x=0;for(let S in d){const T=d[S];x+=a[S]=T.args.filter(P=>!P.literal).length+(T.dynamicFn?1:0)}for(let S in u)d[S]||v.push(S);return{counts:a,ready:v,total:x}}function runComputedEffect(g,d,a,u,v){let x=runMethodEffect(g,d,a,u,v);if(x===NOOP)return!1;let S=v.methodInfo;return g.__dataHasAccessor&&g.__dataHasAccessor[S]?g._setPendingProperty(S,x,!0):(g[S]=x,!1)}function computeLinkedPaths(g,d,a){let u=g.__dataLinkedPaths;if(u){let v;for(let x in u){let S=u[x];isDescendant(x,d)?(v=translate$1(x,S,d),g._setPendingPropertyOrPath(v,a,!0,!0)):isDescendant(S,d)&&(v=translate$1(S,x,d),g._setPendingPropertyOrPath(v,a,!0,!0))}}}function addBinding(g,d,a,u,v,x,S){a.bindings=a.bindings||[];let T={kind:u,target:v,parts:x,literal:S,isCompound:x.length!==1};if(a.bindings.push(T),shouldAddListener(T)){let{event:z,negate:L}=T.parts[0];T.listenerEvent=z||camelToDashCase(v)+"-changed",T.listenerNegate=L}let P=d.nodeInfoList.length;for(let z=0;z<T.parts.length;z++){let L=T.parts[z];L.compoundIndex=z,addEffectForBindingPart(g,d,T,L,P)}}function addEffectForBindingPart(g,d,a,u,v){if(!u.literal)if(a.kind==="attribute"&&a.target[0]==="-")console.warn("Cannot set attribute "+a.target+' because "-" is not a valid attribute starting character');else{let x=u.dependencies,S={index:v,binding:a,part:u,evaluator:g};for(let T=0;T<x.length;T++){let P=x[T];typeof P=="string"&&(P=parseArg(P),P.wildcard=!0),g._addTemplatePropertyEffect(d,P.rootProperty,{fn:runBindingEffect,info:S,trigger:P})}}}function runBindingEffect(g,d,a,u,v,x,S){let T=S[v.index],P=v.binding,z=v.part;if(x&&z.source&&d.length>z.source.length&&P.kind=="property"&&!P.isCompound&&T.__isPropertyEffectsClient&&T.__dataHasAccessor&&T.__dataHasAccessor[P.target]){let L=a[d];d=translate$1(z.source,P.target,d),T._setPendingPropertyOrPath(d,L,!1,!0)&&g._enqueueClient(T)}else{let L=v.evaluator._evaluateBinding(g,z,d,a,u,x);L!==NOOP&&applyBindingValue(g,T,P,z,L)}}function applyBindingValue(g,d,a,u,v){if(v=computeBindingValue(d,v,a,u),sanitizeDOMValue&&(v=sanitizeDOMValue(v,a.target,a.kind,d)),a.kind=="attribute")g._valueToNodeAttribute(d,v,a.target);else{let x=a.target;d.__isPropertyEffectsClient&&d.__dataHasAccessor&&d.__dataHasAccessor[x]?(!d[TYPES.READ_ONLY]||!d[TYPES.READ_ONLY][x])&&d._setPendingProperty(x,v)&&g._enqueueClient(d):g._setUnmanagedPropertyToNode(d,x,v)}}function computeBindingValue(g,d,a,u){if(a.isCompound){let v=g.__dataCompoundStorage[a.target];v[u.compoundIndex]=d,d=v.join("")}return a.kind!=="attribute"&&(a.target==="textContent"||a.target==="value"&&(g.localName==="input"||g.localName==="textarea"))&&(d=d??""),d}function shouldAddListener(g){return!!g.target&&g.kind!="attribute"&&g.kind!="text"&&!g.isCompound&&g.parts[0].mode==="{"}function setupBindings(g,d){let{nodeList:a,nodeInfoList:u}=d;if(u.length)for(let v=0;v<u.length;v++){let x=u[v],S=a[v],T=x.bindings;if(T)for(let P=0;P<T.length;P++){let z=T[P];setupCompoundStorage(S,z),addNotifyListener(S,g,z)}S.__dataHost=g}}function setupCompoundStorage(g,d){if(d.isCompound){let a=g.__dataCompoundStorage||(g.__dataCompoundStorage={}),u=d.parts,v=new Array(u.length);for(let S=0;S<u.length;S++)v[S]=u[S].literal;let x=d.target;a[x]=v,d.literal&&d.kind=="property"&&(x==="className"&&(g=wrap$j(g)),g[x]=d.literal)}}function addNotifyListener(g,d,a){if(a.listenerEvent){let u=a.parts[0];g.addEventListener(a.listenerEvent,function(v){handleNotification(v,d,a.target,u.source,u.negate)})}}function createMethodEffect(g,d,a,u,v,x){x=d.static||x&&(typeof x!="object"||x[d.methodName]);let S={methodName:d.methodName,args:d.args,methodInfo:v,dynamicFn:x};for(let T=0,P;T<d.args.length&&(P=d.args[T]);T++)P.literal||g._addPropertyEffect(P.rootProperty,a,{fn:u,info:S,trigger:P});return x&&g._addPropertyEffect(d.methodName,a,{fn:u,info:S}),S}function runMethodEffect(g,d,a,u,v){let x=g._methodHost||g,S=x[v.methodName];if(S){let T=g._marshalArgs(v.args,d,a);return T===NOOP?NOOP:S.apply(x,T)}else v.dynamicFn||console.warn("method `"+v.methodName+"` not defined")}const emptyArray=[],IDENT="(?:[a-zA-Z_$][\\w.:$\\-*]*)",NUMBER$1="(?:[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?)",SQUOTE_STRING="(?:'(?:[^'\\\\]|\\\\.)*')",DQUOTE_STRING='(?:"(?:[^"\\\\]|\\\\.)*")',STRING="(?:"+SQUOTE_STRING+"|"+DQUOTE_STRING+")",ARGUMENT="(?:("+IDENT+"|"+NUMBER$1+"|"+STRING+")\\s*)",ARGUMENTS="(?:"+ARGUMENT+"(?:,\\s*"+ARGUMENT+")*)",ARGUMENT_LIST="(?:\\(\\s*(?:"+ARGUMENTS+"?)\\)\\s*)",BINDING="("+IDENT+"\\s*"+ARGUMENT_LIST+"?)",OPEN_BRACKET="(\\[\\[|{{)\\s*",CLOSE_BRACKET="(?:]]|}})",NEGATE="(?:(!)\\s*)?",EXPRESSION=OPEN_BRACKET+NEGATE+BINDING+CLOSE_BRACKET,bindingRegex=new RegExp(EXPRESSION,"g");function literalFromParts(g){let d="";for(let a=0;a<g.length;a++){let u=g[a].literal;d+=u||""}return d}function parseMethod(g){let d=g.match(/([^\s]+?)\(([\s\S]*)\)/);if(d){let u={methodName:d[1],static:!0,args:emptyArray};if(d[2].trim()){let v=d[2].replace(/\\,/g,"&comma;").split(",");return parseArgs(v,u)}else return u}return null}function parseArgs(g,d){return d.args=g.map(function(a){let u=parseArg(a);return u.literal||(d.static=!1),u},this),d}function parseArg(g){let d=g.trim().replace(/&comma;/g,",").replace(/\\(.)/g,"$1"),a={name:d,value:"",literal:!1},u=d[0];switch(u==="-"&&(u=d[1]),u>="0"&&u<="9"&&(u="#"),u){case"'":case'"':a.value=d.slice(1,-1),a.literal=!0;break;case"#":a.value=Number(d),a.literal=!0;break}return a.literal||(a.rootProperty=root(d),a.structured=isPath(d),a.structured&&(a.wildcard=d.slice(-2)==".*",a.wildcard&&(a.name=d.slice(0,-2)))),a}function getArgValue(g,d,a){let u=get$6(g,a);return u===void 0&&(u=d[a]),u}function notifySplices(g,d,a,u){const v={indexSplices:u};legacyUndefined&&!g._overrideLegacyUndefined&&(d.splices=v),g.notifyPath(a+".splices",v),g.notifyPath(a+".length",d.length),legacyUndefined&&!g._overrideLegacyUndefined&&(v.indexSplices=[])}function notifySplice(g,d,a,u,v,x){notifySplices(g,d,a,[{index:u,addedCount:v,removed:x,object:d,type:"splice"}])}function upper(g){return g[0].toUpperCase()+g.substring(1)}const PropertyEffects=dedupingMixin(g=>{const d=TemplateStamp(PropertyAccessors(g));class a extends d{constructor(){super(),this.__isPropertyEffectsClient=!0,this.__dataClientsReady,this.__dataPendingClients,this.__dataToNotify,this.__dataLinkedPaths,this.__dataHasPaths,this.__dataCompoundStorage,this.__dataHost,this.__dataTemp,this.__dataClientsInitialized,this.__data,this.__dataPending,this.__dataOld,this.__computeEffects,this.__computeInfo,this.__reflectEffects,this.__notifyEffects,this.__propagateEffects,this.__observeEffects,this.__readOnly,this.__templateInfo,this._overrideLegacyUndefined}get PROPERTY_EFFECT_TYPES(){return TYPES}_initializeProperties(){super._initializeProperties(),this._registerHost(),this.__dataClientsReady=!1,this.__dataPendingClients=null,this.__dataToNotify=null,this.__dataLinkedPaths=null,this.__dataHasPaths=!1,this.__dataCompoundStorage=this.__dataCompoundStorage||null,this.__dataHost=this.__dataHost||null,this.__dataTemp={},this.__dataClientsInitialized=!1}_registerHost(){if(hostStack.length){let v=hostStack[hostStack.length-1];v._enqueueClient(this),this.__dataHost=v}}_initializeProtoProperties(v){this.__data=Object.create(v),this.__dataPending=Object.create(v),this.__dataOld={}}_initializeInstanceProperties(v){let x=this[TYPES.READ_ONLY];for(let S in v)(!x||!x[S])&&(this.__dataPending=this.__dataPending||{},this.__dataOld=this.__dataOld||{},this.__data[S]=this.__dataPending[S]=v[S])}_addPropertyEffect(v,x,S){this._createPropertyAccessor(v,x==TYPES.READ_ONLY);let T=ensureOwnEffectMap(this,x,!0)[v];T||(T=this[x][v]=[]),T.push(S)}_removePropertyEffect(v,x,S){let T=ensureOwnEffectMap(this,x,!0)[v],P=T.indexOf(S);P>=0&&T.splice(P,1)}_hasPropertyEffect(v,x){let S=this[x];return!!(S&&S[v])}_hasReadOnlyEffect(v){return this._hasPropertyEffect(v,TYPES.READ_ONLY)}_hasNotifyEffect(v){return this._hasPropertyEffect(v,TYPES.NOTIFY)}_hasReflectEffect(v){return this._hasPropertyEffect(v,TYPES.REFLECT)}_hasComputedEffect(v){return this._hasPropertyEffect(v,TYPES.COMPUTE)}_setPendingPropertyOrPath(v,x,S,T){if(T||root(Array.isArray(v)?v[0]:v)!==v){if(!T){let P=get$6(this,v);if(v=set$1(this,v,x),!v||!super._shouldPropertyChange(v,x,P))return!1}if(this.__dataHasPaths=!0,this._setPendingProperty(v,x,S))return computeLinkedPaths(this,v,x),!0}else{if(this.__dataHasAccessor&&this.__dataHasAccessor[v])return this._setPendingProperty(v,x,S);this[v]=x}return!1}_setUnmanagedPropertyToNode(v,x,S){(S!==v[x]||typeof S=="object")&&(x==="className"&&(v=wrap$j(v)),v[x]=S)}_setPendingProperty(v,x,S){let T=this.__dataHasPaths&&isPath(v),P=T?this.__dataTemp:this.__data;return this._shouldPropertyChange(v,x,P[v])?(this.__dataPending||(this.__dataPending={},this.__dataOld={}),v in this.__dataOld||(this.__dataOld[v]=this.__data[v]),T?this.__dataTemp[v]=x:this.__data[v]=x,this.__dataPending[v]=x,(T||this[TYPES.NOTIFY]&&this[TYPES.NOTIFY][v])&&(this.__dataToNotify=this.__dataToNotify||{},this.__dataToNotify[v]=S),!0):!1}_setProperty(v,x){this._setPendingProperty(v,x,!0)&&this._invalidateProperties()}_invalidateProperties(){this.__dataReady&&this._flushProperties()}_enqueueClient(v){this.__dataPendingClients=this.__dataPendingClients||[],v!==this&&this.__dataPendingClients.push(v)}_flushClients(){this.__dataClientsReady?this.__enableOrFlushClients():(this.__dataClientsReady=!0,this._readyClients(),this.__dataReady=!0)}__enableOrFlushClients(){let v=this.__dataPendingClients;if(v){this.__dataPendingClients=null;for(let x=0;x<v.length;x++){let S=v[x];S.__dataEnabled?S.__dataPending&&S._flushProperties():S._enableProperties()}}}_readyClients(){this.__enableOrFlushClients()}setProperties(v,x){for(let S in v)(x||!this[TYPES.READ_ONLY]||!this[TYPES.READ_ONLY][S])&&this._setPendingPropertyOrPath(S,v[S],!0);this._invalidateProperties()}ready(){this._flushProperties(),this.__dataClientsReady||this._flushClients(),this.__dataPending&&this._flushProperties()}_propertiesChanged(v,x,S){let T=this.__dataHasPaths;this.__dataHasPaths=!1;let P;runComputedEffects(this,x,S,T),P=this.__dataToNotify,this.__dataToNotify=null,this._propagatePropertyChanges(x,S,T),this._flushClients(),runEffects(this,this[TYPES.REFLECT],x,S,T),runEffects(this,this[TYPES.OBSERVE],x,S,T),P&&runNotifyEffects(this,P,x,S,T),this.__dataCounter==1&&(this.__dataTemp={})}_propagatePropertyChanges(v,x,S){this[TYPES.PROPAGATE]&&runEffects(this,this[TYPES.PROPAGATE],v,x,S),this.__templateInfo&&this._runEffectsForTemplate(this.__templateInfo,v,x,S)}_runEffectsForTemplate(v,x,S,T){const P=(z,L)=>{runEffects(this,v.propertyEffects,z,S,L,v.nodeList);for(let N=v.firstChild;N;N=N.nextSibling)this._runEffectsForTemplate(N,z,S,L)};v.runEffects?v.runEffects(P,x,T):P(x,T)}linkPaths(v,x){v=normalize$1(v),x=normalize$1(x),this.__dataLinkedPaths=this.__dataLinkedPaths||{},this.__dataLinkedPaths[v]=x}unlinkPaths(v){v=normalize$1(v),this.__dataLinkedPaths&&delete this.__dataLinkedPaths[v]}notifySplices(v,x){let S={path:""},T=get$6(this,v,S);notifySplices(this,T,S.path,x)}get(v,x){return get$6(x||this,v)}set(v,x,S){S?set$1(S,v,x):(!this[TYPES.READ_ONLY]||!this[TYPES.READ_ONLY][v])&&this._setPendingPropertyOrPath(v,x,!0)&&this._invalidateProperties()}push(v,...x){let S={path:""},T=get$6(this,v,S),P=T.length,z=T.push(...x);return x.length&&notifySplice(this,T,S.path,P,x.length,[]),z}pop(v){let x={path:""},S=get$6(this,v,x),T=!!S.length,P=S.pop();return T&&notifySplice(this,S,x.path,S.length,0,[P]),P}splice(v,x,S,...T){let P={path:""},z=get$6(this,v,P);x<0?x=z.length-Math.floor(-x):x&&(x=Math.floor(x));let L;return arguments.length===2?L=z.splice(x):L=z.splice(x,S,...T),(T.length||L.length)&&notifySplice(this,z,P.path,x,T.length,L),L}shift(v){let x={path:""},S=get$6(this,v,x),T=!!S.length,P=S.shift();return T&&notifySplice(this,S,x.path,0,0,[P]),P}unshift(v,...x){let S={path:""},T=get$6(this,v,S),P=T.unshift(...x);return x.length&&notifySplice(this,T,S.path,0,x.length,[]),P}notifyPath(v,x){let S;if(arguments.length==1){let T={path:""};x=get$6(this,v,T),S=T.path}else Array.isArray(v)?S=normalize$1(v):S=v;this._setPendingPropertyOrPath(S,x,!0,!0)&&this._invalidateProperties()}_createReadOnlyProperty(v,x){this._addPropertyEffect(v,TYPES.READ_ONLY),x&&(this["_set"+upper(v)]=function(S){this._setProperty(v,S)})}_createPropertyObserver(v,x,S){let T={property:v,method:x,dynamicFn:!!S};this._addPropertyEffect(v,TYPES.OBSERVE,{fn:runObserverEffect,info:T,trigger:{name:v}}),S&&this._addPropertyEffect(x,TYPES.OBSERVE,{fn:runObserverEffect,info:T,trigger:{name:x}})}_createMethodObserver(v,x){let S=parseMethod(v);if(!S)throw new Error("Malformed observer expression '"+v+"'");createMethodEffect(this,S,TYPES.OBSERVE,runMethodEffect,null,x)}_createNotifyingProperty(v){this._addPropertyEffect(v,TYPES.NOTIFY,{fn:runNotifyEffect,info:{eventName:camelToDashCase(v)+"-changed",property:v}})}_createReflectedProperty(v){let x=this.constructor.attributeNameForProperty(v);x[0]==="-"?console.warn("Property "+v+" cannot be reflected to attribute "+x+' because "-" is not a valid starting attribute name. Use a lowercase first letter for the property instead.'):this._addPropertyEffect(v,TYPES.REFLECT,{fn:runReflectEffect,info:{attrName:x}})}_createComputedProperty(v,x,S){let T=parseMethod(x);if(!T)throw new Error("Malformed computed expression '"+x+"'");const P=createMethodEffect(this,T,TYPES.COMPUTE,runComputedEffect,v,S);ensureOwnEffectMap(this,COMPUTE_INFO)[v]=P}_marshalArgs(v,x,S){const T=this.__data,P=[];for(let z=0,L=v.length;z<L;z++){let{name:N,structured:$,wildcard:B,value:U,literal:j}=v[z];if(!j)if(B){const Y=isDescendant(N,x),q=getArgValue(T,S,Y?x:N);U={path:Y?x:N,value:q,base:Y?get$6(T,N):q}}else U=$?getArgValue(T,S,N):T[N];if(legacyUndefined&&!this._overrideLegacyUndefined&&U===void 0&&v.length>1)return NOOP;P[z]=U}return P}static addPropertyEffect(v,x,S){this.prototype._addPropertyEffect(v,x,S)}static createPropertyObserver(v,x,S){this.prototype._createPropertyObserver(v,x,S)}static createMethodObserver(v,x){this.prototype._createMethodObserver(v,x)}static createNotifyingProperty(v){this.prototype._createNotifyingProperty(v)}static createReadOnlyProperty(v,x){this.prototype._createReadOnlyProperty(v,x)}static createReflectedProperty(v){this.prototype._createReflectedProperty(v)}static createComputedProperty(v,x,S){this.prototype._createComputedProperty(v,x,S)}static bindTemplate(v){return this.prototype._bindTemplate(v)}_bindTemplate(v,x){let S=this.constructor._parseTemplate(v),T=this.__preBoundTemplateInfo==S;if(!T)for(let P in S.propertyEffects)this._createPropertyAccessor(P);if(x)if(S=Object.create(S),S.wasPreBound=T,!this.__templateInfo)this.__templateInfo=S;else{const P=v._parentTemplateInfo||this.__templateInfo,z=P.lastChild;S.parent=P,P.lastChild=S,S.previousSibling=z,z?z.nextSibling=S:P.firstChild=S}else this.__preBoundTemplateInfo=S;return S}static _addTemplatePropertyEffect(v,x,S){let T=v.hostProps=v.hostProps||{};T[x]=!0;let P=v.propertyEffects=v.propertyEffects||{};(P[x]=P[x]||[]).push(S)}_stampTemplate(v,x){x=x||this._bindTemplate(v,!0),hostStack.push(this);let S=super._stampTemplate(v,x);if(hostStack.pop(),x.nodeList=S.nodeList,!x.wasPreBound){let T=x.childNodes=[];for(let P=S.firstChild;P;P=P.nextSibling)T.push(P)}return S.templateInfo=x,setupBindings(this,x),this.__dataClientsReady&&(this._runEffectsForTemplate(x,this.__data,null,!1),this._flushClients()),S}_removeBoundDom(v){const x=v.templateInfo,{previousSibling:S,nextSibling:T,parent:P}=x;S?S.nextSibling=T:P&&(P.firstChild=T),T?T.previousSibling=S:P&&(P.lastChild=S),x.nextSibling=x.previousSibling=null;let z=x.childNodes;for(let L=0;L<z.length;L++){let N=z[L];wrap$j(wrap$j(N).parentNode).removeChild(N)}}static _parseTemplateNode(v,x,S){let T=d._parseTemplateNode.call(this,v,x,S);if(v.nodeType===Node.TEXT_NODE){let P=this._parseBindings(v.textContent,x);P&&(v.textContent=literalFromParts(P)||" ",addBinding(this,x,S,"text","textContent",P),T=!0)}return T}static _parseTemplateNodeAttribute(v,x,S,T,P){let z=this._parseBindings(P,x);if(z){let L=T,N="property";capitalAttributeRegex.test(T)?N="attribute":T[T.length-1]=="$"&&(T=T.slice(0,-1),N="attribute");let $=literalFromParts(z);return $&&N=="attribute"&&(T=="class"&&v.hasAttribute("class")&&($+=" "+v.getAttribute(T)),v.setAttribute(T,$)),N=="attribute"&&L=="disable-upgrade$"&&v.setAttribute(T,""),v.localName==="input"&&L==="value"&&v.setAttribute(L,""),v.removeAttribute(L),N==="property"&&(T=dashToCamelCase(T)),addBinding(this,x,S,N,T,z,$),!0}else return d._parseTemplateNodeAttribute.call(this,v,x,S,T,P)}static _parseTemplateNestedTemplate(v,x,S){let T=d._parseTemplateNestedTemplate.call(this,v,x,S);const P=v.parentNode,z=S.templateInfo,L=P.localName==="dom-if",N=P.localName==="dom-repeat";removeNestedTemplates&&(L||N)&&(P.removeChild(v),S=S.parentInfo,S.templateInfo=z,S.noted=!0,T=!1);let $=z.hostProps;if(fastDomIf&&L)$&&(x.hostProps=Object.assign(x.hostProps||{},$),removeNestedTemplates||(S.parentInfo.noted=!0));else{let B="{";for(let U in $){let j=[{mode:B,source:U,dependencies:[U],hostProp:!0}];addBinding(this,x,S,"property","_host_"+U,j)}}return T}static _parseBindings(v,x){let S=[],T=0,P;for(;(P=bindingRegex.exec(v))!==null;){P.index>T&&S.push({literal:v.slice(T,P.index)});let z=P[1][0],L=!!P[2],N=P[3].trim(),$=!1,B="",U=-1;z=="{"&&(U=N.indexOf("::"))>0&&(B=N.substring(U+2),N=N.substring(0,U),$=!0);let j=parseMethod(N),Y=[];if(j){let{args:q,methodName:Q}=j;for(let ee=0;ee<q.length;ee++){let ie=q[ee];ie.literal||Y.push(ie)}let J=x.dynamicFns;(J&&J[Q]||j.static)&&(Y.push(Q),j.dynamicFn=!0)}else Y.push(N);S.push({source:N,mode:z,negate:L,customEvent:$,signature:j,dependencies:Y,event:B}),T=bindingRegex.lastIndex}if(T&&T<v.length){let z=v.substring(T);z&&S.push({literal:z})}return S.length?S:null}static _evaluateBinding(v,x,S,T,P,z){let L;return x.signature?L=runMethodEffect(v,S,T,P,x.signature):S!=x.source?L=get$6(v,x.source):z&&isPath(S)?L=get$6(v,S):L=v.__data[S],x.negate&&(L=!L),L}}return a}),hostStack=[];/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function register$2(g){}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function normalizeProperties(g){const d={};for(let a in g){const u=g[a];d[a]=typeof u=="function"?{type:u}:u}return d}const PropertiesMixin=dedupingMixin(g=>{const d=PropertiesChanged(g);function a(x){const S=Object.getPrototypeOf(x);return S.prototype instanceof v?S:null}function u(x){if(!x.hasOwnProperty(JSCompiler_renameProperty("__ownProperties",x))){let S=null;if(x.hasOwnProperty(JSCompiler_renameProperty("properties",x))){const T=x.properties;T&&(S=normalizeProperties(T))}x.__ownProperties=S}return x.__ownProperties}class v extends d{static get observedAttributes(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__observedAttributes",this))){this.prototype;const S=this._properties;this.__observedAttributes=S?Object.keys(S).map(T=>this.prototype._addPropertyToAttributeMap(T)):[]}return this.__observedAttributes}static finalize(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__finalized",this))){const S=a(this);S&&S.finalize(),this.__finalized=!0,this._finalizeClass()}}static _finalizeClass(){const S=u(this);S&&this.createProperties(S)}static get _properties(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__properties",this))){const S=a(this);this.__properties=Object.assign({},S&&S._properties,u(this))}return this.__properties}static typeForProperty(S){const T=this._properties[S];return T&&T.type}_initializeProperties(){this.constructor.finalize(),super._initializeProperties()}connectedCallback(){super.connectedCallback&&super.connectedCallback(),this._enableProperties()}disconnectedCallback(){super.disconnectedCallback&&super.disconnectedCallback()}}return v});/**
 * @fileoverview
 * @suppress {checkPrototypalTypes}
 * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
 * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
 * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
 * Google as part of the polymer project is also subject to an additional IP
 * rights grant found at http://polymer.github.io/PATENTS.txt
 */const version="3.5.2",builtCSS=window.ShadyCSS&&window.ShadyCSS.cssBuild,ElementMixin$1=dedupingMixin(g=>{const d=PropertiesMixin(PropertyEffects(g));function a(P){if(!P.hasOwnProperty(JSCompiler_renameProperty("__propertyDefaults",P))){P.__propertyDefaults=null;let z=P._properties;for(let L in z){let N=z[L];"value"in N&&(P.__propertyDefaults=P.__propertyDefaults||{},P.__propertyDefaults[L]=N)}}return P.__propertyDefaults}function u(P){return P.hasOwnProperty(JSCompiler_renameProperty("__ownObservers",P))||(P.__ownObservers=P.hasOwnProperty(JSCompiler_renameProperty("observers",P))?P.observers:null),P.__ownObservers}function v(P,z,L,N){L.computed&&(L.readOnly=!0),L.computed&&(P._hasReadOnlyEffect(z)?console.warn(`Cannot redefine computed property '${z}'.`):P._createComputedProperty(z,L.computed,N)),L.readOnly&&!P._hasReadOnlyEffect(z)?P._createReadOnlyProperty(z,!L.computed):L.readOnly===!1&&P._hasReadOnlyEffect(z)&&console.warn(`Cannot make readOnly property '${z}' non-readOnly.`),L.reflectToAttribute&&!P._hasReflectEffect(z)?P._createReflectedProperty(z):L.reflectToAttribute===!1&&P._hasReflectEffect(z)&&console.warn(`Cannot make reflected property '${z}' non-reflected.`),L.notify&&!P._hasNotifyEffect(z)?P._createNotifyingProperty(z):L.notify===!1&&P._hasNotifyEffect(z)&&console.warn(`Cannot make notify property '${z}' non-notify.`),L.observer&&P._createPropertyObserver(z,L.observer,N[L.observer]),P._addPropertyToAttributeMap(z)}function x(P,z,L,N){if(!builtCSS){const $=z.content.querySelectorAll("style"),B=stylesFromTemplate(z),U=stylesFromModuleImports(L),j=z.content.firstElementChild;for(let q=0;q<U.length;q++){let Q=U[q];Q.textContent=P._processStyleText(Q.textContent,N),z.content.insertBefore(Q,j)}let Y=0;for(let q=0;q<B.length;q++){let Q=B[q],J=$[Y];J!==Q?(Q=Q.cloneNode(!0),J.parentNode.insertBefore(Q,J)):Y++,Q.textContent=P._processStyleText(Q.textContent,N)}}if(window.ShadyCSS&&window.ShadyCSS.prepareTemplate(z,L),useAdoptedStyleSheetsWithBuiltCSS&&builtCSS&&supportsAdoptingStyleSheets){const $=z.content.querySelectorAll("style");if($){let B="";Array.from($).forEach(U=>{B+=U.textContent,U.parentNode.removeChild(U)}),P._styleSheet=new CSSStyleSheet,P._styleSheet.replaceSync(B)}}}function S(P){let z=null;if(P&&(!strictTemplatePolicy||allowTemplateFromDomModule)&&(z=DomModule.import(P,"template"),strictTemplatePolicy&&!z))throw new Error(`strictTemplatePolicy: expecting dom-module or null template for ${P}`);return z}class T extends d{static get polymerElementVersion(){return version}static _finalizeClass(){d._finalizeClass.call(this);const z=u(this);z&&this.createObservers(z,this._properties),this._prepareTemplate()}static _prepareTemplate(){let z=this.template;z&&(typeof z=="string"?(console.error("template getter must return HTMLTemplateElement"),z=null):legacyOptimizations||(z=z.cloneNode(!0))),this.prototype._template=z}static createProperties(z){for(let L in z)v(this.prototype,L,z[L],z)}static createObservers(z,L){const N=this.prototype;for(let $=0;$<z.length;$++)N._createMethodObserver(z[$],L)}static get template(){if(!this.hasOwnProperty(JSCompiler_renameProperty("_template",this))){let z=this.prototype.hasOwnProperty(JSCompiler_renameProperty("_template",this.prototype))?this.prototype._template:void 0;typeof z=="function"&&(z=z()),this._template=z!==void 0?z:this.hasOwnProperty(JSCompiler_renameProperty("is",this))&&S(this.is)||Object.getPrototypeOf(this.prototype).constructor.template}return this._template}static set template(z){this._template=z}static get importPath(){if(!this.hasOwnProperty(JSCompiler_renameProperty("_importPath",this))){const z=this.importMeta;if(z)this._importPath=pathFromUrl(z.url);else{const L=DomModule.import(this.is);this._importPath=L&&L.assetpath||Object.getPrototypeOf(this.prototype).constructor.importPath}}return this._importPath}constructor(){super(),this._template,this._importPath,this.rootPath,this.importPath,this.root,this.$}_initializeProperties(){this.constructor.finalize(),this.constructor._finalizeTemplate(this.localName),super._initializeProperties(),this.rootPath=rootPath,this.importPath=this.constructor.importPath;let z=a(this.constructor);if(z)for(let L in z){let N=z[L];if(this._canApplyPropertyDefault(L)){let $=typeof N.value=="function"?N.value.call(this):N.value;this._hasAccessor(L)?this._setPendingProperty(L,$,!0):this[L]=$}}}_canApplyPropertyDefault(z){return!this.hasOwnProperty(z)}static _processStyleText(z,L){return resolveCss(z,L)}static _finalizeTemplate(z){const L=this.prototype._template;if(L&&!L.__polymerFinalized){L.__polymerFinalized=!0;const N=this.importPath,$=N?resolveUrl(N):"";x(this,L,z,$),this.prototype._bindTemplate(L)}}connectedCallback(){window.ShadyCSS&&this._template&&window.ShadyCSS.styleElement(this),super.connectedCallback()}ready(){this._template&&(this.root=this._stampTemplate(this._template),this.$=this.root.$),super.ready()}_readyClients(){this._template&&(this.root=this._attachDom(this.root)),super._readyClients()}_attachDom(z){const L=wrap$j(this);if(L.attachShadow)return z?(L.shadowRoot||(L.attachShadow({mode:"open",shadyUpgradeFragment:z}),L.shadowRoot.appendChild(z),this.constructor._styleSheet&&(L.shadowRoot.adoptedStyleSheets=[this.constructor._styleSheet])),syncInitialRender&&window.ShadyDOM&&window.ShadyDOM.flushInitial(L.shadowRoot),L.shadowRoot):null;throw new Error("ShadowDOM not available. PolymerElement can create dom as children instead of in ShadowDOM by setting `this.root = this;` before `ready`.")}updateStyles(z){window.ShadyCSS&&window.ShadyCSS.styleSubtree(this,z)}resolveUrl(z,L){return!L&&this.importPath&&(L=resolveUrl(this.importPath)),resolveUrl(z,L)}static _parseTemplateContent(z,L,N){return L.dynamicFns=L.dynamicFns||this._properties,d._parseTemplateContent.call(this,z,L,N)}static _addTemplatePropertyEffect(z,L,N){return legacyWarnings&&!(L in this._properties)&&!(N.info.part.signature&&N.info.part.signature.static)&&!N.info.part.hostProp&&!z.nestedTemplate&&console.warn(`Property '${L}' used in template but not declared in 'properties'; attribute will not be observed.`),d._addTemplatePropertyEffect.call(this,z,L,N)}}return T});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const policy=window.trustedTypes&&trustedTypes.createPolicy("polymer-html-literal",{createHTML:g=>g});class LiteralString{constructor(d,a){assertValidTemplateStringParameters(d,a);const u=a.reduce((v,x,S)=>v+literalValue(x)+d[S+1],d[0]);this.value=u.toString()}toString(){return this.value}}function literalValue(g){if(g instanceof LiteralString)return g.value;throw new Error(`non-literal value passed to Polymer's htmlLiteral function: ${g}`)}function htmlValue(g){if(g instanceof HTMLTemplateElement)return g.innerHTML;if(g instanceof LiteralString)return literalValue(g);throw new Error(`non-template value passed to Polymer's html function: ${g}`)}const html$3=function(d,...a){assertValidTemplateStringParameters(d,a);const u=document.createElement("template");let v=a.reduce((x,S,T)=>x+htmlValue(S)+d[T+1],d[0]);return policy&&(v=policy.createHTML(v)),u.innerHTML=v,u},assertValidTemplateStringParameters=(g,d)=>{if(!Array.isArray(g)||!Array.isArray(g.raw)||d.length!==g.length-1)throw new TypeError("Invalid call to the html template tag")};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const PolymerElement=ElementMixin$1(HTMLElement);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const wrap$i=g=>g,HAS_NATIVE_TA=typeof document.head.style.touchAction=="string",GESTURE_KEY="__polymerGestures",HANDLED_OBJ="__polymerGesturesHandled",TOUCH_ACTION="__polymerGesturesTouchAction",TAP_DISTANCE=25,TRACK_DISTANCE=5,TRACK_LENGTH=2,MOUSE_EVENTS=["mousedown","mousemove","mouseup","click"],MOUSE_WHICH_TO_BUTTONS=[0,1,4,2],MOUSE_HAS_BUTTONS=(function(){try{return new MouseEvent("test",{buttons:1}).buttons===1}catch{return!1}})();function isMouseEvent(g){return MOUSE_EVENTS.indexOf(g)>-1}let supportsPassive=!1;(function(){try{const g=Object.defineProperty({},"passive",{get(){supportsPassive=!0}});window.addEventListener("test",null,g),window.removeEventListener("test",null,g)}catch{}})();function PASSIVE_TOUCH(g){isMouseEvent(g)}const IS_TOUCH_ONLY=navigator.userAgent.match(/iP(?:[oa]d|hone)|Android/u),canBeDisabled={button:!0,command:!0,fieldset:!0,input:!0,keygen:!0,optgroup:!0,option:!0,select:!0,textarea:!0};function hasLeftMouseButton(g){const d=g.type;if(!isMouseEvent(d))return!1;if(d==="mousemove"){let u=g.buttons===void 0?1:g.buttons;return g instanceof window.MouseEvent&&!MOUSE_HAS_BUTTONS&&(u=MOUSE_WHICH_TO_BUTTONS[g.which]||0),!!(u&1)}return(g.button===void 0?0:g.button)===0}function isSyntheticClick(g){if(g.type==="click"){if(g.detail===0)return!0;const d=_findOriginalTarget(g);if(!d.nodeType||d.nodeType!==Node.ELEMENT_NODE)return!0;const a=d.getBoundingClientRect(),u=g.pageX,v=g.pageY;return!(u>=a.left&&u<=a.right&&v>=a.top&&v<=a.bottom)}return!1}const POINTERSTATE={touch:{x:0,y:0,id:-1,scrollDecided:!1}};function firstTouchAction(g){let d="auto";const a=getComposedPath(g);for(let u=0,v;u<a.length;u++)if(v=a[u],v[TOUCH_ACTION]){d=v[TOUCH_ACTION];break}return d}function trackDocument(g,d,a){g.movefn=d,g.upfn=a,document.addEventListener("mousemove",d),document.addEventListener("mouseup",a)}function untrackDocument(g){document.removeEventListener("mousemove",g.movefn),document.removeEventListener("mouseup",g.upfn),g.movefn=null,g.upfn=null}const getComposedPath=window.ShadyDOM&&window.ShadyDOM.noPatch?window.ShadyDOM.composedPath:g=>g.composedPath&&g.composedPath()||[],gestures={},recognizers=[];function deepTargetFind(g,d){let a=document.elementFromPoint(g,d),u=a;for(;u&&u.shadowRoot&&!window.ShadyDOM;){const v=u;if(u=u.shadowRoot.elementFromPoint(g,d),v===u)break;u&&(a=u)}return a}function _findOriginalTarget(g){const d=getComposedPath(g);return d.length>0?d[0]:g.target}function _handleNative(g){const d=g.type,u=g.currentTarget[GESTURE_KEY];if(!u)return;const v=u[d];if(!v)return;if(!g[HANDLED_OBJ]&&(g[HANDLED_OBJ]={},d.startsWith("touch"))){const S=g.changedTouches[0];if(d==="touchstart"&&g.touches.length===1&&(POINTERSTATE.touch.id=S.identifier),POINTERSTATE.touch.id!==S.identifier)return;HAS_NATIVE_TA||(d==="touchstart"||d==="touchmove")&&_handleTouchAction(g)}const x=g[HANDLED_OBJ];if(!x.skip){for(let S=0,T;S<recognizers.length;S++)T=recognizers[S],v[T.name]&&!x[T.name]&&T.flow&&T.flow.start.indexOf(g.type)>-1&&T.reset&&T.reset();for(let S=0,T;S<recognizers.length;S++)T=recognizers[S],v[T.name]&&!x[T.name]&&(x[T.name]=!0,T[d](g))}}function _handleTouchAction(g){const d=g.changedTouches[0],a=g.type;if(a==="touchstart")POINTERSTATE.touch.x=d.clientX,POINTERSTATE.touch.y=d.clientY,POINTERSTATE.touch.scrollDecided=!1;else if(a==="touchmove"){if(POINTERSTATE.touch.scrollDecided)return;POINTERSTATE.touch.scrollDecided=!0;const u=firstTouchAction(g);let v=!1;const x=Math.abs(POINTERSTATE.touch.x-d.clientX),S=Math.abs(POINTERSTATE.touch.y-d.clientY);g.cancelable&&(u==="none"?v=!0:u==="pan-x"?v=S>x:u==="pan-y"&&(v=x>S)),v?g.preventDefault():prevent("track")}}function addListener(g,d,a){return gestures[d]?(_add(g,d,a),!0):!1}function removeListener(g,d,a){return gestures[d]?(_remove(g,d,a),!0):!1}function _add(g,d,a){const u=gestures[d],v=u.deps,x=u.name;let S=g[GESTURE_KEY];S||(g[GESTURE_KEY]=S={});for(let T=0,P,z;T<v.length;T++)P=v[T],!(IS_TOUCH_ONLY&&isMouseEvent(P)&&P!=="click")&&(z=S[P],z||(S[P]=z={_count:0}),z._count===0&&g.addEventListener(P,_handleNative,PASSIVE_TOUCH(P)),z[x]=(z[x]||0)+1,z._count=(z._count||0)+1);g.addEventListener(d,a),u.touchAction&&setTouchAction(g,u.touchAction)}function _remove(g,d,a){const u=gestures[d],v=u.deps,x=u.name,S=g[GESTURE_KEY];if(S)for(let T=0,P,z;T<v.length;T++)P=v[T],z=S[P],z&&z[x]&&(z[x]=(z[x]||1)-1,z._count=(z._count||1)-1,z._count===0&&g.removeEventListener(P,_handleNative,PASSIVE_TOUCH(P)));g.removeEventListener(d,a)}function register$1(g){recognizers.push(g),g.emits.forEach(d=>{gestures[d]=g})}function _findRecognizerByEvent(g){for(let d=0,a;d<recognizers.length;d++){a=recognizers[d];for(let u=0,v;u<a.emits.length;u++)if(v=a.emits[u],v===g)return a}return null}function setTouchAction(g,d){HAS_NATIVE_TA&&g instanceof HTMLElement&&microTask$1.run(()=>{g.style.touchAction=d}),g[TOUCH_ACTION]=d}function _fire(g,d,a){const u=new Event(d,{bubbles:!0,cancelable:!0,composed:!0});if(u.detail=a,wrap$i(g).dispatchEvent(u),u.defaultPrevented){const v=a.preventer||a.sourceEvent;v&&v.preventDefault&&v.preventDefault()}}function prevent(g){const d=_findRecognizerByEvent(g);d.info&&(d.info.prevent=!0)}register$1({name:"downup",deps:["mousedown","touchstart","touchend"],flow:{start:["mousedown","touchstart"],end:["mouseup","touchend"]},emits:["down","up"],info:{movefn:null,upfn:null},reset(){untrackDocument(this.info)},mousedown(g){if(!hasLeftMouseButton(g))return;const d=_findOriginalTarget(g),a=this,u=x=>{hasLeftMouseButton(x)||(downupFire("up",d,x),untrackDocument(a.info))},v=x=>{hasLeftMouseButton(x)&&downupFire("up",d,x),untrackDocument(a.info)};trackDocument(this.info,u,v),downupFire("down",d,g)},touchstart(g){downupFire("down",_findOriginalTarget(g),g.changedTouches[0],g)},touchend(g){downupFire("up",_findOriginalTarget(g),g.changedTouches[0],g)}});function downupFire(g,d,a,u){d&&_fire(d,g,{x:a.clientX,y:a.clientY,sourceEvent:a,preventer:u,prevent(v){return prevent(v)}})}register$1({name:"track",touchAction:"none",deps:["mousedown","touchstart","touchmove","touchend"],flow:{start:["mousedown","touchstart"],end:["mouseup","touchend"]},emits:["track"],info:{x:0,y:0,state:"start",started:!1,moves:[],addMove(g){this.moves.length>TRACK_LENGTH&&this.moves.shift(),this.moves.push(g)},movefn:null,upfn:null,prevent:!1},reset(){this.info.state="start",this.info.started=!1,this.info.moves=[],this.info.x=0,this.info.y=0,this.info.prevent=!1,untrackDocument(this.info)},mousedown(g){if(!hasLeftMouseButton(g))return;const d=_findOriginalTarget(g),a=this,u=x=>{const S=x.clientX,T=x.clientY;trackHasMovedEnough(a.info,S,T)&&(a.info.state=a.info.started?x.type==="mouseup"?"end":"track":"start",a.info.state==="start"&&prevent("tap"),a.info.addMove({x:S,y:T}),hasLeftMouseButton(x)||(a.info.state="end",untrackDocument(a.info)),d&&trackFire(a.info,d,x),a.info.started=!0)},v=x=>{a.info.started&&u(x),untrackDocument(a.info)};trackDocument(this.info,u,v),this.info.x=g.clientX,this.info.y=g.clientY},touchstart(g){const d=g.changedTouches[0];this.info.x=d.clientX,this.info.y=d.clientY},touchmove(g){const d=_findOriginalTarget(g),a=g.changedTouches[0],u=a.clientX,v=a.clientY;trackHasMovedEnough(this.info,u,v)&&(this.info.state==="start"&&prevent("tap"),this.info.addMove({x:u,y:v}),trackFire(this.info,d,a),this.info.state="track",this.info.started=!0)},touchend(g){const d=_findOriginalTarget(g),a=g.changedTouches[0];this.info.started&&(this.info.state="end",this.info.addMove({x:a.clientX,y:a.clientY}),trackFire(this.info,d,a))}});function trackHasMovedEnough(g,d,a){if(g.prevent)return!1;if(g.started)return!0;const u=Math.abs(g.x-d),v=Math.abs(g.y-a);return u>=TRACK_DISTANCE||v>=TRACK_DISTANCE}function trackFire(g,d,a){if(!d)return;const u=g.moves[g.moves.length-2],v=g.moves[g.moves.length-1],x=v.x-g.x,S=v.y-g.y;let T,P=0;u&&(T=v.x-u.x,P=v.y-u.y),_fire(d,"track",{state:g.state,x:a.clientX,y:a.clientY,dx:x,dy:S,ddx:T,ddy:P,sourceEvent:a,hover(){return deepTargetFind(a.clientX,a.clientY)}})}register$1({name:"tap",deps:["mousedown","click","touchstart","touchend"],flow:{start:["mousedown","touchstart"],end:["click","touchend"]},emits:["tap"],info:{x:NaN,y:NaN,prevent:!1},reset(){this.info.x=NaN,this.info.y=NaN,this.info.prevent=!1},mousedown(g){hasLeftMouseButton(g)&&(this.info.x=g.clientX,this.info.y=g.clientY)},click(g){hasLeftMouseButton(g)&&trackForward(this.info,g)},touchstart(g){const d=g.changedTouches[0];this.info.x=d.clientX,this.info.y=d.clientY},touchend(g){trackForward(this.info,g.changedTouches[0],g)}});function trackForward(g,d,a){const u=Math.abs(d.clientX-g.x),v=Math.abs(d.clientY-g.y),x=_findOriginalTarget(a||d);!x||canBeDisabled[x.localName]&&x.hasAttribute("disabled")||(isNaN(u)||isNaN(v)||u<=TAP_DISTANCE&&v<=TAP_DISTANCE||isSyntheticClick(d))&&(g.prevent||_fire(x,"tap",{x:d.clientX,y:d.clientY,sourceEvent:d,preventer:a}))}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DisabledMixin=dedupeMixin(g=>class extends g{static get properties(){return{disabled:{type:Boolean,value:!1,observer:"_disabledChanged",reflectToAttribute:!0,sync:!0}}}_disabledChanged(a){this._setAriaDisabled(a)}_setAriaDisabled(a){a?this.setAttribute("aria-disabled","true"):this.removeAttribute("aria-disabled")}click(){this.disabled||super.click()}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const KeyboardMixin=dedupeMixin(g=>class extends g{ready(){super.ready(),this.addEventListener("keydown",a=>{this._onKeyDown(a)}),this.addEventListener("keyup",a=>{this._onKeyUp(a)})}_onKeyDown(a){switch(a.key){case"Enter":this._onEnter(a);break;case"Escape":this._onEscape(a);break}}_onKeyUp(a){}_onEnter(a){}_onEscape(a){}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ActiveMixin=g=>class extends DisabledMixin(KeyboardMixin(g)){get _activeKeys(){return[" "]}ready(){super.ready(),addListener(this,"down",a=>{this._shouldSetActive(a)&&this._setActive(!0)}),addListener(this,"up",()=>{this._setActive(!1)})}disconnectedCallback(){super.disconnectedCallback(),this._setActive(!1)}_shouldSetActive(a){return!this.disabled}_onKeyDown(a){super._onKeyDown(a),this._shouldSetActive(a)&&this._activeKeys.includes(a.key)&&(this._setActive(!0),document.addEventListener("keyup",u=>{this._activeKeys.includes(u.key)&&this._setActive(!1)},{once:!0}))}_setActive(a){this.toggleAttribute("active",a)}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const accordionHeading=i`
  :host {
    display: block;
    outline: none;
    -webkit-user-select: none;
    user-select: none;
  }

  :host([hidden]) {
    display: none !important;
  }

  button {
    display: flex;
    align-items: center;
    justify-content: inherit;
    width: 100%;
    margin: 0;
    padding: 0;
    background-color: initial;
    color: inherit;
    border: initial;
    outline: none;
    font: inherit;
    text-align: inherit;
  }
`;/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-accordion-heading",accordionHeading,{moduleId:"vaadin-accordion-heading-styles"});class AccordionHeading extends ActiveMixin(DirMixin(ThemableMixin(PolymerElement))){static get is(){return"vaadin-accordion-heading"}static get template(){return html$3`
      <button id="button" part="content" disabled$="[[disabled]]" aria-expanded$="[[__updateAriaExpanded(opened)]]">
        <span part="toggle" aria-hidden="true"></span>
        <slot></slot>
      </button>
    `}static get properties(){return{opened:{type:Boolean,reflectToAttribute:!0,value:!1}}}_attachDom(d){const a=this.attachShadow({mode:"open",delegatesFocus:!0});return a.appendChild(d),a}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","heading")}__updateAriaExpanded(d){return d?"true":"false"}}defineCustomElement(AccordionHeading);const details=i`
  :host {
    margin: var(--lumo-space-xs) 0;
    outline: none;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
  }

  :host([focus-ring]) ::slotted([slot='summary']) {
    box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  [part='content'] {
    padding: var(--lumo-space-xs) 0 var(--lumo-space-s);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-m);
  }

  :host([theme~='filled']) {
    background-color: var(--lumo-contrast-5pct);
    border-radius: var(--lumo-border-radius-m);
  }

  :host([theme~='filled']) [part='content'] {
    padding-left: var(--lumo-space-m);
    padding-right: var(--lumo-space-m);
  }

  :host([theme~='small']) [part$='content'] {
    font-size: var(--lumo-font-size-s);
  }
`;registerStyles$1("vaadin-details",details,{moduleId:"lumo-details"});const accordionPanel$1=i`
  :host {
    margin: 0;
    border-bottom: solid 1px var(--lumo-contrast-10pct);
  }

  :host(:last-child) {
    border-bottom: none;
  }

  :host([theme~='filled']) {
    border-bottom: none;
  }

  :host([theme~='filled']:not(:last-child)) {
    margin-bottom: 2px;
  }
`;registerStyles$1("vaadin-accordion-panel",[details,accordionPanel$1],{moduleId:"lumo-accordion-panel"});/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const accordionPanel=i`
  :host {
    display: block;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='content'] {
    display: none;
    overflow: hidden;
  }

  :host([opened]) [part='content'] {
    display: block;
    overflow: visible;
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const FocusMixin=dedupeMixin(g=>class extends g{get _keyboardActive(){return isKeyboardActive()}ready(){this.addEventListener("focusin",a=>{this._shouldSetFocus(a)&&this._setFocused(!0)}),this.addEventListener("focusout",a=>{this._shouldRemoveFocus(a)&&this._setFocused(!1)}),super.ready()}disconnectedCallback(){super.disconnectedCallback(),this.hasAttribute("focused")&&this._setFocused(!1)}_setFocused(a){this.toggleAttribute("focused",a),this.toggleAttribute("focus-ring",a&&this._keyboardActive)}_shouldSetFocus(a){return!0}_shouldRemoveFocus(a){return!0}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const TabindexMixin=g=>class extends DisabledMixin(g){static get properties(){return{tabindex:{type:Number,reflectToAttribute:!0,observer:"_tabindexChanged",sync:!0},_lastTabIndex:{type:Number}}}_disabledChanged(a,u){super._disabledChanged(a,u),!this.__shouldAllowFocusWhenDisabled()&&(a?(this.tabindex!==void 0&&(this._lastTabIndex=this.tabindex),this.setAttribute("tabindex","-1")):u&&(this._lastTabIndex!==void 0?this.setAttribute("tabindex",this._lastTabIndex):this.tabindex=void 0))}_tabindexChanged(a){this.__shouldAllowFocusWhenDisabled()||this.disabled&&a!==-1&&(this._lastTabIndex=a,this.setAttribute("tabindex","-1"))}focus(){(!this.disabled||this.__shouldAllowFocusWhenDisabled())&&super.focus()}__shouldAllowFocusWhenDisabled(){return!1}};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DelegateFocusMixin=dedupeMixin(g=>class extends FocusMixin(TabindexMixin(g)){static get properties(){return{autofocus:{type:Boolean},focusElement:{type:Object,readOnly:!0,observer:"_focusElementChanged",sync:!0},_lastTabIndex:{value:0}}}constructor(){super(),this._boundOnBlur=this._onBlur.bind(this),this._boundOnFocus=this._onFocus.bind(this)}ready(){super.ready(),this.autofocus&&!this.disabled&&requestAnimationFrame(()=>{this.focus(),this.setAttribute("focus-ring","")})}focus(){this.focusElement&&!this.disabled&&this.focusElement.focus()}blur(){this.focusElement&&this.focusElement.blur()}click(){this.focusElement&&!this.disabled&&this.focusElement.click()}_focusElementChanged(a,u){a?(a.disabled=this.disabled,this._addFocusListeners(a),this.__forwardTabIndex(this.tabindex)):u&&this._removeFocusListeners(u)}_addFocusListeners(a){a.addEventListener("blur",this._boundOnBlur),a.addEventListener("focus",this._boundOnFocus)}_removeFocusListeners(a){a.removeEventListener("blur",this._boundOnBlur),a.removeEventListener("focus",this._boundOnFocus)}_onFocus(a){a.stopPropagation(),this.dispatchEvent(new Event("focus"))}_onBlur(a){a.stopPropagation(),this.dispatchEvent(new Event("blur"))}_shouldSetFocus(a){return a.target===this.focusElement}_shouldRemoveFocus(a){return a.target===this.focusElement}_disabledChanged(a,u){super._disabledChanged(a,u),this.focusElement&&(this.focusElement.disabled=a),a&&this.blur()}_tabindexChanged(a){this.__forwardTabIndex(a)}__forwardTabIndex(a){a!==void 0&&this.focusElement&&(this.focusElement.tabIndex=a,a!==-1&&(this.tabindex=void 0)),this.disabled&&a&&(a!==-1&&(this._lastTabIndex=a),this.tabindex=void 0),a===void 0&&this.hasAttribute("tabindex")&&this.removeAttribute("tabindex")}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DelegateStateMixin=dedupeMixin(g=>class extends g{static get properties(){return{stateTarget:{type:Object,observer:"_stateTargetChanged"}}}static get delegateAttrs(){return[]}static get delegateProps(){return[]}ready(){super.ready(),this._createDelegateAttrsObserver(),this._createDelegatePropsObserver()}_stateTargetChanged(a){a&&(this._ensureAttrsDelegated(),this._ensurePropsDelegated())}_createDelegateAttrsObserver(){this._createMethodObserver(`_delegateAttrsChanged(${this.constructor.delegateAttrs.join(", ")})`)}_createDelegatePropsObserver(){this._createMethodObserver(`_delegatePropsChanged(${this.constructor.delegateProps.join(", ")})`)}_ensureAttrsDelegated(){this.constructor.delegateAttrs.forEach(a=>{this._delegateAttribute(a,this[a])})}_ensurePropsDelegated(){this.constructor.delegateProps.forEach(a=>{this._delegateProperty(a,this[a])})}_delegateAttrsChanged(...a){this.constructor.delegateAttrs.forEach((u,v)=>{this._delegateAttribute(u,a[v])})}_delegatePropsChanged(...a){this.constructor.delegateProps.forEach((u,v)=>{this._delegateProperty(u,a[v])})}_delegateAttribute(a,u){this.stateTarget&&(a==="invalid"&&this._delegateAttribute("aria-invalid",u?"true":!1),typeof u=="boolean"?this.stateTarget.toggleAttribute(a,u):u?this.stateTarget.setAttribute(a,u):this.stateTarget.removeAttribute(a))}_delegateProperty(a,u){this.stateTarget&&(this.stateTarget[a]=u)}});/**
 * @license
 * Copyright (c) 2023 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotObserver{constructor(d,a){this.slot=d,this.callback=a,this._storedNodes=[],this._connected=!1,this._scheduled=!1,this._boundSchedule=()=>{this._schedule()},this.connect(),this._schedule()}connect(){this.slot.addEventListener("slotchange",this._boundSchedule),this._connected=!0}disconnect(){this.slot.removeEventListener("slotchange",this._boundSchedule),this._connected=!1}_schedule(){this._scheduled||(this._scheduled=!0,queueMicrotask(()=>{this.flush()}))}flush(){this._connected&&(this._scheduled=!1,this._processNodes())}_processNodes(){const d=this.slot.assignedNodes({flatten:!0});let a=[];const u=[],v=[];d.length&&(a=d.filter(x=>!this._storedNodes.includes(x))),this._storedNodes.length&&this._storedNodes.forEach((x,S)=>{const T=d.indexOf(x);T===-1?u.push(x):T!==S&&v.push(x)}),(a.length||u.length||v.length)&&this.callback({addedNodes:a,currentNodes:d,movedNodes:v,removedNodes:u}),this._storedNodes=d}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let uniqueId=0;function generateUniqueId(){return uniqueId++}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotController extends EventTarget{static generateId(d,a="default"){return`${a}-${d.localName}-${generateUniqueId()}`}constructor(d,a,u,v={}){super();const{initializer:x,multiple:S,observe:T,useUniqueId:P,uniqueIdPrefix:z}=v;this.host=d,this.slotName=a,this.tagName=u,this.observe=typeof T=="boolean"?T:!0,this.multiple=typeof S=="boolean"?S:!1,this.slotInitializer=x,S&&(this.nodes=[]),P&&(this.defaultId=this.constructor.generateId(d,z||a))}hostConnected(){this.initialized||(this.multiple?this.initMultiple():this.initSingle(),this.observe&&this.observeSlot(),this.initialized=!0)}initSingle(){let d=this.getSlotChild();d?(this.node=d,this.initAddedNode(d)):(d=this.attachDefaultNode(),this.initNode(d))}initMultiple(){const d=this.getSlotChildren();if(d.length===0){const a=this.attachDefaultNode();a&&(this.nodes=[a],this.initNode(a))}else this.nodes=d,d.forEach(a=>{this.initAddedNode(a)})}attachDefaultNode(){const{host:d,slotName:a,tagName:u}=this;let v=this.defaultNode;return!v&&u&&(v=document.createElement(u),v instanceof Element&&(a!==""&&v.setAttribute("slot",a),this.defaultNode=v)),v&&(this.node=v,d.appendChild(v)),v}getSlotChildren(){const{slotName:d}=this;return Array.from(this.host.childNodes).filter(a=>a.nodeType===Node.ELEMENT_NODE&&a.hasAttribute("data-slot-ignore")?!1:a.nodeType===Node.ELEMENT_NODE&&a.slot===d||a.nodeType===Node.TEXT_NODE&&a.textContent.trim()&&d==="")}getSlotChild(){return this.getSlotChildren()[0]}initNode(d){const{slotInitializer:a}=this;a&&a(d,this.host)}initCustomNode(d){}teardownNode(d){}initAddedNode(d){d!==this.defaultNode&&(this.initCustomNode(d),this.initNode(d))}observeSlot(){const{slotName:d}=this,a=d===""?"slot:not([name])":`slot[name=${d}]`,u=this.host.shadowRoot.querySelector(a);this.__slotObserver=new SlotObserver(u,({addedNodes:v,removedNodes:x})=>{const S=this.multiple?this.nodes:[this.node],T=v.filter(P=>!isEmptyTextNode(P)&&!S.includes(P)&&!(P.nodeType===Node.ELEMENT_NODE&&P.hasAttribute("data-slot-ignore")));x.length&&(this.nodes=S.filter(P=>!x.includes(P)),x.forEach(P=>{this.teardownNode(P)})),T&&T.length>0&&(this.multiple?(this.defaultNode&&this.defaultNode.remove(),this.nodes=[...S,...T].filter(P=>P!==this.defaultNode),T.forEach(P=>{this.initAddedNode(P)})):(this.node&&this.node.remove(),this.node=T[0],this.initAddedNode(this.node)))})}}/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class TooltipController extends SlotController{constructor(d){super(d,"tooltip"),this.setTarget(d)}initCustomNode(d){d.target=this.target,this.ariaTarget!==void 0&&(d.ariaTarget=this.ariaTarget),this.context!==void 0&&(d.context=this.context),this.manual!==void 0&&(d.manual=this.manual),this.opened!==void 0&&(d.opened=this.opened),this.position!==void 0&&(d._position=this.position),this.shouldShow!==void 0&&(d.shouldShow=this.shouldShow),this.__notifyChange()}teardownNode(){this.__notifyChange()}setAriaTarget(d){this.ariaTarget=d;const a=this.node;a&&(a.ariaTarget=d)}setContext(d){this.context=d;const a=this.node;a&&(a.context=d)}setManual(d){this.manual=d;const a=this.node;a&&(a.manual=d)}setOpened(d){this.opened=d;const a=this.node;a&&(a.opened=d)}setPosition(d){this.position=d;const a=this.node;a&&(a._position=d)}setShouldShow(d){this.shouldShow=d;const a=this.node;a&&(a.shouldShow=d)}setTarget(d){this.target=d;const a=this.node;a&&(a.target=d)}__notifyChange(){this.dispatchEvent(new CustomEvent("tooltip-changed",{detail:{node:this.node}}))}}/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotChildObserveController extends SlotController{constructor(d,a,u,v={}){super(d,a,u,{...v,useUniqueId:!0})}initCustomNode(d){this.__updateNodeId(d),this.__notifyChange(d)}teardownNode(d){const a=this.getSlotChild();a&&a!==this.defaultNode?this.__notifyChange(a):(this.restoreDefaultNode(),this.updateDefaultNode(this.node))}attachDefaultNode(){const d=super.attachDefaultNode();return d&&this.__updateNodeId(d),d}restoreDefaultNode(){}updateDefaultNode(d){this.__notifyChange(d)}observeNode(d){this.__nodeObserver&&this.__nodeObserver.disconnect(),this.__nodeObserver=new MutationObserver(a=>{a.forEach(u=>{const v=u.target,x=v===this.node;u.type==="attributes"?x&&this.__updateNodeId(v):(x||v.parentElement===this.node)&&this.__notifyChange(this.node)})}),this.__nodeObserver.observe(d,{attributes:!0,attributeFilter:["id"],childList:!0,subtree:!0,characterData:!0})}__hasContent(d){return d?d.nodeType===Node.ELEMENT_NODE&&(customElements.get(d.localName)||d.children.length>0)||d.textContent&&d.textContent.trim()!=="":!1}__notifyChange(d){this.dispatchEvent(new CustomEvent("slot-content-changed",{detail:{hasContent:this.__hasContent(d),node:d}}))}__updateNodeId(d){const a=!this.nodes||d===this.nodes[0];d.nodeType===Node.ELEMENT_NODE&&(!this.multiple||a)&&!d.id&&(d.id=this.defaultId)}}/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class ContentController extends SlotChildObserveController{static generateId(d){return super.generateId(d,"content")}constructor(d){super(d,"",null,{multiple:!0})}}/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const CollapsibleMixin=g=>class extends g{static get properties(){return{opened:{type:Boolean,value:!1,reflectToAttribute:!0,notify:!0},_contentElements:{type:Array}}}static get observers(){return["_openedOrContentChanged(opened, _contentElements)"]}constructor(){super(),this._contentController=new ContentController(this),this._contentController.addEventListener("slot-content-changed",a=>{const u=a.target.nodes||[];this._contentElements=u.filter(v=>v.parentNode===this)})}ready(){super.ready(),this.addController(this._contentController),this.addEventListener("click",({target:a})=>{if(this.disabled||a.localName==="a")return;const u=this.focusElement;u&&(a===u||u.contains(a))&&(this.opened=!this.opened)})}_openedOrContentChanged(a,u){u&&u.forEach(v=>{v.setAttribute("aria-hidden",a?"false":"true")})}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SummaryController extends SlotChildObserveController{constructor(d,a){super(d,"summary",a)}setSummary(d){this.summary=d,this.getSlotChild()||this.restoreDefaultNode(),this.node===this.defaultNode&&this.updateDefaultNode(this.node)}restoreDefaultNode(){const{summary:d}=this;d&&d.trim()!==""&&this.attachDefaultNode()}updateDefaultNode(d){d&&(d.textContent=this.summary),super.updateDefaultNode(d)}}/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const AccordionPanelMixin=g=>class extends CollapsibleMixin(DelegateFocusMixin(DelegateStateMixin(g))){static get properties(){return{summary:{type:String,observer:"_summaryChanged"}}}static get observers(){return["__updateAriaAttributes(focusElement, _contentElements)"]}static get delegateProps(){return["disabled","opened","_theme"]}constructor(){super(),this._summaryController=new SummaryController(this,"vaadin-accordion-heading"),this._summaryController.addEventListener("slot-content-changed",a=>{const{node:u}=a.target;this._setFocusElement(u),this.stateTarget=u,this._tooltipController.setTarget(u)}),this._tooltipController=new TooltipController(this),this._tooltipController.setPosition("bottom-start")}__forwardTabIndex(a){super.__forwardTabIndex(a),a!==void 0&&this.focusElement&&(this.focusElement.$.button.tabIndex=a,this.focusElement.tabIndex=-1)}ready(){super.ready(),this.addController(this._summaryController),this.addController(this._tooltipController)}_delegateProperty(a,u){if(this.stateTarget){if(a==="_theme"){this._delegateAttribute("theme",u);return}super._delegateProperty(a,u)}}_setAriaDisabled(){}_summaryChanged(a){this._summaryController.setSummary(a)}__updateAriaAttributes(a,u){if(a&&u){const v=u[0];v&&(v.setAttribute("role","region"),v.setAttribute("aria-labelledby",a.id)),v&&v.id?a.setAttribute("aria-controls",v.id):a.removeAttribute("aria-controls")}}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-accordion-panel",accordionPanel,{moduleId:"vaadin-accordion-panel-styles"});class AccordionPanel extends AccordionPanelMixin(ThemableMixin(ControllerMixin(PolymerElement))){static get is(){return"vaadin-accordion-panel"}static get template(){return html$3`
      <slot name="summary"></slot>

      <div part="content">
        <slot></slot>
      </div>

      <slot name="tooltip"></slot>
    `}}defineCustomElement(AccordionPanel);const DEV_MODE_CODE_REGEXP=/\/\*[\*!]\s+vaadin-dev-mode:start([\s\S]*)vaadin-dev-mode:end\s+\*\*\//i,FlowClients=window.Vaadin&&window.Vaadin.Flow&&window.Vaadin.Flow.clients;function isMinified(){function g(){return!0}return uncommentAndRun(g)}function isDevelopmentMode(){try{return isForcedDevelopmentMode()?!0:isLocalhost()?FlowClients?!isFlowProductionMode():!isMinified():!1}catch{return!1}}function isForcedDevelopmentMode(){return localStorage.getItem("vaadin.developmentmode.force")}function isLocalhost(){return["localhost","127.0.0.1"].indexOf(window.location.hostname)>=0}function isFlowProductionMode(){return!!(FlowClients&&Object.keys(FlowClients).map(d=>FlowClients[d]).filter(d=>d.productionMode).length>0)}function uncommentAndRun(g,d){if(typeof g!="function")return;const a=DEV_MODE_CODE_REGEXP.exec(g.toString());if(a)try{g=new Function(a[1])}catch(u){console.log("vaadin-development-mode-detector: uncommentAndRun() failed",u)}return g(d)}window.Vaadin=window.Vaadin||{};const runIfDevelopmentMode=function(g,d){if(window.Vaadin.developmentMode)return uncommentAndRun(g,d)};window.Vaadin.developmentMode===void 0&&(window.Vaadin.developmentMode=isDevelopmentMode());function maybeGatherAndSendStats(){/*! vaadin-dev-mode:start
  (function () {
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
  return typeof obj;
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};

var classCallCheck = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

var createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();

var getPolymerVersion = function getPolymerVersion() {
  return window.Polymer && window.Polymer.version;
};

var StatisticsGatherer = function () {
  function StatisticsGatherer(logger) {
    classCallCheck(this, StatisticsGatherer);

    this.now = new Date().getTime();
    this.logger = logger;
  }

  createClass(StatisticsGatherer, [{
    key: 'frameworkVersionDetectors',
    value: function frameworkVersionDetectors() {
      return {
        'Flow': function Flow() {
          if (window.Vaadin && window.Vaadin.Flow && window.Vaadin.Flow.clients) {
            var flowVersions = Object.keys(window.Vaadin.Flow.clients).map(function (key) {
              return window.Vaadin.Flow.clients[key];
            }).filter(function (client) {
              return client.getVersionInfo;
            }).map(function (client) {
              return client.getVersionInfo().flow;
            });
            if (flowVersions.length > 0) {
              return flowVersions[0];
            }
          }
        },
        'Vaadin Framework': function VaadinFramework() {
          if (window.vaadin && window.vaadin.clients) {
            var frameworkVersions = Object.values(window.vaadin.clients).filter(function (client) {
              return client.getVersionInfo;
            }).map(function (client) {
              return client.getVersionInfo().vaadinVersion;
            });
            if (frameworkVersions.length > 0) {
              return frameworkVersions[0];
            }
          }
        },
        'AngularJs': function AngularJs() {
          if (window.angular && window.angular.version && window.angular.version) {
            return window.angular.version.full;
          }
        },
        'Angular': function Angular() {
          if (window.ng) {
            var tags = document.querySelectorAll("[ng-version]");
            if (tags.length > 0) {
              return tags[0].getAttribute("ng-version");
            }
            return "Unknown";
          }
        },
        'Backbone.js': function BackboneJs() {
          if (window.Backbone) {
            return window.Backbone.VERSION;
          }
        },
        'React': function React() {
          var reactSelector = '[data-reactroot], [data-reactid]';
          if (!!document.querySelector(reactSelector)) {
            // React does not publish the version by default
            return "unknown";
          }
        },
        'Ember': function Ember() {
          if (window.Em && window.Em.VERSION) {
            return window.Em.VERSION;
          } else if (window.Ember && window.Ember.VERSION) {
            return window.Ember.VERSION;
          }
        },
        'jQuery': function (_jQuery) {
          function jQuery() {
            return _jQuery.apply(this, arguments);
          }

          jQuery.toString = function () {
            return _jQuery.toString();
          };

          return jQuery;
        }(function () {
          if (typeof jQuery === 'function' && jQuery.prototype.jquery !== undefined) {
            return jQuery.prototype.jquery;
          }
        }),
        'Polymer': function Polymer() {
          var version = getPolymerVersion();
          if (version) {
            return version;
          }
        },
        'LitElement': function LitElement() {
          var version = window.litElementVersions && window.litElementVersions[0];
          if (version) {
            return version;
          }
        },
        'LitHtml': function LitHtml() {
          var version = window.litHtmlVersions && window.litHtmlVersions[0];
          if (version) {
            return version;
          }
        },
        'Vue.js': function VueJs() {
          if (window.Vue) {
            return window.Vue.version;
          }
        }
      };
    }
  }, {
    key: 'getUsedVaadinElements',
    value: function getUsedVaadinElements(elements) {
      var version = getPolymerVersion();
      var elementClasses = void 0;
      // NOTE: In case you edit the code here, YOU MUST UPDATE any statistics reporting code in Flow.
      // Check all locations calling the method getEntries() in
      // https://github.com/vaadin/flow/blob/master/flow-server/src/main/java/com/vaadin/flow/internal/UsageStatistics.java#L106
      // Currently it is only used by BootstrapHandler.
      if (version && version.indexOf('2') === 0) {
        // Polymer 2: components classes are stored in window.Vaadin
        elementClasses = Object.keys(window.Vaadin).map(function (c) {
          return window.Vaadin[c];
        }).filter(function (c) {
          return c.is;
        });
      } else {
        // Polymer 3: components classes are stored in window.Vaadin.registrations
        elementClasses = window.Vaadin.registrations || [];
      }
      elementClasses.forEach(function (klass) {
        var version = klass.version ? klass.version : "0.0.0";
        elements[klass.is] = { version: version };
      });
    }
  }, {
    key: 'getUsedVaadinThemes',
    value: function getUsedVaadinThemes(themes) {
      ['Lumo', 'Material'].forEach(function (themeName) {
        var theme;
        var version = getPolymerVersion();
        if (version && version.indexOf('2') === 0) {
          // Polymer 2: themes are stored in window.Vaadin
          theme = window.Vaadin[themeName];
        } else {
          // Polymer 3: themes are stored in custom element registry
          theme = customElements.get('vaadin-' + themeName.toLowerCase() + '-styles');
        }
        if (theme && theme.version) {
          themes[themeName] = { version: theme.version };
        }
      });
    }
  }, {
    key: 'getFrameworks',
    value: function getFrameworks(frameworks) {
      var detectors = this.frameworkVersionDetectors();
      Object.keys(detectors).forEach(function (framework) {
        var detector = detectors[framework];
        try {
          var version = detector();
          if (version) {
            frameworks[framework] = { version: version };
          }
        } catch (e) {}
      });
    }
  }, {
    key: 'gather',
    value: function gather(storage) {
      var storedStats = storage.read();
      var gatheredStats = {};
      var types = ["elements", "frameworks", "themes"];

      types.forEach(function (type) {
        gatheredStats[type] = {};
        if (!storedStats[type]) {
          storedStats[type] = {};
        }
      });

      var previousStats = JSON.stringify(storedStats);

      this.getUsedVaadinElements(gatheredStats.elements);
      this.getFrameworks(gatheredStats.frameworks);
      this.getUsedVaadinThemes(gatheredStats.themes);

      var now = this.now;
      types.forEach(function (type) {
        var keys = Object.keys(gatheredStats[type]);
        keys.forEach(function (key) {
          if (!storedStats[type][key] || _typeof(storedStats[type][key]) != _typeof({})) {
            storedStats[type][key] = { firstUsed: now };
          }
          // Discards any previously logged version number
          storedStats[type][key].version = gatheredStats[type][key].version;
          storedStats[type][key].lastUsed = now;
        });
      });

      var newStats = JSON.stringify(storedStats);
      storage.write(newStats);
      if (newStats != previousStats && Object.keys(storedStats).length > 0) {
        this.logger.debug("New stats: " + newStats);
      }
    }
  }]);
  return StatisticsGatherer;
}();

var StatisticsStorage = function () {
  function StatisticsStorage(key) {
    classCallCheck(this, StatisticsStorage);

    this.key = key;
  }

  createClass(StatisticsStorage, [{
    key: 'read',
    value: function read() {
      var localStorageStatsString = localStorage.getItem(this.key);
      try {
        return JSON.parse(localStorageStatsString ? localStorageStatsString : '{}');
      } catch (e) {
        return {};
      }
    }
  }, {
    key: 'write',
    value: function write(data) {
      localStorage.setItem(this.key, data);
    }
  }, {
    key: 'clear',
    value: function clear() {
      localStorage.removeItem(this.key);
    }
  }, {
    key: 'isEmpty',
    value: function isEmpty() {
      var storedStats = this.read();
      var empty = true;
      Object.keys(storedStats).forEach(function (key) {
        if (Object.keys(storedStats[key]).length > 0) {
          empty = false;
        }
      });

      return empty;
    }
  }]);
  return StatisticsStorage;
}();

var StatisticsSender = function () {
  function StatisticsSender(url, logger) {
    classCallCheck(this, StatisticsSender);

    this.url = url;
    this.logger = logger;
  }

  createClass(StatisticsSender, [{
    key: 'send',
    value: function send(data, errorHandler) {
      var logger = this.logger;

      if (navigator.onLine === false) {
        logger.debug("Offline, can't send");
        errorHandler();
        return;
      }
      logger.debug("Sending data to " + this.url);

      var req = new XMLHttpRequest();
      req.withCredentials = true;
      req.addEventListener("load", function () {
        // Stats sent, nothing more to do
        logger.debug("Response: " + req.responseText);
      });
      req.addEventListener("error", function () {
        logger.debug("Send failed");
        errorHandler();
      });
      req.addEventListener("abort", function () {
        logger.debug("Send aborted");
        errorHandler();
      });
      req.open("POST", this.url);
      req.setRequestHeader("Content-Type", "application/json");
      req.send(data);
    }
  }]);
  return StatisticsSender;
}();

var StatisticsLogger = function () {
  function StatisticsLogger(id) {
    classCallCheck(this, StatisticsLogger);

    this.id = id;
  }

  createClass(StatisticsLogger, [{
    key: '_isDebug',
    value: function _isDebug() {
      return localStorage.getItem("vaadin." + this.id + ".debug");
    }
  }, {
    key: 'debug',
    value: function debug(msg) {
      if (this._isDebug()) {
        console.info(this.id + ": " + msg);
      }
    }
  }]);
  return StatisticsLogger;
}();

var UsageStatistics = function () {
  function UsageStatistics() {
    classCallCheck(this, UsageStatistics);

    this.now = new Date();
    this.timeNow = this.now.getTime();
    this.gatherDelay = 10; // Delay between loading this file and gathering stats
    this.initialDelay = 24 * 60 * 60;

    this.logger = new StatisticsLogger("statistics");
    this.storage = new StatisticsStorage("vaadin.statistics.basket");
    this.gatherer = new StatisticsGatherer(this.logger);
    this.sender = new StatisticsSender("https://tools.vaadin.com/usage-stats/submit", this.logger);
  }

  createClass(UsageStatistics, [{
    key: 'maybeGatherAndSend',
    value: function maybeGatherAndSend() {
      var _this = this;

      if (localStorage.getItem(UsageStatistics.optOutKey)) {
        return;
      }
      this.gatherer.gather(this.storage);
      setTimeout(function () {
        _this.maybeSend();
      }, this.gatherDelay * 1000);
    }
  }, {
    key: 'lottery',
    value: function lottery() {
      return true;
    }
  }, {
    key: 'currentMonth',
    value: function currentMonth() {
      return this.now.getYear() * 12 + this.now.getMonth();
    }
  }, {
    key: 'maybeSend',
    value: function maybeSend() {
      var firstUse = Number(localStorage.getItem(UsageStatistics.firstUseKey));
      var monthProcessed = Number(localStorage.getItem(UsageStatistics.monthProcessedKey));

      if (!firstUse) {
        // Use a grace period to avoid interfering with tests, incognito mode etc
        firstUse = this.timeNow;
        localStorage.setItem(UsageStatistics.firstUseKey, firstUse);
      }

      if (this.timeNow < firstUse + this.initialDelay * 1000) {
        this.logger.debug("No statistics will be sent until the initial delay of " + this.initialDelay + "s has passed");
        return;
      }
      if (this.currentMonth() <= monthProcessed) {
        this.logger.debug("This month has already been processed");
        return;
      }
      localStorage.setItem(UsageStatistics.monthProcessedKey, this.currentMonth());
      // Use random sampling
      if (this.lottery()) {
        this.logger.debug("Congratulations, we have a winner!");
      } else {
        this.logger.debug("Sorry, no stats from you this time");
        return;
      }

      this.send();
    }
  }, {
    key: 'send',
    value: function send() {
      // Ensure we have the latest data
      this.gatherer.gather(this.storage);

      // Read, send and clean up
      var data = this.storage.read();
      data["firstUse"] = Number(localStorage.getItem(UsageStatistics.firstUseKey));
      data["usageStatisticsVersion"] = UsageStatistics.version;
      var info = 'This request contains usage statistics gathered from the application running in development mode. \n\nStatistics gathering is automatically disabled and excluded from production builds.\n\nFor details and to opt-out, see https://github.com/vaadin/vaadin-usage-statistics.\n\n\n\n';
      var self = this;
      this.sender.send(info + JSON.stringify(data), function () {
        // Revert the 'month processed' flag
        localStorage.setItem(UsageStatistics.monthProcessedKey, self.currentMonth() - 1);
      });
    }
  }], [{
    key: 'version',
    get: function get$1() {
      return '2.1.2';
    }
  }, {
    key: 'firstUseKey',
    get: function get$1() {
      return 'vaadin.statistics.firstuse';
    }
  }, {
    key: 'monthProcessedKey',
    get: function get$1() {
      return 'vaadin.statistics.monthProcessed';
    }
  }, {
    key: 'optOutKey',
    get: function get$1() {
      return 'vaadin.statistics.optout';
    }
  }]);
  return UsageStatistics;
}();

try {
  window.Vaadin = window.Vaadin || {};
  window.Vaadin.usageStatsChecker = window.Vaadin.usageStatsChecker || new UsageStatistics();
  window.Vaadin.usageStatsChecker.maybeGatherAndSend();
} catch (e) {
  // Intentionally ignored as this is not a problem in the app being developed
}

}());

  vaadin-dev-mode:end **/}const usageStatistics=function(){if(typeof runIfDevelopmentMode=="function")return runIfDevelopmentMode(maybeGatherAndSendStats)};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */window.Vaadin||(window.Vaadin={});window.Vaadin.registrations||(window.Vaadin.registrations=[]);window.Vaadin.developmentModeCallback||(window.Vaadin.developmentModeCallback={});window.Vaadin.developmentModeCallback["vaadin-usage-statistics"]=function(){usageStatistics()};let statsJob;const registered=new Set,ElementMixin=g=>class extends DirMixin(g){static finalize(){super.finalize();const{is:a}=this;a&&!registered.has(a)&&(window.Vaadin.registrations.push(this),registered.add(a),window.Vaadin.developmentModeCallback&&(statsJob=Debouncer$1.debounce(statsJob,idlePeriod$1,()=>{window.Vaadin.developmentModeCallback["vaadin-usage-statistics"]()}),enqueueDebouncer$1(statsJob)))}constructor(){super(),document.doctype===null&&console.warn('Vaadin components require the "standards mode" declaration. Please add <!DOCTYPE html> to the HTML document.')}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const KeyboardDirectionMixin=g=>class extends KeyboardMixin(g){get focused(){return(this._getItems()||[]).find(isElementFocused)}get _vertical(){return!0}get _tabNavigation(){return!1}focus(){const a=this._getItems();if(Array.isArray(a)){const u=this._getAvailableIndex(a,0,null,v=>!isElementHidden(v));u>=0&&this._focus(u)}}_getItems(){return Array.from(this.children)}_onKeyDown(a){if(super._onKeyDown(a),a.metaKey||a.ctrlKey)return;const{key:u,shiftKey:v}=a,x=this._getItems()||[],S=x.indexOf(this.focused);let T,P;const L=!this._vertical&&this.getAttribute("dir")==="rtl"?-1:1;this.__isPrevKeyPressed(u,v)?(P=-L,T=S-L):this.__isNextKeyPressed(u,v)?(P=L,T=S+L):u==="Home"?(P=1,T=0):u==="End"&&(P=-1,T=x.length-1),T=this._getAvailableIndex(x,T,P,N=>!isElementHidden(N)),!(this._tabNavigation&&u==="Tab"&&(T>S&&a.shiftKey||T<S&&!a.shiftKey||T===S))&&T>=0&&(a.preventDefault(),this._focus(T,!0))}__isPrevKeyPressed(a,u){return this._vertical?a==="ArrowUp":a==="ArrowLeft"||this._tabNavigation&&a==="Tab"&&u}__isNextKeyPressed(a,u){return this._vertical?a==="ArrowDown":a==="ArrowRight"||this._tabNavigation&&a==="Tab"&&!u}_focus(a,u=!1){const v=this._getItems();this._focusItem(v[a],u)}_focusItem(a){a&&(a.focus(),a.setAttribute("focus-ring",""))}_getAvailableIndex(a,u,v,x){const S=a.length;let T=u;for(let P=0;typeof T=="number"&&P<S;P+=1,T+=v||1){T<0?T=S-1:T>=S&&(T=0);const z=a[T];if(this._isItemFocusable(z)&&this.__isMatchingItem(z,x))return T}return-1}__isMatchingItem(a,u){return typeof u=="function"?u(a):!0}_isItemFocusable(a){return!a.hasAttribute("disabled")}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const AccordionMixin=g=>class extends KeyboardDirectionMixin(g){static get properties(){return{opened:{type:Number,value:0,notify:!0,reflectToAttribute:!0},items:{type:Array,readOnly:!0,notify:!0}}}static get observers(){return["_updateItems(items, opened)"]}constructor(){super(),this._boundUpdateOpened=this._updateOpened.bind(this)}get focused(){return(this._getItems()||[]).find(a=>isElementFocused(a.focusElement))}focus(){this._observer&&this._observer.flush(),super.focus()}ready(){super.ready();const a=this.shadowRoot.querySelector("slot");this._observer=new SlotObserver(a,u=>{this._setItems(this._filterItems(Array.from(this.children))),this._filterItems(u.addedNodes).forEach(v=>{v.addEventListener("opened-changed",this._boundUpdateOpened)})})}_getItems(){return this.items}_filterItems(a){return a.filter(u=>u instanceof customElements.get("vaadin-accordion-panel"))}_updateItems(a,u){if(a){this.__itemsSync=!0;const v=a[u];a.forEach(x=>{x.opened=x===v}),this.__itemsSync=!1}}_onKeyDown(a){this.items.some(u=>u.focusElement===a.target)&&super._onKeyDown(a)}_updateOpened(a){if(this.__itemsSync)return;const u=this._filterItems(a.composedPath())[0],v=this.items.indexOf(u);if(a.detail.value){if(u.disabled||v===-1)return;this.opened=v}else this.items.some(x=>x.opened)||(this.opened=null)}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Accordion extends AccordionMixin(ThemableMixin(ElementMixin(PolymerElement))){static get template(){return html$3`
      <style>
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <slot></slot>
    `}static get is(){return"vaadin-accordion"}}defineCustomElement(Accordion);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const INTERACTION_EVENTS=["mousedown","mouseup","click","dblclick","keypress","keydown","keyup"],ButtonMixin=g=>class extends ActiveMixin(TabindexMixin(FocusMixin(g))){constructor(){super(),this.__onInteractionEvent=this.__onInteractionEvent.bind(this),INTERACTION_EVENTS.forEach(a=>{this.addEventListener(a,this.__onInteractionEvent,!0)}),this.tabindex=0}get _activeKeys(){return["Enter"," "]}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","button"),this.__shouldAllowFocusWhenDisabled()&&this.style.setProperty("--_vaadin-button-disabled-pointer-events","auto")}_onKeyDown(a){super._onKeyDown(a),!(a.altKey||a.shiftKey||a.ctrlKey||a.metaKey)&&this._activeKeys.includes(a.key)&&(a.preventDefault(),this.click())}__onInteractionEvent(a){this.__shouldSuppressInteractionEvent(a)&&a.stopImmediatePropagation()}__shouldSuppressInteractionEvent(a){return this.disabled}};/**
 * @license
 * Copyright (c) 2025 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const detailsSummary=()=>i`
  :host {
    display: block;
    outline: none;
    white-space: nowrap;
    -webkit-user-select: none;
    user-select: none;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([disabled]) {
    pointer-events: none;
  }
`;/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-details-summary",detailsSummary(),{moduleId:"vaadin-details-summary-styles"});class DetailsSummary extends ButtonMixin(DirMixin(ThemableMixin(PolymerElement))){static get is(){return"vaadin-details-summary"}static get template(){return html$3`
      <span part="toggle" aria-hidden="true"></span>
      <div part="content"><slot></slot></div>
    `}static get properties(){return{opened:{type:Boolean,reflectToAttribute:!0}}}}defineCustomElement(DetailsSummary);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DetailsBaseMixin=g=>class extends CollapsibleMixin(DelegateFocusMixin(DelegateStateMixin(g))){static get properties(){return{summary:{type:String,observer:"_summaryChanged"}}}static get observers(){return["__updateAriaControls(focusElement, _contentElements)","__updateAriaExpanded(focusElement, opened)"]}static get delegateProps(){return["disabled","opened","_theme"]}constructor(){super(),this._summaryController=new SummaryController(this,"vaadin-details-summary"),this._summaryController.addEventListener("slot-content-changed",a=>{const{node:u}=a.target;this._setFocusElement(u),this.stateTarget=u,this._tooltipController.setTarget(u)}),this._tooltipController=new TooltipController(this),this._tooltipController.setPosition("bottom-start")}ready(){super.ready(),this.addController(this._summaryController),this.addController(this._tooltipController)}_delegateProperty(a,u){if(this.stateTarget){if(a==="_theme"){this._delegateAttribute("theme",u);return}super._delegateProperty(a,u)}}_setAriaDisabled(){}_summaryChanged(a){this._summaryController.setSummary(a)}__updateAriaControls(a,u){if(a&&u){const v=u[0];v&&v.id?a.setAttribute("aria-controls",v.id):a.removeAttribute("aria-controls")}}__updateAriaExpanded(a,u){a&&a.setAttribute("aria-expanded",u?"true":"false")}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Details extends DetailsBaseMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get template(){return html$3`
      <style>
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none !important;
        }

        [part='content'] {
          display: none;
        }

        :host([opened]) [part='content'] {
          display: block;
        }
      </style>

      <slot name="summary"></slot>

      <div part="content">
        <slot></slot>
      </div>

      <slot name="tooltip"></slot>
    `}static get is(){return"vaadin-details"}}defineCustomElement(Details);registerStyles$1("vaadin-app-layout",i`
    [part='navbar'],
    [part='drawer'] {
      background-color: var(--lumo-base-color);
      background-clip: padding-box;
    }

    [part='navbar'] {
      min-height: var(--lumo-size-xl);
      border-bottom: 1px solid var(--lumo-contrast-10pct);
    }

    [part='navbar'][bottom] {
      border-bottom: none;
      border-top: 1px solid var(--lumo-contrast-10pct);
    }

    [part='drawer'] {
      border-inline-end: 1px solid var(--lumo-contrast-10pct);
    }

    :host([overlay]) [part='drawer'] {
      border-inline-end: none;
      box-shadow: var(--lumo-box-shadow-s);
    }

    :host([primary-section='navbar']) [part='navbar'] {
      border: none;
      background-image: linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    }

    :host([primary-section='drawer']:not([overlay])) [part='drawer'] {
      background-image: linear-gradient(var(--lumo-shade-5pct), var(--lumo-shade-5pct));
    }

    [part='backdrop'] {
      background-color: var(--lumo-shade-20pct);
      opacity: 1;
    }

    [part] ::slotted(h2),
    [part] ::slotted(h3),
    [part] ::slotted(h4) {
      margin-top: var(--lumo-space-xs) !important;
      margin-bottom: var(--lumo-space-xs) !important;
    }
  `,{moduleId:"lumo-app-layout"});/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function _detectIosNavbar(){if(isIOS){const g=window.innerHeight,a=window.innerWidth>g,u=document.documentElement.clientHeight;a&&u>g?document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom",`${u-g}px`):document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom","")}}_detectIosNavbar();window.addEventListener("resize",_detectIosNavbar);const template$8=document.createElement("template");template$8.innerHTML=`
  <style>
    /* Use units so that the values can be used in calc() */
    html {
      --safe-area-inset-top: env(safe-area-inset-top, 0px);
      --safe-area-inset-right: env(safe-area-inset-right, 0px);
      --safe-area-inset-bottom: env(safe-area-inset-bottom, 0px);
      --safe-area-inset-left: env(safe-area-inset-left, 0px);
    }
  </style>
`;document.head.appendChild(template$8.content);/**
 * @license
 * Copyright (c) 2025 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function deepMerge$1(g,...d){const a=x=>Array.isArray(x),u=x=>x&&typeof x=="object"&&!a(x),v=(x,S)=>{u(S)&&u(x)&&Object.keys(S).forEach(T=>{const P=S[T];u(P)?(x[T]||(x[T]={}),v(x[T],P)):a(P)?x[T]=[...P]:P!=null&&(x[T]=P)})};return d.forEach(x=>{v(g,x)}),g}const I18nMixin=(g,d)=>class extends d{static get properties(){return{i18n:{type:Object},__effectiveI18n:{type:Object,sync:!0}}}constructor(){super(),this.i18n=deepMerge$1({},g)}get i18n(){return this.__customI18n}set i18n(u){u!==this.__customI18n&&(this.__customI18n=u,this.__effectiveI18n=deepMerge$1({},g,this.__customI18n))}};/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DEFAULT_I18N$a={drawer:"Drawer"},AppLayoutMixin=g=>class extends I18nMixin(DEFAULT_I18N$a,g){static get properties(){return{primarySection:{type:String,value:"navbar",notify:!0,reflectToAttribute:!0,observer:"__primarySectionChanged",sync:!0},drawerOpened:{type:Boolean,notify:!0,value:!0,reflectToAttribute:!0,observer:"__drawerOpenedChanged",sync:!0},overlay:{type:Boolean,notify:!0,readOnly:!0,value:!1,reflectToAttribute:!0,observer:"__overlayChanged",sync:!0},closeDrawerOn:{type:String,value:"vaadin-router-location-changed",observer:"_closeDrawerOnChanged"}}}static get observers(){return["__i18nChanged(__effectiveI18n)"]}static dispatchCloseOverlayDrawerEvent(){window.dispatchEvent(new CustomEvent("close-overlay-drawer"))}get i18n(){return super.i18n}set i18n(a){super.i18n=a}constructor(){super(),this.__boundResizeListener=this._resize.bind(this),this.__drawerToggleClickListener=this._drawerToggleClick.bind(this),this.__onDrawerKeyDown=this.__onDrawerKeyDown.bind(this),this.__closeOverlayDrawerListener=this.__closeOverlayDrawer.bind(this),this.__trapFocusInDrawer=this.__trapFocusInDrawer.bind(this),this.__releaseFocusFromDrawer=this.__releaseFocusFromDrawer.bind(this),this.__ariaModalController=new AriaModalController(this,()=>[...this.querySelectorAll('vaadin-drawer-toggle, [slot="drawer"]')]),this.__focusTrapController=new FocusTrapController(this)}connectedCallback(){super.connectedCallback(),this._blockAnimationUntilAfterNextRender(),window.addEventListener("resize",this.__boundResizeListener),this.addEventListener("drawer-toggle-click",this.__drawerToggleClickListener),requestAnimationFrame(()=>{this._updateOffsetSize()}),this._updateTouchOptimizedMode(),this._updateDrawerSize(),this._updateOverlayMode(),this._navbarSizeObserver=new ResizeObserver(()=>{requestAnimationFrame(()=>{this.__isDrawerAnimating?this.__updateOffsetSizePending=!0:this._updateOffsetSize()})}),this._navbarSizeObserver.observe(this.$.navbarTop),this._navbarSizeObserver.observe(this.$.navbarBottom),this._navbarSizeObserver.observe(this.$.drawer),window.addEventListener("close-overlay-drawer",this.__closeOverlayDrawerListener),window.addEventListener("keydown",this.__onDrawerKeyDown)}ready(){super.ready(),this.addController(this.__focusTrapController),this.__setAriaExpanded(),this.$.drawer.addEventListener("transitionstart",()=>{this.__isDrawerAnimating=!0}),this.$.drawer.addEventListener("transitionend",()=>{this.__updateOffsetSizePending&&(this.__updateOffsetSizePending=!1,this._updateOffsetSize()),requestAnimationFrame(()=>{this.__isDrawerAnimating=!1})})}disconnectedCallback(){super.disconnectedCallback(),window.removeEventListener("resize",this.__boundResizeListener),this.removeEventListener("drawer-toggle-click",this.__drawerToggleClickListener),window.removeEventListener("close-overlay-drawer",this.__drawerToggleClickListener),window.removeEventListener("keydown",this.__onDrawerKeyDown)}__primarySectionChanged(a){["navbar","drawer"].includes(a)||(this.primarySection="navbar")}__drawerOpenedChanged(a,u){this.overlay&&(a?this.__trapFocusInDrawer():u&&this.__releaseFocusFromDrawer()),this.__setAriaExpanded()}__overlayChanged(a,u){u&&this.__restoreFocus()}__i18nChanged(){this.__updateDrawerAriaAttributes()}_drawerToggleClick(a){a.stopPropagation(),this.drawerOpened=!this.drawerOpened}__closeOverlayDrawer(){this.overlay&&(this.drawerOpened=!1)}__setAriaExpanded(){const a=this.querySelector("vaadin-drawer-toggle");a&&a.setAttribute("aria-expanded",this.drawerOpened)}_updateDrawerSize(){const a=this.querySelectorAll("[slot=drawer]").length,u=this.$.drawer;a===0?(u.setAttribute("hidden",""),this.style.setProperty("--_vaadin-app-layout-drawer-width",0)):(u.removeAttribute("hidden"),this.style.removeProperty("--_vaadin-app-layout-drawer-width")),this._updateOffsetSize()}_resize(){this._blockAnimationUntilAfterNextRender(),this._updateTouchOptimizedMode(),this._updateOverlayMode()}_updateOffsetSize(){const u=this.$.navbarTop.getBoundingClientRect(),x=this.$.navbarBottom.getBoundingClientRect(),T=this.$.drawer.getBoundingClientRect();this.style.setProperty("--_vaadin-app-layout-navbar-offset-size",`${u.height}px`),this.style.setProperty("--_vaadin-app-layout-navbar-offset-size-bottom",`${x.height}px`),this.style.setProperty("--_vaadin-app-layout-drawer-offset-size",`${T.width}px`)}_updateOverlayMode(){const a=this._getCustomPropertyValue("--vaadin-app-layout-drawer-overlay")==="true";!this.overlay&&a&&(this._drawerStateSaved=this.drawerOpened,this.drawerOpened=!1),this._setOverlay(a),!this.overlay&&this._drawerStateSaved&&(this.drawerOpened=this._drawerStateSaved,this._drawerStateSaved=null),this.__updateDrawerAriaAttributes()}__updateDrawerAriaAttributes(){const a=this.$.drawer;this.overlay?(a.setAttribute("role","dialog"),a.setAttribute("aria-modal","true"),a.setAttribute("aria-label",this.__effectiveI18n.drawer)):(a.removeAttribute("role"),a.removeAttribute("aria-modal"),a.removeAttribute("aria-label"))}__drawerTransitionComplete(){return new Promise(a=>{if(this._getCustomPropertyValue("--vaadin-app-layout-transition")==="none"){a();return}this.$.drawer.addEventListener("transitionend",a,{once:!0})})}async __trapFocusInDrawer(){await this.__drawerTransitionComplete(),this.drawerOpened&&(this.$.drawer.setAttribute("tabindex","0"),this.__ariaModalController.showModal(),this.__focusTrapController.trapFocus(this.$.drawer))}async __releaseFocusFromDrawer(){if(await this.__drawerTransitionComplete(),this.drawerOpened)return;this.__restoreFocus();const a=this.querySelector("vaadin-drawer-toggle");a&&(a.focus(),a.setAttribute("focus-ring","focus"))}__restoreFocus(){this.__ariaModalController.close(),this.__focusTrapController.releaseFocus(),this.$.drawer.removeAttribute("tabindex")}__onDrawerKeyDown(a){a.key==="Escape"&&this.overlay&&(this.drawerOpened=!1)}_closeDrawerOnChanged(a,u){u&&window.removeEventListener(u,this.__closeOverlayDrawerListener),a&&window.addEventListener(a,this.__closeOverlayDrawerListener)}_onBackdropClick(){this._close()}_onBackdropTouchend(a){a.preventDefault(),this._close()}_close(){this.drawerOpened=!1}_getCustomPropertyValue(a){return(getComputedStyle(this).getPropertyValue(a)||"").trim().toLowerCase()}_updateTouchOptimizedMode(){const a=this._getCustomPropertyValue("--vaadin-app-layout-touch-optimized")==="true",u=this.querySelectorAll('[slot*="navbar"]');u.length>0&&Array.from(u).forEach(v=>{v.getAttribute("slot").indexOf("touch-optimized")>-1&&(v.__touchOptimized=!0),a&&v.__touchOptimized?v.setAttribute("slot","navbar-bottom"):v.setAttribute("slot","navbar")}),this.$.navbarTop.querySelector("[name=navbar]").assignedNodes().length===0?this.$.navbarTop.setAttribute("hidden",""):this.$.navbarTop.removeAttribute("hidden"),this.$.navbarBottom.querySelector("[name=navbar-bottom]").assignedNodes().length===0?this.$.navbarBottom.setAttribute("hidden",""):this.$.navbarBottom.removeAttribute("hidden"),this._updateOffsetSize()}_blockAnimationUntilAfterNextRender(){this.setAttribute("no-anim",""),this.__debounceAnimation=Debouncer$1.debounce(this.__debounceAnimation,animationFrame,()=>{setTimeout(()=>{this.removeAttribute("no-anim")})})}};/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const appLayoutStyles=i`
  :host {
    display: block;
    box-sizing: border-box;
    height: 100%;
    --vaadin-app-layout-transition: 200ms;
    transition: padding var(--vaadin-app-layout-transition);
    --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 16em);
    --vaadin-app-layout-touch-optimized: false;
    --vaadin-app-layout-navbar-offset-top: var(--_vaadin-app-layout-navbar-offset-size);
    --vaadin-app-layout-navbar-offset-bottom: var(--_vaadin-app-layout-navbar-offset-size-bottom);
    padding-block: var(--vaadin-app-layout-navbar-offset-top) var(--vaadin-app-layout-navbar-offset-bottom);
    padding-inline-start: var(--vaadin-app-layout-navbar-offset-left);
  }

  :host([hidden]),
  [hidden] {
    display: none !important;
  }

  :host([no-anim]) {
    --vaadin-app-layout-transition: none !important;
  }

  :host([drawer-opened]) {
    --vaadin-app-layout-drawer-offset-left: var(--_vaadin-app-layout-drawer-offset-size);
  }

  :host([overlay]) {
    --vaadin-app-layout-drawer-offset-left: 0;
    --vaadin-app-layout-navbar-offset-left: 0;
  }

  :host(:not([no-scroll])) [content] {
    overflow: auto;
  }

  [content] {
    height: 100%;
  }

  @media (pointer: coarse) and (max-width: 800px) and (min-height: 500px) {
    :host {
      --vaadin-app-layout-touch-optimized: true;
    }
  }

  [part='navbar'] {
    position: fixed;
    display: flex;
    align-items: center;
    top: 0;
    inset-inline: 0;
    transition: inset-inline-start var(--vaadin-app-layout-transition);
    padding-top: var(--safe-area-inset-top);
    padding-left: var(--safe-area-inset-left);
    padding-right: var(--safe-area-inset-right);
    z-index: 1;
  }

  :host([primary-section='drawer'][drawer-opened]:not([overlay])) [part='navbar'] {
    inset-inline-start: var(--vaadin-app-layout-drawer-offset-left, 0);
  }

  :host([primary-section='drawer']) [part='drawer'] {
    top: 0;
  }

  [part='navbar'][bottom] {
    top: auto;
    bottom: 0;
    padding-bottom: var(--safe-area-inset-bottom);
  }

  [part='drawer'] {
    overflow: auto;
    position: fixed;
    top: var(--vaadin-app-layout-navbar-offset-top, 0);
    bottom: var(--vaadin-app-layout-navbar-offset-bottom, var(--vaadin-viewport-offset-bottom, 0));
    inset-inline: var(--vaadin-app-layout-navbar-offset-left, 0) auto;
    transition:
      transform var(--vaadin-app-layout-transition),
      visibility var(--vaadin-app-layout-transition);
    transform: translateX(-100%);
    max-width: 90%;
    width: var(--_vaadin-app-layout-drawer-width);
    box-sizing: border-box;
    padding: var(--safe-area-inset-top) 0 var(--safe-area-inset-bottom) var(--safe-area-inset-left);
    outline: none;
    /* The drawer should be inaccessible by the tabbing navigation when it is closed. */
    visibility: hidden;
    display: flex;
    flex-direction: column;
  }

  :host([drawer-opened]) [part='drawer'] {
    /* The drawer should be accessible by the tabbing navigation when it is opened. */
    visibility: visible;
    transform: translateX(0%);
    touch-action: manipulation;
  }

  [part='backdrop'] {
    background-color: #000;
    opacity: 0.3;
  }

  :host(:not([drawer-opened])) [part='backdrop'] {
    opacity: 0;
  }

  :host([overlay]) [part='backdrop'] {
    position: fixed;
    inset: 0;
    pointer-events: none;
    transition: opacity var(--vaadin-app-layout-transition);
    -webkit-tap-highlight-color: transparent;
  }

  :host([overlay]) [part='drawer'] {
    top: 0;
    bottom: 0;
  }

  :host([overlay]) [part='drawer'],
  :host([overlay]) [part='backdrop'] {
    z-index: 2;
  }

  :host([drawer-opened][overlay]) [part='backdrop'] {
    pointer-events: auto;
    touch-action: manipulation;
  }

  :host([dir='rtl']) [part='drawer'] {
    transform: translateX(100%);
  }

  :host([dir='rtl'][drawer-opened]) [part='drawer'] {
    transform: translateX(0%);
  }

  :host([drawer-opened]:not([overlay])) {
    padding-inline-start: var(--vaadin-app-layout-drawer-offset-left);
  }

  @media (max-width: 800px), (max-height: 600px) {
    :host {
      --vaadin-app-layout-drawer-overlay: true;
      --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 20em);
    }
  }

  /* If a vaadin-scroller is used in the drawer, allow it to take all remaining space and contain scrolling */
  [part='drawer'] ::slotted(vaadin-scroller) {
    flex: 1;
    overscroll-behavior: contain;
  }
`;/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-app-layout",appLayoutStyles,{moduleId:"vaadin-app-layout-styles"});class AppLayout extends AppLayoutMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get template(){return html$3`
      <div part="navbar" id="navbarTop">
        <slot name="navbar" on-slotchange="_updateTouchOptimizedMode"></slot>
      </div>
      <div part="backdrop" on-click="_onBackdropClick" on-touchend="_onBackdropTouchend"></div>
      <div part="drawer" id="drawer">
        <slot name="drawer" id="drawerSlot" on-slotchange="_updateDrawerSize"></slot>
      </div>
      <div content>
        <slot></slot>
      </div>
      <div part="navbar" id="navbarBottom" bottom hidden>
        <slot name="navbar-bottom"></slot>
      </div>
      <div hidden>
        <slot id="touchSlot" name="navbar touch-optimized" on-slotchange="_updateTouchOptimizedMode"></slot>
      </div>
    `}static get is(){return"vaadin-app-layout"}}defineCustomElement(AppLayout);const button$1=i`
  :host {
    /* Sizing */
    --lumo-button-size: var(--lumo-size-m);
    min-width: var(--vaadin-button-min-width, calc(var(--_button-size) * 2));
    height: var(--_button-size);
    padding: var(--vaadin-button-padding, 0 calc(var(--_button-size) / 3 + var(--lumo-border-radius-m) / 2));
    margin: var(--vaadin-button-margin, var(--lumo-space-xs) 0);
    box-sizing: border-box;
    /* Style */
    font-family: var(--lumo-font-family);
    font-size: var(--vaadin-button-font-size, var(--lumo-font-size-m));
    font-weight: var(--vaadin-button-font-weight, 500);
    color: var(--_lumo-button-text-color);
    background: var(--_lumo-button-background);
    border: var(--vaadin-button-border, none);
    border-radius: var(--vaadin-button-border-radius, var(--lumo-border-radius-m));
    cursor: var(--lumo-clickable-cursor);
    -webkit-tap-highlight-color: transparent;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    flex-shrink: 0;
    --_button-size: var(--vaadin-button-height, var(--lumo-button-size));
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    /* Used by notification */
    --_lumo-button-background: var(--vaadin-button-background, var(--lumo-contrast-5pct));
    --_lumo-button-text-color: var(--vaadin-button-text-color, var(--lumo-primary-text-color));
    --_lumo-button-primary-background: var(--vaadin-button-primary-background, var(--lumo-primary-color));
    --_lumo-button-primary-text-color: var(--vaadin-button-primary-text-color, var(--lumo-primary-contrast-color));
  }

  /* Set only for the internal parts so we don't affect the host vertical alignment */
  [part='label'],
  [part='prefix'],
  [part='suffix'] {
    line-height: var(--lumo-line-height-xs);
  }

  [part='label'] {
    padding: calc(var(--lumo-button-size) / 6) 0;
  }

  :host([theme~='small']) {
    font-size: var(--lumo-font-size-s);
    --lumo-button-size: var(--lumo-size-s);
  }

  :host([theme~='large']) {
    font-size: var(--lumo-font-size-l);
    --lumo-button-size: var(--lumo-size-l);
  }

  /* For interaction states */
  :host::before,
  :host::after {
    content: '';
    /* We rely on the host always being relative */
    position: absolute;
    z-index: 1;
    inset: 0;
    background-color: currentColor;
    border-radius: inherit;
    opacity: 0;
    pointer-events: none;
  }

  /* Hover */

  @media (any-hover: hover) {
    :host(:not([disabled]):hover)::before {
      opacity: 0.02;
    }
  }

  /* Active */

  :host::after {
    transition:
      opacity 1.4s,
      transform 0.1s;
    filter: blur(8px);
  }

  :host([active])::before {
    opacity: 0.05;
    transition-duration: 0s;
  }

  :host([active])::after {
    opacity: 0.1;
    transition-duration: 0s, 0s;
    transform: scale(0);
  }

  /* Keyboard focus */

  :host([focus-ring]) {
    box-shadow:
      0 0 0 calc(1px * var(--_focus-ring-gap-on, 0)) var(--_focus-ring-gap-color, var(--lumo-base-color)),
      0 0 0 calc(var(--_focus-ring-width) + 1px * var(--_focus-ring-gap-on, 0)) var(--_focus-ring-color);
  }

  :host([theme~='primary'][focus-ring]) {
    --_focus-ring-gap-on: 1;
  }

  /* Types (primary, tertiary, tertiary-inline */

  :host([theme~='tertiary']),
  :host([theme~='tertiary-inline']) {
    --_background: transparent !important;
    background: var(--vaadin-button-tertiary-background, var(--_background));
    min-width: 0;
  }

  :host([theme~='tertiary']) {
    border: var(--vaadin-button-tertiary-border, none);
    color: var(--vaadin-button-tertiary-text-color, var(--lumo-primary-text-color));
    font-weight: var(--vaadin-button-tertiary-font-weight, 500);
    padding: var(--vaadin-button-tertiary-padding, 0 calc(var(--_button-size) / 6));
  }

  :host([theme~='tertiary-inline'])::before {
    display: none;
  }

  :host([theme~='tertiary-inline']) {
    margin: 0;
    height: auto;
    padding: 0;
    line-height: inherit;
    font-size: inherit;
  }

  :host([theme~='tertiary-inline']) [part='label'] {
    padding: 0;
    overflow: visible;
    line-height: inherit;
  }

  :host([theme~='primary']) {
    background: var(--_lumo-button-primary-background);
    border: var(--vaadin-button-primary-border, none);
    color: var(--_lumo-button-primary-text-color);
    font-weight: var(--vaadin-button-primary-font-weight, 600);
    min-width: calc(var(--lumo-button-size) * 2.5);
  }

  :host([theme~='primary'])::before {
    background-color: black;
  }

  @media (any-hover: hover) {
    :host([theme~='primary']:not([disabled]):hover)::before {
      opacity: 0.05;
    }
  }

  :host([theme~='primary'][active])::before {
    opacity: 0.1;
  }

  :host([theme~='primary'][active])::after {
    opacity: 0.2;
  }

  /* Colors (success, warning, error, contrast) */

  :host([theme~='success']) {
    color: var(--lumo-success-text-color);
  }

  :host([theme~='success'][theme~='primary']) {
    background-color: var(--lumo-success-color);
    color: var(--lumo-success-contrast-color);
  }

  :host([theme~='warning']) {
    color: var(--lumo-warning-text-color);
  }

  :host([theme~='warning'][theme~='primary']) {
    background-color: var(--lumo-warning-color);
    color: var(--lumo-warning-contrast-color);
  }

  :host([theme~='error']) {
    color: var(--lumo-error-text-color);
  }

  :host([theme~='error'][theme~='primary']) {
    background-color: var(--lumo-error-color);
    color: var(--lumo-error-contrast-color);
  }

  :host([theme~='contrast']) {
    color: var(--lumo-contrast);
  }

  :host([theme~='contrast'][theme~='primary']) {
    background-color: var(--lumo-contrast);
    color: var(--lumo-base-color);
  }

  /* Disabled state. Keep selectors after other color variants. */

  :host([disabled]) {
    color: var(--lumo-disabled-text-color);
  }

  :host([theme~='primary'][disabled]) {
    background-color: var(--lumo-contrast-30pct);
    color: var(--lumo-base-color);
  }

  :host([theme~='primary'][disabled]) [part] {
    opacity: 0.7;
  }

  /* Icons */

  [part] ::slotted(vaadin-icon) {
    display: inline-block;
    width: var(--lumo-icon-size-m);
    height: var(--lumo-icon-size-m);
  }

  /* Vaadin icons are based on a 16x16 grid (unlike Lumo and Material icons with 24x24), so they look too big by default */
  [part] ::slotted(vaadin-icon[icon^='vaadin:']) {
    padding: 0.25em;
    box-sizing: border-box !important;
  }

  [part='prefix'] {
    margin-left: -0.25em;
    margin-right: 0.25em;
  }

  [part='suffix'] {
    margin-left: 0.25em;
    margin-right: -0.25em;
  }

  /* Icon-only */

  :host([theme~='icon']:not([theme~='tertiary-inline'])) {
    min-width: var(--lumo-button-size);
    padding-left: calc(var(--lumo-button-size) / 4);
    padding-right: calc(var(--lumo-button-size) / 4);
  }

  :host([theme~='icon']) [part='prefix'],
  :host([theme~='icon']) [part='suffix'] {
    margin-left: 0;
    margin-right: 0;
  }

  /* RTL specific styles */

  :host([dir='rtl']) [part='prefix'] {
    margin-left: 0.25em;
    margin-right: -0.25em;
  }

  :host([dir='rtl']) [part='suffix'] {
    margin-left: -0.25em;
    margin-right: 0.25em;
  }

  :host([dir='rtl'][theme~='icon']) [part='prefix'],
  :host([dir='rtl'][theme~='icon']) [part='suffix'] {
    margin-left: 0;
    margin-right: 0;
  }
`;registerStyles$1("vaadin-button",button$1,{moduleId:"lumo-button"});/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const buttonStyles=i`
  :host {
    display: inline-block;
    position: relative;
    outline: none;
    white-space: nowrap;
    -webkit-user-select: none;
    user-select: none;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([disabled]) {
    pointer-events: var(--_vaadin-button-disabled-pointer-events, none);
    cursor: not-allowed;
  }

  /* Aligns the button with form fields when placed on the same line.
  Note, to make it work, the form fields should have the same "::before" pseudo-element. */
  .vaadin-button-container::before {
    content: '\\2003';
    display: inline-block;
    width: 0;
    max-height: 100%;
  }

  .vaadin-button-container {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    width: 100%;
    height: 100%;
    min-height: inherit;
    text-shadow: inherit;
  }

  [part='prefix'],
  [part='suffix'] {
    flex: none;
  }

  [part='label'] {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  }

  @media (forced-colors: active) {
    :host {
      outline: 1px solid;
      outline-offset: -1px;
    }

    :host([focused]) {
      outline-width: 2px;
    }

    :host([disabled]) {
      outline-color: GrayText;
    }
  }
`;/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-button",buttonStyles,{moduleId:"vaadin-button-styles"});class Button extends ButtonMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get properties(){return{disabled:{type:Boolean,value:!1}}}static get is(){return"vaadin-button"}static get template(){return html$3`
      <div class="vaadin-button-container">
        <span part="prefix" aria-hidden="true">
          <slot name="prefix"></slot>
        </span>
        <span part="label">
          <slot></slot>
        </span>
        <span part="suffix" aria-hidden="true">
          <slot name="suffix"></slot>
        </span>

        <slot name="tooltip"></slot>
      </div>
    `}ready(){super.ready(),this._tooltipController=new TooltipController(this),this.addController(this._tooltipController)}__shouldAllowFocusWhenDisabled(){return window.Vaadin.featureFlags.accessibleDisabledButtons}}defineCustomElement(Button);const drawerToggle$1=i`
  :host {
    width: var(--lumo-size-l);
    height: var(--lumo-size-l);
    min-width: auto;
    margin: 0 var(--lumo-space-s);
    padding: 0;
    background: transparent;
  }

  [part='icon'],
  [part='icon']::after,
  [part='icon']::before {
    position: inherit;
    height: auto;
    width: auto;
    background: transparent;
    top: auto;
  }

  [part='icon']::before {
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-m);
    content: var(--lumo-icons-menu);
  }

  :host([slot~='navbar']) {
    color: var(--lumo-secondary-text-color);
  }
`;registerStyles$1("vaadin-drawer-toggle",[button$1,drawerToggle$1],{moduleId:"lumo-drawer-toggle"});/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const drawerToggle=i`
  :host {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: default;
    position: relative;
    outline: none;
    height: 24px;
    width: 24px;
    padding: 4px;
  }

  [part='icon'],
  [part='icon']::after,
  [part='icon']::before {
    position: absolute;
    top: 8px;
    height: 3px;
    width: 24px;
    background-color: #000;
  }

  [part='icon']::after,
  [part='icon']::before {
    content: '';
  }

  [part='icon']::after {
    top: 6px;
  }

  [part='icon']::before {
    top: 12px;
  }
`;/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-drawer-toggle",[buttonStyles,drawerToggle],{moduleId:"vaadin-drawer-toggle-styles"});class DrawerToggle extends ButtonMixin(DirMixin(ThemableMixin(PolymerElement))){static get template(){return html$3`
      <slot id="slot">
        <div part="icon"></div>
      </slot>
      <div part="icon" hidden$="[[!_showFallbackIcon]]"></div>
    `}static get is(){return"vaadin-drawer-toggle"}static get properties(){return{ariaLabel:{type:String,value:"Toggle navigation panel",reflectToAttribute:!0},_showFallbackIcon:{type:Boolean,value:!1}}}constructor(){super(),this.addEventListener("click",()=>{this.dispatchEvent(new CustomEvent("drawer-toggle-click",{bubbles:!0,composed:!0}))})}ready(){super.ready(),this._toggleFallbackIcon(),this.$.slot.addEventListener("slotchange",()=>{this._toggleFallbackIcon()})}_toggleFallbackIcon(){const d=this.$.slot.assignedNodes();this._showFallbackIcon=d.length>0&&d.every(a=>isEmptyTextNode(a))}}defineCustomElement(DrawerToggle);const tooltipOverlay=i`
  :host {
    --vaadin-tooltip-offset-top: var(--lumo-space-xs);
    --vaadin-tooltip-offset-bottom: var(--lumo-space-xs);
    --vaadin-tooltip-offset-start: var(--lumo-space-xs);
    --vaadin-tooltip-offset-end: var(--lumo-space-xs);
  }

  [part='overlay'] {
    background: var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    color: var(--lumo-body-text-color);
    font-size: var(--lumo-font-size-xs);
    line-height: var(--lumo-line-height-s);
  }

  [part='content'] {
    padding: var(--lumo-space-xs) var(--lumo-space-s);
  }
`;registerStyles$1("vaadin-tooltip-overlay",[overlay,tooltipOverlay],{moduleId:"lumo-tooltip-overlay"});/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const getClosestOverlay=g=>{let d=g;for(;d&&d!==g.ownerDocument;)if(d=d.parentNode||d.host,d&&d._hasOverlayStackMixin)return d;return null},PopoverOverlayMixin=g=>class extends PositionMixin(OverlayMixin(g)){static get properties(){return{position:{type:String,reflectToAttribute:!0}}}static get observers(){return["__openedOrTargetChanged(opened, positionTarget)"]}get _tagNamePrefix(){return"vaadin-popover"}_updatePosition(){if(super._updatePosition(),!(!this.positionTarget||!this.opened)){if(this.owner){const a=getComputedStyle(this.owner);["top","bottom","start","end"].forEach(u=>{const v=`--${this._tagNamePrefix}-offset-${u}`;this.style.setProperty(v,a.getPropertyValue(v))})}if(this.removeAttribute("arrow-centered"),this.position==="bottom"||this.position==="top"){const a=this.positionTarget.getBoundingClientRect(),u=this.$.overlay.getBoundingClientRect(),v=a.width/2-u.width/2;if(this.style.left){const x=u.left+v;x>0&&(this.style.left=`${x}px`,this.setAttribute("arrow-centered",""))}if(this.style.right){const x=parseFloat(this.style.right)+v;x>0&&(this.style.right=`${x}px`,this.setAttribute("arrow-centered",""))}}if(this.position==="start"||this.position==="end"){const a=this.positionTarget.getBoundingClientRect(),u=this.$.overlay.getBoundingClientRect(),v=a.height/2-u.height/2;this.style.top=`${u.top+v}px`}}}__openedOrTargetChanged(a,u){if(u){const v=getClosestOverlay(u);v&&setNestedOverlay(v,a?this:null)}}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const tooltipOverlayStyles=i`
  [part='overlay'] {
    max-width: 40ch;
  }

  [part='content'] {
    white-space: pre-wrap;
  }

  :host([position^='top'][top-aligned]) [part='overlay'],
  :host([position^='bottom'][top-aligned]) [part='overlay'] {
    margin-top: var(--vaadin-tooltip-offset-top, 0);
  }

  :host([position^='top'][bottom-aligned]) [part='overlay'],
  :host([position^='bottom'][bottom-aligned]) [part='overlay'] {
    margin-bottom: var(--vaadin-tooltip-offset-bottom, 0);
  }

  :host([position^='start'][start-aligned]) [part='overlay'],
  :host([position^='end'][start-aligned]) [part='overlay'] {
    margin-inline-start: var(--vaadin-tooltip-offset-start, 0);
  }

  :host([position^='start'][end-aligned]) [part='overlay'],
  :host([position^='end'][end-aligned]) [part='overlay'] {
    margin-inline-end: var(--vaadin-tooltip-offset-end, 0);
  }

  @media (forced-colors: active) {
    [part='overlay'] {
      outline: 1px dashed;
    }
  }
`;/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-tooltip-overlay",[overlayStyles$1,tooltipOverlayStyles],{moduleId:"vaadin-tooltip-overlay-styles"});class TooltipOverlay extends PopoverOverlayMixin(DirMixin(ThemableMixin(PolymerElement))){static get is(){return"vaadin-tooltip-overlay"}static get template(){return html$3`
      <div id="backdrop" part="backdrop" hidden></div>
      <div part="overlay" id="overlay">
        <div part="content" id="content"><slot></slot></div>
      </div>
    `}get _tagNamePrefix(){return"vaadin-tooltip"}requestContentUpdate(){super.requestContentUpdate(),this.toggleAttribute("hidden",this.textContent.trim()==="")}}defineCustomElement(TooltipOverlay);/**
 * @license
 * Copyright (c) 2023 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const OverlayClassMixin=g=>class extends g{static get properties(){return{overlayClass:{type:String},_overlayElement:{type:Object}}}static get observers(){return["__updateOverlayClassNames(overlayClass, _overlayElement)"]}__updateOverlayClassNames(a,u){if(!u||a===void 0)return;const{classList:v}=u;if(this.__initialClasses||(this.__initialClasses=new Set(v)),Array.isArray(this.__previousClasses)){const S=this.__previousClasses.filter(T=>!this.__initialClasses.has(T));S.length>0&&v.remove(...S)}const x=typeof a=="string"?a.split(" ").filter(Boolean):[];x.length>0&&v.add(...x),this.__previousClasses=x}};/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PopoverPositionMixin=g=>class extends g{static get properties(){return{position:{type:String},_position:{type:String,value:"bottom"},__effectivePosition:{type:String,computed:"__computePosition(position, _position)"}}}__computeHorizontalAlign(a){return["top-end","bottom-end","start-top","start","start-bottom"].includes(a)?"end":"start"}__computeNoHorizontalOverlap(a){return["start-top","start","start-bottom","end-top","end","end-bottom"].includes(a)}__computeNoVerticalOverlap(a){return["top-start","top-end","top","bottom-start","bottom","bottom-end"].includes(a)}__computeVerticalAlign(a){return["top-start","top-end","top","start-bottom","end-bottom"].includes(a)?"bottom":"top"}__computePosition(a,u){return a||u}};/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PopoverTargetMixin=g=>class extends g{static get properties(){return{for:{type:String,observer:"__forChanged"},target:{type:Object},__isConnected:{type:Boolean,sync:!0}}}static get observers(){return["__targetOrConnectedChanged(target, __isConnected)"]}connectedCallback(){super.connectedCallback(),this.__isConnected=!0}disconnectedCallback(){super.disconnectedCallback(),this.__isConnected=!1}__forChanged(a){a&&(this.__setTargetByIdDebouncer=Debouncer$1.debounce(this.__setTargetByIdDebouncer,microTask$1,()=>this.__setTargetById(a)))}__setTargetById(a){if(!this.isConnected)return;const u=this.getRootNode().getElementById(a);u?this.target=u:console.warn(`No element with id="${a}" set via "for" property found on the page.`)}__targetOrConnectedChanged(a,u){this.__previousTarget&&(this.__previousTarget!==a||!u)&&this._removeTargetListeners(this.__previousTarget),a&&u&&this._addTargetListeners(a),this.__previousTarget=a}_addTargetListeners(a){}_removeTargetListeners(a){}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DEFAULT_DELAY$1=500;let defaultFocusDelay$3=DEFAULT_DELAY$1,defaultHoverDelay$3=DEFAULT_DELAY$1,defaultHideDelay$3=DEFAULT_DELAY$1;const closing=new Set;let warmedUp=!1,warmUpTimeout=null,cooldownTimeout=null;class TooltipStateController{constructor(d){this.host=d}get openedProp(){return this.host.manual?"opened":"_autoOpened"}get focusDelay(){const d=this.host;return d.focusDelay!=null&&d.focusDelay>=0?d.focusDelay:defaultFocusDelay$3}get hoverDelay(){const d=this.host;return d.hoverDelay!=null&&d.hoverDelay>=0?d.hoverDelay:defaultHoverDelay$3}get hideDelay(){const d=this.host;return d.hideDelay!=null&&d.hideDelay>=0?d.hideDelay:defaultHideDelay$3}get isClosing(){return closing.has(this.host)}open(d={immediate:!1}){const{immediate:a,hover:u,focus:v}=d,x=u&&this.hoverDelay>0,S=v&&this.focusDelay>0;!a&&(x||S)&&!this.__closeTimeout?this.__warmupTooltip(S):this.__showTooltip()}close(d){!d&&this.hideDelay>0?this.__scheduleClose():(this.__abortClose(),this._setOpened(!1)),this.__abortWarmUp(),warmedUp&&(this.__abortCooldown(),this.__scheduleCooldown())}_isOpened(){return this.host[this.openedProp]}_setOpened(d){this.host[this.openedProp]=d}__flushClosingTooltips(){closing.forEach(d=>{d._stateController.close(!0),closing.delete(d)})}__showTooltip(){this.__abortClose(),this.__flushClosingTooltips(),this._setOpened(!0),warmedUp=!0,this.__abortWarmUp(),this.__abortCooldown()}__warmupTooltip(d){this._isOpened()||(warmedUp?this.__showTooltip():warmUpTimeout==null&&this.__scheduleWarmUp(d))}__abortClose(){this.__closeTimeout&&(clearTimeout(this.__closeTimeout),this.__closeTimeout=null),this.isClosing&&closing.delete(this.host)}__abortCooldown(){cooldownTimeout&&(clearTimeout(cooldownTimeout),cooldownTimeout=null)}__abortWarmUp(){warmUpTimeout&&(clearTimeout(warmUpTimeout),warmUpTimeout=null)}__scheduleClose(){this._isOpened()&&!this.isClosing&&(closing.add(this.host),this.__closeTimeout=setTimeout(()=>{closing.delete(this.host),this.__closeTimeout=null,this._setOpened(!1)},this.hideDelay))}__scheduleCooldown(){cooldownTimeout=setTimeout(()=>{cooldownTimeout=null,warmedUp=!1},this.hideDelay)}__scheduleWarmUp(d){const a=d?this.focusDelay:this.hoverDelay;warmUpTimeout=setTimeout(()=>{warmUpTimeout=null,warmedUp=!0,this.__showTooltip()},a)}}const TooltipMixin=g=>class extends PopoverPositionMixin(PopoverTargetMixin(OverlayClassMixin(g))){static get properties(){return{ariaTarget:{type:Object},context:{type:Object,value:()=>({})},focusDelay:{type:Number},generator:{type:Object},hideDelay:{type:Number},hoverDelay:{type:Number},manual:{type:Boolean,value:!1,sync:!0},opened:{type:Boolean,value:!1,sync:!0},shouldShow:{type:Object,value:()=>(a,u)=>!0},text:{type:String,observer:"__textChanged"},_autoOpened:{type:Boolean,observer:"__autoOpenedChanged",sync:!0},_effectiveAriaTarget:{type:Object,computed:"__computeAriaTarget(ariaTarget, target)",observer:"__effectiveAriaTargetChanged"},__isTargetHidden:{type:Boolean,value:!1},_isConnected:{type:Boolean,sync:!0},_srLabel:{type:Object},_overlayContent:{type:String}}}static get observers(){return["__generatorChanged(_overlayElement, generator, context)","__updateSrLabelText(_srLabel, _overlayContent)"]}static setDefaultFocusDelay(a){defaultFocusDelay$3=a!=null&&a>=0?a:DEFAULT_DELAY$1}static setDefaultHideDelay(a){defaultHideDelay$3=a!=null&&a>=0?a:DEFAULT_DELAY$1}static setDefaultHoverDelay(a){defaultHoverDelay$3=a!=null&&a>=0?a:DEFAULT_DELAY$1}constructor(){super(),this._uniqueId=`vaadin-tooltip-${generateUniqueId()}`,this._renderer=this.__tooltipRenderer.bind(this),this.__onFocusin=this.__onFocusin.bind(this),this.__onFocusout=this.__onFocusout.bind(this),this.__onMouseDown=this.__onMouseDown.bind(this),this.__onMouseEnter=this.__onMouseEnter.bind(this),this.__onMouseLeave=this.__onMouseLeave.bind(this),this.__onKeyDown=this.__onKeyDown.bind(this),this.__onOverlayOpen=this.__onOverlayOpen.bind(this),this.__targetVisibilityObserver=new IntersectionObserver(a=>{a.forEach(u=>this.__onTargetVisibilityChange(u.isIntersecting))},{threshold:0}),this._stateController=new TooltipStateController(this)}connectedCallback(){super.connectedCallback(),this._isConnected=!0,document.body.addEventListener("vaadin-overlay-open",this.__onOverlayOpen)}disconnectedCallback(){super.disconnectedCallback(),this._autoOpened&&this._stateController.close(!0),this._isConnected=!1,document.body.removeEventListener("vaadin-overlay-open",this.__onOverlayOpen)}ready(){super.ready(),this._overlayElement=this.$.overlay,this._srLabelController=new SlotController(this,"sr-label","div",{initializer:a=>{a.id=this._uniqueId,a.setAttribute("role","tooltip"),this._srLabel=a}}),this.addController(this._srLabelController)}__computeOpened(a,u,v,x){return x&&(a?u:v)}__autoOpenedChanged(a,u){a?document.addEventListener("keydown",this.__onKeyDown,!0):u&&document.removeEventListener("keydown",this.__onKeyDown,!0)}_addTargetListeners(a){a.addEventListener("mouseenter",this.__onMouseEnter),a.addEventListener("mouseleave",this.__onMouseLeave),a.addEventListener("focusin",this.__onFocusin),a.addEventListener("focusout",this.__onFocusout),a.addEventListener("mousedown",this.__onMouseDown),requestAnimationFrame(()=>{this.__targetVisibilityObserver.observe(a)})}_removeTargetListeners(a){a.removeEventListener("mouseenter",this.__onMouseEnter),a.removeEventListener("mouseleave",this.__onMouseLeave),a.removeEventListener("focusin",this.__onFocusin),a.removeEventListener("focusout",this.__onFocusout),a.removeEventListener("mousedown",this.__onMouseDown),this.__targetVisibilityObserver.unobserve(a)}__onFocusin(a){this.manual||isKeyboardActive()&&(this.target.contains(a.relatedTarget)||this.__isShouldShow()&&(this.__focusInside=!0,!this.__isTargetHidden&&(!this.__hoverInside||!this._autoOpened)&&this._stateController.open({focus:!0})))}__onFocusout(a){this.manual||this.target.contains(a.relatedTarget)||(this.__focusInside=!1,this.__hoverInside||this._stateController.close(!0))}__onKeyDown(a){a.key==="Escape"&&(a.stopPropagation(),this._stateController.close(!0))}__onMouseDown(){this.manual||this._stateController.close(!0)}__onMouseEnter(){this.manual||this.__isShouldShow()&&(this.__hoverInside||(this.__hoverInside=!0,!this.__isTargetHidden&&(!this.__focusInside||!this._autoOpened)&&this._stateController.open({hover:!0})))}__onMouseLeave(a){a.relatedTarget!==this._overlayElement&&this.__handleMouseLeave()}__onOverlayMouseEnter(){this.manual||this._stateController.isClosing&&this._stateController.open({immediate:!0})}__onOverlayMouseLeave(a){a.relatedTarget!==this.target&&this.__handleMouseLeave()}__handleMouseLeave(){this.manual||(this.__hoverInside=!1,this.__focusInside||this._stateController.close())}__onOverlayOpen(){this.manual||this._overlayElement.opened&&!this._overlayElement._last&&this._stateController.close(!0)}__onTargetVisibilityChange(a){const u=this.__isTargetHidden;if(this.__isTargetHidden=!a,u&&a&&(this.__focusInside||this.__hoverInside)){this._stateController.open({immediate:!0});return}!a&&this._autoOpened&&this._stateController.close(!0)}__isShouldShow(){return!(typeof this.shouldShow=="function"&&this.shouldShow(this.target,this.context)!==!0)}__textChanged(a,u){this._overlayElement&&(a||u)&&this._overlayElement.requestContentUpdate()}__tooltipRenderer(a){a.textContent=typeof this.generator=="function"?this.generator(this.context):this.text,this._overlayContent=a.textContent}__computeAriaTarget(a,u){const v=S=>S&&S.nodeType===Node.ELEMENT_NODE;return(Array.isArray(a)?a.some(v):a)?a:u}__effectiveAriaTargetChanged(a,u){u&&[u].flat().forEach(v=>{removeValueFromAttribute(v,"aria-describedby",this._uniqueId)}),a&&[a].flat().forEach(v=>{addValueToAttribute(v,"aria-describedby",this._uniqueId)})}__generatorChanged(a,u,v){a&&((u!==this.__oldTextGenerator||v!==this.__oldContext)&&a.requestContentUpdate(),this.__oldTextGenerator=u,this.__oldContext=v)}__updateSrLabelText(a,u){a&&(a.textContent=u)}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let Tooltip$1=class extends TooltipMixin(ThemePropertyMixin(ElementMixin(ControllerMixin(PolymerElement)))){static get is(){return"vaadin-tooltip"}static get template(){return html$3`
      <style>
        :host {
          display: none;
        }
      </style>
      <vaadin-tooltip-overlay
        id="overlay"
        owner="[[__overlayOwner]]"
        renderer="[[_renderer]]"
        theme$="[[_theme]]"
        opened="[[__computeOpened(manual, opened, _autoOpened, _isConnected)]]"
        position-target="[[target]]"
        position="[[__effectivePosition]]"
        no-horizontal-overlap$="[[__computeNoHorizontalOverlap(__effectivePosition)]]"
        no-vertical-overlap$="[[__computeNoVerticalOverlap(__effectivePosition)]]"
        horizontal-align="[[__computeHorizontalAlign(__effectivePosition)]]"
        vertical-align="[[__computeVerticalAlign(__effectivePosition)]]"
        on-mouseenter="__onOverlayMouseEnter"
        on-mouseleave="__onOverlayMouseLeave"
        modeless
      ></vaadin-tooltip-overlay>

      <slot name="sr-label"></slot>
    `}static get properties(){return{__overlayOwner:{value(){return this}}}}};defineCustomElement(Tooltip$1);const globalStyle=document.createElement("style");globalStyle.textContent="html { --vaadin-avatar-size: var(--lumo-size-m); }";document.head.appendChild(globalStyle);registerStyles$1("vaadin-avatar",i`
    :host {
      color: var(--lumo-secondary-text-color);
      background-color: var(--lumo-contrast-10pct);
      border-radius: 50%;
      outline: none;
      cursor: default;
      user-select: none;
      -webkit-tap-highlight-color: transparent;
      -webkit-font-smoothing: antialiased;
      -moz-osx-font-smoothing: grayscale;
    }

    :host([has-color-index]) {
      color: var(--lumo-base-color);
    }

    :host([focus-ring]) {
      border-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    }

    [part='icon'],
    [part='abbr'] {
      fill: currentColor;
    }

    [part='abbr'] {
      font-family: var(--lumo-font-family);
      font-size: 2.4375em;
      font-weight: 500;
    }

    :host([theme~='xlarge']) [part='abbr'] {
      font-size: 2.5em;
    }

    :host([theme~='large']) [part='abbr'] {
      font-size: 2.375em;
    }

    :host([theme~='small']) [part='abbr'] {
      font-size: 2.75em;
    }

    :host([theme~='xsmall']) [part='abbr'] {
      font-size: 3em;
    }

    :host([theme~='xlarge']) {
      --vaadin-avatar-size: var(--lumo-size-xl);
    }

    :host([theme~='large']) {
      --vaadin-avatar-size: var(--lumo-size-l);
    }

    :host([theme~='small']) {
      --vaadin-avatar-size: var(--lumo-size-s);
    }

    :host([theme~='xsmall']) {
      --vaadin-avatar-size: var(--lumo-size-xs);
    }
  `,{moduleId:"lumo-avatar"});/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const template$7=document.createElement("template");template$7.innerHTML=`
  <style>
    @font-face {
      font-family: 'vaadin-avatar-icons';
      src: url(data:application/font-woff;charset=utf-8;base64,d09GRgABAAAAAAQAAAsAAAAABnwAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAABHU1VCAAABCAAAADsAAABUIIslek9TLzIAAAFEAAAAQwAAAFZAIUmEY21hcAAAAYgAAABLAAABcOspwa1nbHlmAAAB1AAAAEUAAABMYO4o1WhlYWQAAAIcAAAALgAAADYYaAmGaGhlYQAAAkwAAAAdAAAAJAZsA1VobXR4AAACbAAAAAgAAAAIA+gAAGxvY2EAAAJ0AAAABgAAAAYAJgAAbWF4cAAAAnwAAAAeAAAAIAEOACFuYW1lAAACnAAAAUIAAAKavFDYrHBvc3QAAAPgAAAAHQAAAC52hGZ4eJxjYGRgYOBiMGCwY2BycfMJYeDLSSzJY5BiYGGAAJA8MpsxJzM9kYEDxgPKsYBpDiBmg4gCACY7BUgAeJxjYGT8wjiBgZWBgamKaQ8DA0MPhGZ8wGDIyAQUZWBlZsAKAtJcUxgcXjG+YmQO+p/FEMUcxDANKMwIkgMADiUMJQB4nGNgYGBlYGBgBmIdIGZhYGAMYWBkAAE/oCgjWJyZgQsszsKgBFbDAhJ/xfj/P4wE8lnAJAMjG8Mo4AGTMlAeOKwgmIERADU0CX0AeJxjYGIAAmYJpkgGHgYRBgZGJT1GEztGIzlGET5GKEuU8YuSpZKSpQuI+LfLv21emz9jHJQPJP7dsUywsEiwBACG8g9CAAAAeJxjYGRgYADicIOnh+P5bb4ycDO/AIow3JZ4rIJMM0swRQIpDgYmEA8AKwgJOwAAeJxjYGRgYA76nwUkXzAAAbMEAyMDKmACAE2GAskAAAAAAAAAA+gAAAAAAAAAJgAAeJxjYGRgYGBiEAViBjCLgYELCBkY/oP5DAAKuwEwAAB4nI2Qu07DMBSG//SGaCWEhMSAGDx1QU0vYyemdmDrUDEhuamTpkriyHEj9RF4B56Bh2Bg5mmY+8d4Qh3qo9jf+c45thQAt/hGgGYFuHN7s1q4YvbHbdKD5w555LmLAZ499+hfPPfxhDfPA/p33hB0rmmG+PDcwg2+PLfpfzx3yL+eu7gPHj33MAxmnvtYB6+eB/SftZTbtBjJWlppRmmki2qlkkMmzZnKGbVWpkp1Iabh5Ex1qQplpFVbsTmKqk5m1sYiNjoXC11YlWValEbvVWTDnbXlfDyOvQ8jnaOGZGyRouCfky63/AyzFBE0fYUVFBIckLnKZTOXda15s+GZulxgihCTC2eXnC3cfFNV7BfY4Mi9eT3BjNYiZh6zRyMnLdxs050xNE3panuaiD7Ezk2VmGPMiP/1h+71/ATcWYAhAAB4nGNgYoAALgbsgImRiZGZgaW0OLWIgQEACl4B2QAAAA==) format('woff');
      font-weight: normal;
      font-style: normal;
    }
  </style>
`;document.head.appendChild(template$7.content);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DEFAULT_I18N$9={anonymous:"anonymous"},AvatarMixin=g=>class extends I18nMixin(DEFAULT_I18N$9,FocusMixin(g)){static get properties(){return{img:{type:String,reflectToAttribute:!0,observer:"__imgChanged"},abbr:{type:String,reflectToAttribute:!0},name:{type:String,reflectToAttribute:!0},colorIndex:{type:Number,observer:"__colorIndexChanged"},withTooltip:{type:Boolean,value:!1,observer:"__withTooltipChanged"},__imgVisible:Boolean,__iconVisible:Boolean,__abbrVisible:Boolean,__tooltipNode:Object}}static get observers(){return["__imgOrAbbrOrNameChanged(img, abbr, name)","__i18nChanged(__effectiveI18n)","__tooltipChanged(__tooltipNode, name, abbr)"]}get i18n(){return super.i18n}set i18n(a){super.i18n=a}ready(){super.ready(),this.__updateVisibility(),this.hasAttribute("role")||this.setAttribute("role","img"),this.hasAttribute("tabindex")||this.setAttribute("tabindex","0"),!this.name&&!this.abbr&&this.__setTooltip()}__colorIndexChanged(a){if(a!=null){const u=`--vaadin-user-color-${a}`;!!getComputedStyle(document.documentElement).getPropertyValue(u)?(this.setAttribute("has-color-index",""),this.style.setProperty("--vaadin-avatar-user-color",`var(${u})`)):(this.removeAttribute("has-color-index"),console.warn(`The CSS property --vaadin-user-color-${a} is not defined`))}else this.removeAttribute("has-color-index")}__imgChanged(){this.__imgFailedToLoad=!1}__imgOrAbbrOrNameChanged(a,u,v){this.__updateVisibility(),!(u&&u!==this.__generatedAbbr)&&(v?this.abbr=this.__generatedAbbr=v.split(" ").map(x=>x.charAt(0)).join(""):this.abbr=void 0)}__tooltipChanged(a,u,v){a&&(v&&v!==this.__generatedAbbr?this.__setTooltip(u?`${u} (${v})`:v):this.__setTooltip(u)),v?this.setAttribute("aria-label",!a&&u?`${u} (${v})`:v):this.removeAttribute("aria-label")}__withTooltipChanged(a,u){if(a){const v=document.createElement("vaadin-tooltip");v.setAttribute("slot","tooltip"),this.appendChild(v),this.__tooltipNode=v}else u&&(this.__tooltipNode.target=null,this.__tooltipNode.remove(),this.__tooltipNode=null)}__i18nChanged(a){a&&a.anonymous&&(this.__oldAnonymous&&this.__tooltipNode&&this.__tooltipNode.text===this.__oldAnonymous&&this.__setTooltip(),this.__oldAnonymous=a.anonymous)}__updateVisibility(){this.__imgVisible=!!this.img&&!this.__imgFailedToLoad,this.__abbrVisible=!this.__imgVisible&&!!this.abbr,this.__iconVisible=!this.__imgVisible&&!this.abbr}__setTooltip(a){const u=this.__tooltipNode;u&&(u.text=a||this.__effectiveI18n.anonymous)}__onImageLoadError(){this.img&&(console.warn(`<vaadin-avatar> The specified image could not be loaded: ${this.img}`),this.__imgFailedToLoad=!0,this.__updateVisibility())}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const avatarStyles=i`
  :host {
    display: inline-block;
    flex: none;
    border-radius: 50%;
    overflow: hidden;
    height: var(--vaadin-avatar-size, 64px);
    width: var(--vaadin-avatar-size, 64px);
    border: var(--vaadin-avatar-outline-width) solid transparent;
    margin: calc(var(--vaadin-avatar-outline-width) * -1);
    background-clip: content-box;
    --vaadin-avatar-outline-width: var(--vaadin-focus-ring-width, 2px);
  }

  img {
    height: 100%;
    width: 100%;
    object-fit: cover;
  }

  [part='icon'] {
    font-size: 5.6em;
  }

  [part='abbr'] {
    font-size: 2.2em;
  }

  [part='icon'] > text {
    font-family: 'vaadin-avatar-icons';
  }

  :host([hidden]) {
    display: none !important;
  }

  svg[hidden] {
    display: none !important;
  }

  :host([has-color-index]) {
    position: relative;
    background-color: var(--vaadin-avatar-user-color);
  }

  :host([has-color-index])::before {
    position: absolute;
    content: '';
    inset: 0;
    border-radius: inherit;
    box-shadow: inset 0 0 0 2px var(--vaadin-avatar-user-color);
  }
`;/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-avatar",avatarStyles,{moduleId:"vaadin-avatar-styles"});class Avatar extends AvatarMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get template(){return html$3`
      <img
        hidden$="[[!__imgVisible]]"
        src$="[[img]]"
        aria-hidden="true"
        on-error="__onImageLoadError"
        draggable="false"
      />
      <svg
        part="icon"
        hidden$="[[!__iconVisible]]"
        id="avatar-icon"
        viewBox="-50 -50 100 100"
        preserveAspectRatio="xMidYMid meet"
        aria-hidden="true"
      >
        <text dy=".35em" text-anchor="middle">&#xea01;</text>
      </svg>
      <svg
        part="abbr"
        hidden$="[[!__abbrVisible]]"
        id="avatar-abbr"
        viewBox="-50 -50 100 100"
        preserveAspectRatio="xMidYMid meet"
        aria-hidden="true"
      >
        <text dy=".35em" text-anchor="middle">[[abbr]]</text>
      </svg>

      <slot name="tooltip"></slot>
    `}static get is(){return"vaadin-avatar"}ready(){super.ready(),this._tooltipController=new TooltipController(this),this.addController(this._tooltipController)}}defineCustomElement(Avatar);const item=i`
  :host {
    display: flex;
    align-items: center;
    box-sizing: border-box;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-xs);
    padding: 0.5em calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4) 0.5em
      var(--_lumo-list-box-item-padding-left, calc(var(--lumo-border-radius-m) / 4));
    min-height: var(--lumo-size-m);
    outline: none;
    border-radius: var(--lumo-border-radius-m);
    cursor: var(--lumo-clickable-cursor);
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    -webkit-tap-highlight-color: var(--lumo-primary-color-10pct);
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    --_selection-color-text: var(--vaadin-selection-color-text, var(--lumo-primary-text-color));
  }

  /* Checkmark */
  [part='checkmark']::before {
    display: var(--_lumo-item-selected-icon-display, none);
    content: var(--lumo-icons-checkmark);
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-m);
    line-height: 1;
    font-weight: normal;
    width: 1em;
    height: 1em;
    margin: calc((1 - var(--lumo-line-height-xs)) * var(--lumo-font-size-m) / 2) 0;
    color: var(--_selection-color-text);
    flex: none;
    opacity: 0;
    transition:
      transform 0.2s cubic-bezier(0.12, 0.32, 0.54, 2),
      opacity 0.1s;
  }

  :host([selected]) [part='checkmark']::before {
    opacity: 1;
  }

  :host([active]:not([selected])) [part='checkmark']::before {
    transform: scale(0.8);
    opacity: 0;
    transition-duration: 0s;
  }

  [part='content'] {
    flex: auto;
  }

  /* Disabled */
  :host([disabled]) {
    color: var(--lumo-disabled-text-color);
    cursor: default;
    pointer-events: none;
  }

  /* TODO a workaround until we have "focus-follows-mouse". After that, use the hover style for focus-ring as well */
  @media (any-hover: hover) {
    :host(:hover:not([disabled])) {
      background-color: var(--lumo-primary-color-10pct);
    }
  }

  :host([focus-ring]:not([disabled])) {
    box-shadow: inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  /* RTL specific styles */
  :host([dir='rtl']) {
    padding-left: calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4);
    padding-right: var(--_lumo-list-box-item-padding-left, calc(var(--lumo-border-radius-m) / 4));
  }

  /* Slotted icons */
  :host ::slotted(vaadin-icon) {
    width: var(--lumo-icon-size-m);
    height: var(--lumo-icon-size-m);
  }
`;registerStyles$1("vaadin-item",item,{moduleId:"lumo-item"});const listBox=i`
  :host {
    -webkit-tap-highlight-color: transparent;
    --_lumo-item-selected-icon-display: var(--_lumo-list-box-item-selected-icon-display, block);
  }

  /* Dividers */
  [part='items'] ::slotted(hr) {
    height: 1px;
    border: 0;
    padding: 0;
    margin: var(--lumo-space-s) var(--lumo-border-radius-m);
    background-color: var(--lumo-contrast-10pct);
  }
`;registerStyles$1("vaadin-list-box",listBox,{moduleId:"lumo-list-box"});/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const menuOverlayCore=i`
  :host([opening]),
  :host([closing]) {
    animation: 0.14s lumo-overlay-dummy-animation;
  }

  [part='overlay'] {
    will-change: opacity, transform;
  }

  :host([opening]) [part='overlay'] {
    animation: 0.1s lumo-menu-overlay-enter ease-out both;
  }

  @keyframes lumo-menu-overlay-enter {
    0% {
      opacity: 0;
      transform: translateY(-4px);
    }
  }

  :host([closing]) [part='overlay'] {
    animation: 0.1s lumo-menu-overlay-exit both;
  }

  @keyframes lumo-menu-overlay-exit {
    100% {
      opacity: 0;
    }
  }
`;registerStyles$1("",menuOverlayCore,{moduleId:"lumo-menu-overlay-core"});const menuOverlayExt=i`
  /* Small viewport (bottom sheet) styles */
  /* Use direct media queries instead of the state attributes ([phone] and [fullscreen]) provided by the elements */
  @media (max-width: 450px), (max-height: 450px) {
    :host {
      top: 0 !important;
      right: 0 !important;
      bottom: var(--vaadin-overlay-viewport-bottom, 0) !important;
      left: 0 !important;
      align-items: stretch !important;
      justify-content: flex-end !important;
    }

    [part='overlay'] {
      max-height: 50vh;
      width: 100vw;
      border-radius: 0;
      box-shadow: var(--lumo-box-shadow-xl);
    }

    /* The content part scrolls instead of the overlay part, because of the gradient fade-out */
    [part='content'] {
      padding: 30px var(--lumo-space-m);
      max-height: inherit;
      box-sizing: border-box;
      -webkit-overflow-scrolling: touch;
      overflow: auto;
      -webkit-mask-image: linear-gradient(transparent, #000 40px, #000 calc(100% - 40px), transparent);
      mask-image: linear-gradient(transparent, #000 40px, #000 calc(100% - 40px), transparent);
    }

    [part='backdrop'] {
      display: block;
    }

    /* Animations */

    :host([opening]) [part='overlay'] {
      animation: 0.2s lumo-mobile-menu-overlay-enter cubic-bezier(0.215, 0.61, 0.355, 1) both;
    }

    :host([closing]),
    :host([closing]) [part='backdrop'] {
      animation-delay: 0.14s;
    }

    :host([closing]) [part='overlay'] {
      animation: 0.14s 0.14s lumo-mobile-menu-overlay-exit cubic-bezier(0.55, 0.055, 0.675, 0.19) both;
    }
  }

  @keyframes lumo-mobile-menu-overlay-enter {
    0% {
      transform: translateY(150%);
    }
  }

  @keyframes lumo-mobile-menu-overlay-exit {
    100% {
      transform: translateY(150%);
    }
  }
`,menuOverlay=[overlay,menuOverlayCore,menuOverlayExt];registerStyles$1("",menuOverlay,{moduleId:"lumo-menu-overlay"});registerStyles$1("vaadin-avatar-group",i`
    :host {
      --vaadin-avatar-size: var(--lumo-size-m);
    }

    :host([theme~='xlarge']) {
      --vaadin-avatar-group-overlap: 12px;
      --vaadin-avatar-group-overlap-border: 3px;
      --vaadin-avatar-size: var(--lumo-size-xl);
    }

    :host([theme~='large']) {
      --vaadin-avatar-group-overlap: 10px;
      --vaadin-avatar-group-overlap-border: 3px;
      --vaadin-avatar-size: var(--lumo-size-l);
    }

    :host([theme~='small']) {
      --vaadin-avatar-group-overlap: 6px;
      --vaadin-avatar-group-overlap-border: 2px;
      --vaadin-avatar-size: var(--lumo-size-s);
    }

    :host([theme~='xsmall']) {
      --vaadin-avatar-group-overlap: 4px;
      --vaadin-avatar-group-overlap-border: 2px;
      --vaadin-avatar-size: var(--lumo-size-xs);
    }
  `,{moduleId:"lumo-avatar-group"});const avatarGroupOverlay=i`
  :host {
    --_lumo-list-box-item-selected-icon-display: none;
    --_lumo-list-box-item-padding-left: calc(var(--lumo-space-m) + var(--lumo-border-radius-m) / 4);
  }

  [part='overlay'] {
    outline: none;
  }
`;registerStyles$1("vaadin-avatar-group-overlay",[overlay,menuOverlayCore,avatarGroupOverlay],{moduleId:"lumo-avatar-group-overlay"});registerStyles$1("vaadin-avatar-group-menu",listBox,{moduleId:"lumo-avatar-group-menu"});registerStyles$1("vaadin-avatar-group-menu-item",[item,i`
      :host {
        padding: var(--lumo-space-xs);
        padding-inline-end: var(--lumo-space-m);
      }

      [part='content'] {
        display: flex;
        align-items: center;
      }

      [part='content'] ::slotted(vaadin-avatar) {
        width: var(--lumo-size-xs);
        height: var(--lumo-size-xs);
        margin-inline-end: var(--lumo-space-s);
      }
    `],{moduleId:"lumo-avatar-group-menu-item"});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function getNormalizedScrollLeft(g,d){const{scrollLeft:a}=g;return d!=="rtl"?a:g.scrollWidth-g.clientWidth+a}function setNormalizedScrollLeft(g,d,a){d!=="rtl"?g.scrollLeft=a:g.scrollLeft=g.clientWidth-g.scrollWidth+a}/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ListMixin=g=>class extends KeyboardDirectionMixin(g){static get properties(){return{disabled:{type:Boolean,value:!1,reflectToAttribute:!0},selected:{type:Number,reflectToAttribute:!0,notify:!0,sync:!0},orientation:{type:String,reflectToAttribute:!0,value:""},items:{type:Array,readOnly:!0,notify:!0},_searchBuf:{type:String,value:""}}}static get observers(){return["_enhanceItems(items, orientation, selected, disabled)"]}get _isRTL(){return!this._vertical&&this.getAttribute("dir")==="rtl"}get _scrollerElement(){return console.warn(`Please implement the '_scrollerElement' property in <${this.localName}>`),this}get _vertical(){return this.orientation!=="horizontal"}focus(){this._observer&&this._observer.flush();const a=Array.isArray(this.items)?this.items:[],u=this._getAvailableIndex(a,0,null,v=>v.tabIndex===0&&!isElementHidden(v));u>=0?this._focus(u):super.focus()}ready(){super.ready(),this.addEventListener("click",u=>this._onClick(u));const a=this.shadowRoot.querySelector("slot:not([name])");this._observer=new SlotObserver(a,()=>{this._setItems(this._filterItems([...this.children]))})}_getItems(){return this.items}_enhanceItems(a,u,v,x){if(!x&&a){this.setAttribute("aria-orientation",u||"vertical"),a.forEach(T=>{u?T.setAttribute("orientation",u):T.removeAttribute("orientation")}),this._setFocusable(v<0||!v?0:v);const S=a[v];a.forEach(T=>{T.selected=T===S}),S&&!S.disabled&&this._scrollToItem(v)}}_filterItems(a){return a.filter(u=>u._hasVaadinItemMixin)}_onClick(a){if(a.metaKey||a.shiftKey||a.ctrlKey||a.defaultPrevented)return;const u=this._filterItems(a.composedPath())[0];let v;u&&!u.disabled&&(v=this.items.indexOf(u))>=0&&(this.selected=v)}_searchKey(a,u){this._searchReset=Debouncer$1.debounce(this._searchReset,timeOut$1.after(500),()=>{this._searchBuf=""}),this._searchBuf+=u.toLowerCase(),this.items.some(x=>this.__isMatchingKey(x))||(this._searchBuf=u.toLowerCase());const v=this._searchBuf.length===1?a+1:a;return this._getAvailableIndex(this.items,v,1,x=>this.__isMatchingKey(x)&&getComputedStyle(x).display!=="none")}__isMatchingKey(a){return a.textContent.replace(/[^\p{L}\p{Nd}]/gu,"").toLowerCase().startsWith(this._searchBuf)}_onKeyDown(a){if(a.metaKey||a.ctrlKey)return;const u=a.key,v=this.items.indexOf(this.focused);if(/[\p{L}\p{Nd}]/u.test(u)&&u.length===1){const x=this._searchKey(v,u);x>=0&&this._focus(x);return}super._onKeyDown(a)}_setFocusable(a){a=this._getAvailableIndex(this.items,a,1);const u=this.items[a];this.items.forEach(v=>{v.tabIndex=v===u?0:-1})}_focus(a){this.items.forEach((u,v)=>{u.focused=v===a}),this._setFocusable(a),this._scrollToItem(a),super._focus(a)}_scrollToItem(a){const u=this.items[a];if(!u)return;const v=this._vertical?["top","bottom"]:this._isRTL?["right","left"]:["left","right"],x=this._scrollerElement.getBoundingClientRect(),S=(this.items[a+1]||u).getBoundingClientRect(),T=(this.items[a-1]||u).getBoundingClientRect();let P=0;!this._isRTL&&S[v[1]]>=x[v[1]]||this._isRTL&&S[v[1]]<=x[v[1]]?P=S[v[1]]-x[v[1]]:(!this._isRTL&&T[v[0]]<=x[v[0]]||this._isRTL&&T[v[0]]>=x[v[0]])&&(P=T[v[0]]-x[v[0]]),this._scroll(P)}_scroll(a){if(this._vertical)this._scrollerElement.scrollTop+=a;else{const u=this.getAttribute("dir")||"ltr",v=getNormalizedScrollLeft(this._scrollerElement,u)+a;setNormalizedScrollLeft(this._scrollerElement,u,v)}}};/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AvatarGroupMenu extends ListMixin(ThemableMixin(DirMixin(ControllerMixin(PolymerElement)))){static get is(){return"vaadin-avatar-group-menu"}static get template(){return html$3`
      <style>
        :host {
          display: flex;
        }

        :host([hidden]) {
          display: none !important;
        }

        [part='items'] {
          height: 100%;
          width: 100%;
          overflow-y: auto;
          -webkit-overflow-scrolling: touch;
        }
      </style>
      <div part="items">
        <slot></slot>
      </div>
    `}static get properties(){return{orientation:{readOnly:!0}}}get _scrollerElement(){return this.shadowRoot.querySelector('[part="items"]')}ready(){super.ready(),this.setAttribute("role","menu")}}defineCustomElement(AvatarGroupMenu);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ItemMixin=g=>class extends ActiveMixin(FocusMixin(g)){static get properties(){return{_hasVaadinItemMixin:{value:!0},selected:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_selectedChanged",sync:!0},_value:String}}get _activeKeys(){return["Enter"," "]}get value(){return this._value!==void 0?this._value:this.textContent.trim()}set value(a){this._value=a}ready(){super.ready();const a=this.getAttribute("value");a!==null&&(this.value=a)}focus(){this.disabled||(super.focus(),this._setFocused(!0))}_shouldSetActive(a){return!this.disabled&&!(a.type==="keydown"&&a.defaultPrevented)}_selectedChanged(a){this.setAttribute("aria-selected",a)}_disabledChanged(a){super._disabledChanged(a),a&&(this.selected=!1,this.blur())}_onKeyDown(a){super._onKeyDown(a),this._activeKeys.includes(a.key)&&!a.defaultPrevented&&(a.preventDefault(),this.click())}};/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AvatarGroupMenuItem extends ItemMixin(ThemableMixin(DirMixin(PolymerElement))){static get is(){return"vaadin-avatar-group-menu-item"}static get template(){return html$3`
      <style>
        :host {
          display: inline-block;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <span part="checkmark" aria-hidden="true"></span>
      <div part="content">
        <slot></slot>
      </div>
    `}ready(){super.ready(),this.setAttribute("role","menuitem")}}defineCustomElement(AvatarGroupMenuItem);/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-avatar-group-overlay",[overlayStyles$1],{moduleId:"vaadin-avatar-group-overlay-styles"});class AvatarGroupOverlay extends PositionMixin(OverlayMixin(DirMixin(ThemableMixin(PolymerElement)))){static get is(){return"vaadin-avatar-group-overlay"}static get template(){return html$3`
      <div id="backdrop" part="backdrop" hidden$="[[!withBackdrop]]"></div>
      <div part="overlay" id="overlay" tabindex="0">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `}}defineCustomElement(AvatarGroupOverlay);/**
 * @license
 * Copyright 2018 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const o$2=g=>g??A$1;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const observer$1=new ResizeObserver(g=>{setTimeout(()=>{g.forEach(d=>{d.target.isConnected&&(d.target.resizables?d.target.resizables.forEach(a=>{a._onResize(d.contentRect)}):d.target._onResize(d.contentRect))})})}),ResizeMixin=dedupeMixin(g=>class extends g{get _observeParent(){return!1}connectedCallback(){if(super.connectedCallback(),observer$1.observe(this),this._observeParent){const a=this.parentNode instanceof ShadowRoot?this.parentNode.host:this.parentNode;a.resizables||(a.resizables=new Set,observer$1.observe(a)),a.resizables.add(this),this.__parent=a}}disconnectedCallback(){super.disconnectedCallback(),observer$1.unobserve(this);const a=this.__parent;if(this._observeParent&&a){const u=a.resizables;u&&(u.delete(this),u.size===0&&observer$1.unobserve(a)),this.__parent=null}}_onResize(a){}});/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const MINIMUM_DISPLAYED_AVATARS=2,DEFAULT_I18N$8={anonymous:"anonymous",activeUsers:{one:"Currently one active user",many:"Currently {count} active users"},joined:"{user} joined",left:"{user} left"},AvatarGroupMixin=g=>class extends I18nMixin(DEFAULT_I18N$8,ResizeMixin(OverlayClassMixin(g))){static get properties(){return{items:{type:Array,observer:"__itemsChanged",sync:!0},maxItemsVisible:{type:Number,sync:!0},_avatars:{type:Array,value:()=>[],sync:!0},__itemsInView:{type:Number,value:null,sync:!0},_overflow:{type:Object,sync:!0},_overflowItems:{type:Array,observer:"__overflowItemsChanged",computed:"__computeOverflowItems(items, __itemsInView, maxItemsVisible)"},_overflowTooltip:{type:Object,sync:!0},_opened:{type:Boolean,sync:!0}}}static get observers(){return["__i18nItemsChanged(__effectiveI18n, items)","__openedChanged(_opened, _overflow)","__updateAvatarsTheme(_overflow, _avatars, _theme)","__updateAvatars(items, __itemsInView, maxItemsVisible, _overflow, __effectiveI18n)","__updateOverflowAvatar(_overflow, items, __itemsInView, maxItemsVisible)","__updateOverflowTooltip(_overflowTooltip, items, __itemsInView, maxItemsVisible)"]}get i18n(){return super.i18n}set i18n(a){super.i18n=a}ready(){super.ready(),this._overflowController=new SlotController(this,"overflow","vaadin-avatar",{initializer:u=>{u.setAttribute("role","button"),u.setAttribute("aria-haspopup","menu"),u.setAttribute("aria-expanded","false"),u.addEventListener("click",x=>this._onOverflowClick(x)),u.addEventListener("keydown",x=>this._onOverflowKeyDown(x));const v=document.createElement("vaadin-tooltip");v.setAttribute("slot","tooltip"),u.appendChild(v),this._overflow=u,this._overflowTooltip=v}}),this.addController(this._overflowController);const a=this.$.overlay;a.renderer=this.__overlayRenderer.bind(this),this._overlayElement=a}disconnectedCallback(){super.disconnectedCallback(),this._opened=!1}__getMessage(a,u){return u.replace("{user}",a.name||a.abbr||this.__effectiveI18n.anonymous)}__overlayRenderer(a){let u=a.firstElementChild;u||(u=document.createElement("vaadin-avatar-group-menu"),u.addEventListener("keydown",v=>this._onListKeyDown(v)),a.appendChild(u)),u.textContent="",this._overflowItems&&this._overflowItems.forEach(v=>{u.appendChild(this.__createItemElement(v))})}__createItemElement(a){const u=document.createElement("vaadin-avatar-group-menu-item"),v=document.createElement("vaadin-avatar");if(u.appendChild(v),v.setAttribute("aria-hidden","true"),v.setAttribute("tabindex","-1"),v.i18n=this.__effectiveI18n,this._theme&&v.setAttribute("theme",this._theme),v.name=a.name,v.abbr=a.abbr,v.img=a.img,v.colorIndex=a.colorIndex,a.className&&(v.className=a.className),a.name){const x=document.createTextNode(a.name);u.appendChild(x)}return u}_onOverflowClick(a){a.stopPropagation(),this._opened?this.$.overlay.close():a.defaultPrevented||(this._opened=!0)}_onOverflowKeyDown(a){this._opened||/^(Enter|SpaceBar|\s)$/u.test(a.key)&&(a.preventDefault(),this._opened=!0)}_onListKeyDown(a){(a.key==="Escape"||a.key==="Tab")&&(this._opened=!1)}_onResize(){this.__setItemsInView()}_onVaadinOverlayClose(a){a.detail.sourceEvent&&a.detail.sourceEvent.composedPath().includes(this)&&a.preventDefault()}_onVaadinOverlayOpen(){this._menuElement&&this._menuElement.focus()}__renderAvatars(a){D(b`
          ${a.map(u=>b`
              <vaadin-avatar
                .name="${u.name}"
                .abbr="${u.abbr}"
                .img="${u.img}"
                .colorIndex="${u.colorIndex}"
                .i18n="${this.__effectiveI18n}"
                class="${o$2(u.className)}"
                with-tooltip
              ></vaadin-avatar>
            `)}
        `,this,{renderBefore:this._overflow})}__updateAvatars(a,u,v,x){if(!x||!Array.isArray(a))return;const S=this.__getLimit(a.length,u,v);this.__renderAvatars(S?a.slice(0,S):a),this._avatars=[...this.querySelectorAll("vaadin-avatar")]}__computeOverflowItems(a,u,v){const x=Array.isArray(a)?a.length:0,S=this.__getLimit(x,u,v);return S?a.slice(S):[]}__updateOverflowAvatar(a,u,v,x){if(a){const S=Array.isArray(u)?u.length:0,T=x!=null&&S>this.__getMax(x);a.abbr=`+${S-this.__getLimit(S,v,x)}`,a.toggleAttribute("hidden",!T&&!(v&&v<S))}}__updateAvatarsTheme(a,u,v){a&&[a,...u].forEach(x=>{v?x.setAttribute("theme",v):x.removeAttribute("theme")})}__updateOverflowTooltip(a,u,v,x){if(!a||!Array.isArray(u))return;const S=this.__getLimit(u.length,v,x);if(S==null)return;const T=[];for(let P=S;P<u.length;P++){const z=u[P];z&&T.push(z.name||z.abbr||"anonymous")}a.text=T.join(`
`)}__getLimit(a,u,v){let x=null;const S=this.__getMax(v);return v!=null&&S<a?x=S-1:u&&u<a&&(x=u),Math.min(x,this.__calculateAvatarsFitWidth())}__getMax(a){return Math.max(a,MINIMUM_DISPLAYED_AVATARS)}__itemsChanged(a,u){this.__setItemsInView();let v=[],x=[];const S=Array.isArray(a),T=Array.isArray(u);T&&(x=u.filter(P=>S&&!a.includes(P))),S&&(v=a.filter(P=>T&&!u.includes(P))),this.__announceItemsChange(v,x)}__announceItemsChange(a,u){let v=[],x=[];a&&(v=a.map(T=>this.__getMessage(T,this.__effectiveI18n.joined||"{user} joined"))),u&&(x=u.map(T=>this.__getMessage(T,this.__effectiveI18n.left||"{user} left")));const S=x.concat(v);S.length>0&&announce(S.join(", "))}__i18nItemsChanged(a,u){if(a&&a.activeUsers){const v=Array.isArray(u)?u.length:0,x=v===1?"one":"many";a.activeUsers[x]&&this.setAttribute("aria-label",a.activeUsers[x].replace("{count}",v||0)),this._avatars.forEach(S=>{S.i18n=a})}}__openedChanged(a,u){u&&(a?(this._menuElement||(this._menuElement=this.$.overlay.querySelector("vaadin-avatar-group-menu")),this._openedWithFocusRing=u.hasAttribute("focus-ring")):this.__oldOpened&&(u.focus(),this._openedWithFocusRing&&u.setAttribute("focus-ring","")),u.setAttribute("aria-expanded",a===!0),this.__oldOpened=a)}__overflowItemsChanged(a,u){(a||u)&&this.$.overlay.requestContentUpdate()}__setItemsInView(){const a=this._avatars,u=this.items;if(!u||!a||a.length<3)return;let v=this.__calculateAvatarsFitWidth();v===u.length-1&&(v=u.length),v>=u.length&&this._opened&&(this.$.overlay.close(),this.$.overlay._flushAnimation("closing")),this.__itemsInView=v}__calculateAvatarsFitWidth(){if(!this.shadowRoot||this._avatars.length<MINIMUM_DISPLAYED_AVATARS)return MINIMUM_DISPLAYED_AVATARS;const a=this._avatars,u=a[0].clientWidth,{marginLeft:v,marginRight:x}=getComputedStyle(a[1]),S=this.__isRTL?parseInt(x,0)-parseInt(v,0):parseInt(v,0)-parseInt(x,0);return Math.floor((this.$.container.offsetWidth-u)/(u+S))}};/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const avatarGroupStyles=i`
  :host {
    display: block;
    width: 100%; /* prevent collapsing inside non-stretching column flex */
    --vaadin-avatar-group-overlap: 8px;
    --vaadin-avatar-group-overlap-border: 2px;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='container'] {
    display: flex;
    position: relative;
    width: 100%;
    flex-wrap: nowrap;
  }

  ::slotted(vaadin-avatar:not(:first-child)) {
    -webkit-mask-image: url('data:image/svg+xml;utf8,<svg viewBox=%220 0 300 300%22 fill=%22none%22 xmlns=%22http://www.w3.org/2000/svg%22><path fill-rule=%22evenodd%22 clip-rule=%22evenodd%22 d=%22M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z%22 fill=%22black%22/></svg>');
    mask-image: url('data:image/svg+xml;utf8,<svg viewBox=%220 0 300 300%22 fill=%22none%22 xmlns=%22http://www.w3.org/2000/svg%22><path fill-rule=%22evenodd%22 clip-rule=%22evenodd%22 d=%22M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z%22 fill=%22black%22/></svg>');
    -webkit-mask-size: calc(
      300% + var(--vaadin-avatar-group-overlap-border) * 6 - var(--vaadin-avatar-outline-width) * 6
    );
    mask-size: calc(300% + var(--vaadin-avatar-group-overlap-border) * 6 - var(--vaadin-avatar-outline-width) * 6);
  }

  ::slotted(vaadin-avatar:not([dir='rtl']):not(:first-child)) {
    margin-left: calc(var(--vaadin-avatar-group-overlap) * -1 - var(--vaadin-avatar-outline-width));
    -webkit-mask-position: calc(50% - var(--vaadin-avatar-size) + var(--vaadin-avatar-group-overlap));
    mask-position: calc(50% - var(--vaadin-avatar-size) + var(--vaadin-avatar-group-overlap));
  }

  ::slotted(vaadin-avatar[dir='rtl']:not(:first-child)) {
    margin-right: calc(var(--vaadin-avatar-group-overlap) * -1);
    -webkit-mask-position: calc(
      50% + var(--vaadin-avatar-size) - var(--vaadin-avatar-group-overlap) + var(--vaadin-avatar-outline-width)
    );
    mask-position: calc(
      50% + var(--vaadin-avatar-size) - var(--vaadin-avatar-group-overlap) + var(--vaadin-avatar-outline-width)
    );
  }
`;/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-avatar-group",avatarGroupStyles,{moduleId:"vaadin-avatar-group-styles"});class AvatarGroup extends AvatarGroupMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get template(){return html$3`
      <div id="container" part="container">
        <slot></slot>
        <slot name="overflow"></slot>
      </div>
      <vaadin-avatar-group-overlay
        id="overlay"
        opened="{{_opened}}"
        position-target="[[_overflow]]"
        no-vertical-overlap
        on-vaadin-overlay-close="_onVaadinOverlayClose"
        on-vaadin-overlay-open="_onVaadinOverlayOpen"
      ></vaadin-avatar-group-overlay>
    `}static get is(){return"vaadin-avatar-group"}}defineCustomElement(AvatarGroup);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const CLASSES={SMALL:"small",MEDIUM:"medium",LARGE:"large"},BoardRowMixin=g=>class extends ResizeMixin(g){constructor(){super(),this._oldWidth=0,this._oldBreakpoints={smallSize:600,mediumSize:960},this._oldFlexBasis=[]}ready(){super.ready(),this.$.insertionPoint.addEventListener("slotchange",()=>this.redraw())}connectedCallback(){super.connectedCallback(),this._onResize()}_addStyleNames(a,u){a<u.smallSize?(this.classList.add(CLASSES.SMALL),this.classList.remove(CLASSES.MEDIUM),this.classList.remove(CLASSES.LARGE)):a<u.mediumSize?(this.classList.remove(CLASSES.SMALL),this.classList.add(CLASSES.MEDIUM),this.classList.remove(CLASSES.LARGE)):(this.classList.remove(CLASSES.SMALL),this.classList.remove(CLASSES.MEDIUM),this.classList.add(CLASSES.LARGE))}_calculateFlexBasis(a,u,v,x){u<x.smallSize?v=1:u<x.mediumSize&&v===4&&(v=2);let S=a/v*100;return S=S>100?100:S,`${S}%`}_reportError(){console.warn("The column configuration is not valid; column count should add up to 3 or 4.",`check: \r
${this.outerHTML}`)}_parseBoardCols(a){const u=a.map(S=>S.getAttribute("board-cols")?parseInt(S.getAttribute("board-cols")):1);let v=4,x=[];return a.forEach((S,T)=>{v-=u[T]}),v<0?(this._reportError(),u.forEach((S,T)=>{x[T]=1})):x=u.slice(0),x}_removeExtraNodesFromDOM(a,u){let v=!1,x=4;const S=[];return u.forEach((T,P)=>{x-=a[P],x<0?(v||(v=!0,this._reportError()),this.removeChild(T)):S[P]=T}),S}redraw(){this._recalculateFlexBasis(!0)}_onResize(){this._recalculateFlexBasis(!1)}_recalculateFlexBasis(a){const u=this.getBoundingClientRect().width,v=this._measureBreakpointsInPx();if(a||this._shouldRecalculate(u,v)){const S=this.$.insertionPoint.assignedNodes({flatten:!0}).filter(z=>z.nodeType===Node.ELEMENT_NODE);this._addStyleNames(u,v);const T=this._parseBoardCols(S),P=T.reduce((z,L)=>z+L,0);this._removeExtraNodesFromDOM(T,S).forEach((z,L)=>{const N=this._calculateFlexBasis(T[L],u,P,v);(a||!this._oldFlexBasis[L]||this._oldFlexBasis[L]!==N)&&(this._oldFlexBasis[L]=N,z.style.flexBasis=N)}),this._oldWidth=u,this._oldBreakpoints=v}}_shouldRecalculate(a,u){return isElementHidden(this)?!1:a!==this._oldWidth||u.smallSize!==this._oldBreakpoints.smallSize||u.mediumSize!==this._oldBreakpoints.mediumSize}_measureBreakpointsInPx(){const a={},u="background-position",v=getComputedStyle(this).getPropertyValue("--small-size"),x=getComputedStyle(this).getPropertyValue("--medium-size");return this.style.setProperty(u,v),a.smallSize=parseFloat(getComputedStyle(this).getPropertyValue(u)),this.style.setProperty(u,x),a.mediumSize=parseFloat(getComputedStyle(this).getPropertyValue(u)),this.style.removeProperty(u),a}};/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class BoardRow extends BoardRowMixin(ElementMixin(PolymerElement)){static get template(){return html$3`
      <style>
        :host {
          display: flex;
          flex-flow: row wrap;
          align-items: stretch;
          --small-size: var(--vaadin-board-width-small, 600px);
          --medium-size: var(--vaadin-board-width-medium, 960px);
        }

        :host([hidden]) {
          display: none !important;
        }

        :host ::slotted(*) {
          box-sizing: border-box;
          flex-grow: 1;
          overflow: hidden;
        }
      </style>
      <slot id="insertionPoint"></slot>
    `}static get is(){return"vaadin-board-row"}}defineCustomElement(BoardRow);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class Board extends ElementMixin(PolymerElement){static get template(){return html$3`
      <style>
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <slot></slot>
    `}static get is(){return"vaadin-board"}static get cvdlName(){return"vaadin-board"}redraw(){[...this.querySelectorAll("*")].filter(d=>d instanceof BoardRow).forEach(d=>d.redraw())}}defineCustomElement(Board);const cardProps=i`
  html {
    --vaadin-card-background: var(--lumo-contrast-5pct);
    --vaadin-card-border-radius: var(--lumo-border-radius-l);
    --vaadin-card-border-width: 0;
    --vaadin-card-border-color: var(--lumo-contrast-20pct);
    --vaadin-card-padding: var(--lumo-space-m);
    --vaadin-card-gap: var(--lumo-space-m);
    --vaadin-card-shadow: none;
  }
`;addGlobalThemeStyles("card-props",cardProps);const card=i`
  :host {
    background: var(--vaadin-card-background);
    border-radius: var(--vaadin-card-border-radius);
    box-shadow: var(--vaadin-card-shadow);
    position: relative;
  }

  /* Could be an inset outline on the host as well, but rounded outlines only work since Safari 16.4 */
  :host::before {
    content: '';
    position: absolute;
    inset: var(--_card-border-inset, 0);
    border-radius: var(--_card-border-pseudo-radius, inherit);
    border: var(--vaadin-card-border, var(--vaadin-card-border-width) solid var(--vaadin-card-border-color));
    pointer-events: none;
  }

  :host([theme~='outlined']) {
    --vaadin-card-border-width: 1px;
    --vaadin-card-background: var(--lumo-base-color);
  }

  :host([theme~='elevated']) {
    --vaadin-card-background: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct)) var(--lumo-base-color);
    --vaadin-card-shadow: var(--lumo-box-shadow-xs);
    --vaadin-card-border-width: 1px;
    --_card-border-inset: calc(-1 * var(--vaadin-card-border-width));
    --_card-border-pseudo-radius: calc(var(--vaadin-card-border-radius) + var(--vaadin-card-border-width));
  }

  :host([theme~='elevated']:not([theme~='outlined'])) {
    --vaadin-card-border-color: var(--lumo-contrast-10pct);
  }

  :host(:where([theme~='stretch-media'])) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    border-radius: var(--lumo-border-radius-m);
  }

  ::slotted([slot='title']) {
    font-size: var(--lumo-font-size-l);
    line-height: var(--lumo-line-height-xs);
    font-weight: 600;
    color: var(--lumo-header-text-color);
  }

  ::slotted([slot='subtitle']) {
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-xs);
    color: var(--lumo-secondary-text-color);
  }
`;registerStyles$1("vaadin-card",card,{moduleId:"lumo-card"});/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Card extends ElementMixin(ThemableMixin(PolylitMixin(i$1))){static get is(){return"vaadin-card"}static get styles(){return i`
      :host {
        display: flex;
        flex-direction: column;
        box-sizing: border-box;
        padding: var(--_padding);
        gap: var(--_gap);
        --_padding: var(--vaadin-card-padding, 1em);
        --_gap: var(--vaadin-card-gap, 1em);
        --_media: 0;
        --_title: 0;
        --_subtitle: 0;
        --_header: max(var(--_header-prefix), var(--_title), var(--_subtitle), var(--_header-suffix));
        --_header-prefix: 0;
        --_header-suffix: 0;
        --_content: 0;
        --_footer: 0;
      }

      :host([hidden]) {
        display: none !important;
      }

      :host(:not([theme~='horizontal'])) {
        justify-content: space-between;
      }

      :host([_m]) {
        --_media: 1;
      }

      :host([_t]) {
        --_title: 1;
      }

      :host([_st]) {
        --_subtitle: 1;
      }

      :host([_h]) {
        --_header: 1;
        --_title: 0;
        --_subtitle: 0;
      }

      :host([_hp]) {
        --_header-prefix: 1;
      }

      :host([_hs]) {
        --_header-suffix: 1;
      }

      :host([_c]) {
        --_content: 1;
      }

      :host([_f]) {
        --_footer: 1;
      }

      [part='media'],
      [part='header'],
      [part='content'],
      [part='footer'] {
        display: none;
      }

      :host([_m]) [part='media'],
      :host([_c]) [part='content'] {
        display: block;
      }

      :host([_f]) [part='footer'] {
        display: flex;
        gap: var(--_gap);
      }

      :host(:is([_h], [_t], [_st], [_hp], [_hs])) [part='header'] {
        display: grid;
        align-items: center;
        gap: var(--_gap);
        row-gap: 0;
      }

      [part='header'] {
        margin-bottom: auto;
      }

      :host([_hs]) [part='header'] {
        grid-template-columns: 1fr auto;
      }

      :host([_hp]) [part='header'] {
        grid-template-columns: repeat(var(--_header-prefix), auto) 1fr;
      }

      slot {
        border-radius: inherit;
      }

      ::slotted([slot='header-prefix']) {
        grid-column: 1;
        grid-row: 1 / span calc(var(--_title) + var(--_subtitle));
      }

      ::slotted([slot='header']),
      ::slotted([slot='title']) {
        grid-column: calc(1 + var(--_header-prefix));
        grid-row: 1;
      }

      ::slotted([slot='subtitle']) {
        grid-column: calc(1 + var(--_header-prefix));
        grid-row: calc(1 + var(--_title));
      }

      ::slotted([slot='header-suffix']) {
        grid-column: calc(2 + var(--_header-prefix));
        grid-row: 1 / span calc(var(--_title) + var(--_subtitle));
      }

      /* Horizontal */
      :host([theme~='horizontal']) {
        display: grid;
        grid-template-columns: repeat(var(--_media), minmax(auto, max-content)) 1fr;
        align-items: start;
      }

      :host([theme~='horizontal'][_f]) {
        grid-template-rows: 1fr auto;
      }

      :host([theme~='horizontal'][_c]) {
        grid-template-rows: repeat(var(--_header), auto) 1fr;
      }

      [part='media'] {
        grid-column: 1;
        grid-row: 1 / span calc(var(--_header) + var(--_content) + var(--_footer));
        align-self: stretch;
        border-radius: inherit;
      }

      [part='header'] {
        grid-column: calc(1 + var(--_media));
        grid-row: 1;
      }

      [part='content'] {
        grid-column: calc(1 + var(--_media));
        grid-row: calc(1 + var(--_header));
        flex: auto;
        min-height: 0;
      }

      [part='footer'] {
        grid-column: calc(1 + var(--_media));
        grid-row: calc(1 + var(--_header) + var(--_content));
        border-radius: inherit;
      }

      :host([theme~='horizontal']) [part='footer'] {
        align-self: end;
      }

      :host(:not([theme~='horizontal'])) ::slotted([slot='media']:is(img, video, svg)) {
        max-width: 100%;
      }

      ::slotted([slot='media']) {
        vertical-align: middle;
      }

      :host(:is([theme~='cover-media'], [theme~='stretch-media']))
        ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
        width: 100%;
        height: auto;
        aspect-ratio: var(--vaadin-card-media-aspect-ratio, 16/9);
        object-fit: cover;
        /* Fixes an issue where an icon overflows the card boundaries on Firefox: https://github.com/vaadin/web-components/issues/8641 */
        overflow: hidden;
      }

      :host([theme~='horizontal']:is([theme~='cover-media'], [theme~='stretch-media'])) {
        grid-template-columns: repeat(var(--_media), minmax(auto, 0.5fr)) 1fr;
      }

      :host([theme~='horizontal']:is([theme~='cover-media'], [theme~='stretch-media']))
        ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
        height: 100%;
        aspect-ratio: auto;
      }

      :host([theme~='cover-media']) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
        margin-top: calc(var(--_padding) * -1);
        margin-inline: calc(var(--_padding) * -1);
        width: calc(100% + var(--_padding) * 2);
        max-width: none;
        border-radius: inherit;
        border-end-end-radius: 0;
        border-end-start-radius: 0;
      }

      :host([theme~='horizontal'][theme~='cover-media']) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
        margin-inline-end: 0;
        width: calc(100% + var(--_padding));
        height: calc(100% + var(--_padding) * 2);
        border-radius: inherit;
        border-start-end-radius: 0;
        border-end-end-radius: 0;
      }

      /* Scroller in content */
      [part='content'] ::slotted(vaadin-scroller) {
        margin-inline: calc(var(--_padding) * -1);
        padding-inline: var(--_padding);
      }

      [part='content'] ::slotted(vaadin-scroller)::before,
      [part='content'] ::slotted(vaadin-scroller)::after {
        margin-inline: calc(var(--_padding) * -1);
      }
    `}static get properties(){return{cardTitle:{type:String,observer:"__cardTitleChanged"},titleHeadingLevel:{type:Number,reflectToAttribute:!0,observer:"__titleHeadingLevelChanged"}}}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","region")}render(){return b`
      <div part="media">
        <slot name="media"></slot>
      </div>
      <div part="header">
        <slot name="header-prefix"></slot>
        <slot name="header">
          <slot name="title"></slot>
          <slot name="subtitle"></slot>
        </slot>
        <slot name="header-suffix"></slot>
      </div>
      <div part="content">
        <slot></slot>
      </div>
      <div part="footer">
        <slot name="footer"></slot>
      </div>
    `}firstUpdated(){super.firstUpdated(),this._onSlotChange()}_onSlotChange(){this.toggleAttribute("_m",this.querySelector(':scope > [slot="media"]')),this.toggleAttribute("_h",this.querySelector(':scope > [slot="header"]')),this.toggleAttribute("_t",this.querySelector(':scope > [slot="title"]')&&!this.querySelector(':scope > [slot="header"]')),this.toggleAttribute("_st",this.querySelector(':scope > [slot="subtitle"]')&&!this.querySelector(':scope > [slot="header"]')),this.toggleAttribute("_hp",this.querySelector(':scope > [slot="header-prefix"]')),this.toggleAttribute("_hs",this.querySelector(':scope > [slot="header-suffix"]')),this.toggleAttribute("_c",this.querySelector(":scope > :not([slot])")),this.toggleAttribute("_f",this.querySelector(':scope > [slot="footer"]')),this.__getCustomTitleElement()&&this.__clearStringTitle()}__clearStringTitle(){const d=this.__getStringTitleElement();d&&this.removeChild(d);const a=this.getAttribute("aria-labelledby");a&&a.startsWith("card-title-")&&this.removeAttribute("aria-labelledby"),this.cardTitle&&(this.cardTitle="")}__getCustomTitleElement(){return Array.from(this.querySelectorAll('[slot="title"]')).find(d=>!d.hasAttribute("card-string-title"))}__cardTitleChanged(d){if(!d){this.__clearStringTitle();return}const a=this.__getCustomTitleElement();a&&this.removeChild(a);let u=this.__getStringTitleElement();u||(u=this.__createStringTitleElement(),this.appendChild(u),this.setAttribute("aria-labelledby",u.id)),u.textContent=d}__createStringTitleElement(){const d=document.createElement("div");return d.setAttribute("slot","title"),d.setAttribute("role","heading"),this.__setTitleHeadingLevel(d,this.titleHeadingLevel),d.setAttribute("card-string-title",""),d.id=`card-title-${generateUniqueId()}`,d}__titleHeadingLevelChanged(d){const a=this.__getStringTitleElement();a&&this.__setTitleHeadingLevel(a,d)}__setTitleHeadingLevel(d,a){d.setAttribute("aria-level",a||2)}__getStringTitleElement(){return this.querySelector('[slot="title"][card-string-title]')}createRenderRoot(){const d=super.createRenderRoot();return d.addEventListener("slotchange",()=>this._onSlotChange()),d}}defineCustomElement(Card);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const chartBaseTheme=i`
  :host {
    font-family: -apple-system, BlinkMacSystemFont, 'Roboto', 'Segoe UI', Helvetica, Arial, sans-serif,
      'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    font-size: 12px;
    line-height: normal;
  }

  .highcharts-container {
    position: relative;
    overflow: hidden;
    width: 100%;
    height: 100%;
    text-align: left;
    z-index: 0;
    /* #1072 */
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
  }

  :where([styled-mode]) .highcharts-root {
    display: block;
  }

  :where([styled-mode]) .highcharts-root text {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-strong {
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-emphasized {
    font-style: italic;
  }

  :where([styled-mode]) .highcharts-anchor {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-background {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-plot-border,
  :where([styled-mode]) .highcharts-plot-background {
    fill: none;
  }

  :where([styled-mode]) .highcharts-label-box {
    fill: none;
  }

  :where([styled-mode]) .highcharts-button-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-tracker-line {
    stroke-linejoin: round;
    stroke: rgba(192, 192, 192, 0.0001);
    stroke-width: 22;
    fill: none;
  }

  :where([styled-mode]) .highcharts-tracker-area {
    fill: rgba(192, 192, 192, 0.0001);
    stroke-width: 0;
  }

  /* Titles */
  :where([styled-mode]) .highcharts-title {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
    font-size: 1.5em;
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-subtitle {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Axes */
  :where([styled-mode]) .highcharts-axis-line {
    fill: none;
    stroke: var(--vaadin-charts-axis-line, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-axis-title {
    fill: var(--vaadin-charts-axis-title, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-axis-labels {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    cursor: default;
    font-size: 0.9em;
  }

  :where([styled-mode]) .highcharts-grid-line {
    fill: none;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-xaxis-grid .highcharts-grid-line {
    stroke-width: var(--vaadin-charts-xaxis-line-width, 0px);
  }

  :where([styled-mode]) .highcharts-tick {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-tick {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-minor-grid-line {
    stroke: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-crosshair-thin {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-crosshair-category {
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
    stroke-opacity: 0.25;
  }

  /* Credits */
  :where([styled-mode]) .highcharts-credits {
    cursor: pointer;
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
    font-size: 0.7em;
    transition:
      fill 250ms,
      font-size 250ms;
  }

  :where([styled-mode]) .highcharts-credits:hover {
    fill: black;
    font-size: 1em;
  }

  /* Tooltip */
  :where([styled-mode]) .highcharts-tooltip {
    cursor: default;
    pointer-events: none;
    white-space: nowrap;
    transition: stroke 150ms;
  }

  :where([styled-mode]) .highcharts-tooltip {
    filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.05)) !important;
  }

  :where([styled-mode]) .highcharts-tooltip text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-tooltip .highcharts-header {
    font-size: 0.85em;
    color: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-tooltip-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-tooltip-border, inherit);
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-box .highcharts-label-box {
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-header {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) div.highcharts-tooltip {
    filter: none;
  }

  :where([styled-mode]) .highcharts-selection-marker {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    fill-opacity: 0.25;
  }

  :where([styled-mode]) .highcharts-graph {
    fill: none;
    stroke-width: 2px;
    stroke-linecap: round;
    stroke-linejoin: round;
  }

  :where([styled-mode]) .highcharts-state-hover .highcharts-graph {
    stroke-width: 3;
  }

  :where([styled-mode]) .highcharts-point-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-series-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-hover path {
    transition: stroke-width 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-normal path {
    transition: stroke-width 250ms;
    /* slow out */
  }

  /* Legend hover affects points and series */
  :where([styled-mode]) g.highcharts-series,
  :where([styled-mode]) .highcharts-point,
  :where([styled-mode]) .highcharts-markers,
  :where([styled-mode]) .highcharts-data-labels {
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-legend-series-active g.highcharts-series:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-point-active .highcharts-point:not(.highcharts-point-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-markers:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-data-labels:not(.highcharts-series-hover) {
    opacity: 0.2;
  }

  /* Series options */
  /* Default colors */
  /* vaadin-charts custom properties */
  /* Use of :where() function to avoid setting classes with high specificity */
  :where([styled-mode]) .highcharts-color-0 {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
  }

  :where([styled-mode]) .highcharts-color-1 {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-color-2 {
    fill: var(--vaadin-charts-color-2, #ff7d94);
    stroke: var(--vaadin-charts-color-2, #ff7d94);
  }

  :where([styled-mode]) .highcharts-color-3 {
    fill: var(--vaadin-charts-color-3, #c5164e);
    stroke: var(--vaadin-charts-color-3, #c5164e);
  }

  :where([styled-mode]) .highcharts-color-4 {
    fill: var(--vaadin-charts-color-4, #15c15d);
    stroke: var(--vaadin-charts-color-4, #15c15d);
  }

  :where([styled-mode]) .highcharts-color-5 {
    fill: var(--vaadin-charts-color-5, #0e8151);
    stroke: var(--vaadin-charts-color-5, #0e8151);
  }

  :where([styled-mode]) .highcharts-color-6 {
    fill: var(--vaadin-charts-color-6, #c18ed2);
    stroke: var(--vaadin-charts-color-6, #c18ed2);
  }

  :where([styled-mode]) .highcharts-color-7 {
    fill: var(--vaadin-charts-color-7, #9233b3);
    stroke: var(--vaadin-charts-color-7, #9233b3);
  }

  :where([styled-mode]) .highcharts-color-8 {
    fill: var(--vaadin-charts-color-8, #fda253);
    stroke: var(--vaadin-charts-color-8, #fda253);
  }

  :where([styled-mode]) .highcharts-color-9 {
    fill: var(--vaadin-charts-color-9, #e24932);
    stroke: var(--vaadin-charts-color-9, #e24932);
  }

  /* end of vaadin-charts custom properties */

  :where([styled-mode]) .highcharts-area {
    fill-opacity: 0.5;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-markers {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode])
    .highcharts-a11y-markers-hidden
    .highcharts-point:not(.highcharts-point-hover):not(.highcharts-a11y-marker-visible),
  :where([styled-mode]) .highcharts-a11y-marker-hidden {
    opacity: 0;
  }

  :where([styled-mode]) .highcharts-point {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-dense-data .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label {
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-data-label-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label text,
  :where([styled-mode]) text.highcharts-data-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-data-label-connector {
    fill: none;
  }

  :where([styled-mode]) .highcharts-data-label-hidden {
    pointer-events: none;
  }

  :where([styled-mode]) .highcharts-halo {
    fill-opacity: 0.25;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-series:not(.highcharts-pie-series) .highcharts-point-select,
  :where([styled-mode]) .highcharts-markers .highcharts-point-select {
    fill: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-column-series rect.highcharts-point {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point {
    transition: fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-solidgauge-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point {
    stroke-width: 2px;
    stroke: var(--vaadin-charts-background, #fff);
    transition:
      stroke 250ms,
      fill 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point-hover {
    stroke-width: 0px;
    stroke: var(--vaadin-charts-background, #fff);
    fill-opacity: 0.75;
    transition:
      stroke 25ms,
      fill 25ms,
      fill-opacity 25ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-above-level {
    display: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node {
    fill: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive {
    fill-opacity: 0.15;
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive:hover {
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-vector-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-windbarb-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-lollipop-stem {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-focus-border {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-legend-item-hidden .highcharts-focus-border {
    fill: none !important;
  }

  /* Legend */
  :where([styled-mode]) .highcharts-legend-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-weight: normal;
    font-size: 1em;
    cursor: pointer;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > .highcharts-point {
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-legend-item:hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-legend-item-hidden * {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    stroke: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-legend-nav-active {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-legend-nav-inactive {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  :where([styled-mode]) circle.highcharts-legend-nav-active,
  :where([styled-mode]) circle.highcharts-legend-nav-inactive {
    /* tracker */
    fill: rgba(192, 192, 192, 0.0001);
  }

  :where([styled-mode]) .highcharts-legend-title-box {
    fill: none;
    stroke-width: 0;
  }

  /* Bubble legend */
  :where([styled-mode]) .highcharts-bubble-legend-symbol {
    stroke-width: 2;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-bubble-legend-connectors {
    stroke-width: 1;
  }

  :where([styled-mode]) .highcharts-bubble-legend-labels {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Loading */
  :where([styled-mode]) .highcharts-loading {
    position: absolute;
    background-color: var(--vaadin-charts-background, #fff);
    opacity: 0.5;
    text-align: center;
    z-index: 10;
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-loading-hidden {
    height: 0 !important;
    opacity: 0;
    overflow: hidden;
    transition:
      opacity 250ms,
      height 250ms step-end;
  }

  :where([styled-mode]) .highcharts-loading-inner {
    font-weight: normal;
    position: relative;
    top: 45%;
  }

  /* Plot bands and polar pane backgrounds */
  :where([styled-mode]) .highcharts-plot-band,
  :where([styled-mode]) .highcharts-pane {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-plot-line {
    fill: none;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-plot-line-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Highcharts More and modules */
  :where([styled-mode]) .highcharts-boxplot-box {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-boxplot-median {
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-bubble-series .highcharts-point {
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-errorbar-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-data-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-dial {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-polygon-series .highcharts-graph {
    fill: inherit;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-waterfall-series .highcharts-graph {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-dasharray: 1, 3;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-link {
    transition:
      fill 250ms,
      fill-opacity 250ms;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point-hover.highcharts-link {
    transition:
      fill 50ms,
      fill-opacity 50ms;
    fill-opacity: 1;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point {
    fill-opacity: 0.75;
    stroke: var(--vaadin-charts-background, #fff);
    transition:
      stroke 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point-hover {
    fill-opacity: 1;
    stroke: var(--vaadin-charts-background, #fff);
  }

  /* Highstock */
  :where([styled-mode]) .highcharts-navigator-mask-outside {
    fill-opacity: 0;
  }

  :where([styled-mode]) .highcharts-navigator-mask-inside {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    /* navigator.maskFill option */
    fill-opacity: 0.2;
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-outline {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: none;
  }

  :where([styled-mode]) .highcharts-navigator-handle {
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-series {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-graph {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-area {
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-grid-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-navigator-xaxis.highcharts-axis-labels {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-navigator-yaxis .highcharts-grid-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-scrollbar-thumb {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-scrollbar-button {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-scrollbar-arrow {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-scrollbar-rifles {
    stroke: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-scrollbar-track {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-button {
    fill: var(--vaadin-charts-button-background, hsla(214, 61%, 25%, 0.05));
    cursor: default;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-button text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-button-hover {
    transition: fill 0ms;
    fill: var(--vaadin-charts-button-hover-background, hsla(214, 90%, 52%, 0.1));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-button-hover text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed {
    fill: var(--vaadin-charts-button-active-background, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed text {
    fill: var(--vaadin-charts-button-active-label, #fff);
  }

  :where([styled-mode]) .highcharts-button-disabled text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons > text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons .highcharts-button {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-range-label rect {
    fill: none;
  }

  :where([styled-mode]) .highcharts-range-label text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-input rect {
    fill: var(--vaadin-charts-contrast-10pct, hsla(214, 57%, 24%, 0.1));
    rx: 2;
    ry: 2;
  }

  :where([styled-mode]) .highcharts-range-input:hover rect {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-range-input text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) input.highcharts-range-selector {
    position: absolute;
    border: 0;
    width: 1px;
    /* Chrome needs a pixel to see it */
    height: 1px;
    padding: 0;
    text-align: center;
    left: -9em;
    /* #4798 */
  }

  :where([styled-mode]) .highcharts-crosshair-label text {
    fill: var(--vaadin-charts-background, #fff);
    font-size: 1.1em;
  }

  :where([styled-mode]) .highcharts-crosshair-label .highcharts-label-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-up {
    fill: var(--vaadin-charts-color-positive, #15c15d);
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-down {
    fill: var(--vaadin-charts-color-negative, #e24932);
  }

  :where([styled-mode]) .highcharts-ohlc-series .highcharts-point-hover {
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point .highcharts-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover .highcharts-label-box {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  /* Highmaps */
  :where([styled-mode]) .highcharts-map-series .highcharts-point {
    transition:
      fill 500ms,
      fill-opacity 500ms,
      stroke-width 250ms;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-map-series .highcharts-point-hover {
    transition:
      fill 0ms,
      fill-opacity 0ms;
    fill-opacity: 0.5;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-mapline-series .highcharts-point {
    fill: none;
  }

  :where([styled-mode]) .highcharts-heatmap-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-map-navigation {
    font-size: 1.3em;
    font-weight: normal;
    text-align: center;
  }

  :where([styled-mode]) .highcharts-coloraxis {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-coloraxis-grid .highcharts-grid-line {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-coloraxis-marker {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-null-point {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* 3d charts */
  :where([styled-mode]) .highcharts-3d-frame {
    fill: transparent;
  }

  /* Exporting module */
  :where([styled-mode]) .highcharts-contextbutton {
    fill: #fff;
    /* needed to capture hover */
    stroke: none;
    stroke-linecap: round;
  }

  :where([styled-mode]) .highcharts-contextbutton:hover {
    fill: #e6e6e6;
    stroke: #e6e6e6;
  }

  :where([styled-mode]) .highcharts-button-symbol {
    stroke: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-menu {
    border: 1px solid #999;
    background: #fff;
    padding: 5px 0;
    box-shadow: 3px 3px 10px #888;
  }

  :where([styled-mode]) .highcharts-menu-item {
    padding: 0.5em 1em;
    background: none;
    color: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
    transition:
      background 250ms,
      color 250ms;
  }

  :where([styled-mode]) .highcharts-menu-item:hover {
    background: #335cad;
    color: #fff;
  }

  /* Drilldown module */
  :where([styled-mode]) .highcharts-drilldown-point {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-drilldown-data-label text,
  :where([styled-mode]) text.highcharts-drilldown-data-label,
  :where([styled-mode]) .highcharts-drilldown-axis-label {
    cursor: pointer;
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: normal;
    text-decoration: underline;
  }

  /* No-data module */
  :where([styled-mode]) .highcharts-no-data text {
    font-weight: normal;
    font-size: 1rem;
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Drag-panes module */
  :where([styled-mode]) .highcharts-axis-resizer {
    cursor: ns-resize;
    stroke: black;
    stroke-width: 2px;
  }

  /* Bullet type series */
  :where([styled-mode]) .highcharts-bullet-target {
    stroke-width: 0;
  }

  /* Lineargauge type series */
  :where([styled-mode]) .highcharts-lineargauge-target {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  :where([styled-mode]) .highcharts-lineargauge-target-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* Annotations module */
  :where([styled-mode]) .highcharts-annotation-label-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-annotation-label text {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  /* Gantt */
  :where([styled-mode]) .highcharts-treegrid-node-collapsed,
  :where([styled-mode]) .highcharts-treegrid-node-expanded {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-point-connecting-path {
    fill: none;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-tick {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-axis-line {
    stroke-width: 1px;
  }

  /* Workaround for https://github.com/highcharts/highcharts/issues/22490 */
  :where([styled-mode]) .highcharts-gantt-series .highcharts-partfill-overlay {
    fill: hsla(0, 0%, 0%, 0.3);
    stroke: hsla(0, 0%, 0%, 0.3);
  }

  /* RTL styles */
  :host([dir='rtl']) :where([styled-mode]) .highcharts-container {
    text-align: right;
  }

  :host([dir='rtl']) :where([styled-mode]) input.highcharts-range-selector {
    left: auto;
    right: -9em;
  }

  :host([dir='rtl']) :where([styled-mode]) .highcharts-menu {
    box-shadow: -3px 3px 10px #888;
  }

  /* https://github.com/highcharts/highcharts/issues/16282 */
  /* without this the resize callback always calls __reflow */
  ul[aria-hidden='false'] {
    margin: 0px;
  }
`;registerStyles$1("vaadin-chart",chartBaseTheme,{moduleId:"vaadin-chart-base-theme"});const chartColors=i`
  :host {
    --vaadin-charts-color-0: #5ac2f7;
    --vaadin-charts-color-1: #1676f3;
    --vaadin-charts-color-2: #ff7d94;
    --vaadin-charts-color-3: #c5164e;
    --vaadin-charts-color-4: #15c15d;
    --vaadin-charts-color-5: #0e8151;
    --vaadin-charts-color-6: #c18ed2;
    --vaadin-charts-color-7: #9233b3;
    --vaadin-charts-color-8: #fda253;
    --vaadin-charts-color-9: #e24932;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-4, #15c15d);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9, #e24932);
  }

  :host([theme~='gradient']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #13bbf0;
    --vaadin-charts-color-2: #1ee;
    --vaadin-charts-color-3: #0cd9bf;
    --vaadin-charts-color-4: #06be81;
    --vaadin-charts-color-5: #00a344;
    --vaadin-charts-color-6: #41c639;
    --vaadin-charts-color-7: #8aed2c;
    --vaadin-charts-color-8: #c0e632;
    --vaadin-charts-color-9: #f6db3a;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-6);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-1);
  }

  :host([theme~='monotone']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #4795f5;
    --vaadin-charts-color-2: #71b0f7;
    --vaadin-charts-color-3: #a0cef9;
    --vaadin-charts-color-4: #bce0fa;
    --vaadin-charts-color-5: #a8d8ed;
    --vaadin-charts-color-6: #7fc3dd;
    --vaadin-charts-color-7: #54adcc;
    --vaadin-charts-color-8: #2b99bc;
    --vaadin-charts-color-9: #0284ac;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-3);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9);
  }

  :host([theme~='classic']) {
    --vaadin-charts-color-0: #7cb5ec;
    --vaadin-charts-color-1: #434348;
    --vaadin-charts-color-2: #90ed7d;
    --vaadin-charts-color-3: #f7a35c;
    --vaadin-charts-color-4: #8085e9;
    --vaadin-charts-color-5: #f15c80;
    --vaadin-charts-color-6: #e4d354;
    --vaadin-charts-color-7: #2b908f;
    --vaadin-charts-color-8: #f45b5b;
    --vaadin-charts-color-9: #91e8e1;
  }
`,chartTheme=i`
  :host {
    --vaadin-charts-background: var(--lumo-base-color);
    --vaadin-charts-title-label: var(--lumo-header-text-color);
    --vaadin-charts-axis-title: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-label: var(--lumo-secondary-text-color);
    --vaadin-charts-data-label: var(--lumo-body-text-color);
    --vaadin-charts-secondary-label: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-line: var(--lumo-contrast-5pct);
    --vaadin-charts-grid-line: var(--lumo-contrast-20pct);
    --vaadin-charts-disabled-label: var(--lumo-disabled-text-color);
    --vaadin-charts-contrast: var(--lumo-contrast);
    --vaadin-charts-contrast-5pct: var(--lumo-contrast-5pct);
    --vaadin-charts-contrast-10pct: var(--lumo-contrast-10pct);
    --vaadin-charts-contrast-20pct: var(--lumo-contrast-20pct);
    --vaadin-charts-contrast-60pct: var(--lumo-contrast-60pct);
    --vaadin-charts-tooltip-background: var(--lumo-base-color);
    --vaadin-charts-tooltip-border-color: inherit;
    --vaadin-charts-button-label: var(--lumo-primary-text-color);
    --vaadin-charts-button-background: var(--lumo-contrast-5pct);
    --vaadin-charts-button-hover-background: var(--lumo-primary-color-10pct);
    --vaadin-charts-button-active-label: var(--lumo-primary-contrast-color);
    --vaadin-charts-button-active-background: var(--lumo-primary-color);
    --vaadin-charts-xaxis-line-width: 0;
    --vaadin-charts-tooltip-background-opacity: 1;
    font-family: var(--lumo-font-family);
  }
`;registerStyles$1("vaadin-chart",[chartColors,chartTheme],{moduleId:"lumo-chart"});function inflateFunctions(config){if(Array.isArray(config)){config.forEach(inflateFunctions);return}!(config instanceof Object)||config.constructor!==Object||Object.entries(config).forEach(([attr,targetProperty])=>{if(attr.startsWith("_fn_")&&(typeof targetProperty=="string"||targetProperty instanceof String)){try{config[attr.substr(4)]=eval(`(${targetProperty})`)}catch(_){config[attr.substr(4)]=eval(`(function(){${targetProperty}})`)}delete config[attr]}else targetProperty instanceof Object&&inflateFunctions(targetProperty)})}function deepMerge(g,d){const a=u=>u&&typeof u=="object"&&!Array.isArray(u);return a(d)&&a(g)&&Object.keys(d).forEach(u=>{a(d[u])?(g[u]||Object.assign(g,{[u]:{}}),deepMerge(g[u],d[u])):Object.assign(g,{[u]:d[u]})}),g}/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const ChartSeriesMixin=g=>class extends g{static get properties(){return{values:{type:Array,value:()=>[],sync:!0},valueMin:{type:Number,reflectToAttribute:!0,sync:!0},valueMax:{type:Number,reflectToAttribute:!0,sync:!0},type:{type:String,reflectToAttribute:!0,sync:!0},title:{type:String,reflectToAttribute:!0,sync:!0},markers:{type:String,reflectToAttribute:!0,sync:!0},unit:{type:String,reflectToAttribute:!0,sync:!0},stack:{type:String,reflectToAttribute:!0,sync:!0},neckPosition:{type:String,reflectToAttribute:!0,sync:!0},neckWidth:{type:String,reflectToAttribute:!0,sync:!0},options:{type:Object,sync:!0},additionalOptions:{type:Object,reflectToAttribute:!0,sync:!0},_series:{type:Object,sync:!0}}}static get observers(){return["__additionalOptionsObserver(additionalOptions, _series)","__markersObserver(markers, _series)","__neckPositionObserver(neckPosition, _series)","__neckWidthObserver(neckWidth, _series)","__stackObserver(stack, _series)","__titleObserver(title, _series)","__typeObserver(type, _series)","__unitObserver(unit, valueMin, valueMax, _series)","__valueMinObserver(valueMin, _series)","__valueMaxObserver(valueMax, _series)","__valuesObserver(values, _series)"]}get options(){const d=deepMerge({},this.additionalOptions);return this.type&&(d.type=this.type),this.title&&(d.name=this.title),this.values&&(d.data=this.values),this.markers&&(this.__isMarkersValid()||(this.markers="auto"),d.marker=this.__markersConfiguration),this.unit&&(d.yAxis=this.unit),this.stack&&(d.stack=this.stack),isFinite(this.valueMin)&&(d.yAxisValueMin=this.valueMin),isFinite(this.valueMax)&&(d.yAxisValueMax=this.valueMax),this.neckWidth&&(d.neckWidth=this.neckWidth),this.neckPosition&&(d.neckHeight=this.neckPosition),d}get __markersConfiguration(){const d={};switch(this.markers){case"shown":d.enabled=!0;break;case"hidden":d.enabled=!1;break;case"auto":default:d.enabled=null;break}return d}setSeries(d){this._series=d}__valuesObserver(d,a){a&&a.setData(d)}__additionalOptionsObserver(d,a){a&&d&&a.update(d)}__updateAxis(d,a,u){if(!isFinite(a)){this.__showWarn(`value-${u}`,"Numbers or null");return}d&&d.yAxis&&d.yAxis.update({[u]:a})}__valueMinObserver(d,a){d===void 0||a==null||this.__updateAxis(a,d,"min")}__valueMaxObserver(d,a){d===void 0||a==null||this.__updateAxis(a,d,"max")}__typeObserver(d,a){d&&a&&a.update({type:d})}__titleObserver(d,a){d===void 0||a==null||a.update({name:d})}__stackObserver(d,a){d===void 0||a==null||a.update({stack:d})}__neckPositionObserver(d,a){d===void 0||a==null||a.update({neckHeight:d})}__neckWidthObserver(d,a){d===void 0||a==null||a.update({neckWidth:d})}__unitObserver(d,a,u,v){if(v&&d!==this.__oldUnit){const x=customElements.get("vaadin-chart");this.__oldUnit=d;const S=this.parentNode instanceof x&&this.parentNode;if(S&&S instanceof x){if(d&&!S.__getAxis(d)){const T={title:{text:d}};S.__addAxis({id:d,axisGenerated:!0,...T})}v.update({yAxis:d||0}),a!==void 0&&this.__updateAxis(v,a,"min"),u!==void 0&&this.__updateAxis(v,u,"max"),S.__removeAxisIfEmpty()}}}__isMarkersValid(){return["shown","hidden","auto"].indexOf(this.markers)===-1?(this.__showWarn("markers",'"shown", "hidden" or "auto"'),!1):!0}__markersObserver(d,a){if(!(d===void 0||a==null)){if(!this.__isMarkersValid()){this.markers="auto";return}a.update({marker:this.__markersConfiguration})}}__showWarn(d,a){console.warn(`<vaadin-chart-series> Acceptable values for "${d}" are ${a}`)}};/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class ChartSeries extends ChartSeriesMixin(PolymerElement){static get is(){return"vaadin-chart-series"}}defineCustomElement(ChartSeries);var w=typeof win<"u"?win:typeof window<"u"?window:{},Globals;(function(g){g.SVG_NS="http://www.w3.org/2000/svg",g.product="Highcharts",g.version="9.2.2",g.win=w,g.doc=g.win.document,g.svg=g.doc&&g.doc.createElementNS&&!!g.doc.createElementNS(g.SVG_NS,"svg").createSVGRect,g.userAgent=g.win.navigator&&g.win.navigator.userAgent||"",g.isChrome=g.userAgent.indexOf("Chrome")!==-1,g.isFirefox=g.userAgent.indexOf("Firefox")!==-1,g.isMS=/(edge|msie|trident)/i.test(g.userAgent)&&!g.win.opera,g.isSafari=!g.isChrome&&g.userAgent.indexOf("Safari")!==-1,g.isTouchDevice=/(Mobile|Android|Windows Phone)/.test(g.userAgent),g.isWebKit=g.userAgent.indexOf("AppleWebKit")!==-1,g.deg2rad=Math.PI*2/360,g.hasBidiBug=g.isFirefox&&parseInt(g.userAgent.split("Firefox/")[1],10)<4,g.hasTouch=!!g.win.TouchEvent,g.marginNames=["plotTop","marginRight","marginBottom","plotLeft"],g.noop=function(){},g.supportsPassiveEvents=(function(){var d=!1;if(!g.isMS){var a=Object.defineProperty({},"passive",{get:function(){d=!0}});g.win.addEventListener&&g.win.removeEventListener&&(g.win.addEventListener("testPassive",g.noop,a),g.win.removeEventListener("testPassive",g.noop,a))}return d})(),g.charts=[],g.dateFormats={},g.seriesTypes={},g.symbolSizes={},g.chartCount=0})(Globals||(Globals={}));const H=Globals;var charts$5=H.charts,doc$m=H.doc,win$g=H.win;function error$c(g,d,a,u){var v=d?"Highcharts error":"Highcharts warning";g===32&&(g=v+": Deprecated member");var x=isNumber$X(g),S=x?v+" #"+g+": www.highcharts.com/errors/"+g+"/":g.toString(),T=function(){if(d)throw new Error(S);win$g.console&&error$c.messages.indexOf(S)===-1&&console.warn(S)};if(typeof u<"u"){var P="";x&&(S+="?"),objectEach$D(u,function(z,L){P+=`
 - `+L+": "+z,x&&(S+=encodeURI(L)+"="+encodeURI(z))}),S+=P}fireEvent$C(H,"displayError",{chart:a,code:g,message:S,params:u},T),error$c.messages.push(S)}(function(g){g.messages=[]})(error$c||(error$c={}));function merge$1x(){var g,d=arguments,a={},u=function(x,S){return typeof x!="object"&&(x={}),objectEach$D(S,function(T,P){P==="__proto__"||P==="constructor"||(isObject$i(T,!0)&&!isClass(T)&&!isDOMElement(T)?x[P]=u(x[P]||{},T):x[P]=S[P])}),x};d[0]===!0&&(a=d[1],d=Array.prototype.slice.call(d,2));var v=d.length;for(g=0;g<v;g++)a=u(a,d[g]);return a}function clamp$l(g,d,a){return g>d?g<a?g:a:d}function cleanRecursively$2(g,d){var a={};return objectEach$D(g,function(u,v){var x;isObject$i(g[v],!0)&&!g.nodeType&&d[v]?(x=cleanRecursively$2(g[v],d[v]),Object.keys(x).length&&(a[v]=x)):(isObject$i(g[v])||g[v]!==d[v])&&(a[v]=g[v])}),a}function pInt$a(g,d){return parseInt(g,d||10)}function isString$d(g){return typeof g=="string"}function isArray$q(g){var d=Object.prototype.toString.call(g);return d==="[object Array]"||d==="[object Array Iterator]"}function isObject$i(g,d){return!!g&&typeof g=="object"&&(!d||!isArray$q(g))}function isDOMElement(g){return isObject$i(g)&&typeof g.nodeType=="number"}function isClass(g){var d=g&&g.constructor;return!!(isObject$i(g,!0)&&!isDOMElement(g)&&d&&d.name&&d.name!=="Object")}function isNumber$X(g){return typeof g=="number"&&!isNaN(g)&&g<1/0&&g>-1/0}function erase$a(g,d){for(var a=g.length;a--;)if(g[a]===d){g.splice(a,1);break}}function defined$_(g){return typeof g<"u"&&g!==null}function attr$8(g,d,a){var u;return isString$d(d)?defined$_(a)?g.setAttribute(d,a):g&&g.getAttribute&&(u=g.getAttribute(d),!u&&d==="class"&&(u=g.getAttribute(d+"Name"))):objectEach$D(d,function(v,x){g.setAttribute(x,v)}),u}function splat$l(g){return isArray$q(g)?g:[g]}function syncTimeout$9(g,d,a){return d>0?setTimeout(g,d,a):(g.call(0,a),-1)}function internalClearTimeout(g){defined$_(g)&&clearTimeout(g)}function extend$1y(g,d){var a;g||(g={});for(a in d)g[a]=d[a];return g}function pick$1K(){for(var g=arguments,d=g.length,a=0;a<d;a++){var u=g[a];if(typeof u<"u"&&u!==null)return u}}function css$d(g,d){H.isMS&&!H.svg&&d&&typeof d.opacity<"u"&&(d.filter="alpha(opacity="+d.opacity*100+")"),extend$1y(g.style,d)}function createElement$b(g,d,a,u,v){var x=doc$m.createElement(g);return d&&extend$1y(x,d),v&&css$d(x,{padding:"0",border:"none",margin:"0"}),a&&css$d(x,a),u&&u.appendChild(x),x}function extendClass$2(g,d){var a=(function(){});return a.prototype=new g,extend$1y(a.prototype,d),a}function pad$2(g,d,a){return new Array((d||2)+1-String(g).replace("-","").length).join(a||"0")+g}function relativeLength$a(g,d,a){return/%$/.test(g)?d*parseFloat(g)/100+(a||0):parseFloat(g)}function wrap$h(g,d,a){var u=g[d];g[d]=function(){var v=Array.prototype.slice.call(arguments),x=arguments,S=this;S.proceed=function(){u.apply(S,arguments.length?arguments:x)},v.unshift(u);var T=a.apply(this,v);return S.proceed=null,T}}function getMagnitude$3(g){return Math.pow(10,Math.floor(Math.log(g)/Math.LN10))}function normalizeTickInterval$3(g,d,a,u,v){var x,S=g;a=pick$1K(a,1);var T=g/a;for(d||(d=v?[1,1.2,1.5,2,2.5,3,4,5,6,8,10]:[1,2,2.5,5,10],u===!1&&(a===1?d=d.filter(function(P){return P%1===0}):a<=.1&&(d=[1/a]))),x=0;x<d.length&&(S=d[x],!(v&&S*a>=g||!v&&T<=(d[x]+(d[x+1]||d[x]))/2));x++);return S=correctFloat$d(S*a,-Math.round(Math.log(.001)/Math.LN10)),S}function stableSort$7(g,d){var a=g.length,u,v;for(v=0;v<a;v++)g[v].safeI=v;for(g.sort(function(x,S){return u=d(x,S),u===0?x.safeI-S.safeI:u}),v=0;v<a;v++)delete g[v].safeI}function arrayMin$9(g){for(var d=g.length,a=g[0];d--;)g[d]<a&&(a=g[d]);return a}function arrayMax$a(g){for(var d=g.length,a=g[0];d--;)g[d]>a&&(a=g[d]);return a}function destroyObjectProperties$a(g,d){objectEach$D(g,function(a,u){a&&a!==d&&a.destroy&&a.destroy(),delete g[u]})}function discardElement$7(g){garbageBin||(garbageBin=createElement$b("div")),g&&garbageBin.appendChild(g),garbageBin.innerHTML=""}var garbageBin;function correctFloat$d(g,d){return parseFloat(g.toPrecision(d||14))}var timeUnits$4={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:24*36e5,week:168*36e5,month:672*36e5,year:364*24*36e5};Math.easeInOutSine=function(g){return-.5*(Math.cos(Math.PI*g)-1)};function getNestedProperty$3(g,d){for(var a=g.split(".");a.length&&defined$_(d);){var u=a.shift();if(typeof u>"u"||u==="__proto__")return;var v=d[u];if(!defined$_(v)||typeof v=="function"||typeof v.nodeType=="number"||v===win$g)return;d=v}return d}function getStyle$2(g,d,a){var u=H.getStyle||getStyle$2,v;if(d==="width"){var x=Math.min(g.offsetWidth,g.scrollWidth),S=g.getBoundingClientRect&&g.getBoundingClientRect().width;return S<x&&S>=x-1&&(x=Math.floor(S)),Math.max(0,x-(u(g,"padding-left",!0)||0)-(u(g,"padding-right",!0)||0))}if(d==="height")return Math.max(0,Math.min(g.offsetHeight,g.scrollHeight)-(u(g,"padding-top",!0)||0)-(u(g,"padding-bottom",!0)||0));win$g.getComputedStyle||error$c(27,!0);var T=win$g.getComputedStyle(g,void 0);return T&&(v=T.getPropertyValue(d),pick$1K(a,d!=="opacity")&&(v=pInt$a(v))),v}function inArray(g,d,a){return error$c(32,!1,void 0,{"Highcharts.inArray":"use Array.indexOf"}),d.indexOf(g,a)}var find$l=Array.prototype.find?function(g,d){return g.find(d)}:(function(g,d){var a,u=g.length;for(a=0;a<u;a++)if(d(g[a],a))return g[a]});function keys(g){return error$c(32,!1,void 0,{"Highcharts.keys":"use Object.keys"}),Object.keys(g)}function offset$1(g){var d=doc$m.documentElement,a=g.parentElement||g.parentNode?g.getBoundingClientRect():{top:0,left:0,width:0,height:0};return{top:a.top+(win$g.pageYOffset||d.scrollTop)-(d.clientTop||0),left:a.left+(win$g.pageXOffset||d.scrollLeft)-(d.clientLeft||0),width:a.width,height:a.height}}function objectEach$D(g,d,a){for(var u in g)Object.hasOwnProperty.call(g,u)&&d.call(a||g[u],g[u],u,g)}objectEach$D({map:"map",each:"forEach",grep:"filter",reduce:"reduce",some:"some"},function(g,d){H[d]=function(a){var u;return error$c(32,!1,void 0,(u={},u["Highcharts."+d]="use Array."+g,u)),Array.prototype[g].apply(a,[].slice.call(arguments,1))}});function addEvent$19(g,d,a,u){u===void 0&&(u={});var v=typeof g=="function"&&g.prototype||g;Object.hasOwnProperty.call(v,"hcEvents")||(v.hcEvents={});var x=v.hcEvents;H.Point&&g instanceof H.Point&&g.series&&g.series.chart&&(g.series.chart.runTrackerClick=!0);var S=g.addEventListener||H.addEventListenerPolyfill;S&&S.call(g,d,a,H.supportsPassiveEvents?{passive:u.passive===void 0?d.indexOf("touch")!==-1:u.passive,capture:!1}:!1),x[d]||(x[d]=[]);var T={fn:a,order:typeof u.order=="number"?u.order:1/0};return x[d].push(T),x[d].sort(function(P,z){return P.order-z.order}),function(){removeEvent$c(g,d,a)}}function removeEvent$c(g,d,a){function u(P,z){var L=g.removeEventListener||H.removeEventListenerPolyfill;L&&L.call(g,P,z,!1)}function v(P){var z,L;g.nodeName&&(d?(z={},z[d]=!0):z=P,objectEach$D(z,function(N,$){if(P[$])for(L=P[$].length;L--;)u($,P[$][L].fn)}))}var x=typeof g=="function"&&g.prototype||g;if(Object.hasOwnProperty.call(x,"hcEvents")){var S=x.hcEvents;if(d){var T=S[d]||[];a?(S[d]=T.filter(function(P){return a!==P.fn}),u(d,a)):(v(S),S[d]=[])}else v(S),delete x.hcEvents}}function fireEvent$C(g,d,a,u){var v;if(a=a||{},doc$m.createEvent&&(g.dispatchEvent||g.fireEvent&&g!==H))v=doc$m.createEvent("Events"),v.initEvent(d,!0,!0),a=extend$1y(v,a),g.dispatchEvent?g.dispatchEvent(a):g.fireEvent(d,a);else if(g.hcEvents){a.target||extend$1y(a,{preventDefault:function(){a.defaultPrevented=!0},target:g,type:d});for(var x=[],S=g,T=!1;S.hcEvents;)Object.hasOwnProperty.call(S,"hcEvents")&&S.hcEvents[d]&&(x.length&&(T=!0),x.unshift.apply(x,S.hcEvents[d])),S=Object.getPrototypeOf(S);T&&x.sort(function(P,z){return P.order-z.order}),x.forEach(function(P){P.fn.call(g,a)===!1&&a.preventDefault()})}u&&!a.defaultPrevented&&u.call(g,a)}var serialMode,uniqueKey$8=(function(){var g=Math.random().toString(36).substring(2,9)+"-",d=0;return function(){return"highcharts-"+(serialMode?"":g)+d++}})();function useSerialIds(g){return serialMode=pick$1K(g,serialMode)}function isFunction$5(g){return typeof g=="function"}win$g.jQuery&&(win$g.jQuery.fn.highcharts=function(){var g=[].slice.call(arguments);if(this[0])return g[0]?(new H[isString$d(g[0])?g.shift():"Chart"](this[0],g[0],g[1]),this):charts$5[attr$8(this[0],"data-highcharts-chart")]});var Utilities={addEvent:addEvent$19,arrayMax:arrayMax$a,arrayMin:arrayMin$9,attr:attr$8,clamp:clamp$l,cleanRecursively:cleanRecursively$2,clearTimeout:internalClearTimeout,correctFloat:correctFloat$d,createElement:createElement$b,css:css$d,defined:defined$_,destroyObjectProperties:destroyObjectProperties$a,discardElement:discardElement$7,erase:erase$a,error:error$c,extend:extend$1y,extendClass:extendClass$2,find:find$l,fireEvent:fireEvent$C,getMagnitude:getMagnitude$3,getNestedProperty:getNestedProperty$3,getStyle:getStyle$2,inArray,isArray:isArray$q,isClass,isDOMElement,isFunction:isFunction$5,isNumber:isNumber$X,isObject:isObject$i,isString:isString$d,keys,merge:merge$1x,normalizeTickInterval:normalizeTickInterval$3,objectEach:objectEach$D,offset:offset$1,pad:pad$2,pick:pick$1K,pInt:pInt$a,relativeLength:relativeLength$a,removeEvent:removeEvent$c,splat:splat$l,stableSort:stableSort$7,syncTimeout:syncTimeout$9,timeUnits:timeUnits$4,uniqueKey:uniqueKey$8,useSerialIds,wrap:wrap$h},palette={colors:["#7cb5ec","#434348","#90ed7d","#f7a35c","#8085e9","#f15c80","#e4d354","#2b908f","#f45b5b","#91e8e1"],backgroundColor:"#ffffff",neutralColor100:"#000000",neutralColor80:"#333333",neutralColor60:"#666666",neutralColor40:"#999999",neutralColor20:"#cccccc",neutralColor10:"#e6e6e6",neutralColor5:"#f2f2f2",neutralColor3:"#f7f7f7",highlightColor100:"#003399",highlightColor80:"#335cad",highlightColor60:"#6685c2",highlightColor20:"#ccd6eb",highlightColor10:"#e6ebf5"},ChartDefaults={panning:{enabled:!1,type:"x"},styledMode:!1,borderRadius:0,colorCount:10,defaultSeriesType:"line",ignoreHiddenSeries:!0,spacing:[10,10,15,10],resetZoomButton:{theme:{zIndex:6},position:{align:"right",x:-10,y:10}},zoomBySingleTouch:!1,width:null,height:null,borderColor:palette.highlightColor80,backgroundColor:palette.backgroundColor,plotBorderColor:palette.neutralColor20},isNumber$W=Utilities.isNumber,merge$1w=Utilities.merge,pInt$9=Utilities.pInt,Color=(function(){function g(d){this.rgba=[NaN,NaN,NaN,NaN],this.input=d;var a=H.Color;if(a&&a!==g)return new a(d);if(!(this instanceof g))return new g(d);this.init(d)}return g.parse=function(d){return d?new g(d):g.None},g.prototype.init=function(d){var a,u,v,x;if(typeof d=="object"&&typeof d.stops<"u")this.stops=d.stops.map(function(P){return new g(P[1])});else if(typeof d=="string"){if(this.input=d=g.names[d.toLowerCase()]||d,d.charAt(0)==="#"){var S=d.length,T=parseInt(d.substr(1),16);S===7?u=[(T&16711680)>>16,(T&65280)>>8,T&255,1]:S===4&&(u=[(T&3840)>>4|(T&3840)>>8,(T&240)>>4|T&240,(T&15)<<4|T&15,1])}if(!u)for(v=g.parsers.length;v--&&!u;)x=g.parsers[v],a=x.regex.exec(d),a&&(u=x.parse(a))}u&&(this.rgba=u)},g.prototype.get=function(d){var a=this.input,u=this.rgba;if(typeof a=="object"&&typeof this.stops<"u"){var v=merge$1w(a);return v.stops=[].slice.call(v.stops),this.stops.forEach(function(x,S){v.stops[S]=[v.stops[S][0],x.get(d)]}),v}return u&&isNumber$W(u[0])?d==="rgb"||!d&&u[3]===1?"rgb("+u[0]+","+u[1]+","+u[2]+")":d==="a"?""+u[3]:"rgba("+u.join(",")+")":a},g.prototype.brighten=function(d){var a=this.rgba;if(this.stops)this.stops.forEach(function(v){v.brighten(d)});else if(isNumber$W(d)&&d!==0)for(var u=0;u<3;u++)a[u]+=pInt$9(d*255),a[u]<0&&(a[u]=0),a[u]>255&&(a[u]=255);return this},g.prototype.setOpacity=function(d){return this.rgba[3]=d,this},g.prototype.tweenTo=function(d,a){var u=this.rgba,v=d.rgba;if(!isNumber$W(u[0])||!isNumber$W(v[0]))return d.input||"none";var x=v[3]!==1||u[3]!==1;return(x?"rgba(":"rgb(")+Math.round(v[0]+(u[0]-v[0])*(1-a))+","+Math.round(v[1]+(u[1]-v[1])*(1-a))+","+Math.round(v[2]+(u[2]-v[2])*(1-a))+(x?","+(v[3]+(u[3]-v[3])*(1-a)):"")+")"},g.names={white:"#ffffff",black:"#000000"},g.parsers=[{regex:/rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]?(?:\.[0-9]+)?)\s*\)/,parse:function(d){return[pInt$9(d[1]),pInt$9(d[2]),pInt$9(d[3]),parseFloat(d[4],10)]}},{regex:/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/,parse:function(d){return[pInt$9(d[1]),pInt$9(d[2]),pInt$9(d[3]),1]}}],g.None=new g(""),g})(),win$f=H.win,defined$Z=Utilities.defined,error$b=Utilities.error,extend$1x=Utilities.extend,isObject$h=Utilities.isObject,merge$1v=Utilities.merge,objectEach$C=Utilities.objectEach,pad$1=Utilities.pad,pick$1J=Utilities.pick,splat$k=Utilities.splat,timeUnits$3=Utilities.timeUnits,hasNewSafariBug=H.isSafari&&win$f.Intl&&win$f.Intl.DateTimeFormat.prototype.formatRange,hasOldSafariBug=H.isSafari&&win$f.Intl&&!win$f.Intl.DateTimeFormat.prototype.formatRange,Time=(function(){function g(d){this.options={},this.useUTC=!1,this.variableTimezone=!1,this.Date=win$f.Date,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.update(d)}return g.prototype.get=function(d,a){if(this.variableTimezone||this.timezoneOffset){var u=a.getTime(),v=u-this.getTimezoneOffset(a);a.setTime(v);var x=a["getUTC"+d]();return a.setTime(u),x}return this.useUTC?a["getUTC"+d]():a["get"+d]()},g.prototype.set=function(d,a,u){if(this.variableTimezone||this.timezoneOffset){if(d==="Milliseconds"||d==="Seconds"||d==="Minutes"&&this.getTimezoneOffset(a)%36e5===0)return a["setUTC"+d](u);var v=this.getTimezoneOffset(a),x=a.getTime()-v;a.setTime(x),a["setUTC"+d](u);var S=this.getTimezoneOffset(a);return x=a.getTime()+S,a.setTime(x)}return this.useUTC||hasNewSafariBug&&d==="FullYear"?a["setUTC"+d](u):a["set"+d](u)},g.prototype.update=function(d){var a=pick$1J(d&&d.useUTC,!0);this.options=d=merge$1v(!0,this.options||{},d),this.Date=d.Date||win$f.Date||Date,this.useUTC=a,this.timezoneOffset=a&&d.timezoneOffset,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.variableTimezone=a&&!!(d.getTimezoneOffset||d.timezone)},g.prototype.makeTime=function(d,a,u,v,x,S){var T,P,z;return this.useUTC?(T=this.Date.UTC.apply(0,arguments),P=this.getTimezoneOffset(T),T+=P,z=this.getTimezoneOffset(T),P!==z?T+=z-P:P-36e5===this.getTimezoneOffset(T-36e5)&&!hasOldSafariBug&&(T-=36e5)):T=new this.Date(d,a,pick$1J(u,1),pick$1J(v,0),pick$1J(x,0),pick$1J(S,0)).getTime(),T},g.prototype.timezoneOffsetFunction=function(){var d=this,a=this.options,u=a.moment||win$f.moment;if(!this.useUTC)return function(v){return new Date(v.toString()).getTimezoneOffset()*6e4};if(a.timezone)if(!u)error$b(25);else return function(v){return-u.tz(v,a.timezone).utcOffset()*6e4};return this.useUTC&&a.getTimezoneOffset?function(v){return a.getTimezoneOffset(v.valueOf())*6e4}:function(){return(d.timezoneOffset||0)*6e4}},g.prototype.dateFormat=function(d,a,u){if(!defined$Z(a)||isNaN(a))return H.defaultOptions.lang&&H.defaultOptions.lang.invalidDate||"";d=pick$1J(d,"%Y-%m-%d %H:%M:%S");var v=this,x=new this.Date(a),S=this.get("Hours",x),T=this.get("Day",x),P=this.get("Date",x),z=this.get("Month",x),L=this.get("FullYear",x),N=H.defaultOptions.lang,$=N&&N.weekdays,B=N&&N.shortWeekdays,U=extend$1x({a:B?B[T]:$[T].substr(0,3),A:$[T],d:pad$1(P),e:pad$1(P,2," "),w:T,b:N.shortMonths[z],B:N.months[z],m:pad$1(z+1),o:z+1,y:L.toString().substr(2,2),Y:L,H:pad$1(S),k:S,I:pad$1(S%12||12),l:S%12||12,M:pad$1(this.get("Minutes",x)),p:S<12?"AM":"PM",P:S<12?"am":"pm",S:pad$1(x.getSeconds()),L:pad$1(Math.floor(a%1e3),3)},H.dateFormats);return objectEach$C(U,function(j,Y){for(;d.indexOf("%"+Y)!==-1;)d=d.replace("%"+Y,typeof j=="function"?j.call(v,a):j)}),u?d.substr(0,1).toUpperCase()+d.substr(1):d},g.prototype.resolveDTLFormat=function(d){return isObject$h(d,!0)?d:(d=splat$k(d),{main:d[0],from:d[1],to:d[2]})},g.prototype.getTimeTicks=function(d,a,u,v){var x=this,S=x.Date,T=[],P={},z=new S(a),L=d.unitRange,N=d.count||1,$,B,U,j;if(v=pick$1J(v,1),defined$Z(a)){x.set("Milliseconds",z,L>=timeUnits$3.second?0:N*Math.floor(x.get("Milliseconds",z)/N)),L>=timeUnits$3.second&&x.set("Seconds",z,L>=timeUnits$3.minute?0:N*Math.floor(x.get("Seconds",z)/N)),L>=timeUnits$3.minute&&x.set("Minutes",z,L>=timeUnits$3.hour?0:N*Math.floor(x.get("Minutes",z)/N)),L>=timeUnits$3.hour&&x.set("Hours",z,L>=timeUnits$3.day?0:N*Math.floor(x.get("Hours",z)/N)),L>=timeUnits$3.day&&x.set("Date",z,L>=timeUnits$3.month?1:Math.max(1,N*Math.floor(x.get("Date",z)/N))),L>=timeUnits$3.month&&(x.set("Month",z,L>=timeUnits$3.year?0:N*Math.floor(x.get("Month",z)/N)),B=x.get("FullYear",z)),L>=timeUnits$3.year&&(B-=B%N,x.set("FullYear",z,B)),L===timeUnits$3.week&&(j=x.get("Day",z),x.set("Date",z,x.get("Date",z)-j+v+(j<v?-7:0))),B=x.get("FullYear",z);var Y=x.get("Month",z),q=x.get("Date",z),Q=x.get("Hours",z);a=z.getTime(),(x.variableTimezone||!x.useUTC)&&defined$Z(u)&&(U=u-a>4*timeUnits$3.month||x.getTimezoneOffset(a)!==x.getTimezoneOffset(u));var J=z.getTime();for($=1;J<u;)T.push(J),L===timeUnits$3.year?J=x.makeTime(B+$*N,0):L===timeUnits$3.month?J=x.makeTime(B,Y+$*N):U&&(L===timeUnits$3.day||L===timeUnits$3.week)?J=x.makeTime(B,Y,q+$*N*(L===timeUnits$3.day?1:7)):U&&L===timeUnits$3.hour&&N>1?J=x.makeTime(B,Y,q,Q+$*N):J+=L*N,$++;T.push(J),L<=timeUnits$3.hour&&T.length<1e4&&T.forEach(function(ee){ee%18e5===0&&x.dateFormat("%H%M%S%L",ee)==="000000000"&&(P[ee]="day")})}return T.info=extend$1x(d,{higherRanks:P,totalRange:L*N}),T},g.prototype.getDateFormat=function(d,a,u,v){var x=this.dateFormat("%m-%d %H:%M:%S.%L",a),S="01-01 00:00:00.000",T={millisecond:15,second:12,minute:9,hour:6,day:3},P,z,L="millisecond";for(z in timeUnits$3){if(d===timeUnits$3.week&&+this.dateFormat("%w",a)===u&&x.substr(6)===S.substr(6)){z="week";break}if(timeUnits$3[z]>d){z=L;break}if(T[z]&&x.substr(T[z])!==S.substr(T[z]))break;z!=="week"&&(L=z)}return z&&(P=this.resolveDTLFormat(v[z]).main),P},g})(),color$g=Color.parse,isTouchDevice$4=H.isTouchDevice,svg$7=H.svg,merge$1u=Utilities.merge,defaultOptions$j={colors:palette.colors,symbols:["circle","diamond","square","triangle","triangle-down"],lang:{loading:"Loading...",months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],decimalPoint:".",numericSymbols:["k","M","G","T","P","E"],resetZoom:"Reset zoom",resetZoomTitle:"Reset zoom level 1:1",thousandsSep:" "},global:{},time:{Date:void 0,getTimezoneOffset:void 0,timezone:void 0,timezoneOffset:0,useUTC:!0},chart:ChartDefaults,title:{text:"Chart title",align:"center",margin:15,widthAdjust:-44},subtitle:{text:"",align:"center",widthAdjust:-44},caption:{margin:15,text:"",align:"left",verticalAlign:"bottom"},plotOptions:{},labels:{style:{position:"absolute",color:palette.neutralColor80}},legend:{enabled:!0,align:"center",alignColumns:!0,className:"highcharts-no-tooltip",layout:"horizontal",labelFormatter:function(){return this.name},borderColor:palette.neutralColor40,borderRadius:0,navigation:{activeColor:palette.highlightColor100,inactiveColor:palette.neutralColor20},itemStyle:{color:palette.neutralColor80,cursor:"pointer",fontSize:"12px",fontWeight:"bold",textOverflow:"ellipsis"},itemHoverStyle:{color:palette.neutralColor100},itemHiddenStyle:{color:palette.neutralColor20},shadow:!1,itemCheckboxStyle:{position:"absolute",width:"13px",height:"13px"},squareSymbol:!0,symbolPadding:5,verticalAlign:"bottom",x:0,y:0,title:{style:{fontWeight:"bold"}}},loading:{labelStyle:{fontWeight:"bold",position:"relative",top:"45%"},style:{position:"absolute",backgroundColor:palette.backgroundColor,opacity:.5,textAlign:"center"}},tooltip:{enabled:!0,animation:svg$7,borderRadius:3,dateTimeLabelFormats:{millisecond:"%A, %b %e, %H:%M:%S.%L",second:"%A, %b %e, %H:%M:%S",minute:"%A, %b %e, %H:%M",hour:"%A, %b %e, %H:%M",day:"%A, %b %e, %Y",week:"Week from %A, %b %e, %Y",month:"%B %Y",year:"%Y"},footerFormat:"",headerShape:"callout",hideDelay:500,padding:8,shape:"callout",shared:!1,snap:isTouchDevice$4?25:10,headerFormat:'<span style="font-size: 10px">{point.key}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.y}</b><br/>',backgroundColor:color$g(palette.neutralColor3).setOpacity(.85).get(),borderWidth:1,shadow:!0,stickOnContact:!1,style:{color:palette.neutralColor80,cursor:"default",fontSize:"12px",whiteSpace:"nowrap"},useHTML:!1},credits:{enabled:!0,href:"https://www.highcharts.com?credits",position:{align:"right",x:-10,verticalAlign:"bottom",y:-5},style:{cursor:"pointer",color:palette.neutralColor40,fontSize:"9px"},text:"Highcharts.com"}};defaultOptions$j.chart.styledMode=!1;var defaultTime$2=new Time(merge$1u(defaultOptions$j.global,defaultOptions$j.time));function getOptions$4(){return defaultOptions$j}function setOptions$2(g){return merge$1u(!0,defaultOptions$j,g),(g.time||g.global)&&(H.time?H.time.update(merge$1u(defaultOptions$j.global,defaultOptions$j.time,g.global,g.time)):H.time=defaultTime$2),defaultOptions$j}var DefaultOptions={defaultOptions:defaultOptions$j,defaultTime:defaultTime$2,getOptions:getOptions$4,setOptions:setOptions$2},color$f=Color.parse,win$e=H.win,isNumber$V=Utilities.isNumber,objectEach$B=Utilities.objectEach,Fx=(function(){function g(d,a,u){this.pos=NaN,this.options=a,this.elem=d,this.prop=u}return g.prototype.dSetter=function(){var d=this.paths,a=d&&d[0],u=d&&d[1],v=this.now||0,x=[];if(v===1||!a||!u)x=this.toD||[];else if(a.length===u.length&&v<1)for(var S=0;S<u.length;S++){for(var T=a[S],P=u[S],z=[],L=0;L<P.length;L++){var N=T[L],$=P[L];isNumber$V(N)&&isNumber$V($)&&!(P[0]==="A"&&(L===4||L===5))?z[L]=N+v*($-N):z[L]=$}x.push(z)}else x=u;this.elem.attr("d",x,void 0,!0)},g.prototype.update=function(){var d=this.elem,a=this.prop,u=this.now,v=this.options.step;this[a+"Setter"]?this[a+"Setter"]():d.attr?d.element&&d.attr(a,u,null,!0):d.style[a]=u+this.unit,v&&v.call(d,u,this)},g.prototype.run=function(d,a,u){var v=this,x=v.options,S=function(z){return S.stopped?!1:v.step(z)},T=win$e.requestAnimationFrame||function(z){setTimeout(z,13)},P=function(){for(var z=0;z<g.timers.length;z++)g.timers[z]()||g.timers.splice(z--,1);g.timers.length&&T(P)};d===a&&!this.elem["forceAnimate:"+this.prop]?(delete x.curAnim[this.prop],x.complete&&Object.keys(x.curAnim).length===0&&x.complete.call(this.elem)):(this.startTime=+new Date,this.start=d,this.end=a,this.unit=u,this.now=this.start,this.pos=0,S.elem=this.elem,S.prop=this.prop,S()&&g.timers.push(S)===1&&T(P))},g.prototype.step=function(d){var a=+new Date,u=this.options,v=this.elem,x=u.complete,S=u.duration,T=u.curAnim,P,z;return v.attr&&!v.element?P=!1:d||a>=S+this.startTime?(this.now=this.end,this.pos=1,this.update(),T[this.prop]=!0,z=!0,objectEach$B(T,function(L){L!==!0&&(z=!1)}),z&&x&&x.call(v),P=!1):(this.pos=u.easing((a-this.startTime)/S),this.now=this.start+(this.end-this.start)*this.pos,this.update(),P=!0),P},g.prototype.initPath=function(d,a,u){var v=d.startX,x=d.endX,S=u.slice(),T=d.isArea,P=T?2:1,z,L,N,$,B=a&&a.slice();if(!B)return[S,S];function U(Y,q){for(;Y.length<L;){var Q=Y[0],J=q[L-Y.length];if(J&&Q[0]==="M"&&(J[0]==="C"?Y[0]=["C",Q[1],Q[2],Q[1],Q[2],Q[1],Q[2]]:Y[0]=["L",Q[1],Q[2]]),Y.unshift(Q),T){var ee=Y.pop();Y.push(Y[Y.length-1],ee)}}}function j(Y,q){for(;Y.length<L;){var Q=Y[Math.floor(Y.length/P)-1].slice();if(Q[0]==="C"&&(Q[1]=Q[5],Q[2]=Q[6]),!T)Y.push(Q);else{var J=Y[Math.floor(Y.length/P)].slice();Y.splice(Y.length/2,0,Q,J)}}}if(v&&x&&x.length){for(N=0;N<v.length;N++)if(v[N]===x[0]){z=N;break}else if(v[0]===x[x.length-v.length+N]){z=N,$=!0;break}else if(v[v.length-1]===x[x.length-v.length+N]){z=v.length-N;break}typeof z>"u"&&(B=[])}return B.length&&isNumber$V(z)&&(L=S.length+z*P,$?(U(B,S),j(S)):(U(S,B),j(B))),[B,S]},g.prototype.fillSetter=function(){g.prototype.strokeSetter.apply(this,arguments)},g.prototype.strokeSetter=function(){this.elem.attr(this.prop,color$f(this.start).tweenTo(color$f(this.end),this.pos),null,!0)},g.timers=[],g})(),defined$Y=Utilities.defined,getStyle$1=Utilities.getStyle,isArray$p=Utilities.isArray,isNumber$U=Utilities.isNumber,isObject$g=Utilities.isObject,merge$1t=Utilities.merge,objectEach$A=Utilities.objectEach,pick$1I=Utilities.pick;function setAnimation$5(g,d){d.renderer.globalAnimation=pick$1I(g,d.options.chart.animation,!0)}function animObject$d(g){return isObject$g(g)?merge$1t({duration:500,defer:0},g):{duration:g?500:0,defer:0}}function getDeferredAnimation$3(g,d,a){var u=animObject$d(d),v=a?[a]:g.series,x=0,S=0;v.forEach(function(P){var z=animObject$d(P.options.animation);x=d&&defined$Y(d.defer)?u.defer:Math.max(x,z.duration+z.defer),S=Math.min(u.duration,z.duration)}),g.renderer.forExport&&(x=0);var T={defer:Math.max(0,x-S),duration:Math.min(x,S)};return T}function animate$2(g,d,a){var u,v="",x,S,T;isObject$g(a)||(T=arguments,a={duration:T[2],easing:T[3],complete:T[4]}),isNumber$U(a.duration)||(a.duration=400),a.easing=typeof a.easing=="function"?a.easing:Math[a.easing]||Math.easeInOutSine,a.curAnim=merge$1t(d),objectEach$A(d,function(P,z){stop$2(g,z),S=new Fx(g,a,z),x=void 0,z==="d"&&isArray$p(d.d)?(S.paths=S.initPath(g,g.pathArray,d.d),S.toD=d.d,u=0,x=1):g.attr?u=g.attr(z):(u=parseFloat(getStyle$1(g,z))||0,z!=="opacity"&&(v="px")),x||(x=P),typeof x=="string"&&x.match("px")&&(x=x.replace(/px/g,"")),S.run(u,x,v)})}function stop$2(g,d){for(var a=Fx.timers.length;a--;)Fx.timers[a].elem===g&&(!d||d===Fx.timers[a].prop)&&(Fx.timers[a].stopped=!0)}var animationExports={animate:animate$2,animObject:animObject$d,getDeferredAnimation:getDeferredAnimation$3,setAnimation:setAnimation$5,stop:stop$2},SVG_NS$3=H.SVG_NS,attr$7=Utilities.attr,createElement$a=Utilities.createElement,discardElement$6=Utilities.discardElement,error$a=Utilities.error,isString$c=Utilities.isString,objectEach$z=Utilities.objectEach,splat$j=Utilities.splat,hasValidDOMParser=(function(){try{return!!new DOMParser().parseFromString("","text/html")}catch{return!1}})(),AST=(function(){function g(d){this.nodes=typeof d=="string"?this.parseMarkup(d):d}return g.filterUserAttributes=function(d){return objectEach$z(d,function(a,u){var v=!0;g.allowedAttributes.indexOf(u)===-1&&(v=!1),["background","dynsrc","href","lowsrc","src"].indexOf(u)!==-1&&(v=isString$c(a)&&g.allowedReferences.some(function(x){return a.indexOf(x)===0})),v||(error$a("Highcharts warning: Invalid attribute '"+u+"' in config"),delete d[u])}),d},g.setElementHTML=function(d,a){if(d.innerHTML="",a){var u=new g(a);u.addToDOM(d)}},g.prototype.addToDOM=function(d){function a(u,v){var x;return splat$j(u).forEach(function(S){var T=S.tagName,P=S.textContent?H.doc.createTextNode(S.textContent):void 0,z;if(T)if(T==="#text")z=P;else if(g.allowedTags.indexOf(T)!==-1){var L=T==="svg"?SVG_NS$3:v.namespaceURI||SVG_NS$3,N=H.doc.createElementNS(L,T),$=S.attributes||{};objectEach$z(S,function(B,U){U!=="tagName"&&U!=="attributes"&&U!=="children"&&U!=="textContent"&&($[U]=B)}),attr$7(N,g.filterUserAttributes($)),P&&N.appendChild(P),a(S.children||[],N),z=N}else error$a("Highcharts warning: Invalid tagName '"+T+"' in config");z&&v.appendChild(z),x=z}),x}return a(this.nodes,d)},g.prototype.parseMarkup=function(d){var a=[];d=d.trim();var u,v;hasValidDOMParser?u=new DOMParser().parseFromString(d,"text/html"):(v=createElement$a("div"),v.innerHTML=d,u={body:v});var x=function(S,T){var P=S.nodeName.toLowerCase(),z={tagName:P};P==="#text"&&(z.textContent=S.textContent||"");var L=S.attributes;if(L){var N={};[].forEach.call(L,function(B){N[B.name]=B.value}),z.attributes=N}if(S.childNodes.length){var $=[];[].forEach.call(S.childNodes,function(B){x(B,$)}),$.length&&(z.children=$)}T.push(z)};return[].forEach.call(u.body.childNodes,function(S){return x(S,a)}),v&&discardElement$6(v),a},g.allowedAttributes=["aria-controls","aria-describedby","aria-expanded","aria-haspopup","aria-hidden","aria-label","aria-labelledby","aria-live","aria-pressed","aria-readonly","aria-roledescription","aria-selected","class","clip-path","color","colspan","cx","cy","d","dx","dy","disabled","fill","height","href","id","in","markerHeight","markerWidth","offset","opacity","orient","padding","paddingLeft","paddingRight","patternUnits","r","refX","refY","role","scope","slope","src","startOffset","stdDeviation","stroke","stroke-linecap","stroke-width","style","tableValues","result","rowspan","summary","target","tabindex","text-align","textAnchor","textLength","type","valign","width","x","x1","x2","y","y1","y2","zIndex"],g.allowedReferences=["https://","http://","mailto:","/","../","./","#"],g.allowedTags=["a","b","br","button","caption","circle","clipPath","code","dd","defs","div","dl","dt","em","feComponentTransfer","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feOffset","feMerge","feMergeNode","filter","h1","h2","h3","h4","h5","h6","hr","i","img","li","linearGradient","marker","ol","p","path","pattern","pre","rect","small","span","stop","strong","style","sub","sup","svg","table","text","thead","tbody","tspan","td","th","tr","u","ul","#text"],g})(),defaultOptions$i=DefaultOptions.defaultOptions,defaultTime$1=DefaultOptions.defaultTime,getNestedProperty$2=Utilities.getNestedProperty,isNumber$T=Utilities.isNumber,pick$1H=Utilities.pick,pInt$8=Utilities.pInt;function dateFormat(g,d,a){return defaultTime$1.dateFormat(g,d,a)}function format$e(g,d,a){for(var u="{",v=!1,x,S,T,P,z=/f$/,L=/\.([0-9])/,N=defaultOptions$i.lang,$=a&&a.time||defaultTime$1,B=a&&a.numberFormatter||numberFormat$2,U=[];g&&(P=g.indexOf(u),P!==-1);){if(x=g.slice(0,P),v){if(S=x.split(":"),T=getNestedProperty$2(S.shift()||"",d),S.length&&typeof T=="number")if(x=S.join(":"),z.test(x)){var j=parseInt((x.match(L)||["","-1"])[1],10);T!==null&&(T=B(T,j,N.decimalPoint,x.indexOf(",")>-1?N.thousandsSep:""))}else T=$.dateFormat(x,T);U.push(T)}else U.push(x);g=g.slice(P+1),v=!v,u=v?"}":"{"}return U.push(g),U.join("")}function numberFormat$2(g,d,a,u){g=+g||0,d=+d;var v,x,S=defaultOptions$i.lang,T=(g.toString().split(".")[1]||"").split("e")[0].length,P=g.toString().split("e"),z=d;d===-1?d=Math.min(T,20):isNumber$T(d)?d&&P[1]&&P[1]<0&&(x=d+ +P[1],x>=0?(P[0]=(+P[0]).toExponential(x).split("e")[0],d=x):(P[0]=P[0].split(".")[0]||0,d<20?g=(P[0]*Math.pow(10,P[1])).toFixed(d):g=0,P[1]=0)):d=2;var L=(Math.abs(P[1]?P[0]:g)+Math.pow(10,-Math.max(d,T)-1)).toFixed(d),N=String(pInt$8(L)),$=N.length>3?N.length%3:0;return a=pick$1H(a,S.decimalPoint),u=pick$1H(u,S.thousandsSep),v=g<0?"-":"",v+=$?N.substr(0,$)+u:"",+P[1]<0&&!z?v="0":v+=N.substr($).replace(/(\d{3})(?=\d)/g,"$1"+u),d&&(v+=a+L.slice(-d)),P[1]&&+v!=0&&(v+="e"+P[1]),v}var FormatUtilities={dateFormat,format:format$e,numberFormat:numberFormat$2},clamp$k=Utilities.clamp,pick$1G=Utilities.pick,stableSort$6=Utilities.stableSort,RendererUtilities;(function(g){function d(a,u,v){var x=a,S=x.reducedLen||u,T=function(j,Y){return(Y.rank||0)-(j.rank||0)},P=function(j,Y){return j.target-Y.target},z,L=!0,N=[],$,B,U=0;for(z=a.length;z--;)U+=a[z].size;if(U>S){for(stableSort$6(a,T),z=0,U=0;U<=S;)U+=a[z].size,z++;N=a.splice(z-1,a.length)}for(stableSort$6(a,P),a=a.map(function(j){return{size:j.size,targets:[j.target],align:pick$1G(j.align,.5)}});L;){for(z=a.length;z--;)$=a[z],B=(Math.min.apply(0,$.targets)+Math.max.apply(0,$.targets))/2,$.pos=clamp$k(B-$.size*$.align,0,u-$.size);for(z=a.length,L=!1;z--;)z>0&&a[z-1].pos+a[z-1].size>a[z].pos&&(a[z-1].size+=a[z].size,a[z-1].targets=a[z-1].targets.concat(a[z].targets),a[z-1].align=.5,a[z-1].pos+a[z-1].size>u&&(a[z-1].pos=u-a[z-1].size),a.splice(z,1),L=!0)}return x.push.apply(x,N),z=0,a.some(function(j){var Y=0;return(j.targets||[]).some(function(){return x[z].pos=j.pos+Y,typeof v<"u"&&Math.abs(x[z].pos-x[z].target)>v?(x.slice(0,z+1).forEach(function(q){return delete q.pos}),x.reducedLen=(x.reducedLen||u)-u*.1,x.reducedLen>u*.1&&d(x,u,v),!0):(Y+=x[z].size,z++,!1)})}),stableSort$6(x,P),x}g.distribute=d})(RendererUtilities||(RendererUtilities={}));const R=RendererUtilities;var animate$1=animationExports.animate,animObject$c=animationExports.animObject,stop$1=animationExports.stop,deg2rad$9=H.deg2rad,doc$l=H.doc,noop$k=H.noop,svg$6=H.svg,SVG_NS$2=H.SVG_NS,win$d=H.win,addEvent$18=Utilities.addEvent,attr$6=Utilities.attr,createElement$9=Utilities.createElement,css$c=Utilities.css,defined$X=Utilities.defined,erase$9=Utilities.erase,extend$1w=Utilities.extend,fireEvent$B=Utilities.fireEvent,isArray$o=Utilities.isArray,isFunction$4=Utilities.isFunction,isNumber$S=Utilities.isNumber,isString$b=Utilities.isString,merge$1s=Utilities.merge,objectEach$y=Utilities.objectEach,pick$1F=Utilities.pick,pInt$7=Utilities.pInt,syncTimeout$8=Utilities.syncTimeout,uniqueKey$7=Utilities.uniqueKey,SVGElement=(function(){function g(){this.element=void 0,this.onEvents={},this.opacity=1,this.renderer=void 0,this.SVG_NS=SVG_NS$2,this.symbolCustomAttribs=["x","y","width","height","r","start","end","innerR","anchorX","anchorY","rounded"]}return g.prototype._defaultGetter=function(d){var a=pick$1F(this[d+"Value"],this[d],this.element?this.element.getAttribute(d):null,0);return/^[\-0-9\.]+$/.test(a)&&(a=parseFloat(a)),a},g.prototype._defaultSetter=function(d,a,u){u.setAttribute(a,d)},g.prototype.add=function(d){var a=this.renderer,u=this.element,v;return d&&(this.parentGroup=d),this.parentInverted=d&&d.inverted,typeof this.textStr<"u"&&this.element.nodeName==="text"&&a.buildText(this),this.added=!0,(!d||d.handleZ||this.zIndex)&&(v=this.zIndexSetter()),v||(d?d.element:a.box).appendChild(u),this.onAdd&&this.onAdd(),this},g.prototype.addClass=function(d,a){var u=a?"":this.attr("class")||"";return d=(d||"").split(/ /g).reduce(function(v,x){return u.indexOf(x)===-1&&v.push(x),v},u?[u]:[]).join(" "),d!==u&&this.attr("class",d),this},g.prototype.afterSetters=function(){this.doTransform&&(this.updateTransform(),this.doTransform=!1)},g.prototype.align=function(d,a,u){var v={},x=this.renderer,S=x.alignedObjects,T,P,z,L,N;d?(this.alignOptions=d,this.alignByTranslate=a,(!u||isString$b(u))&&(this.alignTo=z=u||"renderer",erase$9(S,this),S.push(this),u=void 0)):(d=this.alignOptions,a=this.alignByTranslate,z=this.alignTo),u=pick$1F(u,x[z],z==="scrollablePlotBox"?x.plotBox:void 0,x);var $=d.align,B=d.verticalAlign;return T=(u.x||0)+(d.x||0),P=(u.y||0)+(d.y||0),$==="right"?L=1:$==="center"&&(L=2),L&&(T+=(u.width-(d.width||0))/L),v[a?"translateX":"x"]=Math.round(T),B==="bottom"?N=1:B==="middle"&&(N=2),N&&(P+=(u.height-(d.height||0))/N),v[a?"translateY":"y"]=Math.round(P),this[this.placed?"animate":"attr"](v),this.placed=!0,this.alignAttr=v,this},g.prototype.alignSetter=function(d){var a={left:"start",center:"middle",right:"end"};a[d]&&(this.alignValue=d,this.element.setAttribute("text-anchor",a[d]))},g.prototype.animate=function(d,a,u){var v=this,x=animObject$c(pick$1F(a,this.renderer.globalAnimation,!0)),S=x.defer;return pick$1F(doc$l.hidden,doc$l.msHidden,doc$l.webkitHidden,!1)&&(x.duration=0),x.duration!==0?(u&&(x.complete=u),syncTimeout$8(function(){v.element&&animate$1(v,d,x)},S)):(this.attr(d,void 0,u),objectEach$y(d,function(T,P){x.step&&x.step.call(this,T,{prop:P,pos:1,elem:this})},this)),this},g.prototype.applyTextOutline=function(d){var a=this.element,u=d.indexOf("contrast")!==-1;u&&(d=d.replace(/contrast/g,this.renderer.getContrast(a.style.fill)));var v=d.split(" "),x=v[v.length-1],S=v[0];if(S&&S!=="none"&&H.svg){this.fakeTS=!0,this.ySetter=this.xSetter,S=S.replace(/(^[\d\.]+)(.*?)$/g,function(z,L,N){return 2*Number(L)+N}),this.removeTextOutline();var T=doc$l.createElementNS(SVG_NS$2,"tspan");attr$6(T,{class:"highcharts-text-outline",fill:x,stroke:x,"stroke-width":S,"stroke-linejoin":"round"}),[].forEach.call(a.childNodes,function(z){var L=z.cloneNode(!0);L.removeAttribute&&["fill","stroke","stroke-width","stroke"].forEach(function(N){return L.removeAttribute(N)}),T.appendChild(L)});var P=doc$l.createElementNS(SVG_NS$2,"tspan");P.textContent="​",["x","y"].forEach(function(z){var L=a.getAttribute(z);L&&P.setAttribute(z,L)}),T.appendChild(P),a.insertBefore(T,a.firstChild)}},g.prototype.attr=function(d,a,u,v){var x=this.element,S=this.symbolCustomAttribs,T,P,z=this,L,N;return typeof d=="string"&&typeof a<"u"&&(T=d,d={},d[T]=a),typeof d=="string"?z=(this[d+"Getter"]||this._defaultGetter).call(this,d,x):(objectEach$y(d,function(B,U){L=!1,v||stop$1(this,U),this.symbolName&&S.indexOf(U)!==-1&&(P||(this.symbolAttr(d),P=!0),L=!0),this.rotation&&(U==="x"||U==="y")&&(this.doTransform=!0),L||(N=this[U+"Setter"]||this._defaultSetter,N.call(this,B,U,x),!this.styledMode&&this.shadows&&/^(width|height|visibility|x|y|d|transform|cx|cy|r)$/.test(U)&&this.updateShadows(U,B,N))},this),this.afterSetters()),u&&u.call(this),z},g.prototype.clip=function(d){return this.attr("clip-path",d?"url("+this.renderer.url+"#"+d.id+")":"none")},g.prototype.crisp=function(d,a){var u=this;a=a||d.strokeWidth||0;var v=Math.round(a)%2/2;return d.x=Math.floor(d.x||u.x||0)+v,d.y=Math.floor(d.y||u.y||0)+v,d.width=Math.floor((d.width||u.width||0)-2*v),d.height=Math.floor((d.height||u.height||0)-2*v),defined$X(d.strokeWidth)&&(d.strokeWidth=a),d},g.prototype.complexColor=function(d,a,u){var v=this.renderer,x,S,T,P,z,L,N,$,B,U,j=[],Y;fireEvent$B(this.renderer,"complexColor",{args:arguments},function(){if(d.radialGradient?S="radialGradient":d.linearGradient&&(S="linearGradient"),S){if(T=d[S],z=v.gradients,L=d.stops,B=u.radialReference,isArray$o(T)&&(d[S]=T={x1:T[0],y1:T[1],x2:T[2],y2:T[3],gradientUnits:"userSpaceOnUse"}),S==="radialGradient"&&B&&!defined$X(T.gradientUnits)&&(P=T,T=merge$1s(T,v.getRadialAttr(B,P),{gradientUnits:"userSpaceOnUse"})),objectEach$y(T,function(Q,J){J!=="id"&&j.push(J,Q)}),objectEach$y(L,function(Q){j.push(Q)}),j=j.join(","),z[j])U=z[j].attr("id");else{T.id=U=uniqueKey$7();var q=z[j]=v.createElement(S).attr(T).add(v.defs);q.radAttr=P,q.stops=[],L.forEach(function(Q){Q[1].indexOf("rgba")===0?(x=Color.parse(Q[1]),N=x.get("rgb"),$=x.get("a")):(N=Q[1],$=1);var J=v.createElement("stop").attr({offset:Q[0],"stop-color":N,"stop-opacity":$}).add(q);q.stops.push(J)})}Y="url("+v.url+"#"+U+")",u.setAttribute(a,Y),u.gradient=j,d.toString=function(){return Y}}})},g.prototype.css=function(d){var a=this.styles,u={},v=this.element,x=["textOutline","textOverflow","width"],S,T="",P,z=!a;return d&&d.color&&(d.fill=d.color),a&&objectEach$y(d,function(L,N){a&&a[N]!==L&&(u[N]=L,z=!0)}),z&&(a&&(d=extend$1w(a,u)),d&&(d.width===null||d.width==="auto"?delete this.textWidth:v.nodeName.toLowerCase()==="text"&&d.width&&(S=this.textWidth=pInt$7(d.width))),this.styles=d,S&&!svg$6&&this.renderer.forExport&&delete d.width,v.namespaceURI===this.SVG_NS?(P=function(L,N){return"-"+N.toLowerCase()},objectEach$y(d,function(L,N){x.indexOf(N)===-1&&(T+=N.replace(/([A-Z])/g,P)+":"+L+";")}),T&&attr$6(v,"style",T)):css$c(v,d),this.added&&(this.element.nodeName==="text"&&this.renderer.buildText(this),d&&d.textOutline&&this.applyTextOutline(d.textOutline))),this},g.prototype.dashstyleSetter=function(d){var a,u=this["stroke-width"];if(u==="inherit"&&(u=1),d=d&&d.toLowerCase(),d){var v=d.replace("shortdashdotdot","3,1,1,1,1,1,").replace("shortdashdot","3,1,1,1").replace("shortdot","1,1,").replace("shortdash","3,1,").replace("longdash","8,3,").replace(/dot/g,"1,3,").replace("dash","4,3,").replace(/,$/,"").split(",");for(a=v.length;a--;)v[a]=""+pInt$7(v[a])*pick$1F(u,NaN);d=v.join(",").replace(/NaN/g,"none"),this.element.setAttribute("stroke-dasharray",d)}},g.prototype.destroy=function(){var d=this,a=d.element||{},u=d.renderer,v=a.ownerSVGElement,x=u.isSVG&&a.nodeName==="SPAN"&&d.parentGroup||void 0,S,T;if(a.onclick=a.onmouseout=a.onmouseover=a.onmousemove=a.point=null,stop$1(d),d.clipPath&&v){var P=d.clipPath;[].forEach.call(v.querySelectorAll("[clip-path],[CLIP-PATH]"),function(z){z.getAttribute("clip-path").indexOf(P.element.id)>-1&&z.removeAttribute("clip-path")}),d.clipPath=P.destroy()}if(d.stops){for(T=0;T<d.stops.length;T++)d.stops[T].destroy();d.stops.length=0,d.stops=void 0}for(d.safeRemoveChild(a),u.styledMode||d.destroyShadows();x&&x.div&&x.div.childNodes.length===0;)S=x.parentGroup,d.safeRemoveChild(x.div),delete x.div,x=S;d.alignTo&&erase$9(u.alignedObjects,d),objectEach$y(d,function(z,L){d[L]&&d[L].parentGroup===d&&d[L].destroy&&d[L].destroy(),delete d[L]})},g.prototype.destroyShadows=function(){(this.shadows||[]).forEach(function(d){this.safeRemoveChild(d)},this),this.shadows=void 0},g.prototype.destroyTextPath=function(d,a){var u=d.getElementsByTagName("text")[0],v;if(u){if(u.removeAttribute("dx"),u.removeAttribute("dy"),a.element.setAttribute("id",""),this.textPathWrapper&&u.getElementsByTagName("textPath").length){for(v=this.textPathWrapper.element.childNodes;v.length;)u.appendChild(v[0]);u.removeChild(this.textPathWrapper.element)}}else(d.getAttribute("dx")||d.getAttribute("dy"))&&(d.removeAttribute("dx"),d.removeAttribute("dy"));this.textPathWrapper&&(this.textPathWrapper=this.textPathWrapper.destroy())},g.prototype.dSetter=function(d,a,u){isArray$o(d)&&(typeof d[0]=="string"&&(d=this.renderer.pathToSegments(d)),this.pathArray=d,d=d.reduce(function(v,x,S){return!x||!x.join?(x||"").toString():(S?v+" ":"")+x.join(" ")},"")),/(NaN| {2}|^$)/.test(d)&&(d="M 0 0"),this[a]!==d&&(u.setAttribute(a,d),this[a]=d)},g.prototype.fadeOut=function(d){var a=this;a.animate({opacity:0},{duration:pick$1F(d,150),complete:function(){a.attr({y:-9999}).hide()}})},g.prototype.fillSetter=function(d,a,u){typeof d=="string"?u.setAttribute(a,d):d&&this.complexColor(d,a,u)},g.prototype.getBBox=function(d,a){var u=this,v=u.renderer,x=u.element,S=u.styles,T=u.textStr,P=v.cache,z=v.cacheKeys,L=x.namespaceURI===u.SVG_NS,N=pick$1F(a,u.rotation,0),$=v.styledMode?x&&g.prototype.getStyle.call(x,"font-size"):S&&S.fontSize,B,U,j,Y,q;if(defined$X(T)&&(q=T.toString(),q.indexOf("<")===-1&&(q=q.replace(/[0-9]/g,"0")),q+=["",N,$,u.textWidth,S&&S.textOverflow,S&&S.fontWeight].join(",")),q&&!d&&(B=P[q]),!B){if(L||v.forExport){try{Y=this.fakeTS&&function(J){var ee=x.querySelector(".highcharts-text-outline");ee&&css$c(ee,{display:J})},isFunction$4(Y)&&Y("none"),B=x.getBBox?extend$1w({},x.getBBox()):{width:x.offsetWidth,height:x.offsetHeight},isFunction$4(Y)&&Y("")}catch{}(!B||B.width<0)&&(B={width:0,height:0})}else B=u.htmlGetBBox();if(v.isSVG&&(U=B.width,j=B.height,L&&(B.height=j={"11px,17":14,"13px,20":16}[S&&S.fontSize+","+Math.round(j)]||j),N)){var Q=N*deg2rad$9;B.width=Math.abs(j*Math.sin(Q))+Math.abs(U*Math.cos(Q)),B.height=Math.abs(j*Math.cos(Q))+Math.abs(U*Math.sin(Q))}if(q&&(T===""||B.height>0)){for(;z.length>250;)delete P[z.shift()];P[q]||z.push(q),P[q]=B}}return B},g.prototype.getStyle=function(d){return win$d.getComputedStyle(this.element||this,"").getPropertyValue(d)},g.prototype.hasClass=function(d){return(""+this.attr("class")).split(" ").indexOf(d)!==-1},g.prototype.hide=function(d){return d?this.attr({y:-9999}):this.attr({visibility:"hidden"}),this},g.prototype.htmlGetBBox=function(){return{height:0,width:0,x:0,y:0}},g.prototype.init=function(d,a){this.element=a==="span"?createElement$9(a):doc$l.createElementNS(this.SVG_NS,a),this.renderer=d,fireEvent$B(this,"afterInit")},g.prototype.invert=function(d){return this.inverted=d,this.updateTransform(),this},g.prototype.on=function(d,a){var u=this.onEvents;return u[d]&&u[d](),u[d]=addEvent$18(this.element,d,a),this},g.prototype.opacitySetter=function(d,a,u){var v=Number(Number(d).toFixed(3));this.opacity=v,u.setAttribute(a,v)},g.prototype.removeClass=function(d){return this.attr("class",(""+this.attr("class")).replace(isString$b(d)?new RegExp("(^| )"+d+"( |$)"):d," ").replace(/ +/g," ").trim())},g.prototype.removeTextOutline=function(){var d=this.element.querySelector("tspan.highcharts-text-outline");d&&this.safeRemoveChild(d)},g.prototype.safeRemoveChild=function(d){var a=d.parentNode;a&&a.removeChild(d)},g.prototype.setRadialReference=function(d){var a=this.element.gradient&&this.renderer.gradients[this.element.gradient];return this.element.radialReference=d,a&&a.radAttr&&a.animate(this.renderer.getRadialAttr(d,a.radAttr)),this},g.prototype.setTextPath=function(d,a){var u=this.element,v=this.text?this.text.element:u,x={textAnchor:"text-anchor"},S=!1,T,P,z=this.textPathWrapper,L=!z;a=merge$1s(!0,{enabled:!0,attributes:{dy:-5,startOffset:"50%",textAnchor:"middle"}},a);var N=AST.filterUserAttributes(a.attributes);if(d&&a&&a.enabled){if(z&&z.element.parentNode===null?(L=!0,z=z.destroy()):z&&this.removeTextOutline.call(z.parentGroup),this.options&&this.options.padding&&(N.dx=-this.options.padding),z||(this.textPathWrapper=z=this.renderer.createElement("textPath"),S=!0),T=z.element,P=d.element.getAttribute("id"),P||d.element.setAttribute("id",P=uniqueKey$7()),L){v.setAttribute("y",0),isNumber$S(N.dx)&&v.setAttribute("x",-N.dx);for(var $=[].slice.call(v.childNodes),B=0;B<$.length;B++){var U=$[B];(U.nodeType===Node.TEXT_NODE||U.nodeName==="tspan")&&T.appendChild(U)}}S&&z&&z.add({element:v}),T.setAttributeNS("http://www.w3.org/1999/xlink","href",this.renderer.url+"#"+P),defined$X(N.dy)&&(T.parentNode.setAttribute("dy",N.dy),delete N.dy),defined$X(N.dx)&&(T.parentNode.setAttribute("dx",N.dx),delete N.dx),objectEach$y(N,function(j,Y){T.setAttribute(x[Y]||Y,j)}),u.removeAttribute("transform"),this.removeTextOutline.call(z),this.text&&!this.renderer.styledMode&&this.attr({fill:"none","stroke-width":0}),this.updateTransform=noop$k,this.applyTextOutline=noop$k}else z&&(delete this.updateTransform,delete this.applyTextOutline,this.destroyTextPath(u,d),this.updateTransform(),this.options&&this.options.rotation&&this.applyTextOutline(this.options.style.textOutline));return this},g.prototype.shadow=function(d,a,u){var v=[],x=this.element,S=this.oldShadowOptions,T={color:palette.neutralColor100,offsetX:this.parentInverted?-1:1,offsetY:this.parentInverted?-1:1,opacity:.15,width:3},P,z,L,N,$=!1,B,U;if(d===!0?U=T:typeof d=="object"&&(U=extend$1w(T,d)),U&&(U&&S&&objectEach$y(U,function(j,Y){j!==S[Y]&&($=!0)}),$&&this.destroyShadows(),this.oldShadowOptions=U),!U)this.destroyShadows();else if(!this.shadows){for(N=U.opacity/U.width,B=this.parentInverted?"translate("+U.offsetY+", "+U.offsetX+")":"translate("+U.offsetX+", "+U.offsetY+")",P=1;P<=U.width;P++)z=x.cloneNode(!1),L=U.width*2+1-2*P,attr$6(z,{stroke:d.color||palette.neutralColor100,"stroke-opacity":N*P,"stroke-width":L,transform:B,fill:"none"}),z.setAttribute("class",(z.getAttribute("class")||"")+" highcharts-shadow"),u&&(attr$6(z,"height",Math.max(attr$6(z,"height")-L,0)),z.cutHeight=L),a?a.element.appendChild(z):x.parentNode&&x.parentNode.insertBefore(z,x),v.push(z);this.shadows=v}return this},g.prototype.show=function(d){return this.attr({visibility:d?"inherit":"visible"})},g.prototype.strokeSetter=function(d,a,u){this[a]=d,this.stroke&&this["stroke-width"]?(g.prototype.fillSetter.call(this,this.stroke,"stroke",u),u.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0):a==="stroke-width"&&d===0&&this.hasStroke?(u.removeAttribute("stroke"),this.hasStroke=!1):this.renderer.styledMode&&this["stroke-width"]&&(u.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0)},g.prototype.strokeWidth=function(){if(!this.renderer.styledMode)return this["stroke-width"]||0;var d=this.getStyle("stroke-width"),a=0,u;return d.indexOf("px")===d.length-2?a=pInt$7(d):d!==""&&(u=doc$l.createElementNS(SVG_NS$2,"rect"),attr$6(u,{width:d,"stroke-width":0}),this.element.parentNode.appendChild(u),a=u.getBBox().width,u.parentNode.removeChild(u)),a},g.prototype.symbolAttr=function(d){var a=this;["x","y","r","start","end","width","height","innerR","anchorX","anchorY","clockwise"].forEach(function(u){a[u]=pick$1F(d[u],a[u])}),a.attr({d:a.renderer.symbols[a.symbolName](a.x,a.y,a.width,a.height,a)})},g.prototype.textSetter=function(d){d!==this.textStr&&(delete this.textPxLength,this.textStr=d,this.added&&this.renderer.buildText(this))},g.prototype.titleSetter=function(d){var a=this.element,u=a.getElementsByTagName("title")[0]||doc$l.createElementNS(this.SVG_NS,"title");a.insertBefore?a.insertBefore(u,a.firstChild):a.appendChild(u),u.textContent=String(pick$1F(d,"")).replace(/<[^>]*>/g,"").replace(/&lt;/g,"<").replace(/&gt;/g,">")},g.prototype.toFront=function(){var d=this.element;return d.parentNode.appendChild(d),this},g.prototype.translate=function(d,a){return this.attr({translateX:d,translateY:a})},g.prototype.updateShadows=function(d,a,u){var v=this.shadows;if(v)for(var x=v.length;x--;)u.call(v[x],d==="height"?Math.max(a-(v[x].cutHeight||0),0):d==="d"?this.d:a,d,v[x])},g.prototype.updateTransform=function(){var d=this,a=d.scaleX,u=d.scaleY,v=d.inverted,x=d.rotation,S=d.matrix,T=d.element,P=d.translateX||0,z=d.translateY||0;v&&(P+=d.width,z+=d.height);var L=["translate("+P+","+z+")"];defined$X(S)&&L.push("matrix("+S.join(",")+")"),v?L.push("rotate(90) scale(-1,1)"):x&&L.push("rotate("+x+" "+pick$1F(this.rotationOriginX,T.getAttribute("x"),0)+" "+pick$1F(this.rotationOriginY,T.getAttribute("y")||0)+")"),(defined$X(a)||defined$X(u))&&L.push("scale("+pick$1F(a,1)+" "+pick$1F(u,1)+")"),L.length&&T.setAttribute("transform",L.join(" "))},g.prototype.visibilitySetter=function(d,a,u){d==="inherit"?u.removeAttribute(a):this[a]!==d&&u.setAttribute(a,d),this[a]=d},g.prototype.xGetter=function(d){return this.element.nodeName==="circle"&&(d==="x"?d="cx":d==="y"&&(d="cy")),this._defaultGetter(d)},g.prototype.zIndexSetter=function(d,a){var u=this.renderer,v=this.parentGroup,x=v||u,S=x.element||u.box,T=this.element,P=S===u.box,z,L,N,$=!1,B,U=this.added,j;if(defined$X(d)?(T.setAttribute("data-z-index",d),d=+d,this[a]===d&&(U=!1)):defined$X(this[a])&&T.removeAttribute("data-z-index"),this[a]=d,U){for(d=this.zIndex,d&&v&&(v.handleZ=!0),z=S.childNodes,j=z.length-1;j>=0&&!$;j--)L=z[j],N=L.getAttribute("data-z-index"),B=!defined$X(N),L!==T&&(d<0&&B&&!P&&!j?(S.insertBefore(T,z[j]),$=!0):(pInt$7(N)<=d||B&&(!defined$X(d)||d>=0))&&(S.insertBefore(T,z[j+1]||null),$=!0));$||(S.insertBefore(T,z[P?3:0]||null),$=!0)}return $},g})();SVGElement.prototype["stroke-widthSetter"]=SVGElement.prototype.strokeSetter;SVGElement.prototype.yGetter=SVGElement.prototype.xGetter;SVGElement.prototype.matrixSetter=SVGElement.prototype.rotationOriginXSetter=SVGElement.prototype.rotationOriginYSetter=SVGElement.prototype.rotationSetter=SVGElement.prototype.scaleXSetter=SVGElement.prototype.scaleYSetter=SVGElement.prototype.translateXSetter=SVGElement.prototype.translateYSetter=SVGElement.prototype.verticalAlignSetter=function(g,d){this[d]=g,this.doTransform=!0};var RendererRegistry;(function(g){g.rendererTypes={};var d;function a(v){return v===void 0&&(v=d),g.rendererTypes[v]||g.rendererTypes[d]}g.getRendererType=a;function u(v,x,S){g.rendererTypes[v]=x,(!d||S)&&(d=v,H.Renderer=x)}g.registerRendererType=u})(RendererRegistry||(RendererRegistry={}));const RendererRegistry$1=RendererRegistry;var __extends$2h=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),defined$W=Utilities.defined,extend$1v=Utilities.extend,isNumber$R=Utilities.isNumber,merge$1r=Utilities.merge,pick$1E=Utilities.pick,removeEvent$b=Utilities.removeEvent,SVGLabel=(function(g){__extends$2h(d,g);function d(a,u,v,x,S,T,P,z,L,N){var $=g.call(this)||this;$.paddingLeftSetter=$.paddingSetter,$.paddingRightSetter=$.paddingSetter,$.init(a,"g"),$.textStr=u,$.x=v,$.y=x,$.anchorX=T,$.anchorY=P,$.baseline=L,$.className=N,$.addClass(N==="button"?"highcharts-no-tooltip":"highcharts-label"),N&&$.addClass("highcharts-"+N),$.text=a.text(void 0,0,0,z).attr({zIndex:1});var B;return typeof S=="string"&&(B=/^url\((.*?)\)$/.test(S),(B||$.renderer.symbols[S])&&($.symbolKey=S)),$.bBox=d.emptyBBox,$.padding=3,$.baselineOffset=0,$.needsBox=a.styledMode||B,$.deferredAttr={},$.alignFactor=0,$}return d.prototype.alignSetter=function(a){var u={left:0,center:.5,right:1}[a];u!==this.alignFactor&&(this.alignFactor=u,this.bBox&&isNumber$R(this.xSetting)&&this.attr({x:this.xSetting}))},d.prototype.anchorXSetter=function(a,u){this.anchorX=a,this.boxAttr(u,Math.round(a)-this.getCrispAdjust()-this.xSetting)},d.prototype.anchorYSetter=function(a,u){this.anchorY=a,this.boxAttr(u,a-this.ySetting)},d.prototype.boxAttr=function(a,u){this.box?this.box.attr(a,u):this.deferredAttr[a]=u},d.prototype.css=function(a){if(a){var u={};a=merge$1r(a),d.textProps.forEach(function(S){typeof a[S]<"u"&&(u[S]=a[S],delete a[S])}),this.text.css(u);var v="width"in u,x="fontSize"in u||"fontWeight"in u;x?this.updateTextPadding():v&&this.updateBoxSize()}return SVGElement.prototype.css.call(this,a)},d.prototype.destroy=function(){removeEvent$b(this.element,"mouseenter"),removeEvent$b(this.element,"mouseleave"),this.text&&this.text.destroy(),this.box&&(this.box=this.box.destroy()),SVGElement.prototype.destroy.call(this)},d.prototype.fillSetter=function(a,u){a&&(this.needsBox=!0),this.fill=a,this.boxAttr(u,a)},d.prototype.getBBox=function(){this.textStr&&this.bBox.width===0&&this.bBox.height===0&&this.updateBoxSize();var a=this.padding,u=pick$1E(this.paddingLeft,a);return{width:this.width,height:this.height,x:this.bBox.x-u,y:this.bBox.y-a}},d.prototype.getCrispAdjust=function(){return this.renderer.styledMode&&this.box?this.box.strokeWidth()%2/2:(this["stroke-width"]?parseInt(this["stroke-width"],10):0)%2/2},d.prototype.heightSetter=function(a){this.heightSetting=a},d.prototype.onAdd=function(){var a=this.textStr;this.text.add(this),this.attr({text:defined$W(a)?a:"",x:this.x,y:this.y}),this.box&&defined$W(this.anchorX)&&this.attr({anchorX:this.anchorX,anchorY:this.anchorY})},d.prototype.paddingSetter=function(a,u){isNumber$R(a)?a!==this[u]&&(this[u]=a,this.updateTextPadding()):this[u]=void 0},d.prototype.rSetter=function(a,u){this.boxAttr(u,a)},d.prototype.shadow=function(a){return a&&!this.renderer.styledMode&&(this.updateBoxSize(),this.box&&this.box.shadow(a)),this},d.prototype.strokeSetter=function(a,u){this.stroke=a,this.boxAttr(u,a)},d.prototype["stroke-widthSetter"]=function(a,u){a&&(this.needsBox=!0),this["stroke-width"]=a,this.boxAttr(u,a)},d.prototype["text-alignSetter"]=function(a){this.textAlign=a},d.prototype.textSetter=function(a){typeof a<"u"&&this.text.attr({text:a}),this.updateTextPadding()},d.prototype.updateBoxSize=function(){var a=this.text.element.style,u={},v=this.padding,x=this.bBox=(!isNumber$R(this.widthSetting)||!isNumber$R(this.heightSetting)||this.textAlign)&&defined$W(this.text.textStr)?this.text.getBBox():d.emptyBBox,S;this.width=this.getPaddedWidth(),this.height=(this.heightSetting||x.height||0)+2*v;var T=this.renderer.fontMetrics(a&&a.fontSize,this.text);if(this.baselineOffset=v+Math.min((this.text.firstLineMetrics||T).b,x.height||1/0),this.heightSetting&&(this.baselineOffset+=(this.heightSetting-T.h)/2),this.needsBox){if(!this.box){var P=this.box=this.symbolKey?this.renderer.symbol(this.symbolKey):this.renderer.rect();P.addClass((this.className==="button"?"":"highcharts-label-box")+(this.className?" highcharts-"+this.className+"-box":"")),P.add(this)}S=this.getCrispAdjust(),u.x=S,u.y=(this.baseline?-this.baselineOffset:0)+S,u.width=Math.round(this.width),u.height=Math.round(this.height),this.box.attr(extend$1v(u,this.deferredAttr)),this.deferredAttr={}}},d.prototype.updateTextPadding=function(){var a=this.text;this.updateBoxSize();var u=this.baseline?0:this.baselineOffset,v=pick$1E(this.paddingLeft,this.padding);defined$W(this.widthSetting)&&this.bBox&&(this.textAlign==="center"||this.textAlign==="right")&&(v+={center:.5,right:1}[this.textAlign]*(this.widthSetting-this.bBox.width)),(v!==a.x||u!==a.y)&&(a.attr("x",v),a.hasBoxWidthChanged&&(this.bBox=a.getBBox(!0)),typeof u<"u"&&a.attr("y",u)),a.x=v,a.y=u},d.prototype.widthSetter=function(a){this.widthSetting=isNumber$R(a)?a:void 0},d.prototype.getPaddedWidth=function(){var a=this.padding,u=pick$1E(this.paddingLeft,a),v=pick$1E(this.paddingRight,a);return(this.widthSetting||this.bBox.width||0)+u+v},d.prototype.xSetter=function(a){this.x=a,this.alignFactor&&(a-=this.alignFactor*this.getPaddedWidth(),this["forceAnimate:x"]=!0),this.xSetting=Math.round(a),this.attr("translateX",this.xSetting)},d.prototype.ySetter=function(a){this.ySetting=this.y=Math.round(a),this.attr("translateY",this.ySetting)},d.emptyBBox={width:0,height:0,x:0,y:0},d.textProps=["color","direction","fontFamily","fontSize","fontStyle","fontWeight","lineHeight","textAlign","textDecoration","textOutline","textOverflow","width"],d})(SVGElement),defined$V=Utilities.defined,isNumber$Q=Utilities.isNumber,pick$1D=Utilities.pick;function arc$1(g,d,a,u,v){var x=[];if(v){var S=v.start||0,T=pick$1D(v.r,a),P=pick$1D(v.r,u||a),z=.001,L=Math.abs((v.end||0)-S-2*Math.PI)<z,N=(v.end||0)-z,$=v.innerR,B=pick$1D(v.open,L),U=Math.cos(S),j=Math.sin(S),Y=Math.cos(N),q=Math.sin(N),Q=pick$1D(v.longArc,N-S-Math.PI<z?0:1);x.push(["M",g+T*U,d+P*j],["A",T,P,0,Q,pick$1D(v.clockwise,1),g+T*Y,d+P*q]),defined$V($)&&x.push(B?["M",g+$*Y,d+$*q]:["L",g+$*Y,d+$*q],["A",$,$,0,Q,defined$V(v.clockwise)?1-v.clockwise:0,g+$*U,d+$*j]),B||x.push(["Z"])}return x}function callout(g,d,a,u,v){var x=6,S=6,T=Math.min(v&&v.r||0,a,u),P=T+S,z=v&&v.anchorX,L=v&&v.anchorY||0,N=roundedRect(g,d,a,u,{r:T});return isNumber$Q(z)&&(g+z>=a?L>d+P&&L<d+u-P?N.splice(3,1,["L",g+a,L-S],["L",g+a+x,L],["L",g+a,L+S],["L",g+a,d+u-T]):N.splice(3,1,["L",g+a,u/2],["L",z,L],["L",g+a,u/2],["L",g+a,d+u-T]):g+z<=0?L>d+P&&L<d+u-P?N.splice(7,1,["L",g,L+S],["L",g-x,L],["L",g,L-S],["L",g,d+T]):N.splice(7,1,["L",g,u/2],["L",z,L],["L",g,u/2],["L",g,d+T]):L&&L>u&&z>g+P&&z<g+a-P?N.splice(5,1,["L",z+S,d+u],["L",z,d+u+x],["L",z-S,d+u],["L",g+T,d+u]):L&&L<0&&z>g+P&&z<g+a-P&&N.splice(1,1,["L",z-S,d],["L",z,d-x],["L",z+S,d],["L",a-T,d])),N}function circle(g,d,a,u){return arc$1(g+a/2,d+u/2,a/2,u/2,{start:Math.PI*.5,end:Math.PI*2.5,open:!1})}function diamond(g,d,a,u){return[["M",g+a/2,d],["L",g+a,d+u/2],["L",g+a/2,d+u],["L",g,d+u/2],["Z"]]}function rect(g,d,a,u,v){return v&&v.r?roundedRect(g,d,a,u,v):[["M",g,d],["L",g+a,d],["L",g+a,d+u],["L",g,d+u],["Z"]]}function roundedRect(g,d,a,u,v){var x=v&&v.r||0;return[["M",g+x,d],["L",g+a-x,d],["C",g+a,d,g+a,d,g+a,d+x],["L",g+a,d+u-x],["C",g+a,d+u,g+a,d+u,g+a-x,d+u],["L",g+x,d+u],["C",g,d+u,g,d+u,g,d+u-x],["L",g,d+x],["C",g,d,g,d,g+x,d]]}function triangle(g,d,a,u){return[["M",g+a/2,d],["L",g+a,d+u],["L",g,d+u],["Z"]]}function triangleDown(g,d,a,u){return[["M",g,d],["L",g+a,d],["L",g+a/2,d+u],["Z"]]}var Symbols={arc:arc$1,callout,circle,diamond,rect,roundedRect,square:rect,triangle,"triangle-down":triangleDown},doc$k=H.doc,SVG_NS$1=H.SVG_NS,attr$5=Utilities.attr,isString$a=Utilities.isString,objectEach$x=Utilities.objectEach,pick$1C=Utilities.pick,TextBuilder=(function(){function g(d){var a=d.styles;this.renderer=d.renderer,this.svgElement=d,this.width=d.textWidth,this.textLineHeight=a&&a.lineHeight,this.textOutline=a&&a.textOutline,this.ellipsis=!!(a&&a.textOverflow==="ellipsis"),this.noWrap=!!(a&&a.whiteSpace==="nowrap"),this.fontSize=a&&a.fontSize}return g.prototype.buildSVG=function(){var d=this.svgElement,a=d.element,u=d.renderer,v=pick$1C(d.textStr,"").toString(),x=v.indexOf("<")!==-1,S=a.childNodes,T=this.width&&!d.added&&u.box,P=/<br.*?>/g,z=[v,this.ellipsis,this.noWrap,this.textLineHeight,this.textOutline,this.fontSize,this.width].join(",");if(z!==d.textCache){d.textCache=z,delete d.actualWidth;for(var L=S.length;L--;)a.removeChild(S[L]);if(!x&&!this.ellipsis&&!this.width&&(v.indexOf(" ")===-1||this.noWrap&&!P.test(v)))a.appendChild(doc$k.createTextNode(this.unescapeEntities(v)));else if(v!==""){T&&T.appendChild(a);var N=new AST(v);this.modifyTree(N.nodes),N.addToDOM(d.element),this.modifyDOM(),this.ellipsis&&(a.textContent||"").indexOf("…")!==-1&&d.attr("title",this.unescapeEntities(d.textStr||"",["&lt;","&gt;"])),T&&T.removeChild(a)}isString$a(this.textOutline)&&d.applyTextOutline&&d.applyTextOutline(this.textOutline)}},g.prototype.modifyDOM=function(){var d=this,a=this.svgElement,u=attr$5(a.element,"x");a.firstLineMetrics=void 0;for(var v;(v=a.element.firstChild)&&/^[\s\u200B]*$/.test(v.textContent||" ");)a.element.removeChild(v);[].forEach.call(a.element.querySelectorAll("tspan.highcharts-br"),function(P,z){P.nextSibling&&P.previousSibling&&(z===0&&P.previousSibling.nodeType===1&&(a.firstLineMetrics=a.renderer.fontMetrics(void 0,P.previousSibling)),attr$5(P,{dy:d.getLineHeight(P.nextSibling),x:u}))});var x=this.width||0;if(x){var S=function(P,z){var L=P.textContent||"",N=L.replace(/([^\^])-/g,"$1- ").split(" "),$=!d.noWrap&&(N.length>1||a.element.childNodes.length>1),B=d.getLineHeight(z),U=0,j=a.actualWidth;if(d.ellipsis)L&&d.truncate(P,L,void 0,0,Math.max(0,x-parseInt(d.fontSize||12,10)),function(Q,J){return Q.substring(0,J)+"…"});else if($){for(var Y=[],q=[];z.firstChild&&z.firstChild!==P;)q.push(z.firstChild),z.removeChild(z.firstChild);for(;N.length;)N.length&&!d.noWrap&&U>0&&(Y.push(P.textContent||""),P.textContent=N.join(" ").replace(/- /g,"-")),d.truncate(P,void 0,N,U===0&&j||0,x,function(Q,J){return N.slice(0,J).join(" ").replace(/- /g,"-")}),j=a.actualWidth,U++;q.forEach(function(Q){z.insertBefore(Q,P)}),Y.forEach(function(Q){z.insertBefore(doc$k.createTextNode(Q),P);var J=doc$k.createElementNS(SVG_NS$1,"tspan");J.textContent="​",attr$5(J,{dy:B,x:u}),z.insertBefore(J,P)})}},T=(function(P){var z=[].slice.call(P.childNodes);z.forEach(function(L){L.nodeType===Node.TEXT_NODE?S(L,P):(L.className.baseVal.indexOf("highcharts-br")!==-1&&(a.actualWidth=0),T(L))})});T(a.element)}},g.prototype.getLineHeight=function(d){var a,u=d.nodeType===Node.TEXT_NODE?d.parentElement:d;return this.renderer.styledMode||(a=u&&/(px|em)$/.test(u.style.fontSize)?u.style.fontSize:this.fontSize||this.renderer.style.fontSize||12),this.textLineHeight?parseInt(this.textLineHeight.toString(),10):this.renderer.fontMetrics(a,u||this.svgElement.element).h},g.prototype.modifyTree=function(d){var a=this,u=function(v,x){var S=v.tagName,T=a.renderer.styledMode,P=v.attributes||{};if(S==="b"||S==="strong"?T?P.class="highcharts-strong":P.style="font-weight:bold;"+(P.style||""):(S==="i"||S==="em")&&(T?P.class="highcharts-emphasized":P.style="font-style:italic;"+(P.style||"")),isString$a(P.style)&&(P.style=P.style.replace(/(;| |^)color([ :])/,"$1fill$2")),S==="br"){P.class="highcharts-br",v.textContent="​";var z=d[x+1];z&&z.textContent&&(z.textContent=z.textContent.replace(/^ +/gm,""))}S!=="#text"&&S!=="a"&&(v.tagName="tspan"),v.attributes=P,v.children&&v.children.filter(function(L){return L.tagName!=="#text"}).forEach(u)};d.forEach(u)},g.prototype.truncate=function(d,a,u,v,x,S){var T=this.svgElement,P=T.renderer,z=T.rotation,L=[],N=u?1:0,$=(a||u||"").length,B=$,U,j,Y=function(q,Q){var J=Q||q,ee=d.parentNode;if(ee&&typeof L[J]>"u")if(ee.getSubStringLength)try{L[J]=v+ee.getSubStringLength(0,u?J+1:J)}catch{}else P.getSpanWidth&&(d.textContent=S(a||u,q),L[J]=v+P.getSpanWidth(T,d));return L[J]};if(T.rotation=0,j=Y(d.textContent.length),v+j>x){for(;N<=$;)B=Math.ceil((N+$)/2),u&&(U=S(u,B)),j=Y(B,U&&U.length-1),N===$?N=$+1:j>x?$=B-1:N=B;$===0?d.textContent="":a&&$===a.length-1||(d.textContent=U||S(a||u,B))}u&&u.splice(0,B),T.actualWidth=j,T.rotation=z},g.prototype.unescapeEntities=function(d,a){return objectEach$x(this.renderer.escapes,function(u,v){(!a||a.indexOf(u)===-1)&&(d=d.toString().replace(new RegExp(u,"g"),v))}),d},g})(),charts$4=H.charts,deg2rad$8=H.deg2rad,doc$j=H.doc,isFirefox$3=H.isFirefox,isMS$2=H.isMS,isWebKit$1=H.isWebKit,noop$j=H.noop,SVG_NS=H.SVG_NS,symbolSizes=H.symbolSizes,win$c=H.win,addEvent$17=Utilities.addEvent,attr$4=Utilities.attr,createElement$8=Utilities.createElement,css$b=Utilities.css,defined$U=Utilities.defined,destroyObjectProperties$9=Utilities.destroyObjectProperties,extend$1u=Utilities.extend,isArray$n=Utilities.isArray,isNumber$P=Utilities.isNumber,isObject$f=Utilities.isObject,isString$9=Utilities.isString,merge$1q=Utilities.merge,pick$1B=Utilities.pick,pInt$6=Utilities.pInt,uniqueKey$6=Utilities.uniqueKey,hasInternalReferenceBug,SVGRenderer=(function(){function g(d,a,u,v,x,S,T){this.alignedObjects=void 0,this.box=void 0,this.boxWrapper=void 0,this.cache=void 0,this.cacheKeys=void 0,this.chartIndex=void 0,this.defs=void 0,this.globalAnimation=void 0,this.gradients=void 0,this.height=void 0,this.imgCount=void 0,this.isSVG=void 0,this.style=void 0,this.url=void 0,this.width=void 0,this.init(d,a,u,v,x,S,T)}return g.prototype.init=function(d,a,u,v,x,S,T){var P=this,z=P.createElement("svg").attr({version:"1.1",class:"highcharts-root"}),L=z.element;T||z.css(this.getStyle(v)),d.appendChild(L),attr$4(d,"dir","ltr"),d.innerHTML.indexOf("xmlns")===-1&&attr$4(L,"xmlns",this.SVG_NS),P.isSVG=!0,this.box=L,this.boxWrapper=z,P.alignedObjects=[],this.url=this.getReferenceURL();var N=this.createElement("desc").add();N.element.appendChild(doc$j.createTextNode("Created with Highcharts 9.2.2")),P.defs=this.createElement("defs").add(),P.allowHTML=S,P.forExport=x,P.styledMode=T,P.gradients={},P.cache={},P.cacheKeys=[],P.imgCount=0,P.setSize(a,u,!1);var $,B;isFirefox$3&&d.getBoundingClientRect&&($=function(){css$b(d,{left:0,top:0}),B=d.getBoundingClientRect(),css$b(d,{left:Math.ceil(B.left)-B.left+"px",top:Math.ceil(B.top)-B.top+"px"})},$(),P.unSubPixelFix=addEvent$17(win$c,"resize",$))},g.prototype.definition=function(d){var a=new AST([d]);return a.addToDOM(this.defs.element)},g.prototype.getReferenceURL=function(){if((isFirefox$3||isWebKit$1)&&doc$j.getElementsByTagName("base").length){if(!defined$U(hasInternalReferenceBug)){var d=uniqueKey$6(),a=new AST([{tagName:"svg",attributes:{width:8,height:8},children:[{tagName:"defs",children:[{tagName:"clipPath",attributes:{id:d},children:[{tagName:"rect",attributes:{width:4,height:4}}]}]},{tagName:"rect",attributes:{id:"hitme",width:8,height:8,"clip-path":"url(#"+d+")",fill:"rgba(0,0,0,0.001)"}}]}]),u=a.addToDOM(doc$j.body);css$b(u,{position:"fixed",top:0,left:0,zIndex:9e5});var v=doc$j.elementFromPoint(6,6);hasInternalReferenceBug=(v&&v.id)==="hitme",doc$j.body.removeChild(u)}if(hasInternalReferenceBug)return win$c.location.href.split("#")[0].replace(/<[^>]*>/g,"").replace(/([\('\)])/g,"\\$1").replace(/ /g,"%20")}return""},g.prototype.getStyle=function(d){return this.style=extend$1u({fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',fontSize:"12px"},d),this.style},g.prototype.setStyle=function(d){this.boxWrapper.css(this.getStyle(d))},g.prototype.isHidden=function(){return!this.boxWrapper.getBBox().width},g.prototype.destroy=function(){var d=this,a=d.defs;return d.box=null,d.boxWrapper=d.boxWrapper.destroy(),destroyObjectProperties$9(d.gradients||{}),d.gradients=null,a&&(d.defs=a.destroy()),d.unSubPixelFix&&d.unSubPixelFix(),d.alignedObjects=null,null},g.prototype.createElement=function(d){var a=new this.Element;return a.init(this,d),a},g.prototype.getRadialAttr=function(d,a){return{cx:d[0]-d[2]/2+(a.cx||0)*d[2],cy:d[1]-d[2]/2+(a.cy||0)*d[2],r:(a.r||0)*d[2]}},g.prototype.buildText=function(d){new TextBuilder(d).buildSVG()},g.prototype.getContrast=function(d){return d=Color.parse(d).rgba,d[0]*=1,d[1]*=1.2,d[2]*=.5,d[0]+d[1]+d[2]>1.8*255?"#000000":"#FFFFFF"},g.prototype.button=function(d,a,u,v,x,S,T,P,z,L){var N=this.label(d,a,u,z,void 0,void 0,L,void 0,"button"),$=this.styledMode,B=0,U=x?merge$1q(x):{},j=U&&U.style||{};U=AST.filterUserAttributes(U),N.attr(merge$1q({padding:8,r:2},U));var Y,q,Q,J;return $||(U=merge$1q({fill:palette.neutralColor3,stroke:palette.neutralColor20,"stroke-width":1,style:{color:palette.neutralColor80,cursor:"pointer",fontWeight:"normal"}},{style:j},U),Y=U.style,delete U.style,S=merge$1q(U,{fill:palette.neutralColor10},AST.filterUserAttributes(S||{})),q=S.style,delete S.style,T=merge$1q(U,{fill:palette.highlightColor10,style:{color:palette.neutralColor100,fontWeight:"bold"}},AST.filterUserAttributes(T||{})),Q=T.style,delete T.style,P=merge$1q(U,{style:{color:palette.neutralColor20}},AST.filterUserAttributes(P||{})),J=P.style,delete P.style),addEvent$17(N.element,isMS$2?"mouseover":"mouseenter",function(){B!==3&&N.setState(1)}),addEvent$17(N.element,isMS$2?"mouseout":"mouseleave",function(){B!==3&&N.setState(B)}),N.setState=function(ee){ee!==1&&(N.state=B=ee),N.removeClass(/highcharts-button-(normal|hover|pressed|disabled)/).addClass("highcharts-button-"+["normal","hover","pressed","disabled"][ee||0]),$||N.attr([U,S,T,P][ee||0]).css([Y,q,Q,J][ee||0])},$||N.attr(U).css(extend$1u({cursor:"default"},Y)),N.on("touchstart",function(ee){return ee.stopPropagation()}).on("click",function(ee){B!==3&&v.call(N,ee)})},g.prototype.crispLine=function(d,a,u){u===void 0&&(u="round");var v=d[0],x=d[1];return defined$U(v[1])&&v[1]===x[1]&&(v[1]=x[1]=Math[u](v[1])-a%2/2),defined$U(v[2])&&v[2]===x[2]&&(v[2]=x[2]=Math[u](v[2])+a%2/2),d},g.prototype.path=function(d){var a=this.styledMode?{}:{fill:"none"};return isArray$n(d)?a.d=d:isObject$f(d)&&extend$1u(a,d),this.createElement("path").attr(a)},g.prototype.circle=function(d,a,u){var v=isObject$f(d)?d:typeof d>"u"?{}:{x:d,y:a,r:u},x=this.createElement("circle");return x.xSetter=x.ySetter=function(S,T,P){P.setAttribute("c"+T,S)},x.attr(v)},g.prototype.arc=function(d,a,u,v,x,S){var T;isObject$f(d)?(T=d,a=T.y,u=T.r,v=T.innerR,x=T.start,S=T.end,d=T.x):T={innerR:v,start:x,end:S};var P=this.symbol("arc",d,a,u,u,T);return P.r=u,P},g.prototype.rect=function(d,a,u,v,x,S){x=isObject$f(d)?d.r:x;var T=this.createElement("rect"),P=isObject$f(d)?d:typeof d>"u"?{}:{x:d,y:a,width:Math.max(u,0),height:Math.max(v,0)};return this.styledMode||(typeof S<"u"&&(P["stroke-width"]=S,P=T.crisp(P)),P.fill="none"),x&&(P.r=x),T.rSetter=function(z,L,N){T.r=z,attr$4(N,{rx:z,ry:z})},T.rGetter=function(){return T.r||0},T.attr(P)},g.prototype.setSize=function(d,a,u){var v=this;v.width=d,v.height=a,v.boxWrapper.animate({width:d,height:a},{step:function(){this.attr({viewBox:"0 0 "+this.attr("width")+" "+this.attr("height")})},duration:pick$1B(u,!0)?void 0:0}),v.alignElements()},g.prototype.g=function(d){var a=this.createElement("g");return d?a.attr({class:"highcharts-"+d}):a},g.prototype.image=function(d,a,u,v,x,S){var T={preserveAspectRatio:"none"},P=function($,B){$.setAttributeNS?$.setAttributeNS("http://www.w3.org/1999/xlink","href",B):$.setAttribute("hc-svg-href",B)};arguments.length>1&&extend$1u(T,{x:a,y:u,width:v,height:x});var z=this.createElement("image").attr(T),L=function($){P(z.element,d),S.call(z,$)};if(S){P(z.element,"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==");var N=new win$c.Image;addEvent$17(N,"load",L),N.src=d,N.complete&&L({})}else P(z.element,d);return z},g.prototype.symbol=function(d,a,u,v,x,S){var T=this,P=/^url\((.*?)\)$/,z=P.test(d),L=!z&&(this.symbols[d]?d:"circle"),N=L&&this.symbols[L],$,B,U,j;if(N)typeof a=="number"&&(B=N.call(this.symbols,Math.round(a||0),Math.round(u||0),v||0,x||0,S)),$=this.path(B),T.styledMode||$.attr("fill","none"),extend$1u($,{symbolName:L||void 0,x:a,y:u,width:v,height:x}),S&&extend$1u($,S);else if(z){U=d.match(P)[1];var Y=$=this.image(U);Y.imgwidth=pick$1B(symbolSizes[U]&&symbolSizes[U].width,S&&S.width),Y.imgheight=pick$1B(symbolSizes[U]&&symbolSizes[U].height,S&&S.height),j=function(q){return q.attr({width:q.width,height:q.height})},["width","height"].forEach(function(q){Y[q+"Setter"]=function(Q,J){var ee=this["img"+J];if(this[J]=Q,defined$U(ee)&&(S&&S.backgroundSize==="within"&&this.width&&this.height&&(ee=Math.round(ee*Math.min(this.width/this.imgwidth,this.height/this.imgheight))),this.element&&this.element.setAttribute(J,ee),!this.alignByTranslate)){var ie=((this[J]||0)-ee)/2,ne=J==="width"?{translateX:ie}:{translateY:ie};this.attr(ne)}}}),defined$U(a)&&Y.attr({x:a,y:u}),Y.isImg=!0,defined$U(Y.imgwidth)&&defined$U(Y.imgheight)?j(Y):(Y.attr({width:0,height:0}),createElement$8("img",{onload:function(){var q=charts$4[T.chartIndex];this.width===0&&(css$b(this,{position:"absolute",top:"-999em"}),doc$j.body.appendChild(this)),symbolSizes[U]={width:this.width,height:this.height},Y.imgwidth=this.width,Y.imgheight=this.height,Y.element&&j(Y),this.parentNode&&this.parentNode.removeChild(this),T.imgCount--,!T.imgCount&&q&&!q.hasLoaded&&q.onload()},src:U}),this.imgCount++)}return $},g.prototype.clipRect=function(d,a,u,v){var x=uniqueKey$6()+"-",S=this.createElement("clipPath").attr({id:x}).add(this.defs),T=this.rect(d,a,u,v,0).add(S);return T.id=x,T.clipPath=S,T.count=0,T},g.prototype.text=function(d,a,u,v){var x=this,S={};if(v&&(x.allowHTML||!x.forExport))return x.html(d,a,u);S.x=Math.round(a||0),u&&(S.y=Math.round(u)),defined$U(d)&&(S.text=d);var T=x.createElement("text").attr(S);return(!v||x.forExport&&!x.allowHTML)&&(T.xSetter=function(P,z,L){for(var N=L.getElementsByTagName("tspan"),$=L.getAttribute(z),B=0,U=void 0;B<N.length;B++)U=N[B],U.getAttribute(z)===$&&U.setAttribute(z,P);L.setAttribute(z,P)}),T},g.prototype.fontMetrics=function(d,a){(this.styledMode||!/px/.test(d))&&win$c.getComputedStyle?d=a&&SVGElement.prototype.getStyle.call(a,"font-size"):d=d||a&&a.style&&a.style.fontSize||this.style&&this.style.fontSize,/px/.test(d)?d=pInt$6(d):d=12;var u=d<24?d+3:Math.round(d*1.2),v=Math.round(u*.8);return{h:u,b:v,f:d}},g.prototype.rotCorr=function(d,a,u){var v=d;return a&&u&&(v=Math.max(v*Math.cos(a*deg2rad$8),4)),{x:-d/3*Math.sin(a*deg2rad$8),y:v}},g.prototype.pathToSegments=function(d){for(var a=[],u=[],v={A:8,C:7,H:2,L:3,M:3,Q:5,S:5,T:3,V:2},x=0;x<d.length;x++)isString$9(u[0])&&isNumber$P(d[x])&&u.length===v[u[0].toUpperCase()]&&d.splice(x,0,u[0].replace("M","L").replace("m","l")),typeof d[x]=="string"&&(u.length&&a.push(u.slice(0)),u.length=0),u.push(d[x]);return a.push(u.slice(0)),a},g.prototype.label=function(d,a,u,v,x,S,T,P,z){return new SVGLabel(this,d,a,u,v,x,S,T,P,z)},g.prototype.alignElements=function(){this.alignedObjects.forEach(function(d){return d.align()})},g})();extend$1u(SVGRenderer.prototype,{Element:SVGElement,SVG_NS,escapes:{"&":"&amp;","<":"&lt;",">":"&gt;","'":"&#39;",'"':"&quot;"},symbols:Symbols,draw:noop$j});RendererRegistry$1.registerRendererType("svg",SVGRenderer,!0);var __extends$2g=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),isFirefox$2=H.isFirefox,isMS$1=H.isMS,isWebKit=H.isWebKit,win$b=H.win,css$a=Utilities.css,defined$T=Utilities.defined,extend$1t=Utilities.extend,pick$1A=Utilities.pick,pInt$5=Utilities.pInt,HTMLElement$1=(function(g){__extends$2g(d,g);function d(){return g!==null&&g.apply(this,arguments)||this}return d.compose=function(a){if(d.composedClasses.indexOf(a)===-1){d.composedClasses.push(a);var u=d.prototype,v=a.prototype;v.getSpanCorrection=u.getSpanCorrection,v.htmlCss=u.htmlCss,v.htmlGetBBox=u.htmlGetBBox,v.htmlUpdateTransform=u.htmlUpdateTransform,v.setSpanRotation=u.setSpanRotation}return a},d.prototype.getSpanCorrection=function(a,u,v){this.xCorr=-a*v,this.yCorr=-u},d.prototype.htmlCss=function(a){var u=this,v=u.element,x=v.tagName==="SPAN"&&a&&"width"in a,S=pick$1A(x&&a.width,void 0),T;return x&&(delete a.width,u.textWidth=S,T=!0),a&&a.textOverflow==="ellipsis"&&(a.whiteSpace="nowrap",a.overflow="hidden"),u.styles=extend$1t(u.styles,a),css$a(u.element,a),T&&u.htmlUpdateTransform(),u},d.prototype.htmlGetBBox=function(){var a=this,u=a.element;return{x:u.offsetLeft,y:u.offsetTop,width:u.offsetWidth,height:u.offsetHeight}},d.prototype.htmlUpdateTransform=function(){if(!this.added){this.alignOnAdd=!0;return}var a=this,u=a.renderer,v=a.element,x=a.translateX||0,S=a.translateY||0,T=a.x||0,P=a.y||0,z=a.textAlign||"left",L={left:0,center:.5,right:1}[z],N=a.styles,$=N&&N.whiteSpace;function B(){return css$a(v,{width:"",whiteSpace:$||"nowrap"}),v.offsetWidth}if(css$a(v,{marginLeft:x,marginTop:S}),!u.styledMode&&a.shadows&&a.shadows.forEach(function(Q){css$a(Q,{marginLeft:x+1,marginTop:S+1})}),a.inverted&&[].forEach.call(v.childNodes,function(Q){u.invertChild(Q,v)}),v.tagName==="SPAN"){var U=a.rotation,j=a.textWidth&&pInt$5(a.textWidth),Y=[U,z,v.innerHTML,a.textWidth,a.textAlign].join(","),q=void 0;j!==a.oldTextWidth&&(j>a.oldTextWidth||(a.textPxLength||B())>j)&&(/[ \-]/.test(v.textContent||v.innerText)||v.style.textOverflow==="ellipsis")?(css$a(v,{width:j+"px",display:"block",whiteSpace:$||"normal"}),a.oldTextWidth=j,a.hasBoxWidthChanged=!0):a.hasBoxWidthChanged=!1,Y!==a.cTT&&(q=u.fontMetrics(v.style.fontSize,v).b,defined$T(U)&&(U!==(a.oldRotation||0)||z!==a.oldAlign)&&a.setSpanRotation(U,L,q),a.getSpanCorrection(!defined$T(U)&&a.textPxLength||v.offsetWidth,q,L,U,z)),css$a(v,{left:T+(a.xCorr||0)+"px",top:P+(a.yCorr||0)+"px"}),a.cTT=Y,a.oldRotation=U,a.oldAlign=z}},d.prototype.setSpanRotation=function(a,u,v){var x=function(){return isMS$1&&!/Edge/.test(win$b.navigator.userAgent)?"-ms-transform":isWebKit?"-webkit-transform":isFirefox$2?"MozTransform":win$b.opera?"-o-transform":void 0},S={},T=x();T&&(S[T]=S.transform="rotate("+a+"deg)",S[T+(isFirefox$2?"Origin":"-origin")]=S.transformOrigin=u*100+"% "+v+"px",css$a(this.element,S))},d.composedClasses=[],d})(SVGElement),__extends$2f=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),attr$3=Utilities.attr,createElement$7=Utilities.createElement,extend$1s=Utilities.extend,pick$1z=Utilities.pick,HTMLRenderer=(function(g){__extends$2f(d,g);function d(){return g!==null&&g.apply(this,arguments)||this}return d.compose=function(a){if(d.composedClasses.indexOf(a)===-1){d.composedClasses.push(a);var u=d.prototype,v=a.prototype;v.html=u.html}return a},d.prototype.html=function(a,u,v){var x=this.createElement("span"),S=x.element,T=x.renderer,P=T.isSVG,z=function(L,N){["opacity","visibility"].forEach(function($){L[$+"Setter"]=function(B,U,j){var Y=L.div?L.div.style:N;SVGElement.prototype[$+"Setter"].call(this,B,U,j),Y&&(Y[U]=B)}}),L.addedSetters=!0};return x.textSetter=function(L){L!==this.textStr&&(delete this.bBox,delete this.oldTextWidth,AST.setElementHTML(this.element,pick$1z(L,"")),this.textStr=L,x.doTransform=!0)},P&&z(x,x.element.style),x.xSetter=x.ySetter=x.alignSetter=x.rotationSetter=function(L,N){N==="align"?x.alignValue=x.textAlign=L:x[N]=L,x.doTransform=!0},x.afterSetters=function(){this.doTransform&&(this.htmlUpdateTransform(),this.doTransform=!1)},x.attr({text:a,x:Math.round(u),y:Math.round(v)}).css({position:"absolute"}),T.styledMode||x.css({fontFamily:this.style.fontFamily,fontSize:this.style.fontSize}),S.style.whiteSpace="nowrap",x.css=x.htmlCss,P&&(x.add=function(L){var N=T.box.parentNode,$=[],B,U;if(this.parentGroup=L,L){if(B=L.div,!B){for(U=L;U;)$.push(U),U=U.parentGroup;$.reverse().forEach(function(j){var Y=attr$3(j.element,"class");function q(ee,ie){j[ie]=ee,ie==="translateX"?J.left=ee+"px":J.top=ee+"px",j.doTransform=!0}var Q=j.styles||{};B=j.div=j.div||createElement$7("div",Y?{className:Y}:void 0,{position:"absolute",left:(j.translateX||0)+"px",top:(j.translateY||0)+"px",display:j.display,opacity:j.opacity,cursor:Q.cursor,pointerEvents:Q.pointerEvents,visibility:j.visibility},B||N);var J=B.style;extend$1s(j,{classSetter:(function(ee){return function(ie){this.element.setAttribute("class",ie),ee.className=ie}})(B),on:function(){return $[0].div&&x.on.apply({element:$[0].div,onEvents:j.onEvents},arguments),j},translateXSetter:q,translateYSetter:q}),j.addedSetters||z(j)})}}else B=N;return B.appendChild(S),x.added=!0,x.alignOnAdd&&x.htmlUpdateTransform(),x}),x},d.composedClasses=[],d})(SVGRenderer),AxisDefaults;(function(g){g.defaultXAxisOptions={alignTicks:!0,allowDecimals:void 0,panningEnabled:!0,zIndex:2,zoomEnabled:!0,dateTimeLabelFormats:{millisecond:{main:"%H:%M:%S.%L",range:!1},second:{main:"%H:%M:%S",range:!1},minute:{main:"%H:%M",range:!1},hour:{main:"%H:%M",range:!1},day:{main:"%e. %b"},week:{main:"%e. %b"},month:{main:"%b '%y"},year:{main:"%Y"}},endOnTick:!1,gridLineDashStyle:"Solid",gridZIndex:1,labels:{autoRotation:void 0,autoRotationLimit:80,distance:void 0,enabled:!0,indentation:10,overflow:"justify",padding:5,reserveSpace:void 0,rotation:void 0,staggerLines:0,step:0,useHTML:!1,x:0,zIndex:7,style:{color:palette.neutralColor60,cursor:"default",fontSize:"11px"}},maxPadding:.01,minorGridLineDashStyle:"Solid",minorTickLength:2,minorTickPosition:"outside",minPadding:.01,offset:void 0,opposite:!1,reversed:void 0,reversedStacks:!1,showEmpty:!0,showFirstLabel:!0,showLastLabel:!0,startOfWeek:1,startOnTick:!1,tickLength:10,tickPixelInterval:100,tickmarkPlacement:"between",tickPosition:"outside",title:{align:"middle",rotation:0,useHTML:!1,x:0,y:0,style:{color:palette.neutralColor60}},type:"linear",uniqueNames:!0,visible:!0,minorGridLineColor:palette.neutralColor5,minorGridLineWidth:1,minorTickColor:palette.neutralColor40,lineColor:palette.highlightColor20,lineWidth:1,gridLineColor:palette.neutralColor10,gridLineWidth:void 0,tickColor:palette.highlightColor20},g.defaultYAxisOptions={reversedStacks:!0,endOnTick:!0,maxPadding:.05,minPadding:.05,tickPixelInterval:72,showLastLabel:!0,labels:{x:-8},startOnTick:!0,title:{rotation:270,text:"Values"},stackLabels:{animation:{},allowOverlap:!1,enabled:!1,crop:!0,overflow:"justify",formatter:function(){var d=this.axis.chart.numberFormatter;return d(this.total,-1)},style:{color:palette.neutralColor100,fontSize:"11px",fontWeight:"bold",textOutline:"1px contrast"}},gridLineWidth:1,lineWidth:0},g.defaultLeftAxisOptions={labels:{x:-15},title:{rotation:270}},g.defaultRightAxisOptions={labels:{x:15},title:{rotation:90}},g.defaultBottomAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}},g.defaultTopAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}}})(AxisDefaults||(AxisDefaults={}));const AxisDefaults$1=AxisDefaults;var addEvent$16=Utilities.addEvent,isFunction$3=Utilities.isFunction,objectEach$w=Utilities.objectEach,removeEvent$a=Utilities.removeEvent,registerEventOptions$3=function(g,d){g.eventOptions=g.eventOptions||{},objectEach$w(d.events,function(a,u){g.eventOptions[u]!==a&&(g.eventOptions[u]&&(removeEvent$a(g,u,g.eventOptions[u]),delete g.eventOptions[u]),isFunction$3(a)&&(g.eventOptions[u]=a,addEvent$16(g,u,a)))})},exports$6={registerEventOptions:registerEventOptions$3},deg2rad$7=H.deg2rad,clamp$j=Utilities.clamp,correctFloat$c=Utilities.correctFloat,defined$S=Utilities.defined,destroyObjectProperties$8=Utilities.destroyObjectProperties,extend$1r=Utilities.extend,fireEvent$A=Utilities.fireEvent,isNumber$O=Utilities.isNumber,merge$1p=Utilities.merge,objectEach$v=Utilities.objectEach,pick$1y=Utilities.pick,Tick=(function(){function g(d,a,u,v,x){this.isNew=!0,this.isNewLabel=!0,this.axis=d,this.pos=a,this.type=u||"",this.parameters=x||{},this.tickmarkOffset=this.parameters.tickmarkOffset,this.options=this.parameters.options,fireEvent$A(this,"init"),!u&&!v&&this.addLabel()}return g.prototype.addLabel=function(){var d=this,a=d.axis,u=a.options,v=a.chart,x=a.categories,S=a.logarithmic,T=a.names,P=d.pos,z=pick$1y(d.options&&d.options.labels,u.labels),L=a.tickPositions,N=P===L[0],$=P===L[L.length-1],B=(!z.step||z.step===1)&&a.tickInterval===1,U=L.info,j=d.label,Y,q,Q,J=this.parameters.category||(x?pick$1y(x[P],T[P],P):P);S&&isNumber$O(J)&&(J=correctFloat$c(S.lin2log(J))),a.dateTime&&(U?(q=v.time.resolveDTLFormat(u.dateTimeLabelFormats[!u.grid&&U.higherRanks[P]||U.unitName]),Y=q.main):isNumber$O(J)&&(Y=a.dateTime.getXDateFormat(J,u.dateTimeLabelFormats||{}))),d.isFirst=N,d.isLast=$;var ee={axis:a,chart:v,dateTimeLabelFormat:Y,isFirst:N,isLast:$,pos:P,tick:d,tickPositionInfo:U,value:J};fireEvent$A(this,"labelFormat",ee);var ie=function(de){return z.formatter?z.formatter.call(de,de):z.format?(de.text=a.defaultLabelFormatter.call(de),FormatUtilities.format(z.format,de,v)):a.defaultLabelFormatter.call(de,de)},ne=ie.call(ee,ee),ae=q&&q.list;ae?d.shortenLabel=function(){for(Q=0;Q<ae.length;Q++)if(extend$1r(ee,{dateTimeLabelFormat:ae[Q]}),j.attr({text:ie.call(ee,ee)}),j.getBBox().width<a.getSlotWidth(d)-2*z.padding)return;j.attr({text:""})}:d.shortenLabel=void 0,B&&a._addedPlotLB&&d.moveLabel(ne,z),!defined$S(j)&&!d.movedLabel?(d.label=j=d.createLabel({x:0,y:0},ne,z),d.rotation=0):j&&j.textStr!==ne&&!B&&(j.textWidth&&!z.style.width&&!j.styles.width&&j.css({width:null}),j.attr({text:ne}),j.textPxLength=j.getBBox().width)},g.prototype.createLabel=function(d,a,u){var v=this.axis,x=v.chart,S=defined$S(a)&&u.enabled?x.renderer.text(a,d.x,d.y,u.useHTML).add(v.labelGroup):null;return S&&(x.styledMode||S.css(merge$1p(u.style)),S.textPxLength=S.getBBox().width),S},g.prototype.destroy=function(){destroyObjectProperties$8(this,this.axis)},g.prototype.getPosition=function(d,a,u,v){var x=this.axis,S=x.chart,T=v&&S.oldChartHeight||S.chartHeight,P={x:d?correctFloat$c(x.translate(a+u,null,null,v)+x.transB):x.left+x.offset+(x.opposite?(v&&S.oldChartWidth||S.chartWidth)-x.right-x.left:0),y:d?T-x.bottom+x.offset-(x.opposite?x.height:0):correctFloat$c(T-x.translate(a+u,null,null,v)-x.transB)};return P.y=clamp$j(P.y,-1e5,1e5),fireEvent$A(this,"afterGetPosition",{pos:P}),P},g.prototype.getLabelPosition=function(d,a,u,v,x,S,T,P){var z=this.axis,L=z.transA,N=z.isLinked&&z.linkedParent?z.linkedParent.reversed:z.reversed,$=z.staggerLines,B=z.tickRotCorr||{x:0,y:0},U=!v&&!z.reserveSpaceDefault?-z.labelOffset*(z.labelAlign==="center"?.5:1):0,j={},Y=x.y,q;return defined$S(Y)||(z.side===0?Y=u.rotation?-8:-u.getBBox().height:z.side===2?Y=B.y+8:Y=Math.cos(u.rotation*deg2rad$7)*(B.y-u.getBBox(!1,0).height/2)),d=d+x.x+U+B.x-(S&&v?S*L*(N?-1:1):0),a=a+Y-(S&&!v?S*L*(N?1:-1):0),$&&(q=T/(P||1)%$,z.opposite&&(q=$-q-1),a+=q*(z.labelOffset/$)),j.x=d,j.y=Math.round(a),fireEvent$A(this,"afterGetLabelPosition",{pos:j,tickmarkOffset:S,index:T}),j},g.prototype.getLabelSize=function(){return this.label?this.label.getBBox()[this.axis.horiz?"height":"width"]:0},g.prototype.getMarkPath=function(d,a,u,v,x,S){return S.crispLine([["M",d,a],["L",d+(x?0:-u),a+(x?u:0)]],v)},g.prototype.handleOverflow=function(d){var a=this,u=this.axis,v=u.options.labels,x=d.x,S=u.chart.chartWidth,T=u.chart.spacing,P=pick$1y(u.labelLeft,Math.min(u.pos,T[3])),z=pick$1y(u.labelRight,Math.max(u.isRadial?0:u.pos+u.len,S-T[1])),L=this.label,N=this.rotation,$={left:0,center:.5,right:1}[u.labelAlign||L.attr("align")],B=L.getBBox().width,U=u.getSlotWidth(a),j=$,Y={},q=U,Q=1,J,ee,ie;!N&&v.overflow==="justify"?(J=x-$*B,ee=x+(1-$)*B,J<P?q=d.x+q*(1-$)-P:ee>z&&(q=z-d.x+q*$,Q=-1),q=Math.min(U,q),q<U&&u.labelAlign==="center"&&(d.x+=Q*(U-q-j*(U-Math.min(B,q)))),(B>q||u.autoRotation&&(L.styles||{}).width)&&(ie=q)):N<0&&x-$*B<P?ie=Math.round(x/Math.cos(N*deg2rad$7)-P):N>0&&x+$*B>z&&(ie=Math.round((S-x)/Math.cos(N*deg2rad$7))),ie&&(a.shortenLabel?a.shortenLabel():(Y.width=Math.floor(ie)+"px",(v.style||{}).textOverflow||(Y.textOverflow="ellipsis"),L.css(Y)))},g.prototype.moveLabel=function(d,a){var u=this,v=u.label,x=u.axis,S=x.reversed,T=!1,P,z,L;v&&v.textStr===d?(u.movedLabel=v,T=!0,delete u.label):objectEach$v(x.ticks,function(N){!T&&!N.isNew&&N!==u&&N.label&&N.label.textStr===d&&(u.movedLabel=N.label,T=!0,N.labelPos=u.movedLabel.xy,delete N.label)}),!T&&(u.labelPos||v)&&(P=u.labelPos||v.xy,z=x.horiz?S?0:x.width+x.left:P.x,L=x.horiz?P.y:S?x.width+x.left:0,u.movedLabel=u.createLabel({x:z,y:L},d,a),u.movedLabel&&u.movedLabel.attr({opacity:0}))},g.prototype.render=function(d,a,u){var v=this,x=v.axis,S=x.horiz,T=v.pos,P=pick$1y(v.tickmarkOffset,x.tickmarkOffset),z=v.getPosition(S,T,P,a),L=z.x,N=z.y,$=S&&L===x.pos+x.len||!S&&N===x.pos?-1:1,B=pick$1y(u,v.label&&v.label.newOpacity,1);u=pick$1y(u,1),this.isActive=!0,this.renderGridLine(a,u,$),this.renderMark(z,u,$),this.renderLabel(z,a,B,d),v.isNew=!1,fireEvent$A(this,"afterRender")},g.prototype.renderGridLine=function(d,a,u){var v=this,x=v.axis,S=x.options,T={},P=v.pos,z=v.type,L=pick$1y(v.tickmarkOffset,x.tickmarkOffset),N=x.chart.renderer,$=v.gridLine,B,U=S.gridLineWidth,j=S.gridLineColor,Y=S.gridLineDashStyle;v.type==="minor"&&(U=S.minorGridLineWidth,j=S.minorGridLineColor,Y=S.minorGridLineDashStyle),$||(x.chart.styledMode||(T.stroke=j,T["stroke-width"]=U||0,T.dashstyle=Y),z||(T.zIndex=1),d&&(a=0),v.gridLine=$=N.path().attr(T).addClass("highcharts-"+(z?z+"-":"")+"grid-line").add(x.gridGroup)),$&&(B=x.getPlotLinePath({value:P+L,lineWidth:$.strokeWidth()*u,force:"pass",old:d}),B&&$[d||v.isNew?"attr":"animate"]({d:B,opacity:a}))},g.prototype.renderMark=function(d,a,u){var v=this,x=v.axis,S=x.options,T=x.chart.renderer,P=v.type,z=x.tickSize(P?P+"Tick":"tick"),L=d.x,N=d.y,$=pick$1y(S[P!=="minor"?"tickWidth":"minorTickWidth"],!P&&x.isXAxis?1:0),B=S[P!=="minor"?"tickColor":"minorTickColor"],U=v.mark,j=!U;z&&(x.opposite&&(z[0]=-z[0]),U||(v.mark=U=T.path().addClass("highcharts-"+(P?P+"-":"")+"tick").add(x.axisGroup),x.chart.styledMode||U.attr({stroke:B,"stroke-width":$})),U[j?"attr":"animate"]({d:v.getMarkPath(L,N,z[0],U.strokeWidth()*u,x.horiz,T),opacity:a}))},g.prototype.renderLabel=function(d,a,u,v){var x=this,S=x.axis,T=S.horiz,P=S.options,z=x.label,L=P.labels,N=L.step,$=pick$1y(x.tickmarkOffset,S.tickmarkOffset),B=d.x,U=d.y,j=!0;z&&isNumber$O(B)&&(z.xy=d=x.getLabelPosition(B,U,z,T,L,$,v,N),x.isFirst&&!x.isLast&&!P.showFirstLabel||x.isLast&&!x.isFirst&&!P.showLastLabel?j=!1:T&&!L.step&&!L.rotation&&!a&&u!==0&&x.handleOverflow(d),N&&v%N&&(j=!1),j&&isNumber$O(d.y)?(d.opacity=u,z[x.isNewLabel?"attr":"animate"](d),x.isNewLabel=!1):(z.attr("y",-9999),x.isNewLabel=!0))},g.prototype.replaceMovedLabel=function(){var d=this,a=d.label,u=d.axis,v=u.reversed,x,S;a&&!d.isNew&&(x=u.horiz?v?u.left:u.width+u.left:a.xy.x,S=u.horiz?a.xy.y:v?u.width+u.top:u.top,a.animate({x,y:S,opacity:0},void 0,a.destroy),delete d.label),u.isDirty=!0,d.label=d.movedLabel,delete d.movedLabel},g})(),animObject$b=animationExports.animObject,defaultOptions$h=DefaultOptions.defaultOptions,registerEventOptions$2=exports$6.registerEventOptions,deg2rad$6=H.deg2rad,arrayMax$9=Utilities.arrayMax,arrayMin$8=Utilities.arrayMin,clamp$i=Utilities.clamp,correctFloat$b=Utilities.correctFloat,defined$R=Utilities.defined,destroyObjectProperties$7=Utilities.destroyObjectProperties,erase$8=Utilities.erase,error$9=Utilities.error,extend$1q=Utilities.extend,fireEvent$z=Utilities.fireEvent,getMagnitude$2=Utilities.getMagnitude,isArray$m=Utilities.isArray,isNumber$N=Utilities.isNumber,isString$8=Utilities.isString,merge$1o=Utilities.merge,normalizeTickInterval$2=Utilities.normalizeTickInterval,objectEach$u=Utilities.objectEach,pick$1x=Utilities.pick,relativeLength$9=Utilities.relativeLength,removeEvent$9=Utilities.removeEvent,splat$i=Utilities.splat,syncTimeout$7=Utilities.syncTimeout,Axis=(function(){function g(d,a){this.alternateBands=void 0,this.bottom=void 0,this.categories=void 0,this.chart=void 0,this.closestPointRange=void 0,this.coll=void 0,this.eventOptions=void 0,this.hasNames=void 0,this.hasVisibleSeries=void 0,this.height=void 0,this.isLinked=void 0,this.labelEdge=void 0,this.labelFormatter=void 0,this.left=void 0,this.len=void 0,this.max=void 0,this.maxLabelLength=void 0,this.min=void 0,this.minorTickInterval=void 0,this.minorTicks=void 0,this.minPixelPadding=void 0,this.names=void 0,this.offset=void 0,this.options=void 0,this.overlap=void 0,this.paddedTicks=void 0,this.plotLinesAndBands=void 0,this.plotLinesAndBandsGroups=void 0,this.pointRange=void 0,this.pointRangePadding=void 0,this.pos=void 0,this.positiveValuesOnly=void 0,this.right=void 0,this.series=void 0,this.side=void 0,this.tickAmount=void 0,this.tickInterval=void 0,this.tickmarkOffset=void 0,this.tickPositions=void 0,this.tickRotCorr=void 0,this.ticks=void 0,this.top=void 0,this.transA=void 0,this.transB=void 0,this.translationSlope=void 0,this.userOptions=void 0,this.visible=void 0,this.width=void 0,this.zoomEnabled=void 0,this.init(d,a)}return g.prototype.init=function(d,a){var u=a.isX,v=this;v.chart=d,v.horiz=d.inverted&&!v.isZAxis?!u:u,v.isXAxis=u,v.coll=v.coll||(u?"xAxis":"yAxis"),fireEvent$z(this,"init",{userOptions:a}),v.opposite=pick$1x(a.opposite,v.opposite),v.side=pick$1x(a.side,v.side,v.horiz?v.opposite?0:2:v.opposite?1:3),v.setOptions(a);var x=this.options,S=x.labels,T=x.type;v.userOptions=a,v.minPixelPadding=0,v.reversed=pick$1x(x.reversed,v.reversed),v.visible=x.visible,v.zoomEnabled=x.zoomEnabled,v.hasNames=T==="category"||x.categories===!0,v.categories=x.categories||v.hasNames,v.names||(v.names=[],v.names.keys={}),v.plotLinesAndBandsGroups={},v.positiveValuesOnly=!!v.logarithmic,v.isLinked=defined$R(x.linkedTo),v.ticks={},v.labelEdge=[],v.minorTicks={},v.plotLinesAndBands=[],v.alternateBands={},v.len=0,v.minRange=v.userMinRange=x.minRange||x.maxZoom,v.range=x.range,v.offset=x.offset||0,v.max=null,v.min=null;var P=pick$1x(x.crosshair,splat$i(d.options.tooltip.crosshairs)[u?0:1]);v.crosshair=P===!0?{}:P,d.axes.indexOf(v)===-1&&(u?d.axes.splice(d.xAxis.length,0,v):d.axes.push(v),d[v.coll].push(v)),v.series=v.series||[],d.inverted&&!v.isZAxis&&u&&typeof v.reversed>"u"&&(v.reversed=!0),v.labelRotation=isNumber$N(S.rotation)?S.rotation:void 0,registerEventOptions$2(v,x),fireEvent$z(this,"afterInit")},g.prototype.setOptions=function(d){this.options=merge$1o(AxisDefaults$1.defaultXAxisOptions,this.coll==="yAxis"&&AxisDefaults$1.defaultYAxisOptions,[AxisDefaults$1.defaultTopAxisOptions,AxisDefaults$1.defaultRightAxisOptions,AxisDefaults$1.defaultBottomAxisOptions,AxisDefaults$1.defaultLeftAxisOptions][this.side],merge$1o(defaultOptions$h[this.coll],d)),fireEvent$z(this,"afterSetOptions",{userOptions:d})},g.prototype.defaultLabelFormatter=function(d){var a=this.axis,u=this.chart,v=u.numberFormatter,x=isNumber$N(this.value)?this.value:NaN,S=a.chart.time,T=a.categories,P=this.dateTimeLabelFormat,z=defaultOptions$h.lang,L=z.numericSymbols,N=z.numericSymbolMagnitude||1e3,$=a.logarithmic?Math.abs(x):a.tickInterval,B=L&&L.length,U,j;if(T)j=""+this.value;else if(P)j=S.dateFormat(P,x);else if(B&&$>=1e3)for(;B--&&typeof j>"u";)U=Math.pow(N,B+1),$>=U&&x*10%U===0&&L[B]!==null&&x!==0&&(j=v(x/U,-1)+L[B]);return typeof j>"u"&&(Math.abs(x)>=1e4?j=v(x,-1):j=v(x,-1,void 0,"")),j},g.prototype.getSeriesExtremes=function(){var d=this,a=d.chart,u;fireEvent$z(this,"getSeriesExtremes",null,function(){d.hasVisibleSeries=!1,d.dataMin=d.dataMax=d.threshold=null,d.softThreshold=!d.isXAxis,d.stacking&&d.stacking.buildStacks(),d.series.forEach(function(v){if(v.visible||!a.options.chart.ignoreHiddenSeries){var x=v.options,S=void 0,T=x.threshold,P=void 0,z=void 0;if(d.hasVisibleSeries=!0,d.positiveValuesOnly&&T<=0&&(T=null),d.isXAxis)S=v.xData,S.length&&(S=d.logarithmic?S.filter(d.validatePositiveValue):S,u=v.getXExtremes(S),P=u.min,z=u.max,!isNumber$N(P)&&!(P instanceof Date)&&(S=S.filter(isNumber$N),u=v.getXExtremes(S),P=u.min,z=u.max),S.length&&(d.dataMin=Math.min(pick$1x(d.dataMin,P),P),d.dataMax=Math.max(pick$1x(d.dataMax,z),z)));else{var L=v.applyExtremes();isNumber$N(L.dataMin)&&(P=L.dataMin,d.dataMin=Math.min(pick$1x(d.dataMin,P),P)),isNumber$N(L.dataMax)&&(z=L.dataMax,d.dataMax=Math.max(pick$1x(d.dataMax,z),z)),defined$R(T)&&(d.threshold=T),(!x.softThreshold||d.positiveValuesOnly)&&(d.softThreshold=!1)}}})}),fireEvent$z(this,"afterGetSeriesExtremes")},g.prototype.translate=function(d,a,u,v,x,S){var T=this.linkedParent||this,P=v&&T.old?T.old.min:T.min,z=T.minPixelPadding,L=(T.isOrdinal||T.brokenAxis&&T.brokenAxis.hasBreaks||T.logarithmic&&x)&&T.lin2val,N=1,$=0,B=v&&T.old?T.old.transA:T.transA,U=0;return B||(B=T.transA),u&&(N*=-1,$=T.len),T.reversed&&(N*=-1,$-=N*(T.sector||T.len)),a?(d=d*N+$,d-=z,U=d/B+P,L&&(U=T.lin2val(U))):(L&&(d=T.val2lin(d)),U=isNumber$N(P)?N*(d-P)*B+$+N*z+(isNumber$N(S)?B*S:0):void 0),U},g.prototype.toPixels=function(d,a){return this.translate(d,!1,!this.horiz,null,!0)+(a?0:this.pos)},g.prototype.toValue=function(d,a){return this.translate(d-(a?0:this.pos),!0,!this.horiz,null,!0)},g.prototype.getPlotLinePath=function(d){var a=this,u=a.chart,v=a.left,x=a.top,S=d.old,T=d.value,P=d.lineWidth,z=S&&u.oldChartHeight||u.chartHeight,L=S&&u.oldChartWidth||u.chartWidth,N=a.transB,$=d.translatedValue,B=d.force,U,j,Y,q,Q;function J(ie,ne,ae){return(B!=="pass"&&ie<ne||ie>ae)&&(B?ie=clamp$i(ie,ne,ae):Q=!0),ie}var ee={value:T,lineWidth:P,old:S,force:B,acrossPanes:d.acrossPanes,translatedValue:$};return fireEvent$z(this,"getPlotLinePath",ee,function(ie){$=pick$1x($,a.translate(T,null,null,S)),$=clamp$i($,-1e5,1e5),U=Y=Math.round($+N),j=q=Math.round(z-$-N),isNumber$N($)?a.horiz?(j=x,q=z-a.bottom,U=Y=J(U,v,v+a.width)):(U=v,Y=L-a.right,j=q=J(j,x,x+a.height)):(Q=!0,B=!1),ie.path=Q&&!B?null:u.renderer.crispLine([["M",U,j],["L",Y,q]],P||1)}),ee.path},g.prototype.getLinearTickPositions=function(d,a,u){var v=correctFloat$b(Math.floor(a/d)*d),x=correctFloat$b(Math.ceil(u/d)*d),S=[],T,P,z;if(correctFloat$b(v+d)===v&&(z=20),this.single)return[a];for(T=v;T<=x&&(S.push(T),T=correctFloat$b(T+d,z),T!==P);)P=T;return S},g.prototype.getMinorTickInterval=function(){var d=this.options;return d.minorTicks===!0?pick$1x(d.minorTickInterval,"auto"):d.minorTicks===!1?null:d.minorTickInterval},g.prototype.getMinorTickPositions=function(){var d=this,a=d.options,u=d.tickPositions,v=d.minorTickInterval,x=d.pointRangePadding||0,S=d.min-x,T=d.max+x,P=T-S,z=[],L;if(P&&P/v<d.len/3){var N=d.logarithmic;if(N)this.paddedTicks.forEach(function($,B,U){B&&z.push.apply(z,N.getLogTickPositions(v,U[B-1],U[B],!0))});else if(d.dateTime&&this.getMinorTickInterval()==="auto")z=z.concat(d.getTimeTicks(d.dateTime.normalizeTimeTickInterval(v),S,T,a.startOfWeek));else for(L=S+(u[0]-S)%v;L<=T&&L!==z[0];L+=v)z.push(L)}return z.length!==0&&d.trimTicks(z),z},g.prototype.adjustForMinRange=function(){var d=this,a=d.options,u=d.logarithmic,v=d.min,x=d.max,S,T,P=0,z,L,N,$,B,U,j;d.isXAxis&&typeof d.minRange>"u"&&!u&&(defined$R(a.min)||defined$R(a.max)?d.minRange=null:(d.series.forEach(function(Y){if(N=Y.xData,$=Y.xIncrement?1:N.length-1,N.length>1)for(z=$;z>0;z--)L=N[z]-N[z-1],(!P||L<P)&&(P=L)}),d.minRange=Math.min(P*5,d.dataMax-d.dataMin))),x-v<d.minRange&&(T=d.dataMax-d.dataMin>=d.minRange,j=d.minRange,S=(j-x+v)/2,B=[v-S,pick$1x(a.min,v-S)],T&&(B[2]=d.logarithmic?d.logarithmic.log2lin(d.dataMin):d.dataMin),v=arrayMax$9(B),U=[v+j,pick$1x(a.max,v+j)],T&&(U[2]=u?u.log2lin(d.dataMax):d.dataMax),x=arrayMin$8(U),x-v<j&&(B[0]=x-j,B[1]=pick$1x(a.min,x-j),v=arrayMax$9(B))),d.min=v,d.max=x},g.prototype.getClosest=function(){var d;return this.categories?d=1:this.series.forEach(function(a){var u=a.closestPointRange,v=a.visible||!a.chart.options.chart.ignoreHiddenSeries;!a.noSharedTooltip&&defined$R(u)&&v&&(d=defined$R(d)?Math.min(d,u):u)}),d},g.prototype.nameToX=function(d){var a=isArray$m(this.categories),u=a?this.categories:this.names,v=d.options.x,x;return d.series.requireSorting=!1,defined$R(v)||(v=this.options.uniqueNames?a?u.indexOf(d.name):pick$1x(u.keys[d.name],-1):d.series.autoIncrement()),v===-1?a||(x=u.length):x=v,typeof x<"u"&&(this.names[x]=d.name,this.names.keys[d.name]=x),x},g.prototype.updateNames=function(){var d=this,a=this.names,u=a.length;u>0&&(Object.keys(a.keys).forEach(function(v){delete a.keys[v]}),a.length=0,this.minRange=this.userMinRange,(this.series||[]).forEach(function(v){v.xIncrement=null,(!v.points||v.isDirtyData)&&(d.max=Math.max(d.max,v.xData.length-1),v.processData(),v.generatePoints()),v.data.forEach(function(x,S){var T;x&&x.options&&typeof x.name<"u"&&(T=d.nameToX(x),typeof T<"u"&&T!==x.x&&(x.x=T,v.xData[S]=T))})}))},g.prototype.setAxisTranslation=function(){var d=this,a=d.max-d.min,u=d.linkedParent,v=!!d.categories,x=d.isXAxis,S=d.axisPointRange||0,T,P=0,z=0,L,N=d.transA;(x||v||S)&&(T=d.getClosest(),u?(P=u.minPointOffset,z=u.pointRangePadding):d.series.forEach(function($){var B=v?1:x?pick$1x($.options.pointRange,T,0):d.axisPointRange||0,U=$.options.pointPlacement;if(S=Math.max(S,B),!d.single||v){var j=$.is("xrange")?!x:x;P=Math.max(P,j&&isString$8(U)?0:B/2),z=Math.max(z,j&&U==="on"?0:B)}}),L=d.ordinal&&d.ordinal.slope&&T?d.ordinal.slope/T:1,d.minPointOffset=P=P*L,d.pointRangePadding=z=z*L,d.pointRange=Math.min(S,d.single&&v?1:a),x&&(d.closestPointRange=T)),d.translationSlope=d.transA=N=d.staticScale||d.len/(a+z||1),d.transB=d.horiz?d.left:d.bottom,d.minPixelPadding=N*P,fireEvent$z(this,"afterSetAxisTranslation")},g.prototype.minFromRange=function(){var d=this;return d.max-d.range},g.prototype.setTickInterval=function(d){var a=this,u=a.chart,v=a.logarithmic,x=a.options,S=a.isXAxis,T=a.isLinked,P=x.tickPixelInterval,z=a.categories,L=a.softThreshold,N=x.maxPadding,$=x.minPadding,B,U,j=x.tickInterval,Y=isNumber$N(a.threshold)?a.threshold:null,q,Q,J,ee;!a.dateTime&&!z&&!T&&this.getTickAmount(),J=pick$1x(a.userMin,x.min),ee=pick$1x(a.userMax,x.max),T?(a.linkedParent=u[a.coll][x.linkedTo],U=a.linkedParent.getExtremes(),a.min=pick$1x(U.min,U.dataMin),a.max=pick$1x(U.max,U.dataMax),x.type!==a.linkedParent.options.type&&error$9(11,1,u)):(L&&defined$R(Y)&&(a.dataMin>=Y?(q=Y,$=0):a.dataMax<=Y&&(Q=Y,N=0)),a.min=pick$1x(J,q,a.dataMin),a.max=pick$1x(ee,Q,a.dataMax)),v&&(a.positiveValuesOnly&&!d&&Math.min(a.min,pick$1x(a.dataMin,a.min))<=0&&error$9(10,1,u),a.min=correctFloat$b(v.log2lin(a.min),16),a.max=correctFloat$b(v.log2lin(a.max),16)),a.range&&defined$R(a.max)&&(a.userMin=a.min=J=Math.max(a.dataMin,a.minFromRange()),a.userMax=ee=a.max,a.range=null),fireEvent$z(a,"foundExtremes"),a.beforePadding&&a.beforePadding(),a.adjustForMinRange(),!z&&!a.axisPointRange&&!(a.stacking&&a.stacking.usePercentage)&&!T&&defined$R(a.min)&&defined$R(a.max)&&(B=a.max-a.min,B&&(!defined$R(J)&&$&&(a.min-=B*$),!defined$R(ee)&&N&&(a.max+=B*N))),isNumber$N(a.userMin)||(isNumber$N(x.softMin)&&x.softMin<a.min&&(a.min=J=x.softMin),isNumber$N(x.floor)&&(a.min=Math.max(a.min,x.floor))),isNumber$N(a.userMax)||(isNumber$N(x.softMax)&&x.softMax>a.max&&(a.max=ee=x.softMax),isNumber$N(x.ceiling)&&(a.max=Math.min(a.max,x.ceiling))),L&&defined$R(a.dataMin)&&(Y=Y||0,!defined$R(J)&&a.min<Y&&a.dataMin>=Y?a.min=a.options.minRange?Math.min(Y,a.max-a.minRange):Y:!defined$R(ee)&&a.max>Y&&a.dataMax<=Y&&(a.max=a.options.minRange?Math.max(Y,a.min+a.minRange):Y)),isNumber$N(a.min)&&isNumber$N(a.max)&&!this.chart.polar&&a.min>a.max&&(defined$R(a.options.min)?a.max=a.min:defined$R(a.options.max)&&(a.min=a.max)),a.min===a.max||typeof a.min>"u"||typeof a.max>"u"?a.tickInterval=1:T&&a.linkedParent&&!j&&P===a.linkedParent.options.tickPixelInterval?a.tickInterval=j=a.linkedParent.tickInterval:a.tickInterval=pick$1x(j,this.tickAmount?(a.max-a.min)/Math.max(this.tickAmount-1,1):void 0,z?1:(a.max-a.min)*P/Math.max(a.len,P)),S&&!d&&(a.series.forEach(function(ne){ne.forceCrop=ne.forceCropping&&ne.forceCropping(),ne.processData(a.min!==(a.old&&a.old.min)||a.max!==(a.old&&a.old.max))}),fireEvent$z(this,"postProcessData")),a.setAxisTranslation(),fireEvent$z(this,"initialAxisTranslation"),a.pointRange&&!j&&(a.tickInterval=Math.max(a.pointRange,a.tickInterval));var ie=pick$1x(x.minTickInterval,a.dateTime&&!a.series.some(function(ne){return ne.noSharedTooltip})?a.closestPointRange:0);!j&&a.tickInterval<ie&&(a.tickInterval=ie),!a.dateTime&&!a.logarithmic&&!j&&(a.tickInterval=normalizeTickInterval$2(a.tickInterval,void 0,getMagnitude$2(a.tickInterval),pick$1x(x.allowDecimals,a.tickInterval<.5||this.tickAmount!==void 0),!!this.tickAmount)),this.tickAmount||(a.tickInterval=a.unsquish()),this.setTickPositions()},g.prototype.setTickPositions=function(){var d=this,a=this.options,u=a.tickPositions,v=this.getMinorTickInterval(),x=this.hasVerticalPanning(),S=this.coll==="colorAxis",T=(S||!x)&&a.startOnTick,P=(S||!x)&&a.endOnTick,z,L=a.tickPositioner;this.tickmarkOffset=this.categories&&a.tickmarkPlacement==="between"&&this.tickInterval===1?.5:0,this.minorTickInterval=v==="auto"&&this.tickInterval?this.tickInterval/5:v,this.single=this.min===this.max&&defined$R(this.min)&&!this.tickAmount&&(parseInt(this.min,10)===this.min||a.allowDecimals!==!1),this.tickPositions=z=u&&u.slice(),z||((!d.ordinal||!d.ordinal.positions)&&(this.max-this.min)/this.tickInterval>Math.max(2*this.len,200)?(z=[this.min,this.max],error$9(19,!1,this.chart)):d.dateTime?z=d.getTimeTicks(d.dateTime.normalizeTimeTickInterval(this.tickInterval,a.units),this.min,this.max,a.startOfWeek,d.ordinal&&d.ordinal.positions,this.closestPointRange,!0):d.logarithmic?z=d.logarithmic.getLogTickPositions(this.tickInterval,this.min,this.max):z=this.getLinearTickPositions(this.tickInterval,this.min,this.max),z.length>this.len&&(z=[z[0],z.pop()],z[0]===z[1]&&(z.length=1)),this.tickPositions=z,L&&(L=L.apply(d,[this.min,this.max]),L&&(this.tickPositions=z=L))),this.paddedTicks=z.slice(0),this.trimTicks(z,T,P),this.isLinked||(this.single&&z.length<2&&!this.categories&&!this.series.some(function(N){return N.is("heatmap")&&N.options.pointPlacement==="between"})&&(this.min-=.5,this.max+=.5),!u&&!L&&this.adjustTickAmount()),fireEvent$z(this,"afterSetTickPositions")},g.prototype.trimTicks=function(d,a,u){var v=d[0],x=d[d.length-1],S=!this.isOrdinal&&this.minPointOffset||0;if(fireEvent$z(this,"trimTicks"),!this.isLinked){if(a&&v!==-1/0)this.min=v;else for(;this.min-S>d[0];)d.shift();if(u)this.max=x;else for(;this.max+S<d[d.length-1];)d.pop();d.length===0&&defined$R(v)&&!this.options.tickPositions&&d.push((x+v)/2)}},g.prototype.alignToOthers=function(){var d=this,a={},u=d.options,v;return this.chart.options.chart.alignTicks!==!1&&u.alignTicks&&u.startOnTick!==!1&&u.endOnTick!==!1&&!d.logarithmic&&this.chart[this.coll].forEach(function(x){var S=x.options,T=x.horiz,P=[T?S.left:S.top,S.width,S.height,S.pane].join(",");x.series.length&&(a[P]?v=!0:a[P]=1)}),v},g.prototype.getTickAmount=function(){var d=this,a=this.options,u=a.tickPixelInterval,v=a.tickAmount;!defined$R(a.tickInterval)&&!v&&this.len<u&&!this.isRadial&&!d.logarithmic&&a.startOnTick&&a.endOnTick&&(v=2),!v&&this.alignToOthers()&&(v=Math.ceil(this.len/u)+1),v<4&&(this.finalTickAmt=v,v=5),this.tickAmount=v},g.prototype.adjustTickAmount=function(){var d=this,a=d.options,u=d.tickInterval,v=d.tickPositions,x=d.tickAmount,S=d.finalTickAmt,T=v&&v.length,P=pick$1x(d.threshold,d.softThreshold?0:null),z,L;if(d.hasData()&&isNumber$N(d.min)&&isNumber$N(d.max)){if(T<x){for(;v.length<x;)v.length%2||d.min===P?v.push(correctFloat$b(v[v.length-1]+u)):v.unshift(correctFloat$b(v[0]-u));d.transA*=(T-1)/(x-1),d.min=a.startOnTick?v[0]:Math.min(d.min,v[0]),d.max=a.endOnTick?v[v.length-1]:Math.max(d.max,v[v.length-1])}else T>x&&(d.tickInterval*=2,d.setTickPositions());if(defined$R(S)){for(L=z=v.length;L--;)(S===3&&L%2===1||S<=2&&L>0&&L<z-1)&&v.splice(L,1);d.finalTickAmt=void 0}}},g.prototype.setScale=function(){var d=this,a=!1,u=!1;d.series.forEach(function(x){a=a||x.isDirtyData||x.isDirty,u=u||x.xAxis&&x.xAxis.isDirty||!1}),d.setAxisSize();var v=d.len!==(d.old&&d.old.len);v||a||u||d.isLinked||d.forceRedraw||d.userMin!==(d.old&&d.old.userMin)||d.userMax!==(d.old&&d.old.userMax)||d.alignToOthers()?(d.stacking&&d.stacking.resetStacks(),d.forceRedraw=!1,d.getSeriesExtremes(),d.setTickInterval(),d.isDirty||(d.isDirty=v||d.min!==(d.old&&d.old.min)||d.max!==(d.old&&d.old.max))):d.stacking&&d.stacking.cleanStacks(),a&&d.panningState&&(d.panningState.isDirty=!0),fireEvent$z(this,"afterSetScale")},g.prototype.setExtremes=function(d,a,u,v,x){var S=this,T=S.chart;u=pick$1x(u,!0),S.series.forEach(function(P){delete P.kdTree}),x=extend$1q(x,{min:d,max:a}),fireEvent$z(S,"setExtremes",x,function(){S.userMin=d,S.userMax=a,S.eventArgs=x,u&&T.redraw(v)})},g.prototype.zoom=function(d,a){var u=this,v=this.dataMin,x=this.dataMax,S=this.options,T=Math.min(v,pick$1x(S.min,v)),P=Math.max(x,pick$1x(S.max,x)),z={newMin:d,newMax:a};return fireEvent$z(this,"zoom",z,function(L){var N=L.newMin,$=L.newMax;(N!==u.min||$!==u.max)&&(u.allowZoomOutside||(defined$R(v)&&(N<T&&(N=T),N>P&&(N=P)),defined$R(x)&&($<T&&($=T),$>P&&($=P))),u.displayBtn=typeof N<"u"||typeof $<"u",u.setExtremes(N,$,!1,void 0,{trigger:"zoom"})),L.zoomed=!0}),z.zoomed},g.prototype.setAxisSize=function(){var d=this.chart,a=this.options,u=a.offsets||[0,0,0,0],v=this.horiz,x=this.width=Math.round(relativeLength$9(pick$1x(a.width,d.plotWidth-u[3]+u[1]),d.plotWidth)),S=this.height=Math.round(relativeLength$9(pick$1x(a.height,d.plotHeight-u[0]+u[2]),d.plotHeight)),T=this.top=Math.round(relativeLength$9(pick$1x(a.top,d.plotTop+u[0]),d.plotHeight,d.plotTop)),P=this.left=Math.round(relativeLength$9(pick$1x(a.left,d.plotLeft+u[3]),d.plotWidth,d.plotLeft));this.bottom=d.chartHeight-S-T,this.right=d.chartWidth-x-P,this.len=Math.max(v?x:S,0),this.pos=v?P:T},g.prototype.getExtremes=function(){var d=this,a=d.logarithmic;return{min:a?correctFloat$b(a.lin2log(d.min)):d.min,max:a?correctFloat$b(a.lin2log(d.max)):d.max,dataMin:d.dataMin,dataMax:d.dataMax,userMin:d.userMin,userMax:d.userMax}},g.prototype.getThreshold=function(d){var a=this,u=a.logarithmic,v=u?u.lin2log(a.min):a.min,x=u?u.lin2log(a.max):a.max;return d===null||d===-1/0?d=v:d===1/0?d=x:v>d?d=v:x<d&&(d=x),a.translate(d,0,1,0,1)},g.prototype.autoLabelAlign=function(d){var a=(pick$1x(d,0)-this.side*90+720)%360,u={align:"center"};return fireEvent$z(this,"autoLabelAlign",u,function(v){a>15&&a<165?v.align="right":a>195&&a<345&&(v.align="left")}),u.align},g.prototype.tickSize=function(d){var a=this.options,u=pick$1x(a[d==="tick"?"tickWidth":"minorTickWidth"],d==="tick"&&this.isXAxis&&!this.categories?1:0),v=a[d==="tick"?"tickLength":"minorTickLength"],x;u&&v&&(a[d+"Position"]==="inside"&&(v=-v),x=[v,u]);var S={tickSize:x};return fireEvent$z(this,"afterTickSize",S),S.tickSize},g.prototype.labelMetrics=function(){var d=this.tickPositions&&this.tickPositions[0]||0;return this.chart.renderer.fontMetrics(this.options.labels.style.fontSize,this.ticks[d]&&this.ticks[d].label)},g.prototype.unsquish=function(){var d=this.options.labels,a=this.horiz,u=this.tickInterval,v=this.len/(((this.categories?1:0)+this.max-this.min)/u),x=d.rotation,S=this.labelMetrics(),T=Math.max(this.max-this.min,0),P=function(U){var j=U/(v||1);return j=j>1?Math.ceil(j):1,j*u>T&&U!==1/0&&v!==1/0&&T&&(j=Math.ceil(T/u)),correctFloat$b(j*u)},z=u,L,N,$=Number.MAX_VALUE,B;return a?(!d.staggerLines&&!d.step&&(isNumber$N(x)?B=[x]:v<d.autoRotationLimit&&(B=d.autoRotation)),B&&B.forEach(function(U){var j;(U===x||U&&U>=-90&&U<=90)&&(N=P(Math.abs(S.h/Math.sin(deg2rad$6*U))),j=N+Math.abs(U/360),j<$&&($=j,L=U,z=N))})):d.step||(z=P(S.h)),this.autoRotation=B,this.labelRotation=pick$1x(L,isNumber$N(x)?x:0),z},g.prototype.getSlotWidth=function(d){var a=this.chart,u=this.horiz,v=this.options.labels,x=Math.max(this.tickPositions.length-(this.categories?0:1),1),S=a.margin[3];if(d&&isNumber$N(d.slotWidth))return d.slotWidth;if(u&&v.step<2)return v.rotation?0:(this.staggerLines||1)*this.len/x;if(!u){var T=v.style.width;if(T!==void 0)return parseInt(String(T),10);if(S)return S-a.spacing[3]}return a.chartWidth*.33},g.prototype.renderUnsquish=function(){var d=this.chart,a=d.renderer,u=this.tickPositions,v=this.ticks,x=this.options.labels,S=x.style,T=this.horiz,P=this.getSlotWidth(),z=Math.max(1,Math.round(P-2*x.padding)),L={},N=this.labelMetrics(),$=S.textOverflow,B,U,j=0,Y,q,Q;if(isString$8(x.rotation)||(L.rotation=x.rotation||0),u.forEach(function(J){var ee=v[J];ee.movedLabel&&ee.replaceMovedLabel(),ee&&ee.label&&ee.label.textPxLength>j&&(j=ee.label.textPxLength)}),this.maxLabelLength=j,this.autoRotation)j>z&&j>N.h?L.rotation=this.labelRotation:this.labelRotation=0;else if(P&&(B=z,!$))for(U="clip",q=u.length;!T&&q--;)Q=u[q],Y=v[Q].label,Y&&(Y.styles&&Y.styles.textOverflow==="ellipsis"?Y.css({textOverflow:"clip"}):Y.textPxLength>P&&Y.css({width:P+"px"}),Y.getBBox().height>this.len/u.length-(N.h-N.f)&&(Y.specificTextOverflow="ellipsis"));L.rotation&&(B=j>d.chartHeight*.5?d.chartHeight*.33:j,$||(U="ellipsis")),this.labelAlign=x.align||this.autoLabelAlign(this.labelRotation),this.labelAlign&&(L.align=this.labelAlign),u.forEach(function(J){var ee=v[J],ie=ee&&ee.label,ne=S.width,ae={};ie&&(ie.attr(L),ee.shortenLabel?ee.shortenLabel():B&&!ne&&S.whiteSpace!=="nowrap"&&(B<ie.textPxLength||ie.element.tagName==="SPAN")?(ae.width=B+"px",$||(ae.textOverflow=ie.specificTextOverflow||U),ie.css(ae)):ie.styles&&ie.styles.width&&!ae.width&&!ne&&ie.css({width:null}),delete ie.specificTextOverflow,ee.rotation=L.rotation)},this),this.tickRotCorr=a.rotCorr(N.b,this.labelRotation||0,this.side!==0)},g.prototype.hasData=function(){return this.series.some(function(d){return d.hasData()})||this.options.showEmpty&&defined$R(this.min)&&defined$R(this.max)},g.prototype.addTitle=function(d){var a=this,u=a.chart.renderer,v=a.horiz,x=a.opposite,S=a.options,T=S.title,P=a.chart.styledMode,z;a.axisTitle||(z=T.textAlign,z||(z=(v?{low:"left",middle:"center",high:"right"}:{low:x?"right":"left",middle:"center",high:x?"left":"right"})[T.align]),a.axisTitle=u.text(T.text||"",0,0,T.useHTML).attr({zIndex:7,rotation:T.rotation,align:z}).addClass("highcharts-axis-title"),P||a.axisTitle.css(merge$1o(T.style)),a.axisTitle.add(a.axisGroup),a.axisTitle.isNew=!0),!P&&!T.style.width&&!a.isRadial&&a.axisTitle.css({width:a.len+"px"}),a.axisTitle[d?"show":"hide"](d)},g.prototype.generateTick=function(d){var a=this,u=a.ticks;u[d]?u[d].addLabel():u[d]=new Tick(a,d)},g.prototype.getOffset=function(){var d=this,a=this,u=a.chart,v=u.renderer,x=a.options,S=a.tickPositions,T=a.ticks,P=a.horiz,z=a.side,L=u.inverted&&!a.isZAxis?[1,0,3,2][z]:z,N=a.hasData(),$=x.title,B=x.labels,U=u.axisOffset,j=u.clipOffset,Y=[-1,1,1,-1][z],q=x.className,Q=a.axisParent,J,ee=0,ie,ne=0,ae=0,de,he;if(a.showAxis=J=N||x.showEmpty,a.staggerLines=a.horiz&&B.staggerLines||void 0,!a.axisGroup){var pe=function(ge,_e,me){return v.g(ge).attr({zIndex:me}).addClass("highcharts-"+d.coll.toLowerCase()+_e+" "+(d.isRadial?"highcharts-radial-axis"+_e+" ":"")+(q||"")).add(Q)};a.gridGroup=pe("grid","-grid",x.gridZIndex),a.axisGroup=pe("axis","",x.zIndex),a.labelGroup=pe("axis-labels","-labels",B.zIndex)}N||a.isLinked?(S.forEach(function(ge){a.generateTick(ge)}),a.renderUnsquish(),a.reserveSpaceDefault=z===0||z===2||{1:"left",3:"right"}[z]===a.labelAlign,pick$1x(B.reserveSpace,a.labelAlign==="center"?!0:null,a.reserveSpaceDefault)&&S.forEach(function(ge){ae=Math.max(T[ge].getLabelSize(),ae)}),a.staggerLines&&(ae*=a.staggerLines),a.labelOffset=ae*(a.opposite?-1:1)):objectEach$u(T,function(ge,_e){ge.destroy(),delete T[_e]}),$&&$.text&&$.enabled!==!1&&(a.addTitle(J),J&&$.reserveSpace!==!1&&(a.titleOffset=ee=a.axisTitle.getBBox()[P?"height":"width"],ie=$.offset,ne=defined$R(ie)?0:pick$1x($.margin,P?5:10))),a.renderLine(),a.offset=Y*pick$1x(x.offset,U[z]?U[z]+(x.margin||0):0),a.tickRotCorr=a.tickRotCorr||{x:0,y:0},z===0?he=-a.labelMetrics().h:z===2?he=a.tickRotCorr.y:he=0,de=Math.abs(ae)+ne,ae&&(de-=he,de+=Y*(P?pick$1x(B.y,a.tickRotCorr.y+Y*8):B.x)),a.axisTitleMargin=pick$1x(ie,de),a.getMaxLabelDimensions&&(a.maxLabelDimensions=a.getMaxLabelDimensions(T,S));var ve=this.tickSize("tick");U[z]=Math.max(U[z],(a.axisTitleMargin||0)+ee+Y*a.offset,de,S&&S.length&&ve?ve[0]+Y*a.offset:0);var be=x.offset?0:Math.floor(a.axisLine.strokeWidth()/2)*2;j[L]=Math.max(j[L],be),fireEvent$z(this,"afterGetOffset")},g.prototype.getLinePath=function(d){var a=this.chart,u=this.opposite,v=this.offset,x=this.horiz,S=this.left+(u?this.width:0)+v,T=a.chartHeight-this.bottom-(u?this.height:0)+v;return u&&(d*=-1),a.renderer.crispLine([["M",x?this.left:S,x?T:this.top],["L",x?a.chartWidth-this.right:S,x?T:a.chartHeight-this.bottom]],d)},g.prototype.renderLine=function(){this.axisLine||(this.axisLine=this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup),this.chart.styledMode||this.axisLine.attr({stroke:this.options.lineColor,"stroke-width":this.options.lineWidth,zIndex:7}))},g.prototype.getTitlePosition=function(){var d=this.horiz,a=this.left,u=this.top,v=this.len,x=this.options.title,S=d?a:u,T=this.opposite,P=this.offset,z=x.x,L=x.y,N=this.axisTitle,$=this.chart.renderer.fontMetrics(x.style.fontSize,N),B=Math.max(N.getBBox(null,0).height-$.h-1,0),U={low:S+(d?0:v),middle:S+v/2,high:S+(d?v:0)}[x.align],j=(d?u+this.height:a)+(d?1:-1)*(T?-1:1)*this.axisTitleMargin+[-B,B,$.f,-B][this.side],Y={x:d?U+z:j+(T?this.width:0)+P+z,y:d?j+L-(T?this.height:0)+P:U+L};return fireEvent$z(this,"afterGetTitlePosition",{titlePosition:Y}),Y},g.prototype.renderMinorTick=function(d,a){var u=this,v=u.minorTicks;v[d]||(v[d]=new Tick(u,d,"minor")),a&&v[d].isNew&&v[d].render(null,!0),v[d].render(null,!1,1)},g.prototype.renderTick=function(d,a,u){var v=this,x=v.isLinked,S=v.ticks;(!x||d>=v.min&&d<=v.max||v.grid&&v.grid.isColumn)&&(S[d]||(S[d]=new Tick(v,d)),u&&S[d].isNew&&S[d].render(a,!0,-1),S[d].render(a))},g.prototype.render=function(){var d=this,a=d.chart,u=d.logarithmic,v=a.renderer,x=d.options,S=d.isLinked,T=d.tickPositions,P=d.axisTitle,z=d.ticks,L=d.minorTicks,N=d.alternateBands,$=x.stackLabels,B=x.alternateGridColor,U=d.tickmarkOffset,j=d.axisLine,Y=d.showAxis,q=animObject$b(v.globalAnimation),Q,J;if(d.labelEdge.length=0,d.overlap=!1,[z,L,N].forEach(function(ne){objectEach$u(ne,function(ae){ae.isActive=!1})}),d.hasData()||S){var ee=d.chart.hasRendered&&d.old&&isNumber$N(d.old.min);d.minorTickInterval&&!d.categories&&d.getMinorTickPositions().forEach(function(ne){d.renderMinorTick(ne,ee)}),T.length&&(T.forEach(function(ne,ae){d.renderTick(ne,ae,ee)}),U&&(d.min===0||d.single)&&(z[-1]||(z[-1]=new Tick(d,-1,null,!0)),z[-1].render(-1))),B&&T.forEach(function(ne,ae){J=typeof T[ae+1]<"u"?T[ae+1]+U:d.max-U,ae%2===0&&ne<d.max&&J<=d.max+(a.polar?-U:U)&&(N[ne]||(N[ne]=new H.PlotLineOrBand(d)),Q=ne+U,N[ne].options={from:u?u.lin2log(Q):Q,to:u?u.lin2log(J):J,color:B,className:"highcharts-alternate-grid"},N[ne].render(),N[ne].isActive=!0)}),d._addedPlotLB||(d._addedPlotLB=!0,(x.plotLines||[]).concat(x.plotBands||[]).forEach(function(ne){d.addPlotBandOrLine(ne)}))}if([z,L,N].forEach(function(ne){var ae=[],de=q.duration,he=function(){for(var pe=ae.length;pe--;)ne[ae[pe]]&&!ne[ae[pe]].isActive&&(ne[ae[pe]].destroy(),delete ne[ae[pe]])};objectEach$u(ne,function(pe,ve){pe.isActive||(pe.render(ve,!1,0),pe.isActive=!1,ae.push(ve))}),syncTimeout$7(he,ne===N||!a.hasRendered||!de?0:de)}),j&&(j[j.isPlaced?"animate":"attr"]({d:this.getLinePath(j.strokeWidth())}),j.isPlaced=!0,j[Y?"show":"hide"](Y)),P&&Y){var ie=d.getTitlePosition();isNumber$N(ie.y)?(P[P.isNew?"attr":"animate"](ie),P.isNew=!1):(P.attr("y",-9999),P.isNew=!0)}$&&$.enabled&&d.stacking&&d.stacking.renderStackTotals(),d.old={len:d.len,max:d.max,min:d.min,transA:d.transA,userMax:d.userMax,userMin:d.userMin},d.isDirty=!1,fireEvent$z(this,"afterRender")},g.prototype.redraw=function(){this.visible&&(this.render(),this.plotLinesAndBands.forEach(function(d){d.render()})),this.series.forEach(function(d){d.isDirty=!0})},g.prototype.getKeepProps=function(){return this.keepProps||g.keepProps},g.prototype.destroy=function(d){var a=this,u=a.plotLinesAndBands,v=this.eventOptions;if(fireEvent$z(this,"destroy",{keepEvents:d}),d||removeEvent$9(a),[a.ticks,a.minorTicks,a.alternateBands].forEach(function(T){destroyObjectProperties$7(T)}),u)for(var x=u.length;x--;)u[x].destroy();["axisLine","axisTitle","axisGroup","gridGroup","labelGroup","cross","scrollbar"].forEach(function(T){a[T]&&(a[T]=a[T].destroy())});for(var S in a.plotLinesAndBandsGroups)a.plotLinesAndBandsGroups[S]=a.plotLinesAndBandsGroups[S].destroy();objectEach$u(a,function(T,P){a.getKeepProps().indexOf(P)===-1&&delete a[P]}),this.eventOptions=v},g.prototype.drawCrosshair=function(d,a){var u=this.crosshair,v=pick$1x(u&&u.snap,!0),x=this.chart,S,T,P,z=this.cross,L;if(fireEvent$z(this,"drawCrosshair",{e:d,point:a}),d||(d=this.cross&&this.cross.e),!u||(defined$R(a)||!v)===!1)this.hideCrosshair();else{if(v?defined$R(a)&&(T=pick$1x(this.coll!=="colorAxis"?a.crosshairPos:null,this.isXAxis?a.plotX:this.len-a.plotY)):T=d&&(this.horiz?d.chartX-this.pos:this.len-d.chartY+this.pos),defined$R(T)&&(L={value:a&&(this.isXAxis?a.x:pick$1x(a.stackY,a.y)),translatedValue:T},x.polar&&extend$1q(L,{isCrosshair:!0,chartX:d&&d.chartX,chartY:d&&d.chartY,point:a}),S=this.getPlotLinePath(L)||null),!defined$R(S)){this.hideCrosshair();return}P=this.categories&&!this.isRadial,z||(this.cross=z=x.renderer.path().addClass("highcharts-crosshair highcharts-crosshair-"+(P?"category ":"thin ")+(u.className||"")).attr({zIndex:pick$1x(u.zIndex,2)}).add(),x.styledMode||(z.attr({stroke:u.color||(P?Color.parse(palette.highlightColor20).setOpacity(.25).get():palette.neutralColor20),"stroke-width":pick$1x(u.width,1)}).css({"pointer-events":"none"}),u.dashStyle&&z.attr({dashstyle:u.dashStyle}))),z.show().attr({d:S}),P&&!u.width&&z.attr({"stroke-width":this.transA}),this.cross.e=d}fireEvent$z(this,"afterDrawCrosshair",{e:d,point:a})},g.prototype.hideCrosshair=function(){this.cross&&this.cross.hide(),fireEvent$z(this,"afterHideCrosshair")},g.prototype.hasVerticalPanning=function(){var d=this.chart.options.chart.panning;return!!(d&&d.enabled&&/y/.test(d.type))},g.prototype.validatePositiveValue=function(d){return isNumber$N(d)&&d>0},g.prototype.update=function(d,a){var u=this.chart;d=merge$1o(this.userOptions,d),this.destroy(!0),this.init(u,d),u.isDirtyBox=!0,pick$1x(a,!0)&&u.redraw()},g.prototype.remove=function(d){for(var a=this.chart,u=this.coll,v=this.series,x=v.length;x--;)v[x]&&v[x].remove(!1);erase$8(a.axes,this),erase$8(a[u],this),a[u].forEach(function(S,T){S.options.index=S.userOptions.index=T}),this.destroy(),a.isDirtyBox=!0,pick$1x(d,!0)&&a.redraw()},g.prototype.setTitle=function(d,a){this.update({title:d},a)},g.prototype.setCategories=function(d,a){this.update({categories:d},a)},g.defaultOptions=AxisDefaults$1.defaultXAxisOptions,g.keepProps=["extKey","hcEvents","names","series","userMax","userMin"],g})(),addEvent$15=Utilities.addEvent,getMagnitude$1=Utilities.getMagnitude,normalizeTickInterval$1=Utilities.normalizeTickInterval,timeUnits$2=Utilities.timeUnits,DateTimeAxis;(function(g){var d=[];function a(S){if(d.indexOf(S)===-1){d.push(S),S.keepProps.push("dateTime");var T=S.prototype;T.getTimeTicks=u,addEvent$15(S,"init",v)}return S}g.compose=a;function u(){return this.chart.time.getTimeTicks.apply(this.chart.time,arguments)}function v(S){var T=this,P=S.userOptions;if(P.type!=="datetime"){T.dateTime=void 0;return}T.dateTime||(T.dateTime=new x(T))}var x=(function(){function S(T){this.axis=T}return S.prototype.normalizeTimeTickInterval=function(T,P){var z=P||[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2]],["week",[1,2]],["month",[1,2,3,4,6]],["year",null]],L=z[z.length-1],N=timeUnits$2[L[0]],$=L[1],B;for(B=0;B<z.length;B++)if(L=z[B],N=timeUnits$2[L[0]],$=L[1],z[B+1]){var U=(N*$[$.length-1]+timeUnits$2[z[B+1][0]])/2;if(T<=U)break}N===timeUnits$2.year&&T<5*N&&($=[1,2,5]);var j=normalizeTickInterval$1(T/N,$,L[0]==="year"?Math.max(getMagnitude$1(T/N),1):1);return{unitRange:N,count:j,unitName:L[0]}},S.prototype.getXDateFormat=function(T,P){var z=this.axis;return z.closestPointRange?z.chart.time.getDateFormat(z.closestPointRange,T,z.options.startOfWeek,P)||P.year:P.day},S})();g.Additions=x})(DateTimeAxis||(DateTimeAxis={}));const DateTimeAxis$1=DateTimeAxis;var addEvent$14=Utilities.addEvent,getMagnitude=Utilities.getMagnitude,normalizeTickInterval=Utilities.normalizeTickInterval,pick$1w=Utilities.pick,LogarithmicAxis;(function(g){var d=[];function a(S){return d.indexOf(S)===-1&&(d.push(S),S.keepProps.push("logarithmic"),addEvent$14(S,"init",u),addEvent$14(S,"afterInit",v)),S}g.compose=a;function u(S){var T=this,P=S.userOptions,z=T.logarithmic;P.type!=="logarithmic"?T.logarithmic=void 0:z||(z=T.logarithmic=new x(T))}function v(){var S=this,T=S.logarithmic;T&&(S.lin2val=function(P){return T.lin2log(P)},S.val2lin=function(P){return T.log2lin(P)})}var x=(function(){function S(T){this.axis=T}return S.prototype.getLogTickPositions=function(T,P,z,L){var N=this,$=N.axis,B=$.len,U=$.options,j=[];if(L||(N.minorAutoInterval=void 0),T>=.5)T=Math.round(T),j=$.getLinearTickPositions(T,P,z);else if(T>=.08){var Y=Math.floor(P),q=void 0,Q=void 0,J=void 0,ee=void 0,ie=void 0,ne=void 0,ae=void 0;for(T>.3?q=[1,2,4]:T>.15?q=[1,2,4,6,8]:q=[1,2,3,4,5,6,7,8,9],Q=Y;Q<z+1&&!ae;Q++)for(ee=q.length,J=0;J<ee&&!ae;J++)ie=N.log2lin(N.lin2log(Q)*q[J]),ie>P&&(!L||ne<=z)&&typeof ne<"u"&&j.push(ne),ne>z&&(ae=!0),ne=ie}else{var de=N.lin2log(P),he=N.lin2log(z),pe=L?$.getMinorTickInterval():U.tickInterval,ve=pe==="auto"?null:pe,be=U.tickPixelInterval/(L?5:1),ge=L?B/$.tickPositions.length:B;T=pick$1w(ve,N.minorAutoInterval,(he-de)*be/(ge||1)),T=normalizeTickInterval(T,void 0,getMagnitude(T)),j=$.getLinearTickPositions(T,de,he).map(N.log2lin),L||(N.minorAutoInterval=T/5)}return L||($.tickInterval=T),j},S.prototype.lin2log=function(T){return Math.pow(10,T)},S.prototype.log2lin=function(T){return Math.log(T)/Math.LN10},S})();g.Additions=x})(LogarithmicAxis||(LogarithmicAxis={}));const LogarithmicAxis$1=LogarithmicAxis;var erase$7=Utilities.erase,extend$1p=Utilities.extend,isNumber$M=Utilities.isNumber,PlotLineOrBandAxis;(function(g){var d=[],a;function u(x,S){return a||(a=x),d.indexOf(S)===-1&&(d.push(S),extend$1p(S.prototype,v.prototype)),S}g.compose=u;var v=(function(){function x(){}return x.prototype.getPlotBandPath=function(S,T,P){P===void 0&&(P=this.options);var z=this.getPlotLinePath({value:T,force:!0,acrossPanes:P.acrossPanes}),L=[],N=this.horiz,$=!isNumber$M(this.min)||!isNumber$M(this.max)||S<this.min&&T<this.min||S>this.max&&T>this.max,B=this.getPlotLinePath({value:S,force:!0,acrossPanes:P.acrossPanes}),U,j=1,Y;if(B&&z)for($&&(Y=B.toString()===z.toString(),j=0),U=0;U<B.length;U+=2){var q=B[U],Q=B[U+1],J=z[U],ee=z[U+1];(q[0]==="M"||q[0]==="L")&&(Q[0]==="M"||Q[0]==="L")&&(J[0]==="M"||J[0]==="L")&&(ee[0]==="M"||ee[0]==="L")&&(N&&J[1]===q[1]?(J[1]+=j,ee[1]+=j):!N&&J[2]===q[2]&&(J[2]+=j,ee[2]+=j),L.push(["M",q[1],q[2]],["L",Q[1],Q[2]],["L",ee[1],ee[2]],["L",J[1],J[2]],["Z"])),L.isFlat=Y}else B=null;return L},x.prototype.addPlotBand=function(S){return this.addPlotBandOrLine(S,"plotBands")},x.prototype.addPlotLine=function(S){return this.addPlotBandOrLine(S,"plotLines")},x.prototype.addPlotBandOrLine=function(S,T){var P=this,z=this.userOptions,L=new a(this,S);if(this.visible&&(L=L.render()),L){if(this._addedPlotLB||(this._addedPlotLB=!0,(z.plotLines||[]).concat(z.plotBands||[]).forEach(function($){P.addPlotBandOrLine($)})),T){var N=z[T]||[];N.push(S),z[T]=N}this.plotLinesAndBands.push(L)}return L},x.prototype.removePlotBandOrLine=function(S){var T=this.plotLinesAndBands,P=this.options,z=this.userOptions;if(T){for(var L=T.length;L--;)T[L].id===S&&T[L].destroy();[P.plotLines||[],z.plotLines||[],P.plotBands||[],z.plotBands||[]].forEach(function(N){for(L=N.length;L--;)(N[L]||{}).id===S&&erase$7(N,N[L])})}},x.prototype.removePlotBand=function(S){this.removePlotBandOrLine(S)},x.prototype.removePlotLine=function(S){this.removePlotBandOrLine(S)},x})()})(PlotLineOrBandAxis||(PlotLineOrBandAxis={}));const PlotLineOrBandAxis$1=PlotLineOrBandAxis;var arrayMax$8=Utilities.arrayMax,arrayMin$7=Utilities.arrayMin,defined$Q=Utilities.defined,destroyObjectProperties$6=Utilities.destroyObjectProperties,erase$6=Utilities.erase,fireEvent$y=Utilities.fireEvent,merge$1n=Utilities.merge,objectEach$t=Utilities.objectEach,pick$1v=Utilities.pick,PlotLineOrBand=(function(){function g(d,a){this.axis=d,a&&(this.options=a,this.id=a.id)}return g.compose=function(d){return PlotLineOrBandAxis$1.compose(g,d)},g.prototype.render=function(){fireEvent$y(this,"render");var d=this,a=d.axis,u=a.horiz,v=a.logarithmic,x=d.options,S=x.color,T=pick$1v(x.zIndex,0),P=x.events,z={},L=a.chart.renderer,N=x.label,$=d.label,B=x.to,U=x.from,j=x.value,Y=d.svgElem,q=[],Q,J=defined$Q(U)&&defined$Q(B),ee=defined$Q(j),ie=!Y,ne={class:"highcharts-plot-"+(J?"band ":"line ")+(x.className||"")},ae=J?"bands":"lines";if(v&&(U=v.log2lin(U),B=v.log2lin(B),j=v.log2lin(j)),a.chart.styledMode||(ee?(ne.stroke=S||palette.neutralColor40,ne["stroke-width"]=pick$1v(x.width,1),x.dashStyle&&(ne.dashstyle=x.dashStyle)):J&&(ne.fill=S||palette.highlightColor10,x.borderWidth&&(ne.stroke=x.borderColor,ne["stroke-width"]=x.borderWidth))),z.zIndex=T,ae+="-"+T,Q=a.plotLinesAndBandsGroups[ae],Q||(a.plotLinesAndBandsGroups[ae]=Q=L.g("plot-"+ae).attr(z).add()),ie&&(d.svgElem=Y=L.path().attr(ne).add(Q)),ee)q=a.getPlotLinePath({value:j,lineWidth:Y.strokeWidth(),acrossPanes:x.acrossPanes});else if(J)q=a.getPlotBandPath(U,B,x);else return;return!d.eventsAdded&&P&&(objectEach$t(P,function(de,he){Y.on(he,function(pe){P[he].apply(d,[pe])})}),d.eventsAdded=!0),(ie||!Y.d)&&q&&q.length?Y.attr({d:q}):Y&&(q?(Y.show(!0),Y.animate({d:q})):Y.d&&(Y.hide(),$&&(d.label=$=$.destroy()))),N&&(defined$Q(N.text)||defined$Q(N.formatter))&&q&&q.length&&a.width>0&&a.height>0&&!q.isFlat?(N=merge$1n({align:u&&J&&"center",x:u?!J&&4:10,verticalAlign:!u&&J&&"middle",y:u?J?16:10:J?6:-4,rotation:u&&!J&&90},N),this.renderLabel(N,q,J,T)):$&&$.hide(),d},g.prototype.renderLabel=function(d,a,u,v){var x=this,S=x.axis,T=S.chart.renderer,P=x.label;P||(x.label=P=T.text(this.getLabelText(d),0,0,d.useHTML).attr({align:d.textAlign||d.align,rotation:d.rotation,class:"highcharts-plot-"+(u?"band":"line")+"-label "+(d.className||""),zIndex:v}).add(),S.chart.styledMode||P.css(merge$1n({textOverflow:"ellipsis"},d.style)));var z=a.xBounds||[a[0][1],a[1][1],u?a[2][1]:a[0][1]],L=a.yBounds||[a[0][2],a[1][2],u?a[2][2]:a[0][2]],N=arrayMin$7(z),$=arrayMin$7(L);P.align(d,!1,{x:N,y:$,width:arrayMax$8(z)-N,height:arrayMax$8(L)-$}),(!P.alignValue||P.alignValue==="left")&&P.css({width:(P.rotation===90?S.height-(P.alignAttr.y-S.top):S.width-(P.alignAttr.x-S.left))+"px"}),P.show(!0)},g.prototype.getLabelText=function(d){return defined$Q(d.formatter)?d.formatter.call(this):d.text},g.prototype.destroy=function(){erase$6(this.axis.plotLinesAndBands,this),delete this.axis,destroyObjectProperties$6(this)},g})(),format$d=FormatUtilities.format,doc$i=H.doc,distribute$3=R.distribute,addEvent$13=Utilities.addEvent,clamp$h=Utilities.clamp,css$9=Utilities.css,defined$P=Utilities.defined,discardElement$5=Utilities.discardElement,extend$1o=Utilities.extend,fireEvent$x=Utilities.fireEvent,isArray$l=Utilities.isArray,isNumber$L=Utilities.isNumber,isString$7=Utilities.isString,merge$1m=Utilities.merge,pick$1u=Utilities.pick,splat$h=Utilities.splat,syncTimeout$6=Utilities.syncTimeout,Tooltip=(function(){function g(d,a){this.container=void 0,this.crosshairs=[],this.distance=0,this.isHidden=!0,this.isSticky=!1,this.now={},this.options={},this.outside=!1,this.chart=d,this.init(d,a)}return g.prototype.applyFilter=function(){var d=this.chart;d.renderer.definition({tagName:"filter",attributes:{id:"drop-shadow-"+d.index,opacity:.5},children:[{tagName:"feGaussianBlur",attributes:{in:"SourceAlpha",stdDeviation:1}},{tagName:"feOffset",attributes:{dx:1,dy:1}},{tagName:"feComponentTransfer",children:[{tagName:"feFuncA",attributes:{type:"linear",slope:.3}}]},{tagName:"feMerge",children:[{tagName:"feMergeNode"},{tagName:"feMergeNode",attributes:{in:"SourceGraphic"}}]}]})},g.prototype.bodyFormatter=function(d){return d.map(function(a){var u=a.series.tooltipOptions;return(u[(a.point.formatPrefix||"point")+"Formatter"]||a.point.tooltipFormatter).call(a.point,u[(a.point.formatPrefix||"point")+"Format"]||"")})},g.prototype.cleanSplit=function(d){this.chart.series.forEach(function(a){var u=a&&a.tt;u&&(!u.isActive||d?a.tt=u.destroy():u.isActive=!1)})},g.prototype.defaultFormatter=function(d){var a=this.points||splat$h(this),u;return u=[d.tooltipFooterHeaderFormatter(a[0])],u=u.concat(d.bodyFormatter(a)),u.push(d.tooltipFooterHeaderFormatter(a[0],!0)),u},g.prototype.destroy=function(){this.label&&(this.label=this.label.destroy()),this.split&&this.tt&&(this.cleanSplit(this.chart,!0),this.tt=this.tt.destroy()),this.renderer&&(this.renderer=this.renderer.destroy(),discardElement$5(this.container)),Utilities.clearTimeout(this.hideTimer),Utilities.clearTimeout(this.tooltipTimeout)},g.prototype.getAnchor=function(d,a){var u=this.chart,v=u.pointer,x=u.inverted,S=u.plotTop,T=u.plotLeft,P,z,L,N=0,$=0;return d=splat$h(d),this.followPointer&&a?(typeof a.chartX>"u"&&(a=v.normalize(a)),P=[a.chartX-T,a.chartY-S]):d[0].tooltipPos?P=d[0].tooltipPos:(d.forEach(function(B){z=B.series.yAxis,L=B.series.xAxis,N+=B.plotX||0,$+=B.plotLow?(B.plotLow+(B.plotHigh||0))/2:B.plotY||0,L&&z&&(x?(N+=S+u.plotHeight-L.len-L.pos,$+=T+u.plotWidth-z.len-z.pos):(N+=L.pos-T,$+=z.pos-S))}),N/=d.length,$/=d.length,P=[x?u.plotWidth-$:N,x?u.plotHeight-N:$],this.shared&&d.length>1&&a&&(x?P[0]=a.chartX-T:P[1]=a.chartY-S)),P.map(Math.round)},g.prototype.getLabel=function(){var d=this,a=this.chart.styledMode,u=this.options,v="tooltip"+(defined$P(u.className)?" "+u.className:""),x=u.style.pointerEvents||(!this.followPointer&&u.stickOnContact?"auto":"none"),S=function(){d.inContact=!0},T=function(j){var Y=d.chart.hoverSeries;d.inContact=d.shouldStickOnContact()&&d.chart.pointer.inClass(j.relatedTarget,"highcharts-tooltip"),!d.inContact&&Y&&Y.onMouseOut&&Y.onMouseOut()},P,z=this.chart.renderer;if(!this.label){if(this.outside){var L=this.chart.options.chart.style,N=RendererRegistry$1.getRendererType();this.container=P=H.doc.createElement("div"),P.className="highcharts-tooltip-container",css$9(P,{position:"absolute",top:"1px",pointerEvents:x,zIndex:Math.max(this.options.style.zIndex||0,(L&&L.zIndex||0)+3)}),addEvent$13(P,"mouseenter",S),addEvent$13(P,"mouseleave",T),H.doc.body.appendChild(P),this.renderer=z=new N(P,0,0,L,void 0,void 0,z.styledMode)}if(this.split?this.label=z.g(v):(this.label=z.label("",0,0,u.shape,void 0,void 0,u.useHTML,void 0,v).attr({padding:u.padding,r:u.borderRadius}),a||this.label.attr({fill:u.backgroundColor,"stroke-width":u.borderWidth}).css(u.style).css({pointerEvents:x}).shadow(u.shadow)),a&&u.shadow&&(this.applyFilter(),this.label.attr({filter:"url(#drop-shadow-"+this.chart.index+")"})),d.outside&&!d.split){var $=this.label,B=$.xSetter,U=$.ySetter;$.xSetter=function(j){B.call($,d.distance),P.style.left=j+"px"},$.ySetter=function(j){U.call($,d.distance),P.style.top=j+"px"}}this.label.on("mouseenter",S).on("mouseleave",T).attr({zIndex:8}).add()}return this.label},g.prototype.getPosition=function(d,a,u){var v=this.chart,x=this.distance,S={},T=v.inverted&&u.h||0,P=this.outside,z=P?doc$i.documentElement.clientWidth-2*x:v.chartWidth,L=P?Math.max(doc$i.body.scrollHeight,doc$i.documentElement.scrollHeight,doc$i.body.offsetHeight,doc$i.documentElement.offsetHeight,doc$i.documentElement.clientHeight):v.chartHeight,N=v.pointer.getChartPosition(),$=function(ae){return ae*N.scaleX},B=function(ae){return ae*N.scaleY},U=function(ae){var de=ae==="x";return[ae,de?z:L,de?d:a].concat(P?[de?$(d):B(a),de?N.left-x+$(u.plotX+v.plotLeft):N.top-x+B(u.plotY+v.plotTop),0,de?z:L]:[de?d:a,de?u.plotX+v.plotLeft:u.plotY+v.plotTop,de?v.plotLeft:v.plotTop,de?v.plotLeft+v.plotWidth:v.plotTop+v.plotHeight])},j=U("y"),Y=U("x"),q,Q=!this.followPointer&&pick$1u(u.ttBelow,!v.inverted==!!u.negative),J=function(ae,de,he,pe,ve,be,ge){var _e=P?ae==="y"?B(x):$(x):x,me=(he-pe)/2,xe=pe<ve-x,Ce=ve+x+pe<de,Me=ve-_e-he+me,Re=ve+_e-me;if(Q&&Ce)S[ae]=Re;else if(!Q&&xe)S[ae]=Me;else if(xe)S[ae]=Math.min(ge-pe,Me-T<0?Me:Me-T);else if(Ce)S[ae]=Math.max(be,Re+T+he>de?Re:Re+T);else return!1},ee=function(ae,de,he,pe,ve){var be;return ve<x||ve>de-x?be=!1:ve<he/2?S[ae]=1:ve>de-pe/2?S[ae]=de-pe-2:S[ae]=ve-he/2,be},ie=function(ae){var de=j;j=Y,Y=de,q=ae},ne=function(){J.apply(0,j)!==!1?ee.apply(0,Y)===!1&&!q&&(ie(!0),ne()):q?S.x=S.y=0:(ie(!0),ne())};return(v.inverted||this.len>1)&&ie(),ne(),S},g.prototype.hide=function(d){var a=this;Utilities.clearTimeout(this.hideTimer),d=pick$1u(d,this.options.hideDelay),this.isHidden||(this.hideTimer=syncTimeout$6(function(){a.getLabel().fadeOut(d&&void 0),a.isHidden=!0},d))},g.prototype.init=function(d,a){this.chart=d,this.options=a,this.crosshairs=[],this.now={x:0,y:0},this.isHidden=!0,this.split=a.split&&!d.inverted&&!d.polar,this.shared=a.shared||this.split,this.outside=pick$1u(a.outside,!!(d.scrollablePixelsX||d.scrollablePixelsY))},g.prototype.shouldStickOnContact=function(){return!!(!this.followPointer&&this.options.stickOnContact)},g.prototype.isStickyOnContact=function(){return!!(this.shouldStickOnContact()&&this.inContact)},g.prototype.move=function(d,a,u,v){var x=this,S=x.now,T=x.options.animation!==!1&&!x.isHidden&&(Math.abs(d-S.x)>1||Math.abs(a-S.y)>1),P=x.followPointer||x.len>1;extend$1o(S,{x:T?(2*S.x+d)/3:d,y:T?(S.y+a)/2:a,anchorX:P?void 0:T?(2*S.anchorX+u)/3:u,anchorY:P?void 0:T?(S.anchorY+v)/2:v}),x.getLabel().attr(S),x.drawTracker(),T&&(Utilities.clearTimeout(this.tooltipTimeout),this.tooltipTimeout=setTimeout(function(){x&&x.move(d,a,u,v)},32))},g.prototype.refresh=function(d,a){var u=this,v=this.chart,x=u.options,S=splat$h(d),T=S[0],P=[],z=x.formatter||u.defaultFormatter,L=u.shared,N=v.styledMode,$={};if(x.enabled){Utilities.clearTimeout(this.hideTimer),u.followPointer=!u.split&&T.series.tooltipOptions.followPointer;var B=u.getAnchor(d,a),U=B[0],j=B[1];L&&!(!isArray$l(d)&&d.series&&d.series.noSharedTooltip)?(v.pointer.applyInactiveState(S),S.forEach(function(ie){ie.setState("hover"),P.push(ie.getLabelConfig())}),$={x:T.category,y:T.y},$.points=P):$=T.getLabelConfig(),this.len=P.length;var Y=z.call($,u),q=T.series;if(this.distance=pick$1u(q.tooltipOptions.distance,16),Y===!1)this.hide();else{if(u.split)this.renderSplit(Y,S);else{var Q=U,J=j;if(a&&v.pointer.isDirectTouch&&(Q=a.chartX-v.plotLeft,J=a.chartY-v.plotTop),v.polar||q.options.clip===!1||q.shouldShowTooltip(Q,J)){var ee=u.getLabel();(!x.style.width||N)&&ee.css({width:this.chart.spacingBox.width+"px"}),ee.attr({text:Y&&Y.join?Y.join(""):Y}),ee.removeClass(/highcharts-color-[\d]+/g).addClass("highcharts-color-"+pick$1u(T.colorIndex,q.colorIndex)),N||ee.attr({stroke:x.borderColor||T.color||q.color||palette.neutralColor60}),u.updatePosition({plotX:U,plotY:j,negative:T.negative,ttBelow:T.ttBelow,h:B[2]||0})}else{u.hide();return}}u.isHidden&&u.label&&u.label.attr({opacity:1}).show(),u.isHidden=!1}fireEvent$x(this,"refresh")}},g.prototype.renderSplit=function(d,a){var u=this,v=u.chart,x=u.chart,S=x.chartWidth;x.chartHeight;var T=x.plotHeight,P=x.plotLeft,z=x.plotTop,L=x.pointer,N=x.scrollablePixelsY,$=N===void 0?0:N,B=x.scrollablePixelsX,U=x.scrollingContainer,j=U===void 0?{scrollLeft:0,scrollTop:0}:U,Y=j.scrollLeft,q=j.scrollTop,Q=x.styledMode,J=u.distance,ee=u.options,ie=u.options.positioner,ne=u.outside&&typeof B!="number"?doc$i.documentElement.getBoundingClientRect():{left:Y,right:Y+S},ae=u.getLabel(),de=this.renderer||v.renderer,he=!!(v.xAxis[0]&&v.xAxis[0].opposite),pe=L.getChartPosition(),ve=pe.left,be=pe.top,ge=z+q,_e=0,me=T-$;function xe(at){var ct=at.isHeader,ft=at.plotX,Lt=ft===void 0?0:ft,xt=at.plotY,St=xt===void 0?0:xt,wt=at.series,Ut,Et;if(ct)Ut=P+Lt,Et=z+T/2;else{var ni=wt.xAxis,qt=wt.yAxis;Ut=ni.pos+clamp$h(Lt,-J,ni.len+J),wt.shouldShowTooltip(0,qt.pos-z+St,{ignoreX:!0})&&(Et=qt.pos+St)}return Ut=clamp$h(Ut,ne.left-J,ne.right+J),{anchorX:Ut,anchorY:Et}}function Ce(at,ct,ft,Lt,xt){xt===void 0&&(xt=!0);var St,wt;return ft?(St=he?0:me,wt=clamp$h(at-Lt/2,ne.left,ne.right-Lt-(u.outside?ve:0))):(St=ct-ge,wt=xt?at-Lt-J:at+J,wt=clamp$h(wt,xt?wt:ne.left,ne.right)),{x:wt,y:St}}function Me(at,ct,ft){var Lt=at,xt=ct.isHeader,St=ct.series,wt="highcharts-color-"+pick$1u(ct.colorIndex,St.colorIndex,"none");if(!Lt){var Ut={padding:ee.padding,r:ee.borderRadius};Q||(Ut.fill=ee.backgroundColor,Ut["stroke-width"]=ee.borderWidth),Lt=de.label("",0,0,ee[xt?"headerShape":"shape"],void 0,void 0,ee.useHTML).addClass((xt?"highcharts-tooltip-header ":"")+"highcharts-tooltip-box "+wt).attr(Ut).add(ae)}return Lt.isActive=!0,Lt.attr({text:ft}),Q||Lt.css(ee.style).shadow(ee.shadow).attr({stroke:ee.borderColor||ct.color||St.color||palette.neutralColor80}),Lt}isString$7(d)&&(d=[!1,d]);var Re=d.slice(0,a.length+1).reduce(function(at,ct,ft){if(ct!==!1&&ct!==""){var Lt=a[ft-1]||{isHeader:!0,plotX:a[0].plotX,plotY:T,series:{}},xt=Lt.isHeader,St=xt?u:Lt.series,wt=St.tt=Me(St.tt,Lt,ct.toString()),Ut=wt.getBBox(),Et=Ut.width+wt.strokeWidth();xt&&(_e=Ut.height,me+=_e,he&&(ge-=_e));var ni=xe(Lt),qt=ni.anchorX,ti=ni.anchorY;if(typeof ti=="number"){var ci=Ut.height+1,st=ie?ie.call(u,Et,ci,Lt):Ce(qt,ti,xt,Et);at.push({align:ie?0:void 0,anchorX:qt,anchorY:ti,boxWidth:Et,point:Lt,rank:pick$1u(st.rank,xt?1:0),size:ci,target:st.y,tt:wt,x:st.x})}else wt.isActive=!1}return at},[]);!ie&&Re.some(function(at){var ct=u.outside,ft=(ct?ve:0)+at.anchorX;return ft<ne.left&&ft+at.boxWidth<ne.right?!0:ft<ve-ne.left+at.boxWidth&&ne.right-ft>ft})&&(Re=Re.map(function(at){var ct=Ce(at.anchorX,at.anchorY,at.point.isHeader,at.boxWidth,!1),ft=ct.x,Lt=ct.y;return extend$1o(at,{target:Lt,x:ft})})),u.cleanSplit(),distribute$3(Re,me);var Ue={left:ve,right:ve};Re.forEach(function(at){var ct=at.x,ft=at.boxWidth,Lt=at.isHeader;Lt||(u.outside&&ve+ct<Ue.left&&(Ue.left=ve+ct),!Lt&&u.outside&&Ue.left+ft>Ue.right&&(Ue.right=ve+ct))}),Re.forEach(function(at){var ct=at.x,ft=at.anchorX,Lt=at.anchorY,xt=at.pos,St=at.point.isHeader,wt={visibility:typeof xt>"u"?"hidden":"inherit",x:ct,y:xt+ge,anchorX:ft,anchorY:Lt};if(u.outside&&ct<ft){var Ut=ve-Ue.left;Ut>0&&(St||(wt.x=ct+Ut,wt.anchorX=ft+Ut),St&&(wt.x=(Ue.right-Ue.left)/2,wt.anchorX=ft+Ut))}at.tt.attr(wt)});var $e=u.container,Te=u.outside,De=u.renderer;if(Te&&$e&&De){var He=ae.getBBox(),Le=He.width,it=He.height,pt=He.x,nt=He.y;De.setSize(Le+pt,it+nt,!1),$e.style.left=Ue.left+"px",$e.style.top=be+"px"}},g.prototype.drawTracker=function(){var d=this;if(d.followPointer||!d.options.stickOnContact){d.tracker&&d.tracker.destroy();return}var a=d.chart,u=d.label,v=d.shared?a.hoverPoints:a.hoverPoint;if(!(!u||!v)){var x={x:0,y:0,width:0,height:0},S=this.getAnchor(v),T=u.getBBox();S[0]+=a.plotLeft-u.translateX,S[1]+=a.plotTop-u.translateY,x.x=Math.min(0,S[0]),x.y=Math.min(0,S[1]),x.width=S[0]<0?Math.max(Math.abs(S[0]),T.width-S[0]):Math.max(Math.abs(S[0]),T.width),x.height=S[1]<0?Math.max(Math.abs(S[1]),T.height-Math.abs(S[1])):Math.max(Math.abs(S[1]),T.height),d.tracker?d.tracker.attr(x):(d.tracker=u.renderer.rect(x).addClass("highcharts-tracker").add(u),a.styledMode||d.tracker.attr({fill:"rgba(0,0,0,0)"}))}},g.prototype.styledModeFormat=function(d){return d.replace('style="font-size: 10px"','class="highcharts-header"').replace(/style="color:{(point|series)\.color}"/g,'class="highcharts-color-{$1.colorIndex}"')},g.prototype.tooltipFooterHeaderFormatter=function(d,a){var u=d.series,v=u.tooltipOptions,x=u.xAxis,S=x&&x.dateTime,T={isFooter:a,labelConfig:d},P=v.xDateFormat,z=v[a?"footerFormat":"headerFormat"];return fireEvent$x(this,"headerFormatter",T,function(L){S&&!P&&isNumber$L(d.key)&&(P=S.getXDateFormat(d.key,v.dateTimeLabelFormats)),S&&P&&(d.point&&d.point.tooltipDateKeys||["key"]).forEach(function(N){z=z.replace("{point."+N+"}","{point."+N+":"+P+"}")}),u.chart.styledMode&&(z=this.styledModeFormat(z)),L.text=format$d(z,{point:d,series:u},this.chart)}),T.text},g.prototype.update=function(d){this.destroy(),merge$1m(!0,this.chart.options.tooltip.userOptions,d),this.init(this.chart,merge$1m(!0,this.options,d))},g.prototype.updatePosition=function(d){var a=this.chart,u=this.options,v=a.pointer,x=this.getLabel(),S=v.getChartPosition(),T=(u.positioner||this.getPosition).call(this,x.width,x.height,d),P=d.plotX+a.plotLeft,z=d.plotY+a.plotTop,L;this.outside&&(L=u.borderWidth+2*this.distance,this.renderer.setSize(x.width+L,x.height+L,!1),(S.scaleX!==1||S.scaleY!==1)&&(css$9(this.container,{transform:"scale("+S.scaleX+", "+S.scaleY+")"}),P*=S.scaleX,z*=S.scaleY),P+=S.left-T.x,z+=S.top-T.y),this.move(Math.round(T.x),Math.round(T.y||0),P,z)},g})(),animObject$a=animationExports.animObject,defaultOptions$g=DefaultOptions.defaultOptions,format$c=FormatUtilities.format,addEvent$12=Utilities.addEvent,defined$O=Utilities.defined,erase$5=Utilities.erase,extend$1n=Utilities.extend,fireEvent$w=Utilities.fireEvent,getNestedProperty$1=Utilities.getNestedProperty,isArray$k=Utilities.isArray,isFunction$2=Utilities.isFunction,isNumber$K=Utilities.isNumber,isObject$e=Utilities.isObject,merge$1l=Utilities.merge,objectEach$s=Utilities.objectEach,pick$1t=Utilities.pick,syncTimeout$5=Utilities.syncTimeout,removeEvent$8=Utilities.removeEvent,uniqueKey$5=Utilities.uniqueKey,Point$4=(function(){function g(){this.category=void 0,this.colorIndex=void 0,this.formatPrefix="point",this.id=void 0,this.isNull=!1,this.name=void 0,this.options=void 0,this.percentage=void 0,this.selected=!1,this.series=void 0,this.total=void 0,this.visible=!0,this.x=void 0}return g.prototype.animateBeforeDestroy=function(){var d=this,a={x:d.startXPos,opacity:0},u=d.getGraphicalProps();u.singular.forEach(function(v){var x=v==="dataLabel";d[v]=d[v].animate(x?{x:d[v].startXPos,y:d[v].startYPos,opacity:0}:a)}),u.plural.forEach(function(v){d[v].forEach(function(x){x.element&&x.animate(extend$1n({x:d.startXPos},x.startYPos?{x:x.startXPos,y:x.startYPos}:{}))})})},g.prototype.applyOptions=function(d,a){var u=this,v=u.series,x=v.options.pointValKey||v.pointValKey;return d=g.prototype.optionsToObject.call(this,d),extend$1n(u,d),u.options=u.options?extend$1n(u.options,d):d,d.group&&delete u.group,d.dataLabels&&delete u.dataLabels,x&&(u.y=g.prototype.getNestedProperty.call(u,x)),u.isNull=pick$1t(u.isValid&&!u.isValid(),u.x===null||!isNumber$K(u.y)),u.formatPrefix=u.isNull?"null":"point",u.selected&&(u.state="select"),"name"in u&&typeof a>"u"&&v.xAxis&&v.xAxis.hasNames&&(u.x=v.xAxis.nameToX(u)),typeof u.x>"u"&&v?typeof a>"u"?u.x=v.autoIncrement():u.x=a:isNumber$K(d.x)&&v.options.relativeXValue&&(u.x=v.autoIncrement(d.x)),u},g.prototype.destroy=function(){var d=this,a=d.series,u=a.chart,v=a.options.dataSorting,x=u.hoverPoints,S=d.series.chart.renderer.globalAnimation,T=animObject$a(S),P;function z(){(d.graphic||d.dataLabel||d.dataLabels)&&(removeEvent$8(d),d.destroyElements());for(P in d)d[P]=null}d.legendItem&&u.legend.destroyItem(d),x&&(d.setState(),erase$5(x,d),x.length||(u.hoverPoints=null)),d===u.hoverPoint&&d.onMouseOut(),!v||!v.enabled?z():(this.animateBeforeDestroy(),syncTimeout$5(z,T.duration)),u.pointCount--},g.prototype.destroyElements=function(d){var a=this,u=a.getGraphicalProps(d);u.singular.forEach(function(v){a[v]=a[v].destroy()}),u.plural.forEach(function(v){a[v].forEach(function(x){x.element&&x.destroy()}),delete a[v]})},g.prototype.firePointEvent=function(d,a,u){var v=this,x=this.series,S=x.options;(S.point.events[d]||v.options&&v.options.events&&v.options.events[d])&&v.importEvents(),d==="click"&&S.allowPointSelect&&(u=function(T){v.select&&v.select(null,T.ctrlKey||T.metaKey||T.shiftKey)}),fireEvent$w(v,d,a,u)},g.prototype.getClassName=function(){var d=this;return"highcharts-point"+(d.selected?" highcharts-point-select":"")+(d.negative?" highcharts-negative":"")+(d.isNull?" highcharts-null-point":"")+(typeof d.colorIndex<"u"?" highcharts-color-"+d.colorIndex:"")+(d.options.className?" "+d.options.className:"")+(d.zone&&d.zone.className?" "+d.zone.className.replace("highcharts-negative",""):"")},g.prototype.getGraphicalProps=function(d){var a=this,u=[],v={singular:[],plural:[]},x,S;for(d=d||{graphic:1,dataLabel:1},d.graphic&&u.push("graphic","upperGraphic","shadowGroup"),d.dataLabel&&u.push("dataLabel","dataLabelUpper","connector"),S=u.length;S--;)x=u[S],a[x]&&v.singular.push(x);return["dataLabel","connector"].forEach(function(T){var P=T+"s";d[T]&&a[P]&&v.plural.push(P)}),v},g.prototype.getLabelConfig=function(){return{x:this.category,y:this.y,color:this.color,colorIndex:this.colorIndex,key:this.name||this.category,series:this.series,point:this,percentage:this.percentage,total:this.total||this.stackTotal}},g.prototype.getNestedProperty=function(d){if(d)return d.indexOf("custom.")===0?getNestedProperty$1(d,this.options):this[d]},g.prototype.getZone=function(){var d=this.series,a=d.zones,u=d.zoneAxis||"y",v,x=0;for(v=a[x];this[u]>=v.value;)v=a[++x];return this.nonZonedColor||(this.nonZonedColor=this.color),v&&v.color&&!this.options.color?this.color=v.color:this.color=this.nonZonedColor,v},g.prototype.hasNewShapeType=function(){var d=this,a=d.graphic&&(d.graphic.symbolName||d.graphic.element.nodeName);return a!==this.shapeType},g.prototype.init=function(d,a,u){return this.series=d,this.applyOptions(a,u),this.id=defined$O(this.id)?this.id:uniqueKey$5(),this.resolveColor(),d.chart.pointCount++,fireEvent$w(this,"afterInit"),this},g.prototype.optionsToObject=function(d){var a=this.series,u=a.options.keys,v=u||a.pointArrayMap||["y"],x=v.length,S={},T,P=0,z=0;if(isNumber$K(d)||d===null)S[v[0]]=d;else if(isArray$k(d))for(!u&&d.length>x&&(T=typeof d[0],T==="string"?S.name=d[0]:T==="number"&&(S.x=d[0]),P++);z<x;)(!u||typeof d[P]<"u")&&(v[z].indexOf(".")>0?g.prototype.setNestedProperty(S,d[P],v[z]):S[v[z]]=d[P]),P++,z++;else typeof d=="object"&&(S=d,d.dataLabels&&(a._hasPointLabels=!0),d.marker&&(a._hasPointMarkers=!0));return S},g.prototype.resolveColor=function(){var d=this.series,a=d.chart.options.chart,u=d.chart.styledMode,v,x,S=a.colorCount,T;delete this.nonZonedColor,d.options.colorByPoint?(u||(x=d.options.colors||d.chart.options.colors,v=x[d.colorCounter],S=x.length),T=d.colorCounter,d.colorCounter++,d.colorCounter===S&&(d.colorCounter=0)):(u||(v=d.color),T=d.colorIndex),this.colorIndex=pick$1t(this.options.colorIndex,T),this.color=pick$1t(this.options.color,v)},g.prototype.setNestedProperty=function(d,a,u){var v=u.split(".");return v.reduce(function(x,S,T,P){var z=P.length-1===T;return x[S]=z?a:isObject$e(x[S],!0)?x[S]:{},x[S]},d),d},g.prototype.tooltipFormatter=function(d){var a=this.series,u=a.tooltipOptions,v=pick$1t(u.valueDecimals,""),x=u.valuePrefix||"",S=u.valueSuffix||"";return a.chart.styledMode&&(d=a.chart.tooltip.styledModeFormat(d)),(a.pointArrayMap||["y"]).forEach(function(T){T="{point."+T,(x||S)&&(d=d.replace(RegExp(T+"}","g"),x+T+"}"+S)),d=d.replace(RegExp(T+"}","g"),T+":,."+v+"f}")}),format$c(d,{point:this,series:this.series},a.chart)},g.prototype.update=function(d,a,u,v){var x=this,S=x.series,T=x.graphic,P=S.chart,z=S.options,L;a=pick$1t(a,!0);function N(){x.applyOptions(d);var $=T&&x.hasDummyGraphic,B=x.y===null?!$:$;T&&B&&(x.graphic=T.destroy(),delete x.hasDummyGraphic),isObject$e(d,!0)&&(T&&T.element&&d&&d.marker&&typeof d.marker.symbol<"u"&&(x.graphic=T.destroy()),d&&d.dataLabels&&x.dataLabel&&(x.dataLabel=x.dataLabel.destroy()),x.connector&&(x.connector=x.connector.destroy())),L=x.index,S.updateParallelArrays(x,L),z.data[L]=isObject$e(z.data[L],!0)||isObject$e(d,!0)?x.options:pick$1t(d,z.data[L]),S.isDirty=S.isDirtyData=!0,!S.fixedBox&&S.hasCartesianSeries&&(P.isDirtyBox=!0),z.legendType==="point"&&(P.isDirtyLegend=!0),a&&P.redraw(u)}v===!1?N():x.firePointEvent("update",{options:d},N)},g.prototype.remove=function(d,a){this.series.removePoint(this.series.data.indexOf(this),d,a)},g.prototype.select=function(d,a){var u=this,v=u.series,x=v.chart;d=pick$1t(d,!u.selected),this.selectedStaging=d,u.firePointEvent(d?"select":"unselect",{accumulate:a},function(){u.selected=u.options.selected=d,v.options.data[v.data.indexOf(u)]=u.options,u.setState(d&&"select"),a||x.getSelectedPoints().forEach(function(S){var T=S.series;S.selected&&S!==u&&(S.selected=S.options.selected=!1,T.options.data[T.data.indexOf(S)]=S.options,S.setState(x.hoverPoints&&T.options.inactiveOtherPoints?"inactive":""),S.firePointEvent("unselect"))})}),delete this.selectedStaging},g.prototype.onMouseOver=function(d){var a=this,u=a.series,v=u.chart,x=v.pointer;d=d?x.normalize(d):x.getChartCoordinatesFromPoint(a,v.inverted),x.runPointActions(d,a)},g.prototype.onMouseOut=function(){var d=this,a=d.series.chart;d.firePointEvent("mouseOut"),d.series.options.inactiveOtherPoints||(a.hoverPoints||[]).forEach(function(u){u.setState()}),a.hoverPoints=a.hoverPoint=null},g.prototype.importEvents=function(){if(!this.hasImportedEvents){var d=this,a=merge$1l(d.series.options.point,d.options),u=a.events;d.events=u,objectEach$s(u,function(v,x){isFunction$2(v)&&addEvent$12(d,x,v)}),this.hasImportedEvents=!0}},g.prototype.setState=function(d,a){var u=this,v=u.series,x=u.state,S=v.options.states[d||"normal"]||{},T=defaultOptions$g.plotOptions[v.type].marker&&v.options.marker,P=T&&T.enabled===!1,z=T&&T.states&&T.states[d||"normal"]||{},L=z.enabled===!1,N=u.marker||{},$=v.chart,B=T&&v.markerAttribs,U=v.halo,j,Y,q,Q=v.stateMarkerGraphic,J;if(d=d||"",!(d===u.state&&!a||u.selected&&d!=="select"||S.enabled===!1||d&&(L||P&&z.enabled===!1)||d&&N.states&&N.states[d]&&N.states[d].enabled===!1)){u.state=d,B&&(j=v.markerAttribs(u,d)),u.graphic&&!u.hasDummyGraphic?(x&&u.graphic.removeClass("highcharts-point-"+x),d&&u.graphic.addClass("highcharts-point-"+d),$.styledMode||(Y=v.pointAttribs(u,d),q=pick$1t($.options.chart.animation,S.animation),v.options.inactiveOtherPoints&&isNumber$K(Y.opacity)&&((u.dataLabels||[]).forEach(function(ae){ae&&ae.animate({opacity:Y.opacity},q)}),u.connector&&u.connector.animate({opacity:Y.opacity},q)),u.graphic.animate(Y,q)),j&&u.graphic.animate(j,pick$1t($.options.chart.animation,z.animation,T.animation)),Q&&Q.hide()):(d&&z&&(J=N.symbol||v.symbol,Q&&Q.currentSymbol!==J&&(Q=Q.destroy()),j&&(Q?Q[a?"animate":"attr"]({x:j.x,y:j.y}):J&&(v.stateMarkerGraphic=Q=$.renderer.symbol(J,j.x,j.y,j.width,j.height).add(v.markerGroup),Q.currentSymbol=J)),!$.styledMode&&Q&&Q.attr(v.pointAttribs(u,d))),Q&&(Q[d&&u.isInside?"show":"hide"](),Q.element.point=u,Q.addClass(u.getClassName(),!0)));var ee=S.halo,ie=u.graphic||Q,ne=ie&&ie.visibility||"inherit";ee&&ee.size&&ie&&ne!=="hidden"&&!u.isCluster?(U||(v.halo=U=$.renderer.path().add(ie.parentGroup)),U.show()[a?"animate":"attr"]({d:u.haloPath(ee.size)}),U.attr({class:"highcharts-halo highcharts-color-"+pick$1t(u.colorIndex,v.colorIndex)+(u.className?" "+u.className:""),visibility:ne,zIndex:-1}),U.point=u,$.styledMode||U.attr(extend$1n({fill:u.color||v.color,"fill-opacity":ee.opacity},AST.filterUserAttributes(ee.attributes||{})))):U&&U.point&&U.point.haloPath&&U.animate({d:U.point.haloPath(0)},null,U.hide),fireEvent$w(u,"afterSetState",{state:d})}},g.prototype.haloPath=function(d){var a=this.series,u=a.chart;return u.renderer.symbols.circle(Math.floor(this.plotX)-d,this.plotY-d,d*2,d*2)},g})(),color$e=Color.parse,charts$3=H.charts,noop$i=H.noop,addEvent$11=Utilities.addEvent,attr$2=Utilities.attr,css$8=Utilities.css,defined$N=Utilities.defined,extend$1m=Utilities.extend,find$k=Utilities.find,fireEvent$v=Utilities.fireEvent,isNumber$J=Utilities.isNumber,isObject$d=Utilities.isObject,objectEach$r=Utilities.objectEach,offset=Utilities.offset,pick$1s=Utilities.pick,splat$g=Utilities.splat,Pointer=(function(){function g(d,a){this.lastValidTouch={},this.pinchDown=[],this.runChartClick=!1,this.eventsToUnbind=[],this.chart=d,this.hasDragged=!1,this.options=a,this.init(d,a)}return g.prototype.applyInactiveState=function(d){var a=[],u;(d||[]).forEach(function(v){u=v.series,a.push(u),u.linkedParent&&a.push(u.linkedParent),u.linkedSeries&&(a=a.concat(u.linkedSeries)),u.navigatorSeries&&a.push(u.navigatorSeries)}),this.chart.series.forEach(function(v){a.indexOf(v)===-1?v.setState("inactive",!0):v.options.inactiveOtherPoints&&v.setAllPointsToState("inactive")})},g.prototype.destroy=function(){var d=this;this.eventsToUnbind.forEach(function(a){return a()}),this.eventsToUnbind=[],H.chartCount||(g.unbindDocumentMouseUp&&(g.unbindDocumentMouseUp=g.unbindDocumentMouseUp()),g.unbindDocumentTouchEnd&&(g.unbindDocumentTouchEnd=g.unbindDocumentTouchEnd())),clearInterval(d.tooltipTimeout),objectEach$r(d,function(a,u){d[u]=void 0})},g.prototype.drag=function(d){var a=this.chart,u=a.options.chart,v=this.zoomHor,x=this.zoomVert,S=a.plotLeft,T=a.plotTop,P=a.plotWidth,z=a.plotHeight,L=this.mouseDownX||0,N=this.mouseDownY||0,$=isObject$d(u.panning)?u.panning&&u.panning.enabled:u.panning,B=u.panKey&&d[u.panKey+"Key"],U=d.chartX,j=d.chartY,Y,q,Q=this.selectionMarker;Q&&Q.touch||(U<S?U=S:U>S+P&&(U=S+P),j<T?j=T:j>T+z&&(j=T+z),this.hasDragged=Math.sqrt(Math.pow(L-U,2)+Math.pow(N-j,2)),this.hasDragged>10&&(Y=a.isInsidePlot(L-S,N-T,{visiblePlotOnly:!0}),a.hasCartesianSeries&&(this.zoomX||this.zoomY)&&Y&&!B&&(Q||(this.selectionMarker=Q=a.renderer.rect(S,T,v?1:P,x?1:z,0).attr({class:"highcharts-selection-marker",zIndex:7}).add(),a.styledMode||Q.attr({fill:u.selectionMarkerFill||color$e(palette.highlightColor80).setOpacity(.25).get()}))),Q&&v&&(q=U-L,Q.attr({width:Math.abs(q),x:(q>0?0:q)+L})),Q&&x&&(q=j-N,Q.attr({height:Math.abs(q),y:(q>0?0:q)+N})),Y&&!Q&&$&&a.pan(d,u.panning)))},g.prototype.dragStart=function(d){var a=this.chart;a.mouseIsDown=d.type,a.cancelClick=!1,a.mouseDownX=this.mouseDownX=d.chartX,a.mouseDownY=this.mouseDownY=d.chartY},g.prototype.drop=function(d){var a=this,u=this.chart,v=this.hasPinched;if(this.selectionMarker){var x={originalEvent:d,xAxis:[],yAxis:[]},S=this.selectionMarker,T=S.attr?S.attr("x"):S.x,P=S.attr?S.attr("y"):S.y,z=S.attr?S.attr("width"):S.width,L=S.attr?S.attr("height"):S.height,N;(this.hasDragged||v)&&(u.axes.forEach(function($){if($.zoomEnabled&&defined$N($.min)&&(v||a[{xAxis:"zoomX",yAxis:"zoomY"}[$.coll]])&&isNumber$J(T)&&isNumber$J(P)){var B=$.horiz,U=d.type==="touchend"?$.minPixelPadding:0,j=$.toValue((B?T:P)+U),Y=$.toValue((B?T+z:P+L)-U);x[$.coll].push({axis:$,min:Math.min(j,Y),max:Math.max(j,Y)}),N=!0}}),N&&fireEvent$v(u,"selection",x,function($){u.zoom(extend$1m($,v?{animation:!1}:null))})),isNumber$J(u.index)&&(this.selectionMarker=this.selectionMarker.destroy()),v&&this.scaleGroups()}u&&isNumber$J(u.index)&&(css$8(u.container,{cursor:u._cursor}),u.cancelClick=this.hasDragged>10,u.mouseIsDown=this.hasDragged=this.hasPinched=!1,this.pinchDown=[])},g.prototype.findNearestKDPoint=function(d,a,u){var v=this.chart,x=v.hoverPoint,S=v.tooltip;if(x&&S&&S.isStickyOnContact())return x;var T;function P(z,L){var N=z.distX-L.distX,$=z.dist-L.dist,B=(L.series.group&&L.series.group.zIndex)-(z.series.group&&z.series.group.zIndex),U;return N!==0&&a?U=N:$!==0?U=$:B!==0?U=B:U=z.series.index>L.series.index?-1:1,U}return d.forEach(function(z){var L=z.noSharedTooltip&&a,N=!L&&z.options.findNearestPointBy.indexOf("y")<0,$=z.searchPoint(u,N);isObject$d($,!0)&&$.series&&(!isObject$d(T,!0)||P(T,$)>0)&&(T=$)}),T},g.prototype.getChartCoordinatesFromPoint=function(d,a){var u=d.series,v=u.xAxis,x=u.yAxis,S=d.shapeArgs;if(v&&x){var T=pick$1s(d.clientX,d.plotX),P=d.plotY||0;return d.isNode&&S&&isNumber$J(S.x)&&isNumber$J(S.y)&&(T=S.x,P=S.y),a?{chartX:x.len+x.pos-P,chartY:v.len+v.pos-T}:{chartX:T+v.pos,chartY:P+x.pos}}if(S&&S.x&&S.y)return{chartX:S.x,chartY:S.y}},g.prototype.getChartPosition=function(){if(this.chartPosition)return this.chartPosition;var d=this.chart.container,a=offset(d);this.chartPosition={left:a.left,top:a.top,scaleX:1,scaleY:1};var u=d.offsetWidth,v=d.offsetHeight;return u>2&&v>2&&(this.chartPosition.scaleX=a.width/u,this.chartPosition.scaleY=a.height/v),this.chartPosition},g.prototype.getCoordinates=function(d){var a={xAxis:[],yAxis:[]};return this.chart.axes.forEach(function(u){a[u.isXAxis?"xAxis":"yAxis"].push({axis:u,value:u.toValue(d[u.horiz?"chartX":"chartY"])})}),a},g.prototype.getHoverData=function(d,a,u,v,x,S){var T=[],P=!!(v&&d),z=function(j){return j.visible&&!(!x&&j.directTouch)&&pick$1s(j.options.enableMouseTracking,!0)},L=a,N,$={chartX:S?S.chartX:void 0,chartY:S?S.chartY:void 0,shared:x};fireEvent$v(this,"beforeGetHoverData",$);var B=L&&!L.stickyTracking;N=B?[L]:u.filter(function(j){return $.filter?$.filter(j):z(j)&&j.stickyTracking});var U=P||!S?d:this.findNearestKDPoint(N,x,S);return L=U&&U.series,U&&(x&&!L.noSharedTooltip?(N=u.filter(function(j){return $.filter?$.filter(j):z(j)&&!j.noSharedTooltip}),N.forEach(function(j){var Y=find$k(j.points,function(q){return q.x===U.x&&!q.isNull});isObject$d(Y)&&(j.chart.isBoosting&&(Y=j.getPoint(Y)),T.push(Y))})):T.push(U)),$={hoverPoint:U},fireEvent$v(this,"afterGetHoverData",$),{hoverPoint:$.hoverPoint,hoverSeries:L,hoverPoints:T}},g.prototype.getPointFromEvent=function(d){for(var a=d.target,u;a&&!u;)u=a.point,a=a.parentNode;return u},g.prototype.onTrackerMouseOut=function(d){var a=this.chart,u=d.relatedTarget||d.toElement,v=a.hoverSeries;this.isDirectTouch=!1,v&&u&&!v.stickyTracking&&!this.inClass(u,"highcharts-tooltip")&&(!this.inClass(u,"highcharts-series-"+v.index)||!this.inClass(u,"highcharts-tracker"))&&v.onMouseOut()},g.prototype.inClass=function(d,a){for(var u;d;){if(u=attr$2(d,"class"),u){if(u.indexOf(a)!==-1)return!0;if(u.indexOf("highcharts-container")!==-1)return!1}d=d.parentNode}},g.prototype.init=function(d,a){this.options=a,this.chart=d,this.runChartClick=!!(a.chart.events&&a.chart.events.click),this.pinchDown=[],this.lastValidTouch={},Tooltip&&(d.tooltip=new Tooltip(d,a.tooltip),this.followTouchMove=pick$1s(a.tooltip.followTouchMove,!0)),this.setDOMEvents()},g.prototype.normalize=function(d,a){var u=d.touches,v=u?u.length?u.item(0):pick$1s(u.changedTouches,d.changedTouches)[0]:d;a||(a=this.getChartPosition());var x=v.pageX-a.left,S=v.pageY-a.top;return x/=a.scaleX,S/=a.scaleY,extend$1m(d,{chartX:Math.round(x),chartY:Math.round(S)})},g.prototype.onContainerClick=function(d){var a=this.chart,u=a.hoverPoint,v=this.normalize(d),x=a.plotLeft,S=a.plotTop;a.cancelClick||(u&&this.inClass(v.target,"highcharts-tracker")?(fireEvent$v(u.series,"click",extend$1m(v,{point:u})),a.hoverPoint&&u.firePointEvent("click",v)):(extend$1m(v,this.getCoordinates(v)),a.isInsidePlot(v.chartX-x,v.chartY-S,{visiblePlotOnly:!0})&&fireEvent$v(a,"click",v)))},g.prototype.onContainerMouseDown=function(d){var a=((d.buttons||d.button)&1)===1;d=this.normalize(d),H.isFirefox&&d.button!==0&&this.onContainerMouseMove(d),(typeof d.button>"u"||a)&&(this.zoomOption(d),a&&d.preventDefault&&d.preventDefault(),this.dragStart(d))},g.prototype.onContainerMouseLeave=function(d){var a=charts$3[pick$1s(g.hoverChartIndex,-1)],u=this.chart.tooltip;u&&u.shouldStickOnContact()&&this.inClass(d.relatedTarget,"highcharts-tooltip-container")||(d=this.normalize(d),a&&(d.relatedTarget||d.toElement)&&(a.pointer.reset(),a.pointer.chartPosition=void 0),u&&!u.isHidden&&this.reset())},g.prototype.onContainerMouseEnter=function(d){delete this.chartPosition},g.prototype.onContainerMouseMove=function(d){var a=this.chart,u=this.normalize(d);this.setHoverChartIndex(),u.preventDefault||(u.returnValue=!1),(a.mouseIsDown==="mousedown"||this.touchSelect(u))&&this.drag(u),!a.openMenu&&(this.inClass(u.target,"highcharts-tracker")||a.isInsidePlot(u.chartX-a.plotLeft,u.chartY-a.plotTop,{visiblePlotOnly:!0}))&&(this.inClass(u.target,"highcharts-no-tooltip")?this.reset(!1,0):this.runPointActions(u))},g.prototype.onDocumentTouchEnd=function(d){var a=charts$3[pick$1s(g.hoverChartIndex,-1)];a&&a.pointer.drop(d)},g.prototype.onContainerTouchMove=function(d){this.touchSelect(d)?this.onContainerMouseMove(d):this.touch(d)},g.prototype.onContainerTouchStart=function(d){this.touchSelect(d)?this.onContainerMouseDown(d):(this.zoomOption(d),this.touch(d,!0))},g.prototype.onDocumentMouseMove=function(d){var a=this.chart,u=this.chartPosition,v=this.normalize(d,u),x=a.tooltip;u&&(!x||!x.isStickyOnContact())&&!a.isInsidePlot(v.chartX-a.plotLeft,v.chartY-a.plotTop,{visiblePlotOnly:!0})&&!this.inClass(v.target,"highcharts-tracker")&&this.reset()},g.prototype.onDocumentMouseUp=function(d){var a=charts$3[pick$1s(g.hoverChartIndex,-1)];a&&a.pointer.drop(d)},g.prototype.pinch=function(d){var a=this,u=a.chart,v=a.pinchDown,x=d.touches||[],S=x.length,T=a.lastValidTouch,P=a.hasZoom,z={},L=S===1&&(a.inClass(d.target,"highcharts-tracker")&&u.runTrackerClick||a.runChartClick),N={},$=a.selectionMarker;S>1?a.initiated=!0:S===1&&this.followTouchMove&&(a.initiated=!1),P&&a.initiated&&!L&&d.cancelable!==!1&&d.preventDefault(),[].map.call(x,function(B){return a.normalize(B)}),d.type==="touchstart"?([].forEach.call(x,function(B,U){v[U]={chartX:B.chartX,chartY:B.chartY}}),T.x=[v[0].chartX,v[1]&&v[1].chartX],T.y=[v[0].chartY,v[1]&&v[1].chartY],u.axes.forEach(function(B){if(B.zoomEnabled){var U=u.bounds[B.horiz?"h":"v"],j=B.minPixelPadding,Y=B.toPixels(Math.min(pick$1s(B.options.min,B.dataMin),B.dataMin)),q=B.toPixels(Math.max(pick$1s(B.options.max,B.dataMax),B.dataMax)),Q=Math.min(Y,q),J=Math.max(Y,q);U.min=Math.min(B.pos,Q-j),U.max=Math.max(B.pos+B.len,J+j)}}),a.res=!0):a.followTouchMove&&S===1?this.runPointActions(a.normalize(d)):v.length&&($||(a.selectionMarker=$=extend$1m({destroy:noop$i,touch:!0},u.plotBox)),a.pinchTranslate(v,x,z,$,N,T),a.hasPinched=P,a.scaleGroups(z,N),a.res&&(a.res=!1,this.reset(!1,0)))},g.prototype.pinchTranslate=function(d,a,u,v,x,S){this.zoomHor&&this.pinchTranslateDirection(!0,d,a,u,v,x,S),this.zoomVert&&this.pinchTranslateDirection(!1,d,a,u,v,x,S)},g.prototype.pinchTranslateDirection=function(d,a,u,v,x,S,T,P){var z=this.chart,L=d?"x":"y",N=d?"X":"Y",$="chart"+N,B=d?"width":"height",U=z["plot"+(d?"Left":"Top")],j=z.inverted,Y=z.bounds[d?"h":"v"],q=a.length===1,Q=a[0][$],J=!q&&a[1][$],ee=function(){typeof pe=="number"&&Math.abs(Q-J)>20&&(de=P||Math.abs(he-pe)/Math.abs(Q-J)),ae=(U-he)/de+Q,ie=z["plot"+(d?"Width":"Height")]/de},ie,ne,ae,de=P||1,he=u[0][$],pe=!q&&u[1][$],ve;ee(),ne=ae,ne<Y.min?(ne=Y.min,ve=!0):ne+ie>Y.max&&(ne=Y.max-ie,ve=!0),ve?(he-=.8*(he-T[L][0]),typeof pe=="number"&&(pe-=.8*(pe-T[L][1])),ee()):T[L]=[he,pe],j||(S[L]=ae-U,S[B]=ie);var be=j?d?"scaleY":"scaleX":"scale"+N,ge=j?1/de:de;x[B]=ie,x[L]=ne,v[be]=de,v["translate"+N]=ge*U+(he-ge*Q)},g.prototype.reset=function(d,a){var u=this,v=u.chart,x=v.hoverSeries,S=v.hoverPoint,T=v.hoverPoints,P=v.tooltip,z=P&&P.shared?T:S;d&&z&&splat$g(z).forEach(function(L){L.series.isCartesian&&typeof L.plotX>"u"&&(d=!1)}),d?P&&z&&splat$g(z).length&&(P.refresh(z),P.shared&&T?T.forEach(function(L){L.setState(L.state,!0),L.series.isCartesian&&(L.series.xAxis.crosshair&&L.series.xAxis.drawCrosshair(null,L),L.series.yAxis.crosshair&&L.series.yAxis.drawCrosshair(null,L))}):S&&(S.setState(S.state,!0),v.axes.forEach(function(L){L.crosshair&&S.series[L.coll]===L&&L.drawCrosshair(null,S)}))):(S&&S.onMouseOut(),T&&T.forEach(function(L){L.setState()}),x&&x.onMouseOut(),P&&P.hide(a),u.unDocMouseMove&&(u.unDocMouseMove=u.unDocMouseMove()),v.axes.forEach(function(L){L.hideCrosshair()}),u.hoverX=v.hoverPoints=v.hoverPoint=null)},g.prototype.runPointActions=function(d,a){var u=this,v=u.chart,x=v.series,S=v.tooltip&&v.tooltip.options.enabled?v.tooltip:void 0,T=S?S.shared:!1,P=a||v.hoverPoint,z=P&&P.series||v.hoverSeries,L=(!d||d.type!=="touchmove")&&(!!a||z&&z.directTouch&&u.isDirectTouch),N=this.getHoverData(P,z,x,L,T,d);P=N.hoverPoint,z=N.hoverSeries;var $=N.hoverPoints,B=z&&z.tooltipOptions.followPointer&&!z.tooltipOptions.split,U=T&&z&&!z.noSharedTooltip;if(P&&(P!==v.hoverPoint||S&&S.isHidden)){if((v.hoverPoints||[]).forEach(function(Y){$.indexOf(Y)===-1&&Y.setState()}),v.hoverSeries!==z&&z.onMouseOver(),u.applyInactiveState($),($||[]).forEach(function(Y){Y.setState("hover")}),v.hoverPoint&&v.hoverPoint.firePointEvent("mouseOut"),!P.series)return;v.hoverPoints=$,v.hoverPoint=P,P.firePointEvent("mouseOver"),S&&S.refresh(U?$:P,d)}else if(B&&S&&!S.isHidden){var j=S.getAnchor([{}],d);v.isInsidePlot(j[0],j[1],{visiblePlotOnly:!0})&&S.updatePosition({plotX:j[0],plotY:j[1]})}u.unDocMouseMove||(u.unDocMouseMove=addEvent$11(v.container.ownerDocument,"mousemove",function(Y){var q=charts$3[g.hoverChartIndex];q&&q.pointer.onDocumentMouseMove(Y)}),u.eventsToUnbind.push(u.unDocMouseMove)),v.axes.forEach(function(q){var Q=pick$1s((q.crosshair||{}).snap,!0),J;Q&&(J=v.hoverPoint,(!J||J.series[q.coll]!==q)&&(J=find$k($,function(ee){return ee.series[q.coll]===q}))),J||!Q?q.drawCrosshair(d,J):q.hideCrosshair()})},g.prototype.scaleGroups=function(d,a){var u=this.chart;u.series.forEach(function(v){var x=d||v.getPlotBox();v.xAxis&&v.xAxis.zoomEnabled&&v.group&&(v.group.attr(x),v.markerGroup&&(v.markerGroup.attr(x),v.markerGroup.clip(a?u.clipRect:null)),v.dataLabelsGroup&&v.dataLabelsGroup.attr(x))}),u.clipRect.attr(a||u.clipBox)},g.prototype.setDOMEvents=function(){var d=this,a=this.chart.container,u=a.ownerDocument;a.onmousedown=this.onContainerMouseDown.bind(this),a.onmousemove=this.onContainerMouseMove.bind(this),a.onclick=this.onContainerClick.bind(this),this.eventsToUnbind.push(addEvent$11(a,"mouseenter",this.onContainerMouseEnter.bind(this))),this.eventsToUnbind.push(addEvent$11(a,"mouseleave",this.onContainerMouseLeave.bind(this))),g.unbindDocumentMouseUp||(g.unbindDocumentMouseUp=addEvent$11(u,"mouseup",this.onDocumentMouseUp.bind(this)));for(var v=this.chart.renderTo.parentElement;v&&v.tagName!=="BODY";)this.eventsToUnbind.push(addEvent$11(v,"scroll",function(){delete d.chartPosition})),v=v.parentElement;H.hasTouch&&(this.eventsToUnbind.push(addEvent$11(a,"touchstart",this.onContainerTouchStart.bind(this),{passive:!1})),this.eventsToUnbind.push(addEvent$11(a,"touchmove",this.onContainerTouchMove.bind(this),{passive:!1})),g.unbindDocumentTouchEnd||(g.unbindDocumentTouchEnd=addEvent$11(u,"touchend",this.onDocumentTouchEnd.bind(this),{passive:!1})))},g.prototype.setHoverChartIndex=function(){var d=this.chart,a=H.charts[pick$1s(g.hoverChartIndex,-1)];a&&a!==d&&a.pointer.onContainerMouseLeave({relatedTarget:!0}),(!a||!a.mouseIsDown)&&(g.hoverChartIndex=d.index)},g.prototype.touch=function(d,a){var u=this.chart,v,x,S;this.setHoverChartIndex(),d.touches.length===1?(d=this.normalize(d),S=u.isInsidePlot(d.chartX-u.plotLeft,d.chartY-u.plotTop,{visiblePlotOnly:!0}),S&&!u.openMenu?(a&&this.runPointActions(d),d.type==="touchmove"&&(x=this.pinchDown,v=x[0]?Math.sqrt(Math.pow(x[0].chartX-d.chartX,2)+Math.pow(x[0].chartY-d.chartY,2))>=4:!1),pick$1s(v,!0)&&this.pinch(d)):a&&this.reset()):d.touches.length===2&&this.pinch(d)},g.prototype.touchSelect=function(d){return!!(this.chart.options.chart.zoomBySingleTouch&&d.touches&&d.touches.length===1)},g.prototype.zoomOption=function(d){var a=this.chart,u=a.options.chart,v=a.inverted,x=u.zoomType||"",S,T;/touch/.test(d.type)&&(x=pick$1s(u.pinchType,x)),this.zoomX=S=/x/.test(x),this.zoomY=T=/y/.test(x),this.zoomHor=S&&!v||T&&v,this.zoomVert=T&&!v||S&&v,this.hasZoom=S||T},g})(),__extends$2e=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),charts$2=H.charts,doc$h=H.doc,noop$h=H.noop,win$a=H.win,addEvent$10=Utilities.addEvent,css$7=Utilities.css,objectEach$q=Utilities.objectEach,removeEvent$7=Utilities.removeEvent,touches={},hasPointerEvent=!!win$a.PointerEvent;function getWebkitTouches(){var g=[];return g.item=function(d){return this[d]},objectEach$q(touches,function(d){g.push({pageX:d.pageX,pageY:d.pageY,target:d.target})}),g}function translateMSPointer(g,d,a,u){var v=charts$2[Pointer.hoverChartIndex||NaN];if((g.pointerType==="touch"||g.pointerType===g.MSPOINTER_TYPE_TOUCH)&&v){var x=v.pointer;u(g),x[d]({type:a,target:g.currentTarget,preventDefault:noop$h,touches:getWebkitTouches()})}}var MSPointer=(function(g){__extends$2e(d,g);function d(){return g!==null&&g.apply(this,arguments)||this}return d.isRequired=function(){return!!(!H.hasTouch&&(win$a.PointerEvent||win$a.MSPointerEvent))},d.prototype.batchMSEvents=function(a){a(this.chart.container,hasPointerEvent?"pointerdown":"MSPointerDown",this.onContainerPointerDown),a(this.chart.container,hasPointerEvent?"pointermove":"MSPointerMove",this.onContainerPointerMove),a(doc$h,hasPointerEvent?"pointerup":"MSPointerUp",this.onDocumentPointerUp)},d.prototype.destroy=function(){this.batchMSEvents(removeEvent$7),g.prototype.destroy.call(this)},d.prototype.init=function(a,u){g.prototype.init.call(this,a,u),this.hasZoom&&css$7(a.container,{"-ms-touch-action":"none","touch-action":"none"})},d.prototype.onContainerPointerDown=function(a){translateMSPointer(a,"onContainerTouchStart","touchstart",function(u){touches[u.pointerId]={pageX:u.pageX,pageY:u.pageY,target:u.currentTarget}})},d.prototype.onContainerPointerMove=function(a){translateMSPointer(a,"onContainerTouchMove","touchmove",function(u){touches[u.pointerId]={pageX:u.pageX,pageY:u.pageY},touches[u.pointerId].target||(touches[u.pointerId].target=u.currentTarget)})},d.prototype.onDocumentPointerUp=function(a){translateMSPointer(a,"onDocumentTouchEnd","touchend",function(u){delete touches[u.pointerId]})},d.prototype.setDOMEvents=function(){g.prototype.setDOMEvents.call(this),(this.hasZoom||this.followTouchMove)&&this.batchMSEvents(addEvent$10)},d})(Pointer),animObject$9=animationExports.animObject,setAnimation$4=animationExports.setAnimation,format$b=FormatUtilities.format,isFirefox$1=H.isFirefox,marginNames$1=H.marginNames,win$9=H.win,distribute$2=R.distribute,addEvent$$=Utilities.addEvent,createElement$6=Utilities.createElement,css$6=Utilities.css,defined$M=Utilities.defined,discardElement$4=Utilities.discardElement,find$j=Utilities.find,fireEvent$u=Utilities.fireEvent,isNumber$I=Utilities.isNumber,merge$1k=Utilities.merge,pick$1r=Utilities.pick,relativeLength$8=Utilities.relativeLength,stableSort$5=Utilities.stableSort,syncTimeout$4=Utilities.syncTimeout,wrap$g=Utilities.wrap,Legend=(function(){function g(d,a){this.allItems=[],this.box=void 0,this.contentGroup=void 0,this.display=!1,this.group=void 0,this.initialItemY=0,this.itemHeight=0,this.itemMarginBottom=0,this.itemMarginTop=0,this.itemX=0,this.itemY=0,this.lastItemY=0,this.lastLineHeight=0,this.legendHeight=0,this.legendWidth=0,this.maxItemWidth=0,this.maxLegendWidth=0,this.offsetWidth=0,this.options={},this.padding=0,this.pages=[],this.proximate=!1,this.scrollGroup=void 0,this.symbolHeight=0,this.symbolWidth=0,this.titleHeight=0,this.totalItemWidth=0,this.widthOption=0,this.chart=d,this.init(d,a)}return g.prototype.init=function(d,a){this.chart=d,this.setOptions(a),a.enabled&&(this.render(),addEvent$$(this.chart,"endResize",function(){this.legend.positionCheckboxes()}),this.proximate?this.unchartrender=addEvent$$(this.chart,"render",function(){this.legend.proximatePositions(),this.legend.positionItems()}):this.unchartrender&&this.unchartrender())},g.prototype.setOptions=function(d){var a=pick$1r(d.padding,8);this.options=d,this.chart.styledMode||(this.itemStyle=d.itemStyle,this.itemHiddenStyle=merge$1k(this.itemStyle,d.itemHiddenStyle)),this.itemMarginTop=d.itemMarginTop||0,this.itemMarginBottom=d.itemMarginBottom||0,this.padding=a,this.initialItemY=a-5,this.symbolWidth=pick$1r(d.symbolWidth,16),this.pages=[],this.proximate=d.layout==="proximate"&&!this.chart.inverted,this.baseline=void 0},g.prototype.update=function(d,a){var u=this.chart;this.setOptions(merge$1k(!0,this.options,d)),this.destroy(),u.isDirtyLegend=u.isDirtyBox=!0,pick$1r(a,!0)&&u.redraw(),fireEvent$u(this,"afterUpdate")},g.prototype.colorizeItem=function(d,a){if(d.legendGroup[a?"removeClass":"addClass"]("highcharts-legend-item-hidden"),!this.chart.styledMode){var u=this,v=u.options,x=d.legendItem,S=d.legendLine,T=d.legendSymbol,P=u.itemHiddenStyle.color,z=a?v.itemStyle.color:P,L=a&&d.color||P,N=d.options&&d.options.marker,$={fill:L};x&&x.css({fill:z,color:z}),S&&S.attr({stroke:L}),T&&(N&&T.isMarker&&($=d.pointAttribs(),a||($.stroke=$.fill=P)),T.attr($))}fireEvent$u(this,"afterColorizeItem",{item:d,visible:a})},g.prototype.positionItems=function(){this.allItems.forEach(this.positionItem,this),this.chart.isResizing||this.positionCheckboxes()},g.prototype.positionItem=function(d){var a=this,u=this,v=u.options,x=v.symbolPadding,S=!v.rtl,T=d._legendItemPos,P=T[0],z=T[1],L=d.checkbox,N=d.legendGroup;if(N&&N.element){var $={translateX:S?P:u.legendWidth-P-2*x-4,translateY:z},B=function(){fireEvent$u(a,"afterPositionItem",{item:d})};defined$M(N.translateY)?N.animate($,void 0,B):(N.attr($),B())}L&&(L.x=P,L.y=z)},g.prototype.destroyItem=function(d){var a=d.checkbox;["legendItem","legendLine","legendSymbol","legendGroup"].forEach(function(u){d[u]&&(d[u]=d[u].destroy())}),a&&discardElement$4(d.checkbox)},g.prototype.destroy=function(){function d(a){this[a]&&(this[a]=this[a].destroy())}this.getAllItems().forEach(function(a){["legendItem","legendGroup"].forEach(d,a)}),["clipRect","up","down","pager","nav","box","title","group"].forEach(d,this),this.display=null},g.prototype.positionCheckboxes=function(){var d=this.group&&this.group.alignAttr,a=this.clipHeight||this.legendHeight,u=this.titleHeight,v;d&&(v=d.translateY,this.allItems.forEach(function(x){var S=x.checkbox,T;S&&(T=v+u+S.y+(this.scrollOffset||0)+3,css$6(S,{left:d.translateX+x.checkboxOffset+S.x-20+"px",top:T+"px",display:this.proximate||T>v-6&&T<v+a-6?"":"none"}))},this))},g.prototype.renderTitle=function(){var d=this.options,a=this.padding,u=d.title,v,x=0;u.text&&(this.title||(this.title=this.chart.renderer.label(u.text,a-3,a-4,null,null,null,d.useHTML,null,"legend-title").attr({zIndex:1}),this.chart.styledMode||this.title.css(u.style),this.title.add(this.group)),u.width||this.title.css({width:this.maxLegendWidth+"px"}),v=this.title.getBBox(),x=v.height,this.offsetWidth=v.width,this.contentGroup.attr({translateY:x})),this.titleHeight=x},g.prototype.setText=function(d){var a=this.options;d.legendItem.attr({text:a.labelFormat?format$b(a.labelFormat,d,this.chart):a.labelFormatter.call(d)})},g.prototype.renderItem=function(d){var a=this,u=a.chart,v=u.renderer,x=a.options,S=x.layout==="horizontal",T=a.symbolWidth,P=x.symbolPadding||0,z=a.itemStyle,L=a.itemHiddenStyle,N=S?pick$1r(x.itemDistance,20):0,$=!x.rtl,B=!d.series,U=!B&&d.series.drawLegendSymbol?d.series:d,j=U.options,Y=a.createCheckboxForItem&&j&&j.showCheckbox,q=x.useHTML,Q=d.options.className,J=d.legendItem,ee=T+P+N+(Y?20:0);J||(d.legendGroup=v.g("legend-item").addClass("highcharts-"+U.type+"-series highcharts-color-"+d.colorIndex+(Q?" "+Q:"")+(B?" highcharts-series-"+d.index:"")).attr({zIndex:1}).add(a.scrollGroup),d.legendItem=J=v.text("",$?T+P:-P,a.baseline||0,q),u.styledMode||J.css(merge$1k(d.visible?z:L)),J.attr({align:$?"left":"right",zIndex:2}).add(d.legendGroup),a.baseline||(a.fontMetrics=v.fontMetrics(u.styledMode?12:z.fontSize,J),a.baseline=a.fontMetrics.f+3+a.itemMarginTop,J.attr("y",a.baseline),a.symbolHeight=x.symbolHeight||a.fontMetrics.f,x.squareSymbol&&(a.symbolWidth=pick$1r(x.symbolWidth,Math.max(a.symbolHeight,16)),ee=a.symbolWidth+P+N+(Y?20:0),$&&J.attr("x",a.symbolWidth+P))),U.drawLegendSymbol(a,d),a.setItemEvents&&a.setItemEvents(d,J,q)),Y&&!d.checkbox&&a.createCheckboxForItem&&a.createCheckboxForItem(d),a.colorizeItem(d,d.visible),(u.styledMode||!z.width)&&J.css({width:(x.itemWidth||a.widthOption||u.spacingBox.width)-ee+"px"}),a.setText(d);var ie=J.getBBox();d.itemWidth=d.checkboxOffset=x.itemWidth||d.legendItemWidth||ie.width+ee,a.maxItemWidth=Math.max(a.maxItemWidth,d.itemWidth),a.totalItemWidth+=d.itemWidth,a.itemHeight=d.itemHeight=Math.round(d.legendItemHeight||ie.height||a.symbolHeight)},g.prototype.layoutItem=function(d){var a=this.options,u=this.padding,v=a.layout==="horizontal",x=d.itemHeight,S=this.itemMarginBottom,T=this.itemMarginTop,P=v?pick$1r(a.itemDistance,20):0,z=this.maxLegendWidth,L=a.alignColumns&&this.totalItemWidth>z?this.maxItemWidth:d.itemWidth;v&&this.itemX-u+L>z&&(this.itemX=u,this.lastLineHeight&&(this.itemY+=T+this.lastLineHeight+S),this.lastLineHeight=0),this.lastItemY=T+this.itemY+S,this.lastLineHeight=Math.max(x,this.lastLineHeight),d._legendItemPos=[this.itemX,this.itemY],v?this.itemX+=L:(this.itemY+=T+x+S,this.lastLineHeight=x),this.offsetWidth=this.widthOption||Math.max((v?this.itemX-u-(d.checkbox?0:P):L)+u,this.offsetWidth)},g.prototype.getAllItems=function(){var d=[];return this.chart.series.forEach(function(a){var u=a&&a.options;a&&pick$1r(u.showInLegend,defined$M(u.linkedTo)?!1:void 0,!0)&&(d=d.concat(a.legendItems||(u.legendType==="point"?a.data:a)))}),fireEvent$u(this,"afterGetAllItems",{allItems:d}),d},g.prototype.getAlignment=function(){var d=this.options;return this.proximate?d.align.charAt(0)+"tv":d.floating?"":d.align.charAt(0)+d.verticalAlign.charAt(0)+d.layout.charAt(0)},g.prototype.adjustMargins=function(d,a){var u=this.chart,v=this.options,x=this.getAlignment();x&&[/(lth|ct|rth)/,/(rtv|rm|rbv)/,/(rbh|cb|lbh)/,/(lbv|lm|ltv)/].forEach(function(S,T){S.test(x)&&!defined$M(d[T])&&(u[marginNames$1[T]]=Math.max(u[marginNames$1[T]],u.legend[(T+1)%2?"legendHeight":"legendWidth"]+[1,-1,-1,1][T]*v[T%2?"x":"y"]+pick$1r(v.margin,12)+a[T]+(u.titleOffset[T]||0)))})},g.prototype.proximatePositions=function(){var d=this.chart,a=[],u=this.options.align==="left";this.allItems.forEach(function(v){var x,S,T=u,P,z;v.yAxis&&(v.xAxis.options.reversed&&(T=!T),v.points&&(x=find$j(T?v.points:v.points.slice(0).reverse(),function(L){return isNumber$I(L.plotY)})),S=this.itemMarginTop+v.legendItem.getBBox().height+this.itemMarginBottom,z=v.yAxis.top-d.plotTop,v.visible?(P=x?x.plotY:v.yAxis.height,P+=z-.3*S):P=z+v.yAxis.height,a.push({target:P,size:S,item:v}))},this),distribute$2(a,d.plotHeight).forEach(function(v){v.item._legendItemPos&&(v.item._legendItemPos[1]=d.plotTop-d.spacing[0]+v.pos)})},g.prototype.render=function(){var d=this,a=d.chart,u=a.renderer,v=d.options,x=d.padding,S=d.getAllItems(),T,P,z,L=d.group,N,$=d.box;d.itemX=x,d.itemY=d.initialItemY,d.offsetWidth=0,d.lastItemY=0,d.widthOption=relativeLength$8(v.width,a.spacingBox.width-x),N=a.spacingBox.width-2*x-v.x,["rm","lm"].indexOf(d.getAlignment().substring(0,2))>-1&&(N/=2),d.maxLegendWidth=d.widthOption||N,L||(d.group=L=u.g("legend").addClass(v.className||"").attr({zIndex:7}).add(),d.contentGroup=u.g().attr({zIndex:1}).add(L),d.scrollGroup=u.g().add(d.contentGroup)),d.renderTitle(),stableSort$5(S,function(B,U){return(B.options&&B.options.legendIndex||0)-(U.options&&U.options.legendIndex||0)}),v.reversed&&S.reverse(),d.allItems=S,d.display=T=!!S.length,d.lastLineHeight=0,d.maxItemWidth=0,d.totalItemWidth=0,d.itemHeight=0,S.forEach(d.renderItem,d),S.forEach(d.layoutItem,d),P=(d.widthOption||d.offsetWidth)+x,z=d.lastItemY+d.lastLineHeight+d.titleHeight,z=d.handleOverflow(z),z+=x,$||(d.box=$=u.rect().addClass("highcharts-legend-box").attr({r:v.borderRadius}).add(L),$.isNew=!0),a.styledMode||$.attr({stroke:v.borderColor,"stroke-width":v.borderWidth||0,fill:v.backgroundColor||"none"}).shadow(v.shadow),P>0&&z>0&&($[$.isNew?"attr":"animate"]($.crisp.call({},{x:0,y:0,width:P,height:z},$.strokeWidth())),$.isNew=!1),$[T?"show":"hide"](),a.styledMode&&L.getStyle("display")==="none"&&(P=z=0),d.legendWidth=P,d.legendHeight=z,T&&d.align(),this.proximate||this.positionItems(),fireEvent$u(this,"afterRender")},g.prototype.align=function(d){d===void 0&&(d=this.chart.spacingBox);var a=this.chart,u=this.options,v=d.y;/(lth|ct|rth)/.test(this.getAlignment())&&a.titleOffset[0]>0?v+=a.titleOffset[0]:/(lbh|cb|rbh)/.test(this.getAlignment())&&a.titleOffset[2]>0&&(v-=a.titleOffset[2]),v!==d.y&&(d=merge$1k(d,{y:v})),this.group.align(merge$1k(u,{width:this.legendWidth,height:this.legendHeight,verticalAlign:this.proximate?"top":u.verticalAlign}),!0,d)},g.prototype.handleOverflow=function(d){var a=this,u=this.chart,v=u.renderer,x=this.options,S=x.y,T=x.verticalAlign==="top",P=this.padding,z=x.maxHeight,L=x.navigation,N=pick$1r(L.animation,!0),$=L.arrowSize||12,B=this.pages,U=this.allItems,j=function(ne){typeof ne=="number"?ie.attr({height:ne}):ie&&(a.clipRect=ie.destroy(),a.contentGroup.clip()),a.contentGroup.div&&(a.contentGroup.div.style.clip=ne?"rect("+P+"px,9999px,"+(P+ne)+"px,0)":"auto")},Y=function(ne){return a[ne]=v.circle(0,0,$*1.3).translate($/2,$/2).add(ee),u.styledMode||a[ne].attr("fill","rgba(0,0,0,0.0001)"),a[ne]},q,Q,J=u.spacingBox.height+(T?-S:S)-P,ee=this.nav,ie=this.clipRect;return x.layout==="horizontal"&&x.verticalAlign!=="middle"&&!x.floating&&(J/=2),z&&(J=Math.min(J,z)),B.length=0,d&&J>0&&d>J&&L.enabled!==!1?(this.clipHeight=q=Math.max(J-20-this.titleHeight-P,0),this.currentPage=pick$1r(this.currentPage,1),this.fullHeight=d,U.forEach(function(ne,ae){var de=ne._legendItemPos[1],he=Math.round(ne.legendItem.getBBox().height),pe=B.length;(!pe||de-B[pe-1]>q&&(Q||de)!==B[pe-1])&&(B.push(Q||de),pe++),ne.pageIx=pe-1,Q&&(U[ae-1].pageIx=pe-1),ae===U.length-1&&de+he-B[pe-1]>q&&de!==Q&&(B.push(de),ne.pageIx=pe),de!==Q&&(Q=de)}),ie||(ie=a.clipRect=v.clipRect(0,P,9999,0),a.contentGroup.clip(ie)),j(q),ee||(this.nav=ee=v.g().attr({zIndex:1}).add(this.group),this.up=v.symbol("triangle",0,0,$,$).add(ee),Y("upTracker").on("click",function(){a.scroll(-1,N)}),this.pager=v.text("",15,10).addClass("highcharts-legend-navigation"),u.styledMode||this.pager.css(L.style),this.pager.add(ee),this.down=v.symbol("triangle-down",0,0,$,$).add(ee),Y("downTracker").on("click",function(){a.scroll(1,N)})),a.scroll(0),d=J):ee&&(j(),this.nav=ee.destroy(),this.scrollGroup.attr({translateY:1}),this.clipHeight=0),d},g.prototype.scroll=function(d,a){var u=this,v=this.chart,x=this.pages,S=x.length,T=this.clipHeight,P=this.options.navigation,z=this.pager,L=this.padding,N=this.currentPage+d;if(N>S&&(N=S),N>0){typeof a<"u"&&setAnimation$4(a,v),this.nav.attr({translateX:L,translateY:T+this.padding+7+this.titleHeight,visibility:"visible"}),[this.up,this.upTracker].forEach(function(B){B.attr({class:N===1?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})}),z.attr({text:N+"/"+S}),[this.down,this.downTracker].forEach(function(B){B.attr({x:18+this.pager.getBBox().width,class:N===S?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})},this),v.styledMode||(this.up.attr({fill:N===1?P.inactiveColor:P.activeColor}),this.upTracker.css({cursor:N===1?"default":"pointer"}),this.down.attr({fill:N===S?P.inactiveColor:P.activeColor}),this.downTracker.css({cursor:N===S?"default":"pointer"})),this.scrollOffset=-x[N-1]+this.initialItemY,this.scrollGroup.animate({translateY:this.scrollOffset}),this.currentPage=N,this.positionCheckboxes();var $=animObject$9(pick$1r(a,v.renderer.globalAnimation,!0));syncTimeout$4(function(){fireEvent$u(u,"afterScroll",{currentPage:N})},$.duration)}},g.prototype.setItemEvents=function(d,a,u){var v=this,x=v.chart.renderer.boxWrapper,S=d instanceof Point$4,T="highcharts-legend-"+(S?"point":"series")+"-active",P=v.chart.styledMode,z=u?[a,d.legendSymbol]:[d.legendGroup],L=function(N){v.allItems.forEach(function($){d!==$&&[$].concat($.linkedSeries||[]).forEach(function(B){B.setState(N,!S)})})};z.forEach(function(N){N&&N.on("mouseover",function(){d.visible&&L("inactive"),d.setState("hover"),d.visible&&x.addClass(T),P||a.css(v.options.itemHoverStyle)}).on("mouseout",function(){v.chart.styledMode||a.css(merge$1k(d.visible?v.itemStyle:v.itemHiddenStyle)),L(""),x.removeClass(T),d.setState()}).on("click",function($){var B="legendItemClick",U=function(){d.setVisible&&d.setVisible(),L(d.visible?"inactive":"")};x.removeClass(T),$={browserEvent:$},d.firePointEvent?d.firePointEvent(B,$,U):fireEvent$u(d,B,$,U)})})},g.prototype.createCheckboxForItem=function(d){var a=this;d.checkbox=createElement$6("input",{type:"checkbox",className:"highcharts-legend-checkbox",checked:d.selected,defaultChecked:d.selected},a.options.itemCheckboxStyle,a.chart.container),addEvent$$(d.checkbox,"click",function(u){var v=u.target;fireEvent$u(d.series||d,"checkboxClick",{checked:v.checked,item:d},function(){d.select()})})},g})();(/Trident\/7\.0/.test(win$9.navigator&&win$9.navigator.userAgent)||isFirefox$1)&&wrap$g(Legend.prototype,"positionItem",function(g,d){var a=this,u=function(){d._legendItemPos&&g.call(a,d)};u(),a.bubbleLegend||setTimeout(u)});var defaultOptions$f=DefaultOptions.defaultOptions,error$8=Utilities.error,extendClass$1=Utilities.extendClass,merge$1j=Utilities.merge,SeriesRegistry;(function(g){g.seriesTypes=H.seriesTypes;function d(v,x){x===void 0&&(x={});var S=v.options.chart,T=x.type||S.type||S.defaultSeriesType||"",P=g.seriesTypes[T];g||error$8(17,!0,v,{missingModuleFor:T});var z=new P;return typeof z.init=="function"&&z.init(v,x),z}g.getSeries=d;function a(v,x){var S=defaultOptions$f.plotOptions||{},T=x.defaultOptions;x.prototype.pointClass||(x.prototype.pointClass=Point$4),x.prototype.type=v,T&&(S[v]=T),g.seriesTypes[v]=x}g.registerSeriesType=a;function u(v,x,S,T,P){var z=defaultOptions$f.plotOptions||{};return x=x||"",z[v]=merge$1j(z[x],S),a(v,extendClass$1(g.seriesTypes[x]||function(){},T)),g.seriesTypes[v].prototype.type=v,P&&(g.seriesTypes[v].prototype.pointClass=extendClass$1(Point$4,P)),g.seriesTypes[v]}g.seriesType=u})(SeriesRegistry||(SeriesRegistry={}));const SeriesRegistry$1=SeriesRegistry;var animate=animationExports.animate,animObject$8=animationExports.animObject,setAnimation$3=animationExports.setAnimation,numberFormat$1=FormatUtilities.numberFormat,registerEventOptions$1=exports$6.registerEventOptions,charts$1=H.charts,doc$g=H.doc,marginNames=H.marginNames,svg$5=H.svg,win$8=H.win,defaultOptions$e=DefaultOptions.defaultOptions,defaultTime=DefaultOptions.defaultTime,seriesTypes$8=SeriesRegistry$1.seriesTypes,addEvent$_=Utilities.addEvent,attr$1=Utilities.attr,cleanRecursively$1=Utilities.cleanRecursively,createElement$5=Utilities.createElement,css$5=Utilities.css,defined$L=Utilities.defined,discardElement$3=Utilities.discardElement,erase$4=Utilities.erase,error$7=Utilities.error,extend$1l=Utilities.extend,find$i=Utilities.find,fireEvent$t=Utilities.fireEvent,getStyle=Utilities.getStyle,isArray$j=Utilities.isArray,isNumber$H=Utilities.isNumber,isObject$c=Utilities.isObject,isString$6=Utilities.isString,merge$1i=Utilities.merge,objectEach$p=Utilities.objectEach,pick$1q=Utilities.pick,pInt$4=Utilities.pInt,relativeLength$7=Utilities.relativeLength,removeEvent$6=Utilities.removeEvent,splat$f=Utilities.splat,syncTimeout$3=Utilities.syncTimeout,uniqueKey$4=Utilities.uniqueKey,Chart$1=(function(){function g(d,a,u){this.axes=void 0,this.axisOffset=void 0,this.bounds=void 0,this.chartHeight=void 0,this.chartWidth=void 0,this.clipBox=void 0,this.colorCounter=void 0,this.container=void 0,this.eventOptions=void 0,this.index=void 0,this.isResizing=void 0,this.labelCollectors=void 0,this.legend=void 0,this.margin=void 0,this.numberFormatter=void 0,this.options=void 0,this.plotBox=void 0,this.plotHeight=void 0,this.plotLeft=void 0,this.plotTop=void 0,this.plotWidth=void 0,this.pointCount=void 0,this.pointer=void 0,this.renderer=void 0,this.renderTo=void 0,this.series=void 0,this.sharedClips={},this.spacing=void 0,this.spacingBox=void 0,this.symbolCounter=void 0,this.time=void 0,this.titleOffset=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.getArgs(d,a,u)}return g.chart=function(d,a,u){return new g(d,a,u)},g.prototype.getArgs=function(d,a,u){isString$6(d)||d.nodeName?(this.renderTo=d,this.init(a,u)):this.init(d,a)},g.prototype.init=function(d,a){var u=d.plotOptions||{};fireEvent$t(this,"init",{args:arguments},function(){var v=merge$1i(defaultOptions$e,d),x=v.chart;objectEach$p(v.plotOptions,function(T,P){isObject$c(T)&&(T.tooltip=u[P]&&merge$1i(u[P].tooltip)||void 0)}),v.tooltip.userOptions=d.chart&&d.chart.forExport&&d.tooltip.userOptions||d.tooltip,this.userOptions=d,this.margin=[],this.spacing=[],this.bounds={h:{},v:{}},this.labelCollectors=[],this.callback=a,this.isResizing=0,this.options=v,this.axes=[],this.series=[],this.time=d.time&&Object.keys(d.time).length?new Time(d.time):H.time,this.numberFormatter=x.numberFormatter||numberFormat$1,this.styledMode=x.styledMode,this.hasCartesianSeries=x.showAxes;var S=this;S.index=charts$1.length,charts$1.push(S),H.chartCount++,registerEventOptions$1(this,x),S.xAxis=[],S.yAxis=[],S.pointCount=S.colorCounter=S.symbolCounter=0,fireEvent$t(S,"afterInit"),S.firstRender()})},g.prototype.initSeries=function(d){var a=this,u=a.options.chart,v=d.type||u.type||u.defaultSeriesType,x=seriesTypes$8[v];x||error$7(17,!0,a,{missingModuleFor:v});var S=new x;return typeof S.init=="function"&&S.init(a,d),S},g.prototype.setSeriesData=function(){this.getSeriesOrderByLinks().forEach(function(d){!d.points&&!d.data&&d.enabledDataSorting&&d.setData(d.options.data,!1)})},g.prototype.getSeriesOrderByLinks=function(){return this.series.concat().sort(function(d,a){return d.linkedSeries.length||a.linkedSeries.length?a.linkedSeries.length-d.linkedSeries.length:0})},g.prototype.orderSeries=function(d){for(var a=this.series,u=d||0,v=a.length;u<v;++u)a[u]&&(a[u].index=u,a[u].name=a[u].getName())},g.prototype.isInsidePlot=function(d,a,u){var v;u===void 0&&(u={});var x=this,S=x.inverted,T=x.plotBox,P=x.plotLeft,z=x.plotTop,L=x.scrollablePlotBox,N=0,$=0;u.visiblePlotOnly&&this.scrollingContainer&&(v=this.scrollingContainer,N=v.scrollLeft,$=v.scrollTop);var B=u.series,U=u.visiblePlotOnly&&L||T,j=u.inverted?a:d,Y=u.inverted?d:a,q={x:j,y:Y,isInsidePlot:!0};if(!u.ignoreX){var Q=B&&(S?B.yAxis:B.xAxis)||{pos:P,len:1/0},J=u.paneCoordinates?Q.pos+j:P+j;J>=Math.max(N+P,Q.pos)&&J<=Math.min(N+P+U.width,Q.pos+Q.len)||(q.isInsidePlot=!1)}if(!u.ignoreY&&q.isInsidePlot){var ee=B&&(S?B.xAxis:B.yAxis)||{pos:z,len:1/0},ie=u.paneCoordinates?ee.pos+Y:z+Y;ie>=Math.max($+z,ee.pos)&&ie<=Math.min($+z+U.height,ee.pos+ee.len)||(q.isInsidePlot=!1)}return fireEvent$t(this,"afterIsInsidePlot",q),q.isInsidePlot},g.prototype.redraw=function(d){fireEvent$t(this,"beforeRedraw");var a=this,u=a.hasCartesianSeries?a.axes:a.colorAxis||[],v=a.series,x=a.pointer,S=a.legend,T=a.userOptions.legend,P=a.renderer,z=P.isHidden(),L=[],N,$,B,U=a.isDirtyBox,j=a.isDirtyLegend,Y;for(a.setResponsive&&a.setResponsive(!1),setAnimation$3(a.hasRendered?d:!1,a),z&&a.temporaryDisplay(),a.layOutTitles(),B=v.length;B--;)if(Y=v[B],(Y.options.stacking||Y.options.centerInCategory)&&($=!0,Y.isDirty)){N=!0;break}if(N)for(B=v.length;B--;)Y=v[B],Y.options.stacking&&(Y.isDirty=!0);v.forEach(function(q){q.isDirty&&(q.options.legendType==="point"?(typeof q.updateTotals=="function"&&q.updateTotals(),j=!0):T&&(T.labelFormatter||T.labelFormat)&&(j=!0)),q.isDirtyData&&fireEvent$t(q,"updatedData")}),j&&S&&S.options.enabled&&(S.render(),a.isDirtyLegend=!1),$&&a.getStacks(),u.forEach(function(q){q.updateNames(),q.setScale()}),a.getMargins(),u.forEach(function(q){q.isDirty&&(U=!0)}),u.forEach(function(q){var Q=q.min+","+q.max;q.extKey!==Q&&(q.extKey=Q,L.push(function(){fireEvent$t(q,"afterSetExtremes",extend$1l(q.eventArgs,q.getExtremes())),delete q.eventArgs})),(U||$)&&q.redraw()}),U&&a.drawChartBox(),fireEvent$t(a,"predraw"),v.forEach(function(q){(U||q.isDirty)&&q.visible&&q.redraw(),q.isDirtyData=!1}),x&&x.reset(!0),P.draw(),fireEvent$t(a,"redraw"),fireEvent$t(a,"render"),z&&a.temporaryDisplay(!0),L.forEach(function(q){q.call()})},g.prototype.get=function(d){var a=this.series;function u(S){return S.id===d||S.options&&S.options.id===d}for(var v=find$i(this.axes,u)||find$i(this.series,u),x=0;!v&&x<a.length;x++)v=find$i(a[x].points||[],u);return v},g.prototype.getAxes=function(){var d=this,a=this.options,u=a.xAxis=splat$f(a.xAxis||{}),v=a.yAxis=splat$f(a.yAxis||{});fireEvent$t(this,"getAxes"),u.forEach(function(S,T){S.index=T,S.isX=!0}),v.forEach(function(S,T){S.index=T});var x=u.concat(v);x.forEach(function(S){new Axis(d,S)}),fireEvent$t(this,"afterGetAxes")},g.prototype.getSelectedPoints=function(){return this.series.reduce(function(d,a){return a.getPointsCollection().forEach(function(u){pick$1q(u.selectedStaging,u.selected)&&d.push(u)}),d},[])},g.prototype.getSelectedSeries=function(){return this.series.filter(function(d){return d.selected})},g.prototype.setTitle=function(d,a,u){this.applyDescription("title",d),this.applyDescription("subtitle",a),this.applyDescription("caption",void 0),this.layOutTitles(u)},g.prototype.applyDescription=function(d,a){var u=this,v=d==="title"?{color:palette.neutralColor80,fontSize:this.options.isStock?"16px":"18px"}:{color:palette.neutralColor60},x=this.options[d]=merge$1i(!this.styledMode&&{style:v},this.options[d],a),S=this[d];S&&a&&(this[d]=S=S.destroy()),x&&!S&&(S=this.renderer.text(x.text,0,0,x.useHTML).attr({align:x.align,class:"highcharts-"+d,zIndex:x.zIndex||4}).add(),S.update=function(T){var P={title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"}[d];u[P](T)},this.styledMode||S.css(x.style),this[d]=S)},g.prototype.layOutTitles=function(d){var a=[0,0,0],u=this.renderer,v=this.spacingBox;["title","subtitle","caption"].forEach(function(S){var T=this[S],P=this.options[S],z=P.verticalAlign||"top",L=S==="title"?z==="top"?-3:0:z==="top"?a[0]+2:0,N,$;T&&(this.styledMode||(N=P.style&&P.style.fontSize),N=u.fontMetrics(N,T).b,T.css({width:(P.width||v.width+(P.widthAdjust||0))+"px"}),$=Math.round(T.getBBox(P.useHTML).height),T.align(extend$1l({y:z==="bottom"?N:L+N,height:$},P),!1,"spacingBox"),P.floating||(z==="top"?a[0]=Math.ceil(a[0]+$):z==="bottom"&&(a[2]=Math.ceil(a[2]+$))))},this),a[0]&&(this.options.title.verticalAlign||"top")==="top"&&(a[0]+=this.options.title.margin),a[2]&&this.options.caption.verticalAlign==="bottom"&&(a[2]+=this.options.caption.margin);var x=!this.titleOffset||this.titleOffset.join(",")!==a.join(",");this.titleOffset=a,fireEvent$t(this,"afterLayOutTitles"),!this.isDirtyBox&&x&&(this.isDirtyBox=this.isDirtyLegend=x,this.hasRendered&&pick$1q(d,!0)&&this.isDirtyBox&&this.redraw())},g.prototype.getChartSize=function(){var d=this,a=d.options.chart,u=a.width,v=a.height,x=d.renderTo;defined$L(u)||(d.containerWidth=getStyle(x,"width")),defined$L(v)||(d.containerHeight=getStyle(x,"height")),d.chartWidth=Math.max(0,u||d.containerWidth||600),d.chartHeight=Math.max(0,relativeLength$7(v,d.chartWidth)||(d.containerHeight>1?d.containerHeight:400))},g.prototype.temporaryDisplay=function(d){var a=this.renderTo,u;if(d)for(;a&&a.style;)a.hcOrigStyle&&(css$5(a,a.hcOrigStyle),delete a.hcOrigStyle),a.hcOrigDetached&&(doc$g.body.removeChild(a),a.hcOrigDetached=!1),a=a.parentNode;else for(;a&&a.style&&(!doc$g.body.contains(a)&&!a.parentNode&&(a.hcOrigDetached=!0,doc$g.body.appendChild(a)),(getStyle(a,"display",!1)==="none"||a.hcOricDetached)&&(a.hcOrigStyle={display:a.style.display,height:a.style.height,overflow:a.style.overflow},u={display:"block",overflow:"hidden"},a!==this.renderTo&&(u.height=0),css$5(a,u),a.offsetWidth||a.style.setProperty("display","block","important")),a=a.parentNode,a!==doc$g.body););},g.prototype.setClassName=function(d){this.container.className="highcharts-container "+(d||"")},g.prototype.getContainer=function(){var d=this,a=d.options,u=a.chart,v="data-highcharts-chart",x=uniqueKey$4(),S,T=d.renderTo;T||(d.renderTo=T=u.renderTo),isString$6(T)&&(d.renderTo=T=doc$g.getElementById(T)),T||error$7(13,!0,d);var P=pInt$4(attr$1(T,v));isNumber$H(P)&&charts$1[P]&&charts$1[P].hasRendered&&charts$1[P].destroy(),attr$1(T,v,d.index),T.innerHTML="",!u.skipClone&&!T.offsetWidth&&d.temporaryDisplay(),d.getChartSize();var z=d.chartWidth,L=d.chartHeight;css$5(T,{overflow:"hidden"}),d.styledMode||(S=extend$1l({position:"relative",overflow:"hidden",width:z+"px",height:L+"px",textAlign:"left",lineHeight:"normal",zIndex:0,"-webkit-tap-highlight-color":"rgba(0,0,0,0)",userSelect:"none","touch-action":"manipulation",outline:"none"},u.style||{}));var N=createElement$5("div",{id:x},S,T);d.container=N,d._cursor=N.style.cursor;var $=u.renderer||!svg$5?RendererRegistry$1.getRendererType(u.renderer):SVGRenderer;if(d.renderer=new $(N,z,L,void 0,u.forExport,a.exporting&&a.exporting.allowHTML,d.styledMode),setAnimation$3(void 0,d),d.setClassName(u.className),!d.styledMode)d.renderer.setStyle(u.style);else for(var B in a.defs)this.renderer.definition(a.defs[B]);d.renderer.chartIndex=d.index,fireEvent$t(this,"afterGetContainer")},g.prototype.getMargins=function(d){var a=this,u=a.spacing,v=a.margin,x=a.titleOffset;this.resetMargins(),x[0]&&!defined$L(v[0])&&(this.plotTop=Math.max(this.plotTop,x[0]+u[0])),x[2]&&!defined$L(v[2])&&(this.marginBottom=Math.max(this.marginBottom,x[2]+u[2])),this.legend&&this.legend.display&&this.legend.adjustMargins(v,u),fireEvent$t(this,"getMargins"),d||this.getAxisMargins()},g.prototype.getAxisMargins=function(){var d=this,a=d.axisOffset=[0,0,0,0],u=d.colorAxis,v=d.margin,x=function(S){S.forEach(function(T){T.visible&&T.getOffset()})};d.hasCartesianSeries?x(d.axes):u&&u.length&&x(u),marginNames.forEach(function(S,T){defined$L(v[T])||(d[S]+=a[T])}),d.setChartSize()},g.prototype.reflow=function(d){var a=this,u=a.options.chart,v=a.renderTo,x=defined$L(u.width)&&defined$L(u.height),S=u.width||getStyle(v,"width"),T=u.height||getStyle(v,"height"),P=d?d.target:win$8;delete a.pointer.chartPosition,!x&&!a.isPrinting&&S&&T&&(P===win$8||P===doc$g)&&((S!==a.containerWidth||T!==a.containerHeight)&&(Utilities.clearTimeout(a.reflowTimeout),a.reflowTimeout=syncTimeout$3(function(){a.container&&a.setSize(void 0,void 0,!1)},d?100:0)),a.containerWidth=S,a.containerHeight=T)},g.prototype.setReflow=function(d){var a=this;d!==!1&&!this.unbindReflow?(this.unbindReflow=addEvent$_(win$8,"resize",function(u){a.options&&a.reflow(u)}),addEvent$_(this,"destroy",this.unbindReflow)):d===!1&&this.unbindReflow&&(this.unbindReflow=this.unbindReflow())},g.prototype.setSize=function(d,a,u){var v=this,x=v.renderer;v.isResizing+=1,setAnimation$3(u,v);var S=x.globalAnimation;v.oldChartHeight=v.chartHeight,v.oldChartWidth=v.chartWidth,typeof d<"u"&&(v.options.chart.width=d),typeof a<"u"&&(v.options.chart.height=a),v.getChartSize(),v.styledMode||(S?animate:css$5)(v.container,{width:v.chartWidth+"px",height:v.chartHeight+"px"},S),v.setChartSize(!0),x.setSize(v.chartWidth,v.chartHeight,S),v.axes.forEach(function(T){T.isDirty=!0,T.setScale()}),v.isDirtyLegend=!0,v.isDirtyBox=!0,v.layOutTitles(),v.getMargins(),v.redraw(S),v.oldChartHeight=null,fireEvent$t(v,"resize"),syncTimeout$3(function(){v&&fireEvent$t(v,"endResize",null,function(){v.isResizing-=1})},animObject$8(S).duration)},g.prototype.setChartSize=function(d){var a=this,u=a.inverted,v=a.renderer,x=a.chartWidth,S=a.chartHeight,T=a.options.chart,P=a.spacing,z=a.clipOffset,L,N,$,B;a.plotLeft=L=Math.round(a.plotLeft),a.plotTop=N=Math.round(a.plotTop),a.plotWidth=$=Math.max(0,Math.round(x-L-a.marginRight)),a.plotHeight=B=Math.max(0,Math.round(S-N-a.marginBottom)),a.plotSizeX=u?B:$,a.plotSizeY=u?$:B,a.plotBorderWidth=T.plotBorderWidth||0,a.spacingBox=v.spacingBox={x:P[3],y:P[0],width:x-P[3]-P[1],height:S-P[0]-P[2]},a.plotBox=v.plotBox={x:L,y:N,width:$,height:B};var U=2*Math.floor(a.plotBorderWidth/2),j=Math.ceil(Math.max(U,z[3])/2),Y=Math.ceil(Math.max(U,z[0])/2);a.clipBox={x:j,y:Y,width:Math.floor(a.plotSizeX-Math.max(U,z[1])/2-j),height:Math.max(0,Math.floor(a.plotSizeY-Math.max(U,z[2])/2-Y))},d||(a.axes.forEach(function(q){q.setAxisSize(),q.setAxisTranslation()}),v.alignElements()),fireEvent$t(a,"afterSetChartSize",{skipAxes:d})},g.prototype.resetMargins=function(){fireEvent$t(this,"resetMargins");var d=this,a=d.options.chart;["margin","spacing"].forEach(function(v){var x=a[v],S=isObject$c(x)?x:[x,x,x,x];["Top","Right","Bottom","Left"].forEach(function(T,P){d[v][P]=pick$1q(a[v+T],S[P])})}),marginNames.forEach(function(u,v){d[u]=pick$1q(d.margin[v],d.spacing[v])}),d.axisOffset=[0,0,0,0],d.clipOffset=[0,0,0,0]},g.prototype.drawChartBox=function(){var d=this,a=d.options.chart,u=d.renderer,v=d.chartWidth,x=d.chartHeight,S=d.styledMode,T=d.plotBGImage,P=a.backgroundColor,z=a.plotBackgroundColor,L=a.plotBackgroundImage,N=d.plotLeft,$=d.plotTop,B=d.plotWidth,U=d.plotHeight,j=d.plotBox,Y=d.clipRect,q=d.clipBox,Q=d.chartBackground,J=d.plotBackground,ee=d.plotBorder,ie,ne,ae,de="animate";Q||(d.chartBackground=Q=u.rect().addClass("highcharts-background").add(),de="attr"),S?ie=ne=Q.strokeWidth():(ie=a.borderWidth||0,ne=ie+(a.shadow?8:0),ae={fill:P||"none"},(ie||Q["stroke-width"])&&(ae.stroke=a.borderColor,ae["stroke-width"]=ie),Q.attr(ae).shadow(a.shadow)),Q[de]({x:ne/2,y:ne/2,width:v-ne-ie%2,height:x-ne-ie%2,r:a.borderRadius}),de="animate",J||(de="attr",d.plotBackground=J=u.rect().addClass("highcharts-plot-background").add()),J[de](j),S||(J.attr({fill:z||"none"}).shadow(a.plotShadow),L&&(T?(L!==T.attr("href")&&T.attr("href",L),T.animate(j)):d.plotBGImage=u.image(L,N,$,B,U).add())),Y?Y.animate({width:q.width,height:q.height}):d.clipRect=u.clipRect(q),de="animate",ee||(de="attr",d.plotBorder=ee=u.rect().addClass("highcharts-plot-border").attr({zIndex:1}).add()),S||ee.attr({stroke:a.plotBorderColor,"stroke-width":a.plotBorderWidth||0,fill:"none"}),ee[de](ee.crisp({x:N,y:$,width:B,height:U},-ee.strokeWidth())),d.isDirtyBox=!1,fireEvent$t(this,"afterDrawChartBox")},g.prototype.propFromSeries=function(){var d=this,a=d.options.chart,u=d.options.series,v,x,S;["inverted","angular","polar"].forEach(function(T){for(x=seriesTypes$8[a.type||a.defaultSeriesType],S=a[T]||x&&x.prototype[T],v=u&&u.length;!S&&v--;)x=seriesTypes$8[u[v].type],x&&x.prototype[T]&&(S=!0);d[T]=S})},g.prototype.linkSeries=function(){var d=this,a=d.series;a.forEach(function(u){u.linkedSeries.length=0}),a.forEach(function(u){var v=u.options.linkedTo;isString$6(v)&&(v===":previous"?v=d.series[u.index-1]:v=d.get(v),v&&v.linkedParent!==u&&(v.linkedSeries.push(u),u.linkedParent=v,v.enabledDataSorting&&u.setDataSortingOptions(),u.visible=pick$1q(u.options.visible,v.options.visible,u.visible)))}),fireEvent$t(this,"afterLinkSeries")},g.prototype.renderSeries=function(){this.series.forEach(function(d){d.translate(),d.render()})},g.prototype.renderLabels=function(){var d=this,a=d.options.labels;a.items&&a.items.forEach(function(u){var v=extend$1l(a.style,u.style),x=pInt$4(v.left)+d.plotLeft,S=pInt$4(v.top)+d.plotTop+12;delete v.left,delete v.top,d.renderer.text(u.html,x,S).attr({zIndex:2}).css(v).add()})},g.prototype.render=function(){var d=this,a=d.axes,u=d.colorAxis,v=d.renderer,x=d.options,S=function($){$.forEach(function(B){B.visible&&B.render()})},T=0;d.setTitle(),d.legend=new Legend(d,x.legend),d.getStacks&&d.getStacks(),d.getMargins(!0),d.setChartSize();var P=d.plotWidth;a.some(function($){if($.horiz&&$.visible&&$.options.labels.enabled&&$.series.length)return T=21,!0}),d.plotHeight=Math.max(d.plotHeight-T,0);var z=d.plotHeight;a.forEach(function($){$.setScale()}),d.getAxisMargins();var L=P/d.plotWidth>1.1,N=z/d.plotHeight>1.05;(L||N)&&(a.forEach(function($){($.horiz&&L||!$.horiz&&N)&&$.setTickInterval(!0)}),d.getMargins()),d.drawChartBox(),d.hasCartesianSeries?S(a):u&&u.length&&S(u),d.seriesGroup||(d.seriesGroup=v.g("series-group").attr({zIndex:3}).add()),d.renderSeries(),d.renderLabels(),d.addCredits(),d.setResponsive&&d.setResponsive(),d.hasRendered=!0},g.prototype.addCredits=function(d){var a=this,u=merge$1i(!0,this.options.credits,d);u.enabled&&!this.credits&&(this.credits=this.renderer.text(u.text+(this.mapCredits||""),0,0).addClass("highcharts-credits").on("click",function(){u.href&&(win$8.location.href=u.href)}).attr({align:u.position.align,zIndex:8}),a.styledMode||this.credits.css(u.style),this.credits.add().align(u.position),this.credits.update=function(v){a.credits=a.credits.destroy(),a.addCredits(v)})},g.prototype.destroy=function(){var d=this,a=d.axes,u=d.series,v=d.container,x=v&&v.parentNode,S;for(fireEvent$t(d,"destroy"),d.renderer.forExport?erase$4(charts$1,d):charts$1[d.index]=void 0,H.chartCount--,d.renderTo.removeAttribute("data-highcharts-chart"),removeEvent$6(d),S=a.length;S--;)a[S]=a[S].destroy();for(this.scroller&&this.scroller.destroy&&this.scroller.destroy(),S=u.length;S--;)u[S]=u[S].destroy();["title","subtitle","chartBackground","plotBackground","plotBGImage","plotBorder","seriesGroup","clipRect","credits","pointer","rangeSelector","legend","resetZoomButton","tooltip","renderer"].forEach(function(T){var P=d[T];P&&P.destroy&&(d[T]=P.destroy())}),v&&(v.innerHTML="",removeEvent$6(v),x&&discardElement$3(v)),objectEach$p(d,function(T,P){delete d[P]})},g.prototype.firstRender=function(){var d=this,a=d.options;d.isReadyToRender&&!d.isReadyToRender()||(d.getContainer(),d.resetMargins(),d.setChartSize(),d.propFromSeries(),d.getAxes(),(isArray$j(a.series)?a.series:[]).forEach(function(u){d.initSeries(u)}),d.linkSeries(),d.setSeriesData(),fireEvent$t(d,"beforeRender"),Pointer&&(MSPointer.isRequired()?d.pointer=new MSPointer(d,a):d.pointer=new Pointer(d,a)),d.render(),d.pointer.getChartPosition(),!d.renderer.imgCount&&!d.hasLoaded&&d.onload(),d.temporaryDisplay(!0))},g.prototype.onload=function(){this.callbacks.concat([this.callback]).forEach(function(d){d&&typeof this.index<"u"&&d.apply(this,[this])},this),fireEvent$t(this,"load"),fireEvent$t(this,"render"),defined$L(this.index)&&this.setReflow(this.options.chart.reflow),this.hasLoaded=!0},g.prototype.addSeries=function(d,a,u){var v=this,x;return d&&(a=pick$1q(a,!0),fireEvent$t(v,"addSeries",{options:d},function(){x=v.initSeries(d),v.isDirtyLegend=!0,v.linkSeries(),x.enabledDataSorting&&x.setData(d.data,!1),fireEvent$t(v,"afterAddSeries",{series:x}),a&&v.redraw(u)})),x},g.prototype.addAxis=function(d,a,u,v){return this.createAxis(a?"xAxis":"yAxis",{axis:d,redraw:u,animation:v})},g.prototype.addColorAxis=function(d,a,u){return this.createAxis("colorAxis",{axis:d,redraw:a,animation:u})},g.prototype.createAxis=function(d,a){var u=new Axis(this,merge$1i(a.axis,{index:this[d].length,isX:d==="xAxis"}));return pick$1q(a.redraw,!0)&&this.redraw(a.animation),u},g.prototype.showLoading=function(d){var a=this,u=a.options,v=u.loading,x=function(){S&&css$5(S,{left:a.plotLeft+"px",top:a.plotTop+"px",width:a.plotWidth+"px",height:a.plotHeight+"px"})},S=a.loadingDiv,T=a.loadingSpan;S||(a.loadingDiv=S=createElement$5("div",{className:"highcharts-loading highcharts-loading-hidden"},null,a.container)),T||(a.loadingSpan=T=createElement$5("span",{className:"highcharts-loading-inner"},null,S),addEvent$_(a,"redraw",x)),S.className="highcharts-loading",AST.setElementHTML(T,pick$1q(d,u.lang.loading,"")),a.styledMode||(css$5(S,extend$1l(v.style,{zIndex:10})),css$5(T,v.labelStyle),a.loadingShown||(css$5(S,{opacity:0,display:""}),animate(S,{opacity:v.style.opacity||.5},{duration:v.showDuration||0}))),a.loadingShown=!0,x()},g.prototype.hideLoading=function(){var d=this.options,a=this.loadingDiv;a&&(a.className="highcharts-loading highcharts-loading-hidden",this.styledMode||animate(a,{opacity:0},{duration:d.loading.hideDuration||100,complete:function(){css$5(a,{display:"none"})}})),this.loadingShown=!1},g.prototype.update=function(d,a,u,v){var x=this,S={credits:"addCredits",title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"},T=d.isResponsiveOptions,P=[],z,L,N;fireEvent$t(x,"update",{options:d}),T||x.setResponsive(!1,!0),d=cleanRecursively$1(d,x.options),x.userOptions=merge$1i(x.userOptions,d);var $=d.chart;$&&(merge$1i(!0,x.options.chart,$),"className"in $&&x.setClassName($.className),"reflow"in $&&x.setReflow($.reflow),("inverted"in $||"polar"in $||"type"in $)&&(x.propFromSeries(),z=!0),"alignTicks"in $&&(z=!0),"events"in $&&registerEventOptions$1(this,$),objectEach$p($,function(j,Y){x.propsRequireUpdateSeries.indexOf("chart."+Y)!==-1&&(L=!0),x.propsRequireDirtyBox.indexOf(Y)!==-1&&(x.isDirtyBox=!0),x.propsRequireReflow.indexOf(Y)!==-1&&(T?x.isDirtyBox=!0:N=!0)}),!x.styledMode&&$.style&&x.renderer.setStyle(x.options.chart.style||{})),!x.styledMode&&d.colors&&(this.options.colors=d.colors),d.time&&(this.time===defaultTime&&(this.time=new Time(d.time)),merge$1i(!0,x.options.time,d.time)),objectEach$p(d,function(j,Y){x[Y]&&typeof x[Y].update=="function"?x[Y].update(j,!1):typeof x[S[Y]]=="function"?x[S[Y]](j):Y!=="colors"&&x.collectionsWithUpdate.indexOf(Y)===-1&&merge$1i(!0,x.options[Y],d[Y]),Y!=="chart"&&x.propsRequireUpdateSeries.indexOf(Y)!==-1&&(L=!0)}),this.collectionsWithUpdate.forEach(function(j){var Y;d[j]&&(Y=[],x[j].forEach(function(q,Q){q.options.isInternal||Y.push(pick$1q(q.options.index,Q))}),splat$f(d[j]).forEach(function(q,Q){var J=defined$L(q.id),ee;J&&(ee=x.get(q.id)),!ee&&x[j]&&(ee=x[j][Y?Y[Q]:Q],ee&&J&&defined$L(ee.options.id)&&(ee=void 0)),ee&&ee.coll===j&&(ee.update(q,!1),u&&(ee.touched=!0)),!ee&&u&&x.collectionsWithInit[j]&&(x.collectionsWithInit[j][0].apply(x,[q].concat(x.collectionsWithInit[j][1]||[]).concat([!1])).touched=!0)}),u&&x[j].forEach(function(q){!q.touched&&!q.options.isInternal?P.push(q):delete q.touched}))}),P.forEach(function(j){j.chart&&j.remove&&j.remove(!1)}),z&&x.axes.forEach(function(j){j.update({},!1)}),L&&x.getSeriesOrderByLinks().forEach(function(j){j.chart&&j.update({},!1)},this);var B=$&&$.width,U=$&&(isString$6($.height)?relativeLength$7($.height,B||x.chartWidth):$.height);N||isNumber$H(B)&&B!==x.chartWidth||isNumber$H(U)&&U!==x.chartHeight?x.setSize(B,U,v):pick$1q(a,!0)&&x.redraw(v),fireEvent$t(x,"afterUpdate",{options:d,redraw:a,animation:v})},g.prototype.setSubtitle=function(d,a){this.applyDescription("subtitle",d),this.layOutTitles(a)},g.prototype.setCaption=function(d,a){this.applyDescription("caption",d),this.layOutTitles(a)},g.prototype.showResetZoom=function(){var d=this,a=defaultOptions$e.lang,u=d.options.chart.resetZoomButton,v=u.theme,x=v.states,S=u.relativeTo==="chart"||u.relativeTo==="spacingBox"?null:"scrollablePlotBox";function T(){d.zoomOut()}fireEvent$t(this,"beforeShowResetZoom",null,function(){d.resetZoomButton=d.renderer.button(a.resetZoom,null,null,T,v,x&&x.hover).attr({align:u.position.align,title:a.resetZoomTitle}).addClass("highcharts-reset-zoom").add().align(u.position,!1,S)}),fireEvent$t(this,"afterShowResetZoom")},g.prototype.zoomOut=function(){fireEvent$t(this,"selection",{resetSelection:!0},this.zoom)},g.prototype.zoom=function(d){var a=this,u=a.pointer,v=a.inverted?u.mouseDownX:u.mouseDownY,x=!1,S;!d||d.resetSelection?(a.axes.forEach(function(P){S=P.zoom()}),u.initiated=!1):d.xAxis.concat(d.yAxis).forEach(function(P){var z=P.axis,L=a.inverted?z.left:z.top,N=a.inverted?L+z.width:L+z.height,$=z.isXAxis,B=!1;(!$&&v>=L&&v<=N||$||!defined$L(v))&&(B=!0),u[$?"zoomX":"zoomY"]&&B&&(S=z.zoom(P.min,P.max),z.displayBtn&&(x=!0))});var T=a.resetZoomButton;x&&!T?a.showResetZoom():!x&&isObject$c(T)&&(a.resetZoomButton=T.destroy()),S&&a.redraw(pick$1q(a.options.chart.animation,d&&d.animation,a.pointCount<100))},g.prototype.pan=function(d,a){var u=this,v=u.hoverPoints,x=typeof a=="object"?a:{enabled:a,type:"x"},S=u.options.chart,T=u.options.mapNavigation&&u.options.mapNavigation.enabled;S&&S.panning&&(S.panning=x);var P=x.type,z;fireEvent$t(this,"pan",{originalEvent:d},function(){v&&v.forEach(function($){$.setState()});var L=u.xAxis;P==="xy"?L=L.concat(u.yAxis):P==="y"&&(L=u.yAxis);var N={};L.forEach(function($){if(!(!$.options.panningEnabled||$.options.isInternal)){var B=$.horiz,U=d[B?"chartX":"chartY"],j=B?"mouseDownX":"mouseDownY",Y=u[j],q=$.minPointOffset||0,Q=$.reversed&&!u.inverted||!$.reversed&&u.inverted?-1:1,J=$.getExtremes(),ee=$.toValue(Y-U,!0)+q*Q,ie=$.toValue(Y+$.len-U,!0)-(q*Q||$.isXAxis&&$.pointRangePadding||0),ne=ie<ee,ae=$.hasVerticalPanning(),de=ne?ie:ee,he=ne?ee:ie,pe=$.panningState,ve;ae&&!$.isXAxis&&(!pe||pe.isDirty)&&$.series.forEach(function(_e){var me=_e.getProcessedData(!0),xe=_e.getExtremes(me.yData,!0);pe||(pe={startMin:Number.MAX_VALUE,startMax:-Number.MAX_VALUE}),isNumber$H(xe.dataMin)&&isNumber$H(xe.dataMax)&&(pe.startMin=Math.min(pick$1q(_e.options.threshold,1/0),xe.dataMin,pe.startMin),pe.startMax=Math.max(pick$1q(_e.options.threshold,-1/0),xe.dataMax,pe.startMax))});var be=Math.min(pick$1q(pe&&pe.startMin,J.dataMin),q?J.min:$.toValue($.toPixels(J.min)-$.minPixelPadding)),ge=Math.max(pick$1q(pe&&pe.startMax,J.dataMax),q?J.max:$.toValue($.toPixels(J.max)+$.minPixelPadding));$.panningState=pe,$.isOrdinal||(ve=be-de,ve>0&&(he+=ve,de=be),ve=he-ge,ve>0&&(he=ge,de-=ve),$.series.length&&de!==J.min&&he!==J.max&&de>=be&&he<=ge&&($.setExtremes(de,he,!1,!1,{trigger:"pan"}),!u.resetZoomButton&&!T&&de!==be&&he!==ge&&P.match("y")&&(u.showResetZoom(),$.displayBtn=!1),z=!0),N[j]=U)}}),objectEach$p(N,function($,B){u[B]=$}),z&&u.redraw(!1),css$5(u.container,{cursor:"move"})})},g})();extend$1l(Chart$1.prototype,{callbacks:[],collectionsWithInit:{xAxis:[Chart$1.prototype.addAxis,[!0]],yAxis:[Chart$1.prototype.addAxis,[!1]],series:[Chart$1.prototype.addSeries]},collectionsWithUpdate:["xAxis","yAxis","series"],propsRequireDirtyBox:["backgroundColor","borderColor","borderWidth","borderRadius","plotBackgroundColor","plotBackgroundImage","plotBorderColor","plotBorderWidth","plotShadow","shadow"],propsRequireReflow:["margin","marginTop","marginRight","marginBottom","marginLeft","spacing","spacingTop","spacingRight","spacingBottom","spacingLeft"],propsRequireUpdateSeries:["chart.inverted","chart.polar","chart.ignoreHiddenSeries","chart.type","colors","plotOptions","time","tooltip"]});var merge$1h=Utilities.merge,pick$1p=Utilities.pick,LegendSymbol;(function(g){function d(u){var v=this.options,x=u.symbolWidth,S=u.symbolHeight,T=S/2,P=this.chart.renderer,z=this.legendGroup,L=u.baseline-Math.round(u.fontMetrics.b*.3),N={},$,B=v.marker;if(this.chart.styledMode||(N={"stroke-width":v.lineWidth||0},v.dashStyle&&(N.dashstyle=v.dashStyle)),this.legendLine=P.path([["M",0,L],["L",x,L]]).addClass("highcharts-graph").attr(N).add(z),B&&B.enabled!==!1&&x){var U=Math.min(pick$1p(B.radius,T),T);this.symbol.indexOf("url")===0&&(B=merge$1h(B,{width:S,height:S}),U=0),this.legendSymbol=$=P.symbol(this.symbol,x/2-U,L-U,2*U,2*U,B).addClass("highcharts-point").add(z),$.isMarker=!0}}g.drawLineMarker=d;function a(u,v){var x=u.options,S=u.symbolHeight,T=x.squareSymbol,P=T?S:u.symbolWidth;v.legendSymbol=this.chart.renderer.rect(T?(u.symbolWidth-S)/2:0,u.baseline-S+1,P,S,pick$1p(u.options.symbolRadius,S/2)).addClass("highcharts-point").attr({zIndex:3}).add(v.legendGroup)}g.drawRectangle=a})(LegendSymbol||(LegendSymbol={}));const LegendSymbol$1=LegendSymbol;var seriesDefaults={lineWidth:2,allowPointSelect:!1,crisp:!0,showCheckbox:!1,animation:{duration:1e3},events:{},marker:{enabledThreshold:2,lineColor:palette.backgroundColor,lineWidth:0,radius:4,states:{normal:{animation:!0},hover:{animation:{duration:50},enabled:!0,radiusPlus:2,lineWidthPlus:1},select:{fillColor:palette.neutralColor20,lineColor:palette.neutralColor100,lineWidth:2}}},point:{events:{}},dataLabels:{animation:{},align:"center",defer:!0,formatter:function(){var g=this.series.chart.numberFormatter;return typeof this.y!="number"?"":g(this.y,-1)},padding:5,style:{fontSize:"11px",fontWeight:"bold",color:"contrast",textOutline:"1px contrast"},verticalAlign:"bottom",x:0,y:0},cropThreshold:300,opacity:1,pointRange:0,softThreshold:!0,states:{normal:{animation:!0},hover:{animation:{duration:50},lineWidthPlus:1,marker:{},halo:{size:10,opacity:.25}},select:{animation:{duration:0}},inactive:{animation:{duration:50},opacity:.2}},stickyTracking:!0,turboThreshold:1e3,findNearestPointBy:"x"},animObject$7=animationExports.animObject,setAnimation$2=animationExports.setAnimation,defaultOptions$d=DefaultOptions.defaultOptions,registerEventOptions=exports$6.registerEventOptions,hasTouch$2=H.hasTouch,svg$4=H.svg,win$7=H.win,seriesTypes$7=SeriesRegistry$1.seriesTypes,addEvent$Z=Utilities.addEvent,arrayMax$7=Utilities.arrayMax,arrayMin$6=Utilities.arrayMin,clamp$g=Utilities.clamp,cleanRecursively=Utilities.cleanRecursively,correctFloat$a=Utilities.correctFloat,defined$K=Utilities.defined,erase$3=Utilities.erase,error$6=Utilities.error,extend$1k=Utilities.extend,find$h=Utilities.find,fireEvent$s=Utilities.fireEvent,getNestedProperty=Utilities.getNestedProperty,isArray$i=Utilities.isArray,isNumber$G=Utilities.isNumber,isString$5=Utilities.isString,merge$1g=Utilities.merge,objectEach$o=Utilities.objectEach,pick$1o=Utilities.pick,removeEvent$5=Utilities.removeEvent,splat$e=Utilities.splat,syncTimeout$2=Utilities.syncTimeout,Series$f=(function(){function g(){this._i=void 0,this.chart=void 0,this.data=void 0,this.eventOptions=void 0,this.eventsToUnbind=void 0,this.index=void 0,this.linkedSeries=void 0,this.options=void 0,this.points=void 0,this.processedXData=void 0,this.processedYData=void 0,this.tooltipOptions=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zones=void 0}return g.prototype.init=function(d,a){fireEvent$s(this,"init",{options:a});var u=this,v=d.series;this.eventsToUnbind=[],u.chart=d,u.options=u.setOptions(a);var x=u.options;u.linkedSeries=[],u.bindAxes(),extend$1k(u,{name:x.name,state:"",visible:x.visible!==!1,selected:x.selected===!0}),registerEventOptions(this,x);var S=x.events;(S&&S.click||x.point&&x.point.events&&x.point.events.click||x.allowPointSelect)&&(d.runTrackerClick=!0),u.getColor(),u.getSymbol(),u.parallelArrays.forEach(function(P){u[P+"Data"]||(u[P+"Data"]=[])}),u.isCartesian&&(d.hasCartesianSeries=!0);var T;v.length&&(T=v[v.length-1]),u._i=pick$1o(T&&T._i,-1)+1,u.opacity=u.options.opacity,d.orderSeries(this.insert(v)),x.dataSorting&&x.dataSorting.enabled?u.setDataSortingOptions():!u.points&&!u.data&&u.setData(x.data,!1),fireEvent$s(this,"afterInit")},g.prototype.is=function(d){return seriesTypes$7[d]&&this instanceof seriesTypes$7[d]},g.prototype.insert=function(d){var a=this.options.index,u;if(isNumber$G(a)){for(u=d.length;u--;)if(a>=pick$1o(d[u].options.index,d[u]._i)){d.splice(u+1,0,this);break}u===-1&&d.unshift(this),u=u+1}else d.push(this);return pick$1o(u,d.length-1)},g.prototype.bindAxes=function(){var d=this,a=d.options,u=d.chart,v;fireEvent$s(this,"bindAxes",null,function(){(d.axisTypes||[]).forEach(function(x){var S=0;u[x].forEach(function(T){v=T.options,(a[x]===S&&!v.isInternal||typeof a[x]<"u"&&a[x]===v.id||typeof a[x]>"u"&&v.index===0)&&(d.insert(T.series),d[x]=T,T.isDirty=!0),v.isInternal||S++}),!d[x]&&d.optionalAxis!==x&&error$6(18,!0,u)})}),fireEvent$s(this,"afterBindAxes")},g.prototype.updateParallelArrays=function(d,a){var u=d.series,v=arguments,x=isNumber$G(a)?function(S){var T=S==="y"&&u.toYData?u.toYData(d):d[S];u[S+"Data"][a]=T}:function(S){Array.prototype[a].apply(u[S+"Data"],Array.prototype.slice.call(v,2))};u.parallelArrays.forEach(x)},g.prototype.hasData=function(){return this.visible&&typeof this.dataMax<"u"&&typeof this.dataMin<"u"||this.visible&&this.yData&&this.yData.length>0},g.prototype.autoIncrement=function(d){var a=this.options,u=a.pointIntervalUnit,v=a.relativeXValue,x=this.chart.time,S=this.xIncrement,T,P;return S=pick$1o(S,a.pointStart,0),this.pointInterval=P=pick$1o(this.pointInterval,a.pointInterval,1),v&&isNumber$G(d)&&(P*=d),u&&(T=new x.Date(S),u==="day"?x.set("Date",T,x.get("Date",T)+P):u==="month"?x.set("Month",T,x.get("Month",T)+P):u==="year"&&x.set("FullYear",T,x.get("FullYear",T)+P),P=T.getTime()-S),v&&isNumber$G(d)?S+P:(this.xIncrement=S+P,S)},g.prototype.setDataSortingOptions=function(){var d=this.options;extend$1k(this,{requireSorting:!1,sorted:!1,enabledDataSorting:!0,allowDG:!1}),defined$K(d.pointRange)||(d.pointRange=1)},g.prototype.setOptions=function(d){var a=this.chart,u=a.options,v=u.plotOptions,x=a.userOptions||{},S=merge$1g(d),T=a.styledMode,P={plotOptions:v,userOptions:S},z;fireEvent$s(this,"setOptions",P);var L=P.plotOptions[this.type],N=x.plotOptions||{};this.userOptions=P.userOptions;var $=merge$1g(L,v.series,x.plotOptions&&x.plotOptions[this.type],S);this.tooltipOptions=merge$1g(defaultOptions$d.tooltip,defaultOptions$d.plotOptions.series&&defaultOptions$d.plotOptions.series.tooltip,defaultOptions$d.plotOptions[this.type].tooltip,u.tooltip.userOptions,v.series&&v.series.tooltip,v[this.type].tooltip,S.tooltip),this.stickyTracking=pick$1o(S.stickyTracking,N[this.type]&&N[this.type].stickyTracking,N.series&&N.series.stickyTracking,this.tooltipOptions.shared&&!this.noSharedTooltip?!0:$.stickyTracking),L.marker===null&&delete $.marker,this.zoneAxis=$.zoneAxis;var B=this.zones=($.zones||[]).slice();return($.negativeColor||$.negativeFillColor)&&!$.zones&&(z={value:$[this.zoneAxis+"Threshold"]||$.threshold||0,className:"highcharts-negative"},T||(z.color=$.negativeColor,z.fillColor=$.negativeFillColor),B.push(z)),B.length&&defined$K(B[B.length-1].value)&&B.push(T?{}:{color:this.color,fillColor:this.fillColor}),fireEvent$s(this,"afterSetOptions",{options:$}),$},g.prototype.getName=function(){return pick$1o(this.options.name,"Series "+(this.index+1))},g.prototype.getCyclic=function(d,a,u){var v=this.chart,x=this.userOptions,S=d+"Index",T=d+"Counter",P=u?u.length:pick$1o(v.options.chart[d+"Count"],v[d+"Count"]),z,L;a||(L=pick$1o(x[S],x["_"+S]),defined$K(L)?z=L:(v.series.length||(v[T]=0),x["_"+S]=z=v[T]%P,v[T]+=1),u&&(a=u[z])),typeof z<"u"&&(this[S]=z),this[d]=a},g.prototype.getColor=function(){this.chart.styledMode?this.getCyclic("color"):this.options.colorByPoint?this.color=palette.neutralColor20:this.getCyclic("color",this.options.color||defaultOptions$d.plotOptions[this.type].color,this.chart.options.colors)},g.prototype.getPointsCollection=function(){return(this.hasGroupedData?this.points:this.data)||[]},g.prototype.getSymbol=function(){var d=this.options.marker;this.getCyclic("symbol",d.symbol,this.chart.options.symbols)},g.prototype.findPointIndex=function(d,a){var u=d.id,v=d.x,x=this.points,S=this.options.dataSorting,T,P,z;if(u){var L=this.chart.get(u);L instanceof Point$4&&(T=L)}else if(this.linkedParent||this.enabledDataSorting||this.options.relativeXValue){var N=function($){return!$.touched&&$.index===d.index};if(S&&S.matchByName?N=function($){return!$.touched&&$.name===d.name}:this.options.relativeXValue&&(N=function($){return!$.touched&&$.options.x===d.x}),T=find$h(x,N),!T)return}return T&&(z=T&&T.index,typeof z<"u"&&(P=!0)),typeof z>"u"&&isNumber$G(v)&&(z=this.xData.indexOf(v,a)),z!==-1&&typeof z<"u"&&this.cropped&&(z=z>=this.cropStart?z-this.cropStart:z),!P&&isNumber$G(z)&&x[z]&&x[z].touched&&(z=void 0),z},g.prototype.updateData=function(d,a){var u=this.options,v=u.dataSorting,x=this.points,S=[],T=this.requireSorting,P=d.length===x.length,z,L,N,$,B=!0;if(this.xIncrement=null,d.forEach(function(U,j){var Y=defined$K(U)&&this.pointClass.prototype.optionsToObject.call({series:this},U)||{},q,Q=Y.x,J=Y.id;J||isNumber$G(Q)?(q=this.findPointIndex(Y,$),q===-1||typeof q>"u"?S.push(U):x[q]&&U!==u.data[q]?(x[q].update(U,!1,null,!1),x[q].touched=!0,T&&($=q+1)):x[q]&&(x[q].touched=!0),(!P||j!==q||v&&v.enabled||this.hasDerivedData)&&(z=!0)):S.push(U)},this),z)for(L=x.length;L--;)N=x[L],N&&!N.touched&&N.remove&&N.remove(!1,a);else P&&(!v||!v.enabled)?(d.forEach(function(U,j){U!==x[j].y&&x[j].update&&x[j].update(U,!1,null,!1)}),S.length=0):B=!1;return x.forEach(function(U){U&&(U.touched=!1)}),B?(S.forEach(function(U){this.addPoint(U,!1,null,null,!1)},this),this.xIncrement===null&&this.xData&&this.xData.length&&(this.xIncrement=arrayMax$7(this.xData),this.autoIncrement()),!0):!1},g.prototype.setData=function(d,a,u,v){var x=this,S=x.points,T=S&&S.length||0,P=x.options,z=x.chart,L=P.dataSorting,N=x.xAxis,$=P.turboThreshold,B=this.xData,U=this.yData,j=x.pointArrayMap,Y=j&&j.length,q=P.keys,Q,J,ee,ie=0,ne=1,ae=null;d=d||[];var de=d.length;if(a=pick$1o(a,!0),L&&L.enabled&&(d=this.sortData(d)),v!==!1&&de&&T&&!x.cropped&&!x.hasGroupedData&&x.visible&&!x.isSeriesBoosting&&(ee=this.updateData(d,u)),!ee){if(x.xIncrement=null,x.colorCounter=0,this.parallelArrays.forEach(function(he){x[he+"Data"].length=0}),$&&de>$)if(ae=x.getFirstValidPoint(d),isNumber$G(ae))for(Q=0;Q<de;Q++)B[Q]=this.autoIncrement(),U[Q]=d[Q];else if(isArray$i(ae))if(Y)for(Q=0;Q<de;Q++)J=d[Q],B[Q]=J[0],U[Q]=J.slice(1,Y+1);else for(q&&(ie=q.indexOf("x"),ne=q.indexOf("y"),ie=ie>=0?ie:0,ne=ne>=0?ne:1),Q=0;Q<de;Q++)J=d[Q],B[Q]=J[ie],U[Q]=J[ne];else error$6(12,!1,z);else for(Q=0;Q<de;Q++)typeof d[Q]<"u"&&(J={series:x},x.pointClass.prototype.applyOptions.apply(J,[d[Q]]),x.updateParallelArrays(J,Q));for(U&&isString$5(U[0])&&error$6(14,!0,z),x.data=[],x.options.data=x.userOptions.data=d,Q=T;Q--;)S[Q]&&S[Q].destroy&&S[Q].destroy();N&&(N.minRange=N.userMinRange),x.isDirty=z.isDirtyBox=!0,x.isDirtyData=!!S,u=!1}P.legendType==="point"&&(this.processData(),this.generatePoints()),a&&z.redraw(u)},g.prototype.sortData=function(d){var a=this,u=a.options,v=u.dataSorting,x=v.sortKey||"y",S=function(P,z){return defined$K(z)&&P.pointClass.prototype.optionsToObject.call({series:P},z)||{}};d.forEach(function(P,z){d[z]=S(a,P),d[z].index=z},this);var T=d.concat().sort(function(P,z){var L=getNestedProperty(x,P),N=getNestedProperty(x,z);return N<L?-1:N>L?1:0});return T.forEach(function(P,z){P.x=z},this),a.linkedSeries&&a.linkedSeries.forEach(function(P){var z=P.options,L=z.data;(!z.dataSorting||!z.dataSorting.enabled)&&L&&(L.forEach(function(N,$){L[$]=S(P,N),d[$]&&(L[$].x=d[$].x,L[$].index=$)}),P.setData(L,!1))}),d},g.prototype.getProcessedData=function(d){var a=this,u=a.xAxis,v=a.options,x=v.cropThreshold,S=d||a.getExtremesFromAll||v.getExtremesFromAll,T=a.isCartesian,P=u&&u.val2lin,z=!!(u&&u.logarithmic),L,N,$=0,B,U,j,Y,q,Q,J=a.xData,ee=a.yData,ie=a.requireSorting,ne=!1,ae=J.length;for(u&&(Y=u.getExtremes(),q=Y.min,Q=Y.max,ne=u.categories&&!u.names.length),T&&a.sorted&&!S&&(!x||ae>x||a.forceCrop)&&(J[ae-1]<q||J[0]>Q?(J=[],ee=[]):a.yData&&(J[0]<q||J[ae-1]>Q)&&(L=this.cropData(a.xData,a.yData,q,Q),J=L.xData,ee=L.yData,$=L.start,N=!0)),j=J.length||1;--j;)B=z?P(J[j])-P(J[j-1]):J[j]-J[j-1],B>0&&(typeof U>"u"||B<U)?U=B:B<0&&ie&&!ne&&(error$6(15,!1,a.chart),ie=!1);return{xData:J,yData:ee,cropped:N,cropStart:$,closestPointRange:U}},g.prototype.processData=function(d){var a=this,u=a.xAxis;if(a.isCartesian&&!a.isDirty&&!u.isDirty&&!a.yAxis.isDirty&&!d)return!1;var v=a.getProcessedData();a.cropped=v.cropped,a.cropStart=v.cropStart,a.processedXData=v.xData,a.processedYData=v.yData,a.closestPointRange=a.basePointRange=v.closestPointRange},g.prototype.cropData=function(d,a,u,v,x){var S=d.length,T,P,z=0,L=S;for(x=pick$1o(x,this.cropShoulder),T=0;T<S;T++)if(d[T]>=u){z=Math.max(0,T-x);break}for(P=T;P<S;P++)if(d[P]>v){L=P+x;break}return{xData:d.slice(z,L),yData:a.slice(z,L),start:z,end:L}},g.prototype.generatePoints=function(){var d=this,a=d.options,u=a.data,v=d.processedXData,x=d.processedYData,S=d.pointClass,T=v.length,P=d.cropStart||0,z=d.hasGroupedData,L=a.keys,N=[],$=a.dataGrouping&&a.dataGrouping.groupAll?P:0,B,U,j,Y,q=d.data;if(!q&&!z){var Q=[];Q.length=u.length,q=d.data=Q}for(L&&z&&(d.options.keys=!1),Y=0;Y<T;Y++)U=P+Y,z?(j=new S().init(d,[v[Y]].concat(splat$e(x[Y]))),j.dataGroup=d.groupMap[$+Y],j.dataGroup.options&&(j.options=j.dataGroup.options,extend$1k(j,j.dataGroup.options),delete j.dataLabels)):(j=q[U],!j&&typeof u[U]<"u"&&(q[U]=j=new S().init(d,u[U],v[Y]))),j&&(j.index=z?$+Y:U,N[Y]=j);if(d.options.keys=L,q&&(T!==(B=q.length)||z))for(Y=0;Y<B;Y++)Y===P&&!z&&(Y+=T),q[Y]&&(q[Y].destroyElements(),q[Y].plotX=void 0);d.data=q,d.points=N,fireEvent$s(this,"afterGeneratePoints")},g.prototype.getXExtremes=function(d){return{min:arrayMin$6(d),max:arrayMax$7(d)}},g.prototype.getExtremes=function(d,a){var u=this.xAxis,v=this.yAxis,x=this.processedXData||this.xData,S=[],T=this.requireSorting?this.cropShoulder:0,P=v?v.positiveValuesOnly:!1,z,L,N,$,B,U,j,Y=0,q=0,Q=0;d=d||this.stackedYData||this.processedYData||[];var J=d.length;for(u&&(z=u.getExtremes(),Y=z.min,q=z.max),U=0;U<J;U++)if($=x[U],B=d[U],L=(isNumber$G(B)||isArray$i(B))&&(B.length||B>0||!P),N=a||this.getExtremesFromAll||this.options.getExtremesFromAll||this.cropped||!u||(x[U+T]||$)>=Y&&(x[U-T]||$)<=q,L&&N)if(j=B.length,j)for(;j--;)isNumber$G(B[j])&&(S[Q++]=B[j]);else S[Q++]=B;var ee={dataMin:arrayMin$6(S),dataMax:arrayMax$7(S)};return fireEvent$s(this,"afterGetExtremes",{dataExtremes:ee}),ee},g.prototype.applyExtremes=function(){var d=this.getExtremes();return this.dataMin=d.dataMin,this.dataMax=d.dataMax,d},g.prototype.getFirstValidPoint=function(d){for(var a=d.length,u=0,v=null;v===null&&u<a;)v=d[u],u++;return v},g.prototype.translate=function(){this.processedXData||this.processData(),this.generatePoints();var d=this,a=d.options,u=a.stacking,v=d.xAxis,x=v.categories,S=d.enabledDataSorting,T=d.yAxis,P=d.points,z=P.length,L=!!d.modifyValue,N=d.pointPlacementToXValue(),$=!!N,B=a.threshold,U=a.startFromThreshold?B:0,j=this.zoneAxis||"y",Y,q,Q,J,ee=Number.MAX_VALUE;function ie(_e){return clamp$g(_e,-1e5,1e5)}for(Y=0;Y<z;Y++){var ne=P[Y],ae=ne.x,de=void 0,he=void 0,pe=ne.y,ve=ne.low,be=u&&T.stacking&&T.stacking.stacks[(d.negStacks&&pe<(U?0:B)?"-":"")+d.stackKey];if((T.positiveValuesOnly&&!T.validatePositiveValue(pe)||v.positiveValuesOnly&&!v.validatePositiveValue(ae))&&(ne.isNull=!0),ne.plotX=q=correctFloat$a(ie(v.translate(ae,0,0,0,1,N,this.type==="flags"))),u&&d.visible&&be&&be[ae]&&(J=d.getStackIndicator(J,ae,d.index),ne.isNull||(de=be[ae],he=de.points[J.key])),isArray$i(he)&&(ve=he[0],pe=he[1],ve===U&&J.key===be[ae].base&&(ve=pick$1o(isNumber$G(B)&&B,T.min)),T.positiveValuesOnly&&ve<=0&&(ve=null),ne.total=ne.stackTotal=de.total,ne.percentage=de.total&&ne.y/de.total*100,ne.stackY=pe,d.irregularWidths||de.setOffset(d.pointXOffset||0,d.barW||0)),ne.yBottom=defined$K(ve)?ie(T.translate(ve,0,1,0,1)):null,L&&(pe=d.modifyValue(pe,ne)),ne.plotY=void 0,isNumber$G(pe)){var ge=T.translate(pe,!1,!0,!1,!0);typeof ge<"u"&&(ne.plotY=ie(ge))}ne.isInside=this.isPointInside(ne),ne.clientX=$?correctFloat$a(v.translate(ae,0,0,0,1,N)):q,ne.negative=ne[j]<(a[j+"Threshold"]||B||0),ne.category=x&&typeof x[ne.x]<"u"?x[ne.x]:ne.x,!ne.isNull&&ne.visible!==!1&&(typeof Q<"u"&&(ee=Math.min(ee,Math.abs(q-Q))),Q=q),ne.zone=this.zones.length&&ne.getZone(),!ne.graphic&&d.group&&S&&(ne.isNew=!0)}d.closestPointRangePx=ee,fireEvent$s(this,"afterTranslate")},g.prototype.getValidPoints=function(d,a,u){var v=this.chart;return(d||this.points||[]).filter(function(x){return a&&!v.isInsidePlot(x.plotX,x.plotY,{inverted:v.inverted})?!1:x.visible!==!1&&(u||!x.isNull)})},g.prototype.getClipBox=function(d,a){var u=this,v=u.options,x=u.chart,S=x.inverted,T=u.xAxis,P=T&&u.yAxis,z=x.options.chart.scrollablePlotArea||{},L;return d&&v.clip===!1&&P?L=S?{y:-x.chartWidth+P.len+P.pos,height:x.chartWidth,width:x.chartHeight,x:-x.chartHeight+T.len+T.pos}:{y:-P.pos,height:x.chartHeight,width:x.chartWidth,x:-T.pos}:(L=u.clipBox||x.clipBox,a&&(L.width=x.plotSizeX,L.x=(x.scrollablePixelsX||0)*(z.scrollPositionX||0))),a?{width:L.width,x:L.x}:L},g.prototype.getSharedClipKey=function(d){if(this.sharedClipKey)return this.sharedClipKey;var a=[d&&d.duration,d&&d.easing,d&&d.defer,this.getClipBox(d).height,this.options.xAxis,this.options.yAxis].join(",");return(this.options.clip!==!1||d)&&(this.sharedClipKey=a),a},g.prototype.setClip=function(d){var a=this.chart,u=this.options,v=a.renderer,x=a.inverted,S=this.clipBox,T=this.getClipBox(d),P=this.getSharedClipKey(d),z=a.sharedClips[P],L=a.sharedClips[P+"m"];d&&(T.width=0,x&&(T.x=a.plotHeight+(u.clip!==!1?0:a.plotTop))),z?a.hasLoaded||z.attr(T):(d&&(a.sharedClips[P+"m"]=L=v.clipRect(x?(a.plotSizeX||0)+99:-99,x?-a.plotLeft:-a.plotTop,99,x?a.chartWidth:a.chartHeight)),a.sharedClips[P]=z=v.clipRect(T),z.count={length:0}),d&&(z.count[this.index]||(z.count[this.index]=!0,z.count.length+=1)),(u.clip!==!1||d)&&(this.group.clip(d||S?z:a.clipRect),this.markerGroup.clip(L)),d||(z.count[this.index]&&(delete z.count[this.index],z.count.length-=1),z.count.length===0&&(S||(a.sharedClips[P]=z.destroy()),L&&(a.sharedClips[P+"m"]=L.destroy())))},g.prototype.animate=function(d){var a=this,u=a.chart,v=animObject$7(a.options.animation),x=this.sharedClipKey;if(d)a.setClip(v);else if(x){var S=u.sharedClips[x],T=u.sharedClips[x+"m"],P=a.getClipBox(v,!0);S&&S.animate(P,v),T&&T.animate({width:P.width+99,x:P.x-(u.inverted?0:99)},v)}},g.prototype.afterAnimate=function(){this.setClip(),fireEvent$s(this,"afterAnimate"),this.finishedAnimating=!0},g.prototype.drawPoints=function(){var d=this,a=d.points,u=d.chart,v=d.options,x=v.marker,S=d[d.specialGroup]||d.markerGroup,T=d.xAxis,P=pick$1o(x.enabled,!T||T.isRadial?!0:null,d.closestPointRangePx>=x.enabledThreshold*x.radius),z,L,N,$,B,U,j;if(x.enabled!==!1||d._hasPointMarkers)for(z=0;z<a.length;z++){L=a[z],N=L.graphic,$=N?"animate":"attr",B=L.marker||{},U=!!L.marker;var Y=(P&&typeof B.enabled>"u"||B.enabled)&&!L.isNull&&L.visible!==!1;if(Y){var q=pick$1o(B.symbol,d.symbol,"rect");j=d.markerAttribs(L,L.selected&&"select"),d.enabledDataSorting&&(L.startXPos=T.reversed?-(j.width||0):T.width);var Q=L.isInside!==!1;N?N[Q?"show":"hide"](Q).animate(j):Q&&((j.width||0)>0||L.hasImage)&&(L.graphic=N=u.renderer.symbol(q,j.x,j.y,j.width,j.height,U?B:x).add(S),d.enabledDataSorting&&u.hasRendered&&(N.attr({x:L.startXPos}),$="animate")),N&&$==="animate"&&N[Q?"show":"hide"](Q).animate(j),N&&!u.styledMode&&N[$](d.pointAttribs(L,L.selected&&"select")),N&&N.addClass(L.getClassName(),!0)}else N&&(L.graphic=N.destroy())}},g.prototype.markerAttribs=function(d,a){var u=this.options,v=u.marker,x=d.marker||{},S=x.symbol||v.symbol,T,P,z=pick$1o(x.radius,v.radius);a&&(T=v.states[a],P=x.states&&x.states[a],z=pick$1o(P&&P.radius,T&&T.radius,z+(T&&T.radiusPlus||0))),d.hasImage=S&&S.indexOf("url")===0,d.hasImage&&(z=0);var L={x:u.crisp?Math.floor(d.plotX-z):d.plotX-z,y:d.plotY-z};return z&&(L.width=L.height=2*z),L},g.prototype.pointAttribs=function(d,a){var u=this.options.marker,v=d&&d.options,x=v&&v.marker||{},S=v&&v.color,T=d&&d.color,P=d&&d.zone&&d.zone.color,z,L,N=this.color,$,B,U=pick$1o(x.lineWidth,u.lineWidth),j=1;return N=S||P||T||N,$=x.fillColor||u.fillColor||N,B=x.lineColor||u.lineColor||N,a=a||"normal",a&&(z=u.states[a],L=x.states&&x.states[a]||{},U=pick$1o(L.lineWidth,z.lineWidth,U+pick$1o(L.lineWidthPlus,z.lineWidthPlus,0)),$=L.fillColor||z.fillColor||$,B=L.lineColor||z.lineColor||B,j=pick$1o(L.opacity,z.opacity,j)),{stroke:B,"stroke-width":U,fill:$,opacity:j}},g.prototype.destroy=function(d){var a=this,u=a.chart,v=/AppleWebKit\/533/.test(win$7.navigator.userAgent),x=a.data||[],S,T,P,z;for(fireEvent$s(a,"destroy"),this.removeEvents(d),(a.axisTypes||[]).forEach(function(L){z=a[L],z&&z.series&&(erase$3(z.series,a),z.isDirty=z.forceRedraw=!0)}),a.legendItem&&a.chart.legend.destroyItem(a),T=x.length;T--;)P=x[T],P&&P.destroy&&P.destroy();a.clips&&a.clips.forEach(function(L){return L.destroy()}),Utilities.clearTimeout(a.animationTimeout),objectEach$o(a,function(L,N){L instanceof SVGElement&&!L.survive&&(S=v&&N==="group"?"hide":"destroy",L[S]())}),u.hoverSeries===a&&(u.hoverSeries=void 0),erase$3(u.series,a),u.orderSeries(),objectEach$o(a,function(L,N){(!d||N!=="hcEvents")&&delete a[N]})},g.prototype.applyZones=function(){var d=this,a=this.chart,u=a.renderer,v=this.zones,x=this.clips||[],S=this.graph,T=this.area,P=Math.max(a.chartWidth,a.chartHeight),z=this[(this.zoneAxis||"y")+"Axis"],L=a.inverted,N,$,B,U,j,Y,q,Q,J,ee,ie,ne=!1;v.length&&(S||T)&&z&&typeof z.min<"u"?(j=z.reversed,Y=z.horiz,S&&!this.showLine&&S.hide(),T&&T.hide(),U=z.getExtremes(),v.forEach(function(ae,de){N=j?Y?a.plotWidth:0:Y?0:z.toPixels(U.min)||0,N=clamp$g(pick$1o($,N),0,P),$=clamp$g(Math.round(z.toPixels(pick$1o(ae.value,U.max),!0)||0),0,P),ne&&(N=$=z.toPixels(U.max)),q=Math.abs(N-$),Q=Math.min(N,$),J=Math.max(N,$),z.isXAxis?(B={x:L?J:Q,y:0,width:q,height:P},Y||(B.x=a.plotHeight-B.x)):(B={x:0,y:L?J:Q,width:P,height:q},Y&&(B.y=a.plotWidth-B.y)),L&&u.isVML&&(z.isXAxis?B={x:0,y:j?Q:J,height:B.width,width:a.chartWidth}:B={x:B.y-a.plotLeft-a.spacingBox.x,y:0,width:B.height,height:a.chartHeight}),x[de]?x[de].animate(B):x[de]=u.clipRect(B),ee=d["zone-area-"+de],ie=d["zone-graph-"+de],S&&ie&&ie.clip(x[de]),T&&ee&&ee.clip(x[de]),ne=ae.value>U.max,d.resetZones&&$===0&&($=void 0)}),this.clips=x):d.visible&&(S&&S.show(!0),T&&T.show(!0))},g.prototype.invertGroups=function(d){var a=this,u=a.chart;function v(){["group","markerGroup"].forEach(function(x){a[x]&&(u.renderer.isVML&&a[x].attr({width:a.yAxis.len,height:a.xAxis.len}),a[x].width=a.yAxis.len,a[x].height=a.xAxis.len,a[x].invert(a.isRadialSeries?!1:d))})}a.xAxis&&(a.eventsToUnbind.push(addEvent$Z(u,"resize",v)),v(),a.invertGroups=v)},g.prototype.plotGroup=function(d,a,u,v,x){var S=this[d],T=!S,P={visibility:u,zIndex:v||.1};return typeof this.opacity<"u"&&!this.chart.styledMode&&this.state!=="inactive"&&(P.opacity=this.opacity),T&&(this[d]=S=this.chart.renderer.g().add(x)),S.addClass("highcharts-"+a+" highcharts-series-"+this.index+" highcharts-"+this.type+"-series "+(defined$K(this.colorIndex)?"highcharts-color-"+this.colorIndex+" ":"")+(this.options.className||"")+(S.hasClass("highcharts-tracker")?" highcharts-tracker":""),!0),S.attr(P)[T?"attr":"animate"](this.getPlotBox()),S},g.prototype.getPlotBox=function(){var d=this.chart,a=this.xAxis,u=this.yAxis;return d.inverted&&(a=u,u=this.xAxis),{translateX:a?a.left:d.plotLeft,translateY:u?u.top:d.plotTop,scaleX:1,scaleY:1}},g.prototype.removeEvents=function(d){var a=this;d||removeEvent$5(a),a.eventsToUnbind.length&&(a.eventsToUnbind.forEach(function(u){u()}),a.eventsToUnbind.length=0)},g.prototype.render=function(){var d=this,a=d.chart,u=d.options,v=animObject$7(u.animation),x=d.visible?"inherit":"hidden",S=u.zIndex,T=d.hasRendered,P=a.seriesGroup,z=a.inverted,L=!d.finishedAnimating&&a.renderer.isSVG&&v.duration;fireEvent$s(this,"render");var N=d.plotGroup("group","series",x,S,P);d.markerGroup=d.plotGroup("markerGroup","markers",x,S,P),L&&d.animate&&d.animate(!0),N.inverted=pick$1o(d.invertible,d.isCartesian)?z:!1,d.drawGraph&&(d.drawGraph(),d.applyZones()),d.visible&&d.drawPoints(),d.drawDataLabels&&d.drawDataLabels(),d.redrawPoints&&d.redrawPoints(),d.drawTracker&&d.options.enableMouseTracking!==!1&&d.drawTracker(),d.invertGroups(z),u.clip!==!1&&!d.sharedClipKey&&!T&&N.clip(a.clipRect),L&&d.animate&&d.animate(),T||(L&&v.defer&&(L+=v.defer),d.animationTimeout=syncTimeout$2(function(){d.afterAnimate()},L||0)),d.isDirty=!1,d.hasRendered=!0,fireEvent$s(d,"afterRender")},g.prototype.redraw=function(){var d=this,a=d.chart,u=d.isDirty||d.isDirtyData,v=d.group,x=d.xAxis,S=d.yAxis;v&&(a.inverted&&v.attr({width:a.plotWidth,height:a.plotHeight}),v.animate({translateX:pick$1o(x&&x.left,a.plotLeft),translateY:pick$1o(S&&S.top,a.plotTop)})),d.translate(),d.render(),u&&delete this.kdTree},g.prototype.searchPoint=function(d,a){var u=this,v=u.xAxis,x=u.yAxis,S=u.chart.inverted;return this.searchKDTree({clientX:S?v.len-d.chartY+v.pos:d.chartX-v.pos,plotY:S?x.len-d.chartX+x.pos:d.chartY-x.pos},a,d)},g.prototype.buildKDTree=function(d){this.buildingKdTree=!0;var a=this,u=a.options.findNearestPointBy.indexOf("y")>-1?2:1;function v(S,T,P){var z=S&&S.length,L,N;if(z)return L=a.kdAxisArray[T%P],S.sort(function($,B){return $[L]-B[L]}),N=Math.floor(z/2),{point:S[N],left:v(S.slice(0,N),T+1,P),right:v(S.slice(N+1),T+1,P)}}function x(){a.kdTree=v(a.getValidPoints(null,!a.directTouch),u,u),a.buildingKdTree=!1}delete a.kdTree,syncTimeout$2(x,a.options.kdNow||d&&d.type==="touchstart"?0:1)},g.prototype.searchKDTree=function(d,a,u){var v=this,x=this.kdAxisArray[0],S=this.kdAxisArray[1],T=a?"distX":"dist",P=v.options.findNearestPointBy.indexOf("y")>-1?2:1;function z(N,$){var B=defined$K(N[x])&&defined$K($[x])?Math.pow(N[x]-$[x],2):null,U=defined$K(N[S])&&defined$K($[S])?Math.pow(N[S]-$[S],2):null,j=(B||0)+(U||0);$.dist=defined$K(j)?Math.sqrt(j):Number.MAX_VALUE,$.distX=defined$K(B)?Math.sqrt(B):Number.MAX_VALUE}function L(N,$,B,U){var j=$.point,Y=v.kdAxisArray[B%U],q,Q,J=j;z(N,j);var ee=N[Y]-j[Y],ie=ee<0?"left":"right",ne=ee<0?"right":"left";return $[ie]&&(q=L(N,$[ie],B+1,U),J=q[T]<J[T]?q:j),$[ne]&&Math.sqrt(ee*ee)<J[T]&&(Q=L(N,$[ne],B+1,U),J=Q[T]<J[T]?Q:J),J}if(!this.kdTree&&!this.buildingKdTree&&this.buildKDTree(u),this.kdTree)return L(d,this.kdTree,P,P)},g.prototype.pointPlacementToXValue=function(){var d=this,a=d.options,u=a.pointPlacement,v=a.pointRange,x=d.xAxis,S=u;return S==="between"&&(S=x.reversed?-.5:.5),isNumber$G(S)?S*(v||x.pointRange):0},g.prototype.isPointInside=function(d){var a=typeof d.plotY<"u"&&typeof d.plotX<"u"&&d.plotY>=0&&d.plotY<=this.yAxis.len&&d.plotX>=0&&d.plotX<=this.xAxis.len;return a},g.prototype.drawTracker=function(){var d=this,a=d.options,u=a.trackByArea,v=[].concat(u?d.areaPath:d.graphPath),x=d.chart,S=x.pointer,T=x.renderer,P=x.options.tooltip.snap,z=d.tracker,L=function($){x.hoverSeries!==d&&d.onMouseOver()},N="rgba(192,192,192,"+(svg$4?1e-4:.002)+")";z?z.attr({d:v}):d.graph&&(d.tracker=T.path(v).attr({visibility:d.visible?"visible":"hidden",zIndex:2}).addClass(u?"highcharts-tracker-area":"highcharts-tracker-line").add(d.group),x.styledMode||d.tracker.attr({"stroke-linecap":"round","stroke-linejoin":"round",stroke:N,fill:u?N:"none","stroke-width":d.graph.strokeWidth()+(u?0:2*P)}),[d.tracker,d.markerGroup,d.dataLabelsGroup].forEach(function($){$&&($.addClass("highcharts-tracker").on("mouseover",L).on("mouseout",function(B){S.onTrackerMouseOut(B)}),a.cursor&&!x.styledMode&&$.css({cursor:a.cursor}),hasTouch$2&&$.on("touchstart",L))})),fireEvent$s(this,"afterDrawTracker")},g.prototype.addPoint=function(d,a,u,v,x){var S=this,T=S.options,P=S.data,z=S.chart,L=S.xAxis,N=L&&L.hasNames&&L.names,$=T.data,B=S.xData,U,j;a=pick$1o(a,!0);var Y={series:S};S.pointClass.prototype.applyOptions.apply(Y,[d]);var q=Y.x;if(j=B.length,S.requireSorting&&q<B[j-1])for(U=!0;j&&B[j-1]>q;)j--;S.updateParallelArrays(Y,"splice",j,0,0),S.updateParallelArrays(Y,j),N&&Y.name&&(N[q]=Y.name),$.splice(j,0,d),U&&(S.data.splice(j,0,null),S.processData()),T.legendType==="point"&&S.generatePoints(),u&&(P[0]&&P[0].remove?P[0].remove(!1):(P.shift(),S.updateParallelArrays(Y,"shift"),$.shift())),x!==!1&&fireEvent$s(S,"addPoint",{point:Y}),S.isDirty=!0,S.isDirtyData=!0,a&&z.redraw(v)},g.prototype.removePoint=function(d,a,u){var v=this,x=v.data,S=x[d],T=v.points,P=v.chart,z=function(){T&&T.length===x.length&&T.splice(d,1),x.splice(d,1),v.options.data.splice(d,1),v.updateParallelArrays(S||{series:v},"splice",d,1),S&&S.destroy(),v.isDirty=!0,v.isDirtyData=!0,a&&P.redraw()};setAnimation$2(u,P),a=pick$1o(a,!0),S?S.firePointEvent("remove",null,z):z()},g.prototype.remove=function(d,a,u,v){var x=this,S=x.chart;function T(){x.destroy(v),S.isDirtyLegend=S.isDirtyBox=!0,S.linkSeries(),pick$1o(d,!0)&&S.redraw(a)}u!==!1?fireEvent$s(x,"remove",null,T):T()},g.prototype.update=function(d,a){d=cleanRecursively(d,this.userOptions),fireEvent$s(this,"update",{options:d});var u=this,v=u.chart,x=u.userOptions,S=u.initialType||u.type,T=v.options.plotOptions,P=seriesTypes$7[S].prototype,z=["group","markerGroup","dataLabelsGroup","transformGroup"],L=u.finishedAnimating&&{animation:!1},N={},$,B,U=["eventOptions","navigatorSeries","baseSeries"],j=d.type||x.type||v.options.chart.type,Y=!(this.hasDerivedData||j&&j!==this.type||typeof d.pointStart<"u"||typeof d.pointInterval<"u"||typeof d.relativeXValue<"u"||u.hasOptionChanged("dataGrouping")||u.hasOptionChanged("pointStart")||u.hasOptionChanged("pointInterval")||u.hasOptionChanged("pointIntervalUnit")||u.hasOptionChanged("keys"));j=j||S,Y&&(U.push("data","isDirtyData","points","processedXData","processedYData","xIncrement","cropped","_hasPointMarkers","_hasPointLabels","clips","nodes","layout","mapMap","mapData","minY","maxY","minX","maxX"),d.visible!==!1&&U.push("area","graph"),u.parallelArrays.forEach(function(ie){U.push(ie+"Data")}),d.data&&(d.dataSorting&&extend$1k(u.options.dataSorting,d.dataSorting),this.setData(d.data,!1))),d=merge$1g(x,L,{index:typeof x.index>"u"?u.index:x.index,pointStart:pick$1o(T&&T.series&&T.series.pointStart,x.pointStart,u.xData[0])},!Y&&{data:u.options.data},d),Y&&d.data&&(d.data=u.options.data),U=z.concat(U),U.forEach(function(ie){U[ie]=u[ie],delete u[ie]});var q=!1;if(seriesTypes$7[j]){if(q=j!==u.type,u.remove(!1,!1,!1,!0),q)if(Object.setPrototypeOf)Object.setPrototypeOf(u,seriesTypes$7[j].prototype);else{var Q=Object.hasOwnProperty.call(u,"hcEvents")&&u.hcEvents;for(B in P)u[B]=void 0;extend$1k(u,seriesTypes$7[j].prototype),Q?u.hcEvents=Q:delete u.hcEvents}}else error$6(17,!0,v,{missingModuleFor:j});if(U.forEach(function(ie){u[ie]=U[ie]}),u.init(v,d),Y&&this.points){if($=u.options,$.visible===!1)N.graphic=1,N.dataLabel=1;else if(!u._hasPointLabels){var J=$.marker,ee=$.dataLabels;J&&(J.enabled===!1||(x.marker&&x.marker.symbol)!==J.symbol)&&(N.graphic=1),ee&&ee.enabled===!1&&(N.dataLabel=1)}this.points.forEach(function(ie){ie&&ie.series&&(ie.resolveColor(),Object.keys(N).length&&ie.destroyElements(N),$.showInLegend===!1&&ie.legendItem&&v.legend.destroyItem(ie))},this)}u.initialType=S,v.linkSeries(),q&&u.linkedSeries.length&&(u.isDirtyData=!0),fireEvent$s(this,"afterUpdate"),pick$1o(a,!0)&&v.redraw(Y?void 0:!1)},g.prototype.setName=function(d){this.name=this.options.name=this.userOptions.name=d,this.chart.isDirtyLegend=!0},g.prototype.hasOptionChanged=function(d){var a=this.chart,u=this.options[d],v=a.options.plotOptions,x=this.userOptions[d];return x?u!==x:u!==pick$1o(v&&v[this.type]&&v[this.type][d],v&&v.series&&v.series[d],u)},g.prototype.onMouseOver=function(){var d=this,a=d.chart,u=a.hoverSeries,v=a.pointer;v.setHoverChartIndex(),u&&u!==d&&u.onMouseOut(),d.options.events.mouseOver&&fireEvent$s(d,"mouseOver"),d.setState("hover"),a.hoverSeries=d},g.prototype.onMouseOut=function(){var d=this,a=d.options,u=d.chart,v=u.tooltip,x=u.hoverPoint;u.hoverSeries=null,x&&x.onMouseOut(),d&&a.events.mouseOut&&fireEvent$s(d,"mouseOut"),v&&!d.stickyTracking&&(!v.shared||d.noSharedTooltip)&&v.hide(),u.series.forEach(function(S){S.setState("",!0)})},g.prototype.setState=function(d,a){var u=this,v=u.options,x=u.graph,S=v.inactiveOtherPoints,T=v.states,P=pick$1o(T[d||"normal"]&&T[d||"normal"].animation,u.chart.options.chart.animation),z,L=v.lineWidth,N=0,$=v.opacity;if(d=d||"",u.state!==d&&([u.group,u.markerGroup,u.dataLabelsGroup].forEach(function(B){B&&(u.state&&B.removeClass("highcharts-series-"+u.state),d&&B.addClass("highcharts-series-"+d))}),u.state=d,!u.chart.styledMode)){if(T[d]&&T[d].enabled===!1)return;if(d&&(L=T[d].lineWidth||L+(T[d].lineWidthPlus||0),$=pick$1o(T[d].opacity,$)),x&&!x.dashstyle)for(z={"stroke-width":L},x.animate(z,P);u["zone-graph-"+N];)u["zone-graph-"+N].animate(z,P),N=N+1;S||[u.group,u.markerGroup,u.dataLabelsGroup,u.labelBySeries].forEach(function(B){B&&B.animate({opacity:$},P)})}a&&S&&u.points&&u.setAllPointsToState(d||void 0)},g.prototype.setAllPointsToState=function(d){this.points.forEach(function(a){a.setState&&a.setState(d)})},g.prototype.setVisible=function(d,a){var u=this,v=u.chart,x=u.legendItem,S=v.options.chart.ignoreHiddenSeries,T=u.visible;u.visible=d=u.options.visible=u.userOptions.visible=typeof d>"u"?!T:d;var P=d?"show":"hide";["group","dataLabelsGroup","markerGroup","tracker","tt"].forEach(function(z){u[z]&&u[z][P]()}),(v.hoverSeries===u||(v.hoverPoint&&v.hoverPoint.series)===u)&&u.onMouseOut(),x&&v.legend.colorizeItem(u,d),u.isDirty=!0,u.options.stacking&&v.series.forEach(function(z){z.options.stacking&&z.visible&&(z.isDirty=!0)}),u.linkedSeries.forEach(function(z){z.setVisible(d,!1)}),S&&(v.isDirtyBox=!0),fireEvent$s(u,P),a!==!1&&v.redraw()},g.prototype.show=function(){this.setVisible(!0)},g.prototype.hide=function(){this.setVisible(!1)},g.prototype.select=function(d){var a=this;a.selected=d=this.options.selected=typeof d>"u"?!a.selected:d,a.checkbox&&(a.checkbox.checked=d),fireEvent$s(a,d?"select":"unselect")},g.prototype.shouldShowTooltip=function(d,a,u){return u===void 0&&(u={}),u.series=this,u.visiblePlotOnly=!0,this.chart.isInsidePlot(d,a,u)},g.defaultOptions=seriesDefaults,g})();extend$1k(Series$f.prototype,{axisTypes:["xAxis","yAxis"],coll:"series",colorCounter:0,cropShoulder:1,directTouch:!1,drawLegendSymbol:LegendSymbol$1.drawLineMarker,isCartesian:!0,kdAxisArray:["clientX","plotY"],parallelArrays:["x","y"],pointClass:Point$4,requireSorting:!0,sorted:!0});SeriesRegistry$1.series=Series$f;var stop=animationExports.stop,addEvent$Y=Utilities.addEvent,createElement$4=Utilities.createElement,merge$1f=Utilities.merge,pick$1n=Utilities.pick;addEvent$Y(Chart$1,"afterSetChartSize",function(g){var d=this.options.chart.scrollablePlotArea,a=d&&d.minWidth,u=d&&d.minHeight,v,x,S;this.renderer.forExport||(a?(this.scrollablePixelsX=v=Math.max(0,a-this.chartWidth),v&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$1f(this.plotBox),this.plotBox.width=this.plotWidth+=v,this.inverted?this.clipBox.height+=v:this.clipBox.width+=v,S={1:{name:"right",value:v}})):u&&(this.scrollablePixelsY=x=Math.max(0,u-this.chartHeight),x&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$1f(this.plotBox),this.plotBox.height=this.plotHeight+=x,this.inverted?this.clipBox.width+=x:this.clipBox.height+=x,S={2:{name:"bottom",value:x}})),S&&!g.skipAxes&&this.axes.forEach(function(T){S[T.side]?T.getPlotLinePath=function(){var P=S[T.side].name,z=S[T.side].value,L=this[P],N;return this[P]=L-z,N=Axis.prototype.getPlotLinePath.apply(this,arguments),this[P]=L,N}:(T.setAxisSize(),T.setAxisTranslation())}))});addEvent$Y(Chart$1,"render",function(){this.scrollablePixelsX||this.scrollablePixelsY?(this.setUpScrolling&&this.setUpScrolling(),this.applyFixed()):this.fixedDiv&&this.applyFixed()});Chart$1.prototype.setUpScrolling=function(){var g=this,d={WebkitOverflowScrolling:"touch",overflowX:"hidden",overflowY:"hidden"};this.scrollablePixelsX&&(d.overflowX="auto"),this.scrollablePixelsY&&(d.overflowY="auto"),this.scrollingParent=createElement$4("div",{className:"highcharts-scrolling-parent"},{position:"relative"},this.renderTo),this.scrollingContainer=createElement$4("div",{className:"highcharts-scrolling"},d,this.scrollingParent),addEvent$Y(this.scrollingContainer,"scroll",function(){g.pointer&&delete g.pointer.chartPosition}),this.innerContainer=createElement$4("div",{className:"highcharts-inner-container"},null,this.scrollingContainer),this.innerContainer.appendChild(this.container),this.setUpScrolling=null};Chart$1.prototype.moveFixedElements=function(){var g=this.container,d=this.fixedRenderer,a=[".highcharts-contextbutton",".highcharts-credits",".highcharts-legend",".highcharts-legend-checkbox",".highcharts-navigator-series",".highcharts-navigator-xaxis",".highcharts-navigator-yaxis",".highcharts-navigator",".highcharts-reset-zoom",".highcharts-drillup-button",".highcharts-scrollbar",".highcharts-subtitle",".highcharts-title"],u;this.scrollablePixelsX&&!this.inverted?u=".highcharts-yaxis":this.scrollablePixelsX&&this.inverted||this.scrollablePixelsY&&!this.inverted?u=".highcharts-xaxis":this.scrollablePixelsY&&this.inverted&&(u=".highcharts-yaxis"),u&&a.push(u+":not(.highcharts-radial-axis)",u+"-labels:not(.highcharts-radial-axis-labels)"),a.forEach(function(v){[].forEach.call(g.querySelectorAll(v),function(x){(x.namespaceURI===d.SVG_NS?d.box:d.box.parentNode).appendChild(x),x.style.pointerEvents="auto"})})};Chart$1.prototype.applyFixed=function(){var g=!this.fixedDiv,d=this.options.chart,a=d.scrollablePlotArea,u=RendererRegistry$1.getRendererType(),v,x,S;g?(this.fixedDiv=createElement$4("div",{className:"highcharts-fixed"},{position:"absolute",overflow:"hidden",pointerEvents:"none",zIndex:(d.style&&d.style.zIndex||0)+2,top:0},null,!0),this.scrollingContainer&&this.scrollingContainer.parentNode.insertBefore(this.fixedDiv,this.scrollingContainer),this.renderTo.style.overflow="visible",this.fixedRenderer=v=new u(this.fixedDiv,this.chartWidth,this.chartHeight,this.options.chart.style),this.scrollableMask=v.path().attr({fill:this.options.chart.backgroundColor||"#fff","fill-opacity":pick$1n(a.opacity,.85),zIndex:-1}).addClass("highcharts-scrollable-mask").add(),addEvent$Y(this,"afterShowResetZoom",this.moveFixedElements),addEvent$Y(this,"afterDrilldown",this.moveFixedElements),addEvent$Y(this,"afterLayOutTitles",this.moveFixedElements)):this.fixedRenderer.setSize(this.chartWidth,this.chartHeight),(this.scrollableDirty||g)&&(this.scrollableDirty=!1,this.moveFixedElements()),x=this.chartWidth+(this.scrollablePixelsX||0),S=this.chartHeight+(this.scrollablePixelsY||0),stop(this.container),this.container.style.width=x+"px",this.container.style.height=S+"px",this.renderer.boxWrapper.attr({width:x,height:S,viewBox:[0,0,x,S].join(" ")}),this.chartBackground.attr({width:x,height:S}),this.scrollingContainer.style.height=this.chartHeight+"px",g&&(a.scrollPositionX&&(this.scrollingContainer.scrollLeft=this.scrollablePixelsX*a.scrollPositionX),a.scrollPositionY&&(this.scrollingContainer.scrollTop=this.scrollablePixelsY*a.scrollPositionY));var T=this.axisOffset,P=this.plotTop-T[0]-1,z=this.plotLeft-T[3]-1,L=this.plotTop+this.plotHeight+T[2]+1,N=this.plotLeft+this.plotWidth+T[1]+1,$=this.plotLeft+this.plotWidth-(this.scrollablePixelsX||0),B=this.plotTop+this.plotHeight-(this.scrollablePixelsY||0),U;this.scrollablePixelsX?U=[["M",0,P],["L",this.plotLeft-1,P],["L",this.plotLeft-1,L],["L",0,L],["Z"],["M",$,P],["L",this.chartWidth,P],["L",this.chartWidth,L],["L",$,L],["Z"]]:this.scrollablePixelsY?U=[["M",z,0],["L",z,this.plotTop-1],["L",N,this.plotTop-1],["L",N,0],["Z"],["M",z,B],["L",z,this.chartHeight],["L",N,this.chartHeight],["L",N,B],["Z"]]:U=[["M",0,0]],this.redrawTrigger!=="adjustHeight"&&this.scrollableMask.attr({d:U})};addEvent$Y(Axis,"afterInit",function(){this.chart.scrollableDirty=!0});addEvent$Y(Series$f,"show",function(){this.chart.scrollableDirty=!0});var getDeferredAnimation$2=animationExports.getDeferredAnimation,addEvent$X=Utilities.addEvent,destroyObjectProperties$5=Utilities.destroyObjectProperties,fireEvent$r=Utilities.fireEvent,isNumber$F=Utilities.isNumber,objectEach$n=Utilities.objectEach,StackingAxis;(function(g){var d=[];function a(S){return d.indexOf(S)===-1&&(d.push(S),addEvent$X(S,"init",v),addEvent$X(S,"destroy",u)),S}g.compose=a;function u(){var S=this.stacking;if(S){var T=S.stacks;objectEach$n(T,function(P,z){destroyObjectProperties$5(P),T[z]=null}),S&&S.stackTotalGroup&&S.stackTotalGroup.destroy()}}function v(){var S=this;S.stacking||(S.stacking=new x(S))}var x=(function(){function S(T){this.oldStacks={},this.stacks={},this.stacksTouched=0,this.axis=T}return S.prototype.buildStacks=function(){var T=this,P=T.axis,z=P.series,L=P.options.reversedStacks,N=z.length,$,B;if(!P.isXAxis){for(T.usePercentage=!1,B=N;B--;)$=z[L?B:N-B-1],$.setStackedPoints(),$.setGroupedPoints();for(B=0;B<N;B++)z[B].modifyStacks();fireEvent$r(P,"afterBuildStacks")}},S.prototype.cleanStacks=function(){var T=this,P=T.axis,z;P.isXAxis||(T.oldStacks&&(z=T.stacks=T.oldStacks),objectEach$n(z,function(L){objectEach$n(L,function(N){N.cumulative=N.total})}))},S.prototype.resetStacks=function(){var T=this,P=T.axis,z=T.stacks;P.isXAxis||objectEach$n(z,function(L){objectEach$n(L,function(N,$){isNumber$F(N.touched)&&N.touched<T.stacksTouched?(N.destroy(),delete L[$]):(N.total=null,N.cumulative=null)})})},S.prototype.renderStackTotals=function(){var T=this,P=T.axis,z=P.chart,L=z.renderer,N=T.stacks,$=P.options.stackLabels&&P.options.stackLabels.animation,B=getDeferredAnimation$2(z,$||!1),U=T.stackTotalGroup=T.stackTotalGroup||L.g("stack-labels").attr({visibility:"visible",zIndex:6,opacity:0}).add();U.translate(z.plotLeft,z.plotTop),objectEach$n(N,function(j){objectEach$n(j,function(Y){Y.render(U)})}),U.animate({opacity:1},B)},S})();g.Additions=x})(StackingAxis||(StackingAxis={}));const StackingAxis$1=StackingAxis;var format$a=FormatUtilities.format,correctFloat$9=Utilities.correctFloat,defined$J=Utilities.defined,destroyObjectProperties$4=Utilities.destroyObjectProperties,isArray$h=Utilities.isArray,isNumber$E=Utilities.isNumber,objectEach$m=Utilities.objectEach,pick$1m=Utilities.pick,StackItem=(function(){function g(d,a,u,v,x){var S=d.chart.inverted;this.axis=d,this.isNegative=u,this.options=a=a||{},this.x=v,this.total=null,this.points={},this.hasValidPoints=!1,this.stack=x,this.leftCliff=0,this.rightCliff=0,this.alignOptions={align:a.align||(S?u?"left":"right":"center"),verticalAlign:a.verticalAlign||(S?"middle":u?"bottom":"top"),y:a.y,x:a.x},this.textAlign=a.textAlign||(S?u?"right":"left":"center")}return g.prototype.destroy=function(){destroyObjectProperties$4(this,this.axis)},g.prototype.render=function(d){var a=this.axis.chart,u=this.options,v=u.format,x={},S=v?format$a(v,this,a):u.formatter.call(this);this.label?this.label.attr({text:S,visibility:"hidden"}):(this.label=a.renderer.label(S,null,null,u.shape,null,null,u.useHTML,!1,"stack-labels"),x={r:u.borderRadius||0,text:S,rotation:u.rotation,padding:pick$1m(u.padding,5),visibility:"hidden"},a.styledMode||(x.fill=u.backgroundColor,x.stroke=u.borderColor,x["stroke-width"]=u.borderWidth,this.label.css(u.style)),this.label.attr(x),this.label.added||this.label.add(d)),this.label.labelrank=a.plotSizeY},g.prototype.setOffset=function(d,a,u,v,x){var S=this,T=S.axis,P=T.chart,z=T.translate(T.stacking.usePercentage?100:v||S.total,0,0,0,1),L=T.translate(u||0),N=defined$J(z)&&Math.abs(z-L),$=pick$1m(x,P.xAxis[0].translate(S.x))+d,B=defined$J(z)&&S.getStackBox(P,S,$,z,a,N,T),U=S.label,j=S.isNegative,Y=pick$1m(S.options.overflow,"justify")==="justify",q=S.textAlign,Q;if(U&&B){var J=U.getBBox(),ee=U.padding,ie=void 0,ne=void 0;q==="left"?ie=P.inverted?-ee:ee:q==="right"?ie=J.width:P.inverted&&q==="center"?ie=J.width/2:ie=P.inverted?j?J.width+ee:-ee:J.width/2,ne=P.inverted?J.height/2:j?-ee:J.height,S.alignOptions.x=pick$1m(S.options.x,0),S.alignOptions.y=pick$1m(S.options.y,0),B.x-=ie,B.y-=ne,U.align(S.alignOptions,null,B),P.isInsidePlot(U.alignAttr.x+ie-S.alignOptions.x,U.alignAttr.y+ne-S.alignOptions.y)?U.show():(U.alignAttr.y=-9999,Y=!1),Y&&Series$f.prototype.justifyDataLabel.call(this.axis,U,S.alignOptions,U.alignAttr,J,B),U.attr({x:U.alignAttr.x,y:U.alignAttr.y}),pick$1m(!Y&&S.options.crop,!0)&&(Q=isNumber$E(U.x)&&isNumber$E(U.y)&&P.isInsidePlot(U.x-ee+U.width,U.y)&&P.isInsidePlot(U.x+ee,U.y),Q||U.hide())}},g.prototype.getStackBox=function(d,a,u,v,x,S,T){var P=a.axis.reversed,z=d.inverted,L=T.height+T.pos-(z?d.plotLeft:d.plotTop),N=a.isNegative&&!P||!a.isNegative&&P;return{x:z?N?v-T.right:v-S+T.pos-d.plotLeft:u+d.xAxis[0].transB-d.plotLeft,y:z?T.height-u-x:N?L-v-S:L-v,width:z?S:x,height:z?x:S}},g})();Chart$1.prototype.getStacks=function(){var g=this,d=g.inverted;g.yAxis.forEach(function(a){a.stacking&&a.stacking.stacks&&a.hasVisibleSeries&&(a.stacking.oldStacks=a.stacking.stacks)}),g.series.forEach(function(a){var u=a.xAxis&&a.xAxis.options||{};a.options.stacking&&(a.visible===!0||g.options.chart.ignoreHiddenSeries===!1)&&(a.stackKey=[a.type,pick$1m(a.options.stack,""),d?u.top:u.left,d?u.height:u.width].join(","))})};StackingAxis$1.compose(Axis);Series$f.prototype.setGroupedPoints=function(){var g=this.yAxis.stacking;this.options.centerInCategory&&(this.is("column")||this.is("columnrange"))&&!this.options.stacking&&this.chart.series.length>1?Series$f.prototype.setStackedPoints.call(this,"group"):g&&objectEach$m(g.stacks,function(d,a){a.slice(-5)==="group"&&(objectEach$m(d,function(u){return u.destroy()}),delete g.stacks[a])})};Series$f.prototype.setStackedPoints=function(g){var d=g||this.options.stacking;if(!(!d||this.visible!==!0&&this.chart.options.chart.ignoreHiddenSeries!==!1)){var a=this,u=a.processedXData,v=a.processedYData,x=[],S=v.length,T=a.options,P=T.threshold,z=pick$1m(T.startFromThreshold&&P,0),L=T.stack,N=g?a.type+","+d:a.stackKey,$="-"+N,B=a.negStacks,U=a.yAxis,j=U.stacking.stacks,Y=U.stacking.oldStacks,q,Q,J,ee,ie,ne,ae,de,he;for(U.stacking.stacksTouched+=1,ae=0;ae<S;ae++)de=u[ae],he=v[ae],q=a.getStackIndicator(q,de,a.index),ne=q.key,Q=B&&he<(z?0:P),ie=Q?$:N,j[ie]||(j[ie]={}),j[ie][de]||(Y[ie]&&Y[ie][de]?(j[ie][de]=Y[ie][de],j[ie][de].total=null):j[ie][de]=new StackItem(U,U.options.stackLabels,Q,de,L)),J=j[ie][de],he!==null?(J.points[ne]=J.points[a.index]=[pick$1m(J.cumulative,z)],defined$J(J.cumulative)||(J.base=ne),J.touched=U.stacking.stacksTouched,q.index>0&&a.singleStacks===!1&&(J.points[ne][0]=J.points[a.index+","+de+",0"][0])):J.points[ne]=J.points[a.index]=null,d==="percent"?(ee=Q?N:$,B&&j[ee]&&j[ee][de]?(ee=j[ee][de],J.total=ee.total=Math.max(ee.total,J.total)+Math.abs(he)||0):J.total=correctFloat$9(J.total+(Math.abs(he)||0))):d==="group"?(isArray$h(he)&&(he=he[0]),he!==null&&(J.total=(J.total||0)+1)):J.total=correctFloat$9(J.total+(he||0)),d==="group"?J.cumulative=(J.total||1)-1:J.cumulative=pick$1m(J.cumulative,z)+(he||0),he!==null&&(J.points[ne].push(J.cumulative),x[ae]=J.cumulative,J.hasValidPoints=!0);d==="percent"&&(U.stacking.usePercentage=!0),d!=="group"&&(this.stackedYData=x),U.stacking.oldStacks={}}};Series$f.prototype.modifyStacks=function(){var g=this,d=g.yAxis,a=g.stackKey,u=d.stacking.stacks,v=g.processedXData,x,S=g.options.stacking;g[S+"Stacker"]&&[a,"-"+a].forEach(function(T){for(var P=v.length,z,L,N;P--;)z=v[P],x=g.getStackIndicator(x,z,g.index,T),L=u[T]&&u[T][z],N=L&&L.points[x.key],N&&g[S+"Stacker"](N,L,P)})};Series$f.prototype.percentStacker=function(g,d,a){var u=d.total?100/d.total:0;g[0]=correctFloat$9(g[0]*u),g[1]=correctFloat$9(g[1]*u),this.stackedYData[a]=g[1]};Series$f.prototype.getStackIndicator=function(g,d,a,u){return!defined$J(g)||g.x!==d||u&&g.key!==u?g={x:d,index:0,key:u}:g.index++,g.key=[a,d,g.index].join(","),g};H.StackItem=StackItem;const StackItem$1=H.StackItem;var __extends$2d=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),defined$I=Utilities.defined,merge$1e=Utilities.merge,LineSeries$5=(function(g){__extends$2d(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.drawGraph=function(){var a=this,u=this.options,v=(this.gappedPath||this.getGraphPath).call(this),x=this.chart.styledMode,S=[["graph","highcharts-graph"]];x||S[0].push(u.lineColor||this.color||palette.neutralColor20,u.dashStyle),S=a.getZonesGraphs(S),S.forEach(function(T,P){var z=T[0],L,N=a[z],$=N?"animate":"attr";N?(N.endX=a.preventGraphAnimation?null:v.xMap,N.animate({d:v})):v.length&&(a[z]=N=a.chart.renderer.path(v).addClass(T[1]).attr({zIndex:1}).add(a.group)),N&&!x&&(L={stroke:T[2],"stroke-width":u.lineWidth,fill:a.fillGraph&&a.color||"none"},T[3]?L.dashstyle=T[3]:u.linecap!=="square"&&(L["stroke-linecap"]=L["stroke-linejoin"]="round"),N[$](L).shadow(P<2&&u.shadow)),N&&(N.startX=v.xMap,N.isArea=v.isArea)})},d.prototype.getGraphPath=function(a,u,v){var x=this,S=x.options,T=[],P=[],z,L=S.step;a=a||x.points;var N=a.reversed;return N&&a.reverse(),L={right:1,center:2}[L]||L&&3,L&&N&&(L=4-L),a=this.getValidPoints(a,!1,!(S.connectNulls&&!u&&!v)),a.forEach(function($,B){var U=$.plotX,j=$.plotY,Y=a[B-1],q;($.leftCliff||Y&&Y.rightCliff)&&!v&&(z=!0),$.isNull&&!defined$I(u)&&B>0?z=!S.connectNulls:$.isNull&&!u?z=!0:(B===0||z?q=[["M",$.plotX,$.plotY]]:x.getPointSpline?q=[x.getPointSpline(a,$,B)]:L?(L===1?q=[["L",Y.plotX,j]]:L===2?q=[["L",(Y.plotX+U)/2,Y.plotY],["L",(Y.plotX+U)/2,j]]:q=[["L",U,Y.plotY]],q.push(["L",U,j])):q=[["L",U,j]],P.push($.x),L&&(P.push($.x),L===2&&P.push($.x)),T.push.apply(T,q),z=!1)}),T.xMap=P,x.graphPath=T,T},d.prototype.getZonesGraphs=function(a){return this.zones.forEach(function(u,v){var x=["zone-graph-"+v,"highcharts-graph highcharts-zone-graph-"+v+" "+(u.className||"")];this.chart.styledMode||x.push(u.color||this.color,u.dashStyle||this.options.dashStyle),a.push(x)},this),a},d.defaultOptions=merge$1e(Series$f.defaultOptions,{}),d})(Series$f);SeriesRegistry$1.registerSeriesType("line",LineSeries$5);var __extends$2c=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),color$d=Color.parse,LineSeries$4=SeriesRegistry$1.seriesTypes.line,extend$1j=Utilities.extend,merge$1d=Utilities.merge,objectEach$l=Utilities.objectEach,pick$1l=Utilities.pick,AreaSeries$1=(function(g){__extends$2c(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.drawGraph=function(){this.areaPath=[],g.prototype.drawGraph.apply(this);var a=this,u=this.areaPath,v=this.options,x=this.zones,S=[["area","highcharts-area",this.color,v.fillColor]];x.forEach(function(T,P){S.push(["zone-area-"+P,"highcharts-area highcharts-zone-area-"+P+" "+T.className,T.color||a.color,T.fillColor||v.fillColor])}),S.forEach(function(T){var P=T[0],z=a[P],L=z?"animate":"attr",N={};z?(z.endX=a.preventGraphAnimation?null:u.xMap,z.animate({d:u})):(N.zIndex=0,z=a[P]=a.chart.renderer.path(u).addClass(T[1]).add(a.group),z.isArea=!0),a.chart.styledMode||(N.fill=pick$1l(T[3],color$d(T[2]).setOpacity(pick$1l(v.fillOpacity,.75)).get())),z[L](N),z.startX=u.xMap,z.shiftUnit=v.step?2:1})},d.prototype.getGraphPath=function(a){var u=LineSeries$4.prototype.getGraphPath,v,x=this.options,S=x.stacking,T=this.yAxis,P,z,L=[],N=[],$=this.index,B,U,j,Y=T.stacking.stacks[this.stackKey],q=x.threshold,Q=Math.round(T.getThreshold(x.threshold)),J,ee,ie=pick$1l(x.connectNulls,S==="percent"),ne=function(de,he,pe){var ve=a[de],be=S&&Y[ve.x].points[$],ge=ve[pe+"Null"]||0,_e=ve[pe+"Cliff"]||0,me,xe,Ce=!0;_e||ge?(me=(ge?be[0]:be[1])+_e,xe=be[0]+_e,Ce=!!ge):!S&&a[he]&&a[he].isNull&&(me=xe=q),typeof me<"u"&&(N.push({plotX:j,plotY:me===null?Q:T.getThreshold(me),isNull:Ce,isCliff:!0}),L.push({plotX:j,plotY:xe===null?Q:T.getThreshold(xe),doCurve:!1}))};for(a=a||this.points,S&&(a=this.getStackPoints(a)),B=0;B<a.length;B++)S||(a[B].leftCliff=a[B].rightCliff=a[B].leftNull=a[B].rightNull=void 0),J=a[B].isNull,j=pick$1l(a[B].rectPlotX,a[B].plotX),ee=S?pick$1l(a[B].yBottom,Q):Q,(!J||ie)&&(ie||ne(B,B-1,"left"),J&&!S&&ie||(N.push(a[B]),L.push({x:B,plotX:j,plotY:ee})),ie||ne(B,B+1,"right"));P=u.call(this,N,!0,!0),L.reversed=!0,z=u.call(this,L,!0,!0);var ae=z[0];return ae&&ae[0]==="M"&&(z[0]=["L",ae[1],ae[2]]),U=P.concat(z),U.length&&U.push(["Z"]),v=u.call(this,N,!1,ie),U.xMap=P.xMap,this.areaPath=U,v},d.prototype.getStackPoints=function(a){var u=this,v=[],x=[],S=this.xAxis,T=this.yAxis,P=T.stacking.stacks[this.stackKey],z={},L=T.series,N=L.length,$=T.options.reversedStacks?1:-1,B=L.indexOf(u);if(a=a||this.points,this.options.stacking){for(var U=0;U<a.length;U++)a[U].leftNull=a[U].rightNull=void 0,z[a[U].x]=a[U];objectEach$l(P,function(Y,q){Y.total!==null&&x.push(q)}),x.sort(function(Y,q){return Y-q});var j=L.map(function(Y){return Y.visible});x.forEach(function(Y,q){var Q=0,J,ee;if(z[Y]&&!z[Y].isNull)v.push(z[Y]),[-1,1].forEach(function(ae){var de=ae===1?"rightNull":"leftNull",he=ae===1?"rightCliff":"leftCliff",pe=0,ve=P[x[q+ae]];if(ve)for(var be=B;be>=0&&be<N;){var ge=L[be].index;J=ve.points[ge],J||(ge===u.index?z[Y][de]=!0:j[be]&&(ee=P[Y].points[ge],ee&&(pe-=ee[1]-ee[0]))),be+=$}z[Y][he]=pe});else{for(var ie=B;ie>=0&&ie<N;){var ne=L[ie].index;if(J=P[Y].points[ne],J){Q=J[1];break}ie+=$}Q=pick$1l(Q,0),Q=T.translate(Q,0,1,0,1),v.push({isNull:!0,plotX:S.translate(Y,0,0,0,1),x:Y,plotY:Q,yBottom:Q})}})}return v},d.defaultOptions=merge$1d(LineSeries$4.defaultOptions,{threshold:0}),d})(LineSeries$4);extend$1j(AreaSeries$1.prototype,{singleStacks:!1,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("area",AreaSeries$1);var __extends$2b=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),LineSeries$3=SeriesRegistry$1.seriesTypes.line,merge$1c=Utilities.merge,pick$1k=Utilities.pick,SplineSeries$1=(function(g){__extends$2b(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.getPointSpline=function(a,u,v){var x=1.5,S=x+1,T=u.plotX||0,P=u.plotY||0,z=a[v-1],L=a[v+1],N,$,B,U,j;function Y(ne){return ne&&!ne.isNull&&ne.doCurve!==!1&&!u.isCliff}if(Y(z)&&Y(L)){var q=z.plotX||0,Q=z.plotY||0,J=L.plotX||0,ee=L.plotY||0,ie=0;N=(x*T+q)/S,$=(x*P+Q)/S,B=(x*T+J)/S,U=(x*P+ee)/S,B!==N&&(ie=(U-$)*(B-T)/(B-N)+P-U),$+=ie,U+=ie,$>Q&&$>P?($=Math.max(Q,P),U=2*P-$):$<Q&&$<P&&($=Math.min(Q,P),U=2*P-$),U>ee&&U>P?(U=Math.max(ee,P),$=2*P-U):U<ee&&U<P&&(U=Math.min(ee,P),$=2*P-U),u.rightContX=B,u.rightContY=U}return j=["C",pick$1k(z.rightContX,z.plotX,0),pick$1k(z.rightContY,z.plotY,0),pick$1k(N,T,0),pick$1k($,P,0),T,P],z.rightContX=z.rightContY=void 0,j},d.defaultOptions=merge$1c(LineSeries$3.defaultOptions),d})(LineSeries$3);SeriesRegistry$1.registerSeriesType("spline",SplineSeries$1);var __extends$2a=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),areaProto$1=AreaSeries$1.prototype,extend$1i=Utilities.extend,merge$1b=Utilities.merge,AreaSplineSeries=(function(g){__extends$2a(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.points=void 0,a.options=void 0,a}return d.defaultOptions=merge$1b(SplineSeries$1.defaultOptions,AreaSeries$1.defaultOptions),d})(SplineSeries$1);extend$1i(AreaSplineSeries.prototype,{getGraphPath:areaProto$1.getGraphPath,getStackPoints:areaProto$1.getStackPoints,drawGraph:areaProto$1.drawGraph,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("areaspline",AreaSplineSeries);var __extends$29=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),animObject$6=animationExports.animObject,color$c=Color.parse,hasTouch$1=H.hasTouch,noop$g=H.noop,clamp$f=Utilities.clamp,css$4=Utilities.css,defined$H=Utilities.defined,extend$1h=Utilities.extend,fireEvent$q=Utilities.fireEvent,isArray$g=Utilities.isArray,isNumber$D=Utilities.isNumber,merge$1a=Utilities.merge,pick$1j=Utilities.pick,objectEach$k=Utilities.objectEach,ColumnSeries$h=(function(g){__extends$29(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.borderWidth=void 0,a.data=void 0,a.group=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.animate=function(a){var u=this,v=this.yAxis,x=u.options,S=this.chart.inverted,T={},P=S?"translateX":"translateY",z,L;a?(T.scaleY=.001,L=clamp$f(v.toPixels(x.threshold),v.pos,v.pos+v.len),S?T.translateX=L-v.len:T.translateY=L,u.clipBox&&u.setClip(),u.group.attr(T)):(z=Number(u.group.attr(P)),u.group.animate({scaleY:1},extend$1h(animObject$6(u.options.animation),{step:function(N,$){u.group&&(T[P]=z+$.pos*(v.pos-z),u.group.attr(T))}})))},d.prototype.init=function(a,u){g.prototype.init.apply(this,arguments);var v=this;a=v.chart,a.hasRendered&&a.series.forEach(function(x){x.type===v.type&&(x.isDirty=!0)})},d.prototype.getColumnMetrics=function(){var a=this,u=a.options,v=a.xAxis,x=a.yAxis,S=v.options.reversedStacks,T=v.reversed&&!S||!v.reversed&&S,P={},z,L=0;u.grouping===!1?L=1:a.chart.series.forEach(function(J){var ee=J.yAxis,ie=J.options,ne;J.type===a.type&&(J.visible||!a.chart.options.chart.ignoreHiddenSeries)&&x.len===ee.len&&x.pos===ee.pos&&(ie.stacking&&ie.stacking!=="group"?(z=J.stackKey,typeof P[z]>"u"&&(P[z]=L++),ne=P[z]):ie.grouping!==!1&&(ne=L++),J.columnIndex=ne)});var N=Math.min(Math.abs(v.transA)*(v.ordinal&&v.ordinal.slope||u.pointRange||v.closestPointRange||v.tickInterval||1),v.len),$=N*u.groupPadding,B=N-2*$,U=B/(L||1),j=Math.min(u.maxPointWidth||v.len,pick$1j(u.pointWidth,U*(1-2*u.pointPadding))),Y=(U-j)/2,q=(a.columnIndex||0)+(T?1:0),Q=Y+($+q*U-N/2)*(T?-1:1);return a.columnMetrics={width:j,offset:Q,paddedWidth:U,columnCount:L},a.columnMetrics},d.prototype.crispCol=function(a,u,v,x){var S=this.chart,T=this.borderWidth,P=-(T%2?.5:0),z,L=T%2?.5:1;S.inverted&&S.renderer.isVML&&(L+=1),this.options.crisp&&(z=Math.round(a+v)+P,a=Math.round(a)+P,v=z-a);var N=Math.round(u+x)+L,$=Math.abs(u)<=.5&&N>.5;return u=Math.round(u)+L,x=N-u,$&&x&&(u-=1,x+=1),{x:a,y:u,width:v,height:x}},d.prototype.adjustForMissingColumns=function(a,u,v,x){var S=this,T=this.options.stacking;if(!v.isNull&&x.columnCount>1){var P=0,z=0;objectEach$k(this.yAxis.stacking&&this.yAxis.stacking.stacks,function(N){if(typeof v.x=="number"){var $=N[v.x.toString()];if($){var B=$.points[S.index],U=$.total;T?(B&&(P=z),$.hasValidPoints&&z++):isArray$g(B)&&(P=B[1],z=U||0)}}});var L=(z-1)*x.paddedWidth+u;a=(v.plotX||0)+L/2-u-P*x.paddedWidth}return a},d.prototype.translate=function(){var a=this,u=a.chart,v=a.options,x=a.dense=a.closestPointRange*a.xAxis.transA<2,S=a.borderWidth=pick$1j(v.borderWidth,x?0:1),T=a.xAxis,P=a.yAxis,z=v.threshold,L=a.translatedThreshold=P.getThreshold(z),N=pick$1j(v.minPointLength,5),$=a.getColumnMetrics(),B=$.width,U=a.pointXOffset=$.offset,j=a.dataMin,Y=a.dataMax,q=a.barW=Math.max(B,1+2*S);u.inverted&&(L-=.5),v.pointPadding&&(q=Math.ceil(q)),Series$f.prototype.translate.apply(a),a.points.forEach(function(Q){var J=pick$1j(Q.yBottom,L),ee=999+Math.abs(J),ie=Q.plotX||0,ne=clamp$f(Q.plotY,-ee,P.len+ee),ae,de=Math.min(ne,J),he=Math.max(ne,J)-de,pe=B,ve=ie+U,be=q;N&&Math.abs(he)<N&&(he=N,ae=!P.reversed&&!Q.negative||P.reversed&&Q.negative,isNumber$D(z)&&isNumber$D(Y)&&Q.y===z&&Y<=z&&(P.min||0)<z&&(j!==Y||(P.max||0)<=z)&&(ae=!ae),de=Math.abs(de-L)>N?J-N:L-(ae?N:0)),defined$H(Q.options.pointWidth)&&(pe=be=Math.ceil(Q.options.pointWidth),ve-=Math.round((pe-B)/2)),v.centerInCategory&&(ve=a.adjustForMissingColumns(ve,pe,Q,$)),Q.barX=ve,Q.pointWidth=pe,Q.tooltipPos=u.inverted?[clamp$f(P.len+P.pos-u.plotLeft-ne,P.pos-u.plotLeft,P.len+P.pos-u.plotLeft),T.len+T.pos-u.plotTop-ve-be/2,he]:[T.left-u.plotLeft+ve+be/2,clamp$f(ne+P.pos-u.plotTop,P.pos-u.plotTop,P.len+P.pos-u.plotTop),he],Q.shapeType=a.pointClass.prototype.shapeType||"rect",Q.shapeArgs=a.crispCol.apply(a,Q.isNull?[ve,L,be,0]:[ve,de,be,he])})},d.prototype.drawGraph=function(){this.group[this.dense?"addClass":"removeClass"]("highcharts-dense-data")},d.prototype.pointAttribs=function(a,u){var v=this.options,x=this.pointAttrToOptions||{},S=x.stroke||"borderColor",T=x["stroke-width"]||"borderWidth",P,z,L,N=a&&a.color||this.color,$=a&&a[S]||v[S]||N,B=a&&a.options.dashStyle||v.dashStyle,U=a&&a[T]||v[T]||this[T]||0,j=pick$1j(a&&a.opacity,v.opacity,1);a&&this.zones.length&&(z=a.getZone(),N=a.options.color||z&&(z.color||a.nonZonedColor)||this.color,z&&($=z.borderColor||$,B=z.dashStyle||B,U=z.borderWidth||U)),u&&a&&(P=merge$1a(v.states[u],a.options.states&&a.options.states[u]||{}),L=P.brightness,N=P.color||typeof L<"u"&&color$c(N).brighten(P.brightness).get()||N,$=P[S]||$,U=P[T]||U,B=P.dashStyle||B,j=pick$1j(P.opacity,j));var Y={fill:N,stroke:$,"stroke-width":U,opacity:j};return B&&(Y.dashstyle=B),Y},d.prototype.drawPoints=function(){var a=this,u=this.chart,v=a.options,x=u.renderer,S=v.animationLimit||250,T;a.points.forEach(function(P){var z=P.plotY,L=P.graphic,N=!!L,$=L&&u.pointCount<S?"animate":"attr";isNumber$D(z)&&P.y!==null?(T=P.shapeArgs,L&&P.hasNewShapeType()&&(L=L.destroy()),a.enabledDataSorting&&(P.startXPos=a.xAxis.reversed?-(T&&T.width||0):a.xAxis.width),L||(P.graphic=L=x[P.shapeType](T).add(P.group||a.group),L&&a.enabledDataSorting&&u.hasRendered&&u.pointCount<S&&(L.attr({x:P.startXPos}),N=!0,$="animate")),L&&N&&L[$](merge$1a(T)),v.borderRadius&&L[$]({r:v.borderRadius}),u.styledMode||L[$](a.pointAttribs(P,P.selected&&"select")).shadow(P.allowShadow!==!1&&v.shadow,null,v.stacking&&!v.borderRadius),L&&(L.addClass(P.getClassName(),!0),L.attr({visibility:P.visible?"inherit":"hidden"}))):L&&(P.graphic=L.destroy())})},d.prototype.drawTracker=function(){var a=this,u=a.chart,v=u.pointer,x=function(T){var P=v.getPointFromEvent(T);typeof P<"u"&&(v.isDirectTouch=!0,P.onMouseOver(T))},S;a.points.forEach(function(T){S=isArray$g(T.dataLabels)?T.dataLabels:T.dataLabel?[T.dataLabel]:[],T.graphic&&(T.graphic.element.point=T),S.forEach(function(P){P.div?P.div.point=T:P.element.point=T})}),a._hasTracking||(a.trackerGroups.forEach(function(T){a[T]&&(a[T].addClass("highcharts-tracker").on("mouseover",x).on("mouseout",function(P){v.onTrackerMouseOut(P)}),hasTouch$1&&a[T].on("touchstart",x),!u.styledMode&&a.options.cursor&&a[T].css(css$4).css({cursor:a.options.cursor}))}),a._hasTracking=!0),fireEvent$q(this,"afterDrawTracker")},d.prototype.remove=function(){var a=this,u=a.chart;u.hasRendered&&u.series.forEach(function(v){v.type===a.type&&(v.isDirty=!0)}),Series$f.prototype.remove.apply(a,arguments)},d.defaultOptions=merge$1a(Series$f.defaultOptions,{borderRadius:0,centerInCategory:!1,groupPadding:.2,marker:null,pointPadding:.1,minPointLength:0,cropThreshold:50,pointRange:null,states:{hover:{halo:!1,brightness:.1},select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}},dataLabels:{align:void 0,verticalAlign:void 0,y:void 0},startFromThreshold:!0,stickyTracking:!1,tooltip:{distance:6},threshold:0,borderColor:palette.backgroundColor}),d})(Series$f);extend$1h(ColumnSeries$h.prototype,{cropShoulder:0,directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getSymbol:noop$g,negStacks:!0,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("column",ColumnSeries$h);var getDeferredAnimation$1=animationExports.getDeferredAnimation,format$9=FormatUtilities.format,defined$G=Utilities.defined,extend$1g=Utilities.extend,fireEvent$p=Utilities.fireEvent,isArray$f=Utilities.isArray,merge$19=Utilities.merge,objectEach$j=Utilities.objectEach,pick$1i=Utilities.pick,splat$d=Utilities.splat,DataLabel;(function(g){var d=[];function a(z,L,N,$,B){var U=this,j=this.chart,Y=this.isCartesian&&j.inverted,q=this.enabledDataSorting,Q=pick$1i(z.dlBox&&z.dlBox.centerX,z.plotX,-9999),J=pick$1i(z.plotY,-9999),ee=L.getBBox(),ie=N.rotation,ne=N.align,ae=j.isInsidePlot(Q,Math.round(J),{inverted:Y,paneCoordinates:!0,series:U}),de=function(xe){q&&U.xAxis&&!_e&&U.setDataLabelStartPos(z,L,B,ae,xe)},he,pe,ve,be,ge,_e=pick$1i(N.overflow,q?"none":"justify")==="justify",me=this.visible&&z.visible!==!1&&(z.series.forceDL||q&&!_e||ae||pick$1i(N.inside,!!this.options.stacking)&&$&&j.isInsidePlot(Q,Y?$.x+1:$.y+$.height-1,{inverted:Y,paneCoordinates:!0,series:U}));me&&(he=j.renderer.fontMetrics(j.styledMode?void 0:N.style.fontSize,L).b,$=extend$1g({x:Y?this.yAxis.len-J:Q,y:Math.round(Y?this.xAxis.len-Q:J),width:0,height:0},$),extend$1g(N,{width:ee.width,height:ee.height}),ie?(_e=!1,be=j.renderer.rotCorr(he,ie),ge={x:$.x+(N.x||0)+$.width/2+be.x,y:$.y+(N.y||0)+{top:0,middle:.5,bottom:1}[N.verticalAlign]*$.height},de(ge),L[B?"attr":"animate"](ge).attr({align:ne}),pe=(ie+720)%360,ve=pe>180&&pe<360,ne==="left"?ge.y-=ve?ee.height:0:ne==="center"?(ge.x-=ee.width/2,ge.y-=ee.height/2):ne==="right"&&(ge.x-=ee.width,ge.y-=ve?0:ee.height),L.placed=!0,L.alignAttr=ge):(de($),L.align(N,void 0,$),ge=L.alignAttr),_e&&$.height>=0?this.justifyDataLabel(L,N,ge,ee,$,B):pick$1i(N.crop,!0)&&(me=j.isInsidePlot(ge.x,ge.y,{paneCoordinates:!0,series:U})&&j.isInsidePlot(ge.x+ee.width,ge.y+ee.height,{paneCoordinates:!0,series:U})),N.shape&&!ie&&L[B?"attr":"animate"]({anchorX:Y?j.plotWidth-z.plotY:z.plotX,anchorY:Y?j.plotHeight-z.plotX:z.plotY})),B&&q&&(L.placed=!1),!me&&(!q||_e)&&(L.hide(!0),L.placed=!1)}function u(z,L){var N=L.filter;if(N){var $=N.operator,B=z[N.property],U=N.value;return $===">"&&B>U||$==="<"&&B<U||$===">="&&B>=U||$==="<="&&B<=U||$==="=="&&B==U||$==="==="&&B===U}return!0}function v(z){if(d.indexOf(z)===-1){var L=z.prototype;d.push(z),L.alignDataLabel=a,L.drawDataLabels=x,L.justifyDataLabel=S,L.setDataLabelStartPos=P}}g.compose=v;function x(){var z=this,L=z.chart,N=z.options,$=z.points,B=z.hasRendered||0,U=L.renderer,j=N.dataLabels,Y,q,Q=j.animation,J=j.defer?getDeferredAnimation$1(L,Q,z):{defer:0,duration:0};if(j=T(T(L.options.plotOptions&&L.options.plotOptions.series&&L.options.plotOptions.series.dataLabels,L.options.plotOptions&&L.options.plotOptions[z.type]&&L.options.plotOptions[z.type].dataLabels),j),fireEvent$p(this,"drawDataLabels"),isArray$f(j)||j.enabled||z._hasPointLabels){if(q=z.plotGroup("dataLabelsGroup","data-labels",B?"inherit":"hidden",j.zIndex||6),q.attr({opacity:+B}),!B){var ee=z.dataLabelsGroup;ee&&(z.visible&&q.show(!0),ee[N.animation?"animate":"attr"]({opacity:1},J))}$.forEach(function(ie){Y=splat$d(T(j,ie.dlOptions||ie.options&&ie.options.dataLabels)),Y.forEach(function(ne,ae){var de=ne.enabled&&(!ie.isNull||ie.dataLabelOnNull)&&u(ie,ne),he=ie.connectors?ie.connectors[ae]:ie.connector,pe,ve,be,ge,_e,me,xe=ie.dataLabels?ie.dataLabels[ae]:ie.dataLabel,Ce=pick$1i(ne.distance,ie.labelDistance),Me=!xe;de&&(pe=ie.getLabelConfig(),ve=pick$1i(ne[ie.formatPrefix+"Format"],ne.format),be=defined$G(ve)?format$9(ve,pe,L):(ne[ie.formatPrefix+"Formatter"]||ne.formatter).call(pe,ne),ge=ne.style,_e=ne.rotation,L.styledMode||(ge.color=pick$1i(ne.color,ge.color,z.color,palette.neutralColor100),ge.color==="contrast"?(ie.contrastColor=U.getContrast(ie.color||z.color),ge.color=!defined$G(Ce)&&ne.inside||Ce<0||N.stacking?ie.contrastColor:palette.neutralColor100):delete ie.contrastColor,N.cursor&&(ge.cursor=N.cursor)),me={r:ne.borderRadius||0,rotation:_e,padding:ne.padding,zIndex:1},L.styledMode||(me.fill=ne.backgroundColor,me.stroke=ne.borderColor,me["stroke-width"]=ne.borderWidth),objectEach$j(me,function(Re,Ue){typeof Re>"u"&&delete me[Ue]})),xe&&(!de||!defined$G(be))?(ie.dataLabel=ie.dataLabel&&ie.dataLabel.destroy(),ie.dataLabels&&(ie.dataLabels.length===1?delete ie.dataLabels:delete ie.dataLabels[ae]),ae||delete ie.dataLabel,he&&(ie.connector=ie.connector.destroy(),ie.connectors&&(ie.connectors.length===1?delete ie.connectors:delete ie.connectors[ae]))):de&&defined$G(be)&&(xe?me.text=be:(ie.dataLabels=ie.dataLabels||[],xe=ie.dataLabels[ae]=_e?U.text(be,0,-9999,ne.useHTML).addClass("highcharts-data-label"):U.label(be,0,-9999,ne.shape,null,null,ne.useHTML,null,"data-label"),ae||(ie.dataLabel=xe),xe.addClass(" highcharts-data-label-color-"+ie.colorIndex+" "+(ne.className||"")+(ne.useHTML?" highcharts-tracker":""))),xe.options=ne,xe.attr(me),L.styledMode||xe.css(ge).shadow(ne.shadow),xe.added||xe.add(q),ne.textPath&&!ne.useHTML&&(xe.setTextPath(ie.getDataLabelPath&&ie.getDataLabelPath(xe)||ie.graphic,ne.textPath),ie.dataLabelPath&&!ne.textPath.enabled&&(ie.dataLabelPath=ie.dataLabelPath.destroy())),z.alignDataLabel(ie,xe,ne,null,Me))})})}fireEvent$p(this,"afterDrawDataLabels")}function S(z,L,N,$,B,U){var j=this.chart,Y=L.align,q=L.verticalAlign,Q=z.box?0:z.padding||0,J=L.x,ee=J===void 0?0:J,ie=L.y,ne=ie===void 0?0:ie,ae,de;return ae=(N.x||0)+Q,ae<0&&(Y==="right"&&ee>=0?(L.align="left",L.inside=!0):ee-=ae,de=!0),ae=(N.x||0)+$.width-Q,ae>j.plotWidth&&(Y==="left"&&ee<=0?(L.align="right",L.inside=!0):ee+=j.plotWidth-ae,de=!0),ae=N.y+Q,ae<0&&(q==="bottom"&&ne>=0?(L.verticalAlign="top",L.inside=!0):ne-=ae,de=!0),ae=(N.y||0)+$.height-Q,ae>j.plotHeight&&(q==="top"&&ne<=0?(L.verticalAlign="bottom",L.inside=!0):ne+=j.plotHeight-ae,de=!0),de&&(L.x=ee,L.y=ne,z.placed=!U,z.align(L,void 0,B)),de}function T(z,L){var N=[],$;if(isArray$f(z)&&!isArray$f(L))N=z.map(function(B){return merge$19(B,L)});else if(isArray$f(L)&&!isArray$f(z))N=L.map(function(B){return merge$19(z,B)});else if(!isArray$f(z)&&!isArray$f(L))N=merge$19(z,L);else for($=Math.max(z.length,L.length);$--;)N[$]=merge$19(z[$],L[$]);return N}function P(z,L,N,$,B){var U=this.chart,j=U.inverted,Y=this.xAxis,q=Y.reversed,Q=j?L.height/2:L.width/2,J=z.pointWidth,ee=J?J/2:0;L.startXPos=j?B.x:q?-Q-ee:Y.width-Q+ee,L.startYPos=j?q?this.yAxis.height-Q+ee:-Q-ee:B.y,$?L.visibility==="hidden"&&(L.show(),L.attr({opacity:0}).animate({opacity:1})):L.attr({opacity:1}).animate({opacity:0},void 0,L.hide),U.hasRendered&&(N&&L.attr({x:L.startXPos,y:L.startYPos}),L.placed=!0)}})(DataLabel||(DataLabel={}));const DataLabel$1=DataLabel;var Series$e=SeriesRegistry$1.series,merge$18=Utilities.merge,pick$1h=Utilities.pick,ColumnDataLabel$1;(function(g){var d=[];function a(v,x,S,T,P){var z=this.chart.inverted,L=v.series,N=v.dlBox||v.shapeArgs,$=pick$1h(v.below,v.plotY>pick$1h(this.translatedThreshold,L.yAxis.len)),B=pick$1h(S.inside,!!this.options.stacking),U;N&&(T=merge$18(N),T.y<0&&(T.height+=T.y,T.y=0),U=T.y+T.height-L.yAxis.len,U>0&&U<T.height&&(T.height-=U),z&&(T={x:L.yAxis.len-T.y-T.height,y:L.xAxis.len-T.x-T.width,width:T.height,height:T.width}),B||(z?(T.x+=$?0:T.width,T.width=0):(T.y+=$?T.height:0,T.height=0))),S.align=pick$1h(S.align,!z||B?"center":$?"right":"left"),S.verticalAlign=pick$1h(S.verticalAlign,z||B?"middle":$?"top":"bottom"),Series$e.prototype.alignDataLabel.call(this,v,x,S,T,P),S.inside&&v.contrastColor&&x.css({color:v.contrastColor})}function u(v){DataLabel$1.compose(Series$e),d.indexOf(v)===-1&&(d.push(v),v.prototype.alignDataLabel=a)}g.compose=u})(ColumnDataLabel$1||(ColumnDataLabel$1={}));const ColumnDataLabel$2=ColumnDataLabel$1;var __extends$28=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),extend$1f=Utilities.extend,merge$17=Utilities.merge,BarSeries=(function(g){__extends$28(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.defaultOptions=merge$17(ColumnSeries$h.defaultOptions,{}),d})(ColumnSeries$h);extend$1f(BarSeries.prototype,{inverted:!0});SeriesRegistry$1.registerSeriesType("bar",BarSeries);var __extends$27=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),addEvent$W=Utilities.addEvent,extend$1e=Utilities.extend,merge$16=Utilities.merge,ScatterSeries$4=(function(g){__extends$27(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.applyJitter=function(){var a=this,u=this.options.jitter,v=this.points.length;function x(S){var T=Math.sin(S)*1e4;return T-Math.floor(T)}u&&this.points.forEach(function(S,T){["x","y"].forEach(function(P,z){var L,N="plot"+P.toUpperCase(),$,B,U;u[P]&&!S.isNull&&(L=a[P+"Axis"],U=u[P]*L.transA,L&&!L.isLog&&($=Math.max(0,S[N]-U),B=Math.min(L.len,S[N]+U),S[N]=$+(B-$)*x(T+z*v),P==="x"&&(S.clientX=S.plotX)))})})},d.prototype.drawGraph=function(){this.options.lineWidth?g.prototype.drawGraph.call(this):this.graph&&(this.graph=this.graph.destroy())},d.defaultOptions=merge$16(LineSeries$5.defaultOptions,{lineWidth:0,findNearestPointBy:"xy",jitter:{x:0,y:0},marker:{enabled:!0},tooltip:{headerFormat:'<span style="color:{point.color}">●</span> <span style="font-size: 10px"> {series.name}</span><br/>',pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>"}}),d})(LineSeries$5);extend$1e(ScatterSeries$4.prototype,{drawTracker:ColumnSeries$h.prototype.drawTracker,sorted:!1,requireSorting:!1,noSharedTooltip:!0,trackerGroups:["group","markerGroup","dataLabelsGroup"],takeOrdinalPosition:!1});addEvent$W(ScatterSeries$4,"afterTranslate",function(){this.applyJitter()});SeriesRegistry$1.registerSeriesType("scatter",ScatterSeries$4);var isNumber$C=Utilities.isNumber,pick$1g=Utilities.pick,relativeLength$6=Utilities.relativeLength,deg2rad$5=H.deg2rad,centeredSeriesMixin=H.CenteredSeriesMixin={getCenter:function(){var g=this.options,d=this.chart,a=2*(g.slicedOffset||0),u,v=d.plotWidth-2*a,x=d.plotHeight-2*a,S=g.center,T=Math.min(v,x),P=g.size,z=g.innerSize||0,L,N,$;for(typeof P=="string"&&(P=parseFloat(P)),typeof z=="string"&&(z=parseFloat(z)),L=[pick$1g(S[0],"50%"),pick$1g(S[1],"50%"),pick$1g(P&&P<0?void 0:g.size,"100%"),pick$1g(z&&z<0?void 0:g.innerSize||0,"0%")],d.angular&&!(this instanceof Series$f)&&(L[3]=0),N=0;N<4;++N)$=L[N],u=N<2||N===2&&/%$/.test($),L[N]=relativeLength$6($,[v,x,T,L[2]][N])+(u?a:0);return L[3]>L[2]&&(L[3]=L[2]),L},getStartAndEndRadians:function(g,d){var a=isNumber$C(g)?g:0,u=isNumber$C(d)&&d>a&&d-a<360?d:a+360,v=-90;return{start:deg2rad$5*(a+v),end:deg2rad$5*(u+v)}}},__extends$26=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),setAnimation$1=animationExports.setAnimation,addEvent$V=Utilities.addEvent,defined$F=Utilities.defined,extend$1d=Utilities.extend,isNumber$B=Utilities.isNumber,pick$1f=Utilities.pick,relativeLength$5=Utilities.relativeLength,PiePoint$3=(function(g){__extends$26(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.labelDistance=void 0,a.options=void 0,a.series=void 0,a}return d.prototype.getConnectorPath=function(){var a=this.labelPosition,u=this.series.options.dataLabels,v=this.connectorShapes,x=u.connectorShape;return v[x]&&(x=v[x]),x.call(this,{x:a.final.x,y:a.final.y,alignment:a.alignment},a.connectorPosition,u)},d.prototype.getTranslate=function(){return this.sliced?this.slicedTranslation:{translateX:0,translateY:0}},d.prototype.haloPath=function(a){var u=this.shapeArgs;return this.sliced||!this.visible?[]:this.series.chart.renderer.symbols.arc(u.x,u.y,u.r+a,u.r+a,{innerR:u.r-1,start:u.start,end:u.end})},d.prototype.init=function(){var a=this;g.prototype.init.apply(this,arguments),this.name=pick$1f(this.name,"Slice");var u=function(v){a.slice(v.type==="select")};return addEvent$V(this,"select",u),addEvent$V(this,"unselect",u),this},d.prototype.isValid=function(){return isNumber$B(this.y)&&this.y>=0},d.prototype.setVisible=function(a,u){var v=this,x=this.series,S=x.chart,T=x.options.ignoreHiddenPoint;u=pick$1f(u,T),a!==this.visible&&(this.visible=this.options.visible=a=typeof a>"u"?!this.visible:a,x.options.data[x.data.indexOf(this)]=this.options,["graphic","dataLabel","connector","shadowGroup"].forEach(function(P){v[P]&&v[P][a?"show":"hide"](a)}),this.legendItem&&S.legend.colorizeItem(this,a),!a&&this.state==="hover"&&this.setState(""),T&&(x.isDirty=!0),u&&S.redraw())},d.prototype.slice=function(a,u,v){var x=this.series,S=x.chart;setAnimation$1(v,S),u=pick$1f(u,!0),this.sliced=this.options.sliced=a=defined$F(a)?a:!this.sliced,x.options.data[x.data.indexOf(this)]=this.options,this.graphic&&this.graphic.animate(this.getTranslate()),this.shadowGroup&&this.shadowGroup.animate(this.getTranslate())},d})(Point$4);extend$1d(PiePoint$3.prototype,{connectorShapes:{fixedOffset:function(g,d,a){var u=d.breakAt,v=d.touchingSliceAt,x=a.softConnector?["C",g.x+(g.alignment==="left"?-5:5),g.y,2*u.x-v.x,2*u.y-v.y,u.x,u.y]:["L",u.x,u.y];return[["M",g.x,g.y],x,["L",v.x,v.y]]},straight:function(g,d){var a=d.touchingSliceAt;return[["M",g.x,g.y],["L",a.x,a.y]]},crookedLine:function(g,d,a){var u=d.touchingSliceAt,v=this.series,x=v.center[0],S=v.chart.plotWidth,T=v.chart.plotLeft,P=g.alignment,z=this.shapeArgs.r,L=relativeLength$5(a.crookDistance,1),N=P==="left"?x+z+(S+T-x-z)*(1-L):T+(x-z)*L,$=["L",N,g.y],B=!0;(P==="left"?N>g.x||N<u.x:N<g.x||N>u.x)&&(B=!1);var U=[["M",g.x,g.y]];return B&&U.push($),U.push(["L",u.x,u.y]),U}}});var __extends$25=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),getStartAndEndRadians=centeredSeriesMixin.getStartAndEndRadians,noop$f=H.noop,clamp$e=Utilities.clamp,extend$1c=Utilities.extend,fireEvent$o=Utilities.fireEvent,merge$15=Utilities.merge,pick$1e=Utilities.pick,relativeLength$4=Utilities.relativeLength,PieSeries$3=(function(g){__extends$25(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.center=void 0,a.data=void 0,a.maxLabelDistance=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.animate=function(a){var u=this,v=u.points,x=u.startAngleRad;a||v.forEach(function(S){var T=S.graphic,P=S.shapeArgs;T&&P&&(T.attr({r:pick$1e(S.startR,u.center&&u.center[3]/2),start:x,end:x}),T.animate({r:P.r,start:P.start,end:P.end},u.options.animation))})},d.prototype.drawEmpty=function(){var a=this.startAngleRad,u=this.endAngleRad,v=this.options,x,S;this.total===0&&this.center?(x=this.center[0],S=this.center[1],this.graph||(this.graph=this.chart.renderer.arc(x,S,this.center[1]/2,0,a,u).addClass("highcharts-empty-series").add(this.group)),this.graph.attr({d:Symbols.arc(x,S,this.center[2]/2,0,{start:a,end:u,innerR:this.center[3]/2})}),this.chart.styledMode||this.graph.attr({"stroke-width":v.borderWidth,fill:v.fillColor||"none",stroke:v.color||palette.neutralColor20})):this.graph&&(this.graph=this.graph.destroy())},d.prototype.drawPoints=function(){var a=this.chart.renderer;this.points.forEach(function(u){u.graphic&&u.hasNewShapeType()&&(u.graphic=u.graphic.destroy()),u.graphic||(u.graphic=a[u.shapeType](u.shapeArgs).add(u.series.group),u.delayedRendering=!0)})},d.prototype.generatePoints=function(){g.prototype.generatePoints.call(this),this.updateTotals()},d.prototype.getX=function(a,u,v){var x=this.center,S=this.radii?this.radii[v.index]||0:x[2]/2,T=Math.asin(clamp$e((a-x[1])/(S+v.labelDistance),-1,1)),P=x[0]+(u?-1:1)*(Math.cos(T)*(S+v.labelDistance))+(v.labelDistance>0?(u?-1:1)*this.options.dataLabels.padding:0);return P},d.prototype.hasData=function(){return!!this.processedXData.length},d.prototype.redrawPoints=function(){var a=this,u=a.chart,v=u.renderer,x=a.options.shadow,S,T,P,z;this.drawEmpty(),x&&!a.shadowGroup&&!u.styledMode&&(a.shadowGroup=v.g("shadow").attr({zIndex:-1}).add(a.group)),a.points.forEach(function(L){var N={};if(T=L.graphic,!L.isNull&&T){var $=void 0;z=L.shapeArgs,S=L.getTranslate(),u.styledMode||($=L.shadowGroup,x&&!$&&($=L.shadowGroup=v.g("shadow").add(a.shadowGroup)),$&&$.attr(S),P=a.pointAttribs(L,L.selected&&"select")),L.delayedRendering?(T.setRadialReference(a.center).attr(z).attr(S),u.styledMode||T.attr(P).attr({"stroke-linejoin":"round"}).shadow(x,$),L.delayedRendering=!1):(T.setRadialReference(a.center),u.styledMode||merge$15(!0,N,P),merge$15(!0,N,z,S),T.animate(N)),T.attr({visibility:L.visible?"inherit":"hidden"}),T.addClass(L.getClassName(),!0)}else T&&(L.graphic=T.destroy())})},d.prototype.sortByAngle=function(a,u){a.sort(function(v,x){return typeof v.angle<"u"&&(x.angle-v.angle)*u})},d.prototype.translate=function(a){this.generatePoints();var u=this,v=1e3,x=u.options,S=x.slicedOffset,T=S+(x.borderWidth||0),P=getStartAndEndRadians(x.startAngle,x.endAngle),z=u.startAngleRad=P.start,L=u.endAngleRad=P.end,N=L-z,$=u.points,B=x.dataLabels.distance,U=x.ignoreHiddenPoint,j=$.length,Y,q,Q,J,ee,ie,ne,ae,de=0;for(a||(u.center=a=u.getCenter()),ne=0;ne<j;ne++){ae=$[ne],q=z+de*N,ae.isValid()&&(!U||ae.visible)&&(de+=ae.percentage/100),Q=z+de*N;var he={x:a[0],y:a[1],r:a[2]/2,innerR:a[3]/2,start:Math.round(q*v)/v,end:Math.round(Q*v)/v};ae.shapeType="arc",ae.shapeArgs=he,ae.labelDistance=pick$1e(ae.options.dataLabels&&ae.options.dataLabels.distance,B),ae.labelDistance=relativeLength$4(ae.labelDistance,he.r),u.maxLabelDistance=Math.max(u.maxLabelDistance||0,ae.labelDistance),J=(Q+q)/2,J>1.5*Math.PI?J-=2*Math.PI:J<-Math.PI/2&&(J+=2*Math.PI),ae.slicedTranslation={translateX:Math.round(Math.cos(J)*S),translateY:Math.round(Math.sin(J)*S)},ee=Math.cos(J)*a[2]/2,ie=Math.sin(J)*a[2]/2,ae.tooltipPos=[a[0]+ee*.7,a[1]+ie*.7],ae.half=J<-Math.PI/2||J>Math.PI/2?1:0,ae.angle=J,Y=Math.min(T,ae.labelDistance/5),ae.labelPosition={natural:{x:a[0]+ee+Math.cos(J)*ae.labelDistance,y:a[1]+ie+Math.sin(J)*ae.labelDistance},final:{},alignment:ae.labelDistance<0?"center":ae.half?"right":"left",connectorPosition:{breakAt:{x:a[0]+ee+Math.cos(J)*Y,y:a[1]+ie+Math.sin(J)*Y},touchingSliceAt:{x:a[0]+ee,y:a[1]+ie}}}}fireEvent$o(u,"afterTranslate")},d.prototype.updateTotals=function(){var a=this.points,u=a.length,v=this.options.ignoreHiddenPoint,x,S,T=0;for(x=0;x<u;x++)S=a[x],S.isValid()&&(!v||S.visible)&&(T+=S.y);for(this.total=T,x=0;x<u;x++)S=a[x],S.percentage=T>0&&(S.visible||!v)?S.y/T*100:0,S.total=T},d.defaultOptions=merge$15(Series$f.defaultOptions,{center:[null,null],clip:!1,colorByPoint:!0,dataLabels:{allowOverlap:!0,connectorPadding:5,connectorShape:"fixedOffset",crookDistance:"70%",distance:30,enabled:!0,formatter:function(){return this.point.isNull?void 0:this.point.name},softConnector:!0,x:0},fillColor:void 0,ignoreHiddenPoint:!0,inactiveOtherPoints:!0,legendType:"point",marker:null,size:null,showInLegend:!1,slicedOffset:10,stickyTracking:!1,tooltip:{followPointer:!0},borderColor:palette.backgroundColor,borderWidth:1,lineWidth:void 0,states:{hover:{brightness:.1}}}),d})(Series$f);extend$1c(PieSeries$3.prototype,{axisTypes:[],directTouch:!0,drawGraph:void 0,drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:ColumnSeries$h.prototype.drawTracker,getCenter:centeredSeriesMixin.getCenter,getSymbol:noop$f,isCartesian:!1,noSharedTooltip:!0,pointAttribs:ColumnSeries$h.prototype.pointAttribs,pointClass:PiePoint$3,requireSorting:!1,searchPoint:noop$f,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("pie",PieSeries$3);var noop$e=H.noop,distribute$1=R.distribute,Series$d=SeriesRegistry$1.series,arrayMax$6=Utilities.arrayMax,clamp$d=Utilities.clamp,defined$E=Utilities.defined,merge$14=Utilities.merge,pick$1d=Utilities.pick,relativeLength$3=Utilities.relativeLength,ColumnDataLabel;(function(g){var d=[],a={radialDistributionY:function(T){return T.top+T.distributeBox.pos},radialDistributionX:function(T,P,z,L){return T.getX(z<P.top+2||z>P.bottom-2?L:z,P.half,P)},justify:function(T,P,z){return z[0]+(T.half?-1:1)*(P+T.labelDistance)},alignToPlotEdges:function(T,P,z,L){var N=T.getBBox().width;return P?N+L:z-N-L},alignToConnectors:function(T,P,z,L){var N=0,$;return T.forEach(function(B){$=B.dataLabel.getBBox().width,$>N&&(N=$)}),P?N+L:z-N-L}};function u(T){if(DataLabel$1.compose(Series$d),d.indexOf(T)===-1){d.push(T);var P=T.prototype;P.dataLabelPositioners=a,P.alignDataLabel=noop$e,P.drawDataLabels=v,P.placeDataLabels=x,P.verifyDataLabelOverflow=S}}g.compose=u;function v(){var T=this,P=T.data,z=T.chart,L=T.options.dataLabels||{},N=L.connectorPadding,$=z.plotWidth,B=z.plotHeight,U=z.plotLeft,j=Math.round(z.chartWidth/3),Y=T.center,q=Y[2]/2,Q=Y[1],J=[[],[]],ee=[0,0,0,0],ie=T.dataLabelPositioners,ne,ae,de,he,pe,ve,be,ge,_e,me,xe,Ce;!T.visible||!L.enabled&&!T._hasPointLabels||(P.forEach(function(Me){Me.dataLabel&&Me.visible&&Me.dataLabel.shortened&&(Me.dataLabel.attr({width:"auto"}).css({width:"auto",textOverflow:"clip"}),Me.dataLabel.shortened=!1)}),Series$d.prototype.drawDataLabels.apply(T),P.forEach(function(Me){Me.dataLabel&&(Me.visible?(J[Me.half].push(Me),Me.dataLabel._pos=null,!defined$E(L.style.width)&&!defined$E(Me.options.dataLabels&&Me.options.dataLabels.style&&Me.options.dataLabels.style.width)&&Me.dataLabel.getBBox().width>j&&(Me.dataLabel.css({width:Math.round(j*.7)+"px"}),Me.dataLabel.shortened=!0)):(Me.dataLabel=Me.dataLabel.destroy(),Me.dataLabels&&Me.dataLabels.length===1&&delete Me.dataLabels))}),J.forEach(function(Me,Re){var Ue=Me.length,$e=[],Te,De,He,Le,it,pt;if(Ue)for(T.sortByAngle(Me,Re-.5),T.maxLabelDistance>0&&(Te=Math.max(0,Q-q-T.maxLabelDistance),De=Math.min(Q+q+T.maxLabelDistance,z.plotHeight),Me.forEach(function(nt){nt.labelDistance>0&&nt.dataLabel&&(nt.top=Math.max(0,Q-q-nt.labelDistance),nt.bottom=Math.min(Q+q+nt.labelDistance,z.plotHeight),it=nt.dataLabel.getBBox().height||21,nt.distributeBox={target:nt.labelPosition.natural.y-nt.top+it/2,size:it,rank:nt.y},$e.push(nt.distributeBox))}),pt=De+it-Te,distribute$1($e,pt,pt/5)),xe=0;xe<Ue;xe++){if(ne=Me[xe],ve=ne.labelPosition,he=ne.dataLabel,me=ne.visible===!1?"hidden":"inherit",He=ve.natural.y,_e=He,$e&&defined$E(ne.distributeBox)&&(typeof ne.distributeBox.pos>"u"?me="hidden":(be=ne.distributeBox.size,_e=ie.radialDistributionY(ne))),delete ne.positionIndex,L.justify)ge=ie.justify(ne,q,Y);else switch(L.alignTo){case"connectors":ge=ie.alignToConnectors(Me,Re,$,U);break;case"plotEdges":ge=ie.alignToPlotEdges(he,Re,$,U);break;default:ge=ie.radialDistributionX(T,ne,_e,He)}he._attr={visibility:me,align:ve.alignment},Ce=ne.options.dataLabels||{},he._pos={x:ge+pick$1d(Ce.x,L.x)+({left:N,right:-N}[ve.alignment]||0),y:_e+pick$1d(Ce.y,L.y)-10},ve.final.x=ge,ve.final.y=_e,pick$1d(L.crop,!0)&&(pe=he.getBBox().width,Le=null,ge-pe<N&&Re===1?(Le=Math.round(pe-ge+N),ee[3]=Math.max(Le,ee[3])):ge+pe>$-N&&Re===0&&(Le=Math.round(ge+pe-$+N),ee[1]=Math.max(Le,ee[1])),_e-be/2<0?ee[0]=Math.max(Math.round(-_e+be/2),ee[0]):_e+be/2>B&&(ee[2]=Math.max(Math.round(_e+be/2-B),ee[2])),he.sideOverflow=Le)}}),(arrayMax$6(ee)===0||this.verifyDataLabelOverflow(ee))&&(this.placeDataLabels(),this.points.forEach(function(Me){if(Ce=merge$14(L,Me.options.dataLabels),ae=pick$1d(Ce.connectorWidth,1),ae){var Re=void 0;de=Me.connector,he=Me.dataLabel,he&&he._pos&&Me.visible&&Me.labelDistance>0?(me=he._attr.visibility,Re=!de,Re&&(Me.connector=de=z.renderer.path().addClass("highcharts-data-label-connector  highcharts-color-"+Me.colorIndex+(Me.className?" "+Me.className:"")).add(T.dataLabelsGroup),z.styledMode||de.attr({"stroke-width":ae,stroke:Ce.connectorColor||Me.color||palette.neutralColor60})),de[Re?"attr":"animate"]({d:Me.getConnectorPath()}),de.attr("visibility",me)):de&&(Me.connector=de.destroy())}})))}function x(){this.points.forEach(function(T){var P=T.dataLabel,z;P&&T.visible&&(z=P._pos,z?(P.sideOverflow&&(P._attr.width=Math.max(P.getBBox().width-P.sideOverflow,0),P.css({width:P._attr.width+"px",textOverflow:(this.options.dataLabels.style||{}).textOverflow||"ellipsis"}),P.shortened=!0),P.attr(P._attr),P[P.moved?"animate":"attr"](z),P.moved=!0):P&&P.attr({y:-9999})),delete T.distributeBox},this)}function S(T){var P=this.center,z=this.options,L=z.center,N=z.minSize||80,$=N,B=z.size!==null;return B||(L[0]!==null?$=Math.max(P[2]-Math.max(T[1],T[3]),N):($=Math.max(P[2]-T[1]-T[3],N),P[0]+=(T[3]-T[1])/2),L[1]!==null?$=clamp$d($,N,P[2]-Math.max(T[0],T[2])):($=clamp$d($,N,P[2]-T[0]-T[2]),P[1]+=(T[0]-T[2])/2),$<P[2]?(P[2]=$,P[3]=Math.min(relativeLength$3(z.innerSize||0,$),$),this.translate(P),this.drawDataLabels&&this.drawDataLabels()):B=!0),B}})(ColumnDataLabel||(ColumnDataLabel={}));const PieDataLabel=ColumnDataLabel;var addEvent$U=Utilities.addEvent,fireEvent$n=Utilities.fireEvent,isArray$e=Utilities.isArray,isNumber$A=Utilities.isNumber,objectEach$i=Utilities.objectEach,pick$1c=Utilities.pick;addEvent$U(Chart$1,"render",function g(){var d=this,a=[];(this.labelCollectors||[]).forEach(function(u){a=a.concat(u())}),(this.yAxis||[]).forEach(function(u){u.stacking&&u.options.stackLabels&&!u.options.stackLabels.allowOverlap&&objectEach$i(u.stacking.stacks,function(v){objectEach$i(v,function(x){x.label&&x.label.visibility!=="hidden"&&a.push(x.label)})})}),(this.series||[]).forEach(function(u){var v=u.options.dataLabels;if(u.visible&&!(v.enabled===!1&&!u._hasPointLabels)){var x=function(S){return S.forEach(function(T){if(T.visible){var P=isArray$e(T.dataLabels)?T.dataLabels:T.dataLabel?[T.dataLabel]:[];P.forEach(function(z){var L=z.options;z.labelrank=pick$1c(L.labelrank,T.labelrank,T.shapeArgs&&T.shapeArgs.height),L.allowOverlap?(z.oldOpacity=z.opacity,z.newOpacity=1,hideOrShow(z,d)):a.push(z)})}})};x(u.nodes||[]),x(u.points)}}),this.hideOverlappingLabels(a)});Chart$1.prototype.hideOverlappingLabels=function(g){var d=this,a=g.length,u=d.renderer,v,x,S,T,P,z,L,N=!1,$=function(U,j){return!(j.x>=U.x+U.width||j.x+j.width<=U.x||j.y>=U.y+U.height||j.y+j.height<=U.y)},B=function(U){var j,Y,q,Q=U.box?0:U.padding||0,J=0,ee=0,ie,ne;if(U&&(!U.alignAttr||U.placed))return j=U.alignAttr||{x:U.attr("x"),y:U.attr("y")},Y=U.parentGroup,U.width||(q=U.getBBox(),U.width=q.width,U.height=q.height,J=u.fontMetrics(null,U.element).h),ie=U.width-2*Q,ne={left:"0",center:"0.5",right:"1"}[U.alignValue],ne?ee=+ne*ie:isNumber$A(U.x)&&Math.round(U.x)!==U.translateX&&(ee=U.x-U.translateX),{x:j.x+(Y.translateX||0)+Q-(ee||0),y:j.y+(Y.translateY||0)+Q-J,width:U.width-2*Q,height:U.height-2*Q}};for(x=0;x<a;x++)v=g[x],v&&(v.oldOpacity=v.opacity,v.newOpacity=1,v.absoluteBox=B(v));for(g.sort(function(U,j){return(j.labelrank||0)-(U.labelrank||0)}),x=0;x<a;x++)for(T=g[x],z=T&&T.absoluteBox,S=x+1;S<a;++S)P=g[S],L=P&&P.absoluteBox,z&&L&&T!==P&&T.newOpacity!==0&&P.newOpacity!==0&&$(z,L)&&((T.labelrank<P.labelrank?T:P).newOpacity=0);g.forEach(function(U){hideOrShow(U,d)&&(N=!0)}),N&&fireEvent$n(d,"afterHideAllOverlappingLabels")};function hideOrShow(g,d){var a,u,v=!1;return g&&(u=g.newOpacity,g.oldOpacity!==u&&(g.alignAttr&&g.placed?(g[u?"removeClass":"addClass"]("highcharts-data-label-hidden"),a=function(){d.styledMode||g.css({pointerEvents:u?"auto":"none"})},v=!0,g.alignAttr.opacity=u,g[g.isOld?"animate":"attr"](g.alignAttr,null,a),fireEvent$n(d,"afterHideOverlappingLabel")):g.attr({opacity:u})),g.isOld=!0),v}var extend$1b=Utilities.extend,find$g=Utilities.find,isArray$d=Utilities.isArray,isObject$b=Utilities.isObject,merge$13=Utilities.merge,objectEach$h=Utilities.objectEach,pick$1b=Utilities.pick,splat$c=Utilities.splat,uniqueKey$3=Utilities.uniqueKey,Responsive;(function(g){var d=[];function a(v){return d.indexOf(v)===-1&&(d.push(v),extend$1b(v.prototype,u.prototype)),v}g.compose=a;var u=(function(){function v(){}return v.prototype.currentOptions=function(x){var S=this,T={};function P(z,L,N,$){var B;objectEach$h(z,function(U,j){if(!$&&S.collectionsWithUpdate.indexOf(j)>-1&&L[j])for(U=splat$c(U),N[j]=[],B=0;B<Math.max(U.length,L[j].length);B++)L[j][B]&&(U[B]===void 0?N[j][B]=L[j][B]:(N[j][B]={},P(U[B],L[j][B],N[j][B],$+1)));else isObject$b(U)?(N[j]=isArray$d(U)?[]:{},P(U,L[j]||{},N[j],$+1)):typeof L[j]>"u"?N[j]=null:N[j]=L[j]})}return P(x,this.options,T,0),T},v.prototype.matchResponsiveRule=function(x,S){var T=x.condition,P=T.callback||function(){return this.chartWidth<=pick$1b(T.maxWidth,Number.MAX_VALUE)&&this.chartHeight<=pick$1b(T.maxHeight,Number.MAX_VALUE)&&this.chartWidth>=pick$1b(T.minWidth,0)&&this.chartHeight>=pick$1b(T.minHeight,0)};P.call(this)&&S.push(x._id)},v.prototype.setResponsive=function(x,S){var T=this,P=this.options.responsive,z=this.currentResponsive,L=[],N;!S&&P&&P.rules&&P.rules.forEach(function(U){typeof U._id>"u"&&(U._id=uniqueKey$3()),T.matchResponsiveRule(U,L)},this);var $=merge$13.apply(void 0,L.map(function(U){return find$g((P||{}).rules||[],function(j){return j._id===U})}).map(function(U){return U&&U.chartOptions}));$.isResponsiveOptions=!0,L=L.toString()||void 0;var B=z&&z.ruleIds;L!==B&&(z&&this.update(z.undoOptions,x,!0),L?(N=this.currentOptions($),N.isResponsiveOptions=!0,this.currentResponsive={ruleIds:L,mergedOptions:$,undoOptions:N},this.update($,x,!0)):this.currentResponsive=void 0)},v})()})(Responsive||(Responsive={}));const Responsive$1=Responsive;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$8=H;G$8.animate=animationExports.animate;G$8.animObject=animationExports.animObject;G$8.getDeferredAnimation=animationExports.getDeferredAnimation;G$8.setAnimation=animationExports.setAnimation;G$8.stop=animationExports.stop;G$8.timers=Fx.timers;G$8.AST=AST;G$8.Axis=Axis;G$8.Chart=Chart$1;G$8.chart=Chart$1.chart;G$8.Fx=Fx;G$8.Legend=Legend;G$8.PlotLineOrBand=PlotLineOrBand;G$8.Point=Point$4;G$8.Pointer=MSPointer.isRequired()?MSPointer:Pointer;G$8.Series=Series$f;G$8.SVGElement=SVGElement;G$8.SVGRenderer=SVGRenderer;G$8.Tick=Tick;G$8.Time=Time;G$8.Tooltip=Tooltip;G$8.Color=Color;G$8.color=Color.parse;HTMLRenderer.compose(SVGRenderer);HTMLElement$1.compose(SVGElement);G$8.defaultOptions=DefaultOptions.defaultOptions;G$8.getOptions=DefaultOptions.getOptions;G$8.time=DefaultOptions.defaultTime;G$8.setOptions=DefaultOptions.setOptions;G$8.dateFormat=FormatUtilities.dateFormat;G$8.format=FormatUtilities.format;G$8.numberFormat=FormatUtilities.numberFormat;G$8.addEvent=Utilities.addEvent;G$8.arrayMax=Utilities.arrayMax;G$8.arrayMin=Utilities.arrayMin;G$8.attr=Utilities.attr;G$8.clearTimeout=Utilities.clearTimeout;G$8.correctFloat=Utilities.correctFloat;G$8.createElement=Utilities.createElement;G$8.css=Utilities.css;G$8.defined=Utilities.defined;G$8.destroyObjectProperties=Utilities.destroyObjectProperties;G$8.discardElement=Utilities.discardElement;G$8.distribute=R.distribute;G$8.erase=Utilities.erase;G$8.error=Utilities.error;G$8.extend=Utilities.extend;G$8.extendClass=Utilities.extendClass;G$8.find=Utilities.find;G$8.fireEvent=Utilities.fireEvent;G$8.getMagnitude=Utilities.getMagnitude;G$8.getStyle=Utilities.getStyle;G$8.inArray=Utilities.inArray;G$8.isArray=Utilities.isArray;G$8.isClass=Utilities.isClass;G$8.isDOMElement=Utilities.isDOMElement;G$8.isFunction=Utilities.isFunction;G$8.isNumber=Utilities.isNumber;G$8.isObject=Utilities.isObject;G$8.isString=Utilities.isString;G$8.keys=Utilities.keys;G$8.merge=Utilities.merge;G$8.normalizeTickInterval=Utilities.normalizeTickInterval;G$8.objectEach=Utilities.objectEach;G$8.offset=Utilities.offset;G$8.pad=Utilities.pad;G$8.pick=Utilities.pick;G$8.pInt=Utilities.pInt;G$8.relativeLength=Utilities.relativeLength;G$8.removeEvent=Utilities.removeEvent;G$8.seriesType=SeriesRegistry$1.seriesType;G$8.splat=Utilities.splat;G$8.stableSort=Utilities.stableSort;G$8.syncTimeout=Utilities.syncTimeout;G$8.timeUnits=Utilities.timeUnits;G$8.uniqueKey=Utilities.uniqueKey;G$8.useSerialIds=Utilities.useSerialIds;G$8.wrap=Utilities.wrap;ColumnDataLabel$2.compose(ColumnSeries$h);DataLabel$1.compose(Series$f);DateTimeAxis$1.compose(Axis);LogarithmicAxis$1.compose(Axis);PieDataLabel.compose(PieSeries$3);PlotLineOrBand.compose(Axis);Responsive$1.compose(Chart$1);var addEvent$T=Utilities.addEvent,correctFloat$8=Utilities.correctFloat,css$3=Utilities.css,defined$D=Utilities.defined,error$5=Utilities.error,pick$1a=Utilities.pick,timeUnits$1=Utilities.timeUnits,composedClasses=[],OrdinalAxis;(function(g){function d(U,j,Y){if(composedClasses.indexOf(U)===-1){composedClasses.push(U);var q=U.prototype;q.getTimeTicks=a,q.index2val=u,q.lin2val=v,q.val2lin=$,q.ordinal2lin=q.val2lin,addEvent$T(U,"afterInit",S),addEvent$T(U,"foundExtremes",T),addEvent$T(U,"afterSetScale",P),addEvent$T(U,"initialAxisTranslation",z)}return composedClasses.indexOf(Y)===-1&&(composedClasses.push(Y),addEvent$T(Y,"pan",L)),composedClasses.indexOf(j)===-1&&(composedClasses.push(j),addEvent$T(j,"updatedData",N)),U}g.compose=d;function a(U,j,Y,q,Q,J,ee){Q===void 0&&(Q=[]),J===void 0&&(J=0);var ie={},ne=this.options.tickPixelInterval,ae=this.chart.time,de=[],he,pe,ve,be,ge,_e=0,me=[],xe=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!Q||Q.length<3||typeof j>"u")return ae.getTimeTicks.apply(ae,arguments);var Ce=Q.length;for(he=0;he<Ce;he++){if(ge=he&&Q[he-1]>Y,Q[he]<j&&(_e=he),he===Ce-1||Q[he+1]-Q[he]>J*5||ge){if(Q[he]>xe){for(pe=ae.getTimeTicks(U,Q[_e],Q[he],q);pe.length&&pe[0]<=xe;)pe.shift();pe.length&&(xe=pe[pe.length-1]),de.push(me.length),me=me.concat(pe)}_e=he+1}if(ge)break}if(pe){if(be=pe.info,ee&&be.unitRange<=timeUnits$1.hour){for(he=me.length-1,_e=1;_e<he;_e++)ae.dateFormat("%d",me[_e])!==ae.dateFormat("%d",me[_e-1])&&(ie[me[_e]]="day",ve=!0);ve&&(ie[me[0]]="day"),be.higherRanks=ie}be.segmentStarts=de,me.info=be}else error$5(12,!1,this.chart);if(ee&&defined$D(ne)){for(var Me=me.length,Re=[],Ue=[],$e=void 0,Te=void 0,De=void 0,He=void 0,Le=void 0,it=Me;it--;)Te=this.translate(me[it]),De&&(Ue[it]=De-Te),Re[it]=De=Te;for(Ue.sort(),He=Ue[Math.floor(Ue.length/2)],He<ne*.6&&(He=null),it=me[Me-1]>Y?Me-1:Me,De=void 0;it--;)Te=Re[it],Le=Math.abs(De-Te),De&&Le<ne*.8&&(He===null||Le<He*.8)?(ie[me[it]]&&!ie[me[it+1]]?($e=it+1,De=Te):$e=it,me.splice($e,1)):De=Te}return me}function u(U){var j=this,Y=j.ordinal,q=Y.positions;if(!q)return U;var Q=q.length-1,J;return U<0?U=q[0]:U>Q?U=q[Q]:(Q=Math.floor(U),J=U-Q),typeof J<"u"&&typeof q[Q]<"u"?q[Q]+(J?J*(q[Q+1]-q[Q]):0):U}function v(U){var j=this,Y=j.ordinal,q=j.old?j.old.min:j.min,Q=j.old?j.old.transA:j.transA,J=Y.positions;if(!J)return U;var ee=(U-q)*Q+j.minPixelPadding,ie=ee>0&&ee<j.left+j.len;if(ie||(Y.extendedOrdinalPositions||(Y.extendedOrdinalPositions=Y.getExtendedPositions()),J=Y.extendedOrdinalPositions),J&&J.length){var ne=Y.getIndexOfPoint(ee,J),ae=correctFloat$8(ne%1);if(ne>=0&&ne<J.length){var de=J[Math.floor(ne)],he=J[Math.ceil(ne)],pe=he-de;return J[Math.floor(ne)]+ae*pe}var ve=J.length,be=J[0],ge=J[ve-1],_e=(ge-be)/(ve-1);return ne<0?be+_e*ne:ge+_e*(ne-ve)}return U}function x(U,j){var Y=g.Additions.findIndexOf(U,j,!0);if(U[Y]===j)return Y;var q=(j-U[Y])/(U[Y+1]-U[Y]);return Y+q}function S(){var U=this;U.ordinal||(U.ordinal=new g.Additions(U))}function T(){var U=this;U.isXAxis&&defined$D(U.options.overscroll)&&U.max===U.dataMax&&(!U.chart.mouseIsDown||U.isInternal)&&(!U.eventArgs||U.eventArgs&&U.eventArgs.trigger!=="navigator")&&(U.max+=U.options.overscroll,!U.isInternal&&defined$D(U.userMin)&&(U.min+=U.options.overscroll))}function P(){var U=this;U.horiz&&!U.isDirty&&(U.isDirty=U.isOrdinal&&U.chart.navigator&&!U.chart.navigator.adaptToUpdatedData)}function z(){var U=this;U.ordinal&&(U.ordinal.beforeSetTickPositions(),U.tickInterval=U.ordinal.postProcessTickInterval(U.tickInterval))}function L(U){var j=this,Y=j.xAxis[0],q=Y.options.overscroll,Q=U.originalEvent.chartX,J=j.options.chart.panning,ee=!1;if(J&&J.type!=="y"&&Y.options.ordinal&&Y.series.length){var ie=j.mouseDownX,ne=Y.getExtremes(),ae=ne.dataMax,de=ne.min,he=ne.max,pe=j.hoverPoints,ve=Y.closestPointRange||Y.ordinal&&Y.ordinal.overscrollPointsRange,be=Y.translationSlope*(Y.ordinal.slope||ve),ge=(ie-Q)/be,_e={ordinal:{positions:Y.ordinal.getExtendedPositions()}},me=Y.index2val,xe=Y.val2lin,Ce=void 0,Me=void 0,Re=void 0,Ue=void 0;_e.ordinal.positions?Math.abs(ge)>1&&(pe&&pe.forEach(function($e){$e.setState()}),ge<0?(Re=_e,Ue=Y.ordinal.positions?Y:_e):(Re=Y.ordinal.positions?Y:_e,Ue=_e),Me=Ue.ordinal.positions,ae>Me[Me.length-1]&&Me.push(ae),j.fixedRange=he-de,Ce=Y.navigatorAxis.toFixedRange(null,null,me.apply(Re,[xe.apply(Re,[de,!0])+ge]),me.apply(Ue,[xe.apply(Ue,[he,!0])+ge])),Ce.min>=Math.min(ne.dataMin,de)&&Ce.max<=Math.max(ae,he)+q&&Y.setExtremes(Ce.min,Ce.max,!0,!1,{trigger:"pan"}),j.mouseDownX=Q,css$3(j.container,{cursor:"move"})):ee=!0}else ee=!0;ee||J&&/y/.test(J.type)?q&&(Y.max=Y.dataMax+q):U.preventDefault()}function N(){var U=this.xAxis;U&&U.options.ordinal&&(delete U.ordinal.index,delete U.ordinal.extendedOrdinalPositions)}function $(U,j){var Y=this,q=Y.ordinal,Q=q.positions,J=q.slope,ee=q.extendedOrdinalPositions;if(!Q)return U;var ie=Q.length,ne;if(Q[0]<=U&&Q[ie-1]>=U)ne=x(Q,U);else{if(ee||(ee=q.getExtendedPositions&&q.getExtendedPositions(),q.extendedOrdinalPositions=ee),!(ee&&ee.length))return U;var ae=ee.length;J||(J=(ee[ae-1]-ee[0])/ae);var de=x(ee,Q[0]);if(U>=ee[0]&&U<=ee[ae-1])ne=x(ee,U)-de;else if(U<ee[0]){var he=ee[0]-U,pe=he/J;ne=-de-pe}else{var he=U-ee[ae-1],pe=he/J;ne=pe+ae-de}}return j?ne:J*(ne||0)+q.offset}var B=(function(){function U(j){this.index={},this.axis=j}return U.prototype.beforeSetTickPositions=function(){var j=this.axis,Y=j.ordinal,q=j.getExtremes(),Q=q.min,J=q.max,ee=j.isXAxis&&!!j.options.breaks,ie=j.options.ordinal,ne=j.chart.options.chart.ignoreHiddenSeries,ae,de,he,pe,ve,be,ge,_e,me=[],xe=Number.MAX_VALUE,Ce=!1;if(ie||ee){if(j.series.forEach(function(Me,Re){if(de=[],(!ne||Me.visible!==!1)&&(Me.takeOrdinalPosition!==!1||ee)&&(me=me.concat(Me.processedXData),ae=me.length,me.sort(function(Ue,$e){return Ue-$e}),xe=Math.min(xe,pick$1a(Me.closestPointRange,xe)),ae)){for(Re=0;Re<ae-1;)me[Re]!==me[Re+1]&&de.push(me[Re+1]),Re++;de[0]!==me[0]&&de.unshift(me[0]),me=de}Me.isSeriesBoosting&&(_e=!0)}),_e&&(me.length=0),ae=me.length,ae>2){for(he=me[1]-me[0],ge=ae-1;ge--&&!Ce;)me[ge+1]-me[ge]!==he&&(Ce=!0);!j.options.keepOrdinalPadding&&(me[0]-Q>he||J-me[me.length-1]>he)&&(Ce=!0)}else j.options.overscroll&&(ae===2?xe=me[1]-me[0]:ae===1?(xe=j.options.overscroll,me=[me[0],me[0]+xe]):xe=Y.overscrollPointsRange);Ce||j.forceOrdinal?(j.options.overscroll&&(Y.overscrollPointsRange=xe,me=me.concat(Y.getOverscrollPositions())),Y.positions=me,pe=j.ordinal2lin(Math.max(Q,me[0]),!0),ve=Math.max(j.ordinal2lin(Math.min(J,me[me.length-1]),!0),1),Y.slope=be=(J-Q)/(ve-pe),Y.offset=Q-pe*be):(Y.overscrollPointsRange=pick$1a(j.closestPointRange,Y.overscrollPointsRange),Y.positions=j.ordinal.slope=Y.offset=void 0)}j.isOrdinal=ie&&Ce,Y.groupIntervalFactor=null},U.findIndexOf=function(j,Y,q){for(var Q=0,J=j.length-1,ee;Q<J;)ee=Math.ceil((Q+J)/2),j[ee]<=Y?Q=ee:J=ee-1;return j[Q]===Y||q?Q:-1},U.prototype.getExtendedPositions=function(){var j=this,Y=j.axis,q=Y.constructor.prototype,Q=Y.chart,J=Y.series[0].currentDataGrouping,ee=J?J.count+J.unitName:"raw",ie=Y.options.overscroll,ne=Y.getExtremes(),ae,de=void 0,he=j.index;return he||(he=j.index={}),he[ee]||(ae={series:[],chart:Q,forceOrdinal:!1,getExtremes:function(){return{min:ne.dataMin,max:ne.dataMax+ie}},getGroupPixelWidth:q.getGroupPixelWidth,getTimeTicks:q.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:q.ordinal2lin,getIndexOfPoint:q.getIndexOfPoint,val2lin:q.val2lin},ae.ordinal.axis=ae,Y.series.forEach(function(pe){de={xAxis:ae,xData:pe.xData.slice(),chart:Q,destroyGroupedData:H.noop,getProcessedData:Series$f.prototype.getProcessedData,applyGrouping:Series$f.prototype.applyGrouping},de.xData=de.xData.concat(j.getOverscrollPositions()),de.options={dataGrouping:J?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[J.unitName,[J.count]]]}:{enabled:!1}},ae.series.push(de),pe.processData.apply(de)}),Y.applyGrouping.call(ae),de.closestPointRange!==de.basePointRange&&de.currentDataGrouping&&(ae.forceOrdinal=!0),Y.ordinal.beforeSetTickPositions.apply({axis:ae}),he[ee]=ae.ordinal.positions),he[ee]},U.prototype.getGroupIntervalFactor=function(j,Y,q){var Q=this;Q.axis;var J=q.processedXData,ee=J.length,ie=[],ne,ae,de=Q.groupIntervalFactor;if(!de){for(ae=0;ae<ee-1;ae++)ie[ae]=J[ae+1]-J[ae];ie.sort(function(he,pe){return he-pe}),ne=ie[Math.floor(ee/2)],j=Math.max(j,J[0]),Y=Math.min(Y,J[ee-1]),Q.groupIntervalFactor=de=ee*ne/(Y-j)}return de},U.prototype.getIndexOfPoint=function(j,Y){var q=this,Q=q.axis,J=q.positions?q.positions[0]:0,ee=Q.series[0].points&&Q.series[0].points[0]&&Q.series[0].points[0].plotX||Q.minPixelPadding;Q.series.length>1&&Q.series.forEach(function(ae){defined$D(ae.points[0])&&defined$D(ae.points[0].plotX)&&ae.points[0].plotX<ee&&(ee=ae.points[0].plotX)});var ie=Q.translationSlope*(q.slope||Q.closestPointRange||q.overscrollPointsRange),ne=(j-ee)/ie;return U.findIndexOf(Y,J)+ne},U.prototype.getOverscrollPositions=function(){var j=this,Y=j.axis,q=Y.options.overscroll,Q=j.overscrollPointsRange,J=[],ee=Y.dataMax;if(defined$D(Q))for(;ee<=Y.dataMax+q;)ee+=Q,J.push(ee);return J},U.prototype.postProcessTickInterval=function(j){var Y=this,q=Y.axis,Q=Y.slope,J;return Q?q.options.breaks?J=q.closestPointRange||j:J=j/(Q/q.closestPointRange):J=j,J},U})();g.Additions=B})(OrdinalAxis||(OrdinalAxis={}));const OrdinalAxis$1=OrdinalAxis;var addEvent$S=Utilities.addEvent,find$f=Utilities.find,fireEvent$m=Utilities.fireEvent,isArray$c=Utilities.isArray,isNumber$z=Utilities.isNumber,pick$19=Utilities.pick,BrokenAxis;(function(g){var d=[];function a($,B){if(d.indexOf($)===-1&&(d.push($),$.keepProps.push("brokenAxis"),addEvent$S($,"init",S),addEvent$S($,"afterInit",u),addEvent$S($,"afterSetTickPositions",x),addEvent$S($,"afterSetOptions",v)),d.indexOf(B)===-1){d.push(B);var U=B.prototype;U.drawBreaks=z,U.gappedPath=L,addEvent$S(B,"afterGeneratePoints",T),addEvent$S(B,"afterRender",P)}return $}g.compose=a;function u(){typeof this.brokenAxis<"u"&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function v(){var $=this;$.brokenAxis&&$.brokenAxis.hasBreaks&&($.options.ordinal=!1)}function x(){var $=this,B=$.brokenAxis;if(B&&B.hasBreaks){for(var U=$.tickPositions,j=$.tickPositions.info,Y=[],q=0;q<U.length;q++)B.isInAnyBreak(U[q])||Y.push(U[q]);$.tickPositions=Y,$.tickPositions.info=j}}function S(){var $=this;$.brokenAxis||($.brokenAxis=new N($))}function T(){var $=this,B=$.isDirty,U=$.options.connectNulls,j=$.points,Y=$.xAxis,q=$.yAxis;if(B)for(var Q=j.length;Q--;){var J=j[Q],ee=J.y===null&&U===!1,ie=!ee&&(Y&&Y.brokenAxis&&Y.brokenAxis.isInAnyBreak(J.x,!0)||q&&q.brokenAxis&&q.brokenAxis.isInAnyBreak(J.y,!0));J.visible=ie?!1:J.options.visible!==!1}}function P(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,pick$19(this.pointArrayMap,["y"]))}function z($,B){var U=this,j=U.points,Y,q,Q,J;if($&&$.brokenAxis&&$.brokenAxis.hasBreaks){var ee=$.brokenAxis;B.forEach(function(ie){Y=ee&&ee.breakArray||[],q=$.isXAxis?$.min:pick$19(U.options.threshold,$.min),j.forEach(function(ne){J=pick$19(ne["stack"+ie.toUpperCase()],ne[ie]),Y.forEach(function(ae){isNumber$z(q)&&isNumber$z(J)&&(Q=!1,q<ae.from&&J>ae.to||q>ae.from&&J<ae.from?Q="pointBreak":(q<ae.from&&J>ae.from&&J<ae.to||q>ae.from&&J>ae.to&&J<ae.from)&&(Q="pointInBreak"),Q&&fireEvent$m($,Q,{point:ne,brk:ae}))})})})}}function L(){var $=this.currentDataGrouping,B=$&&$.gapSize,U=this.points.slice(),j=this.yAxis,Y=this.options.gapSize,q=U.length-1,Q;if(Y&&q>0){this.options.gapUnit!=="value"&&(Y*=this.basePointRange),B&&B>Y&&B>=this.basePointRange&&(Y=B);for(var J=void 0,ee=void 0;q--;)if(ee&&ee.visible!==!1||(ee=U[q+1]),J=U[q],!(ee.visible===!1||J.visible===!1)){if(ee.x-J.x>Y){var ie=(J.x+ee.x)/2;U.splice(q+1,0,{isNull:!0,x:ie}),j.stacking&&this.options.stacking&&(Q=j.stacking.stacks[this.stackKey][ie]=new StackItem$1(j,j.options.stackLabels,!1,ie,this.stack),Q.total=0)}ee=J}}return this.getGraphPath(U)}var N=(function(){function $(B){this.hasBreaks=!1,this.axis=B}return $.isInBreak=function(B,U){var j=B.repeat||1/0,Y=B.from,q=B.to-B.from,Q=U>=Y?(U-Y)%j:j-(Y-U)%j,J;return B.inclusive?J=Q<=q:J=Q<q&&Q!==0,J},$.lin2Val=function(B){var U=this,j=U.brokenAxis,Y=j&&j.breakArray;if(!Y||!isNumber$z(B))return B;var q=B,Q,J;for(J=0;J<Y.length&&(Q=Y[J],!(Q.from>=q));J++)(Q.to<q||$.isInBreak(Q,q))&&(q+=Q.len);return q},$.val2Lin=function(B){var U=this,j=U.brokenAxis,Y=j&&j.breakArray;if(!Y||!isNumber$z(B))return B;var q=B,Q,J;for(J=0;J<Y.length;J++)if(Q=Y[J],Q.to<=B)q-=Q.len;else{if(Q.from>=B)break;if($.isInBreak(Q,B)){q-=B-Q.from;break}}return q},$.prototype.findBreakAt=function(B,U){return find$f(U,function(j){return j.from<B&&B<j.to})},$.prototype.isInAnyBreak=function(B,U){var j=this,Y=j.axis,q=Y.options.breaks||[],Q=q.length,J,ee,ie;if(Q&&isNumber$z(B)){for(;Q--;)$.isInBreak(q[Q],B)&&(J=!0,ee||(ee=pick$19(q[Q].showPoints,!Y.isXAxis)));J&&U?ie=J&&!ee:ie=J}return ie},$.prototype.setBreaks=function(B,U){var j=this,Y=j.axis,q=isArray$c(B)&&!!B.length;Y.isDirty=j.hasBreaks!==q,j.hasBreaks=q,Y.options.breaks=Y.userOptions.breaks=B,Y.forceRedraw=!0,Y.series.forEach(function(Q){Q.isDirty=!0}),!q&&Y.val2lin===$.val2Lin&&(delete Y.val2lin,delete Y.lin2val),q&&(Y.userOptions.ordinal=!1,Y.lin2val=$.lin2Val,Y.val2lin=$.val2Lin,Y.setExtremes=function(Q,J,ee,ie,ne){if(j.hasBreaks){for(var ae=this.options.breaks||[],de=void 0;de=j.findBreakAt(Q,ae);)Q=de.to;for(;de=j.findBreakAt(J,ae);)J=de.from;J<Q&&(J=Q)}Y.constructor.prototype.setExtremes.call(this,Q,J,ee,ie,ne)},Y.setAxisTranslation=function(){if(Y.constructor.prototype.setAxisTranslation.call(this),j.unitLength=void 0,j.hasBreaks){var Q=Y.options.breaks||[],J=[],ee=[],ie=pick$19(Y.pointRangePadding,0),ne=0,ae,de,he=Y.userMin||Y.min,pe=Y.userMax||Y.max,ve,be;Q.forEach(function(ge){de=ge.repeat||1/0,isNumber$z(he)&&isNumber$z(pe)&&($.isInBreak(ge,he)&&(he+=ge.to%de-he%de),$.isInBreak(ge,pe)&&(pe-=pe%de-ge.from%de))}),Q.forEach(function(ge){if(ve=ge.from,de=ge.repeat||1/0,isNumber$z(he)&&isNumber$z(pe)){for(;ve-de>he;)ve-=de;for(;ve<he;)ve+=de;for(be=ve;be<pe;be+=de)J.push({value:be,move:"in"}),J.push({value:be+ge.to-ge.from,move:"out",size:ge.breakSize})}}),J.sort(function(ge,_e){return ge.value===_e.value?(ge.move==="in"?0:1)-(_e.move==="in"?0:1):ge.value-_e.value}),ae=0,ve=he,J.forEach(function(ge){ae+=ge.move==="in"?1:-1,ae===1&&ge.move==="in"&&(ve=ge.value),ae===0&&isNumber$z(ve)&&(ee.push({from:ve,to:ge.value,len:ge.value-ve-(ge.size||0)}),ne+=ge.value-ve-(ge.size||0))}),j.breakArray=ee,isNumber$z(he)&&isNumber$z(pe)&&isNumber$z(Y.min)&&(j.unitLength=pe-he-ne+ie,fireEvent$m(Y,"afterBreaks"),Y.staticScale?Y.transA=Y.staticScale:j.unitLength&&(Y.transA*=(pe-Y.min+ie)/j.unitLength),ie&&(Y.minPixelPadding=Y.transA*(Y.minPointOffset||0)),Y.min=he,Y.max=pe)}}),pick$19(U,!0)&&Y.chart.redraw()},$})();g.Additions=N})(BrokenAxis||(BrokenAxis={}));const BrokenAxis$1=BrokenAxis;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/broken-axis
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$7=H;BrokenAxis$1.compose(G$7.Axis,G$7.Series);var format$8=FormatUtilities.format,seriesProto$3=Series$f.prototype,addEvent$R=Utilities.addEvent,arrayMax$5=Utilities.arrayMax,arrayMin$5=Utilities.arrayMin,correctFloat$7=Utilities.correctFloat,defined$C=Utilities.defined,error$4=Utilities.error,extend$1a=Utilities.extend,isNumber$y=Utilities.isNumber,merge$12=Utilities.merge,pick$18=Utilities.pick,approximations=H.approximations={sum:function(g){var d=g.length,a;if(!d&&g.hasNulls)a=null;else if(d)for(a=0;d--;)a+=g[d];return a},average:function(g){var d=g.length,a=approximations.sum(g);return isNumber$y(a)&&d&&(a=correctFloat$7(a/d)),a},averages:function(){var g=[];return[].forEach.call(arguments,function(d){g.push(approximations.average(d))}),typeof g[0]>"u"?void 0:g},open:function(g){return g.length?g[0]:g.hasNulls?null:void 0},high:function(g){return g.length?arrayMax$5(g):g.hasNulls?null:void 0},low:function(g){return g.length?arrayMin$5(g):g.hasNulls?null:void 0},close:function(g){return g.length?g[g.length-1]:g.hasNulls?null:void 0},ohlc:function(g,d,a,u){if(g=approximations.open(g),d=approximations.high(d),a=approximations.low(a),u=approximations.close(u),isNumber$y(g)||isNumber$y(d)||isNumber$y(a)||isNumber$y(u))return[g,d,a,u]},range:function(g,d){if(g=approximations.low(g),d=approximations.high(d),isNumber$y(g)||isNumber$y(d))return[g,d];if(g===null&&d===null)return null}},applyGrouping=function(){var g=this,d=g.chart,a=g.options,u=a.dataGrouping,v=g.allowDG!==!1&&u&&pick$18(u.enabled,d.options.isStock),x=g.visible||!d.options.chart.ignoreHiddenSeries,S,T,P=this.currentDataGrouping,z,L,N=!1;if(v&&!g.requireSorting&&(g.requireSorting=N=!0),T=skipDataGrouping(g)||!v,N&&(g.requireSorting=!1),!T){g.destroyGroupedData();var $=void 0,B=u.groupAll?g.xData:g.processedXData,U=u.groupAll?g.yData:g.processedYData,j=d.plotSizeX,Y=g.xAxis,q=Y.options.ordinal,Q=g.groupPixelWidth;if(Q&&B&&B.length){S=!0,g.isDirty=!0,g.points=null;var J=Y.getExtremes(),ee=J.min,ie=J.max,ne=q&&Y.ordinal&&Y.ordinal.getGroupIntervalFactor(ee,ie,g)||1,ae=Q*(ie-ee)/j*ne,de=Y.getTimeTicks(DateTimeAxis$1.Additions.prototype.normalizeTimeTickInterval(ae,u.units||defaultDataGroupingUnits),Math.min(ee,B[0]),Math.max(ie,B[B.length-1]),Y.options.startOfWeek,B,g.closestPointRange),he=seriesProto$3.groupData.apply(g,[B,U,de,u.approximation]),pe=he.groupedXData,ve=he.groupedYData,be=0;for(u&&u.smoothed&&pe.length&&(u.firstAnchor="firstPoint",u.anchor="middle",u.lastAnchor="lastPoint",error$4(32,!1,d,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),anchorPoints(g,pe,ie),$=1;$<de.length;$++)(!de.info.segmentStarts||de.info.segmentStarts.indexOf($)===-1)&&(be=Math.max(de[$]-de[$-1],be));z=de.info,z.gapSize=be,g.closestPointRange=de.info.totalRange,g.groupMap=he.groupMap,x&&adjustExtremes(Y,pe),u.groupAll&&(g.allGroupedData=ve,L=g.cropData(pe,ve,Y.min,Y.max,1),pe=L.xData,ve=L.yData,g.cropStart=L.start),g.processedXData=pe,g.processedYData=ve}else g.groupMap=null;g.hasGroupedData=S,g.currentDataGrouping=z,g.preventGraphAnimation=(P&&P.totalRange)!==(z&&z.totalRange)}},skipDataGrouping=function(g){if(g.isCartesian&&!g.isDirty&&!g.xAxis.isDirty&&!g.yAxis.isDirty)return!1},groupData=function(g,d,a,u){var v=this,x=v.data,S=v.options&&v.options.data,T=[],P=[],z=[],L=g.length,N,$,B,U=!!d,j=[],Y,q=v.pointArrayMap,Q=q&&q.length,J=["x"].concat(q||["y"]),ee=this.options.dataGrouping&&this.options.dataGrouping.groupAll,ie=0,ne=0,ae,de,he;function pe(_e){return typeof _e=="function"?_e:approximations[_e]?approximations[_e]:approximations[v.getDGApproximation&&v.getDGApproximation()||"average"]}for(Y=pe(u),Q?q.forEach(function(){j.push([])}):j.push([]),ae=Q||1,de=0;de<=L&&!(g[de]>=a[0]);de++);for(de;de<=L;de++){for(;typeof a[ie+1]<"u"&&g[de]>=a[ie+1]||de===L;){for(N=a[ie],v.dataGroupInfo={start:ee?ne:v.cropStart+ne,length:j[0].length},B=Y.apply(v,j),v.pointClass&&!defined$C(v.dataGroupInfo.options)&&(v.dataGroupInfo.options=merge$12(v.pointClass.prototype.optionsToObject.call({series:v},v.options.data[v.cropStart+ne])),J.forEach(function(_e){delete v.dataGroupInfo.options[_e]})),typeof B<"u"&&(T.push(N),P.push(B),z.push(v.dataGroupInfo)),ne=de,he=0;he<ae;he++)j[he].length=0,j[he].hasNulls=!1;if(ie+=1,de===L)break}if(de===L)break;if(q){var ve=v.options.dataGrouping&&v.options.dataGrouping.groupAll?de:v.cropStart+de,be=x&&x[ve]||v.pointClass.prototype.applyOptions.apply({series:v},[S[ve]]),ge=void 0;for(he=0;he<Q;he++)ge=be[q[he]],isNumber$y(ge)?j[he].push(ge):ge===null&&(j[he].hasNulls=!0)}else $=U?d[de]:null,isNumber$y($)?j[0].push($):$===null&&(j[0].hasNulls=!0)}return{groupedXData:T,groupedYData:P,groupMap:z}},anchorPoints=function(g,d,a){var u=g.options,v=u.dataGrouping,x=g.currentDataGrouping&&g.currentDataGrouping.gapSize,S;if(v&&g.xData&&x&&g.groupMap){var T=d.length-1,P=v.anchor,z=pick$18(v.firstAnchor,P),L=pick$18(v.lastAnchor,P);if(P&&P!=="start"){var N=x*{middle:.5,end:1}[P];for(S=d.length-1;S--&&S>0;)d[S]+=N}if(z&&z!=="start"&&g.xData[0]>=d[0]){var $=g.groupMap[0].start,B=g.groupMap[0].length,U=void 0;isNumber$y($)&&isNumber$y(B)&&(U=$+(B-1)),d[0]={middle:d[0]+.5*x,end:d[0]+x,firstPoint:g.xData[0],lastPoint:U&&g.xData[U]}[z]}if(L&&L!=="start"&&x&&d[T]>=a-x){var j=g.groupMap[g.groupMap.length-1].start;d[T]={middle:d[T]+.5*x,end:d[T]+x,firstPoint:j&&g.xData[j],lastPoint:g.xData[g.xData.length-1]}[L]}}},adjustExtremes=function(g,d){defined$C(d[0])&&isNumber$y(g.min)&&isNumber$y(g.dataMin)&&d[0]<g.min&&((!defined$C(g.options.min)&&g.min<=g.dataMin||g.min===g.dataMin)&&(g.min=Math.min(d[0],g.min)),g.dataMin=Math.min(d[0],g.dataMin)),defined$C(d[d.length-1])&&isNumber$y(g.max)&&isNumber$y(g.dataMax)&&d[d.length-1]>g.max&&((!defined$C(g.options.max)&&isNumber$y(g.dataMax)&&g.max>=g.dataMax||g.max===g.dataMax)&&(g.max=Math.max(d[d.length-1],g.max)),g.dataMax=Math.max(d[d.length-1],g.dataMax))},dataGrouping={approximations,groupData};seriesProto$3.processData;var baseGeneratePoints=seriesProto$3.generatePoints,commonOptions={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},specificOptions={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},defaultDataGroupingUnits=H.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];seriesProto$3.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};seriesProto$3.groupData=groupData;seriesProto$3.applyGrouping=applyGrouping;seriesProto$3.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(g,d){g&&(this.groupedData[d]=g.destroy?g.destroy():null)},this),this.groupedData.length=0)};seriesProto$3.generatePoints=function(){baseGeneratePoints.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null};Axis.prototype.applyGrouping=function(){var g=this,d=g.series;d.forEach(function(a){a.groupPixelWidth=void 0,a.groupPixelWidth=g.getGroupPixelWidth&&g.getGroupPixelWidth(),a.groupPixelWidth&&(a.hasProcessed=!0),a.applyGrouping()})};Axis.prototype.getGroupPixelWidth=function(){var g=this.series,d=g.length,a,u=0,v=!1,x,S;for(a=d;a--;)S=g[a].options.dataGrouping,S&&(u=Math.max(u,pick$18(S.groupPixelWidth,commonOptions.groupPixelWidth)));for(a=d;a--;)S=g[a].options.dataGrouping,S&&(x=(g[a].processedXData||g[a].data).length,(g[a].groupPixelWidth||x>this.chart.plotSizeX/u||x&&S.forced)&&(v=!0));return v?u:0};Axis.prototype.setDataGrouping=function(g,d){var a=this,u;if(d=pick$18(d,!0),g||(g={forced:!1,units:null}),this instanceof Axis)for(u=this.series.length;u--;)this.series[u].update({dataGrouping:g},!1);else this.chart.options.series.forEach(function(v){v.dataGrouping=g},!1);a.ordinal&&(a.ordinal.slope=void 0),d&&this.chart.redraw()};addEvent$R(Axis,"postProcessData",Axis.prototype.applyGrouping);addEvent$R(Point$4,"update",function(){if(this.dataGroup)return error$4(24,!1,this.series.chart),!1});addEvent$R(Tooltip,"headerFormatter",function(g){var d=this.chart,a=d.time,u=g.labelConfig,v=u.series,x=v.options,S=v.tooltipOptions,T=x.dataGrouping,P=S.xDateFormat,z,L=v.xAxis,N,$,B,U,j=S[g.isFooter?"footerFormat":"headerFormat"];L&&L.options.type==="datetime"&&T&&isNumber$y(u.key)&&(N=v.currentDataGrouping,$=T.dateTimeLabelFormats||commonOptions.dateTimeLabelFormats,N?(B=$[N.unitName],N.count===1?P=B[0]:(P=B[1],z=B[2])):!P&&$&&L.dateTime&&(P=L.dateTime.getXDateFormat(u.x,S.dateTimeLabelFormats)),U=a.dateFormat(P,u.key),z&&(U+=a.dateFormat(z,u.key+N.totalRange-1)),v.chart.styledMode&&(j=this.styledModeFormat(j)),g.text=format$8(j,{point:extend$1a(u.point,{key:U}),series:v},d),g.preventDefault())});addEvent$R(Series$f,"destroy",seriesProto$3.destroyGroupedData);addEvent$R(Series$f,"afterSetOptions",function(g){var d=g.options,a=this.type,u=this.chart.options.plotOptions,v=DefaultOptions.defaultOptions.plotOptions[a].dataGrouping,x=this.useCommonDataGrouping&&commonOptions;if(specificOptions[a]||x){v||(v=merge$12(commonOptions,specificOptions[a]));var S=this.chart.rangeSelector;d.dataGrouping=merge$12(x,v,u.series&&u.series.dataGrouping,u[a].dataGrouping,this.userOptions.dataGrouping,!d.isInternal&&S&&isNumber$y(S.selected)&&S.buttonOptions[S.selected].dataGrouping)}});addEvent$R(Axis,"afterSetScale",function(){this.series.forEach(function(g){g.hasProcessed=!1})});H.dataGrouping=dataGrouping;var __extends$24=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),ColumnSeries$g=SeriesRegistry$1.seriesTypes.column,OHLCPoint=(function(g){__extends$24(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.close=void 0,a.high=void 0,a.low=void 0,a.open=void 0,a.options=void 0,a.plotClose=void 0,a.plotOpen=void 0,a.series=void 0,a}return d.prototype.getClassName=function(){return g.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")},d.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)},d.prototype.resolveColor=function(){g.prototype.resolveColor.call(this),this.resolveUpColor()},d.prototype.getZone=function(){var a=g.prototype.getZone.call(this);return this.resolveUpColor(),a},d.prototype.applyOptions=function(){return g.prototype.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this},d})(ColumnSeries$g.prototype.pointClass),__extends$23=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),ColumnSeries$f=SeriesRegistry$1.seriesTypes.column,extend$19=Utilities.extend,merge$11=Utilities.merge,OHLCSeries$1=(function(g){__extends$23(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a.yData=void 0,a}return d.prototype.drawPoints=function(){var a=this,u=a.points,v=a.chart,x=function(S,T,P){var z=S[0],L=S[1];typeof z[2]=="number"&&(z[2]=Math.max(P+T,z[2])),typeof L[2]=="number"&&(L[2]=Math.min(P-T,L[2]))};u.forEach(function(S){var T,P,z,L,N,$=S.graphic,B,U=!$,j;typeof S.plotY<"u"&&($||(S.graphic=$=v.renderer.path().add(a.group)),v.styledMode||$.attr(a.pointAttribs(S,S.selected&&"select")),j=$.strokeWidth(),z=j%2/2,B=Math.round(S.plotX)-z,L=Math.round(S.shapeArgs.width/2),N=[["M",B,Math.round(S.yBottom)],["L",B,Math.round(S.plotHigh)]],S.open!==null&&(T=Math.round(S.plotOpen)+z,N.push(["M",B,T],["L",B-L,T]),x(N,j/2,T)),S.close!==null&&(P=Math.round(S.plotClose)+z,N.push(["M",B,P],["L",B+L,P]),x(N,j/2,P)),$[U?"attr":"animate"]({d:N}).addClass(S.getClassName(),!0))})},d.prototype.init=function(){g.prototype.init.apply(this,arguments),this.options.stacking=void 0},d.prototype.pointAttribs=function(a,u){var v=g.prototype.pointAttribs.call(this,a,u),x=this.options;return delete v.fill,!a.options.color&&x.upColor&&a.open<a.close&&(v.stroke=x.upColor),v},d.prototype.toYData=function(a){return[a.open,a.high,a.low,a.close]},d.prototype.translate=function(){var a=this,u=a.yAxis,v=!!a.modifyValue,x=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];g.prototype.translate.apply(a),a.points.forEach(function(S){[S.open,S.high,S.low,S.close,S.low].forEach(function(T,P){T!==null&&(v&&(T=a.modifyValue(T)),S[x[P]]=u.toPixels(T,!0))}),S.tooltipPos[1]=S.plotHigh+u.pos-a.chart.plotTop})},d.defaultOptions=merge$11(ColumnSeries$f.defaultOptions,{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}),d})(ColumnSeries$f);extend$19(OHLCSeries$1.prototype,{animate:null,directTouch:!1,pointArrayMap:["open","high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});OHLCSeries$1.prototype.pointClass=OHLCPoint;SeriesRegistry$1.registerSeriesType("ohlc",OHLCSeries$1);var __extends$22=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),defaultOptions$c=DefaultOptions.defaultOptions,_a$d=SeriesRegistry$1.seriesTypes,ColumnSeries$e=_a$d.column,OHLCSeries=_a$d.ohlc,merge$10=Utilities.merge,CandlestickSeries=(function(g){__extends$22(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.pointAttribs=function(a,u){var v=ColumnSeries$e.prototype.pointAttribs.call(this,a,u),x=this.options,S=a.open<a.close,T=x.lineColor||this.color,P=a.color||this.color,z;return v["stroke-width"]=x.lineWidth,v.fill=a.options.color||S&&x.upColor||P,v.stroke=a.options.lineColor||S&&x.upLineColor||T,u&&(z=x.states[u],v.fill=z.color||v.fill,v.stroke=z.lineColor||v.stroke,v["stroke-width"]=z.lineWidth||v["stroke-width"]),v},d.prototype.drawPoints=function(){var a=this,u=a.points,v=a.chart,x=a.yAxis.reversed;u.forEach(function(S){var T=S.graphic,P,z,L,N,$,B,U,j,Y,q,Q=!T;typeof S.plotY<"u"&&(T||(S.graphic=T=v.renderer.path().add(a.group)),a.chart.styledMode||T.attr(a.pointAttribs(S,S.selected&&"select")).shadow(a.options.shadow),U=T.strokeWidth()%2/2,j=Math.round(S.plotX)-U,P=S.plotOpen,z=S.plotClose,L=Math.min(P,z),N=Math.max(P,z),q=Math.round(S.shapeArgs.width/2),$=x?N!==S.yBottom:Math.round(L)!==Math.round(S.plotHigh),B=x?Math.round(L)!==Math.round(S.plotHigh):N!==S.yBottom,L=Math.round(L)+U,N=Math.round(N)+U,Y=[],Y.push(["M",j-q,N],["L",j-q,L],["L",j+q,L],["L",j+q,N],["Z"],["M",j,L],["L",j,$?Math.round(x?S.yBottom:S.plotHigh):L],["M",j,N],["L",j,B?Math.round(x?S.plotHigh:S.yBottom):N]),T[Q?"attr":"animate"]({d:Y}).addClass(S.getClassName(),!0))})},d.defaultOptions=merge$10(OHLCSeries.defaultOptions,defaultOptions$c.plotOptions,{states:{hover:{lineWidth:2}},tooltip:defaultOptions$c.plotOptions.ohlc.tooltip,threshold:null,lineColor:palette.neutralColor100,lineWidth:1,upColor:palette.backgroundColor,stickyTracking:!0}),d})(OHLCSeries);SeriesRegistry$1.registerSeriesType("candlestick",CandlestickSeries);var __extends$21=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),ColumnSeries$d=SeriesRegistry$1.seriesTypes.column,isNumber$x=Utilities.isNumber,FlagsPoint=(function(g){__extends$21(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.options=void 0,a.series=void 0,a}return d.prototype.isValid=function(){return isNumber$x(this.y)||typeof this.y>"u"},d.prototype.hasNewShapeType=function(){var a=this.options.shape||this.series.options.shape;return this.graphic&&a&&a!==this.graphic.symbolKey},d})(ColumnSeries$d.prototype.pointClass),columnProto$5=ColumnSeries$h.prototype,seriesProto$2=Series$f.prototype,defined$B=Utilities.defined,stableSort$4=Utilities.stableSort,onSeriesMixin={getPlotBox:function(){return seriesProto$2.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){columnProto$5.translate.apply(this);var g=this,d=g.options,a=g.chart,u=g.points,v=u.length-1,x,S,T=d.onSeries,P=T&&a.get(T),z=d.onKey||"y",L=P&&P.options.step,N=P&&P.points,$=N&&N.length,B=a.inverted,U=g.xAxis,j=g.yAxis,Y=0,q,Q,J,ee,ie;if(P&&P.visible&&$)for(Y=(P.pointXOffset||0)+(P.barW||0)/2,ee=P.currentDataGrouping,Q=N[$-1].x+(ee?ee.totalRange:0),stableSort$4(u,function(ne,ae){return ne.x-ae.x}),z="plot"+z[0].toUpperCase()+z.substr(1);$--&&u[v]&&(q=N[$],x=u[v],x.y=q.y,!(q.x<=x.x&&typeof q[z]<"u"&&(x.x<=Q&&(x.plotY=q[z],q.x<x.x&&!L&&(J=N[$+1],J&&typeof J[z]<"u"&&(ie=(x.x-q.x)/(J.x-q.x),x.plotY+=ie*(J[z]-q[z]),x.y+=ie*(J.y-q.y)))),v--,$++,v<0))););u.forEach(function(ne,ae){var de;ne.plotX+=Y,(typeof ne.plotY>"u"||B)&&(ne.plotX>=0&&ne.plotX<=U.len?B?(ne.plotY=U.translate(ne.x,0,1,0,1),ne.plotX=defined$B(ne.y)?j.translate(ne.y,0,0,0,1):0):ne.plotY=(U.opposite?0:g.yAxis.len)+U.offset:ne.shapeArgs={}),S=u[ae-1],S&&S.plotX===ne.plotX&&(typeof S.stackIndex>"u"&&(S.stackIndex=0),de=S.stackIndex+1),ne.stackIndex=de}),this.onSeries=P}},symbols$4=SVGRenderer.prototype.symbols;symbols$4.flag=function(g,d,a,u,v){var x=v&&v.anchorX||g,S=v&&v.anchorY||d,T=symbols$4.circle(x-1,S-1,2,2);return T.push(["M",x,S],["L",g,d+u],["L",g,d],["L",g+a,d],["L",g+a,d+u],["L",g,d+u],["Z"]),T};function createPinSymbol(g){symbols$4[g+"pin"]=function(d,a,u,v,x){var S=x&&x.anchorX,T=x&&x.anchorY,P;if(g==="circle"&&v>u&&(d-=Math.round((v-u)/2),u=v),P=symbols$4[g](d,a,u,v),S&&T){var z=S;if(g==="circle")z=d+u/2;else{var L=P[0],N=P[1];L[0]==="M"&&N[0]==="L"&&(z=(L[1]+N[1])/2)}var $=a>T?a:a+v;P.push(["M",z,$],["L",S,T]),P=P.concat(symbols$4.circle(S-1,T-1,2,2))}return P}}createPinSymbol("circle");createPinSymbol("square");var Renderer=RendererRegistry$1.getRendererType();Renderer!==SVGRenderer&&(Renderer.prototype.symbols.circlepin=symbols$4.circlepin,Renderer.prototype.symbols.flag=symbols$4.flag,Renderer.prototype.symbols.squarepin=symbols$4.squarepin);var __extends$20=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),noop$d=H.noop,distribute=R.distribute,Series$c=SeriesRegistry$1.series,ColumnSeries$c=SeriesRegistry$1.seriesTypes.column,addEvent$Q=Utilities.addEvent,defined$A=Utilities.defined,extend$18=Utilities.extend,merge$$=Utilities.merge,objectEach$g=Utilities.objectEach,wrap$f=Utilities.wrap,FlagsSeries=(function(g){__extends$20(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.animate=function(a){a&&this.setClip()},d.prototype.drawPoints=function(){var a=this,u=a.points,v=a.chart,x=v.renderer,S,T,P=v.inverted,z=a.options,L=z.y,N,$,B,U,j,Y,q,Q,J=a.yAxis,ee={},ie=[],ne;for($=u.length;$--;)B=u[$],Q=(P?B.plotY:B.plotX)>a.xAxis.len,S=B.plotX,j=B.stackIndex,N=B.options.shape||z.shape,T=B.plotY,typeof T<"u"&&(T=B.plotY+L-(typeof j<"u"&&j*z.stackDistance)),B.anchorX=j?void 0:B.plotX,Y=j?void 0:B.plotY,ne=N!=="flag",U=B.graphic,typeof T<"u"&&S>=0&&!Q?(U&&B.hasNewShapeType()&&(U=U.destroy()),U||(U=B.graphic=x.label("",null,null,N,null,null,z.useHTML).addClass("highcharts-point").add(a.markerGroup),B.graphic.div&&(B.graphic.div.point=B),U.isNew=!0),U.attr({align:ne?"center":"left",width:z.width,height:z.height,"text-align":z.textAlign}),v.styledMode||U.attr(a.pointAttribs(B)).css(merge$$(z.style,B.style)).shadow(z.shadow),S>0&&(S-=U.strokeWidth()%2),q={y:T,anchorY:Y},z.allowOverlapX&&(q.x=S,q.anchorX=B.anchorX),U.attr({text:B.options.title||z.title||"A"})[U.isNew?"attr":"animate"](q),z.allowOverlapX||(ee[B.plotX]?ee[B.plotX].size=Math.max(ee[B.plotX].size,U.width):ee[B.plotX]={align:ne?.5:0,size:U.width,target:S,anchorX:S}),B.tooltipPos=[S,T+J.pos-v.plotTop]):U&&(B.graphic=U.destroy());z.allowOverlapX||(objectEach$g(ee,function(ae){ae.plotX=ae.anchorX,ie.push(ae)}),distribute(ie,P?J.len:this.xAxis.len,100),u.forEach(function(ae){var de=ae.graphic&&ee[ae.plotX];de&&(ae.graphic[ae.graphic.isNew?"attr":"animate"]({x:de.pos+de.align*de.size,anchorX:ae.anchorX}),defined$A(de.pos)?ae.graphic.isNew=!1:(ae.graphic.attr({x:-9999,anchorX:-9999}),ae.graphic.isNew=!0))})),z.useHTML&&wrap$f(a.markerGroup,"on",function(ae){return SVGElement.prototype.on.apply(ae.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},d.prototype.drawTracker=function(){var a=this,u=a.points;g.prototype.drawTracker.call(this),u.forEach(function(v){var x=v.graphic;x&&(v.unbindMouseOver&&v.unbindMouseOver(),v.unbindMouseOver=addEvent$Q(x.element,"mouseover",function(){v.stackIndex>0&&!v.raised&&(v._y=x.y,x.attr({y:v._y-8}),v.raised=!0),u.forEach(function(S){S!==v&&S.raised&&S.graphic&&(S.graphic.attr({y:S._y}),S.raised=!1)})}))})},d.prototype.pointAttribs=function(a,u){var v=this.options,x=a&&a.color||this.color,S=v.lineColor,T=a&&a.lineWidth,P=a&&a.fillColor||v.fillColor;return u&&(P=v.states[u].fillColor,S=v.states[u].lineColor,T=v.states[u].lineWidth),{fill:P||x,stroke:S||x,"stroke-width":T||v.lineWidth||0}},d.prototype.setClip=function(){Series$c.prototype.setClip.apply(this,arguments),this.options.clip!==!1&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])},d.defaultOptions=merge$$(ColumnSeries$c.defaultOptions,{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:palette.backgroundColor,lineWidth:1,states:{hover:{lineColor:palette.neutralColor100,fillColor:palette.highlightColor20}},style:{fontSize:"11px",fontWeight:"bold"}}),d})(ColumnSeries$c);extend$18(FlagsSeries.prototype,{allowDG:!1,buildKDTree:noop$d,forceCrop:!0,getPlotBox:onSeriesMixin.getPlotBox,init:Series$c.prototype.init,invertGroups:noop$d,invertible:!1,noSharedTooltip:!0,pointClass:FlagsPoint,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],translate:onSeriesMixin.translate});SeriesRegistry$1.registerSeriesType("flags",FlagsSeries);var addEvent$P=Utilities.addEvent,defined$z=Utilities.defined,pick$17=Utilities.pick,ScrollbarAxis=(function(){function g(){}return g.compose=function(d,a){if(g.composed.indexOf(d)===-1)g.composed.push(d);else return d;var u=function(v){var x=pick$17(v.options&&v.options.min,v.min),S=pick$17(v.options&&v.options.max,v.max);return{axisMin:x,axisMax:S,scrollMin:defined$z(v.dataMin)?Math.min(x,v.min,v.dataMin,pick$17(v.threshold,1/0)):x,scrollMax:defined$z(v.dataMax)?Math.max(S,v.max,v.dataMax,pick$17(v.threshold,-1/0)):S}};return addEvent$P(d,"afterInit",function(){var v=this;v.options&&v.options.scrollbar&&v.options.scrollbar.enabled&&(v.options.scrollbar.vertical=!v.horiz,v.options.startOnTick=v.options.endOnTick=!1,v.scrollbar=new a(v.chart.renderer,v.options.scrollbar,v.chart),addEvent$P(v.scrollbar,"changed",function(x){var S=u(v),T=S.axisMin,P=S.axisMax,z=S.scrollMin,L=S.scrollMax,N=L-z,$,B;!defined$z(T)||!defined$z(P)||(v.horiz&&!v.reversed||!v.horiz&&v.reversed?($=z+N*this.to,B=z+N*this.from):($=z+N*(1-this.from),B=z+N*(1-this.to)),this.shouldUpdateExtremes(x.DOMType)?v.setExtremes(B,$,!0,x.DOMType!=="mousemove"&&x.DOMType!=="touchmove",x):this.setRange(this.from,this.to))}))}),addEvent$P(d,"afterRender",function(){var v=this,x=u(v),S=x.scrollMin,T=x.scrollMax,P=v.scrollbar,z=v.axisTitleMargin+(v.titleOffset||0),L=v.chart.scrollbarsOffsets,N=v.options.margin||0,$,B,U;P&&(v.horiz?(v.opposite||(L[1]+=z),P.position(v.left,v.top+v.height+2+L[1]-(v.opposite?N:0),v.width,v.height),v.opposite||(L[1]+=N),$=1):(v.opposite&&(L[0]+=z),P.position(v.left+v.width+2+L[0]-(v.opposite?0:N),v.top,v.width,v.height),v.opposite&&(L[0]+=N),$=0),L[$]+=P.size+P.options.margin,isNaN(S)||isNaN(T)||!defined$z(v.min)||!defined$z(v.max)||v.min===v.max?P.setRange(0,1):(B=(v.min-S)/(T-S),U=(v.max-S)/(T-S),v.horiz&&!v.reversed||!v.horiz&&v.reversed?P.setRange(B,U):P.setRange(1-U,1-B)))}),addEvent$P(d,"afterGetOffset",function(){var v=this,x=v.horiz?2:1,S=v.scrollbar;S&&(v.chart.scrollbarsOffsets=[0,0],v.chart.axisOffset[x]+=S.size+S.options.margin)}),d},g.composed=[],g})(),isTouchDevice$3=H.isTouchDevice,ScrollbarDefaults={height:isTouchDevice$3?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:palette.neutralColor20,barBorderWidth:1,barBorderColor:palette.neutralColor20,buttonArrowColor:palette.neutralColor80,buttonBackgroundColor:palette.neutralColor10,buttonBorderColor:palette.neutralColor20,buttonBorderWidth:1,rifleColor:palette.neutralColor80,trackBackgroundColor:palette.neutralColor5,trackBorderColor:palette.neutralColor5,trackBorderWidth:1},defaultOptions$b=DefaultOptions.defaultOptions,addEvent$O=Utilities.addEvent,correctFloat$6=Utilities.correctFloat,defined$y=Utilities.defined,destroyObjectProperties$3=Utilities.destroyObjectProperties,fireEvent$l=Utilities.fireEvent,merge$_=Utilities.merge,pick$16=Utilities.pick,removeEvent$4=Utilities.removeEvent,Scrollbar=(function(){function g(d,a,u){this._events=[],this.chart=void 0,this.chartX=0,this.chartY=0,this.from=0,this.group=void 0,this.options=void 0,this.renderer=void 0,this.scrollbar=void 0,this.scrollbarButtons=[],this.scrollbarGroup=void 0,this.scrollbarLeft=0,this.scrollbarRifles=void 0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.track=void 0,this.trackBorderWidth=1,this.userOptions=void 0,this.x=0,this.y=0,this.init(d,a,u)}return g.compose=function(d){ScrollbarAxis.compose(d,g)},g.swapXY=function(d,a){return a&&d.forEach(function(u){for(var v=u.length,x,S=0;S<v;S+=2)x=u[S+1],typeof x=="number"&&(u[S+1]=u[S+2],u[S+2]=x)}),d},g.prototype.addEvents=function(){var d=this.options.inverted?[1,0]:[0,1],a=this.scrollbarButtons,u=this.scrollbarGroup.element,v=this.track.element,x=this.mouseDownHandler.bind(this),S=this.mouseMoveHandler.bind(this),T=this.mouseUpHandler.bind(this),P=[[a[d[0]].element,"click",this.buttonToMinClick.bind(this)],[a[d[1]].element,"click",this.buttonToMaxClick.bind(this)],[v,"click",this.trackClick.bind(this)],[u,"mousedown",x],[u.ownerDocument,"mousemove",S],[u.ownerDocument,"mouseup",T]];H.hasTouch&&P.push([u,"touchstart",x],[u.ownerDocument,"touchmove",S],[u.ownerDocument,"touchend",T]),P.forEach(function(z){addEvent$O.apply(null,z)}),this._events=P},g.prototype.buttonToMaxClick=function(d){var a=this,u=(a.to-a.from)*pick$16(a.options.step,.2);a.updatePosition(a.from+u,a.to+u),fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:d})},g.prototype.buttonToMinClick=function(d){var a=this,u=correctFloat$6(a.to-a.from)*pick$16(a.options.step,.2);a.updatePosition(correctFloat$6(a.from-u),correctFloat$6(a.to-u)),fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:d})},g.prototype.cursorToScrollbarPosition=function(d){var a=this,u=a.options,v=u.minWidth>a.calculatedWidth?u.minWidth:0;return{chartX:(d.chartX-a.x-a.xOffset)/(a.barWidth-v),chartY:(d.chartY-a.y-a.yOffset)/(a.barWidth-v)}},g.prototype.destroy=function(){var d=this,a=d.chart.scroller;d.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(u){d[u]&&d[u].destroy&&(d[u]=d[u].destroy())}),a&&d===a.scrollbar&&(a.scrollbar=null,destroyObjectProperties$3(a.scrollbarButtons))},g.prototype.drawScrollbarButton=function(d){var a=this,u=a.renderer,v=a.scrollbarButtons,x=a.options,S=a.size,T=u.g().add(a.group),P;v.push(T),P=u.rect().addClass("highcharts-scrollbar-button").add(T),a.chart.styledMode||P.attr({stroke:x.buttonBorderColor,"stroke-width":x.buttonBorderWidth,fill:x.buttonBackgroundColor}),P.attr(P.crisp({x:-.5,y:-.5,width:S+1,height:S+1,r:x.buttonBorderRadius},P.strokeWidth())),P=u.path(g.swapXY([["M",S/2+(d?-1:1),S/2-3],["L",S/2+(d?-1:1),S/2+3],["L",S/2+(d?2:-2),S/2]],x.vertical)).addClass("highcharts-scrollbar-arrow").add(v[d]),a.chart.styledMode||P.attr({fill:x.buttonArrowColor})},g.prototype.init=function(d,a,u){var v=this;v.scrollbarButtons=[],v.renderer=d,v.userOptions=a,v.options=merge$_(ScrollbarDefaults,defaultOptions$b.scrollbar,a),v.chart=u,v.size=pick$16(v.options.size,v.options.height),a.enabled&&(v.render(),v.addEvents())},g.prototype.mouseDownHandler=function(d){var a=this,u=a.chart.pointer.normalize(d),v=a.cursorToScrollbarPosition(u);a.chartX=v.chartX,a.chartY=v.chartY,a.initPositions=[a.from,a.to],a.grabbedCenter=!0},g.prototype.mouseMoveHandler=function(d){var a=this,u=a.chart.pointer.normalize(d),v=a.options,x=v.vertical?"chartY":"chartX",S=a.initPositions||[],T,P,z;a.grabbedCenter&&(!d.touches||d.touches[0][x]!==0)&&(P=a.cursorToScrollbarPosition(u)[x],T=a[x],z=P-T,a.hasDragged=!0,a.updatePosition(S[0]+z,S[1]+z),a.hasDragged&&fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMType:d.type,DOMEvent:d}))},g.prototype.mouseUpHandler=function(d){var a=this;a.hasDragged&&fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMType:d.type,DOMEvent:d}),a.grabbedCenter=a.hasDragged=a.chartX=a.chartY=null},g.prototype.position=function(d,a,u,v){var x=this,S=x.options,T=S.vertical,P=x.rendered?"animate":"attr",z=v,L=0;x.x=d,x.y=a+this.trackBorderWidth,x.width=u,x.height=v,x.xOffset=z,x.yOffset=L,T?(x.width=x.yOffset=u=L=x.size,x.xOffset=z=0,x.barWidth=v-u*2,x.x=d=d+x.options.margin):(x.height=x.xOffset=v=z=x.size,x.barWidth=u-v*2,x.y=x.y+x.options.margin),x.group[P]({translateX:d,translateY:x.y}),x.track[P]({width:u,height:v}),x.scrollbarButtons[1][P]({translateX:T?0:u-z,translateY:T?v-L:0})},g.prototype.removeEvents=function(){this._events.forEach(function(d){removeEvent$4.apply(null,d)}),this._events.length=0},g.prototype.render=function(){var d=this,a=d.renderer,u=d.options,v=d.size,x=d.chart.styledMode,S=a.g("scrollbar").attr({zIndex:u.zIndex,translateY:-99999}).add();d.group=S,d.track=a.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:u.trackBorderRadius||0,height:v,width:v}).add(S),x||d.track.attr({fill:u.trackBackgroundColor,stroke:u.trackBorderColor,"stroke-width":u.trackBorderWidth}),d.trackBorderWidth=d.track.strokeWidth(),d.track.attr({y:-this.trackBorderWidth%2/2}),d.scrollbarGroup=a.g().add(S),d.scrollbar=a.rect().addClass("highcharts-scrollbar-thumb").attr({height:v,width:v,r:u.barBorderRadius||0}).add(d.scrollbarGroup),d.scrollbarRifles=a.path(g.swapXY([["M",-3,v/4],["L",-3,2*v/3],["M",0,v/4],["L",0,2*v/3],["M",3,v/4],["L",3,2*v/3]],u.vertical)).addClass("highcharts-scrollbar-rifles").add(d.scrollbarGroup),x||(d.scrollbar.attr({fill:u.barBackgroundColor,stroke:u.barBorderColor,"stroke-width":u.barBorderWidth}),d.scrollbarRifles.attr({stroke:u.rifleColor,"stroke-width":1})),d.scrollbarStrokeWidth=d.scrollbar.strokeWidth(),d.scrollbarGroup.translate(-d.scrollbarStrokeWidth%2/2,-d.scrollbarStrokeWidth%2/2),d.drawScrollbarButton(0),d.drawScrollbarButton(1)},g.prototype.setRange=function(d,a){var u=this,v=u.options,x=v.vertical,S=v.minWidth,T=u.barWidth,P=this.rendered&&!this.hasDragged&&!(this.chart.navigator&&this.chart.navigator.hasDragged)?"animate":"attr";if(defined$y(T)){var z=T*Math.min(a,1),L,N;d=Math.max(d,0),L=Math.ceil(T*d),u.calculatedWidth=N=correctFloat$6(z-L),N<S&&(L=(T-S+N)*d,N=S);var $=Math.floor(L+u.xOffset+u.yOffset),B=N/2-.5;u.from=d,u.to=a,x?(u.scrollbarGroup[P]({translateY:$}),u.scrollbar[P]({height:N}),u.scrollbarRifles[P]({translateY:B}),u.scrollbarTop=$,u.scrollbarLeft=0):(u.scrollbarGroup[P]({translateX:$}),u.scrollbar[P]({width:N}),u.scrollbarRifles[P]({translateX:B}),u.scrollbarLeft=$,u.scrollbarTop=0),N<=12?u.scrollbarRifles.hide():u.scrollbarRifles.show(!0),v.showFull===!1&&(d<=0&&a>=1?u.group.hide():u.group.show()),u.rendered=!0}},g.prototype.shouldUpdateExtremes=function(d){return pick$16(this.options.liveRedraw,H.svg&&!H.isTouchDevice&&!this.chart.isBoosting)||d==="mouseup"||d==="touchend"||!defined$y(d)},g.prototype.trackClick=function(d){var a=this,u=a.chart.pointer.normalize(d),v=a.to-a.from,x=a.y+a.scrollbarTop,S=a.x+a.scrollbarLeft;a.options.vertical&&u.chartY>x||!a.options.vertical&&u.chartX>S?a.updatePosition(a.from+v,a.to+v):a.updatePosition(a.from-v,a.to-v),fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:d})},g.prototype.update=function(d){this.destroy(),this.init(this.chart.renderer,merge$_(!0,this.options,d),this.chart)},g.prototype.updatePosition=function(d,a){a>1&&(d=correctFloat$6(1-correctFloat$6(a-d)),a=1),d<0&&(a=correctFloat$6(a-d),d=0),this.from=d,this.to=a},g.defaultOptions=ScrollbarDefaults,g})();defaultOptions$b.scrollbar=merge$_(!0,Scrollbar.defaultOptions,defaultOptions$b.scrollbar);var isTouchDevice$2=H.isTouchDevice,addEvent$N=Utilities.addEvent,correctFloat$5=Utilities.correctFloat,defined$x=Utilities.defined,isNumber$w=Utilities.isNumber,pick$15=Utilities.pick,NavigatorAxisAdditions=(function(){function g(d){this.axis=d}return g.prototype.destroy=function(){this.axis=void 0},g.prototype.toFixedRange=function(d,a,u,v){var x=this,S=x.axis,T=S.chart,P=T&&T.fixedRange,z=(S.pointRange||0)/2,L=pick$15(u,S.translate(d,!0,!S.horiz)),N=pick$15(v,S.translate(a,!0,!S.horiz)),$=P&&(N-L)/P;return defined$x(u)||(L=correctFloat$5(L+z)),defined$x(v)||(N=correctFloat$5(N-z)),$>.7&&$<1.3&&(v?L=N-P:N=L+P),(!isNumber$w(L)||!isNumber$w(N))&&(L=N=void 0),{min:L,max:N}},g})(),NavigatorAxis=(function(){function g(){}return g.compose=function(d){d.keepProps.push("navigatorAxis"),addEvent$N(d,"init",function(){var a=this;a.navigatorAxis||(a.navigatorAxis=new NavigatorAxisAdditions(a))}),addEvent$N(d,"zoom",function(a){var u=this,v=u.chart,x=v.options,S=x.navigator,T=u.navigatorAxis,P=x.chart.pinchType,z=x.rangeSelector,L=x.chart.zoomType,N;u.isXAxis&&(S&&S.enabled||z&&z.enabled)&&(L==="y"?a.zoomed=!1:(!isTouchDevice$2&&L==="xy"||isTouchDevice$2&&P==="xy")&&u.options.range&&(N=T.previousZoom,defined$x(a.newMin)?T.previousZoom=[u.min,u.max]:N&&(a.newMin=N[0],a.newMax=N[1],T.previousZoom=void 0))),typeof a.zoomed<"u"&&a.preventDefault()})},g.AdditionsClass=NavigatorAxisAdditions,g})(),color$b=Color.parse,hasTouch=H.hasTouch,isTouchDevice$1=H.isTouchDevice,defaultOptions$a=DefaultOptions.defaultOptions,seriesTypes$6=SeriesRegistry$1.seriesTypes,addEvent$M=Utilities.addEvent,clamp$c=Utilities.clamp,correctFloat$4=Utilities.correctFloat,defined$w=Utilities.defined,destroyObjectProperties$2=Utilities.destroyObjectProperties,erase$2=Utilities.erase,extend$17=Utilities.extend,find$e=Utilities.find,isArray$b=Utilities.isArray,isNumber$v=Utilities.isNumber,merge$Z=Utilities.merge,pick$14=Utilities.pick,removeEvent$3=Utilities.removeEvent,splat$b=Utilities.splat,defaultSeriesType,numExt=function(g){for(var d=[],a=1;a<arguments.length;a++)d[a-1]=arguments[a];var u=[].filter.call(d,isNumber$v);if(u.length)return Math[g].apply(0,u)};defaultSeriesType=typeof seriesTypes$6.areaspline>"u"?"line":"areaspline";extend$17(defaultOptions$a,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:palette.neutralColor5,borderColor:palette.neutralColor40},maskFill:color$b(palette.highlightColor60).setOpacity(.3).get(),outlineColor:palette.neutralColor20,outlineWidth:1,series:{type:defaultSeriesType,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:palette.neutralColor10,gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:palette.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});RendererRegistry$1.getRendererType().prototype.symbols["navigator-handle"]=function(g,d,a,u,v){var x=(v&&v.width||0)/2,S=Math.round(x/3)+.5,T=v&&v.height||0;return[["M",-x-1,.5],["L",x,.5],["L",x,T+.5],["L",-x-1,T+.5],["L",-x-1,.5],["M",-S,4],["L",-S,T-3],["M",S-1,4],["L",S-1,T-3]]};var Navigator=(function(){function g(d){this.baseSeries=void 0,this.chart=void 0,this.handles=void 0,this.height=void 0,this.left=void 0,this.navigatorEnabled=void 0,this.navigatorGroup=void 0,this.navigatorOptions=void 0,this.navigatorSeries=void 0,this.navigatorSize=void 0,this.opposite=void 0,this.outline=void 0,this.outlineHeight=void 0,this.range=void 0,this.rendered=void 0,this.shades=void 0,this.size=void 0,this.top=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zoomedMax=void 0,this.zoomedMin=void 0,this.init(d)}return g.prototype.drawHandle=function(d,a,u,v){var x=this,S=x.navigatorOptions.handles.height;x.handles[a][v](u?{translateX:Math.round(x.left+x.height/2),translateY:Math.round(x.top+parseInt(d,10)+.5-S)}:{translateX:Math.round(x.left+parseInt(d,10)),translateY:Math.round(x.top+x.height/2-S/2-1)})},g.prototype.drawOutline=function(d,a,u,v){var x=this,S=x.navigatorOptions.maskInside,T=x.outline.strokeWidth(),P=T/2,z=T%2/2,L=x.outlineHeight,N=x.scrollbarHeight||0,$=x.size,B=x.left-N,U=x.top,j,Y;u?(B-=P,j=U+a+z,a=U+d+z,Y=[["M",B+L,U-N-z],["L",B+L,j],["L",B,j],["L",B,a],["L",B+L,a],["L",B+L,U+$+N]],S&&Y.push(["M",B+L,j-P],["L",B+L,a+P])):(d+=B+N-z,a+=B+N-z,U+=P,Y=[["M",B,U],["L",d,U],["L",d,U+L],["L",a,U+L],["L",a,U],["L",B+$+N*2,U]],S&&Y.push(["M",d-P,U],["L",a+P,U])),x.outline[v]({d:Y})},g.prototype.drawMasks=function(d,a,u,v){var x=this,S=x.left,T=x.top,P=x.height,z,L,N,$;u?(N=[S,S,S],$=[T,T+d,T+a],L=[P,P,P],z=[d,a-d,x.size-a]):(N=[S,S+d,S+a],$=[T,T,T],L=[d,a-d,x.size-a],z=[P,P,P]),x.shades.forEach(function(B,U){B[v]({x:N[U],y:$[U],width:L[U],height:z[U]})})},g.prototype.renderElements=function(){var d=this,a=d.navigatorOptions,u=a.maskInside,v=d.chart,x=v.inverted,S=v.renderer,T,P={cursor:x?"ns-resize":"ew-resize"};d.navigatorGroup=T=S.g("navigator").attr({zIndex:8,visibility:"hidden"}).add(),[!u,u,!u].forEach(function(z,L){d.shades[L]=S.rect().addClass("highcharts-navigator-mask"+(L===1?"-inside":"-outside")).add(T),v.styledMode||d.shades[L].attr({fill:z?a.maskFill:"rgba(0,0,0,0)"}).css(L===1&&P)}),d.outline=S.path().addClass("highcharts-navigator-outline").add(T),v.styledMode||d.outline.attr({"stroke-width":a.outlineWidth,stroke:a.outlineColor}),a.handles.enabled&&[0,1].forEach(function(z){if(a.handles.inverted=v.inverted,d.handles[z]=S.symbol(a.handles.symbols[z],-a.handles.width/2-1,0,a.handles.width,a.handles.height,a.handles),d.handles[z].attr({zIndex:7-z}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][z]).add(T),!v.styledMode){var L=a.handles;d.handles[z].attr({fill:L.backgroundColor,stroke:L.borderColor,"stroke-width":L.lineWidth}).css(P)}})},g.prototype.update=function(d){(this.series||[]).forEach(function(u){u.baseSeries&&delete u.baseSeries.navigatorSeries}),this.destroy();var a=this.chart.options;merge$Z(!0,a.navigator,this.options,d),this.init(this.chart)},g.prototype.render=function(d,a,u,v){var x=this,S=x.chart,T,P,z,L=x.scrollbarHeight,N,$=x.xAxis,B=$.pointRange||0,U=$.navigatorAxis.fake?S.xAxis[0]:$,j=x.navigatorEnabled,Y,q,Q=x.rendered,J=S.inverted,ee,ie,ne,ae,de=S.xAxis[0].minRange,he=S.xAxis[0].options.maxRange;if(!(this.hasDragged&&!defined$w(u))){if(d=correctFloat$4(d-B/2),a=correctFloat$4(a+B/2),!isNumber$v(d)||!isNumber$v(a))if(Q)u=0,v=pick$14($.width,U.width);else return;x.left=pick$14($.left,S.plotLeft+L+(J?S.plotWidth:0)),x.size=q=N=pick$14($.len,(J?S.plotHeight:S.plotWidth)-2*L),J?T=L:T=N+2*L,u=pick$14(u,$.toPixels(d,!0)),v=pick$14(v,$.toPixels(a,!0)),(!isNumber$v(u)||Math.abs(u)===1/0)&&(u=0,v=T),ie=$.toValue(u,!0),ne=$.toValue(v,!0),ae=Math.abs(correctFloat$4(ne-ie)),ae<de?this.grabbedLeft?u=$.toPixels(ne-de-B,!0):this.grabbedRight&&(v=$.toPixels(ie+de+B,!0)):defined$w(he)&&correctFloat$4(ae-B)>he&&(this.grabbedLeft?u=$.toPixels(ne-he-B,!0):this.grabbedRight&&(v=$.toPixels(ie+he+B,!0))),x.zoomedMax=clamp$c(Math.max(u,v),0,q),x.zoomedMin=clamp$c(x.fixedWidth?x.zoomedMax-x.fixedWidth:Math.min(u,v),0,q),x.range=x.zoomedMax-x.zoomedMin,q=Math.round(x.zoomedMax),Y=Math.round(x.zoomedMin),j&&(x.navigatorGroup.attr({visibility:"visible"}),ee=Q&&!x.hasDragged?"animate":"attr",x.drawMasks(Y,q,J,ee),x.drawOutline(Y,q,J,ee),x.navigatorOptions.handles.enabled&&(x.drawHandle(Y,0,J,ee),x.drawHandle(q,1,J,ee))),x.scrollbar&&(J?(z=x.top-L,P=x.left-L+(j||!U.opposite?0:(U.titleOffset||0)+U.axisTitleMargin),L=N+2*L):(z=x.top+(j?x.height:-L),P=x.left-L),x.scrollbar.position(P,z,T,L),x.scrollbar.setRange(x.zoomedMin/(N||1),x.zoomedMax/(N||1))),x.rendered=!0}},g.prototype.addMouseEvents=function(){var d=this,a=d.chart,u=a.container,v=[],x,S;d.mouseMoveHandler=x=function(T){d.onMouseMove(T)},d.mouseUpHandler=S=function(T){d.onMouseUp(T)},v=d.getPartsEvents("mousedown"),v.push(addEvent$M(a.renderTo,"mousemove",x),addEvent$M(u.ownerDocument,"mouseup",S)),hasTouch&&(v.push(addEvent$M(a.renderTo,"touchmove",x),addEvent$M(u.ownerDocument,"touchend",S)),v.concat(d.getPartsEvents("touchstart"))),d.eventsToUnbind=v,d.series&&d.series[0]&&v.push(addEvent$M(d.series[0].xAxis,"foundExtremes",function(){a.navigator.modifyNavigatorAxisExtremes()}))},g.prototype.getPartsEvents=function(d){var a=this,u=[];return["shades","handles"].forEach(function(v){a[v].forEach(function(x,S){u.push(addEvent$M(x.element,d,function(T){a[v+"Mousedown"](T,S)}))})}),u},g.prototype.shadesMousedown=function(d,a){d=this.chart.pointer.normalize(d);var u=this,v=u.chart,x=u.xAxis,S=u.zoomedMin,T=u.left,P=u.size,z=u.range,L=d.chartX,N,$,B,U;v.inverted&&(L=d.chartY,T=u.top),a===1?(u.grabbedCenter=L,u.fixedWidth=z,u.dragOffset=L-S):(U=L-T-z/2,a===0?U=Math.max(0,U):a===2&&U+z>=P&&(U=P-z,u.reversedExtremes?(U-=z,$=u.getUnionExtremes().dataMin):N=u.getUnionExtremes().dataMax),U!==S&&(u.fixedWidth=z,B=x.navigatorAxis.toFixedRange(U,U+z,$,N),defined$w(B.min)&&v.xAxis[0].setExtremes(Math.min(B.min,B.max),Math.max(B.min,B.max),!0,null,{trigger:"navigator"})))},g.prototype.handlesMousedown=function(d,a){d=this.chart.pointer.normalize(d);var u=this,v=u.chart,x=v.xAxis[0],S=u.reversedExtremes;a===0?(u.grabbedLeft=!0,u.otherHandlePos=u.zoomedMax,u.fixedExtreme=S?x.min:x.max):(u.grabbedRight=!0,u.otherHandlePos=u.zoomedMin,u.fixedExtreme=S?x.max:x.min),v.fixedRange=null},g.prototype.onMouseMove=function(d){var a=this,u=a.chart,v=a.left,x=a.navigatorSize,S=a.range,T=a.dragOffset,P=u.inverted,z;(!d.touches||d.touches[0].pageX!==0)&&(d=u.pointer.normalize(d),z=d.chartX,P&&(v=a.top,z=d.chartY),a.grabbedLeft?(a.hasDragged=!0,a.render(0,0,z-v,a.otherHandlePos)):a.grabbedRight?(a.hasDragged=!0,a.render(0,0,a.otherHandlePos,z-v)):a.grabbedCenter&&(a.hasDragged=!0,z<T?z=T:z>x+T-S&&(z=x+T-S),a.render(0,0,z-T,z-T+S)),a.hasDragged&&a.scrollbar&&pick$14(a.scrollbar.options.liveRedraw,H.svg&&!isTouchDevice$1&&!this.chart.isBoosting)&&(d.DOMType=d.type,setTimeout(function(){a.onMouseUp(d)},0)))},g.prototype.onMouseUp=function(d){var a=this,u=a.chart,v=a.xAxis,x=a.scrollbar,S=d.DOMEvent||d,T=u.inverted,P=a.rendered&&!a.hasDragged?"animate":"attr",z,L,N,$,B,U;(a.hasDragged&&(!x||!x.hasDragged)||d.trigger==="scrollbar")&&(N=a.getUnionExtremes(),a.zoomedMin===a.otherHandlePos?$=a.fixedExtreme:a.zoomedMax===a.otherHandlePos&&(B=a.fixedExtreme),a.zoomedMax===a.size&&(B=a.reversedExtremes?N.dataMin:N.dataMax),a.zoomedMin===0&&($=a.reversedExtremes?N.dataMax:N.dataMin),U=v.navigatorAxis.toFixedRange(a.zoomedMin,a.zoomedMax,$,B),defined$w(U.min)&&u.xAxis[0].setExtremes(Math.min(U.min,U.max),Math.max(U.min,U.max),!0,a.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:S})),d.DOMType!=="mousemove"&&d.DOMType!=="touchmove"&&(a.grabbedLeft=a.grabbedRight=a.grabbedCenter=a.fixedWidth=a.fixedExtreme=a.otherHandlePos=a.hasDragged=a.dragOffset=null),a.navigatorEnabled&&isNumber$v(a.zoomedMin)&&isNumber$v(a.zoomedMax)&&(L=Math.round(a.zoomedMin),z=Math.round(a.zoomedMax),a.shades&&a.drawMasks(L,z,T,P),a.outline&&a.drawOutline(L,z,T,P),a.navigatorOptions.handles.enabled&&Object.keys(a.handles).length===a.handles.length&&(a.drawHandle(L,0,T,P),a.drawHandle(z,1,T,P)))},g.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(d){d()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},g.prototype.removeBaseSeriesEvents=function(){var d=this.baseSeries||[];this.navigatorEnabled&&d[0]&&(this.navigatorOptions.adaptToUpdatedData!==!1&&d.forEach(function(a){removeEvent$3(a,"updatedData",this.updatedDataHandler)},this),d[0].xAxis&&removeEvent$3(d[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},g.prototype.init=function(d){var a=d.options,u=a.navigator,v=u.enabled,x=a.scrollbar,S=x.enabled,T=v?u.height:0,P=S?x.height:0;this.handles=[],this.shades=[],this.chart=d,this.setBaseSeries(),this.height=T,this.scrollbarHeight=P,this.scrollbarEnabled=S,this.navigatorEnabled=v,this.navigatorOptions=u,this.scrollbarOptions=x,this.outlineHeight=T+P,this.opposite=pick$14(u.opposite,!!(!v&&d.inverted));var z=this,L=z.baseSeries,N=d.xAxis.length,$=d.yAxis.length,B=L&&L[0]&&L[0].xAxis||d.xAxis[0]||{options:{}};d.isDirtyBox=!0,z.navigatorEnabled?(z.xAxis=new Axis(d,merge$Z({breaks:B.options.breaks,ordinal:B.options.ordinal},u.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:N,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},d.inverted?{offsets:[P,0,-P,0],width:T}:{offsets:[0,-P,0,P],height:T})),z.yAxis=new Axis(d,merge$Z(u.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:$,isInternal:!0,reversed:pick$14(u.yAxis&&u.yAxis.reversed,d.yAxis[0]&&d.yAxis[0].reversed,!1),zoomEnabled:!1},d.inverted?{width:T}:{height:T})),L||u.series.data?z.updateNavigatorSeries(!1):d.series.length===0&&(z.unbindRedraw=addEvent$M(d,"beforeRedraw",function(){d.series.length>0&&!z.series&&(z.setBaseSeries(),z.unbindRedraw())})),z.reversedExtremes=d.inverted&&!z.xAxis.reversed||!d.inverted&&z.xAxis.reversed,z.renderElements(),z.addMouseEvents()):(z.xAxis={chart:d,navigatorAxis:{fake:!0},translate:function(U,j){var Y=d.xAxis[0],q=Y.getExtremes(),Q=Y.len-2*P,J=numExt("min",Y.options.min,q.dataMin),ee=numExt("max",Y.options.max,q.dataMax)-J;return j?U*ee/Q+J:Q*(U-J)/ee},toPixels:function(U){return this.translate(U)},toValue:function(U){return this.translate(U,!0)}},z.xAxis.navigatorAxis.axis=z.xAxis,z.xAxis.navigatorAxis.toFixedRange=NavigatorAxis.AdditionsClass.prototype.toFixedRange.bind(z.xAxis.navigatorAxis)),d.options.scrollbar.enabled&&(d.scrollbar=z.scrollbar=new Scrollbar(d.renderer,merge$Z(d.options.scrollbar,{margin:z.navigatorEnabled?0:10,vertical:d.inverted}),d),addEvent$M(z.scrollbar,"changed",function(U){var j=z.size,Y=j*this.to,q=j*this.from;z.hasDragged=z.scrollbar.hasDragged,z.render(0,0,q,Y),this.shouldUpdateExtremes(U.DOMType)&&setTimeout(function(){z.onMouseUp(U)})})),z.addBaseSeriesEvents(),z.addChartEvents()},g.prototype.getUnionExtremes=function(d){var a=this.chart.xAxis[0],u=this.xAxis,v=u.options,x=a.options,S;return(!d||a.dataMin!==null)&&(S={dataMin:pick$14(v&&v.min,numExt("min",x.min,a.dataMin,u.dataMin,u.min)),dataMax:pick$14(v&&v.max,numExt("max",x.max,a.dataMax,u.dataMax,u.max))}),S},g.prototype.setBaseSeries=function(d,a){var u=this.chart,v=this.baseSeries=[];d=d||u.options&&u.options.navigator.baseSeries||(u.series.length?find$e(u.series,function(x){return!x.options.isInternal}).index:0),(u.series||[]).forEach(function(x,S){!x.options.isInternal&&(x.options.showInNavigator||(S===d||x.options.id===d)&&x.options.showInNavigator!==!1)&&v.push(x)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,a)},g.prototype.updateNavigatorSeries=function(d,a){var u=this,v=u.chart,x=u.baseSeries,S,T,P=u.navigatorOptions.series,z,L={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},N=u.series=(u.series||[]).filter(function($){var B=$.baseSeries;return x.indexOf(B)<0?(B&&(removeEvent$3(B,"updatedData",u.updatedDataHandler),delete B.navigatorSeries),$.chart&&$.destroy(),!1):!0});x&&x.length&&x.forEach(function(B){var U=B.navigatorSeries,j=extend$17({color:B.color,visible:B.visible},isArray$b(P)?defaultOptions$a.navigator.series:P);if(!(U&&u.navigatorOptions.adaptToUpdatedData===!1)){L.name="Navigator "+x.length,S=B.options||{},z=S.navigatorOptions||{},j.dataLabels=splat$b(j.dataLabels),T=merge$Z(S,L,j,z),T.pointRange=pick$14(j.pointRange,z.pointRange,defaultOptions$a.plotOptions[T.type||"line"].pointRange);var Y=z.data||j.data;u.hasNavigatorData=u.hasNavigatorData||!!Y,T.data=Y||S.data&&S.data.slice(0),U&&U.options?U.update(T,a):(B.navigatorSeries=v.initSeries(T),B.navigatorSeries.baseSeries=B,N.push(B.navigatorSeries))}}),(P.data&&!(x&&x.length)||isArray$b(P))&&(u.hasNavigatorData=!1,P=splat$b(P),P.forEach(function($,B){L.name="Navigator "+(N.length+1),T=merge$Z(defaultOptions$a.navigator.series,{color:v.series[B]&&!v.series[B].options.isInternal&&v.series[B].color||v.options.colors[B]||v.options.colors[0]},L,$),T.data=$.data,T.data&&(u.hasNavigatorData=!0,N.push(v.initSeries(T)))})),d&&this.addBaseSeriesEvents()},g.prototype.addBaseSeriesEvents=function(){var d=this,a=d.baseSeries||[];a[0]&&a[0].xAxis&&a[0].eventsToUnbind.push(addEvent$M(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),a.forEach(function(u){u.eventsToUnbind.push(addEvent$M(u,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),u.eventsToUnbind.push(addEvent$M(u,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),this.navigatorOptions.adaptToUpdatedData!==!1&&u.xAxis&&u.eventsToUnbind.push(addEvent$M(u,"updatedData",this.updatedDataHandler)),u.eventsToUnbind.push(addEvent$M(u,"remove",function(){this.navigatorSeries&&(erase$2(d.series,this.navigatorSeries),defined$w(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)},g.prototype.getBaseSeriesMin=function(d){return this.baseSeries.reduce(function(a,u){return Math.min(a,u.xData?u.xData[0]:a)},d)},g.prototype.modifyNavigatorAxisExtremes=function(){var d=this.xAxis,a;typeof d.getExtremes<"u"&&(a=this.getUnionExtremes(!0),a&&(a.dataMin!==d.min||a.dataMax!==d.max)&&(d.min=a.dataMin,d.max=a.dataMax))},g.prototype.modifyBaseAxisExtremes=function(){var d=this,a=d.chart.navigator,u=d.getExtremes(),v=u.min,x=u.max,S=u.dataMin,T=u.dataMax,P=x-v,z=a.stickToMin,L=a.stickToMax,N=pick$14(d.options.overscroll,0),$,B,U=a.series&&a.series[0],j=!!d.setExtremes,Y=d.eventArgs&&d.eventArgs.trigger==="rangeSelectorButton";Y||(z&&(B=S,$=B+P),L&&($=T+N,z||(B=Math.max(S,$-P,a.getBaseSeriesMin(U&&U.xData?U.xData[0]:-Number.MAX_VALUE)))),j&&(z||L)&&isNumber$v(B)&&(d.min=d.userMin=B,d.max=d.userMax=$)),a.stickToMin=a.stickToMax=null},g.prototype.updatedDataHandler=function(){var d=this.chart.navigator,a=this,u=this.navigatorSeries;d.stickToMax=d.reversedExtremes?Math.round(d.zoomedMin)===0:Math.round(d.zoomedMax)>=Math.round(d.size),d.stickToMin=d.shouldStickToMin(a,d),u&&!d.hasNavigatorData&&(u.options.pointStart=a.xData[0],u.setData(a.options.data,!1,null,!1))},g.prototype.shouldStickToMin=function(d,a){var u=a.getBaseSeriesMin(d.xData[0]),v=d.xAxis,x=v.max,S=v.min,T=v.options.range,P=!0;return isNumber$v(x)&&isNumber$v(S)?T&&x-u>0?P=x-u<T&&!this.chart.fixedRange:P=S<=u:P=!1,P},g.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(addEvent$M(this.chart,"redraw",function(){var d=this.navigator,a=d&&(d.baseSeries&&d.baseSeries[0]&&d.baseSeries[0].xAxis||this.xAxis[0]);a&&d.render(a.min,a.max)}),addEvent$M(this.chart,"getMargins",function(){var d=this,a=d.navigator,u=a.opposite?"plotTop":"marginBottom";d.inverted&&(u=a.opposite?"marginRight":"plotLeft"),d[u]=(d[u]||0)+(a.navigatorEnabled||!d.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))},g.prototype.destroy=function(){this.removeEvents(),this.xAxis&&(erase$2(this.chart.xAxis,this.xAxis),erase$2(this.chart.axes,this.xAxis)),this.yAxis&&(erase$2(this.chart.yAxis,this.yAxis),erase$2(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(d){d.destroy&&d.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(d){this[d]&&this[d].destroy&&this[d].destroy(),this[d]=null},this),[this.handles].forEach(function(d){destroyObjectProperties$2(d)},this)},g})();H.Navigator||(H.Navigator=Navigator,NavigatorAxis.compose(Axis),addEvent$M(Chart$1,"beforeShowResetZoom",function(){var g=this.options,d=g.navigator,a=g.rangeSelector;if((d&&d.enabled||a&&a.enabled)&&(!isTouchDevice$1&&g.chart.zoomType==="x"||isTouchDevice$1&&g.chart.pinchType==="x"))return!1}),addEvent$M(Chart$1,"beforeRender",function(){var g=this.options;(g.navigator.enabled||g.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this))}),addEvent$M(Chart$1,"afterSetChartSize",function(){var g=this.legend,d=this.navigator,a,u,v,x;d&&(u=g&&g.options,v=d.xAxis,x=d.yAxis,a=d.scrollbarHeight,this.inverted?(d.left=d.opposite?this.chartWidth-a-d.height:this.spacing[3]+a,d.top=this.plotTop+a):(d.left=pick$14(v.left,this.plotLeft+a),d.top=d.navigatorOptions.top||this.chartHeight-d.height-a-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(u&&u.verticalAlign==="bottom"&&u.layout!=="proximate"&&u.enabled&&!u.floating?g.legendHeight+pick$14(u.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),v&&x&&(this.inverted?v.options.left=x.options.left=d.left:v.options.top=x.options.top=d.top,v.setAxisSize(),x.setAxisSize()))}),addEvent$M(Chart$1,"update",function(g){var d=g.options.navigator||{},a=g.options.scrollbar||{};!this.navigator&&!this.scroller&&(d.enabled||a.enabled)&&(merge$Z(!0,this.options.navigator,d),merge$Z(!0,this.options.scrollbar,a),delete g.options.navigator,delete g.options.scrollbar)}),addEvent$M(Chart$1,"afterUpdate",function(g){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this),pick$14(g.redraw,!0)&&this.redraw(g.animation))}),addEvent$M(Chart$1,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),addEvent$M(Series$f,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),Chart$1.prototype.callbacks.push(function(g){var d,a=g.navigator;a&&g.xAxis[0]&&(d=g.xAxis[0].getExtremes(),a.render(d.min,d.max))}));H.Navigator=Navigator;H.Navigator;var defaultOptions$9=DefaultOptions.defaultOptions,addEvent$L=Utilities.addEvent,createElement$3=Utilities.createElement,css$2=Utilities.css,defined$v=Utilities.defined,destroyObjectProperties$1=Utilities.destroyObjectProperties,discardElement$2=Utilities.discardElement,extend$16=Utilities.extend,find$d=Utilities.find,fireEvent$k=Utilities.fireEvent,isNumber$u=Utilities.isNumber,merge$Y=Utilities.merge,objectEach$f=Utilities.objectEach,pad=Utilities.pad,pick$13=Utilities.pick,pInt$3=Utilities.pInt,splat$a=Utilities.splat;extend$16(defaultOptions$9,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:palette.highlightColor80,cursor:"pointer"},labelStyle:{color:palette.neutralColor60}}});extend$16(defaultOptions$9.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"});var RangeSelector=(function(){function g(d){this.buttons=void 0,this.buttonOptions=g.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.options=void 0,this.chart=d,this.init(d)}return g.prototype.clickButton=function(d,a){var u=this,v=u.chart,x=u.buttonOptions[d],S=v.xAxis[0],T=v.scroller&&v.scroller.getUnionExtremes()||S||{},P=T.dataMin,z=T.dataMax,L,N=S&&Math.round(Math.min(S.max,pick$13(z,S.max))),$=x.type,B,U=x._range,j,Y,q,Q,J,ee=x.dataGrouping;if(!(P===null||z===null)){if(v.fixedRange=U,u.setSelected(d),ee&&(this.forcedDataGrouping=!0,Axis.prototype.setDataGrouping.call(S||{chart:this.chart},ee,!1),this.frozenStates=x.preserveDataGrouping),$==="month"||$==="year")S?(Q={range:x,max:N,chart:v,dataMin:P,dataMax:z},L=S.minFromRange.call(Q),isNumber$u(Q.newMax)&&(N=Q.newMax)):U=x;else if(U)L=Math.max(N-U,P),N=Math.min(L+U,z);else if($==="ytd")if(S)typeof z>"u"&&(P=Number.MAX_VALUE,z=Number.MIN_VALUE,v.series.forEach(function(ie){var ne=ie.xData;P=Math.min(ne[0],P),z=Math.max(ne[ne.length-1],z)}),a=!1),J=u.getYTDExtremes(z,P,v.time.useUTC),L=j=J.min,N=J.max;else{u.deferredYTDClick=d;return}else $==="all"&&S&&(v.navigator&&v.navigator.baseSeries[0]&&(v.navigator.baseSeries[0].xAxis.options.range=void 0),L=P,N=z);defined$v(L)&&(L+=x._offsetMin),defined$v(N)&&(N+=x._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=d+1),S?S.setExtremes(L,N,pick$13(a,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:x}):(B=splat$a(v.options.xAxis)[0],q=B.range,B.range=U,Y=B.min,B.min=j,addEvent$L(v,"load",function(){B.range=q,B.min=Y})),fireEvent$k(this,"afterBtnClick")}},g.prototype.setSelected=function(d){this.selected=this.options.selected=d},g.prototype.init=function(d){var a=this,u=d.options.rangeSelector,v=u.buttons||a.defaultButtons.slice(),x=u.selected,S=function(){var T=a.minInput,P=a.maxInput;T&&T.blur&&fireEvent$k(T,"blur"),P&&P.blur&&fireEvent$k(P,"blur")};a.chart=d,a.options=u,a.buttons=[],a.buttonOptions=v,this.eventsToUnbind=[],this.eventsToUnbind.push(addEvent$L(d.container,"mousedown",S)),this.eventsToUnbind.push(addEvent$L(d,"resize",S)),v.forEach(a.computeButtonRange),typeof x<"u"&&v[x]&&this.clickButton(x,!1),this.eventsToUnbind.push(addEvent$L(d,"load",function(){d.xAxis&&d.xAxis[0]&&addEvent$L(d.xAxis[0],"setExtremes",function(T){this.max-this.min!==d.fixedRange&&T.trigger!=="rangeSelectorButton"&&T.trigger!=="updatedData"&&a.forcedDataGrouping&&!a.frozenStates&&this.setDataGrouping(!1,!1)})}))},g.prototype.updateButtonStates=function(){var d=this,a=this.chart,u=this.dropdown,v=a.xAxis[0],x=Math.round(v.max-v.min),S=!v.hasVisibleSeries,T=24*36e5,P=a.scroller&&a.scroller.getUnionExtremes()||v,z=P.dataMin,L=P.dataMax,N=d.getYTDExtremes(L,z,a.time.useUTC),$=N.min,B=N.max,U=d.selected,j=isNumber$u(U),Y=d.options.allButtonsEnabled,q=d.buttons;d.buttonOptions.forEach(function(Q,J){var ee=Q._range,ie=Q.type,ne=Q.count||1,ae=q[J],de=0,he,pe,ve=Q._offsetMax-Q._offsetMin,be=J===U,ge=ee>L-z,_e=ee<v.minRange,me=!1,xe=!1,Ce=ee===x;(ie==="month"||ie==="year")&&x+36e5>={month:28,year:365}[ie]*T*ne-ve&&x-36e5<={month:31,year:366}[ie]*T*ne+ve?Ce=!0:ie==="ytd"?(Ce=B-$+ve===x,me=!be):ie==="all"&&(Ce=v.max-v.min>=L-z,xe=!be&&j&&Ce),he=!Y&&(ge||_e||xe||S),pe=be&&Ce||Ce&&!j&&!me||be&&d.frozenStates,he?de=3:pe&&(j=!0,de=2),ae.state!==de&&(ae.setState(de),u&&(u.options[J+1].disabled=he,de===2&&(u.selectedIndex=J+1)),de===0&&U===J&&d.setSelected())})},g.prototype.computeButtonRange=function(d){var a=d.type,u=d.count||1,v={millisecond:1,second:1e3,minute:60*1e3,hour:3600*1e3,day:24*3600*1e3,week:168*3600*1e3};v[a]?d._range=v[a]*u:(a==="month"||a==="year")&&(d._range={month:30,year:365}[a]*24*36e5*u),d._offsetMin=pick$13(d.offsetMin,0),d._offsetMax=pick$13(d.offsetMax,0),d._range+=d._offsetMax-d._offsetMin},g.prototype.getInputValue=function(d){var a=d==="min"?this.minInput:this.maxInput,u=this.chart.options.rangeSelector,v=this.chart.time;return a?(a.type==="text"&&u.inputDateParser||this.defaultInputDateParser)(a.value,v.useUTC,v):0},g.prototype.setInputValue=function(d,a){var u=this.options,v=this.chart.time,x=d==="min"?this.minInput:this.maxInput,S=d==="min"?this.minDateBox:this.maxDateBox;if(x){var T=x.getAttribute("data-hc-time"),P=defined$v(T)?Number(T):void 0;if(defined$v(a)){var z=P;defined$v(z)&&x.setAttribute("data-hc-time-previous",z),x.setAttribute("data-hc-time",a),P=a}x.value=v.dateFormat(this.inputTypeFormats[x.type]||u.inputEditDateFormat,P),S&&S.attr({text:v.dateFormat(u.inputDateFormat,P)})}},g.prototype.setInputExtremes=function(d,a,u){var v=d==="min"?this.minInput:this.maxInput;if(v){var x=this.inputTypeFormats[v.type],S=this.chart.time;if(x){var T=S.dateFormat(x,a);v.min!==T&&(v.min=T);var P=S.dateFormat(x,u);v.max!==P&&(v.max=P)}}},g.prototype.showInput=function(d){var a=d==="min"?this.minDateBox:this.maxDateBox,u=d==="min"?this.minInput:this.maxInput;if(u&&a&&this.inputGroup){var v=u.type==="text",x=this.inputGroup,S=x.translateX,T=x.translateY,P=this.options.inputBoxWidth;css$2(u,{width:v?a.width+(P?-2:20)+"px":"auto",height:v?a.height-2+"px":"auto",border:"2px solid silver"}),v&&P?css$2(u,{left:S+a.x+"px",top:T+"px"}):css$2(u,{left:Math.min(Math.round(a.x+S-(u.offsetWidth-a.width)/2),this.chart.chartWidth-u.offsetWidth)+"px",top:T-(u.offsetHeight-a.height)/2+"px"})}},g.prototype.hideInput=function(d){var a=d==="min"?this.minInput:this.maxInput;a&&css$2(a,{top:"-9999em",border:0,width:"1px",height:"1px"})},g.prototype.defaultInputDateParser=function(d,a,u){var v=function(z){return z.length>6&&(z.lastIndexOf("-")===z.length-6||z.lastIndexOf("+")===z.length-6)},x=d.split("/").join("-").split(" ").join("T");if(x.indexOf("T")===-1&&(x+="T00:00"),a)x+="Z";else if(H.isSafari&&!v(x)){var S=new Date(x).getTimezoneOffset()/60;x+=S<=0?"+"+pad(-S)+":00":"-"+pad(S)+":00"}var T=Date.parse(x);if(!isNumber$u(T)){var P=d.split("-");T=Date.UTC(pInt$3(P[0]),pInt$3(P[1])-1,pInt$3(P[2]))}return u&&a&&isNumber$u(T)&&(T+=u.getTimezoneOffset(T)),T},g.prototype.drawInput=function(d){var a=this,u=a.chart,v=a.div,x=a.inputGroup,S=this,T=u.renderer.style||{},P=u.renderer,z=u.options.rangeSelector,L=defaultOptions$9.lang,N=d==="min";function $(){var Q=S.getInputValue(d),J=u.xAxis[0],ee=u.scroller&&u.scroller.xAxis?u.scroller.xAxis:J,ie=ee.dataMin,ne=ee.dataMax,ae=S.maxInput,de=S.minInput;Q!==Number(Y.getAttribute("data-hc-time-previous"))&&isNumber$u(Q)&&(Y.setAttribute("data-hc-time-previous",Q),N&&ae&&isNumber$u(ie)?Q>Number(ae.getAttribute("data-hc-time"))?Q=void 0:Q<ie&&(Q=ie):de&&isNumber$u(ne)&&(Q<Number(de.getAttribute("data-hc-time"))?Q=void 0:Q>ne&&(Q=ne)),typeof Q<"u"&&J.setExtremes(N?Q:J.min,N?J.max:Q,void 0,void 0,{trigger:"rangeSelectorInput"}))}var B=L[N?"rangeSelectorFrom":"rangeSelectorTo"]||"",U=P.label(B,0).addClass("highcharts-range-label").attr({padding:B?2:0,height:B?z.inputBoxHeight:0}).add(x),j=P.label("",0).addClass("highcharts-range-input").attr({padding:2,width:z.inputBoxWidth,height:z.inputBoxHeight,"text-align":"center"}).on("click",function(){S.showInput(d),S[d+"Input"].focus()});u.styledMode||j.attr({stroke:z.inputBoxBorderColor,"stroke-width":1}),j.add(x);var Y=createElement$3("input",{name:d,className:"highcharts-range-selector"},void 0,v);Y.setAttribute("type",preferredInputType(z.inputDateFormat||"%b %e, %Y")),u.styledMode||(U.css(merge$Y(T,z.labelStyle)),j.css(merge$Y({color:palette.neutralColor80},T,z.inputStyle)),css$2(Y,extend$16({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:T.fontSize,fontFamily:T.fontFamily,top:"-9999em"},z.inputStyle))),Y.onfocus=function(){S.showInput(d)},Y.onblur=function(){Y===H.doc.activeElement&&$(),S.hideInput(d),S.setInputValue(d),Y.blur()};var q=!1;return Y.onchange=function(){q||($(),S.hideInput(d),Y.blur())},Y.onkeypress=function(Q){Q.keyCode===13&&$()},Y.onkeydown=function(Q){q=!0,(Q.keyCode===38||Q.keyCode===40)&&$()},Y.onkeyup=function(){q=!1},{dateBox:j,input:Y,label:U}},g.prototype.getPosition=function(){var d=this.chart,a=d.options.rangeSelector,u=a.verticalAlign==="top"?d.plotTop-d.axisOffset[0]:0;return{buttonTop:u+a.buttonPosition.y,inputTop:u+a.inputPosition.y-10}},g.prototype.getYTDExtremes=function(d,a,u){var v=this.chart.time,x,S=new v.Date(d),T=v.get("FullYear",S),P=u?v.Date.UTC(T,0,1):+new v.Date(T,0,1);x=Math.max(a,P);var z=S.getTime();return{max:Math.min(d||z,z),min:x}},g.prototype.render=function(d,a){var u=this.chart,v=u.renderer,x=u.container,S=u.options,T=S.rangeSelector,P=pick$13(S.chart.style&&S.chart.style.zIndex,0)+1,z=T.inputEnabled,L=this.rendered;if(T.enabled!==!1){if(!L&&(this.group=v.g("range-selector-group").attr({zIndex:7}).add(),this.div=createElement$3("div",void 0,{position:"relative",height:0,zIndex:P}),this.buttonOptions.length&&this.renderButtons(),x.parentNode&&x.parentNode.insertBefore(this.div,x),z)){this.inputGroup=v.g("input-group").add(this.group);var N=this.drawInput("min");this.minDateBox=N.dateBox,this.minLabel=N.label,this.minInput=N.input;var $=this.drawInput("max");this.maxDateBox=$.dateBox,this.maxLabel=$.label,this.maxInput=$.input}if(z){this.setInputValue("min",d),this.setInputValue("max",a);var B=u.scroller&&u.scroller.getUnionExtremes()||u.xAxis[0]||{};if(defined$v(B.dataMin)&&defined$v(B.dataMax)){var U=u.xAxis[0].minRange||0;this.setInputExtremes("min",B.dataMin,Math.min(B.dataMax,this.getInputValue("max"))-U),this.setInputExtremes("max",Math.max(B.dataMin,this.getInputValue("min"))+U,B.dataMax)}if(this.inputGroup){var j=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(Y){if(Y){var q=Y.getBBox().width;q&&(Y.attr({x:j}),j+=q+T.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},g.prototype.renderButtons=function(){var d=this,a=this,u=a.buttons,v=a.chart,x=a.options,S=defaultOptions$9.lang,T=v.renderer,P=merge$Y(x.buttonTheme),z=P&&P.states,L=P.width||28;delete P.width,delete P.states,this.buttonGroup=T.g("range-selector-buttons").add(this.group);var N=this.dropdown=createElement$3("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);addEvent$L(N,"touchstart",function(){N.style.fontSize="16px"}),[[H.isMS?"mouseover":"mouseenter"],[H.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function($){var B=$[0],U=$[1];addEvent$L(N,B,function(){var j=u[d.currentButtonIndex()];j&&fireEvent$k(j.element,U||B)})}),this.zoomText=T.label(S&&S.rangeSelectorZoom||"",0).attr({padding:x.buttonTheme.padding,height:x.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(x.labelStyle),P["stroke-width"]=pick$13(P["stroke-width"],0)),createElement$3("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,N),this.buttonOptions.forEach(function($,B){createElement$3("option",{textContent:$.title||$.text},void 0,N),u[B]=T.button($.text,0,0,function(U){var j=$.events&&$.events.click,Y;j&&(Y=j.call($,U)),Y!==!1&&d.clickButton(B),d.isActive=!0},P,z&&z.hover,z&&z.select,z&&z.disabled).attr({"text-align":"center",width:L}).add(d.buttonGroup),$.title&&u[B].attr("title",$.title)})},g.prototype.alignElements=function(){var d=this,a=this,u=a.buttonGroup,v=a.buttons,x=a.chart,S=a.group,T=a.inputGroup,P=a.options,z=a.zoomText,L=x.options,N=L.exporting&&L.exporting.enabled!==!1&&L.navigation&&L.navigation.buttonOptions,$=P.buttonPosition,B=P.inputPosition,U=P.verticalAlign,j=function(_e,me){return N&&d.titleCollision(x)&&U==="top"&&me.align==="right"&&me.y-_e.getBBox().height-12<(N.y||0)+(N.height||0)+x.spacing[0]?-40:0},Y=x.plotLeft;if(S&&$&&B){var q=$.x-x.spacing[3];if(u){if(this.positionButtons(),!this.initialButtonGroupWidth){var Q=0;z&&(Q+=z.getBBox().width+5),v.forEach(function(_e,me){Q+=_e.width,me!==v.length-1&&(Q+=P.buttonSpacing)}),this.initialButtonGroupWidth=Q}Y-=x.spacing[3],this.updateButtonStates();var J=j(u,$);this.alignButtonGroup(J),S.placed=u.placed=x.hasLoaded}var ee=0;T&&(ee=j(T,B),B.align==="left"?q=Y:B.align==="right"&&(q=-Math.max(x.axisOffset[1],-ee)),T.align({y:B.y,width:T.getBBox().width,align:B.align,x:B.x+q-2},!0,x.spacingBox),T.placed=x.hasLoaded),this.handleCollision(ee),S.align({verticalAlign:U},!0,x.spacingBox);var ie=S.alignAttr.translateY,ne=S.getBBox().height+20,ae=0;if(U==="bottom"){var de=x.legend&&x.legend.options,he=de&&de.verticalAlign==="bottom"&&de.enabled&&!de.floating?x.legend.legendHeight+pick$13(de.margin,10):0;ne=ne+he-20,ae=ie-ne-(P.floating?0:P.y)-(x.titleOffset?x.titleOffset[2]:0)-10}U==="top"?(P.floating&&(ae=0),x.titleOffset&&x.titleOffset[0]&&(ae=x.titleOffset[0]),ae+=x.margin[0]-x.spacing[0]||0):U==="middle"&&(B.y===$.y?ae=ie:(B.y||$.y)&&(B.y<0||$.y<0?ae-=Math.min(B.y,$.y):ae=ie-ne)),S.translate(P.x,P.y+Math.floor(ae));var pe=this,ve=pe.minInput,be=pe.maxInput,ge=pe.dropdown;P.inputEnabled&&ve&&be&&(ve.style.marginTop=S.translateY+"px",be.style.marginTop=S.translateY+"px"),ge&&(ge.style.marginTop=S.translateY+"px")}},g.prototype.alignButtonGroup=function(d,a){var u=this,v=u.chart,x=u.options,S=u.buttonGroup;u.buttons;var T=x.buttonPosition,P=v.plotLeft-v.spacing[3],z=T.x-v.spacing[3];T.align==="right"?z+=d-P:T.align==="center"&&(z-=P/2),S&&S.align({y:T.y,width:pick$13(a,this.initialButtonGroupWidth),align:T.align,x:z},!0,v.spacingBox)},g.prototype.positionButtons=function(){var d=this,a=d.buttons,u=d.chart,v=d.options,x=d.zoomText,S=u.hasLoaded?"animate":"attr",T=v.buttonPosition,P=u.plotLeft,z=P;x&&x.visibility!=="hidden"&&(x[S]({x:pick$13(P+T.x,P)}),z+=T.x+x.getBBox().width+5),this.buttonOptions.forEach(function(L,N){a[N].visibility!=="hidden"?(a[N][S]({x:z}),z+=a[N].width+v.buttonSpacing):a[N][S]({x:P})})},g.prototype.handleCollision=function(d){var a=this,u=this,v=u.chart,x=u.buttonGroup,S=u.inputGroup,T=this.options,P=T.buttonPosition,z=T.dropdown,L=T.inputPosition,N=function(){var U=0;return a.buttons.forEach(function(j){var Y=j.getBBox();Y.width>U&&(U=Y.width)}),U},$=function(U){if(S&&x){var j=S.alignAttr.translateX+S.alignOptions.x-d+S.getBBox().x+2,Y=S.alignOptions.width,q=x.alignAttr.translateX+x.getBBox().x;return q+U>j&&j+Y>q&&P.y<L.y+S.getBBox().height}return!1},B=function(){S&&x&&S.attr({translateX:S.alignAttr.translateX+(v.axisOffset[1]>=-d?0:-d),translateY:S.alignAttr.translateY+x.getBBox().height+10})};if(x){if(z==="always"){this.collapseButtons(d),$(N())&&B();return}z==="never"&&this.expandButtons()}S&&x?L.align===P.align||$(this.initialButtonGroupWidth+20)?z==="responsive"?(this.collapseButtons(d),$(N())&&B()):B():z==="responsive"&&this.expandButtons():x&&z==="responsive"&&(this.initialButtonGroupWidth>v.plotWidth?this.collapseButtons(d):this.expandButtons())},g.prototype.collapseButtons=function(d){var a=this,u=a.buttons,v=a.buttonOptions,x=a.chart,S=a.dropdown,T=a.options,P=a.zoomText,z=x.userOptions.rangeSelector&&x.userOptions.rangeSelector.buttonTheme||{},L=function(B){return{text:B?B+" ▾":"▾",width:"auto",paddingLeft:pick$13(T.buttonTheme.paddingLeft,z.padding,8),paddingRight:pick$13(T.buttonTheme.paddingRight,z.padding,8)}};P&&P.hide();var N=!1;v.forEach(function(B,U){var j=u[U];j.state!==2?j.hide():(j.show(),j.attr(L(B.text)),N=!0)}),N||(S&&(S.selectedIndex=0),u[0].show(),u[0].attr(L(this.zoomText&&this.zoomText.textStr)));var $=T.buttonPosition.align;this.positionButtons(),($==="right"||$==="center")&&this.alignButtonGroup(d,u[this.currentButtonIndex()].getBBox().width),this.showDropdown()},g.prototype.expandButtons=function(){var d=this,a=d.buttons,u=d.buttonOptions,v=d.options,x=d.zoomText;this.hideDropdown(),x&&x.show(),u.forEach(function(S,T){var P=a[T];P.show(),P.attr({text:S.text,width:v.buttonTheme.width||28,paddingLeft:pick$13(v.buttonTheme.paddingLeft,"unset"),paddingRight:pick$13(v.buttonTheme.paddingRight,"unset")}),P.state<2&&P.setState(0)}),this.positionButtons()},g.prototype.currentButtonIndex=function(){var d=this.dropdown;return d&&d.selectedIndex>0?d.selectedIndex-1:0},g.prototype.showDropdown=function(){var d=this,a=d.buttonGroup,u=d.buttons,v=d.chart,x=d.dropdown;if(a&&x){var S=a.translateX,T=a.translateY,P=u[this.currentButtonIndex()].getBBox();css$2(x,{left:v.plotLeft+S+"px",top:T+.5+"px",width:P.width+"px",height:P.height+"px"}),this.hasVisibleDropdown=!0}},g.prototype.hideDropdown=function(){var d=this.dropdown;d&&(css$2(d,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},g.prototype.getHeight=function(){var d=this,a=d.options,u=d.group,v=a.inputPosition,x=a.buttonPosition,S=a.y,T=x.y,P=v.y,z=0,L;return a.height?a.height:(this.alignElements(),z=u?u.getBBox(!0).height+13+S:0,L=Math.min(P,T),(P<0&&T<0||P>0&&T>0)&&(z+=Math.abs(L)),z)},g.prototype.titleCollision=function(d){return!(d.options.title.text||d.options.subtitle.text)},g.prototype.update=function(d){var a=this.chart;merge$Y(!0,a.options.rangeSelector,d),this.destroy(),this.init(a),this.render()},g.prototype.destroy=function(){var d=this,a=d.minInput,u=d.maxInput;d.eventsToUnbind&&(d.eventsToUnbind.forEach(function(v){return v()}),d.eventsToUnbind=void 0),destroyObjectProperties$1(d.buttons),a&&(a.onfocus=a.onblur=a.onchange=null),u&&(u.onfocus=u.onblur=u.onchange=null),objectEach$f(d,function(v,x){v&&x!=="chart"&&(v instanceof SVGElement?v.destroy():v instanceof window.HTMLElement&&discardElement$2(v)),v!==g.prototype[x]&&(d[x]=null)},this)},g})();RangeSelector.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];RangeSelector.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};function preferredInputType(g){var d=g.indexOf("%L")!==-1;if(d)return"text";var a=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(v){return g.indexOf("%"+v)!==-1}),u=["H","k","I","l","M","S"].some(function(v){return g.indexOf("%"+v)!==-1});return a&&u?"datetime-local":a?"date":u?"time":"text"}Axis.prototype.minFromRange=function(){var g=this.range,d=g.type,a,u=this.max,v,x,S=this.chart.time,T=function(P,z){var L=d==="year"?"FullYear":"Month",N=new S.Date(P),$=S.get(L,N);return S.set(L,N,$+z),$===S.get(L,N)&&S.set("Date",N,0),N.getTime()-P};return isNumber$u(g)?(a=u-g,x=g):(a=u+T(u,-g.count),this.chart&&(this.chart.fixedRange=u-a)),v=pick$13(this.dataMin,Number.MIN_VALUE),isNumber$u(a)||(a=v),a<=v&&(a=v,typeof x>"u"&&(x=T(a,g.count)),this.newMax=Math.min(a+x,this.dataMax)),isNumber$u(u)||(a=void 0),a};if(!H.RangeSelector){var chartDestroyEvents_1=[],initRangeSelector_1=function(g){var d,a=g.rangeSelector,u,v,x;function S(){a&&(d=g.xAxis[0].getExtremes(),u=g.legend,x=a&&a.options.verticalAlign,isNumber$u(d.min)&&a.render(d.min,d.max),u.display&&x==="top"&&x===u.options.verticalAlign&&(v=merge$Y(g.spacingBox),u.options.layout==="vertical"?v.y=g.plotTop:v.y+=a.getHeight(),u.group.placed=!1,u.align(v)))}if(a){var T=find$d(chartDestroyEvents_1,function(P){return P[0]===g});T||chartDestroyEvents_1.push([g,[addEvent$L(g.xAxis[0],"afterSetExtremes",function(P){a&&a.render(P.min,P.max)}),addEvent$L(g,"redraw",S)]]),S()}};addEvent$L(Chart$1,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new RangeSelector(this))}),addEvent$L(Chart$1,"beforeRender",function(){var g=this,d=g.axes,a=g.rangeSelector,u;a&&(isNumber$u(a.deferredYTDClick)&&(a.clickButton(a.deferredYTDClick),delete a.deferredYTDClick),d.forEach(function(v){v.updateNames(),v.setScale()}),g.getAxisMargins(),a.render(),u=a.options.verticalAlign,a.options.floating||(u==="bottom"?this.extraBottomMargin=!0:u!=="middle"&&(this.extraTopMargin=!0)))}),addEvent$L(Chart$1,"update",function(g){var d=this,a=g.options,u=a.rangeSelector,v=d.rangeSelector,x,S=this.extraBottomMargin,T=this.extraTopMargin;u&&u.enabled&&!defined$v(v)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=v=new RangeSelector(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,v&&(initRangeSelector_1(this),x=u&&u.verticalAlign||v.options&&v.options.verticalAlign,v.options.floating||(x==="bottom"?this.extraBottomMargin=!0:x!=="middle"&&(this.extraTopMargin=!0)),(this.extraBottomMargin!==S||this.extraTopMargin!==T)&&(this.isDirtyBox=!0))}),addEvent$L(Chart$1,"render",function(){var g=this,d=g.rangeSelector,a;d&&!d.options.floating&&(d.render(),a=d.options.verticalAlign,a==="bottom"?this.extraBottomMargin=!0:a!=="middle"&&(this.extraTopMargin=!0))}),addEvent$L(Chart$1,"getMargins",function(){var g=this.rangeSelector,d;g&&(d=g.getHeight(),this.extraTopMargin&&(this.plotTop+=d),this.extraBottomMargin&&(this.marginBottom+=d))}),Chart$1.prototype.callbacks.push(initRangeSelector_1),addEvent$L(Chart$1,"destroy",function(){for(var d=0;d<chartDestroyEvents_1.length;d++){var a=chartDestroyEvents_1[d];if(a[0]===this){a[1].forEach(function(u){return u()}),chartDestroyEvents_1.splice(d,1);return}}}),H.RangeSelector=RangeSelector}var __extends$1$=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),animObject$5=animationExports.animObject,format$7=FormatUtilities.format,getOptions$3=DefaultOptions.getOptions,pointTooltipFormatter=Point$4.prototype.tooltipFormatter,_a$c=Series$f.prototype,seriesInit=_a$c.init,seriesProcessData=_a$c.processData,addEvent$K=Utilities.addEvent,arrayMax$4=Utilities.arrayMax,arrayMin$4=Utilities.arrayMin,clamp$b=Utilities.clamp,defined$u=Utilities.defined,extend$15=Utilities.extend,find$c=Utilities.find,isNumber$t=Utilities.isNumber,isString$4=Utilities.isString,merge$X=Utilities.merge,pick$12=Utilities.pick,splat$9=Utilities.splat,StockChart=(function(g){__extends$1$(d,g);function d(){return g!==null&&g.apply(this,arguments)||this}return d.prototype.init=function(a,u){var v=getOptions$3(),x=a.xAxis,S=a.yAxis,T=pick$12(a.navigator&&a.navigator.enabled,v.navigator.enabled,!0);a.xAxis=a.yAxis=void 0;var P=merge$X({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:T},scrollbar:{enabled:pick$12(v.scrollbar&&v.scrollbar.enabled,!0)},rangeSelector:{enabled:pick$12(v.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:pick$12(v.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},a,{isStock:!0});a.xAxis=x,a.yAxis=S,P.xAxis=splat$9(a.xAxis||{}).map(function(z,L){return merge$X(getDefaultAxisOptions("xAxis",z),v.xAxis,v.xAxis&&v.xAxis[L],z,getForcedAxisOptions("xAxis",a))}),P.yAxis=splat$9(a.yAxis||{}).map(function(z,L){return merge$X(getDefaultAxisOptions("yAxis",z),v.yAxis,v.yAxis&&v.yAxis[L],z)}),g.prototype.init.call(this,P,u)},d.prototype.createAxis=function(a,u){return u.axis=merge$X(getDefaultAxisOptions(a,u.axis),u.axis,getForcedAxisOptions(a,this.userOptions)),g.prototype.createAxis.call(this,a,u)},d})(Chart$1);(function(g){function d(a,u,v){return new g(a,u,v)}g.stockChart=d})(StockChart||(StockChart={}));function getDefaultAxisOptions(g,d){return g==="xAxis"?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:g==="yAxis"?{labels:{y:-2},opposite:pick$12(d.opposite,!0),showLastLabel:!!(d.categories||d.type==="category"),title:{text:null}}:{}}function getForcedAxisOptions(g,d){if(g==="xAxis"){var a=getOptions$3(),u=pick$12(d.navigator&&d.navigator.enabled,a.navigator.enabled,!0),v={type:"datetime",categories:void 0};return u&&(v.startOnTick=!1,v.endOnTick=!1),v}return{}}addEvent$K(Series$f,"setOptions",function(g){var d;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?d={borderWidth:0,shadow:!1}:!this.is("scatter")&&!this.is("sma")&&(d={marker:{enabled:!1,radius:2}}),d&&(g.plotOptions[this.type]=merge$X(g.plotOptions[this.type],d)))});addEvent$K(Axis,"autoLabelAlign",function(g){var d=this.chart,a=this.options,u=d._labelPanes=d._labelPanes||{},v,x=this.options.labels;this.chart.options.isStock&&this.coll==="yAxis"&&(v=a.top+","+a.height,!u[v]&&x.enabled&&(x.x===15&&(x.x=0),typeof x.align>"u"&&(x.align="right"),u[v]=this,g.align="right",g.preventDefault()))});addEvent$K(Axis,"destroy",function(){var g=this.chart,d=this.options&&this.options.top+","+this.options.height;d&&g._labelPanes&&g._labelPanes[d]===this&&delete g._labelPanes[d]});addEvent$K(Axis,"getPlotLinePath",function(g){var d=this,a=this.isLinked&&!this.series?this.linkedParent.series:this.series,u=d.chart,v=u.renderer,x=d.left,S=d.top,T,P,z,L,N=[],$=[],B,U,j=g.translatedValue,Y=g.value,q=g.force,Q;function J(ee){var ie=ee==="xAxis"?"yAxis":"xAxis",ne=d.options[ie];return isNumber$t(ne)?[u[ie][ne]]:isString$4(ne)?[u.get(ne)]:a.map(function(ae){return ae[ie]})}(u.options.isStock&&g.acrossPanes!==!1&&d.coll==="xAxis"||d.coll==="yAxis")&&(g.preventDefault(),$=J(d.coll),B=d.isXAxis?u.yAxis:u.xAxis,B.forEach(function(ee){if(!defined$u(ee.options.id)||ee.options.id.indexOf("navigator")===-1){var ie=ee.isXAxis?"yAxis":"xAxis",ne=defined$u(ee.options[ie])?u[ie][ee.options[ie]]:u[ie][0];d===ne&&$.push(ee)}}),U=$.length?[]:[d.isXAxis?u.yAxis[0]:u.xAxis[0]],$.forEach(function(ee){U.indexOf(ee)===-1&&!find$c(U,function(ie){return ie.pos===ee.pos&&ie.len===ee.len})&&U.push(ee)}),Q=pick$12(j,d.translate(Y,null,null,g.old)),isNumber$t(Q)&&(d.horiz?U.forEach(function(ee){var ie;P=ee.pos,L=P+ee.len,T=z=Math.round(Q+d.transB),q!=="pass"&&(T<x||T>x+d.width)&&(q?T=z=clamp$b(T,x,x+d.width):ie=!0),ie||N.push(["M",T,P],["L",z,L])}):U.forEach(function(ee){var ie;T=ee.pos,z=T+ee.len,P=L=Math.round(S+d.height-Q),q!=="pass"&&(P<S||P>S+d.height)&&(q?P=L=clamp$b(P,S,S+d.height):ie=!0),ie||N.push(["M",T,P],["L",z,L])})),g.path=N.length>0?v.crispPolyLine(N,g.lineWidth||1):null)});SVGRenderer.prototype.crispPolyLine=function(g,d){for(var a=0;a<g.length;a=a+2){var u=g[a],v=g[a+1];u[1]===v[1]&&(u[1]=v[1]=Math.round(u[1])-d%2/2),u[2]===v[2]&&(u[2]=v[2]=Math.round(u[2])+d%2/2)}return g};addEvent$K(Axis,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});addEvent$K(Axis,"afterDrawCrosshair",function(g){if(!(!this.crosshair||!this.crosshair.label||!this.crosshair.label.enabled||!this.cross||!isNumber$t(this.min)||!isNumber$t(this.max))){var d=this.chart,a=this.logarithmic,u=this.crosshair.label,v=this.horiz,x=this.opposite,S=this.left,T=this.top,P=this.crossLabel,z,L,N,$=u.format,B="",U,j,Y=this.options.tickPosition==="inside",q=this.crosshair.snap!==!1,Q=0,J=g.e||this.cross&&this.cross.e,ee=g.point,ie=this.min,ne=this.max;a&&(ie=a.lin2log(ie),ne=a.lin2log(ne)),j=v?"center":x?this.labelAlign==="right"?"right":"left":this.labelAlign==="left"?"left":"center",P||(P=this.crossLabel=d.renderer.label("",0,void 0,u.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(ee?ee.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:u.align||j,padding:pick$12(u.padding,8),r:pick$12(u.borderRadius,3),zIndex:2}).add(this.labelGroup),d.styledMode||P.attr({fill:u.backgroundColor||ee&&ee.series&&ee.series.color||palette.neutralColor60,stroke:u.borderColor||"","stroke-width":u.borderWidth||0}).css(extend$15({color:palette.backgroundColor,fontWeight:"normal",fontSize:"11px",textAlign:"center"},u.style||{}))),v?(z=q?(ee.plotX||0)+S:J.chartX,L=T+(x?0:this.height)):(z=x?this.width+S:0,L=q?(ee.plotY||0)+T:J.chartY),!$&&!u.formatter&&(this.dateTime&&(B="%b %d, %Y"),$="{value"+(B?":"+B:"")+"}");var ae=q?this.isXAxis?ee.x:ee.y:this.toValue(v?J.chartX:J.chartY),de=ee?ee.series.isPointInside(ee):isNumber$t(ae)&&ae>ie&&ae<ne,he="";$?he=format$7($,{value:ae},d):u.formatter&&isNumber$t(ae)&&(he=u.formatter.call(this,ae)),P.attr({text:he,x:z,y:L,visibility:de?"visible":"hidden"}),N=P.getBBox(),isNumber$t(P.y)&&(v?(Y&&!x||!Y&&x)&&(L=P.y-N.height):L=P.y-N.height/2),v?U={left:S-N.x,right:S+this.width-N.x}:U={left:this.labelAlign==="left"?S:0,right:this.labelAlign==="right"?S+this.width:d.chartWidth},P.translateX<U.left&&(Q=U.left-P.translateX),P.translateX+N.width>=U.right&&(Q=-(P.translateX+N.width-U.right)),P.attr({x:z+Q,y:L,anchorX:v?z:this.opposite?0:d.chartWidth,anchorY:v?this.opposite?d.chartHeight:0:L+N.height/2})}});Series$f.prototype.init=function(){seriesInit.apply(this,arguments),this.initCompare(this.options.compare)};Series$f.prototype.setCompare=function(g){this.initCompare(g),this.userOptions.compare=g};Series$f.prototype.initCompare=function(g){this.modifyValue=g==="value"||g==="percent"?function(d,a){var u=this.compareValue;return typeof d<"u"&&typeof u<"u"?(g==="value"?d-=u:d=100*(d/u)-(this.options.compareBase===100?0:100),a&&(a.change=d),d):0}:null,this.chart.hasRendered&&(this.isDirty=!0)};Series$f.prototype.forceCropping=function(){var g=this.chart,d=this.options,a=d.dataGrouping,u=this.allowDG!==!1&&a&&pick$12(a.enabled,g.options.isStock);return u};Series$f.prototype.processData=function(g){var d=this,a,u=-1,v,x,S=d.options.compareStart===!0?0:1,T,P;if(seriesProcessData.apply(this,arguments),d.xAxis&&d.processedYData){for(v=d.processedXData,x=d.processedYData,T=x.length,d.pointArrayMap&&(u=d.pointArrayMap.indexOf(d.options.pointValKey||d.pointValKey||"y")),a=0;a<T-S;a++)if(P=x[a]&&u>-1?x[a][u]:x[a],isNumber$t(P)&&v[a+S]>=d.xAxis.min&&P!==0){d.compareValue=P;break}}};addEvent$K(Series$f,"afterGetExtremes",function(g){var d=g.dataExtremes;if(this.modifyValue&&d){var a=[this.modifyValue(d.dataMin),this.modifyValue(d.dataMax)];d.dataMin=arrayMin$4(a),d.dataMax=arrayMax$4(a)}});Axis.prototype.setCompare=function(g,d){this.isXAxis||(this.series.forEach(function(a){a.setCompare(g)}),pick$12(d,!0)&&this.chart.redraw())};Point$4.prototype.tooltipFormatter=function(g){var d=this,a=d.series.chart.numberFormatter;return g=g.replace("{point.change}",(d.change>0?"+":"")+a(d.change,pick$12(d.series.tooltipOptions.changeDecimals,2))),pointTooltipFormatter.apply(this,[g])};addEvent$K(Series$f,"render",function(){var g=this.chart,d;if(!(g.is3d&&g.is3d())&&!g.polar&&this.xAxis&&!this.xAxis.isRadial&&this.options.clip!==!1){if(d=this.yAxis.len,this.xAxis.axisLine){var a=g.plotTop+g.plotHeight-this.yAxis.pos-this.yAxis.len,u=Math.floor(this.xAxis.axisLine.strokeWidth()/2);a>=0&&(d-=Math.max(u-a,0))}if((!g.hasLoaded||!this.clipBox&&this.isDirty&&!this.isDirtyData)&&(this.clipBox=this.clipBox||merge$X(g.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=d),g.hasRendered){var v=animObject$5(this.options.animation),x=this.getSharedClipKey(v),S=g.sharedClips[x];if(S){S.animate({width:this.xAxis.len,height:d});var T=g.sharedClips[x+"m"];T&&T.animate({width:this.xAxis.len})}}}});addEvent$K(Chart$1,"update",function(g){var d=g.options;"scrollbar"in d&&this.navigator&&(merge$X(!0,this.options.scrollbar,d.scrollbar),this.navigator.update({},!1),delete d.scrollbar)});const StockChart$1=StockChart;/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/stock
 * @requires highcharts
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$6=H;G$6.Scrollbar=Scrollbar;G$6.StockChart=G$6.stockChart=StockChart$1.stockChart;Scrollbar.compose(G$6.Axis);OrdinalAxis$1.compose(G$6.Axis,G$6.Series,G$6.Chart);/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/highstock
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */G$8.product="Highstock";var doc$f=H.doc,win$6=H.win,merge$W=Utilities.merge;function addClass$1(g,d){g.classList?g.classList.add(d):g.className.indexOf(d)<0&&(g.className+=d)}function escapeStringForHTML$1(g){return g.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")}function getElement$2(g){return doc$f.getElementById(g)}function getFakeMouseEvent$2(g){if(typeof win$6.MouseEvent=="function")return new win$6.MouseEvent(g);if(doc$f.createEvent){var d=doc$f.createEvent("MouseEvent");if(d.initMouseEvent)return d.initMouseEvent(g,!0,!0,win$6,g==="click"?1:0,0,0,0,0,!1,!1,!1,!1,0,null),d}return{type:g}}function getHeadingTagNameForElement$1(g){var d=function(x){var S=parseInt(x.slice(1),10),T=Math.min(6,S+1);return"h"+T},a=function(x){return/H[1-6]/.test(x)},u=function(x){for(var S=x;S=S.previousSibling;){var T=S.tagName||"";if(a(T))return T}return""},v=function(x){var S=u(x);if(S)return d(S);var T=x.parentElement;if(!T)return"p";var P=T.tagName;return a(P)?d(P):v(T)};return v(g)}function removeElement$5(g){g&&g.parentNode&&g.parentNode.removeChild(g)}function reverseChildNodes$1(g){for(var d=g.childNodes.length;d--;)g.appendChild(g.childNodes[d])}function setElAttrs$4(g,d){Object.keys(d).forEach(function(a){var u=d[a];u===null?g.removeAttribute(a):g.setAttribute(a,u)})}function stripHTMLTagsFromString$2(g){return typeof g=="string"?g.replace(/<\/?[^>]+(>|$)/g,""):g}function visuallyHideElement$2(g){var d={position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:"0.01"};merge$W(!0,g.style,d)}var HTMLUtilities={addClass:addClass$1,escapeStringForHTML:escapeStringForHTML$1,getElement:getElement$2,getFakeMouseEvent:getFakeMouseEvent$2,getHeadingTagNameForElement:getHeadingTagNameForElement$1,removeElement:removeElement$5,reverseChildNodes:reverseChildNodes$1,setElAttrs:setElAttrs$4,stripHTMLTagsFromString:stripHTMLTagsFromString$2,visuallyHideElement:visuallyHideElement$2},stripHTMLTags$3=HTMLUtilities.stripHTMLTagsFromString,doc$e=H.doc,defined$t=Utilities.defined,find$b=Utilities.find,fireEvent$j=Utilities.fireEvent;function getChartTitle$5(g){return stripHTMLTags$3(g.options.title.text||g.langFormat("accessibility.defaultChartTitle",{chart:g}))}function getAxisDescription$2(g){return g&&(g.userOptions&&g.userOptions.accessibility&&g.userOptions.accessibility.description||g.axisTitle&&g.axisTitle.textStr||g.options.id||g.categories&&"categories"||g.dateTime&&"Time"||"values")}function getAxisRangeDescription$2(g){var d=g.options||{};return d.accessibility&&typeof d.accessibility.rangeDescription<"u"?d.accessibility.rangeDescription:g.categories?getCategoryAxisRangeDesc(g):g.dateTime&&(g.min===0||g.dataMin===0)?getAxisTimeLengthDesc(g):getAxisFromToDescription(g)}function getCategoryAxisRangeDesc(g){var d=g.chart;return g.dataMax&&g.dataMin?d.langFormat("accessibility.axis.rangeCategories",{chart:d,axis:g,numCategories:g.dataMax-g.dataMin+1}):""}function getAxisTimeLengthDesc(g){var d=g.chart,a={},u="Seconds";a.Seconds=((g.max||0)-(g.min||0))/1e3,a.Minutes=a.Seconds/60,a.Hours=a.Minutes/60,a.Days=a.Hours/24,["Minutes","Hours","Days"].forEach(function(x){a[x]>2&&(u=x)});var v=a[u].toFixed(u!=="Seconds"&&u!=="Minutes"?1:0);return d.langFormat("accessibility.axis.timeRange"+u,{chart:d,axis:g,range:v.replace(".0","")})}function getAxisFromToDescription(g){var d=g.chart,a=d.options&&d.options.accessibility&&d.options.accessibility.screenReaderSection.axisRangeDateFormat||"",u=function(v){return g.dateTime?d.time.dateFormat(a,g[v]):g[v]};return d.langFormat("accessibility.axis.rangeFromTo",{chart:d,axis:g,rangeFrom:u("min"),rangeTo:u("max")})}function getSeriesFirstPointElement$1(g){if(g.points&&g.points.length){var d=find$b(g.points,function(a){return!!a.graphic});return d&&d.graphic&&d.graphic.element}}function getSeriesA11yElement$1(g){var d=getSeriesFirstPointElement$1(g);return d&&d.parentNode||g.graph&&g.graph.element||g.group&&g.group.element}function unhideChartElementFromAT$7(g,d){d.setAttribute("aria-hidden",!1),!(d===g.renderTo||!d.parentNode||d.parentNode===doc$e.body)&&(Array.prototype.forEach.call(d.parentNode.childNodes,function(a){a.hasAttribute("aria-hidden")||a.setAttribute("aria-hidden",!0)}),unhideChartElementFromAT$7(g,d.parentNode))}function hideSeriesFromAT$1(g){var d=getSeriesA11yElement$1(g);d&&d.setAttribute("aria-hidden",!0)}function getSeriesFromName$1(g,d){return d?(g.series||[]).filter(function(a){return a.name===d}):g.series}function getPointFromXY$1(g,d,a){for(var u=g.length,v;u--;)if(v=find$b(g[u].points||[],function(x){return x.x===d&&x.y===a}),v)return v}function getRelativePointAxisPosition(g,d){if(!defined$t(g.dataMin)||!defined$t(g.dataMax))return 0;var a=g.toPixels(g.dataMin),u=g.toPixels(g.dataMax),v=g.coll==="xAxis"?"x":"y",x=g.toPixels(d[v]||0);return(x-a)/(u-a)}function scrollToPoint$1(g){var d=g.series.xAxis,a=g.series.yAxis,u=d&&d.scrollbar?d:a,v=u&&u.scrollbar;if(v&&defined$t(v.to)&&defined$t(v.from)){var x=v.to-v.from,S=getRelativePointAxisPosition(u,g);v.updatePosition(S-x/2,S+x/2),fireEvent$j(v,"changed",{from:v.from,to:v.to,trigger:"scrollbar",DOMEvent:null})}}var ChartUtilities={getChartTitle:getChartTitle$5,getAxisDescription:getAxisDescription$2,getAxisRangeDescription:getAxisRangeDescription$2,getPointFromXY:getPointFromXY$1,getSeriesFirstPointElement:getSeriesFirstPointElement$1,getSeriesFromName:getSeriesFromName$1,getSeriesA11yElement:getSeriesA11yElement$1,unhideChartElementFromAT:unhideChartElementFromAT$7,hideSeriesFromAT:hideSeriesFromAT$1,scrollToPoint:scrollToPoint$1},find$a=Utilities.find;function KeyboardNavigationHandler(g,d){this.chart=g,this.keyCodeMap=d.keyCodeMap||[],this.validate=d.validate,this.init=d.init,this.terminate=d.terminate,this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}KeyboardNavigationHandler.prototype={run:function(g){var d=g.which||g.keyCode,a=this.response.noHandler,u=find$a(this.keyCodeMap,function(v){return v[0].indexOf(d)>-1});return u?a=u[1].call(this,d,g):d===9&&(a=this.response[g.shiftKey?"prev":"next"]),a}};var doc$d=H.doc,removeElement$4=HTMLUtilities.removeElement,extend$14=Utilities.extend,DOMElementProvider=function(){this.elements=[]};extend$14(DOMElementProvider.prototype,{createElement:function(){var g=doc$d.createElement.apply(doc$d,arguments);return this.elements.push(g),g},destroyCreatedElements:function(){this.elements.forEach(function(g){removeElement$4(g)}),this.elements=[]}});var addEvent$J=Utilities.addEvent,extend$13=Utilities.extend,EventProvider=function(){this.eventRemovers=[]};extend$13(EventProvider.prototype,{addEvent:function(){var g=addEvent$J.apply(H,arguments);return this.eventRemovers.push(g),g},removeAddedEvents:function(){this.eventRemovers.forEach(function(g){g()}),this.eventRemovers=[]}});var unhideChartElementFromAT$6=ChartUtilities.unhideChartElementFromAT,doc$c=H.doc,win$5=H.win,removeElement$3=HTMLUtilities.removeElement,getFakeMouseEvent$1=HTMLUtilities.getFakeMouseEvent,extend$12=Utilities.extend,fireEvent$i=Utilities.fireEvent,merge$V=Utilities.merge,functionsToOverrideByDerivedClasses={init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}};function AccessibilityComponent(){}AccessibilityComponent.prototype={initBase:function(g){this.chart=g,this.eventProvider=new EventProvider,this.domElementProvider=new DOMElementProvider,this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9}},addEvent:function(){return this.eventProvider.addEvent.apply(this.eventProvider,arguments)},createElement:function(){return this.domElementProvider.createElement.apply(this.domElementProvider,arguments)},fireEventOnWrappedOrUnwrappedElement:function(g,d){var a=d.type;doc$c.createEvent&&(g.dispatchEvent||g.fireEvent)?g.dispatchEvent?g.dispatchEvent(d):g.fireEvent(a,d):fireEvent$i(g,a,d)},fakeClickEvent:function(g){if(g){var d=getFakeMouseEvent$1("click");this.fireEventOnWrappedOrUnwrappedElement(g,d)}},addProxyGroup:function(g){this.createOrUpdateProxyContainer();var d=this.createElement("div");return Object.keys(g||{}).forEach(function(a){g[a]!==null&&d.setAttribute(a,g[a])}),this.chart.a11yProxyContainer.appendChild(d),d},createOrUpdateProxyContainer:function(){var g=this.chart,d=g.renderer.box;g.a11yProxyContainer=g.a11yProxyContainer||this.createProxyContainerElement(),d.nextSibling!==g.a11yProxyContainer&&g.container.insertBefore(g.a11yProxyContainer,d.nextSibling)},createProxyContainerElement:function(){var g=doc$c.createElement("div");return g.className="highcharts-a11y-proxy-container",g},createProxyButton:function(g,d,a,u,v){var x=g.element,S=this.createElement("button"),T=merge$V({"aria-label":x.getAttribute("aria-label")},a);return Object.keys(T).forEach(function(P){T[P]!==null&&S.setAttribute(P,T[P])}),S.className="highcharts-a11y-proxy-button",g.hasClass("highcharts-no-tooltip")&&(S.className+=" highcharts-no-tooltip"),v&&this.addEvent(S,"click",v),this.setProxyButtonStyle(S),this.updateProxyButtonPosition(S,u||g),this.proxyMouseEventsForButton(x,S),d.appendChild(S),T["aria-hidden"]||unhideChartElementFromAT$6(this.chart,S),S},getElementPosition:function(g){var d=g.element,a=this.chart.renderTo;if(a&&d&&d.getBoundingClientRect){var u=d.getBoundingClientRect(),v=a.getBoundingClientRect();return{x:u.left-v.left,y:u.top-v.top,width:u.right-u.left,height:u.bottom-u.top}}return{x:0,y:0,width:1,height:1}},setProxyButtonStyle:function(g){merge$V(!0,g.style,{borderWidth:"0",backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:"0.001",filter:"alpha(opacity=1)",zIndex:"999",overflow:"hidden",padding:"0",margin:"0",display:"block",position:"absolute"}),g.style["-ms-filter"]="progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"},updateProxyButtonPosition:function(g,d){var a=this.getElementPosition(d);merge$V(!0,g.style,{width:(a.width||1)+"px",height:(a.height||1)+"px",left:(Math.round(a.x)||0)+"px",top:(Math.round(a.y)||0)+"px"})},proxyMouseEventsForButton:function(g,d){var a=this;["click","touchstart","touchend","touchcancel","touchmove","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(u){var v=u.indexOf("touch")===0;a.addEvent(d,u,function(x){var S=v?a.cloneTouchEvent(x):a.cloneMouseEvent(x);g&&a.fireEventOnWrappedOrUnwrappedElement(g,S),x.stopPropagation(),u!=="touchstart"&&u!=="touchmove"&&u!=="touchend"&&x.preventDefault()},{passive:!1})})},cloneMouseEvent:function(g){if(typeof win$5.MouseEvent=="function")return new win$5.MouseEvent(g.type,g);if(doc$c.createEvent){var d=doc$c.createEvent("MouseEvent");if(d.initMouseEvent)return d.initMouseEvent(g.type,g.bubbles,g.cancelable,g.view||win$5,g.detail,g.screenX,g.screenY,g.clientX,g.clientY,g.ctrlKey,g.altKey,g.shiftKey,g.metaKey,g.button,g.relatedTarget),d}return getFakeMouseEvent$1(g.type)},cloneTouchEvent:function(g){var d=function(v){for(var x=[],S=0;S<v.length;++S){var T=v.item(S);T&&x.push(T)}return x};if(typeof win$5.TouchEvent=="function"){var a=new win$5.TouchEvent(g.type,{touches:d(g.touches),targetTouches:d(g.targetTouches),changedTouches:d(g.changedTouches),ctrlKey:g.ctrlKey,shiftKey:g.shiftKey,altKey:g.altKey,metaKey:g.metaKey,bubbles:g.bubbles,cancelable:g.cancelable,composed:g.composed,detail:g.detail,view:g.view});return g.defaultPrevented&&a.preventDefault(),a}var u=this.cloneMouseEvent(g);return u.touches=g.touches,u.changedTouches=g.changedTouches,u.targetTouches=g.targetTouches,u},destroyBase:function(){removeElement$3(this.chart.a11yProxyContainer),this.domElementProvider.destroyCreatedElements(),this.eventProvider.removeAddedEvents()}};extend$12(AccessibilityComponent.prototype,functionsToOverrideByDerivedClasses);var doc$b=H.doc,win$4=H.win,addEvent$I=Utilities.addEvent,fireEvent$h=Utilities.fireEvent,getElement$1=HTMLUtilities.getElement;addEvent$I(doc$b,"keydown",function(g){var d=g.which||g.keyCode,a=27;d===a&&H.charts&&H.charts.forEach(function(u){u&&u.dismissPopupContent&&u.dismissPopupContent()})});Chart$1.prototype.dismissPopupContent=function(){var g=this;fireEvent$h(this,"dismissPopupContent",{},function(){g.tooltip&&g.tooltip.hide(0),g.hideExportMenu()})};function KeyboardNavigation(g,d){this.init(g,d)}KeyboardNavigation.prototype={init:function(g,d){var a=this,u=this.eventProvider=new EventProvider;this.chart=g,this.components=d,this.modules=[],this.currentModuleIx=0,this.update(),u.addEvent(this.tabindexContainer,"keydown",function(v){return a.onKeydown(v)}),u.addEvent(this.tabindexContainer,"focus",function(v){return a.onFocus(v)}),["mouseup","touchend"].forEach(function(v){return u.addEvent(doc$b,v,function(){return a.onMouseUp()})}),["mousedown","touchstart"].forEach(function(v){return u.addEvent(g.renderTo,v,function(){a.isClickingChart=!0})}),u.addEvent(g.renderTo,"mouseover",function(){a.pointerIsOverChart=!0}),u.addEvent(g.renderTo,"mouseout",function(){a.pointerIsOverChart=!1}),this.modules.length&&this.modules[0].init(1)},update:function(g){var d=this.chart.options.accessibility,a=d&&d.keyboardNavigation,u=this.components;this.updateContainerTabindex(),a&&a.enabled&&g&&g.length?(this.modules=g.reduce(function(v,x){var S=u[x].getKeyboardNavigation();return v.concat(S)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())},onFocus:function(g){var d=this.chart,a=g.relatedTarget&&d.container.contains(g.relatedTarget);!this.exiting&&!this.tabbingInBackwards&&!this.isClickingChart&&!a&&this.modules[0]&&this.modules[0].init(1),this.exiting=!1},onMouseUp:function(){if(delete this.isClickingChart,!this.keyboardReset&&!this.pointerIsOverChart){var g=this.chart,d=this.modules&&this.modules[this.currentModuleIx||0];d&&d.terminate&&d.terminate(),g.focusElement&&g.focusElement.removeFocusBorder(),this.currentModuleIx=0,this.keyboardReset=!0}},onKeydown:function(g){var d=g||win$4.event,a,u=this.modules&&this.modules.length&&this.modules[this.currentModuleIx];if(this.keyboardReset=!1,this.exiting=!1,u){var v=u.run(d);v===u.response.success?a=!0:v===u.response.prev?a=this.prev():v===u.response.next&&(a=this.next()),a&&(d.preventDefault(),d.stopPropagation())}},prev:function(){return this.move(-1)},next:function(){return this.move(1)},move:function(g){var d=this.modules&&this.modules[this.currentModuleIx];d&&d.terminate&&d.terminate(g),this.chart.focusElement&&this.chart.focusElement.removeFocusBorder(),this.currentModuleIx+=g;var a=this.modules&&this.modules[this.currentModuleIx];if(a){if(a.validate&&!a.validate())return this.move(g);if(a.init)return a.init(g),!0}return this.currentModuleIx=0,this.exiting=!0,g>0?this.exitAnchor.focus():this.tabindexContainer.focus(),!1},updateExitAnchor:function(){var g="highcharts-end-of-chart-marker-"+this.chart.index,d=getElement$1(g);this.removeExitAnchor(),d?(this.makeElementAnExitAnchor(d),this.exitAnchor=d):this.createExitAnchor()},updateContainerTabindex:function(){var g=this.chart.options.accessibility,d=g&&g.keyboardNavigation,a=!(d&&d.enabled===!1),u=this.chart,v=u.container,x;u.renderTo.hasAttribute("tabindex")?(v.removeAttribute("tabindex"),x=u.renderTo):x=v,this.tabindexContainer=x;var S=x.getAttribute("tabindex");a&&!S?x.setAttribute("tabindex","0"):a||u.container.removeAttribute("tabindex")},makeElementAnExitAnchor:function(g){var d=this.tabindexContainer.getAttribute("tabindex")||0;g.setAttribute("class","highcharts-exit-anchor"),g.setAttribute("tabindex",d),g.setAttribute("aria-hidden",!1),this.addExitAnchorEventsToEl(g)},createExitAnchor:function(){var g=this.chart,d=this.exitAnchor=doc$b.createElement("div");g.renderTo.appendChild(d),this.makeElementAnExitAnchor(d)},removeExitAnchor:function(){this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)},addExitAnchorEventsToEl:function(g){var d=this.chart,a=this;this.eventProvider.addEvent(g,"focus",function(u){var v=u||win$4.event,x,S=v.relatedTarget&&d.container.contains(v.relatedTarget),T=!(S||a.exiting);T?(a.tabbingInBackwards=!0,a.tabindexContainer.focus(),delete a.tabbingInBackwards,v.preventDefault(),a.modules&&a.modules.length&&(a.currentModuleIx=a.modules.length-1,x=a.modules[a.currentModuleIx],x&&x.validate&&!x.validate()?a.prev():x&&x.init(-1))):a.exiting=!1})},destroy:function(){this.removeExitAnchor(),this.eventProvider.removeAddedEvents(),this.chart.container.removeAttribute("tabindex")}};var animObject$4=animationExports.animObject,addEvent$H=Utilities.addEvent,extend$11=Utilities.extend,find$9=Utilities.find,fireEvent$g=Utilities.fireEvent,isNumber$s=Utilities.isNumber,pick$11=Utilities.pick,syncTimeout$1=Utilities.syncTimeout,removeElement$2=HTMLUtilities.removeElement,stripHTMLTags$2=HTMLUtilities.stripHTMLTagsFromString,getChartTitle$4=ChartUtilities.getChartTitle;function scrollLegendToItem(g,d){var a=g.allItems[d].pageIx,u=g.currentPage;typeof a<"u"&&a+1!==u&&g.scroll(1+a-u)}function shouldDoLegendA11y(g){var d=g.legend&&g.legend.allItems,a=g.options.legend.accessibility||{};return!!(d&&d.length&&!(g.colorAxis&&g.colorAxis.length)&&a.enabled!==!1)}Chart$1.prototype.highlightLegendItem=function(g){var d=this.legend.allItems,a=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx;return d[g]?(isNumber$s(a)&&d[a]&&fireEvent$g(d[a].legendGroup.element,"mouseout"),scrollLegendToItem(this.legend,g),this.setFocusToElement(d[g].legendItem,d[g].a11yProxyElement),fireEvent$g(d[g].legendGroup.element,"mouseover"),!0):!1};addEvent$H(Legend,"afterColorizeItem",function(g){var d=this.chart,a=d.options.accessibility,u=g.item;a.enabled&&u&&u.a11yProxyElement&&u.a11yProxyElement.setAttribute("aria-pressed",g.visible?"true":"false")});var LegendComponent=function(){};LegendComponent.prototype=new AccessibilityComponent;extend$11(LegendComponent.prototype,{init:function(){var g=this;this.proxyElementsList=[],this.recreateProxies(),this.addEvent(Legend,"afterScroll",function(){this.chart===g.chart&&(g.updateProxiesPositions(),g.updateLegendItemProxyVisibility(),this.chart.highlightLegendItem(g.highlightedLegendItemIx))}),this.addEvent(Legend,"afterPositionItem",function(d){this.chart===g.chart&&this.chart.renderer&&g.updateProxyPositionForItem(d.item)}),this.addEvent(Legend,"afterRender",function(){this.chart===g.chart&&this.chart.renderer&&g.recreateProxies()&&syncTimeout$1(function(){return g.updateProxiesPositions()},animObject$4(pick$11(this.chart.renderer.globalAnimation,!0)).duration)})},updateLegendItemProxyVisibility:function(){var g=this.chart.legend,d=g.allItems||[],a=g.currentPage||1,u=g.clipHeight||0;d.forEach(function(v){var x=v.pageIx||0,S=v._legendItemPos?v._legendItemPos[1]:0,T=v.legendItem?Math.round(v.legendItem.getBBox().height):0,P=S+T-g.pages[x]>u||x!==a-1;v.a11yProxyElement&&(v.a11yProxyElement.style.visibility=P?"hidden":"visible")})},onChartRender:function(){shouldDoLegendA11y(this.chart)||this.removeProxies()},onChartUpdate:function(){this.updateLegendTitle()},updateProxiesPositions:function(){for(var g=0,d=this.proxyElementsList;g<d.length;g++){var a=d[g],u=a.element,v=a.posElement;this.updateProxyButtonPosition(u,v)}},updateProxyPositionForItem:function(g){var d=find$9(this.proxyElementsList,function(a){return a.item===g});d&&this.updateProxyButtonPosition(d.element,d.posElement)},recreateProxies:function(){return this.removeProxies(),shouldDoLegendA11y(this.chart)?(this.addLegendProxyGroup(),this.addLegendListContainer(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility(),!0):!1},removeProxies:function(){removeElement$2(this.legendProxyGroup),this.proxyElementsList=[]},updateLegendTitle:function(){var g=this.chart,d=stripHTMLTags$2((g.legend&&g.legend.options.title&&g.legend.options.title.text||"").replace(/<br ?\/?>/g," ")),a=g.langFormat("accessibility.legend.legendLabel"+(d?"":"NoTitle"),{chart:g,legendTitle:d,chartTitle:getChartTitle$4(g)});this.legendProxyGroup&&this.legendProxyGroup.setAttribute("aria-label",a)},addLegendProxyGroup:function(){var g=this.chart.options.accessibility,d=g.landmarkVerbosity==="all"?"region":null;this.legendProxyGroup=this.addProxyGroup({"aria-label":"_placeholder_",role:d})},addLegendListContainer:function(){if(this.legendProxyGroup){var g=this.legendListContainer=this.createElement("ul");g.style.listStyle="none",this.legendProxyGroup.appendChild(g)}},proxyLegendItems:function(){var g=this,d=this.chart.legend&&this.chart.legend.allItems||[];d.forEach(function(a){a.legendItem&&a.legendItem.element&&g.proxyLegendItem(a)})},proxyLegendItem:function(g){if(!(!g.legendItem||!g.legendGroup||!this.legendListContainer)){var d=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:stripHTMLTags$2(g.name),item:g}),a={tabindex:-1,"aria-pressed":g.visible,"aria-label":d},u=g.legendGroup.div?g.legendItem:g.legendGroup,v=this.createElement("li");this.legendListContainer.appendChild(v),g.a11yProxyElement=this.createProxyButton(g.legendItem,v,a,u),this.proxyElementsList.push({item:g,element:g.a11yProxyElement,posElement:u})}},getKeyboardNavigation:function(){var g=this.keyCodes,d=this,a=this.chart;return new KeyboardNavigationHandler(a,{keyCodeMap:[[[g.left,g.right,g.up,g.down],function(u){return d.onKbdArrowKey(this,u)}],[[g.enter,g.space],function(u){return H.isFirefox&&u===g.space?this.response.success:d.onKbdClick(this)}]],validate:function(){return d.shouldHaveLegendNavigation()},init:function(u){return d.onKbdNavigationInit(u)},terminate:function(){a.legend.allItems.forEach(function(u){return u.setState("",!0)})}})},onKbdArrowKey:function(g,d){var a=this.keyCodes,u=g.response,v=this.chart,x=v.options.accessibility,S=v.legend.allItems.length,T=d===a.left||d===a.up?-1:1,P=v.highlightLegendItem(this.highlightedLegendItemIx+T);return P?(this.highlightedLegendItemIx+=T,u.success):S>1&&x.keyboardNavigation.wrapAround?(g.init(T),u.success):u[T>0?"next":"prev"]},onKbdClick:function(g){var d=this.chart.legend.allItems[this.highlightedLegendItemIx];return d&&d.a11yProxyElement&&fireEvent$g(d.a11yProxyElement,"click"),g.response.success},shouldHaveLegendNavigation:function(){var g=this.chart,d=g.options.legend||{},a=g.legend&&g.legend.allItems,u=g.colorAxis&&g.colorAxis.length,v=d.accessibility||{};return!!(a&&g.legend.display&&!u&&v.enabled&&v.keyboardNavigation&&v.keyboardNavigation.enabled)},onKbdNavigationInit:function(g){var d=this.chart,a=d.legend.allItems.length-1,u=g>0?0:a;d.highlightLegendItem(u),this.highlightedLegendItemIx=u}});var extend$10=Utilities.extend,getChartTitle$3=ChartUtilities.getChartTitle,unhideChartElementFromAT$5=ChartUtilities.unhideChartElementFromAT,removeElement$1=HTMLUtilities.removeElement,getFakeMouseEvent=HTMLUtilities.getFakeMouseEvent;function getExportMenuButtonElement(g){return g.exportSVGElements&&g.exportSVGElements[0]}Chart$1.prototype.showExportMenu=function(){var g=getExportMenuButtonElement(this);if(g){var d=g.element;d.onclick&&d.onclick(getFakeMouseEvent("click"))}};Chart$1.prototype.hideExportMenu=function(){var g=this,d=g.exportDivElements;d&&g.exportContextMenu&&(d.forEach(function(a){a&&a.className==="highcharts-menu-item"&&a.onmouseout&&a.onmouseout(getFakeMouseEvent("mouseout"))}),g.highlightedExportItemIx=0,g.exportContextMenu.hideMenu(),g.container.focus())};Chart$1.prototype.highlightExportItem=function(g){var d=this.exportDivElements&&this.exportDivElements[g],a=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx],u;return d&&d.tagName==="LI"&&!(d.children&&d.children.length)?(u=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus,d.focus&&u&&d.focus(),a&&a.onmouseout&&a.onmouseout(getFakeMouseEvent("mouseout")),d.onmouseover&&d.onmouseover(getFakeMouseEvent("mouseover")),this.highlightedExportItemIx=g,!0):!1};Chart$1.prototype.highlightLastExportItem=function(){var g=this,d;if(g.exportDivElements){for(d=g.exportDivElements.length;d--;)if(g.highlightExportItem(d))return!0}return!1};function exportingShouldHaveA11y(g){var d=g.options.exporting,a=getExportMenuButtonElement(g);return!!(d&&d.enabled!==!1&&d.accessibility&&d.accessibility.enabled&&a&&a.element)}var MenuComponent=function(){};MenuComponent.prototype=new AccessibilityComponent;extend$10(MenuComponent.prototype,{init:function(){var g=this.chart,d=this;this.addEvent(g,"exportMenuShown",function(){d.onMenuShown()}),this.addEvent(g,"exportMenuHidden",function(){d.onMenuHidden()})},onMenuHidden:function(){var g=this.chart.exportContextMenu;g&&g.setAttribute("aria-hidden","true"),this.isExportMenuShown=!1,this.setExportButtonExpandedState("false")},onMenuShown:function(){var g=this.chart,d=g.exportContextMenu;d&&(this.addAccessibleContextMenuAttribs(),unhideChartElementFromAT$5(g,d)),this.isExportMenuShown=!0,this.setExportButtonExpandedState("true")},setExportButtonExpandedState:function(g){var d=this.exportButtonProxy;d&&d.setAttribute("aria-expanded",g)},onChartRender:function(){var g=this.chart,d=g.options.accessibility;if(removeElement$1(this.exportProxyGroup),exportingShouldHaveA11y(g)){this.exportProxyGroup=this.addProxyGroup(d.landmarkVerbosity==="all"?{"aria-label":g.langFormat("accessibility.exporting.exportRegionLabel",{chart:g,chartTitle:getChartTitle$3(g)}),role:"region"}:{});var a=getExportMenuButtonElement(this.chart);this.exportButtonProxy=this.createProxyButton(a,this.exportProxyGroup,{"aria-label":g.langFormat("accessibility.exporting.menuButtonLabel",{chart:g}),"aria-expanded":!1})}},addAccessibleContextMenuAttribs:function(){var g=this.chart,d=g.exportDivElements;if(d&&d.length){d.forEach(function(u){u&&(u.tagName==="LI"&&!(u.children&&u.children.length)?u.setAttribute("tabindex",-1):u.setAttribute("aria-hidden","true"))});var a=d[0]&&d[0].parentNode;a&&(a.removeAttribute("aria-hidden"),a.setAttribute("aria-label",g.langFormat("accessibility.exporting.chartMenuLabel",{chart:g})))}},getKeyboardNavigation:function(){var g=this.keyCodes,d=this.chart,a=this;return new KeyboardNavigationHandler(d,{keyCodeMap:[[[g.left,g.up],function(){return a.onKbdPrevious(this)}],[[g.right,g.down],function(){return a.onKbdNext(this)}],[[g.enter,g.space],function(){return a.onKbdClick(this)}]],validate:function(){return!!d.exporting&&d.options.exporting.enabled!==!1&&d.options.exporting.accessibility.enabled!==!1},init:function(){var u=a.exportButtonProxy,v=d.exportingGroup;v&&u&&d.setFocusToElement(v,u)},terminate:function(){d.hideExportMenu()}})},onKbdPrevious:function(g){for(var d=this.chart,a=d.options.accessibility,u=g.response,v=d.highlightedExportItemIx||0;v--;)if(d.highlightExportItem(v))return u.success;return a.keyboardNavigation.wrapAround?(d.highlightLastExportItem(),u.success):u.prev},onKbdNext:function(g){for(var d=this.chart,a=d.options.accessibility,u=g.response,v=(d.highlightedExportItemIx||0)+1;v<d.exportDivElements.length;++v)if(d.highlightExportItem(v))return u.success;return a.keyboardNavigation.wrapAround?(d.highlightExportItem(0),u.success):u.next},onKbdClick:function(g){var d=this.chart,a=d.exportDivElements[d.highlightedExportItemIx],u=getExportMenuButtonElement(d).element;return this.isExportMenuShown?this.fakeClickEvent(a):(this.fakeClickEvent(u),d.highlightExportItem(0)),g.response.success}});var seriesTypes$5=SeriesRegistry$1.seriesTypes,doc$a=H.doc,defined$s=Utilities.defined,extend$$=Utilities.extend,fireEvent$f=Utilities.fireEvent,getPointFromXY=ChartUtilities.getPointFromXY,getSeriesFromName=ChartUtilities.getSeriesFromName,scrollToPoint=ChartUtilities.scrollToPoint;Series$f.prototype.keyboardMoveVertical=!0;["column","pie"].forEach(function(g){seriesTypes$5[g]&&(seriesTypes$5[g].prototype.keyboardMoveVertical=!1)});function getPointIndex(g){var d=g.index,a=g.series.points,u=a.length;if(a[d]!==g){for(;u--;)if(a[u]===g)return u}else return d}function isSkipSeries(g){var d=g.chart.options.accessibility,a=d.keyboardNavigation.seriesNavigation,u=g.options.accessibility||{},v=u.keyboardNavigation;return v&&v.enabled===!1||u.enabled===!1||g.options.enableMouseTracking===!1||!g.visible||a.pointNavigationEnabledThreshold&&a.pointNavigationEnabledThreshold<=g.points.length}function isSkipPoint(g){var d=g.series.chart.options.accessibility,a=g.options.accessibility&&g.options.accessibility.enabled===!1;return g.isNull&&d.keyboardNavigation.seriesNavigation.skipNullPoints||g.visible===!1||g.isInside===!1||a||isSkipSeries(g.series)}function getClosestPoint(g,d,a,u){var v=1/0,x,S,T,P=d.points.length,z=function(L){return!(defined$s(L.plotX)&&defined$s(L.plotY))};if(!z(g)){for(;P--;)x=d.points[P],!z(x)&&(T=(g.plotX-x.plotX)*(g.plotX-x.plotX)*a+(g.plotY-x.plotY)*(g.plotY-x.plotY)*1,T<v&&(v=T,S=P));return defined$s(S)?d.points[S]:void 0}}Point$4.prototype.highlight=function(){var g=this.series.chart;return this.isNull?g.tooltip&&g.tooltip.hide(0):this.onMouseOver(),scrollToPoint(this),this.graphic&&g.setFocusToElement(this.graphic),g.highlightedPoint=this,this};Chart$1.prototype.highlightAdjacentPoint=function(g){var d=this,a=d.series,u=d.highlightedPoint,v=u&&getPointIndex(u)||0,x=u&&u.series.points,S=d.series&&d.series[d.series.length-1],T=S&&S.points&&S.points[S.points.length-1],P,z;if(!a[0]||!a[0].points)return!1;if(!u)z=g?a[0].points[0]:T;else if(P=a[u.series.index+(g?1:-1)],z=x[v+(g?1:-1)],!z&&P&&(z=P.points[g?0:P.points.length-1]),!z)return!1;return isSkipPoint(z)?(P=z.series,isSkipSeries(P)?d.highlightedPoint=g?P.points[P.points.length-1]:P.points[0]:d.highlightedPoint=z,d.highlightAdjacentPoint(g)):z.highlight()};Series$f.prototype.highlightFirstValidPoint=function(){var g=this.chart.highlightedPoint,d=(g&&g.series)===this?getPointIndex(g):0,a=this.points,u=a.length;if(a&&u){for(var v=d;v<u;++v)if(!isSkipPoint(a[v]))return a[v].highlight();for(var x=d;x>=0;--x)if(!isSkipPoint(a[x]))return a[x].highlight()}return!1};Chart$1.prototype.highlightAdjacentSeries=function(g){var d=this,a=d.highlightedPoint,u=d.series&&d.series[d.series.length-1],v=u&&u.points&&u.points[u.points.length-1],x,S,T;return d.highlightedPoint?(x=d.series[a.series.index+(g?-1:1)],!x||(S=getClosestPoint(a,x,4),!S)?!1:isSkipSeries(x)?(S.highlight(),T=d.highlightAdjacentSeries(g),T||(a.highlight(),!1)):(S.highlight(),S.series.highlightFirstValidPoint())):(x=g?d.series&&d.series[0]:u,S=g?x&&x.points&&x.points[0]:v,S?S.highlight():!1)};Chart$1.prototype.highlightAdjacentPointVertical=function(g){var d=this.highlightedPoint,a=1/0,u;return!defined$s(d.plotX)||!defined$s(d.plotY)?!1:(this.series.forEach(function(v){isSkipSeries(v)||v.points.forEach(function(x){if(!(!defined$s(x.plotY)||!defined$s(x.plotX)||x===d)){var S=x.plotY-d.plotY,T=Math.abs(x.plotX-d.plotX),P=Math.abs(S)*Math.abs(S)+T*T*4;v.yAxis&&v.yAxis.reversed&&(S*=-1),!(S<=0&&g||S>=0&&!g||P<5||isSkipPoint(x))&&P<a&&(a=P,u=x)}})}),u?u.highlight():!1)};function highlightFirstValidPointInChart(g){var d=!1;return delete g.highlightedPoint,d=g.series.reduce(function(a,u){return a||u.highlightFirstValidPoint()},!1),d}function highlightLastValidPointInChart(g){for(var d=g.series.length,a=d,u=!1;a--&&(g.highlightedPoint=g.series[a].points[g.series[a].points.length-1],u=g.series[a].highlightFirstValidPoint(),!u););return u}function updateChartFocusAfterDrilling(g){highlightFirstValidPointInChart(g),g.focusElement&&g.focusElement.removeFocusBorder()}function SeriesKeyboardNavigation(g,d){this.keyCodes=d,this.chart=g}extend$$(SeriesKeyboardNavigation.prototype,{init:function(){var g=this,d=this.chart,a=this.eventProvider=new EventProvider;a.addEvent(Series$f,"destroy",function(){return g.onSeriesDestroy(this)}),a.addEvent(d,"afterDrilldown",function(){updateChartFocusAfterDrilling(this)}),a.addEvent(d,"drilldown",function(u){var v=u.point,x=v.series;g.lastDrilledDownPoint={x:v.x,y:v.y,seriesName:x?x.name:""}}),a.addEvent(d,"drillupall",function(){setTimeout(function(){g.onDrillupAll()},10)}),a.addEvent(Point$4,"afterSetState",function(){var u=this,v=u.graphic&&u.graphic.element;d.highlightedPoint===u&&doc$a.activeElement!==v&&v&&v.focus&&v.focus()})},onDrillupAll:function(){var g=this.lastDrilledDownPoint,d=this.chart,a=g&&getSeriesFromName(d,g.seriesName),u;g&&a&&defined$s(g.x)&&defined$s(g.y)&&(u=getPointFromXY(a,g.x,g.y)),d.container&&d.container.focus(),u&&u.highlight&&u.highlight(),d.focusElement&&d.focusElement.removeFocusBorder()},getKeyboardNavigationHandler:function(){var g=this,d=this.keyCodes,a=this.chart,u=a.inverted;return new KeyboardNavigationHandler(a,{keyCodeMap:[[u?[d.up,d.down]:[d.left,d.right],function(v){return g.onKbdSideways(this,v)}],[u?[d.left,d.right]:[d.up,d.down],function(v){return g.onKbdVertical(this,v)}],[[d.enter,d.space],function(v,x){var S=a.highlightedPoint;return S&&(x.point=S,fireEvent$f(S.series,"click",x),S.firePointEvent("click")),this.response.success}]],init:function(v){return g.onHandlerInit(this,v)},terminate:function(){return g.onHandlerTerminate()}})},onKbdSideways:function(g,d){var a=this.keyCodes,u=d===a.right||d===a.down;return this.attemptHighlightAdjacentPoint(g,u)},onKbdVertical:function(g,d){var a=this.chart,u=this.keyCodes,v=d===u.down||d===u.right,x=a.options.accessibility.keyboardNavigation.seriesNavigation;if(x.mode&&x.mode==="serialize")return this.attemptHighlightAdjacentPoint(g,v);var S=a.highlightedPoint&&a.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries";return a[S](v),g.response.success},onHandlerInit:function(g,d){var a=this.chart;return d>0?highlightFirstValidPointInChart(a):highlightLastValidPointInChart(a),g.response.success},onHandlerTerminate:function(){var g=this.chart;g.tooltip&&g.tooltip.hide(0);var d=g.highlightedPoint&&g.highlightedPoint.series;d&&d.onMouseOut&&d.onMouseOut(),g.highlightedPoint&&g.highlightedPoint.onMouseOut&&g.highlightedPoint.onMouseOut(),delete g.highlightedPoint},attemptHighlightAdjacentPoint:function(g,d){var a=this.chart,u=a.options.accessibility.keyboardNavigation.wrapAround,v=a.highlightAdjacentPoint(d);return v?g.response.success:u?g.init(d?1:-1):g.response[d?"next":"prev"]},onSeriesDestroy:function(g){var d=this.chart,a=d.highlightedPoint&&d.highlightedPoint.series===g;a&&(delete d.highlightedPoint,d.focusElement&&d.focusElement.removeFocusBorder())},destroy:function(){this.eventProvider.removeAddedEvents()}});var escapeStringForHTML=HTMLUtilities.escapeStringForHTML,stripHTMLTagsFromString$1=HTMLUtilities.stripHTMLTagsFromString;function getChartAnnotationLabels(g){var d=g.annotations||[];return d.reduce(function(a,u){return u.options&&u.options.visible!==!1&&(a=a.concat(u.labels)),a},[])}function getLabelText(g){return g.options&&g.options.accessibility&&g.options.accessibility.description||g.graphic&&g.graphic.text&&g.graphic.text.textStr||""}function getAnnotationLabelDescription(g){var d=g.options&&g.options.accessibility&&g.options.accessibility.description;if(d)return d;var a=g.chart,u=getLabelText(g),v=g.points,x=function($){return $.graphic&&$.graphic.element&&$.graphic.element.getAttribute("aria-label")||""},S=function($){var B=$.accessibility&&$.accessibility.valueDescription||x($),U=$&&$.series.name||"";return(U?U+", ":"")+"data point "+B},T=v.filter(function($){return!!$.graphic}).map(S).filter(function($){return!!$}),P=T.length,z=P>1?"MultiplePoints":P?"SinglePoint":"NoPoints",L="accessibility.screenReaderSection.annotations.description"+z,N={annotationText:u,annotation:g,numPoints:P,annotationPoint:T[0],additionalAnnotationPoints:T.slice(1)};return a.langFormat(L,N)}function getAnnotationListItems(g){var d=getChartAnnotationLabels(g);return d.map(function(a){var u=escapeStringForHTML(stripHTMLTagsFromString$1(getAnnotationLabelDescription(a)));return u?"<li>"+u+"</li>":""})}function getAnnotationsInfoHTML$1(g){var d=g.annotations;if(!(d&&d.length))return"";var a=getAnnotationListItems(g);return'<ul style="list-style-type: none">'+a.join(" ")+"</ul>"}function getPointAnnotationTexts$1(g){var d=getChartAnnotationLabels(g.series.chart),a=d.filter(function(u){return u.points.indexOf(g)>-1});return a.length?a.map(function(u){return""+getLabelText(u)}):[]}var AnnotationsA11y={getAnnotationsInfoHTML:getAnnotationsInfoHTML$1,getPointAnnotationTexts:getPointAnnotationTexts$1},getPointAnnotationTexts=AnnotationsA11y.getPointAnnotationTexts,getAxisDescription$1=ChartUtilities.getAxisDescription,getSeriesFirstPointElement=ChartUtilities.getSeriesFirstPointElement,getSeriesA11yElement=ChartUtilities.getSeriesA11yElement,unhideChartElementFromAT$4=ChartUtilities.unhideChartElementFromAT,format$6=FormatUtilities.format,numberFormat=FormatUtilities.numberFormat,reverseChildNodes=HTMLUtilities.reverseChildNodes,stripHTMLTags$1=HTMLUtilities.stripHTMLTagsFromString,find$8=Utilities.find,isNumber$r=Utilities.isNumber,pick$10=Utilities.pick,defined$r=Utilities.defined;function findFirstPointWithGraphic(g){var d=g.index;return!g.series||!g.series.data||!defined$r(d)?null:find$8(g.series.data,function(a){return!!(a&&typeof a.index<"u"&&a.index>d&&a.graphic&&a.graphic.element)})||null}function shouldAddDummyPoint(g){var d=g.series&&g.series.is("sunburst"),a=g.isNull;return a&&!d}function makeDummyElement(g,d){var a=g.series.chart.renderer,u=a.rect(d.x,d.y,1,1);return u.attr({class:"highcharts-a11y-dummy-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0}),u}function addDummyPointElement(g){var d=g.series,a=findFirstPointWithGraphic(g),u=a&&a.graphic,v=u?u.parentGroup:d.graph||d.group,x=a?{x:pick$10(g.plotX,a.plotX,0),y:pick$10(g.plotY,a.plotY,0)}:{x:pick$10(g.plotX,0),y:pick$10(g.plotY,0)},S=makeDummyElement(g,x);if(v&&v.element)return g.graphic=S,g.hasDummyGraphic=!0,S.add(v),v.element.insertBefore(S.element,u?u.element:null),S.element}function hasMorePointsThanDescriptionThreshold(g){var d=g.chart.options.accessibility,a=d.series.pointDescriptionEnabledThreshold;return!!(a!==!1&&g.points&&g.points.length>=a)}function shouldSetScreenReaderPropsOnPoints(g){var d=g.options.accessibility||{};return!hasMorePointsThanDescriptionThreshold(g)&&!d.exposeAsGroupOnly}function shouldSetKeyboardNavPropsOnPoints(g){var d=g.chart.options.accessibility,a=d.keyboardNavigation.seriesNavigation;return!!(g.points&&(g.points.length<a.pointNavigationEnabledThreshold||a.pointNavigationEnabledThreshold===!1))}function shouldDescribeSeriesElement(g){var d=g.chart,a=d.options.chart,u=a.options3d&&a.options3d.enabled,v=d.series.length>1,x=d.options.accessibility.series.describeSingleSeries,S=(g.options.accessibility||{}).exposeAsGroupOnly,T=u&&v;return!T&&(v||x||S||hasMorePointsThanDescriptionThreshold(g))}function pointNumberToString(g,d){var a=g.series.chart,u=a.options.accessibility.point||{},v=g.series.tooltipOptions||{},x=a.options.lang;return isNumber$r(d)?numberFormat(d,u.valueDecimals||v.valueDecimals||-1,x.decimalPoint,x.accessibility.thousandsSep||x.thousandsSep):d}function getSeriesDescriptionText(g){var d=g.options.accessibility||{},a=d.description;return a&&g.chart.langFormat("accessibility.series.description",{description:a,series:g})||""}function getSeriesAxisDescriptionText(g,d){var a=g[d];return g.chart.langFormat("accessibility.series."+d+"Description",{name:getAxisDescription$1(a),series:g})}function getPointA11yTimeDescription(g){var d=g.series,a=d.chart,u=a.options.accessibility.point||{},v=d.xAxis&&d.xAxis.dateTime;if(v){var x=v.getXDateFormat(g.x||0,a.options.tooltip.dateTimeLabelFormats),S=u.dateFormatter&&u.dateFormatter(g)||u.dateFormat||x;return a.time.dateFormat(S,g.x||0,void 0)}}function getPointXDescription(g){var d=getPointA11yTimeDescription(g),a=g.series.xAxis||{},u=a.categories&&defined$r(g.category)&&(""+g.category).replace("<br/>"," "),v=g.id&&g.id.indexOf("highcharts-")<0,x="x, "+g.x;return g.name||d||u||(v?g.id:x)}function getPointArrayMapValueDescription(g,d,a){var u=d||"",v=a||"",x=function(T){var P=pointNumberToString(g,pick$10(g[T],g.options[T]));return T+": "+u+P+v},S=g.series.pointArrayMap;return S.reduce(function(T,P){return T+(T.length?", ":"")+x(P)},"")}function getPointValue(g){var d=g.series,a=d.chart.options.accessibility.point||{},u=d.tooltipOptions||{},v=a.valuePrefix||u.valuePrefix||"",x=a.valueSuffix||u.valueSuffix||"",S=typeof g.value<"u"?"value":"y",T=pointNumberToString(g,g[S]);return g.isNull?d.chart.langFormat("accessibility.series.nullPointValue",{point:g}):d.pointArrayMap?getPointArrayMapValueDescription(g,v,x):v+T+x}function getPointAnnotationDescription(g){var d=g.series.chart,a="accessibility.series.pointAnnotationsDescription",u=getPointAnnotationTexts(g),v={point:g,annotations:u};return u.length?d.langFormat(a,v):""}function getPointValueDescription(g){var d=g.series,a=d.chart,u=a.options.accessibility.point.valueDescriptionFormat,v=pick$10(d.xAxis&&d.xAxis.options.accessibility&&d.xAxis.options.accessibility.enabled,!a.angular),x=v?getPointXDescription(g):"",S={point:g,index:defined$r(g.index)?g.index+1:"",xDescription:x,value:getPointValue(g),separator:v?", ":""};return format$6(u,S,a)}function defaultPointDescriptionFormatter$1(g){var d=g.series,a=d.chart,u=getPointValueDescription(g),v=g.options&&g.options.accessibility&&g.options.accessibility.description,x=v?" "+v:"",S=a.series.length>1&&d.name?" "+d.name+".":"",T=getPointAnnotationDescription(g),P=T?" "+T:"";return g.accessibility=g.accessibility||{},g.accessibility.valueDescription=u,u+x+S+P}function setPointScreenReaderAttribs(g,d){var a=g.series,u=a.chart.options.accessibility.point||{},v=a.options.accessibility||{},x=stripHTMLTags$1(v.pointDescriptionFormatter&&v.pointDescriptionFormatter(g)||u.descriptionFormatter&&u.descriptionFormatter(g)||defaultPointDescriptionFormatter$1(g));d.setAttribute("role","img"),d.setAttribute("aria-label",x)}function describePointsInSeries(g){var d=shouldSetScreenReaderPropsOnPoints(g),a=shouldSetKeyboardNavPropsOnPoints(g);(d||a)&&g.points.forEach(function(u){var v=u.graphic&&u.graphic.element||shouldAddDummyPoint(u)&&addDummyPointElement(u),x=u.options&&u.options.accessibility&&u.options.accessibility.enabled===!1;v&&(v.setAttribute("tabindex","-1"),v.style.outline="0",d&&!x?setPointScreenReaderAttribs(u,v):v.setAttribute("aria-hidden",!0))})}function defaultSeriesDescriptionFormatter$1(g){var d=g.chart,a=d.types||[],u=getSeriesDescriptionText(g),v=function(L){return d[L]&&d[L].length>1&&g[L]},x=getSeriesAxisDescriptionText(g,"xAxis"),S=getSeriesAxisDescriptionText(g,"yAxis"),T={name:g.name||"",ix:g.index+1,numSeries:d.series&&d.series.length,numPoints:g.points&&g.points.length,series:g},P=a.length>1?"Combination":"",z=d.langFormat("accessibility.series.summary."+g.type+P,T)||d.langFormat("accessibility.series.summary.default"+P,T);return z+(u?" "+u:"")+(v("yAxis")?" "+S:"")+(v("xAxis")?" "+x:"")}function describeSeriesElement(g,d){var a=g.options.accessibility||{},u=g.chart.options.accessibility,v=u.landmarkVerbosity;a.exposeAsGroupOnly?d.setAttribute("role","img"):v==="all"&&d.setAttribute("role","region"),d.setAttribute("tabindex","-1"),d.style.outline="0",d.setAttribute("aria-label",stripHTMLTags$1(u.series.descriptionFormatter&&u.series.descriptionFormatter(g)||defaultSeriesDescriptionFormatter$1(g)))}function describeSeries$1(g){var d=g.chart,a=getSeriesFirstPointElement(g),u=getSeriesA11yElement(g),v=d.is3d&&d.is3d();u&&(u.lastChild===a&&!v&&reverseChildNodes(u),describePointsInSeries(g),unhideChartElementFromAT$4(d,u),shouldDescribeSeriesElement(g)?describeSeriesElement(g,u):u.setAttribute("aria-label",""))}var SeriesDescriber={describeSeries:describeSeries$1,defaultPointDescriptionFormatter:defaultPointDescriptionFormatter$1,defaultSeriesDescriptionFormatter:defaultSeriesDescriptionFormatter$1,getPointA11yTimeDescription,getPointXDescription,getPointValue,getPointValueDescription},doc$9=H.doc,setElAttrs$3=HTMLUtilities.setElAttrs,visuallyHideElement$1=HTMLUtilities.visuallyHideElement,Announcer=(function(){function g(d,a){this.chart=d,this.domElementProvider=new DOMElementProvider,this.announceRegion=this.addAnnounceRegion(a)}return g.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},g.prototype.announce=function(d){var a=this;AST.setElementHTML(this.announceRegion,d),this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer),this.clearAnnouncementRegionTimer=setTimeout(function(){a.announceRegion.innerHTML="",delete a.clearAnnouncementRegionTimer},1e3)},g.prototype.addAnnounceRegion=function(d){var a=this.chart.announcerContainer||this.createAnnouncerContainer(),u=this.domElementProvider.createElement("div");return setElAttrs$3(u,{"aria-hidden":!1,"aria-live":d}),visuallyHideElement$1(u),a.appendChild(u),u},g.prototype.createAnnouncerContainer=function(){var d=this.chart,a=doc$9.createElement("div");return setElAttrs$3(a,{"aria-hidden":!1,style:"position:relative",class:"highcharts-announcer-container"}),d.renderTo.insertBefore(a,d.renderTo.firstChild),d.announcerContainer=a,a},g})(),extend$_=Utilities.extend,defined$q=Utilities.defined,getChartTitle$2=ChartUtilities.getChartTitle,defaultPointDescriptionFormatter=SeriesDescriber.defaultPointDescriptionFormatter,defaultSeriesDescriptionFormatter=SeriesDescriber.defaultSeriesDescriptionFormatter;function chartHasAnnounceEnabled(g){return!!g.options.accessibility.announceNewData.enabled}function findPointInDataArray(g){var d=g.series.data.filter(function(a){return g.x===a.x&&g.y===a.y});return d.length===1?d[0]:g}function getUniqueSeries(g,d){var a=(g||[]).concat(d||[]).reduce(function(u,v){return u[v.name+v.index]=v,u},{});return Object.keys(a).map(function(u){return a[u]})}var NewDataAnnouncer=function(g){this.chart=g};extend$_(NewDataAnnouncer.prototype,{init:function(){var g=this.chart,d=g.options.accessibility.announceNewData,a=d.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0,this.dirty={allSeries:{}},this.eventProvider=new EventProvider,this.announcer=new Announcer(g,a),this.addEventListeners()},destroy:function(){this.eventProvider.removeAddedEvents(),this.announcer.destroy()},addEventListeners:function(){var g=this,d=this.chart,a=this.eventProvider;a.addEvent(d,"afterDrilldown",function(){g.lastAnnouncementTime=0}),a.addEvent(Series$f,"updatedData",function(){g.onSeriesUpdatedData(this)}),a.addEvent(d,"afterAddSeries",function(u){g.onSeriesAdded(u.series)}),a.addEvent(Series$f,"addPoint",function(u){g.onPointAdded(u.point)}),a.addEvent(d,"redraw",function(){g.announceDirtyData()})},onSeriesUpdatedData:function(g){var d=this.chart;g.chart===d&&chartHasAnnounceEnabled(d)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[g.name+g.index]=g)},onSeriesAdded:function(g){chartHasAnnounceEnabled(this.chart)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[g.name+g.index]=g,this.dirty.newSeries=defined$q(this.dirty.newSeries)?void 0:g)},onPointAdded:function(g){var d=g.series.chart;this.chart===d&&chartHasAnnounceEnabled(d)&&(this.dirty.newPoint=defined$q(this.dirty.newPoint)?void 0:g)},announceDirtyData:function(){var g=this.chart,d=this;if(g.options.accessibility.announceNewData&&this.dirty.hasDirty){var a=this.dirty.newPoint;a&&(a=findPointInDataArray(a)),this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(u){return d.dirty.allSeries[u]}),this.dirty.newSeries,a),this.dirty={allSeries:{}}}},queueAnnouncement:function(g,d,a){var u=this,v=this.chart,x=v.options.accessibility.announceNewData;if(x.enabled){var S=+new Date,T=S-this.lastAnnouncementTime,P=Math.max(0,x.minAnnounceInterval-T),z=getUniqueSeries(this.queuedAnnouncement&&this.queuedAnnouncement.series,g),L=this.buildAnnouncementMessage(z,d,a);L&&(this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:S,message:L,series:z},this.queuedAnnouncementTimer=setTimeout(function(){u&&u.announcer&&(u.lastAnnouncementTime=+new Date,u.announcer.announce(u.queuedAnnouncement.message),delete u.queuedAnnouncement,delete u.queuedAnnouncementTimer)},P))}},buildAnnouncementMessage:function(g,d,a){var u=this.chart,v=u.options.accessibility.announceNewData;if(v.announcementFormatter){var x=v.announcementFormatter(g,d,a);if(x!==!1)return x.length?x:null}var S=H.charts&&H.charts.length>1?"Multiple":"Single",T=d?"newSeriesAnnounce"+S:a?"newPointAnnounce"+S:"newDataAnnounce",P=getChartTitle$2(u);return u.langFormat("accessibility.announceNewData."+T,{chartTitle:P,seriesDesc:d?defaultSeriesDescriptionFormatter(d):null,pointDesc:a?defaultPointDescriptionFormatter(a):null,point:a,series:d})}});var addEvent$G=Utilities.addEvent,merge$U=Utilities.merge;function isWithinDescriptionThreshold(g){var d=g.chart.options.accessibility;return g.points.length<d.series.pointDescriptionEnabledThreshold||d.series.pointDescriptionEnabledThreshold===!1}function shouldForceMarkers(g){var d=g.chart,a=d.options.accessibility.enabled,u=(g.options.accessibility&&g.options.accessibility.enabled)!==!1;return a&&u&&isWithinDescriptionThreshold(g)}function hasIndividualPointMarkerOptions(g){return!!(g._hasPointMarkers&&g.points&&g.points.length)}function unforceSeriesMarkerOptions(g){var d=g.resetA11yMarkerOptions;d&&merge$U(!0,g.options,{marker:{enabled:d.enabled,states:{normal:{opacity:d.states&&d.states.normal&&d.states.normal.opacity}}}})}function forceZeroOpacityMarkerOptions(g){merge$U(!0,g,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function getPointMarkerOpacity(g){return g.marker.states&&g.marker.states.normal&&g.marker.states.normal.opacity||1}function unforcePointMarkerOptions(g){merge$U(!0,g.marker,{states:{normal:{opacity:getPointMarkerOpacity(g)}}})}function handleForcePointMarkers(g){for(var d=g.points.length;d--;){var a=g.points[d],u=a.options;delete a.hasForcedA11yMarker,u.marker&&(u.marker.enabled?(unforcePointMarkerOptions(u),a.hasForcedA11yMarker=!1):(forceZeroOpacityMarkerOptions(u),a.hasForcedA11yMarker=!0))}}function addForceMarkersEvents(){addEvent$G(Series$f,"render",function(){var g=this,d=g.options;shouldForceMarkers(g)?(d.marker&&d.marker.enabled===!1&&(g.a11yMarkersForced=!0,forceZeroOpacityMarkerOptions(g.options)),hasIndividualPointMarkerOptions(g)&&handleForcePointMarkers(g)):g.a11yMarkersForced&&(delete g.a11yMarkersForced,unforceSeriesMarkerOptions(g))}),addEvent$G(Series$f,"afterSetOptions",function(g){this.resetA11yMarkerOptions=merge$U(g.options.marker||{},this.userOptions.marker||{})}),addEvent$G(Series$f,"afterRender",function(){var g=this;g.chart.styledMode&&(g.markerGroup&&g.markerGroup[g.a11yMarkersForced?"addClass":"removeClass"]("highcharts-a11y-markers-hidden"),hasIndividualPointMarkerOptions(g)&&g.points.forEach(function(d){d.graphic&&(d.graphic[d.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),d.graphic[d.hasForcedA11yMarker===!1?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))}))})}var extend$Z=Utilities.extend,hideSeriesFromAT=ChartUtilities.hideSeriesFromAT,describeSeries=SeriesDescriber.describeSeries;H.SeriesAccessibilityDescriber=SeriesDescriber;addForceMarkersEvents();var SeriesComponent=function(){};SeriesComponent.prototype=new AccessibilityComponent;extend$Z(SeriesComponent.prototype,{init:function(){this.newDataAnnouncer=new NewDataAnnouncer(this.chart),this.newDataAnnouncer.init(),this.keyboardNavigation=new SeriesKeyboardNavigation(this.chart,this.keyCodes),this.keyboardNavigation.init(),this.hideTooltipFromATWhenShown(),this.hideSeriesLabelsFromATWhenShown()},hideTooltipFromATWhenShown:function(){var g=this;this.addEvent(Tooltip,"refresh",function(){this.chart===g.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})},hideSeriesLabelsFromATWhenShown:function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(g){g.labelBySeries&&g.labelBySeries.attr("aria-hidden",!0)})})},onChartRender:function(){var g=this.chart;g.series.forEach(function(d){var a=(d.options.accessibility&&d.options.accessibility.enabled)!==!1&&d.visible;a?describeSeries(d):hideSeriesFromAT(d)})},getKeyboardNavigation:function(){return this.keyboardNavigation.getKeyboardNavigationHandler()},destroy:function(){this.newDataAnnouncer.destroy(),this.keyboardNavigation.destroy()}});var unhideChartElementFromAT$3=ChartUtilities.unhideChartElementFromAT,noop$c=H.noop,removeElement=HTMLUtilities.removeElement,setElAttrs$2=HTMLUtilities.setElAttrs,extend$Y=Utilities.extend,pick$$=Utilities.pick;function chartHasMapZoom(g){return!!(g.mapZoom&&g.mapNavButtons&&g.mapNavButtons.length)}H.Axis.prototype.panStep=function(g,d){var a=d||3,u=this.getExtremes(),v=(u.max-u.min)/a*g,x=u.max+v,S=u.min+v,T=x-S;g<0&&S<u.dataMin?(S=u.dataMin,x=S+T):g>0&&x>u.dataMax&&(x=u.dataMax,S=x-T),this.setExtremes(S,x)};var ZoomComponent=noop$c;ZoomComponent.prototype=new AccessibilityComponent;extend$Y(ZoomComponent.prototype,{init:function(){var g=this,d=this.chart;["afterShowResetZoom","afterDrilldown","drillupall"].forEach(function(a){g.addEvent(d,a,function(){g.updateProxyOverlays()})})},onChartUpdate:function(){var g=this.chart,d=this;g.mapNavButtons&&g.mapNavButtons.forEach(function(a,u){unhideChartElementFromAT$3(g,a.element),d.setMapNavButtonAttrs(a.element,"accessibility.zoom.mapZoom"+(u?"Out":"In"))})},setMapNavButtonAttrs:function(g,d){var a=this.chart,u=a.langFormat(d,{chart:a});setElAttrs$2(g,{tabindex:-1,role:"button","aria-label":u})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var g=this.chart;removeElement(this.drillUpProxyGroup),removeElement(this.resetZoomProxyGroup),g.resetZoomButton&&this.recreateProxyButtonAndGroup(g.resetZoomButton,"resetZoomProxyButton","resetZoomProxyGroup",g.langFormat("accessibility.zoom.resetZoomButton",{chart:g})),g.drillUpButton&&this.recreateProxyButtonAndGroup(g.drillUpButton,"drillUpProxyButton","drillUpProxyGroup",g.langFormat("accessibility.drillUpButton",{chart:g,buttonText:g.getDrilldownBackText()}))},recreateProxyButtonAndGroup:function(g,d,a,u){removeElement(this[a]),this[a]=this.addProxyGroup(),this[d]=this.createProxyButton(g,this[a],{"aria-label":u,tabindex:-1})},getMapZoomNavigation:function(){var g=this.keyCodes,d=this.chart,a=this;return new KeyboardNavigationHandler(d,{keyCodeMap:[[[g.up,g.down,g.left,g.right],function(u){return a.onMapKbdArrow(this,u)}],[[g.tab],function(u,v){return a.onMapKbdTab(this,v)}],[[g.space,g.enter],function(){return a.onMapKbdClick(this)}]],validate:function(){return chartHasMapZoom(d)},init:function(u){return a.onMapNavInit(u)}})},onMapKbdArrow:function(g,d){var a=this.keyCodes,u=d===a.up||d===a.down?"yAxis":"xAxis",v=d===a.left||d===a.up?-1:1;return this.chart[u][0].panStep(v),g.response.success},onMapKbdTab:function(g,d){var a,u=this.chart,v=g.response,x=d.shiftKey,S=x&&!this.focusedMapNavButtonIx||!x&&this.focusedMapNavButtonIx;return u.mapNavButtons[this.focusedMapNavButtonIx].setState(0),S?(u.mapZoom(),v[x?"prev":"next"]):(this.focusedMapNavButtonIx+=x?-1:1,a=u.mapNavButtons[this.focusedMapNavButtonIx],u.setFocusToElement(a.box,a.element),a.setState(2),v.success)},onMapKbdClick:function(g){return this.fakeClickEvent(this.chart.mapNavButtons[this.focusedMapNavButtonIx].element),g.response.success},onMapNavInit:function(g){var d=this.chart,a=d.mapNavButtons[0],u=d.mapNavButtons[1],v=g>0?a:u;d.setFocusToElement(v.box,v.element),v.setState(2),this.focusedMapNavButtonIx=g>0?0:1},simpleButtonNavigation:function(g,d,a){var u=this.keyCodes,v=this,x=this.chart;return new KeyboardNavigationHandler(x,{keyCodeMap:[[[u.tab,u.up,u.down,u.left,u.right],function(S,T){var P=S===u.tab&&T.shiftKey||S===u.left||S===u.up;return this.response[P?"prev":"next"]}],[[u.space,u.enter],function(){var S=a(this,x);return pick$$(S,this.response.success)}]],validate:function(){var S=x[g]&&x[g].box&&v[d];return S},init:function(){x.setFocusToElement(x[g].box,v[d])}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(g,d){d.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(g,d){return d.drillUp(),g.response.prev}),this.getMapZoomNavigation()]}});var unhideChartElementFromAT$2=ChartUtilities.unhideChartElementFromAT,getAxisRangeDescription$1=ChartUtilities.getAxisRangeDescription,setElAttrs$1=HTMLUtilities.setElAttrs,addEvent$F=Utilities.addEvent,extend$X=Utilities.extend;function shouldRunInputNavigation(g){return!!(g.rangeSelector&&g.rangeSelector.inputGroup&&g.rangeSelector.inputGroup.element.getAttribute("visibility")!=="hidden"&&g.options.rangeSelector.inputEnabled!==!1&&g.rangeSelector.minInput&&g.rangeSelector.maxInput)}Chart$1.prototype.highlightRangeSelectorButton=function(g){var d=this.rangeSelector&&this.rangeSelector.buttons||[],a=this.highlightedRangeSelectorItemIx,u=this.rangeSelector&&this.rangeSelector.selected;return typeof a<"u"&&d[a]&&a!==u&&d[a].setState(this.oldRangeSelectorItemState||0),this.highlightedRangeSelectorItemIx=g,d[g]?(this.setFocusToElement(d[g].box,d[g].element),g!==u&&(this.oldRangeSelectorItemState=d[g].state,d[g].setState(1)),!0):!1};addEvent$F(RangeSelector,"afterBtnClick",function(){if(this.chart.accessibility&&this.chart.accessibility.components.rangeSelector)return this.chart.accessibility.components.rangeSelector.onAfterBtnClick()});var RangeSelectorComponent=function(){};RangeSelectorComponent.prototype=new AccessibilityComponent;extend$X(RangeSelectorComponent.prototype,{init:function(){var g=this.chart;this.announcer=new Announcer(g,"polite")},onChartUpdate:function(){var g=this.chart,d=this,a=g.rangeSelector;a&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),a.buttons&&a.buttons.length&&a.buttons.forEach(function(u){d.setRangeButtonAttrs(u)}),a.maxInput&&a.minInput&&["minInput","maxInput"].forEach(function(u,v){var x=a[u];x&&(unhideChartElementFromAT$2(g,x),d.setRangeInputAttrs(x,"accessibility.rangeSelector."+(v?"max":"min")+"InputLabel"))}))},updateSelectorVisibility:function(){var g=this.chart,d=g.rangeSelector,a=d&&d.dropdown,u=d&&d.buttons||[],v=function(x){return x.setAttribute("aria-hidden",!0)};d&&d.hasVisibleDropdown&&a?(unhideChartElementFromAT$2(g,a),u.forEach(function(x){return v(x.element)})):(a&&v(a),u.forEach(function(x){return unhideChartElementFromAT$2(g,x.element)}))},setDropdownAttrs:function(){var g=this.chart,d=g.rangeSelector&&g.rangeSelector.dropdown;if(d){var a=g.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:g.options.lang.rangeSelectorZoom});d.setAttribute("aria-label",a),d.setAttribute("tabindex",-1)}},setRangeButtonAttrs:function(g){setElAttrs$1(g.element,{tabindex:-1,role:"button"})},setRangeInputAttrs:function(g,d){var a=this.chart;setElAttrs$1(g,{tabindex:-1,"aria-label":a.langFormat(d,{chart:a})})},onButtonNavKbdArrowKey:function(g,d){var a=g.response,u=this.keyCodes,v=this.chart,x=v.options.accessibility.keyboardNavigation.wrapAround,S=d===u.left||d===u.up?-1:1,T=v.highlightRangeSelectorButton(v.highlightedRangeSelectorItemIx+S);return T?a.success:x?(g.init(S),a.success):a[S>0?"next":"prev"]},onButtonNavKbdClick:function(g){var d=g.response,a=this.chart,u=a.oldRangeSelectorItemState===3;return u||this.fakeClickEvent(a.rangeSelector.buttons[a.highlightedRangeSelectorItemIx].element),d.success},onAfterBtnClick:function(){var g=this.chart,d=getAxisRangeDescription$1(g.xAxis[0]),a=g.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:g,axisRangeDescription:d});a&&this.announcer.announce(a)},onInputKbdMove:function(g){var d=this.chart,a=d.rangeSelector,u=d.highlightedInputRangeIx=(d.highlightedInputRangeIx||0)+g,v=u>1||u<0;if(v)d.accessibility&&(d.accessibility.keyboardNavigation.tabindexContainer.focus(),d.accessibility.keyboardNavigation[g<0?"prev":"next"]());else if(a){var x=a[u?"maxDateBox":"minDateBox"],S=a[u?"maxInput":"minInput"];x&&S&&d.setFocusToElement(x,S)}},onInputNavInit:function(g){var d=this,a=this,u=this.chart,v=g>0?0:1,x=u.rangeSelector,S=x&&x[v?"maxDateBox":"minDateBox"],T=x&&x.minInput,P=x&&x.maxInput,z=v?P:T;if(u.highlightedInputRangeIx=v,S&&T&&P){u.setFocusToElement(S,z),this.removeInputKeydownHandler&&this.removeInputKeydownHandler();var L=function(B){var U=(B.which||B.keyCode)===d.keyCodes.tab;U&&(B.preventDefault(),B.stopPropagation(),a.onInputKbdMove(B.shiftKey?-1:1))},N=addEvent$F(T,"keydown",L),$=addEvent$F(P,"keydown",L);this.removeInputKeydownHandler=function(){N(),$()}}},onInputNavTerminate:function(){var g=this.chart.rangeSelector||{};g.maxInput&&g.hideInput("max"),g.minInput&&g.hideInput("min"),this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)},initDropdownNav:function(){var g=this,d=this.chart,a=d.rangeSelector,u=a&&a.dropdown;a&&u&&(d.setFocusToElement(a.buttonGroup,u),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=addEvent$F(u,"keydown",function(v){var x=(v.which||v.keyCode)===g.keyCodes.tab;x&&(v.preventDefault(),v.stopPropagation(),d.accessibility&&(d.accessibility.keyboardNavigation.tabindexContainer.focus(),d.accessibility.keyboardNavigation[v.shiftKey?"prev":"next"]()))}))},getRangeSelectorButtonNavigation:function(){var g=this.chart,d=this.keyCodes,a=this;return new KeyboardNavigationHandler(g,{keyCodeMap:[[[d.left,d.right,d.up,d.down],function(u){return a.onButtonNavKbdArrowKey(this,u)}],[[d.enter,d.space],function(){return a.onButtonNavKbdClick(this)}]],validate:function(){return!!(g.rangeSelector&&g.rangeSelector.buttons&&g.rangeSelector.buttons.length)},init:function(u){var v=g.rangeSelector;if(v&&v.hasVisibleDropdown)a.initDropdownNav();else if(v){var x=v.buttons.length-1;g.highlightRangeSelectorButton(u>0?0:x)}},terminate:function(){a.removeDropdownKeydownHandler&&(a.removeDropdownKeydownHandler(),delete a.removeDropdownKeydownHandler)}})},getRangeSelectorInputNavigation:function(){var g=this.chart,d=this;return new KeyboardNavigationHandler(g,{keyCodeMap:[],validate:function(){return shouldRunInputNavigation(g)},init:function(a){d.onInputNavInit(a)},terminate:function(){d.onInputNavTerminate()}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]},destroy:function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeInputKeydownHandler&&this.removeInputKeydownHandler(),this.announcer&&this.announcer.destroy()}});var format$5=FormatUtilities.format,doc$8=H.doc,extend$W=Utilities.extend,pick$_=Utilities.pick,getAnnotationsInfoHTML=AnnotationsA11y.getAnnotationsInfoHTML,getAxisDescription=ChartUtilities.getAxisDescription,getAxisRangeDescription=ChartUtilities.getAxisRangeDescription,getChartTitle$1=ChartUtilities.getChartTitle,unhideChartElementFromAT$1=ChartUtilities.unhideChartElementFromAT,addClass=HTMLUtilities.addClass,getElement=HTMLUtilities.getElement,getHeadingTagNameForElement=HTMLUtilities.getHeadingTagNameForElement,setElAttrs=HTMLUtilities.setElAttrs,stripHTMLTagsFromString=HTMLUtilities.stripHTMLTagsFromString,visuallyHideElement=HTMLUtilities.visuallyHideElement;function stripEmptyHTMLTags(g){return g.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")}function getTypeDescForMapChart(g,d){return d.mapTitle?g.langFormat("accessibility.chartTypes.mapTypeDescription",d):g.langFormat("accessibility.chartTypes.unknownMap",d)}function getTypeDescForCombinationChart(g,d){return g.langFormat("accessibility.chartTypes.combinationChart",d)}function getTypeDescForEmptyChart(g,d){return g.langFormat("accessibility.chartTypes.emptyChart",d)}function buildTypeDescriptionFromSeries(g,d,a){var u=d[0],v=g.langFormat("accessibility.seriesTypeDescriptions."+u,a),x=g.series&&g.series.length<2?"Single":"Multiple";return(g.langFormat("accessibility.chartTypes."+u+x,a)||g.langFormat("accessibility.chartTypes.default"+x,a))+(v?" "+v:"")}function getTableSummary(g){return g.langFormat("accessibility.table.tableSummary",{chart:g})}Chart$1.prototype.getTypeDescription=function(g){var d=g[0],a=this.series&&this.series[0]||{},u={numSeries:this.series.length,numPoints:a.points&&a.points.length,chart:this,mapTitle:a.mapTitle};return d?d==="map"?getTypeDescForMapChart(this,u):this.types.length>1?getTypeDescForCombinationChart(this,u):buildTypeDescriptionFromSeries(this,g,u):getTypeDescForEmptyChart(this,u)};var InfoRegionsComponent=function(){};InfoRegionsComponent.prototype=new AccessibilityComponent;extend$W(InfoRegionsComponent.prototype,{init:function(){var g=this.chart,d=this;this.initRegionsDefinitions(),this.addEvent(g,"aftergetTableAST",function(a){d.onDataTableCreated(a)}),this.addEvent(g,"afterViewData",function(a){d.dataTableDiv=a,setTimeout(function(){d.focusDataTable()},300)}),this.announcer=new Announcer(g,"assertive")},initRegionsDefinitions:function(){var g=this;this.screenReaderSections={before:{element:null,buildContent:function(d){var a=d.options.accessibility.screenReaderSection.beforeChartFormatter;return a?a(d):g.defaultBeforeChartFormatter(d)},insertIntoDOM:function(d,a){a.renderTo.insertBefore(d,a.renderTo.firstChild)},afterInserted:function(){typeof g.sonifyButtonId<"u"&&g.initSonifyButton(g.sonifyButtonId),typeof g.dataTableButtonId<"u"&&g.initDataTableButton(g.dataTableButtonId)}},after:{element:null,buildContent:function(d){var a=d.options.accessibility.screenReaderSection.afterChartFormatter;return a?a(d):g.defaultAfterChartFormatter()},insertIntoDOM:function(d,a){a.renderTo.insertBefore(d,a.container.nextSibling)},afterInserted:function(){g.chart.accessibility&&g.chart.accessibility.keyboardNavigation.updateExitAnchor()}}}},onChartRender:function(){var g=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement(),this.setLinkedDescriptionAttrs(),Object.keys(this.screenReaderSections).forEach(function(d){g.updateScreenReaderSection(d)})},getLinkedDescriptionElement:function(){var g=this.chart.options,d=g.accessibility.linkedDescription;if(d){if(typeof d!="string")return d;var a=format$5(d,this.chart),u=doc$8.querySelectorAll(a);if(u.length===1)return u[0]}},setLinkedDescriptionAttrs:function(){var g=this.linkedDescriptionElement;g&&(g.setAttribute("aria-hidden","true"),addClass(g,"highcharts-linked-description"))},updateScreenReaderSection:function(g){var d=this.chart,a=this.screenReaderSections[g],u=a.buildContent(d),v=a.element=a.element||this.createElement("div"),x=v.firstChild||this.createElement("div");this.setScreenReaderSectionAttribs(v,g),AST.setElementHTML(x,u),v.appendChild(x),a.insertIntoDOM(v,d),visuallyHideElement(x),unhideChartElementFromAT$1(d,x),a.afterInserted&&a.afterInserted()},setScreenReaderSectionAttribs:function(g,d){var a="accessibility.screenReaderSection."+d+"RegionLabel",u=this.chart,v=u.langFormat(a,{chart:u,chartTitle:getChartTitle$1(u)}),x="highcharts-screen-reader-region-"+d+"-"+u.index;setElAttrs(g,{id:x,"aria-label":v}),g.style.position="relative",u.options.accessibility.landmarkVerbosity==="all"&&v&&g.setAttribute("role","region")},defaultBeforeChartFormatter:function(){var g=this.chart,d=g.options.accessibility.screenReaderSection.beforeChartFormat,a=this.getAxesDescription(),u=g.sonify&&g.options.sonification&&g.options.sonification.enabled,v="highcharts-a11y-sonify-data-btn-"+g.index,x="hc-linkto-highcharts-data-table-"+g.index,S=getAnnotationsInfoHTML(g),T=g.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:g}),P={headingTagName:getHeadingTagNameForElement(g.renderTo),chartTitle:getChartTitle$1(g),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:a.xAxis,yAxisDescription:a.yAxis,playAsSoundButton:u?this.getSonifyButtonText(v):"",viewTableButton:g.getCSV?this.getDataTableButtonText(x):"",annotationsTitle:S?T:"",annotationsList:S},z=H.i18nFormat(d,P,g);return this.dataTableButtonId=x,this.sonifyButtonId=v,stripEmptyHTMLTags(z)},defaultAfterChartFormatter:function(){var g=this.chart,d=g.options.accessibility.screenReaderSection.afterChartFormat,a={endOfChartMarker:this.getEndOfChartMarkerText()},u=H.i18nFormat(d,a,g);return stripEmptyHTMLTags(u)},getLinkedDescription:function(){var g=this.linkedDescriptionElement,d=g&&g.innerHTML||"";return stripHTMLTagsFromString(d)},getLongdescText:function(){var g=this.chart.options,d=g.caption,a=d&&d.text,u=this.getLinkedDescription();return g.accessibility.description||u||a||""},getTypeDescriptionText:function(){var g=this.chart;return g.types?g.options.accessibility.typeDescription||g.getTypeDescription(g.types):""},getDataTableButtonText:function(g){var d=this.chart,a=d.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:d,chartTitle:getChartTitle$1(d)});return'<button id="'+g+'">'+a+"</button>"},getSonifyButtonText:function(g){var d=this.chart;if(d.options.sonification&&d.options.sonification.enabled===!1)return"";var a=d.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:d,chartTitle:getChartTitle$1(d)});return'<button id="'+g+'">'+a+"</button>"},getSubtitleText:function(){var g=this.chart.options.subtitle;return stripHTMLTagsFromString(g&&g.text||"")},getEndOfChartMarkerText:function(){var g=this.chart,d=g.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:g}),a="highcharts-end-of-chart-marker-"+g.index;return'<div id="'+a+'">'+d+"</div>"},onDataTableCreated:function(g){var d=this.chart;if(d.options.accessibility.enabled){this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true");var a=g.tree.attributes||{};a.tabindex=-1,a.summary=getTableSummary(d),g.tree.attributes=a}},focusDataTable:function(){var g=this.dataTableDiv,d=g&&g.getElementsByTagName("table")[0];d&&d.focus&&d.focus()},initSonifyButton:function(g){var d=this,a=this.sonifyButton=getElement(g),u=this.chart,v=function(x){a&&(a.setAttribute("aria-hidden","true"),a.setAttribute("aria-label","")),x.preventDefault(),x.stopPropagation();var S=u.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:u});d.announcer.announce(S),setTimeout(function(){a&&(a.removeAttribute("aria-hidden"),a.removeAttribute("aria-label")),u.sonify&&u.sonify()},1e3)};a&&u&&(setElAttrs(a,{tabindex:-1}),a.onclick=function(x){var S=u.options.accessibility&&u.options.accessibility.screenReaderSection.onPlayAsSoundClick;(S||v).call(this,x,u)})},initDataTableButton:function(g){var d=this.viewDataTableButton=getElement(g),a=this.chart,u=g.replace("hc-linkto-","");d&&(setElAttrs(d,{tabindex:-1,"aria-expanded":!!getElement(u)}),d.onclick=a.options.accessibility.screenReaderSection.onViewDataTableClick||function(){a.viewData()})},getAxesDescription:function(){var g=this.chart,d=function(T,P){var z=g[T];return z.length>1||z[0]&&pick$_(z[0].options.accessibility&&z[0].options.accessibility.enabled,P)},a=!!g.types&&g.types.indexOf("map")<0,u=!!g.hasCartesianSeries,v=d("xAxis",!g.angular&&u&&a),x=d("yAxis",u&&a),S={};return v&&(S.xAxis=this.getAxisDescriptionText("xAxis")),x&&(S.yAxis=this.getAxisDescriptionText("yAxis")),S},getAxisDescriptionText:function(g){var d=this.chart,a=d[g];return d.langFormat("accessibility.axis."+g+"Description"+(a.length>1?"Plural":"Singular"),{chart:d,names:a.map(function(u){return getAxisDescription(u)}),ranges:a.map(function(u){return getAxisRangeDescription(u)}),numAxes:a.length})},destroy:function(){this.announcer&&this.announcer.destroy()}});var unhideChartElementFromAT=ChartUtilities.unhideChartElementFromAT,getChartTitle=ChartUtilities.getChartTitle,doc$7=H.doc,stripHTMLTags=HTMLUtilities.stripHTMLTagsFromString,extend$V=Utilities.extend,ContainerComponent=function(){};ContainerComponent.prototype=new AccessibilityComponent;extend$V(ContainerComponent.prototype,{onChartUpdate:function(){this.handleSVGTitleElement(),this.setSVGContainerLabel(),this.setGraphicContainerAttrs(),this.setRenderToAttrs(),this.makeCreditsAccessible()},handleSVGTitleElement:function(){var g=this.chart,d="highcharts-title-"+g.index,a=stripHTMLTags(g.langFormat("accessibility.svgContainerTitle",{chartTitle:getChartTitle(g)}));if(a.length){var u=this.svgTitleElement=this.svgTitleElement||doc$7.createElementNS("http://www.w3.org/2000/svg","title");u.textContent=a,u.id=d,g.renderTo.insertBefore(u,g.renderTo.firstChild)}},setSVGContainerLabel:function(){var g=this.chart,d=g.langFormat("accessibility.svgContainerLabel",{chartTitle:getChartTitle(g)});g.renderer.box&&d.length&&g.renderer.box.setAttribute("aria-label",d)},setGraphicContainerAttrs:function(){var g=this.chart,d=g.langFormat("accessibility.graphicContainerLabel",{chartTitle:getChartTitle(g)});d.length&&g.container.setAttribute("aria-label",d)},setRenderToAttrs:function(){var g=this.chart;g.options.accessibility.landmarkVerbosity!=="disabled"?g.renderTo.setAttribute("role","region"):g.renderTo.removeAttribute("role"),g.renderTo.setAttribute("aria-label",g.langFormat("accessibility.chartContainerLabel",{title:getChartTitle(g),chart:g}))},makeCreditsAccessible:function(){var g=this.chart,d=g.credits;d&&(d.textStr&&d.element.setAttribute("aria-label",g.langFormat("accessibility.credits",{creditsStr:stripHTMLTags(d.textStr)})),unhideChartElementFromAT(g,d.element))},getKeyboardNavigation:function(){var g=this.chart;return new KeyboardNavigationHandler(g,{keyCodeMap:[],validate:function(){return!0},init:function(){var d=g.accessibility;d&&d.keyboardNavigation.tabindexContainer.focus()}})},destroy:function(){this.chart.renderTo.setAttribute("aria-hidden",!0)}});var doc$6=H.doc,isMS=H.isMS,win$3=H.win,whcm={isHighContrastModeActive:function(){var g=/(Edg)/.test(win$3.navigator.userAgent);if(win$3.matchMedia&&g)return win$3.matchMedia("(-ms-high-contrast: active)").matches;if(isMS&&win$3.getComputedStyle){var d=doc$6.createElement("div"),a="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";d.style.backgroundImage="url("+a+")",doc$6.body.appendChild(d);var u=(d.currentStyle||win$3.getComputedStyle(d)).backgroundImage;return doc$6.body.removeChild(d),u==="none"}return!1},setHighContrastTheme:function(g){g.highContrastModeActive=!0;var d=g.options.accessibility.highContrastTheme;g.update(d,!1),g.series.forEach(function(a){var u=d.plotOptions[a.type]||{};a.update({color:u.color||"windowText",colors:[u.color||"windowText"],borderColor:u.borderColor||"window"}),a.points.forEach(function(v){v.options&&v.options.color&&v.update({color:u.color||"windowText",borderColor:u.borderColor||"window"},!1)})}),g.redraw()}},theme={chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},labels:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}},Options={accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},series:{describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{index}. {xDescription}{separator}{value}."},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:palette.highlightColor80,lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5e3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}},langOptions={accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",drillUpButton:"{buttonText}",credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"Chart screen reader information, {chartTitle}.",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{ Also related to, #each(additionalAnnotationPoints)}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility, {chartTitle}",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu",exportRegionLabel:"Chart menu, {chartTitle}"},series:{summary:{default:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name}, series {ix} of {numSeries}, scatter plot with {numPoints} {#plural(numPoints, points, point)}.",boxplot:"{name}, boxplot {ix} of {numSeries} with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotCombination:"{name}, series {ix} of {numSeries}. Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",bubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}.",map:"{name}, map {ix} of {numSeries} with {numPoints} {#plural(numPoints, areas, area)}.",mapCombination:"{name}, series {ix} of {numSeries}. Map with {numPoints} {#plural(numPoints, areas, area)}.",mapline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",maplineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",mapbubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",mapbubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}."},description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}",nullPointValue:"No value",pointAnnotationsDescription:"{Annotation: #each(annotations). }"}}},error$3=Utilities.error,pick$Z=Utilities.pick;function traverseSetOption(g,d,a){for(var u=g,v,x=0;x<d.length-1;++x)v=d[x],u=u[v]=pick$Z(u[v],{});u[d[d.length-1]]=a}function deprecateFromOptionsMap(g,d,a,u){function v(T,P){return P.reduce(function(z,L){return z[L]},T)}var x=v(g.options,d),S=v(g.options,a);Object.keys(u).forEach(function(T){var P,z=x[T];typeof z<"u"&&(traverseSetOption(S,u[T],z),error$3(32,!1,g,(P={},P[d.join(".")+"."+T]=a.join(".")+"."+u[T].join("."),P)))})}function copyDeprecatedChartOptions(g){var d=g.options.chart,a=g.options.accessibility||{};["description","typeDescription"].forEach(function(u){var v;d[u]&&(a[u]=d[u],error$3(32,!1,g,(v={},v["chart."+u]="use accessibility."+u,v)))})}function copyDeprecatedAxisOptions(g){g.axes.forEach(function(d){var a=d.options;a&&a.description&&(a.accessibility=a.accessibility||{},a.accessibility.description=a.description,error$3(32,!1,g,{"axis.description":"use axis.accessibility.description"}))})}function copyDeprecatedSeriesOptions(g){var d={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","pointDescriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"]};g.series.forEach(function(a){Object.keys(d).forEach(function(u){var v,x=a.options[u];typeof x<"u"&&(traverseSetOption(a.options,d[u],u==="skipKeyboardNavigation"?!x:x),error$3(32,!1,g,(v={},v["series."+u]="series."+d[u].join("."),v)))})})}function copyDeprecatedTopLevelAccessibilityOptions(g){deprecateFromOptionsMap(g,["accessibility"],["accessibility"],{pointDateFormat:["point","dateFormat"],pointDateFormatter:["point","dateFormatter"],pointDescriptionFormatter:["point","descriptionFormatter"],pointDescriptionThreshold:["series","pointDescriptionEnabledThreshold"],pointNavigationThreshold:["keyboardNavigation","seriesNavigation","pointNavigationEnabledThreshold"],pointValueDecimals:["point","valueDecimals"],pointValuePrefix:["point","valuePrefix"],pointValueSuffix:["point","valueSuffix"],screenReaderSectionFormatter:["screenReaderSection","beforeChartFormatter"],describeSingleSeries:["series","describeSingleSeries"],seriesDescriptionFormatter:["series","descriptionFormatter"],onTableAnchorClick:["screenReaderSection","onViewDataTableClick"],axisRangeDateFormat:["screenReaderSection","axisRangeDateFormat"]})}function copyDeprecatedKeyboardNavigationOptions(g){deprecateFromOptionsMap(g,["accessibility","keyboardNavigation"],["accessibility","keyboardNavigation","seriesNavigation"],{skipNullPoints:["skipNullPoints"],mode:["mode"]})}function copyDeprecatedLangOptions(g){deprecateFromOptionsMap(g,["lang","accessibility"],["lang","accessibility"],{legendItem:["legend","legendItem"],legendLabel:["legend","legendLabel"],mapZoomIn:["zoom","mapZoomIn"],mapZoomOut:["zoom","mapZoomOut"],resetZoomButton:["zoom","resetZoomButton"],screenReaderRegionLabel:["screenReaderSection","beforeRegionLabel"],rangeSelectorButton:["rangeSelector","buttonText"],rangeSelectorMaxInput:["rangeSelector","maxInputLabel"],rangeSelectorMinInput:["rangeSelector","minInputLabel"],svgContainerEnd:["screenReaderSection","endOfChartMarker"],viewAsDataTable:["table","viewAsDataTableButtonText"],tableSummary:["table","tableSummary"]})}function copyDeprecatedOptions(g){copyDeprecatedChartOptions(g),copyDeprecatedAxisOptions(g),g.series&&copyDeprecatedSeriesOptions(g),copyDeprecatedTopLevelAccessibilityOptions(g),copyDeprecatedKeyboardNavigationOptions(g),copyDeprecatedLangOptions(g)}var format$4=FormatUtilities.format,pick$Y=Utilities.pick;function stringTrim$1(g){return g.trim&&g.trim()||g.replace(/^\s+|\s+$/g,"")}function formatExtendedStatement(g,d){var a=g.indexOf("#each("),u=g.indexOf("#plural("),v=g.indexOf("["),x=g.indexOf("]"),S,T;if(a>-1){var P=g.slice(a).indexOf(")")+a,z=g.substring(0,a),L=g.substring(P+1),N=g.substring(a+6,P),$=N.split(","),B=Number($[1]),U=void 0;if(T="",S=d[$[0]],S){B=isNaN(B)?S.length:B,U=B<0?S.length+B:Math.min(B,S.length);for(var j=0;j<U;++j)T+=z+S[j]+L}return T.length?T:""}if(u>-1){var Y=g.slice(u).indexOf(")")+u,q=g.substring(u+8,Y),Q=q.split(","),J=Number(d[Q[0]]);switch(J){case 0:T=pick$Y(Q[4],Q[1]);break;case 1:T=pick$Y(Q[2],Q[1]);break;case 2:T=pick$Y(Q[3],Q[1]);break;default:T=Q[1]}return T?stringTrim$1(T):""}if(v>-1){var ee=g.substring(0,v),ie=Number(g.substring(v+1,x)),ne=void 0;return S=d[ee],!isNaN(ie)&&S&&(ie<0?(ne=S[S.length+ie],typeof ne>"u"&&(ne=S[0])):(ne=S[ie],typeof ne>"u"&&(ne=S[S.length-1]))),typeof ne<"u"?ne:""}return"{"+g+"}"}H.i18nFormat=function(g,d,a){var u=function(P,z){var L=P.slice(z||0),N=L.indexOf("{"),$=L.indexOf("}");if(N>-1&&$>N)return{statement:L.substring(N+1,$),begin:z+N+1,end:z+$}},v=[],x,S,T=0;do x=u(g,T),S=g.substring(T,x&&x.begin-1),S.length&&v.push({value:S,type:"constant"}),x&&v.push({value:x.statement,type:"statement"}),T=x?x.end+1:T+1;while(x);return v.forEach(function(P){P.type==="statement"&&(P.value=formatExtendedStatement(P.value,d))}),format$4(v.reduce(function(P,z){return P+z.value},""),d,a)};Chart$1.prototype.langFormat=function(g,d){for(var a=g.split("."),u=this.options.lang,v=0;v<a.length;++v)u=u&&u[a[v]];return typeof u=="string"?H.i18nFormat(u,d,this):""};var addEvent$E=Utilities.addEvent,extend$U=Utilities.extend,pick$X=Utilities.pick,svgElementBorderUpdateTriggers=["x","y","transform","width","height","r","d","stroke-width"];function addDestroyFocusBorderHook(g){if(!g.focusBorderDestroyHook){var d=g.destroy;g.destroy=function(){return g.focusBorder&&g.focusBorder.destroy&&g.focusBorder.destroy(),d.apply(g,arguments)},g.focusBorderDestroyHook=d}}function removeDestroyFocusBorderHook(g){g.focusBorderDestroyHook&&(g.destroy=g.focusBorderDestroyHook,delete g.focusBorderDestroyHook)}function addUpdateFocusBorderHooks(g){for(var d=[],a=1;a<arguments.length;a++)d[a-1]=arguments[a];g.focusBorderUpdateHooks||(g.focusBorderUpdateHooks={},svgElementBorderUpdateTriggers.forEach(function(u){var v=u+"Setter",x=g[v]||g._defaultSetter;g.focusBorderUpdateHooks[v]=x,g[v]=function(){var S=x.apply(g,arguments);return g.addFocusBorder.apply(g,d),S}}))}function removeUpdateFocusBorderHooks(g){g.focusBorderUpdateHooks&&(Object.keys(g.focusBorderUpdateHooks).forEach(function(d){var a=g.focusBorderUpdateHooks[d];a===g._defaultSetter?delete g[d]:g[d]=a}),delete g.focusBorderUpdateHooks)}extend$U(SVGElement.prototype,{addFocusBorder:function(g,d){this.focusBorder&&this.removeFocusBorder();var a=this.getBBox(),u=pick$X(g,3);a.x+=this.translateX?this.translateX:0,a.y+=this.translateY?this.translateY:0;var v=a.x-u,x=a.y-u,S=a.width+2*u,T=a.height+2*u;function P(j){var Y=0,q=0;return j.attr("text-anchor")==="middle"?Y=q=.5:j.rotation?Y=.25:q=.75,{x:Y,y:q}}var z=this instanceof SVGLabel;if(this.element.nodeName==="text"||z){var L=!!this.rotation,N=z?{x:L?1:0,y:0}:P(this),$=+this.attr("x"),B=+this.attr("y");if(isNaN($)||(v=$-a.width*N.x-u),isNaN(B)||(x=B-a.height*N.y-u),z&&L){var U=S;S=T,T=U,isNaN($)||(v=$-a.height*N.x-u),isNaN(B)||(x=B-a.width*N.y-u)}}this.focusBorder=this.renderer.rect(v,x,S,T,parseInt((d&&d.r||0).toString(),10)).addClass("highcharts-focus-border").attr({zIndex:99}).add(this.parentGroup),this.renderer.styledMode||this.focusBorder.attr({stroke:d&&d.stroke,"stroke-width":d&&d.strokeWidth}),addUpdateFocusBorderHooks(this,g,d),addDestroyFocusBorderHook(this)},removeFocusBorder:function(){removeUpdateFocusBorderHooks(this),removeDestroyFocusBorderHook(this),this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}});Chart$1.prototype.renderFocusBorder=function(){var g=this.focusElement,d=this.options.accessibility.keyboardNavigation.focusBorder;g&&(g.removeFocusBorder(),d.enabled&&g.addFocusBorder(d.margin,{stroke:d.style.color,strokeWidth:d.style.lineWidth,r:d.style.borderRadius}))};Chart$1.prototype.setFocusToElement=function(g,d){var a=this.options.accessibility.keyboardNavigation.focusBorder,u=d||g.element;u&&u.focus&&(u.hcEvents&&u.hcEvents.focusin||addEvent$E(u,"focusin",function(){}),u.focus(),a.hideBrowserFocusOutline&&(u.style.outline="none")),this.focusElement&&this.focusElement.removeFocusBorder(),this.focusElement=g,this.renderFocusBorder()};var doc$5=H.doc,defaultOptions$8=DefaultOptions.defaultOptions,addEvent$D=Utilities.addEvent,extend$T=Utilities.extend,fireEvent$e=Utilities.fireEvent,merge$T=Utilities.merge;merge$T(!0,defaultOptions$8,Options,{accessibility:{highContrastTheme:theme},lang:langOptions});H.A11yChartUtilities=ChartUtilities;H.A11yHTMLUtilities=HTMLUtilities;H.KeyboardNavigationHandler=KeyboardNavigationHandler;H.AccessibilityComponent=AccessibilityComponent;function Accessibility(g){this.init(g)}Accessibility.prototype={init:function(g){if(this.chart=g,!doc$5.addEventListener||!g.renderer.isSVG){g.renderTo.setAttribute("aria-hidden",!0);return}copyDeprecatedOptions(g),this.initComponents(),this.keyboardNavigation=new KeyboardNavigation(g,this.components),this.update()},initComponents:function(){var g=this.chart,d=g.options.accessibility;this.components={container:new ContainerComponent,infoRegions:new InfoRegionsComponent,legend:new LegendComponent,chartMenu:new MenuComponent,rangeSelector:new RangeSelectorComponent,series:new SeriesComponent,zoom:new ZoomComponent},d.customComponents&&extend$T(this.components,d.customComponents);var a=this.components;this.getComponentOrder().forEach(function(u){a[u].initBase(g),a[u].init()})},getComponentOrder:function(){if(!this.components)return[];if(!this.components.series)return Object.keys(this.components);var g=Object.keys(this.components).filter(function(d){return d!=="series"});return["series"].concat(g)},update:function(){var g=this.components,d=this.chart,a=d.options.accessibility;fireEvent$e(d,"beforeA11yUpdate"),d.types=this.getChartTypes(),this.getComponentOrder().forEach(function(u){g[u].onChartUpdate(),fireEvent$e(d,"afterA11yComponentUpdate",{name:u,component:g[u]})}),this.keyboardNavigation.update(a.keyboardNavigation.order),!d.highContrastModeActive&&whcm.isHighContrastModeActive()&&whcm.setHighContrastTheme(d),fireEvent$e(d,"afterA11yUpdate",{accessibility:this})},destroy:function(){var g=this.chart||{},d=this.components;Object.keys(d).forEach(function(a){d[a].destroy(),d[a].destroyBase()}),this.keyboardNavigation&&this.keyboardNavigation.destroy(),g.renderTo&&g.renderTo.setAttribute("aria-hidden",!0),g.focusElement&&g.focusElement.removeFocusBorder()},getChartTypes:function(){var g={};return this.chart.series.forEach(function(d){g[d.type]=1}),Object.keys(g)}};Chart$1.prototype.updateA11yEnabled=function(){var g=this.accessibility,d=this.options.accessibility;d&&d.enabled?g?g.update():this.accessibility=g=new Accessibility(this):g?(g.destroy&&g.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)};addEvent$D(Chart$1,"render",function(g){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var d=this.accessibility;d&&d.getComponentOrder().forEach(function(a){d.components[a].onChartRender()})});addEvent$D(Chart$1,"update",function(g){var d=g.options.accessibility;d&&(d.customComponents&&(this.options.accessibility.customComponents=d.customComponents,delete d.customComponents),merge$T(!0,this.options.accessibility,d),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility)),this.a11yDirty=!0});addEvent$D(Point$4,"update",function(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)});["addSeries","init"].forEach(function(g){addEvent$D(Chart$1,g,function(){this.a11yDirty=!0})});["update","updatedData","remove"].forEach(function(g){addEvent$D(Series$f,g,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})});["afterDrilldown","drillupall"].forEach(function(g){addEvent$D(Chart$1,g,function(){this.accessibility&&this.accessibility.update()})});addEvent$D(Chart$1,"destroy",function(){this.accessibility&&this.accessibility.destroy()});var addEvent$C=Utilities.addEvent,fireEvent$d=Utilities.fireEvent,objectEach$e=Utilities.objectEach,pick$W=Utilities.pick,removeEvent$2=Utilities.removeEvent,eventEmitterMixin={addEvents:function(){var g=this,d=function(u){addEvent$C(u,H.isTouchDevice?"touchstart":"mousedown",function(v){g.onMouseDown(v)},{passive:!1})};if(d(this.graphic.element),(g.labels||[]).forEach(function(u){u.options.useHTML&&u.graphic.text&&d(u.graphic.text.element)}),objectEach$e(g.options.events,function(u,v){var x=function(S){(v!=="click"||!g.cancelClick)&&u.call(g,g.chart.pointer.normalize(S),g.target)};(g.nonDOMEvents||[]).indexOf(v)===-1?g.graphic.on(v,x):addEvent$C(g,v,x,{passive:!1})}),g.options.draggable&&(addEvent$C(g,"drag",g.onDrag),!g.graphic.renderer.styledMode)){var a={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[g.options.draggable]};g.graphic.css(a),(g.labels||[]).forEach(function(u){u.options.useHTML&&u.graphic.text&&u.graphic.text.css(a)})}g.isUpdating||fireEvent$d(g,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag()),this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(g){var d=this,a=d.chart.pointer,u,v;g.preventDefault&&g.preventDefault(),g.button!==2&&(g=a.normalize(g),u=g.chartX,v=g.chartY,d.cancelClick=!1,d.chart.hasDraggedAnnotation=!0,d.removeDrag=addEvent$C(H.doc,H.isTouchDevice?"touchmove":"mousemove",function(x){d.hasDragged=!0,x=a.normalize(x),x.prevChartX=u,x.prevChartY=v,fireEvent$d(d,"drag",x),u=x.chartX,v=x.chartY},H.isTouchDevice?{passive:!1}:void 0),d.removeMouseUp=addEvent$C(H.doc,H.isTouchDevice?"touchend":"mouseup",function(x){var S=pick$W(d.target&&d.target.annotation,d.target);S&&(S.cancelClick=d.hasDragged),d.cancelClick=d.hasDragged,d.hasDragged=!1,d.chart.hasDraggedAnnotation=!1,fireEvent$d(pick$W(S,d),"afterUpdate"),d.onMouseUp(x)},H.isTouchDevice?{passive:!1}:void 0))},onMouseUp:function(g){var d=this.chart,a=this.target||this,u=d.options.annotations,v=d.annotations.indexOf(a);this.removeDocEvents(),u[v]=a.options},onDrag:function(g){if(this.chart.isInsidePlot(g.chartX-this.chart.plotLeft,g.chartY-this.chart.plotTop,{visiblePlotOnly:!0})){var d=this.mouseMoveToTranslation(g);this.options.draggable==="x"&&(d.y=0),this.options.draggable==="y"&&(d.x=0),this.points.length?this.translate(d.x,d.y):(this.shapes.forEach(function(a){a.translate(d.x,d.y)}),this.labels.forEach(function(a){a.translate(d.x,d.y)})),this.redraw(!1)}},mouseMoveToRadians:function(g,d,a){var u=g.prevChartY-a,v=g.prevChartX-d,x=g.chartY-a,S=g.chartX-d,T;return this.chart.inverted&&(T=v,v=u,u=T,T=S,S=x,x=T),Math.atan2(x,S)-Math.atan2(u,v)},mouseMoveToTranslation:function(g){var d=g.chartX-g.prevChartX,a=g.chartY-g.prevChartY,u;return this.chart.inverted&&(u=a,a=d,d=u),{x:d,y:a}},mouseMoveToScale:function(g,d,a){var u=g.prevChartX-d,v=g.prevChartY-a,x=g.chartX-d,S=g.chartY-a,T=(x||1)/(u||1),P=(S||1)/(v||1),z;return this.chart.inverted&&(z=P,P=T,T=z),{x:T,y:P}},destroy:function(){this.removeDocEvents(),removeEvent$2(this),this.hcEvents=null}},merge$S=Utilities.merge,pick$V=Utilities.pick,ControlPoint=(function(){function g(d,a,u,v){this.addEvents=eventEmitterMixin.addEvents,this.graphic=void 0,this.mouseMoveToRadians=eventEmitterMixin.mouseMoveToRadians,this.mouseMoveToScale=eventEmitterMixin.mouseMoveToScale,this.mouseMoveToTranslation=eventEmitterMixin.mouseMoveToTranslation,this.onDrag=eventEmitterMixin.onDrag,this.onMouseDown=eventEmitterMixin.onMouseDown,this.onMouseUp=eventEmitterMixin.onMouseUp,this.removeDocEvents=eventEmitterMixin.removeDocEvents,this.nonDOMEvents=["drag"],this.chart=d,this.target=a,this.options=u,this.index=pick$V(u.index,v)}return g.prototype.setVisibility=function(d){this.graphic.attr("visibility",d?"visible":"hidden"),this.options.visible=d},g.prototype.render=function(){var d=this.chart,a=this.options;this.graphic=d.renderer.symbol(a.symbol,0,0,a.width,a.height).add(d.controlPointsGroup).css(a.style),this.setVisibility(a.visible),this.addEvents()},g.prototype.redraw=function(d){this.graphic[d?"animate":"attr"](this.options.positioner.call(this,this.target))},g.prototype.destroy=function(){eventEmitterMixin.destroy.call(this),this.graphic&&(this.graphic=this.graphic.destroy()),this.chart=null,this.target=null,this.options=null},g.prototype.update=function(d){var a=this.chart,u=this.target,v=this.index,x=merge$S(!0,this.options,d);this.destroy(),this.constructor(a,u,x,v),this.render(a.controlPointsGroup),this.redraw()},g})(),defined$p=Utilities.defined,fireEvent$c=Utilities.fireEvent,MockPoint=(function(){function g(d,a,u){this.isInside=void 0,this.negative=void 0,this.plotX=void 0,this.plotY=void 0,this.ttBelow=void 0,this.x=void 0,this.y=void 0,this.mock=!0,this.series={visible:!0,chart:d,getPlotBox:Series$f.prototype.getPlotBox},this.target=a||null,this.options=u,this.applyOptions(this.getOptions())}return g.fromPoint=function(d){return new g(d.series.chart,null,{x:d.x,y:d.y,xAxis:d.series.xAxis,yAxis:d.series.yAxis})},g.pointToPixels=function(d,a){var u=d.series,v=u.chart,x=d.plotX,S=d.plotY,T;return v.inverted&&(d.mock?(x=d.plotY,S=d.plotX):(x=v.plotWidth-d.plotY,S=v.plotHeight-d.plotX)),u&&!a&&(T=u.getPlotBox(),x+=T.translateX,S+=T.translateY),{x,y:S}},g.pointToOptions=function(d){return{x:d.x,y:d.y,xAxis:d.series.xAxis,yAxis:d.series.yAxis}},g.prototype.hasDynamicOptions=function(){return typeof this.options=="function"},g.prototype.getOptions=function(){return this.hasDynamicOptions()?this.options(this.target):this.options},g.prototype.applyOptions=function(d){this.command=d.command,this.setAxis(d,"x"),this.setAxis(d,"y"),this.refresh()},g.prototype.setAxis=function(d,a){var u=a+"Axis",v=d[u],x=this.series.chart;this.series[u]=v instanceof Axis?v:defined$p(v)?x[u][v]||x.get(v):null},g.prototype.toAnchor=function(){var d=[this.plotX,this.plotY,0,0];return this.series.chart.inverted&&(d[0]=this.plotY,d[1]=this.plotX),d},g.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}},g.prototype.isInsidePlot=function(){var d=this.plotX,a=this.plotY,u=this.series.xAxis,v=this.series.yAxis,x={x:d,y:a,isInsidePlot:!0};return u&&(x.isInsidePlot=defined$p(d)&&d>=0&&d<=u.len),v&&(x.isInsidePlot=x.isInsidePlot&&defined$p(a)&&a>=0&&a<=v.len),fireEvent$c(this.series.chart,"afterIsInsidePlot",x),x.isInsidePlot},g.prototype.refresh=function(){var d=this.series,a=d.xAxis,u=d.yAxis,v=this.getOptions();a?(this.x=v.x,this.plotX=a.toPixels(v.x,!0)):(this.x=null,this.plotX=v.x),u?(this.y=v.y,this.plotY=u.toPixels(v.y,!0)):(this.y=null,this.plotY=v.y),this.isInside=this.isInsidePlot()},g.prototype.translate=function(d,a,u,v){this.hasDynamicOptions()||(this.plotX+=u,this.plotY+=v,this.refreshOptions())},g.prototype.scale=function(d,a,u,v){if(!this.hasDynamicOptions()){var x=this.plotX*u,S=this.plotY*v,T=(1-u)*d,P=(1-v)*a;this.plotX=T+x,this.plotY=P+S,this.refreshOptions()}},g.prototype.rotate=function(d,a,u){if(!this.hasDynamicOptions()){var v=Math.cos(u),x=Math.sin(u),S=this.plotX,T=this.plotY,P=void 0,z=void 0;S-=d,T-=a,P=S*v-T*x,z=S*x+T*v,this.plotX=P+d,this.plotY=z+a,this.refreshOptions()}},g.prototype.refreshOptions=function(){var d=this.series,a=d.xAxis,u=d.yAxis;this.x=this.options.x=a?this.options.x=a.toValue(this.plotX,!0):this.plotX,this.y=this.options.y=u?u.toValue(this.plotY,!0):this.plotY},g})(),isObject$a=Utilities.isObject,isString$3=Utilities.isString,merge$R=Utilities.merge,splat$8=Utilities.splat,controllableMixin={init:function(g,d,a){this.annotation=g,this.chart=g.chart,this.options=d,this.points=[],this.controlPoints=[],this.index=a,this.linkPoints(),this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var g=this.options;return g.points||g.point&&splat$8(g.point)},attrsFromOptions:function(g){var d=this.constructor.attrsMap,a={},u,v,x=this.chart.styledMode;for(u in g)v=d[u],v&&(!x||["fill","stroke","stroke-width"].indexOf(v)===-1)&&(a[v]=g[u]);return a},anchor:function(g){var d=g.series.getPlotBox(),a=g.series.chart,u=g.mock?g.toAnchor():Tooltip.prototype.getAnchor.call({chart:g.series.chart},g),v={x:u[0]+(this.options.x||0),y:u[1]+(this.options.y||0),height:u[2]||0,width:u[3]||0};return{relativePosition:v,absolutePosition:merge$R(v,{x:v.x+(g.mock?d.translateX:a.plotLeft),y:v.y+(g.mock?d.translateY:a.plotTop)})}},point:function(g,d){if(g&&g.series)return g;if(!d||d.series===null){if(isObject$a(g))d=new MockPoint(this.chart,this,g);else if(isString$3(g))d=this.chart.get(g)||null;else if(typeof g=="function"){var a=g.call(d,this);d=a.series?a:new MockPoint(this.chart,this,g)}}return d},linkPoints:function(){var g=this.getPointsOptions(),d=this.points,a=g&&g.length||0,u,v;for(u=0;u<a;u++){if(v=this.point(g[u],d[u]),!v){d.length=0;return}v.mock&&v.refresh(),d[u]=v}return d},addControlPoints:function(){var g=this.options.controlPoints;(g||[]).forEach(function(d,a){var u=merge$R(this.options.controlPointOptions,d);u.index||(u.index=a),g[a]=u,this.controlPoints.push(new ControlPoint(this.chart,this,u))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(g){this.controlPoints.forEach(function(d){d.render()})},redraw:function(g){this.controlPoints.forEach(function(d){d.redraw(g)})},transform:function(g,d,a,u,v){if(this.chart.inverted){var x=d;d=a,a=x}this.points.forEach(function(S,T){this.transformPoint(g,d,a,u,v,T)},this)},transformPoint:function(g,d,a,u,v,x){var S=this.points[x];S.mock||(S=this.points[x]=MockPoint.fromPoint(S)),S[g](d,a,u,v)},translate:function(g,d){this.transform("translate",null,null,g,d)},translatePoint:function(g,d,a){this.transformPoint("translate",null,null,g,d,a)},translateShape:function(g,d){var a=this.annotation.chart,u=this.annotation.userOptions,v=a.annotations.indexOf(this.annotation),x=a.options.annotations[v];this.translatePoint(g,d,0),x[this.collection][this.index].point=this.options.point,u[this.collection][this.index].point=this.options.point},rotate:function(g,d,a){this.transform("rotate",g,d,a)},scale:function(g,d,a,u){this.transform("scale",g,d,a,u)},setControlPointsVisibility:function(g){this.controlPoints.forEach(function(d){d.setVisibility(g)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy()),this.tracker&&(this.tracker=this.tracker.destroy()),this.controlPoints.forEach(function(g){g.destroy()}),this.chart=null,this.points=null,this.controlPoints=null,this.options=null,this.annotation&&(this.annotation=null)},update:function(g){var d=this.annotation,a=merge$R(!0,this.options,g),u=this.graphic.parentGroup;this.destroy(),this.constructor(d,a,this.index),this.render(u),this.redraw()}},addEvent$B=Utilities.addEvent,defined$o=Utilities.defined,merge$Q=Utilities.merge,uniqueKey$2=Utilities.uniqueKey,defaultMarkers={arrow:{tagName:"marker",attributes:{id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 0 L 10 5 L 0 10 Z","stroke-width":0}}]},"reverse-arrow":{tagName:"marker",attributes:{id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 5 L 10 0 L 10 10 Z","stroke-width":0}}]}};SVGRenderer.prototype.addMarker=function(g,d){var a={attributes:{id:g}},u={stroke:d.color||"none",fill:d.color||"rgba(0, 0, 0, 0.75)"};a.children=d.children&&d.children.map(function(S){return merge$Q(u,S)});var v=merge$Q(!0,{attributes:{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"}},d,a),x=this.definition(v);return x.id=g,x};function createMarkerSetter(g){return function(d){this.attr(g,"url(#"+d+")")}}var markerMixin={markerEndSetter:createMarkerSetter("marker-end"),markerStartSetter:createMarkerSetter("marker-start"),setItemMarkers:function(g){var d=g.options,a=g.chart,u=a.options.defs,v=d.fill,x=defined$o(v)&&v!=="none"?v:d.stroke,S=function(T){var P=d[T],z,L,N,$;if(P){for(N in u)if(z=u[N],(P===(z.attributes&&z.attributes.id)||P===z.id)&&z.tagName==="marker"){L=z;break}L&&($=g[T]=a.renderer.addMarker((d.id||uniqueKey$2())+"-"+P,merge$Q(L,{color:x})),g.attr(T,$.getAttribute("id")))}};["markerStart","markerEnd"].forEach(S)}};addEvent$B(Chart$1,"afterGetContainer",function(){this.options.defs=merge$Q(defaultMarkers,this.options.defs||{})});var extend$S=Utilities.extend,TRACKER_FILL="rgba(192,192,192,"+(H.svg?1e-4:.002)+")",ControllablePath=(function(){function g(d,a,u){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.setMarkers=markerMixin.setItemMarkers,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translate=controllableMixin.translate,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="path",this.init(d,a,u),this.collection="shapes"}return g.prototype.toD=function(){var d=this.options.d;if(d)return typeof d=="function"?d.call(this):d;var a=this.points,u=a.length,v=u,x=a[0],S=v&&this.anchor(x).absolutePosition,T=0,P,z=[];if(S)for(z.push(["M",S.x,S.y]);++T<u&&v;)x=a[T],P=x.command||"L",S=this.anchor(x).absolutePosition,P==="M"?z.push([P,S.x,S.y]):P==="L"?z.push([P,S.x,S.y]):P==="Z"&&z.push([P]),v=x.series.visible;return v?this.chart.renderer.crispLine(z,this.graphic.strokeWidth()):null},g.prototype.shouldBeDrawn=function(){return controllableMixin.shouldBeDrawn.call(this)||!!this.options.d},g.prototype.render=function(d){var a=this.options,u=this.attrsFromOptions(a);this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(u).add(d),a.className&&this.graphic.addClass(a.className),this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(d),this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:TRACKER_FILL,fill:TRACKER_FILL,"stroke-width":this.graphic.strokeWidth()+a.snap*2}),controllableMixin.render.call(this),extend$S(this.graphic,{markerStartSetter:markerMixin.markerStartSetter,markerEndSetter:markerMixin.markerEndSetter}),this.setMarkers(this)},g.prototype.redraw=function(d){var a=this.toD(),u=d?"animate":"attr";a?(this.graphic[u]({d:a}),this.tracker[u]({d:a})):(this.graphic.attr({d:"M 0 "+-9e9}),this.tracker.attr({d:"M 0 "+-9e9})),this.graphic.placed=this.tracker.placed=!!a,controllableMixin.redraw.call(this,d)},g.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"},g})(),merge$P=Utilities.merge,ControllableRect=(function(){function g(d,a,u){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="rect",this.translate=controllableMixin.translateShape,this.init(d,a,u),this.collection="shapes"}return g.prototype.render=function(d){var a=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9e9,0,0).attr(a).add(d),controllableMixin.render.call(this)},g.prototype.redraw=function(d){var a=this.anchor(this.points[0]).absolutePosition;a?this.graphic[d?"animate":"attr"]({x:a.x,y:a.y,width:this.options.width,height:this.options.height}):this.attr({x:0,y:-9e9}),this.graphic.placed=!!a,controllableMixin.redraw.call(this,d)},g.attrsMap=merge$P(ControllablePath.attrsMap,{width:"width",height:"height"}),g})(),merge$O=Utilities.merge,ControllableCircle=(function(){function g(d,a,u){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="circle",this.translate=controllableMixin.translateShape,this.init(d,a,u),this.collection="shapes"}return g.prototype.render=function(d){var a=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9e9,0).attr(a).add(d),controllableMixin.render.call(this)},g.prototype.redraw=function(d){var a=this.anchor(this.points[0]).absolutePosition;a?this.graphic[d?"animate":"attr"]({x:a.x,y:a.y,r:this.options.r}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!a,controllableMixin.redraw.call(this,d)},g.prototype.setRadius=function(d){this.options.r=d},g.attrsMap=merge$O(ControllablePath.attrsMap,{r:"r"}),g})(),format$3=FormatUtilities.format,symbols$3=SVGRenderer.prototype.symbols,extend$R=Utilities.extend,isNumber$q=Utilities.isNumber,pick$U=Utilities.pick,ControllableLabel=(function(){function g(d,a,u){this.addControlPoints=controllableMixin.addControlPoints,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.init(d,a,u),this.collection="labels"}return g.alignedPosition=function(d,a){var u=d.align,v=d.verticalAlign,x=(a.x||0)+(d.x||0),S=(a.y||0)+(d.y||0),T,P;return u==="right"?T=1:u==="center"&&(T=2),T&&(x+=(a.width-(d.width||0))/T),v==="bottom"?P=1:v==="middle"&&(P=2),P&&(S+=(a.height-(d.height||0))/P),{x:Math.round(x),y:Math.round(S)}},g.justifiedOptions=function(d,a,u,v){var x=u.align,S=u.verticalAlign,T=a.box?0:a.padding||0,P=a.getBBox(),z={align:x,verticalAlign:S,x:u.x,y:u.y,width:a.width,height:a.height},L=(v.x||0)-d.plotLeft,N=(v.y||0)-d.plotTop,$;return $=L+T,$<0&&(x==="right"?z.align="left":z.x=(z.x||0)-$),$=L+P.width-T,$>d.plotWidth&&(x==="left"?z.align="right":z.x=(z.x||0)+d.plotWidth-$),$=N+T,$<0&&(S==="bottom"?z.verticalAlign="top":z.y=(z.y||0)-$),$=N+P.height-T,$>d.plotHeight&&(S==="top"?z.verticalAlign="bottom":z.y=(z.y||0)+d.plotHeight-$),z},g.prototype.translatePoint=function(d,a){controllableMixin.translatePoint.call(this,d,a,0)},g.prototype.translate=function(d,a){var u=this.annotation.chart,v=this.annotation.userOptions,x=u.annotations.indexOf(this.annotation),S=u.options.annotations,T=S[x];if(u.inverted){var P=d;d=a,a=P}this.options.x+=d,this.options.y+=a,T[this.collection][this.index].x=this.options.x,T[this.collection][this.index].y=this.options.y,v[this.collection][this.index].x=this.options.x,v[this.collection][this.index].y=this.options.y},g.prototype.render=function(d){var a=this.options,u=this.attrsFromOptions(a),v=a.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,a.shape,null,null,a.useHTML,null,"annotation-label").attr(u).add(d),this.annotation.chart.styledMode||(v.color==="contrast"&&(v.color=this.annotation.chart.renderer.getContrast(g.shapesWithoutBackground.indexOf(a.shape)>-1?"#FFFFFF":a.backgroundColor)),this.graphic.css(a.style).shadow(a.shadow)),a.className&&this.graphic.addClass(a.className),this.graphic.labelrank=a.labelrank,controllableMixin.render.call(this)},g.prototype.redraw=function(d){var a=this.options,u=this.text||a.format||a.text,v=this.graphic,x=this.points[0];v.attr({text:u?format$3(u,x.getLabelConfig(),this.annotation.chart):a.formatter.call(x,this)});var S=this.anchor(x),T=this.position(S);T?(v.alignAttr=T,T.anchorX=S.absolutePosition.x,T.anchorY=S.absolutePosition.y,v[d?"animate":"attr"](T)):v.attr({x:0,y:-9999}),v.placed=!!T,controllableMixin.redraw.call(this,d)},g.prototype.anchor=function(d){var a=controllableMixin.anchor.apply(this,arguments),u=this.options.x||0,v=this.options.y||0;return a.absolutePosition.x-=u,a.absolutePosition.y-=v,a.relativePosition.x-=u,a.relativePosition.y-=v,a},g.prototype.position=function(d){var a=this.graphic,u=this.annotation.chart,v=this.points[0],x=this.options,S=d.absolutePosition,T=d.relativePosition,P,z,L,N,$=v.series.visible&&MockPoint.prototype.isInsidePlot.call(v),B=a.width,U=B===void 0?0:B,j=a.height,Y=j===void 0?0:j;return $&&(x.distance?P=Tooltip.prototype.getPosition.call({chart:u,distance:pick$U(x.distance,16)},U,Y,{plotX:T.x,plotY:T.y,negative:v.negative,ttBelow:v.ttBelow,h:T.height||T.width}):x.positioner?P=x.positioner.call(this):(z={x:S.x,y:S.y,width:0,height:0},P=g.alignedPosition(extend$R(x,{width:U,height:Y}),z),this.options.overflow==="justify"&&(P=g.alignedPosition(g.justifiedOptions(u,a,x,P),z))),x.crop&&(L=P.x-u.plotLeft,N=P.y-u.plotTop,$=u.isInsidePlot(L,N)&&u.isInsidePlot(L+U,N+Y))),$?P:null},g.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"},g.shapesWithoutBackground=["connector"],g})();symbols$3.connector=function(g,d,a,u,v){var x=v&&v.anchorX,S=v&&v.anchorY,T,P,z=a/2;return isNumber$q(x)&&isNumber$q(S)&&(T=[["M",x,S]],P=d-S,P<0&&(P=-u-P),P<a&&(z=x<g+a/2?P:a-P),S>d+u?T.push(["L",g+z,d+u]):S<d?T.push(["L",g+z,d]):x<g?T.push(["L",g,d+u/2]):x>g+a&&T.push(["L",g+a,d+u/2])),T||[]};var ControllableImage=(function(){function g(d,a,u){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="image",this.translate=controllableMixin.translateShape,this.init(d,a,u),this.collection="shapes"}return g.prototype.render=function(d){var a=this.attrsFromOptions(this.options),u=this.options;this.graphic=this.annotation.chart.renderer.image(u.src,0,-9e9,u.width,u.height).attr(a).add(d),this.graphic.width=u.width,this.graphic.height=u.height,controllableMixin.render.call(this)},g.prototype.redraw=function(d){var a=this.anchor(this.points[0]),u=ControllableLabel.prototype.position.call(this,a);u?this.graphic[d?"animate":"attr"]({x:u.x,y:u.y}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!u,controllableMixin.redraw.call(this,d)},g.attrsMap={width:"width",height:"height",zIndex:"zIndex"},g})(),getDeferredAnimation=animationExports.getDeferredAnimation,chartProto=Chart$1.prototype,addEvent$A=Utilities.addEvent,defined$n=Utilities.defined,destroyObjectProperties=Utilities.destroyObjectProperties,erase$1=Utilities.erase,extend$Q=Utilities.extend,find$7=Utilities.find,fireEvent$b=Utilities.fireEvent,merge$N=Utilities.merge,pick$T=Utilities.pick,splat$7=Utilities.splat,wrap$e=Utilities.wrap,Annotation=(function(){function g(d,a){this.annotation=void 0,this.coll="annotations",this.collection=void 0,this.animationConfig=void 0,this.graphic=void 0,this.group=void 0,this.labelCollector=void 0,this.labelsGroup=void 0,this.shapesGroup=void 0;var u;this.chart=d,this.points=[],this.controlPoints=[],this.coll="annotations",this.labels=[],this.shapes=[],this.options=merge$N(this.defaultOptions,a),this.userOptions=a,u=this.getLabelsAndShapesOptions(this.options,a),this.options.labels=u.labels,this.options.shapes=u.shapes,this.init(d,this.options)}return g.prototype.init=function(){var d=this.chart,a=this.options.animation;this.linkPoints(),this.addControlPoints(),this.addShapes(),this.addLabels(),this.setLabelCollector(),this.animationConfig=getDeferredAnimation(d,a)},g.prototype.getLabelsAndShapesOptions=function(d,a){var u={};return["labels","shapes"].forEach(function(v){d[v]&&(a[v]?u[v]=splat$7(a[v]).map(function(x,S){return merge$N(d[v][S],x)}):u[v]=d[v])}),u},g.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(d,a){var u=this.initShape(d,a);merge$N(!0,this.options.shapes[a],u.options)},this)},g.prototype.addLabels=function(){(this.options.labels||[]).forEach(function(d,a){var u=this.initLabel(d,a);merge$N(!0,this.options.labels[a],u.options)},this)},g.prototype.addClipPaths=function(){this.setClipAxes(),this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))},g.prototype.setClipAxes=function(){var d=this.chart.xAxis,a=this.chart.yAxis,u=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(v,x){var S=x&&(x.point||x.points&&x.points[0]);return[d[S&&S.xAxis]||v[0],a[S&&S.yAxis]||v[1]]},[]);this.clipXAxis=u[0],this.clipYAxis=u[1]},g.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}},g.prototype.setLabelCollector=function(){var d=this;d.labelCollector=function(){return d.labels.reduce(function(a,u){return u.options.allowOverlap||a.push(u.graphic),a},[])},d.chart.labelCollectors.push(d.labelCollector)},g.prototype.setOptions=function(d){this.options=merge$N(this.defaultOptions,d)},g.prototype.redraw=function(d){this.linkPoints(),this.graphic||this.render(),this.clipRect&&this.clipRect.animate(this.getClipBox()),this.redrawItems(this.shapes,d),this.redrawItems(this.labels,d),controllableMixin.redraw.call(this,d)},g.prototype.redrawItems=function(d,a){for(var u=d.length;u--;)this.redrawItem(d[u],a)},g.prototype.renderItems=function(d){for(var a=d.length;a--;)this.renderItem(d[a])},g.prototype.render=function(){var d=this.chart.renderer;this.graphic=d.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add(),this.shapesGroup=d.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip),this.labelsGroup=d.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic),this.addClipPaths(),this.clipRect&&this.graphic.clip(this.clipRect),this.renderItems(this.shapes),this.renderItems(this.labels),this.addEvents(),controllableMixin.render.call(this)},g.prototype.setVisibility=function(d){var a=this.options,u=this.chart.navigationBindings,v=pick$T(d,!a.visible);this.graphic.attr("visibility",v?"visible":"hidden"),v||(this.setControlPointsVisibility(!1),u.activeAnnotation===this&&u.popup&&u.popup.formType==="annotation-toolbar"&&fireEvent$b(u,"closePopup")),a.visible=v},g.prototype.setControlPointsVisibility=function(d){var a=function(u){u.setControlPointsVisibility(d)};controllableMixin.setControlPointsVisibility.call(this,d),this.shapes.forEach(a),this.labels.forEach(a)},g.prototype.destroy=function(){var d=this.chart,a=function(u){u.destroy()};this.labels.forEach(a),this.shapes.forEach(a),this.clipXAxis=null,this.clipYAxis=null,erase$1(d.labelCollectors,this.labelCollector),eventEmitterMixin.destroy.call(this),controllableMixin.destroy.call(this),destroyObjectProperties(this,d)},g.prototype.remove=function(){return this.chart.removeAnnotation(this)},g.prototype.update=function(d,a){var u=this.chart,v=this.getLabelsAndShapesOptions(this.userOptions,d),x=u.annotations.indexOf(this),S=merge$N(!0,this.userOptions,d);S.labels=v.labels,S.shapes=v.shapes,this.destroy(),this.constructor(u,S),u.options.annotations[x]=S,this.isUpdating=!0,pick$T(a,!0)&&u.redraw(),fireEvent$b(this,"afterUpdate"),this.isUpdating=!1},g.prototype.initShape=function(d,a){var u=merge$N(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},d),v=new g.shapesMap[u.type](this,u,a);return v.itemType="shape",this.shapes.push(v),v},g.prototype.initLabel=function(d,a){var u=merge$N(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},d),v=new ControllableLabel(this,u,a);return v.itemType="label",this.labels.push(v),v},g.prototype.redrawItem=function(d,a){d.linkPoints(),d.shouldBeDrawn()?(d.graphic||this.renderItem(d),d.redraw(pick$T(a,!0)&&d.graphic.placed),d.points.length&&this.adjustVisibility(d)):this.destroyItem(d)},g.prototype.adjustVisibility=function(d){var a=!1,u=d.graphic;d.points.forEach(function(v){v.series.visible!==!1&&v.visible!==!1&&(a=!0)}),a?u.visibility==="hidden"&&u.show():u.hide()},g.prototype.destroyItem=function(d){erase$1(this[d.itemType+"s"],d),d.destroy()},g.prototype.renderItem=function(d){d.render(d.itemType==="label"?this.labelsGroup:this.shapesGroup)},g.ControlPoint=ControlPoint,g.MockPoint=MockPoint,g.shapesMap={rect:ControllableRect,circle:ControllableCircle,path:ControllablePath,image:ControllableImage},g.types={},g})();merge$N(!0,Annotation.prototype,controllableMixin,eventEmitterMixin,merge$N(Annotation.prototype,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:palette.neutralColor100,borderRadius:3,borderWidth:1,className:"highcharts-no-tooltip",crop:!1,formatter:function(){return defined$n(this.y)?this.y:"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:palette.neutralColor100,"stroke-width":2,fill:palette.backgroundColor},visible:!1,events:{}},events:{},zIndex:6}}));H.extendAnnotation=function(g,d,a,u){d=d||Annotation,extend$Q(g.prototype,merge$N(d.prototype,a)),g.prototype.defaultOptions=merge$N(g.prototype.defaultOptions,u||{})};extend$Q(chartProto,{initAnnotation:function(g){var d=Annotation.types[g.type]||Annotation,a=new d(this,g);return this.annotations.push(a),a},addAnnotation:function(g,d){var a=this.initAnnotation(g);return this.options.annotations.push(a.options),pick$T(d,!0)&&(a.redraw(),a.graphic.attr({opacity:1})),a},removeAnnotation:function(g){var d=this.annotations,a=g.coll==="annotations"?g:find$7(d,function(u){return u.options.id===g});a&&(fireEvent$b(a,"remove"),erase$1(this.options.annotations,a.options),erase$1(d,a),a.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox),this.annotations.forEach(function(g){g.redraw(),g.graphic.animate({opacity:1},g.animationConfig)})}});chartProto.collectionsWithUpdate.push("annotations");chartProto.collectionsWithInit.annotations=[chartProto.addAnnotation];addEvent$A(Chart$1,"afterInit",function(){this.annotations=[],this.options.annotations||(this.options.annotations=[])});chartProto.callbacks.push(function(g){g.plotBoxClip=this.renderer.clipRect(this.plotBox),g.controlPointsGroup=g.renderer.g("control-points").attr({zIndex:99}).clip(g.plotBoxClip).add(),g.options.annotations.forEach(function(d,a){if(!g.annotations.some(function(v){return v.options===d})){var u=g.initAnnotation(d);g.options.annotations[a]=u.options}}),g.drawAnnotations(),addEvent$A(g,"redraw",g.drawAnnotations),addEvent$A(g,"destroy",function(){g.plotBoxClip.destroy(),g.controlPointsGroup.destroy()}),addEvent$A(g,"exportData",function(d){var a=g.annotations,u=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,v=!d.dataRows[1].xValues,x=g.options.lang&&g.options.lang.exportData&&g.options.lang.exportData.annotationHeader,S=function(U){var j;return u&&(j=u(U),j!==!1)?j:(j=x+" "+U,v?{columnTitle:j,topLevelColumnTitle:j}:j)},T=d.dataRows[0].length,P=g.options.exporting&&g.options.exporting.csv&&g.options.exporting.csv.annotations&&g.options.exporting.csv.annotations.itemDelimiter,z=g.options.exporting&&g.options.exporting.csv&&g.options.exporting.csv.annotations&&g.options.exporting.csv.annotations.join;a.forEach(function(U){U.options.labelOptions.includeInDataExport&&U.labels.forEach(function(j){if(j.options.text){var Y=j.options.text;j.points.forEach(function(q){var Q=q.x,J=q.series.xAxis?q.series.xAxis.options.index:-1,ee=!1;if(J===-1){for(var ie=d.dataRows[0].length,ne=new Array(ie),ae=0;ae<ie;++ae)ne[ae]="";ne.push(Y),ne.xValues=[],ne.xValues[J]=Q,d.dataRows.push(ne),ee=!0}if(ee||d.dataRows.forEach(function(de,he){!ee&&de.xValues&&J!==void 0&&Q===de.xValues[J]&&(z&&de.length>T?de[de.length-1]+=P+Y:de.push(Y),ee=!0)}),!ee){for(var ie=d.dataRows[0].length,ne=new Array(ie),ae=0;ae<ie;++ae)ne[ae]="";ne[0]=Q,ne.push(Y),ne.xValues=[],J!==void 0&&(ne.xValues[J]=Q),d.dataRows.push(ne)}})}})});var L=0;d.dataRows.forEach(function(U){L=Math.max(L,U.length)});for(var N=L-d.dataRows[0].length,$=0;$<N;$++){var B=S($+1);v?(d.dataRows[0].push(B.topLevelColumnTitle),d.dataRows[1].push(B.columnTitle)):d.dataRows[0].push(B)}})});wrap$e(Pointer.prototype,"onContainerMouseDown",function(g){this.chart.hasDraggedAnnotation||g.apply(this,Array.prototype.slice.call(arguments,1))});H.Annotation=Annotation;var chartNavigation={initUpdate:function(g){g.navigation||(g.navigation={updates:[],update:function(d,a){this.updates.forEach(function(u){u.update.call(u.context,d,a)})}})},addUpdate:function(g,d){d.navigation||this.initUpdate(d),d.navigation.updates.push({update:g,context:d})}},format$2=FormatUtilities.format,setOptions$1=DefaultOptions.setOptions,addEvent$z=Utilities.addEvent,attr=Utilities.attr,fireEvent$a=Utilities.fireEvent,isArray$a=Utilities.isArray,isFunction$1=Utilities.isFunction,isNumber$p=Utilities.isNumber,isObject$9=Utilities.isObject,merge$M=Utilities.merge,objectEach$d=Utilities.objectEach,pick$S=Utilities.pick,doc$4=H.doc,win$2=H.win,PREFIX$1="highcharts-";function closestPolyfill(g,d){var a=win$2.Element.prototype,u=a.matches||a.msMatchesSelector||a.webkitMatchesSelector,v=null;if(a.closest)v=a.closest.call(g,d);else do{if(u.call(g,d))return g;g=g.parentElement||g.parentNode}while(g!==null&&g.nodeType===1);return v}var bindingsUtils={getFieldType:function(g){return{string:"text",number:"number",boolean:"checkbox"}[typeof g]},updateRectSize:function(g,d){var a=d.chart,u=d.options.typeOptions,v=isNumber$p(u.xAxis)&&a.xAxis[u.xAxis],x=isNumber$p(u.yAxis)&&a.yAxis[u.yAxis];if(v&&x){var S=v.toValue(g[v.horiz?"chartX":"chartY"]),T=x.toValue(g[x.horiz?"chartX":"chartY"]),P=S-u.point.x,z=u.point.y-T;d.update({typeOptions:{background:{width:a.inverted?z:P,height:a.inverted?P:z}}})}},getAssignedAxis:function(g){return g.filter(function(d){var a=d.axis.min,u=d.axis.max,v=pick$S(d.axis.minPointOffset,0);return isNumber$p(a)&&isNumber$p(u)&&d.value>=a-v&&d.value<=u+v&&!d.axis.options.isInternal})[0]}},NavigationBindings=(function(){function g(d,a){this.boundClassNames=void 0,this.selectedButton=void 0,this.chart=d,this.options=a,this.eventsToUnbind=[],this.container=doc$4.getElementsByClassName(this.options.bindingsClassName||"")}return g.prototype.initEvents=function(){var d=this,a=d.chart,u=d.container,v=d.options;d.boundClassNames={},objectEach$d(v.bindings||{},function(x){d.boundClassNames[x.className]=x}),[].forEach.call(u,function(x){d.eventsToUnbind.push(addEvent$z(x,"click",function(S){var T=d.getButtonEvents(x,S);T&&T.button.className.indexOf("highcharts-disabled-btn")===-1&&d.bindingsButtonClick(T.button,T.events,S)}))}),objectEach$d(v.events||{},function(x,S){isFunction$1(x)&&d.eventsToUnbind.push(addEvent$z(d,S,x,{passive:!1}))}),d.eventsToUnbind.push(addEvent$z(a.container,"click",function(x){!a.cancelClick&&a.isInsidePlot(x.chartX-a.plotLeft,x.chartY-a.plotTop,{visiblePlotOnly:!0})&&d.bindingsChartClick(this,x)})),d.eventsToUnbind.push(addEvent$z(a.container,H.isTouchDevice?"touchmove":"mousemove",function(x){d.bindingsContainerMouseMove(this,x)},H.isTouchDevice?{passive:!1}:void 0))},g.prototype.initUpdate=function(){var d=this;chartNavigation.addUpdate(function(a){d.update(a)},this.chart)},g.prototype.bindingsButtonClick=function(d,a,u){var v=this,x=v.chart;v.selectedButtonElement&&(fireEvent$a(v,"deselectButton",{button:v.selectedButtonElement}),v.nextEvent&&(v.currentUserDetails&&v.currentUserDetails.coll==="annotations"&&x.removeAnnotation(v.currentUserDetails),v.mouseMoveEvent=v.nextEvent=!1)),v.selectedButton=a,v.selectedButtonElement=d,fireEvent$a(v,"selectButton",{button:d}),a.init&&a.init.call(v,d,u),(a.start||a.steps)&&x.renderer.boxWrapper.addClass(PREFIX$1+"draw-mode")},g.prototype.bindingsChartClick=function(d,a){d=this.chart;var u=this,v=u.activeAnnotation,x=u.selectedButton,S=d.renderer.boxWrapper;v&&(!v.cancelClick&&!a.activeAnnotation&&a.target.parentNode&&!closestPolyfill(a.target,"."+PREFIX$1+"popup")?fireEvent$a(u,"closePopup"):v.cancelClick&&setTimeout(function(){v.cancelClick=!1},0)),!(!x||!x.start)&&(u.nextEvent?(u.nextEvent(a,u.currentUserDetails),u.steps&&(u.stepIndex++,x.steps[u.stepIndex]?u.mouseMoveEvent=u.nextEvent=x.steps[u.stepIndex]:(fireEvent$a(u,"deselectButton",{button:u.selectedButtonElement}),S.removeClass(PREFIX$1+"draw-mode"),x.end&&x.end.call(u,a,u.currentUserDetails),u.nextEvent=!1,u.mouseMoveEvent=!1,u.selectedButton=null))):(u.currentUserDetails=x.start.call(u,a),u.currentUserDetails&&x.steps?(u.stepIndex=0,u.steps=!0,u.mouseMoveEvent=u.nextEvent=x.steps[u.stepIndex]):(fireEvent$a(u,"deselectButton",{button:u.selectedButtonElement}),S.removeClass(PREFIX$1+"draw-mode"),u.steps=!1,u.selectedButton=null,x.end&&x.end.call(u,a,u.currentUserDetails))))},g.prototype.bindingsContainerMouseMove=function(d,a){this.mouseMoveEvent&&this.mouseMoveEvent(a,this.currentUserDetails)},g.prototype.fieldsToOptions=function(d,a){return objectEach$d(d,function(u,v){var x=parseFloat(u),S=v.split("."),T=a,P=S.length-1;isNumber$p(x)&&!u.match(/px/g)&&!v.match(/format/g)&&(u=x),u!==""&&u!=="undefined"&&S.forEach(function(z,L){var N=pick$S(S[L+1],"");P===L?T[z]=u:(T[z]||(T[z]=N.match(/\d/g)?[]:{}),T=T[z])})}),a},g.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)},g.prototype.annotationToFields=function(d){var a=d.options,u=g.annotationsEditable,v=u.nestedOptions,x=this.utils.getFieldType,S=pick$S(a.type,a.shapes&&a.shapes[0]&&a.shapes[0].type,a.labels&&a.labels[0]&&a.labels[0].itemType,"label"),T=g.annotationsNonEditable[a.langKey]||[],P={langKey:a.langKey,type:S};function z(L,N,$,B){var U;$&&L&&T.indexOf(N)===-1&&(($.indexOf&&$.indexOf(N))>=0||$[N]||$===!0)&&(isArray$a(L)?(B[N]=[],L.forEach(function(j,Y){isObject$9(j)?(B[N][Y]={},objectEach$d(j,function(q,Q){z(q,Q,v[N],B[N][Y])})):z(j,0,v[N],B[N])})):isObject$9(L)?(U={},isArray$a(B)?(B.push(U),U[N]={},U=U[N]):B[N]=U,objectEach$d(L,function(j,Y){z(j,Y,N===0?$:v[N],U)})):N==="format"?B[N]=[format$2(L,d.labels[0].points[0]).toString(),"text"]:isArray$a(B)?B.push([L,x(L)]):B[N]=[L,x(L)])}return objectEach$d(a,function(L,N){N==="typeOptions"?(P[N]={},objectEach$d(a[N],function($,B){z($,B,v,P[N])})):z(L,N,u[S],P)}),P},g.prototype.getClickedClassNames=function(d,a){for(var u=a.target,v=[],x;u;)if(x=attr(u,"class"),x&&(v=v.concat(x.split(" ").map(function(S){return[S,u]}))),u=u.parentNode,u===d)return v;return v},g.prototype.getButtonEvents=function(d,a){var u=this,v=this.getClickedClassNames(d,a),x;return v.forEach(function(S){u.boundClassNames[S[0]]&&!x&&(x={events:u.boundClassNames[S[0]],button:S[1]})}),x},g.prototype.update=function(d){this.options=merge$M(!0,this.options,d),this.removeEvents(),this.initEvents()},g.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(d){d()})},g.prototype.destroy=function(){this.removeEvents()},g.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]},g.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]},g})();NavigationBindings.prototype.utils=bindingsUtils;Chart$1.prototype.initNavigationBindings=function(){var g=this,d=g.options;d&&d.navigation&&d.navigation.bindings&&(g.navigationBindings=new NavigationBindings(g,d.navigation),g.navigationBindings.initEvents(),g.navigationBindings.initUpdate())};addEvent$z(Chart$1,"load",function(){this.initNavigationBindings()});addEvent$z(Chart$1,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});addEvent$z(NavigationBindings,"deselectButton",function(){this.selectedButtonElement=null});addEvent$z(Annotation,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});function selectableAnnotation(g){var d=g.prototype.defaultOptions.events&&g.prototype.defaultOptions.events.click;function a(u){var v=this,x=v.chart.navigationBindings,S=x.activeAnnotation;d&&d.call(v,u),S!==v?(x.deselectAnnotation(),x.activeAnnotation=v,v.setControlPointsVisibility(!0),fireEvent$a(x,"showPopup",{annotation:v,formType:"annotation-toolbar",options:x.annotationToFields(v),onSubmit:function(T){var P={},z;T.actionType==="remove"?(x.activeAnnotation=!1,x.chart.removeAnnotation(v)):(x.fieldsToOptions(T.fields,P),x.deselectAnnotation(),z=P.typeOptions,v.options.type==="measure"&&(z.crosshairY.enabled=z.crosshairY.strokeWidth!==0,z.crosshairX.enabled=z.crosshairX.strokeWidth!==0),v.update(P))}})):fireEvent$a(x,"closePopup"),u.activeAnnotation=!0}merge$M(!0,g.prototype.defaultOptions.events,{click:a})}H.Annotation&&(selectableAnnotation(Annotation),objectEach$d(Annotation.types,function(g){selectableAnnotation(g)}));setOptions$1({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(g){var d=this.chart.pointer.getCoordinates(g),a=this.utils.getAssignedAxis(d.xAxis),u=this.utils.getAssignedAxis(d.yAxis),v=this.chart.options.navigation;if(!(!a||!u))return this.chart.addAnnotation(merge$M({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:a.value,y:u.value,xAxis:a.axis.options.index,yAxis:u.axis.options.index},r:5}]},v.annotationsOptions,v.bindings.circleAnnotation.annotationsOptions))},steps:[function(g,d){var a=d.options.shapes[0].point,u=this.chart.inverted,v,x,S;isNumber$p(a.xAxis)&&isNumber$p(a.yAxis)&&(v=this.chart.xAxis[a.xAxis].toPixels(a.x),x=this.chart.yAxis[a.yAxis].toPixels(a.y),S=Math.max(Math.sqrt(Math.pow(u?x-g.chartX:v-g.chartX,2)+Math.pow(u?v-g.chartY:x-g.chartY,2)),5)),d.update({shapes:[{r:S}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(g){var d=this.chart.pointer.getCoordinates(g),a=this.utils.getAssignedAxis(d.xAxis),u=this.utils.getAssignedAxis(d.yAxis);if(!(!a||!u)){var v=a.value,x=u.value,S=a.axis.options.index,T=u.axis.options.index,P=this.chart.options.navigation;return this.chart.addAnnotation(merge$M({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:S,yAxis:T,x:v,y:x},{xAxis:S,yAxis:T,x:v,y:x},{xAxis:S,yAxis:T,x:v,y:x},{xAxis:S,yAxis:T,x:v,y:x}]}]},P.annotationsOptions,P.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(g,d){var a=d.options.shapes[0].points,u=this.chart.pointer.getCoordinates(g),v=this.utils.getAssignedAxis(u.xAxis),x=this.utils.getAssignedAxis(u.yAxis),S,T;v&&x&&(S=v.value,T=x.value,a[1].x=S,a[2].x=S,a[2].y=T,a[3].y=T,d.update({shapes:[{points:a}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(g){var d=this.chart.pointer.getCoordinates(g),a=this.utils.getAssignedAxis(d.xAxis),u=this.utils.getAssignedAxis(d.yAxis),v=this.chart.options.navigation;if(!(!a||!u))return this.chart.addAnnotation(merge$M({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:a.axis.options.index,yAxis:u.axis.options.index,x:a.value,y:u.value},overflow:"none",crop:!0}]},v.annotationsOptions,v.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});addEvent$z(Chart$1,"render",function(){var g=this,d=g.navigationBindings,a="highcharts-disabled-btn";if(g&&d){var u=!1;g.series.forEach(function(v){!v.options.isInternal&&v.visible&&(u=!0)}),objectEach$d(d.boundClassNames,function(v,x){if(g.navigationBindings&&g.navigationBindings.container&&g.navigationBindings.container[0]){var S=g.navigationBindings.container[0].querySelectorAll("."+x);if(S)for(var T=0;T<S.length;T++){var P=S[T];v.noDataState==="normal"||u?P.className.indexOf(a)!==-1&&P.classList.remove(a):P.className.indexOf(a)===-1&&(P.className+=" "+a)}}})}});addEvent$z(NavigationBindings,"closePopup",function(){this.deselectAnnotation()});var doc$3=H.doc,isFirefox=H.isFirefox,getOptions$2=DefaultOptions.getOptions,addEvent$y=Utilities.addEvent,createElement$2=Utilities.createElement,defined$m=Utilities.defined,fireEvent$9=Utilities.fireEvent,isArray$9=Utilities.isArray,isObject$8=Utilities.isObject,isString$2=Utilities.isString,objectEach$c=Utilities.objectEach,pick$R=Utilities.pick,stableSort$3=Utilities.stableSort,wrap$d=Utilities.wrap,indexFilter=/\d/g,PREFIX="highcharts-",DIV="div",INPUT="input",LABEL="label",BUTTON="button",SELECT="select",OPTION="option",SPAN="span",UL="ul",LI="li",H3="h3";wrap$d(Pointer.prototype,"onContainerMouseDown",function(g,d){var a=d.target&&d.target.className;isString$2(a)&&a.indexOf(PREFIX+"popup-field")>=0||g.apply(this,Array.prototype.slice.call(arguments,1))});H.Popup=function(g,d,a){this.init(g,d,a)};H.Popup.prototype={init:function(g,d,a){this.chart=a,this.container=createElement$2(DIV,{className:PREFIX+"popup highcharts-no-tooltip"},null,g),this.lang=this.getLangpack(),this.iconsURL=d,this.addCloseBtn()},addCloseBtn:function(){var g=this,d,a=this.iconsURL;d=createElement$2(DIV,{className:PREFIX+"popup-close"},null,this.container),d.style["background-image"]="url("+(a.match(/png|svg|jpeg|jpg|gif/ig)?a:a+"close.svg")+")",["click","touchstart"].forEach(function(u){addEvent$y(d,u,function(){g.chart?fireEvent$9(g.chart.navigationBindings,"closePopup"):g.closePopup()})})},addColsContainer:function(g){var d,a;return a=createElement$2(DIV,{className:PREFIX+"popup-lhs-col"},null,g),d=createElement$2(DIV,{className:PREFIX+"popup-rhs-col"},null,g),createElement$2(DIV,{className:PREFIX+"popup-rhs-col-wrapper"},null,d),{lhsCol:a,rhsCol:d}},addInput:function(g,d,a,u){var v=g.split("."),x=v[v.length-1],S=this.lang,T=PREFIX+d+"-"+x;T.match(indexFilter)||createElement$2(LABEL,{htmlFor:T},void 0,a).appendChild(doc$3.createTextNode(S[x]||x)),u!==""&&createElement$2(INPUT,{name:T,value:u[0],type:u[1],className:PREFIX+"popup-field"},void 0,a).setAttribute(PREFIX+"data-name",g)},addButton:function(g,d,a,u,v){var x=this,S=this.closePopup,T=this.getFields,P;return P=createElement$2(BUTTON,void 0,void 0,g),P.appendChild(doc$3.createTextNode(d)),["click","touchstart"].forEach(function(z){addEvent$y(P,z,function(){return S.call(x),u(T(v,a))})}),P},getFields:function(g,d){var a=g.querySelectorAll("input"),u="#"+PREFIX+"select-series > option:checked",v="#"+PREFIX+"select-volume > option:checked",x=g.querySelectorAll(u)[0],S=g.querySelectorAll(v)[0],T,P,z;return z={actionType:d,linkedTo:x&&x.getAttribute("value"),fields:{}},[].forEach.call(a,function(L){P=L.getAttribute(PREFIX+"data-name"),T=L.getAttribute(PREFIX+"data-series-id"),T?z.seriesId=L.value:P?z.fields[P]=L.value:z.type=L.value}),S&&(z.fields["params.volumeSeriesID"]=S.getAttribute("value")),z},showPopup:function(){var g=this.container,d=PREFIX+"annotation-toolbar",a=g.querySelectorAll("."+PREFIX+"popup-close")[0];this.formType=void 0,g.innerHTML="",g.className.indexOf(d)>=0&&(g.classList.remove(d),g.removeAttribute("style")),g.appendChild(a),g.style.display="block",g.style.height=""},closePopup:function(){var g=pick$R(this.popup&&this.popup.container,this.container);g.style.display="none"},showForm:function(g,d,a,u){d&&(this.popup=d.navigationBindings.popup,this.showPopup(),g==="indicators"&&this.indicators.addForm.call(this,d,a,u),g==="annotation-toolbar"&&this.annotations.addToolbar.call(this,d,a,u),g==="annotation-edit"&&this.annotations.addForm.call(this,d,a,u),g==="flag"&&this.annotations.addForm.call(this,d,a,u,!0),this.formType=g,this.container.style.height=this.container.offsetHeight+"px")},getLangpack:function(){return getOptions$2().lang.navigation.popup},annotations:{addToolbar:function(g,d,a){var u=this,v=this.lang,x=this.popup.container,S=this.showForm,T=PREFIX+"annotation-toolbar",P;x.className.indexOf(T)===-1&&(x.className+=" "+T),g&&(x.style.top=g.plotTop+10+"px"),createElement$2(SPAN,void 0,void 0,x).appendChild(doc$3.createTextNode(pick$R(v[d.langKey]||d.langKey,d.shapes&&d.shapes[0].type))),P=this.addButton(x,v.removeButton||"remove","remove",a,x),P.className+=" "+PREFIX+"annotation-remove-button",P.style["background-image"]="url("+this.iconsURL+"destroy.svg)",P=this.addButton(x,v.editButton||"edit","edit",function(){S.call(u,"annotation-edit",g,d,a)},x),P.className+=" "+PREFIX+"annotation-edit-button",P.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(g,d,a,u){var v=this.popup.container,x=this.lang,S,T;g&&(T=createElement$2("h2",{className:PREFIX+"popup-main-title"},void 0,v),T.appendChild(doc$3.createTextNode(x[d.langKey]||d.langKey||"")),T=createElement$2(DIV,{className:PREFIX+"popup-lhs-col "+PREFIX+"popup-lhs-full"},null,v),S=createElement$2(DIV,{className:PREFIX+"popup-bottom-row"},null,v),this.annotations.addFormFields.call(this,T,g,"",d,[],!0),this.addButton(S,u?x.addButton||"add":x.saveButton||"save",u?"add":"save",a,v))},addFormFields:function(g,d,a,u,v,x){var S=this,T=this.annotations.addFormFields,P=this.addInput,z=this.lang,L,N;d&&(objectEach$c(u,function($,B){L=a!==""?a+"."+B:B,isObject$8($)&&(!isArray$9($)||isArray$9($)&&isObject$8($[0])?(N=z[B]||B,N.match(indexFilter)||v.push([!0,N,g]),T.call(S,g,d,L,$,v,!1)):v.push([S,L,"annotation",g,$]))}),x&&(stableSort$3(v,function($){return $[1].match(/format/g)?-1:1}),isFirefox&&v.reverse(),v.forEach(function($){$[0]===!0?createElement$2(SPAN,{className:PREFIX+"annotation-title"},void 0,$[2]).appendChild(doc$3.createTextNode($[1])):P.apply($[0],$.splice(1))})))}},indicators:{addForm:function(g,d,a){var u,v=this.indicators,x=this.lang,S;g&&(this.tabs.init.call(this,g),u=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content"),this.addColsContainer(u[0]),v.addIndicatorList.call(this,g,u[0],"add"),S=u[0].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(S,x.addButton||"add","add",a,S),this.addColsContainer(u[1]),v.addIndicatorList.call(this,g,u[1],"edit"),S=u[1].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(S,x.saveButton||"save","edit",a,S),this.addButton(S,x.removeButton||"remove","remove",a,S))},addIndicatorList:function(g,d,a){var u=this,v=d.querySelectorAll("."+PREFIX+"popup-lhs-col")[0],x=d.querySelectorAll("."+PREFIX+"popup-rhs-col")[0],S=a==="edit",T=S?g.series:g.options.plotOptions,P=this.indicators.addFormFields,z,L,N;g&&(L=createElement$2(UL,{className:PREFIX+"indicator-list"},null,v),z=x.querySelectorAll("."+PREFIX+"popup-rhs-col-wrapper")[0],objectEach$c(T,function($,B){var U=$.options;if($.params||U&&U.params){var j=u.indicators.getNameType($,B),Y=j.type;N=createElement$2(LI,{className:PREFIX+"indicator-list"},void 0,L),N.appendChild(doc$3.createTextNode(j.name)),["click","touchstart"].forEach(function(q){addEvent$y(N,q,function(){P.call(u,g,S?$:T[Y],j.type,z),S&&$.options&&createElement$2(INPUT,{type:"hidden",name:PREFIX+"id-"+Y,value:$.options.id},null,z).setAttribute(PREFIX+"data-series-id",$.options.id)})})}}),L.childNodes.length>0&&L.childNodes[0].click())},getNameType:function(g,d){var a=g.options,u=H.seriesTypes,v=u[d]&&u[d].prototype.nameBase||d.toUpperCase(),x=d;return a&&a.type&&(x=g.options.type,v=g.name),{name:v,type:x}},listAllSeries:function(g,d,a,u,v){var x=PREFIX+d+"-type-"+g,S=this.lang,T,P;a&&(createElement$2(LABEL,{htmlFor:x},null,u).appendChild(doc$3.createTextNode(S[d]||d)),T=createElement$2(SELECT,{name:x,className:PREFIX+"popup-field"},null,u),T.setAttribute("id",PREFIX+"select-"+d),a.series.forEach(function(z){P=z.options,!P.params&&P.id&&P.id!==PREFIX+"navigator-series"&&createElement$2(OPTION,{value:P.id},null,T).appendChild(doc$3.createTextNode(P.name||P.id))}),defined$m(v)&&(T.value=v))},addFormFields:function(g,d,a,u){var v=d.params||d.options.params,x=this.indicators.getNameType;u.innerHTML="",createElement$2(H3,{className:PREFIX+"indicator-title"},void 0,u).appendChild(doc$3.createTextNode(x(d,a).name)),createElement$2(INPUT,{type:"hidden",name:PREFIX+"type-"+a,value:a},null,u),this.indicators.listAllSeries.call(this,a,"series",g,u,d.linkedParent&&v.volumeSeriesID),v.volumeSeriesID&&this.indicators.listAllSeries.call(this,a,"volume",g,u,d.linkedParent&&d.linkedParent.options.id),this.indicators.addParamInputs.call(this,g,"params",v,a,u)},addParamInputs:function(g,d,a,u,v){var x=this,S=this.indicators.addParamInputs,T=this.addInput,P;g&&objectEach$c(a,function(z,L){P=d+"."+L,z!==void 0&&(isObject$8(z)?(T.call(x,P,u,v,""),S.call(x,g,P,z,u,v)):P!=="params.volumeSeriesID"&&T.call(x,P,u,v,[z,"text"]))})},getAmount:function(){var g=this.series,d=0;return g.forEach(function(a){var u=a.options;(a.params||u&&u.params)&&d++}),d}},tabs:{init:function(g){var d=this.tabs,a=this.indicators.getAmount.call(g),u;g&&(u=d.addMenuItem.call(this,"add"),d.addMenuItem.call(this,"edit",a),d.addContentItem.call(this,"add"),d.addContentItem.call(this,"edit"),d.switchTabs.call(this,a),d.selectTab.call(this,u,0))},addMenuItem:function(g,d){var a=this.popup.container,u=PREFIX+"tab-item",v=this.lang,x;return d===0&&(u+=" "+PREFIX+"tab-disabled"),x=createElement$2(SPAN,{className:u},void 0,a),x.appendChild(doc$3.createTextNode(v[g+"Button"]||g)),x.setAttribute(PREFIX+"data-tab-type",g),x},addContentItem:function(){var g=this.popup.container;return createElement$2(DIV,{className:PREFIX+"tab-item-content "+PREFIX+"no-mousewheel"},null,g)},switchTabs:function(g){var d=this,a=this.popup.container,u=a.querySelectorAll("."+PREFIX+"tab-item"),v;u.forEach(function(x,S){v=x.getAttribute(PREFIX+"data-tab-type"),!(v==="edit"&&g===0)&&["click","touchstart"].forEach(function(T){addEvent$y(x,T,function(){d.tabs.deselectAll.call(d),d.tabs.selectTab.call(d,this,S)})})})},selectTab:function(g,d){var a=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content");g.className+=" "+PREFIX+"tab-item-active",a[d].className+=" "+PREFIX+"tab-item-show"},deselectAll:function(){var g=this.popup.container,d=g.querySelectorAll("."+PREFIX+"tab-item"),a=g.querySelectorAll("."+PREFIX+"tab-item-content"),u;for(u=0;u<d.length;u++)d[u].classList.remove(PREFIX+"tab-item-active"),a[u].classList.remove(PREFIX+"tab-item-show")}}};addEvent$y(NavigationBindings,"showPopup",function(g){this.popup||(this.popup=new H.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/9.2.2/gfx/stock-icons/",this.chart)),this.popup.showForm(g.formType,this.chart,g.options,g.onSubmit)});addEvent$y(NavigationBindings,"closePopup",function(){this.popup&&this.popup.closePopup()});H.Popup;var addEvent$x=Utilities.addEvent,extend$P=Utilities.extend,merge$L=Utilities.merge,pick$Q=Utilities.pick,splat$6=Utilities.splat;Chart$1.prototype.collectionsWithUpdate.push("pane");var Pane=(function(){function g(d,a){this.background=void 0,this.center=void 0,this.chart=void 0,this.options=void 0,this.coll="pane",this.defaultOptions={center:["50%","50%"],size:"85%",innerSize:"0%",startAngle:0},this.defaultBackgroundOptions={shape:"circle",borderWidth:1,borderColor:palette.neutralColor20,backgroundColor:{linearGradient:{x1:0,y1:0,x2:0,y2:1},stops:[[0,palette.backgroundColor],[1,palette.neutralColor10]]},from:-Number.MAX_VALUE,innerRadius:0,to:Number.MAX_VALUE,outerRadius:"105%"},this.init(d,a)}return g.prototype.init=function(d,a){this.chart=a,this.background=[],a.pane.push(this),this.setOptions(d)},g.prototype.setOptions=function(d){this.options=d=merge$L(this.defaultOptions,this.chart.angular?{background:{}}:void 0,d)},g.prototype.render=function(){var d=this.options,a=this.options.background,u=this.chart.renderer,v,x;if(this.group||(this.group=u.g("pane-group").attr({zIndex:d.zIndex||0}).add()),this.updateCenter(),a)for(a=splat$6(a),v=Math.max(a.length,this.background.length||0),x=0;x<v;x++)a[x]&&this.axis?this.renderBackground(merge$L(this.defaultBackgroundOptions,a[x]),x):this.background[x]&&(this.background[x]=this.background[x].destroy(),this.background.splice(x,1))},g.prototype.renderBackground=function(d,a){var u="animate",v={class:"highcharts-pane "+(d.className||"")};this.chart.styledMode||extend$P(v,{fill:d.backgroundColor,stroke:d.borderColor,"stroke-width":d.borderWidth}),this.background[a]||(this.background[a]=this.chart.renderer.path().add(this.group),u="attr"),this.background[a][u]({d:this.axis.getPlotBandPath(d.from,d.to,d)}).attr(v)},g.prototype.updateCenter=function(d){this.center=(d||this.axis||{}).center=centeredSeriesMixin.getCenter.call(this)},g.prototype.update=function(d,a){merge$L(!0,this.options,d),this.setOptions(this.options),this.render(),this.chart.axes.forEach(function(u){u.pane===this&&(u.pane=null,u.update({},a))},this)},g})();function isInsidePane(g,d,a){return Math.sqrt(Math.pow(g-a[0],2)+Math.pow(d-a[1],2))<=a[2]/2}Chart$1.prototype.getHoverPane=function(g){var d=this,a;return g&&d.pane.forEach(function(u){var v=g.chartX-d.plotLeft,x=g.chartY-d.plotTop,S=d.inverted?x:v,T=d.inverted?v:x;isInsidePane(S,T,u.center)&&(a=u)}),a};addEvent$x(Chart$1,"afterIsInsidePlot",function(g){var d=this;d.polar&&(g.isInsidePlot=d.pane.some(function(a){return isInsidePane(g.x,g.y,a.center)}))});addEvent$x(Pointer,"beforeGetHoverData",function(g){var d=this.chart;d.polar?(d.hoverPane=d.getHoverPane(g),g.filter=function(a){return a.visible&&!(!g.shared&&a.directTouch)&&pick$Q(a.options.enableMouseTracking,!0)&&(!d.hoverPane||a.xAxis.pane===d.hoverPane)}):d.hoverPane=void 0});addEvent$x(Pointer,"afterGetHoverData",function(g){var d=this.chart;g.hoverPoint&&g.hoverPoint.plotX&&g.hoverPoint.plotY&&d.hoverPane&&!isInsidePane(g.hoverPoint.plotX,g.hoverPoint.plotY,d.hoverPane.center)&&(g.hoverPoint=void 0)});H.Pane=Pane;const Pane$1=H.Pane;var defaultOptions$7=DefaultOptions.defaultOptions,noop$b=H.noop,addEvent$w=Utilities.addEvent,correctFloat$3=Utilities.correctFloat,defined$l=Utilities.defined,extend$O=Utilities.extend,fireEvent$8=Utilities.fireEvent,merge$K=Utilities.merge,pick$P=Utilities.pick,relativeLength$2=Utilities.relativeLength,wrap$c=Utilities.wrap,RadialAxis;(function(g){var d=[],a={gridLineWidth:1,labels:{align:void 0,distance:15,x:0,y:void 0,style:{textOverflow:"none"}},maxPadding:0,minPadding:0,showLastLabel:!1,tickLength:0},u={labels:{align:"center",x:0,y:void 0},minorGridLineWidth:0,minorTickInterval:"auto",minorTickLength:10,minorTickPosition:"inside",minorTickWidth:1,tickLength:10,tickPosition:"inside",tickWidth:2,title:{rotation:0},zIndex:2},v={gridLineInterpolation:"circle",gridLineWidth:1,labels:{align:"right",x:-3,y:-2},showLastLabel:!1,title:{x:4,text:null,rotation:90}};function x(){this.autoConnect=this.isCircular&&typeof pick$P(this.userMax,this.options.max)>"u"&&correctFloat$3(this.endAngleRad-this.startAngleRad)===correctFloat$3(2*Math.PI),!this.isCircular&&this.chart.inverted&&this.max++,this.autoConnect&&(this.max+=this.categories&&1||this.pointRange||this.closestPointRange||0)}function S(me,xe){return d.indexOf(me)===-1&&(d.push(me),addEvent$w(me,"afterInit",Q),addEvent$w(me,"autoLabelAlign",J),addEvent$w(me,"destroy",ee),addEvent$w(me,"init",ie),addEvent$w(me,"initialAxisTranslation",ne)),d.indexOf(xe)===-1&&(d.push(xe),addEvent$w(xe,"afterGetLabelPosition",ae),addEvent$w(xe,"afterGetPosition",de),wrap$c(xe.prototype,"getMarkPath",_e)),me}g.compose=S;function T(){var me=this;return function(){if(me.isRadial&&me.tickPositions&&me.options.labels&&me.options.labels.allowOverlap!==!0)return me.tickPositions.map(function(xe){return me.ticks[xe]&&me.ticks[xe].label}).filter(function(xe){return!!xe})}}function P(){return noop$b}function z(me,xe,Ce){var Me=this.pane.center,Re=me.value,Ue,$e,Te,De;return this.isCircular?(defined$l(Re)?me.point&&(Ue=me.point.shapeArgs||{},Ue.start&&(Re=this.chart.inverted?this.translate(me.point.rectPlotY,!0):me.point.x)):(Te=me.chartX||0,De=me.chartY||0,Re=this.translate(Math.atan2(De-Ce,Te-xe)-this.startAngleRad,!0)),$e=this.getPosition(Re),Te=$e.x,De=$e.y):(defined$l(Re)||(Te=me.chartX,De=me.chartY),defined$l(Te)&&defined$l(De)&&(Ce=Me[1]+this.chart.plotTop,Re=this.translate(Math.min(Math.sqrt(Math.pow(Te-xe,2)+Math.pow(De-Ce,2)),Me[2]/2)-Me[3]/2,!0))),[Re,Te||0,De||0]}function L(me,xe,Ce){var Me=this.pane.center,Re=this.chart,Ue=this.left||0,$e=this.top||0,Te,De=pick$P(xe,Me[2]/2-this.offset),He;return typeof Ce>"u"&&(Ce=this.horiz?0:this.center&&-this.center[3]/2),Ce&&(De+=Ce),this.isCircular||typeof xe<"u"?(He=this.chart.renderer.symbols.arc(Ue+Me[0],$e+Me[1],De,De,{start:this.startAngleRad,end:this.endAngleRad,open:!0,innerR:0}),He.xBounds=[Ue+Me[0]],He.yBounds=[$e+Me[1]-De]):(Te=this.postTranslate(this.angleRad,De),He=[["M",this.center[0]+Re.plotLeft,this.center[1]+Re.plotTop],["L",Te.x,Te.y]]),He}function N(){var me=this.constructor.prototype;me.getOffset.call(this),this.chart.axisOffset[this.side]=0}function $(me,xe,Ce){var Me=this.chart,Re=function(qt){if(typeof qt=="string"){var ti=parseInt(qt,10);return it.test(qt)&&(ti=ti*Te/100),ti}return qt},Ue=this.center,$e=this.startAngleRad,Te=Ue[2]/2,De=Math.min(this.offset,0),He=this.left||0,Le=this.top||0,it=/%$/,pt=this.isCircular,nt,at,ct,ft,Lt,xt,St=pick$P(Re(Ce.outerRadius),Te),wt=Re(Ce.innerRadius),Ut=pick$P(Re(Ce.thickness),10);if(this.options.gridLineInterpolation==="polygon")xt=this.getPlotLinePath({value:me}).concat(this.getPlotLinePath({value:xe,reverse:!0}));else{me=Math.max(me,this.min),xe=Math.min(xe,this.max);var Et=this.translate(me),ni=this.translate(xe);pt||(St=Et||0,wt=ni||0),Ce.shape==="circle"||!pt?(nt=-Math.PI/2,at=Math.PI*1.5,Lt=!0):(nt=$e+(Et||0),at=$e+(ni||0)),St-=De,Ut-=De,xt=Me.renderer.symbols.arc(He+Ue[0],Le+Ue[1],St,St,{start:Math.min(nt,at),end:Math.max(nt,at),innerR:pick$P(wt,St-Ut),open:Lt}),pt&&(ct=(at+nt)/2,ft=He+Ue[0]+Ue[2]/2*Math.cos(ct),xt.xBounds=ct>-Math.PI/2&&ct<Math.PI/2?[ft,Me.plotWidth]:[0,ft],xt.yBounds=[Le+Ue[1]+Ue[2]/2*Math.sin(ct)],xt.yBounds[0]+=ct>-Math.PI&&ct<0||ct>Math.PI?-10:10)}return xt}function B(me){var xe=this,Ce=this.pane.center,Me=this.chart,Re=Me.inverted,Ue=me.reverse,$e=this.pane.options.background?this.pane.options.background[0]||this.pane.options.background:{},Te=$e.innerRadius||"0%",De=$e.outerRadius||"100%",He=Ce[0]+Me.plotLeft,Le=Ce[1]+Me.plotTop,it=this.height,pt=me.isCrosshair,nt=Ce[3]/2,at=me.value,ct,ft,Lt,xt,St,wt,Ut,Et,ni,qt=this.getPosition(at),ti=qt.x,ci=qt.y;if(pt&&(Et=this.getCrosshairPosition(me,He,Le),at=Et[0],ti=Et[1],ci=Et[2]),this.isCircular)ft=Math.sqrt(Math.pow(ti-He,2)+Math.pow(ci-Le,2)),Lt=typeof Te=="string"?relativeLength$2(Te,1):Te/ft,xt=typeof De=="string"?relativeLength$2(De,1):De/ft,Ce&&nt&&(ct=nt/ft,Lt<ct&&(Lt=ct),xt<ct&&(xt=ct)),ni=[["M",He+Lt*(ti-He),Le-Lt*(Le-ci)],["L",ti-(1-xt)*(ti-He),ci+(1-xt)*(Le-ci)]];else if(at=this.translate(at),at&&(at<0||at>it)&&(at=0),this.options.gridLineInterpolation==="circle")ni=this.getLinePath(0,at,nt);else if(ni=[],Me[Re?"yAxis":"xAxis"].forEach(function(di){di.pane===xe.pane&&(St=di)}),St){Ut=St.tickPositions,St.autoConnect&&(Ut=Ut.concat([Ut[0]])),Ue&&(Ut=Ut.slice().reverse()),at&&(at+=nt);for(var st=0;st<Ut.length;st++)wt=St.getPosition(Ut[st],at),ni.push(st?["L",wt.x,wt.y]:["M",wt.x,wt.y])}return ni}function U(me,xe){var Ce=this.translate(me);return this.postTranslate(this.isCircular?Ce:this.angleRad,pick$P(this.isCircular?xe:Ce<0?0:Ce,this.center[2]/2)-this.offset)}function j(){var me=this.center,xe=this.chart,Ce=this.options.title;return{x:xe.plotLeft+me[0]+(Ce.x||0),y:xe.plotTop+me[1]-{high:.5,middle:.25,low:0}[Ce.align]*me[2]+(Ce.y||0)}}function Y(me){me.beforeSetTickPositions=x,me.createLabelCollector=T,me.getCrosshairPosition=z,me.getLinePath=L,me.getOffset=N,me.getPlotBandPath=$,me.getPlotLinePath=B,me.getPosition=U,me.getTitlePosition=j,me.postTranslate=he,me.setAxisSize=ve,me.setAxisTranslation=be,me.setOptions=ge}function q(me){me.isHidden=!0,me.createLabelCollector=P,me.getOffset=noop$b,me.redraw=pe,me.render=pe,me.setScale=noop$b,me.setCategories=noop$b,me.setTitle=noop$b}function Q(){var me=this.chart,xe=this.options,Ce=me.angular&&this.isXAxis,Me=this.pane,Re=Me&&Me.options;!Ce&&Me&&(me.angular||me.polar)&&(this.angleRad=(xe.angle||0)*Math.PI/180,this.startAngleRad=(Re.startAngle-90)*Math.PI/180,this.endAngleRad=(pick$P(Re.endAngle,Re.startAngle+360)-90)*Math.PI/180,this.offset=xe.offset||0)}function J(me){this.isRadial&&(me.align=void 0,me.preventDefault())}function ee(){if(this.chart&&this.chart.labelCollectors){var me=this.labelCollector?this.chart.labelCollectors.indexOf(this.labelCollector):-1;me>=0&&this.chart.labelCollectors.splice(me,1)}}function ie(me){var xe=this.chart,Ce=xe.inverted,Me=xe.angular,Re=xe.polar,Ue=this.isXAxis,$e=this.coll,Te=Me&&Ue,De=xe.options,He=me.userOptions.pane||0,Le=this.pane=xe.pane&&xe.pane[He],it;if($e==="colorAxis"){this.isRadial=!1;return}Me?(Te?q(this):Y(this),it=!Ue,it&&(this.defaultPolarOptions=u)):Re&&(Y(this),it=this.horiz,this.defaultPolarOptions=it?a:merge$K($e==="xAxis"?AxisDefaults$1.defaultXAxisOptions:AxisDefaults$1.defaultYAxisOptions,v),Ce&&$e==="yAxis"&&(this.defaultPolarOptions.stackLabels=AxisDefaults$1.defaultYAxisOptions.stackLabels,this.defaultPolarOptions.reversedStacks=!0)),Me||Re?(this.isRadial=!0,De.chart.zoomType=null,this.labelCollector||(this.labelCollector=this.createLabelCollector()),this.labelCollector&&xe.labelCollectors.push(this.labelCollector)):this.isRadial=!1,Le&&it&&(Le.axis=this),this.isCircular=it}function ne(){this.isRadial&&this.beforeSetTickPositions()}function ae(me){var xe=this.label;if(xe){var Ce=this.axis,Me=xe.getBBox(),Re=Ce.options.labels,Ue=(Ce.translate(this.pos)+Ce.startAngleRad+Math.PI/2)/Math.PI*180%360,$e=Math.round(Ue),Te=defined$l(Re.y)?0:-Me.height*.3,De=Re.y,He,Le=20,it=Re.align,pt="end",nt=$e<0?$e+360:$e,at=nt,ct=0,ft=0;Ce.isRadial&&(He=Ce.getPosition(this.pos,Ce.center[2]/2+relativeLength$2(pick$P(Re.distance,-25),Ce.center[2]/2,-Ce.center[2]/2)),Re.rotation==="auto"?xe.attr({rotation:Ue}):defined$l(De)||(De=Ce.chart.renderer.fontMetrics(xe.styles&&xe.styles.fontSize).b-Me.height/2),defined$l(it)||(Ce.isCircular?(Me.width>Ce.len*Ce.tickInterval/(Ce.max-Ce.min)&&(Le=0),Ue>Le&&Ue<180-Le?it="left":Ue>180+Le&&Ue<360-Le?it="right":it="center"):it="center",xe.attr({align:it})),it==="auto"&&Ce.tickPositions.length===2&&Ce.isCircular&&(nt>90&&nt<180?nt=180-nt:nt>270&&nt<=360&&(nt=540-nt),at>180&&at<=360&&(at=360-at),(Ce.pane.options.startAngle===$e||Ce.pane.options.startAngle===$e+360||Ce.pane.options.startAngle===$e-360)&&(pt="start"),$e>=-90&&$e<=90||$e>=-360&&$e<=-270||$e>=270&&$e<=360?it=pt==="start"?"right":"left":it=pt==="start"?"left":"right",at>70&&at<110&&(it="center"),nt<15||nt>=180&&nt<195?ct=Me.height*.3:nt>=15&&nt<=35?ct=pt==="start"?0:Me.height*.75:nt>=195&&nt<=215?ct=pt==="start"?Me.height*.75:0:nt>35&&nt<=90?ct=pt==="start"?-Me.height*.25:Me.height:nt>215&&nt<=270&&(ct=pt==="start"?Me.height:-Me.height*.25),at<15?ft=pt==="start"?-Me.height*.15:Me.height*.15:at>165&&at<=180&&(ft=pt==="start"?Me.height*.15:-Me.height*.15),xe.attr({align:it}),xe.translate(ft,ct+Te)),me.pos.x=He.x+(Re.x||0),me.pos.y=He.y+(De||0))}}function de(me){this.axis.getPosition&&extend$O(me.pos,this.axis.getPosition(this.pos))}function he(me,xe){var Ce=this.chart,Me=this.center;return me=this.startAngleRad+me,{x:Ce.plotLeft+Me[0]+Math.cos(me)*xe,y:Ce.plotTop+Me[1]+Math.sin(me)*xe}}function pe(){this.isDirty=!1}function ve(){var me=this.constructor.prototype,xe,Ce;me.setAxisSize.call(this),this.isRadial&&(this.pane.updateCenter(this),xe=this.center=this.pane.center.slice(),this.isCircular?this.sector=this.endAngleRad-this.startAngleRad:(Ce=this.postTranslate(this.angleRad,xe[3]/2),xe[0]=Ce.x-this.chart.plotLeft,xe[1]=Ce.y-this.chart.plotTop),this.len=this.width=this.height=(xe[2]-xe[3])*pick$P(this.sector,1)/2)}function be(){var me=this.constructor.prototype;me.setAxisTranslation.call(this),this.center&&(this.isCircular?this.transA=(this.endAngleRad-this.startAngleRad)/(this.max-this.min||1):this.transA=(this.center[2]-this.center[3])/2/(this.max-this.min||1),this.isXAxis?this.minPixelPadding=this.transA*this.minPointOffset:this.minPixelPadding=0)}function ge(me){var xe=this.options=merge$K(this.constructor.defaultOptions,this.defaultPolarOptions,defaultOptions$7[this.coll],me);xe.plotBands||(xe.plotBands=[]),fireEvent$8(this,"afterSetOptions")}function _e(me,xe,Ce,Me,Re,Ue,$e){var Te=this.axis,De,He;return Te.isRadial?(De=Te.getPosition(this.pos,Te.center[2]/2+Me),He=["M",xe,Ce,"L",De.x,De.y]):He=me.call(this,xe,Ce,Me,Re,Ue,$e),He}})(RadialAxis||(RadialAxis={}));const RadialAxis$1=RadialAxis;var __extends$1_=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),pointProto=Point$4.prototype,defined$k=Utilities.defined,isNumber$o=Utilities.isNumber,AreaRangePoint$1=(function(g){__extends$1_(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.high=void 0,a.low=void 0,a.options=void 0,a.plotHigh=void 0,a.plotLow=void 0,a.plotHighX=void 0,a.plotLowX=void 0,a.plotX=void 0,a.series=void 0,a}return d.prototype.setState=function(){var a=this.state,u=this.series,v=u.chart.polar;defined$k(this.plotHigh)||(this.plotHigh=u.yAxis.toPixels(this.high,!0)),defined$k(this.plotLow)||(this.plotLow=this.plotY=u.yAxis.toPixels(this.low,!0)),u.stateMarkerGraphic&&(u.lowerStateMarkerGraphic=u.stateMarkerGraphic,u.stateMarkerGraphic=u.upperStateMarkerGraphic),this.graphic=this.upperGraphic,this.plotY=this.plotHigh,v&&(this.plotX=this.plotHighX),pointProto.setState.apply(this,arguments),this.state=a,this.plotY=this.plotLow,this.graphic=this.lowerGraphic,v&&(this.plotX=this.plotLowX),u.stateMarkerGraphic&&(u.upperStateMarkerGraphic=u.stateMarkerGraphic,u.stateMarkerGraphic=u.lowerStateMarkerGraphic,u.lowerStateMarkerGraphic=void 0),pointProto.setState.apply(this,arguments)},d.prototype.haloPath=function(){var a=this.series.chart.polar,u=[];return this.plotY=this.plotLow,a&&(this.plotX=this.plotLowX),this.isInside&&(u=pointProto.haloPath.apply(this,arguments)),this.plotY=this.plotHigh,a&&(this.plotX=this.plotHighX),this.isTopInside&&(u=u.concat(pointProto.haloPath.apply(this,arguments))),u},d.prototype.isValid=function(){return isNumber$o(this.low)&&isNumber$o(this.high)},d})(AreaSeries$1.prototype.pointClass),__extends$1Z=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),areaProto=AreaSeries$1.prototype,columnProto$4=ColumnSeries$h.prototype,noop$a=H.noop,seriesProto$1=Series$f.prototype,defined$j=Utilities.defined,extend$N=Utilities.extend,isArray$8=Utilities.isArray,pick$O=Utilities.pick,merge$J=Utilities.merge,AreaRangeSeries$2=(function(g){__extends$1Z(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a.lowerStateMarkerGraphic=void 0,a.xAxis=void 0,a}return d.prototype.toYData=function(a){return[a.low,a.high]},d.prototype.highToXY=function(a){var u=this.chart,v=this.xAxis.postTranslate(a.rectPlotX||0,this.yAxis.len-a.plotHigh);a.plotHighX=v.x-u.plotLeft,a.plotHigh=v.y-u.plotTop,a.plotLowX=a.plotX},d.prototype.translate=function(){var a=this,u=a.yAxis,v=!!a.modifyValue;areaProto.translate.apply(a),a.points.forEach(function(x){var S=x.high,T=x.plotY;x.isNull?x.plotY=null:(x.plotLow=T,x.plotHigh=u.translate(v?a.modifyValue(S,x):S,0,1,0,1),v&&(x.yBottom=x.plotHigh))}),this.chart.polar&&this.points.forEach(function(x){a.highToXY(x),x.tooltipPos=[(x.plotHighX+x.plotLowX)/2,(x.plotHigh+x.plotLow)/2]})},d.prototype.getGraphPath=function(a){var u=[],v=[],x,S=areaProto.getGraphPath,T,P,z,L,N=this.options,$=this.chart.polar,B=$&&N.connectEnds!==!1,U=N.connectNulls,j=N.step,Y,q;for(a=a||this.points,x=a.length;x--;){T=a[x];var Q=$?{plotX:T.rectPlotX,plotY:T.yBottom,doCurve:!1}:{plotX:T.plotX,plotY:T.plotY,doCurve:!1};!T.isNull&&!B&&!U&&(!a[x+1]||a[x+1].isNull)&&v.push(Q),P={polarPlotY:T.polarPlotY,rectPlotX:T.rectPlotX,yBottom:T.yBottom,plotX:pick$O(T.plotHighX,T.plotX),plotY:T.plotHigh,isNull:T.isNull},v.push(P),u.push(P),!T.isNull&&!B&&!U&&(!a[x-1]||a[x-1].isNull)&&v.push(Q)}return L=S.call(this,a),j&&(j===!0&&(j="left"),N.step={left:"right",center:"center",right:"left"}[j]),Y=S.call(this,u),q=S.call(this,v),N.step=j,z=[].concat(L,Y),!this.chart.polar&&q[0]&&q[0][0]==="M"&&(q[0]=["L",q[0][1],q[0][2]]),this.graphPath=z,this.areaPath=L.concat(q),z.isArea=!0,z.xMap=L.xMap,this.areaPath.xMap=L.xMap,z},d.prototype.drawDataLabels=function(){var a=this.points,u=a.length,v,x=[],S=this.options.dataLabels,T,P,z=this.chart.inverted,L,N;if(S){if(isArray$8(S)?(L=S[0]||{enabled:!1},N=S[1]||{enabled:!1}):(L=extend$N({},S),L.x=S.xHigh,L.y=S.yHigh,N=extend$N({},S),N.x=S.xLow,N.y=S.yLow),L.enabled||this._hasPointLabels){for(v=u;v--;)T=a[v],T&&(P=L.inside?T.plotHigh<T.plotLow:T.plotHigh>T.plotLow,T.y=T.high,T._plotY=T.plotY,T.plotY=T.plotHigh,x[v]=T.dataLabel,T.dataLabel=T.dataLabelUpper,T.below=P,z?L.align||(L.align=P?"right":"left"):L.verticalAlign||(L.verticalAlign=P?"top":"bottom"));for(this.options.dataLabels=L,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments),v=u;v--;)T=a[v],T&&(T.dataLabelUpper=T.dataLabel,T.dataLabel=x[v],delete T.dataLabels,T.y=T.low,T.plotY=T._plotY)}if(N.enabled||this._hasPointLabels){for(v=u;v--;)T=a[v],T&&(P=N.inside?T.plotHigh<T.plotLow:T.plotHigh>T.plotLow,T.below=!P,z?N.align||(N.align=P?"left":"right"):N.verticalAlign||(N.verticalAlign=P?"bottom":"top"));this.options.dataLabels=N,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments)}if(L.enabled)for(v=u;v--;)T=a[v],T&&(T.dataLabels=[T.dataLabelUpper,T.dataLabel].filter(function($){return!!$}));this.options.dataLabels=S}},d.prototype.alignDataLabel=function(){columnProto$4.alignDataLabel.apply(this,arguments)},d.prototype.drawPoints=function(){var a=this,u=a.points.length,v,x;for(seriesProto$1.drawPoints.apply(a,arguments),x=0;x<u;)v=a.points[x],v.origProps={plotY:v.plotY,plotX:v.plotX,isInside:v.isInside,negative:v.negative,zone:v.zone,y:v.y},v.lowerGraphic=v.graphic,v.graphic=v.upperGraphic,v.plotY=v.plotHigh,defined$j(v.plotHighX)&&(v.plotX=v.plotHighX),v.y=pick$O(v.high,v.origProps.y),v.negative=v.y<(a.options.threshold||0),a.zones.length&&(v.zone=v.getZone()),a.chart.polar||(v.isInside=v.isTopInside=typeof v.plotY<"u"&&v.plotY>=0&&v.plotY<=a.yAxis.len&&v.plotX>=0&&v.plotX<=a.xAxis.len),x++;for(seriesProto$1.drawPoints.apply(a,arguments),x=0;x<u;)v=a.points[x],v.upperGraphic=v.graphic,v.graphic=v.lowerGraphic,v.origProps&&(extend$N(v,v.origProps),delete v.origProps),x++},d.defaultOptions=merge$J(AreaSeries$1.defaultOptions,{lineWidth:1,threshold:null,tooltip:{pointFormat:'<span style="color:{series.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},trackByArea:!0,dataLabels:{align:void 0,verticalAlign:void 0,xLow:0,xHigh:0,yLow:0,yHigh:0}}),d})(AreaSeries$1);extend$N(AreaRangeSeries$2.prototype,{pointArrayMap:["low","high"],pointValKey:"low",deferTranslatePolar:!0,pointClass:AreaRangePoint$1,setStackedPoints:noop$a});SeriesRegistry$1.registerSeriesType("arearange",AreaRangeSeries$2);var __extends$1Y=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),SplineSeries=SeriesRegistry$1.seriesTypes.spline,merge$I=Utilities.merge,extend$M=Utilities.extend,AreaSplineRangeSeries=(function(g){__extends$1Y(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.options=void 0,a.data=void 0,a.points=void 0,a}return d.defaultOptions=merge$I(AreaRangeSeries$2.defaultOptions),d})(AreaRangeSeries$2);extend$M(AreaSplineRangeSeries.prototype,{getPointSpline:SplineSeries.prototype.getPointSpline});SeriesRegistry$1.registerSeriesType("areasplinerange",AreaSplineRangeSeries);var __extends$1X=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),noop$9=H.noop,extend$L=Utilities.extend,merge$H=Utilities.merge,pick$N=Utilities.pick,BoxPlotSeries=(function(g){__extends$1X(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.pointAttribs=function(){return{}},d.prototype.translate=function(){var a=this,u=a.yAxis,v=a.pointArrayMap;g.prototype.translate.apply(a),a.points.forEach(function(x){v.forEach(function(S){x[S]!==null&&(x[S+"Plot"]=u.translate(x[S],0,1,0,1))}),x.plotHigh=x.highPlot})},d.prototype.drawPoints=function(){var a=this,u=a.points,v=a.options,x=a.chart,S=x.renderer,T,P,z,L,N,$,B,U=0,j,Y,q,Q,J,ee=a.doQuartiles!==!1,ie,ne=a.options.whiskerLength;u.forEach(function(ae){var de=ae.graphic,he=de?"animate":"attr",pe=ae.shapeArgs,ve={},be={},ge={},_e={},me=ae.color||a.color;if(typeof ae.plotY<"u"){Y=Math.round(pe.width),q=Math.floor(pe.x),Q=q+Y,J=Math.round(Y/2),T=Math.floor(ee?ae.q1Plot:ae.lowPlot),P=Math.floor(ee?ae.q3Plot:ae.lowPlot),z=Math.floor(ae.highPlot),L=Math.floor(ae.lowPlot),de||(ae.graphic=de=S.g("point").add(a.group),ae.stem=S.path().addClass("highcharts-boxplot-stem").add(de),ne&&(ae.whiskers=S.path().addClass("highcharts-boxplot-whisker").add(de)),ee&&(ae.box=S.path(j).addClass("highcharts-boxplot-box").add(de)),ae.medianShape=S.path($).addClass("highcharts-boxplot-median").add(de)),x.styledMode||(be.stroke=ae.stemColor||v.stemColor||me,be["stroke-width"]=pick$N(ae.stemWidth,v.stemWidth,v.lineWidth),be.dashstyle=ae.stemDashStyle||v.stemDashStyle||v.dashStyle,ae.stem.attr(be),ne&&(ge.stroke=ae.whiskerColor||v.whiskerColor||me,ge["stroke-width"]=pick$N(ae.whiskerWidth,v.whiskerWidth,v.lineWidth),ge.dashstyle=ae.whiskerDashStyle||v.whiskerDashStyle||v.dashStyle,ae.whiskers.attr(ge)),ee&&(ve.fill=ae.fillColor||v.fillColor||me,ve.stroke=v.lineColor||me,ve["stroke-width"]=v.lineWidth||0,ve.dashstyle=ae.boxDashStyle||v.boxDashStyle||v.dashStyle,ae.box.attr(ve)),_e.stroke=ae.medianColor||v.medianColor||me,_e["stroke-width"]=pick$N(ae.medianWidth,v.medianWidth,v.lineWidth),_e.dashstyle=ae.medianDashStyle||v.medianDashStyle||v.dashStyle,ae.medianShape.attr(_e));var xe=void 0;B=ae.stem.strokeWidth()%2/2,U=q+J+B,xe=[["M",U,P],["L",U,z],["M",U,T],["L",U,L]],ae.stem[he]({d:xe}),ee&&(B=ae.box.strokeWidth()%2/2,T=Math.floor(T)+B,P=Math.floor(P)+B,q+=B,Q+=B,xe=[["M",q,P],["L",q,T],["L",Q,T],["L",Q,P],["L",q,P],["Z"]],ae.box[he]({d:xe})),ne&&(B=ae.whiskers.strokeWidth()%2/2,z=z+B,L=L+B,ie=/%$/.test(ne)?J*parseFloat(ne)/100:ne/2,xe=[["M",U-ie,z],["L",U+ie,z],["M",U-ie,L],["L",U+ie,L]],ae.whiskers[he]({d:xe})),N=Math.round(ae.medianPlot),B=ae.medianShape.strokeWidth()%2/2,N=N+B,xe=[["M",q,N],["L",Q,N]],ae.medianShape[he]({d:xe})}})},d.prototype.toYData=function(a){return[a.low,a.q1,a.median,a.q3,a.high]},d.defaultOptions=merge$H(ColumnSeries$h.defaultOptions,{threshold:null,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Maximum: {point.high}<br/>Upper quartile: {point.q3}<br/>Median: {point.median}<br/>Lower quartile: {point.q1}<br/>Minimum: {point.low}<br/>'},whiskerLength:"50%",fillColor:palette.backgroundColor,lineWidth:1,medianWidth:2,whiskerWidth:2}),d})(ColumnSeries$h);extend$L(BoxPlotSeries.prototype,{pointArrayMap:["low","q1","median","q3","high"],pointValKey:"high",drawDataLabels:noop$9,setStackedPoints:noop$9});SeriesRegistry$1.registerSeriesType("boxplot",BoxPlotSeries);var BubbleLegendDefaults={borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:"10px",color:palette.neutralColor100},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0},color$a=Color.parse,noop$8=H.noop,arrayMax$3=Utilities.arrayMax,arrayMin$3=Utilities.arrayMin,isNumber$n=Utilities.isNumber,merge$G=Utilities.merge,pick$M=Utilities.pick,stableSort$2=Utilities.stableSort,BubbleLegendItem=(function(){function g(d,a){this.chart=void 0,this.fontMetrics=void 0,this.legend=void 0,this.legendGroup=void 0,this.legendItem=void 0,this.legendItemHeight=void 0,this.legendItemWidth=void 0,this.legendSymbol=void 0,this.maxLabel=void 0,this.movementX=void 0,this.ranges=void 0,this.selected=void 0,this.visible=void 0,this.symbols=void 0,this.options=void 0,this.setState=noop$8,this.init(d,a)}return g.prototype.init=function(d,a){this.options=d,this.visible=!0,this.chart=a.chart,this.legend=a},g.prototype.addToLegend=function(d){d.splice(this.options.legendIndex,0,this)},g.prototype.drawLegendSymbol=function(d){var a=this.chart,u=this.options,v=pick$M(d.options.itemDistance,20),x=u.ranges,S=u.connectorDistance,T;if(this.fontMetrics=a.renderer.fontMetrics(u.labels.style.fontSize),!x||!x.length||!isNumber$n(x[0].value)){d.options.bubbleLegend.autoRanges=!0;return}stableSort$2(x,function(N,$){return $.value-N.value}),this.ranges=x,this.setOptions(),this.render();var P=this.getMaxLabelSize(),z=this.ranges[0].radius,L=z*2;T=S-z+P.width,T=T>0?T:0,this.maxLabel=P,this.movementX=u.labels.align==="left"?T:0,this.legendItemWidth=L+T+v,this.legendItemHeight=L+this.fontMetrics.h/2},g.prototype.setOptions=function(){var d=this.ranges,a=this.options,u=this.chart.series[a.seriesIndex],v=this.legend.baseline,x={zIndex:a.zIndex,"stroke-width":a.borderWidth},S={zIndex:a.zIndex,"stroke-width":a.connectorWidth},T={align:this.legend.options.rtl||a.labels.align==="left"?"right":"left",zIndex:a.zIndex},P=u.options.marker.fillOpacity,z=this.chart.styledMode;d.forEach(function(L,N){z||(x.stroke=pick$M(L.borderColor,a.borderColor,u.color),x.fill=pick$M(L.color,a.color,P!==1?color$a(u.color).setOpacity(P).get("rgba"):u.color),S.stroke=pick$M(L.connectorColor,a.connectorColor,u.color)),d[N].radius=this.getRangeRadius(L.value),d[N]=merge$G(d[N],{center:d[0].radius-d[N].radius+v}),z||merge$G(!0,d[N],{bubbleAttribs:merge$G(x),connectorAttribs:merge$G(S),labelAttribs:T})},this)},g.prototype.getRangeRadius=function(d){var a=this.options,u=this.options.seriesIndex,v=this.chart.series[u],x=a.ranges[0].value,S=a.ranges[a.ranges.length-1].value,T=a.minSize,P=a.maxSize;return v.getRadius.call(this,S,x,T,P,d)},g.prototype.render=function(){var d=this.chart.renderer,a=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]}),this.legendSymbol=d.g("bubble-legend"),this.legendItem=d.g("bubble-legend-item"),this.legendSymbol.translateX=0,this.legendSymbol.translateY=0,this.ranges.forEach(function(u){u.value>=a&&this.renderRange(u)},this),this.legendSymbol.add(this.legendItem),this.legendItem.add(this.legendGroup),this.hideOverlappingLabels()},g.prototype.renderRange=function(d){var a=this.ranges[0],u=this.legend,v=this.options,x=v.labels,S=this.chart,T=S.series[v.seriesIndex],P=S.renderer,z=this.symbols,L=z.labels,N=d.center,$=Math.abs(d.radius),B=v.connectorDistance||0,U=x.align,j=u.options.rtl,Y=v.borderWidth,q=v.connectorWidth,Q=a.radius||0,J=N-$-Y/2+q/2,ee=this.fontMetrics,ie=ee.f/2-(ee.h-ee.f)/2,ne=(J%1?1:.5)-(q%2?0:.5),ae=P.styledMode,de=j||U==="left"?-B:B;U==="center"&&(de=0,v.connectorDistance=0,d.labelAttribs.align="center");var he=J+v.labels.y,pe=Q+de+v.labels.x;z.bubbleItems.push(P.circle(Q,N+ne,$).attr(ae?{}:d.bubbleAttribs).addClass((ae?"highcharts-color-"+T.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(v.className||"")).add(this.legendSymbol)),z.connectors.push(P.path(P.crispLine([["M",Q,J],["L",Q+de,J]],v.connectorWidth)).attr(ae?{}:d.connectorAttribs).addClass((ae?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(v.connectorClassName||"")).add(this.legendSymbol));var ve=P.text(this.formatLabel(d),pe,he+ie).attr(ae?{}:d.labelAttribs).css(ae?{}:x.style).addClass("highcharts-bubble-legend-labels "+(v.labels.className||"")).add(this.legendSymbol);L.push(ve),ve.placed=!0,ve.alignAttr={x:pe,y:he+ie}},g.prototype.getMaxLabelSize=function(){var d=this.symbols.labels,a,u;return d.forEach(function(v){u=v.getBBox(!0),a?a=u.width>a.width?u:a:a=u}),a||{}},g.prototype.formatLabel=function(d){var a=this.options,u=a.labels.formatter,v=a.labels.format,x=this.chart.numberFormatter;return v?FormatUtilities.format(v,d):u?u.call(d):x(d.value,1)},g.prototype.hideOverlappingLabels=function(){var d=this.chart,a=this.options.labels.allowOverlap,u=this.symbols;!a&&u&&(d.hideOverlappingLabels(u.labels),u.labels.forEach(function(v,x){v.newOpacity?v.newOpacity!==v.oldOpacity&&u.connectors[x].show():u.connectors[x].hide()}))},g.prototype.getRanges=function(){var d=this.legend.bubbleLegend,a=d.chart.series,u=d.options.ranges,v,x,S=Number.MAX_VALUE,T=-Number.MAX_VALUE;return a.forEach(function(P){P.isBubble&&!P.ignoreSeries&&(x=P.zData.filter(isNumber$n),x.length&&(S=pick$M(P.options.zMin,Math.min(S,Math.max(arrayMin$3(x),P.options.displayNegative===!1?P.options.zThreshold:-Number.MAX_VALUE))),T=pick$M(P.options.zMax,Math.max(T,arrayMax$3(x)))))}),S===T?v=[{value:T}]:v=[{value:S},{value:(S+T)/2},{value:T,autoRanges:!0}],u.length&&u[0].radius&&v.reverse(),v.forEach(function(P,z){u&&u[z]&&(v[z]=merge$G(u[z],P))}),v},g.prototype.predictBubbleSizes=function(){var d=this.chart,a=this.fontMetrics,u=d.legend.options,v=u.floating,x=u.layout==="horizontal",S=x?d.legend.lastLineHeight:0,T=d.plotSizeX,P=d.plotSizeY,z=d.series[this.options.seriesIndex],L=Math.ceil(z.minPxSize),N=Math.ceil(z.maxPxSize),$=Math.min(P,T),B,U=z.options.maxSize;return v||!/%$/.test(U)?B=N:(U=parseFloat(U),B=($+S-a.h/2)*U/100/(U/100+1),(x&&P-B>=T||!x&&T-B>=P)&&(B=N)),[L,Math.ceil(B)]},g.prototype.updateRanges=function(d,a){var u=this.legend.options.bubbleLegend;u.minSize=d,u.maxSize=a,u.ranges=this.getRanges()},g.prototype.correctSizes=function(){var d=this.legend,a=this.chart,u=a.series[this.options.seriesIndex],v=u.maxPxSize,x=this.options.maxSize;Math.abs(Math.ceil(v)-x)>1&&(this.updateRanges(this.options.minSize,u.maxPxSize),d.render())},g})(),setOptions=DefaultOptions.setOptions,addEvent$v=Utilities.addEvent,objectEach$b=Utilities.objectEach,wrap$b=Utilities.wrap,BubbleLegendComposition;(function(g){var d=[];function a(z,L,N){var $=this,B=$.legend,U=v($)>=0,j,Y;B&&B.options.enabled&&B.bubbleLegend&&B.options.bubbleLegend.autoRanges&&U?(j=B.bubbleLegend.options,Y=B.bubbleLegend.predictBubbleSizes(),B.bubbleLegend.updateRanges(Y[0],Y[1]),j.placed||(B.group.placed=!1,B.allItems.forEach(function(q){q.legendGroup.translateY=null})),B.render(),$.getMargins(),$.axes.forEach(function(q){q.visible&&q.render(),j.placed||(q.setScale(),q.updateNames(),objectEach$b(q.ticks,function(Q){Q.isNew=!0,Q.isNewLabel=!0}))}),j.placed=!0,$.getMargins(),z.call($,L,N),B.bubbleLegend.correctSizes(),P(B,x(B))):(z.call($,L,N),B&&B.options.enabled&&B.bubbleLegend&&(B.render(),P(B,x(B))))}function u(z,L,N){d.indexOf(z)===-1&&(d.push(z),setOptions({legend:{bubbleLegend:BubbleLegendDefaults}}),wrap$b(z.prototype,"drawChartBox",a)),d.indexOf(L)===-1&&(d.push(L),addEvent$v(L,"afterGetAllItems",S)),d.indexOf(N)===-1&&(d.push(N),addEvent$v(N,"legendItemClick",T))}g.compose=u;function v(z){for(var L=z.series,N=0;N<L.length;){if(L[N]&&L[N].isBubble&&L[N].visible&&L[N].zData.length)return N;N++}return-1}function x(z){var L=z.allItems,N=[],$=L.length,B,U=0,j=0;for(U=0;U<$;U++)if(L[U].legendItemHeight&&(L[U].itemHeight=L[U].legendItemHeight),L[U]===L[$-1]||L[U+1]&&L[U]._legendItemPos[1]!==L[U+1]._legendItemPos[1]){for(N.push({height:0}),B=N[N.length-1],j;j<=U;j++)L[j].itemHeight>B.height&&(B.height=L[j].itemHeight);B.step=U}return N}function S(z){var L=this,N=L.bubbleLegend,$=L.options,B=$.bubbleLegend,U=v(L.chart);N&&N.ranges&&N.ranges.length&&(B.ranges.length&&(B.autoRanges=!!B.ranges[0].autoRanges),L.destroyItem(N)),U>=0&&$.enabled&&B.enabled&&(B.seriesIndex=U,L.bubbleLegend=new BubbleLegendItem(B,L),L.bubbleLegend.addToLegend(z.allItems))}function T(){var z=this,L=z.chart,N=z.visible,$=z.chart.legend,B;$&&$.bubbleLegend&&(z.visible=!N,z.ignoreSeries=N,B=v(L)>=0,$.bubbleLegend.visible!==B&&($.update({bubbleLegend:{enabled:B}}),$.bubbleLegend.visible=B),z.visible=N)}function P(z,L){var N=z.allItems,$=z.options.rtl,B,U,j,Y=0;N.forEach(function(q,Q){B=q.legendGroup.translateX,U=q._legendItemPos[1],j=q.movementX,(j||$&&q.ranges)&&(j=$?B-q.options.maxSize/2:B+j,q.legendGroup.attr({translateX:j})),Q>L[Y].step&&Y++,q.legendGroup.attr({translateY:Math.round(U+L[Y].height/2)}),q._legendItemPos[1]=U+L[Y].height/2})}})(BubbleLegendComposition||(BubbleLegendComposition={}));const BubbleLegendComposition$1=BubbleLegendComposition;var __extends$1W=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),ScatterPoint$2=SeriesRegistry$1.seriesTypes.scatter.prototype.pointClass,extend$K=Utilities.extend,BubblePoint=(function(g){__extends$1W(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.options=void 0,a.series=void 0,a}return d.prototype.haloPath=function(a){return Point$4.prototype.haloPath.call(this,a===0?0:(this.marker&&this.marker.radius||0)+a)},d})(ScatterPoint$2);extend$K(BubblePoint.prototype,{ttBelow:!1});var __extends$1V=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),color$9=Color.parse,noop$7=H.noop,_a$b=SeriesRegistry$1.seriesTypes,ColumnSeries$b=_a$b.column,ScatterSeries$3=_a$b.scatter,arrayMax$2=Utilities.arrayMax,arrayMin$2=Utilities.arrayMin,clamp$a=Utilities.clamp,extend$J=Utilities.extend,isNumber$m=Utilities.isNumber,merge$F=Utilities.merge,pick$L=Utilities.pick,pInt$2=Utilities.pInt,BubbleSeries$2=(function(g){__extends$1V(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.maxPxSize=void 0,a.minPxSize=void 0,a.options=void 0,a.points=void 0,a.radii=void 0,a.yData=void 0,a.zData=void 0,a}return d.prototype.animate=function(a){!a&&this.points.length<this.options.animationLimit&&this.points.forEach(function(u){var v=u.graphic;v&&v.width&&(this.hasRendered||v.attr({x:u.plotX,y:u.plotY,width:1,height:1}),v.animate(this.markerAttribs(u),this.options.animation))},this)},d.prototype.getRadii=function(a,u,v){var x,S,T=this.zData,P=this.yData,z=v.minPxSize,L=v.maxPxSize,N=[],$;for(S=0,x=T.length;S<x;S++)$=T[S],N.push(this.getRadius(a,u,z,L,$,P[S]));this.radii=N},d.prototype.getRadius=function(a,u,v,x,S,T){var P=this.options,z=P.sizeBy!=="width",L=P.zThreshold,N=u-a,$=.5;if(T===null||S===null)return null;if(isNumber$m(S)){if(P.sizeByAbsoluteValue&&(S=Math.abs(S-L),u=N=Math.max(u-L,Math.abs(a-L)),a=0),S<a)return v/2-1;N>0&&($=(S-a)/N)}return z&&$>=0&&($=Math.sqrt($)),Math.ceil(v+$*(x-v))/2},d.prototype.hasData=function(){return!!this.processedXData.length},d.prototype.pointAttribs=function(a,u){var v=this.options.marker,x=v.fillOpacity,S=Series$f.prototype.pointAttribs.call(this,a,u);return x!==1&&(S.fill=color$9(S.fill).setOpacity(x).get("rgba")),S},d.prototype.translate=function(){var a,u=this.data,v,x,S=this.radii;for(g.prototype.translate.call(this),a=u.length;a--;)v=u[a],x=S?S[a]:0,isNumber$m(x)&&x>=this.minPxSize/2?(v.marker=extend$J(v.marker,{radius:x,width:2*x,height:2*x}),v.dlBox={x:v.plotX-x,y:v.plotY-x,width:2*x,height:2*x}):v.shapeArgs=v.plotY=v.dlBox=void 0},d.compose=BubbleLegendComposition$1.compose,d.defaultOptions=merge$F(ScatterSeries$3.defaultOptions,{dataLabels:{formatter:function(){var a=this.series.chart.numberFormatter,u=this.point.z;return isNumber$m(u)?a(u,-1):""},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"}),d})(ScatterSeries$3);extend$J(BubbleSeries$2.prototype,{alignDataLabel:ColumnSeries$b.prototype.alignDataLabel,applyZones:noop$7,bubblePadding:!0,buildKDTree:noop$7,directTouch:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:BubblePoint,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",zoneAxis:"z"});Axis.prototype.beforePadding=function(){var g=this,d=this.len,a=this.chart,u=0,v=d,x=this.isXAxis,S=x?"xData":"yData",T=this.min,P={},z=Math.min(a.plotWidth,a.plotHeight),L=Number.MAX_VALUE,N=-Number.MAX_VALUE,$=this.max-T,B=d/$,U=[];this.series.forEach(function(j){var Y=j.options,q;j.bubblePadding&&(j.visible||!a.options.chart.ignoreHiddenSeries)&&(g.allowZoomOutside=!0,U.push(j),x&&(["minSize","maxSize"].forEach(function(Q){var J=Y[Q],ee=/%$/.test(J);J=pInt$2(J),P[Q]=ee?z*J/100:J}),j.minPxSize=P.minSize,j.maxPxSize=Math.max(P.maxSize,P.minSize),q=j.zData.filter(isNumber$m),q.length&&(L=pick$L(Y.zMin,clamp$a(arrayMin$2(q),Y.displayNegative===!1?Y.zThreshold:-Number.MAX_VALUE,L)),N=pick$L(Y.zMax,Math.max(N,arrayMax$2(q))))))}),U.forEach(function(j){var Y=j[S],q=Y.length,Q;if(x&&j.getRadii(L,N,j),$>0)for(;q--;)isNumber$m(Y[q])&&g.dataMin<=Y[q]&&Y[q]<=g.max&&(Q=j.radii?j.radii[q]:0,u=Math.min((Y[q]-T)*B-Q,u),v=Math.max((Y[q]-T)*B+Q,v))}),U.length&&$>0&&!this.logarithmic&&(v-=d,B*=(d+Math.max(0,u)-Math.min(v,d))/d,[["min","userMin",u],["max","userMax",v]].forEach(function(j){typeof pick$L(g.options[j[0]],g[j[1]])>"u"&&(g[j[0]]+=j[2]/B)}))};SeriesRegistry$1.registerSeriesType("bubble",BubbleSeries$2);var __extends$1U=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),_a$a=SeriesRegistry$1.seriesTypes,ColumnPoint=_a$a.column.prototype.pointClass,AreaRangePoint=_a$a.arearange.prototype.pointClass,extend$I=Utilities.extend,isNumber$l=Utilities.isNumber,ColumnRangePoint=(function(g){__extends$1U(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.series=void 0,a.options=void 0,a.barX=void 0,a.pointWidth=void 0,a.shapeType=void 0,a}return d.prototype.isValid=function(){return isNumber$l(this.low)},d})(AreaRangePoint);extend$I(ColumnRangePoint.prototype,{setState:ColumnPoint.prototype.setState});var __extends$1T=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),noop$6=H.noop,_a$9=SeriesRegistry$1.seriesTypes,AreaRangeSeries$1=_a$9.arearange,ColumnSeries$a=_a$9.column,columnProto$3=ColumnSeries$a.prototype,arearangeProto$1=AreaRangeSeries$1.prototype,clamp$9=Utilities.clamp,merge$E=Utilities.merge,pick$K=Utilities.pick,extend$H=Utilities.extend,columnRangeOptions={pointRange:null,marker:null,states:{hover:{halo:!1}}},ColumnRangeSeries=(function(g){__extends$1T(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.points=void 0,a.options=void 0,a}return d.prototype.setOptions=function(){return merge$E(!0,arguments[0],{stacking:void 0}),arearangeProto$1.setOptions.apply(this,arguments)},d.prototype.translate=function(){var a=this,u=a.yAxis,v=a.xAxis,x=v.startAngleRad,S,T=a.chart,P=a.xAxis.isRadial,z=Math.max(T.chartWidth,T.chartHeight)+999,L;function N($){return clamp$9($,-z,z)}columnProto$3.translate.apply(a),a.points.forEach(function($){var B=$.shapeArgs||{},U=a.options.minPointLength,j,Y,q;if($.plotHigh=L=N(u.translate($.high,0,1,0,1)),$.plotLow=N($.plotY),q=L,Y=pick$K($.rectPlotY,$.plotY)-L,Math.abs(Y)<U?(j=U-Y,Y+=j,q-=j/2):Y<0&&(Y*=-1,q-=Y),P)S=$.barX+x,$.shapeType="arc",$.shapeArgs=a.polarArc(q+Y,q,S,S+$.pointWidth);else{B.height=Y,B.y=q;var Q=B.x,J=Q===void 0?0:Q,ee=B.width,ie=ee===void 0?0:ee;$.tooltipPos=T.inverted?[u.len+u.pos-T.plotLeft-q-Y/2,v.len+v.pos-T.plotTop-J-ie/2,Y]:[v.left-T.plotLeft+J+ie/2,u.pos-T.plotTop+q+Y/2,Y]}})},d.prototype.crispCol=function(){return columnProto$3.crispCol.apply(this,arguments)},d.prototype.drawPoints=function(){return columnProto$3.drawPoints.apply(this,arguments)},d.prototype.drawTracker=function(){return columnProto$3.drawTracker.apply(this,arguments)},d.prototype.getColumnMetrics=function(){return columnProto$3.getColumnMetrics.apply(this,arguments)},d.prototype.pointAttribs=function(){return columnProto$3.pointAttribs.apply(this,arguments)},d.prototype.adjustForMissingColumns=function(){return columnProto$3.adjustForMissingColumns.apply(this,arguments)},d.prototype.animate=function(){return columnProto$3.animate.apply(this,arguments)},d.prototype.translate3dPoints=function(){return columnProto$3.translate3dPoints.apply(this,arguments)},d.prototype.translate3dShapes=function(){return columnProto$3.translate3dShapes.apply(this,arguments)},d.defaultOptions=merge$E(ColumnSeries$a.defaultOptions,AreaRangeSeries$1.defaultOptions,columnRangeOptions),d})(AreaRangeSeries$1);extend$H(ColumnRangeSeries.prototype,{directTouch:!0,trackerGroups:["group","dataLabelsGroup"],drawGraph:noop$6,getSymbol:noop$6,polarArc:function(){return columnProto$3.polarArc.apply(this,arguments)},pointClass:ColumnRangePoint});SeriesRegistry$1.registerSeriesType("columnrange",ColumnRangeSeries);var __extends$1S=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),colProto=ColumnSeries$h.prototype,clamp$8=Utilities.clamp,merge$D=Utilities.merge,pick$J=Utilities.pick,ColumnPyramidSeries=(function(g){__extends$1S(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.translate=function(){var a=this,u=a.chart,v=a.options,x=a.dense=a.closestPointRange*a.xAxis.transA<2,S=a.borderWidth=pick$J(v.borderWidth,x?0:1),T=a.yAxis,P=v.threshold,z=a.translatedThreshold=T.getThreshold(P),L=pick$J(v.minPointLength,5),N=a.getColumnMetrics(),$=N.width,B=a.barW=Math.max($,1+2*S),U=a.pointXOffset=N.offset;u.inverted&&(z-=.5),v.pointPadding&&(B=Math.ceil(B)),colProto.translate.apply(a),a.points.forEach(function(j){var Y=pick$J(j.yBottom,z),q=999+Math.abs(Y),Q=clamp$8(j.plotY,-q,T.len+q),J=j.plotX+U,ee=B/2,ie=Math.min(Q,Y),ne=Math.max(Q,Y)-ie,ae,de,he,pe,ve,be,ge,_e,me,xe,Ce,Me;j.barX=J,j.pointWidth=$,j.tooltipPos=u.inverted?[T.len+T.pos-u.plotLeft-Q,a.xAxis.len-J-ee,ne]:[J+ee,Q+T.pos-u.plotTop,ne],ae=P+(j.total||j.y),v.stacking==="percent"&&(ae=P+(j.y<0)?-100:100),he=T.toPixels(ae,!0),de=u.plotHeight-he-(u.plotHeight-z),pe=de?ee*(ie-he)/de:0,ve=de?ee*(ie+ne-he)/de:0,ge=J-pe+ee,_e=J+pe+ee,me=J+ve+ee,xe=J-ve+ee,Ce=ie-L,Me=ie+ne,j.y<0&&(Ce=ie,Me=ie+ne+L),u.inverted&&(be=u.plotWidth-ie,de=he-(u.plotWidth-z),pe=ee*(he-be)/de,ve=ee*(he-(be-ne))/de,ge=J+ee+pe,_e=ge-2*pe,me=J-ve+ee,xe=J+ve+ee,Ce=ie,Me=ie+ne-L,j.y<0&&(Me=ie+ne+L)),j.shapeType="path",j.shapeArgs={x:ge,y:Ce,width:_e-ge,height:ne,d:[["M",ge,Ce],["L",_e,Ce],["L",me,Me],["L",xe,Me],["Z"]]}})},d.defaultOptions=merge$D(ColumnSeries$h.defaultOptions,{}),d})(ColumnSeries$h);SeriesRegistry$1.registerSeriesType("columnpyramid",ColumnPyramidSeries);var __extends$1R=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),AreaRangeSeries=SeriesRegistry$1.seriesTypes.arearange,merge$C=Utilities.merge,extend$G=Utilities.extend,ErrorBarSeries=(function(g){__extends$1R(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.getColumnMetrics=function(){return this.linkedParent&&this.linkedParent.columnMetrics||ColumnSeries$h.prototype.getColumnMetrics.call(this)},d.prototype.drawDataLabels=function(){var a=this.pointValKey;AreaRangeSeries&&(AreaRangeSeries.prototype.drawDataLabels.call(this),this.data.forEach(function(u){u.y=u[a]}))},d.prototype.toYData=function(a){return[a.low,a.high]},d.defaultOptions=merge$C(BoxPlotSeries.defaultOptions,{color:palette.neutralColor100,grouping:!1,linkedTo:":previous",tooltip:{pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},whiskerWidth:null}),d})(BoxPlotSeries);extend$G(ErrorBarSeries.prototype,{pointArrayMap:["low","high"],pointValKey:"high",doQuartiles:!1});SeriesRegistry$1.registerSeriesType("errorbar",ErrorBarSeries);var __extends$1Q=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),Point$3=SeriesRegistry$1.series.prototype.pointClass,GaugePoint=(function(g){__extends$1Q(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.options=void 0,a.series=void 0,a.shapeArgs=void 0,a}return d.prototype.setState=function(a){this.state=a},d})(Point$3),__extends$1P=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),noop$5=H.noop,Series$b=SeriesRegistry$1.series,ColumnSeries$9=SeriesRegistry$1.seriesTypes.column,clamp$7=Utilities.clamp,isNumber$k=Utilities.isNumber,extend$F=Utilities.extend,merge$B=Utilities.merge,pick$I=Utilities.pick,pInt$1=Utilities.pInt,GaugeSeries$1=(function(g){__extends$1P(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.points=void 0,a.options=void 0,a.yAxis=void 0,a}return d.prototype.translate=function(){var a=this,u=a.yAxis,v=a.options,x=u.center;a.generatePoints(),a.points.forEach(function(S){var T=merge$B(v.dial,S.dial),P=pInt$1(pick$I(T.radius,"80%"))*x[2]/200,z=pInt$1(pick$I(T.baseLength,"70%"))*P/100,L=pInt$1(pick$I(T.rearLength,"10%"))*P/100,N=T.baseWidth||3,$=T.topWidth||1,B=v.overshoot,U=u.startAngleRad+u.translate(S.y,null,null,null,!0);(isNumber$k(B)||v.wrap===!1)&&(B=isNumber$k(B)?B/180*Math.PI:0,U=clamp$7(U,u.startAngleRad-B,u.endAngleRad+B)),U=U*180/Math.PI,S.shapeType="path";var j=T.path||[["M",-L,-N/2],["L",z,-N/2],["L",P,-$/2],["L",P,$/2],["L",z,N/2],["L",-L,N/2],["Z"]];S.shapeArgs={d:j,translateX:x[0],translateY:x[1],rotation:U},S.plotX=x[0],S.plotY=x[1]})},d.prototype.drawPoints=function(){var a=this,u=a.chart,v=a.yAxis.center,x=a.pivot,S=a.options,T=S.pivot,P=u.renderer;a.points.forEach(function(z){var L=z.graphic,N=z.shapeArgs,$=N.d,B=merge$B(S.dial,z.dial);L?(L.animate(N),N.d=$):z.graphic=P[z.shapeType](N).attr({rotation:N.rotation,zIndex:1}).addClass("highcharts-dial").add(a.group),u.styledMode||z.graphic[L?"animate":"attr"]({stroke:B.borderColor||"none","stroke-width":B.borderWidth||0,fill:B.backgroundColor||palette.neutralColor100})}),x?x.animate({translateX:v[0],translateY:v[1]}):(a.pivot=P.circle(0,0,pick$I(T.radius,5)).attr({zIndex:2}).addClass("highcharts-pivot").translate(v[0],v[1]).add(a.group),u.styledMode||a.pivot.attr({"stroke-width":T.borderWidth||0,stroke:T.borderColor||palette.neutralColor20,fill:T.backgroundColor||palette.neutralColor100}))},d.prototype.animate=function(a){var u=this;a||u.points.forEach(function(v){var x=v.graphic;x&&(x.attr({rotation:u.yAxis.startAngleRad*180/Math.PI}),x.animate({rotation:v.shapeArgs.rotation},u.options.animation))})},d.prototype.render=function(){this.group=this.plotGroup("group","series",this.visible?"visible":"hidden",this.options.zIndex,this.chart.seriesGroup),Series$b.prototype.render.call(this),this.group.clip(this.chart.clipRect)},d.prototype.setData=function(a,u){Series$b.prototype.setData.call(this,a,!1),this.processData(),this.generatePoints(),pick$I(u,!0)&&this.chart.redraw()},d.prototype.hasData=function(){return!!this.points.length},d.defaultOptions=merge$B(Series$b.defaultOptions,{dataLabels:{borderColor:palette.neutralColor20,borderRadius:3,borderWidth:1,crop:!1,defer:!1,enabled:!0,verticalAlign:"top",y:15,zIndex:2},dial:{},pivot:{},tooltip:{headerFormat:""},showInLegend:!1}),d})(Series$b);extend$F(GaugeSeries$1.prototype,{angular:!0,directTouch:!0,drawGraph:noop$5,drawTracker:ColumnSeries$9.prototype.drawTracker,fixedBox:!0,forceDL:!0,noSharedTooltip:!0,pointClass:GaugePoint,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("gauge",GaugeSeries$1);var __extends$1O=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),BubbleSeries$1=SeriesRegistry$1.seriesTypes.bubble,PackedBubblePoint=(function(g){__extends$1O(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.degree=NaN,a.mass=NaN,a.radius=NaN,a.options=void 0,a.series=void 0,a.value=null,a}return d.prototype.destroy=function(){return this.series.layout&&this.series.layout.removeElementFromCollection(this,this.series.layout.nodes),Point$4.prototype.destroy.apply(this,arguments)},d.prototype.firePointEvent=function(){var a=this.series,u=a.options;if(this.isParentNode&&u.parentNode){var v=u.allowPointSelect;u.allowPointSelect=u.parentNode.allowPointSelect,Point$4.prototype.firePointEvent.apply(this,arguments),u.allowPointSelect=v}else Point$4.prototype.firePointEvent.apply(this,arguments)},d.prototype.select=function(){var a=this,u=this.series,v=u.chart;a.isParentNode?(v.getSelectedPoints=v.getSelectedParentNodes,Point$4.prototype.select.apply(this,arguments),v.getSelectedPoints=Chart$1.prototype.getSelectedPoints):Point$4.prototype.select.apply(this,arguments)},d})(BubbleSeries$1.prototype.pointClass),addEvent$u=Utilities.addEvent;H.dragNodesMixin={onMouseDown:function(g,d){var a=this.chart.pointer.normalize(d);g.fixedPosition={chartX:a.chartX,chartY:a.chartY,plotX:g.plotX,plotY:g.plotY},g.inDragMode=!0},onMouseMove:function(g,d){if(g.fixedPosition&&g.inDragMode){var a=this,u=a.chart,v=u.pointer.normalize(d),x=g.fixedPosition.chartX-v.chartX,S=g.fixedPosition.chartY-v.chartY,T=void 0,P=void 0,z=u.graphLayoutsLookup;(Math.abs(x)>5||Math.abs(S)>5)&&(T=g.fixedPosition.plotX-x,P=g.fixedPosition.plotY-S,u.isInsidePlot(T,P)&&(g.plotX=T,g.plotY=P,g.hasDragged=!0,this.redrawHalo(g),z.forEach(function(L){L.restartSimulation()})))}},onMouseUp:function(g,d){g.fixedPosition&&(g.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw()),g.inDragMode=g.hasDragged=!1,this.options.fixedDraggable||delete g.fixedPosition)},redrawHalo:function(g){g&&this.halo&&this.halo.attr({d:g.haloPath(this.options.states.hover.halo.size)})}};addEvent$u(Chart$1,"load",function(){var g=this,d,a,u;g.container&&(d=addEvent$u(g.container,"mousedown",function(v){var x=g.hoverPoint;x&&x.series&&x.series.hasDraggableNodes&&x.series.options.draggable&&(x.series.onMouseDown(x,v),a=addEvent$u(g.container,"mousemove",function(S){return x&&x.series&&x.series.onMouseMove(x,S)}),u=addEvent$u(g.container.ownerDocument,"mouseup",function(S){return a(),u(),x&&x.series&&x.series.onMouseUp(x,S)}))})),addEvent$u(g,"destroy",function(){d()})});H.networkgraphIntegrations={verlet:{attractiveForceFunction:function(g,d){return(d-g)/g},repulsiveForceFunction:function(g,d){return(d-g)/g*(d>g?1:0)},barycenter:function(){var g=this.options.gravitationalConstant,d=this.barycenter.xFactor,a=this.barycenter.yFactor;d=(d-(this.box.left+this.box.width)/2)*g,a=(a-(this.box.top+this.box.height)/2)*g,this.nodes.forEach(function(u){u.fixedPosition||(u.plotX-=d/u.mass/u.degree,u.plotY-=a/u.mass/u.degree)})},repulsive:function(g,d,a){var u=d*this.diffTemperature/g.mass/g.degree;g.fixedPosition||(g.plotX+=a.x*u,g.plotY+=a.y*u)},attractive:function(g,d,a){var u=g.getMass(),v=-a.x*d*this.diffTemperature,x=-a.y*d*this.diffTemperature;g.fromNode.fixedPosition||(g.fromNode.plotX-=v*u.fromNode/g.fromNode.degree,g.fromNode.plotY-=x*u.fromNode/g.fromNode.degree),g.toNode.fixedPosition||(g.toNode.plotX+=v*u.toNode/g.toNode.degree,g.toNode.plotY+=x*u.toNode/g.toNode.degree)},integrate:function(g,d){var a=-g.options.friction,u=g.options.maxSpeed,v=d.prevX,x=d.prevY,S=(d.plotX+d.dispX-v)*a,T=(d.plotY+d.dispY-x)*a,P=Math.abs,z=P(S)/(S||1),L=P(T)/(T||1);S=z*Math.min(u,Math.abs(S)),T=L*Math.min(u,Math.abs(T)),d.prevX=d.plotX+d.dispX,d.prevY=d.plotY+d.dispY,d.plotX+=S,d.plotY+=T,d.temperature=g.vectorLength({x:S,y:T})},getK:function(g){return Math.pow(g.box.width*g.box.height/g.nodes.length,.5)}},euler:{attractiveForceFunction:function(g,d){return g*g/d},repulsiveForceFunction:function(g,d){return d*d/g},barycenter:function(){var g=this.options.gravitationalConstant,d=this.barycenter.xFactor,a=this.barycenter.yFactor;this.nodes.forEach(function(u){if(!u.fixedPosition){var v=u.getDegree(),x=v*(1+v/2);u.dispX+=(d-u.plotX)*g*x/u.degree,u.dispY+=(a-u.plotY)*g*x/u.degree}})},repulsive:function(g,d,a,u){g.dispX+=a.x/u*d/g.degree,g.dispY+=a.y/u*d/g.degree},attractive:function(g,d,a,u){var v=g.getMass(),x=a.x/u*d,S=a.y/u*d;g.fromNode.fixedPosition||(g.fromNode.dispX-=x*v.fromNode/g.fromNode.degree,g.fromNode.dispY-=S*v.fromNode/g.fromNode.degree),g.toNode.fixedPosition||(g.toNode.dispX+=x*v.toNode/g.toNode.degree,g.toNode.dispY+=S*v.toNode/g.toNode.degree)},integrate:function(g,d){var a;d.dispX+=d.dispX*g.options.friction,d.dispY+=d.dispY*g.options.friction,a=d.temperature=g.vectorLength({x:d.dispX,y:d.dispY}),a!==0&&(d.plotX+=d.dispX/a*Math.min(Math.abs(d.dispX),g.temperature),d.plotY+=d.dispY/a*Math.min(Math.abs(d.dispY),g.temperature))},getK:function(g){return Math.pow(g.box.width*g.box.height/g.nodes.length,.3)}}};var extend$E=Utilities.extend,QuadTreeNode=H.QuadTreeNode=function(g){this.box=g,this.boxSize=Math.min(g.width,g.height),this.nodes=[],this.isInternal=!1,this.body=!1,this.isEmpty=!0};extend$E(QuadTreeNode.prototype,{insert:function(g,d){var a;this.isInternal?this.nodes[this.getBoxPosition(g)].insert(g,d-1):(this.isEmpty=!1,this.body?d?(this.isInternal=!0,this.divideBox(),this.body!==!0&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,d-1),this.body=!0),this.nodes[this.getBoxPosition(g)].insert(g,d-1)):(a=new QuadTreeNode({top:g.plotX,left:g.plotY,width:.1,height:.1}),a.body=g,a.isInternal=!1,this.nodes.push(a)):(this.isInternal=!1,this.body=g))},updateMassAndCenter:function(){var g=0,d=0,a=0;this.isInternal?(this.nodes.forEach(function(u){u.isEmpty||(g+=u.mass,d+=u.plotX*u.mass,a+=u.plotY*u.mass)}),d/=g,a/=g):this.body&&(g=this.body.mass,d=this.body.plotX,a=this.body.plotY),this.mass=g,this.plotX=d,this.plotY=a},divideBox:function(){var g=this.box.width/2,d=this.box.height/2;this.nodes[0]=new QuadTreeNode({left:this.box.left,top:this.box.top,width:g,height:d}),this.nodes[1]=new QuadTreeNode({left:this.box.left+g,top:this.box.top,width:g,height:d}),this.nodes[2]=new QuadTreeNode({left:this.box.left+g,top:this.box.top+d,width:g,height:d}),this.nodes[3]=new QuadTreeNode({left:this.box.left,top:this.box.top+d,width:g,height:d})},getBoxPosition:function(g){var d=g.plotX<this.box.left+this.box.width/2,a=g.plotY<this.box.top+this.box.height/2,u;return d?a?u=0:u=3:a?u=1:u=2,u}});var QuadTree=H.QuadTree=function(g,d,a,u){this.box={left:g,top:d,width:a,height:u},this.maxDepth=25,this.root=new QuadTreeNode(this.box,"0"),this.root.isInternal=!0,this.root.isRoot=!0,this.root.divideBox()};extend$E(QuadTree.prototype,{insertNodes:function(g){g.forEach(function(d){this.root.insert(d,this.maxDepth)},this)},visitNodeRecursive:function(g,d,a){var u;g||(g=this.root),g===this.root&&d&&(u=d(g)),u!==!1&&(g.nodes.forEach(function(v){if(v.isInternal){if(d&&(u=d(v)),u===!1)return;this.visitNodeRecursive(v,d,a)}else v.body&&d&&d(v.body);a&&a(v)},this),g===this.root&&a&&a(g))},calculateMassAndCenter:function(){this.visitNodeRecursive(null,null,function(g){g.updateMassAndCenter()})}});var setAnimation=animationExports.setAnimation,addEvent$t=Utilities.addEvent,clamp$6=Utilities.clamp,defined$i=Utilities.defined,extend$D=Utilities.extend,isFunction=Utilities.isFunction,pick$H=Utilities.pick;H.layouts={"reingold-fruchterman":function(){}};extend$D(H.layouts["reingold-fruchterman"].prototype,{init:function(g){this.options=g,this.nodes=[],this.links=[],this.series=[],this.box={x:0,y:0,width:0,height:0},this.setInitialRendering(!0),this.integration=H.networkgraphIntegrations[g.integration],this.enableSimulation=g.enableSimulation,this.attractiveForce=pick$H(g.attractiveForce,this.integration.attractiveForceFunction),this.repulsiveForce=pick$H(g.repulsiveForce,this.integration.repulsiveForceFunction),this.approximation=g.approximation},updateSimulation:function(g){this.enableSimulation=pick$H(g,this.options.enableSimulation)},start:function(){var g=this,d=this.series,a=this.options;g.currentStep=0,g.forces=d[0]&&d[0].forces||[],g.chart=d[0]&&d[0].chart,g.initialRendering&&(g.initPositions(),d.forEach(function(u){u.finishedAnimating=!0,u.render()})),g.setK(),g.resetSimulation(a),g.enableSimulation&&g.step()},step:function(){var g=this,d=this.series;this.options,g.currentStep++,g.approximation==="barnes-hut"&&(g.createQuadTree(),g.quadTree.calculateMassAndCenter()),g.forces.forEach(function(a){g[a+"Forces"](g.temperature)}),g.applyLimits(g.temperature),g.temperature=g.coolDown(g.startTemperature,g.diffTemperature,g.currentStep),g.prevSystemTemperature=g.systemTemperature,g.systemTemperature=g.getSystemTemperature(),g.enableSimulation&&(d.forEach(function(a){a.chart&&a.render()}),g.maxIterations--&&isFinite(g.temperature)&&!g.isStable()?(g.simulation&&H.win.cancelAnimationFrame(g.simulation),g.simulation=H.win.requestAnimationFrame(function(){g.step()})):g.simulation=!1)},stop:function(){this.simulation&&H.win.cancelAnimationFrame(this.simulation)},setArea:function(g,d,a,u){this.box={left:g,top:d,width:a,height:u}},setK:function(){this.k=this.options.linkLength||this.integration.getK(this)},addElementsToCollection:function(g,d){g.forEach(function(a){d.indexOf(a)===-1&&d.push(a)})},removeElementFromCollection:function(g,d){var a=d.indexOf(g);a!==-1&&d.splice(a,1)},clear:function(){this.nodes.length=0,this.links.length=0,this.series.length=0,this.resetSimulation()},resetSimulation:function(){this.forcedStop=!1,this.systemTemperature=0,this.setMaxIterations(),this.setTemperature(),this.setDiffTemperature()},restartSimulation:function(){this.simulation?this.resetSimulation():(this.setInitialRendering(!1),this.enableSimulation?this.start():this.setMaxIterations(1),this.chart&&this.chart.redraw(),this.setInitialRendering(!0))},setMaxIterations:function(g){this.maxIterations=pick$H(g,this.options.maxIterations)},setTemperature:function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},setDiffTemperature:function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+1)},setInitialRendering:function(g){this.initialRendering=g},createQuadTree:function(){this.quadTree=new H.QuadTree(this.box.left,this.box.top,this.box.width,this.box.height),this.quadTree.insertNodes(this.nodes)},initPositions:function(){var g=this.options.initialPositions;isFunction(g)?(g.call(this),this.nodes.forEach(function(d){defined$i(d.prevX)||(d.prevX=d.plotX),defined$i(d.prevY)||(d.prevY=d.plotY),d.dispX=0,d.dispY=0})):g==="circle"?this.setCircularPositions():this.setRandomPositions()},setCircularPositions:function(){var g=this.box,d=this.nodes,a=d.length+1,u=2*Math.PI/a,v=d.filter(function(z){return z.linksTo.length===0}),x=[],S={},T=this.options.initialPositionRadius;function P(z){z.linksFrom.forEach(function(L){S[L.toNode.id]||(S[L.toNode.id]=!0,x.push(L.toNode),P(L.toNode))})}v.forEach(function(z){x.push(z),P(z)}),x.length?d.forEach(function(z){x.indexOf(z)===-1&&x.push(z)}):x=d,x.forEach(function(z,L){z.plotX=z.prevX=pick$H(z.plotX,g.width/2+T*Math.cos(L*u)),z.plotY=z.prevY=pick$H(z.plotY,g.height/2+T*Math.sin(L*u)),z.dispX=0,z.dispY=0})},setRandomPositions:function(){var g=this.box,d=this.nodes,a=d.length+1;function u(v){var x=v*v/Math.PI;return x=x-Math.floor(x),x}d.forEach(function(v,x){v.plotX=v.prevX=pick$H(v.plotX,g.width*u(x)),v.plotY=v.prevY=pick$H(v.plotY,g.height*u(a+x)),v.dispX=0,v.dispY=0})},force:function(g){this.integration[g].apply(this,Array.prototype.slice.call(arguments,1))},barycenterForces:function(){this.getBarycenter(),this.force("barycenter")},getBarycenter:function(){var g=0,d=0,a=0;return this.nodes.forEach(function(u){d+=u.plotX*u.mass,a+=u.plotY*u.mass,g+=u.mass}),this.barycenter={x:d,y:a,xFactor:d/g,yFactor:a/g},this.barycenter},barnesHutApproximation:function(g,d){var a=this,u=a.getDistXY(g,d),v=a.vectorLength(u),x,S;return g!==d&&v!==0&&(d.isInternal?d.boxSize/v<a.options.theta&&v!==0?(S=a.repulsiveForce(v,a.k),a.force("repulsive",g,S*d.mass,u,v),x=!1):x=!0:(S=a.repulsiveForce(v,a.k),a.force("repulsive",g,S*d.mass,u,v))),x},repulsiveForces:function(){var g=this;g.approximation==="barnes-hut"?g.nodes.forEach(function(d){g.quadTree.visitNodeRecursive(null,function(a){return g.barnesHutApproximation(d,a)})}):g.nodes.forEach(function(d){g.nodes.forEach(function(a){var u,v,x;d!==a&&!d.fixedPosition&&(x=g.getDistXY(d,a),v=g.vectorLength(x),v!==0&&(u=g.repulsiveForce(v,g.k),g.force("repulsive",d,u*a.mass,x,v)))})})},attractiveForces:function(){var g=this,d,a,u;g.links.forEach(function(v){v.fromNode&&v.toNode&&(d=g.getDistXY(v.fromNode,v.toNode),a=g.vectorLength(d),a!==0&&(u=g.attractiveForce(a,g.k),g.force("attractive",v,u,d,a)))})},applyLimits:function(){var g=this,d=g.nodes;d.forEach(function(a){a.fixedPosition||(g.integration.integrate(g,a),g.applyLimitBox(a,g.box),a.dispX=0,a.dispY=0)})},applyLimitBox:function(g,d){var a=g.radius;g.plotX=clamp$6(g.plotX,d.left+a,d.width-a),g.plotY=clamp$6(g.plotY,d.top+a,d.height-a)},coolDown:function(g,d,a){return g-d*a},isStable:function(){return Math.abs(this.systemTemperature-this.prevSystemTemperature)<1e-5||this.temperature<=0},getSystemTemperature:function(){return this.nodes.reduce(function(g,d){return g+d.temperature},0)},vectorLength:function(g){return Math.sqrt(g.x*g.x+g.y*g.y)},getDistR:function(g,d){var a=this.getDistXY(g,d);return this.vectorLength(a)},getDistXY:function(g,d){var a=g.plotX-d.plotX,u=g.plotY-d.plotY;return{x:a,y:u,absX:Math.abs(a),absY:Math.abs(u)}}});addEvent$t(Chart$1,"predraw",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(g){g.stop()})});addEvent$t(Chart$1,"render",function(){var g,d=!1;function a(u){u.maxIterations--&&isFinite(u.temperature)&&!u.isStable()&&!u.enableSimulation&&(u.beforeStep&&u.beforeStep(),u.step(),g=!1,d=!0)}if(this.graphLayoutsLookup){for(setAnimation(!1,this),this.graphLayoutsLookup.forEach(function(u){u.start()});!g;)g=!0,this.graphLayoutsLookup.forEach(a);d&&this.series.forEach(function(u){u&&u.layout&&u.render()})}});addEvent$t(Chart$1,"beforePrint",function(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(g){g.updateSimulation(!1)}),this.redraw())});addEvent$t(Chart$1,"afterPrint",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(g){g.updateSimulation()}),this.redraw()});var Reingold=H.layouts["reingold-fruchterman"],addEvent$s=Utilities.addEvent,extendClass=Utilities.extendClass,pick$G=Utilities.pick;Chart$1.prototype.getSelectedParentNodes=function(){var g=this,d=g.series,a=[];return d.forEach(function(u){u.parentNode&&u.parentNode.selected&&a.push(u.parentNode)}),a};H.networkgraphIntegrations.packedbubble={repulsiveForceFunction:function(g,d,a,u){return Math.min(g,(a.marker.radius+u.marker.radius)/2)},barycenter:function(){var g=this,d=g.options.gravitationalConstant,a=g.box,u=g.nodes,v,x;u.forEach(function(S){g.options.splitSeries&&!S.isParentNode?(v=S.series.parentNode.plotX,x=S.series.parentNode.plotY):(v=a.width/2,x=a.height/2),S.fixedPosition||(S.plotX-=(S.plotX-v)*d/(S.mass*Math.sqrt(u.length)),S.plotY-=(S.plotY-x)*d/(S.mass*Math.sqrt(u.length)))})},repulsive:function(g,d,a,u){var v=d*this.diffTemperature/g.mass/g.degree,x=a.x*v,S=a.y*v;g.fixedPosition||(g.plotX+=x,g.plotY+=S),u.fixedPosition||(u.plotX-=x,u.plotY-=S)},integrate:H.networkgraphIntegrations.verlet.integrate,getK:H.noop};H.layouts.packedbubble=extendClass(Reingold,{beforeStep:function(){this.options.marker&&this.series.forEach(function(g){g&&g.calculateParentRadius()})},isStable:function(){var g=Math.abs(this.prevSystemTemperature-this.systemTemperature),d=10*this.systemTemperature/Math.sqrt(this.nodes.length);return Math.abs(d)<1&&g<1e-5||this.temperature<=0},setCircularPositions:function(){var g=this,d=g.box,a=g.nodes,u=a.length+1,v=2*Math.PI/u,x,S,T=g.options.initialPositionRadius;a.forEach(function(P,z){g.options.splitSeries&&!P.isParentNode?(x=P.series.parentNode.plotX,S=P.series.parentNode.plotY):(x=d.width/2,S=d.height/2),P.plotX=P.prevX=pick$G(P.plotX,x+T*Math.cos(P.index||z*v)),P.plotY=P.prevY=pick$G(P.plotY,S+T*Math.sin(P.index||z*v)),P.dispX=0,P.dispY=0})},repulsiveForces:function(){var g=this,d,a,u,v=g.options.bubblePadding;g.nodes.forEach(function(x){x.degree=x.mass,x.neighbours=0,g.nodes.forEach(function(S){d=0,x!==S&&!x.fixedPosition&&(g.options.seriesInteraction||x.series===S.series)&&(u=g.getDistXY(x,S),a=g.vectorLength(u)-(x.marker.radius+S.marker.radius+v),a<0&&(x.degree+=.01,x.neighbours++,d=g.repulsiveForce(-a/Math.sqrt(x.neighbours),g.k,x,S)),g.force("repulsive",x,d*S.mass,u,S,a))})})},applyLimitBox:function(g){var d=this,a,u,v=.01;d.options.splitSeries&&!g.isParentNode&&d.options.parentNodeLimit&&(a=d.getDistXY(g,g.series.parentNode),u=g.series.parentNodeRadius-g.marker.radius-d.vectorLength(a),u<0&&u>-2*g.marker.radius&&(g.plotX-=a.x*v,g.plotY-=a.y*v)),Reingold.prototype.applyLimitBox.apply(this,arguments)}});addEvent$s(Chart$1,"beforeRedraw",function(){this.allDataPoints&&delete this.allDataPoints});var __extends$1N=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),color$8=Color.parse,Series$a=SeriesRegistry$1.series,BubbleSeries=SeriesRegistry$1.seriesTypes.bubble,addEvent$r=Utilities.addEvent,clamp$5=Utilities.clamp,defined$h=Utilities.defined,extend$C=Utilities.extend,fireEvent$7=Utilities.fireEvent,isArray$7=Utilities.isArray,isNumber$j=Utilities.isNumber,merge$A=Utilities.merge,pick$F=Utilities.pick,dragNodesMixin=H.dragNodesMixin,PackedBubbleSeries=(function(g){__extends$1N(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.chart=void 0,a.data=void 0,a.layout=void 0,a.options=void 0,a.points=void 0,a.xData=void 0,a}return d.prototype.accumulateAllPoints=function(a){var u=a.chart,v=[],x,S;for(x=0;x<u.series.length;x++)if(a=u.series[x],a.is("packedbubble")&&a.visible||!u.options.chart.ignoreHiddenSeries)for(S=0;S<a.yData.length;S++)v.push([null,null,a.yData[S],a.index,S,{id:S,marker:{radius:0}}]);return v},d.prototype.addLayout=function(){var a=this,u=a.options.layoutAlgorithm,v=a.chart.graphLayoutsStorage,x=a.chart.graphLayoutsLookup,S=a.chart.options.chart,T;v||(a.chart.graphLayoutsStorage=v={},a.chart.graphLayoutsLookup=x=[]),T=v[u.type],T||(u.enableSimulation=defined$h(S.forExport)?!S.forExport:u.enableSimulation,v[u.type]=T=new H.layouts[u.type],T.init(u),x.splice(T.index,0,T)),a.layout=T,a.points.forEach(function(P){P.mass=2,P.degree=1,P.collisionNmb=1}),T.setArea(0,0,a.chart.plotWidth,a.chart.plotHeight),T.addElementsToCollection([a],T.series),T.addElementsToCollection(a.points,T.nodes)},d.prototype.addSeriesLayout=function(){var a=this,u=a.options.layoutAlgorithm,v=a.chart.graphLayoutsStorage,x=a.chart.graphLayoutsLookup,S=merge$A(u,u.parentNodeOptions,{enableSimulation:a.layout.options.enableSimulation}),T;T=v[u.type+"-series"],T||(v[u.type+"-series"]=T=new H.layouts[u.type],T.init(S),x.splice(T.index,0,T)),a.parentNodeLayout=T,this.createParentNodes()},d.prototype.calculateParentRadius=function(){var a=this,u,v=20,x=20;u=a.seriesBox(),a.parentNodeRadius=clamp$5(Math.sqrt(2*a.parentNodeMass/Math.PI)+v,x,u?Math.max(Math.sqrt(Math.pow(u.width,2)+Math.pow(u.height,2))/2+v,x):Math.sqrt(2*a.parentNodeMass/Math.PI)+v),a.parentNode&&(a.parentNode.marker.radius=a.parentNode.radius=a.parentNodeRadius)},d.prototype.calculateZExtremes=function(){var a=this.chart,u=this.options.zMin,v=this.options.zMax,x=1/0,S=-1/0;return u&&v?[u,v]:(a.series.forEach(function(T){T.yData.forEach(function(P){defined$h(P)&&(P>S&&(S=P),P<x&&(x=P))})}),u=pick$F(u,x),v=pick$F(v,S),[u,v])},d.prototype.checkOverlap=function(a,u){var v=a[0]-u[0],x=a[1]-u[1],S=a[2]+u[2];return Math.sqrt(v*v+x*x)-Math.abs(S)<-.001},d.prototype.createParentNodes=function(){var a=this,u=a.chart,v=a.parentNodeLayout,x,S=a.parentNode,T=a.pointClass;a.parentNodeMass=0,a.points.forEach(function(P){a.parentNodeMass+=Math.PI*Math.pow(P.marker.radius,2)}),a.calculateParentRadius(),v.nodes.forEach(function(P){P.seriesIndex===a.index&&(x=!0)}),v.setArea(0,0,u.plotWidth,u.plotHeight),x||(S||(S=new T().init(this,{mass:a.parentNodeRadius/2,marker:{radius:a.parentNodeRadius},dataLabels:{inside:!1},dataLabelOnNull:!0,degree:a.parentNodeRadius,isParentNode:!0,seriesIndex:a.index})),a.parentNode&&(S.plotX=a.parentNode.plotX,S.plotY=a.parentNode.plotY),a.parentNode=S,v.addElementsToCollection([a],v.series),v.addElementsToCollection([S],v.nodes))},d.prototype.deferLayout=function(){var a=this,u=a.options.layoutAlgorithm;a.visible&&(a.addLayout(),u.splitSeries&&a.addSeriesLayout())},d.prototype.destroy=function(){this.chart.graphLayoutsLookup&&this.chart.graphLayoutsLookup.forEach(function(a){a.removeElementFromCollection(this,a.series)},this),this.parentNode&&this.parentNodeLayout&&(this.parentNodeLayout.removeElementFromCollection(this.parentNode,this.parentNodeLayout.nodes),this.parentNode.dataLabel&&(this.parentNode.dataLabel=this.parentNode.dataLabel.destroy())),Series$a.prototype.destroy.apply(this,arguments)},d.prototype.drawDataLabels=function(){var a=this.options.dataLabels.textPath,u=this.points;Series$a.prototype.drawDataLabels.apply(this,arguments),this.parentNode&&(this.parentNode.formatPrefix="parentNode",this.points=[this.parentNode],this.options.dataLabels.textPath=this.options.dataLabels.parentNodeTextPath,Series$a.prototype.drawDataLabels.apply(this,arguments),this.points=u,this.options.dataLabels.textPath=a)},d.prototype.drawGraph=function(){if(!(!this.layout||!this.layout.options.splitSeries)){var a=this,u=a.chart,v={},x=this.layout.options.parentNodeOptions.marker,S={fill:x.fillColor||color$8(a.color).brighten(.4).get(),opacity:x.fillOpacity,stroke:x.lineColor||a.color,"stroke-width":x.lineWidth};this.parentNodesGroup||(a.parentNodesGroup=a.plotGroup("parentNodesGroup","parentNode",a.visible?"inherit":"hidden",.1,u.seriesGroup),a.group.attr({zIndex:2})),this.calculateParentRadius(),v=merge$A({x:a.parentNode.plotX-a.parentNodeRadius,y:a.parentNode.plotY-a.parentNodeRadius,width:a.parentNodeRadius*2,height:a.parentNodeRadius*2},S),a.parentNode.graphic||(a.graph=a.parentNode.graphic=u.renderer.symbol(S.symbol).add(a.parentNodesGroup)),a.parentNode.graphic.attr(v)}},d.prototype.drawTracker=function(){var a=this,u=a.parentNode,v;g.prototype.drawTracker.call(this),u&&(v=isArray$7(u.dataLabels)?u.dataLabels:u.dataLabel?[u.dataLabel]:[],u.graphic&&(u.graphic.element.point=u),v.forEach(function(x){x.div?x.div.point=u:x.element.point=u}))},d.prototype.getPointRadius=function(){var a=this,u=a.chart,v=u.plotWidth,x=u.plotHeight,S=a.options,T=S.useSimulation,P=Math.min(v,x),z={},L=[],N=u.allDataPoints,$,B,U,j,Y;["minSize","maxSize"].forEach(function(q){var Q=parseInt(S[q],10),J=/%$/.test(S[q]);z[q]=J?P*Q/100:Q*Math.sqrt(N.length)}),u.minRadius=$=z.minSize/Math.sqrt(N.length),u.maxRadius=B=z.maxSize/Math.sqrt(N.length),Y=T?a.calculateZExtremes():[$,B],(N||[]).forEach(function(q,Q){U=T?clamp$5(q[2],Y[0],Y[1]):q[2],j=a.getRadius(Y[0],Y[1],$,B,U),j===0&&(j=null),N[Q][2]=j,L.push(j)}),a.radii=L},d.prototype.init=function(){return Series$a.prototype.init.apply(this,arguments),this.eventsToUnbind.push(addEvent$r(this,"updatedData",function(){this.chart.series.forEach(function(a){a.type===this.type&&(a.isDirty=!0)},this)})),this},d.prototype.onMouseUp=function(a){if(a.fixedPosition&&!a.removed){var u,v,x=this.layout,S=this.parentNodeLayout;S&&x.options.dragBetweenSeries&&S.nodes.forEach(function(T){a&&a.marker&&T!==a.series.parentNode&&(u=x.getDistXY(a,T),v=x.vectorLength(u)-T.marker.radius-a.marker.radius,v<0&&(T.series.addPoint(merge$A(a.options,{plotX:a.plotX,plotY:a.plotY}),!1),x.removeElementFromCollection(a,x.nodes),a.remove()))}),dragNodesMixin.onMouseUp.apply(this,arguments)}},d.prototype.placeBubbles=function(a){var u=this,v=u.checkOverlap,x=u.positionBubble,S=[],T=1,P=0,z=0,L,N,$=[],B;if(N=a.sort(function(U,j){return j[2]-U[2]}),N.length){if(S.push([[0,0,N[0][2],N[0][3],N[0][4]]]),N.length>1)for(S.push([[0,0-N[1][2]-N[0][2],N[1][2],N[1][3],N[1][4]]]),B=2;B<N.length;B++)N[B][2]=N[B][2]||1,L=x(S[T][P],S[T-1][z],N[B]),v(L,S[T][0])?(S.push([]),z=0,S[T+1].push(x(S[T][P],S[T][0],N[B])),T++,P=0):T>1&&S[T-1][z+1]&&v(L,S[T-1][z+1])?(z++,S[T].push(x(S[T][P],S[T-1][z],N[B])),P++):(P++,S[T].push(L));u.chart.stages=S,u.chart.rawPositions=[].concat.apply([],S),u.resizeRadius(),$=u.chart.rawPositions}return $},d.prototype.positionBubble=function(a,u,v){var x=Math.sqrt,S=Math.asin,T=Math.acos,P=Math.pow,z=Math.abs,L=x(P(a[0]-u[0],2)+P(a[1]-u[1],2)),N=T((P(L,2)+P(v[2]+u[2],2)-P(v[2]+a[2],2))/(2*(v[2]+u[2])*L)),$=S(z(a[0]-u[0])/L),B=a[1]-u[1]<0?0:Math.PI,U=(a[0]-u[0])*(a[1]-u[1])<0?1:-1,j=B+N+$*U,Y=Math.cos(j),q=Math.sin(j),Q=u[0]+(u[2]+v[2])*q,J=u[1]-(u[2]+v[2])*Y;return[Q,J,v[2],v[3],v[4]]},d.prototype.render=function(){var a=this,u=[];Series$a.prototype.render.apply(this,arguments),a.options.dataLabels.allowOverlap||(a.data.forEach(function(v){isArray$7(v.dataLabels)&&v.dataLabels.forEach(function(x){u.push(x)})}),a.options.useSimulation&&a.chart.hideOverlappingLabels(u))},d.prototype.resizeRadius=function(){var a=this.chart,u=a.rawPositions,v=Math.min,x=Math.max,S=a.plotLeft,T=a.plotTop,P=a.plotHeight,z=a.plotWidth,L,N,$,B,U,j,Y,q,Q;for(L=$=Number.POSITIVE_INFINITY,N=B=Number.NEGATIVE_INFINITY,Q=0;Q<u.length;Q++)U=u[Q][2],L=v(L,u[Q][0]-U),N=x(N,u[Q][0]+U),$=v($,u[Q][1]-U),B=x(B,u[Q][1]+U);if(j=[N-L,B-$],Y=[(z-S)/j[0],(P-T)/j[1]],q=v.apply([],Y),Math.abs(q-1)>1e-10){for(Q=0;Q<u.length;Q++)u[Q][2]*=q;this.placeBubbles(u)}else a.diffY=P/2+T-$-(B-$)/2,a.diffX=z/2+S-L-(N-L)/2},d.prototype.seriesBox=function(){var a=this,u=a.chart,v=a.data,x=Math.max,S=Math.min,T,P=[u.plotLeft,u.plotLeft+u.plotWidth,u.plotTop,u.plotTop+u.plotHeight];return v.forEach(function(z){defined$h(z.plotX)&&defined$h(z.plotY)&&z.marker.radius&&(T=z.marker.radius,P[0]=S(P[0],z.plotX-T),P[1]=x(P[1],z.plotX+T),P[2]=S(P[2],z.plotY-T),P[3]=x(P[3],z.plotY+T))}),isNumber$j(P.width/P.height)?P:null},d.prototype.setVisible=function(){var a=this;Series$a.prototype.setVisible.apply(a,arguments),a.parentNodeLayout&&a.graph?a.visible?(a.graph.show(),a.parentNode.dataLabel&&a.parentNode.dataLabel.show()):(a.graph.hide(),a.parentNodeLayout.removeElementFromCollection(a.parentNode,a.parentNodeLayout.nodes),a.parentNode.dataLabel&&a.parentNode.dataLabel.hide()):a.layout&&(a.visible?a.layout.addElementsToCollection(a.points,a.layout.nodes):a.points.forEach(function(u){a.layout.removeElementFromCollection(u,a.layout.nodes)}))},d.prototype.translate=function(){var a=this,u=a.chart,v=a.data,x=a.index,S,T,P,z,L=a.options.useSimulation;for(a.processedXData=a.xData,a.generatePoints(),defined$h(u.allDataPoints)||(u.allDataPoints=a.accumulateAllPoints(a),a.getPointRadius()),L?P=u.allDataPoints:(P=a.placeBubbles(u.allDataPoints),a.options.draggable=!1),z=0;z<P.length;z++)P[z][3]===x&&(S=v[P[z][4]],T=pick$F(P[z][2],void 0),L||(S.plotX=P[z][0]-u.plotLeft+u.diffX,S.plotY=P[z][1]-u.plotTop+u.diffY),isNumber$j(T)&&(S.marker=extend$C(S.marker,{radius:T,width:2*T,height:2*T}),S.radius=T));L&&a.deferLayout(),fireEvent$7(a,"afterTranslate")},d.defaultOptions=merge$A(BubbleSeries.defaultOptions,{minSize:"10%",maxSize:"50%",sizeBy:"area",zoneAxis:"y",crisp:!1,tooltip:{pointFormat:"Value: {point.value}"},draggable:!0,useSimulation:!0,parentNode:{allowPointSelect:!1},dataLabels:{formatter:function(){var a=this.series.chart.numberFormatter,u=this.point.value;return isNumber$j(u)?a(u,-1):""},parentNodeFormatter:function(){return this.name},parentNodeTextPath:{enabled:!0},padding:0,style:{transition:"opacity 2000ms"}},layoutAlgorithm:{initialPositions:"circle",initialPositionRadius:20,bubblePadding:5,parentNodeLimit:!1,seriesInteraction:!0,dragBetweenSeries:!1,parentNodeOptions:{maxIterations:400,gravitationalConstant:.03,maxSpeed:50,initialPositionRadius:100,seriesInteraction:!0,marker:{fillColor:null,fillOpacity:1,lineWidth:1,lineColor:null,symbol:"circle"}},enableSimulation:!0,type:"packedbubble",integration:"packedbubble",maxIterations:1e3,splitSeries:!1,maxSpeed:5,gravitationalConstant:.01,friction:-.981}}),d})(BubbleSeries);extend$C(PackedBubbleSeries.prototype,{alignDataLabel:Series$a.prototype.alignDataLabel,axisTypes:[],directTouch:!0,forces:["barycenter","repulsive"],hasDraggableNodes:!0,isCartesian:!1,noSharedTooltip:!0,onMouseDown:dragNodesMixin.onMouseDown,onMouseMove:dragNodesMixin.onMouseMove,pointArrayMap:["value"],pointClass:PackedBubblePoint,pointValKey:"value",redrawHalo:dragNodesMixin.redrawHalo,requireSorting:!1,searchPoint:H.noop,trackerGroups:["group","dataLabelsGroup","parentNodesGroup"]});SeriesRegistry$1.registerSeriesType("packedbubble",PackedBubbleSeries);var __extends$1M=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),noop$4=H.noop,Series$9=SeriesRegistry$1.series,_a$8=SeriesRegistry$1.seriesTypes,AreaSeries=_a$8.area,LineSeries$2=_a$8.line,ScatterSeries$2=_a$8.scatter,extend$B=Utilities.extend,merge$z=Utilities.merge,PolygonSeries=(function(g){__extends$1M(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.getGraphPath=function(){for(var a=LineSeries$2.prototype.getGraphPath.call(this),u=a.length+1;u--;)(u===a.length||a[u][0]==="M")&&u>0&&a.splice(u,0,["Z"]);return this.areaPath=a,a},d.prototype.drawGraph=function(){this.options.fillColor=this.color,AreaSeries.prototype.drawGraph.call(this)},d.defaultOptions=merge$z(ScatterSeries$2.defaultOptions,{marker:{enabled:!1,states:{hover:{enabled:!1}}},stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:""},trackByArea:!0}),d})(ScatterSeries$2);extend$B(PolygonSeries.prototype,{type:"polygon",drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:Series$9.prototype.drawTracker,setStackedPoints:noop$4});SeriesRegistry$1.registerSeriesType("polygon",PolygonSeries);var addEvent$q=Utilities.addEvent,objectEach$a=Utilities.objectEach,WaterfallAxis;(function(g){var d=(function(){function T(P){this.axis=P,this.stacks={changed:!1}}return T.prototype.renderStackTotals=function(){var P=this.axis,z=P.waterfall.stacks,L=P.stacking&&P.stacking.stackTotalGroup,N=new StackItem$1(P,P.options.stackLabels,!1,0,void 0);this.dummyStackItem=N,objectEach$a(z,function($){objectEach$a($,function(B){N.total=B.stackTotal,B.label&&(N.label=B.label),StackItem$1.prototype.render.call(N,L),B.label=N.label,delete N.label})}),N.total=null},T})();g.Composition=d;function a(T,P){addEvent$q(T,"init",S),addEvent$q(T,"afterBuildStacks",u),addEvent$q(T,"afterRender",v),addEvent$q(P,"beforeRedraw",x)}g.compose=a;function u(){var T=this,P=T.waterfall.stacks;P&&(P.changed=!1,delete P.alreadyChanged)}function v(){var T=this,P=T.options.stackLabels;P&&P.enabled&&T.waterfall.stacks&&T.waterfall.renderStackTotals()}function x(){for(var T=this.axes,P=this.series,z=P.length;z--;)P[z].options.stacking&&(T.forEach(function(L){L.isXAxis||(L.waterfall.stacks.changed=!0)}),z=0)}function S(){var T=this;T.waterfall||(T.waterfall=new d(T))}})(WaterfallAxis||(WaterfallAxis={}));const WaterfallAxis$1=WaterfallAxis;var __extends$1L=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),isNumber$i=Utilities.isNumber,WaterfallPoint=(function(g){__extends$1L(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.options=void 0,a.series=void 0,a}return d.prototype.getClassName=function(){var a=Point$4.prototype.getClassName.call(this);return this.isSum?a+=" highcharts-sum":this.isIntermediateSum&&(a+=" highcharts-intermediate-sum"),a},d.prototype.isValid=function(){return isNumber$i(this.y)||this.isSum||!!this.isIntermediateSum},d})(ColumnSeries$h.prototype.pointClass),__extends$1K=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(u,v){u.__proto__=v}||function(u,v){for(var x in v)v.hasOwnProperty(x)&&(u[x]=v[x])},g(d,a)};return function(d,a){g(d,a);function u(){this.constructor=d}d.prototype=a===null?Object.create(a):(u.prototype=a.prototype,new u)}})(),_a$7=SeriesRegistry$1.seriesTypes,ColumnSeries$8=_a$7.column,LineSeries$1=_a$7.line,arrayMax$1=Utilities.arrayMax,arrayMin$1=Utilities.arrayMin,correctFloat$2=Utilities.correctFloat,extend$A=Utilities.extend,isNumber$h=Utilities.isNumber,merge$y=Utilities.merge,objectEach$9=Utilities.objectEach,pick$E=Utilities.pick;function ownProp(g,d){return Object.hasOwnProperty.call(g,d)}var WaterfallSeries=(function(g){__extends$1K(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.chart=void 0,a.data=void 0,a.options=void 0,a.points=void 0,a.stackedYNeg=void 0,a.stackedYPos=void 0,a.stackKey=void 0,a.xData=void 0,a.yAxis=void 0,a.yData=void 0,a}return d.prototype.generatePoints=function(){var a,u,v,x;for(ColumnSeries$8.prototype.generatePoints.apply(this),v=0,u=this.points.length;v<u;v++)a=this.points[v],x=this.processedYData[v],(a.isIntermediateSum||a.isSum)&&(a.y=correctFloat$2(x))},d.prototype.translate=function(){var a=this,u=a.options,v=a.yAxis,x,S=pick$E(u.minPointLength,5),T=S/2,P=u.threshold||0,z=P,L=P,N=u.stacking,$=v.waterfall.stacks[a.stackKey],B,U,j;ColumnSeries$8.prototype.translate.apply(a);for(var Y=a.points,q=0;q<Y.length;q++){var Q=Y[q],J=a.processedYData[q],ee=Q.shapeArgs;if(!(!ee||!isNumber$h(J))){var ie=[0,J],ne=Q.y;if(N){if($){var ae=$[q];N==="overlap"?(B=ae.stackState[ae.stateIndex--],x=ne>=0?B:B-ne,ownProp(ae,"absolutePos")&&delete ae.absolutePos,ownProp(ae,"absoluteNeg")&&delete ae.absoluteNeg):(ne>=0?(B=ae.threshold+ae.posTotal,ae.posTotal-=ne,x=B):(B=ae.threshold+ae.negTotal,ae.negTotal-=ne,x=B-ne),ae.posTotal||ownProp(ae,"absolutePos")&&(ae.posTotal=ae.absolutePos,delete ae.absolutePos),ae.negTotal||ownProp(ae,"absoluteNeg")&&(ae.negTotal=ae.absoluteNeg,delete ae.absoluteNeg)),Q.isSum||(ae.connectorThreshold=ae.threshold+ae.stackTotal),v.reversed?(U=ne>=0?x-ne:x+ne,j=x):(U=x,j=x-ne),Q.below=U<=P,ee.y=v.translate(U,!1,!0,!1,!0)||0,ee.height=Math.abs(ee.y-(v.translate(j,!1,!0,!1,!0)||0));var de=v.waterfall.dummyStackItem;de&&(de.x=q,de.label=$[q].label,de.setOffset(a.pointXOffset||0,a.barW||0,a.stackedYNeg[q],a.stackedYPos[q]))}}else x=Math.max(z,z+ne)+ie[0],ee.y=v.translate(x,!1,!0,!1,!0)||0,Q.isSum?(ee.y=v.translate(ie[1],!1,!0,!1,!0)||0,ee.height=Math.min(v.translate(ie[0],!1,!0,!1,!0)||0,v.len)-ee.y,Q.below=ie[1]<=P):Q.isIntermediateSum?(ne>=0?(U=ie[1]+L,j=L):(U=L,j=ie[1]+L),v.reversed&&(U^=j,j^=U,U^=j),ee.y=v.translate(U,!1,!0,!1,!0)||0,ee.height=Math.abs(ee.y-Math.min(v.translate(j,!1,!0,!1,!0)||0,v.len)),L+=ie[1],Q.below=U<=P):(ee.height=J>0?(v.translate(z,!1,!0,!1,!0)||0)-ee.y:(v.translate(z,!1,!0,!1,!0)||0)-(v.translate(z-J,!1,!0,!1,!0)||0),z+=J,Q.below=z<P),ee.height<0&&(ee.y+=ee.height,ee.height*=-1);Q.plotY=ee.y=Math.round(ee.y||0)-a.borderWidth%2/2,ee.height=Math.max(Math.round(ee.height||0),.001),Q.yBottom=ee.y+ee.height,ee.height<=S&&!Q.isNull?(ee.height=S,ee.y-=T,Q.plotY=ee.y,Q.y<0?Q.minPointLengthOffset=-T:Q.minPointLengthOffset=T):(Q.isNull&&(ee.width=0),Q.minPointLengthOffset=0);var he=Q.plotY+(Q.negative?ee.height:0);Q.below&&(Q.plotY+=ee.height),Q.tooltipPos&&(a.chart.inverted?Q.tooltipPos[0]=v.len-he:Q.tooltipPos[1]=he)}}},d.prototype.processData=function(a){var u=this,v=u.options,x=u.yData,S=v.data,T,P=x.length,z=v.threshold||0,L,N,$,B,U,j;for(N=L=$=B=0,j=0;j<P;j++)U=x[j],T=S&&S[j]?S[j]:{},U==="sum"||T.isSum?x[j]=correctFloat$2(N):U==="intermediateSum"||T.isIntermediateSum?(x[j]=correctFloat$2(L),L=0):(N+=U,L+=U),$=Math.min(N,$),B=Math.max(N,B);g.prototype.processData.call(this,a),v.stacking||(u.dataMin=$+z,u.dataMax=B)},d.prototype.toYData=function(a){return a.isSum?"sum":a.isIntermediateSum?"intermediateSum":a.y},d.prototype.updateParallelArrays=function(a,u){g.prototype.updateParallelArrays.call(this,a,u),(this.yData[0]==="sum"||this.yData[0]==="intermediateSum")&&(this.yData[0]=null)},d.prototype.pointAttribs=function(a,u){var v=this.options.upColor,x;return v&&!a.options.color&&(a.color=a.y>0?v:null),x=ColumnSeries$8.prototype.pointAttribs.call(this,a,u),delete x.dashstyle,x},d.prototype.getGraphPath=function(){return[["M",0,0]]},d.prototype.getCrispPath=function(){var a=this.data,u=this.yAxis,v=a.length,x=Math.round(this.graph.strokeWidth())%2/2,S=Math.round(this.borderWidth)%2/2,T=this.xAxis.reversed,P=this.yAxis.reversed,z=this.options.stacking,L=[],N,$,B,U,j,Y,q,Q,J;for(J=1;J<v;J++)if(Q=a[J].shapeArgs,U=a[J-1],q=a[J-1].shapeArgs,$=u.waterfall.stacks[this.stackKey],Y=U.y>0?-q.height:0,$&&q&&Q&&(B=$[J-1],z?(N=B.connectorThreshold,j=Math.round(u.translate(N,0,1,0,1)+(P?Y:0))-x):j=q.y+U.minPointLengthOffset+S-x,L.push(["M",(q.x||0)+(T?0:q.width||0),j],["L",(Q.x||0)+(T&&Q.width||0),j])),q&&L.length&&(!z&&U.y<0&&!P||U.y>0&&P)){var ee=L[L.length-2];ee&&typeof ee[2]=="number"&&(ee[2]+=q.height||0);var ie=L[L.length-1];ie&&typeof ie[2]=="number"&&(ie[2]+=q.height||0)}return L},d.prototype.drawGraph=function(){LineSeries$1.prototype.drawGraph.call(this),this.graph.attr({d:this.getCrispPath()})},d.prototype.setStackedPoints=function(){var a=this,u=a.options,v=a.yAxis.waterfall.stacks,x=u.threshold,S=x||0,T=S,P=a.stackKey,z=a.xData,L=z.length,N,$,B,U,j,Y,q,Q,J,ee,ie,ne,ae;function de(pe,ve,be,ge){if(!Y)$.stackState[0]=pe,Y=$.stackState.length;else for(be;be<Y;be++)$.stackState[be]+=ge;$.stackState.push($.stackState[Y-1]+ve)}if(a.yAxis.stacking.usePercentage=!1,B=U=j=S,a.visible||!a.chart.options.chart.ignoreHiddenSeries){ae=v.changed,ne=v.alreadyChanged,ne&&ne.indexOf(P)<0&&(ae=!0),v[P]||(v[P]={}),N=v[P];for(var he=0;he<L;he++)ie=z[he],(!N[ie]||ae)&&(N[ie]={negTotal:0,posTotal:0,stackTotal:0,threshold:0,stateIndex:0,stackState:[],label:ae&&N[ie]?N[ie].label:void 0}),$=N[ie],ee=a.yData[he],ee>=0?$.posTotal+=ee:$.negTotal+=ee,J=u.data[he],q=$.absolutePos=$.posTotal,Q=$.absoluteNeg=$.negTotal,$.stackTotal=q+Q,Y=$.stackState.length,J&&J.isIntermediateSum?(de(j,U,0,j),j=U,U=x,S^=T,T^=S,S^=T):J&&J.isSum?(de(x,B,Y),S=x):(de(S,ee,0,B),J&&(B+=ee,U+=ee)),$.stateIndex++,$.threshold=S,S+=$.stackTotal;v.changed=!1,v.alreadyChanged||(v.alreadyChanged=[]),v.alreadyChanged.push(P)}},d.prototype.getExtremes=function(){var a=this.options.stacking,u,v,x,S;return a?(u=this.yAxis,v=u.waterfall.stacks,x=this.stackedYNeg=[],S=this.stackedYPos=[],a==="overlap"?objectEach$9(v[this.stackKey],function(T){x.push(arrayMin$1(T.stackState)),S.push(arrayMax$1(T.stackState))}):objectEach$9(v[this.stackKey],function(T){x.push(T.negTotal+T.threshold),S.push(T.posTotal+T.threshold)}),{dataMin:arrayMin$1(x),dataMax:arrayMax$1(S)}):{dataMin:this.dataMin,dataMax:this.dataMax}},d.defaultOptions=merge$y(ColumnSeries$8.defaultOptions,{dataLabels:{inside:!0},lineWidth:1,lineColor:palette.neutralColor80,dashStyle:"Dot",borderColor:palette.neutralColor80,states:{hover:{lineWidthPlus:0}}}),d})(ColumnSeries$8);extend$A(WaterfallSeries.prototype,{getZonesGraphs:LineSeries$1.prototype.getZonesGraphs,pointValKey:"y",showLine:!0,pointClass:WaterfallPoint});SeriesRegistry$1.registerSeriesType("waterfall",WaterfallSeries);WaterfallAxis$1.compose(Axis,Chart$1);var animObject$3=animationExports.animObject,seriesTypes$4=SeriesRegistry$1.seriesTypes,addEvent$p=Utilities.addEvent,defined$g=Utilities.defined,find$6=Utilities.find,isNumber$g=Utilities.isNumber,pick$D=Utilities.pick,splat$5=Utilities.splat,uniqueKey$1=Utilities.uniqueKey,wrap$a=Utilities.wrap,seriesProto=Series$f.prototype,pointerProto=Pointer.prototype,columnProto$2,arearangeProto;seriesProto.searchPointByAngle=function(g){var d=this,a=d.chart,u=d.xAxis,v=u.pane.center,x=g.chartX-v[0]-a.plotLeft,S=g.chartY-v[1]-a.plotTop;return this.searchKDTree({clientX:180+Math.atan2(x,S)*(-180/Math.PI)})};seriesProto.getConnectors=function(g,d,a,u){var v,x,S,T,P,z,L,N,$,B,U,j,Y=1.5,q=Y+1,Q,J,ee,ie,ne,ae,de,he,pe,ve=u?1:0;return d>=0&&d<=g.length-1?v=d:d<0?v=g.length-1+d:v=0,x=v-1<0?g.length-(1+ve):v-1,S=v+1>g.length-1?ve:v+1,T=g[x],P=g[S],z=T.plotX,L=T.plotY,N=P.plotX,$=P.plotY,B=g[v].plotX,U=g[v].plotY,Q=(Y*B+z)/q,J=(Y*U+L)/q,ee=(Y*B+N)/q,ie=(Y*U+$)/q,ne=Math.sqrt(Math.pow(Q-B,2)+Math.pow(J-U,2)),ae=Math.sqrt(Math.pow(ee-B,2)+Math.pow(ie-U,2)),de=Math.atan2(J-U,Q-B),he=Math.atan2(ie-U,ee-B),pe=Math.PI/2+(de+he)/2,Math.abs(de-pe)>Math.PI/2&&(pe-=Math.PI),Q=B+Math.cos(pe)*ne,J=U+Math.sin(pe)*ne,ee=B+Math.cos(Math.PI+pe)*ae,ie=U+Math.sin(Math.PI+pe)*ae,j={rightContX:ee,rightContY:ie,leftContX:Q,leftContY:J,plotX:B,plotY:U},a&&(j.prevPointCont=this.getConnectors(g,x,!1,u)),j};seriesProto.toXY=function(g){var d=this.chart,a=this.xAxis,u=this.yAxis,v=g.plotX,x=g.plotY,S=g.series,T=d.inverted,P=g.y,z=T?v:u.len-x,L;if(T&&S&&!S.isRadialBar&&(g.plotY=x=typeof P=="number"&&u.translate(P)||0),g.rectPlotX=v,g.rectPlotY=x,u.center&&(z+=u.center[3]/2),isNumber$g(x)){var N=T?u.postTranslate(x,z):a.postTranslate(v,z);g.plotX=g.polarPlotX=N.x-d.plotLeft,g.plotY=g.polarPlotY=N.y-d.plotTop}this.kdByAngle?(L=(v/Math.PI*180+a.pane.options.startAngle)%360,L<0&&(L+=360),g.clientX=L):g.clientX=g.plotX};seriesTypes$4.spline&&(wrap$a(seriesTypes$4.spline.prototype,"getPointSpline",function(g,d,a,u){var v,x;if(this.chart.polar)if(!u)v=["M",a.plotX,a.plotY];else{x=this.getConnectors(d,u,!0,this.connectEnds);var S=x.prevPointCont&&x.prevPointCont.rightContX,T=x.prevPointCont&&x.prevPointCont.rightContY;v=["C",isNumber$g(S)?S:x.plotX,isNumber$g(T)?T:x.plotY,isNumber$g(x.leftContX)?x.leftContX:x.plotX,isNumber$g(x.leftContY)?x.leftContY:x.plotY,x.plotX,x.plotY]}else v=g.call(this,d,a,u);return v}),seriesTypes$4.areasplinerange&&(seriesTypes$4.areasplinerange.prototype.getPointSpline=seriesTypes$4.spline.prototype.getPointSpline));addEvent$p(Series$f,"afterTranslate",function(){var g=this,d=g.chart;if(d.polar&&g.xAxis){if(g.kdByAngle=d.tooltip&&d.tooltip.shared,g.kdByAngle?g.searchPoint=g.searchPointByAngle:g.options.findNearestPointBy="xy",!g.preventPostTranslate)for(var a=g.points,u=a.length;u--;)g.toXY(a[u]),!d.hasParallelCoordinates&&!g.yAxis.reversed&&a[u].y<g.yAxis.min&&(a[u].isNull=!0);this.hasClipCircleSetter||(this.hasClipCircleSetter=!!g.eventsToUnbind.push(addEvent$p(g,"afterRender",function(){var v;d.polar&&(v=this.yAxis.pane.center,this.clipCircle?this.clipCircle.animate({x:v[0],y:v[1],r:v[2]/2,innerR:v[3]/2}):this.clipCircle=d.renderer.clipCircle(v[0],v[1],v[2]/2,v[3]/2),this.group.clip(this.clipCircle),this.setClip=H.noop)})))}},{order:2});wrap$a(seriesTypes$4.line.prototype,"getGraphPath",function(g,d){var a=this,u,v,x;if(this.chart.polar){for(d=d||this.points,u=0;u<d.length;u++)if(!d[u].isNull){v=u;break}this.options.connectEnds!==!1&&typeof v<"u"&&(this.connectEnds=!0,d.splice(d.length,0,d[v]),x=!0),d.forEach(function(T){typeof T.polarPlotY>"u"&&a.toXY(T)})}var S=g.apply(this,[].slice.call(arguments,1));return x&&d.pop(),S});var polarAnimate=function(g,d){var a=this,u=this.chart,v=this.options.animation,x=this.group,S=this.markerGroup,T=this.xAxis.center,P=u.plotLeft,z=u.plotTop,L,N,$,B,U,j;u.polar?a.isRadialBar?d||(a.startAngleRad=pick$D(a.translatedThreshold,a.xAxis.startAngleRad),H.seriesTypes.pie.prototype.animate.call(a,d)):u.renderer.isSVG&&(v=animObject$3(v),a.is("column")?d||(N=T[3]/2,a.points.forEach(function(Y){$=Y.graphic,B=Y.shapeArgs,U=B&&B.r,j=B&&B.innerR,$&&B&&($.attr({r:N,innerR:N}),$.animate({r:U,innerR:j},a.options.animation))})):d?(L={translateX:T[0]+P,translateY:T[1]+z,scaleX:.001,scaleY:.001},x.attr(L),S&&S.attr(L)):(L={translateX:P,translateY:z,scaleX:1,scaleY:1},x.animate(L,v),S&&S.animate(L,v))):g.call(this,d)};wrap$a(seriesProto,"animate",polarAnimate);seriesTypes$4.column&&(arearangeProto=seriesTypes$4.arearange.prototype,columnProto$2=seriesTypes$4.column.prototype,columnProto$2.polarArc=function(g,d,a,u){var v=this.xAxis.center,x=this.yAxis.len,S=v[3]/2,T=x-d+S,P=x-pick$D(g,x)+S;return this.yAxis.reversed&&(T<0&&(T=S),P<0&&(P=S)),{x:v[0],y:v[1],r:T,innerR:P,start:a,end:u}},wrap$a(columnProto$2,"animate",polarAnimate),wrap$a(columnProto$2,"translate",function(g){var d=this,a=d.options,u=a.threshold,v=a.stacking,x=d.chart,S=d.xAxis,T=d.yAxis,P=T.reversed,z=T.center,L=S.startAngleRad,N=S.endAngleRad,$=N-L,B,U,j,Y,q,Q,J,ee,ie,ne,ae,de,he,pe,ve,be;if(d.preventPostTranslate=!0,g.call(d),S.isRadial)for(U=d.points,Y=U.length,q=T.translate(T.min),Q=T.translate(T.max),u=a.threshold||0,x.inverted&&isNumber$g(u)&&(B=T.translate(u),defined$g(B)&&(B<0?B=0:B>$&&(B=$),d.translatedThreshold=B+L));Y--;)j=U[Y],pe=j.barX,ne=j.x,ae=j.y,j.shapeType="arc",x.inverted?(j.plotY=T.translate(ae),v&&T.stacking?(he=T.stacking.stacks[(ae<0?"-":"")+d.stackKey],d.visible&&he&&he[ne]&&(j.isNull||(de=he[ne].points[d.getStackIndicator(void 0,ne,d.index).key],J=T.translate(de[0]),ee=T.translate(de[1]),defined$g(J)&&(J=Utilities.clamp(J,0,$))))):(J=B,ee=j.plotY),J>ee&&(ee=[J,J=ee][0]),P?ee>q?ee=q:J<Q?J=Q:(J>q||ee<Q)&&(J=ee=$):J<q?J=q:ee>Q?ee=Q:(ee<q||J>Q)&&(J=ee=0),T.min>T.max&&(J=ee=P?$:0),J+=L,ee+=L,z&&(j.barX=pe+=z[3]/2),ve=Math.max(pe,0),be=Math.max(pe+j.pointWidth,0),j.shapeArgs={x:z&&z[0],y:z&&z[1],r:be,innerR:ve,start:J,end:ee},j.opacity=J===ee?0:void 0,j.plotY=(defined$g(d.translatedThreshold)&&(J<d.translatedThreshold?J:ee))-L):(J=pe+L,j.shapeArgs=d.polarArc(j.yBottom,j.plotY,J,J+j.pointWidth)),d.toXY(j),x.inverted?(ie=T.postTranslate(j.rectPlotY,pe+j.pointWidth/2),j.tooltipPos=[ie.x-x.plotLeft,ie.y-x.plotTop]):j.tooltipPos=[j.plotX,j.plotY],z&&(j.ttBelow=j.plotY>z[1])}),columnProto$2.findAlignments=function(g,d){var a,u;return d.align===null&&(g>20&&g<160?a="left":g>200&&g<340?a="right":a="center",d.align=a),d.verticalAlign===null&&(g<45||g>315?u="bottom":g>135&&g<225?u="top":u="middle",d.verticalAlign=u),d},arearangeProto&&(arearangeProto.findAlignments=columnProto$2.findAlignments),wrap$a(columnProto$2,"alignDataLabel",function(g,d,a,u,v,x){var S=this.chart,T=pick$D(u.inside,!!this.options.stacking),P,z,L;S.polar?(P=d.rectPlotX/Math.PI*180,S.inverted?(this.forceDL=S.isInsidePlot(d.plotX,Math.round(d.plotY)),T&&d.shapeArgs?(z=d.shapeArgs,L=this.yAxis.postTranslate(((z.start||0)+(z.end||0))/2-this.xAxis.startAngleRad,d.barX+d.pointWidth/2),v={x:L.x-S.plotLeft,y:L.y-S.plotTop}):d.tooltipPos&&(v={x:d.tooltipPos[0],y:d.tooltipPos[1]}),u.align=pick$D(u.align,"center"),u.verticalAlign=pick$D(u.verticalAlign,"middle")):this.findAlignments&&(u=this.findAlignments(P,u)),seriesProto.alignDataLabel.call(this,d,a,u,v,x),this.isRadialBar&&d.shapeArgs&&d.shapeArgs.start===d.shapeArgs.end&&a.hide(!0)):g.call(this,d,a,u,v,x)}));wrap$a(pointerProto,"getCoordinates",function(g,d){var a=this.chart,u={xAxis:[],yAxis:[]};return a.polar?a.axes.forEach(function(v){var x=v.isXAxis,S=v.center,T,P;v.coll!=="colorAxis"&&(T=d.chartX-S[0]-a.plotLeft,P=d.chartY-S[1]-a.plotTop,u[x?"xAxis":"yAxis"].push({axis:v,value:v.translate(x?Math.PI-Math.atan2(T,P):Math.sqrt(Math.pow(T,2)+Math.pow(P,2)),!0)}))}):u=g.call(this,d),u});SVGRenderer.prototype.clipCircle=function(g,d,a,u){var v,x=uniqueKey$1(),S=this.createElement("clipPath").attr({id:x}).add(this.defs);return v=u?this.arc(g,d,a,u,0,2*Math.PI).add(S):this.circle(g,d,a).add(S),v.id=x,v.clipPath=S,v};addEvent$p(Chart$1,"getAxes",function(){this.pane||(this.pane=[]),this.options.pane=splat$5(this.options.pane),this.options.pane.forEach(function(g){new Pane$1(g,this)},this)});addEvent$p(Chart$1,"afterDrawChartBox",function(){this.pane.forEach(function(g){g.render()})});addEvent$p(Series$f,"afterInit",function(){var g=this.chart;g.inverted&&g.polar&&(this.isRadialSeries=!0,this.is("column")&&(this.isRadialBar=!0))});wrap$a(Chart$1.prototype,"get",function(g,d){return find$6(this.pane||[],function(a){return a.options.id===d})||g.call(this,d)});/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts-more
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$5=H;RadialAxis$1.compose(G$5.Axis,G$5.Tick);BubbleSeries$2.compose(G$5.Chart,G$5.Legend,G$5.Series);var pick$C=Utilities.pick,deg2rad$4=H.deg2rad;function rotate3D(g,d,a,u){return{x:u.cosB*g-u.sinB*a,y:-u.sinA*u.sinB*g+u.cosA*d-u.cosB*u.sinA*a,z:u.cosA*u.sinB*g+u.sinA*d+u.cosA*u.cosB*a}}function perspective3D$1(g,d,a){var u=a>0&&a<Number.POSITIVE_INFINITY?a/(g.z+d.z+a):1;return{x:g.x*u,y:g.y*u}}H.perspective3D=perspective3D$1;function perspective$6(g,d,a,u){var